(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     25965,        680]
NotebookOptionsPosition[     25326,        653]
NotebookOutlinePosition[     25669,        668]
CellTagsIndexPosition[     25626,        665]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9},
 FontFamily->"Arial"],

Cell[TextData[{
 StyleBox["Linear Maps and the Action Ellipse",
  FontWeight->"Bold"],
 "\n\nLinear combinations are also written in ",
 StyleBox["matrix form",
  FontSlant->"Italic"],
 ":\n\n\t",
 StyleBox["c",
  FontWeight->"Bold"],
 " = s",
 StyleBox["a",
  FontWeight->"Bold"],
 " + t",
 StyleBox["b",
  FontWeight->"Bold"],
 " = s",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", GridBox[{
      {"v"},
      {"w"}
     }], ")"}], TraditionalForm]]],
 " + t",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", GridBox[{
      {"x"},
      {"y"}
     }], ")"}], TraditionalForm]]],
 " = ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", GridBox[{
      {
       RowBox[{"sv", " ", "+", " ", "tx"}]},
      {
       RowBox[{"sw", "+", "ty"}]}
     }], ")"}], TraditionalForm]]],
 "\n\t\t=",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", GridBox[{
      {"v", "x"},
      {"w", "y"}
     }], ")"}], TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   RowBox[{"(", GridBox[{
      {"s"},
      {"t"}
     }], ")"}], TraditionalForm]]],
 "\n\t\t\nwhere ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", GridBox[{
      {"v", "x"},
      {"w", "y"}
     }], ")"}], TraditionalForm]]],
 " is a ",
 StyleBox["matrix",
  FontSlant->"Italic"],
 " M, and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", GridBox[{
      {"s"},
      {"t"}
     }], ")"}], TraditionalForm]]],
 " is a vector ",
 StyleBox["v",
  FontWeight->"Bold"],
 ", abbreviated:\n\n\t\t",
 StyleBox["c ",
  FontWeight->"Bold"],
 "= M",
 StyleBox["v.\n\t\t\n",
  FontWeight->"Bold"],
 "The action of M is called a ",
 StyleBox["linear map. ",
  FontSlant->"Italic"],
 "Notationally",
 StyleBox[",  w",
  FontSlant->"Italic"],
 "e do",
 StyleBox[" ",
  FontSlant->"Italic"],
 "not distiguish between a matrix and the corresponding linear map",
 StyleBox[". \n\n",
  FontSlant->"Italic"],
 "Examples:",
 StyleBox["\n",
  FontSlant->"Italic"],
 "If x=w=0, M is a ",
 StyleBox["scaling",
  FontSlant->"Italic"],
 " matrix.\n\n If \n\n\tM=",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", GridBox[{
      {
       RowBox[{"cos", " ", "\[Alpha]"}], 
       RowBox[{
        RowBox[{"-", "sin"}], " ", "\[Alpha]"}]},
      {
       RowBox[{"sin", " ", "\[Alpha]"}], 
       RowBox[{"cos", " ", "\[Alpha]"}]}
     }], ")"}], TraditionalForm]]],
 ",\n\t\nM defines a ",
 StyleBox["rotation",
  FontSlant->"Italic"],
 " by \[Alpha].\n\nIn the following cell, an input vector ",
 StyleBox["a",
  FontWeight->"Bold"],
 " is in green, its image ",
 StyleBox["b",
  FontWeight->"Bold"],
 " under the matrix mat is in red. The vector ",
 StyleBox["a",
  FontWeight->"Bold"],
 " traces out a circle, and ",
 StyleBox["b",
  FontWeight->"Bold"],
 " traces out an ellipse -- the action ellipse.\n"
}], "Subsubtitle",
 CellChangeTimes->{{3.5190605704177775`*^9, 3.519060578092991*^9}, {
   3.5190606755931625`*^9, 3.5190606801327705`*^9}, {3.5190608203926163`*^9, 
   3.5190608745559115`*^9}, {3.519060915412383*^9, 3.5190610274049797`*^9}, {
   3.519061174669239*^9, 3.5190613186574917`*^9}, 3.519143837518166*^9, {
   3.5191440108968706`*^9, 3.5191440842949996`*^9}, {3.5191441776923637`*^9, 
   3.519144178940366*^9}, 3.5191443457826586`*^9, {3.519144902064036*^9, 
   3.5191449079140463`*^9}, {3.5191568024721313`*^9, 
   3.5191568026437316`*^9}, {3.519407947973127*^9, 3.5194079501571302`*^9}, {
   3.5198551456939306`*^9, 3.5198551992644243`*^9}, 3.5198554847605257`*^9, {
   3.5206885387440853`*^9, 3.52068856435933*^9}, {3.5206886364470572`*^9, 
   3.5206886585990963`*^9}, {3.584796372919403*^9, 3.5847963745194054`*^9}, {
   3.5847975359610314`*^9, 3.5847975391210356`*^9}, {3.584800993114422*^9, 
   3.5848010569045115`*^9}},
 FontFamily->"Arial",
 FontSize->18,
 FontColor->GrayLevel[0]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"matrix", " ", 
    RowBox[{"options", ":", " ", 
     RowBox[{"load", " ", "one", " ", "into", " ", "mat"}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"mat1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        StyleBox[
         RowBox[{"3", ",", "1"}],
         FontColor->GrayLevel[0]], 
        StyleBox["}",
         FontColor->GrayLevel[0]]}], 
       StyleBox[",",
        FontColor->GrayLevel[0]], 
       StyleBox[
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}],
        FontColor->GrayLevel[0]]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"angle", " ", "=", " ", 
     RowBox[{"Pi", "/", "4"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", "angle", "]"}], ",", 
         RowBox[{"-", 
          RowBox[{"Sin", "[", "angle", "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Sin", "[", "angle", "]"}], ",", 
         RowBox[{"Cos", "[", "angle", "]"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat4", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat5", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat", " ", "=", " ", "mat1"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"a", " ", "is", " ", "in", " ", "green"}], ",", " ", 
     RowBox[{"tracing", " ", "out", " ", "a", " ", "circle"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"b", " ", "is", " ", "in", " ", "red"}], ",", " ", 
     RowBox[{
     "tracing", " ", "out", " ", "the", " ", "action", " ", "ellipse"}]}], 
    " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", "s", "]"}], ",", 
         RowBox[{"Sin", "[", "s", "]"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"b", " ", "=", " ", 
       RowBox[{"mat", ".", "a"}]}], ";", "  ", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"arrowa", "=", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", 
         RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", "a"}], "}"}], "]"}]}], 
        "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"arrowb", "=", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", 
         RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", "b"}], "}"}], "]"}]}], 
        "}"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Green", ",", "arrowa", ",", 
          RowBox[{"Circle", "[", "]"}], ",", "Red", ",", "arrowb"}], "}"}], 
        ",", 
        RowBox[{"Axes", "\[Rule]", "True"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"MatrixForm", "[", "mat", "]"}], ",", "15"}], "]"}]}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}]}], "]"}]}], ",",
      "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", "0", ",", "\"\<Green vector selection\>\""}], "}"}],
        ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\< \>\"", ",", "\"\< \>\"", ",", 
        "\"\<red vector = matrix * green vector\>\"", ",", "\"\< \>\""}], 
       "}"}]}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.584801133484618*^9, 3.5848013877649746`*^9}, {
  3.584801430295034*^9, 3.5848014986851296`*^9}, {3.5848015601952157`*^9, 
  3.584801591185259*^9}, {3.5848016926154013`*^9, 3.5848017756855173`*^9}, {
  3.5848019099457054`*^9, 3.5848019323457365`*^9}, {3.5848020701459293`*^9, 
  3.584802107405982*^9}, {3.584802149736041*^9, 3.5848021925061007`*^9}, {
  3.5848022429261713`*^9, 3.5848022748962164`*^9}, {3.5848025443565936`*^9, 
  3.5848025656766233`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`s$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`s$$], 0, "Green vector selection"}, 0, 2 Pi}}, 
    Typeset`size$$ = {360., {139., 145.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`s$83218$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`s$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`s$$, $CellContext`s$83218$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ($CellContext`a = {
          Cos[$CellContext`s$$], 
          Sin[$CellContext`s$$]}; $CellContext`b = 
        Dot[$CellContext`mat, $CellContext`a]; $CellContext`arrowa = {Thick, 
          Arrowheads[Large], 
          Arrow[{{0, 0}, $CellContext`a}]}; $CellContext`arrowb = {Thick, 
          Arrowheads[Large], 
          Arrow[{{0, 0}, $CellContext`b}]}; 
       Graphics[{Green, $CellContext`arrowa, 
          Circle[], Red, $CellContext`arrowb}, Axes -> True, PlotLabel -> 
         Style[
           MatrixForm[$CellContext`mat], 15], 
         PlotRange -> {{-3, 3}, {-2, 2}}]), 
      "Specifications" :> {{{$CellContext`s$$, 0, "Green vector selection"}, 
         0, 2 Pi}}, 
      "Options" :> {
       FrameLabel -> {" ", " ", "red vector = matrix * green vector", " "}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{433., {205., 210.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.584801717985437*^9, 3.5848017315554557`*^9}, 
   3.584801776805519*^9, 3.5848019334057384`*^9, {3.58480209862597*^9, 
   3.5848021929861016`*^9}, 3.5848022574661922`*^9, {3.5848025484765997`*^9, 
   3.5848025704366302`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
All matrices map circles to ellipses.
In the following cell, the original data are green and the mapped data \
(images) are red. 
Original points and corresponding image points are connected by straight \
lines. 
This is a static version of the previous cell.\
\>", "Subsubtitle",
 CellChangeTimes->{{3.5848024497264614`*^9, 3.584802483776509*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"circpoints", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", "t", "]"}], ",", 
       RowBox[{"Sin", "[", "t", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", " ", "Pi"}], ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ellpoints", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"mat", ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Cos", "[", "t", "]"}], ",", 
        RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"pplot", "=", 
    RowBox[{"Graphics", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"PointSize", "[", "Large", "]"}], ",", "Green", ",", 
       RowBox[{"Point", "[", "circpoints", "]"}], ",", "Red", ",", " ", 
       RowBox[{"Point", "[", "ellpoints", "]"}]}], "}"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"line", "[", "t_", "]"}], ":=", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Line", "[", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"mat", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Cos", "[", "t", "]"}], ",", 
          RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", "t", "]"}], ",", 
         RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], "}"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lineplot", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"line", "[", "t", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{"lineplot", ",", "pplot"}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.584802516766555*^9, 3.5848025234765644`*^9}}],

Cell[BoxData[
 GraphicsBox[{LineBox[{{3., 1.}, {1., 0.}}], 
   LineBox[{{3.0848459124809056`, 1.1946709985716821`}, {0.9950041652780258, 
    0.09983341664682815}}], 
   LineBox[{{3.1388690643187864`, 1.377405239431364}, {0.9800665778412416, 
    0.19866933079506122`}}], 
   LineBox[{{3.1615296740381575`, 1.5463769024482852`}, {0.955336489125606, 
    0.2955202066613396}}], 
   LineBox[{{3.1526013243173057`, 1.6998976786201863`}, {0.9210609940028851, 
    0.3894183423086505}}], 
   LineBox[{{3.1121732242753213`, 1.8364336390987788`}, {0.8775825618903728, 
    0.479425538604203}}], 
   LineBox[{{3.0406493181240704`, 1.9546205616997492`}, {0.8253356149096782, 
    0.5646424733950355}}], 
   LineBox[{{2.9387442490911564`, 2.0532775617598706`}, {0.7648421872844884, 
    0.6442176872376911}}], 
   LineBox[{{2.807476218941019, 2.131418891146211}, {0.6967067093471654, 
    0.7173560908995228}}], 
   LineBox[{{2.6481568144394765`, 2.1882637875256314`}, {0.6216099682706644, 
    0.7833269096274834}}], 
   LineBox[{{2.4623779024123156`, 2.2232442754839328`}, {0.5403023058681397, 
    0.8414709848078965}}], 
   LineBox[{{2.251995724338167, 2.236010841548448}, {0.4535961214255773, 
    0.8912073600614354}}], 
   LineBox[{{2.0191123493972465`, 2.226435926411126}, {0.3623577544766734, 
    0.9320390859672264}}], 
   LineBox[{{1.7660546712909548`, 2.194615199458973}, {0.26749882862458735`, 
    0.963558185417193}}], 
   LineBox[{{1.4953511586891826`, 2.1408666028771615`}, {0.16996714290024081`,
     0.9854497299884603}}], 
   LineBox[{{1.2097065916071632`, 2.065727174875812}, {0.0707372016677029, 
    0.9974949866040544}}], 
   LineBox[{{0.9119750361376386, 
    1.9699476837817214`}, {-0.029199522301288815`, 0.9995736030415051}}], 
   LineBox[{{0.605131327565894, 1.8544851266094122`}, {-0.12884449429552486`, 
    0.9916648104524686}}], 
   LineBox[{{0.29224134679893377`, 1.7204931670633032`}, {-0.2272020946930871,
     0.9738476308781951}}], 
   LineBox[{{-0.023568612903096198`, 
    1.5693106085113253`}, {-0.3232895668635036, 0.9463000876874145}}], 
   LineBox[{{-0.33914308281574557`, 1.402448017104221}, {-0.4161468365471424, 
    0.9092974268256817}}], 
   LineBox[{{-0.651328947150699, 1.2215726286978899`}, {-0.5048461045998576, 
    0.8632093666488737}}], 
   LineBox[{{-0.9570069479464474, 1.0284916903838344`}, {-0.5885011172553458, 
    0.8084964038195901}}], 
   LineBox[{{-1.2531228516627533`, 0.8251344030736156}, {-0.6662760212798244, 
    0.74570521217672}}], 
   LineBox[{{-1.5367179660725867`, 0.6135326455610555}, {-0.7373937155412458, 
    0.6754631805511506}}], 
   LineBox[{{-1.8049587025368448`, 0.3958006726609794}, {-0.8011436155469337, 
    0.5984721441039565}}], 
   LineBox[{{-2.0551648882853777`, 0.174113990273981}, {-0.8568887533689473, 
    0.5155013718214642}}], 
   LineBox[{{-2.2848365458173534`, -0.04931238154940165}, \
{-0.9040721420170612, 0.4273798802338298}}], 
   LineBox[{{-2.49167887185007, -0.27224604035684896`}, {-0.9422223406686583, 
    0.33498815015590466`}}], 
   LineBox[{{-2.6736251662347903`, -0.4924595067216267}, {-0.9709581651495907,
     0.23924932921398198`}}], 
   LineBox[{{-2.828857481741469, -0.7077524804807109}, {-0.9899924966004454, 
    0.1411200080598672}}], 
   LineBox[{{-2.955824788386548, -0.9159738254066985}, {-0.9991351502732795, 
    0.04158066243329049}}], 
   LineBox[{{-3.0532584708118393`, -1.1150430626499133`}, \
{-0.9982947757947531, -0.058374143427580086`}}], 
   LineBox[{{-3.120185003869843, -1.3029711581953622`}, {-0.9874797699088649, \
-0.15774569414324865`}}], 
   LineBox[{{-3.1559356797652143`, -1.4778803966331242`}, \
{-0.9667981925794609, -0.25554110202683167`}}], 
   LineBox[{{-3.160153289562009, -1.638023142670036}, {-0.9364566872907963, \
-0.35078322768961984`}}], 
   LineBox[{{-3.1327956922972935`, -1.781799302923852}, {-0.896758416334147, \
-0.44252044329485246`}}], 
   LineBox[{{-3.0741362360397173`, -1.9077723135273947`}, \
{-0.848100031710408, -0.5298361409084934}}], 
   LineBox[{{-2.9847610266859688`, -2.014683493799855}, {-0.7909677119144165, \
-0.6118578909427193}}], 
   LineBox[{{-2.8655630717843934`, -2.101464622568088}, {-0.7259323042001399, \
-0.6877661591839741}}], 
   LineBox[{{-2.717733357898764, -2.1672486114794682`}, {-0.6536436208636119, \
-0.7568024953079282}}], 
   LineBox[{{-2.5427489506642162`, -2.2113781686620904`}, \
{-0.5748239465332685, -0.8182771110644108}}], 
   LineBox[{{-2.3423582364356865`, -2.233412366167876}, {-0.4902608213406994, \
-0.8715757724135882}}], 
   LineBox[{{-2.118563452989381, -2.2331310455788853`}, \
{-0.40079917207997545`, -0.9161659367494549}}], 
   LineBox[{{-1.8736006838247743`, -2.2105370177574515`}, \
{-0.30733286997841935`, -0.9516020738895161}}], 
   LineBox[{{-1.6099175159574362`, -2.165856034760974}, {-0.2107957994307797, \
-0.977530117665097}}], 
   LineBox[{{-1.3301485844386265`, -2.099534534201983}, \
{-0.11215252693505398`, -0.9936910036334645}}], 
   LineBox[{{-1.0370892479527725`, -2.012235178591092}, \
{-0.01238866346289056, -0.9999232575641008}}], 
   LineBox[{{-0.7336676585174988, -1.9048302342322339`}, {
    0.08749898343944727, -0.9961646088358406}}], 
   LineBox[{{-0.4229155043566052, -1.7783928558260893`}, {
    0.18651236942257576`, -0.9824526126243325}}], 
   LineBox[{{-0.10793771827345966`, -1.6341863638630507`}, {
    0.28366218546322625`, -0.9589242746631385}}], 
   LineBox[{{0.20811854581121103`, -1.4736516219424831`}, {
    0.37797774271298107`, -0.9258146823277321}}], 
   LineBox[{{0.5220953581809781, -1.2983926401399293`}, {
    0.4685166713003771, -0.8834546557201531}}], 
   LineBox[{{0.8308555663135838, -1.11016054826864}, {
    0.5543743361791615, -0.8322674422239008}}], 
   LineBox[{{1.131314140271917, -0.9108360991693396}, {
    0.6346928759426347, -0.7727644875559871}}], 
   LineBox[{{1.420468997303388, -0.7024108768495239}, {
    0.70866977429126, -0.7055403255703919}}], 
   LineBox[{{1.6954309976584296`, -0.48696739723439153`}, {
    0.7755658785102502, -0.6312666378723208}}], 
   LineBox[{{1.953452811919842, -0.2666583003561154}, {
    0.8347127848391598, -0.5506855425976376}}], 
   LineBox[{{2.1919563714102015`, -0.043684841886193815`}, {
    0.8855195169413194, -0.4646021794137566}}], 
   LineBox[{{2.408558627401872, 0.17972510108356388`}, {
    0.9274784307440359, -0.373876664830236}}], 
   LineBox[{{2.601095361752172, 0.40133929025251425`}, {
    0.960170286650366, -0.27941549819892586`}}], 
   LineBox[{{2.767642811055659, 0.6189434298983947}, {
    0.9832684384425847, -0.18216250427209502`}}], 
   LineBox[{{2.906536888252156, 0.8303632913882247}, {
    0.9965420970232175, -0.0830894028174964}}], 
   {RGBColor[0, 1, 0], PointSize[Large], PointBox[CompressedData["
1:eJw1hgsw2wccgI1iVOfRlpXi5t1WvO9iVH/UqOLqWW+zmbZDVaauJqOrjZ6x
2s5U0/WMpivWzqMETTx+6LIUY+IVFo8gJPL6pz2pOq623W7f3Xff915qduQF
dTU1NfjHf/sfSvj/Bkwat414BDiOlI80VzCBmpp3m5FEQM+Ej/Ve1hCwdJyn
zCsV4MFi3R7dmIDXdL4oOl8OmZdObHjJZiG8MFHL4bAMlJohueLmRTiUGHTS
Ll0CCX4PTW4ZrkBlTW1kdb4YmEcC06/UCOEC7bPFzJB1GH2Dg1Wb63B0pbLa
S7gKfo3JNA3DDSjX6tB3CF4GhZ7Od9FyCRh+zNF6qr0Anp+QQtnFMhjP965a
dOEB+7wp3X9SDimhxz9tt+BCiAV7O29aARqxB3u+GGCDxvIHS6OlBDRss8Om
zdqgPMvxHlVKgLtxCpu6XoPs0wJO0S4BFZfpm9uF/dhJc+Z1dRNAfcc2THVo
FJWHe4sGjxHQEuDB/L11CmM9TS1NghSgmRMVa0f/CwMZXMmrd+Uw/BNtX7u9
AHdypJBeKwVKU2mI2vQKvs17NOe+tAFCZxcTq8g1tHKOI3HnRVDK/Z7BoomQ
xn2mSqtZg8LyEmKLvoFPhv880GK3CpTNG6/uZ0qxu6Sue/e6AOo1LrY7KGSo
12Bj45rAh1BKbF6LnQL715KtcyjTMOz7gG9sROCkS9DM09oxmFgr6dvXTGDi
dGeWp8Eg2NTHnJG8JtDJgPaVfvBD6Bxhrmi/JNCNJH6fvNqEnfsbHLPvEnhH
r2tY3fU3VO/78Jm6UoG5oXsGQwnjmGI6oJG7JUfLVNZ176szGO84wTjVJsMX
XKW/X+Q8kucKm+jWUvQzc5JlbApQ3Mgvvhe2gXX9sr2YqlUUPfdInfES4Vi7
JclJfR0HbPha9RIhNlvMLzDJYkwjZbio0law9/kKNcpZguacMtmVj5Zw1mh8
6eWqFKO8jSuf1M+hbdlbXt4Rcnw0mFoQ+3gSlQ4BrjevKjDDJy46cWcYb/hy
fORnCCy7FX9Cu7MHWbLkgxF/EOiREe7vlfINRsrI+il7BH7pey7u/MVO2PPR
+7FKQGCacYH9gyUO/Cy1uuZLIXAuOJNSYj8B7ncFqqIWBT5OElYMucwC02r2
aGCdHBUZ5HjS7gLwbFhtpwNkOO+WC9m9y0A26okm7kvw21bb7EthQqBout0p
YIkxaEr75OWmdYht1T039MM6Fut+XZrNFQNDVW0S4y7E428OVG91SKCOQz1L
rl1G+5wGLVKMDIaXKji6PQt4LHz7lKhJDma9+9Noch6qrD7X6WIqoJ/eWvZi
mYsM2tkU4hoBSTvuvCMRHBz7Jd/311UCzEf7+HEBHfg3aMAd2w==
     "]], 
    {RGBColor[1, 0, 0], PointBox[CompressedData["
1:eJwBAQT++yFib1JlAgAAAD8AAAACAAAAAAAAAAAACEAAAAAAAADwPypwmrHD
rQhARoVFVl8d8z8IZ01iZxwJQOwlixPaCfY/kp7aEdBKCUD34fS09b34Pycn
CguHOAlAMoWD6Mcy+z+6/k0Tu+UIQKBBUz0IYv0/ppQf8z9TCEDkbsk1IEb/
P5w8SViMggdAQfRKyRxtAED/MYUXtnUGQIBl/FglDQFApZMF12wvBUCojNNx
kIEBQCQIii/zsgNAGshxSzTJAUA0HZZVFgQCQL6d76ZZ4wFAH+McYCQnAEAc
mpSjvc8BQGxIAovCQfw/sdjnaZKOAUAisSlW9ez3P/KlY6t+IAFAlVWLTPVa
8z+TZhT4m4YAQLBYX0XmLu0/bMbK3OeE/z9Mx7VfPF3jPyRLm5j4q/0/KJbC
DBW00j8hdNjXI4f7P+AFhtZeIpi/6ybNcOUb+T+E7VYwhbTVv8XX/FRtcPY/
Y2neza/X5L+WI5+9j4vzP0gx7wjNn+6/UIDms7N08D9FMByMygz0v2AugEOA
Z+o/gFH3k2WW+L+o0fY2D6LjP+RrYGAc4fy/yhM0WMxU2T/llfhJ+nAAwBhc
AANeScY/2u0HYlhHAsCgyRX0eD+pv4HXFVX17gPAGBXzp3ps0b+L7VWXlWMF
wMFQ/uB0hN+/CP8ICIChBsAke6qH6KXmv1qcdneHpQfAHqQDV6hP7b99+fLG
Em0IwK5o+2Q31/G/kbkojiP2CMABSQFJ+Nj0vxD4pjRbPwnAOwUv6mWl978L
IKhy/kcJwD++PcFXNfq/gbsbMPcPCcAlf2H8P4L8v7npKb3UlwjA3AftQjyG
/r/W7p9jyuAHwIpKLWESHgDAoIPvVKzsBsAhDB2vzM8AwDxjm/zqvQXAh9ik
cIZWAcA6VAjDjFcEwLjviwnnsAHAYQ+oUCa9AsBQYnlNB94BwMi4SGXR8gDA
fYxDz3PdAcB4puy1RPr9v83sLggurwHASLeE3jjC+b8XJClUrFMBwOfAz+FJ
SPW/ycIJw9jLAMCm2C/l6pfwv5NG38EOGQDA0OXumDR657/3WYdEL3r+v7K1
CzEMEdu/2GgzEUx0/L9oR/1pzqG7v33GxZmgJfq/HKH55aCjyj+OCx+5E5T3
v437GFMBteA/HEpsXDfG9L9dhqBpXpbqP8n4AbU3w/G/GoYf29wZ8j9UWj6/
kSXtv0BmBrM9uvY/ZowNYCZ65r/sFPlAfCD7P8jBVU15Kt+/cJlXvFdB/z8s
Is/57RDRv6S5C2wgiQFAMNp2Dtxdpr98hLliukQDQDhMtms7Acc/4AXEFQvP
BEBqAI/9iq/ZP9HyA+ohJAZABpuvc2LO4z/xSH1plkAHQIf2iQlWkuo/IKru
8A==
      "]]}}},
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 12}]], "Output",
 CellChangeTimes->{{3.5848025309465747`*^9, 3.58480257049663*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{951, 630},
WindowMargins->{{Automatic, 56}, {Automatic, 51}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 691, 12, 107, "Subtitle"],
Cell[1273, 36, 3703, 139, 675, "Subsubtitle"],
Cell[CellGroupData[{
Cell[5001, 179, 5557, 155, 532, "Input"],
Cell[10561, 336, 2420, 50, 432, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13018, 391, 358, 8, 85, "Subsubtitle"],
Cell[CellGroupData[{
Cell[13401, 403, 2132, 65, 152, "Input"],
Cell[15536, 470, 9750, 178, 273, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
