(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    114867,       1994]
NotebookOptionsPosition[    114388,       1973]
NotebookOutlinePosition[    114731,       1988]
CellTagsIndexPosition[    114688,       1985]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9},
 FontFamily->"Arial"],

Cell[TextData[{
 StyleBox["Action Ellipsoid",
  FontWeight->"Bold"],
 "\nIn 3 D, matrices map spheres to ellipsoids\n"
}], "Subsubtitle",
 CellChangeTimes->{{3.5848174433360147`*^9, 3.584817501886097*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"input", " ", "matrix"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"mmat1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "3"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mmat2", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mmat1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mmat", " ", "=", " ", "mmat2"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "a", " ", "sphere"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"sphere", "[", 
      RowBox[{"u_", ",", "v_"}], "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Cos", "[", "u", "]"}], "*", 
        RowBox[{"Sin", "[", "v", "]"}]}], ",", 
       RowBox[{
        RowBox[{"Sin", "[", "u", "]"}], "*", 
        RowBox[{"Sin", "[", "v", "]"}]}], ",", 
       RowBox[{"Cos", "[", "v", "]"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "map", " ", "the", " ", "sphere", " ", "by", " ", "the", " ", "input", 
     " ", "matrix"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ell", "[", 
      RowBox[{"u_", ",", "v_"}], "]"}], ":=", 
     RowBox[{"mmat", ".", 
      RowBox[{"sphere", "[", 
       RowBox[{"u", ",", "v"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sphereplot", "=", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{"sphere", "[", 
        RowBox[{"u", ",", "v"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "0", ",", 
         RowBox[{"2", "Pi"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"v", ",", "0", ",", "Pi"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Green", ",", 
          RowBox[{"Opacity", "[", "0.8", "]"}]}], "}"}]}], ",", 
       RowBox[{"Mesh", "\[Rule]", " ", "None"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ellplot", "=", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{"ell", "[", 
        RowBox[{"u", ",", "v"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "0", ",", 
         RowBox[{"2", "Pi"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"v", ",", "0", ",", "Pi"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"Opacity", "[", "0.5", "]"}]}], "}"}]}], ",", 
       RowBox[{"Mesh", "\[Rule]", " ", "None"}], ",", 
       RowBox[{"Axes", "\[Rule]", " ", "False"}], ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Matrix: \>\"", ",", 
      RowBox[{"MatrixForm", "[", "mmat", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"ellplot", ",", "sphereplot"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.5848175624681826`*^9, 3.584817920958685*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Matrix: \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2", "1", "0"},
       {"1", "1", "1"},
       {"0", "1", 
        RowBox[{"-", "1"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Matrix: ", 
   MatrixForm[{{2, 1, 0}, {1, 1, 1}, {0, 1, -1}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.584817833928563*^9, 3.5848178733886185`*^9}, 
   3.5848179220186863`*^9, 3.584897118252536*^9}],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJw8XAk0Vm0QJoqkjYrsFfIXkShlma9SSZJWKiSptJcolSQVLUhIkexC2pMk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    "], {
     {RGBColor[1, 0, 0], Opacity[0.5], EdgeForm[None], 
      GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxN3HXYZlXVBvDzPEdUEEkFBqRTUkJaSgQpgQEEpLsblXaYQUCkQUAkBukc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        "]]]}, {}, {}, {}, {}},
    VertexNormals->CompressedData["
1:eJwcmgc41e0bx5FkNEnKpiJFClGp7kRRVhJlJhSJehuSBoqoNFRkZhQKiYyM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     "]], GraphicsComplex3DBox[CompressedData["
1:eJxlm3lcT+kXx0PGb8i+jl22DLITLTdGIrusyTKRUiKMLUvWoixjm4yI7JmM
bGX9PlT2ZUplH4YkjD0Mlfzu7fmcM/d7Z/4Yr95z5jzn+dxzznOe21XPa9IA
76IWFhZv1X8VU/+MubRmT5/aK53y9vVr+Waog2Otr9o/r5WLH+vfMVmHOzkU
sxyRaB3kRLxHwyXne55f6LQ7wOPXJstDmd+2Wxr/xzU/p59D0hYVeK5gfvV9
9vdp1/xMPT569tfzGWevz+x1fqEp3u9DKb2ff/oucxDW4aYmm0cln9at+/Vq
YZymKoNjPgRtcrYn/gn2DaW9ifhM+D8s/TN/jHi6y3iYH0b8a2T8zBXsd7/c
L/NE6DNc6sOc9HyT9VnT8xTxItMOT1sz+4pSrnD9IKeW80a+imz9WmkatHNi
UMxF5UFY/rOxCUcV4hbW18rbJZ5RplV53/5C13PMPx78vlN1jxglp0+/t2eS
LzMfXWTRvFoeMaLuoIgzej4+IeiY6kdsfuhw4LzOz/z0g5fVdUXHOct8xujW
tZlZGKdIeFoQW94/2IH4Ati3k/aCuB/8b5L+mU9DPHVkPMzTEP8HGT/zj/Xk
fufK/TJvAH3ypT7MSU+vvNCmqp4m4jM8Fjw9nXxXaZVy4Ocz1mFOZ+pPW3wy
/YXyR5VPB5MsbyueCeMsT1e7oBBv2Dnskn2/VKVXzhjX20cymF+56/V5tKrL
4BJlry6pcJd5R8skGy2OpiOWRun5psiiEx36pQrnoiXO3tL5udE8rnSy5W1x
sdaOcJNu3bARhXGKPoPHrfONXulA/Cbsz0l7YfSvSP/MeyOe72U8zPci/iEy
fuY1sd+Bcr/ML0CfmVIf5qSnR3rv1aqeJuKn14ysFp2TqbxL1upsjVOxxO/c
kiyfKYN9s8anfH6odPfz/KDGqxD3v7/Gq8bDW8rUnH4PNrV+wPxk5W2T2qvP
vUf8lMprpmYy96W8fW75frWOu2UE9a758JaoUC+/vt5PuUcVf1PXFXmX9zyx
1637cV1hnMLu0eqpJYv+4mC0/yTtBfGe8F9W+mc+g/JcxsN8O+LvKeNnPgL7
nSf3y7w/9Bkh9WFOemb92WWWqqeJeOCb9uu1P21f7B7QZHmEU6c3zY9vVe3G
Xc99MTfsiTLy46v9Wt4SD51UZXikqkut8MBlU1ZlMh94Zkbls2r9N7dd+MV2
7FPmO+dUe6/VbUipiDQ9rxO+a4EW9+3V+RX1fqK/xjvNC3siWn6d7XlLt267
nMI4RXPLJx/vbYh0IL4N9s2lvSBeD/5vSv/MjyKeJTIe5u0Rv62Mn/l07LeB
3C/z0dBnhtSHOelZbG5bd1VPE/GsbcePanndvvA8iXSaMNa/rJb3/tsLmqd8
fqa4buiWqtalQtzF26OI9hxTssYsVPfHPG5o3bkz1H61sd+w7P01XjCfh/4Z
9rZkgp5THrapVjJvrs7PbLcWy9V1hWVhHvy7bpVdhXGK3L9WBE+4usWB+BzY
F5H2gnh5+G8l/TNfh3iWyXiYL0f8kTJ+5vbY7y25X+ZjoY+31Ic56Rncs6mj
qqeJ+Le9m3+7Se3T/k4b/Ao8Nzv1WvN4y89qH79cs9t4TZfDfQOXhah9lbjN
toq9tfo/sv98qxZqfhKf/97LxaSec/9UmD99pN8r5leuT72tnSuTVnfqoudf
Uk5YavVZsKz/Fludn9v1Wv+h7fNqpcaPFuvWnduvME6RGNQu9n7baAfid2B/
UdoL4gXwny/9M89EPBNlPMw9EP9nGT/z2tivSe6XeRL0SZf6MCc9z4a4+qt6
mohPy5dzR5PCuSnKqYRnpTaNdq12SN/Sop/2XOS5fFch7uX2ZbhWB5b1B/6l
1Qfx23srXVqp+itf2A9fM2+EOYHOXeLUby3Rv4hT3gYgD4hbFP7zRsifox2I
V4X9eGkviP8D/0Wlf+ZOiKeFjIf5QcRfUcbPfAj2W1rul/kV6OMs9WFOes6J
6Baj6mkiXhL6T0A+u0r9xRU8ryPIZ+JN8Hzjkc/EFyAfPiGf2Q/yJxD5TNyY
z8Qpn68hn4nPQz4nIZ+JUz5fQj4Tp3z+gnwm/ti8vpgPR/y5yGfixnwmngx9
MpDPxEnPc8hn4k/QTzqgP/shLyag/3RHfybeDf0qFf2Z+AHz/sY8GP0wHP2Z
OPXntujPxKnfFkd/Jk55m4f+bLQviv5MnPpza/Rn4uvNzwvmKxD/JvRn4g7Y
7230Z+Le0Gcc+jNx0nM++jPxKTgfW2Le6CDPR+GL83QU5g3iy3D+1sa8QXww
zusWmDeI78b5vhTzBnFrzAN3MG8Q3475oTXmDeIdMG+0wLxBfAfsW2DeIF7f
fJ5hfhzxhGLeYP+IvyXmDeIzsd9GmDeIe0GfWZg3iJOexTFvEE/GvPcR87MF
+pkH5sOemJ+JB2KenIX5mbjA/Nkb8zNxf8yr0ZififfFfFsN8zPxisjDAszP
xHPRbx0xPxOvBPt8zM/E+8F/FczPxIMQz1bMz8R3I/4+mJ+Je2G/SzA/Ex8E
fUZjfiZOej7D/Ex8Me4vjrgPmuT9RdzBfccH90HitrgfDcF9kPgt3Ke8cB8k
3hX3rw64DxLfgftaT9wHiT/C/S4d90HiEbgPeuI+SDwT9qm4DxLfCf89cB8k
Psw8HubxiH8s7oPEG2C/I3EfJJ4GfRbjPkic9PTBfZB4Q9zHW+P9hi3O4V64
vxfg/Qbxqni/sRrvN4hXOSTfD1TpK99vEJ+P9wk/4P0Gc+TVMbzfIL4V/XMo
3m9wPJgTHuD9BvFo2A/E+w2j/6N4v0F8PeLpgvcbxHPwfqOajJ95aez3V7zf
IO4CfWqGy/cbxEnPRXi/QTx/nTZ/8Pslel8nyuWcLXwf5Vdiq/59nbBz+lD4
/mpewRP9+zpR2dkmQXvf9ezawsW693Kidr62np9pm5PVAD33u6/V1UJTWN4C
K70f517a+RFu6h2dp39fJwZsKIzTVCHY6qPufZ3oDHs3aU/vzYQ//C+V/pm3
QzzRMh7mbxUZ/98yfua22G+I3C/zb6HPMqkPc9LzSa3trXTv60TtWnsPmN6e
UPZ8tzir1aJflaYb/wyee+W18qR2cGxCzEklt1ZEYudcPyfiLZJKjLrrG6+8
jnSdVXD/ANuHWHZIDniwR9lg16h/mbRjzEP3jFP/fw+Taz3pj3hx25o9Jj3Y
Iw7WWZhTWmdfb3NElupfrP8xPOWLzn+BX9xDNU6xMe2vSFtdnMTXSC6IW8PP
WumH+bdY94Bcl3nxyo7JujiZT8G+Nst9MW8EHfKkDsxrQM80qacw6rnKxi5J
1dNEPPnDsySvsk+UZz8dyX9RP1lxap9tH7X1idKltv3N23EPlTEPAqy6d7jH
fHDLxEs7tqUpHW7/HvjJ6zHz1fUc7xbttcTk51x1tfYz8Vq/JX3ZuS1NWIYl
NtLbt+s7rfOduIeigWXxoq46/1bT056p8YiXbj3HPtfFQzxbckG8A/zUk36Y
18W6xeS6zBcFx93TxcncFfuyl/tibg8dpksdmCdCt5LTCnVj/uOliNCf/J4r
ce+Pf35f64LiPfLQF59vHio7fU43Kt8iSzlwOLf9mcd/Mc+NaJnbcNFNZUHw
pQZTxz9l3mbF3JIL5i8zOS97O2lEtb+Z/9glZXzjRTeFT6TLlSk6+65l3u9U
/YstLWdFnNb5Xxz95bAaj9h2sO79t7p4iG+UXBDvBj9R0g/zsVh3nFyXeYRT
JytdnMyzsa8QuS/mm6DDSakD85HQ7abUjfmqoyV7BUx5qey+uXH6uEeXlDvH
9v3qVj9DcZg+v9ywzdnKm9xGb4pkPGJ+ffKtF2nt7ijBq1c5r2z/N/NXPz+c
FB2w3NSwyONbbm1fMe/bcHdIRrs7oq3voz9X6OxLHOwVpfoXPm+GOOn9V7He
NU+NRxz4+chXL108xPdILoh/Cz/e0g9zd6zbRq7LvHuP1Mm6OJmfwr6WyH0x
bwMdvkgdmC+HbmlSN+arit/6MsbitVK6TRX7E72vKIPikl8dUvtC+zR7/7n3
nioJQ77eXJSWyXxHXOoUqw13lfvWnkMH7nrBPLj357VpL1eYehzzWKH1EeJB
yV2sy2y4K0J8Zr1x19kv8l5sMe/eUzHQ7WpNvf9KI+u0GWvxWjzLGrk+QRcP
8b8kF8SXwM8A6Yf5PKy7RK7LvHerYr/o4mS+Evt6LPfFvBl0SJY6MF8O3Ryk
bsyNevaSXBj1JG7Uk7hRT+JGPYkb9SRu1NPISU/iRj2JG/UkbtSTuFFP4kY9
iRv1JG6s95syb4Wx3okb6524sd6JG+uduLHeiRvr3cip3okb6524sd6JG+ud
uLHeiRvrnbix3ol7oa8ewHk0VvZVsctwHhHPQ99eiPOIeFucR51xHhH3wrng
i/OIuAvOka04j4gvwbmzHeeRkUfiPCLuajiPiHubn4PMN+A8QpzMn2JfoTiP
iG82nEfER0G3WziPiJ/Huf8C85K9PPeFC+YEH8xLxIdhruiEeYn4OsxLAZiX
iNfB3PIN5iXidphzbDAvES+LuegN5iUjf455iXhH+GmIeYm4tfm6zEMwLyFO
5j2wLyfMS8SdoMMszEvEz0K30piXiPfCvHrdfP4XlevIebVxbbP5X7hj7rXa
ZDb/i/2YkxPN539xGPP/dPP5X9hiDr9nPv8LF8ztB83nf9HMX875SebzP/MT
5vO/cIWfOPP5X7TGunfN53/RCvP/dPP5X0RiX+fN53/hBh2qbTKb/0UP6Jlv
Pv+LUu9T7LR75ne3ErLS1Xse3b/if6tXyNekVNU4fwfSPbvLWRv1/mmxblaq
el9k/s6n9Ceh3j975Z4IUO+XzDcn1lLvyc1Oyd+DrGT+qvB9UJCp7o7BpfT2
aYXvPUNNTz80rav376ho7/dXmFZWPRqYqouH+BLJ+TuQDPh5Iv0wf4d168h1
mTeoYNVaFyfz+9jXALmvf79LgQ5WUgfmh6CbSerG/NjoK0W0ur03rmvELq0+
cC9ovC5lTje1bjuOWzNdrT/mPdpWqfZMrdvhbS/ka/VBfNbo+XF/q3WyOP7+
DT0Pm9IxVKvbTh2GWun92B482lOrw66vuozdqVu3VGdZt/3GfH2x9cMGB+It
YN9F2vP9JRz+O0r/zMMQzyIZD/PmiN9Txs+8GvaryP0yPwR9cqQ+zN0bF9uq
nR+bK2+tZ6P2aZr/mwUcddXOj/QHK7K0Pk186yr3fm/U8yMzLO6y1qeJu6e/
9M9R+/W+eLcoPa+T0zFbOz+W23uM0/upV2bpJ+38SA+wONhIt65FmDw/Iqof
Pe2cudmBuDXsU6S9MPoPk/6Z+yCeWBkP82DEnyXjZ14f+70n98u8F/Q5JvX5
l6eGx2pzzJ9zVrrfUOcFmvNXjg/MslDnmM9XW2dp8wLxon936fqjOseMS8+J
0OYF4s/b2pwYq84N9ScO9dbzltOVCG3OuLxu3BC9n41f7Mpqc4nbFXEsXbdu
HuYYh7irlSP3bHUgHgn7btKe7yOt4P+i9M/cop2Mx1rGw/zP5zJ+Xxk/88XY
b9Frhftl7gJ98qU+zGeVWHpSm6er9sr7rM65fO/I7dxWLFTn6U2xNj3VuZh5
ccdFiUfUeTqxRFJvdY5m/sOKTr7H1Pl138HZ1fR8df9xQdq8W6bWX0fm6vx8
OevXQJuPB9iHuZXWrdv0uJynkw7nTz21LNqBeAHs+0h7vnesgX8r6Z/5cMQT
K+Nhft9Bxp8s42f+GvvdKffLfDL0sZP6MDfqRnO7UTfiRt2IG3UjbtSNuFE3
4kbdiBt1I27UjbhRN+JG3YgbdSNu1I24sU5pPjfWKXFjnRI31ilxY50SN9Yp
cWOdEjfWKXFjnRI31ilxY50SN9YpcWOdEh+IvheFc4Hm8Obokxk4F4hHo68+
xrlAfCD68O84F4hT316Bc4E49fkMnAvEi+Bc2IBzgXh92KfiXCBeF/7DcS4Q
9zU/p5jPR/xPcC6wf8O5QLw39DmOc4H4CZyz9zGH0LzdFOeyPeYQ4j1xjo/E
HEJ8Ds79UMwhxFdgTnDEHEK8FeYKV8whxMtgDnHHHGK0x9zC94JV8G+POYTX
RTwhmEOIt0T8ozCHEK+J/XbBHEI8Hvp8xBzCcWJOfnkzQT8Pi+oz/yicA9/H
PtPPw6LChJjCuTHi44iJuvlWrM09VzgPy+9YeB4WVTO03+cFmXy3ftLPw2JP
4e+tQ023y2zSz8Pil1Dt+4wVpozaQyfr5mHmVyTneX4v/NyUfpjXwLo+cl3m
1d2OtNbFyfyLv9zXZrkv5uWhQ5F9z/TzMN/XTpr/fkHUKB+XrN2v4k6vLBWo
3mPo9w5PuzSfo92vnJc+sLmn3mOIz7Yt+08z9X61adWhz9o9hvigGQedW6r3
mfSu+y7quRL8rIF2/7kQ13fbXZ2fe80GWmv3pY+/xoRM1K1bwVrerzx8gnw+
bZ7kQPxP2L+T9vx7E2f4Pyf9M/dHPGkyHuZDEX+UjJ/5fey3u9wv84rQ55rU
h3mDa1VttO+Q9ihzticlX+bv5apPqzJY+57j4pNVo7XvEIhXm7awjPYdUklr
m6JxNV4wfxk8pvDetLWv/N6HeNFDl49ov5/+rq7Dpv06+8Wblz/VvsOoczx7
z2qd/1LuIzy17418Cr9fufwfPlJy/l4uBH5qST/Mv8G61eS6zFuHjJmgi5N5
MeyrrNwX8/LQ4YbUgXk96HZD6sbcZu+qNO37uZ88F/dcp/5M35VNWpVfkGj5
TNlgt2q69l0D8eTxg9qL5LvK9UYWL7Xvd4gHHPI0uzcSX4HvCui7beJt8P2M
A75/JU7fiXVDfEbuiO+xiNN3v/iOlvlqrHsa3wcQj3o8fq++non/jn3dkvti
7g0ddkodmDeEbtulbv9y6ByD/KTvx2rguVxCfhL/Ds+xFPKT+CvkZzTyk3gx
5El15CfxJYb8JG6FPPRFfhr5KOQn8VD4qY38JF7CvC6Yt0F+Ik7mlJ/lkJ/E
KT9vIj+JW0O3m8hP4i7oA7fN+6Qo/oPsG97mfVLsQJ+5ZN4nRTD6UlEXsz4p
RqCPvTTvk+Kb5rLv1d5o1idFZ/TJleZ9UpSAfY2NZn2S/f9t3ifFOsRTxMWs
T4oFiP+yeZ8UeeiTAeZ9UjhBn3/M+6RId4pqXTk0VoleZzUlO36WkpfdKblm
zmvlOvgXyQXxTooZJ3thBz5svZm9sAiV77vjI34otWD+rya6d+8VmVFaXk4t
lz9lTsxF/h57e0Fm4e8b3g00BUYHbDLRffP86VeLB698pSzJrND+fdgJsb1g
e73YhFRlV7z8fU/5Yw/Xpb3cbKJ7VjW70vm/C7XuTvg7t4w6KWJy1p764Ujs
f+zpfvF5+MiGs4a9Vq7tcD1cpstJEdB9/a2bgWeFMR6aq39D/D8hfvousWOv
Ol16qut0d/29cuPiw51IN9KhhudvJVUdnEiHffDTXfpRjDrMiK6kretEOlyE
DvWlDgrpkLK3W/mM0S+VBUWqKrazj4tKD0pMejT3Fu+3UbkW2n6dSJ/q0MdR
6qOQPkYdJksd/uOHdMuDvZ+0V0g3o/4bpH9h3BfpSTr0gA6kp/G5R8v9iiLQ
syb05PsFeALyjbj7u9aTRfrfSrMKNUyNqxwTDxt6XlE+3BfeTy4Fpb1c4dTq
s0V3l1wPPpcGrJo7W+Ozi23TOM+NW/F8e6ztW0V9vibKcx/4Sf1kobdXKB+e
rjGzV8hPjHmeiH5Y965cl8+f7r/fabclMl1xXi9iF6UcVFpc/u6ApmN2xvEY
7TuzeY32163jEcN/P25si/WtjoakKBav0gvODb/E9kNcfpyofX+2w6J/6Y6J
Z9j+gM9sW9OQRKWj49x9vqXS2P7Gu767vBKOKsuCO+Zq33+R/bXnvVJrZE01
NU2uPrenmpdkH30lofDvLY6cIb8LI/tPdVx7iyGJYvnhib56/474DrCUTbPN
ev+126SuU+MXgQc+FNfHT38PqF3ADm87Xfwe3VyGqfqItsMqOC/Q6XMN34Hf
vTP4Xg2dPmRvK+2F0T5N2vPfG6iDeCbKeNievhNuI+Nh+1zsN1zul+2dsd+S
cr9sP/zG7us6Pdn+7A/hzXR6sv02PC9H+bzYPgnPa6V8Xmw/EvlQQeYD2/dB
PsTJfGD7AaiXpqiXTFkv/+kzFWSfET5Z7yPCGieq5+8oq3kp8crQV9f6dF7+
Wqk/tseUOerPjXperhau/nfiQ/fNXhrYdq2S4j4raHCfs8wf7P/t9Hj3WBHq
mbEkwyGZ+YLjmQN9B5jE+/QTj3wGmJi/8Zq3VbUTF4KfrvJ1j2Xec9ekyapf
UWtZi5JT264VxB2/v/1SjVP0WZyXq8bFvMP2fYvmqj8P+F92ovbfiVcemxk+
Tf3/f/nH21fzR7xcn4ajfNT1HHwbn9DWJ77z5dpALb6fokqd1+Il3g31O0rW
L+ufhfrdI+uX9R8I/a+XL9RfIf2vQ39rqb9Cfd7Yh6lvG/s89WHjOUJ91eif
nu8gxJOGeKh/DsG+eqMvNZP7EiVvyH1FoS/Rd6GVBjXz155r0P2Jb/1U/YZI
fUQg8rMi+hX5mYr8PIF+RX6CkG9vkW/k5zr0Xyz1Z25CvXRDfyP/H1EvMehv
5N8eeWuHvCU/3fDc+8jnzvwe+mEn9EPyn4R+uBD9kPz7I/+fIP/Jz/+Qb7/J
fGNevK7sJ7+if5J/T/STZuif/P0t6mgT6oj89Eaee8s8Z/49+tsi9Fvyfwb9
rSf6LX+3jHqsmCHrkfz0QX35yvpi7ot+2wX9mfy/Q7/NQ38m/8XHyLrOQl2T
n9GoawdZ1//x74B+bvSfg35O/slPK/QH1hnrPpDrMm8Kfeaj//PzhT5u6P/k
vy90GIc+Q362QbfyUjfmJcyfL/sfTX+PG+cF+e9j/hzZzzdx8rlvlM+d+Xic
L8hP9p+N8wX5yf5tzPOQ/bQzz1vm+1FfbjiPyP8j1NfvOI/If3PUUX/0T85D
1J2jrLt/40d/aIDzi/z7oT+cw/lF/pPRB9aiD5Ofn9A3ip0p7BvMB6GPTUB/
Jv//Qx+7gP5M/sujj/0i+xj7+TpQ8hHob9T/DyEeb/Ql4k2gQ0f0E+Lvx5id
O8zb4bm7o36JOyDf+qPuiLshz5ugXoznZiLynPhC5Oc7ec4yf4Z+sgR5Rbwe
8iEV+UC8Ip5jUzxH4j9C/xeybzM/5Oo5StvnG8eI0jN153X0xGwXrd+tyY29
p9YHz3UjZq782PBYilIrLXtWE98EZfzriLUZ4pWSUy5k2Vm1f0W1mXROyxee
u14mLx1f5qLy+W7Sdj/1T7LfcezEt/PVfhT7c66f9vzJ3vqvMSGNNL/Pd9o1
Utche/GP7/SFan5k5q5y1dv3uhLuOvLUFnF8fFcrm8hUtp/cz3uhlq8JrdqM
0cfj8uX1AOc7ieKnltGHXllcY/vxnz+EafUzuOvDUybdfrdbReaqdqJuWu5D
5U4i259BPXeoEnDXon+oA9l37HuyohqH8O9YrL7HqS1s7wf/7tI/zyF7qkdZ
q/sUx0I7LWzsmyDIfirij5fxs32dzIkuqo7i4dPvslVd2f4P6PNI6vOvvW35
eTaq3396/GKlrUP2YdB/n9Sf7eftCCoYpMYt2rStoe2D7B/j+e6Qz5ft7+8u
PlnTpW32us6vVZ3IPhL5s0fmD9uvHrB7gqZ7YKOsJO05sD6J8vye7JetnueL
TJw/i65Yas/15ohKE7zU50z2/wdlEIr1
    "], {
     {RGBColor[0, 1, 0], Opacity[0.8], EdgeForm[None], 
      GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNm3f819Mexz/fYxMapCTtQUpLE/0KmaWhIdGyqTSISoNkZ5P2kNIgWRk3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        "]]]}, {}, {}, {}, {}},
    VertexNormals->CompressedData["
1:eJxNW3lcTl0XrUSmQpRIMqW8KQkJ9VwaVCJDJYlChgaSqZSKSvNESVSKqERI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     "]]},
  Boxed->False,
  PlotRange->{{-2.2358214727937136`, 
   2.2358214876943014`}, {-1.7320485382499495`, 
   1.7222142776576839`}, {-1.4142135623730683`, 1.4142135623730683`}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5848175213681254`*^9, {3.5848176672483296`*^9, 3.5848177183784013`*^9}, 
   3.5848177849684944`*^9, {3.584817833948563*^9, 3.5848178734286184`*^9}, 
   3.5848179220386868`*^9, 3.584897118262536*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{802, 630},
WindowMargins->{{Automatic, 28}, {34, Automatic}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 691, 12, 107, "Subtitle"],
Cell[1273, 36, 205, 5, 67, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1503, 45, 4101, 115, 392, "Input"],
Cell[5607, 162, 968, 26, 50, "Print"],
Cell[6578, 190, 107782, 1779, 342, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
