(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     14570,        377]
NotebookOptionsPosition[     13978,        352]
NotebookOutlinePosition[     14323,        367]
CellTagsIndexPosition[     14280,        364]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9},
 FontFamily->"Arial"],

Cell[TextData[{
 StyleBox["Barycentric coordinates",
  FontWeight->"Bold"],
 "\nOn a line and in a triangle"
}], "Subsubtitle",
 CellChangeTimes->{{3.5847328876381493`*^9, 3.584732897298163*^9}, {
  3.584733899967575*^9, 3.5847339036275797`*^9}, {3.5847347546887712`*^9, 
  3.584734768638791*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"p1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Manipulate", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PointSize", "[", "Large", "]"}], ",", "Black", ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Point", "[", "p1", "]"}], ",", " ", 
         RowBox[{"Point", "[", "p2", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{"p1", ",", "p2"}], "}"}], "]"}], ",", 
         "\[IndentingNewLine]", "Red", ",", "\[IndentingNewLine]", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "t"}], ")"}], "*", 
              RowBox[{"p1", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], " ", "+", " ", 
             RowBox[{"t", "*", 
              RowBox[{"p2", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}]}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "t"}], ")"}], "*", 
              RowBox[{"p1", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], " ", "+", " ", 
             RowBox[{"t", "*", 
              RowBox[{"p2", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}], "]"}]}], "}"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"Axes", "\[Rule]", "True"}], ",", " ", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "0.5"}], "}"}], ",", 
       RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\< \>\"", ",", "\"\< \>\"", ",", 
        "\"\<Barycentric coordinates / Linear interpolation\>\"", ",", 
        "\"\< \>\""}], "}"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.5847329305982094`*^9, 3.5847332097886004`*^9}, {
  3.5847332447886496`*^9, 3.5847332988687253`*^9}, {3.5847333484987946`*^9, 
  3.584733358048808*^9}, {3.584733410738882*^9, 3.584733441598925*^9}, {
  3.584733515623031*^9, 3.584733537797068*^9}, {3.5847336038171606`*^9, 
  3.5847337926874247`*^9}, {3.5847338339974823`*^9, 3.584733878637545*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 0.5, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`t$$], 0.5}, -1, 2}}, Typeset`size$$ = {
    360., {180., 184.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`t$59906$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0.5}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$59906$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         PointSize[Large], Black, 
         Point[$CellContext`p1], 
         Point[$CellContext`p2], 
         Line[{$CellContext`p1, $CellContext`p2}], Red, 
         Point[{(1 - $CellContext`t$$) 
            Part[$CellContext`p1, 1] + $CellContext`t$$ 
            Part[$CellContext`p2, 1], (1 - $CellContext`t$$) 
            Part[$CellContext`p1, 2] + $CellContext`t$$ 
            Part[$CellContext`p2, 2]}]}, Axes -> True, 
        PlotRange -> {{-3, 3}, {-3, 3}}], 
      "Specifications" :> {{{$CellContext`t$$, 0.5}, -1, 2}}, 
      "Options" :> {
       FrameLabel -> {
         " ", " ", "Barycentric coordinates / Linear interpolation", " "}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{433., {245., 250.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.5847331762185535`*^9, 3.5847332003385873`*^9}, {
   3.5847332563086653`*^9, 3.584733299268726*^9}, 3.58473335920881*^9, {
   3.584733415248888*^9, 3.5847334423389263`*^9}, 3.584733518655037*^9, {
   3.584733737757348*^9, 3.584733794847428*^9}, 3.5847338794775467`*^9, 
   3.584734784798814*^9, {3.584734837718888*^9, 3.584734851278907*^9}}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{3.584733260968672*^9, 3.584733915767597*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"t1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "2"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"t2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "2"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"t3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0.0", ",", " ", "2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"pt", "[", 
      RowBox[{"u_", ",", "v_"}], "]"}], " ", ":=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"u", "*", "t1"}], " ", "+", " ", 
       RowBox[{"v", "*", "t2"}], " ", "+", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "u", "-", "v"}], ")"}], "*", "t3"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"barycoords", "[", 
      RowBox[{"u_", ",", "v_"}], "]"}], " ", ":=", " ", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", 
       RowBox[{"1", "-", "u", "-", "v"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"range", " ", "=", " ", "6"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"Manipulate", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"BaseStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"Large", ",", " ", "Bold", ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "}"}]}],
          ",", "\[IndentingNewLine]", 
         RowBox[{"PointSize", "[", "Large", "]"}], ",", "Black", ",", 
         RowBox[{"Point", "[", "t1", "]"}], ",", " ", 
         RowBox[{"Point", "[", "t2", "]"}], ",", 
         RowBox[{"Point", "[", "t3", "]"}], ",", "\[IndentingNewLine]", 
         "Yellow", ",", 
         RowBox[{"Polygon", "[", 
          RowBox[{"{", 
           RowBox[{"t1", ",", "t2", ",", "t3"}], "}"}], "]"}], ",", 
         "\[IndentingNewLine]", "Orange", ",", " ", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"barycoords", "[", 
            RowBox[{"u", ",", "v"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"4", ",", "4"}], "}"}], ",", 
           RowBox[{"Scaled", "[", 
            RowBox[{"{", 
             RowBox[{"2", ",", "2"}], "}"}], "]"}]}], "]"}], ",", 
         "\[IndentingNewLine]", "Red", ",", "\[IndentingNewLine]", 
         RowBox[{"Point", "[", 
          RowBox[{"pt", "[", 
           RowBox[{"u", ",", "v"}], "]"}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Axes", "\[Rule]", "True"}], ",", " ", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "range"}], ",", "range"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "range"}], ",", "range"}], "}"}]}], "}"}]}]}], "]"}],
      ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u", ",", "0.5"}], "}"}], ",", "0", ",", "1", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Open\>\""}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"v", ",", "0.5"}], "}"}], ",", "0", ",", "1", ",", 
       RowBox[{"Appearance", "\[Rule]", "\"\<Open\>\""}]}], "}"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\< \>\"", ",", "\"\< \>\"", ",", 
        "\"\<Barycentric coordinates / Linear interpolation\>\"", ",", 
        "\"\< \>\""}], "}"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->CompressedData["
1:eJwdxU0ogwEAgOGvHSSN/BRxWH1FDuZgZTvIbFEcZFnZStESipQsaqI5bIqU
tE1+Zm0TSQ52mV0Wy0FWkrL8rK2IWmkHtJrE4t3h6RGHJvUjEkEQqv6x7sFv
MgTftA7xdooDBxfzXNBYs8DnYbmNrYmmVZ72eh189+Hd4B5fys0nftURR+vd
QX7aTYVYOrp+yuNbpggni5RR7jsuuWFZs/6ew9lU/lrxKsEh6WCS35ckaVY6
x/J3uJ6z3HrY9su+ur1i4/+Rs4EKDpRbZfw4XCnynKBRcX+6rIUL97/UbL7O
tHPuZVvHsYbuXo5rFEb+jHeZ+VXbaWHDt2eWM66QndVe9SKvXSqWeabUvsI/
SYuT5bHqTZ7w53bY5s95+A/yuMh0
  "]],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0., $CellContext`v$$ = 0., 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`u$$], 0.5}, 0, 1}, {{
       Hold[$CellContext`v$$], 0.5}, 0, 1}}, Typeset`size$$ = {
    540., {267., 277.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`u$64227$$ = 
    0, $CellContext`v$64228$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`u$$ = 0.5, $CellContext`v$$ = 0.5}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$64227$$, 0], 
        Hold[$CellContext`v$$, $CellContext`v$64228$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Graphics[{BaseStyle -> {Large, Bold, FontFamily -> "Helvetica"}, 
         PointSize[Large], Black, 
         Point[$CellContext`t1], 
         Point[$CellContext`t2], 
         Point[$CellContext`t3], Yellow, 
         Polygon[{$CellContext`t1, $CellContext`t2, $CellContext`t3}], Orange, 
         Text[
          $CellContext`barycoords[$CellContext`u$$, $CellContext`v$$], {4, 4}, 
          Scaled[{2, 2}]], Red, 
         Point[
          $CellContext`pt[$CellContext`u$$, $CellContext`v$$]]}, Axes -> True,
         PlotRange -> {{-$CellContext`range, $CellContext`range}, \
{-$CellContext`range, $CellContext`range}}], 
      "Specifications" :> {{{$CellContext`u$$, 0.5}, 0, 1, Appearance -> 
         "Open"}, {{$CellContext`v$$, 0.5}, 0, 1, Appearance -> "Open"}}, 
      "Options" :> {
       FrameLabel -> {
         " ", " ", "Barycentric coordinates / Linear interpolation", " "}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{648., {438., 445.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.584735959130458*^9, {3.5847360019005175`*^9, 3.5847361193866887`*^9}, 
   3.5847362077468123`*^9, {3.5847363335069885`*^9, 3.58473634928701*^9}, {
   3.5847364387071357`*^9, 3.584736449627151*^9}, 3.5847364967072167`*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1112, 680},
WindowMargins->{{Automatic, 90}, {Automatic, -69}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 691, 12, 107, "Subtitle"],
Cell[1273, 36, 297, 7, 48, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1595, 47, 2947, 76, 252, "Input"],
Cell[4545, 125, 2388, 48, 512, "Output"]
}, Open  ]],
Cell[6948, 176, 90, 1, 43, "Input"],
Cell[CellGroupData[{
Cell[7063, 181, 4186, 110, 503, "Input"],
Cell[11252, 293, 2698, 55, 926, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
