(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     53033,       1019]
NotebookOptionsPosition[     52277,        988]
NotebookOutlinePosition[     52622,       1003]
CellTagsIndexPosition[     52579,       1000]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 "\n"
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
  3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
  3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
  3.5842134956497355`*^9, 3.5842135862546945`*^9}},
 FontFamily->"Arial"],

Cell[TextData[{
 StyleBox["Bilinear Bezier surfaces",
  FontWeight->"Bold"],
 "\nDisplay a bilinear Bezier surfaces using the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " BernsteinBasis function.\nDemonstrate use of trimmed surfaces using \
RegionFunction function."
}], "Subsubtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.584213508457358*^9}, {3.5842138977632446`*^9, 
   3.5842138981220455`*^9}, {3.584213949492935*^9, 3.584213996199417*^9}, {
   3.584214534384763*^9, 3.5842145386747704`*^9}, {3.5842145968316727`*^9, 
   3.584214614865304*^9}, {3.5842234305427027`*^9, 3.5842234731151776`*^9}, {
   3.584285363332838*^9, 3.5842853886528735`*^9}, {3.5842854384829435`*^9, 
   3.584285440332946*^9}, 3.5842856764032764`*^9},
 FontFamily->"Arial"],

Cell[CellGroupData[{

Cell["\<\

Create surface and display\
\>", "Section",
 CellChangeTimes->{{3.584285308802762*^9, 3.584285347372816*^9}}],

Cell["\<\

Input : bb Bezier control points\
\>", "Text",
 CellChangeTimes->{{3.5842853991928883`*^9, 3.584285426042926*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Bezier", " ", "surface", " ", "control", " ", 
     RowBox[{"mesh", ":", " ", 
      RowBox[{"b_", "00"}]}]}], ",", " ", 
    RowBox[{"b_", "10"}], ",", " ", 
    RowBox[{"b_", "01"}], ",", " ", 
    RowBox[{"b_", "11"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"bb", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}]}], "}"}]}], ";"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "move", " ", "barycenter", " ", "of", " ", "Bezier", " ", "points", " ", 
     "to", " ", "origin"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"center", "=", 
     RowBox[{
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{"bb", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "j"}], "]"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "2"}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "2"}], "}"}]}], "]"}], "/", "4"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"bb", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", 
       RowBox[{
        RowBox[{"bb", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "j"}], "]"}], "]"}], "-", "center"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "2"}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "routine", " ", "to", " ", "evaluate", " ", "the", " ", "surface"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"surf", "[", 
      RowBox[{"u_", ",", "v_"}], "]"}], ":=", " ", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"bb", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "j"}], "]"}], "]"}], "*", 
          RowBox[{"BernsteinBasis", "[", 
           RowBox[{"1", ",", 
            RowBox[{"i", "-", "1"}], ",", "u"}], "]"}], "*", 
          RowBox[{"BernsteinBasis", "[", 
           RowBox[{"1", ",", 
            RowBox[{"j", "-", "1"}], ",", "v"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "2"}], "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "2"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"plot", " ", "the", " ", "control", " ", 
     RowBox[{"net", ":", " ", 
      RowBox[{
       RowBox[{"in", " ", "u"}], "-", 
       RowBox[{"direction", " ", "and", " ", "then", " ", "in", " ", "v"}], 
       "-", "direction"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"netplot", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
        RowBox[{"Map", "[", 
         RowBox[{"Point", ",", "bb"}], "]"}], ",", "Gray", ",", 
        RowBox[{"Line", "[", "bb", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"Transpose", "[", "bb", "]"}], "]"}]}], "}"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"plot", " ", "the", " ", "shaded", " ", "surface"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"surfplot", "=", 
     RowBox[{"ParametricPlot3D", "[", 
      RowBox[{
       RowBox[{"surf", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"Mesh", "\[Rule]", "False"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "display", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"surfplot", ",", "netplot"}], "}"}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
     RowBox[{"ViewPoint", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", 
        RowBox[{"-", "4"}], ",", "5"}], "}"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.499109692210306*^9, 3.4991098565877953`*^9}, {
   3.49910993313713*^9, 3.499109950952361*^9}, {3.49910999634844*^9, 
   3.4991100964850163`*^9}, {3.4991101465299044`*^9, 3.499110163721134*^9}, {
   3.499110345274253*^9, 3.499110423399191*^9}, {3.4991105995859003`*^9, 
   3.4991106596304054`*^9}, {3.499520076193455*^9, 3.4995200792977557`*^9}, {
   3.4995201666393566`*^9, 3.499520184578781*^9}, {3.499520236228726*^9, 
   3.4995202531073847`*^9}, {3.499520450791504*^9, 3.4995204606546736`*^9}, {
   3.499520501426734*^9, 3.499520558739314*^9}, {3.4995207457477803`*^9, 
   3.4995207701682544`*^9}, {3.4995208420729837`*^9, 3.499520853525996*^9}, {
   3.5288111268322735`*^9, 3.5288111331974816`*^9}, {3.5288124730056753`*^9, 
   3.528812526077896*^9}, 3.529097327259808*^9, 3.5290973799411*^9, {
   3.529097454696432*^9, 3.529097465959652*^9}, {3.5290975302941647`*^9, 
   3.5290975353173733`*^9}, {3.529157704488058*^9, 3.529157812471448*^9}, {
   3.5291578502079134`*^9, 3.5291579264920473`*^9}, {3.5291609789726095`*^9, 
   3.5291610059918575`*^9}, {3.529161061746355*^9, 3.5291610697647696`*^9}, {
   3.529161348147258*^9, 3.529161350939663*^9}, {3.52916186146816*^9, 
   3.529161864790966*^9}, {3.5291620858277545`*^9, 3.529162088308159*^9}, 
   3.529166472114661*^9, {3.5292750027825737`*^9, 3.529275016884999*^9}, 
   3.5292752497622075`*^9, {3.5292755292210984`*^9, 3.529275558159149*^9}, 
   3.5292758587560773`*^9, {3.5292759405314207`*^9, 3.5292760216827636`*^9}, {
   3.529276456439927*^9, 3.5292764642399406`*^9}, 3.537364728735965*^9, {
   3.5373647667844315`*^9, 3.53736481712572*^9}, 3.5373649460755467`*^9, {
   3.537364995418433*^9, 3.5373649970408363`*^9}, {3.537365150108305*^9, 
   3.5373651628223276`*^9}, {3.537365382771916*^9, 3.5373656073967104`*^9}, {
   3.537365651201587*^9, 3.5373656608580046`*^9}, {3.5373657029468784`*^9, 
   3.5373657723826003`*^9}, {3.5373658532531424`*^9, 3.537365854329544*^9}, {
   3.53736596560454*^9, 3.5373659679913435`*^9}, {3.5373660047450085`*^9, 
   3.5373660133718233`*^9}, {3.5373660515918903`*^9, 3.53736609681637*^9}, {
   3.5373661336948347`*^9, 3.5373661386712437`*^9}, {3.5373661801205163`*^9, 
   3.537366314701953*^9}, {3.5373663781316643`*^9, 3.537366502120682*^9}, {
   3.5373665353799405`*^9, 3.5373665956740465`*^9}, {3.5373666355789165`*^9, 
   3.537366657590555*^9}, {3.5373666972614245`*^9, 3.5373666980102262`*^9}, 
   3.537366830657259*^9, {3.537366992039542*^9, 3.5373670261100025`*^9}, 
   3.5373670717556825`*^9, {3.5373671040321393`*^9, 3.5373671466826143`*^9}, {
   3.537368513525815*^9, 3.5373685333690495`*^9}, {3.5373795829476585`*^9, 
   3.537379586754065*^9}, {3.5373796227901287`*^9, 3.5373796365337524`*^9}, 
   3.537379829849292*^9, {3.537379907833829*^9, 3.5373799086918306`*^9}, 
   3.5373799531519084`*^9, 3.5373801746566973`*^9, {3.53738020473355*^9, 
   3.537380274356473*^9}, {3.5373803203141537`*^9, 3.537380362964628*^9}, {
   3.537380414413519*^9, 3.537380414600719*^9}, {3.537380677585981*^9, 
   3.5373807451496997`*^9}, {3.5373807828549657`*^9, 
   3.5373807973005915`*^9}, {3.5373809539716663`*^9, 3.537380971459297*^9}, {
   3.5373810478682313`*^9, 3.5373810517838383`*^9}, 3.5373811033575287`*^9, {
   3.537450655838801*^9, 3.5374507062112894`*^9}, {3.537450756786578*^9, 
   3.5374507600157843`*^9}, {3.5374508189682875`*^9, 
   3.5374508233518953`*^9}, {3.5374511730421095`*^9, 3.537451191902542*^9}, {
   3.537451311944753*^9, 3.537451313863557*^9}, {3.5374535116306133`*^9, 
   3.537453633342027*^9}, {3.5375377485765986`*^9, 3.537537750479802*^9}, {
   3.5376327936452637`*^9, 3.537632899179449*^9}, {3.537632929443502*^9, 
   3.537632952125942*^9}, {3.537633177015937*^9, 3.5376331776399384`*^9}, 
   3.537633271186903*^9, {3.537633378951892*^9, 3.53763348589008*^9}, {
   3.537633619457515*^9, 3.5376336724976077`*^9}, {3.537633728064905*^9, 
   3.537633764522169*^9}, {3.5376338038810387`*^9, 3.537633853036725*^9}, {
   3.537633887216385*^9, 3.53763394674609*^9}, {3.537633992032969*^9, 
   3.537634019894618*^9}, {3.5376340612346907`*^9, 3.537634063013094*^9}, {
   3.537634156192057*^9, 3.537634175177291*^9}, {3.537634792345575*^9, 
   3.537634809318404*^9}, 3.53763484097086*^9, {3.584214089830782*^9, 
   3.584214146802082*^9}, {3.5842141947721663`*^9, 3.5842143018351545`*^9}, {
   3.5842144326569843`*^9, 3.58421444719621*^9}, {3.584214659808983*^9, 
   3.584214667811797*^9}},
 FontFamily->"Courier New"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx1mAtQVFUYgLeXmU7qFPlgLLTUwOgxiWK1caeomag0B8cJx54+CJVVQx3N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    "], {
     {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJwBCQX2+iFib1JiAgAAAKgBAAADAAAA4gIRFQUGEgIDEwMEFgYHFwcIGgoL
HAwNGAgJGQkKFAQFKhobGwsMKRkaIxMUIBARIRESJBQVJRUWKBgZ7+XkJhYX
JxcYHQ0OKxscLBwdPy8wRzc4MSEiLR0eMiIjNCQlNycoMyMkNSUmNiYnLx8g
MCAhOCgpOSkqQDAxPCwtPi4vQTEyIhITQjIzRDQ1OiorOyssQzM0RTU2gHBx
RjY3f29wTj4/Sjo7Szs8Tz9AUEBBU0NEVUVGUUFCUkJDTT0+Y1NUVERFYlJT
XExNWEhJWUlKXU1OXk5PYVFSV0dIX09QYFBRVkZHZFRVZVVWd2doSTk6aVla
ZlZXa1tcbV1ecGBhbFxdbl5fb19gZ1dYaFhZcWFicmJjeGhpdWVmdmZnempr
SDg5e2tsfW1uc2NkdGRlfGxtfm5vWkpLgXFyzb2+hnZ3g3N0hHR1nIyNh3d4
inp7i3t8jHx9jX1+hXV2iXl6jn5/kICBlYWGkoKDk4OEloaHmIiJm4uMkYGC
mYmKmoqLj3+A8PjnnY2On4+Qo5OUoJCRoZGSno6PpJSVp5eYqJiZqZmaqpqb
opKTq5ucrJydrZ2er5+gsKChsaGisqKjlISFs6OkuKiprp6ftqant6eotKSl
gnJzuamqu6uswLCxva2uvq6vwbGywrKzxra3yLi5w7O0xbW2v6+w1sbHx7e4
1cXGzr6/y7u8zLy9z7/A0MDB5sXUyrq70cHC0sLDybm618fI2MjJCBgXvKyt
3MzN2cnK3c3O38/Q4+IQ3s7P4NDR7ejS2srL28vMAhIRAxMSCRkYBhYVBxcW
ChoZuqqrCxsaDR0cBBQTBRUUDBwb5B0OECAfESEgEiIhFCQjFSUkFiYlFycm
GCgnGSkoGiopGysqHCwrHS0sHy8uIDAvITEwIjIxIzMyJDQzJTU0JjY1Jzc2
KDg3KTk4Kjo5Kzs6LDw7Lj49Lz8+M0NCMEA/MUFASVlYNERDNkZFN0dGOEhH
OUlIMkJBOkpJO0tKPU1MP09OQFBPQVFQQlJRSFhXQ1NSR1dWPk5NRVVURlZV
RFRTNUVESlpZbn59TV1cTl5dT19eUGBfUWFgUmJhU2NiVGRjVWVkVmZlV2dm
WGhnWWloW2tqXGxrXW1sXm5tX29uYHBvYXFwYnJxY3NyZHRzZXV0ZnZ1Z3d2
bHx7aHh3anp5TFxbbX18b39+cIB/cYGAcoKBa3t6c4OCdISDdYWEd4eGeYmI
eoqJe4uKgZGQfIyLgJCPdoaFfo6Nf4+OfY2MEyMigpKRhJSTiZmYhZWUhpaV
ipqZi5uajp6dkKCfjJybjZ2ciJiXnq6tj5+ena2sl6emk6OilKSjmKinmamo
nKyrkqKhmqqpm6uqkaGgn6+uoLCvssLBu8vKpLSzobGwpra1qLi3q7u6p7e2
qbm4qrq5orKxo7OyrLy7rb28s8PCsMC/scHAtcXElaWktsbFuMjHrr69r7++
t8fGucnIusrJvMzLg5OSwdHQvs7Nv8/OwtLR8Ofmx9fWydnYxdXUxtbVwNDP
yNjXytrZ6+QOzNzbzd3czt7dz9/eHeQe0ODf8u7jy9va7uriEOIR6ODRpZWW
5OUe+fHhvc3M8eno7ObU6Ong8+/r9u4B4uoC9PDs9fHt5ufE0ujR4+7i9+8P
7vIB7PDm7fHo7/MPxebE8PTT7vbq6+/k+PDT8fXh7/fl8fnpl2heKQ==
        "]]]}, {}, {}, {}, {}},
    VertexNormals->CompressedData["
1:eJxVWAk0lWsblVJKiZRM4YpQaNJAnOeSIq5CSYQGVKIy1c0YTYZCUqRScUmp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     "]], 
   {RGBColor[1, 0, 0], PointSize[
    Large], {Point3DBox[
      NCache[{{Rational[-1, 2], Rational[-1, 2], Rational[-1, 4]}, {
        Rational[1, 2], Rational[-1, 2], 
         Rational[-1, 4]}}, {{-0.5, -0.5, -0.25}, {0.5, -0.5, -0.25}}]], 
     Point3DBox[
      NCache[{{Rational[-1, 2], Rational[1, 2], Rational[-1, 4]}, {
        Rational[1, 2], Rational[1, 2], Rational[3, 4]}}, {{-0.5, 
       0.5, -0.25}, {0.5, 0.5, 0.75}}]]}, 
    {GrayLevel[0.5], 
     Line3DBox[
      NCache[{{{Rational[-1, 2], Rational[-1, 2], Rational[-1, 4]}, {
         Rational[1, 2], Rational[-1, 2], Rational[-1, 4]}}, {{
         Rational[-1, 2], Rational[1, 2], Rational[-1, 4]}, {
         Rational[1, 2], Rational[1, 2], Rational[
          3, 4]}}}, {{{-0.5, -0.5, -0.25}, {0.5, -0.5, -0.25}}, {{-0.5, 
       0.5, -0.25}, {0.5, 0.5, 0.75}}}]], 
     Line3DBox[
      NCache[{{{Rational[-1, 2], Rational[-1, 2], Rational[-1, 4]}, {
         Rational[-1, 2], Rational[1, 2], Rational[-1, 4]}}, {{
         Rational[1, 2], Rational[-1, 2], Rational[-1, 4]}, {
         Rational[1, 2], Rational[1, 2], Rational[
          3, 4]}}}, {{{-0.5, -0.5, -0.25}, {-0.5, 0.5, -0.25}}, {{
       0.5, -0.5, -0.25}, {0.5, 0.5, 0.75}}}]]}}},
  AutomaticImageSize->True,
  Boxed->False,
  ImageSize->{409.65571137179836`, 457.9820693663037},
  PlotRange->{{-0.49999992857142866`, 
   0.49999992857142866`}, {-0.4999999285714286, 
   0.49999992857142866`}, {-0.24999999999999492`, 0.7499998571428623}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  ViewPoint->{-3.8274588266272946`, 4.0713616806557695`, 3.7114111865651105`},
  ViewVertical->{-0.697643599296544, -0.04294784137991681, 
   0.7151565501911933}]], "Output",
 CellChangeTimes->{
  3.537633274275708*^9, 3.5376333830234995`*^9, {3.5376334341291895`*^9, 
   3.5376334873720827`*^9}, {3.5376337458645363`*^9, 
   3.5376337667841735`*^9}, {3.5376338117902527`*^9, 
   3.5376338551271286`*^9}, {3.537633896607601*^9, 3.5376339489924936`*^9}, {
   3.5376339991777816`*^9, 3.5376340220630217`*^9}, 3.537634066008299*^9, {
   3.537634158360461*^9, 3.5376341786560965`*^9}, {3.537634763391924*^9, 
   3.5376348109564075`*^9}, 3.537634842608863*^9, 3.584212561161294*^9, 
   3.584214452157018*^9, 3.5842146810718203`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Repeat surface display, but display only a region of the surface, using \
RegionFunction.\
\>", "Section",
 CellChangeTimes->{{3.5376344587233887`*^9, 3.5376345006250625`*^9}, {
  3.537635029255191*^9, 3.537635035776003*^9}, {3.584285459062972*^9, 
  3.5842854648629804`*^9}},
 FontFamily->"Arial",
 FontSize->18],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"surfplot", "=", 
   RowBox[{"ParametricPlot3D", "[", 
    RowBox[{
     RowBox[{"surf", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"RegionFunction", "\[Rule]", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "2"}], "+", 
          RowBox[{"y", "^", "2"}]}], "<", ".2"}]}], "]"}]}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}], ",", " ", 
     RowBox[{"Mesh", "\[Rule]", "False"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", "surfplot", "}"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.5376345337127204`*^9, 3.537634585785612*^9}, {
   3.5376346299804897`*^9, 3.537634689541394*^9}, {3.5376347218646507`*^9, 
   3.5376347378078785`*^9}, {3.537634822406828*^9, 3.5376348261664343`*^9}, 
   3.53763485830249*^9, 3.5376349415362372`*^9, {3.5376351835862627`*^9, 
   3.5376351915890765`*^9}, {3.5376352394187603`*^9, 3.537635283988039*^9}, 
   3.584214470970651*^9},
 FontFamily->"Courier New"],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1mntYVdXWxrEQTU1S6HI4KVp8JqaUZhrCYR5FPViGJpV3M1FDdGtpHc20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   "], {
    {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNmXec1sURxnfoHMU7EGmHdDiEowoCKh1OEEMVkSrIIb1IFwtKKMbEqMQS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        "]], Polygon3DBox[CompressedData["
1:eJwtlNlvTVEUh9eq2z/Eq1fUHAklMTemeBBDTQ9okVCtaoO2hpqKapU2hjTU
2LqG3LbU0NJSMy9ekfCG8My38ttJv5zv9tyzzt57/dYdWVy6sCTPzGZDBja5
2T7oxlthAn4UBvFL0IifhiN4EWzBl8Bz/CJMjHvwDK+BMfh+eIxXwTBeBI/w
fK7joB6e8nkPdOG3oBb/BgX4YRjAz5uenQE5U43R+CF4gp+FA/hBl4+Abrw9
9oD/gsn4cXiJX4FmfHu8E38Dy/G58MC0xzl4XdTER8EZvAJu4+9hHj4duvCH
pmenwXVTjauuM4i9fzHdy7nWEt9pw1uh3LSn1a6aUasBTuEnoTBqwTp8PvTF
PdiGL4MhvB2m4MfghWnN8d1CuGN6phSvgR78ApzAG6AA74C1+G7I4h/ijPBe
+B1nBX9hJp/Loh7XNbDetZZ38AO+m+pl+f9emAX8WUvkzNWDOPvPpmxNcq09
MhZZ2OjKXmRiEG+CYTyP6w5YAa9MPYu99sM/055bYu+QgU98LnP1OHrbCQOu
NWbTnoe4XobGyEt6doHLMyl7413Zjgz+SWfQl87gnmuNsbafpmxNdZ1lZCxm
ocR11jETkdWx0GYps/g5uG+qV4VvgI+mnt2Ne6l2PVS79hh7i2di9ra6ZjNm
sAO/5spapeldN+Cr6Z3lqWfRq8jsLnwVvDVlusc1o/mp5zcjy1BtqlGLL3XN
dm9kKM7G1cs6U7YWu2Y5MlbpmpmYlcjUSrzYle3XsAjf7JrtftNadrp6FWuK
3na6fguix/8BMT+r/Q==
        "]]}]}, {}, {}, {}, {}},
   VertexNormals->CompressedData["
1:eJxVl3c81t/7x42SkJImQiQjoiWKrkgKKSkZoaWMJlqISiFlVEQlLYokWyEc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    "]],
  AutomaticImageSize->True,
  Boxed->False,
  ImageSize->{336.7225508366433, 401.56462988980314`},
  PlotRange->{{-0.44642850765306125`, 
   0.44712605219626933`}, {-0.4471260521962691, 
   0.44642850765306147`}, {-0.2260841547922736, 0.41624349886862766`}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  ViewPoint->{2.670262082775642, -0.8597605978411422, 0.3612646172690208},
  ViewVertical->{0.9073911907650878, -0.41155861593004983`, 
   0.11853720322608753`}]], "Output",
 CellChangeTimes->{
  3.5376347012570148`*^9, {3.53763473283147*^9, 3.5376347402882833`*^9}, 
   3.537634828865239*^9, 3.537634860923295*^9, 3.5376349441726418`*^9, 
   3.537635194163081*^9, {3.5376352416339645`*^9, 3.537635285969242*^9}, 
   3.584212562034896*^9, {3.584214452687419*^9, 3.5842144727802544`*^9}, 
   3.584214681539821*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1256, 633},
WindowMargins->{{Automatic, 116}, {41, Automatic}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 673, 13, 135, "Subtitle"],
Cell[1243, 37, 970, 18, 68, "Subsubtitle"],
Cell[CellGroupData[{
Cell[2238, 59, 120, 4, 97, "Section"],
Cell[2361, 65, 125, 4, 45, "Text"],
Cell[CellGroupData[{
Cell[2511, 73, 9257, 196, 372, "Input"],
Cell[11771, 271, 13514, 234, 473, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25334, 511, 323, 8, 102, "Section"],
Cell[CellGroupData[{
Cell[25682, 523, 1459, 37, 78, "Input"],
Cell[27144, 562, 25093, 421, 625, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
