(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     57767,       1178]
NotebookOptionsPosition[     56774,       1139]
NotebookOutlinePosition[     57117,       1154]
CellTagsIndexPosition[     57074,       1151]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", Cell[TextData[{
   StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
    FontWeight->"Bold",
    FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
   StyleBox[
   "\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis Group, An A \
K Peters Book, 2013",
    FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
   "\n"
  }], "Subtitle",
   CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
    3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
    3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
    3.5842134956497355`*^9, 3.5842135862546945`*^9}},
   FontFamily->"Arial"]}]], "Subtitle",
 CellChangeTimes->{{3.584223535343687*^9, 3.584223561489333*^9}}],

Cell[TextData[{
 StyleBox["B-spline surface functions",
  FontWeight->"Bold"],
 "\n1) Display the surface, \n2) Display an isoparametric curve, and \n3) \
Find the interpolating B-spline surface to input data points\n"
}], "Subsubtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
  3.584223662873911*^9, 3.5842236838715477`*^9}, {3.584223797221347*^9, 
  3.584223800169752*^9}, {3.584224461298913*^9, 3.5842245844767294`*^9}, {
  3.584224646564839*^9, 3.5842246629916677`*^9}},
 FontFamily->"Arial"],

Cell[CellGroupData[{

Cell["\<\

B - spline surface display\
\>", "Section",
 CellChangeTimes->{{3.5842240053413124`*^9, 3.584224027867752*^9}, {
  3.584224649466444*^9, 3.584224649934445*^9}, {3.584224688809713*^9, 
  3.5842247464206142`*^9}, {3.5842248142183332`*^9, 3.584224823359949*^9}}],

Cell["\<\

Input : 
nu, nv-- degree in u and v parametric directions
llu, llv-- number of segments
knotsu, knotsv-- knot sequences, generated as uniform
dd-- control points, created to form an interesting shape

Output : Display\
\>", "Text",
 CellChangeTimes->{{3.584224809709925*^9, 3.5842248324547653`*^9}, {
  3.5842248758228416`*^9, 3.584224883310855*^9}, {3.584277012601777*^9, 
  3.5842770308518023`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Define", " ", "basic", " ", "elements", " ", "of", " ", "a", " ", "B"}], 
    "-", 
    RowBox[{"spline", " ", "surface"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"nu", "=", "3"}], ";"}], "  ", 
   RowBox[{"(*", 
    RowBox[{"u", "-", "degree"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nv", "=", "3"}], ";"}], " ", 
   RowBox[{"(*", 
    RowBox[{"v", "-", "degree"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"llu", "=", "4"}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"number", " ", "of", " ", "domain", " ", "intervals"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"llv", "=", "6"}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"number", " ", "of", " ", "domain", " ", "intervals"}], " ", 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"u", ",", 
     RowBox[{"v", "-", " ", 
      RowBox[{"knot", " ", 
       RowBox[{"sequences", ":"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"uniform", " ", "with", " ", "nu"}], "+", 
     RowBox[{"1", " ", "and", " ", "nv"}], "+", 
     RowBox[{"1", " ", "repeated", " ", "knots", " ", "at", " ", "ends"}]}], 
    "  ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"knotu", " ", "=", " ", 
     RowBox[{
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "0", ",", "nu"}], "}"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"i", "/", "llu"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", 
            RowBox[{"llu", "-", "1"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "0", ",", "nu"}], "}"}]}], "]"}]}], "]"}], "//", 
      "N"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"knotv", " ", "=", " ", 
     RowBox[{
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{"0", ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "0", ",", "nv"}], "}"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"i", "/", "llv"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", 
            RowBox[{"llv", "-", "1"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "0", ",", "nv"}], "}"}]}], "]"}]}], "]"}], "//", 
      "N"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"B", "-", 
     RowBox[{"spline", " ", "control", " ", 
      RowBox[{"grid", ":"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dd", "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"Sqrt", "[", "i", "]"}], "*", 
           RowBox[{"Cos", "[", "j", "]"}]}], ",", 
          RowBox[{
           RowBox[{"Sqrt", "[", "i", "]"}], "*", 
           RowBox[{"Sin", "[", "j", "]"}]}], ",", 
          RowBox[{".5", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", "^", "2"}], "+", 
              RowBox[{"i", "^", "2"}]}], ")"}], "]"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"nu", "+", "llu"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "1", ",", 
          RowBox[{"nv", "+", "llv"}]}], "}"}]}], "]"}], "//", "N"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"netplot", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Red", ",", 
        RowBox[{"Map", "[", 
         RowBox[{"Point", ",", "dd"}], "]"}], ",", "Gray", ",", 
        RowBox[{"Line", "[", "dd", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"Transpose", "[", "dd", "]"}], "]"}]}], "}"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"surfplot", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"BSplineSurface", "[", 
       RowBox[{"dd", ",", 
        RowBox[{"SplineKnots", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"knotu", ",", "knotv"}], "}"}]}], ",", 
        RowBox[{"SplineDegree", "\[Rule]", " ", 
         RowBox[{"{", 
          RowBox[{"nu", ",", "nv"}], "}"}]}]}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"surfplot", ",", "netplot"}], "}"}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.499109692210306*^9, 3.4991098565877953`*^9}, {
   3.49910993313713*^9, 3.499109950952361*^9}, {3.49910999634844*^9, 
   3.4991100964850163`*^9}, {3.4991101465299044`*^9, 3.499110163721134*^9}, {
   3.499110345274253*^9, 3.499110423399191*^9}, {3.4991105995859003`*^9, 
   3.4991106596304054`*^9}, {3.499520076193455*^9, 3.4995200792977557`*^9}, {
   3.4995201666393566`*^9, 3.499520184578781*^9}, {3.499520236228726*^9, 
   3.4995202531073847`*^9}, {3.499520450791504*^9, 3.4995204606546736`*^9}, {
   3.499520501426734*^9, 3.499520558739314*^9}, {3.4995207457477803`*^9, 
   3.4995207701682544`*^9}, {3.4995208420729837`*^9, 3.499520853525996*^9}, {
   3.5288111268322735`*^9, 3.5288111331974816`*^9}, {3.5288124730056753`*^9, 
   3.528812526077896*^9}, 3.529097327259808*^9, 3.5290973799411*^9, {
   3.529097454696432*^9, 3.529097465959652*^9}, {3.5290975302941647`*^9, 
   3.5290975353173733`*^9}, {3.529157704488058*^9, 3.529157812471448*^9}, {
   3.5291578502079134`*^9, 3.5291579264920473`*^9}, {3.5291609789726095`*^9, 
   3.5291610059918575`*^9}, {3.529161061746355*^9, 3.5291610697647696`*^9}, {
   3.529161348147258*^9, 3.529161350939663*^9}, {3.52916186146816*^9, 
   3.529161864790966*^9}, {3.5291620858277545`*^9, 3.529162088308159*^9}, 
   3.529166472114661*^9, {3.5292750027825737`*^9, 3.529275016884999*^9}, 
   3.5292752497622075`*^9, {3.5292755292210984`*^9, 3.529275558159149*^9}, 
   3.5292758587560773`*^9, {3.5292759405314207`*^9, 3.5292760216827636`*^9}, {
   3.529276456439927*^9, 3.5292764642399406`*^9}, {3.562965121782059*^9, 
   3.5629651422495213`*^9}, {3.5629657982743444`*^9, 
   3.5629658030168962`*^9}, {3.5629665077583203`*^9, 3.562966511471168*^9}, {
   3.5630374115775447`*^9, 3.563037413590177*^9}, 3.563037449536724*^9, 
   3.563052035161214*^9, 3.563052192567232*^9, 3.5630522634701414`*^9, 
   3.56305229613696*^9, {3.563052345885998*^9, 3.5630523489748373`*^9}, 
   3.5630524280834513`*^9, 3.563052492309475*^9, {3.5630525305143647`*^9, 
   3.563052555646287*^9}, {3.5630526578119965`*^9, 3.5630526732873955`*^9}, 
   3.563052717638764*^9, {3.563052766217787*^9, 3.563052787090854*^9}, 
   3.5630528200616875`*^9, {3.5630528694987216`*^9, 3.563052913460085*^9}, {
   3.563052950198556*^9, 3.5630529707596197`*^9}, {3.563055893027895*^9, 
   3.563055934337225*^9}, {3.563056014225849*^9, 3.563056028515632*^9}, 
   3.5630561003857536`*^9, {3.563056180835985*^9, 3.563056206498314*^9}, {
   3.5630562634702444`*^9, 3.563056267479496*^9}, {3.563056400315199*^9, 
   3.5630564627939997`*^9}, {3.563056506708563*^9, 3.563056549031905*^9}, {
   3.5630565930244694`*^9, 3.5630566350826087`*^9}, 3.5630566743171115`*^9, {
   3.5630586257073455`*^9, 3.5630586276573706`*^9}, {3.5630586799336405`*^9, 
   3.5630586874997377`*^9}, {3.5630587236142006`*^9, 
   3.5630587464060926`*^9}, {3.563058781834147*^9, 3.563058800320384*^9}, {
   3.563058834968428*^9, 3.5630588387436767`*^9}, {3.5630589052629294`*^9, 
   3.563058907088153*^9}, 3.5630682342433696`*^9, 3.563115896901076*^9, {
   3.5646781149053555`*^9, 3.5646781343117895`*^9}, {3.584223692529563*^9, 
   3.5842237707013006`*^9}},
 FontFamily->"Courier New"],

Cell[BoxData[
 Graphics3DBox[{BSplineSurface3DBox[CompressedData["
1:eJw903lQk0cYBvBEYkgYFAIBPBCCUqAFiwIVFOq7IKgc4ggUtTojBkEoWBEK
xYNL60BDK3VAKZVDQ4emVSIT1NZybKRIPbBABuQognIZY4MEkkASgdrm+7Iz
O7N/7Tz77O914B6PiDOiUCjG7zbz3f7vXEi/beYS8gImTZlFUXIZPPHNia+8
OgFLUyP3OvEH8PZbXTL1CjkIlKVXvhxVgGT8fDNN+AYf6LlzzMe8BSIPDGzZ
F6aBe45/02tkY1hoN/jsrrcUG8tvxptlU1B/SFLKeWcJeJY9V+XdnMRqd4tD
cXE0pFqbyfz17iSI+XU8xYsuvHkwth5HMZANp79y1l4KDJNjLQz6OIhN7Clt
O01RiXssbq5qwac7XK5KBG+g8/fD8NzeHCWtrKnROsvxRXfTTU4xA+A4159y
wNYCzUu2deWnSWFdhodlhMmMIX/48l8ULj0jmFt3pnxTsZJ4rxrebzriWhOv
xvZdjCp+4UOY2X840LXvLbSX9/ZVlMjx4raSkCF7BdbfQ0UfNX+ddPlGP5yS
if4UilR4pl/wYwJvKYrpssybuKuCx6XPSjeE9GN9P0wEqqRslpkC0qM9zu9r
kMMrXQanx24Z6jmYvLo8+hFmSLz4Gq4a9L2Zo5fccl53hRK7Xfu8OKtmBH74
8DuHhBQLdHHXb9OR03KQn5y+1L5n1tB/cmTEcJ35S1zEec1e8NAY8l+/45l4
+rgO7xFSs7jBHTCQPNyeMUdBlY/y3wasmcbpS648sNMoMeX/RUNuhRc2NJ8Y
htSzBXdYxVrMr65fNh5hjHwCHW9Jr2hhTRib7asZwm8nYxM9e0wQj5F4tHBM
CXuVX6VrvaYhpbVi87cZy1HrXDl9ntOJ5TeKs3Wf6aCaLRTkW7NQztCugQXQ
YAcfalxB7wRkt65zC9BYIL1DBeFQC6QfvUMZ4XAeyP71DhcJhxIg8+sdKgmH
c1j/v3TC4QjhcAFTFqvK2suZhMMFwuELrO/NlHA4RzhUGbzpHUoIh4tEHhbh
cJ5wKANudGxWhcgSxTc2SEujZqD2Vk2AdtUCkP7P5Dd+8k+bHA9l8ukrAymI
9NPGZ8ZU36aKS7zS1jA9uoHsf7DpSG8tdxafaK5dm2epM+Tn1K7wtA4bg6Br
8c0Hnalicl767E/msNZTkWvm5bHQhVGc8EW4jehjM3S0B2mn5rSg4a1nh+XN
QjjVWxvrxUIpDx9vz5V0Yx8nVWeDiIr887ltHkMWyLmC3pQVRhGHjrw36pAl
h4LcjJ6DpWxUFEIvfeWmAinje3ZwFgWR89uS7L4Fdk9hQe6Ow7wuKiL934iu
N/s03khs+3AyN8v+KZB+/FeuWM6u1OBTq6w/sPp53tD/heSf7Iz9JiAkKYqV
82iJmMwvOxS3FXcuQTuv6qw7J8ax3rM5skXTal3hPPh3aBIrscYwL1tdjmcG
dTzF9e68AtdYI6R3wkb19z3XNw5QxX6O93O7naYgwyg4jcO3QqMs6Ub/YTV8
s1GQeLaDisg+687k+T2oUGBhWu0oHYwQOb9uAtpEkJImbokpaw0c7zX4b2zc
f6/gug77Bfk2NNAoYtLPXzLvRhuaFNQ2kWaToTQx2X+VxcVUYQQNcdJ3d5gK
XmIyf7hnaAJTtggpKm+rPzp0EBl1s4zXbolszxUFr63uw6O+l1Y/naKhTZ2S
TH6AFdINNu1Q7TQSC7ZtyOGkKuC1hahB9MQa/QtKe9+w
    "],
    SplineDegree->{3, 3},
    SplineKnots->{{0., 0., 0., 0., 0.25, 0.5, 0.75, 1., 1., 1., 1.}, {0., 0., 
      0., 0., 0.16666666666666666`, 0.3333333333333333, 0.5, 
      0.6666666666666666, 0.8333333333333334, 1., 1., 1., 1.}}], 
   {RGBColor[1, 0, 0], PointSize[
    Medium], {
     Point3DBox[{{0.5403023058681397, 0.8414709848078965, 
      0.7071067811865476}, {-0.4161468365471424, 0.9092974268256817, 
      1.118033988749895}, {-0.9899924966004454, 0.1411200080598672, 
      1.5811388300841898`}, {-0.6536436208636119, -0.7568024953079282, 
      2.0615528128088303`}, {0.28366218546322625`, -0.9589242746631385, 
      2.5495097567963922`}, {0.960170286650366, -0.27941549819892586`, 
      3.0413812651491097`}, {0.7539022543433046, 0.6569865987187891, 
      3.5355339059327378`}, {-0.14550003380861354`, 0.9893582466233818, 
      4.031128874149275}, {-0.9111302618846769, 0.4121184852417566, 
      4.527692569068709}}], 
     Point3DBox[{{0.7641028487401794, 1.190019679058772, 
      1.118033988749895}, {-0.5885205001836284, 1.2859407532478362`, 
      1.4142135623730951`}, {-1.4000608153399503`, 0.19957382932046472`, 
      1.8027756377319946`}, {-0.9243916735839774, -1.0702803529022729`, 
      2.23606797749979}, {0.4011589098144868, -1.3561237145173934`, 
      2.692582403567252}, {1.35788584156861, -0.39515318709015607`, 
      3.1622776601683795`}, {1.066178792795952, 0.9291193582054819, 
      3.640054944640259}, {-0.20576812113788515`, 1.399163850420452, 
      4.123105625617661}, {-1.28853277344586, 0.5828235511335484, 
      4.6097722286464435`}}], 
     Point3DBox[{{0.9358310452102377, 1.4574704987822955`, 
      1.5811388300841898`}, {-0.7207874643087115, 1.574949342453724, 
      1.8027756377319946`}, {-1.7147173032239305`, 0.24442702392421947`, 
      2.121320343559643}, {-1.132143961379064, -1.3108203731682384`, 2.5}, {
      0.4913173174083336, -1.6609055643276887`, 2.9154759474226504`}, {
      1.6630637203964067`, -0.4839618393027097, 3.3541019662496847`}, {
      1.3057970084633177`, 1.1379341688728084`, 
      3.8078865529319543`}, {-0.252013451059508, 1.7136187500389568`, 
      4.272001872658765}, {-1.5781239058977972`, 0.7138101551770469, 
      4.743416490252569}}], 
     Point3DBox[{{1.0806046117362793`, 1.682941969615793, 
      2.0615528128088303`}, {-0.8322936730942848, 1.8185948536513634`, 
      2.23606797749979}, {-1.9799849932008908`, 0.2822400161197344, 
      2.5}, {-1.3072872417272239`, -1.5136049906158564`, 
      2.8284271247461903`}, {0.5673243709264525, -1.917848549326277, 
      3.2015621187164243`}, {1.920340573300732, -0.5588309963978517, 
      3.605551275463989}, {1.5078045086866092`, 1.3139731974375781`, 
      4.031128874149275}, {-0.2910000676172271, 1.9787164932467636`, 
      4.47213595499958}, {-1.8222605237693539`, 0.8242369704835132, 
      4.924428900898052}}], 
     Point3DBox[{{1.208152684321044, 1.8815863231241494`, 
      2.5495097567963922`}, {-0.9305326151409044, 2.0332508581478654`, 
      2.692582403567252}, {-2.2136905196133254`, 0.3155539310071813, 
      2.9154759474226504`}, {-1.4615915693101362`, -1.6922618250499932`, 
      3.2015621187164243`}, {0.6342879293419266, -2.144219863421457, 
      3.5355339059327378`}, {2.1470060309256773`, -0.6247920479397683, 
      3.905124837953327}, {1.6857766891019652`, 1.4690666950415887`, 
      4.301162633521313}, {-0.3253479663245775, 2.2122722935498835`, 
      4.716990566028302}, {-2.0373492019313235`, 0.9215249477848116, 
      5.1478150704935}}], 
     Point3DBox[{{1.3234649562261074`, 2.061174546136602, 
      3.0413812651491097`}, {-1.019347407613893, 2.2273147201486445`, 
      3.1622776601683795`}, {-2.424976465855101, 0.34567201224412414`, 
      3.3541019662496847`}, {-1.6010933447410738`, -1.8537799495694842`, 
      3.605551275463989}, {0.6948276137076321, -2.3488751748931564`, 
      3.905124837953327}, {2.3519272684752552`, -0.6844253968129204, 
      4.242640687119286}, {1.846675839075039, 1.6092819347076814`, 
      4.6097722286464435`}, {-0.3564008403888045, 2.4234228770419235`, 
      5.}, {-2.2318042308258668`, 1.0094800024110233`, 5.4083269131959835`}}],
      Point3DBox[{{1.429505534121852, 2.2263229612783046`, 
      3.5355339059327378`}, {-1.1010210383899839`, 2.4057748591717063`, 
      3.640054944640259}, {-2.6192739458247356`, 0.3733684463418393, 
      3.8078865529319543`}, {-1.7293784668689076`, -2.0023111941779046`, 
      4.031128874149275}, {0.750499599088778, -2.5370751569016603`, 
      4.301162633521313}, {2.54037179475047, -0.7392639206915739, 
      4.6097722286464435`}, {1.9946378778433487`, 1.7382231549121023`, 
      4.949747468305833}, {-0.38495690520908155`, 2.617595878116377, 
      5.315072906367325}, {-2.410624084932008, 1.0903630226423306`, 
      5.70087712549569}}]}, 
    {GrayLevel[0.5], Line3DBox[CompressedData["
1:eJw903lQk0cYBvBEYkgYFAIBPBCCUqAFiwIVFOq7IKgc4ggUtTojBkEoWBEK
xYNL60BDK3VAKZVDQ4emVSIT1NZybKRIPbBABuQognIZY4MEkkASgdrm+7Iz
O7N/7Tz77O914B6PiDOiUCjG7zbz3f7vXEi/beYS8gImTZlFUXIZPPHNia+8
OgFLUyP3OvEH8PZbXTL1CjkIlKVXvhxVgGT8fDNN+AYf6LlzzMe8BSIPDGzZ
F6aBe45/02tkY1hoN/jsrrcUG8tvxptlU1B/SFLKeWcJeJY9V+XdnMRqd4tD
cXE0pFqbyfz17iSI+XU8xYsuvHkwth5HMZANp79y1l4KDJNjLQz6OIhN7Clt
O01RiXssbq5qwac7XK5KBG+g8/fD8NzeHCWtrKnROsvxRXfTTU4xA+A4159y
wNYCzUu2deWnSWFdhodlhMmMIX/48l8ULj0jmFt3pnxTsZJ4rxrebzriWhOv
xvZdjCp+4UOY2X840LXvLbSX9/ZVlMjx4raSkCF7BdbfQ0UfNX+ddPlGP5yS
if4UilR4pl/wYwJvKYrpssybuKuCx6XPSjeE9GN9P0wEqqRslpkC0qM9zu9r
kMMrXQanx24Z6jmYvLo8+hFmSLz4Gq4a9L2Zo5fccl53hRK7Xfu8OKtmBH74
8DuHhBQLdHHXb9OR03KQn5y+1L5n1tB/cmTEcJ35S1zEec1e8NAY8l+/45l4
+rgO7xFSs7jBHTCQPNyeMUdBlY/y3wasmcbpS648sNMoMeX/RUNuhRc2NJ8Y
htSzBXdYxVrMr65fNh5hjHwCHW9Jr2hhTRib7asZwm8nYxM9e0wQj5F4tHBM
CXuVX6VrvaYhpbVi87cZy1HrXDl9ntOJ5TeKs3Wf6aCaLRTkW7NQztCugQXQ
YAcfalxB7wRkt65zC9BYIL1DBeFQC6QfvUMZ4XAeyP71DhcJhxIg8+sdKgmH
c1j/v3TC4QjhcAFTFqvK2suZhMMFwuELrO/NlHA4RzhUGbzpHUoIh4tEHhbh
cJ5wKANudGxWhcgSxTc2SEujZqD2Vk2AdtUCkP7P5Dd+8k+bHA9l8ukrAymI
9NPGZ8ZU36aKS7zS1jA9uoHsf7DpSG8tdxafaK5dm2epM+Tn1K7wtA4bg6Br
8c0Hnalicl767E/msNZTkWvm5bHQhVGc8EW4jehjM3S0B2mn5rSg4a1nh+XN
QjjVWxvrxUIpDx9vz5V0Yx8nVWeDiIr887ltHkMWyLmC3pQVRhGHjrw36pAl
h4LcjJ6DpWxUFEIvfeWmAinje3ZwFgWR89uS7L4Fdk9hQe6Ow7wuKiL934iu
N/s03khs+3AyN8v+KZB+/FeuWM6u1OBTq6w/sPp53tD/heSf7Iz9JiAkKYqV
82iJmMwvOxS3FXcuQTuv6qw7J8ax3rM5skXTal3hPPh3aBIrscYwL1tdjmcG
dTzF9e68AtdYI6R3wkb19z3XNw5QxX6O93O7naYgwyg4jcO3QqMs6Ub/YTV8
s1GQeLaDisg+687k+T2oUGBhWu0oHYwQOb9uAtpEkJImbokpaw0c7zX4b2zc
f6/gug77Bfk2NNAoYtLPXzLvRhuaFNQ2kWaToTQx2X+VxcVUYQQNcdJ3d5gK
XmIyf7hnaAJTtggpKm+rPzp0EBl1s4zXbolszxUFr63uw6O+l1Y/naKhTZ2S
TH6AFdINNu1Q7TQSC7ZtyOGkKuC1hahB9MQa/QtKe9+w
      "]], Line3DBox[CompressedData["
1:eJw9lHlQk1cUxROJIWFQCARwQQhKgRYsClRQqPeBoLKII1DU6owYBKFgRSgU
FzatAw2t1AGlVBYNHZpWiUxQW8vyIkXqggUyIEsRlM0YGySQBJII1Dbflzdz
Z95fvzn3nPOeA/d4RJwRhUJhvhvjd/PfvZB+28wl5AVMmjKLouQyeOKbE195
dQLmJdu68tOksC7DwzLCZAYEytIrX44q4OKu36Yjp+UgPzl9qX3PLEQeGNiy
L0wDeo6C4GjBWH4z3iybguIbG6SlUTNQe6smQLtqAdTuFofi4mioKIRe+spN
BVLG9+zgLAraPBhbj6MYaJQl3eg/rIZvNgoSz3ZQkdjEntK20xQtTY3c68Qf
wNtvdcnUK+QGPeHLf1G49Ixgbt2Z8k3FSkK/GpIjI4brzF/iIs5r9oKHBmb2
Hw507XsLeo6M4MwTHCo6k9/4yT9tcjyUyaevDKSgmX7Bjwm8pagl2X0L7J7C
gtwdh3ldVKTfl4nqzuT5PahQYGFa7SgdjNArXQanx24Zkoyfb6YJ3+ADPXeO
+Zi3GPx5v+mIa028Gtt3Mar4hQ8Neq7f8Uw8fVyH9wipWdzgDhhIHm7PmKMQ
nEWCIwHK/4eG2vjMmOrbVHGJV9oapkc38Kvrl41HGKMb0fVmn8YbiW0fTuZm
2T+Ft5OxiZ49JshNQJsIUtLELTFlrYHjvZDSWrH524zl6J7j3/Qa2RgW2g0+
u+stxWRe7eW9fRUlcry4rSRkyF6BSX8qH+W/DVgzjdOXXHlgp1FiUo+eoyQ4
c1jvPx0NNh3preXO4hPNtWvzLHWYslhV1l7ORP4rVyxnV2rwqVXWH1j9PI/1
Ppiixsb99wqu67BfkG9DA40i7vz9MDy3N0f9IUkp550l4Fn2XJV3cxKT/fmo
+eukyzf64ZRM9KdQpMJkXm6FFzY0nxiG1LMFd1jFWkz6o+eMEJwFgx5O7QpP
67AxCLoW33zQmSom+3Yh+Sc7Y78JCEmKYuU8WiJO+CLcRvSxGfpL5t1oQ5OC
2ibSbDKUJg6nemtjvVhItTaT+evdSRDz63iKF12Y7HNMl2XexF0VPC59Vroh
pB+T/fEJdLwlvaKFNWFstq9mCJN56TkLBOeFwZ8++5M5rPVU5Jp5eSx0YRST
emSH4rbiziVo51WddefEONb3xxxVWVxMFUbQECd9d4ep4CX+4cPvHBJSLJAN
p79y1l4KDJNjLQz6OJD7giopm2WmgPRoj/P7GuRA9pnHSDxaOKaEvcqv0rVe
04b+6DlzBEcFZF5He5B2ak4LGt56dljeLJD+2KJpta5wHvw7NImVWAOknnDP
0ASmbBFSVN5Wf3ToIDLqZhmv3RKVuMfi5qoWfLrD5apE8MbA7zmYvLo8+hFm
SLz4Gq6a+GfMUetcOX2e04nlN4qzdZ/poJotFORbswiOhOAsEu+dhVIePt6e
K+nGPk6qzgYRFfnnc9s8hizQVpfjmUEdT3G9O6/ANdYI6XvORrbnioLXVvfh
Ud9Lq59O0dCmTkkmP8AKJa2sqdE6y/FFd9NNTjED4DjXn3LA1gK95JbzuiuU
2O3a58VZNSOGfXOGdg0sgAY7+FDjCnonILt1nVuAxoLgzBMcGXCjY7MqRJbI
uYLelBVGEYeOvDfqkCWHgtyMnoOlbFR/33N94wBV7Od4P7fbaQoyjILTOHwr
pBts2qHaaSQWbNuQw0lVwGsLUYPoiTX6F/Ld37A=
      "]]}}},
  AutomaticImageSize->True,
  Boxed->False,
  ImageSize->{449.0987259025337, 388.62895560574935`},
  ViewPoint->{2.3298756714169646`, 2.30923173118745, -0.83013743887167},
  ViewVertical->{0.360014912272764, 
   0.6366682631444865, -0.7051837056566509}]], "Output",
 CellChangeTimes->{
  3.4991106608160076`*^9, 3.4995200809669027`*^9, {3.4995201775590067`*^9, 
   3.4995201854367537`*^9}, {3.4995202393798246`*^9, 3.499520254308546*^9}, 
   3.499520462971634*^9, 3.499520504934354*^9, {3.4995205361006837`*^9, 
   3.4995205599138837`*^9}, {3.4995207465838823`*^9, 3.499520771793131*^9}, {
   3.4995208442184515`*^9, 3.499520854188567*^9}, 3.5288111436033487`*^9, 
   3.528812756589036*^9, {3.529097329334612*^9, 3.5290973574302607`*^9}, {
   3.5290974580972376`*^9, 3.529097467582054*^9}, 3.529097536799376*^9, {
   3.529157868194745*^9, 3.52915789343559*^9}, {3.5291609801270113`*^9, 
   3.5291610068498583`*^9}, 3.529161352203265*^9, 3.529161866538169*^9, 
   3.529162089509361*^9, 3.5291664731754627`*^9, 3.529173784652707*^9, {
   3.5292750061989803`*^9, 3.5292750187414017`*^9}, 3.529275251649811*^9, {
   3.5292755322787037`*^9, 3.529275559609952*^9}, 3.5292758600196795`*^9, 
   3.5292759436046267`*^9, 3.5292759783614874`*^9, 3.5292760312923803`*^9, 
   3.529276467079146*^9, {3.5629651354010344`*^9, 3.56296514368474*^9}, 
   3.5629658059809914`*^9, 3.562966512656783*^9, 3.563036254694283*^9, 
   3.5630374146354976`*^9, 3.5630374514089403`*^9, 3.56305203639363*^9, 
   3.5630521938932495`*^9, 3.5630522645153546`*^9, 3.5630523005206165`*^9, 
   3.563052350082452*^9, 3.56305242951867*^9, 3.563052493963096*^9, {
   3.563052532620392*^9, 3.563052557830315*^9}, 3.5630527190271816`*^9, {
   3.5630527678090067`*^9, 3.5630527879176645`*^9}, {3.56305284907806*^9, 
   3.563052915690914*^9}, {3.563052951337371*^9, 3.563052972740845*^9}, {
   3.5630558959451323`*^9, 3.563055938237275*^9}, 3.5630561014465675`*^9, {
   3.5630561830512133`*^9, 3.5630562073875256`*^9}, 3.5630562682595057`*^9, {
   3.5630564188014355`*^9, 3.563056463870414*^9}, {3.563056509532199*^9, 
   3.5630565509039297`*^9}, 3.5630565954737005`*^9, 3.563056638077847*^9, 
   3.563056675237523*^9, 3.5630586894653625`*^9, {3.563058724799816*^9, 
   3.5630587479349127`*^9}, 3.5630588058272543`*^9, 3.563058841021306*^9, 
   3.563058908507771*^9, 3.563068195586074*^9, 3.5630682383306217`*^9, 
   3.563115899974492*^9, 3.5631435942698803`*^9, {3.564678120942566*^9, 
   3.5646781352789907`*^9}, 3.5842148245140724`*^9, 3.5842238521334434`*^9, 
   3.5842848300720916`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

Isoparametric curve moving on a surfacefrom previous cell \
\>", "Section",
 CellChangeTimes->{{3.562965048570321*^9, 3.5629651158695836`*^9}, {
   3.5629651638245983`*^9, 3.562965238315553*^9}, {3.562965334677989*^9, 
   3.5629653973595924`*^9}, {3.562965439246129*^9, 3.5629654891355686`*^9}, {
   3.562965558619464*^9, 3.5629656902096815`*^9}, 3.562965770240246*^9, {
   3.5629658292569113`*^9, 3.562965858913082*^9}, {3.562966177268083*^9, 
   3.562966178360097*^9}, {3.5629664068094263`*^9, 3.5629664920957193`*^9}, {
   3.5630237809720645`*^9, 3.5630237838425016`*^9}, {3.5630363294504414`*^9, 
   3.5630363541455584`*^9}, {3.5630364164059563`*^9, 
   3.5630365180568595`*^9}, {3.5630365590073843`*^9, 3.563036647023713*^9}, {
   3.5630367140889726`*^9, 3.563036799749671*^9}, {3.5630369898537083`*^9, 
   3.5630369917569323`*^9}, {3.563037124795438*^9, 3.5630371352787724`*^9}, {
   3.563037243577362*^9, 3.563037281895383*^9}, {3.5630373179199395`*^9, 
   3.5630373505433035`*^9}, 3.5630373896414137`*^9, {3.563037564378992*^9, 
   3.563037591773997*^9}, {3.5630376311972184`*^9, 3.5630376343641806`*^9}, 
   3.563037679824912*^9, 3.5630377322904024`*^9, {3.5630452114452066`*^9, 
   3.5630452168428755`*^9}, {3.5630452923010435`*^9, 
   3.5630453298195243`*^9}, {3.5630453800833683`*^9, 
   3.5630453829694057`*^9}, {3.563051809894326*^9, 3.5630518832464666`*^9}, {
   3.5630519563958044`*^9, 3.5630520071588554`*^9}, {3.56305206135395*^9, 
   3.563052116048251*^9}, {3.563052161756837*^9, 3.5630521747362037`*^9}, {
   3.563052392171791*^9, 3.563052395291831*^9}, {3.5630524393935966`*^9, 
   3.5630524404856105`*^9}, 3.5630524715612087`*^9, {3.563052565568014*^9, 
   3.5630525901227293`*^9}, {3.5630588540942736`*^9, 3.563058877744177*^9}, {
   3.563115929928604*^9, 3.5631159687757597`*^9}, {3.5842247560926313`*^9, 
   3.5842248009271097`*^9}},
 FontFamily->"Arial",
 FontSize->18,
 FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
     "column", " ", "i", " ", "of", " ", "dd", " ", "is", " ", "given", " ", 
      "by", " ", 
      RowBox[{
       RowBox[{"dd", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ".", " ", "It"}], " ", "has", " ", 
      "nv"}], "+", 
     RowBox[{"llv", " ", 
      RowBox[{"elements", ".", "\[IndentingNewLine]", "We"}], " ", "need", 
      " ", 
      RowBox[{"dd", "[", 
       RowBox[{"[", "i", "]"}], "]"}], " ", "evaluated", " ", "at", " ", 
      "the", " ", "moving", " ", "value", " ", 
      RowBox[{"v", ".", " ", "All"}], " ", "those", " ", "values", " ", 
      RowBox[{"(", "points", ")"}], " ", "are", " ", "stored", " ", "in", " ",
       "the", " ", "array", " ", "cc"}]}], ",", " ", 
    RowBox[{
     RowBox[{"which", " ", "has", " ", "nu"}], "+", 
     RowBox[{"llu", " ", "elements"}]}]}], " ", "*)"}], "\[IndentingNewLine]",
   "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"cc", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"nu", "+", "llu"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"cc", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "=", 
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"BSplineBasis", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"nv", ",", "knotv"}], "}"}], ",", 
              RowBox[{"j", "-", "1"}], ",", "v"}], "]"}], "*", 
            RowBox[{"dd", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "j"}], "]"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", 
             RowBox[{"nv", "+", "llv"}]}], "}"}]}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"nu", "+", "llu"}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"points", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"{", 
         RowBox[{"Green", ",", 
          RowBox[{"PointSize", "[", "0.025", "]"}], ",", 
          RowBox[{"Point", "[", "cc", "]"}]}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ccplot", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"Line", "[", "cc", "]"}], "]"}]}], ";", "\[IndentingNewLine]",
       "\[IndentingNewLine]", 
      RowBox[{"curve", "=", 
       RowBox[{"Graphics3D", "[", 
        RowBox[{"{", 
         RowBox[{"Green", ",", "Thick", ",", 
          RowBox[{"BSplineCurve", "[", 
           RowBox[{"cc", ",", 
            RowBox[{"SplineDegree", "\[Rule]", "nu"}], ",", 
            RowBox[{"SplineKnots", "\[Rule]", "knotu"}]}], "]"}]}], "}"}], 
        "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Show", "[", 
       RowBox[{
       "surfplot", ",", "points", ",", "curve", ",", "ccplot", ",", "netplot",
         ",", 
        RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", "0", ",", "1"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.562965048570321*^9, 3.5629651158695836`*^9}, {
   3.5629651638245983`*^9, 3.562965238315553*^9}, {3.562965334677989*^9, 
   3.5629653973595924`*^9}, {3.562965439246129*^9, 3.5629654891355686`*^9}, {
   3.562965558619464*^9, 3.5629656902096815`*^9}, 3.562965770240246*^9, {
   3.5629658292569113`*^9, 3.562965858913082*^9}, {3.562966177268083*^9, 
   3.562966178360097*^9}, {3.5629664068094263`*^9, 3.5629664920957193`*^9}, {
   3.5630237809720645`*^9, 3.5630237838425016`*^9}, {3.5630363294504414`*^9, 
   3.5630363541455584`*^9}, {3.5630364164059563`*^9, 
   3.5630365180568595`*^9}, {3.5630365590073843`*^9, 3.563036647023713*^9}, {
   3.5630367140889726`*^9, 3.563036799749671*^9}, {3.5630369898537083`*^9, 
   3.5630369917569323`*^9}, {3.563037124795438*^9, 3.5630371352787724`*^9}, {
   3.563037243577362*^9, 3.563037281895383*^9}, {3.5630373179199395`*^9, 
   3.5630373505433035`*^9}, 3.5630373896414137`*^9, {3.563037564378992*^9, 
   3.563037591773997*^9}, {3.5630376311972184`*^9, 3.5630376343641806`*^9}, 
   3.563037679824912*^9, 3.5630377322904024`*^9, {3.5630452114452066`*^9, 
   3.5630452168428755`*^9}, {3.5630452923010435`*^9, 
   3.5630453298195243`*^9}, {3.5630453800833683`*^9, 
   3.5630453829694057`*^9}, {3.563051809894326*^9, 3.5630518832464666`*^9}, {
   3.5630519563958044`*^9, 3.5630520071588554`*^9}, {3.56305206135395*^9, 
   3.563052116048251*^9}, {3.563052161756837*^9, 3.5630521747362037`*^9}, {
   3.563052392171791*^9, 3.563052395291831*^9}, {3.5630524393935966`*^9, 
   3.5630524404856105`*^9}, 3.5630524715612087`*^9, {3.563052565568014*^9, 
   3.5630525901227293`*^9}, {3.5630588540942736`*^9, 3.563058877744177*^9}, {
   3.563115929928604*^9, 3.563115951380117*^9}, {3.56311603191503*^9, 
   3.563116035784202*^9}, {3.5631436051121583`*^9, 3.563143606875004*^9}, {
   3.5842238659550676`*^9, 3.5842238841602993`*^9}, {3.584223920742364*^9, 
   3.5842239318495836`*^9}},
 FontFamily->"Courier New"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`v$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`v$$], 0, 1}}, Typeset`size$$ = {540., {285., 294.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`v$3101$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`v$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`v$$, $CellContext`v$3101$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> (
       Do[Part[$CellContext`cc, $CellContext`i] = 
         Sum[BSplineBasis[{$CellContext`nv, $CellContext`knotv}, \
$CellContext`j - 1, $CellContext`v$$] 
           Part[$CellContext`dd, $CellContext`i, $CellContext`j], \
{$CellContext`j, 1, $CellContext`nv + $CellContext`llv}], {$CellContext`i, 
          1, $CellContext`nu + $CellContext`llu}]; $CellContext`points = 
        Graphics3D[{Green, 
           PointSize[0.025], 
           Point[$CellContext`cc]}]; $CellContext`ccplot = Graphics3D[
          Line[$CellContext`cc]]; $CellContext`curve = 
        Graphics3D[{Green, Thick, 
           
           BSplineCurve[$CellContext`cc, SplineDegree -> $CellContext`nu, 
            SplineKnots -> $CellContext`knotu]}]; 
       Show[$CellContext`surfplot, $CellContext`points, $CellContext`curve, \
$CellContext`ccplot, $CellContext`netplot, Boxed -> False]), 
      "Specifications" :> {{$CellContext`v$$, 0, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{610., {357., 364.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.5629656938913994`*^9, 3.5629657875099993`*^9, {3.56296581841459*^9, 
   3.562965861970741*^9}, 3.562966180341323*^9, {3.5629664972125854`*^9, 
   3.5629665169156375`*^9}, 3.5630237851061172`*^9, 3.5630362547410836`*^9, {
   3.563036436421013*^9, 3.563036478167148*^9}, 3.5630365203968897`*^9, 
   3.563037149646557*^9, 3.563037248772762*^9, 3.5630372829563055`*^9, {
   3.563037325424405*^9, 3.563037352602741*^9}, {3.5630373911547885`*^9, 
   3.5630374189259925`*^9}, 3.563037455559019*^9, {3.563037568357196*^9, 
   3.563037593692895*^9}, 3.563037635596644*^9, 3.563037680776561*^9, 
   3.563037734349708*^9, 3.5630453321439543`*^9, 3.5630519040415335`*^9, {
   3.56305195839263*^9, 3.5630520086252737`*^9}, 3.5630520432265177`*^9, {
   3.563052082944627*^9, 3.563052117031064*^9}, {3.563052175329011*^9, 
   3.563052199259718*^9}, 3.563052268774209*^9, 3.5630523051694756`*^9, 
   3.5630523583661575`*^9, 3.5630523961030416`*^9, {3.5630524440736566`*^9, 
   3.563052499391966*^9}, {3.563052570872082*^9, 3.56305259177635*^9}, 
   3.563052725594866*^9, 3.563052797059382*^9, {3.56305285377372*^9, 
   3.5630529240838213`*^9}, 3.5630529806345463`*^9, 3.563056110775487*^9, 
   3.5630562181048627`*^9, 3.5630562797256527`*^9, 3.5630564263675327`*^9, 
   3.5630564815610404`*^9, {3.563056533852911*^9, 3.5630565596400414`*^9}, {
   3.5630566553784685`*^9, 3.563056679870783*^9}, 3.5630587569206276`*^9, 
   3.563058813642955*^9, {3.5630588716600986`*^9, 3.563058886839093*^9}, 
   3.5630589175870876`*^9, 3.563068195679675*^9, 3.563068248735955*^9, 
   3.563115904608019*^9, 3.563116037796796*^9, {3.563143594332282*^9, 
   3.5631436082010374`*^9}, 3.564678121036166*^9, 3.5842148245764723`*^9, 
   3.5842238521958437`*^9, 3.5842848301420918`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interpolation ", "Section",
 CellChangeTimes->{{3.528811882271649*^9, 3.5288119016467247`*^9}, {
  3.5288119365612965`*^9, 3.5288120264175377`*^9}, {3.5292762563071756`*^9, 
  3.5292762672583947`*^9}},
 FontFamily->"Arial"],

Cell["\<\

 we are given an array pp  of size (nu+llu)(nv+llv), containing data points \
to be interpolated.\
\>", "Text",
 CellChangeTimes->{{3.528811882271649*^9, 3.5288119016467247`*^9}, {
  3.5288119365612965`*^9, 3.5288120264175377`*^9}, {3.5292762563071756`*^9, 
  3.5292762672583947`*^9}, {3.529276387565806*^9, 3.529276411465048*^9}},
 FontFamily->"Arial",
 FontSize->18],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Input", " ", "data", " ", 
    RowBox[{"points", " ", "--"}], " ", "generated", " ", "on", " ", "an", 
    " ", "interesting", " ", "test", " ", "surface"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"pp", "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i", ",", "j", ",", 
          RowBox[{
           RowBox[{
            RowBox[{"i", "^", "2"}], "/", "5"}], "-", "i", "+", 
           RowBox[{"Sin", "[", "j", "]"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"nu", "+", "llu"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", 
          RowBox[{"nv", "+", "llv"}]}], "}"}]}], "]"}], "//", "N"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Greville", " ", "abscissae", " ", "grevu"}], ",", " ", 
     RowBox[{"grevv", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"grevu", "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{"knotu", "[", 
            RowBox[{"[", 
             RowBox[{"j", "+", "1"}], "]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "i", ",", 
             RowBox[{"i", "+", "nu", "-", "1"}]}], "}"}]}], "]"}], "/", 
         "nu"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"nu", "+", "llu"}]}], "}"}]}], "]"}], "//", "N"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"grevv", "=", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{"knotv", "[", 
            RowBox[{"[", 
             RowBox[{"j", "+", "1"}], "]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "i", ",", 
             RowBox[{"i", "+", "nv", "-", "1"}]}], "}"}]}], "]"}], "/", 
         "nv"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"nv", "+", "llv"}]}], "}"}]}], "]"}], "//", "N"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Vandermonde", " ", "matrices", " ", "vandu"}], ",", " ", 
     RowBox[{"vandv", " ", "based", " ", "on", " ", "greville"}]}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vandu", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"BSplineBasis", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"nu", ",", "knotu"}], "}"}], ",", "j", ",", 
         RowBox[{"grevu", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"nu", "+", "llu"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "0", ",", 
         RowBox[{"nu", "+", "llu", "-", "1"}]}], " ", "}"}]}], "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vandv", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"BSplineBasis", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"nv", ",", "knotv"}], "}"}], ",", "j", ",", 
          RowBox[{"grevv", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", 
          RowBox[{"nv", "+", "llv"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "0", ",", 
          RowBox[{"nv", "+", "llv", "-", "1"}]}], " ", "}"}]}], "]"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "The", " ", "MatrixForms", " ", "are", " ", "for", " ", "debug", " ", 
     "printing"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"MatrixForm", "[", "vandu", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"MatrixForm", "[", "pp", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"MatrixForm", "[", 
     RowBox[{"Inverse", "[", 
      RowBox[{"Transpose", "[", "vandv", "]"}], "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Solve", " ", "the", " ", "interpolation", " ", "problem", " ", "for", 
      " ", "the", " ", "B"}], "-", 
     RowBox[{"spline", " ", "control", " ", "points"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"intdd", "=", 
     RowBox[{
      RowBox[{"Inverse", "[", "vandu", "]"}], ".", 
      RowBox[{"Transpose", "[", 
       RowBox[{
        RowBox[{"Inverse", "[", 
         RowBox[{"Transpose", "[", "vandv", "]"}], "]"}], ".", 
        RowBox[{"Transpose", "[", "pp", "]"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"intnetplot", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "Large", "]"}], ",", "Green", ",", 
        RowBox[{"Map", "[", 
         RowBox[{"Point", ",", "pp"}], "]"}], ",", "Gray", ",", 
        RowBox[{"Line", "[", "intdd", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"Transpose", "[", "intdd", "]"}], "]"}]}], "}"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"intddplot", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
        RowBox[{"Map", "[", 
         RowBox[{"Point", ",", "intdd"}], "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"intsurfplot", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"BSplineSurface", "[", 
       RowBox[{"intdd", ",", 
        RowBox[{"SplineKnots", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"knotu", ",", "knotv"}], "}"}]}], ",", 
        RowBox[{"SplineDegree", "\[Rule]", " ", 
         RowBox[{"{", 
          RowBox[{"nu", ",", "nv"}], "}"}]}]}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"intddplot", ",", "intsurfplot", ",", "intnetplot"}], "}"}], 
     ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5288120349352474`*^9, 3.528812057617938*^9}, {
   3.5288121293320575`*^9, 3.528812142904231*^9}, {3.52881238172832*^9, 
   3.5288124261423745`*^9}, {3.528812692705398*^9, 3.5288127683829384`*^9}, {
   3.529097156547107*^9, 3.5290971664843245`*^9}, {3.529097291052144*^9, 
   3.5290972963249536`*^9}, {3.529097386992313*^9, 3.529097395541128*^9}, {
   3.5290976965592566`*^9, 3.529097730972917*^9}, {3.5290977985366354`*^9, 
   3.529097834479099*^9}, {3.5291579361016645`*^9, 3.5291579446036797`*^9}, {
   3.529158014273402*^9, 3.529158091680738*^9}, {3.529158309893921*^9, 
   3.529158316633133*^9}, {3.529158409905697*^9, 3.529158439093348*^9}, {
   3.5291586077764444`*^9, 3.5291586506297197`*^9}, {3.5291586836081777`*^9, 
   3.5291586891461873`*^9}, {3.5291588002027826`*^9, 3.529158826520028*^9}, {
   3.5291589360946207`*^9, 3.5291589618814664`*^9}, {3.52915906066084*^9, 
   3.5291590635624447`*^9}, {3.529159216380313*^9, 3.529159229858737*^9}, {
   3.5291593251125045`*^9, 3.529159360165766*^9}, 3.52915940239504*^9, 
   3.5291607752674522`*^9, {3.529160900457672*^9, 3.5291609595817757`*^9}, {
   3.5291610228398867`*^9, 3.529161102899227*^9}, {3.5291612274030457`*^9, 
   3.529161297509569*^9}, 3.529161374807705*^9, {3.52916141780138*^9, 
   3.529161431030204*^9}, {3.5291615081723394`*^9, 3.52916154846721*^9}, {
   3.529161607076513*^9, 3.5291616126457224`*^9}, {3.5291616712862253`*^9, 
   3.529161686277852*^9}, {3.5291617800028167`*^9, 3.5291618519521437`*^9}, {
   3.5291619163022566`*^9, 3.52916192400867*^9}, {3.52916196932675*^9, 
   3.529162080570545*^9}, {3.5291621274094276`*^9, 3.529162136192243*^9}, {
   3.5291622768264904`*^9, 3.5291622876841097`*^9}, {3.52916232248777*^9, 
   3.529162336106594*^9}, {3.5291624407671785`*^9, 3.529162530997737*^9}, {
   3.529165983646603*^9, 3.529165996033025*^9}, {3.5291660266714783`*^9, 
   3.5291660323186884`*^9}, {3.529166253043476*^9, 3.5291662548530793`*^9}, {
   3.5291665044223175`*^9, 3.5291665561520085`*^9}, {3.529166590643669*^9, 
   3.529166622358525*^9}, {3.529166669033807*^9, 3.5291666739166155`*^9}, {
   3.5291736591348867`*^9, 3.529173691723344*^9}, 3.529173727275806*^9, {
   3.529174199769436*^9, 3.529174205026645*^9}, 3.529174261514344*^9, 
   3.52917434422569*^9, {3.5291746376310053`*^9, 3.5291746533870325`*^9}, {
   3.529177310648919*^9, 3.529177363902641*^9}, {3.5291774170003304`*^9, 
   3.5291774211195755`*^9}, {3.529178170837136*^9, 3.529178183925536*^9}, {
   3.5292748875919714`*^9, 3.5292749541728888`*^9}, {3.5292750259174147`*^9, 
   3.5292750310342236`*^9}, {3.529275140203215*^9, 3.5292751470984273`*^9}, 
   3.529275231026575*^9, {3.5292753294315476`*^9, 3.5292753309291506`*^9}, {
   3.5292753686188164`*^9, 3.529275448459757*^9}, 3.5292755022330513`*^9, {
   3.529275599062421*^9, 3.5292756421808968`*^9}, {3.5292758206608105`*^9, 
   3.529275834669635*^9}, {3.5292759188473825`*^9, 3.5292759203137856`*^9}, {
   3.529276474395559*^9, 3.529276481321971*^9}, {3.5292765362964673`*^9, 
   3.5292765483552885`*^9}, {3.584224149017565*^9, 3.5842242882010093`*^9}, {
   3.5842770631818476`*^9, 3.584277090911886*^9}},
 FontFamily->"Courier New"],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[1, 0, 0], PointSize[Large], 
    Point3DBox[{{1., 1., 0.04147098480789646}, {0.9999999999999999, 
     2.2598870056497176`, 0.3836561803032316}, {1.0000000000000002`, 
     3.033898305084746, -0.8255666889260365}, {1.0000000000000002`, 
     3.9915254237288154`, -1.6392808108545165`}, {0.9999999999999999, 
     4.999999999999998, -1.9581250395034693`}, {1.0000000000000002`, 
     6.008474576271188, -1.0817646791104376`}, {0.9999999999999999, 
     6.966101694915253, -0.1913092332483347}, {1., 7.740112994350285, 
     0.5955110585282309}, {1., 9., -0.38788151475824345`}}], 
    Point3DBox[{{2.260416666666666, 
     0.9999999999999997, -0.5726493855624737}, {2.2604166666666656`, 
     2.2598870056497167`, -0.2304641900671384}, {2.2604166666666665`, 
     3.0338983050847452`, -1.4396870592964062`}, {2.2604166666666665`, 
     3.991525423728813, -2.2534011812248855`}, {2.260416666666666, 
     4.999999999999997, -2.5722454098738377`}, {2.2604166666666665`, 
     6.008474576271183, -1.6958850494808075`}, {2.2604166666666656`, 
     6.966101694915249, -0.8054296036187045}, {2.2604166666666656`, 
     7.740112994350282, -0.018609311842139337`}, {2.260416666666666, 
     8.999999999999996, -1.0020018851286134`}}], 
    Point3DBox[{{3.031250000000001, 
     1.0000000000000004`, -0.3545938300069183}, {3.031250000000001, 
     2.2598870056497184`, -0.012408634511582903`}, {3.0312499999999996`, 
     3.033898305084748, -1.221631503740852}, {3.031250000000001, 
     3.991525423728817, -2.0353456256693314`}, {3.0312499999999996`, 
     4.999999999999999, -2.3541898543182835`}, {3.031250000000001, 
     6.008474576271188, -1.477829493925253}, {3.0312500000000004`, 
     6.966101694915257, -0.5873740480631494}, {3.0312500000000018`, 
     7.740112994350289, 0.19944624371341635`}, {3.031250000000001, 
     9.000000000000005, -0.7839463295730584}}], 
    Point3DBox[{{4.000000000000001, 
     0.9999999999999999, -0.0511216077846961}, {3.999999999999999, 
     2.2598870056497167`, 0.2910635877106389}, {4.000000000000003, 
     3.0338983050847457`, -0.918159281518629}, {4.000000000000001, 
     3.991525423728814, -1.7318734034471088`}, {4., 
     4.9999999999999964`, -2.050717632096062}, {4.000000000000002, 
     6.008474576271188, -1.17435727170303}, {3.999999999999999, 
     6.9661016949152526`, -0.28390182584092727`}, {3.999999999999999, 
     7.740112994350283, 0.5029184659356384}, {4.000000000000001, 
     9., -0.48047410735083584`}}], 
    Point3DBox[{{4.968750000000001, 1.0000000000000002`, 
     0.8079061699930816}, {4.96875, 2.259887005649718, 1.150091365488417}, {
     4.968750000000001, 3.033898305084747, -0.05913150374085152}, {
     4.9687500000000036`, 3.9915254237288176`, -0.8728456256693314}, {
     4.968750000000001, 5., -1.1916898543182848`}, {4.96875, 
     6.0084745762711895`, -0.315329493925253}, {4.968750000000001, 
     6.966101694915254, 0.5751259519368502}, {4.9687500000000036`, 
     7.7401129943502855`, 1.3619462437134164`}, {4.968750000000001, 
     9.000000000000002, 0.37855367042694155`}}], 
    Point3DBox[{{5.739583333333335, 1., 1.5148506144375267`}, {
     5.739583333333332, 2.259887005649717, 1.8570358099328632`}, {
     5.739583333333335, 3.0338983050847457`, 0.6478129407035935}, {
     5.739583333333334, 3.991525423728815, -0.16590118122488495`}, {
     5.739583333333331, 4.999999999999998, -0.4847454098738385}, {
     5.739583333333336, 6.008474576271189, 0.39161495051919326`}, {
     5.739583333333332, 6.966101694915253, 1.2820703963812954`}, {
     5.739583333333334, 7.740112994350285, 2.0688906881578615`}, {
     5.739583333333335, 9., 1.0854981148713871`}}], 
    Point3DBox[{{7., 1., 3.6414709848078965`}, {7.000000000000001, 
     2.2598870056497176`, 3.9836561803032327`}, {7., 3.033898305084746, 
     2.7744333110739645`}, {7.000000000000001, 3.9915254237288154`, 
     1.9607191891454843`}, {7., 4.999999999999998, 1.6418749604965297`}, {
     7.000000000000002, 6.008474576271188, 2.518235320889563}, {
     6.999999999999998, 6.966101694915253, 3.408690766751665}, {
     7.000000000000001, 7.740112994350285, 4.195511058528232}, {7., 9., 
     3.2121184852417564`}}]}, BSplineSurface3DBox[CompressedData["
1:eJxVlHtI01EUx+c252b5CN00FGvL0LIs1KCHcG+lpthD06ZZGBpaYi/SMi0t
EKxWps0swlWW2UN6KfRApd+iNC0kmloz0vRXf+QzX2Np2frp79wLu3D5/fjy
5dzzuefco0w+uDVFJBAI7Lgt4/b0P7+GEfniFWb14zWVyDKzfiFR4sEK5CrE
n3ta7xgKjcgGfNfacrP3hUrxE3Vgu316H0P0Tk15z+0hJ9wQMZGft3qSIXH+
zXxd8FE1258Ta6H+0tplRQ+l7vj9eH/Oz80j1F8tX/s6otMDB9d6LjacaGJI
fjbR4f7dJi+cO2/uiv2O35F1/ipcIfKZmt1qZGK3cUsuxFMQz92NbfGOYZkY
0G2AayrlOtNxsoXZBnoZcJ0/tG6jSWqmuhG4jtt9DDBLhHrr+C7YUNiQaioR
64m/GLgEtZd2xqv+0HMfANfvF8ZNro29VP8XxXPZJjq8jXYsofnz96bEXgWj
8wOlw4xwGhNLsRC4ey98iK6q/kR1W+B6cXRrXU3aWf4+kRTfBC59eEN2y7kx
6u8BrtIMbcTucIGe+C3ANTBRkJvULtQTP6lXgNZNs7zSzNeR058CV1xa1703
71lGDLoE6mXU2u3IPN2MSBwR1EtX36dTKHqhH5wxqT9+5ZGvW1LF8PxOtF7i
/It+zeUGJAK/DrjcC9q0RUmDNM4X4DrW08zqn/6B/nHGf4FLnrW9smuPgOfi
dMKVd76+Y/G7UXruE+AaqosqPuxnoLoF6iUfzsr66daNyLmkDw8lpx1T6Lv4
fLpdMOn3l+mR9olfevl+5XQxcD0YVwU1po4i4r8BXKd+HLE9EfaIv09OZ4FL
WaYY2z7UT+Pz57rikITMpEVzxhgS/wpwJbPmVzv826i/Brg6mmM1B/awiMQX
Qr1M5ya9z7wzIev8Vdh/sHjJqtVGFDfdnyYFJu/va8IRS2vwbxQLuhC4Hl09
7J/+bIr6Sb1q+jcEsbU/kBr0r8C1N6RzAgU38O+C08nckLRrdXMk35h40C8D
173qMJ+Vzh30XDI3+mQ5aGf+OI1P5ka2e2WRolCArfNX4cjujNDAxBGYI56U
69Z9X02d0gH4PTGZh/YRd5Wnu5ww8ZN5uMB80s0+QEL9ZB4at5TLPXZZaHzC
NW/984deoZP8u+B00odpBnVR/EIx+Dwol6+NX5UlZBaNT7jiNDKHoCZnbJ2/
CscP+CxNr5Hh/6ykU/w=
    "],
    SplineDegree->{3, 3},
    SplineKnots->{{0., 0., 0., 0., 0.25, 0.5, 0.75, 1., 1., 1., 1.}, {0., 0., 
      0., 0., 0.16666666666666666`, 0.3333333333333333, 0.5, 
      0.6666666666666666, 0.8333333333333334, 1., 1., 1., 1.}}], 
   {RGBColor[0, 1, 0], PointSize[
    Large], {Point3DBox[{{1., 1., 0.04147098480789646}, {1., 2., 
      0.10929742682568167`}, {1., 3., -0.6588799919401328}, {1., 
      4., -1.5568024953079282`}, {1., 5., -1.7589242746631384`}, {1., 
      6., -1.079415498198926}, {1., 7., -0.14301340128121098`}, {1., 8., 
      0.18935824662338174`}, {1., 9., -0.38788151475824345`}}], 
     Point3DBox[{{2., 1., -0.35852901519210345`}, {2., 
      2., -0.29070257317431825`}, {2., 3., -1.0588799919401328`}, {2., 
      4., -1.9568024953079282`}, {2., 5., -2.1589242746631383`}, {2., 
      6., -1.4794154981989258`}, {2., 7., -0.5430134012812109}, {2., 
      8., -0.21064175337661817`}, {2., 9., -0.7878815147582434}}], 
     Point3DBox[{{3., 1., -0.35852901519210345`}, {3., 
      2., -0.29070257317431825`}, {3., 3., -1.0588799919401328`}, {3., 
      4., -1.9568024953079282`}, {3., 5., -2.1589242746631383`}, {3., 
      6., -1.4794154981989258`}, {3., 7., -0.5430134012812109}, {3., 
      8., -0.21064175337661817`}, {3., 9., -0.7878815147582434}}], 
     Point3DBox[{{4., 1., 0.04147098480789646}, {4., 2., 
      0.10929742682568167`}, {4., 3., -0.6588799919401328}, {4., 
      4., -1.5568024953079282`}, {4., 5., -1.7589242746631384`}, {4., 
      6., -1.079415498198926}, {4., 7., -0.14301340128121098`}, {4., 8., 
      0.18935824662338174`}, {4., 9., -0.38788151475824345`}}], 
     Point3DBox[{{5., 1., 0.8414709848078965}, {5., 2., 0.9092974268256817}, {
      5., 3., 0.1411200080598672}, {5., 4., -0.7568024953079282}, {5., 
      5., -0.9589242746631385}, {5., 6., -0.27941549819892586`}, {5., 7., 
      0.6569865987187891}, {5., 8., 0.9893582466233818}, {5., 9., 
      0.4121184852417566}}], 
     Point3DBox[{{6., 1., 2.0414709848078965`}, {6., 2., 
      2.1092974268256817`}, {6., 3., 1.341120008059867}, {6., 4., 
      0.44319750469207175`}, {6., 5., 0.2410757253368615}, {6., 6., 
      0.9205845018010741}, {6., 7., 1.856986598718789}, {6., 8., 
      2.1893582466233816`}, {6., 9., 1.6121184852417565`}}], 
     Point3DBox[{{7., 1., 3.6414709848078965`}, {7., 2., 
      3.7092974268256818`}, {7., 3., 2.941120008059867}, {7., 4., 
      2.0431975046920714`}, {7., 5., 1.8410757253368613`}, {7., 6., 
      2.520584501801074}, {7., 7., 3.456986598718789}, {7., 8., 
      3.7893582466233817`}, {7., 9., 3.2121184852417564`}}]}, 
    {GrayLevel[0.5], Line3DBox[CompressedData["
1:eJxVlHtI01EUx+c252b5CN00FGvL0LIs1KCHcG+lpthD06ZZGBpaYi/SMi0t
EKxWps0swlWW2UN6KfRApd+iNC0kmloz0vRXf+QzX2Np2frp79wLu3D5/fjy
5dzzuefco0w+uDVFJBAI7Lgt4/b0P7+GEfniFWb14zWVyDKzfiFR4sEK5CrE
n3ta7xgKjcgGfNfacrP3hUrxE3Vgu316H0P0Tk15z+0hJ9wQMZGft3qSIXH+
zXxd8FE1258Ta6H+0tplRQ+l7vj9eH/Oz80j1F8tX/s6otMDB9d6LjacaGJI
fjbR4f7dJi+cO2/uiv2O35F1/ipcIfKZmt1qZGK3cUsuxFMQz92NbfGOYZkY
0G2AayrlOtNxsoXZBnoZcJ0/tG6jSWqmuhG4jtt9DDBLhHrr+C7YUNiQaioR
64m/GLgEtZd2xqv+0HMfANfvF8ZNro29VP8XxXPZJjq8jXYsofnz96bEXgWj
8wOlw4xwGhNLsRC4ey98iK6q/kR1W+B6cXRrXU3aWf4+kRTfBC59eEN2y7kx
6u8BrtIMbcTucIGe+C3ANTBRkJvULtQTP6lXgNZNs7zSzNeR058CV1xa1703
71lGDLoE6mXU2u3IPN2MSBwR1EtX36dTKHqhH5wxqT9+5ZGvW1LF8PxOtF7i
/It+zeUGJAK/DrjcC9q0RUmDNM4X4DrW08zqn/6B/nHGf4FLnrW9smuPgOfi
dMKVd76+Y/G7UXruE+AaqosqPuxnoLoF6iUfzsr66daNyLmkDw8lpx1T6Lv4
fLpdMOn3l+mR9olfevl+5XQxcD0YVwU1po4i4r8BXKd+HLE9EfaIv09OZ4FL
WaYY2z7UT+Pz57rikITMpEVzxhgS/wpwJbPmVzv826i/Brg6mmM1B/awiMQX
Qr1M5ya9z7wzIev8Vdh/sHjJqtVGFDfdnyYFJu/va8IRS2vwbxQLuhC4Hl09
7J/+bIr6Sb1q+jcEsbU/kBr0r8C1N6RzAgU38O+C08nckLRrdXMk35h40C8D
173qMJ+Vzh30XDI3+mQ5aGf+OI1P5ka2e2WRolCArfNX4cjujNDAxBGYI56U
69Z9X02d0gH4PTGZh/YRd5Wnu5ww8ZN5uMB80s0+QEL9ZB4at5TLPXZZaHzC
NW/984deoZP8u+B00odpBnVR/EIx+Dwol6+NX5UlZBaNT7jiNDKHoCZnbJ2/
CscP+CxNr5Hh/6ykU/w=
      "]], Line3DBox[CompressedData["
1:eJxdlHtIU1EYwLe7OadlGrppKNpWoWVZ+IAy4Z5KS+lp2rQMQ6OH2AstTdMK
BKuZaTOLaJU97CH2UOiBSmdRVhYSTa0panrzj3xm6lhatq7e7xzIA5e7/fZx
vt++831HlXhw8y6JSCSy4x9b/pn4LKxBlrxRkEXzaHkpG72FXwoGjVsn1g/W
zZWrnxvFYWYiDMkRA/Hd5z5GllV8xuLJ707ICvHopXuOfmGZwDuckRjiXySv
tY9v6WZjJvY3KxHJ27rtiLUh5Bd4eFB+876PtlrlQPeVxB+8xbow6Etnwx1j
vomNAk8x8PFd13DziXrqaQP8edrm6sqkM/jv5D6ONF6ac963rsQo5OU9pcDL
R9SBb3YPCXXgPRngDy+n+CU/HWfF4El87CPuqk61O9L/ebUxO2NfmBw91gQ0
2Sf34C3geQX42UMr15nlFjypw8rRDeCG8NqM+rxhLIF66oG75TbqChL6aT2v
Az/ZdcQma/VDTOpJ4it71wRyVV20nsRnjuWEq72/jHq2aUs6bw84otqI0Zzj
wWPU0wT8mO0nf4uMMZB6dgIvTtVF7AwXGci5twA/2lnHGZ78xlLw5ICrriiH
tw70Yg14tgLfG9o2yobUYlJP4mPaWKJw32FlybkL5+aM0jRcb2a0Ff/fn87I
mF+721wkNZB6WoH3jeZmJzQxBhF4/gGuSN9a2r4H/HlP4XcXFLrtcML8mcM4
CjxJXlmTTj9T9hWTehLuterZA8+wMZbUs7hqccEDuRv6MNKb+X3DT1rPQuCi
qgvbY9W/aX+SeH+dq3ZJqUXgvCfhx8/WNC94P4RJf14CnshZXsb5NeJY8LwI
/F7Fau+lTs0sA55knySjpiB2npTOUYVixauINncUUuWxwJj1DpM5Kgf+67lp
vcubbuFceM8nwGOS2u+9/sDROXoMfKB6U2GKr5H2ZyXw5rpo7YE9HJ0jkrfH
LpPdnjMC5+pOuY/Yt8waOo3Ovzgy3K/D7ImyvWYF7Z/xjc77300Ct4l3eBs5
o0joN95TBvEmnW3c4VN1LPG0QrxiMD39u2sHS/qTgXhz3tjc0+/NLOlPkjfD
rbRAmS9CpD8Jj9HaOQS+c6KewluNbkm8x6c3mGh/CvlVyDN3aHaAfJCeuwTi
9TU9eqWym96fZJ9DiUlHlYb2KfenGvn1Fy5cFmyacn+q0dqO1LCA+J9T7k81
iu3zXpRcaYf+Ad2tU/w=
      "]]}}},
  AutomaticImageSize->True,
  Boxed->False,
  ImageSize->{394.81830331980365`, 387.5644744299469},
  ViewPoint->{2.9653647187618724`, 0.537173266807542, -1.53884923437926},
  ViewVertical->{
   0.18903549243220139`, -0.4190547965725636, -1.0601132560394184`}]], \
"Output",
 CellChangeTimes->{
  3.5292755045106554`*^9, {3.529275538315914*^9, 3.5292755673787656`*^9}, 
   3.5292756440061*^9, 3.5292758360424376`*^9, 3.5292758707524986`*^9, 
   3.529275922170189*^9, 3.529275954399845*^9, 3.5292759879087043`*^9, 
   3.5292760424152*^9, 3.5292765166560326`*^9, 3.529276552598496*^9, 
   3.563036254850285*^9, 3.563068195820077*^9, 3.563143594472686*^9, 
   3.5646781213013663`*^9, 3.584214824857273*^9, 3.5842238523050437`*^9, 
   3.584284830232092*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1352, 697},
WindowMargins->{{Automatic, 49}, {Automatic, 8}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 829, 16, 201, "Subtitle"],
Cell[1399, 40, 526, 10, 105, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1950, 54, 270, 6, 97, "Section"],
Cell[2223, 62, 412, 12, 147, "Text"],
Cell[CellGroupData[{
Cell[2660, 78, 8117, 180, 392, "Input"],
Cell[10780, 260, 12793, 205, 605, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23622, 471, 1927, 31, 137, "Section"],
Cell[CellGroupData[{
Cell[25574, 506, 5335, 117, 422, "Input"],
Cell[30912, 625, 4065, 72, 745, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35026, 703, 229, 4, 105, "Section"],
Cell[35258, 709, 379, 9, 90, "Text"],
Cell[CellGroupData[{
Cell[35662, 722, 9651, 222, 800, "Input"],
Cell[45316, 946, 11418, 188, 603, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
