(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     90877,       1842]
NotebookOptionsPosition[     89879,       1805]
NotebookOutlinePosition[     90223,       1820]
CellTagsIndexPosition[     90180,       1817]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 "\n"
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
  3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
  3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
  3.5842134956497355`*^9, 3.5842135862546945`*^9}},
 FontFamily->"Arial"],

Cell[TextData[{
 "\nComposing affine  maps",
 StyleBox["\nDemonstrates repeated application of an affine map  to a point \
set on a circle.\nCan also add an extra linear map to each affine map.\nSee \
Figures 6.4 and 6.5",
  FontWeight->"Plain"]
}], "Subtitle",
 CellChangeTimes->{{3.5190605704177775`*^9, 3.519060578092991*^9}, {
   3.5190606755931625`*^9, 3.5190606801327705`*^9}, {3.5190608203926163`*^9, 
   3.5190608745559115`*^9}, {3.519060915412383*^9, 3.5190610274049797`*^9}, {
   3.519061174669239*^9, 3.5190613186574917`*^9}, 3.519143837518166*^9, {
   3.5191440108968706`*^9, 3.5191440842949996`*^9}, {3.5191441776923637`*^9, 
   3.519144178940366*^9}, 3.5191443457826586`*^9, {3.519144902064036*^9, 
   3.5191449079140463`*^9}, 3.519156811457747*^9, {3.5192153918123827`*^9, 
   3.5192153974751925`*^9}, {3.5192154318576527`*^9, 3.519215691223708*^9}, {
   3.5192158081927137`*^9, 3.519215848627985*^9}, {3.519215887877654*^9, 
   3.519216004737459*^9}, {3.519216076466385*^9, 3.519216133858886*^9}, {
   3.519216519366763*^9, 3.519216550052017*^9}, {3.519216635914568*^9, 
   3.5192166381453714`*^9}, {3.519217165987899*^9, 3.519217215673986*^9}, 
   3.519217553164979*^9, {3.519217675890394*^9, 3.519217728431287*^9}, {
   3.5192178033270183`*^9, 3.519217836055876*^9}, {3.5192354757312593`*^9, 
   3.5192355017365055`*^9}, {3.5192355615782104`*^9, 3.519235579377842*^9}, {
   3.5192360996699553`*^9, 3.5192361066119676`*^9}, {3.519236155798854*^9, 
   3.5192361622104654`*^9}, {3.519250527129697*^9, 3.519250592228611*^9}, {
   3.5192506335374837`*^9, 3.519250686265576*^9}, {3.5192507781913376`*^9, 
   3.519250787083353*^9}, 3.5193003676408386`*^9, {3.5193004238789372`*^9, 
   3.5193004762014294`*^9}, {3.5193036080161295`*^9, 
   3.5193036918350773`*^9}, {3.519303722567131*^9, 3.519303742410366*^9}, 
   3.519303837040132*^9, {3.519304166660311*^9, 3.519304192228756*^9}, 
   3.5193120073460827`*^9, {3.5193120766102047`*^9, 3.519312082351014*^9}, {
   3.5193170104228706`*^9, 3.519317036521717*^9}, {3.5193211526529474`*^9, 
   3.5193211598133593`*^9}, {3.519321193025818*^9, 3.5193211987666283`*^9}, {
   3.519321513497181*^9, 3.519321592074519*^9}, {3.5193216490770187`*^9, 
   3.5193216896058903`*^9}, {3.519343007985736*^9, 3.519343043319798*^9}, {
   3.5193431211171346`*^9, 3.519343127232345*^9}, {3.519352043128805*^9, 
   3.519352043596806*^9}, 3.5193924460265155`*^9, {3.519393453853305*^9, 
   3.5193934546489515`*^9}, {3.5194077013054934`*^9, 3.5194077049715*^9}, 
   3.5194196552368903`*^9, 3.5195785836619773`*^9, {3.5212492789260855`*^9, 
   3.5212492863828983`*^9}, 3.5219253694127026`*^9, 3.521925458473259*^9, {
   3.5225460706154685`*^9, 3.522546077527864*^9}, {3.550005130514476*^9, 
   3.550005237561864*^9}, {3.5500052961087666`*^9, 3.550005301475176*^9}, {
   3.55000534364205*^9, 3.55000538924093*^9}, 3.5500054248245926`*^9, 
   3.5500055199067593`*^9, {3.550005610449319*^9, 3.5500056120873213`*^9}, {
   3.5500059477063107`*^9, 3.5500059751311593`*^9}, {3.5500060789961414`*^9, 
   3.550006082740148*^9}, {3.550006161707487*^9, 3.5500061716759043`*^9}, {
   3.550006211799175*^9, 3.550006215215581*^9}, 3.550006266602071*^9, {
   3.5500064095607224`*^9, 3.550006423195146*^9}, {3.550006490306464*^9, 
   3.550006503909688*^9}, {3.550066414869915*^9, 3.55006641778712*^9}, {
   3.5500664625591984`*^9, 3.5500664687056093`*^9}, 3.550066519516899*^9, 
   3.5500677396458426`*^9, {3.5500681282913275`*^9, 3.5500681442501554`*^9}, 
   3.5500682849000025`*^9, {3.5500683240716715`*^9, 3.5500683325580864`*^9}, {
   3.5500683723849564`*^9, 3.550068373102557*^9}, {3.550090428919712*^9, 
   3.550090440838133*^9}, {3.550091836194154*^9, 3.55009184566337*^9}, {
   3.5500919789500046`*^9, 3.5500920097132587`*^9}, {3.5500920562637405`*^9, 
   3.550092161875926*^9}, 3.5500922046668015`*^9, 3.5500923745822997`*^9, {
   3.550092411289164*^9, 3.5500924176383753`*^9}, {3.5500926347751565`*^9, 
   3.550092698688469*^9}, {3.5500927406681423`*^9, 3.550092767203789*^9}, {
   3.550176384290493*^9, 3.5501764452086*^9}, {3.5501764806674623`*^9, 
   3.5501764952378883`*^9}, {3.550176601583275*^9, 3.5501766229241123`*^9}, {
   3.5501766694901943`*^9, 3.550176721703486*^9}, {3.550176757037548*^9, 
   3.550176759003152*^9}, {3.550176870948948*^9, 3.550176901603002*^9}, {
   3.5501769367966633`*^9, 3.550176937280265*^9}, {3.5501784283740873`*^9, 
   3.550178457093738*^9}, {3.5502508434269114`*^9, 3.5502508901645937`*^9}, {
   3.5502510114392066`*^9, 3.5502511123713837`*^9}, {3.550251152666255*^9, 
   3.550251154444658*^9}, {3.5502511848647113`*^9, 3.5502511971575327`*^9}, {
   3.550251233599197*^9, 3.5502512356428003`*^9}, {3.5502513565430126`*^9, 
   3.550251408257104*^9}, 3.5502515021536684`*^9, {3.5601085466569166`*^9, 
   3.5601085819735208`*^9}, {3.5601086127487497`*^9, 
   3.5601086389045734`*^9}, {3.5601092671839256`*^9, 
   3.5601092834396467`*^9}, {3.56010931381382*^9, 3.5601093181507587`*^9}, {
   3.561666387644267*^9, 3.5616664237275295`*^9}, {3.5616664730241613`*^9, 
   3.561666478016226*^9}, {3.5616667161532784`*^9, 3.5616667491009007`*^9}, {
   3.561666889658703*^9, 3.5616669742273874`*^9}, {3.561667013071885*^9, 
   3.5616670598100843`*^9}, 3.5616670958777466`*^9, {3.561667150868452*^9, 
   3.5616671803372297`*^9}, {3.561667223502983*^9, 3.5616672787120905`*^9}, {
   3.561667427709601*^9, 3.5616675272700777`*^9}, {3.5616675985941916`*^9, 
   3.561667621729288*^9}, {3.5616678194774237`*^9, 3.5616678740001225`*^9}, {
   3.5616679892388*^9, 3.561667989379202*^9}, 3.5616680497831764`*^9, {
   3.5616682807441373`*^9, 3.5616683241594934`*^9}, {3.5644208738521767`*^9, 
   3.5644209131522317`*^9}, {3.5843676898531713`*^9, 3.584367771453285*^9}, {
   3.5843678602234097`*^9, 3.5843678623934126`*^9}, {3.5843687262946224`*^9, 
   3.5843688221247563`*^9}},
 FontFamily->"Arial",
 FontSize->16,
 FontWeight->"Bold",
 FontColor->GrayLevel[0]],

Cell[CellGroupData[{

Cell["\<\

Initialize\
\>", "Section",
 CellChangeTimes->{{3.584367236242536*^9, 3.5843672463025503`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"to", " ", "enable", " ", "file", " ", 
    RowBox[{"export", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"del", "=", "0.1"}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"increment", " ", "for", " ", "plotting"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "preimage", " ", "points", " ", "on", " ", "unit", " ", "circle"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"circpoints", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", "t", "]"}], ",", 
         RowBox[{"Sin", "[", "t", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"2", " ", "Pi"}], ",", "del"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"num", " ", "=", " ", 
     RowBox[{"Length", "[", "circpoints", "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5190605704177775`*^9, 3.519060578092991*^9}, {
   3.5190606755931625`*^9, 3.5190606801327705`*^9}, {3.5190608203926163`*^9, 
   3.5190608745559115`*^9}, {3.519060915412383*^9, 3.5190610274049797`*^9}, {
   3.519061174669239*^9, 3.5190613186574917`*^9}, 3.519143837518166*^9, {
   3.5191440108968706`*^9, 3.5191440842949996`*^9}, {3.5191441776923637`*^9, 
   3.519144178940366*^9}, 3.5191443457826586`*^9, {3.519144902064036*^9, 
   3.5191449079140463`*^9}, 3.519156811457747*^9, {3.5192153918123827`*^9, 
   3.5192153974751925`*^9}, {3.5192154318576527`*^9, 3.519215691223708*^9}, {
   3.5192158081927137`*^9, 3.519215848627985*^9}, {3.519215887877654*^9, 
   3.519216004737459*^9}, {3.519216076466385*^9, 3.519216133858886*^9}, {
   3.519216519366763*^9, 3.519216550052017*^9}, {3.519216635914568*^9, 
   3.5192166381453714`*^9}, {3.519217165987899*^9, 3.519217215673986*^9}, 
   3.519217553164979*^9, {3.519217675890394*^9, 3.519217728431287*^9}, {
   3.5192178033270183`*^9, 3.519217836055876*^9}, {3.5192354757312593`*^9, 
   3.5192355017365055`*^9}, {3.5192355615782104`*^9, 3.519235579377842*^9}, {
   3.5192360996699553`*^9, 3.5192361066119676`*^9}, {3.519236155798854*^9, 
   3.5192361622104654`*^9}, {3.519250527129697*^9, 3.519250592228611*^9}, {
   3.5192506335374837`*^9, 3.519250686265576*^9}, {3.5192507781913376`*^9, 
   3.519250787083353*^9}, 3.5193003676408386`*^9, {3.5193004238789372`*^9, 
   3.5193004762014294`*^9}, {3.5193036080161295`*^9, 
   3.5193036918350773`*^9}, {3.519303722567131*^9, 3.519303742410366*^9}, 
   3.519303837040132*^9, {3.519304166660311*^9, 3.519304192228756*^9}, 
   3.5193120073460827`*^9, {3.5193120766102047`*^9, 3.519312082351014*^9}, {
   3.5193170104228706`*^9, 3.519317036521717*^9}, {3.5193211526529474`*^9, 
   3.5193211598133593`*^9}, {3.519321193025818*^9, 3.5193211987666283`*^9}, {
   3.519321513497181*^9, 3.519321592074519*^9}, {3.5193216490770187`*^9, 
   3.5193216896058903`*^9}, {3.519343007985736*^9, 3.519343043319798*^9}, {
   3.5193431211171346`*^9, 3.519343127232345*^9}, {3.519352043128805*^9, 
   3.519352043596806*^9}, 3.5193924460265155`*^9, {3.519393453853305*^9, 
   3.5193934546489515`*^9}, {3.5194077013054934`*^9, 3.5194077049715*^9}, 
   3.5194196552368903`*^9, 3.5195785836619773`*^9, {3.5212492789260855`*^9, 
   3.5212492863828983`*^9}, 3.5219253694127026`*^9, 3.521925458473259*^9, {
   3.5225460706154685`*^9, 3.522546077527864*^9}, {3.550005130514476*^9, 
   3.550005237561864*^9}, {3.5500052961087666`*^9, 3.550005301475176*^9}, {
   3.55000534364205*^9, 3.55000538924093*^9}, 3.5500054248245926`*^9, 
   3.5500055199067593`*^9, {3.550005610449319*^9, 3.5500056120873213`*^9}, {
   3.5500059477063107`*^9, 3.5500059751311593`*^9}, {3.5500060789961414`*^9, 
   3.550006082740148*^9}, {3.550006161707487*^9, 3.5500061716759043`*^9}, {
   3.550006211799175*^9, 3.550006215215581*^9}, 3.550006266602071*^9, {
   3.5500064095607224`*^9, 3.550006423195146*^9}, {3.550006490306464*^9, 
   3.550006503909688*^9}, {3.550066414869915*^9, 3.55006641778712*^9}, {
   3.5500664625591984`*^9, 3.5500664687056093`*^9}, 3.550066519516899*^9, 
   3.5500677396458426`*^9, {3.5500681282913275`*^9, 3.5500681442501554`*^9}, 
   3.5500682849000025`*^9, {3.5500683240716715`*^9, 3.5500683325580864`*^9}, {
   3.5500683723849564`*^9, 3.550068373102557*^9}, {3.550090428919712*^9, 
   3.550090440838133*^9}, {3.550091836194154*^9, 3.55009184566337*^9}, {
   3.5500919789500046`*^9, 3.5500920097132587`*^9}, {3.5500920562637405`*^9, 
   3.550092161875926*^9}, 3.5500922046668015`*^9, 3.5500923745822997`*^9, {
   3.550092411289164*^9, 3.5500924176383753`*^9}, {3.5500926347751565`*^9, 
   3.550092698688469*^9}, {3.5500927406681423`*^9, 3.550092767203789*^9}, {
   3.550176384290493*^9, 3.5501764452086*^9}, {3.5501764806674623`*^9, 
   3.5501764952378883`*^9}, {3.550176601583275*^9, 3.5501766229241123`*^9}, {
   3.5501766694901943`*^9, 3.550176721703486*^9}, {3.550176757037548*^9, 
   3.550176759003152*^9}, {3.550176870948948*^9, 3.550176901603002*^9}, {
   3.5501769367966633`*^9, 3.550176937280265*^9}, {3.5501784283740873`*^9, 
   3.550178457093738*^9}, {3.5502508434269114`*^9, 3.5502508901645937`*^9}, {
   3.5502510114392066`*^9, 3.5502511123713837`*^9}, {3.550251152666255*^9, 
   3.550251154444658*^9}, {3.5502511848647113`*^9, 3.5502511971575327`*^9}, {
   3.550251233599197*^9, 3.5502512356428003`*^9}, {3.5502513565430126`*^9, 
   3.550251408257104*^9}, 3.5502515021536684`*^9, {3.5601085466569166`*^9, 
   3.5601085819735208`*^9}, {3.5601086127487497`*^9, 
   3.5601086389045734`*^9}, {3.5601092671839256`*^9, 
   3.5601092834396467`*^9}, {3.56010931381382*^9, 3.5601093181507587`*^9}, {
   3.561666387644267*^9, 3.5616664237275295`*^9}, {3.5616664730241613`*^9, 
   3.561666478016226*^9}, {3.5616667161532784`*^9, 3.5616667491009007`*^9}, {
   3.561666889658703*^9, 3.5616669742273874`*^9}, {3.561667013071885*^9, 
   3.5616670598100843`*^9}, 3.5616670958777466`*^9, {3.561667150868452*^9, 
   3.5616671803372297`*^9}, {3.561667223502983*^9, 3.5616672787120905`*^9}, {
   3.561667427709601*^9, 3.5616675272700777`*^9}, {3.5616675985941916`*^9, 
   3.561667621729288*^9}, {3.5616678194774237`*^9, 3.5616678740001225`*^9}, {
   3.5616679892388*^9, 3.561667989379202*^9}, 3.5616680497831764`*^9, {
   3.5616682807441373`*^9, 3.5616682930058947`*^9}, {3.5616685273676987`*^9, 
   3.5616686368343024`*^9}, {3.5616686774104223`*^9, 
   3.5616686888765697`*^9}, {3.5616687502321563`*^9, 3.5616687526501875`*^9}, 
   3.561669007245451*^9, {3.5616691130304074`*^9, 3.561669181328083*^9}, {
   3.5616692207809887`*^9, 3.561669233853956*^9}, {3.5616692786889315`*^9, 
   3.5616693334300327`*^9}, {3.5644068742875385`*^9, 
   3.5644069139276466`*^9}, {3.5644210043423595`*^9, 
   3.5644211596125765`*^9}, {3.564422567271556*^9, 3.5644226894617267`*^9}, {
   3.564422810841896*^9, 3.5644228115218973`*^9}, {3.564423664303091*^9, 
   3.5644238361333323`*^9}, {3.5644239101534357`*^9, 3.564423912413439*^9}, {
   3.5644240907736883`*^9, 3.5644240911636887`*^9}, {3.564424171903802*^9, 
   3.5644242578839226`*^9}, 3.5644243994841204`*^9, {3.564424467124215*^9, 
   3.5644246303044434`*^9}, {3.5644247337245884`*^9, 
   3.5644247339845886`*^9}, {3.564425266394427*^9, 3.5644252689975758`*^9}, {
   3.564425327017894*^9, 3.5644253850322123`*^9}, {3.5644254319078937`*^9, 
   3.564425575629114*^9}, {3.564425677399935*^9, 3.5644256778319597`*^9}, {
   3.5644257713523083`*^9, 3.5644258310767245`*^9}, {3.5644259005857005`*^9, 
   3.5644259779881277`*^9}, {3.56442600810685*^9, 3.5644260794119287`*^9}, {
   3.5644261302518363`*^9, 3.5644261709881663`*^9}, {3.5644262022929573`*^9, 
   3.56442621738982*^9}, {3.564428376561318*^9, 3.5644283789044523`*^9}, {
   3.5644284264411707`*^9, 3.5644284265761786`*^9}, 3.56442847502995*^9, {
   3.564429567761451*^9, 3.564429575770909*^9}, {3.564430413583829*^9, 
   3.564430421385992*^9}, {3.564430679035986*^9, 3.564430683313594*^9}, {
   3.564431231161726*^9, 3.5644312408025427`*^9}, {3.5644312785858097`*^9, 
   3.56443127892901*^9}, {3.5644313987728195`*^9, 3.5644313992564206`*^9}, {
   3.564433774652216*^9, 3.5644338258737006`*^9}, {3.564433887691402*^9, 
   3.5644338890114036`*^9}, {3.564433924810254*^9, 3.564433924950255*^9}, {
   3.5644878286300116`*^9, 3.56448787024007*^9}, {3.5644879044701176`*^9, 
   3.5644879051401186`*^9}, {3.564487998590249*^9, 3.564488112740409*^9}, {
   3.564488226610569*^9, 3.564488334080719*^9}, {3.564488364820762*^9, 
   3.564488367400766*^9}, {3.564488403490816*^9, 3.5644884065808206`*^9}, {
   3.564488461240897*^9, 3.5644884614308977`*^9}, {3.5644885506510224`*^9, 
   3.5644885528910255`*^9}, {3.564488593211082*^9, 3.5644886059911*^9}, {
   3.5644886408411484`*^9, 3.564488644621154*^9}, {3.564488767431326*^9, 
   3.5644887688013277`*^9}, {3.5644888186513977`*^9, 3.564488819171398*^9}, 
   3.564489454542288*^9, {3.564489750132702*^9, 3.564489928102951*^9}, 
   3.5644900130230694`*^9, {3.564490066113144*^9, 3.5644900668131447`*^9}, {
   3.564490097043187*^9, 3.564490100303192*^9}, 3.5644902055433393`*^9, {
   3.5644915246971874`*^9, 3.564491524967188*^9}, {3.5644915662772455`*^9, 
   3.5644915663972454`*^9}, {3.564500120959222*^9, 3.564500124109226*^9}, 
   3.5645001670792866`*^9, 3.564500221039362*^9, {3.564500348989541*^9, 
   3.5645003570295525`*^9}, {3.564500393929604*^9, 3.564500403979618*^9}, {
   3.564500458509694*^9, 3.564500481499727*^9}, {3.564500531019796*^9, 
   3.5645006477799597`*^9}, 3.5645012506308036`*^9, {3.5645012860308533`*^9, 
   3.5645012905308595`*^9}, {3.5645013228409047`*^9, 3.564501356710952*^9}, 
   3.564501413321031*^9, {3.5645014686711087`*^9, 3.5645014906611395`*^9}, 
   3.5645015255511885`*^9, {3.5645015672212467`*^9, 3.564501597401289*^9}, {
   3.5645016890514174`*^9, 3.564501713301451*^9}, {3.5645017831915493`*^9, 
   3.56450178385155*^9}, {3.564501814301593*^9, 3.564501817281597*^9}, 
   3.5645018562516513`*^9, {3.5645125566687775`*^9, 3.5645125681035976`*^9}, {
   3.564512617696085*^9, 3.56451262051969*^9}, {3.5645127899359875`*^9, 
   3.5645128228052454`*^9}, {3.564512870556929*^9, 3.564512903597787*^9}, {
   3.564513023312397*^9, 3.564513027789605*^9}, {3.564513124634575*^9, 
   3.5645132366895723`*^9}, {3.564513383079624*^9, 3.564513404887261*^9}, 
   3.5843672700425835`*^9, {3.584367471262865*^9, 3.5843674714528656`*^9}},
 FontFamily->"Courier New",
 FontColor->GrayLevel[0]],

Cell["\<\
 Affine map control routine
if maptype = 1 then apply affine map defined by mat and vec below
if maptype != 1 then in addition to applying the affine map defined by mat \
and vec, also apply a linear map to the result.\
\>", "Text",
 CellChangeTimes->{{3.5843674549528427`*^9, 3.5843676008630466`*^9}, {
  3.584368005553613*^9, 3.5843680129136233`*^9}, {3.584368055463683*^9, 
  3.584368194193877*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"affinemap", "[", "point_", "]"}], ":=", 
    RowBox[{"(", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"maptype", " ", "\[Equal]", " ", "1"}], ",", 
       RowBox[{
        RowBox[{"mat", ".", "point"}], "+", "vec"}], ",", 
       RowBox[{"mat2nd", ".", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"mat", ".", "point"}], " ", "+", " ", "vec"}], ")"}]}]}], 
      "]"}], "\[IndentingNewLine]", ")"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.5843674412028227`*^9, 3.5843674414628234`*^9}, {
  3.584367513922925*^9, 3.584367525302941*^9}, {3.58436803197365*^9, 
  3.584368039783661*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

Pick an affine map to apply\
\>", "Section",
 CellChangeTimes->{{3.5843672730625877`*^9, 3.5843672811225986`*^9}, {
  3.5843673407026825`*^9, 3.5843673456726894`*^9}}],

Cell["Load one of the mat* vec* pairs into mat and vec below", "Text",
 CellChangeTimes->{{3.5843673505126963`*^9, 3.58436737489273*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", "translation", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"mat1", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vec1", "=", " ", 
     RowBox[{"{", 
      RowBox[{".8", ",", ".2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "scale", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat2", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0.5"}], "}"}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vec2", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0.0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "shear", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat3", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vec3", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"translational", " ", "part"}], " ", "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"(*", " ", "rotation", " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"alpha", "=", 
     RowBox[{"-", "90"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat4", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"alpha", " ", "Degree"}], "]"}], ",", 
         RowBox[{"-", 
          RowBox[{"Sin", "[", 
           RowBox[{"alpha", " ", "Degree"}], "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"alpha", " ", "Degree"}], "]"}], ",", 
         RowBox[{"Cos", "[", 
          RowBox[{"alpha", " ", "Degree"}], "]"}]}], "}"}]}], "}"}]}], ";"}], 
   " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vec4", "=", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"rotate", " ", "then", " ", "scale"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"matscale", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.5", ",", " ", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.0", ",", "0.5"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat5", " ", "=", " ", 
     RowBox[{"matscale", ".", "mat4"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vec5", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"x", "'"}], " ", "=", " ", 
     RowBox[{
      RowBox[{"Rot", ".", "Scale", ".", "x"}], " ", "+", " ", "T"}]}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"alpha", " ", "=", " ", "45"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat6", " ", "=", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"alpha", " ", "Degree"}], "]"}], ",", 
          RowBox[{"-", 
           RowBox[{"Sin", "[", 
            RowBox[{"alpha", " ", "Degree"}], "]"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"alpha", " ", "Degree"}], "]"}], ",", 
          RowBox[{"Cos", "[", 
           RowBox[{"alpha", " ", "Degree"}], "]"}]}], "}"}]}], "}"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.5", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0.5"}], "}"}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vec6", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0.2", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"x", "'"}], " ", "=", " ", 
     RowBox[{
      RowBox[{"R", ".", "Scale", ".", "Shear", ".", "x"}], " ", "+", " ", 
      "T"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"alpha", " ", "=", " ", "90"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat7", " ", "=", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Cos", "[", 
           RowBox[{"alpha", " ", "Degree"}], "]"}], ",", 
          RowBox[{"-", 
           RowBox[{"Sin", "[", 
            RowBox[{"alpha", " ", "Degree"}], "]"}]}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"alpha", " ", "Degree"}], "]"}], ",", 
          RowBox[{"Cos", "[", 
           RowBox[{"alpha", " ", "Degree"}], "]"}]}], "}"}]}], "}"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.5", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0.5"}], "}"}]}], "}"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vec7", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"x", "'"}], " ", "=", " ", 
     RowBox[{
      RowBox[{"Shear", ".", "Scale", ".", "x"}], " ", "+", " ", "T"}]}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat8", " ", "=", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}], ".", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.2", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0.5"}], "}"}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vec8", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0.0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"===", "===", "===", "===", "==="}], "=", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
       "Make", " ", "selection", " ", "from", " ", "above", " ", "here"}], 
       " ", "===", "==="}], "=", 
      RowBox[{"===", "===", "===", "==="}]}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat", " ", "=", " ", "mat7"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vec", " ", "=", " ", "vec7"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"For", " ", "more", " ", "fun"}], " ", "..."}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"maptype", " ", "=", " ", 
      RowBox[{
      "1", " ", "then", " ", "we", " ", "use", " ", "only", " ", "the", " ", 
       "affine", " ", "map", " ", "defined", " ", "by", " ", "mat"}]}], ",", 
     "vec"}], "  ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"otherwise", ",", " ", 
     RowBox[{
     "we", " ", "also", " ", "apply", " ", "the", " ", "linear", " ", "map", 
      " ", "mat2nd"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"See", " ", 
     RowBox[{"affinemap", "[", "]"}], " ", "routine", " ", "above", " ", 
     "for", " ", "exact", " ", "application"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"maptype", " ", "=", " ", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat2nd", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.5", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1.5"}], "}"}]}], "}"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.5190605704177775`*^9, 3.519060578092991*^9}, {
   3.5190606755931625`*^9, 3.5190606801327705`*^9}, {3.5190608203926163`*^9, 
   3.5190608745559115`*^9}, {3.519060915412383*^9, 3.5190610274049797`*^9}, {
   3.519061174669239*^9, 3.5190613186574917`*^9}, 3.519143837518166*^9, {
   3.5191440108968706`*^9, 3.5191440842949996`*^9}, {3.5191441776923637`*^9, 
   3.519144178940366*^9}, 3.5191443457826586`*^9, {3.519144902064036*^9, 
   3.5191449079140463`*^9}, 3.519156811457747*^9, {3.5192153918123827`*^9, 
   3.5192153974751925`*^9}, {3.5192154318576527`*^9, 3.519215691223708*^9}, {
   3.5192158081927137`*^9, 3.519215848627985*^9}, {3.519215887877654*^9, 
   3.519216004737459*^9}, {3.519216076466385*^9, 3.519216133858886*^9}, {
   3.519216519366763*^9, 3.519216550052017*^9}, {3.519216635914568*^9, 
   3.5192166381453714`*^9}, {3.519217165987899*^9, 3.519217215673986*^9}, 
   3.519217553164979*^9, {3.519217675890394*^9, 3.519217728431287*^9}, {
   3.5192178033270183`*^9, 3.519217836055876*^9}, {3.5192354757312593`*^9, 
   3.5192355017365055`*^9}, {3.5192355615782104`*^9, 3.519235579377842*^9}, {
   3.5192360996699553`*^9, 3.5192361066119676`*^9}, {3.519236155798854*^9, 
   3.5192361622104654`*^9}, {3.519250527129697*^9, 3.519250592228611*^9}, {
   3.5192506335374837`*^9, 3.519250686265576*^9}, {3.5192507781913376`*^9, 
   3.519250787083353*^9}, 3.5193003676408386`*^9, {3.5193004238789372`*^9, 
   3.5193004762014294`*^9}, {3.5193036080161295`*^9, 
   3.5193036918350773`*^9}, {3.519303722567131*^9, 3.519303742410366*^9}, 
   3.519303837040132*^9, {3.519304166660311*^9, 3.519304192228756*^9}, 
   3.5193120073460827`*^9, {3.5193120766102047`*^9, 3.519312082351014*^9}, {
   3.5193170104228706`*^9, 3.519317036521717*^9}, {3.5193211526529474`*^9, 
   3.5193211598133593`*^9}, {3.519321193025818*^9, 3.5193211987666283`*^9}, {
   3.519321513497181*^9, 3.519321592074519*^9}, {3.5193216490770187`*^9, 
   3.5193216896058903`*^9}, {3.519343007985736*^9, 3.519343043319798*^9}, {
   3.5193431211171346`*^9, 3.519343127232345*^9}, {3.519352043128805*^9, 
   3.519352043596806*^9}, 3.5193924460265155`*^9, {3.519393453853305*^9, 
   3.5193934546489515`*^9}, {3.5194077013054934`*^9, 3.5194077049715*^9}, 
   3.5194196552368903`*^9, 3.5195785836619773`*^9, {3.5212492789260855`*^9, 
   3.5212492863828983`*^9}, 3.5219253694127026`*^9, 3.521925458473259*^9, {
   3.5225460706154685`*^9, 3.522546077527864*^9}, {3.550005130514476*^9, 
   3.550005237561864*^9}, {3.5500052961087666`*^9, 3.550005301475176*^9}, {
   3.55000534364205*^9, 3.55000538924093*^9}, 3.5500054248245926`*^9, 
   3.5500055199067593`*^9, {3.550005610449319*^9, 3.5500056120873213`*^9}, {
   3.5500059477063107`*^9, 3.5500059751311593`*^9}, {3.5500060789961414`*^9, 
   3.550006082740148*^9}, {3.550006161707487*^9, 3.5500061716759043`*^9}, {
   3.550006211799175*^9, 3.550006215215581*^9}, 3.550006266602071*^9, {
   3.5500064095607224`*^9, 3.550006423195146*^9}, {3.550006490306464*^9, 
   3.550006503909688*^9}, {3.550066414869915*^9, 3.55006641778712*^9}, {
   3.5500664625591984`*^9, 3.5500664687056093`*^9}, 3.550066519516899*^9, 
   3.5500677396458426`*^9, {3.5500681282913275`*^9, 3.5500681442501554`*^9}, 
   3.5500682849000025`*^9, {3.5500683240716715`*^9, 3.5500683325580864`*^9}, {
   3.5500683723849564`*^9, 3.550068373102557*^9}, {3.550090428919712*^9, 
   3.550090440838133*^9}, {3.550091836194154*^9, 3.55009184566337*^9}, {
   3.5500919789500046`*^9, 3.5500920097132587`*^9}, {3.5500920562637405`*^9, 
   3.550092161875926*^9}, 3.5500922046668015`*^9, 3.5500923745822997`*^9, {
   3.550092411289164*^9, 3.5500924176383753`*^9}, {3.5500926347751565`*^9, 
   3.550092698688469*^9}, {3.5500927406681423`*^9, 3.550092767203789*^9}, {
   3.550176384290493*^9, 3.5501764452086*^9}, {3.5501764806674623`*^9, 
   3.5501764952378883`*^9}, {3.550176601583275*^9, 3.5501766229241123`*^9}, {
   3.5501766694901943`*^9, 3.550176721703486*^9}, {3.550176757037548*^9, 
   3.550176759003152*^9}, {3.550176870948948*^9, 3.550176901603002*^9}, {
   3.5501769367966633`*^9, 3.550176937280265*^9}, {3.5501784283740873`*^9, 
   3.550178457093738*^9}, {3.5502508434269114`*^9, 3.5502508901645937`*^9}, {
   3.5502510114392066`*^9, 3.5502511123713837`*^9}, {3.550251152666255*^9, 
   3.550251154444658*^9}, {3.5502511848647113`*^9, 3.5502511971575327`*^9}, {
   3.550251233599197*^9, 3.5502512356428003`*^9}, {3.5502513565430126`*^9, 
   3.550251408257104*^9}, 3.5502515021536684`*^9, {3.5601085466569166`*^9, 
   3.5601085819735208`*^9}, {3.5601086127487497`*^9, 
   3.5601086389045734`*^9}, {3.5601092671839256`*^9, 
   3.5601092834396467`*^9}, {3.56010931381382*^9, 3.5601093181507587`*^9}, {
   3.561666387644267*^9, 3.5616664237275295`*^9}, {3.5616664730241613`*^9, 
   3.561666478016226*^9}, {3.5616667161532784`*^9, 3.5616667491009007`*^9}, {
   3.561666889658703*^9, 3.5616669742273874`*^9}, {3.561667013071885*^9, 
   3.5616670598100843`*^9}, 3.5616670958777466`*^9, {3.561667150868452*^9, 
   3.5616671803372297`*^9}, {3.561667223502983*^9, 3.5616672787120905`*^9}, {
   3.561667427709601*^9, 3.5616675272700777`*^9}, {3.5616675985941916`*^9, 
   3.561667621729288*^9}, {3.5616678194774237`*^9, 3.5616678740001225`*^9}, {
   3.5616679892388*^9, 3.561667989379202*^9}, 3.5616680497831764`*^9, {
   3.5616682807441373`*^9, 3.5616682930058947`*^9}, {3.5616685273676987`*^9, 
   3.5616686368343024`*^9}, {3.5616686774104223`*^9, 
   3.5616686888765697`*^9}, {3.5616687502321563`*^9, 3.5616687526501875`*^9}, 
   3.561669007245451*^9, {3.5616691130304074`*^9, 3.561669181328083*^9}, {
   3.5616692207809887`*^9, 3.561669233853956*^9}, {3.5616692786889315`*^9, 
   3.5616693334300327`*^9}, {3.5644068742875385`*^9, 
   3.5644069139276466`*^9}, {3.5644210043423595`*^9, 
   3.5644211596125765`*^9}, {3.564422567271556*^9, 3.5644226894617267`*^9}, {
   3.564422810841896*^9, 3.5644228115218973`*^9}, {3.564423664303091*^9, 
   3.5644238361333323`*^9}, {3.5644239101534357`*^9, 3.564423912413439*^9}, {
   3.5644240907736883`*^9, 3.5644240911636887`*^9}, {3.564424171903802*^9, 
   3.5644242578839226`*^9}, 3.5644243994841204`*^9, {3.564424467124215*^9, 
   3.5644246303044434`*^9}, {3.5644247337245884`*^9, 
   3.5644247339845886`*^9}, {3.564425266394427*^9, 3.5644252689975758`*^9}, {
   3.564425327017894*^9, 3.5644253850322123`*^9}, {3.5644254319078937`*^9, 
   3.564425575629114*^9}, {3.564425677399935*^9, 3.5644256778319597`*^9}, {
   3.5644257713523083`*^9, 3.5644258310767245`*^9}, {3.5644259005857005`*^9, 
   3.5644259779881277`*^9}, {3.56442600810685*^9, 3.5644260794119287`*^9}, {
   3.5644261302518363`*^9, 3.5644261709881663`*^9}, {3.5644262022929573`*^9, 
   3.56442621738982*^9}, {3.564428376561318*^9, 3.5644283789044523`*^9}, {
   3.5644284264411707`*^9, 3.5644284265761786`*^9}, 3.56442847502995*^9, {
   3.564429567761451*^9, 3.564429575770909*^9}, {3.564430413583829*^9, 
   3.564430421385992*^9}, {3.564430679035986*^9, 3.564430683313594*^9}, {
   3.564431231161726*^9, 3.5644312408025427`*^9}, {3.5644312785858097`*^9, 
   3.56443127892901*^9}, {3.5644313987728195`*^9, 3.5644313992564206`*^9}, {
   3.564433774652216*^9, 3.5644338258737006`*^9}, {3.564433887691402*^9, 
   3.5644338890114036`*^9}, {3.564433924810254*^9, 3.564433924950255*^9}, {
   3.5644878286300116`*^9, 3.56448787024007*^9}, {3.5644879044701176`*^9, 
   3.5644879051401186`*^9}, {3.564487998590249*^9, 3.564488112740409*^9}, {
   3.564488226610569*^9, 3.564488334080719*^9}, {3.564488364820762*^9, 
   3.564488367400766*^9}, {3.564488403490816*^9, 3.5644884065808206`*^9}, {
   3.564488461240897*^9, 3.5644884614308977`*^9}, {3.5644885506510224`*^9, 
   3.5644885528910255`*^9}, {3.564488593211082*^9, 3.5644886059911*^9}, {
   3.5644886408411484`*^9, 3.564488644621154*^9}, {3.564488767431326*^9, 
   3.5644887688013277`*^9}, {3.5644888186513977`*^9, 3.564488819171398*^9}, 
   3.564489454542288*^9, {3.564489750132702*^9, 3.564489928102951*^9}, 
   3.5644900130230694`*^9, {3.564490066113144*^9, 3.5644900668131447`*^9}, {
   3.564490097043187*^9, 3.564490100303192*^9}, 3.5644902055433393`*^9, {
   3.5644915246971874`*^9, 3.564491524967188*^9}, {3.5644915662772455`*^9, 
   3.5644915663972454`*^9}, {3.564500120959222*^9, 3.564500124109226*^9}, 
   3.5645001670792866`*^9, 3.564500221039362*^9, {3.564500348989541*^9, 
   3.5645003570295525`*^9}, {3.564500393929604*^9, 3.564500403979618*^9}, {
   3.564500458509694*^9, 3.564500481499727*^9}, {3.564500531019796*^9, 
   3.5645006477799597`*^9}, 3.5645012506308036`*^9, {3.5645012860308533`*^9, 
   3.5645012905308595`*^9}, {3.5645013228409047`*^9, 3.564501356710952*^9}, 
   3.564501413321031*^9, {3.5645014686711087`*^9, 3.5645014906611395`*^9}, 
   3.5645015255511885`*^9, {3.5645015672212467`*^9, 3.564501597401289*^9}, {
   3.5645016890514174`*^9, 3.564501713301451*^9}, {3.5645017831915493`*^9, 
   3.56450178385155*^9}, {3.564501814301593*^9, 3.564501817281597*^9}, 
   3.5645018562516513`*^9, {3.5645125566687775`*^9, 3.5645125681035976`*^9}, {
   3.564512617696085*^9, 3.56451262051969*^9}, {3.5645127899359875`*^9, 
   3.5645128228052454`*^9}, {3.564512870556929*^9, 3.564512903597787*^9}, {
   3.564513023312397*^9, 3.564513027789605*^9}, {3.564513124634575*^9, 
   3.5645132366895723`*^9}, {3.564513383079624*^9, 3.564513404887261*^9}, {
   3.5843672700425835`*^9, 3.584367285272605*^9}, {3.584367384702744*^9, 
   3.5843674181327906`*^9}, {3.5843676171430693`*^9, 3.5843676208030744`*^9}, 
   3.5843678950234585`*^9, {3.5843679694135623`*^9, 3.584367983343582*^9}, {
   3.5843682785639954`*^9, 3.5843683745541296`*^9}, {3.58436843901422*^9, 
   3.5843684962143*^9}},
 FontFamily->"Courier New",
 FontColor->GrayLevel[0]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

Multiple application of the same map\
\>", "Section",
 CellChangeTimes->{{3.5644290638996315`*^9, 3.5644290874209766`*^9}},
 FontSize->12],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Original", " ", "points", " ", "on", " ", "a", " ", "circle"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"circplot", " ", "=", " ", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "Large", "]"}], ",", "Black", ",", 
        RowBox[{"Point", "[", "circpoints", "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"First", " ", "app", " ", "of", " ", "map"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x1points", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "num"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"x1points", "[", 
        RowBox[{"[", "i", "]"}], "]"}], " ", "=", " ", 
       RowBox[{"affinemap", "[", 
        RowBox[{"circpoints", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "num"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x1plot", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "Large", "]"}], ",", 
        RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", 
        RowBox[{"Point", "[", "x1points", "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"l1plot", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", "0", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "num"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"l1plot", "[", 
        RowBox[{"[", "i", "]"}], "]"}], " ", "=", 
       RowBox[{"Graphics", "[", 
        RowBox[{"Line", "[", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"x1points", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ",", " ", 
           RowBox[{"circpoints", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "num"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Second", " ", "app", " ", "of", " ", "map"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x2points", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "num"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"x2points", "[", 
        RowBox[{"[", "i", "]"}], "]"}], " ", "=", " ", 
       RowBox[{"affinemap", "[", 
        RowBox[{"x1points", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "num"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x2plot", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "Large", "]"}], ",", 
        RowBox[{"GrayLevel", "[", "0.8", "]"}], ",", 
        RowBox[{"Point", "[", "x2points", "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"l2plot", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", "0", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "num"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"l2plot", "[", 
        RowBox[{"[", "i", "]"}], "]"}], " ", "=", 
       RowBox[{"Graphics", "[", 
        RowBox[{"Line", "[", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"x2points", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ",", " ", 
           RowBox[{"x1points", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "num"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Third", " ", "app", " ", "of", " ", "map"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x3points", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "num"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"x3points", "[", 
        RowBox[{"[", "i", "]"}], "]"}], " ", "=", " ", 
       RowBox[{"affinemap", "[", 
        RowBox[{"x2points", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "]"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "num"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x3plot", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "Large", "]"}], ",", 
        RowBox[{"GrayLevel", "[", "0.9", "]"}], ",", 
        RowBox[{"Point", "[", "x3points", "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"l3plot", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", "0", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "num"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"l3plot", "[", 
        RowBox[{"[", "i", "]"}], "]"}], " ", "=", 
       RowBox[{"Graphics", "[", 
        RowBox[{"Line", "[", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"x3points", "[", 
            RowBox[{"[", "i", "]"}], "]"}], ",", " ", 
           RowBox[{"x2points", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "]"}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "num"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Display", " ", "graphics"}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Just", " ", "one", " ", "application"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"{", 
     RowBox[{"l1plot", ",", "circplot", ",", "x1plot"}], "}"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Show", " ", "all", " ", "apps"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"pic", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"{", 
      RowBox[{
      "l1plot", ",", "l2plot", ",", "l3plot", ",", "circplot", ",", "x1plot", 
       ",", "x2plot", ",", " ", "x3plot"}], "}"}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<maps_examps.eps\>\"", ",", "pic"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Show", " ", "all", " ", "without", " ", "connecting", " ", "lines"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"{", 
     RowBox[{"circplot", ",", "x1plot", ",", "x2plot", ",", " ", "x3plot"}], 
     "}"}], "]"}]}]}]], "Input",
 CellChangeTimes->{
  3.5644290900931296`*^9, 3.5644291500655603`*^9, {3.5644291864816427`*^9, 
   3.5644292937627788`*^9}, 3.56442932542259*^9, {3.5644293558533306`*^9, 
   3.5644293918433886`*^9}, {3.5644294261403503`*^9, 
   3.5644294905260334`*^9}, {3.5644295272171316`*^9, 3.564429611268939*^9}, {
   3.5644296813969507`*^9, 3.564429792747319*^9}, {3.5644298231350574`*^9, 
   3.564429874806013*^9}, {3.5644299143142724`*^9, 3.5644300414925466`*^9}, {
   3.564430108271366*^9, 3.5644302060309577`*^9}, {3.5644302845074463`*^9, 
   3.564430375539653*^9}, {3.564490381935587*^9, 3.564490459495696*^9}, {
   3.56449112701663*^9, 3.564491150656664*^9}, {3.5644913132168913`*^9, 
   3.564491316586896*^9}, 3.5644913629969606`*^9, {3.5644997142986526`*^9, 
   3.5644997413686905`*^9}, {3.5645017195114603`*^9, 3.564501720371461*^9}, {
   3.564512015893828*^9, 3.5645120487630854`*^9}, {3.564512082552745*^9, 
   3.5645121302732286`*^9}, {3.564512200863353*^9, 3.5645122677094703`*^9}, {
   3.5645123140883512`*^9, 3.5645123283623767`*^9}, {3.564512382166871*^9, 
   3.564512499073477*^9}, 3.5645128676085243`*^9, {3.5645129269822283`*^9, 
   3.564512989475938*^9}, {3.5843676283030853`*^9, 3.5843676299830875`*^9}, {
   3.5843676629331336`*^9, 3.5843676749131503`*^9}, {3.5843684021341686`*^9, 
   3.58436843182421*^9}}],

Cell[BoxData[
 GraphicsBox[{LineBox[{{0., 0.75}, {1., 0.}}], 
   LineBox[{{-0.07487506248512112, 0.8211281864436404}, {0.9950041652780258, 
    0.09983341664682815}}], 
   LineBox[{{-0.1490019980962959, 0.884051931477227}, {0.9800665778412416, 
    0.19866933079506122`}}], 
   LineBox[{{-0.2216401549960047, 0.9381425218402092}, {0.955336489125606, 
    0.2955202066613396}}], 
   LineBox[{{-0.2920637567314879, 0.9828595022336517}, {0.9210609940028851, 
    0.3894183423086505}}], 
   LineBox[{{-0.35956915395315225`, 1.0177560753709318`}, {0.8775825618903728,
     0.479425538604203}}], 
   LineBox[{{-0.4234818550462766, 1.0424835662285352`}, {0.8253356149096782, 
    0.5646424733950355}}], 
   LineBox[{{-0.4831632654282684, 1.0567949058916346`}, {0.7648421872844884, 
    0.6442176872376911}}], 
   LineBox[{{-0.5380170681746421, 1.0605471001850162`}, {0.6967067093471654, 
    0.7173560908995228}}], 
   LineBox[{{-0.5874951822206126, 1.0537026584236107`}, {0.6216099682706644, 
    0.7833269096274834}}], 
   LineBox[{{-0.6311032386059223, 1.036329968007027}, {0.5403023058681397, 
    0.8414709848078965}}], 
   LineBox[{{-0.6684055200460766, 1.0086026111152595`}, {0.4535961214255773, 
    0.8912073600614354}}], 
   LineBox[{{-0.6990293144754198, 0.9707976303329248}, {0.3623577544766734, 
    0.9320390859672264}}], 
   LineBox[{{-0.7226686390628947, 0.9232927605313352}, {0.26749882862458735`, 
    0.963558185417193}}], 
   LineBox[{{-0.7390872974913452, 0.8665626546665258}, {0.16996714290024081`, 
    0.9854497299884603}}], 
   LineBox[{{-0.7481212399530408, 0.801174141203818}, {0.0707372016677029, 
    0.9974949866040544}}], 
   LineBox[{{-0.7496802022811289, 
    0.7277805605551622}, {-0.029199522301288815`, 0.9995736030415051}}], 
   LineBox[{{-0.7437486078393514, 0.6471152371177078}, {-0.12884449429552486`,
     0.9916648104524686}}], 
   LineBox[{{-0.7303857231586464, 0.5599841521388311}, {-0.2272020946930871, 
    0.9738476308781951}}], 
   LineBox[{{-0.7097250657655608, 0.4672578906179332}, {-0.3232895668635036, 
    0.9463000876874145}}], 
   LineBox[{{-0.6819730701192612, 0.36986294270890446`}, {-0.4161468365471424,
     0.9092974268256817}}], 
   LineBox[{{-0.6474070249866553, 0.26877244653676213`}, {-0.5048461045998576,
     0.8632093666488737}}], 
   LineBox[{{-0.6063723028646926, 0.1649964649231832}, {-0.5885011172553458, 
    0.8084964038195901}}], 
   LineBox[{{-0.5592789091325401, 0.0595718931726717}, {-0.6662760212798244, 
    0.74570521217672}}], 
   LineBox[{{-0.506597385413363, -0.046447901242571366`}, \
{-0.7373937155412458, 0.6754631805511506}}], 
   LineBox[{{-0.44885410807796744`, -0.15200360358223286`}, \
{-0.8011436155469337, 0.5984721441039565}}], 
   LineBox[{{-0.3866260288660981, -0.2560405361606124}, {-0.8568887533689473, 
    0.5155013718214642}}], 
   LineBox[{{-0.32053491017537233`, -0.3575191963374236}, \
{-0.9040721420170612, 0.4273798802338298}}], 
   LineBox[{{-0.2512411126169285, -0.4554256428845652}, {-0.9422223406686583, 
    0.33498815015590466`}}], 
   LineBox[{{-0.17943699691048648`, -0.5487816269517065}, \
{-0.9709581651495907, 0.23924932921398198`}}], 
   LineBox[{{-0.1058400060449004, -0.6366543664054336}, {-0.9899924966004454, 
    0.1411200080598672}}], 
   LineBox[{{-0.03118549682496787, -0.7181658658799918}, {-0.9991351502732795,
     0.04158066243329049}}], 
   LineBox[{{
    0.04378060757068507, -0.79250168941675}, {-0.9982947757947531, \
-0.058374143427580086`}}], 
   LineBox[{{
    0.11830927060743648`, -0.8589190980390852}, {-0.9874797699088649, \
-0.15774569414324865`}}], 
   LineBox[{{
    0.19165582652012375`, -0.9167544709547194}, {-0.9667981925794609, \
-0.25554110202683167`}}], 
   LineBox[{{
    0.26308742076721486`, -0.965429936235312}, {-0.9364566872907963, \
-0.35078322768961984`}}], 
   LineBox[{{
    0.33189033247113936`, -1.0044591447217497`}, {-0.896758416334147, \
-0.44252044329485246`}}], 
   LineBox[{{
    0.3973771056813701, -1.033452129464176}, {-0.848100031710408, \
-0.5298361409084934}}], 
   LineBox[{{
    0.45889341820703944`, -1.0521192021428518`}, {-0.7909677119144165, \
-0.6118578909427193}}], 
   LineBox[{{
    0.5158246193879805, -1.0602738475380855`}, {-0.7259323042001399, \
-0.6877661591839741}}], 
   LineBox[{{
    0.5676018714809461, -1.0578345871286552`}, {-0.6536436208636119, \
-0.7568024953079282}}], 
   LineBox[{{
    0.6137078332983081, -1.0448257931982594`}, {-0.5748239465332685, \
-0.8182771110644108}}], 
   LineBox[{{
    0.6536818293101911, -1.0213774453157156`}, {-0.4902608213406994, \
-0.8715757724135882}}], 
   LineBox[{{
    0.6871244525620912, -0.9877238316220727}, {-0.40079917207997545`, \
-0.9161659367494549}}], 
   LineBox[{{
    0.7137015554171371, -0.9442012079009515}, {-0.30733286997841935`, \
-0.9516020738895161}}], 
   LineBox[{{
    0.7331475882488228, -0.8912444378219075}, {-0.2107957994307797, \
-0.977530117665097}}], 
   LineBox[{{
    0.7452682527250984, -0.8293826479263889}, {-0.11215252693505398`, \
-0.9936910036334645}}], 
   LineBox[{{
    0.7499424431730757, -0.7592339407702435}, {-0.01238866346289056, \
-0.9999232575641008}}], 
   LineBox[{{0.7471234566268804, -0.6814992190472949}, {
    0.08749898343944727, -0.9961646088358406}}], 
   LineBox[{{0.7368394594682494, -0.5969551824013175}, {
    0.18651236942257576`, -0.9824526126243325}}], 
   LineBox[{{0.7191932059973538, -0.5064465668999341}, {
    0.28366218546322625`, -0.9589242746631385}}], 
   LineBox[{{0.6943610117457991, -0.41087770471106333`}, {
    0.37797774271298107`, -0.9258146823277321}}], 
   LineBox[{{0.6625909917901148, -0.311203488314832}, {
    0.4685166713003771, -0.8834546557201531}}], 
   LineBox[{{0.6242005816679256, -0.20841982953355445`}, {
    0.5543743361791615, -0.8322674422239008}}], 
   LineBox[{{0.5795733656669904, -0.10355370871001435`}, {
    0.6346928759426347, -0.7727644875559871}}], 
   LineBox[{{0.5291552441777939, 0.00234708654065105}, {
    0.70866977429126, -0.7055403255703919}}], 
   LineBox[{{0.47344997840424063`, 0.10822443047844699`}, {
    0.7755658785102502, -0.6312666378723208}}], 
   LineBox[{{0.4130141569482282, 0.21302043168114165`}, {
    0.8347127848391598, -0.5506855425976376}}], 
   LineBox[{{0.34845163456031747`, 0.3156880031456721}, {
    0.8855195169413194, -0.4646021794137566}}], 
   LineBox[{{0.280407498622677, 0.41520132443534996`}, {
    0.9274784307440359, -0.373876664830236}}], 
   LineBox[{{0.2095616236491944, 0.5105660913385801}, {
    0.960170286650366, -0.27941549819892586`}}], 
   LineBox[{{0.13662187820407126`, 0.6008294506278673}, {
    0.9832684384425847, -0.18216250427209502`}}], 
   LineBox[{{0.0623170521131223, 0.6850895206542909}, {
    0.9965420970232175, -0.0830894028174964}}], 
   {GrayLevel[0], PointSize[Large], PointBox[CompressedData["
1:eJw1hgsw2wccgI1iVOfRlpXi5t1WvO9iVH/UqOLqWW+zmbZDVaauJqOrjZ6x
2s5U0/WMpivWzqMETTx+6LIUY+IVFo8gJPL6pz2pOq623W7f3Xff915qduQF
dTU1NfjHf/sfSvj/Bkwat414BDiOlI80VzCBmpp3m5FEQM+Ej/Ve1hCwdJyn
zCsV4MFi3R7dmIDXdL4oOl8OmZdObHjJZiG8MFHL4bAMlJohueLmRTiUGHTS
Ll0CCX4PTW4ZrkBlTW1kdb4YmEcC06/UCOEC7bPFzJB1GH2Dg1Wb63B0pbLa
S7gKfo3JNA3DDSjX6tB3CF4GhZ7Od9FyCRh+zNF6qr0Anp+QQtnFMhjP965a
dOEB+7wp3X9SDimhxz9tt+BCiAV7O29aARqxB3u+GGCDxvIHS6OlBDRss8Om
zdqgPMvxHlVKgLtxCpu6XoPs0wJO0S4BFZfpm9uF/dhJc+Z1dRNAfcc2THVo
FJWHe4sGjxHQEuDB/L11CmM9TS1NghSgmRMVa0f/CwMZXMmrd+Uw/BNtX7u9
AHdypJBeKwVKU2mI2vQKvs17NOe+tAFCZxcTq8g1tHKOI3HnRVDK/Z7BoomQ
xn2mSqtZg8LyEmKLvoFPhv880GK3CpTNG6/uZ0qxu6Sue/e6AOo1LrY7KGSo
12Bj45rAh1BKbF6LnQL715KtcyjTMOz7gG9sROCkS9DM09oxmFgr6dvXTGDi
dGeWp8Eg2NTHnJG8JtDJgPaVfvBD6Bxhrmi/JNCNJH6fvNqEnfsbHLPvEnhH
r2tY3fU3VO/78Jm6UoG5oXsGQwnjmGI6oJG7JUfLVNZ176szGO84wTjVJsMX
XKW/X+Q8kucKm+jWUvQzc5JlbApQ3Mgvvhe2gXX9sr2YqlUUPfdInfES4Vi7
JclJfR0HbPha9RIhNlvMLzDJYkwjZbio0law9/kKNcpZguacMtmVj5Zw1mh8
6eWqFKO8jSuf1M+hbdlbXt4Rcnw0mFoQ+3gSlQ4BrjevKjDDJy46cWcYb/hy
fORnCCy7FX9Cu7MHWbLkgxF/EOiREe7vlfINRsrI+il7BH7pey7u/MVO2PPR
+7FKQGCacYH9gyUO/Cy1uuZLIXAuOJNSYj8B7ncFqqIWBT5OElYMucwC02r2
aGCdHBUZ5HjS7gLwbFhtpwNkOO+WC9m9y0A26okm7kvw21bb7EthQqBout0p
YIkxaEr75OWmdYht1T039MM6Fut+XZrNFQNDVW0S4y7E428OVG91SKCOQz1L
rl1G+5wGLVKMDIaXKji6PQt4LHz7lKhJDma9+9Noch6qrD7X6WIqoJ/eWvZi
mYsM2tkU4hoBSTvuvCMRHBz7Jd/311UCzEf7+HEBHfg3aMAd2w==
     "]]}, 
   {GrayLevel[0.5], PointSize[Large], PointBox[CompressedData["
1:eJxVkvs71QccgF3SlDHJ5tLT5jrN7TkukzXzOVJ0mD0il6fHI5ehaMihrI5L
LaVEDdmZy4lIqqVyya3HB5XHLUMcnOPYuX8PTseXjHKZtR/3Ps/7vP/AaxyR
4BeloqSkBB/8r/9HBuETNfqqVvU4Ze3PqvWYBc3Q+KMZOs8x1LjRw8JLDj/o
McMaQgfwCx/aGXc1BdzI5dtaPxlBFeWAlzfp85B8wDnIVnUcd4VRmK2HSPhI
eKbS35CL9wx/BtVaEoq+nCkzl0/jM7PT3RUyEgw3P8lP2CvAemaSi9I7Euxc
Peq6BoQodCg+vMIloa7XI27TTow+npfbBgtJiN1u8r4gUoLHY9hpLqYkHOko
aEkKlaKylqVdt/Y8NLP91wyMCAypj9xflvMGumroMcXVBO6kNRULWudgj1/4
UglJ4A0B9+3eyhnQtZcFhG8QmLfimbJKIyC7LlLQO0CgrWuWqlWjGJKHfASH
jxHYzjstjJwTgNt9/6AdT6VINeqozCV44Oi5m9IyIkHJuzbW2INxcCki5/Oa
xOjluh78q8MweBhTRdExIuxhRN8v/vwlHDVVEZZKBChb/mvb15m1YM/za9Zw
4iN1s2RhS89d3P64qXBr6xT+uN/4Dif5OTJ7Eg3OtU+gdrXvxErEENLSdnGr
fhlFSvaGHVPARt+Tl4oDdIfQ5BmD+cSchyyzp+V9K92YSFxjsK4LUJ2aX3VE
vw1DzPxWU4+J8aC+2F1v/hZOcsPXnNakKDWOjzsRWw2yfV2Z1iEzKMzXoVyk
tYN5SQbhzpjD2sX0322ye8CmX5qqGfgGf+vVuHWSPQT5zYF+r8QKTClbWnz8
3RhsruR0uOuQKNxzMKI8fhIenis3ULtCImkkyrgQyoMCi/6Fs2MkcrrHK26f
58OLWmwULJOoohcV3f+VELxaXvwtkpOY95llaXqlCL6fcqGWNJFoojVlsTwr
huiPD/GvB5FYanE+Tr4uAU4aTSWhZB4bpt9WVbGlUE8w6RInBYYlBigWUggQ
r5lr7cyS47VTlwZdJgkYZhed9bk6i64LJ7wvbxLAEDqsVnnLMMP2Cj1BRgB9
wo0+PijBNkpxMKXwwwdy+043QxFKk46nVqgSMOpEjf/TkY8ahrdvOjpLoUih
rzTizcGKEo2tiw4S0L5rs61r9jXe08zNoL8XwQ7WOGQ+7EPdi1GneDlCCN6g
kekXWtFtS/YqW8GHjiVOmv2+SMhLjDBV9pkGPiP7DrOhDRKtnBUj8RxgVbZI
qAf6YcLiwafqPmyIVPVN/tZxFEZfqXvbLw5DrOVPBTX5HDBaUvedHekDCk+v
Pi+QD1nr0eGvGZ0QTd/96J9vRPCHA4umJnsERiGdXKpcAv8CdV8e4A==
     "]]}},
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 10}]], "Output",
 CellChangeTimes->{3.584367652733119*^9, 3.584368044133667*^9, 
  3.584368445654229*^9}],

Cell[BoxData[
 GraphicsBox[{LineBox[{{0., 0.75}, {1., 0.}}], 
   LineBox[{{-0.07487506248512112, 0.8211281864436404}, {0.9950041652780258, 
    0.09983341664682815}}], 
   LineBox[{{-0.1490019980962959, 0.884051931477227}, {0.9800665778412416, 
    0.19866933079506122`}}], 
   LineBox[{{-0.2216401549960047, 0.9381425218402092}, {0.955336489125606, 
    0.2955202066613396}}], 
   LineBox[{{-0.2920637567314879, 0.9828595022336517}, {0.9210609940028851, 
    0.3894183423086505}}], 
   LineBox[{{-0.35956915395315225`, 1.0177560753709318`}, {0.8775825618903728,
     0.479425538604203}}], 
   LineBox[{{-0.4234818550462766, 1.0424835662285352`}, {0.8253356149096782, 
    0.5646424733950355}}], 
   LineBox[{{-0.4831632654282684, 1.0567949058916346`}, {0.7648421872844884, 
    0.6442176872376911}}], 
   LineBox[{{-0.5380170681746421, 1.0605471001850162`}, {0.6967067093471654, 
    0.7173560908995228}}], 
   LineBox[{{-0.5874951822206126, 1.0537026584236107`}, {0.6216099682706644, 
    0.7833269096274834}}], 
   LineBox[{{-0.6311032386059223, 1.036329968007027}, {0.5403023058681397, 
    0.8414709848078965}}], 
   LineBox[{{-0.6684055200460766, 1.0086026111152595`}, {0.4535961214255773, 
    0.8912073600614354}}], 
   LineBox[{{-0.6990293144754198, 0.9707976303329248}, {0.3623577544766734, 
    0.9320390859672264}}], 
   LineBox[{{-0.7226686390628947, 0.9232927605313352}, {0.26749882862458735`, 
    0.963558185417193}}], 
   LineBox[{{-0.7390872974913452, 0.8665626546665258}, {0.16996714290024081`, 
    0.9854497299884603}}], 
   LineBox[{{-0.7481212399530408, 0.801174141203818}, {0.0707372016677029, 
    0.9974949866040544}}], 
   LineBox[{{-0.7496802022811289, 
    0.7277805605551622}, {-0.029199522301288815`, 0.9995736030415051}}], 
   LineBox[{{-0.7437486078393514, 0.6471152371177078}, {-0.12884449429552486`,
     0.9916648104524686}}], 
   LineBox[{{-0.7303857231586464, 0.5599841521388311}, {-0.2272020946930871, 
    0.9738476308781951}}], 
   LineBox[{{-0.7097250657655608, 0.4672578906179332}, {-0.3232895668635036, 
    0.9463000876874145}}], 
   LineBox[{{-0.6819730701192612, 0.36986294270890446`}, {-0.4161468365471424,
     0.9092974268256817}}], 
   LineBox[{{-0.6474070249866553, 0.26877244653676213`}, {-0.5048461045998576,
     0.8632093666488737}}], 
   LineBox[{{-0.6063723028646926, 0.1649964649231832}, {-0.5885011172553458, 
    0.8084964038195901}}], 
   LineBox[{{-0.5592789091325401, 0.0595718931726717}, {-0.6662760212798244, 
    0.74570521217672}}], 
   LineBox[{{-0.506597385413363, -0.046447901242571366`}, \
{-0.7373937155412458, 0.6754631805511506}}], 
   LineBox[{{-0.44885410807796744`, -0.15200360358223286`}, \
{-0.8011436155469337, 0.5984721441039565}}], 
   LineBox[{{-0.3866260288660981, -0.2560405361606124}, {-0.8568887533689473, 
    0.5155013718214642}}], 
   LineBox[{{-0.32053491017537233`, -0.3575191963374236}, \
{-0.9040721420170612, 0.4273798802338298}}], 
   LineBox[{{-0.2512411126169285, -0.4554256428845652}, {-0.9422223406686583, 
    0.33498815015590466`}}], 
   LineBox[{{-0.17943699691048648`, -0.5487816269517065}, \
{-0.9709581651495907, 0.23924932921398198`}}], 
   LineBox[{{-0.1058400060449004, -0.6366543664054336}, {-0.9899924966004454, 
    0.1411200080598672}}], 
   LineBox[{{-0.03118549682496787, -0.7181658658799918}, {-0.9991351502732795,
     0.04158066243329049}}], 
   LineBox[{{
    0.04378060757068507, -0.79250168941675}, {-0.9982947757947531, \
-0.058374143427580086`}}], 
   LineBox[{{
    0.11830927060743648`, -0.8589190980390852}, {-0.9874797699088649, \
-0.15774569414324865`}}], 
   LineBox[{{
    0.19165582652012375`, -0.9167544709547194}, {-0.9667981925794609, \
-0.25554110202683167`}}], 
   LineBox[{{
    0.26308742076721486`, -0.965429936235312}, {-0.9364566872907963, \
-0.35078322768961984`}}], 
   LineBox[{{
    0.33189033247113936`, -1.0044591447217497`}, {-0.896758416334147, \
-0.44252044329485246`}}], 
   LineBox[{{
    0.3973771056813701, -1.033452129464176}, {-0.848100031710408, \
-0.5298361409084934}}], 
   LineBox[{{
    0.45889341820703944`, -1.0521192021428518`}, {-0.7909677119144165, \
-0.6118578909427193}}], 
   LineBox[{{
    0.5158246193879805, -1.0602738475380855`}, {-0.7259323042001399, \
-0.6877661591839741}}], 
   LineBox[{{
    0.5676018714809461, -1.0578345871286552`}, {-0.6536436208636119, \
-0.7568024953079282}}], 
   LineBox[{{
    0.6137078332983081, -1.0448257931982594`}, {-0.5748239465332685, \
-0.8182771110644108}}], 
   LineBox[{{
    0.6536818293101911, -1.0213774453157156`}, {-0.4902608213406994, \
-0.8715757724135882}}], 
   LineBox[{{
    0.6871244525620912, -0.9877238316220727}, {-0.40079917207997545`, \
-0.9161659367494549}}], 
   LineBox[{{
    0.7137015554171371, -0.9442012079009515}, {-0.30733286997841935`, \
-0.9516020738895161}}], 
   LineBox[{{
    0.7331475882488228, -0.8912444378219075}, {-0.2107957994307797, \
-0.977530117665097}}], 
   LineBox[{{
    0.7452682527250984, -0.8293826479263889}, {-0.11215252693505398`, \
-0.9936910036334645}}], 
   LineBox[{{
    0.7499424431730757, -0.7592339407702435}, {-0.01238866346289056, \
-0.9999232575641008}}], 
   LineBox[{{0.7471234566268804, -0.6814992190472949}, {
    0.08749898343944727, -0.9961646088358406}}], 
   LineBox[{{0.7368394594682494, -0.5969551824013175}, {
    0.18651236942257576`, -0.9824526126243325}}], 
   LineBox[{{0.7191932059973538, -0.5064465668999341}, {
    0.28366218546322625`, -0.9589242746631385}}], 
   LineBox[{{0.6943610117457991, -0.41087770471106333`}, {
    0.37797774271298107`, -0.9258146823277321}}], 
   LineBox[{{0.6625909917901148, -0.311203488314832}, {
    0.4685166713003771, -0.8834546557201531}}], 
   LineBox[{{0.6242005816679256, -0.20841982953355445`}, {
    0.5543743361791615, -0.8322674422239008}}], 
   LineBox[{{0.5795733656669904, -0.10355370871001435`}, {
    0.6346928759426347, -0.7727644875559871}}], 
   LineBox[{{0.5291552441777939, 0.00234708654065105}, {
    0.70866977429126, -0.7055403255703919}}], 
   LineBox[{{0.47344997840424063`, 0.10822443047844699`}, {
    0.7755658785102502, -0.6312666378723208}}], 
   LineBox[{{0.4130141569482282, 0.21302043168114165`}, {
    0.8347127848391598, -0.5506855425976376}}], 
   LineBox[{{0.34845163456031747`, 0.3156880031456721}, {
    0.8855195169413194, -0.4646021794137566}}], 
   LineBox[{{0.280407498622677, 0.41520132443534996`}, {
    0.9274784307440359, -0.373876664830236}}], 
   LineBox[{{0.2095616236491944, 0.5105660913385801}, {
    0.960170286650366, -0.27941549819892586`}}], 
   LineBox[{{0.13662187820407126`, 0.6008294506278673}, {
    0.9832684384425847, -0.18216250427209502`}}], 
   LineBox[{{0.0623170521131223, 0.6850895206542909}, {
    0.9965420970232175, -0.0830894028174964}}], 
   LineBox[{{-0.5625, 0.5625}, {0., 0.75}}], 
   LineBox[{{-0.6158461398327303, 0.5596898429688895}, {-0.07487506248512112, 
    0.8211281864436404}}], 
   LineBox[{{-0.6630389486079202, 0.5512874500356983}, {-0.1490019980962959, 
    0.884051931477227}}], 
   LineBox[{{-0.7036068913801569, 0.5373767751331534}, {-0.2216401549960047, 
    0.9381425218402092}}], 
   LineBox[{{-0.7371446266752388, 0.5180968091266229}, {-0.2920637567314879, 
    0.9828595022336517}}], 
   LineBox[{{-0.7633170565281988, 0.4936401910633347}, {-0.35956915395315225`,
     1.0177560753709318`}}], 
   LineBox[{{-0.7818626746714015, 0.4642512833866939}, {-0.4234818550462766, 
    1.0424835662285352`}}], 
   LineBox[{{-0.792596179418726, 0.4302237303475247}, {-0.4831632654282684, 
    1.0567949058916346`}}], 
   LineBox[{{-0.7954103251387621, 0.39189752400778055`}, {-0.5380170681746421,
     1.0605471001850162`}}], 
   LineBox[{{-0.790276993817708, 0.3496556071522485}, {-0.5874951822206126, 
    1.0537026584236107`}}], 
   LineBox[{{-0.7772474760052703, 0.30392004705082853`}, {-0.6311032386059223,
     1.036329968007027}}], 
   LineBox[{{-0.7564519583364446, 0.2551478183018872}, {-0.6684055200460766, 
    1.0086026111152595`}}], 
   LineBox[{{-0.7280982227496936, 0.2038262368931287}, {-0.6990293144754198, 
    0.9707976303329248}}], 
   LineBox[{{-0.6924695703985014, 0.15046809110133041`}, {-0.7226686390628947,
     0.9232927605313352}}], 
   LineBox[{{-0.6499219909998943, 0.0956065178813855}, {-0.7390872974913452, 
    0.8665626546665258}}], 
   LineBox[{{-0.6008806059028635, 
    0.039789675938082913`}, {-0.7481212399530408, 0.801174141203818}}], 
   LineBox[{{-0.5458354204163716, -0.016424731294475026`}, \
{-0.7496802022811289, 0.7277805605551622}}], 
   LineBox[{{-0.48533642783828085`, -0.07247502804123268}, \
{-0.7437486078393514, 0.6471152371177078}}], 
   LineBox[{{-0.41998811410412334`, -0.12780117826486143`}, \
{-0.7303857231586464, 0.5599841521388311}}], 
   LineBox[{{-0.3504434179634499, -0.1818503813607207}, {-0.7097250657655608, 
    0.4672578906179332}}], 
   LineBox[{{-0.27739720703167836`, -0.23408259555776756`}, \
{-0.6819730701192612, 0.36986294270890446`}}], 
   LineBox[{{-0.2015793349025716, -0.2839759338374198}, {-0.6474070249866553, 
    0.26877244653676213`}}], 
   LineBox[{{-0.1237473486923874, -0.331031878456132}, {-0.6063723028646926, 
    0.1649964649231832}}], 
   LineBox[{{-0.04467891987950377, -0.3747802619699013}, {-0.5592789091325401,
     0.0595718931726717}}], 
   LineBox[{{
    0.034835925931928524`, -0.41478396499195075`}, {-0.506597385413363, \
-0.046447901242571366`}}], 
   LineBox[{{
    0.11400270268667465`, -0.4506432837451502}, {-0.44885410807796744`, \
-0.15200360358223286`}}], 
   LineBox[{{
    0.1920304021204593, -0.48199992377003287`}, {-0.3866260288660981, \
-0.2560405361606124}}], 
   LineBox[{{
    0.2681393972530677, -0.5085405798845969}, {-0.32053491017537233`, \
-0.3575191963374236}}], 
   LineBox[{{
    0.34156923216342394`, -0.5300000666261203}, {-0.2512411126169285, \
-0.4554256428845652}}], 
   LineBox[{{
    0.4115862202137799, -0.5461639678966448}, {-0.17943699691048648`, \
-0.5487816269517065}}], 
   LineBox[{{
    0.4774907748040752, -0.5568707793377505}, {-0.1058400060449004, \
-0.6366543664054336}}], 
   LineBox[{{
    0.5386243994099938, -0.5620135220287197}, {-0.03118549682496787, \
-0.7181658658799918}}], 
   LineBox[{{0.5943762670625625, -0.5615408113845488}, {
    0.04378060757068507, -0.79250168941675}}], 
   LineBox[{{0.6441893235293139, -0.5554573705737366}, {
    0.11830927060743648`, -0.8589190980390852}}], 
   LineBox[{{0.6875658532160396, -0.5438239833259468}, {
    0.19165582652012375`, -0.9167544709547194}}], 
   LineBox[{{0.7240724521764841, -0.5267568866010728}, {
    0.26308742076721486`, -0.965429936235312}}], 
   LineBox[{{0.7533443585413122, -0.5044266091879578}, {
    0.33189033247113936`, -1.0044591447217497`}}], 
   LineBox[{{0.7750890970981321, -0.47705626783710453`}, {
    0.3973771056813701, -1.033452129464176}}], 
   LineBox[{{0.7890894016071388, -0.4449193379518593}, {
    0.45889341820703944`, -1.0521192021428518`}}], 
   LineBox[{{0.7952053856535641, -0.40833692111257874`}, {
    0.5158246193879805, -1.0602738475380855`}}], 
   LineBox[{{0.7933759403464914, -0.3676745367357818}, {
    0.5676018714809461, -1.0578345871286552`}}], 
   LineBox[{{0.7836193448986946, -0.32333846992496346`}, {
    0.6137078332983081, -1.0448257931982594`}}], 
   LineBox[{{0.7660330839867867, -0.27577171200414335`}, {
    0.6536818293101911, -1.0213774453157156`}}], 
   LineBox[{{0.7407928737165546, -0.2254495342949861}, {
    0.6871244525620912, -0.9877238316220727}}], 
   LineBox[{{0.7081509059257136, -0.17287473936286082`}, {
    0.7137015554171371, -0.9442012079009515}}], 
   LineBox[{{0.6684333283664307, -0.11857263717981359`}, {
    0.7331475882488228, -0.8912444378219075}}], 
   LineBox[{{0.6220369859447917, -0.06308579640096787}, {
    0.7452682527250984, -0.8293826479263889}}], 
   LineBox[{{0.5694254555776826, -0.0069686231978758895`}, {
    0.7499424431730757, -0.7592339407702435}}], 
   LineBox[{{0.5111244142854712, 0.0492181781846891}, {
    0.7471234566268804, -0.6814992190472949}}], 
   LineBox[{{0.44771638680098813`, 0.10491320780019889`}, {
    0.7368394594682494, -0.5969551824013175}}], 
   LineBox[{{0.37983492517495054`, 0.15955997932306482`}, {
    0.7191932059973538, -0.5064465668999341}}], 
   LineBox[{{0.30815827853329747`, 0.21261248027605184`}, {
    0.6943610117457991, -0.41087770471106333`}}], 
   LineBox[{{0.23340261623612402`, 0.26354062760646213`}, {
    0.6625909917901148, -0.311203488314832}}], 
   LineBox[{{0.15631487215016585`, 0.3118355641007784}, {
    0.6242005816679256, -0.20841982953355445`}}], 
   LineBox[{{0.07766528153251076, 0.35701474271773204`}, {
    0.5795733656669904, -0.10355370871001435`}}], 
   LineBox[{{-0.0017603149054882875`, 0.39862674803883374`}, {
    0.5291552441777939, 0.00234708654065105}}], 
   LineBox[{{-0.08116832285883524, 0.4362558066620157}, {0.47344997840424063`,
     0.10822443047844699`}}], 
   LineBox[{{-0.15976532376085623`, 0.4695259414720274}, {0.4130141569482282, 
    0.21302043168114165`}}], 
   LineBox[{{-0.23676600235925405`, 0.4981047282794922}, {
    0.34845163456031747`, 0.3156880031456721}}], 
   LineBox[{{-0.3114009933265125, 0.5217066172935202}, {0.280407498622677, 
    0.41520132443534996`}}], 
   LineBox[{{-0.3829245685039351, 0.5400957862408309}, {0.2095616236491944, 
    0.5105660913385801}}], 
   LineBox[{{-0.4506220879709005, 0.5530884966239539}, {0.13662187820407126`, 
    0.6008294506278673}}], 
   LineBox[{{-0.5138171404907181, 0.5605549295755599}, {0.0623170521131223, 
    0.6850895206542909}}], LineBox[{{-0.421875, 0.}, {-0.5625, 0.5625}}], 
   LineBox[{{-0.4197673822266671, -0.04211722264788062}, {-0.6158461398327303,
     0.5596898429688895}}], 
   LineBox[{{-0.41346558752677376`, -0.08381362392916641}, \
{-0.6630389486079202, 0.5512874500356983}}], 
   LineBox[{{-0.4030325813498651, -0.12467258718525259`}, \
{-0.7036068913801569, 0.5373767751331534}}], 
   LineBox[{{-0.3885726068449672, -0.16428586316146193`}, \
{-0.7371446266752388, 0.5180968091266229}}], 
   LineBox[{{-0.37023014329750104`, -0.2022576490986481}, \
{-0.7633170565281988, 0.4936401910633347}}], 
   LineBox[{{-0.34818846254002045`, -0.23820854346353065`}, \
{-0.7818626746714015, 0.4642512833866939}}], 
   LineBox[{{-0.3226677977606435, -0.27177933680340094`}, {-0.792596179418726,
     0.4302237303475247}}], 
   LineBox[{{-0.29392314300583544`, -0.3026346008482361}, \
{-0.7954103251387621, 0.39189752400778055`}}], 
   LineBox[{{-0.2622417053641864, -0.33046603999909463`}, {-0.790276993817708,
     0.3496556071522485}}], 
   LineBox[{{-0.2279400352881214, -0.35499557171583135`}, \
{-0.7772474760052703, 0.30392004705082853`}}], 
   LineBox[{{-0.19136086372641542`, -0.3759781050259181}, \
{-0.7564519583364446, 0.2551478183018872}}], 
   LineBox[{{-0.15286967766984652`, -0.3932039893924236}, \
{-0.7280982227496936, 0.2038262368931287}}], 
   LineBox[{{-0.11285106832599781`, -0.40650110947287826`}, \
{-0.6924695703985014, 0.15046809110133041`}}], 
   LineBox[{{-0.07170488841103911, -0.41573660483888164`}, \
{-0.6499219909998943, 0.0956065178813855}}], 
   LineBox[{{-0.029842256953562185`, -0.42081819747358545`}, \
{-0.6008806059028635, 0.039789675938082913`}}], 
   LineBox[{{
    0.01231854847085627, -0.4216951137831349}, {-0.5458354204163716, \
-0.016424731294475026`}}], 
   LineBox[{{
    0.05435627103092451, -0.41835859190963515`}, {-0.48533642783828085`, \
-0.07247502804123268}}], 
   LineBox[{{
    0.09585088369864607, -0.41084196927673855`}, {-0.41998811410412334`, \
-0.12780117826486143`}}], 
   LineBox[{{
    0.13638778602054052`, -0.399220349493128}, {-0.3504434179634499, \
-0.1818503813607207}}], 
   LineBox[{{
    0.17556194666832567`, -0.3836098519420844}, {-0.27739720703167836`, \
-0.23408259555776756`}}], 
   LineBox[{{
    0.21298195037806486`, -0.3641664515549936}, {-0.2015793349025716, \
-0.2839759338374198}}], 
   LineBox[{{
    0.24827390884209902`, -0.3410844203613896}, {-0.1237473486923874, \
-0.331031878456132}}], 
   LineBox[{{
    0.28108519647742597`, -0.3145943863870538}, {-0.04467891987950377, \
-0.3747802619699013}}], 
   LineBox[{{0.3110879737439631, -0.28496102929501665`}, {
    0.034835925931928524`, -0.41478396499195075`}}], 
   LineBox[{{0.3379824628088627, -0.2524804357938567}, {
    0.11400270268667465`, -0.4506432837451502}}], 
   LineBox[{{0.3614999428275246, -0.21747714123718018`}, {
    0.1920304021204593, -0.48199992377003287`}}], 
   LineBox[{{0.3814054349134477, -0.1803008869736469}, {
    0.2681393972530677, -0.5085405798845969}}], 
   LineBox[{{0.3975000499695902, -0.14132312584702228`}, {
    0.34156923216342394`, -0.5300000666261203}}], 
   LineBox[{{0.4096229759224836, -0.10093331076214868`}, {
    0.4115862202137799, -0.5461639678966448}}], 
   LineBox[{{0.4176530845033129, -0.0595350034002565}, {
    0.4774907748040752, -0.5568707793377505}}], 
   LineBox[{{0.42151014152153976`, -0.017541841964044375`}, {
    0.5386243994099938, -0.5620135220287197}}], 
   LineBox[{{0.4211556085384116, 0.024626591758510286`}, {
    0.5943762670625625, -0.5615408113845488}}], 
   LineBox[{{0.4165930279303024, 0.066548964716683}, {
    0.6441893235293139, -0.5554573705737366}}], 
   LineBox[{{0.4078679874944601, 0.10780640241756956`}, {
    0.6875658532160396, -0.5438239833259468}}], 
   LineBox[{{0.3950676649508046, 0.14798667418155848`}, {
    0.7240724521764841, -0.5267568866010728}}], 
   LineBox[{{0.3783199568909683, 0.18668831201501582`}, {
    0.7533443585413122, -0.5044266091879578}}], 
   LineBox[{{0.35779220087782837`, 0.2235246219457707}, {
    0.7750890970981321, -0.47705626783710453`}}], 
   LineBox[{{0.3336895034638945, 0.25812754774145963`}, {
    0.7890894016071388, -0.4449193379518593}}], 
   LineBox[{{0.30625269083443407`, 0.29015134840573903`}, {
    0.7952053856535641, -0.40833692111257874`}}], 
   LineBox[{{0.27575590255183635`, 0.31927605270803217`}, {
    0.7933759403464914, -0.3676745367357818}}], 
   LineBox[{{0.24250385244372258`, 0.34521065623029834`}, {
    0.7836193448986946, -0.32333846992496346`}}], 
   LineBox[{{0.2068287840031075, 0.3676960289869825}, {
    0.7660330839867867, -0.27577171200414335`}}], 
   LineBox[{{0.1690871507212396, 0.3865075045661764}, {
    0.7407928737165546, -0.2254495342949861}}], 
   LineBox[{{0.12965605452214563`, 0.4014571249221396}, {
    0.7081509059257136, -0.17287473936286082`}}], 
   LineBox[{{0.08892947788486019, 0.4123955183899628}, {
    0.6684333283664307, -0.11857263717981359`}}], 
   LineBox[{{0.0473143473007259, 0.4192133921578679}, {
    0.6220369859447917, -0.06308579640096787}}], 
   LineBox[{{0.005226467398406917, 0.42184262428485503`}, {
    0.5694254555776826, -0.0069686231978758895`}}], 
   LineBox[{{-0.036913633638516824`, 0.4202569443526202}, {0.5111244142854712,
     0.0492181781846891}}], 
   LineBox[{{-0.07868490585014917, 0.41447219595089024`}, {
    0.44771638680098813`, 0.10491320780019889`}}], 
   LineBox[{{-0.11966998449229861`, 0.4045461783735115}, {
    0.37983492517495054`, 0.15955997932306482`}}], 
   LineBox[{{-0.15945936020703888`, 0.390578069107012}, {0.30815827853329747`,
     0.21261248027605184`}}], 
   LineBox[{{-0.1976554707048466, 0.37270743288193964`}, {
    0.23340261623612402`, 0.26354062760646213`}}], 
   LineBox[{{-0.2338766730755838, 0.35111282718820813`}, {
    0.15631487215016585`, 0.3118355641007784}}], 
   LineBox[{{-0.267761057038299, 0.32601001818768205`}, {0.07766528153251076, 
    0.35701474271773204`}}], 
   LineBox[{{-0.2989700610291253, 
    0.2976498248500091}, {-0.0017603149054882875`, 0.39862674803883374`}}], 
   LineBox[{{-0.32719185499651177`, 
    0.26631561285238536`}, {-0.08116832285883524, 0.4362558066620157}}], 
   LineBox[{{-0.35214445610402056`, 
    0.2323204632833784}, {-0.15976532376085623`, 0.4695259414720274}}], 
   LineBox[{{-0.37357854620961917`, 
    0.1960040444401786}, {-0.23676600235925405`, 0.4981047282794922}}], 
   LineBox[{{-0.3912799629701401, 0.15772921797525577`}, {-0.3114009933265125,
     0.5217066172935202}}], 
   LineBox[{{-0.40507183968062316`, 
    0.11787841330267185`}, {-0.3829245685039351, 0.5400957862408309}}], 
   LineBox[{{-0.41481637246796543`, 
    0.07684980648979005}, {-0.4506220879709005, 0.5530884966239539}}], 
   LineBox[{{-0.4204161971816699, 0.03505334181363129}, {-0.5138171404907181, 
    0.5605549295755599}}], 
   {GrayLevel[0], PointSize[Large], PointBox[CompressedData["
1:eJw1hgsw2wccgI1iVOfRlpXi5t1WvO9iVH/UqOLqWW+zmbZDVaauJqOrjZ6x
2s5U0/WMpivWzqMETTx+6LIUY+IVFo8gJPL6pz2pOq623W7f3Xff915qduQF
dTU1NfjHf/sfSvj/Bkwat414BDiOlI80VzCBmpp3m5FEQM+Ej/Ve1hCwdJyn
zCsV4MFi3R7dmIDXdL4oOl8OmZdObHjJZiG8MFHL4bAMlJohueLmRTiUGHTS
Ll0CCX4PTW4ZrkBlTW1kdb4YmEcC06/UCOEC7bPFzJB1GH2Dg1Wb63B0pbLa
S7gKfo3JNA3DDSjX6tB3CF4GhZ7Od9FyCRh+zNF6qr0Anp+QQtnFMhjP965a
dOEB+7wp3X9SDimhxz9tt+BCiAV7O29aARqxB3u+GGCDxvIHS6OlBDRss8Om
zdqgPMvxHlVKgLtxCpu6XoPs0wJO0S4BFZfpm9uF/dhJc+Z1dRNAfcc2THVo
FJWHe4sGjxHQEuDB/L11CmM9TS1NghSgmRMVa0f/CwMZXMmrd+Uw/BNtX7u9
AHdypJBeKwVKU2mI2vQKvs17NOe+tAFCZxcTq8g1tHKOI3HnRVDK/Z7BoomQ
xn2mSqtZg8LyEmKLvoFPhv880GK3CpTNG6/uZ0qxu6Sue/e6AOo1LrY7KGSo
12Bj45rAh1BKbF6LnQL715KtcyjTMOz7gG9sROCkS9DM09oxmFgr6dvXTGDi
dGeWp8Eg2NTHnJG8JtDJgPaVfvBD6Bxhrmi/JNCNJH6fvNqEnfsbHLPvEnhH
r2tY3fU3VO/78Jm6UoG5oXsGQwnjmGI6oJG7JUfLVNZ176szGO84wTjVJsMX
XKW/X+Q8kucKm+jWUvQzc5JlbApQ3Mgvvhe2gXX9sr2YqlUUPfdInfES4Vi7
JclJfR0HbPha9RIhNlvMLzDJYkwjZbio0law9/kKNcpZguacMtmVj5Zw1mh8
6eWqFKO8jSuf1M+hbdlbXt4Rcnw0mFoQ+3gSlQ4BrjevKjDDJy46cWcYb/hy
fORnCCy7FX9Cu7MHWbLkgxF/EOiREe7vlfINRsrI+il7BH7pey7u/MVO2PPR
+7FKQGCacYH9gyUO/Cy1uuZLIXAuOJNSYj8B7ncFqqIWBT5OElYMucwC02r2
aGCdHBUZ5HjS7gLwbFhtpwNkOO+WC9m9y0A26okm7kvw21bb7EthQqBout0p
YIkxaEr75OWmdYht1T039MM6Fut+XZrNFQNDVW0S4y7E428OVG91SKCOQz1L
rl1G+5wGLVKMDIaXKji6PQt4LHz7lKhJDma9+9Noch6qrD7X6WIqoJ/eWvZi
mYsM2tkU4hoBSTvuvCMRHBz7Jd/311UCzEf7+HEBHfg3aMAd2w==
     "]]}, 
   {GrayLevel[0.5], PointSize[Large], PointBox[CompressedData["
1:eJxVkvs71QccgF3SlDHJ5tLT5jrN7TkukzXzOVJ0mD0il6fHI5ehaMihrI5L
LaVEDdmZy4lIqqVyya3HB5XHLUMcnOPYuX8PTseXjHKZtR/3Ps/7vP/AaxyR
4BeloqSkBB/8r/9HBuETNfqqVvU4Ze3PqvWYBc3Q+KMZOs8x1LjRw8JLDj/o
McMaQgfwCx/aGXc1BdzI5dtaPxlBFeWAlzfp85B8wDnIVnUcd4VRmK2HSPhI
eKbS35CL9wx/BtVaEoq+nCkzl0/jM7PT3RUyEgw3P8lP2CvAemaSi9I7Euxc
Peq6BoQodCg+vMIloa7XI27TTow+npfbBgtJiN1u8r4gUoLHY9hpLqYkHOko
aEkKlaKylqVdt/Y8NLP91wyMCAypj9xflvMGumroMcXVBO6kNRULWudgj1/4
UglJ4A0B9+3eyhnQtZcFhG8QmLfimbJKIyC7LlLQO0CgrWuWqlWjGJKHfASH
jxHYzjstjJwTgNt9/6AdT6VINeqozCV44Oi5m9IyIkHJuzbW2INxcCki5/Oa
xOjluh78q8MweBhTRdExIuxhRN8v/vwlHDVVEZZKBChb/mvb15m1YM/za9Zw
4iN1s2RhS89d3P64qXBr6xT+uN/4Dif5OTJ7Eg3OtU+gdrXvxErEENLSdnGr
fhlFSvaGHVPARt+Tl4oDdIfQ5BmD+cSchyyzp+V9K92YSFxjsK4LUJ2aX3VE
vw1DzPxWU4+J8aC+2F1v/hZOcsPXnNakKDWOjzsRWw2yfV2Z1iEzKMzXoVyk
tYN5SQbhzpjD2sX0322ye8CmX5qqGfgGf+vVuHWSPQT5zYF+r8QKTClbWnz8
3RhsruR0uOuQKNxzMKI8fhIenis3ULtCImkkyrgQyoMCi/6Fs2MkcrrHK26f
58OLWmwULJOoohcV3f+VELxaXvwtkpOY95llaXqlCL6fcqGWNJFoojVlsTwr
huiPD/GvB5FYanE+Tr4uAU4aTSWhZB4bpt9WVbGlUE8w6RInBYYlBigWUggQ
r5lr7cyS47VTlwZdJgkYZhed9bk6i64LJ7wvbxLAEDqsVnnLMMP2Cj1BRgB9
wo0+PijBNkpxMKXwwwdy+043QxFKk46nVqgSMOpEjf/TkY8ahrdvOjpLoUih
rzTizcGKEo2tiw4S0L5rs61r9jXe08zNoL8XwQ7WOGQ+7EPdi1GneDlCCN6g
kekXWtFtS/YqW8GHjiVOmv2+SMhLjDBV9pkGPiP7DrOhDRKtnBUj8RxgVbZI
qAf6YcLiwafqPmyIVPVN/tZxFEZfqXvbLw5DrOVPBTX5HDBaUvedHekDCk+v
Pi+QD1nr0eGvGZ0QTd/96J9vRPCHA4umJnsERiGdXKpcAv8CdV8e4A==
     "]]}, 
   {GrayLevel[0.8], PointSize[Large], PointBox[CompressedData["
1:eJwtkX0w2wccxo2luk5no/VWnBihJxX1fk59u462o2uvarVGrBZv67y11Lvr
rdXO22xxlOY22m5ehrhDMaJ84+W81MtECPGW30+QZOqqjC05ZXbbc/fc5z5/
PvdQ2XH+4ZoaGhqw33/5Xxbxf0LFl53bms0yZOXH8tQKEg5ItBNL3ZYxzEa/
yLqchClVEncjcwVTE5n9Do4kdAv2rtQXy5GXF9UNRQTYcs4vGcYoUP2Spj1S
IoXdKhfp2xQlJkYItfxa5sHEraF6g6VE74JN08HsWdBZrmVq3FZi/BAwJUck
IPo0Ur3xiRJZXuHKrhAx/PmHr7GrVIGsqtoPYhJEYPpj1/MZZwVyaWOZgQFj
cDdXWl50QY7ayu4ItcELeND34nWz7Qq+fMiYzDnTA6NJ7zgfH17Cla6HTrWp
rUBXLm3f8JAh0dqpunS9HGpUW1PpySRyMii6FUIO+syfeyDQlaIp39WpLb8R
Sy80io6SM2g5fX9nMEiADkZjHjUxYgwdZXKkZ/uRp9ZxIwRC9CZOWUZtj2Bc
cBqFOTKIPzfahVfTx5Hezt2T1yGa96gCnjAm0V4V2W9DVCLpYsCM2JnCm3vO
zVrip9C2avnueN4MFssa/jrH6IA1z6S1q1NzaKRK6U0oGoBdvcsuBpIFtKLd
sXY8LoTD7P0hPgSa5Ac7+sxNgh2D+qx7i0DbIBE/JnAG4ifyZulpJOa6pie7
/LAAZy/b1S4KSZSF5Xje8CThdofFgNYOifa8ghAqRQaP7mXHWf1NIqvp8Zpj
6RKUbJvlXOwjkW1UZ5KrsQKLvsv5b0WSGHuo6w3XTg4TZaZnTs4SuLspfBJ+
TAGb7i0+H1sReL/tZmXWiAK+KDqhZZi9gKz2+q/dTyuBYp689X3qHNK+fczx
j993drr9ScsZfHW0av2zUCUE5bT0q7OmMN43iPhKXwm6CcniwoYJ5OpFjwVm
KmBP971wr0ohhpn/9lFhkxz4mtd6s2aHsa+u0YBevQJvTF5FdVv04WrGT76j
octg5CPr7GN2ohn19TG+XAZl19kHw2j1OK+sbG93X4TTyfw8al4GXmXfKqYG
EcA5+LmWhVM1DLOHn7Kr5sCRG/VdySwfvPxDrN0uTYNrU4p5UnQvrDfqfTPf
KoLTCoFg0XUIHqX1Hv6QGAEanXFPMj8G+S0kw0KzF9zb2DZmWyLQvOPmLCWf
QVnEoeAAiRgs4gae+02xUDia3WOcKYFfg2kZ8f1NOBFVmFq6OgstHn48h4Re
XO/4PbtFZwGOUFLsr10cxZiQjKoNQgpj0oLY3TURGp6K1h9vIGBg6Bcd8d1p
rCm8spV0ngTjE7wDu+I5XA7nVqw0kmBEEZY73Nr/Jc576f11Ev4BkAMd3A==

     "]]}, 
   {GrayLevel[0.9], PointSize[Large], PointBox[CompressedData["
1:eJw1knlMkwcYxplD3Go3K3LPDu10Q5RLCAIa3lmFoRRDAVEgBQbIkcBKHGAN
gtIxAwwG9WAgGwuXQDjLFRwdL1cpVzl6f5/iHGiBBTnEMCQcY1n2JE9+z7+/
5DkcxvW5tktHRwd2+i//y1P8f1EUFbt4kyTGrvyeHJ5XgUYdB4OdkkgcOSZy
G0toRcfGPccvDBPoYFYzn/UXIp9dUhbyXIPMX0Ut7D1iFNlxxIRQje95mTMe
TA+ihjrJbPdQ4cXnWuPilFFcqW1T5j9WYMtRuYUyYgLzNQ3vl43JcGOLnc4J
lqN4YS9XMDCOa7tzPwj6XImU5LRHn1lJca604Sq0q1Dr3O72XeoAtnu68/Ro
GhRb60tPC3ox2KmfdtaSwKlQCY5OizCX3elC193xYDdGfhnUhCQ9rCWuiERv
w+LVv38sxrhbr683LJCoccnIv+GSCZedKu58tEmipbFs5KGiBgiLPHp4P4n2
5yXr9ZntwM+6QT/jSeKQ2fnaLxK7IcvclS/PJtA+uj5gnNcPZkuH/Gk5Glz5
odt4izkMutUL0juX1FhXnnQ7XjIG3KNV6KtQYkxVXi9rcwLEUcxUb4YCh20D
MyZn5aBx4thIz8iwqc7kZFqJEvR8K5vLLMbRdXSjcpyhhpo/i29dVA2jwYHg
K2+iNbA8n5pkaiDBrn4htTyeANJZ7fXCqAdrOtkXzp0iwWFu5G2v6gnOvevS
UfxGAjXjiHNIcj1aH7Sr3b1OQoGXrVHKqgBf9rIqHd+SQNM+LWg7VQhTy7XS
xGoSiq9TggI/FILvktqPb0aCzkQ9y76wA1wXLKcHPQgYZb4+6bLcA7GXBbMR
jho4bOe7P+qVBNxtwpj7tSrYluZ8k/DzCKT7mzodD1LC3Z7FqGPfj0N65rOp
8kI5tKL+qkogA92ZAcONigmYemIn1+UqIP9EczeHMgahAQ3cBWMVbBk//Ilz
cwi0uep5vww1UHuY8opyMQhYy2uZIg24+q2MCwq6ICvwnvNNIQGyby33Gfa1
Qeynh040RpAQl3ufmu9cBZ1wJTpCQUI8MWwREJ0I12zUDrxtEmL1+Luuakvx
kt/61ymvSNA2eVcLj7SgLKkuvO0uCeyPW62EpZ3ITEusNHxJgG19Hs0ypg9Z
HH+L09sacO5xP9fPGkSjfVL3eFINCkODjppFKQY3pC6W8FSwOiJx22bs/Nzh
nnnApALoRY99fBlyHNIlCCFVDn/kWX/StqRA75CZMu+9E5AwWqTNyFThC9tt
zzqRFHw8ftlsnVWjIjvUpNpoEEqDGPQOCoE5MzEPeLZ9cJuzyW2aJ7Bcn/Lo
K6tO0JhErgVkk3jg2X1pXG0zuFdG+pvOkkjbjH7Hf1MC/wDxsBfG
     "]]}},
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 10}]], "Output",
 CellChangeTimes->{3.584367652733119*^9, 3.584368044133667*^9, 
  3.584368445674229*^9}],

Cell[BoxData["\<\"maps_examps.eps\"\>"], "Output",
 CellChangeTimes->{3.584367652733119*^9, 3.584368044133667*^9, 
  3.5843684457642293`*^9}],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], PointSize[Large], PointBox[CompressedData["
1:eJw1hgsw2wccgI1iVOfRlpXi5t1WvO9iVH/UqOLqWW+zmbZDVaauJqOrjZ6x
2s5U0/WMpivWzqMETTx+6LIUY+IVFo8gJPL6pz2pOq623W7f3Xff915qduQF
dTU1NfjHf/sfSvj/Bkwat414BDiOlI80VzCBmpp3m5FEQM+Ej/Ve1hCwdJyn
zCsV4MFi3R7dmIDXdL4oOl8OmZdObHjJZiG8MFHL4bAMlJohueLmRTiUGHTS
Ll0CCX4PTW4ZrkBlTW1kdb4YmEcC06/UCOEC7bPFzJB1GH2Dg1Wb63B0pbLa
S7gKfo3JNA3DDSjX6tB3CF4GhZ7Od9FyCRh+zNF6qr0Anp+QQtnFMhjP965a
dOEB+7wp3X9SDimhxz9tt+BCiAV7O29aARqxB3u+GGCDxvIHS6OlBDRss8Om
zdqgPMvxHlVKgLtxCpu6XoPs0wJO0S4BFZfpm9uF/dhJc+Z1dRNAfcc2THVo
FJWHe4sGjxHQEuDB/L11CmM9TS1NghSgmRMVa0f/CwMZXMmrd+Uw/BNtX7u9
AHdypJBeKwVKU2mI2vQKvs17NOe+tAFCZxcTq8g1tHKOI3HnRVDK/Z7BoomQ
xn2mSqtZg8LyEmKLvoFPhv880GK3CpTNG6/uZ0qxu6Sue/e6AOo1LrY7KGSo
12Bj45rAh1BKbF6LnQL715KtcyjTMOz7gG9sROCkS9DM09oxmFgr6dvXTGDi
dGeWp8Eg2NTHnJG8JtDJgPaVfvBD6Bxhrmi/JNCNJH6fvNqEnfsbHLPvEnhH
r2tY3fU3VO/78Jm6UoG5oXsGQwnjmGI6oJG7JUfLVNZ176szGO84wTjVJsMX
XKW/X+Q8kucKm+jWUvQzc5JlbApQ3Mgvvhe2gXX9sr2YqlUUPfdInfES4Vi7
JclJfR0HbPha9RIhNlvMLzDJYkwjZbio0law9/kKNcpZguacMtmVj5Zw1mh8
6eWqFKO8jSuf1M+hbdlbXt4Rcnw0mFoQ+3gSlQ4BrjevKjDDJy46cWcYb/hy
fORnCCy7FX9Cu7MHWbLkgxF/EOiREe7vlfINRsrI+il7BH7pey7u/MVO2PPR
+7FKQGCacYH9gyUO/Cy1uuZLIXAuOJNSYj8B7ncFqqIWBT5OElYMucwC02r2
aGCdHBUZ5HjS7gLwbFhtpwNkOO+WC9m9y0A26okm7kvw21bb7EthQqBout0p
YIkxaEr75OWmdYht1T039MM6Fut+XZrNFQNDVW0S4y7E428OVG91SKCOQz1L
rl1G+5wGLVKMDIaXKji6PQt4LHz7lKhJDma9+9Noch6qrD7X6WIqoJ/eWvZi
mYsM2tkU4hoBSTvuvCMRHBz7Jd/311UCzEf7+HEBHfg3aMAd2w==
     "]]}, 
   {GrayLevel[0.5], PointSize[Large], PointBox[CompressedData["
1:eJxVkvs71QccgF3SlDHJ5tLT5jrN7TkukzXzOVJ0mD0il6fHI5ehaMihrI5L
LaVEDdmZy4lIqqVyya3HB5XHLUMcnOPYuX8PTseXjHKZtR/3Ps/7vP/AaxyR
4BeloqSkBB/8r/9HBuETNfqqVvU4Ze3PqvWYBc3Q+KMZOs8x1LjRw8JLDj/o
McMaQgfwCx/aGXc1BdzI5dtaPxlBFeWAlzfp85B8wDnIVnUcd4VRmK2HSPhI
eKbS35CL9wx/BtVaEoq+nCkzl0/jM7PT3RUyEgw3P8lP2CvAemaSi9I7Euxc
Peq6BoQodCg+vMIloa7XI27TTow+npfbBgtJiN1u8r4gUoLHY9hpLqYkHOko
aEkKlaKylqVdt/Y8NLP91wyMCAypj9xflvMGumroMcXVBO6kNRULWudgj1/4
UglJ4A0B9+3eyhnQtZcFhG8QmLfimbJKIyC7LlLQO0CgrWuWqlWjGJKHfASH
jxHYzjstjJwTgNt9/6AdT6VINeqozCV44Oi5m9IyIkHJuzbW2INxcCki5/Oa
xOjluh78q8MweBhTRdExIuxhRN8v/vwlHDVVEZZKBChb/mvb15m1YM/za9Zw
4iN1s2RhS89d3P64qXBr6xT+uN/4Dif5OTJ7Eg3OtU+gdrXvxErEENLSdnGr
fhlFSvaGHVPARt+Tl4oDdIfQ5BmD+cSchyyzp+V9K92YSFxjsK4LUJ2aX3VE
vw1DzPxWU4+J8aC+2F1v/hZOcsPXnNakKDWOjzsRWw2yfV2Z1iEzKMzXoVyk
tYN5SQbhzpjD2sX0322ye8CmX5qqGfgGf+vVuHWSPQT5zYF+r8QKTClbWnz8
3RhsruR0uOuQKNxzMKI8fhIenis3ULtCImkkyrgQyoMCi/6Fs2MkcrrHK26f
58OLWmwULJOoohcV3f+VELxaXvwtkpOY95llaXqlCL6fcqGWNJFoojVlsTwr
huiPD/GvB5FYanE+Tr4uAU4aTSWhZB4bpt9WVbGlUE8w6RInBYYlBigWUggQ
r5lr7cyS47VTlwZdJgkYZhed9bk6i64LJ7wvbxLAEDqsVnnLMMP2Cj1BRgB9
wo0+PijBNkpxMKXwwwdy+043QxFKk46nVqgSMOpEjf/TkY8ahrdvOjpLoUih
rzTizcGKEo2tiw4S0L5rs61r9jXe08zNoL8XwQ7WOGQ+7EPdi1GneDlCCN6g
kekXWtFtS/YqW8GHjiVOmv2+SMhLjDBV9pkGPiP7DrOhDRKtnBUj8RxgVbZI
qAf6YcLiwafqPmyIVPVN/tZxFEZfqXvbLw5DrOVPBTX5HDBaUvedHekDCk+v
Pi+QD1nr0eGvGZ0QTd/96J9vRPCHA4umJnsERiGdXKpcAv8CdV8e4A==
     "]]}, 
   {GrayLevel[0.8], PointSize[Large], PointBox[CompressedData["
1:eJwtkX0w2wccxo2luk5no/VWnBihJxX1fk59u462o2uvarVGrBZv67y11Lvr
rdXO22xxlOY22m5ehrhDMaJ84+W81MtECPGW30+QZOqqjC05ZXbbc/fc5z5/
PvdQ2XH+4ZoaGhqw33/5Xxbxf0LFl53bms0yZOXH8tQKEg5ItBNL3ZYxzEa/
yLqchClVEncjcwVTE5n9Do4kdAv2rtQXy5GXF9UNRQTYcs4vGcYoUP2Spj1S
IoXdKhfp2xQlJkYItfxa5sHEraF6g6VE74JN08HsWdBZrmVq3FZi/BAwJUck
IPo0Ur3xiRJZXuHKrhAx/PmHr7GrVIGsqtoPYhJEYPpj1/MZZwVyaWOZgQFj
cDdXWl50QY7ayu4ItcELeND34nWz7Qq+fMiYzDnTA6NJ7zgfH17Cla6HTrWp
rUBXLm3f8JAh0dqpunS9HGpUW1PpySRyMii6FUIO+syfeyDQlaIp39WpLb8R
Sy80io6SM2g5fX9nMEiADkZjHjUxYgwdZXKkZ/uRp9ZxIwRC9CZOWUZtj2Bc
cBqFOTKIPzfahVfTx5Hezt2T1yGa96gCnjAm0V4V2W9DVCLpYsCM2JnCm3vO
zVrip9C2avnueN4MFssa/jrH6IA1z6S1q1NzaKRK6U0oGoBdvcsuBpIFtKLd
sXY8LoTD7P0hPgSa5Ac7+sxNgh2D+qx7i0DbIBE/JnAG4ifyZulpJOa6pie7
/LAAZy/b1S4KSZSF5Xje8CThdofFgNYOifa8ghAqRQaP7mXHWf1NIqvp8Zpj
6RKUbJvlXOwjkW1UZ5KrsQKLvsv5b0WSGHuo6w3XTg4TZaZnTs4SuLspfBJ+
TAGb7i0+H1sReL/tZmXWiAK+KDqhZZi9gKz2+q/dTyuBYp689X3qHNK+fczx
j993drr9ScsZfHW0av2zUCUE5bT0q7OmMN43iPhKXwm6CcniwoYJ5OpFjwVm
KmBP971wr0ohhpn/9lFhkxz4mtd6s2aHsa+u0YBevQJvTF5FdVv04WrGT76j
octg5CPr7GN2ohn19TG+XAZl19kHw2j1OK+sbG93X4TTyfw8al4GXmXfKqYG
EcA5+LmWhVM1DLOHn7Kr5sCRG/VdySwfvPxDrN0uTYNrU4p5UnQvrDfqfTPf
KoLTCoFg0XUIHqX1Hv6QGAEanXFPMj8G+S0kw0KzF9zb2DZmWyLQvOPmLCWf
QVnEoeAAiRgs4gae+02xUDia3WOcKYFfg2kZ8f1NOBFVmFq6OgstHn48h4Re
XO/4PbtFZwGOUFLsr10cxZiQjKoNQgpj0oLY3TURGp6K1h9vIGBg6Bcd8d1p
rCm8spV0ngTjE7wDu+I5XA7nVqw0kmBEEZY73Nr/Jc576f11Ev4BkAMd3A==

     "]]}, 
   {GrayLevel[0.9], PointSize[Large], PointBox[CompressedData["
1:eJw1knlMkwcYxplD3Go3K3LPDu10Q5RLCAIa3lmFoRRDAVEgBQbIkcBKHGAN
gtIxAwwG9WAgGwuXQDjLFRwdL1cpVzl6f5/iHGiBBTnEMCQcY1n2JE9+z7+/
5DkcxvW5tktHRwd2+i//y1P8f1EUFbt4kyTGrvyeHJ5XgUYdB4OdkkgcOSZy
G0toRcfGPccvDBPoYFYzn/UXIp9dUhbyXIPMX0Ut7D1iFNlxxIRQje95mTMe
TA+ihjrJbPdQ4cXnWuPilFFcqW1T5j9WYMtRuYUyYgLzNQ3vl43JcGOLnc4J
lqN4YS9XMDCOa7tzPwj6XImU5LRHn1lJca604Sq0q1Dr3O72XeoAtnu68/Ro
GhRb60tPC3ox2KmfdtaSwKlQCY5OizCX3elC193xYDdGfhnUhCQ9rCWuiERv
w+LVv38sxrhbr683LJCoccnIv+GSCZedKu58tEmipbFs5KGiBgiLPHp4P4n2
5yXr9ZntwM+6QT/jSeKQ2fnaLxK7IcvclS/PJtA+uj5gnNcPZkuH/Gk5Glz5
odt4izkMutUL0juX1FhXnnQ7XjIG3KNV6KtQYkxVXi9rcwLEUcxUb4YCh20D
MyZn5aBx4thIz8iwqc7kZFqJEvR8K5vLLMbRdXSjcpyhhpo/i29dVA2jwYHg
K2+iNbA8n5pkaiDBrn4htTyeANJZ7fXCqAdrOtkXzp0iwWFu5G2v6gnOvevS
UfxGAjXjiHNIcj1aH7Sr3b1OQoGXrVHKqgBf9rIqHd+SQNM+LWg7VQhTy7XS
xGoSiq9TggI/FILvktqPb0aCzkQ9y76wA1wXLKcHPQgYZb4+6bLcA7GXBbMR
jho4bOe7P+qVBNxtwpj7tSrYluZ8k/DzCKT7mzodD1LC3Z7FqGPfj0N65rOp
8kI5tKL+qkogA92ZAcONigmYemIn1+UqIP9EczeHMgahAQ3cBWMVbBk//Ilz
cwi0uep5vww1UHuY8opyMQhYy2uZIg24+q2MCwq6ICvwnvNNIQGyby33Gfa1
Qeynh040RpAQl3ufmu9cBZ1wJTpCQUI8MWwREJ0I12zUDrxtEmL1+Luuakvx
kt/61ymvSNA2eVcLj7SgLKkuvO0uCeyPW62EpZ3ITEusNHxJgG19Hs0ypg9Z
HH+L09sacO5xP9fPGkSjfVL3eFINCkODjppFKQY3pC6W8FSwOiJx22bs/Nzh
nnnApALoRY99fBlyHNIlCCFVDn/kWX/StqRA75CZMu+9E5AwWqTNyFThC9tt
zzqRFHw8ftlsnVWjIjvUpNpoEEqDGPQOCoE5MzEPeLZ9cJuzyW2aJ7Bcn/Lo
K6tO0JhErgVkk3jg2X1pXG0zuFdG+pvOkkjbjH7Hf1MC/wDxsBfG
     "]]}},
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 10}]], "Output",
 CellChangeTimes->{3.584367652733119*^9, 3.584368044133667*^9, 
  3.5843684457642293`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1165, 669},
WindowMargins->{{Automatic, 27}, {32, Automatic}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 673, 13, 135, "Subtitle"],
Cell[1255, 37, 5904, 85, 118, "Subtitle"],
Cell[CellGroupData[{
Cell[7184, 126, 106, 4, 97, "Section"],
Cell[7293, 132, 10971, 169, 212, "Input"],
Cell[18267, 303, 412, 8, 62, "Text"],
Cell[18682, 313, 719, 18, 92, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19438, 336, 178, 5, 97, "Section"],
Cell[19619, 343, 137, 1, 28, "Text"],
Cell[19759, 346, 18083, 381, 892, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37879, 732, 149, 5, 79, "Section"],
Cell[CellGroupData[{
Cell[38053, 741, 9329, 240, 1032, "Input"],
Cell[47385, 983, 9846, 194, 395, "Output"],
Cell[57234, 1179, 26366, 510, 395, "Output"],
Cell[83603, 1691, 141, 2, 30, "Output"],
Cell[83747, 1695, 6092, 105, 395, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
