(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     50366,       1551]
NotebookOptionsPosition[     45745,       1401]
NotebookOutlinePosition[     46089,       1416]
CellTagsIndexPosition[     46046,       1413]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", Cell[TextData[{
   StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
    FontWeight->"Bold",
    FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
   StyleBox[
   "\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis Group, An A \
K Peters Book, 2013",
    FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
   "\n"
  }], "Subtitle",
   CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
    3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
    3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
    3.5842134956497355`*^9, 3.5842135862546945`*^9}},
   FontFamily->"Arial"]}]], "Subtitle",
 CellChangeTimes->{{3.584277171972*^9, 3.584277185012018*^9}}],

Cell[TextData[{
 "\n",
 StyleBox["Condition number of a matrix",
  FontWeight->"Bold"],
 "\nThis notebook looks at several examples of the condition number of a \
matrix.\n"
}], "Subsubtitle",
 CellChangeTimes->{{3.5554180965597506`*^9, 3.5554181061693673`*^9}, 
   3.5554181469166393`*^9, {3.584277394882312*^9, 3.5842773990823183`*^9}, {
   3.5842788743564525`*^9, 3.5842788865464697`*^9}, {3.5842916701437345`*^9, 
   3.584291696293771*^9}}],

Cell[CellGroupData[{

Cell["\<\

Routine to find condition number of input matrix m via SVD and print it along \
with the determinant of the matrix\
\>", "Section",
 CellChangeTimes->{{3.5842774166823425`*^9, 3.5842774658324113`*^9}, {
  3.584284408093977*^9, 3.5842844121239824`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"showcondnum", "[", "m_", "]"}], " ", ":=", " ", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"\"\<  matrix = \>\"", ",", 
       RowBox[{"MatrixForm", "[", "m", "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"sigma", " ", "=", 
      RowBox[{"SingularValueList", "[", "m", "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"cond", " ", "=", " ", 
      RowBox[{
       RowBox[{"sigma", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "/", 
       RowBox[{"sigma", "[", 
        RowBox[{"[", 
         RowBox[{"Length", "[", "m", "]"}], "]"}], "]"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\< singular values = \>\"", ",", 
       RowBox[{"sigma", "//", "N"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\< condition number = \>\"", ",", 
       RowBox[{"cond", "//", "N"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\< determinant = \>\"", ",", 
       RowBox[{
        RowBox[{"Det", "[", "m", "]"}], "//", "N"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "\"\< \>\"", "]"}], ";"}], "\[IndentingNewLine]", 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.5554190032021427`*^9, 3.555419112979536*^9}, {
  3.555419251148978*^9, 3.55541930890028*^9}, {3.555419371144389*^9, 
  3.555419375449997*^9}, {3.5554194355569024`*^9, 3.5554194579741416`*^9}, {
  3.5554195536023097`*^9, 3.555419560575522*^9}, {3.5555212231245623`*^9, 
  3.555521251891012*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

Create some input matrices and call condition number routine above\
\>", "Section",
 CellChangeTimes->{{3.5554181130489798`*^9, 3.5554181621266656`*^9}, {
  3.5554182283331823`*^9, 3.5554182492996187`*^9}, {3.5842778754825144`*^9, 
  3.58427789372254*^9}, {3.5842779817526627`*^9, 3.584277990962676*^9}, {
  3.584284424063999*^9, 3.584284439624021*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Matrix", " ", "that", " ", "needs", " ", "pivoting"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"mat", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"showcondnum", "[", "mat", "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "After", " ", "one", " ", "step", " ", "of", " ", "GE", " ", "and", " ", 
     "one", " ", "row", " ", 
     RowBox[{"exchange", " ", "--"}], " ", "pivot"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<One step GE and one row change \>\"", "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "2"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"showcondnum", "[", "mat2", "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"row", " ", "echelon", " ", "form"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<Row echelon form\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"showcondnum", "[", "mat3", "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5553685882999907`*^9, 3.5553686325705223`*^9}, {
   3.555368725770853*^9, 3.5553687411767344`*^9}, {3.5553688630687065`*^9, 
   3.555368905670143*^9}, {3.555368973244008*^9, 3.5553691092377863`*^9}, {
   3.5554181699422793`*^9, 3.5554181845439053`*^9}, {3.5554182941652975`*^9, 
   3.555418298954506*^9}, {3.5554183893566647`*^9, 3.555418400994285*^9}, {
   3.555419231009343*^9, 3.5554192445189667`*^9}, {3.5554193400067344`*^9, 
   3.5554193456539445`*^9}, {3.555419483620587*^9, 3.5554195380958824`*^9}, {
   3.555419620947628*^9, 3.555419634566452*^9}, {3.5842779131425667`*^9, 
   3.584277932672594*^9}, 3.584277977532657*^9, {3.584278013112707*^9, 
   3.5842780221827197`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2", "2", "0"},
       {"1", "1", "2"},
       {"2", "1", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["  matrix = ", 
   MatrixForm[{{2, 2, 0}, {1, 1, 2}, {2, 1, 1}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296073103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" singular values = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "4.096206398565977`", ",", "1.7003768794470395`", ",", 
     "0.5742922672203559`"}], "}"}]}],
  SequenceForm[
  " singular values = ", {4.096206398565977, 1.7003768794470395`, 
   0.5742922672203559}],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296073103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" condition number = \"\>", "\[InvisibleSpace]", 
   "7.1326163216372604`"}],
  SequenceForm[" condition number = ", 7.1326163216372604`],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296073103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" determinant = \"\>", "\[InvisibleSpace]", "4.`"}],
  SequenceForm[" determinant = ", 4.],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296073103*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.584278296073103*^9}],

Cell[BoxData["\<\"One step GE and one row change \"\>"], "Print",
 CellChangeTimes->{3.584278296073103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2", "2", "0"},
       {"0", 
        RowBox[{"-", "1"}], "1"},
       {"0", "0", "2"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["  matrix = ", 
   MatrixForm[{{2, 2, 0}, {0, -1, 1}, {0, 0, 2}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296073103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" singular values = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "2.9471759644707913`", ",", "2.222918540959682`", ",", 
     "0.6105628507396584`"}], "}"}]}],
  SequenceForm[
  " singular values = ", {2.9471759644707913`, 2.222918540959682, 
   0.6105628507396584}],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296083103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" condition number = \"\>", "\[InvisibleSpace]", 
   "4.826982121333575`"}],
  SequenceForm[" condition number = ", 4.826982121333575],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296083103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" determinant = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "4.`"}]}],
  SequenceForm[" determinant = ", -4.],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296083103*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.584278296083103*^9}],

Cell[BoxData["\<\"Row echelon form\"\>"], "Print",
 CellChangeTimes->{3.584278296083103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0"},
       {"0", "1", 
        RowBox[{"-", "1"}]},
       {"0", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["  matrix = ", 
   MatrixForm[{{1, 0, 0}, {0, 1, -1}, {0, 0, 1}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296083103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" singular values = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1.618033988749895`", ",", "1.`", ",", "0.6180339887498948`"}], 
    "}"}]}],
  SequenceForm[
  " singular values = ", {1.618033988749895, 1., 0.6180339887498948}],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296083103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" condition number = \"\>", "\[InvisibleSpace]", 
   "2.618033988749895`"}],
  SequenceForm[" condition number = ", 2.618033988749895],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296083103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" determinant = \"\>", "\[InvisibleSpace]", "1.`"}],
  SequenceForm[" determinant = ", 1.],
  Editable->False]], "Print",
 CellChangeTimes->{3.5842782960931034`*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.5842782960931034`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

What is condition number of shear?\
\>", "Section",
 CellChangeTimes->{{3.5554180745793123`*^9, 3.5554180925661435`*^9}, {
   3.5554184135055075`*^9, 3.5554184469051657`*^9}, {3.5842844678740606`*^9, 
   3.584284468974062*^9}, 3.5842845062641144`*^9, {3.5842845479016967`*^9, 
   3.5842845483016973`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Print", "[", "\"\<Shear \>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"shear", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"showcondnum", "[", "shear", "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.555416960971648*^9, 3.555417068533837*^9}, {
  3.555419574849547*^9, 3.555419608420806*^9}, {3.555419705218976*^9, 
  3.5554197057025766`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Shear \"\>"], "Print",
 CellChangeTimes->{3.584278296113103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0"},
       {"2", "1", "0"},
       {"4", "0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["  matrix = ", 
   MatrixForm[{{1, 0, 0}, {2, 1, 0}, {4, 0, 1}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296113103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" singular values = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4.685557720282968`", ",", "1.`", ",", "0.2134217652833884`"}], 
    "}"}]}],
  SequenceForm[
  " singular values = ", {4.685557720282968, 1., 0.2134217652833884}],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296113103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" condition number = \"\>", "\[InvisibleSpace]", 
   "21.954451150103324`"}],
  SequenceForm[" condition number = ", 21.954451150103324`],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296113103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" determinant = \"\>", "\[InvisibleSpace]", "1.`"}],
  SequenceForm[" determinant = ", 1.],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296113103*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.584278296123103*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Print", "[", "\"\<Matrix that needs pivoting\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.0001", ",", " ", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"showcondnum", "[", "a", "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<After pivot\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"anew", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.0001", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"showcondnum", "[", "anew", "]"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.55541880228939*^9, 3.555418871569112*^9}, {
  3.555418931488817*^9, 3.5554189776960983`*^9}, {3.5554192035220947`*^9, 
  3.555419221228126*^9}, {3.5554195843655634`*^9, 3.5554195891235723`*^9}, {
  3.5554196553924885`*^9, 3.55541969598376*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Matrix that needs pivoting\"\>"], "Print",
 CellChangeTimes->{3.584278296143103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.0001`", "1"},
       {"1", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["  matrix = ", 
   MatrixForm[{{0.0001, 1}, {1, 1}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296143103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" singular values = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1.6180616289645644`", ",", "0.6179616289645649`"}], "}"}]}],
  SequenceForm[
  " singular values = ", {1.6180616289645644`, 0.6179616289645649}],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296143103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" condition number = \"\>", "\[InvisibleSpace]", 
   "2.6183852736548263`"}],
  SequenceForm[" condition number = ", 2.6183852736548263`],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296143103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" determinant = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.9999`"}]}],
  SequenceForm[" determinant = ", -0.9999],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296143103*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.584278296143103*^9}],

Cell[BoxData["\<\"After pivot\"\>"], "Print",
 CellChangeTimes->{3.584278296153103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "1"},
       {"0.0001`", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["  matrix = ", 
   MatrixForm[{{1, 1}, {0.0001, 1}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296153103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" singular values = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1.6180616289645648`", ",", "0.617961628964565`"}], "}"}]}],
  SequenceForm[
  " singular values = ", {1.6180616289645648`, 0.617961628964565}],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296153103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" condition number = \"\>", "\[InvisibleSpace]", 
   "2.6183852736548268`"}],
  SequenceForm[" condition number = ", 2.6183852736548268`],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296153103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" determinant = \"\>", "\[InvisibleSpace]", "0.9999`"}],
  SequenceForm[" determinant = ", 0.9999],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296153103*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.584278296153103*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

This is an example from Burdon Faires & Reynolds\
\>", "Section",
 CellChangeTimes->{{3.55561678736178*^9, 3.555616816206231*^9}, 
   3.5556169342552385`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", " ", "+", " ", 
        RowBox[{"2", "y"}]}], " ", "\[Equal]", " ", "3"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"1.0001", "x"}], " ", "+", " ", 
        RowBox[{"2", "y"}]}], " ", "\[Equal]", " ", "3.0001"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", " ", "+", " ", 
        RowBox[{"2", "y"}]}], " ", "\[Equal]", " ", "3"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"1.0001", "x"}], " ", "+", " ", 
        RowBox[{"2", "y"}]}], " ", "\[Equal]", " ", "3.0002"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.0001", ",", "2"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"showcondnum", "[", "b", "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.5554281742866735`*^9, 3.555428226733966*^9}, {
  3.555530224277323*^9, 3.555530235852543*^9}, {3.555616883274349*^9, 
  3.555616884428751*^9}, {3.5556169534900723`*^9, 3.5556169767185135`*^9}, {
  3.5556171122047515`*^9, 3.5556171476636133`*^9}, {3.5556171969441004`*^9, 
  3.5556171970533004`*^9}, {3.5556174462637377`*^9, 3.555617448993743*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "1.0000000000022204`"}], ",", 
    RowBox[{"y", "\[Rule]", "0.9999999999988898`"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.5842782961731033`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "1.9999999999999998`"}], ",", 
    RowBox[{"y", "\[Rule]", "0.5000000000000001`"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.584278296183103*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "2"},
       {"1.0001`", "2"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["  matrix = ", 
   MatrixForm[{{1, 2}, {1.0001, 2}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296183103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" singular values = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"3.1623092837355555`", ",", "0.00006324492073807787`"}], "}"}]}],
  SequenceForm[
  " singular values = ", {3.1623092837355555`, 0.00006324492073807787}],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296183103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" condition number = \"\>", "\[InvisibleSpace]", 
   "50001.000030214665`"}],
  SequenceForm[" condition number = ", 50001.000030214665`],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296183103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" determinant = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.00019999999999997797`"}]}],
  SequenceForm[" determinant = ", -0.00019999999999997797`],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296183103*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.584278296183103*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", "2"}], ")"}], "x"}], " ", "+", " ", "y"}], " ", 
     "\[Equal]", " ", 
     RowBox[{"3", "/", "2"}]}], " ", "&&", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1.0001", "/", "2"}], ")"}], "x"}], " ", "+", " ", "y"}], " ",
      "\[Equal]", " ", 
     RowBox[{"3.0001", "/", "2"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", "2"}], ")"}], "x"}], " ", "+", " ", "y"}], " ", 
     "\[Equal]", " ", 
     RowBox[{"3", "/", "2"}]}], " ", "&&", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1.0001", "/", "2"}], ")"}], "x"}], " ", "+", " ", "y"}], " ",
      "\[Equal]", " ", 
     RowBox[{"3.0002", "/", "2"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b2", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1.0001", "/", "2"}], ",", "1"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"showcondnum", "[", "b2", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.5556171921704917`*^9, 3.555617193824095*^9}, {
  3.5556175353086944`*^9, 3.55561762894646*^9}, {3.5556176732817373`*^9, 
  3.555617675699742*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "1.0000000000022204`"}], ",", 
    RowBox[{"y", "\[Rule]", "0.9999999999988898`"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.584278296203103*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "1.9999999999999998`"}], ",", 
    RowBox[{"y", "\[Rule]", "0.5000000000000001`"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.5842782962131033`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox["1", "2"], "1"},
       {"0.50005`", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["  matrix = ", 
   MatrixForm[{{
      Rational[1, 2], 1}, {0.50005, 1}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.5842782962131033`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" singular values = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1.5811546418677778`", ",", "0.000031622460369038934`"}], "}"}]}],
  SequenceForm[
  " singular values = ", {1.5811546418677778`, 0.000031622460369038934`}],
  Editable->False]], "Print",
 CellChangeTimes->{3.5842782962131033`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" condition number = \"\>", "\[InvisibleSpace]", 
   "50001.000030214665`"}],
  SequenceForm[" condition number = ", 50001.000030214665`],
  Editable->False]], "Print",
 CellChangeTimes->{3.5842782962131033`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" determinant = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.00004999999999999449`"}]}],
  SequenceForm[" determinant = ", -0.00004999999999999449],
  Editable->False]], "Print",
 CellChangeTimes->{3.5842782962131033`*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.5842782962131033`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Another example", "Section",
 CellChangeTimes->{{3.584284582201745*^9, 3.5842845914417577`*^9}}],

Cell["\<\

This is an example from a webpage.
The second system differs from the first on the rhs only.
This is supposed to be an example of high condition number leading to a small \
change in rhs causing a rather large difference in result -- or is it? What \
is large?
The change in intersection of the two lines is not a surprise. 
The det of matrix is not very small.\
\>", "Text",
 CellChangeTimes->{{3.5556156823466387`*^9, 3.555615698773468*^9}, {
  3.555615823526887*^9, 3.5556158952558126`*^9}, {3.555617024891398*^9, 
  3.5556170471526375`*^9}, {3.5556172930246687`*^9, 3.555617363271592*^9}, {
  3.5842788211463776`*^9, 3.5842788215663786`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", " ", "+", " ", 
        RowBox[{"0.5", "y"}]}], " ", "\[Equal]", " ", 
       RowBox[{"3", "/", "2"}]}], " ", "&&", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"1", "/", "2"}], "x"}], " ", "+", " ", 
        RowBox[{
         RowBox[{"1", "/", "3"}], "y"}]}], " ", "\[Equal]", " ", "1"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", " ", "+", " ", 
        RowBox[{"0.5", "y"}]}], " ", "\[Equal]", " ", 
       RowBox[{"3", "/", "2"}]}], " ", "&&", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"1", "/", "2"}], "x"}], " ", "+", " ", 
        RowBox[{
         RowBox[{"1", "/", "3"}], "y"}]}], " ", "\[Equal]", " ", 
       RowBox[{"5", "/", "6"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", " ", 
         RowBox[{"1", "/", "3"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"showcondnum", "[", "c", "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.555532563236231*^9, 3.5555326307843494`*^9}, {
  3.555532668645616*^9, 3.555532689034852*^9}, {3.5555328706503706`*^9, 
  3.5555328722415733`*^9}, {3.5555332678894687`*^9, 3.5555332711186743`*^9}, {
  3.555615608137309*^9, 3.5556156091201105`*^9}, {3.5556160345016575`*^9, 
  3.5556160400708675`*^9}, {3.555617230218959*^9, 3.5556172471293883`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "0.`"}], ",", 
    RowBox[{"y", "\[Rule]", "3.`"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.5842782962331033`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "1.`"}], ",", 
    RowBox[{"y", "\[Rule]", "1.`"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.584278296243103*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", 
        FractionBox["1", "2"]},
       {
        FractionBox["1", "2"], 
        FractionBox["1", "3"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["  matrix = ", 
   MatrixForm[{{1, 
      Rational[1, 2]}, {
      Rational[1, 2], 
      Rational[1, 3]}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296243103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" singular values = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1.2675918792439982`", ",", "0.06574145408933511`"}], "}"}]}],
  SequenceForm[
  " singular values = ", {1.2675918792439982`, 0.06574145408933511}],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296243103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" condition number = \"\>", "\[InvisibleSpace]", 
   "19.28147006790397`"}],
  SequenceForm[" condition number = ", 19.28147006790397],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296243103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" determinant = \"\>", "\[InvisibleSpace]", 
   "0.08333333333333333`"}],
  SequenceForm[" determinant = ", 0.08333333333333333],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296243103*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.584278296243103*^9}]
}, Open  ]]
}, Open  ]],

Cell["\<\

This is the same example as the previous one, but the equations have been \
multiplied so the y - coeff is 1.
Problem is the same, but the matrices are different, thus a different \
condition number\
\>", "Text",
 CellChangeTimes->{{3.555616446235981*^9, 3.5556165043148828`*^9}, {
  3.5556173809464235`*^9, 3.5556174064836683`*^9}},
 FontFamily->"Tahoma"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"2", "x"}], " ", "+", " ", "y"}], " ", "\[Equal]", " ", "3"}],
       " ", "&&", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"3", "/", "2"}], "x"}], " ", "+", " ", "y"}], " ", 
       "\[Equal]", " ", "3"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"2", "x"}], " ", "+", " ", "y"}], " ", "\[Equal]", " ", "3"}],
       " ", "&&", " ", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"3", "/", "2"}], "x"}], " ", "+", " ", "y"}], " ", 
       "\[Equal]", " ", 
       RowBox[{"5", "/", "2"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c2", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"3", "/", "2"}], ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"showcondnum", "[", "c2", "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.5556156695078163`*^9, 3.5556156753890266`*^9}, {
  3.5556157263231163`*^9, 3.5556158182228775`*^9}, {3.555615945285101*^9, 
  3.5556159591691256`*^9}, {3.555615993832386*^9, 3.555616023566038*^9}, {
  3.555616082206541*^9, 3.55561608715175*^9}, {3.5556163075517373`*^9, 
  3.555616341388197*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "0"}], ",", 
    RowBox[{"y", "\[Rule]", "3"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.584278296273103*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "1"}], ",", 
    RowBox[{"y", "\[Rule]", "1"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.584278296273103*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2", "1"},
       {
        FractionBox["3", "2"], "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["  matrix = ", 
   MatrixForm[{{2, 1}, {
      Rational[3, 2], 1}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296273103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" singular values = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2.8669818343581808`", ",", "0.17439943079093007`"}], "}"}]}],
  SequenceForm[
  " singular values = ", {2.8669818343581808`, 0.17439943079093007`}],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296273103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" condition number = \"\>", "\[InvisibleSpace]", 
   "16.43916967707949`"}],
  SequenceForm[" condition number = ", 16.43916967707949],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296273103*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" determinant = \"\>", "\[InvisibleSpace]", "0.5`"}],
  SequenceForm[" determinant = ", 0.5],
  Editable->False]], "Print",
 CellChangeTimes->{3.584278296273103*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.584278296273103*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

This example is from Forsythe, Malcolm, Moler (p44)\
\>", "Section",
 CellChangeTimes->{{3.5556183378413057`*^9, 3.5556183627857494`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"4.1", "x"}], "+", 
      RowBox[{"2.8", "y"}]}], " ", "\[Equal]", " ", "4.1"}], "&&", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"9.7", "x"}], " ", "+", " ", 
      RowBox[{"6.6", "y"}]}], " ", "\[Equal]", " ", "9.7"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"4.1", "x"}], "+", 
      RowBox[{"2.8", "y"}]}], " ", "\[Equal]", " ", "4.11"}], "&&", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"9.7", "x"}], " ", "+", " ", 
      RowBox[{"6.6", "y"}]}], " ", "\[Equal]", " ", "9.70"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4.1", ",", " ", "2.8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9.7", ",", "6.6"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"showcondnum", "[", "d", "]"}], ";"}], "\[IndentingNewLine]", 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"solp", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"0.34", ",", " ", "0.97"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"4.1", ",", " ", "9.7"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bp", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"4.11", ",", " ", "9.7"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"deltasol", " ", "=", " ", 
   RowBox[{"sol", " ", "-", " ", "solp"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"deltab", " ", "=", " ", 
   RowBox[{"b", " ", "-", " ", "bp"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rdeltab", " ", "=", " ", 
   RowBox[{
    RowBox[{"Norm", "[", "deltab", "]"}], "/", 
    RowBox[{"Norm", "[", "b", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rdeltasol", " ", "=", " ", 
   RowBox[{
    RowBox[{"Norm", "[", "deltasol", "]"}], "/", 
    RowBox[{"Norm", "[", "sol", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Norm b=\>\"", ",", 
    RowBox[{"Norm", "[", "b", "]"}], ",", "\"\<  Norm x=\>\"", ",", 
    RowBox[{
     RowBox[{"Norm", "[", "sol", "]"}], "//", "N"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{
   "\"\<Relative changes: \>\"", ",", "rdeltab", ",", "\"\<  \>\"", ",", 
    "rdeltasol"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Cond Num >= \>\"", ",", 
     RowBox[{"rdeltasol", "/", "rdeltab"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5555341713650556`*^9, 3.5555342288199563`*^9}, {
  3.555534260768812*^9, 3.5555343058216915`*^9}, {3.5555343643373947`*^9, 
  3.5555343644777946`*^9}, {3.5555351966456566`*^9, 3.5555352628833723`*^9}, {
  3.5556179409002075`*^9, 3.555617993004299*^9}, {3.5556181073525*^9, 
  3.555618120456523*^9}, {3.5556183712877645`*^9, 3.555618444529893*^9}, {
  3.555618499317189*^9, 3.55561853965886*^9}, {3.555618597737762*^9, 
  3.5556187253771863`*^9}, {3.555618846012198*^9, 3.5556189543387885`*^9}, {
  3.5556189914044533`*^9, 3.555619021886907*^9}, {3.555619235059682*^9, 
  3.555619367831515*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "1.`"}], ",", 
    RowBox[{"y", "\[Rule]", "0.`"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.584278296293103*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "0.3399999999999742`"}], ",", 
    RowBox[{"y", "\[Rule]", "0.9700000000000378`"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.5842782963031034`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"4.1`", "2.8`"},
       {"9.7`", "6.6`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["  matrix = ", 
   MatrixForm[{{4.1, 2.8}, {9.7, 6.6}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.5842782963031034`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" singular values = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"12.739699305151673`", ",", "0.00784947883028568`"}], "}"}]}],
  SequenceForm[
  " singular values = ", {12.739699305151673`, 0.00784947883028568}],
  Editable->False]], "Print",
 CellChangeTimes->{3.5842782963031034`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" condition number = \"\>", "\[InvisibleSpace]", 
   "1622.9993838569296`"}],
  SequenceForm[" condition number = ", 1622.9993838569296`],
  Editable->False]], "Print",
 CellChangeTimes->{3.5842782963031034`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\" determinant = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.10000000000000007`"}]}],
  SequenceForm[" determinant = ", -0.10000000000000007`],
  Editable->False]], "Print",
 CellChangeTimes->{3.5842782963031034`*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.5842782963031034`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Norm b=\"\>", "\[InvisibleSpace]", "10.530906893520612`", 
   "\[InvisibleSpace]", "\<\"  Norm x=\"\>", "\[InvisibleSpace]", "1.`"}],
  SequenceForm["Norm b=", 10.530906893520612`, "  Norm x=", 1.],
  Editable->False]], "Print",
 CellChangeTimes->{3.5842782963031034`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Relative changes: \"\>", "\[InvisibleSpace]", 
   "0.0009495858335005706`", "\[InvisibleSpace]", "\<\"  \"\>", 
   "\[InvisibleSpace]", "1.173243367763057`"}],
  SequenceForm[
  "Relative changes: ", 0.0009495858335005706, "  ", 1.173243367763057],
  Editable->False]], "Print",
 CellChangeTimes->{3.5842782963031034`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cond Num >= \"\>", "\[InvisibleSpace]", "1235.531666935248`"}],
  SequenceForm["Cond Num >= ", 1235.531666935248],
  Editable->False]], "Print",
 CellChangeTimes->{3.5842782963031034`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1284, 709},
WindowMargins->{{Automatic, 52}, {14, Automatic}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 826, 16, 201, "Subtitle"],
Cell[1408, 40, 444, 10, 86, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1877, 54, 263, 6, 97, "Section"],
Cell[2143, 62, 1647, 38, 212, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3827, 105, 364, 7, 97, "Section"],
Cell[CellGroupData[{
Cell[4216, 116, 2926, 74, 312, "Input"],
Cell[CellGroupData[{
Cell[7167, 194, 873, 24, 70, "Print"],
Cell[8043, 220, 405, 11, 32, "Print"],
Cell[8451, 233, 258, 6, 32, "Print"],
Cell[8712, 241, 211, 5, 32, "Print"],
Cell[8926, 248, 77, 1, 32, "Print"],
Cell[9006, 251, 107, 1, 32, "Print"],
Cell[9116, 254, 898, 25, 70, "Print"],
Cell[10017, 281, 405, 11, 32, "Print"],
Cell[10425, 294, 255, 6, 32, "Print"],
Cell[10683, 302, 231, 6, 32, "Print"],
Cell[10917, 310, 77, 1, 32, "Print"],
Cell[10997, 313, 92, 1, 32, "Print"],
Cell[11092, 316, 898, 25, 70, "Print"],
Cell[11993, 343, 362, 9, 32, "Print"],
Cell[12358, 354, 255, 6, 32, "Print"],
Cell[12616, 362, 213, 5, 32, "Print"],
Cell[12832, 369, 79, 1, 32, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12972, 377, 316, 7, 143, "Section"],
Cell[CellGroupData[{
Cell[13313, 388, 756, 21, 125, "Input"],
Cell[CellGroupData[{
Cell[14094, 413, 82, 1, 32, "Print"],
Cell[14179, 416, 873, 24, 70, "Print"],
Cell[15055, 442, 362, 9, 32, "Print"],
Cell[15420, 453, 258, 6, 32, "Print"],
Cell[15681, 461, 211, 5, 32, "Print"],
Cell[15895, 468, 77, 1, 32, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16021, 475, 1290, 36, 260, "Input"],
Cell[CellGroupData[{
Cell[17336, 515, 102, 1, 32, "Print"],
Cell[17441, 518, 833, 23, 49, "Print"],
Cell[18277, 543, 344, 8, 32, "Print"],
Cell[18624, 553, 258, 6, 32, "Print"],
Cell[18885, 561, 239, 6, 32, "Print"],
Cell[19127, 569, 77, 1, 32, "Print"],
Cell[19207, 572, 87, 1, 32, "Print"],
Cell[19297, 575, 833, 23, 49, "Print"],
Cell[20133, 600, 342, 8, 32, "Print"],
Cell[20478, 610, 258, 6, 32, "Print"],
Cell[20739, 618, 219, 5, 32, "Print"],
Cell[20961, 625, 77, 1, 32, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21099, 633, 169, 5, 143, "Section"],
Cell[CellGroupData[{
Cell[21293, 642, 1606, 42, 152, "Input"],
Cell[22902, 686, 239, 6, 42, "Output"],
Cell[23144, 694, 237, 6, 42, "Output"],
Cell[CellGroupData[{
Cell[23406, 704, 833, 23, 49, "Print"],
Cell[24242, 729, 352, 8, 32, "Print"],
Cell[24597, 739, 258, 6, 32, "Print"],
Cell[24858, 747, 272, 6, 32, "Print"],
Cell[25133, 755, 77, 1, 32, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25259, 762, 1660, 54, 125, "Input"],
Cell[26922, 818, 237, 6, 42, "Output"],
Cell[27162, 826, 239, 6, 42, "Output"],
Cell[CellGroupData[{
Cell[27426, 836, 884, 25, 66, "Print"],
Cell[28313, 863, 357, 8, 32, "Print"],
Cell[28673, 873, 260, 6, 32, "Print"],
Cell[28936, 881, 273, 6, 32, "Print"],
Cell[29212, 889, 79, 1, 32, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29352, 897, 102, 1, 105, "Section"],
Cell[29457, 900, 657, 13, 202, "Text"],
Cell[CellGroupData[{
Cell[30139, 917, 1886, 52, 152, "Input"],
Cell[32028, 971, 207, 6, 42, "Output"],
Cell[32238, 979, 205, 6, 42, "Output"],
Cell[CellGroupData[{
Cell[32468, 989, 963, 29, 79, "Print"],
Cell[33434, 1020, 346, 8, 32, "Print"],
Cell[33783, 1030, 255, 6, 32, "Print"],
Cell[34041, 1038, 249, 6, 32, "Print"],
Cell[34293, 1046, 77, 1, 32, "Print"]
}, Open  ]]
}, Open  ]],
Cell[34397, 1051, 367, 9, 96, "Text"],
Cell[CellGroupData[{
Cell[34789, 1064, 1627, 48, 152, "Input"],
Cell[36419, 1114, 201, 6, 42, "Output"],
Cell[36623, 1122, 201, 6, 42, "Output"],
Cell[CellGroupData[{
Cell[36849, 1132, 869, 25, 66, "Print"],
Cell[37721, 1159, 347, 8, 32, "Print"],
Cell[38071, 1169, 255, 6, 32, "Print"],
Cell[38329, 1177, 213, 5, 32, "Print"],
Cell[38545, 1184, 77, 1, 32, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[38683, 1192, 149, 4, 143, "Section"],
Cell[CellGroupData[{
Cell[38857, 1200, 3612, 98, 503, "Input"],
Cell[42472, 1300, 205, 6, 42, "Output"],
Cell[42680, 1308, 239, 6, 42, "Output"],
Cell[CellGroupData[{
Cell[42944, 1318, 844, 23, 49, "Print"],
Cell[43791, 1343, 348, 8, 32, "Print"],
Cell[44142, 1353, 260, 6, 32, "Print"],
Cell[44405, 1361, 268, 6, 32, "Print"],
Cell[44676, 1369, 79, 1, 32, "Print"],
Cell[44758, 1372, 321, 6, 32, "Print"],
Cell[45082, 1380, 371, 8, 32, "Print"],
Cell[45456, 1390, 237, 5, 32, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
