(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     18019,        472]
NotebookOptionsPosition[     17578,        452]
NotebookOutlinePosition[     17922,        467]
CellTagsIndexPosition[     17879,        464]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 "\n"
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
  3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
  3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
  3.5842134956497355`*^9, 3.5842135862546945`*^9}},
 FontFamily->"Arial"],

Cell[TextData[{
 "\n",
 StyleBox["Conics from plane/cone intersection",
  FontWeight->"Bold"],
 "\nConic sections -- parabola, ellipse, hyperbola -- are created from \
cone/plane intersections.\nThis nb was used to create chapter figure for \
Chapter 19 Conics."
}], "Subsubtitle",
 CellChangeTimes->{{3.584290204711683*^9, 3.5842902718717766`*^9}, {
  3.584290437072008*^9, 3.584290457082036*^9}, {3.584291865364008*^9, 
  3.5842918959240503`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "make", " ", "a", " ", "plane", " ", "in", " ", "the", " ", "xy", " ", 
    "plane"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"baseplane", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Plane", " ", "for", " ", "ellipse", " ", "intersection"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eangle", " ", "=", " ", "20"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Rellipse", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"eangle", " ", "Degree"}], "]"}], ",", " ", "0", ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"eangle", " ", "Degree"}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", "\t\t    ", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
       "\t             ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Sin", "[", 
           RowBox[{"eangle", " ", "Degree"}], "]"}]}], ",", " ", "0", ",", 
         " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"eangle", " ", "Degree"}], "]"}]}], "}"}]}], "}"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Tellipse", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0.6"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ellipseplane", " ", "=", " ", "baseplane"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"ellipseplane", "[", 
       RowBox[{"[", "i", "]"}], "]"}], " ", "=", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"Rellipse", ".", 
         RowBox[{"baseplane", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ")"}], " ", "+", " ", 
       "Tellipse"}]}], ",", " ", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"\"\<baseplane=\>\"", ",", 
       RowBox[{"MatrixForm", "[", "baseplane", "]"}], ",", 
       "\"\<  ellipseplane=\>\"", ",", 
       RowBox[{"MatrixForm", "[", "ellipseplane", "]"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Rellipse=\>\"", ",", 
       RowBox[{"MatrixForm", "[", "Rellipse", "]"}], ",", 
       "\"\<  Tellipse=\>\"", ",", 
       RowBox[{"MatrixForm", "[", "Tellipse", "]"}]}], "]"}], ";"}], 
    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Plane", " ", "for", " ", "parabola"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pangle", " ", "=", " ", "60"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Rparabola", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"pangle", " ", "Degree"}], "]"}], ",", " ", "0", ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"pangle", " ", "Degree"}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", "\t\t    ", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
       "\t             ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Sin", "[", 
           RowBox[{"pangle", " ", "Degree"}], "]"}]}], ",", " ", "0", ",", 
         " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"pangle", " ", "Degree"}], "]"}]}], "}"}]}], "}"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Tparabola", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "0.3"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"parabolaplane", " ", "=", " ", "baseplane"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"parabolaplane", "[", 
       RowBox[{"[", "i", "]"}], "]"}], " ", "=", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"Rparabola", ".", 
         RowBox[{"baseplane", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ")"}], " ", "+", " ", 
       "Tparabola"}]}], ",", " ", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Plane", " ", "for", " ", "hyperbola"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hangle", " ", "=", " ", "90"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Rhyper", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"hangle", " ", "Degree"}], "]"}], ",", " ", "0", ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"hangle", " ", "Degree"}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", "\t\t    ", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
       "\t             ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Sin", "[", 
           RowBox[{"hangle", " ", "Degree"}], "]"}]}], ",", " ", "0", ",", 
         " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"hangle", " ", "Degree"}], "]"}]}], "}"}]}], "}"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Thyper", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0.2", ",", "0", ",", "0"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hyperplane", " ", "=", " ", "baseplane"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Do", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"hyperplane", "[", 
       RowBox[{"[", "i", "]"}], "]"}], " ", "=", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"Rhyper", ".", 
         RowBox[{"baseplane", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ")"}], " ", "+", " ", 
       "Thyper"}]}], ",", " ", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "4"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "Graphics", " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"conegray", " ", "=", " ", "0.6"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"planegray", " ", "=", " ", "0.0"}], ";"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"gconeellipse", " ", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "conegray", "]"}], ",", 
         RowBox[{"Cone", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", "0.5"}],
           "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Cone", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", "0.5"}],
           "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"GrayLevel", "[", "planegray", "]"}], ",", 
         RowBox[{"Polygon", "[", 
          RowBox[{"{", "ellipseplane", "}"}], "]"}]}], "}"}], ",", " ", 
       RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}], ",", " ", 
       RowBox[{"ViewPoint", "->", 
        RowBox[{"{", 
         RowBox[{"1.3", ",", " ", 
          RowBox[{"-", "2.4"}], ",", " ", "2.5"}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"gconeparabola", " ", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "conegray", "]"}], ",", 
         RowBox[{"Cone", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", "0.5"}],
           "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Cone", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", "0.5"}],
           "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"GrayLevel", "[", "planegray", "]"}], ",", 
         RowBox[{"Polygon", "[", 
          RowBox[{"{", "parabolaplane", "}"}], "]"}]}], "}"}], ",", " ", 
       RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"gconehyper", " ", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "conegray", "]"}], ",", 
         RowBox[{"Cone", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", "0.5"}],
           "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Cone", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", 
               RowBox[{"-", "1"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", "0.5"}],
           "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"GrayLevel", "[", "planegray", "]"}], ",", 
         RowBox[{"Polygon", "[", 
          RowBox[{"{", "hyperplane", "}"}], "]"}]}], "}"}], ",", " ", 
       RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"pic", " ", "=", " ", 
    RowBox[{"GraphicsRow", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "gconeellipse", ",", " ", "gconeparabola", ",", " ", "gconehyper"}], 
       "}"}], ",", 
      RowBox[{"Alignment", "\[Rule]", "Center"}], ",", " ", 
      RowBox[{"ImageSize", "\[Rule]", "Full"}]}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Export", "[", 
      RowBox[{"\"\<ConesConics.eps\>\"", ",", " ", "pic"}], "]"}], ";"}], " ",
     "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.5598241896740522`*^9, 3.55982426257298*^9}, {
   3.5598243112284665`*^9, 3.5598243404941177`*^9}, {3.5598243863737984`*^9, 
   3.5598243966230164`*^9}, {3.559824429539074*^9, 3.55982445584072*^9}, {
   3.559824728326399*^9, 3.559824763910062*^9}, {3.5598248229873652`*^9, 
   3.5598250065468884`*^9}, {3.5598250460773573`*^9, 3.559825356330703*^9}, {
   3.559825418808812*^9, 3.5598254992269535`*^9}, {3.5598255339838147`*^9, 
   3.5598255770866904`*^9}, {3.5598256085207453`*^9, 
   3.5598258589231853`*^9}, {3.5598259183592896`*^9, 
   3.5598260464199142`*^9}, {3.559826104046416*^9, 3.5598262388618526`*^9}, {
   3.559826277830721*^9, 3.559826316409589*^9}, {3.5598264118661566`*^9, 
   3.5598264220997744`*^9}, {3.559826466275052*^9, 3.5598265352271733`*^9}, {
   3.559826655284984*^9, 3.5598266905722466`*^9}, {3.5598268031888437`*^9, 
   3.5598269214214516`*^9}, 3.5598269515919046`*^9, {3.5598269942579794`*^9, 
   3.559827024256832*^9}, {3.5598270893401465`*^9, 3.55982710264697*^9}, {
   3.55982718137571*^9, 3.55982719267013*^9}, {3.5598503090729094`*^9, 
   3.559850348213378*^9}, {3.559850384898243*^9, 3.5598504012626715`*^9}, 
   3.5599135036866055`*^9, 3.584290297731813*^9, {3.5842903449518795`*^9, 
   3.584290400841957*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     Graphics3DBox[{
       {GrayLevel[0.6], ConeBox[{{0, 0, 1}, {0, 0, 0}}, 0.5], 
        ConeBox[{{0, 0, -1}, {0, 0, 0}}, 0.5]}, 
       {GrayLevel[0.], 
        StyleBox[
         Polygon3DBox[
          NCache[{{{-Cos[20 Degree], -1, 0.9420201433256687}, {
             Cos[20 Degree], -1, 0.25797985667433126`}, {
             Cos[20 Degree], 1, 0.25797985667433126`}, {-Cos[20 Degree], 1, 
              0.9420201433256687}}}, {{{-0.9396926207859084, -1, 
              0.9420201433256687}, {
             0.9396926207859084, -1, 0.25797985667433126`}, {
             0.9396926207859084, 1, 
              0.25797985667433126`}, {-0.9396926207859084, 1, 
              0.9420201433256687}}}]],
         FontColor->GrayLevel[0.]]}},
      AspectRatio->1,
      Boxed->False,
      Lighting->"Neutral",
      ViewPoint->{1.3, -2.4, 2.5}], {193.5, -189.}, ImageScaled[{0.5, 0.5}], {360., 360.},
     ContentSelectable->True], InsetBox[
     Graphics3DBox[{
       {GrayLevel[0.6], ConeBox[{{0, 0, 1}, {0, 0, 0}}, 0.5], 
        ConeBox[{{0, 0, -1}, {0, 0, 0}}, 0.5]}, 
       {GrayLevel[0.], 
        StyleBox[
         Polygon3DBox[
          NCache[{{{Rational[-1, 2], -1, 0.5660254037844386}, {
             Rational[1, 2], -1, -1.1660254037844386`}, {
             Rational[1, 2], 1, -1.1660254037844386`}, {
             Rational[-1, 2], 1, 0.5660254037844386}}}, {{{-0.5, -1, 
              0.5660254037844386}, {0.5, -1, -1.1660254037844386`}, {
             0.5, 1, -1.1660254037844386`}, {-0.5, 1, 0.5660254037844386}}}]],
         FontColor->GrayLevel[0.]]}},
      AspectRatio->1,
      Boxed->False,
      Lighting->"Neutral"], {580.5, -189.}, ImageScaled[{0.5, 0.5}], {360., 360.},
     ContentSelectable->True], InsetBox[
     Graphics3DBox[{
       {GrayLevel[0.6], ConeBox[{{0, 0, 1}, {0, 0, 0}}, 0.5], 
        ConeBox[{{0, 0, -1}, {0, 0, 0}}, 0.5]}, 
       {GrayLevel[0.], 
        StyleBox[
         Polygon3DBox[{{{0.2, -1, 1}, {0.2, -1, -1}, {0.2, 1, -1}, {
            0.2, 1, 1}}}],
         FontColor->GrayLevel[0.]]}},
      AspectRatio->1,
      Boxed->False,
      Lighting->"Neutral"], {967.5, -189.}, ImageScaled[{0.5, 0.5}], {360., 360.},
     ContentSelectable->True]}, {}},
  ContentSelectable->True,
  ImageSize->Full,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.559850747126879*^9, 3.55991350641661*^9, 
  3.56209875619162*^9, 3.5842901345815845`*^9, 3.5842904072919664`*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1121, 630},
WindowMargins->{{Automatic, 35}, {Automatic, 42}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 673, 13, 135, "Subtitle"],
Cell[1255, 37, 449, 10, 86, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1729, 51, 13344, 339, 1352, "Input"],
Cell[15076, 392, 2474, 56, 350, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
