(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     77962,       1492]
NotebookOptionsPosition[     77350,       1468]
NotebookOutlinePosition[     77694,       1483]
CellTagsIndexPosition[     77651,       1480]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 "\n"
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
  3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
  3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
  3.5842134956497355`*^9, 3.5842135862546945`*^9}},
 FontFamily->"Arial"],

Cell[TextData[{
 "\n",
 StyleBox["Conic Sections",
  FontWeight->"Bold"],
 " \nCreate figures for Chapter 19 Conic.\nConics are created as contours of \
quadratic functions."
}], "Subsubtitle",
 CellChangeTimes->{{3.569352300806876*^9, 3.569352304691283*^9}, 
   3.5693523776994114`*^9, {3.5694115829768777`*^9, 3.569411593210496*^9}, {
   3.5842922342745237`*^9, 3.5842922623745637`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"to", " ", "enable", " ", "file", " ", 
    RowBox[{"export", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetOptions", "[", 
     RowBox[{"ContourPlot", ",", 
      RowBox[{"BaseStyle", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontFamily", "->", "\"\<Helvetica\>\""}], ",", 
         RowBox[{"FontSize", "\[Rule]", "16"}]}], "}"}]}]}], "]"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.569352364064987*^9, 3.5693523643925877`*^9}, {
  3.5693523988218484`*^9, 3.569352403111856*^9}, {3.569352528068075*^9, 
  3.5693525458989067`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"ellipse", " ", "example"}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"pic1", " ", "=", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"2", 
         RowBox[{"x", "^", "2"}]}], " ", "+", " ", 
        RowBox[{"4", 
         RowBox[{"y", "^", "2"}]}]}], "\[Equal]", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1.0"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "2"}], ",", "1"}], "}"}], ",", " ", 
      RowBox[{"ContourStyle", "\[Rule]", "Thick"}]}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"pic2", " ", "=", " ", 
    RowBox[{"ContourPlot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"3", 
         RowBox[{"x", "^", "2"}]}], " ", "-", 
        RowBox[{"2", " ", "x", "*", "y"}], " ", "+", " ", 
        RowBox[{"3", 
         RowBox[{"y", "^", "2"}]}]}], "\[Equal]", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1.0"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "2"}], ",", "1"}], "}"}], ",", " ", 
      RowBox[{"ContourStyle", "\[Rule]", "Thick"}]}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"pic3", " ", "=", " ", 
    RowBox[{"ContourPlot", "[", " ", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"3", 
         RowBox[{"x", "^", "2"}]}], " ", "-", 
        RowBox[{"2", "x", "*", "y"}], " ", "+", 
        RowBox[{"3", 
         RowBox[{"y", "^", "2"}]}], " ", "-", " ", 
        RowBox[{"14", "x"}], " ", "+", " ", 
        RowBox[{"10", "y"}]}], "\[Equal]", 
       RowBox[{"-", "18"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1.0"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "2"}], ",", "1"}], "}"}], ",", " ", 
      RowBox[{"ContourStyle", "\[Rule]", "Thick"}]}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{"pic4", " ", "=", " ", 
    RowBox[{"ContourPlot", "[", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"3", 
        RowBox[{"x", "^", "2"}]}], " ", "-", 
       RowBox[{"2", "x", "*", "y"}], " ", "+", 
       RowBox[{"3", 
        RowBox[{"y", "^", "2"}]}], " ", "-", " ", 
       RowBox[{"14", "x"}], " ", "+", " ", 
       RowBox[{"10", "y"}], "+", " ", "18"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1.0"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "2"}], ",", "1"}], "}"}], ",", " ", 
      RowBox[{"ContourStyle", "\[Rule]", "Thick"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"hyperbola", " ", "example"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"xtntx", " ", "=", " ", "4"}], ";", "\[IndentingNewLine]", 
     RowBox[{"pic1", " ", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"ContourPlot", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"5.53", 
             RowBox[{"x", "^", "2"}]}], " ", "-", " ", 
            RowBox[{"2.53", 
             RowBox[{"y", "^", "2"}]}]}], "\[Equal]", "1"}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"-", "xtntx"}], ",", "xtntx"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"y", ",", 
            RowBox[{"-", "xtntx"}], ",", "xtntx"}], "}"}], ",", " ", 
          RowBox[{"ContourStyle", "\[Rule]", "Thick"}]}], "]"}], 
        "\[IndentingNewLine]", "pic2"}], " ", "=", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"ContourPlot", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"x", "^", "2"}], " ", "+", " ", 
             RowBox[{"8", "x", "*", "y"}], " ", "+", " ", 
             RowBox[{"2", 
              RowBox[{"y", "^", "2"}]}]}], "\[Equal]", "1"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", 
             RowBox[{"-", "xtntx"}], ",", "xtntx"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"y", ",", 
             RowBox[{"-", "xtntx"}], ",", "xtntx"}], "}"}], ",", " ", 
           RowBox[{"ContourStyle", "\[Rule]", "Thick"}]}], "]"}], 
         "\[IndentingNewLine]", "pic3"}], " ", "=", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"ContourPlot", "[", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"x", "^", "2"}], " ", "+", " ", 
              RowBox[{"8", "x", "*", "y"}], " ", "+", " ", 
              RowBox[{"2", 
               RowBox[{"y", "^", "2"}]}], " ", "-", " ", 
              RowBox[{"4", "x"}], " ", "-", " ", 
              RowBox[{"16", "y"}]}], "\[Equal]", 
             RowBox[{"-", "3"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", 
              RowBox[{"-", "xtntx"}], ",", "xtntx"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"y", ",", 
              RowBox[{"-", "xtntx"}], ",", "xtntx"}], "}"}], ",", " ", 
            RowBox[{"ContourStyle", "\[Rule]", "Thick"}]}], "]"}], 
          "\[IndentingNewLine]", "pic4"}], "=", " ", 
         RowBox[{"ContourPlot", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "^", "2"}], " ", "+", " ", 
            RowBox[{"8", "x", "*", "y"}], " ", "+", " ", 
            RowBox[{"2", 
             RowBox[{"y", "^", "2"}]}], " ", "-", " ", 
            RowBox[{"4", "x"}], " ", "-", " ", 
            RowBox[{"16", "y"}], " ", "+", "3"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", 
             RowBox[{"-", "xtntx"}], ",", "xtntx"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"y", ",", 
             RowBox[{"-", "xtntx"}], ",", "xtntx"}], "}"}], ",", " ", 
           RowBox[{"ContourStyle", "\[Rule]", "Thick"}]}], "]"}]}]}]}]}]}], 
    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"parabola", " ", "example"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"xtntx", " ", "=", " ", "10"}], ";", "\[IndentingNewLine]", 
     RowBox[{"pic1", " ", "=", 
      RowBox[{
       RowBox[{
        RowBox[{"ContourPlot", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"5.53", 
             RowBox[{"x", "^", "2"}]}], " ", "-", " ", 
            RowBox[{"2.53", 
             RowBox[{"y", "^", "2"}]}]}], "\[Equal]", "1"}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"-", "xtntx"}], ",", "xtntx"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"y", ",", 
            RowBox[{"-", "xtntx"}], ",", "xtntx"}], "}"}], ",", " ", 
          RowBox[{"ContourStyle", "\[Rule]", "Thick"}]}], "]"}], 
        "\[IndentingNewLine]", "pic2"}], " ", "=", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"ContourPlot", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"2", 
              RowBox[{"x", "^", "2"}]}], " ", "+", " ", 
             RowBox[{"4", "x", "*", "y"}], " ", "+", " ", 
             RowBox[{"2", 
              RowBox[{"y", "^", "2"}]}]}], "   ", "\[Equal]", " ", "0"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", 
             RowBox[{"-", "xtntx"}], ",", "xtntx"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"y", ",", 
             RowBox[{"-", "xtntx"}], ",", "xtntx"}], "}"}], ",", " ", 
           RowBox[{"ContourStyle", "\[Rule]", "Thick"}]}], "]"}], 
         "\[IndentingNewLine]", "pic3"}], " ", "=", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"ContourPlot", "[", " ", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"2", 
               RowBox[{"x", "^", "2"}]}], " ", "+", " ", 
              RowBox[{"4", "x", "*", "y"}], " ", "+", " ", 
              RowBox[{"2", 
               RowBox[{"y", "^", "2"}]}], " ", "-", " ", 
              RowBox[{"4", "x"}], " ", "-", " ", "y"}], "  ", "\[Equal]", " ",
              "0"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", 
              RowBox[{"-", "xtntx"}], ",", "xtntx"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"y", ",", 
              RowBox[{"-", "xtntx"}], ",", "xtntx"}], "}"}], ",", " ", 
            RowBox[{"ContourStyle", "\[Rule]", "Thick"}]}], "]"}], 
          "\[IndentingNewLine]", "pic4"}], " ", "=", " ", 
         RowBox[{"ContourPlot", "[", " ", 
          RowBox[{
           RowBox[{
            RowBox[{"2", 
             RowBox[{"x", "^", "2"}]}], " ", "+", " ", 
            RowBox[{"4", "x", "*", "y"}], " ", "+", " ", 
            RowBox[{"2", 
             RowBox[{"y", "^", "2"}]}], " ", "-", " ", 
            RowBox[{"4", "x"}], " ", "-", " ", "y"}], " ", ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", 
             RowBox[{"-", "xtntx"}], ",", "xtntx"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"y", ",", 
             RowBox[{"-", "xtntx"}], ",", "xtntx"}], "}"}], ",", " ", 
           RowBox[{"ContourStyle", "\[Rule]", "Thick"}]}], "]"}]}]}]}]}]}], 
    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<ConicSection1.eps\>\"", ",", "pic1"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<ConicSection2.eps\>\"", ",", "pic2"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<ConicSection3.eps\>\"", ",", "pic3"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Export", "[", 
      RowBox[{"\"\<ConicSection4.eps\>\"", ",", "pic4"}], "]"}], ";"}], " ", 
    "*)"}]}]}]], "Input",
 CellChangeTimes->CompressedData["
1:eJwlzmkogwEAxvHXpNxkUeSYrJxRriRTJpEsS0mWpbkNkShH09K+yES0veRI
NPc5ScmVK9OrRI5yhBxrPrhGyhzv8/rw9Ov59vfOKU/LZxEE4UMPxs7MUb+k
IY4TuMZ4J22+hTFDgw9wxWT+BtNTxSaYFRBuR3Qa4j4yPxmLvDtrzGhTboyN
sICaVkP7LXYfbCLyBiB/dFQD20Ubi+606siydSgdE1DweYJ3Axd1j3YetIa1
Cw84xSJ8ISuE+tdpIRLaamWJkBK6bMMVvUIHhcNeRzCq0HgMT6o7rqDypZex
SuSnh3z2MaN9SbcRinesvuCB5I7wpL3k+ljA+6d6DnRs+A6GkhFdNKwjc3lw
szeCD1WypXhYGcJNgsXOCQLI2Z2pgUPWijq4XfQshwp5tgL2ZzgroSX7vQWu
SlZVUOumIWGQwKYHSj3JAZjrujwCv5wsxqAwjH0Kozb2zuGwA+/Qn7b0epJx
p3FfHkgbOtuuhKWSnzZ435GngrFnZBfzuS09sNVUq4Hu81bjMLlCXRiE/uRX
xj99FhfQ
  "]],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdV3s4lVkXN0aSZHKpCKV8qUgXXXShRdFNmO6Nmi6US3Xcp9LEZEpRPSEa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   "], {{}, {}, 
    TagBox[
     TooltipBox[
      {Thickness[Large], 
       LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
         19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 
        36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 
        53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
        70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
        87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 
        103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 
        117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 
        131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 
        145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 
        159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 
        173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 
        187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 
        201, 202, 203, 204, 205, 206, 207, 208, 209, 210}]},
      RowBox[{
        RowBox[{
          RowBox[{"2", " ", 
            SuperscriptBox["x", "2"]}], "+", 
          RowBox[{"4", " ", 
            SuperscriptBox["y", "2"]}]}], "\[Equal]", "1"}]],
     Annotation[#, 2 $CellContext`x^2 + 4 $CellContext`y^2 == 1, 
      "Tooltip"]& ]}],
  AspectRatio->1,
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 16},
  Frame->True,
  PlotRange->{{-1., 3}, {-2, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5694151464031386`*^9, {3.5694151847792063`*^9, 3.569415204669241*^9}, 
   3.5694152804697742`*^9, {3.569415344726287*^9, 3.5694153579551105`*^9}, 
   3.5694154117596045`*^9, 3.5694154457208643`*^9, 3.5694155050945683`*^9, {
   3.5694158829896326`*^9, 3.569415902286866*^9}, 3.569441971208268*^9, 
   3.569442021627557*^9, 3.5694421399537644`*^9}],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdV3k8VdsXlyZepUF65UmJQlEe7yeJFvFSSimql8jjxm3QM0QTIi9EZcpQ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   "], {{}, {}, 
    TagBox[
     TooltipBox[
      {Thickness[Large], 
       LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
         19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 
        36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 
        53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
        70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
        87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 
        103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 
        117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 
        131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 
        145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 
        159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 
        173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 
        187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 
        201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 
        215, 216, 217, 218, 219, 220}]},
      RowBox[{
        RowBox[{
          RowBox[{"3", " ", 
            SuperscriptBox["x", "2"]}], "-", 
          RowBox[{"2", " ", "x", " ", "y"}], "+", 
          RowBox[{"3", " ", 
            SuperscriptBox["y", "2"]}]}], "\[Equal]", "1"}]],
     Annotation[#, 
      3 $CellContext`x^2 - 2 $CellContext`x $CellContext`y + 
       3 $CellContext`y^2 == 1, "Tooltip"]& ]}],
  AspectRatio->1,
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 16},
  Frame->True,
  PlotRange->{{-1., 3}, {-2, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5694151464031386`*^9, {3.5694151847792063`*^9, 3.569415204669241*^9}, 
   3.5694152804697742`*^9, {3.569415344726287*^9, 3.5694153579551105`*^9}, 
   3.5694154117596045`*^9, 3.5694154457208643`*^9, 3.5694155050945683`*^9, {
   3.5694158829896326`*^9, 3.569415902286866*^9}, 3.569441971208268*^9, 
   3.569442021627557*^9, 3.5694421399849644`*^9}],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxdV2dYU0kXTrkKKkVhbagI6iLWzyihic7YKAqCWCiirorwIUUU7IqwCBZW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   "], {{}, {}, 
    TagBox[
     TooltipBox[
      {Thickness[Large], 
       LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
         19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 
        36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 
        53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
        70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
        87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 
        103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 
        117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 
        131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 
        145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 
        159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 
        173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 
        187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 
        201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 
        215, 216, 217, 218}]},
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{"-", "14"}], " ", "x"}], "+", 
          RowBox[{"3", " ", 
            SuperscriptBox["x", "2"]}], "+", 
          RowBox[{"10", " ", "y"}], "-", 
          RowBox[{"2", " ", "x", " ", "y"}], "+", 
          RowBox[{"3", " ", 
            SuperscriptBox["y", "2"]}]}], "\[Equal]", 
        RowBox[{"-", "18"}]}]],
     Annotation[#, (-14) $CellContext`x + 3 $CellContext`x^2 + 
       10 $CellContext`y - 2 $CellContext`x $CellContext`y + 
       3 $CellContext`y^2 == -18, "Tooltip"]& ]}],
  AspectRatio->1,
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 16},
  Frame->True,
  PlotRange->{{-1., 3}, {-2, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5694151464031386`*^9, {3.5694151847792063`*^9, 3.569415204669241*^9}, 
   3.5694152804697742`*^9, {3.569415344726287*^9, 3.5694153579551105`*^9}, 
   3.5694154117596045`*^9, 3.5694154457208643`*^9, 3.5694155050945683`*^9, {
   3.5694158829896326`*^9, 3.569415902286866*^9}, 3.569441971208268*^9, 
   3.569442021627557*^9, 3.5694421400005646`*^9}],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxtXQdYlEcT5jiwd6NGsceosaNg1/3sBXvDghp7BXvvsaMY7A1RFI0t9i64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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmWmMltUVx5/nfd73Dgw20jZNky4fWGRGUfwo2DQqKjgSRYksZRGQmWER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         "]], PolygonBox[CompressedData["
1:eJwllFmMj1cYxr//nP8536Bip2krjbGNinErcW8ZxpYhtsTasVTHGMNYBg26
4aKW1s5o2pSERGwJLvRGKBEk9lgvTJG4RoX6PZ6LJ3me857vfO953+c9PWYu
HFdbkmXZPFAEnVKWDWXhl0KWdYT3y7PsQMiy16yVw2+x9hZ9mnhzzLIL4C9i
J3QI8Q7EZxPvC7rDu4LtBa9NhU8DNfAGtlfx7bfoRvQyUAuvA8vhJ/mmjvgU
9Cx0L3Rn+AKwFF2FHgb/FTSjn/P/AvwueIeuQN+BjwTn4JNZGwuv5czj6CPg
UvQ3+vYFqIZfBE+D7/hT9D/1b9WkC7wVeAWfTrwU/rniwTm2hy8CTfCL4Bh8
DdgIPwR2c9469Gr4G85cC18C1gfvuQFvTQ0nwI/yjyvsH56c62HwD3pM8l3K
wKfw31UjYu/R99DX0WfQu9Fz4LtAFbpJIL4V7AuuWQ4/ER1TTVSbSazNIFZQ
T9DzlWNwzb+Bj0jujWqq2j4CJRinH/ohfFQyVw6j1TvOWBBco8/Q59F/ENuE
3gO/Gu2dXaoZvJv+UWLPyDvLknupteXwvtSnmv+9QZfB61k7VbBnFisX1voU
7cn/1Rv0OHS54px/k7X/gnu0I/oMnfUSFIm1UU2DPf8bfCf4E15DfAd8S3Lv
tGe79vP9wKL3DOG8kOylLej96J65Z0c59M7tAXlhA1jN3gnJ/y7lzPHyd7S3
9xPfhv4Z3RLsSXnzuWpe8NoL+Krks26As8k1VW3rwVx5C2wOvrPuvjR5tuW5
xmSPyCvXyW8k+X3JWv9gj9dH90S9kQfkhZScmzwkLz0Df7O3Th6NnmHNsjxc
Cf9Bngv2fEPym6G3Q2s/Jues3PUGfBftcXn9K/JJ5DMxedbasdZALM89GwOI
t4I/Jp7DK9hzkPg7dI+iPdInd8/UO+15Ah/M2vqiZ+aT5BnSLOkON6M9L+9X
o/dF91C9VA2/19uQfNe2nPEvfBDnNcEXKn90S3JMOSiXlckx9WwFfF5ybyrQ
8zl7jt6M4Bmt0bwke0Fv5Gy9jezJgmdSszk6+u38uJbcM/XuGphLLKLL4W04
owg/nvwWaUY0K6W5ayfPyruqmWqnmSnorY9+S/SG3mb/19Fn6Y666xfJb7tm
WrN9P/kuegMeJM+YZk0ekpdG5M5Nd6zM3UP1Uj1QLy5H91o5B/Te6NrrjaiB
fwBg4sxB
         "]]}]}, 
     {RGBColor[0.3888395826363643, 0.22332023963459158`, 0.6635413890733945], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmnmUVdWVxm/d++55IAUUFFXFPMioQAdBiJHAiiC2ERCLIUYTmYxxaJsI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         "]], PolygonBox[CompressedData["
1:eJwllmlsVVUUhR/3vnsu1IqAUYNDlFgmIYBCIComBSJgmWy1iGIBS8sghVIB
ESqzTKkpaMBaIgjEYKIGgkAQ/YE/BBShjagMVVsQcIpjRIySiN/K+rHy1jp7
3zO8s4fTqbSyaFaUyWR2gCwoTDOZjkkmM4bBxSGTWQLvCy8F76PHgSvwy6A1
/Dvsn8MHxZnMe/B+jA2ENzJ2Fp3HfJ+1Yl4m7ww/yZgWvBufzvi2Y2wAtv7o
HuiZYDf2fmApvgl6DPZRoBO++xl7AN8T2C/AF4F74JPAfnyvw+fjyHO2h59L
vBd9o2+fwKcUfjvoAD/B2AHsj6PHoEeAx+DVoApbhD7O/kvQj8oGJsIXgtnY
H0bvi/xNIXx08FwfMLYQ+zr0Dng9Yy/Bc9lTH/bWHWThh/ApxH4ta0yBvwUq
Is/5JfxNUAZv4vsV8N/AGfRw9EH4MbAr8n9WwPwxGBt5z9r7p9h3oovxD6y3
HN0/8pwfYn8ZvIZtPVgO/1pz6K7Q0/FtzTfdiIuejLWBD8HewrcNjA2G78Vn
HmttxJ6feo/a606wRfETHEtDwSvYpqPnxD7zNPgQvtmc9R3oLooYK8L+LfoK
egT2RuxtWWMaep/OFDsGc+HDGBvEXloYO4T+UTGA/xrdEbw6mI/EvxzehH8+
fDI+vZi7JPFZFqAHoGdqD6y1BH0vugF9CXtnJQd6ZeK1doNtzPcHuBHb7+gG
+JHEvnngKnoG+kjsMw1FnwXlrP8G+hx8Kpgd+4wFzL9NMRo5GZuwfQUmRL6T
b4JzRLmiNbX2SPwrce/LWFd0gWISPR57D+bbnniuo9j3Ys8Bj6CLQTfsecG5
mIM+D68Em9GLwBzlNyhjilzs38NPKf/YzwR0z9R3qrv9B/8vsM8L5ivBfH2L
/TB8AihG7wme+0++eVc8ONdVc1R7Gvl9G72J+QerdiS+e8WIYqUx+L/WHR6H
fwKqIt/5T/ABID92TbrIt5PQ09BTwajEc2pu3anu9kXsW/Gtw14LXwWK0ePA
asUO2BA7Zp/Gf31wLutOdbcng33vB2vQE4PXWqozw28BAf43690Mv4/1l2Vd
E59JHGOKNeXQUfR80JG5qnUm/LcHx5rudCK264Nr112gDv0C+qHIOb8SfhPo
hG01qMdeg34w8hl1VuWkcnMXeB1+THce+U5r8O+eOjb+Vb5iOxBcW9UDFmNP
U9eCXuA4+mBwb1BNWZZ4Ta29CizA9lwwLwcl8DPgauwYPxUcQ4olxbBiuT44
N1RzhiaOYcWyeoZ6RzVYEnuO08E5q9zVGT9KnNPK7Vq+L0L/F3y3qsGH0VuD
z66aodqhGq9ar5qu2v5scOx2AZWKdearyfpOtqAvBudCW/BO4pxSbqkmqTap
BqoW9uY+9ySOAcXCLFCm3Epc6zWn5q5Az1VvAcOD/yP9VzqjzhqlriWqGa3g
PwSvrR6hXnEJNMNH6UyqtaqxsWNesa+eqd45Wv0mOKYUW/J5Cv4z/qfRw9AD
0Xem7tWqEaoVzaqPkXu6evvk4LMop5Xb5aAWvg4sw7Y2cS4oJ5WbY4NzXz1c
vbwqOPcVs68mXlNrq6f9mvgMOot6zOXEPU69Tmf8C56TOvbU89T72uPfJnbM
PwlfEdzLlMNzlRvBvU81XbW9Q+paqTfCGfTG4N5+CZ3Czyd+W6iGqJa0gGzW
NVi1uCL4rlSjZgT3FPUW/QdL4bcG57r2dFvwf6L/Rj1fvf+a4NxSz60LfiPo
raA1mtG9g2NX/3kf+HhwR+wa0i64J6s3qyapNm1Cr43dQ6ao1gSfRTG1Ad41
9d2rhneBzw5+u6jGq9brzaa3m2LgF723Ur9N9GaIU+eAckFvJr2dFNOKba35
PPpCcO9QDVEtUU1SbdKeb9DdBL8VVfNU+/4HPio9VA==
         "]]}]}, 
     {RGBColor[0.5479042481057942, 0.49989073508671483`, 0.8871260189219918], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmG+QlmUVxt/e97nvty9Bu0wfSjNYXZzJRrZUwGxml9KcyYLCcaBS1hob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         "]], PolygonBox[CompressedData["
1:eJwtlVlsVlUUhS/3/8/5eREc4gtBpUVi0sS0DGHSAFFoWtQK5QGEMkjCA0Mg
hjglDKGKRgpVSGz0AREsYyFQRq0UEEpJIGV8AEwKyBiLtBQQo3H6VhYPO9lr
r3PO3ndPN2/6vPK5aZIkc5EssjEkySAM1YBhuSSpBQf0U5kk2ReTpATbdnAL
Zx/CTUQa0N/BNgDuN3Aj+AH4TXA7dz7gvafBd9F7YfsHfEtOwes5H+HO8X4D
uBbZjT4HehpcR/TdO9iqwVfBXcGt4MPo/XlvXtYxTIAvBe8CV/D+f+BfkKXo
a7GNhLsJ/gy8HjwK/DiyiLsDwU/k/A36lhrOdHL2ErIavh3bG3Cj8DkG39/A
H4H7F+mR2qd8K2fKXV/ubIB7Gfxp1mc+1Fvcr+N+IfwUfR+yCm4zZ4pzFunK
YTvct5yfmboma9BPYytL/abe/gP8deqaqDaKWbG/ho8RnL8N/jx1jpSrE9h+
hWtDquC2ghvRt+DvbfAB8HnwBWQJeBO4Af1HZDP6KmwPM75TF11j1Vo5vQP3
JHgweD54G/hIdK0Gg39Cfw/bU6l74FnwXqQF/iSyAG4ysgauDPwK3CmkI+Ma
nUT/HjkDPiubvg38FXo+PpvB3XOupWK4qPpEc5e4v0L9F537RnzkoW+J/rYq
bGOVW+7fzbpnroPHKMdZ1+h38JfIRxnH2IS+OLh3FZNiWxg8K/omfds4pAL9
Buf/hqsC14BnI9PRv0AGdPE3rIyOUbHqTHV0D6mXLoIPgSuDddVItXoQPIuK
UbEewzYLX0ORT4J7Vr27GHwZvF85SNyDjeilyjn4Fvg4eFmwrhn8Dnw9ulem
cuZa9AxqFtUT6o3l4NsZ95R6SzOmWdPMXIEbjTThuwi+N3w5Minjby5Gfy7n
3Cimkaon0plxzVtUK/gZvFfJmVa480hzap/yXY+8n3rHFHD+Z/CJ1G/orY+D
e085aYrOuXKvGqqW68A70YdoR6AX4O+trHOi3PQDz8l6htrA44NnRTZxZeHR
rgK/CB4X3EuKWbHLJk4xXoCrC66NfMiXdpB20Tbu3IB7Nbr3NdOa7ftIK/rr
qn/wTGm2lIMXomuq2g6BLwL/qZ2Xekf15O3CaE45KYc7GD3b2rnaveeCZ6EQ
WzfOl2gHpM7JVPQfomdN/wD9Cx6L3q2a4XfB+dF3tZO1m1Vj1Vpv6K29mpfU
O0O7Y2lwrrXTjnL2mZy/TTH/pXxjeynjO3vAw6N3mXJwD/x8dC+qp/pE94R6
Q3f6g3dE/1s0c/Xo14Jzq5nWbP8Pjbv6MA==
         "]]}]}, 
     {RGBColor[0.6690678024334884, 0.6966679757472485, 0.9118980472740708], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1V29o1VUY/u3+7jmXPhRSQtC/q/UlxRnuD5QsneJMKyMzbKVEM8g/YcHt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         "]], PolygonBox[CompressedData["
1:eJwllEtI1lEQxS/+vfejRS1CiKhMCyJDI5+URWb4KSVFZqU9iHIVQrUohWgV
RFFgRC2EHit7meYjsFyomGmSFCQ9LJKggqCyEl2UYY/fYRaH78ycufPNnTvz
T606vPVQgnNuJ0gEWcG5S/w+xZkNbwG9kXOD+Kq8c+XY4/ABfO3wSTCHgyeI
H4Y/BKNoa4npg+/izChaMb7V2LXYafBKsAm7ADx2FrMOnhJzrpR8O8As7EHw
gdgZ2I2cfQY6iV2Mby7adXAf3gluwK+BDvgaYhrgpcQPJJhvH7wtWO39oBWe
Ds7w/0+IyYBXEPMKXoCeh/3Wm5aPnURtzfh64OvxNcE3ow/Cs/Atwc4MFque
TMDj6F3ozfj2wreD4QTLsR9eQM4LxB7F14Y9kzPT8HT0BtnoWeg54IX67+1t
VqIvJ/ZqsNy5+K7Abwbrhe60hdhH2O8j6+Ep7IXk20iudvAH+ysY4WwcvQfe
Dc5h/8Se4ux3kETscfLdRUvBzojsTrpbK6h2dgfdZbe3WTmCnYtdCOoTbaY6
0PrAZc7W4stDi5OvjHxv0IvgC/CVoNUT00tsHRiL7I311qpRteqNvsAXBZu1
bM1LzO6ku20AydiT3nI1YZfEDOKauQlvNaiWEew93nqsXuuOqcFyKJdmftpb
jaq1GN98tClvPA7mxWxmNbua8WTNLnoh/38A3wr0e95mRz1Rby5667V27I7O
Yt8ifzV6Jvpzb3fTDGgW1FP1Vj385W3ntHv6j/PYJ8G7yHbwAVoJKI9sZ455
m3nNvnbMBZsxzdon9H/e3lhvnYtvWbA76W56k9/eZlyzrp3Sbp31tmsHwVCw
ndHuaMY163+95VYNquU2GNJ+gUZ4k7ezH9FPe5tpzbZiyrzthHYjB18aWru3
2rRzr719E/Rt0J370bvAy8hmvMjbTmg35OsO9s3Rt0c7VoP+I1gtmvFx+CpQ
FNkOdHl7M72d3mSbtzfR29Shf8ZeGqy2GuwWb984feu0U5Xar2DabM58C3ZG
Z/Uf+dhjwTTNuGZdPVAvtLPa3f8ajbwW
         "]]}]}, 
     {RGBColor[0.7836333390107106, 0.8540017204329313, 0.9046219709440829], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNVL1r01EUfSS/97JW8CPVpuKmoGAHrUmlgu2iiyLiolP/AN0Eh64lBgQh
LYp0NXGxOlXwY9BB6Fa1cWgJiC0kogGp9QsdPKfnFDu83Jv77u9+nHvuOzBx
7cLVXAhhEieP8wA/TZwW9BVcnIU+A7mIMwp9CrKahdCAPg59P/Qz0KehH0kh
DEM/DHmqEMJ12B7FEG7i/wzsNcge/L9BX8eZxP0d5Kni7Ib/GGxP4f82KfZ0
VP4POdWwA9/24dwIyse8dci1THejOdU3j/tm0N0A7K+hlzLpT2xftt/Rgnr7
iFzncRagN5N86Uf/K7DPQj8O332w9+PUnHfVNS06N/My7pS/7WbKPZZT7GH3
3cmEL2sjFkViGhSXOuPcT+rpVpSt3z7rsN+FHIKswFbOFJPzabmOCXzzEv/n
4LORF+b8hvJ7XvGJ2ZrrX7cP7ZxRKcq/4fmTD5wh503sfyTVs5H0Hb+h/2/8
H4T+wliuei7HCprj5Sg8Bo3JLtiXILuwV5Lq/wT9YdJ9Pf6fGXFlLayJuDF/
0bN4HMU38o6zJZfmjefWTOaiuHMwKQ7reR80i67ree585aQ6u+YNT8dcYr01
19NnDpDD3JvGtt3pOOabrRkk5TyXV96uYw4Y07r5wNqXHJ+cI/deoa7bUXEY
byfsI+RQFAdGjD/n1jMnyp7r5o45B+OTgyfNGe7QsnP/TerhHmQ707z5zaEk
bInxqjnDmdKHccc9k6rxIe/YP3svuT7W1vL82Ds5zRhfEPtrVA170FMnqnfy
grWdznTXX5BehLwYtW/c3RW/DcxL3pA/QwVxj/1xLuy14n5ZY9tYsL/2tvqb
ftM4n1nXWTSGm3uRtDOfk7Dt+e5X1FzJce7WojnHO+4r8a/5DXwH2fBec7+f
Rb0pP5PeO+b/k9QDe7kUVTfzMc6JJHyIE/e85XeG7yZ5s7egXol72dxcMA7/
ABtu1+Q=
         "]], PolygonBox[CompressedData["
1:eJwtkr0vg2EUxW/6em5nIShBLELCYBAUHdTCQkQkYusfwCbxJzARkQjmtouu
IhhqszU+FjWISYJEaKmPwe/mGk5yzj3nvfd57vN2ZVbmlmMi0g3qwHEQ2aBw
DYZV5AFdglcjkS14lVqWXILwB/wdVPB2qb3Bl8jck5+mlkKfow/QM+hicBi3
TA3eEBdJ0msM3KFb0Wn8W/xX9DM9UvB6/Bd4ARTx09QO1WfYrDJ6kfxj8LNb
jyZ6jeAfcbYbakn4N+ik1w7+OvwHTOLl0L/wJ/VZa3xToNd28Fkd1L7wFoL3
SpEfRLcwYwJvCj2uXjPPdjZPdkB9N6NkGsmWg3O7s929or7LNnCCl0NfxPzO
WfWe1tvObGffUz9rHuzDr9TvYne4hPeBoch7zNLvLPjZ20EN71N9lr2xvbXV
zLMdnQZ/A3sL69GvvlPbre08A2+O+9vYnRPwkv0Dkf8Dm/g96rtbJdOr//9M
5BnL/gHS71TG
         "]]}]}, 
     {RGBColor[0.888661779670237, 0.889025906810977, 0.8575693236480275], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtUDtOw1AQXDv28wViPikQXICGhsYBQ5eSI3AAOEMoIiE4QbhCWgpECxcg
OQQlcsBEQMGMZorRvp23Ozu7B5fXF1d5RBwCA6AtIvbKiFPEMdAAj+BnWcQE
OMrEnwB3ubgFUGfq6YGha9bunw7Ev0KnTxEjvL+S/sfWOUZ+hrqnUvU3wCqU
k/9O0qf2SyjWftMT85X5qXu5R+u5fNMDNbYq+X8v5aGzz/NC9fRzn2sud38u
lX/aQ+ea2yTtnyRubb7zHHpb+G7LUJz53fvO7H9A/xx9c8TdSh62K+018W4f
pfyNKt1mv1BPYw875slx9zfwG+TLpFm8ydB6tTU3vjP/Wnum/78k/d+k3ajP
OY13517/E9dJEQ==
         "]], 
        PolygonBox[{{1815, 1089, 1091, 1520}, {1780, 652, 1050, 1782}, {1428, 
         898, 1016, 1746}, {1747, 1016, 897, 1674}, {1818, 1091, 651, 1466}, {
         1813, 1086, 181, 1511}, {1690, 666, 1056, 1788}, {1783, 834, 652, 
         1467}, {1674, 897, 197, 1673}, {1787, 1056, 898, 1428}, {1512, 1087, 
         1086, 1813}, {1466, 651, 1087, 1814}, {1816, 197, 1089, 1817}, {1511,
          181, 834, 1592}}]}]}}, {{}, 
     TagBox[
      TooltipBox[
       {Thickness[Large], 
        LineBox[{1691, 1690, 1788, 1787, 1428, 1746, 1747, 1674, 1673, 1786, 
         1597, 1816, 1817, 1815, 1520, 1818, 1466, 1814, 1512, 1813, 1511, 
         1592, 1465, 1783, 1467, 1780, 1782, 1781}]},
       "40"],
      Annotation[#, 40, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Thickness[Large], 
        LineBox[{1372, 1846, 1474, 1473, 1528, 1845, 1371, 1598, 1369, 1378, 
         1710, 1709, 1427, 1785, 1469, 1784, 1468, 1593, 1594, 1513, 1841, 
         1366, 1589, 1364, 1840, 1506, 1425, 1744, 1424, 1745, 1779, 1778, 
         1585, 1812, 1499, 1811, 1500, 1581, 1580, 1360, 1703, 1702, 1701, 
         1421, 1772, 1773, 1771, 1454, 1576, 1577, 1456, 1855, 1455}]},
       "30"],
      Annotation[#, 30, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Thickness[Large], LineBox[CompressedData["
1:eJwV0b0rhWEcxvHbgMnZheNlMCiUIwuFIkkUJ5FB+AMoRdlFGQxmJgYc5aWY
EI4ok2KwWIyU14m8fe7h2/e6fvfvfp6nc8rHJvrGc0IIk8jmhtCeF0IbivND
+NSL+ItL+IQ/0CG/c7O9FrzJ9WZD3KgPckp/4mM8ok4f4Abn/TyKLTmDJfkA
rXb2465ZCvdyrVmaa/Re3uQNrGNRf+FXPGNPr+JdvkO1uz1cadbFI1iTV7Eg
X3FnvGMvw/O4MJvjy/gePudZPuUszvCACiTcu3FWwLdcblaGdnkYK/IyjnAY
f1ezUrs/nORvTsfvxQ62EeIznCU4iWk73TwV3xO/nf/Qaec3/hdmM9ykX3Oh
/g+dQzz/
         "]]},
       "20"],
      Annotation[#, 20, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Thickness[Large], LineBox[CompressedData["
1:eJwV0DkvRVEUhuFNgtLwDwRRXEEh0YjELGLK7eUmt5VQaA1BVOZCa4qh0poK
FGhMHaEw5KIyRGIoJOI5xZt3fWvtfU7Wzk/2xnvSQgh9SKSH0J8RwmZmCAO8
xSu8w4O8zUO8y6u8z8O8xyN8wGtcnRXCOo9iXm8Bi2iSj3iMl3gZCXUzCtQt
HHP3kovkQqTwiFOM65/wBF+hxNlWLtbb4Dz5mrM5FzmImX3gHBc4w7QzNyg1
j3OZXjnu1G16t1wh33O9/BC9BR7RLqe40vyJG+Tn6G3wig75havM37hRfo/e
Cl/olD+5xvw72l3+4Tq5Fl3Rt/UOeQ7JaO9oZ0xhEn84NpvmWcygO/oXx/Gr
/gc1dkRC
         "]]},
       "10"],
      Annotation[#, 10, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Thickness[Large], LineBox[CompressedData["
1:eJwl09dvjWEcwPHntHpOtRJ7xIjU9h8YkQiJUDVjb0pbpaeq9qzV1q1dmysR
V9SVa7EJMWtfmP+D8PnFxSff5/k957ze13tatqZ+bj6TUuqgPJvS46KUSnIp
PdGcdqaYUqaYtfnMGb7yhWtmGWcF/LW/Z5+sn+okfab3qXW2gY1MjZqd0CzH
yXGSDPMooJBLPndED/Mq/m37Br3JLTbTSD2bgvOF2qDTtYI5zKZfXMP8Oj+t
b+g3/cF3/jDCPY9kCJ3sy7RIFzCftb5TGWUFK5lhtkpn6WrtynbrxbpDLzLB
dS5oFXc5T43z9dRat8ZaP+hH3vOZT+wynxnX54X1ZNd6rtVUWNfEs2o51T5T
xVmzPfF/pBPN2zXPQ8ba1+k05w80a/9IC+NZ47npwgHn68zHWDfFmt1xP/zi
d3yfo/GOtVVf62Vt0Wa2cIiDHOM0pZxitOuOosR6qA5nGI2+PzjerY6L36B1
MYviembj4/6sb9POVbMOvaJv9B1v417tl8c7YCdt9n21D8voziAGUumsvw6g
G0vpRe+4Z2c9tQdL4rdmvy3eMVt5Gc9jtl/P6b74zbnHvXqHJrM6zWf//439
AzmkZZE=
         "]]},
       "0"],
      Annotation[#, 0, "Tooltip"]& ], {}, {}}}],
  AspectRatio->1,
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 16},
  Frame->True,
  PlotRange->{{-1., 3}, {-2, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5694151464031386`*^9, {3.5694151847792063`*^9, 3.569415204669241*^9}, 
   3.5694152804697742`*^9, {3.569415344726287*^9, 3.5694153579551105`*^9}, 
   3.5694154117596045`*^9, 3.5694154457208643`*^9, 3.5694155050945683`*^9, {
   3.5694158829896326`*^9, 3.569415902286866*^9}, 3.569441971208268*^9, 
   3.569442021627557*^9, 3.569442140016165*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1222, 630},
WindowMargins->{{Automatic, 31}, {Automatic, 48}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 673, 13, 135, "Subtitle"],
Cell[1255, 37, 389, 9, 86, "Subsubtitle"],
Cell[1647, 48, 1135, 28, 112, "Input"],
Cell[CellGroupData[{
Cell[2807, 80, 10706, 273, 692, "Input"],
Cell[13516, 355, 5232, 93, 362, "Output"],
Cell[18751, 450, 6226, 110, 362, "Output"],
Cell[24980, 562, 6387, 114, 362, "Output"],
Cell[31370, 678, 45952, 786, 362, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
