(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      9907,        267]
NotebookOptionsPosition[      9469,        247]
NotebookOutlinePosition[      9811,        262]
CellTagsIndexPosition[      9768,        259]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9},
 FontFamily->"Arial"],

Cell[TextData[{
 StyleBox["Linear Dependence and Determinants",
  FontWeight->"Bold"],
 "\n\nTwo vectors a and b are called",
 StyleBox[" linearly dependent",
  FontFamily->"Arial",
  FontSlant->"Italic"],
 " if one can be expressed in terms of the other:\n\t",
 StyleBox["b",
  FontWeight->"Bold"],
 "=r",
 StyleBox["a",
  FontWeight->"Bold"],
 ".\nElse, they are",
 StyleBox[" linearly independent",
  FontFamily->"Arial",
  FontSlant->"Italic"],
 ".\n\nThe ",
 StyleBox["determinant",
  FontSlant->"Italic"],
 " of two vectors measures the ",
 StyleBox["area",
  FontSlant->"Italic"],
 " of the parallelogram spanned by them. If it is zero, then the vectors are \
linearly dependent. The area may also be negative. In the following cell, the \
determinant is displayed in a box on top of the graphic.\n"
}], "Subsubtitle",
 CellChangeTimes->{{3.5190605704177775`*^9, 3.519060578092991*^9}, {
   3.5190606755931625`*^9, 3.5190606801327705`*^9}, {3.5190608203926163`*^9, 
   3.5190608745559115`*^9}, {3.519060915412383*^9, 3.5190610274049797`*^9}, {
   3.519061174669239*^9, 3.5190613186574917`*^9}, 3.519143837518166*^9, {
   3.5191440108968706`*^9, 3.5191440842949996`*^9}, {3.5191441776923637`*^9, 
   3.519144178940366*^9}, 3.5191443457826586`*^9, {3.519144902064036*^9, 
   3.5191449079140463`*^9}, {3.5191568024721313`*^9, 
   3.5191568026437316`*^9}, {3.519407947973127*^9, 3.5194079501571302`*^9}, {
   3.5198551456939306`*^9, 3.5198551992644243`*^9}, 3.5198554847605257`*^9, {
   3.5206885387440853`*^9, 3.52068856435933*^9}, {3.5206886364470572`*^9, 
   3.5206886585990963`*^9}, {3.584796372919403*^9, 3.5847963745194054`*^9}, {
   3.5847975359610314`*^9, 3.5847975391210356`*^9}},
 FontFamily->"Arial",
 FontSize->18,
 FontColor->GrayLevel[0]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Fixed", " ", 
    RowBox[{"vector", " ", "--"}], " ", "in", " ", "black"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"a1", " ", "=", " ", 
     RowBox[{"{", 
      StyleBox[
       RowBox[{"1", ",", "0"}],
       FontColor->GrayLevel[0]], "}"}]}], ";"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"graphics", " ", "for", " ", "a1"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"arrowa1", "=", 
     RowBox[{"{", 
      RowBox[{"Thick", ",", 
       RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", "a1"}], "}"}], "]"}]}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"arrowplot", "=", 
     RowBox[{"Graphics", "[", "arrowa", "]"}]}], ";"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"b1", "=", 
       RowBox[{"{", 
        RowBox[{"s", ",", "t"}], "}"}]}], ";", "  ", 
      RowBox[{"(*", 
       RowBox[{"in", " ", "red"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"arrowb1", "=", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", 
         RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", "b1"}], "}"}], "]"}]}], 
        "}"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Green", ",", 
          RowBox[{"Polygon", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "0"}], "}"}], ",", " ", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1", ",", "0"}], "}"}], "+", "b1"}], ",", "b1"}], 
            "}"}], "]"}], ",", "Black", ",", "arrowa1", ",", "Red", ",", 
          "arrowb1"}], "}"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Framed", "[", 
            RowBox[{"Det", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1", ",", "0"}], "}"}], ",", "b1"}], "}"}], "]"}], 
            "]"}], ",", "20"}], "]"}]}], ",", 
        RowBox[{"Axes", "\[Rule]", "True"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], "]"}]}], ",",
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", "0.5"}], "}"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "0.5"}], "}"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\< \>\"", ",", "\"\< \>\"", ",", 
        "\"\<Determinant: area of the parallelogram\>\"", ",", "\"\< \>\""}], 
       "}"}]}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.584797617941146*^9, 3.5847976256211567`*^9}, {
  3.5847980649567995`*^9, 3.5847981062768574`*^9}, {3.584798234287037*^9, 
  3.5847982720690928`*^9}, {3.584798323599165*^9, 3.5847983354691815`*^9}, {
  3.584798375579238*^9, 3.584798375949238*^9}, {3.5847986033295565`*^9, 
  3.584798616969576*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`s$$ = -0.265, $CellContext`t$$ = 
    0.4099999999999999, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`s$$], 0.5}, -1, 1}, {{
       Hold[$CellContext`t$$], 0.5}, -1, 1}}, Typeset`size$$ = {
    360., {109., 116.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`s$83027$$ = 
    0, $CellContext`t$83028$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`s$$ = 0.5, $CellContext`t$$ = 0.5}, 
      "ControllerVariables" :> {
        Hold[$CellContext`s$$, $CellContext`s$83027$$, 0], 
        Hold[$CellContext`t$$, $CellContext`t$83028$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`b1 = {$CellContext`s$$, $CellContext`t$$}; \
$CellContext`arrowb1 = {Thick, 
          Arrowheads[Large], 
          Arrow[{{0, 0}, $CellContext`b1}]}; Graphics[{Green, 
          
          Polygon[{{0, 0}, {1, 
            0}, {1, 0} + $CellContext`b1, $CellContext`b1}], 
          Black, $CellContext`arrowa1, Red, $CellContext`arrowb1}, PlotLabel -> 
         Style[
           Framed[
            Det[{{1, 0}, $CellContext`b1}]], 20], Axes -> True, 
         PlotRange -> {{-2, 2}, {-1, 1}}]), 
      "Specifications" :> {{{$CellContext`s$$, 0.5}, -1, 
         1}, {{$CellContext`t$$, 0.5}, -1, 1}}, 
      "Options" :> {
       FrameLabel -> {
         " ", " ", "Determinant: area of the parallelogram", " "}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{433., {193., 198.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.5847978067664385`*^9, 3.584798275669098*^9, 
  3.584802385656371*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{893, 630},
WindowMargins->{{3, Automatic}, {Automatic, 48}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 691, 12, 107, "Subtitle"],
Cell[1273, 36, 1755, 41, 232, "Subsubtitle"],
Cell[CellGroupData[{
Cell[3053, 81, 3983, 108, 372, "Input"],
Cell[7039, 191, 2402, 52, 408, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
