(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     12267,        317]
NotebookOptionsPosition[     11731,        295]
NotebookOutlinePosition[     12172,        312]
CellTagsIndexPosition[     12129,        309]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9},
 FontFamily->"Arial"],

Cell["\<\
Determinants 3x3 matrices
Three vectors a, b, c span a parallelepiped ( a skew box). It volume is given \
by the determinant of a, b, c. If it is nonzero, the vectors are linearly \
independent.\
\>", "Subsubtitle",
 CellChangeTimes->{{3.584902333551261*^9, 3.584902363591303*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"aa", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], ";", "  ", 
   RowBox[{"(*", "  ", "green", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"bb", "=", " ", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], ";", "  ", 
   RowBox[{"(*", "  ", "green", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"cc", "=", " ", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], ";"}], "  ", 
  RowBox[{"(*", "  ", "green", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"viewing", " ", "extents"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"range", "=", 
    RowBox[{"2", "*", 
     RowBox[{"Max", "[", 
      RowBox[{
       RowBox[{"Norm", "[", "aa", "]"}], ",", 
       RowBox[{"Norm", "[", "bb", "]"}], ",", 
       RowBox[{"Norm", "[", "cc", "]"}]}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"arrowaa", "=", 
   RowBox[{"{", 
    RowBox[{"Green", ",", 
     RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "aa"}], "}"}], 
      "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"arrowbb", " ", "=", 
   RowBox[{"{", 
    RowBox[{"Green", ",", 
     RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "bb"}], "}"}], 
      "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"arrowcc", " ", "=", 
   RowBox[{"{", 
    RowBox[{"Green", ",", 
     RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
     RowBox[{"Arrow", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "cc"}], "}"}], 
      "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"zz", "=", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"rst", "=", 
      RowBox[{"{", 
       RowBox[{"r", ",", "s", ",", "t"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{
       RowBox[{"{", " ", 
        RowBox[{
         RowBox[{"Arrowheads", "[", ".05", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"Tube", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "rst"}], "}"}], 
            ",", ".015"}], "]"}], "]"}], ",", "Thick", ",", "arrowaa", ",", 
         " ", "arrowbb", ",", " ", "arrowcc", ",", "LightRed", ",", 
         RowBox[{"Opacity", "[", "0.8", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Polygon", "[", 
          RowBox[{"{", 
           RowBox[{"zz", ",", "aa", ",", 
            RowBox[{"aa", "+", "bb"}], ",", "bb"}], "}"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Polygon", "[", 
          RowBox[{"{", 
           RowBox[{"zz", ",", "aa", ",", 
            RowBox[{"aa", "+", "rst"}], ",", "rst"}], "}"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Polygon", "[", 
          RowBox[{"{", 
           RowBox[{"zz", ",", "bb", ",", 
            RowBox[{"bb", "+", "rst"}], ",", "rst"}], "}"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Polygon", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"rst", "+", "zz"}], ",", 
            RowBox[{"rst", "+", "aa"}], ",", 
            RowBox[{"rst", "+", "aa", "+", "bb"}], ",", 
            RowBox[{"rst", "+", "bb"}]}], "}"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Polygon", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"bb", "+", "zz"}], ",", 
            RowBox[{"bb", "+", "aa"}], ",", 
            RowBox[{"bb", "+", "aa", "+", "rst"}], ",", 
            RowBox[{"bb", "+", "rst"}]}], "}"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Polygon", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"aa", "+", "zz"}], ",", 
            RowBox[{"aa", "+", "bb"}], ",", 
            RowBox[{"aa", "+", "bb", "+", "rst"}], ",", 
            RowBox[{"aa", "+", "rst"}]}], "}"}], "]"}]}], 
        "\[IndentingNewLine]", "}"}], ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "range"}], ",", 
       RowBox[{"PlotLabel", "\[Rule]", 
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"Framed", "[", 
           RowBox[{"Det", "[", 
            RowBox[{"{", 
             RowBox[{"aa", ",", "bb", ",", "rst"}], "}"}], "]"}], "]"}], ",", 
          "20"}], "]"}]}]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"r", ",", "0", ",", "\"\<e_1 dir:  r\>\""}], "}"}], ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"s", ",", "0", ",", "\"\<e_2 dir:  s\>\""}], "}"}], ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"t", ",", "1", ",", "\"\<e_3 dir:  t\>\""}], "}"}], ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Tube arrow defined by (r,s,t)\>\"", ",", "\"\< \>\"", ",", 
       "\"\<Determinant: area of the parallelepiped\>\"", ",", "\"\< \>\""}], 
      "}"}]}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5849023863113346`*^9, 3.5849025342615423`*^9}, {
  3.5849026230116663`*^9, 3.584902623671667*^9}, {3.5849030533622684`*^9, 
  3.58490305411227*^9}, {3.584903302002617*^9, 3.584903405182761*^9}, {
  3.584903470932853*^9, 3.584903518002919*^9}, {3.584903572702996*^9, 
  3.5849035804430065`*^9}, {3.584903672873136*^9, 3.584903684093152*^9}, {
  3.5849037231032066`*^9, 3.5849038100433283`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`r$$ = 
    1., $CellContext`s$$ = -0.23199999999999998`, $CellContext`t$$ = 1., 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`r$$], 0, "e_1 dir: r"}, -1, 1}, {{
       Hold[$CellContext`s$$], 0, "e_2 dir: s"}, -1, 1}, {{
       Hold[$CellContext`t$$], 1, "e_3 dir: t"}, -1, 1}}, Typeset`size$$ = {
    540., {315., 325.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`r$97672$$ = 
    0, $CellContext`s$97673$$ = 0, $CellContext`t$97674$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`r$$ = 0, $CellContext`s$$ = 
        0, $CellContext`t$$ = 1}, "ControllerVariables" :> {
        Hold[$CellContext`r$$, $CellContext`r$97672$$, 0], 
        Hold[$CellContext`s$$, $CellContext`s$97673$$, 0], 
        Hold[$CellContext`t$$, $CellContext`t$97674$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`rst = {$CellContext`r$$, $CellContext`s$$, \
$CellContext`t$$}; Graphics3D[{
          Arrowheads[0.05], 
          Arrow[
           Tube[{{0, 0, 0}, $CellContext`rst}, 0.015]], 
          Thick, $CellContext`arrowaa, $CellContext`arrowbb, \
$CellContext`arrowcc, LightRed, 
          Opacity[0.8], 
          
          Polygon[{$CellContext`zz, $CellContext`aa, $CellContext`aa + \
$CellContext`bb, $CellContext`bb}], 
          
          Polygon[{$CellContext`zz, $CellContext`aa, $CellContext`aa + \
$CellContext`rst, $CellContext`rst}], 
          
          Polygon[{$CellContext`zz, $CellContext`bb, $CellContext`bb + \
$CellContext`rst, $CellContext`rst}], 
          
          Polygon[{$CellContext`rst + $CellContext`zz, $CellContext`rst + \
$CellContext`aa, $CellContext`rst + $CellContext`aa + $CellContext`bb, \
$CellContext`rst + $CellContext`bb}], 
          
          Polygon[{$CellContext`bb + $CellContext`zz, $CellContext`bb + \
$CellContext`aa, $CellContext`bb + $CellContext`aa + $CellContext`rst, \
$CellContext`bb + $CellContext`rst}], 
          
          Polygon[{$CellContext`aa + $CellContext`zz, $CellContext`aa + \
$CellContext`bb, $CellContext`aa + $CellContext`bb + $CellContext`rst, \
$CellContext`aa + $CellContext`rst}]}, Boxed -> False, 
         PlotRange -> $CellContext`range, PlotLabel -> Style[
           Framed[
            Det[{$CellContext`aa, $CellContext`bb, $CellContext`rst}]], 20]]),
       "Specifications" :> {{{$CellContext`r$$, 0, "e_1 dir: r"}, -1, 
         1}, {{$CellContext`s$$, 0, "e_2 dir: s"}, -1, 
         1}, {{$CellContext`t$$, 1, "e_3 dir: t"}, -1, 1}}, 
      "Options" :> {
       FrameLabel -> {
         "Tube arrow defined by (r,s,t)", " ", 
          "Determinant: area of the parallelepiped", " "}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{648., {516., 523.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.5849033812927275`*^9, 3.584903408432766*^9}, 
   3.5849034510128255`*^9, 3.5849035104929085`*^9, 3.584903581323008*^9, 
   3.5849036848531528`*^9, 3.584903800133314*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{864, 807},
WindowMargins->{{Automatic, 69}, {0, Automatic}},
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.5, 1.5 Inherited],
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 691, 12, 248, "Subtitle"],
Cell[1273, 36, 291, 6, 128, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1589, 46, 6331, 165, 854, "Input"],
Cell[7923, 213, 3780, 78, 1063, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
