(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      8888,        264]
NotebookOptionsPosition[      8449,        244]
NotebookOutlinePosition[      8792,        259]
CellTagsIndexPosition[      8749,        256]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9},
 FontFamily->"Arial"],

Cell[TextData[{
 "\n",
 StyleBox["Dot Product",
  FontWeight->"Bold"],
 "\n\nTwo vectors ",
 StyleBox["a",
  FontWeight->"Bold"],
 "=",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", GridBox[{
      {"v"},
      {"w"}
     }], ")"}], TraditionalForm]]],
 " and ",
 StyleBox["b",
  FontWeight->"Bold"],
 "=",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", GridBox[{
      {"x"},
      {"y"}
     }], ")"}], TraditionalForm]]],
 " define a ",
 StyleBox["dot product",
  FontSlant->"Italic"],
 ":\n\n\t",
 StyleBox["ab",
  FontWeight->"Bold"],
 "=",
 StyleBox["a.b",
  FontWeight->"Bold"],
 "=vx + wy.\n\nIf ",
 StyleBox["a.b",
  FontWeight->"Bold"],
 "=0, then ",
 StyleBox["a",
  FontWeight->"Bold"],
 " and ",
 StyleBox["b",
  FontWeight->"Bold"],
 " are ",
 StyleBox["perpendicular (",
  FontSlant->"Italic"],
 "also",
 StyleBox[":orthogonal), ",
  FontSlant->"Italic"],
 "i.e., they form a right angle",
 StyleBox[".\n\n",
  FontSlant->"Italic"],
 "In the following cell, b is changed in the Manipulate command (red), and ",
 StyleBox["a",
  FontWeight->"Bold"],
 " is given as fixed input (black). The dot product is displayed in a box."
}], "Subsubtitle",
 CellChangeTimes->{{3.519060513774078*^9, 3.5190605260200996`*^9}, 
   3.5191436408642206`*^9, {3.5191438075661135`*^9, 3.519143812292922*^9}, 
   3.5191438595610046`*^9, {3.51915726271134*^9, 3.519157266314946*^9}, {
   3.519211313036418*^9, 3.519211314705621*^9}, 3.5206887728380966`*^9, {
   3.5219824906429195`*^9, 3.521982492639451*^9}, 3.5219840802256036`*^9, {
   3.5847985224294434`*^9, 3.5847985235694447`*^9}},
 FontSize->18,
 FontColor->GrayLevel[0]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"fixed", " ", 
    RowBox[{"vector", " ", "--"}], " ", "in", " ", "black"}], "  ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"a2", " ", "=", " ", 
     RowBox[{"{", 
      StyleBox[
       RowBox[{"2", ",", "1"}],
       FontColor->GrayLevel[0]], "}"}]}], ";"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"graphics", " ", "for", " ", "a2"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"arrowa2", "=", 
     RowBox[{"{", 
      RowBox[{"Thick", ",", 
       RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", "a2"}], "}"}], "]"}]}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"arrowplot2", "=", 
     RowBox[{"Graphics", "[", "arrowa2", "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"b2", "=", 
       RowBox[{"{", 
        RowBox[{"s", ",", "t"}], "}"}]}], ";", "  ", 
      RowBox[{"(*", 
       RowBox[{"in", " ", "red"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"arrowb2", "=", 
       RowBox[{"{", 
        RowBox[{"Thick", ",", 
         RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", "b2"}], "}"}], "]"}]}], 
        "}"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"arrowa2", ",", "Red", ",", "arrowb2"}], "}"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Framed", "[", 
            RowBox[{"a2", ".", "b2"}], "]"}], ",", "20"}], "]"}]}], ",", 
        RowBox[{"Axes", "\[Rule]", "True"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], "]"}]}], ",",
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", "0.5"}], "}"}], ",", 
       RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "0.5"}], "}"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\< \>\"", ",", "\"\< \>\"", ",", "\"\<Dot product: black.red\>\"", 
        ",", "\"\< \>\""}], "}"}]}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5847985518994846`*^9, 3.5847985697095094`*^9}, {
  3.5847986473796177`*^9, 3.584798681509666*^9}, {3.5847989274375277`*^9, 
  3.5847989767275963`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`s$$ = -0.6699999999999999, $CellContext`t$$ \
= -0.31999999999999995`, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`s$$], 0.5}, -1, 2}, {{
       Hold[$CellContext`t$$], 0.5}, -1, 1}}, Typeset`size$$ = {
    360., {110., 114.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`s$76347$$ = 
    0, $CellContext`t$76348$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`s$$ = 0.5, $CellContext`t$$ = 0.5}, 
      "ControllerVariables" :> {
        Hold[$CellContext`s$$, $CellContext`s$76347$$, 0], 
        Hold[$CellContext`t$$, $CellContext`t$76348$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`b2 = {$CellContext`s$$, $CellContext`t$$}; \
$CellContext`arrowb2 = {Thick, 
          Arrowheads[Large], 
          Arrow[{{0, 0}, $CellContext`b2}]}; 
       Graphics[{$CellContext`arrowa2, Red, $CellContext`arrowb2}, PlotLabel -> 
         Style[
           Framed[
            Dot[$CellContext`a2, $CellContext`b2]], 20], Axes -> True, 
         PlotRange -> {{-2, 2}, {-1, 1}}]), 
      "Specifications" :> {{{$CellContext`s$$, 0.5}, -1, 
         2}, {{$CellContext`t$$, 0.5}, -1, 1}}, 
      "Options" :> {FrameLabel -> {" ", " ", "Dot product: black.red", " "}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{433., {193., 198.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.5847986831896687`*^9, {3.584798971107589*^9, 3.5847989773975973`*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{701, 630},
WindowMargins->{{Automatic, 48}, {Automatic, 44}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 691, 12, 165, "Subtitle"],
Cell[1273, 36, 1611, 63, 298, "Subsubtitle"],
Cell[CellGroupData[{
Cell[2909, 103, 3239, 88, 392, "Input"],
Cell[6151, 193, 2270, 47, 408, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

