(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     35478,        860]
NotebookOptionsPosition[     34390,        818]
NotebookOutlinePosition[     34734,        833]
CellTagsIndexPosition[     34691,        830]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 "\n"
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
  3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
  3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
  3.5842134956497355`*^9, 3.5842135862546945`*^9}},
 FontFamily->"Arial"],

Cell[TextData[{
 "\n",
 StyleBox["Eigendecomposition for 2x2 symmetric matrices",
  FontWeight->"Bold"],
 "\nThe eigendecompostion is computed.\nThe action of the matrix is \
interpreted as a linear combination of projection matrices, which are built \
from the eigendecomposition.\nSee Section 7.5: Eigen Things, The Geometry of \
Symmetric Matrices\nFigure 7.7 was generated using this nb.\n"
}], "Subsubtitle",
 CellChangeTimes->{{3.5641484955264397`*^9, 3.56414851372348*^9}, {
  3.564148549192509*^9, 3.564148571340776*^9}, {3.5842925069509096`*^9, 
  3.584292520120928*^9}, {3.584292882171435*^9, 3.58429290725147*^9}, {
  3.584293029651641*^9, 3.5842931268317776`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetOptions", "[", 
     RowBox[{"Graphics", ",", 
      RowBox[{"BaseStyle", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontFamily", "->", "\"\<Helvetica\>\""}], ",", 
         RowBox[{"FontSize", "\[Rule]", "14"}]}], "}"}]}]}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.564148655293578*^9, 3.564148655739603*^9}, {
   3.5641559935442343`*^9, 3.564156022092284*^9}, 3.564156083993193*^9, 
   3.5701436816448617`*^9, {3.5701437937778587`*^9, 3.570143820703506*^9}}],

Cell[CellGroupData[{

Cell[" Eigendecomposition", "Section",
 CellChangeTimes->{{3.5842926470111055`*^9, 3.584292660711125*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"symmetric", " ", "matrix", " ", "for", " ", "decomposition"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "vector", " ", "to", " ", "apply", " ", "transformation", " ", "to"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0.5"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"SVD", " ", "of", " ", "a"}], " ", "=", " ", 
     RowBox[{"uu", ".", "sigma", ".", 
      RowBox[{"vv", "^", "T"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"SVD", " ", "=", " ", "Eigendecomp"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"uu", ",", "sigma", ",", "vv"}], "}"}], "=", 
     RowBox[{"SingularValueDecomposition", "[", "a", "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Put", " ", "evecs", " ", "and", " ", "evals", " ", "in", " ", "easy", 
     " ", "access", " ", "structures"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"uut", " ", "=", " ", 
     RowBox[{"Transpose", "[", "uu", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"r1", " ", "=", " ", 
     RowBox[{"uut", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"r2", " ", "=", " ", 
     RowBox[{"uut", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"l1", " ", "=", " ", 
     RowBox[{"sigma", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"l2", " ", "=", " ", 
     RowBox[{"sigma", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "2"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<m =   \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "a", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<lambda1 = \>\"", ",", "l1", ",", "\"\<  r1 =  \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "r1", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<lambda2 = \>\"", ",", "l2", ",", "\"\<  r2 =  \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "r2", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5641485173806896`*^9, 3.564148555420865*^9}, {
  3.5641486766818013`*^9, 3.5641486991180844`*^9}, {3.5641487620796857`*^9, 
  3.56414876897608*^9}, {3.564148804763127*^9, 3.564148858894223*^9}, {
  3.5641489519255443`*^9, 3.564149136882123*^9}, {3.564152126349848*^9, 
  3.5641521276758504`*^9}, {3.5842925346709485`*^9, 3.5842925383009534`*^9}, {
  3.5842928298113613`*^9, 3.584292831851364*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"m =   \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2.`", "1.`"},
       {"1.`", "2.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["m =   ", 
   MatrixForm[{{2., 1.}, {1., 2.}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.564148704688403*^9, 3.5641491447375727`*^9, 3.5641492247441483`*^9, 
   3.5641493765638323`*^9, 3.5641495957033663`*^9, {3.564149833248953*^9, 
   3.564149848387819*^9}, 3.5641498797426124`*^9, 3.564149921591006*^9, 
   3.564149953920855*^9, 3.56415200215803*^9, 3.5641520612977333`*^9, {
   3.5641521072086143`*^9, 3.5641521307178555`*^9}, 3.5641522514888673`*^9, 
   3.5641523342782125`*^9, 3.564152375025484*^9, {3.5641524309203825`*^9, 
   3.564152438065195*^9}, {3.564152515909332*^9, 3.564152551024994*^9}, 
   3.5641525937066684`*^9, 3.564155843682371*^9, 3.5641560891256027`*^9, 
   3.564156170292545*^9, 3.5671038629332604`*^9, 3.5671075625584884`*^9, 
   3.5701367887627573`*^9, 3.5701436393531876`*^9, 3.5701438020302734`*^9, 
   3.5842925555209775`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lambda1 = \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"  r1 =  \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"0.7071067811865475`"},
        {"0.7071067811865475`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["lambda1 = ", 3, "  r1 =  ", 
   MatrixForm[{0.7071067811865475, 0.7071067811865475}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.564148704688403*^9, 3.5641491447375727`*^9, 3.5641492247441483`*^9, 
   3.5641493765638323`*^9, 3.5641495957033663`*^9, {3.564149833248953*^9, 
   3.564149848387819*^9}, 3.5641498797426124`*^9, 3.564149921591006*^9, 
   3.564149953920855*^9, 3.56415200215803*^9, 3.5641520612977333`*^9, {
   3.5641521072086143`*^9, 3.5641521307178555`*^9}, 3.5641522514888673`*^9, 
   3.5641523342782125`*^9, 3.564152375025484*^9, {3.5641524309203825`*^9, 
   3.564152438065195*^9}, {3.564152515909332*^9, 3.564152551024994*^9}, 
   3.5641525937066684`*^9, 3.564155843682371*^9, 3.5641560891256027`*^9, 
   3.564156170292545*^9, 3.5671038629332604`*^9, 3.5671075625584884`*^9, 
   3.5701367887627573`*^9, 3.5701436393531876`*^9, 3.5701438020302734`*^9, 
   3.5842925555309772`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"lambda2 = \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"  r2 =  \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         RowBox[{"-", "0.7071067811865475`"}]},
        {"0.7071067811865475`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["lambda2 = ", 1, "  r2 =  ", 
   MatrixForm[{-0.7071067811865475, 0.7071067811865475}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.564148704688403*^9, 3.5641491447375727`*^9, 3.5641492247441483`*^9, 
   3.5641493765638323`*^9, 3.5641495957033663`*^9, {3.564149833248953*^9, 
   3.564149848387819*^9}, 3.5641498797426124`*^9, 3.564149921591006*^9, 
   3.564149953920855*^9, 3.56415200215803*^9, 3.5641520612977333`*^9, {
   3.5641521072086143`*^9, 3.5641521307178555`*^9}, 3.5641522514888673`*^9, 
   3.5641523342782125`*^9, 3.564152375025484*^9, {3.5641524309203825`*^9, 
   3.564152438065195*^9}, {3.564152515909332*^9, 3.564152551024994*^9}, 
   3.5641525937066684`*^9, 3.564155843682371*^9, 3.5641560891256027`*^9, 
   3.564156170292545*^9, 3.5671038629332604`*^9, 3.5671075625584884`*^9, 
   3.5701367887627573`*^9, 3.5701436393531876`*^9, 3.5701438020302734`*^9, 
   3.5842925555309772`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Eigendecomposition as a sum of projections\
\>", "Section",
 CellChangeTimes->{{3.564148862948455*^9, 3.5641489001515827`*^9}, 
   3.5641491416463957`*^9, {3.5842926000510397`*^9, 3.5842926046710463`*^9}}],

Cell["\<\
The action of the matrix interpreted as a linear combination of projections. \
Projections formed from the eigenvectors and the linear combination is formed \
from the eigenvalues.\
\>", "Text",
 CellChangeTimes->{{3.584292965101551*^9, 3.58429302143163*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Projection", " ", "matrices"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"p1", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r1", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "*", 
        RowBox[{"r1", "[", 
         RowBox[{"[", "j", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "2"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p2", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"r2", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "*", 
        RowBox[{"r2", "[", 
         RowBox[{"[", "j", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "2"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Projection to r1 = \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "p1", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Projection to r2 = \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "p2", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xproj1", " ", "=", " ", 
     RowBox[{"l1", "*", 
      RowBox[{"p1", ".", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xproj2", " ", "=", " ", 
     RowBox[{"l2", "*", 
      RowBox[{"p2", ".", "x"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Projection of x to r1 *l1 = \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "xproj1", "]"}], "//", "N"}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Projection of x to r2 *l2= \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "xproj2", "]"}], "//", "N"}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "GRAPHICS", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotx", " ", "=", " ", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", "Thick", ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", "x"}], "}"}], "]"}], ",", 
        " ", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<x\>\"", ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            "Bold", ",", "18"}], "]"}], ",", "x", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1.5"}], "}"}]}], "]"}]}], "}"}], "]"}]}], ";"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotraxes", " ", "=", " ", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", "Thin", ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", "r1"}], "}"}], "]"}], ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", "r2"}], "}"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Subscript", "[", 
             RowBox[{"\"\<r\>\"", ",", "1"}], "]"}], ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            "Bold", ",", "18"}], "]"}], ",", "r1", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"-", "1.5"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Subscript", "[", 
             RowBox[{"\"\<r\>\"", ",", "2"}], "]"}], ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            "Bold", ",", "18"}], "]"}], ",", "r2", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"-", "1.5"}]}], "}"}]}], "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotxproj", " ", "=", " ", "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0.6", "]"}], ",", "Thin", ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", "xproj1"}], "}"}], "]"}], 
        ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", "xproj2"}], "}"}], "]"}], 
        ",", "\[IndentingNewLine]", 
        RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Subscript", "[", 
              RowBox[{"\"\<P\>\"", ",", "2"}], "]"}], "\"\<x\>\""}], ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            "Bold", ",", "18"}], "]"}], ",", "xproj2", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1.5"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"\"\<3\>\"", 
             RowBox[{"Subscript", "[", 
              RowBox[{"\"\<P\>\"", ",", "1"}], "]"}], "\"\<x\>\""}], ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            "Bold", ",", "18"}], "]"}], ",", "xproj1", ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "0.0"}], "}"}]}], "]"}]}], "}"}], "]"}]}], ";"}],
    " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotsum", " ", "=", " ", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0.8", "]"}], ",", "Thin", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{"xproj1", ",", " ", 
           RowBox[{"xproj1", " ", "+", " ", "xproj2"}]}], "}"}], "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{"xproj2", ",", " ", 
           RowBox[{"xproj2", " ", "+", " ", "xproj1"}]}], "}"}], "]"}]}], 
       "}"}], "]"}]}], ";"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotax", " ", "=", " ", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0.8", "]"}], ",", "Thick", ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"a", ".", "x"}]}], "}"}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{
          RowBox[{"Style", "[", 
           RowBox[{"\"\<Ax\>\"", ",", 
            RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], ",", 
            "Bold", ",", "18"}], "]"}], ",", 
          RowBox[{"a", ".", "x"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "2"}], "}"}]}], "]"}]}], "}"}], "]"}]}], ";"}], 
   " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"pic", " ", "=", " ", 
    RowBox[{"Show", "[", 
     RowBox[{
     "plotx", ",", "plotraxes", ",", "plotxproj", ",", "plotsum", ",", 
      "plotax", ",", 
      RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<EigenDecomp.eps\>\"", ",", "pic"}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{
  3.5641489030097466`*^9, {3.5641491554221835`*^9, 3.564149221915987*^9}, {
   3.564149288167776*^9, 3.564149373715669*^9}, {3.5641495110755253`*^9, 
   3.5641495213681145`*^9}, {3.5641495810405273`*^9, 
   3.5641495894830103`*^9}, {3.564149713631111*^9, 3.564149875875391*^9}, {
   3.5641499162707014`*^9, 3.5641499450623484`*^9}, {3.5641515718684745`*^9, 
   3.5641516117889442`*^9}, {3.564151659113427*^9, 3.564151677193859*^9}, {
   3.5641517550535955`*^9, 3.564151790824459*^9}, {3.5641518301053276`*^9, 
   3.5641521037766085`*^9}, {3.56415213884547*^9, 3.5641522482284613`*^9}, {
   3.5641522934997416`*^9, 3.564152329223804*^9}, {3.5641523643550653`*^9, 
   3.564152371796279*^9}, {3.564152407816742*^9, 3.5641524343991885`*^9}, {
   3.564152476098062*^9, 3.5641525483573885`*^9}, {3.564152584923853*^9, 
   3.564152589759862*^9}, {3.5641557408625903`*^9, 3.564155840000765*^9}, {
   3.564156135130083*^9, 3.5641561667981386`*^9}, {3.567107451498333*^9, 
   3.567107467278355*^9}, {3.567107497728398*^9, 3.567107547168467*^9}, {
   3.5671075853285203`*^9, 3.567107592988531*^9}, {3.5671076416385994`*^9, 
   3.5671076676586356`*^9}, {3.5671078337888684`*^9, 3.567107858698903*^9}, {
   3.5671078912089486`*^9, 3.567107912938979*^9}, {3.567108054309177*^9, 
   3.5671080686091967`*^9}, {3.5671081169492645`*^9, 3.567108151809314*^9}, {
   3.5671081967793765`*^9, 3.567108260879466*^9}, {3.5671083219795513`*^9, 
   3.5671083760196276`*^9}, {3.56710840619967*^9, 3.5671084069196706`*^9}, {
   3.567108455099738*^9, 3.5671084562097397`*^9}, {3.5671085341198487`*^9, 
   3.5671086685900373`*^9}, {3.570143932992503*^9, 3.570143973396574*^9}, {
   3.5701440106026397`*^9, 3.570144060460327*^9}, {3.570144117104027*^9, 
   3.570144216850602*^9}, {3.5701442533234663`*^9, 3.5701442541346674`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Projection to r1 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.5`", "0.5`"},
       {"0.5`", "0.5`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Projection to r1 = ", 
   MatrixForm[{{0.5, 0.5}, {0.5, 0.5}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.564149224888157*^9, 3.5641493765918336`*^9, 3.5641495957343683`*^9, {
   3.5641498332779546`*^9, 3.56414984841582*^9}, 3.5641498797696137`*^9, 
   3.5641499216180077`*^9, 3.564149953945856*^9, 3.56415200218923*^9, {
   3.564152034169286*^9, 3.5641520613289337`*^9}, {3.5641521072398143`*^9, 
   3.564152130749056*^9}, 3.5641522515044675`*^9, 3.564152334309413*^9, 
   3.5641523750410843`*^9, {3.564152430951583*^9, 3.5641524380963955`*^9}, {
   3.5641525159249315`*^9, 3.5641525510405936`*^9}, 3.5641525937378683`*^9, 
   3.5641558437135715`*^9, 3.564156089156802*^9, 3.564156170323745*^9, 
   3.5671038629932604`*^9, 3.5671075190884275`*^9, 3.567107562598489*^9, {
   3.567107644928604*^9, 3.567107668728637*^9}, 3.56710784215888*^9, {
   3.5671079047689676`*^9, 3.56710791348898*^9}, 3.567108104049247*^9, 
   3.567108153039315*^9, {3.56710822078941*^9, 3.567108261959468*^9}, {
   3.5671083329495673`*^9, 3.5671084077596717`*^9}, 3.567108554379877*^9, 
   3.5671085908399277`*^9, 3.5671086234199734`*^9, {3.5671086548800178`*^9, 
   3.567108669200038*^9}, 3.570136788809558*^9, 3.570143639368788*^9, 
   3.570143802061473*^9, 3.570143975003377*^9, 3.570144038589089*^9, {
   3.5701441330472546`*^9, 3.5701442179426036`*^9}, 3.570144257831874*^9, 
   3.5842925555709777`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Projection to r2 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.5`", 
        RowBox[{"-", "0.5`"}]},
       {
        RowBox[{"-", "0.5`"}], "0.5`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Projection to r2 = ", 
   MatrixForm[{{0.5, -0.5}, {-0.5, 0.5}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.564149224888157*^9, 3.5641493765918336`*^9, 3.5641495957343683`*^9, {
   3.5641498332779546`*^9, 3.56414984841582*^9}, 3.5641498797696137`*^9, 
   3.5641499216180077`*^9, 3.564149953945856*^9, 3.56415200218923*^9, {
   3.564152034169286*^9, 3.5641520613289337`*^9}, {3.5641521072398143`*^9, 
   3.564152130749056*^9}, 3.5641522515044675`*^9, 3.564152334309413*^9, 
   3.5641523750410843`*^9, {3.564152430951583*^9, 3.5641524380963955`*^9}, {
   3.5641525159249315`*^9, 3.5641525510405936`*^9}, 3.5641525937378683`*^9, 
   3.5641558437135715`*^9, 3.564156089156802*^9, 3.564156170323745*^9, 
   3.5671038629932604`*^9, 3.5671075190884275`*^9, 3.567107562598489*^9, {
   3.567107644928604*^9, 3.567107668728637*^9}, 3.56710784215888*^9, {
   3.5671079047689676`*^9, 3.56710791348898*^9}, 3.567108104049247*^9, 
   3.567108153039315*^9, {3.56710822078941*^9, 3.567108261959468*^9}, {
   3.5671083329495673`*^9, 3.5671084077596717`*^9}, 3.567108554379877*^9, 
   3.5671085908399277`*^9, 3.5671086234199734`*^9, {3.5671086548800178`*^9, 
   3.567108669200038*^9}, 3.570136788809558*^9, 3.570143639368788*^9, 
   3.570143802061473*^9, 3.570143975003377*^9, 3.570144038589089*^9, {
   3.5701441330472546`*^9, 3.5701442179426036`*^9}, 3.570144257831874*^9, 
   3.5842925555709777`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Projection of x to r1 *l1 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"3.75`"},
        {"3.75`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Projection of x to r1 *l1 = ", 
   MatrixForm[{3.75, 3.75}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.564149224888157*^9, 3.5641493765918336`*^9, 3.5641495957343683`*^9, {
   3.5641498332779546`*^9, 3.56414984841582*^9}, 3.5641498797696137`*^9, 
   3.5641499216180077`*^9, 3.564149953945856*^9, 3.56415200218923*^9, {
   3.564152034169286*^9, 3.5641520613289337`*^9}, {3.5641521072398143`*^9, 
   3.564152130749056*^9}, 3.5641522515044675`*^9, 3.564152334309413*^9, 
   3.5641523750410843`*^9, {3.564152430951583*^9, 3.5641524380963955`*^9}, {
   3.5641525159249315`*^9, 3.5641525510405936`*^9}, 3.5641525937378683`*^9, 
   3.5641558437135715`*^9, 3.564156089156802*^9, 3.564156170323745*^9, 
   3.5671038629932604`*^9, 3.5671075190884275`*^9, 3.567107562598489*^9, {
   3.567107644928604*^9, 3.567107668728637*^9}, 3.56710784215888*^9, {
   3.5671079047689676`*^9, 3.56710791348898*^9}, 3.567108104049247*^9, 
   3.567108153039315*^9, {3.56710822078941*^9, 3.567108261959468*^9}, {
   3.5671083329495673`*^9, 3.5671084077596717`*^9}, 3.567108554379877*^9, 
   3.5671085908399277`*^9, 3.5671086234199734`*^9, {3.5671086548800178`*^9, 
   3.567108669200038*^9}, 3.570136788809558*^9, 3.570143639368788*^9, 
   3.570143802061473*^9, 3.570143975003377*^9, 3.570144038589089*^9, {
   3.5701441330472546`*^9, 3.5701442179426036`*^9}, 3.570144257831874*^9, 
   3.5842925555809774`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Projection of x to r2 *l2= \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"0.75`"},
        {
         RowBox[{"-", "0.75`"}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Projection of x to r2 *l2= ", 
   MatrixForm[{0.75, -0.75}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.564149224888157*^9, 3.5641493765918336`*^9, 3.5641495957343683`*^9, {
   3.5641498332779546`*^9, 3.56414984841582*^9}, 3.5641498797696137`*^9, 
   3.5641499216180077`*^9, 3.564149953945856*^9, 3.56415200218923*^9, {
   3.564152034169286*^9, 3.5641520613289337`*^9}, {3.5641521072398143`*^9, 
   3.564152130749056*^9}, 3.5641522515044675`*^9, 3.564152334309413*^9, 
   3.5641523750410843`*^9, {3.564152430951583*^9, 3.5641524380963955`*^9}, {
   3.5641525159249315`*^9, 3.5641525510405936`*^9}, 3.5641525937378683`*^9, 
   3.5641558437135715`*^9, 3.564156089156802*^9, 3.564156170323745*^9, 
   3.5671038629932604`*^9, 3.5671075190884275`*^9, 3.567107562598489*^9, {
   3.567107644928604*^9, 3.567107668728637*^9}, 3.56710784215888*^9, {
   3.5671079047689676`*^9, 3.56710791348898*^9}, 3.567108104049247*^9, 
   3.567108153039315*^9, {3.56710822078941*^9, 3.567108261959468*^9}, {
   3.5671083329495673`*^9, 3.5671084077596717`*^9}, 3.567108554379877*^9, 
   3.5671085908399277`*^9, 3.5671086234199734`*^9, {3.5671086548800178`*^9, 
   3.567108669200038*^9}, 3.570136788809558*^9, 3.570143639368788*^9, 
   3.570143802061473*^9, 3.570143975003377*^9, 3.570144038589089*^9, {
   3.5701441330472546`*^9, 3.5701442179426036`*^9}, 3.570144257831874*^9, 
   3.5842925555809774`*^9}]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0.], Thickness[Large], 
    StyleBox[{ArrowBox[{{0, 0}, {2, 0.5}}], InsetBox[
       StyleBox["\<\"x\"\>",
        StripOnInput->False,
        FontFamily->"Helvetica",
        FontSize->18,
        FontWeight->Bold], {2, 0.5}, {0, 1.5}]},
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], Thickness[Tiny], 
    StyleBox[{
      ArrowBox[NCache[{{0, 0}, {2^Rational[-1, 2], 2^Rational[-1, 2]}}, {{0, 
         0}, {0.7071067811865475, 0.7071067811865475}}]], 
      ArrowBox[NCache[{{0, 0}, {-2^Rational[-1, 2], 2^Rational[-1, 2]}}, {{0, 
         0}, {-0.7071067811865475, 0.7071067811865475}}]], InsetBox[
       StyleBox[
        SubscriptBox["\<\"r\"\>", "1"],
        StripOnInput->False,
        FontFamily->"Helvetica",
        FontSize->18,
        FontWeight->Bold], 
       NCache[{2^Rational[-1, 2], 2^Rational[-1, 2]}, {0.7071067811865475, 
        0.7071067811865475}], {0, -1.5}], InsetBox[
       StyleBox[
        SubscriptBox["\<\"r\"\>", "2"],
        StripOnInput->False,
        FontFamily->"Helvetica",
        FontSize->18,
        FontWeight->Bold], 
       NCache[{-2^Rational[-1, 2], 2^Rational[-1, 2]}, {-0.7071067811865475, 
        0.7071067811865475}], {0, -1.5}]},
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.6], Thickness[Tiny], ArrowBox[{{0, 0}, {3.75, 3.75}}], 
    ArrowBox[{{0, 0}, {0.75, -0.75}}], 
    {GrayLevel[0.], 
     StyleBox[{InsetBox[
        StyleBox[
         RowBox[{
          SubscriptBox["\<\"P\"\>", "2"], " ", "\<\"x\"\>"}],
         StripOnInput->False,
         FontFamily->"Helvetica",
         FontSize->18,
         FontWeight->Bold], {0.75, -0.75}, {0, 1.5}], InsetBox[
        StyleBox[
         RowBox[{"\<\"3\"\>", " ", 
          SubscriptBox["\<\"P\"\>", "1"], " ", "\<\"x\"\>"}],
         StripOnInput->False,
         FontFamily->"Helvetica",
         FontSize->18,
         FontWeight->Bold], {3.75, 3.75}, {2, 0.}]},
      FontColor->GrayLevel[0.]]}}, 
   {GrayLevel[0.8], Thickness[Tiny], LineBox[{{3.75, 3.75}, {4.5, 3.}}], 
    LineBox[{{0.75, -0.75}, {4.5, 3.}}]}, 
   {GrayLevel[0.8], Thickness[Large], ArrowBox[{{0, 0}, {4.5, 3.}}], 
    {GrayLevel[0.], 
     StyleBox[InsetBox[
       StyleBox["\<\"Ax\"\>",
        StripOnInput->False,
        FontFamily->"Helvetica",
        FontSize->18,
        FontWeight->Bold], {4.5, 3.}, {0, 2}],
      FontColor->GrayLevel[0.]]}}},
  Axes->True,
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 14}]], "Output",
 CellChangeTimes->{{3.564152034574887*^9, 3.5641520613289337`*^9}, {
   3.5641521072398143`*^9, 3.564152130749056*^9}, 3.564152251520067*^9, 
   3.564152334309413*^9, 3.5641523750566845`*^9, {3.564152430951583*^9, 
   3.564152438111995*^9}, {3.5641525159405317`*^9, 3.5641525510561934`*^9}, 
   3.5641525937378683`*^9, 3.5641558437291713`*^9, 3.564156089156802*^9, 
   3.564156170339345*^9, 3.5671038630032606`*^9, 3.5671075190884275`*^9, 
   3.567107562598489*^9, {3.5671076449386044`*^9, 3.567107668738637*^9}, 
   3.5671078425488806`*^9, {3.567107904778968*^9, 3.5671079134989796`*^9}, 
   3.5671081040592465`*^9, 3.5671081530493155`*^9, {3.56710822079941*^9, 
   3.5671082619694676`*^9}, {3.567108332959567*^9, 3.567108407769672*^9}, 
   3.5671085543898773`*^9, 3.567108590849928*^9, 3.5671086234299736`*^9, {
   3.5671086548900175`*^9, 3.5671086692100377`*^9}, 3.5701367888407574`*^9, 
   3.5701436393843875`*^9, 3.570143802061473*^9, 3.570143975003377*^9, 
   3.5701440389478893`*^9, {3.570144133062855*^9, 3.570144217958204*^9}, 
   3.570144257831874*^9, 3.5842925556209774`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1072, 630},
WindowMargins->{{Automatic, 70}, {Automatic, 17}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 673, 13, 135, "Subtitle"],
Cell[1255, 37, 676, 12, 143, "Subsubtitle"],
Cell[1934, 51, 714, 18, 72, "Input"],
Cell[CellGroupData[{
Cell[2673, 73, 106, 1, 71, "Section"],
Cell[CellGroupData[{
Cell[2804, 78, 3427, 87, 472, "Input"],
Cell[CellGroupData[{
Cell[6256, 169, 1572, 34, 36, "Print"],
Cell[7831, 205, 1760, 37, 36, "Print"],
Cell[9594, 244, 1786, 38, 36, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11441, 289, 215, 4, 71, "Section"],
Cell[11659, 295, 269, 5, 45, "Text"],
Cell[CellGroupData[{
Cell[11953, 304, 10133, 246, 712, "Input"],
Cell[CellGroupData[{
Cell[22111, 554, 2118, 41, 36, "Print"],
Cell[24232, 597, 2168, 43, 36, "Print"],
Cell[26403, 642, 2166, 43, 36, "Print"],
Cell[28572, 687, 2190, 44, 36, "Print"]
}, Open  ]],
Cell[30777, 734, 3573, 79, 346, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
