(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     54745,       1245]
NotebookOptionsPosition[     53721,       1206]
NotebookOutlinePosition[     54065,       1221]
CellTagsIndexPosition[     54022,       1218]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[Cell[TextData[{
  StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
   FontWeight->"Bold",
   FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
  StyleBox[
  "\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis Group, An A \
K Peters Book, 2013",
   FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
  "\n"
 }], "Subtitle",
  CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}},
  FontFamily->"Arial"]], "Subtitle",
 CellChangeTimes->{{3.5842947927680626`*^9, 3.5842948099080863`*^9}, 
   3.584295199898632*^9}],

Cell[TextData[{
 "\n",
 StyleBox["Google eigenvector",
  FontWeight->"Bold"],
 " \nCreate a Google matrix from an input adjacency matrix that represents \
webpage inlinks and outlinks.\nFind the dominant eigenvector.\nIdentify the \
page with highest ranking.\nConstruct a graph to visualize the input linkage \
information.\nSee Section 15.3 Eigen Things Revisited, Application: Google \
Eigenvector"
}], "Subsubtitle",
 CellChangeTimes->{{3.553458836149364*^9, 3.5534591955135956`*^9}, {
   3.553459231705659*^9, 3.5534594016991577`*^9}, {3.553459443444831*^9, 
   3.553459457422456*^9}, {3.5534595237225723`*^9, 3.5534595313353853`*^9}, {
   3.5534616381295137`*^9, 3.5534616549463434`*^9}, {3.553464661305624*^9, 
   3.5534646752052484`*^9}, {3.5534647095253086`*^9, 
   3.5534648422659416`*^9}, {3.5534676787097235`*^9, 
   3.5534677463514423`*^9}, {3.553467806988749*^9, 3.553467837190402*^9}, {
   3.553468220545475*^9, 3.553468222448679*^9}, {3.553479878118289*^9, 
   3.5534798879931064`*^9}, {3.553480103289085*^9, 3.5534801878412333`*^9}, {
   3.553480503436247*^9, 3.553480507367454*^9}, {3.553480694255782*^9, 
   3.5534807155186195`*^9}, {3.5534807518510838`*^9, 3.553480757888294*^9}, {
   3.5535211812524977`*^9, 3.553521218411763*^9}, {3.5535217975471807`*^9, 
   3.553521806751197*^9}, {3.553521855267282*^9, 3.553521859182889*^9}, {
   3.553522042732811*^9, 3.5535220775832725`*^9}, {3.553535203749778*^9, 
   3.5535352249814153`*^9}, {3.553535256821071*^9, 3.5535353927129097`*^9}, {
   3.553535426533769*^9, 3.553535427469771*^9}, {3.5535354896514797`*^9, 
   3.5535355041283054`*^9}, {3.553535593266862*^9, 3.553535601020076*^9}, {
   3.553535641439747*^9, 3.5535356636073856`*^9}, {3.5535357184258823`*^9, 
   3.5535357267718964`*^9}, {3.553535862211334*^9, 3.553535871774151*^9}, 
   3.5535359060318117`*^9, {3.553535947262684*^9, 3.553536012751599*^9}, {
   3.5535446445091877`*^9, 3.553544676442444*^9}, {3.553544747625369*^9, 
   3.5535447620865946`*^9}, {3.5535448047370696`*^9, 
   3.5535448088710766`*^9}, {3.5535448901472197`*^9, 
   3.5535449042496443`*^9}, {3.553544951751728*^9, 3.5535450784395504`*^9}, {
   3.5535451479532723`*^9, 3.553545176236122*^9}, {3.5535454678006344`*^9, 
   3.55354547113904*^9}, {3.5535455192339244`*^9, 3.5535455278919396`*^9}, 
   3.5535455880144453`*^9, {3.5535659723742504`*^9, 3.5535659803302646`*^9}, {
   3.553566166438592*^9, 3.5535661756270075`*^9}, 3.553566207061063*^9, {
   3.553566241989524*^9, 3.5535662585099535`*^9}, {3.5616584305480385`*^9, 
   3.561658434697646*^9}, 3.584294873288175*^9, {3.584295034728401*^9, 
   3.584295076258459*^9}, {3.584295614829213*^9, 3.584295721619363*^9}},
 FontFamily->"Arial",
 FontSize->18],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetOptions", "[", 
     RowBox[{"AdjacencyGraph", ",", 
      RowBox[{"BaseStyle", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontFamily", "->", "\"\<Helvetica\>\""}], ",", 
         RowBox[{"FontSize", "\[Rule]", "12"}]}], "}"}]}]}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.5607139033648043`*^9, 3.560713903739205*^9}, {
  3.560714254552621*^9, 3.560714267656644*^9}}],

Cell[CellGroupData[{

Cell["\<\

Input adjacency matrix\
\>", "Section",
 CellChangeTimes->{{3.5842949291082535`*^9, 3.5842949634883013`*^9}, {
  3.58429513406854*^9, 3.584295155998571*^9}, {3.5842953171387963`*^9, 
  3.584295321998803*^9}}],

Cell["\<\

Several options are available -- choose one by loading it into \"mat\" below.
Inlinks are rows, outlinks are columns.
Adjacency matrix has 0 or 1 as entries.\
\>", "Text",
 CellChangeTimes->{{3.5842953249088073`*^9, 3.5842954151089334`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", " ", 
    RowBox[{
    "Example", " ", "in", " ", "Google", " ", "matrix", " ", "section"}], " ",
     "*)"}],
   FontSize->12], 
  StyleBox["\[IndentingNewLine]",
   FontSize->12], 
  RowBox[{
   StyleBox[
    RowBox[{
     RowBox[{"mat1", " ", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], ";"}],
    FontSize->12], "\[IndentingNewLine]", 
   StyleBox["\[IndentingNewLine]",
    FontSize->12], 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Austin", "'"}], "s", " ", "example"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
         "0"}], "}"}], ",", "\[IndentingNewLine]", "          ", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
         "0"}], "}"}], ",", "\[IndentingNewLine]", "       ", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
         "0"}], "}"}], ",", "\[IndentingNewLine]", "      ", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
         "0"}], "}"}], ",", "\[IndentingNewLine]", "      ", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "1", ",", 
         "0"}], "}"}], ",", "\[IndentingNewLine]", "      ", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", 
         "1"}], "}"}], ",", "\[IndentingNewLine]", "      ", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", 
         "1"}], "}"}], ",", "\[IndentingNewLine]", "      ", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", 
         "0"}], "}"}]}], "}"}]}], ";"}], 
   StyleBox["\[IndentingNewLine]",
    FontSize->12], "\[IndentingNewLine]", 
   StyleBox[
    RowBox[{"(*", " ", "Exercises", " ", "*)"}],
    FontSize->12], 
   StyleBox["\[IndentingNewLine]",
    FontSize->12], 
   StyleBox[
    RowBox[{"(*", " ", "EX1", " ", "*)"}],
    FontSize->12], 
   StyleBox["\[IndentingNewLine]",
    FontSize->12], 
   StyleBox[
    RowBox[{
     RowBox[{"mat3", " ", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], ";"}],
    FontSize->12], 
   StyleBox[" ",
    FontSize->12], 
   StyleBox["\[IndentingNewLine]",
    FontSize->12], 
   StyleBox[
    RowBox[{"(*", " ", "EX2", " ", "*)"}],
    FontSize->12], "\[IndentingNewLine]", 
   StyleBox[
    RowBox[{
     RowBox[{"mat4", " ", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}]}], 
       "}"}]}], ";"}],
    FontSize->12], "\[IndentingNewLine]", 
   StyleBox["\[IndentingNewLine]",
    FontSize->12], 
   StyleBox[
    RowBox[{
     StyleBox[
      RowBox[{"(", "*"}]], " ", 
     RowBox[{
      RowBox[{
      "===", "===", "===", "===", "===", "===", "===", "===", "===", "===", "===",
        "===", "==="}], "="}], " ", 
     StyleBox[
      RowBox[{"*", ")"}]]}],
    FontSize->12], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Select", " ", "one", " ", "of", " ", "the", " ", "matrices", " ", "from",
      " ", "above"}], " ", "*)"}], 
   StyleBox["\[IndentingNewLine]",
    FontSize->12], 
   StyleBox[
    RowBox[{
     RowBox[{"mat", " ", "=", " ", "mat1"}], ";"}],
    FontSize->12], "\[IndentingNewLine]", 
   StyleBox["\[IndentingNewLine]",
    FontSize->12], 
   StyleBox[
    RowBox[{"(*", " ", 
     RowBox[{"Form", " ", "the", " ", "transpose", " ", "for", " ", 
      RowBox[{"M", ".", "'"}], "s", " ", "Adjacency", " ", "Graph", " ", 
      "routine"}], " ", "*)"}],
    FontSize->12], 
   StyleBox["\[IndentingNewLine]",
    FontSize->12], 
   StyleBox[
    RowBox[{"(*", " ", 
     RowBox[{
     "This", " ", "routine", " ", "has", " ", "the", " ", "opposite", " ", 
      RowBox[{"in", "/", "outlink"}], " ", "convention", " ", "for", " ", "a",
       " ", "directed", " ", "graph"}], " ", "*)"}],
    FontSize->12], 
   StyleBox["\[IndentingNewLine]",
    FontSize->12], 
   RowBox[{
    RowBox[{"matT", " ", "=", " ", 
     RowBox[{"Transpose", "[", "mat", "]"}]}], ";"}], 
   StyleBox["\[IndentingNewLine]",
    FontSize->12], 
   StyleBox[
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Input Google Matrix =\>\"", ",", 
       RowBox[{"MatrixForm", "[", "mat", "]"}], ",", " ", 
       "\"\<Transpose for AdjacencyGraph\>\"", ",", 
       RowBox[{"MatrixForm", "[", "matT", "]"}]}], "]"}], ";"}],
    FontSize->12]}]}]], "Input",
 CellChangeTimes->{{3.553458836149364*^9, 3.5534591955135956`*^9}, {
   3.553459231705659*^9, 3.5534594016991577`*^9}, {3.553459443444831*^9, 
   3.553459457422456*^9}, {3.5534595237225723`*^9, 3.5534595313353853`*^9}, {
   3.5534616381295137`*^9, 3.5534616549463434`*^9}, {3.553464661305624*^9, 
   3.5534646752052484`*^9}, {3.5534647095253086`*^9, 
   3.5534648422659416`*^9}, {3.5534676787097235`*^9, 
   3.5534677463514423`*^9}, {3.553467806988749*^9, 3.553467837190402*^9}, {
   3.553468220545475*^9, 3.553468222448679*^9}, {3.553479878118289*^9, 
   3.5534798879931064`*^9}, {3.553480103289085*^9, 3.5534801878412333`*^9}, {
   3.553480503436247*^9, 3.553480507367454*^9}, {3.553480694255782*^9, 
   3.5534807155186195`*^9}, {3.5534807518510838`*^9, 3.553480757888294*^9}, {
   3.5535211812524977`*^9, 3.553521218411763*^9}, {3.5535217975471807`*^9, 
   3.553521806751197*^9}, {3.553521855267282*^9, 3.553521859182889*^9}, {
   3.553522042732811*^9, 3.5535220775832725`*^9}, {3.553535203749778*^9, 
   3.5535352249814153`*^9}, {3.553535256821071*^9, 3.5535353927129097`*^9}, {
   3.553535426533769*^9, 3.553535427469771*^9}, {3.5535354896514797`*^9, 
   3.5535355041283054`*^9}, {3.553535593266862*^9, 3.553535601020076*^9}, {
   3.553535641439747*^9, 3.5535356636073856`*^9}, {3.5535357184258823`*^9, 
   3.5535357267718964`*^9}, {3.553535862211334*^9, 3.553535871774151*^9}, 
   3.5535359060318117`*^9, {3.553535947262684*^9, 3.553536012751599*^9}, {
   3.5535446445091877`*^9, 3.553544676442444*^9}, {3.553544747625369*^9, 
   3.5535447620865946`*^9}, {3.5535448047370696`*^9, 
   3.5535448088710766`*^9}, {3.5535448901472197`*^9, 
   3.5535449042496443`*^9}, {3.553544951751728*^9, 3.5535450784395504`*^9}, {
   3.5535451479532723`*^9, 3.553545176236122*^9}, {3.5535454678006344`*^9, 
   3.55354547113904*^9}, {3.5535455192339244`*^9, 3.5535455278919396`*^9}, 
   3.5535455880144453`*^9, {3.5535659723742504`*^9, 3.5535659803302646`*^9}, {
   3.553566166438592*^9, 3.5535661756270075`*^9}, {3.5535662656859655`*^9, 
   3.553566288118805*^9}, {3.560713826097869*^9, 3.5607138385934906`*^9}, {
   3.5607138898551807`*^9, 3.560714057961076*^9}, {3.56071410585316*^9, 
   3.5607141612332573`*^9}, {3.5607143867472534`*^9, 3.560714525337897*^9}, {
   3.5607145629183626`*^9, 3.560714570858777*^9}, {3.5607147438942804`*^9, 
   3.5607147705547276`*^9}, 3.5607148407704506`*^9, {3.5607151389649744`*^9, 
   3.5607151650326204`*^9}, {3.560715230318735*^9, 3.5607152682892017`*^9}, {
   3.5607153507821465`*^9, 3.5607153510785475`*^9}, {3.5607154540387278`*^9, 
   3.56071546101194*^9}, {3.5607155599005136`*^9, 3.560715623657826*^9}, {
   3.560715738162027*^9, 3.560715740470831*^9}, {3.5607157874893136`*^9, 
   3.5607158835230827`*^9}, {3.560715952069603*^9, 3.5607159639100237`*^9}, {
   3.560716140252733*^9, 3.5607161477719464`*^9}, 3.5607161902664213`*^9, {
   3.5607163498391013`*^9, 3.560716357186714*^9}, {3.5607164063892007`*^9, 
   3.560716407138002*^9}, {3.560716533857024*^9, 3.5607165349958267`*^9}, {
   3.5607166202655764`*^9, 3.560716652744833*^9}, {3.5607167014013186`*^9, 
   3.5607167199809513`*^9}, {3.5616568253424177`*^9, 
   3.5616570221367636`*^9}, {3.561657068375245*^9, 3.561657151772991*^9}, {
   3.561657184361449*^9, 3.5616573443241296`*^9}, {3.561657376400587*^9, 
   3.5616575705117273`*^9}, {3.5616576019145827`*^9, 3.561657608404194*^9}, {
   3.5616576603678856`*^9, 3.5616577674152737`*^9}, {3.5616578032797365`*^9, 
   3.5616578090673466`*^9}, {3.5616581907756176`*^9, 3.561658192741221*^9}, 
   3.561658291224194*^9, {3.561658525926606*^9, 3.5616587271201596`*^9}, {
   3.5616588202763243`*^9, 3.561658822553928*^9}, {3.561658935778927*^9, 
   3.561659136410879*^9}, {3.561659213365814*^9, 3.561659239729861*^9}, {
   3.5616592822399354`*^9, 3.561659314110791*^9}, {3.5616636496594887`*^9, 
   3.56166368430715*^9}, {3.561663791058137*^9, 3.561663824379796*^9}, {
   3.5616639945284967`*^9, 3.561663998865304*^9}, {3.561669603723794*^9, 
   3.5616696041293945`*^9}, {3.5616697544512587`*^9, 3.5616698261177845`*^9}, 
   {3.56166986326145*^9, 3.561669934522375*^9}, {3.584294906358221*^9, 
   3.5842949258182487`*^9}, {3.584295240388689*^9, 3.584295306998782*^9}, {
   3.584295420728942*^9, 3.5842954366289635`*^9}, 3.58429546954901*^9, {
   3.584295830559515*^9, 3.5842958306695156`*^9}, {3.584295874429577*^9, 
   3.584295874529577*^9}},
 FontFamily->"Courier New"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Input Google Matrix =\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "1", "1", "1"},
       {"0", "0", "1", "0"},
       {"1", "1", "0", "1"},
       {"0", "0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   "\[InvisibleSpace]", "\<\"Transpose for AdjacencyGraph\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", "1", "0"},
       {"1", "0", "1", "0"},
       {"1", "1", "0", "1"},
       {"1", "0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Input Google Matrix =", 
   MatrixForm[{{0, 1, 1, 1}, {0, 0, 1, 0}, {1, 1, 0, 1}, {0, 0, 1, 0}}], 
   "Transpose for AdjacencyGraph", 
   MatrixForm[{{0, 0, 1, 0}, {1, 0, 1, 0}, {1, 1, 0, 1}, {1, 0, 1, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.5842958165894957`*^9, 3.5842958342295203`*^9}, 
   3.5842958814395866`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

Transform adjaceny matrix to Google matrix, get dominant eigenvector, and \
create graph\
\>", "Section",
 CellChangeTimes->{{3.5842954735790157`*^9, 3.5842955470691185`*^9}, {
  3.5842957481394*^9, 3.58429575540941*^9}, {3.5842957860894527`*^9, 
  3.584295801789475*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", " ", 
    RowBox[{"Normalize", " ", "the", " ", 
     RowBox[{"matrix", ":", " ", 
      RowBox[{"Average", " ", 
       RowBox[{"outlinks", "/", "columns"}]}]}]}], " ", "*)"}],
   FontSize->12], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "It", " ", "is", " ", "easier", " ", "in", " ", "M", " ", "to", " ", 
     "access", " ", "row", " ", "data"}], ",", " ", 
    RowBox[{"so", " ", "use", " ", "matT"}]}], " ", "*)"}], 
  StyleBox["\[IndentingNewLine]",
   FontSize->12], 
  RowBox[{
   RowBox[{
    RowBox[{"n", " ", "=", " ", 
     RowBox[{"Length", "[", 
      RowBox[{"mat", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";"}], 
   StyleBox["\[IndentingNewLine]",
    FontSize->12], 
   StyleBox[
    RowBox[{
     RowBox[{"mattemp", " ", "=", " ", "matT"}], ";"}],
    FontSize->12], "\[IndentingNewLine]", 
   StyleBox[
    RowBox[{
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"(", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"sum", " ", "=", " ", "0"}], ";", "\[IndentingNewLine]", 
         RowBox[{"Do", "[", 
          RowBox[{
           RowBox[{"sum", " ", "=", " ", 
            RowBox[{"sum", " ", "+", " ", 
             RowBox[{"matT", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "j"}], "]"}], "]"}]}]}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", "n"}], "}"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Do", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"mattemp", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "j"}], "]"}], "]"}], " ", "=", " ", 
            RowBox[{
             RowBox[{"mattemp", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "j"}], "]"}], "]"}], "/", "sum"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "1", ",", "n"}], "}"}]}], "]"}], ";"}], 
        "\[IndentingNewLine]", ")"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}], ";"}],
    FontSize->12], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"matnorm", " ", "=", " ", 
     RowBox[{"Transpose", "[", "mattemp", "]"}]}], ";"}], 
   StyleBox["\[IndentingNewLine]",
    FontSize->12], 
   StyleBox[
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"matnorm", "=", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", 
            RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", "/", "3"}], ",", "0", ",", 
            RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", "/", "3"}], ",", "1", ",", "0", ",", "1"}], "}"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", "/", "3"}], ",", "0", ",", "0", ",", "0"}], "}"}]}], 
         "}"}], "//", "N"}]}], ";"}], "*)"}],
    FontSize->12], "\[IndentingNewLine]", 
   StyleBox[
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Matrix normalized -- matnorm--to be stochastic: \>\"", ",", 
       RowBox[{"MatrixForm", "[", "matnorm", "]"}]}], "]"}], ";"}],
    FontSize->12], "\[IndentingNewLine]", 
   StyleBox[
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Eigenvalues of matnorm =\>\"", ",", 
       RowBox[{"Eigenvalues", "[", "matnorm", "]"}]}], "]"}], ";"}],
    FontSize->12], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"evecs", " ", "=", " ", 
     RowBox[{"Eigenvectors", "[", "matnorm", "]"}]}], ";"}], 
   StyleBox["\[IndentingNewLine]",
    FontSize->12], 
   StyleBox[
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Eigenvectors of matnorm = \>\"", ",", 
       RowBox[{"MatrixForm", "[", 
        RowBox[{"evecs", "//", "N"}], "]"}]}], "]"}], ";"}],
    FontSize->12], "\[IndentingNewLine]", 
   StyleBox["\[IndentingNewLine]",
    FontSize->12], 
   StyleBox[
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Dominant evec =\>\"", ",", 
       RowBox[{"evecs", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ";"}],
    FontSize->12], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"max", " ", "=", " ", 
     RowBox[{"evecs", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], 
   StyleBox["\[IndentingNewLine]",
    FontSize->12], 
   StyleBox[
    RowBox[{
     RowBox[{"imax", " ", "=", " ", "1"}], ";"}],
    FontSize->12], "\[IndentingNewLine]", 
   StyleBox[
    RowBox[{
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"evecs", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "i"}], "]"}], "]"}], " ", ">", " ", "max"}], 
         ",", "\[IndentingNewLine]", "     ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"max", "=", 
            RowBox[{"evecs", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "i"}], "]"}], "]"}]}], ";", 
           RowBox[{"imax", "=", "i"}]}], ")"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "2", ",", "n"}], "}"}]}], "]"}], ";"}],
    FontSize->12], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
     "\"\<Highest page rank: page \>\"", ",", "imax", ",", "\"\<  value=\>\"",
       ",", "max"}], "]"}], ";"}], 
   StyleBox["\[IndentingNewLine]",
    FontSize->12], 
   StyleBox["\[IndentingNewLine]",
    FontSize->12], 
   RowBox[{
    StyleBox["pic",
     FontSize->12], 
    StyleBox[" ",
     FontSize->12], 
    StyleBox["=",
     FontSize->12], 
    StyleBox[" ",
     FontSize->12], 
    RowBox[{
     StyleBox["AdjacencyGraph",
      FontSize->12], 
     StyleBox["[",
      FontSize->12], 
     RowBox[{
      StyleBox["matT",
       FontSize->12], 
      StyleBox[",",
       FontSize->12], "\[IndentingNewLine]", 
      RowBox[{
       StyleBox["EdgeStyle",
        FontSize->12], 
       StyleBox["\[Rule]",
        FontSize->12], 
       RowBox[{
        StyleBox["Directive",
         FontSize->12], 
        StyleBox["[",
         FontSize->12], 
        RowBox[{"Black", ",", "Thick"}], "]"}]}], ",", 
      RowBox[{"VertexStyle", "\[Rule]", "White"}], ",", 
      RowBox[{"VertexSize", "\[Rule]", "0.15"}], ",", 
      StyleBox[
       RowBox[{"VertexLabels", "\[Rule]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"i", "\[Rule]", 
           RowBox[{"Placed", "[", 
            RowBox[{"i", ",", "Top"}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}],
       FontSize->12], 
      StyleBox[",",
       FontSize->12], 
      StyleBox[
       RowBox[{"VertexShapeFunction", "\[Rule]", "\"\<Circle\>\""}],
       FontSize->12], 
      StyleBox[",",
       FontSize->12], 
      StyleBox[
       RowBox[{"VertexLabelStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", 
          RowBox[{"FontFamily", "->", "\"\<Helvetica\>\""}], ",", 
          RowBox[{"FontSize", "\[Rule]", "12"}]}], "]"}]}],
       FontSize->12], 
      StyleBox[",",
       FontSize->12], 
      StyleBox[
       RowBox[{"ImagePadding", "\[Rule]", "30"}],
       FontSize->12]}], 
     StyleBox["]",
      FontSize->12]}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   StyleBox[
    RowBox[{
     RowBox[{"Export", "[", 
      RowBox[{"\"\<google_graph.eps\>\"", ",", " ", "pic"}], "]"}], ";"}],
    FontSize->12], 
   StyleBox[" ",
    FontSize->12], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.553458836149364*^9, 3.5534591955135956`*^9}, {
   3.553459231705659*^9, 3.5534594016991577`*^9}, {3.553459443444831*^9, 
   3.553459457422456*^9}, {3.5534595237225723`*^9, 3.5534595313353853`*^9}, {
   3.5534616381295137`*^9, 3.5534616549463434`*^9}, {3.553464661305624*^9, 
   3.5534646752052484`*^9}, {3.5534647095253086`*^9, 
   3.5534648422659416`*^9}, {3.5534676787097235`*^9, 
   3.5534677463514423`*^9}, {3.553467806988749*^9, 3.553467837190402*^9}, {
   3.553468220545475*^9, 3.553468222448679*^9}, {3.553479878118289*^9, 
   3.5534798879931064`*^9}, {3.553480103289085*^9, 3.5534801878412333`*^9}, {
   3.553480503436247*^9, 3.553480507367454*^9}, {3.553480694255782*^9, 
   3.5534807155186195`*^9}, {3.5534807518510838`*^9, 3.553480757888294*^9}, {
   3.5535211812524977`*^9, 3.553521218411763*^9}, {3.5535217975471807`*^9, 
   3.553521806751197*^9}, {3.553521855267282*^9, 3.553521859182889*^9}, {
   3.553522042732811*^9, 3.5535220775832725`*^9}, {3.553535203749778*^9, 
   3.5535352249814153`*^9}, {3.553535256821071*^9, 3.5535353927129097`*^9}, {
   3.553535426533769*^9, 3.553535427469771*^9}, {3.5535354896514797`*^9, 
   3.5535355041283054`*^9}, {3.553535593266862*^9, 3.553535601020076*^9}, {
   3.553535641439747*^9, 3.5535356636073856`*^9}, {3.5535357184258823`*^9, 
   3.5535357267718964`*^9}, {3.553535862211334*^9, 3.553535871774151*^9}, 
   3.5535359060318117`*^9, {3.553535947262684*^9, 3.553536012751599*^9}, {
   3.5535446445091877`*^9, 3.553544676442444*^9}, {3.553544747625369*^9, 
   3.5535447620865946`*^9}, {3.5535448047370696`*^9, 
   3.5535448088710766`*^9}, {3.5535448901472197`*^9, 
   3.5535449042496443`*^9}, {3.553544951751728*^9, 3.5535450784395504`*^9}, {
   3.5535451479532723`*^9, 3.553545176236122*^9}, {3.5535454678006344`*^9, 
   3.55354547113904*^9}, {3.5535455192339244`*^9, 3.5535455278919396`*^9}, 
   3.5535455880144453`*^9, {3.5535659723742504`*^9, 3.5535659803302646`*^9}, {
   3.553566166438592*^9, 3.5535661756270075`*^9}, {3.5535662656859655`*^9, 
   3.553566288118805*^9}, {3.560713826097869*^9, 3.5607138385934906`*^9}, {
   3.5607138898551807`*^9, 3.560714057961076*^9}, {3.56071410585316*^9, 
   3.5607141612332573`*^9}, {3.5607143867472534`*^9, 3.560714525337897*^9}, {
   3.5607145629183626`*^9, 3.560714570858777*^9}, {3.5607147438942804`*^9, 
   3.5607147705547276`*^9}, 3.5607148407704506`*^9, {3.5607151389649744`*^9, 
   3.5607151650326204`*^9}, {3.560715230318735*^9, 3.5607152682892017`*^9}, {
   3.5607153507821465`*^9, 3.5607153510785475`*^9}, {3.5607154540387278`*^9, 
   3.56071546101194*^9}, {3.5607155599005136`*^9, 3.560715623657826*^9}, {
   3.560715738162027*^9, 3.560715740470831*^9}, {3.5607157874893136`*^9, 
   3.5607158835230827`*^9}, {3.560715952069603*^9, 3.5607159639100237`*^9}, {
   3.560716140252733*^9, 3.5607161477719464`*^9}, 3.5607161902664213`*^9, {
   3.5607163498391013`*^9, 3.560716357186714*^9}, {3.5607164063892007`*^9, 
   3.560716407138002*^9}, {3.560716533857024*^9, 3.5607165349958267`*^9}, {
   3.5607166202655764`*^9, 3.560716652744833*^9}, {3.5607167014013186`*^9, 
   3.5607167199809513`*^9}, {3.5616568253424177`*^9, 
   3.5616570221367636`*^9}, {3.561657068375245*^9, 3.561657151772991*^9}, {
   3.561657184361449*^9, 3.5616573443241296`*^9}, {3.561657376400587*^9, 
   3.5616575705117273`*^9}, {3.5616576019145827`*^9, 3.561657608404194*^9}, {
   3.5616576603678856`*^9, 3.5616577674152737`*^9}, {3.5616578032797365`*^9, 
   3.5616578090673466`*^9}, {3.5616581907756176`*^9, 3.561658192741221*^9}, 
   3.561658291224194*^9, {3.561658525926606*^9, 3.5616587271201596`*^9}, {
   3.5616588202763243`*^9, 3.561658822553928*^9}, {3.561658935778927*^9, 
   3.561659136410879*^9}, {3.561659213365814*^9, 3.561659239729861*^9}, {
   3.5616592822399354`*^9, 3.561659314110791*^9}, {3.5616636496594887`*^9, 
   3.56166368430715*^9}, {3.561663791058137*^9, 3.561663824379796*^9}, {
   3.5616639945284967`*^9, 3.561663998865304*^9}, {3.561669603723794*^9, 
   3.5616696041293945`*^9}, {3.5616697544512587`*^9, 3.5616698261177845`*^9}, 
   {3.56166986326145*^9, 3.561669934522375*^9}, {3.584294906358221*^9, 
   3.5842949258182487`*^9}, {3.584295240388689*^9, 3.584295306998782*^9}, {
   3.584295420728942*^9, 3.5842954366289635`*^9}, 3.58429546954901*^9},
 FontFamily->"Courier New"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Matrix normalized -- matnorm--to be stochastic: \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        FractionBox["1", "2"], 
        FractionBox["1", "3"], 
        FractionBox["1", "2"]},
       {"0", "0", 
        FractionBox["1", "3"], "0"},
       {"1", 
        FractionBox["1", "2"], "0", 
        FractionBox["1", "2"]},
       {"0", "0", 
        FractionBox["1", "3"], "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Matrix normalized -- matnorm--to be stochastic: ", 
   MatrixForm[{{0, 
      Rational[1, 2], 
      Rational[1, 3], 
      Rational[1, 2]}, {0, 0, 
      Rational[1, 3], 0}, {1, 
      Rational[1, 2], 0, 
      Rational[1, 2]}, {0, 0, 
      Rational[1, 3], 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.560714032938632*^9, 3.5607140612994814`*^9}, {
   3.5607142580626273`*^9, 3.5607142710106497`*^9}, 3.5607144717362027`*^9, 
   3.5607145840875998`*^9, 3.560714753737898*^9, 3.560714845294459*^9, 
   3.560715242174756*^9, 3.5607152728756094`*^9, 3.560715407457046*^9, 
   3.560715468905554*^9, {3.560715612488206*^9, 3.5607156248434277`*^9}, 
   3.560715744667238*^9, {3.5607158581574373`*^9, 3.5607158842718835`*^9}, 
   3.560715971663237*^9, 3.560716151703153*^9, 3.5607162616677465`*^9, 
   3.5607163591835175`*^9, 3.560716408869605*^9, 3.560716536290629*^9, {
   3.5607166316223965`*^9, 3.5607166542580357`*^9}, 3.560716723178957*^9, 
   3.561586729682803*^9, {3.561657089591282*^9, 3.5616570999341*^9}, 
   3.5616571538477955`*^9, 3.5616572884292316`*^9, 3.5616574263986745`*^9, 
   3.561657773998485*^9, 3.561657813918955*^9, 3.5616581964228277`*^9, 
   3.561658299741809*^9, {3.5616587077605257`*^9, 3.5616587300841646`*^9}, 
   3.561658828825139*^9, 3.561659143789692*^9, 3.5616592408062625`*^9, 
   3.5616592891039476`*^9, 3.561659320803203*^9, 3.5616636884567575`*^9, {
   3.561663807625366*^9, 3.561663834738214*^9}, {3.5616698075069523`*^9, 
   3.561669830345392*^9}, {3.561669890062297*^9, 3.561669938547182*^9}, {
   3.5842958166294956`*^9, 3.5842958342495203`*^9}, 3.5842958814795866`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Eigenvalues of matnorm =\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}]}], ",", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["3"]}]}], ")"}]}], ",", "0"}], "}"}]}],
  SequenceForm[
  "Eigenvalues of matnorm =", {
   1, Rational[1, 6] (-3 + Complex[0, 1] 3^Rational[1, 2]), 
    Rational[1, 6] (-3 + Complex[0, -1] 3^Rational[1, 2]), 0}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.560714032938632*^9, 3.5607140612994814`*^9}, {
   3.5607142580626273`*^9, 3.5607142710106497`*^9}, 3.5607144717362027`*^9, 
   3.5607145840875998`*^9, 3.560714753737898*^9, 3.560714845294459*^9, 
   3.560715242174756*^9, 3.5607152728756094`*^9, 3.560715407457046*^9, 
   3.560715468905554*^9, {3.560715612488206*^9, 3.5607156248434277`*^9}, 
   3.560715744667238*^9, {3.5607158581574373`*^9, 3.5607158842718835`*^9}, 
   3.560715971663237*^9, 3.560716151703153*^9, 3.5607162616677465`*^9, 
   3.5607163591835175`*^9, 3.560716408869605*^9, 3.560716536290629*^9, {
   3.5607166316223965`*^9, 3.5607166542580357`*^9}, 3.560716723178957*^9, 
   3.561586729682803*^9, {3.561657089591282*^9, 3.5616570999341*^9}, 
   3.5616571538477955`*^9, 3.5616572884292316`*^9, 3.5616574263986745`*^9, 
   3.561657773998485*^9, 3.561657813918955*^9, 3.5616581964228277`*^9, 
   3.561658299741809*^9, {3.5616587077605257`*^9, 3.5616587300841646`*^9}, 
   3.561658828825139*^9, 3.561659143789692*^9, 3.5616592408062625`*^9, 
   3.5616592891039476`*^9, 3.561659320803203*^9, 3.5616636884567575`*^9, {
   3.561663807625366*^9, 3.561663834738214*^9}, {3.5616698075069523`*^9, 
   3.561669830345392*^9}, {3.561669890062297*^9, 3.561669938547182*^9}, {
   3.5842958166294956`*^9, 3.5842958342495203`*^9}, 3.5842958814795866`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Eigenvectors of matnorm = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2.`", "1.`", "3.`", "1.`"},
       {
        RowBox[{
         RowBox[{"-", "0.5`"}], "-", 
         RowBox[{"0.8660254037844386`", " ", "\[ImaginaryI]"}]}], "1.`", 
        RowBox[{
         RowBox[{"-", "1.5`"}], "+", 
         RowBox[{"0.8660254037844386`", " ", "\[ImaginaryI]"}]}], "1.`"},
       {
        RowBox[{
         RowBox[{"-", "0.5`"}], "+", 
         RowBox[{"0.8660254037844386`", " ", "\[ImaginaryI]"}]}], "1.`", 
        RowBox[{
         RowBox[{"-", "1.5`"}], "-", 
         RowBox[{"0.8660254037844386`", " ", "\[ImaginaryI]"}]}], "1.`"},
       {"0.`", 
        RowBox[{"-", "1.`"}], "0.`", "1.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Eigenvectors of matnorm = ", 
   MatrixForm[{{2., 1., 3., 1.}, {
      Complex[-0.5, -0.8660254037844386], 1., 
      Complex[-1.5, 0.8660254037844386], 1.}, {
      Complex[-0.5, 0.8660254037844386], 1., 
      Complex[-1.5, -0.8660254037844386], 1.}, {0., -1., 0., 1.}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.560714032938632*^9, 3.5607140612994814`*^9}, {
   3.5607142580626273`*^9, 3.5607142710106497`*^9}, 3.5607144717362027`*^9, 
   3.5607145840875998`*^9, 3.560714753737898*^9, 3.560714845294459*^9, 
   3.560715242174756*^9, 3.5607152728756094`*^9, 3.560715407457046*^9, 
   3.560715468905554*^9, {3.560715612488206*^9, 3.5607156248434277`*^9}, 
   3.560715744667238*^9, {3.5607158581574373`*^9, 3.5607158842718835`*^9}, 
   3.560715971663237*^9, 3.560716151703153*^9, 3.5607162616677465`*^9, 
   3.5607163591835175`*^9, 3.560716408869605*^9, 3.560716536290629*^9, {
   3.5607166316223965`*^9, 3.5607166542580357`*^9}, 3.560716723178957*^9, 
   3.561586729682803*^9, {3.561657089591282*^9, 3.5616570999341*^9}, 
   3.5616571538477955`*^9, 3.5616572884292316`*^9, 3.5616574263986745`*^9, 
   3.561657773998485*^9, 3.561657813918955*^9, 3.5616581964228277`*^9, 
   3.561658299741809*^9, {3.5616587077605257`*^9, 3.5616587300841646`*^9}, 
   3.561658828825139*^9, 3.561659143789692*^9, 3.5616592408062625`*^9, 
   3.5616592891039476`*^9, 3.561659320803203*^9, 3.5616636884567575`*^9, {
   3.561663807625366*^9, 3.561663834738214*^9}, {3.5616698075069523`*^9, 
   3.561669830345392*^9}, {3.561669890062297*^9, 3.561669938547182*^9}, {
   3.5842958166294956`*^9, 3.5842958342495203`*^9}, 3.584295881619587*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Dominant evec =\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "3", ",", "1"}], "}"}]}],
  SequenceForm["Dominant evec =", {2, 1, 3, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.560714032938632*^9, 3.5607140612994814`*^9}, {
   3.5607142580626273`*^9, 3.5607142710106497`*^9}, 3.5607144717362027`*^9, 
   3.5607145840875998`*^9, 3.560714753737898*^9, 3.560714845294459*^9, 
   3.560715242174756*^9, 3.5607152728756094`*^9, 3.560715407457046*^9, 
   3.560715468905554*^9, {3.560715612488206*^9, 3.5607156248434277`*^9}, 
   3.560715744667238*^9, {3.5607158581574373`*^9, 3.5607158842718835`*^9}, 
   3.560715971663237*^9, 3.560716151703153*^9, 3.5607162616677465`*^9, 
   3.5607163591835175`*^9, 3.560716408869605*^9, 3.560716536290629*^9, {
   3.5607166316223965`*^9, 3.5607166542580357`*^9}, 3.560716723178957*^9, 
   3.561586729682803*^9, {3.561657089591282*^9, 3.5616570999341*^9}, 
   3.5616571538477955`*^9, 3.5616572884292316`*^9, 3.5616574263986745`*^9, 
   3.561657773998485*^9, 3.561657813918955*^9, 3.5616581964228277`*^9, 
   3.561658299741809*^9, {3.5616587077605257`*^9, 3.5616587300841646`*^9}, 
   3.561658828825139*^9, 3.561659143789692*^9, 3.5616592408062625`*^9, 
   3.5616592891039476`*^9, 3.561659320803203*^9, 3.5616636884567575`*^9, {
   3.561663807625366*^9, 3.561663834738214*^9}, {3.5616698075069523`*^9, 
   3.561669830345392*^9}, {3.561669890062297*^9, 3.561669938547182*^9}, {
   3.5842958166294956`*^9, 3.5842958342495203`*^9}, 3.584295881619587*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Highest page rank: page \"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"  value=\"\>", "\[InvisibleSpace]", "3"}],
  SequenceForm["Highest page rank: page ", 3, "  value=", 3],
  Editable->False]], "Print",
 CellChangeTimes->{{3.560714032938632*^9, 3.5607140612994814`*^9}, {
   3.5607142580626273`*^9, 3.5607142710106497`*^9}, 3.5607144717362027`*^9, 
   3.5607145840875998`*^9, 3.560714753737898*^9, 3.560714845294459*^9, 
   3.560715242174756*^9, 3.5607152728756094`*^9, 3.560715407457046*^9, 
   3.560715468905554*^9, {3.560715612488206*^9, 3.5607156248434277`*^9}, 
   3.560715744667238*^9, {3.5607158581574373`*^9, 3.5607158842718835`*^9}, 
   3.560715971663237*^9, 3.560716151703153*^9, 3.5607162616677465`*^9, 
   3.5607163591835175`*^9, 3.560716408869605*^9, 3.560716536290629*^9, {
   3.5607166316223965`*^9, 3.5607166542580357`*^9}, 3.560716723178957*^9, 
   3.561586729682803*^9, {3.561657089591282*^9, 3.5616570999341*^9}, 
   3.5616571538477955`*^9, 3.5616572884292316`*^9, 3.5616574263986745`*^9, 
   3.561657773998485*^9, 3.561657813918955*^9, 3.5616581964228277`*^9, 
   3.561658299741809*^9, {3.5616587077605257`*^9, 3.5616587300841646`*^9}, 
   3.561658828825139*^9, 3.561659143789692*^9, 3.5616592408062625`*^9, 
   3.5616592891039476`*^9, 3.561659320803203*^9, 3.5616636884567575`*^9, {
   3.561663807625366*^9, 3.561663834738214*^9}, {3.5616698075069523`*^9, 
   3.561669830345392*^9}, {3.561669890062297*^9, 3.561669938547182*^9}, {
   3.5842958166294956`*^9, 3.5842958342495203`*^9}, 3.584295881619587*^9}]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4}, {
       SparseArray[
       Automatic, {4, 4}, 0, {
        1, {{0, 1, 3, 6, 8}, {{3}, {1}, {3}, {1}, {2}, {4}, {1}, {3}}}, 
         Pattern}], Null}, {
      BaseStyle -> {FontFamily -> "Helvetica", FontSize -> 12}, EdgeStyle -> {
         Directive[
          GrayLevel[0], 
          Thickness[Large]]}, ImagePadding -> 30, 
       VertexLabels -> {
        3 -> Placed[3, Top], 4 -> Placed[4, Top], 2 -> Placed[2, Top], 1 -> 
         Placed[1, Top]}, VertexLabelStyle -> {
         Directive[
          GrayLevel[0], FontFamily -> "Helvetica", FontSize -> 12]}, 
       VertexShapeFunction -> {"Circle"}, VertexSize -> {0.15}, VertexStyle -> {
         GrayLevel[1]}}]], Typeset`boxes, Typeset`boxes$s2d = 
    GraphicsGroupBox[{{
       Directive[
        Hue[0.6, 0.2, 0.8], 
        EdgeForm[
         Directive[
          GrayLevel[0], 
          Opacity[0.7]]]], FontFamily -> "Helvetica", FontSize -> 12, 
       TagBox[{
         TagBox[
          StyleBox[
           
           DiskBox[{0.9400693765298261, 0.875671696990294}, {
            0.06567542502201679, 0.06567542502201679}], 
           GrayLevel[1], StripOnInput -> False], "DynamicName", BoxID -> 
          "VertexID$1"], 
         InsetBox[
          FormBox[
           StyleBox["1", 
            Directive[
             GrayLevel[0], FontFamily -> "Helvetica", FontSize -> 12], 
            StripOnInput -> False], TraditionalForm], 
          Offset[{0, -2}, 
           DynamicLocation["VertexID$1", Automatic, Top]], 
          ImageScaled[{0.5, 1}], BaseStyle -> "Graphics"]}, "DynamicName", 
        BoxID -> "VertexLabelID$1"], 
       TagBox[{
         TagBox[
          StyleBox[
           
           DiskBox[{0., 0.4381300037459262}, {0.06567542502201679, 
            0.06567542502201679}], 
           GrayLevel[1], StripOnInput -> False], "DynamicName", BoxID -> 
          "VertexID$2"], 
         InsetBox[
          FormBox[
           StyleBox["2", 
            Directive[
             GrayLevel[0], FontFamily -> "Helvetica", FontSize -> 12], 
            StripOnInput -> False], TraditionalForm], 
          Offset[{0, -2}, 
           DynamicLocation["VertexID$2", Automatic, Top]], 
          ImageScaled[{0.5, 1}], BaseStyle -> "Graphics"]}, "DynamicName", 
        BoxID -> "VertexLabelID$2"], 
       TagBox[{
         TagBox[
          StyleBox[
           
           DiskBox[{0.9411252977877977, 0.}, {0.06567542502201679, 
            0.06567542502201679}], 
           GrayLevel[1], StripOnInput -> False], "DynamicName", BoxID -> 
          "VertexID$3"], 
         InsetBox[
          FormBox[
           StyleBox["3", 
            Directive[
             GrayLevel[0], FontFamily -> "Helvetica", FontSize -> 12], 
            StripOnInput -> False], TraditionalForm], 
          Offset[{0, -2}, 
           DynamicLocation["VertexID$3", Automatic, Top]], 
          ImageScaled[{0.5, 1}], BaseStyle -> "Graphics"]}, "DynamicName", 
        BoxID -> "VertexLabelID$3"], 
       TagBox[{
         TagBox[
          StyleBox[
           
           DiskBox[{1.8824177406519322`, 0.4386208514461305}, {
            0.06567542502201679, 0.06567542502201679}], 
           GrayLevel[1], StripOnInput -> False], "DynamicName", BoxID -> 
          "VertexID$4"], 
         InsetBox[
          FormBox[
           StyleBox["4", 
            Directive[
             GrayLevel[0], FontFamily -> "Helvetica", FontSize -> 12], 
            StripOnInput -> False], TraditionalForm], 
          Offset[{0, -2}, 
           DynamicLocation["VertexID$4", Automatic, Top]], 
          ImageScaled[{0.5, 1}], BaseStyle -> "Graphics"]}, "DynamicName", 
        BoxID -> "VertexLabelID$4"]}, {
       Directive[
        Opacity[0.7], 
        Hue[0.6, 0.7, 0.5]], FontFamily -> "Helvetica", FontSize -> 12, 
       Arrowheads[{{0.03457088293230457, 0.7}}], 
       StyleBox[{
         Arrowheads[0.03457088293230457], 
         ArrowBox[{
           DynamicLocation["VertexID$1", Automatic, Center], {
           0.9725500638581286, 0.7832273945404383}, {0.9801998168964874, 
           0.759657668969618}, {0.9867075416865816, 0.7357474158741768}, {
           0.9920581870449794, 0.7115519353193227}, {0.9962393779024559, 
           0.6871271870494835}, {0.9992414439252792, 0.6625296610635989}, {
           1.0010574418809304`, 0.6378162469640307}, {1.0016831716965384`, 
           0.6130441023812636}, {1.002105540199727, 0.26277542358514616`}, {
           1.0015395546760728`, 0.2380018419825867}, {0.9997831628346983, 
           0.21328412014720682`}, {0.9968404268903761, 0.1886794256725003}, {
           0.9927181528559483, 0.16424466474023938`}, {0.9874258748012548, 
           0.14003635050683041`}, {0.9809758328025658, 
           0.11611047239866457`}, {0.9733829446335116, 0.09252236661876147}, 
           DynamicLocation["VertexID$3", Automatic, Center]}]}, 
        Directive[
         GrayLevel[0], 
         Thickness[Large]], StripOnInput -> False], 
       StyleBox[{
         Arrowheads[0.03457088293230457], 
         ArrowBox[{
           DynamicLocation["VertexID$2", Automatic, Center], 
           DynamicLocation["VertexID$1", Automatic, Center]}]}, 
        Directive[
         GrayLevel[0], 
         Thickness[Large]], StripOnInput -> False], 
       StyleBox[{
         Arrowheads[0.03457088293230457], 
         ArrowBox[{
           DynamicLocation["VertexID$2", Automatic, Center], {
           0.11559161886696814`, 0.42664592617825714`}, {0.1447462019702998, 
           0.42303953716131654`}, {0.17369368297828836`, 
           0.4180356285927348}, {0.20236711163403104`, 0.4116457736026261}, {
           0.23070017151385508`, 0.4038847507630203}, {0.25862733340514044`, 
           0.3947705099077147}, {0.2860840068634656, 0.38432413061757364`}, {
           0.3130066895985545, 0.37256977346729414`}, {0.6894568087136734, 
           0.1973177719689238}, {0.7157832334586394, 0.18428262264802125`}, {
           0.7414525119828443, 0.16999682908527608`}, {0.7664052759152984, 
           0.1544934317220592}, {0.7905838140529009, 0.137808287095803}, {
           0.8139322058359526, 0.1199799849103535}, {0.8363964506822369, 
           0.10104975878500633`}, {0.857924592880541, 0.08106139088864778}, 
           DynamicLocation["VertexID$3", Automatic, Center]}]}, 
        Directive[
         GrayLevel[0], 
         Thickness[Large]], StripOnInput -> False], 
       StyleBox[{
         Arrowheads[0.03457088293230457], 
         ArrowBox[{
           DynamicLocation["VertexID$3", Automatic, Center], {
           0.9086446104594954, 0.09244430244985584}, {0.9009948574211367, 
           0.11601402802067615`}, {0.8944871326310425, 
           0.13992428111611732`}, {0.8891364872726447, 
           0.16411976167097134`}, {0.8849552964151682, 
           0.18854450994081057`}, {0.8819532303923449, 
           0.21314203592669523`}, {0.8801372324366936, 
           0.23785545002626332`}, {0.8795115026210857, 0.2626275946090305}, {
           0.8790891341178971, 0.612896273405148}, {0.8796551196415514, 
           0.6376698550077075}, {0.8814115114829258, 0.6623875768430872}, {
           0.884354247427248, 0.686992271317794}, {0.8884765214616759, 
           0.7114270322500548}, {0.8937687995163692, 0.7356353464834637}, {
           0.9002188415150583, 0.7595612245916296}, {0.9078117296841126, 
           0.7831493303715327}, 
           DynamicLocation["VertexID$1", Automatic, Center]}]}, 
        Directive[
         GrayLevel[0], 
         Thickness[Large]], StripOnInput -> False], 
       StyleBox[{
         Arrowheads[0.03457088293230457], 
         ArrowBox[{
           DynamicLocation["VertexID$3", Automatic, Center], {
           0.8255336789208297, 0.011484077567669115`}, {0.7963790958174981, 
           0.015090466584609774`}, {0.7674316148095096, 
           0.020094375153191457`}, {0.7387581861537669, 
           0.026484230143300147`}, {0.7104251262739427, 
           0.03424525298290604}, {0.6824979643826574, 0.04335949383821169}, {
           0.6550412909243323, 0.05380587312835261}, {0.6281186081892434, 
           0.06556023027863211}, {0.2516684890741245, 0.2408122317770025}, {
           0.2253420643291585, 0.25384738109790506`}, {0.1996727858049535, 
           0.26813317466065023`}, {0.1747200218724994, 
           0.28363657202386705`}, {0.15054148373489695`, 
           0.3003217166501233}, {0.1271930919518452, 0.3181500188355728}, {
           0.10472884710556096`, 0.33708024496091993`}, {0.08320070490725687, 
           0.35706861285727853`}, 
           DynamicLocation["VertexID$2", Automatic, Center]}]}, 
        Directive[
         GrayLevel[0], 
         Thickness[Large]], StripOnInput -> False], 
       StyleBox[{
         Arrowheads[0.03457088293230457], 
         ArrowBox[{
           DynamicLocation["VertexID$3", Automatic, Center], {
           1.0243255114182293`, 0.08111940986898242}, {1.0458538822318588`, 
           0.10112244938575632`}, {1.0683190608092314`, 
           0.12006731917378843`}, {1.091669089279585, 0.13791020319606517`}, {
           1.1158499632753427`, 0.154609834108155}, {1.1408057568343906`, 
           0.17012758870206857`}, {1.1664787517466526`, 
           0.18442757723471104`}, {1.1928095710458093`, 
           0.19747672643432873`}, {1.5693265481914629`, 
           0.37292506701278083`}, {1.5962542934830726`, 0.384693196571421}, {
           1.6237166857914755`, 0.3951530889464934}, {1.6516502095997367`, 
           0.40428055230999427`}, {1.679990259749478, 0.41205447649980315`}, {
           1.7086712908608563`, 0.41845688184364727`}, {1.7376269689271027`, 
           0.42347296074281177`}, {1.76679032473301, 0.42709111191942234`}, 
           DynamicLocation["VertexID$4", Automatic, Center]}]}, 
        Directive[
         GrayLevel[0], 
         Thickness[Large]], StripOnInput -> False], 
       StyleBox[{
         Arrowheads[0.03457088293230457], 
         ArrowBox[{
           DynamicLocation["VertexID$4", Automatic, Center], 
           DynamicLocation["VertexID$1", Automatic, Center]}]}, 
        Directive[
         GrayLevel[0], 
         Thickness[Large]], StripOnInput -> False], 
       StyleBox[{
         Arrowheads[0.03457088293230457], 
         ArrowBox[{
           DynamicLocation["VertexID$4", Automatic, Center], {
           1.7992175270215012`, 0.35750144157714814`}, {1.7776891562078716`, 
           0.3374984020603742}, {1.755223977630499, 0.3185535322723422}, {
           1.7318739491601454`, 0.3007106482500653}, {1.7076930751643877`, 
           0.2840110173379755}, {1.6827372816053399`, 0.26849326274406193`}, {
           1.6570642866930778`, 0.2541932742114196}, {1.630733467393921, 
           0.24114412501180182`}, {1.2542164902482675`, 
           0.06569578443334967}, {1.2272887449566579`, 0.05392765487470952}, {
           1.1998263526482549`, 0.04346776249963702}, {1.1718928288399937`, 
           0.03434029913613623}, {1.1435527786902524`, 
           0.026566374946327298`}, {1.114871747578874, 
           0.020163969602483234`}, {1.0859160695126278`, 
           0.015147890703318678`}, {1.0567527137067207`, 
           0.011529739526708216`}, 
           DynamicLocation["VertexID$3", Automatic, Center]}]}, 
        Directive[
         GrayLevel[0], 
         Thickness[Large]], StripOnInput -> False]}}], Typeset`data}, 
    TagBox[
     DynamicBox[GraphComputation`NetworkGraphicsBox[
      2, Typeset`graph, Typeset`boxes], {
      CachedValue :> Typeset`boxes, SingleEvaluation -> True, 
       SynchronousUpdating -> False, TrackedSymbols :> {}},
      ImageSizeCache->{{166.5, 193.5}, {-10.740000000000009`, 
       6.259999999999991}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False,
    UnsavedVariables:>{Typeset`data}]],
  BaseStyle->{},
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FrameTicks->None,
  ImagePadding->30]], "Output",
 CellChangeTimes->{{3.5607158581886377`*^9, 3.5607158843030834`*^9}, 
   3.560715971741237*^9, 3.560716151734353*^9, 3.5607162616833467`*^9, 
   3.5607163591991177`*^9, 3.560716408932005*^9, 3.560716536353029*^9, {
   3.5607166317003965`*^9, 3.560716654289236*^9}, 3.5607167232101574`*^9, 
   3.5615867298728037`*^9, {3.5616570896380825`*^9, 3.5616570999653006`*^9}, 
   3.561657153878995*^9, 3.561657288444832*^9, 3.5616574264142747`*^9, 
   3.5616577741544857`*^9, 3.561657813981355*^9, 3.561658196594428*^9, 
   3.561658299819809*^9, {3.561658708010126*^9, 3.561658730255765*^9}, 
   3.5616588290591393`*^9, 3.5616591438364925`*^9, 3.561659240868663*^9, 
   3.5616592891819477`*^9, 3.561659320881203*^9, 3.5616636885191574`*^9, {
   3.561663807828167*^9, 3.561663834785014*^9}, {3.5616698078813524`*^9, 
   3.561669830392192*^9}, {3.561669890077897*^9, 3.561669938593982*^9}, {
   3.584295817329497*^9, 3.584295834459521*^9}, 3.5842958816395864`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1206, 697},
WindowMargins->{{Automatic, 48}, {20, Automatic}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 811, 16, 155, "Subtitle"],
Cell[1393, 40, 2702, 42, 163, "Subsubtitle"],
Cell[4098, 84, 621, 17, 72, "Input"],
Cell[CellGroupData[{
Cell[4744, 105, 219, 6, 97, "Section"],
Cell[4966, 113, 252, 6, 79, "Text"],
Cell[CellGroupData[{
Cell[5243, 123, 10355, 232, 552, "Input"],
Cell[15601, 357, 1890, 49, 65, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17540, 412, 283, 7, 97, "Section"],
Cell[CellGroupData[{
Cell[17848, 423, 11907, 292, 592, "Input"],
Cell[CellGroupData[{
Cell[29780, 719, 2631, 57, 105, "Print"],
Cell[32414, 778, 2085, 41, 40, "Print"],
Cell[34502, 821, 2939, 59, 65, "Print"],
Cell[37444, 882, 1570, 24, 23, "Print"],
Cell[39017, 908, 1594, 23, 23, "Print"]
}, Open  ]],
Cell[40626, 934, 13055, 267, 375, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
