(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     25191,        628]
NotebookOptionsPosition[     24517,        601]
NotebookOutlinePosition[     24861,        616]
CellTagsIndexPosition[     24818,        613]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 "\n"
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
  3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
  3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
  3.5842134956497355`*^9, 3.5842135862546945`*^9}},
 FontFamily->"Arial"],

Cell[TextData[{
 "\n",
 StyleBox["Hedgehog Plot",
  FontWeight->"Bold"],
 "\nThe normal to each facet of an icosahedron is displayed\nSee Figure 8.2 \
in PLA"
}], "Subsubtitle",
 CellChangeTimes->{{3.5842985121895266`*^9, 3.584298603679654*^9}, {
  3.584298729819831*^9, 3.5842987305198317`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"points", " ", "=", " ", 
     RowBox[{
      RowBox[{"PolyhedronData", "[", 
       RowBox[{"\"\<Icosahedron\>\"", ",", "\"\<VertexCoordinates\>\""}], 
       "]"}], "//", "N"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"centroid", " ", "=", " ", 
     RowBox[{
      RowBox[{"PolyhedronData", "[", 
       RowBox[{"\"\<Icosahedron\>\"", ",", "\"\<Centroid\>\""}], "]"}], "//", 
      "N"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tris", " ", "=", " ", 
     RowBox[{
      RowBox[{"PolyhedronData", "[", 
       RowBox[{"\"\<Icosahedron\>\"", ",", "\"\<FaceIndices\>\""}], "]"}], "//",
       "N"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"numtris", " ", "=", " ", 
     RowBox[{"PolyhedronData", "[", 
      RowBox[{"\"\<Icosahedron\>\"", ",", "\"\<FaceCount\>\""}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<num tris = \>\"", ",", "numtris"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<tris = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "tris", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<points = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "points", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "calculate", " ", "centroid", " ", "of", " ", "each", " ", "face"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"center", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numtris"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"(", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"p1", " ", "=", " ", 
         RowBox[{"points", "[", 
          RowBox[{"[", 
           RowBox[{"tris", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"p2", " ", "=", " ", 
         RowBox[{"points", "[", 
          RowBox[{"[", 
           RowBox[{"tris", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "2"}], "]"}], "]"}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"p3", " ", "=", " ", 
         RowBox[{"points", "[", 
          RowBox[{"[", 
           RowBox[{"tris", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "3"}], "]"}], "]"}], "]"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"center", "[", 
          RowBox[{"[", "i", "]"}], "]"}], " ", "=", " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "3"}], ")"}], "*", 
          RowBox[{"(", 
           RowBox[{"p1", " ", "+", " ", "p2", " ", "+", " ", "p3"}], 
           ")"}]}]}]}], ")"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "numtris"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<center of each tri =\>\"", ",", 
      RowBox[{"MatrixForm", "[", "center", "]"}]}], "]"}], ";"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"icoplot", " ", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Opacity", "[", "1", "]"}], ",", 
         RowBox[{"EdgeForm", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "0.003", "]"}], ",", "Black"}], "}"}], 
          "]"}], ",", 
         RowBox[{"PolyhedronData", "[", 
          RowBox[{"\"\<Icosahedron\>\"", ",", "\"\<Faces\>\""}], "]"}]}], 
        "}"}], ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
       RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], " ", "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"alpha", " ", "=", " ", 
     RowBox[{"2.5", "*", 
      RowBox[{"EuclideanDistance", "[", 
       RowBox[{"centroid", ",", 
        RowBox[{"center", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"normalplot", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Graphics3D", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
           RowBox[{"Arrow", "[", 
            RowBox[{"Tube", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"centroid", ",", 
                RowBox[{"alpha", "*", 
                 RowBox[{"center", "[", 
                  RowBox[{"[", "i", "]"}], "]"}]}]}], "}"}], ",", "0.01"}], 
             "]"}], "]"}]}], "}"}], ",", 
         RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numtris"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"icoplot", ",", "normalplot"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.564517048267086*^9, 3.5645171097467937`*^9}, {
   3.564517285231502*^9, 3.564517289069109*^9}, {3.5645174462081847`*^9, 
   3.5645175590743833`*^9}, {3.56451860482162*^9, 3.5645186458496923`*^9}, {
   3.5645186763633456`*^9, 3.5645186792649508`*^9}, {3.5646105225121717`*^9, 
   3.564611046808693*^9}, {3.564611077556347*^9, 3.5646111608292933`*^9}, 
   3.564611225553807*^9, {3.564611262791072*^9, 3.5646113259711833`*^9}, {
   3.564611425699358*^9, 3.5646116717429905`*^9}, {3.564612254963216*^9, 
   3.5646122833240657`*^9}, {3.5646123174725256`*^9, 3.5646123968142653`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"num tris = \"\>", "\[InvisibleSpace]", "20"}],
  SequenceForm["num tris = ", 20],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.564517514785905*^9, {3.564517555065176*^9, 3.5645175719444056`*^9}, 
   3.564518612496834*^9, 3.564518646988494*^9, 3.564518682166556*^9, 
   3.5646108424327335`*^9, 3.5646110056870203`*^9, {3.564611051363901*^9, 
   3.564611083499957*^9}, {3.5646114805802546`*^9, 3.564611521873527*^9}, 
   3.5646115788448267`*^9, {3.56461160887488*^9, 3.5646116752529964`*^9}, 
   3.564612287255273*^9, {3.5646123245861382`*^9, 3.5646124002774715`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"tris = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2.`", "12.`", "8.`"},
       {"2.`", "8.`", "7.`"},
       {"2.`", "7.`", "11.`"},
       {"2.`", "11.`", "4.`"},
       {"2.`", "4.`", "12.`"},
       {"5.`", "9.`", "1.`"},
       {"6.`", "5.`", "1.`"},
       {"10.`", "6.`", "1.`"},
       {"3.`", "10.`", "1.`"},
       {"9.`", "3.`", "1.`"},
       {"12.`", "10.`", "8.`"},
       {"8.`", "3.`", "7.`"},
       {"7.`", "9.`", "11.`"},
       {"11.`", "5.`", "4.`"},
       {"4.`", "6.`", "12.`"},
       {"5.`", "11.`", "9.`"},
       {"6.`", "4.`", "5.`"},
       {"10.`", "12.`", "6.`"},
       {"3.`", "8.`", "10.`"},
       {"9.`", "7.`", "3.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["tris = ", 
   MatrixForm[CompressedData["
1:eJxdj0EKgCAURKU2Ll24aOHCJMJb5Bk6QtC6q3eEAn2CI8Rj5o+/cb2e856M
Mf7/ZtNPqciNsYw+OoiP3sVHO/HR/Mc3psb3qFxkjr+VcY5vyzjHZ68VP0s+
CskHIft2IT2dkJ76Xu4lyTnJ0S9Ljn5RcuwLPfcBOWwa0g==
    "]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.564517514785905*^9, {3.564517555065176*^9, 3.5645175719444056`*^9}, 
   3.564518612496834*^9, 3.564518646988494*^9, 3.564518682166556*^9, 
   3.5646108424327335`*^9, 3.5646110056870203`*^9, {3.564611051363901*^9, 
   3.564611083499957*^9}, {3.5646114805802546`*^9, 3.564611521873527*^9}, 
   3.5646115788448267`*^9, {3.56461160887488*^9, 3.5646116752529964`*^9}, 
   3.564612287255273*^9, {3.5646123245861382`*^9, 3.5646124002774715`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"points = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.`", "0.`", 
        RowBox[{"-", "0.9510565162951536`"}]},
       {"0.`", "0.`", "0.9510565162951536`"},
       {
        RowBox[{"-", "0.85065080835204`"}], "0.`", 
        RowBox[{"-", "0.42532540417601994`"}]},
       {"0.85065080835204`", "0.`", "0.42532540417601994`"},
       {"0.6881909602355868`", 
        RowBox[{"-", "0.5`"}], 
        RowBox[{"-", "0.42532540417601994`"}]},
       {"0.6881909602355868`", "0.5`", 
        RowBox[{"-", "0.42532540417601994`"}]},
       {
        RowBox[{"-", "0.6881909602355868`"}], 
        RowBox[{"-", "0.5`"}], "0.42532540417601994`"},
       {
        RowBox[{"-", "0.6881909602355868`"}], "0.5`", "0.42532540417601994`"},
       {
        RowBox[{"-", "0.2628655560595668`"}], 
        RowBox[{"-", "0.8090169943749475`"}], 
        RowBox[{"-", "0.42532540417601994`"}]},
       {
        RowBox[{"-", "0.2628655560595668`"}], "0.8090169943749475`", 
        RowBox[{"-", "0.42532540417601994`"}]},
       {"0.2628655560595668`", 
        RowBox[{"-", "0.8090169943749475`"}], "0.42532540417601994`"},
       {"0.2628655560595668`", "0.8090169943749475`", "0.42532540417601994`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["points = ", 
   MatrixForm[{{0., 0., -0.9510565162951536}, {0., 0., 
    0.9510565162951536}, {-0.85065080835204, 0., -0.42532540417601994`}, {
    0.85065080835204, 0., 0.42532540417601994`}, {
    0.6881909602355868, -0.5, -0.42532540417601994`}, {0.6881909602355868, 
    0.5, -0.42532540417601994`}, {-0.6881909602355868, -0.5, 
    0.42532540417601994`}, {-0.6881909602355868, 0.5, 
    0.42532540417601994`}, {-0.2628655560595668, -0.8090169943749475, \
-0.42532540417601994`}, {-0.2628655560595668, 
    0.8090169943749475, -0.42532540417601994`}, {
    0.2628655560595668, -0.8090169943749475, 0.42532540417601994`}, {
    0.2628655560595668, 0.8090169943749475, 0.42532540417601994`}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.564517514785905*^9, {3.564517555065176*^9, 3.5645175719444056`*^9}, 
   3.564518612496834*^9, 3.564518646988494*^9, 3.564518682166556*^9, 
   3.5646108424327335`*^9, 3.5646110056870203`*^9, {3.564611051363901*^9, 
   3.564611083499957*^9}, {3.5646114805802546`*^9, 3.564611521873527*^9}, 
   3.5646115788448267`*^9, {3.56461160887488*^9, 3.5646116752529964`*^9}, 
   3.564612287255273*^9, {3.5646123245861382`*^9, 3.5646124002774715`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"center of each tri =\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "0.14177513472533998`"}], "0.43633899812498245`", 
        "0.6005691082157312`"},
       {
        RowBox[{"-", "0.4587939734903912`"}], "0.`", "0.6005691082157312`"},
       {
        RowBox[{"-", "0.14177513472533998`"}], 
        RowBox[{"-", "0.43633899812498245`"}], "0.6005691082157312`"},
       {"0.3711721214705356`", 
        RowBox[{"-", "0.2696723314583158`"}], "0.6005691082157312`"},
       {"0.3711721214705356`", "0.2696723314583158`", "0.6005691082157312`"},
       {"0.14177513472533998`", 
        RowBox[{"-", "0.43633899812498245`"}], 
        RowBox[{"-", "0.6005691082157312`"}]},
       {"0.4587939734903912`", "0.`", 
        RowBox[{"-", "0.6005691082157312`"}]},
       {"0.14177513472533998`", "0.43633899812498245`", 
        RowBox[{"-", "0.6005691082157312`"}]},
       {
        RowBox[{"-", "0.3711721214705356`"}], "0.2696723314583158`", 
        RowBox[{"-", "0.6005691082157312`"}]},
       {
        RowBox[{"-", "0.3711721214705356`"}], 
        RowBox[{"-", "0.2696723314583158`"}], 
        RowBox[{"-", "0.6005691082157312`"}]},
       {
        RowBox[{"-", "0.2293969867451956`"}], "0.7060113295832983`", 
        "0.14177513472533998`"},
       {
        RowBox[{"-", "0.7423442429410712`"}], "0.`", "0.14177513472533998`"},
       {
        RowBox[{"-", "0.22939698674519562`"}], 
        RowBox[{"-", "0.7060113295832983`"}], "0.14177513472533998`"},
       {"0.6005691082157312`", 
        RowBox[{"-", "0.43633899812498245`"}], "0.14177513472533998`"},
       {"0.6005691082157312`", "0.43633899812498245`", "0.14177513472533998`"},
       {"0.22939698674519562`", 
        RowBox[{"-", "0.7060113295832983`"}], 
        RowBox[{"-", "0.14177513472533998`"}]},
       {"0.7423442429410712`", "0.`", 
        RowBox[{"-", "0.14177513472533998`"}]},
       {"0.2293969867451956`", "0.7060113295832983`", 
        RowBox[{"-", "0.14177513472533998`"}]},
       {
        RowBox[{"-", "0.6005691082157312`"}], "0.43633899812498245`", 
        RowBox[{"-", "0.14177513472533998`"}]},
       {
        RowBox[{"-", "0.6005691082157312`"}], 
        RowBox[{"-", "0.43633899812498245`"}], 
        RowBox[{"-", "0.14177513472533998`"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["center of each tri =", 
   MatrixForm[CompressedData["
1:eJxTTMoPSmViYGAQAWJmIJ7B1MK+QfXQfqnFu9J/vblt73PixpY75o/tffrf
pz6MubufAQpg4mjq98PEP53Yuc3j4HX7gh/8e/2dLuISt0czxx7NnP1Qe+3R
7N2Pph5mzn6o+fvRzEcXRzP/7P6jvqlCS6c/g7sDov453L8wcV9U9XB3wPwB
cz8OcXs0c+zRzIG687k9mr0wd9qjuRPuDzTz0cXh5gMAm3r90Q==
    "]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.564517514785905*^9, {3.564517555065176*^9, 3.5645175719444056`*^9}, 
   3.564518612496834*^9, 3.564518646988494*^9, 3.564518682166556*^9, 
   3.5646108424327335`*^9, 3.5646110056870203`*^9, {3.564611051363901*^9, 
   3.564611083499957*^9}, {3.5646114805802546`*^9, 3.564611521873527*^9}, 
   3.5646115788448267`*^9, {3.56461160887488*^9, 3.5646116752529964`*^9}, 
   3.564612287255273*^9, {3.5646123245861382`*^9, 3.5646124002774715`*^9}}]
}, Open  ]],

Cell[BoxData[
 Graphics3DBox[{
   {Opacity[1], EdgeForm[{GrayLevel[0], Thickness[0.003]}], 
    GraphicsComplex3DBox[
     NCache[{{0, 0, (-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2]}, {
       0, 0, 5 (50 - 10 5^Rational[1, 2])^
         Rational[-1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
        0, -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(2/(5 - 5^
         Rational[1, 2]))^Rational[1, 2], 0, (10 - 2 5^Rational[1, 2])^
        Rational[-1, 2]}, {(
         Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
         5^Rational[1, 2]), 
        Rational[-1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
         Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
         5^Rational[1, 2]), Rational[
        1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
         Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
         5^Rational[1, 2]), Rational[-1, 2], (10 - 2 5^Rational[1, 2])^
        Rational[-1, 2]}, {(
         Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (1 + 
         5^Rational[1, 2]), Rational[1, 2], (10 - 2 5^Rational[1, 2])^
        Rational[-1, 2]}, {(
         Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
         5^Rational[1, 2]), 
        Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
         Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
         Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
         5^Rational[1, 2]), 
        Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
         Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(
         Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
         5^Rational[1, 2]), 
        Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
         Rational[1, 2], (10 - 2 5^Rational[1, 2])^
        Rational[-1, 2]}, {(
         Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2]) (-1 + 
         5^Rational[1, 2]), 
        Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
         Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}}, {{
       0, 0, -0.9510565162951536}, {
       0, 0, 0.9510565162951536}, {-0.85065080835204, 
        0, -0.42532540417601994`}, {
       0.85065080835204, 0, 0.42532540417601994`}, {
       0.6881909602355868, -0.5, -0.42532540417601994`}, {0.6881909602355868, 
       0.5, -0.42532540417601994`}, {-0.6881909602355868, -0.5, 
       0.42532540417601994`}, {-0.6881909602355868, 0.5, 
       0.42532540417601994`}, {-0.2628655560595668, -0.8090169943749475, \
-0.42532540417601994`}, {-0.2628655560595668, 
       0.8090169943749475, -0.42532540417601994`}, {
       0.2628655560595668, -0.8090169943749475, 0.42532540417601994`}, {
       0.2628655560595668, 0.8090169943749475, 0.42532540417601994`}}], 
     Polygon3DBox[{{2, 12, 8}, {2, 8, 7}, {2, 7, 11}, {2, 11, 4}, {2, 4, 
      12}, {5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 3, 1}, {12, 10, 
      8}, {8, 3, 7}, {7, 9, 11}, {11, 5, 4}, {4, 6, 12}, {5, 11, 9}, {6, 4, 
      5}, {10, 12, 6}, {3, 8, 10}, {9, 7, 3}}]]}, 
   {GrayLevel[0.], 
    StyleBox[
     Arrow3DBox[TubeBox[{{0., 0., 0.}, {-0.2678704053083727, 
      0.8244203365140412, 1.1347172460466872`}}, 0.01]],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], 
    StyleBox[
     Arrow3DBox[TubeBox[{{0., 0., 0.}, {-0.8668468407383146, 0., 
      1.1347172460466872`}}, 0.01]],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], 
    StyleBox[
     Arrow3DBox[TubeBox[{{0., 0., 
      0.}, {-0.2678704053083727, -0.8244203365140412, 1.1347172460466872`}}, 
      0.01]],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], 
    StyleBox[
     Arrow3DBox[TubeBox[{{0., 0., 0.}, {0.70129382567753, -0.5095197889823035,
       1.1347172460466872`}}, 0.01]],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], 
    StyleBox[
     Arrow3DBox[TubeBox[{{0., 0., 0.}, {0.70129382567753, 0.5095197889823035, 
      1.1347172460466872`}}, 0.01]],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], 
    StyleBox[
     Arrow3DBox[TubeBox[{{0., 0., 0.}, {
      0.2678704053083727, -0.8244203365140412, -1.1347172460466872`}}, 0.01]],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], 
    StyleBox[
     Arrow3DBox[TubeBox[{{0., 0., 0.}, {0.8668468407383146, 
      0., -1.1347172460466872`}}, 0.01]],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], 
    StyleBox[
     Arrow3DBox[TubeBox[{{0., 0., 0.}, {0.2678704053083727, 
      0.8244203365140412, -1.1347172460466872`}}, 0.01]],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], 
    StyleBox[
     Arrow3DBox[TubeBox[{{0., 0., 0.}, {-0.70129382567753, 
      0.5095197889823035, -1.1347172460466872`}}, 0.01]],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], 
    StyleBox[
     Arrow3DBox[TubeBox[{{0., 0., 
      0.}, {-0.70129382567753, -0.5095197889823035, -1.1347172460466872`}}, 
      0.01]],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], 
    StyleBox[
     Arrow3DBox[TubeBox[{{0., 0., 0.}, {-0.4334234203691573, 
      1.3339401254963448`, 0.2678704053083727}}, 0.01]],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], 
    StyleBox[
     Arrow3DBox[TubeBox[{{0., 0., 0.}, {-1.40258765135506, 0., 
      0.2678704053083727}}, 0.01]],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], 
    StyleBox[
     Arrow3DBox[TubeBox[{{0., 0., 
      0.}, {-0.4334234203691574, -1.3339401254963448`, 0.2678704053083727}}, 
      0.01]],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], 
    StyleBox[
     Arrow3DBox[TubeBox[{{0., 0., 0.}, {
      1.1347172460466872`, -0.8244203365140412, 0.2678704053083727}}, 0.01]],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], 
    StyleBox[
     Arrow3DBox[TubeBox[{{0., 0., 0.}, {1.1347172460466872`, 
      0.8244203365140412, 0.2678704053083727}}, 0.01]],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], 
    StyleBox[
     Arrow3DBox[TubeBox[{{0., 0., 0.}, {
      0.4334234203691574, -1.3339401254963448`, -0.2678704053083727}}, 0.01]],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], 
    StyleBox[
     Arrow3DBox[TubeBox[{{0., 0., 0.}, {1.40258765135506, 
      0., -0.2678704053083727}}, 0.01]],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], 
    StyleBox[
     Arrow3DBox[TubeBox[{{0., 0., 0.}, {0.4334234203691573, 
      1.3339401254963448`, -0.2678704053083727}}, 0.01]],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], 
    StyleBox[
     Arrow3DBox[TubeBox[{{0., 0., 0.}, {-1.1347172460466872`, 
      0.8244203365140412, -0.2678704053083727}}, 0.01]],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], 
    StyleBox[
     Arrow3DBox[TubeBox[{{0., 0., 
      0.}, {-1.1347172460466872`, -0.8244203365140412, -0.2678704053083727}}, 
      0.01]],
     FontColor->GrayLevel[0.]]}},
  AutomaticImageSize->True,
  Boxed->False,
  ImageSize->{430.3032939791778, 419.6227840633543},
  Lighting->"Neutral",
  ViewAngle->0.3083339400965742,
  ViewPoint->{0.974453347738665, -0.3893908477388297, 3.2169574819661753`},
  ViewVertical->{-0.14450050319390187`, -0.6192784488285703, 
   0.7717602007056267}]], "Output",
 CellChangeTimes->{{3.564611051379501*^9, 3.5646110835311575`*^9}, {
   3.5646114806426544`*^9, 3.564611521904727*^9}, {3.5646115789228272`*^9, 
   3.5646116752841964`*^9}, 3.564612287270873*^9, {3.564612324617338*^9, 
   3.5646124002930713`*^9}}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.564611009368627*^9, 3.5646110193370447`*^9}}]
}, Open  ]]
},
WindowSize->{1001, 630},
WindowMargins->{{Automatic, 53}, {Automatic, 35}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 673, 13, 135, "Subtitle"],
Cell[1255, 37, 296, 8, 86, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1576, 49, 6019, 154, 612, "Input"],
Cell[CellGroupData[{
Cell[7620, 207, 624, 11, 23, "Print"],
Cell[8247, 220, 1993, 51, 305, "Print"],
Cell[10243, 273, 2998, 64, 185, "Print"],
Cell[13244, 339, 3679, 82, 305, "Print"]
}, Open  ]],
Cell[16938, 424, 7454, 170, 435, "Output"]
}, Open  ]],
Cell[24407, 597, 94, 1, 31, "Input"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
