(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     43342,       1069]
NotebookOptionsPosition[     41498,       1009]
NotebookOutlinePosition[     41842,       1024]
CellTagsIndexPosition[     41799,       1021]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 "\n"
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
  3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
  3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
  3.5842134956497355`*^9, 3.5842135862546945`*^9}},
 FontFamily->"Arial"],

Cell[TextData[{
 "\n",
 StyleBox["Householder method",
  FontWeight->"Bold"],
 "\nSolve a linear system with the Householder method.\nCompute the \
Householder matrix one column at a time to better understand the method.\n\
After calling the Householder routine for columns 1 .. n-1, the solution to \
the linear system is found by calling the back substitution routine.\nSee \
Section 13.1 Alternative System Solvers/The Houesholder Method"
}], "Subsubtitle",
 CellChangeTimes->{{3.558563782892237*^9, 3.5585638032346725`*^9}, {
   3.58429613357994*^9, 3.58429613389994*^9}, 3.5842961668999863`*^9, {
   3.584296468280408*^9, 3.5842965030364633`*^9}, {3.584296573672567*^9, 
   3.5842966247826385`*^9}, {3.584296698222741*^9, 3.5842967004527445`*^9}}],

Cell["\<\

The transpose matrix is used to easily access the ith column.\
\>", "Text",
 CellChangeTimes->{{3.558620898426564*^9, 3.558620932824624*^9}, {
   3.558620968330287*^9, 3.5586210739736724`*^9}, 3.5842961310899363`*^9}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Tolerance", " ", "for", " ", "zero"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"zeroeps", " ", "=", " ", "0.0000005"}], ";"}]}]], "Input",
 CellChangeTimes->{{3.558616075756257*^9, 3.5586161753780317`*^9}, {
   3.5586162088868904`*^9, 3.5586164670671806`*^9}, {3.558616550496127*^9, 
   3.5586167106616087`*^9}, {3.5586167677577085`*^9, 
   3.5586172251349125`*^9}, {3.5586172703749914`*^9, 3.55861730355625*^9}, {
   3.558617717549777*^9, 3.5586177200145817`*^9}, {3.5586180120626945`*^9, 
   3.558618017959505*^9}, {3.5586185152571783`*^9, 3.5586185331972094`*^9}, {
   3.558618672879855*^9, 3.5586187828756485`*^9}, {3.5586191916431665`*^9, 
   3.5586193795766964`*^9}, {3.558619418732765*^9, 3.5586194332875905`*^9}, {
   3.558619466500049*^9, 3.55861964356036*^9}, 3.5586198573275356`*^9, {
   3.558619896000003*^9, 3.5586199495548973`*^9}, {3.5586201602176676`*^9, 
   3.5586201658804774`*^9}, {3.5586202002629375`*^9, 3.558620270977862*^9}, {
   3.558620333502772*^9, 3.558620341739586*^9}, {3.558620385934464*^9, 
   3.5586204434205647`*^9}, {3.5586204795346284`*^9, 
   3.5586204803926296`*^9}, {3.5586206429449153`*^9, 3.558620664457353*^9}, {
   3.5586206958602085`*^9, 3.5586207496491027`*^9}, {3.558620865962907*^9, 
   3.558620872920519*^9}, {3.558629886063923*^9, 3.558629914050372*^9}, {
   3.55862994720043*^9, 3.558629981801291*^9}, {3.5586300487098083`*^9, 
   3.558630061938632*^9}, {3.5586315091375737`*^9, 3.558631524862401*^9}, 
   3.5842962278100715`*^9, {3.5842962710901318`*^9, 3.584296279370144*^9}}],

Cell[CellGroupData[{

Cell["\<\

Routine for construction of one column of the Householder matrix\
\>", "Section",
 CellChangeTimes->{{3.5842962336300793`*^9, 3.5842962611401176`*^9}, {
  3.584296323920206*^9, 3.584296329230213*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Global", " ", 
     RowBox[{"input", ":", " ", "mat"}]}], ",", " ", "rhs", ",", " ", 
    "syssize"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Global", " ", 
     RowBox[{"output", ":", " ", "mat"}]}], ",", " ", "HH", ",", " ", 
    "normalmatrix"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"constructHi", "[", "icol_", "]"}], " ", ":=", " ", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
     "Construct", " ", "transpose", " ", "for", " ", "easy", " ", "access", 
      " ", "to", " ", "column", " ", "vectors"}], " ", "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"matT", " ", "=", " ", 
      RowBox[{"Transpose", "[", "mat", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"Print", "[", 
        RowBox[{"\"\<Length of icol before H = \>\"", ",", 
         RowBox[{
          RowBox[{"Norm", "[", 
           RowBox[{"{", 
            RowBox[{"matT", "[", 
             RowBox[{"[", "icol", "]"}], "]"}], "}"}], "]"}], "//", "N"}]}], 
        "]"}], ";"}], " ", "*)"}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Form", " ", "icol", " ", "column", " ", "vector", " ", "with", " ", 
       "zeros", " ", "before", " ", "icol", " ", "element"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"column", " ", "=", " ", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"i", "<", "icol"}], ",", "0", ",", 
          RowBox[{"matT", "[", 
           RowBox[{"[", 
            RowBox[{"icol", ",", "i"}], "]"}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "syssize"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Find", " ", "resulting", " ", "column", " ", "length", " ", "with", 
       " ", 
       RowBox[{"plus", "/", "minus"}], " ", "sign"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"mat", "[", 
          RowBox[{"[", 
           RowBox[{"icol", ",", "icol"}], "]"}], "]"}], " ", "]"}], "<", " ", 
        "zeroeps"}], ",", " ", 
       RowBox[{"diagsign", " ", "=", " ", 
        RowBox[{"-", "1"}]}], ",", 
       RowBox[{"diagsign", " ", "=", " ", 
        RowBox[{"-", 
         RowBox[{"Sign", "[", 
          RowBox[{"mat", "[", 
           RowBox[{"[", 
            RowBox[{"icol", ",", "icol"}], "]"}], "]"}], "]"}]}]}]}], "]"}], 
     ";", " ", "\[IndentingNewLine]", 
     RowBox[{"gamma", " ", "=", " ", 
      RowBox[{"diagsign", "*", 
       RowBox[{"Norm", "[", "column", "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"Form", " ", "the", " ", "e_icol", " ", "vectors"}], ";", " ", 
       RowBox[{
       "column", " ", "will", " ", "be", " ", "mapped", " ", "to", " ", 
        "this", " ", "vector"}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"evec", " ", "=", " ", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"i", " ", "\[Equal]", " ", "icol"}], ",", "1", ",", "0"}], 
         "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "syssize"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Form", " ", "normal", " ", "to", " ", "plane", " ", "about", " ", 
       "which", " ", "we", " ", "reflect"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"normal", "=", 
      RowBox[{"column", " ", "-", " ", 
       RowBox[{"gamma", "*", "evec"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"lgth", " ", "=", " ", 
      RowBox[{"Norm", "[", "normal", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"normal", " ", "=", " ", 
      RowBox[{"normal", "/", "lgth"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Form", " ", "dyadic", " ", "matrix", " ", "from", " ", "normal", " ", 
       "vector"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"normalmatrix", "=", " ", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"normal", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "*", 
         RowBox[{"normal", "[", 
          RowBox[{"[", "j", "]"}], "]"}]}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "syssize"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "1", ",", "syssize"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Form", " ", "Householder", " ", "transformation", " ", "targeted", " ",
        "for", " ", "icol", " ", "column"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"HHicol", " ", "=", " ", 
      RowBox[{
       RowBox[{"IdentityMatrix", "[", "syssize", "]"}], " ", "-", " ", 
       RowBox[{"2", "*", "normalmatrix"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
       "Apply", " ", "Householder", " ", "to", " ", "matrix", " ", "and", " ",
         "right"}], "-", 
       RowBox[{"hand", " ", "side"}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"mat", " ", "=", " ", 
      RowBox[{"HHicol", ".", "mat"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"rhs", " ", "=", " ", 
      RowBox[{"HHicol", ".", "rhs"}]}], ";"}], "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"dum", " ", "=", " ", 
       RowBox[{"Transpose", "[", "mat", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Length of icol before H = \>\"", ",", 
        RowBox[{
         RowBox[{"Norm", "[", 
          RowBox[{"{", 
           RowBox[{"dum", "[", 
            RowBox[{"[", "icol", "]"}], "]"}], "}"}], "]"}], "//", "N"}]}], 
       "]"}], ";"}], " ", "*)"}], "\[IndentingNewLine]", ")"}]}]}]], "Input",
 CellChangeTimes->{{3.558616075756257*^9, 3.5586161753780317`*^9}, {
   3.5586162088868904`*^9, 3.5586164670671806`*^9}, {3.558616550496127*^9, 
   3.5586167106616087`*^9}, {3.5586167677577085`*^9, 
   3.5586172251349125`*^9}, {3.5586172703749914`*^9, 3.55861730355625*^9}, {
   3.558617717549777*^9, 3.5586177200145817`*^9}, {3.5586180120626945`*^9, 
   3.558618017959505*^9}, {3.5586185152571783`*^9, 3.5586185331972094`*^9}, {
   3.558618672879855*^9, 3.5586187828756485`*^9}, {3.5586191916431665`*^9, 
   3.5586193795766964`*^9}, {3.558619418732765*^9, 3.5586194332875905`*^9}, {
   3.558619466500049*^9, 3.55861964356036*^9}, 3.5586198573275356`*^9, {
   3.558619896000003*^9, 3.5586199495548973`*^9}, {3.5586201602176676`*^9, 
   3.5586201658804774`*^9}, {3.5586202002629375`*^9, 3.558620270977862*^9}, {
   3.558620333502772*^9, 3.558620341739586*^9}, {3.558620385934464*^9, 
   3.5586204434205647`*^9}, {3.5586204795346284`*^9, 
   3.5586204803926296`*^9}, {3.5586206429449153`*^9, 3.558620664457353*^9}, {
   3.5586206958602085`*^9, 3.5586207496491027`*^9}, {3.558620865962907*^9, 
   3.558620872920519*^9}, {3.558629886063923*^9, 3.558629914050372*^9}, {
   3.55862994720043*^9, 3.558629981801291*^9}, {3.5586300487098083`*^9, 
   3.558630061938632*^9}, {3.5586315091375737`*^9, 3.558631524862401*^9}, {
   3.5842962278100715`*^9, 3.5842962307500753`*^9}, 3.5842962960601673`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Backsubstitution routine", "Section",
 CellChangeTimes->{{3.5842963019201756`*^9, 3.5842963168701963`*^9}}],

Cell[BoxData[
 RowBox[{"backsubstitution", ":=", " ", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"soln", "[", 
      RowBox[{"[", "syssize", "]"}], "]"}], " ", "=", " ", 
     RowBox[{
      RowBox[{"rhs", "[", 
       RowBox[{"[", "syssize", "]"}], "]"}], "/", 
      RowBox[{"mat", "[", 
       RowBox[{"[", 
        RowBox[{"syssize", ",", "syssize"}], "]"}], "]"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"(", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"sum", " ", "=", " ", "0"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"sum", " ", "=", " ", 
            RowBox[{"sum", " ", "+", " ", 
             RowBox[{
              RowBox[{"mat", "[", 
               RowBox[{"[", 
                RowBox[{"j", ",", "i"}], "]"}], "]"}], "*", 
              RowBox[{"soln", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}]}]}], ")"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"j", "+", "1"}], ",", "syssize"}], "}"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"soln", "[", 
          RowBox[{"[", "j", "]"}], "]"}], " ", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"rhs", "[", 
             RowBox[{"[", "j", "]"}], "]"}], " ", "-", " ", "sum"}], ")"}], 
          "/", 
          RowBox[{"mat", "[", 
           RowBox[{"[", 
            RowBox[{"j", ",", "j"}], "]"}], "]"}]}]}], ";"}], 
       "\[IndentingNewLine]", ")"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", 
        RowBox[{"syssize", "-", "1"}], ",", "1", ",", " ", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   ")"}]}]], "Input",
 CellChangeTimes->{{3.558616075756257*^9, 3.5586161753780317`*^9}, {
   3.5586162088868904`*^9, 3.5586164670671806`*^9}, {3.558616550496127*^9, 
   3.5586167106616087`*^9}, {3.5586167677577085`*^9, 
   3.5586172251349125`*^9}, {3.5586172703749914`*^9, 3.55861730355625*^9}, {
   3.558617717549777*^9, 3.5586177200145817`*^9}, {3.5586180120626945`*^9, 
   3.558618017959505*^9}, {3.5586185152571783`*^9, 3.5586185331972094`*^9}, {
   3.558618672879855*^9, 3.5586187828756485`*^9}, {3.5586191916431665`*^9, 
   3.5586193795766964`*^9}, {3.558619418732765*^9, 3.5586194332875905`*^9}, {
   3.558619466500049*^9, 3.55861964356036*^9}, 3.5586198573275356`*^9, {
   3.558619896000003*^9, 3.5586199495548973`*^9}, {3.5586201602176676`*^9, 
   3.5586201658804774`*^9}, {3.5586202002629375`*^9, 3.558620270977862*^9}, {
   3.558620333502772*^9, 3.558620341739586*^9}, {3.558620385934464*^9, 
   3.5586204434205647`*^9}, {3.5586204795346284`*^9, 
   3.5586204803926296`*^9}, {3.5586206429449153`*^9, 3.558620664457353*^9}, {
   3.5586206958602085`*^9, 3.5586207496491027`*^9}, {3.558620865962907*^9, 
   3.558620872920519*^9}, {3.558629886063923*^9, 3.558629914050372*^9}, {
   3.55862994720043*^9, 3.558629981801291*^9}, {3.5586300487098083`*^9, 
   3.558630061938632*^9}, {3.5586315091375737`*^9, 3.558631524862401*^9}, {
   3.5842962278100715`*^9, 3.5842962307500753`*^9}, 3.5842962960601673`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

Play with 3 x3 matrix\
\>", "Section",
 CellChangeTimes->{{3.558563980809785*^9, 3.5585640011210203`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"syssize", " ", "=", " ", "3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Example", " ", "14.2"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"mat", " ", "=", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "2", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1", ",", "1"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"rhs", " ", "=", " ", 
      RowBox[{"{", 
       RowBox[{"6", ",", "9", ",", "7"}], "}"}]}], ";"}], 
    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Example", " ", "16.1"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"mat", " ", "=", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"rhs", " ", "=", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]}], ";"}], 
    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "5", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rhs", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"soln", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";"}], " ", 
   RowBox[{"(*", " ", "Initialize", " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"savemat", " ", "=", " ", "mat"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"saverhs", "=", " ", "rhs"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<Input: \>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<matrix = \>\"", ",", 
     RowBox[{"MatrixForm", "[", "mat", "]"}], ",", "\"\<    Transpose = \>\"",
      ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"Transpose", "[", "mat", "]"}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Determinant(mat) = \>\"", ",", 
      RowBox[{"Det", "[", "mat", "]"}]}], "]"}], ";"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"(", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Print", "[", "\"\< \>\"", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{
        "Print", "[", 
         "\"\<--------------------------------------------- \>\"", "]"}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"Print", "[", "\"\< \>\"", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{
         "\"\<Create Householder for column \>\"", ",", "icol", ",", 
          "\"\<  and apply\>\""}], "]"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"constructHi", "[", "icol", "]"}], ";", "\[IndentingNewLine]",
         "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "Print", " ", "some", " ", "intermediate", " ", "results", " ", "to",
           " ", "check"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<column =\>\"", ",", 
          RowBox[{"column", "//", "N"}], ",", "\"\<  gamma=\>\"", ",", 
          RowBox[{"gamma", "//", "N"}], ",", "\"\<  normal = \>\"", ",", 
          RowBox[{"normal", "//", "N"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<normal matrix = \>\"", ",", 
          RowBox[{
           RowBox[{"MatrixForm", "[", "normalmatrix", "]"}], "//", "N"}], 
          ",", "\"\<  (must be symmetric and rank deficient)\>\""}], "]"}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<HHicol = \>\"", ",", 
          RowBox[{
           RowBox[{"MatrixForm", "[", "HHicol", "]"}], "//", "N"}], ",", 
          "\"\<  (must be symmetric and orthogonal)\>\""}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Det(HHicol) = \>\"", ",", 
          RowBox[{
           RowBox[{"Det", "[", "HHicol", "]"}], "//", "N"}], ",", 
          "\"\<  (must be +/- 1)\>\""}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<mat = \>\"", ",", 
          RowBox[{
           RowBox[{"MatrixForm", "[", "mat", "]"}], "//", "N"}]}], "]"}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Det(mat) = \>\"", ",", 
          RowBox[{
           RowBox[{"Det", "[", "mat", "]"}], "//", "N"}], ",", 
          "\"\<  (must not change)\>\""}], "]"}], ";"}], 
       "\[IndentingNewLine]", ")"}], ",", 
      RowBox[{"{", 
       RowBox[{"icol", ",", "1", ",", 
        RowBox[{"syssize", "-", "1"}]}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"backsubstitution", ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<soln = \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "soln", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"test", " ", "=", " ", 
     RowBox[{
      RowBox[{"savemat", ".", "soln"}], "//", "N"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Check soln correct mat.soln=\>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "test", "]"}], "//", "N"}], ",", 
      "\"\< =? rhs =\>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "saverhs", "]"}], "//", "N"}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.558563683695262*^9, 3.558563770911416*^9}, {
   3.558563855603965*^9, 3.558563958049345*^9}, {3.558564008733834*^9, 
   3.5585640365174828`*^9}, {3.558564067733137*^9, 3.558564178415332*^9}, {
   3.5585642915623302`*^9, 3.558564323635987*^9}, {3.5585644001853213`*^9, 
   3.558564426674168*^9}, {3.5585646272593203`*^9, 3.55856471259147*^9}, {
   3.5585648706353474`*^9, 3.5585650217060127`*^9}, {3.5585650810173173`*^9, 
   3.5585651670514684`*^9}, {3.558565576427387*^9, 3.558565840785452*^9}, 
   3.5585659592052593`*^9, {3.5585661993832817`*^9, 3.5585663226078978`*^9}, {
   3.558566530447063*^9, 3.5585665336762686`*^9}, {3.5585666292420363`*^9, 
   3.5585668449904156`*^9}, {3.558566880137277*^9, 3.558566890386495*^9}, {
   3.5585758164157095`*^9, 3.5585758932302437`*^9}, {3.5585759299683084`*^9, 
   3.558575932932314*^9}, {3.5585759689839773`*^9, 3.5585760054412413`*^9}, {
   3.5585760648461456`*^9, 3.558576120460243*^9}, {3.5585761570891075`*^9, 
   3.558576173827937*^9}, {3.558576240549254*^9, 3.558576346941041*^9}, {
   3.5585763824779034`*^9, 3.558576394240324*^9}, 3.558576429714786*^9, {
   3.558576622749525*^9, 3.5585766228899255`*^9}, 3.558576761340169*^9, {
   3.5586155489277315`*^9, 3.558615663853133*^9}, {3.5586158916759334`*^9, 
   3.5586160453674035`*^9}, {3.5586167220808287`*^9, 3.558616735481252*^9}, {
   3.5586172482697525`*^9, 3.5586172608433747`*^9}, {3.5586173431023197`*^9, 
   3.558617494297785*^9}, {3.558617530895449*^9, 3.5586176829177165`*^9}, {
   3.558617740310217*^9, 3.5586177437266235`*^9}, {3.558617775082678*^9, 
   3.5586178622400312`*^9}, {3.5586179124253197`*^9, 3.558617983967045*^9}, {
   3.5586180495651603`*^9, 3.558618057193574*^9}, {3.558618544351229*^9, 
   3.5586185562696505`*^9}, {3.558618609543744*^9, 3.5586186151441536`*^9}, {
   3.558618799832878*^9, 3.558618800347679*^9}, {3.558618855025775*^9, 
   3.5586188696898007`*^9}, {3.5586189008742557`*^9, 3.5586189264895*^9}, {
   3.558618975145986*^9, 3.558619040619301*^9}, {3.5586190800405703`*^9, 
   3.5586191267626524`*^9}, {3.558619662576793*^9, 3.5586198208390713`*^9}, {
   3.5586198645035477`*^9, 3.558619919228444*^9}, {3.5586203664344296`*^9, 
   3.558620371629239*^9}, {3.558620507957878*^9, 3.5586205996548395`*^9}, 
   3.5586207688839364`*^9, {3.558621096609312*^9, 3.5586211019289217`*^9}, {
   3.5586211919878798`*^9, 3.55862122069193*^9}, {3.5586213132312927`*^9, 
   3.5586213410773416`*^9}, {3.5586214302782984`*^9, 3.5586214869375973`*^9}, 
   3.5586294788252077`*^9, {3.5586295405857162`*^9, 3.5586295726905727`*^9}, {
   3.5586298232114124`*^9, 3.5586298755027046`*^9}, 3.558632433602168*^9, {
   3.568472901682604*^9, 3.5684729243806434`*^9}, {3.5684731863987036`*^9, 
   3.568473324443346*^9}, {3.5684735624529643`*^9, 3.568473566633772*^9}, {
   3.568473688829187*^9, 3.568473689094387*^9}, {3.5842963671402664`*^9, 
   3.584296367370267*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Input: \"\>"], "Print",
 CellChangeTimes->{3.568473695599599*^9, 3.5842963822502875`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "5", "4"},
       {"1", 
        RowBox[{"-", "1"}], "2"},
       {"0", "3", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   "\[InvisibleSpace]", "\<\"    Transpose = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "1", "0"},
       {"5", 
        RowBox[{"-", "1"}], "3"},
       {"4", "2", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["matrix = ", 
   MatrixForm[{{1, 5, 4}, {1, -1, 2}, {0, 3, 0}}], "    Transpose = ", 
   MatrixForm[{{1, 1, 0}, {5, -1, 3}, {4, 2, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.568473695599599*^9, 3.5842963822502875`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Determinant(mat) = \"\>", "\[InvisibleSpace]", "6"}],
  SequenceForm["Determinant(mat) = ", 6],
  Editable->False]], "Print",
 CellChangeTimes->{3.568473695599599*^9, 3.5842963822602873`*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.568473695599599*^9, 3.5842963822602873`*^9}],

Cell[BoxData["\<\"--------------------------------------------- \"\>"], \
"Print",
 CellChangeTimes->{3.568473695599599*^9, 3.5842963822602873`*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.568473695599599*^9, 3.5842963822602873`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Create Householder for column \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"  and apply\"\>"}],
  SequenceForm["Create Householder for column ", 1, "  and apply"],
  Editable->False]], "Print",
 CellChangeTimes->{3.568473695599599*^9, 3.5842963822602873`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"column =\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "1.`", ",", "0.`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"  gamma=\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.4142135623730951`"}], 
   "\[InvisibleSpace]", "\<\"  normal = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0.9238795325112867`", ",", "0.3826834323650898`", ",", "0.`"}], 
    "}"}]}],
  SequenceForm[
  "column =", {1., 1., 0.}, "  gamma=", -1.4142135623730951`, "  normal = ", {
   0.9238795325112867, 0.3826834323650898, 0.}],
  Editable->False]], "Print",
 CellChangeTimes->{3.568473695599599*^9, 3.5842963822702875`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"normal matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.8535533905932737`", "0.35355339059327373`", "0.`"},
       {"0.35355339059327373`", "0.14644660940672624`", "0.`"},
       {"0.`", "0.`", "0.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   "\[InvisibleSpace]", "\<\"  (must be symmetric and rank deficient)\"\>"}],
  SequenceForm["normal matrix = ", 
   MatrixForm[{{0.8535533905932737, 0.35355339059327373`, 0.}, {
    0.35355339059327373`, 0.14644660940672624`, 0.}, {0., 0., 0.}}], 
   "  (must be symmetric and rank deficient)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.568473695599599*^9, 3.5842963822702875`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"HHicol = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "0.7071067811865475`"}], 
        RowBox[{"-", "0.7071067811865475`"}], "0.`"},
       {
        RowBox[{"-", "0.7071067811865475`"}], "0.7071067811865475`", "0.`"},
       {"0.`", "0.`", "1.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   "\[InvisibleSpace]", "\<\"  (must be symmetric and orthogonal)\"\>"}],
  SequenceForm["HHicol = ", 
   MatrixForm[{{-0.7071067811865475, -0.7071067811865475, 
    0.}, {-0.7071067811865475, 0.7071067811865475, 0.}, {0., 0., 1.}}], 
   "  (must be symmetric and orthogonal)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.568473695599599*^9, 3.5842963822702875`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Det(HHicol) = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.`"}], "\[InvisibleSpace]", "\<\"  (must be +/- 1)\"\>"}],
  SequenceForm["Det(HHicol) = ", -1., "  (must be +/- 1)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.568473695599599*^9, 3.584296382600288*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"mat = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "1.414213562373095`"}], 
        RowBox[{"-", "2.82842712474619`"}], 
        RowBox[{"-", "4.242640687119285`"}]},
       {"0.`", 
        RowBox[{"-", "4.242640687119286`"}], 
        RowBox[{"-", "1.414213562373095`"}]},
       {"0.`", "3.`", "0.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["mat = ", 
   MatrixForm[{{-1.414213562373095, -2.82842712474619, -4.242640687119285}, {
    0., -4.242640687119286, -1.414213562373095}, {0., 3., 0.}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.568473695599599*^9, 3.5842963826102877`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Det(mat) = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "6.000000000000001`"}], 
   "\[InvisibleSpace]", "\<\"  (must not change)\"\>"}],
  SequenceForm["Det(mat) = ", -6.000000000000001, "  (must not change)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.568473695599599*^9, 3.5842963826102877`*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.568473695599599*^9, 3.5842963826102877`*^9}],

Cell[BoxData["\<\"--------------------------------------------- \"\>"], \
"Print",
 CellChangeTimes->{3.568473695599599*^9, 3.584296382620288*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.568473695599599*^9, 3.584296382620288*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Create Householder for column \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"  and apply\"\>"}],
  SequenceForm["Create Householder for column ", 2, "  and apply"],
  Editable->False]], "Print",
 CellChangeTimes->{3.568473695599599*^9, 3.584296382620288*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"column =\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "4.242640687119286`"}], ",", "3.`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"  gamma=\"\>", "\[InvisibleSpace]", 
   "5.196152422706632`", "\[InvisibleSpace]", "\<\"  normal = \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "0.9530206138714226`"}], ",", "0.30290544652768625`"}], 
    "}"}]}],
  SequenceForm[
  "column =", {0., -4.242640687119286, 3.}, "  gamma=", 5.196152422706632, 
   "  normal = ", {0., -0.9530206138714226, 0.30290544652768625`}],
  Editable->False]], "Print",
 CellChangeTimes->{3.568473695599599*^9, 3.584296382630288*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"normal matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.`", "0.`", "0.`"},
       {"0.`", "0.908248290463863`", 
        RowBox[{"-", "0.28867513459481287`"}]},
       {"0.`", 
        RowBox[{"-", "0.28867513459481287`"}], "0.09175170953613697`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   "\[InvisibleSpace]", "\<\"  (must be symmetric and rank deficient)\"\>"}],
  SequenceForm["normal matrix = ", 
   MatrixForm[{{0., 0., 0.}, {0., 0.908248290463863, -0.28867513459481287`}, {
    0., -0.28867513459481287`, 0.09175170953613697}}], 
   "  (must be symmetric and rank deficient)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.568473695599599*^9, 3.584296382630288*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"HHicol = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.`", "0.`", "0.`"},
       {"0.`", 
        RowBox[{"-", "0.816496580927726`"}], "0.5773502691896257`"},
       {"0.`", "0.5773502691896257`", "0.816496580927726`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   "\[InvisibleSpace]", "\<\"  (must be symmetric and orthogonal)\"\>"}],
  SequenceForm["HHicol = ", 
   MatrixForm[{{1., 0., 0.}, {0., -0.816496580927726, 0.5773502691896257}, {
    0., 0.5773502691896257, 0.816496580927726}}], 
   "  (must be symmetric and orthogonal)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.568473695599599*^9, 3.584296382630288*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Det(HHicol) = \"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "0.9999999999999999`"}], 
   "\[InvisibleSpace]", "\<\"  (must be +/- 1)\"\>"}],
  SequenceForm["Det(HHicol) = ", -0.9999999999999999, "  (must be +/- 1)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.568473695599599*^9, 3.5842963826402884`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"mat = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "1.414213562373095`"}], 
        RowBox[{"-", "2.82842712474619`"}], 
        RowBox[{"-", "4.242640687119285`"}]},
       {"0.`", "5.196152422706632`", "1.1547005383792515`"},
       {"0.`", 
        RowBox[{"-", "4.440892098500626`*^-16"}], 
        RowBox[{"-", "0.8164965809277259`"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["mat = ", 
   MatrixForm[{{-1.414213562373095, -2.82842712474619, -4.242640687119285}, {
    0., 5.196152422706632, 1.1547005383792515`}, {
    0., -4.440892098500626*^-16, -0.8164965809277259}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.568473695599599*^9, 3.5842963826402884`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Det(mat) = \"\>", "\[InvisibleSpace]", "5.999999999999997`", 
   "\[InvisibleSpace]", "\<\"  (must not change)\"\>"}],
  SequenceForm["Det(mat) = ", 5.999999999999997, "  (must not change)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.568473695599599*^9, 3.584296382670288*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"soln = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"3.3333333333333335`"},
        {"0.3333333333333333`"},
        {
         RowBox[{"-", "1.5`"}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["soln = ", 
   MatrixForm[{3.3333333333333335`, 0.3333333333333333, -1.5}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.568473695599599*^9, 3.584296382670288*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Check soln correct mat.soln=\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         RowBox[{"-", "0.9999999999999996`"}]},
        {"0.`"},
        {"0.9999999999999999`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\" =? rhs =\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         RowBox[{"-", "1.`"}]},
        {"0.`"},
        {"1.`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Check soln correct mat.soln=", 
   MatrixForm[{-0.9999999999999996, 0., 0.9999999999999999}], " =? rhs =", 
   MatrixForm[{-1., 0., 1.}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.568473695599599*^9, 3.5842963826802883`*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.558563815215494*^9, 3.558563833592326*^9}, {
  3.5585639392669115`*^9, 3.5585639402809134`*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1006, 630},
WindowMargins->{{Automatic, 38}, {Automatic, 45}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 673, 13, 135, "Subtitle"],
Cell[1255, 37, 752, 13, 124, "Subsubtitle"],
Cell[2010, 52, 228, 5, 45, "Text"],
Cell[2241, 59, 1653, 25, 92, "Input"],
Cell[CellGroupData[{
Cell[3919, 88, 211, 5, 97, "Section"],
Cell[4133, 95, 7509, 171, 592, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11679, 271, 113, 1, 71, "Section"],
Cell[11795, 274, 3227, 70, 172, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15059, 349, 117, 4, 97, "Section"],
Cell[CellGroupData[{
Cell[15201, 357, 9634, 208, 1052, "Input"],
Cell[CellGroupData[{
Cell[24860, 569, 107, 1, 23, "Print"],
Cell[24970, 572, 1718, 46, 50, "Print"],
Cell[26691, 620, 240, 5, 23, "Print"],
Cell[26934, 627, 101, 1, 23, "Print"],
Cell[27038, 630, 148, 2, 23, "Print"],
Cell[27189, 634, 101, 1, 23, "Print"],
Cell[27293, 637, 325, 6, 23, "Print"],
Cell[27621, 645, 680, 15, 23, "Print"],
Cell[28304, 662, 1201, 27, 50, "Print"],
Cell[29508, 691, 1245, 30, 50, "Print"],
Cell[30756, 723, 322, 6, 23, "Print"],
Cell[31081, 731, 1192, 30, 50, "Print"],
Cell[32276, 763, 356, 7, 23, "Print"],
Cell[32635, 772, 101, 1, 23, "Print"],
Cell[32739, 775, 146, 2, 23, "Print"],
Cell[32888, 779, 99, 1, 23, "Print"],
Cell[32990, 782, 323, 6, 23, "Print"],
Cell[33316, 790, 736, 17, 23, "Print"],
Cell[34055, 809, 1246, 29, 50, "Print"],
Cell[35304, 840, 1189, 28, 50, "Print"],
Cell[36496, 870, 360, 7, 23, "Print"],
Cell[36859, 879, 1272, 31, 53, "Print"],
Cell[38134, 912, 334, 6, 23, "Print"],
Cell[38471, 920, 992, 27, 50, "Print"],
Cell[39466, 949, 1832, 50, 50, "Print"]
}, Open  ]]
}, Open  ]],
Cell[41325, 1003, 145, 2, 31, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
