(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     64409,       1445]
NotebookOptionsPosition[     62735,       1390]
NotebookOutlinePosition[     63078,       1405]
CellTagsIndexPosition[     63035,       1402]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 "\n"
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
  3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
  3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
  3.5842134956497355`*^9, 3.5842135862546945`*^9}},
 FontFamily->"Arial"],

Cell[TextData[{
 "\n",
 StyleBox["Householder method and least squares",
  FontWeight->"Bold"],
 "\nSolve a linear system with the Householder method.\nCompute the \
Householder matrix one column at a time to better understand the method.\n\
After calling the Householder routine for columns 1 .. n-1, the solution to \
the linear system is found by calling the back substitution routine.\nSee \
Section 13.1 Alternative System Solvers/The Houesholder Method\n\nThis nb is \
nearly identical to Householder.nb -- this nb works for a  non-square matrix \
so that the least squares solution to an overdetermined system may be found."
}], "Subsubtitle",
 CellChangeTimes->{{3.558563782892237*^9, 3.5585638032346725`*^9}, {
  3.5684736434643073`*^9, 3.568473644525109*^9}, {3.5842968208049154`*^9, 
  3.5842969927451563`*^9}}],

Cell["\<\


The transpose matrix is used to easily access the ith column.\
\>", "Text",
 CellChangeTimes->{{3.558620898426564*^9, 3.558620932824624*^9}, {
  3.558620968330287*^9, 3.5586210739736724`*^9}, {3.568479388338253*^9, 
  3.568479406949086*^9}, {3.5842968182049117`*^9, 3.58429683863494*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Tolerance", " ", "for", " ", "zero"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"zeroeps", " ", "=", " ", "0.0000005"}], ";"}]}]], "Input",
 CellChangeTimes->{{3.558616075756257*^9, 3.5586161753780317`*^9}, {
   3.5586162088868904`*^9, 3.5586164670671806`*^9}, {3.558616550496127*^9, 
   3.5586167106616087`*^9}, {3.5586167677577085`*^9, 
   3.5586172251349125`*^9}, {3.5586172703749914`*^9, 3.55861730355625*^9}, {
   3.558617717549777*^9, 3.5586177200145817`*^9}, {3.5586180120626945`*^9, 
   3.558618017959505*^9}, {3.5586185152571783`*^9, 3.5586185331972094`*^9}, {
   3.558618672879855*^9, 3.5586187828756485`*^9}, {3.5586191916431665`*^9, 
   3.5586193795766964`*^9}, {3.558619418732765*^9, 3.5586194332875905`*^9}, {
   3.558619466500049*^9, 3.55861964356036*^9}, 3.5586198573275356`*^9, {
   3.558619896000003*^9, 3.5586199495548973`*^9}, {3.5586201602176676`*^9, 
   3.5586201658804774`*^9}, {3.5586202002629375`*^9, 3.558620270977862*^9}, {
   3.558620333502772*^9, 3.558620341739586*^9}, {3.558620385934464*^9, 
   3.5586204434205647`*^9}, {3.5586204795346284`*^9, 
   3.5586204803926296`*^9}, {3.5586206429449153`*^9, 3.558620664457353*^9}, {
   3.5586206958602085`*^9, 3.5586207496491027`*^9}, {3.558620865962907*^9, 
   3.558620872920519*^9}, {3.558629886063923*^9, 3.558629914050372*^9}, {
   3.55862994720043*^9, 3.558629981801291*^9}, {3.5586300487098083`*^9, 
   3.558630061938632*^9}, {3.5586315091375737`*^9, 3.558631524862401*^9}, {
   3.5684742452197638`*^9, 3.5684742511165743`*^9}, {3.5684742943442507`*^9, 
   3.568474294859051*^9}, {3.5684743339371195`*^9, 3.5684743816732035`*^9}, {
   3.5684744609057426`*^9, 3.5684745285318613`*^9}, {3.584297010535181*^9, 
   3.584297020695195*^9}}],

Cell[CellGroupData[{

Cell["\<\

Routine for construction of one column of the Householder matrix\
\>", "Section",
 CellChangeTimes->{{3.5842962336300793`*^9, 3.5842962611401176`*^9}, {
  3.584296323920206*^9, 3.584296329230213*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Global", " ", 
     RowBox[{"input", ":", " ", "mat"}]}], ",", " ", "rhs", ",", " ", 
    "rowsize", ",", " ", "colsize"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Global", " ", 
     RowBox[{"output", ":", " ", "mat"}]}], ",", " ", "HH", ",", " ", 
    "normalmatrix"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"constructHi", "[", "icol_", "]"}], " ", ":=", " ", 
   RowBox[{"(", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
     "Construct", " ", "transpose", " ", "for", " ", "easy", " ", "access", 
      " ", "to", " ", "column", " ", "vectors"}], " ", "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"matT", " ", "=", " ", 
      RowBox[{"Transpose", "[", "mat", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"Print", "[", 
        RowBox[{"\"\<Length of icol before H = \>\"", ",", 
         RowBox[{
          RowBox[{"Norm", "[", 
           RowBox[{"{", 
            RowBox[{"matT", "[", 
             RowBox[{"[", "icol", "]"}], "]"}], "}"}], "]"}], "//", "N"}]}], 
        "]"}], ";"}], " ", "*)"}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Form", " ", "icol", " ", "column", " ", "vector", " ", "with", " ", 
       "zeros", " ", "before", " ", "icol", " ", "element"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"column", " ", "=", " ", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"i", "<", "icol"}], ",", "0", ",", 
          RowBox[{"matT", "[", 
           RowBox[{"[", 
            RowBox[{"icol", ",", "i"}], "]"}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "rowsize"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Find", " ", "resulting", " ", "column", " ", "length", " ", "with", 
       " ", 
       RowBox[{"plus", "/", "minus"}], " ", "sign"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"mat", "[", 
          RowBox[{"[", 
           RowBox[{"icol", ",", "icol"}], "]"}], "]"}], " ", "]"}], "<", " ", 
        "zeroeps"}], ",", " ", 
       RowBox[{"diagsign", " ", "=", " ", 
        RowBox[{"-", "1"}]}], ",", 
       RowBox[{"diagsign", " ", "=", " ", 
        RowBox[{"-", 
         RowBox[{"Sign", "[", 
          RowBox[{"mat", "[", 
           RowBox[{"[", 
            RowBox[{"icol", ",", "icol"}], "]"}], "]"}], "]"}]}]}]}], "]"}], 
     ";", " ", "\[IndentingNewLine]", 
     RowBox[{"gamma", " ", "=", " ", 
      RowBox[{"diagsign", "*", 
       RowBox[{"Norm", "[", "column", "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"Form", " ", "the", " ", "e_icol", " ", "vectors"}], ";", " ", 
       RowBox[{
       "column", " ", "will", " ", "be", " ", "mapped", " ", "to", " ", 
        "this", " ", "vector"}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"evec", " ", "=", " ", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"i", " ", "\[Equal]", " ", "icol"}], ",", "1", ",", "0"}], 
         "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "rowsize"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Form", " ", "normal", " ", "to", " ", "plane", " ", "about", " ", 
       "which", " ", "we", " ", "reflect"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"normal", "=", 
      RowBox[{"column", " ", "-", " ", 
       RowBox[{"gamma", "*", "evec"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"lgth", " ", "=", " ", 
      RowBox[{"Norm", "[", "normal", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"normal", " ", "=", " ", 
      RowBox[{"normal", "/", "lgth"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Form", " ", "dyadic", " ", "matrix", " ", "from", " ", "normal", " ", 
       "vector"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"normalmatrix", "=", " ", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"normal", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "*", 
         RowBox[{"normal", "[", 
          RowBox[{"[", "j", "]"}], "]"}]}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "rowsize"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "1", ",", "rowsize"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "Form", " ", "Householder", " ", "transformation", " ", "targeted", " ",
        "for", " ", "icol", " ", "column"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{"HHicol", " ", "=", " ", 
      RowBox[{
       RowBox[{"IdentityMatrix", "[", "rowsize", "]"}], " ", "-", " ", 
       RowBox[{"2", "*", "normalmatrix"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
       "Apply", " ", "Householder", " ", "to", " ", "matrix", " ", "and", " ",
         "right"}], "-", 
       RowBox[{"hand", " ", "side"}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"mat", " ", "=", " ", 
      RowBox[{"HHicol", ".", "mat"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"rhs", " ", "=", " ", 
      RowBox[{"HHicol", ".", "rhs"}]}], ";"}], "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"dum", " ", "=", " ", 
       RowBox[{"Transpose", "[", "mat", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Length of icol before H = \>\"", ",", 
        RowBox[{
         RowBox[{"Norm", "[", 
          RowBox[{"{", 
           RowBox[{"dum", "[", 
            RowBox[{"[", "icol", "]"}], "]"}], "}"}], "]"}], "//", "N"}]}], 
       "]"}], ";"}], " ", "*)"}], "\[IndentingNewLine]", ")"}]}]}]], "Input",
 CellChangeTimes->{{3.558616075756257*^9, 3.5586161753780317`*^9}, {
   3.5586162088868904`*^9, 3.5586164670671806`*^9}, {3.558616550496127*^9, 
   3.5586167106616087`*^9}, {3.5586167677577085`*^9, 
   3.5586172251349125`*^9}, {3.5586172703749914`*^9, 3.55861730355625*^9}, {
   3.558617717549777*^9, 3.5586177200145817`*^9}, {3.5586180120626945`*^9, 
   3.558618017959505*^9}, {3.5586185152571783`*^9, 3.5586185331972094`*^9}, {
   3.558618672879855*^9, 3.5586187828756485`*^9}, {3.5586191916431665`*^9, 
   3.5586193795766964`*^9}, {3.558619418732765*^9, 3.5586194332875905`*^9}, {
   3.558619466500049*^9, 3.55861964356036*^9}, 3.5586198573275356`*^9, {
   3.558619896000003*^9, 3.5586199495548973`*^9}, {3.5586201602176676`*^9, 
   3.5586201658804774`*^9}, {3.5586202002629375`*^9, 3.558620270977862*^9}, {
   3.558620333502772*^9, 3.558620341739586*^9}, {3.558620385934464*^9, 
   3.5586204434205647`*^9}, {3.5586204795346284`*^9, 
   3.5586204803926296`*^9}, {3.5586206429449153`*^9, 3.558620664457353*^9}, {
   3.5586206958602085`*^9, 3.5586207496491027`*^9}, {3.558620865962907*^9, 
   3.558620872920519*^9}, {3.558629886063923*^9, 3.558629914050372*^9}, {
   3.55862994720043*^9, 3.558629981801291*^9}, {3.5586300487098083`*^9, 
   3.558630061938632*^9}, {3.5586315091375737`*^9, 3.558631524862401*^9}, {
   3.5684742452197638`*^9, 3.5684742511165743`*^9}, {3.5684742943442507`*^9, 
   3.568474294859051*^9}, {3.5684743339371195`*^9, 3.5684743816732035`*^9}, {
   3.5684744609057426`*^9, 3.5684745285318613`*^9}, {3.584297010535181*^9, 
   3.584297020695195*^9}, 3.5842970521852393`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Backsubstitution routine", "Section",
 CellChangeTimes->{{3.5842963019201756`*^9, 3.5842963168701963`*^9}}],

Cell[BoxData[
 RowBox[{"backsubstitution", ":=", " ", 
  RowBox[{"(", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"soln", "[", 
      RowBox[{"[", "colsize", "]"}], "]"}], " ", "=", " ", 
     RowBox[{
      RowBox[{"rhs", "[", 
       RowBox[{"[", "colsize", "]"}], "]"}], "/", 
      RowBox[{"mat", "[", 
       RowBox[{"[", 
        RowBox[{"colsize", ",", "colsize"}], "]"}], "]"}]}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"(", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"sum", " ", "=", " ", "0"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"sum", " ", "=", " ", 
            RowBox[{"sum", " ", "+", " ", 
             RowBox[{
              RowBox[{"mat", "[", 
               RowBox[{"[", 
                RowBox[{"j", ",", "i"}], "]"}], "]"}], "*", 
              RowBox[{"soln", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}]}]}], ")"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", 
            RowBox[{"j", "+", "1"}], ",", "colsize"}], "}"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"soln", "[", 
          RowBox[{"[", "j", "]"}], "]"}], " ", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"rhs", "[", 
             RowBox[{"[", "j", "]"}], "]"}], " ", "-", " ", "sum"}], ")"}], 
          "/", 
          RowBox[{"mat", "[", 
           RowBox[{"[", 
            RowBox[{"j", ",", "j"}], "]"}], "]"}]}]}], ";"}], 
       "\[IndentingNewLine]", ")"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", 
        RowBox[{"colsize", "-", "1"}], ",", "1", ",", " ", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   ")"}]}]], "Input",
 CellChangeTimes->{{3.558616075756257*^9, 3.5586161753780317`*^9}, {
   3.5586162088868904`*^9, 3.5586164670671806`*^9}, {3.558616550496127*^9, 
   3.5586167106616087`*^9}, {3.5586167677577085`*^9, 
   3.5586172251349125`*^9}, {3.5586172703749914`*^9, 3.55861730355625*^9}, {
   3.558617717549777*^9, 3.5586177200145817`*^9}, {3.5586180120626945`*^9, 
   3.558618017959505*^9}, {3.5586185152571783`*^9, 3.5586185331972094`*^9}, {
   3.558618672879855*^9, 3.5586187828756485`*^9}, {3.5586191916431665`*^9, 
   3.5586193795766964`*^9}, {3.558619418732765*^9, 3.5586194332875905`*^9}, {
   3.558619466500049*^9, 3.55861964356036*^9}, 3.5586198573275356`*^9, {
   3.558619896000003*^9, 3.5586199495548973`*^9}, {3.5586201602176676`*^9, 
   3.5586201658804774`*^9}, {3.5586202002629375`*^9, 3.558620270977862*^9}, {
   3.558620333502772*^9, 3.558620341739586*^9}, {3.558620385934464*^9, 
   3.5586204434205647`*^9}, {3.5586204795346284`*^9, 
   3.5586204803926296`*^9}, {3.5586206429449153`*^9, 3.558620664457353*^9}, {
   3.5586206958602085`*^9, 3.5586207496491027`*^9}, {3.558620865962907*^9, 
   3.558620872920519*^9}, {3.558629886063923*^9, 3.558629914050372*^9}, {
   3.55862994720043*^9, 3.558629981801291*^9}, {3.5586300487098083`*^9, 
   3.558630061938632*^9}, {3.5586315091375737`*^9, 3.558631524862401*^9}, {
   3.5684742452197638`*^9, 3.5684742511165743`*^9}, {3.5684742943442507`*^9, 
   3.568474294859051*^9}, {3.5684743339371195`*^9, 3.5684743816732035`*^9}, {
   3.5684744609057426`*^9, 3.5684745285318613`*^9}, {3.584297010535181*^9, 
   3.584297020695195*^9}, 3.5842970521852393`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

Input definition\
\>", "Section",
 CellChangeTimes->{{3.558563980809785*^9, 3.5585640011210203`*^9}, {
  3.5684745571111116`*^9, 3.5684745598099165`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rowsize", " ", "=", " ", "3"}], ";", "\[IndentingNewLine]", 
    RowBox[{"colsize", "=", "3"}], ";", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{"Example", " ", "14.2"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"(*", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"mat", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", "2", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1", ",", "1"}], "}"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"rhs", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{"6", ",", "9", ",", "7"}], "}"}]}], ";"}], 
     "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{"Example", " ", "16.1"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"(*", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"mat", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"rhs", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]}], ";"}], 
     "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"mat", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "5", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3", ",", "0"}], "}"}]}], "}"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"rhs", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"soln", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";"}], " ", 
   RowBox[{"(*", " ", "Initialize", " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"rowsize", " ", "=", " ", "7"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"colsize", " ", "=", " ", "2"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"30", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"40", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"50", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"60", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rhs", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
      "30", ",", "25", ",", "40", ",", "40", ",", "30", ",", "5", ",", "25"}],
       "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"soln", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"savemat", " ", "=", " ", "mat"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"saverhs", "=", " ", "rhs"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<Input: \>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<matrix = \>\"", ",", 
     RowBox[{"MatrixForm", "[", "mat", "]"}], ",", "\"\<    Transpose = \>\"",
      ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"Transpose", "[", "mat", "]"}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"(", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Print", "[", "\"\< \>\"", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{
        "Print", "[", 
         "\"\<--------------------------------------------- \>\"", "]"}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"Print", "[", "\"\< \>\"", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{
         "\"\<Create Householder for column \>\"", ",", "icol", ",", 
          "\"\<  and apply\>\""}], "]"}], ";", "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"constructHi", "[", "icol", "]"}], ";", "\[IndentingNewLine]",
         "\[IndentingNewLine]", 
        RowBox[{"(*", " ", 
         RowBox[{
         "Print", " ", "some", " ", "intermediate", " ", "results", " ", "to",
           " ", "check"}], " ", "*)"}], "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<column =\>\"", ",", 
          RowBox[{"column", "//", "N"}], ",", "\"\<  gamma=\>\"", ",", 
          RowBox[{"gamma", "//", "N"}], ",", "\"\<  normal = \>\"", ",", 
          RowBox[{"normal", "//", "N"}]}], "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<normal matrix = \>\"", ",", 
          RowBox[{
           RowBox[{"MatrixForm", "[", "normalmatrix", "]"}], "//", "N"}], 
          ",", "\"\<  (must be symmetric and rank deficient)\>\""}], "]"}], 
        ";", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<HHicol = \>\"", ",", 
          RowBox[{
           RowBox[{"MatrixForm", "[", "HHicol", "]"}], "//", "N"}], ",", 
          "\"\<  (must be symmetric and orthogonal)\>\""}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<mat = \>\"", ",", 
          RowBox[{
           RowBox[{"MatrixForm", "[", "mat", "]"}], "//", "N"}], ",", 
          "\"\<  rhs = \>\"", ",", 
          RowBox[{
           RowBox[{"MatrixForm", "[", "rhs", "]"}], "//", "N"}]}], "]"}], 
        ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", ")"}], ",", 
      RowBox[{"{", 
       RowBox[{"icol", ",", "1", ",", 
        RowBox[{"syssize", "-", "1"}]}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"backsubstitution", ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<soln = \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "soln", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"test", " ", "=", " ", 
     RowBox[{
      RowBox[{"savemat", ".", "soln"}], "//", "N"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Check soln correct mat.soln=\>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "test", "]"}], "//", "N"}], ",", 
      "\"\< =? rhs =\>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "saverhs", "]"}], "//", "N"}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.558563683695262*^9, 3.558563770911416*^9}, {
   3.558563855603965*^9, 3.558563958049345*^9}, {3.558564008733834*^9, 
   3.5585640365174828`*^9}, {3.558564067733137*^9, 3.558564178415332*^9}, {
   3.5585642915623302`*^9, 3.558564323635987*^9}, {3.5585644001853213`*^9, 
   3.558564426674168*^9}, {3.5585646272593203`*^9, 3.55856471259147*^9}, {
   3.5585648706353474`*^9, 3.5585650217060127`*^9}, {3.5585650810173173`*^9, 
   3.5585651670514684`*^9}, {3.558565576427387*^9, 3.558565840785452*^9}, 
   3.5585659592052593`*^9, {3.5585661993832817`*^9, 3.5585663226078978`*^9}, {
   3.558566530447063*^9, 3.5585665336762686`*^9}, {3.5585666292420363`*^9, 
   3.5585668449904156`*^9}, {3.558566880137277*^9, 3.558566890386495*^9}, {
   3.5585758164157095`*^9, 3.5585758932302437`*^9}, {3.5585759299683084`*^9, 
   3.558575932932314*^9}, {3.5585759689839773`*^9, 3.5585760054412413`*^9}, {
   3.5585760648461456`*^9, 3.558576120460243*^9}, {3.5585761570891075`*^9, 
   3.558576173827937*^9}, {3.558576240549254*^9, 3.558576346941041*^9}, {
   3.5585763824779034`*^9, 3.558576394240324*^9}, 3.558576429714786*^9, {
   3.558576622749525*^9, 3.5585766228899255`*^9}, 3.558576761340169*^9, {
   3.5586155489277315`*^9, 3.558615663853133*^9}, {3.5586158916759334`*^9, 
   3.5586160453674035`*^9}, {3.5586167220808287`*^9, 3.558616735481252*^9}, {
   3.5586172482697525`*^9, 3.5586172608433747`*^9}, {3.5586173431023197`*^9, 
   3.558617494297785*^9}, {3.558617530895449*^9, 3.5586176829177165`*^9}, {
   3.558617740310217*^9, 3.5586177437266235`*^9}, {3.558617775082678*^9, 
   3.5586178622400312`*^9}, {3.5586179124253197`*^9, 3.558617983967045*^9}, {
   3.5586180495651603`*^9, 3.558618057193574*^9}, {3.558618544351229*^9, 
   3.5586185562696505`*^9}, {3.558618609543744*^9, 3.5586186151441536`*^9}, {
   3.558618799832878*^9, 3.558618800347679*^9}, {3.558618855025775*^9, 
   3.5586188696898007`*^9}, {3.5586189008742557`*^9, 3.5586189264895*^9}, {
   3.558618975145986*^9, 3.558619040619301*^9}, {3.5586190800405703`*^9, 
   3.5586191267626524`*^9}, {3.558619662576793*^9, 3.5586198208390713`*^9}, {
   3.5586198645035477`*^9, 3.558619919228444*^9}, {3.5586203664344296`*^9, 
   3.558620371629239*^9}, {3.558620507957878*^9, 3.5586205996548395`*^9}, 
   3.5586207688839364`*^9, {3.558621096609312*^9, 3.5586211019289217`*^9}, {
   3.5586211919878798`*^9, 3.55862122069193*^9}, {3.5586213132312927`*^9, 
   3.5586213410773416`*^9}, {3.5586214302782984`*^9, 3.5586214869375973`*^9}, 
   3.5586294788252077`*^9, {3.5586295405857162`*^9, 3.5586295726905727`*^9}, {
   3.5586298232114124`*^9, 3.5586298755027046`*^9}, 3.558632433602168*^9, {
   3.5684736833379774`*^9, 3.5684736837123775`*^9}, {3.568474576252345*^9, 
   3.5684746446116657`*^9}, {3.5684746841265345`*^9, 
   3.5684747077137766`*^9}, {3.568479374563429*^9, 3.5684793805226393`*^9}, {
   3.5684795582381516`*^9, 3.5684795877222033`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Input: \"\>"], "Print",
 CellChangeTimes->{
  3.558620374546444*^9, 3.558620449707376*^9, 3.558620487958643*^9, 
   3.5586206041944475`*^9, 3.5586206757205725`*^9, {3.558620705875426*^9, 
   3.5586207306326694`*^9}, 3.558620772097542*^9, 3.5586208781777287`*^9, 
   3.558621105906928*^9, 3.5586212244827366`*^9, 3.5586213450241485`*^9, 
   3.5586214924756074`*^9, 3.5586294487171545`*^9, 3.55862948589202*^9, 
   3.5586295771365805`*^9, 3.5586299860600986`*^9, 3.558630065011837*^9, 
   3.558632437205775*^9, 3.5684746518344784`*^9, 3.5684747114577827`*^9, {
   3.5684795799065895`*^9, 3.568479591076209*^9}, 3.5842970905752926`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "1"},
       {"10", "1"},
       {"20", "1"},
       {"30", "1"},
       {"40", "1"},
       {"50", "1"},
       {"60", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   "\[InvisibleSpace]", "\<\"    Transpose = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "10", "20", "30", "40", "50", "60"},
       {"1", "1", "1", "1", "1", "1", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["matrix = ", 
   MatrixForm[{{0, 1}, {10, 1}, {20, 1}, {30, 1}, {40, 1}, {50, 1}, {60, 1}}],
    "    Transpose = ", 
   MatrixForm[{{0, 10, 20, 30, 40, 50, 60}, {1, 1, 1, 1, 1, 1, 1}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.558620374546444*^9, 3.558620449707376*^9, 3.558620487958643*^9, 
   3.5586206041944475`*^9, 3.5586206757205725`*^9, {3.558620705875426*^9, 
   3.5586207306326694`*^9}, 3.558620772097542*^9, 3.5586208781777287`*^9, 
   3.558621105906928*^9, 3.5586212244827366`*^9, 3.5586213450241485`*^9, 
   3.5586214924756074`*^9, 3.5586294487171545`*^9, 3.55862948589202*^9, 
   3.5586295771365805`*^9, 3.5586299860600986`*^9, 3.558630065011837*^9, 
   3.558632437205775*^9, 3.5684746518344784`*^9, 3.5684747114577827`*^9, {
   3.5684795799065895`*^9, 3.568479591076209*^9}, 3.5842970905752926`*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.558620374546444*^9, 3.558620449707376*^9, 3.558620487958643*^9, 
   3.5586206041944475`*^9, 3.5586206757205725`*^9, {3.558620705875426*^9, 
   3.5586207306326694`*^9}, 3.558620772097542*^9, 3.5586208781777287`*^9, 
   3.558621105906928*^9, 3.5586212244827366`*^9, 3.5586213450241485`*^9, 
   3.5586214924756074`*^9, 3.5586294487171545`*^9, 3.55862948589202*^9, 
   3.5586295771365805`*^9, 3.5586299860600986`*^9, 3.558630065011837*^9, 
   3.558632437205775*^9, 3.5684746518344784`*^9, 3.5684747114577827`*^9, {
   3.5684795799065895`*^9, 3.568479591076209*^9}, 3.5842970905752926`*^9}],

Cell[BoxData["\<\"--------------------------------------------- \"\>"], \
"Print",
 CellChangeTimes->{
  3.558620374546444*^9, 3.558620449707376*^9, 3.558620487958643*^9, 
   3.5586206041944475`*^9, 3.5586206757205725`*^9, {3.558620705875426*^9, 
   3.5586207306326694`*^9}, 3.558620772097542*^9, 3.5586208781777287`*^9, 
   3.558621105906928*^9, 3.5586212244827366`*^9, 3.5586213450241485`*^9, 
   3.5586214924756074`*^9, 3.5586294487171545`*^9, 3.55862948589202*^9, 
   3.5586295771365805`*^9, 3.5586299860600986`*^9, 3.558630065011837*^9, 
   3.558632437205775*^9, 3.5684746518344784`*^9, 3.5684747114577827`*^9, {
   3.5684795799065895`*^9, 3.568479591076209*^9}, 3.5842970905752926`*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.558620374546444*^9, 3.558620449707376*^9, 3.558620487958643*^9, 
   3.5586206041944475`*^9, 3.5586206757205725`*^9, {3.558620705875426*^9, 
   3.5586207306326694`*^9}, 3.558620772097542*^9, 3.5586208781777287`*^9, 
   3.558621105906928*^9, 3.5586212244827366`*^9, 3.5586213450241485`*^9, 
   3.5586214924756074`*^9, 3.5586294487171545`*^9, 3.55862948589202*^9, 
   3.5586295771365805`*^9, 3.5586299860600986`*^9, 3.558630065011837*^9, 
   3.558632437205775*^9, 3.5684746518344784`*^9, 3.5684747114577827`*^9, {
   3.5684795799065895`*^9, 3.568479591076209*^9}, 3.5842970905752926`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Create Householder for column \"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"  and apply\"\>"}],
  SequenceForm["Create Householder for column ", 1, "  and apply"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.558620374546444*^9, 3.558620449707376*^9, 3.558620487958643*^9, 
   3.5586206041944475`*^9, 3.5586206757205725`*^9, {3.558620705875426*^9, 
   3.5586207306326694`*^9}, 3.558620772097542*^9, 3.5586208781777287`*^9, 
   3.558621105906928*^9, 3.5586212244827366`*^9, 3.5586213450241485`*^9, 
   3.5586214924756074`*^9, 3.5586294487171545`*^9, 3.55862948589202*^9, 
   3.5586295771365805`*^9, 3.5586299860600986`*^9, 3.558630065011837*^9, 
   3.558632437205775*^9, 3.5684746518344784`*^9, 3.5684747114577827`*^9, {
   3.5684795799065895`*^9, 3.568479591076209*^9}, 3.584297090585293*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"column =\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.`", ",", "10.`", ",", "20.`", ",", "30.`", ",", "40.`", ",", "50.`", 
     ",", "60.`"}], "}"}], "\[InvisibleSpace]", "\<\"  gamma=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", "95.39392014169457`"}], 
   "\[InvisibleSpace]", "\<\"  normal = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.7071067811865475`", ",", "0.07412493166611012`", ",", 
     "0.14824986333222023`", ",", "0.22237479499833035`", ",", 
     "0.29649972666444047`", ",", "0.3706246583305506`", ",", 
     "0.4447495899966607`"}], "}"}]}],
  SequenceForm[
  "column =", {0., 10., 20., 30., 40., 50., 60.}, 
   "  gamma=", -95.39392014169457, "  normal = ", {0.7071067811865475, 
   0.07412493166611012, 0.14824986333222023`, 0.22237479499833035`, 
   0.29649972666444047`, 0.3706246583305506, 0.4447495899966607}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.558620374546444*^9, 3.558620449707376*^9, 3.558620487958643*^9, 
   3.5586206041944475`*^9, 3.5586206757205725`*^9, {3.558620705875426*^9, 
   3.5586207306326694`*^9}, 3.558620772097542*^9, 3.5586208781777287`*^9, 
   3.558621105906928*^9, 3.5586212244827366`*^9, 3.5586213450241485`*^9, 
   3.5586214924756074`*^9, 3.5586294487171545`*^9, 3.55862948589202*^9, 
   3.5586295771365805`*^9, 3.5586299860600986`*^9, 3.558630065011837*^9, 
   3.558632437205775*^9, 3.5684746518344784`*^9, 3.5684747114577827`*^9, {
   3.5684795799065895`*^9, 3.568479591076209*^9}, 3.584297090585293*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"normal matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.5`", "0.052414241836095915`", "0.10482848367219183`", 
        "0.15724272550828775`", "0.20965696734438366`", 
        "0.26207120918047955`", "0.3144854510165755`"},
       {"0.052414241836095915`", "0.005494505494505495`", 
        "0.01098901098901099`", "0.016483516483516484`", 
        "0.02197802197802198`", "0.027472527472527472`", 
        "0.03296703296703297`"},
       {"0.10482848367219183`", "0.01098901098901099`", 
        "0.02197802197802198`", "0.03296703296703297`", 
        "0.04395604395604396`", "0.054945054945054944`", 
        "0.06593406593406594`"},
       {"0.15724272550828775`", "0.016483516483516484`", 
        "0.03296703296703297`", "0.04945054945054945`", 
        "0.06593406593406594`", "0.08241758241758242`", "0.0989010989010989`"},
       {"0.20965696734438366`", "0.02197802197802198`", 
        "0.04395604395604396`", "0.06593406593406594`", 
        "0.08791208791208792`", "0.10989010989010989`", 
        "0.13186813186813187`"},
       {"0.26207120918047955`", "0.027472527472527472`", 
        "0.054945054945054944`", "0.08241758241758242`", 
        "0.10989010989010989`", "0.13736263736263737`", 
        "0.16483516483516483`"},
       {"0.3144854510165755`", "0.03296703296703297`", "0.06593406593406594`",
         "0.0989010989010989`", "0.13186813186813187`", 
        "0.16483516483516483`", "0.1978021978021978`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   "\[InvisibleSpace]", "\<\"  (must be symmetric and rank deficient)\"\>"}],
  SequenceForm["normal matrix = ", 
   MatrixForm[CompressedData["
1:eJxTTMoPSmViYGBgh2IIeGA/ZTO/LNe1VVB6l/36Y6entiscgfJP2dtc0Aw6
dvQCVPwKXL14RqNYRmMZlG6zF+R7KMD3cAKUP81e5pAiEM2Bii+Amw9TD1MH
k4fwl0H1rYGKb4C7B2Y+TL3k1EAgWglXB+ZKboWK74S7H2YPzHyYegh/G9S+
PVDxA3D/wtwPcw/MfJj6ILBFB6HiR+HhA3MfzB6Ye2Dmw9RDxE/aAwB3Wplw

    "]], "  (must be symmetric and rank deficient)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.558620374546444*^9, 3.558620449707376*^9, 3.558620487958643*^9, 
   3.5586206041944475`*^9, 3.5586206757205725`*^9, {3.558620705875426*^9, 
   3.5586207306326694`*^9}, 3.558620772097542*^9, 3.5586208781777287`*^9, 
   3.558621105906928*^9, 3.5586212244827366`*^9, 3.5586213450241485`*^9, 
   3.5586214924756074`*^9, 3.5586294487171545`*^9, 3.55862948589202*^9, 
   3.5586295771365805`*^9, 3.5586299860600986`*^9, 3.558630065011837*^9, 
   3.558632437205775*^9, 3.5684746518344784`*^9, 3.5684747114577827`*^9, {
   3.5684795799065895`*^9, 3.568479591076209*^9}, 3.584297090585293*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"HHicol = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.`", 
        RowBox[{"-", "0.10482848367219183`"}], 
        RowBox[{"-", "0.20965696734438366`"}], 
        RowBox[{"-", "0.3144854510165755`"}], 
        RowBox[{"-", "0.4193139346887673`"}], 
        RowBox[{"-", "0.5241424183609591`"}], 
        RowBox[{"-", "0.628970902033151`"}]},
       {
        RowBox[{"-", "0.10482848367219183`"}], "0.989010989010989`", 
        RowBox[{"-", "0.02197802197802198`"}], 
        RowBox[{"-", "0.03296703296703297`"}], 
        RowBox[{"-", "0.04395604395604396`"}], 
        RowBox[{"-", "0.054945054945054944`"}], 
        RowBox[{"-", "0.06593406593406594`"}]},
       {
        RowBox[{"-", "0.20965696734438366`"}], 
        RowBox[{"-", "0.02197802197802198`"}], "0.9560439560439561`", 
        RowBox[{"-", "0.06593406593406594`"}], 
        RowBox[{"-", "0.08791208791208792`"}], 
        RowBox[{"-", "0.10989010989010989`"}], 
        RowBox[{"-", "0.13186813186813187`"}]},
       {
        RowBox[{"-", "0.3144854510165755`"}], 
        RowBox[{"-", "0.03296703296703297`"}], 
        RowBox[{"-", "0.06593406593406594`"}], "0.9010989010989011`", 
        RowBox[{"-", "0.13186813186813187`"}], 
        RowBox[{"-", "0.16483516483516483`"}], 
        RowBox[{"-", "0.1978021978021978`"}]},
       {
        RowBox[{"-", "0.4193139346887673`"}], 
        RowBox[{"-", "0.04395604395604396`"}], 
        RowBox[{"-", "0.08791208791208792`"}], 
        RowBox[{"-", "0.13186813186813187`"}], "0.8241758241758241`", 
        RowBox[{"-", "0.21978021978021978`"}], 
        RowBox[{"-", "0.26373626373626374`"}]},
       {
        RowBox[{"-", "0.5241424183609591`"}], 
        RowBox[{"-", "0.054945054945054944`"}], 
        RowBox[{"-", "0.10989010989010989`"}], 
        RowBox[{"-", "0.16483516483516483`"}], 
        RowBox[{"-", "0.21978021978021978`"}], "0.7252747252747253`", 
        RowBox[{"-", "0.32967032967032966`"}]},
       {
        RowBox[{"-", "0.628970902033151`"}], 
        RowBox[{"-", "0.06593406593406594`"}], 
        RowBox[{"-", "0.13186813186813187`"}], 
        RowBox[{"-", "0.1978021978021978`"}], 
        RowBox[{"-", "0.26373626373626374`"}], 
        RowBox[{"-", "0.32967032967032966`"}], "0.6043956043956044`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   "\[InvisibleSpace]", "\<\"  (must be symmetric and orthogonal)\"\>"}],
  SequenceForm["HHicol = ", 
   MatrixForm[CompressedData["
1:eJxTTMoPSmViYGBgh2IYmLKZX5br2q79EPrU/vXHTk9tV7gC5d/ab3NBM+jY
0QdQ8Sf7YeoTfi2N/7X0vb14RqNYRuO0/YJ8DwX4Hi7YD+Ev2y9zSBGI1kDF
N8DNh6mvfzm97uX0d/YweYj4Nqi+PVB9B+DugZkPUx979mrM2atv7GHqpgZK
AtHR/ZJgxkm4+2HugZkPUw92fvwre4h9Z6DiF+D+hbkf5h6Y+TD14cWmQPTc
HiJ+FR4+MPfB7IG5B2Y+TD1Ye/hjewALWrlw
    "]], "  (must be symmetric and orthogonal)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.558620374546444*^9, 3.558620449707376*^9, 3.558620487958643*^9, 
   3.5586206041944475`*^9, 3.5586206757205725`*^9, {3.558620705875426*^9, 
   3.5586207306326694`*^9}, 3.558620772097542*^9, 3.5586208781777287`*^9, 
   3.558621105906928*^9, 3.5586212244827366`*^9, 3.5586213450241485`*^9, 
   3.5586214924756074`*^9, 3.5586294487171545`*^9, 3.55862948589202*^9, 
   3.5586295771365805`*^9, 3.5586299860600986`*^9, 3.558630065011837*^9, 
   3.558632437205775*^9, 3.5684746518344784`*^9, 3.5684747114577827`*^9, {
   3.5684795799065895`*^9, 3.568479591076209*^9}, 3.584297090585293*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"mat = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "95.39392014169457`"}], 
        RowBox[{"-", "2.2013981571160284`"}]},
       {"0.`", "0.6644022855585774`"},
       {"0.`", "0.3288045711171548`"},
       {"0.`", 
        RowBox[{"-", "0.006793143324267781`"}]},
       {"0.`", 
        RowBox[{"-", "0.3423908577656904`"}]},
       {"0.`", 
        RowBox[{"-", "0.677988572207113`"}]},
       {"0.`", 
        RowBox[{"-", "1.0135862866485357`"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"  rhs = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         RowBox[{"-", "54.51081150953975`"}]},
        {"16.14085977554853`"},
        {"22.281719551097062`"},
        {"13.422579326645593`"},
        {
         RowBox[{"-", "5.436560897805877`"}]},
        {
         RowBox[{"-", "39.29570112225735`"}]},
        {
         RowBox[{"-", "28.154841346708814`"}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["mat = ", 
   MatrixForm[{{-95.39392014169457, -2.2013981571160284`}, {0., 
    0.6644022855585774}, {0., 0.3288045711171548}, {
    0., -0.006793143324267781}, {0., -0.3423908577656904}, {
    0., -0.677988572207113}, {0., -1.0135862866485357`}}], "  rhs = ", 
   MatrixForm[{-54.51081150953975, 16.14085977554853, 22.281719551097062`, 
    13.422579326645593`, -5.436560897805877, -39.29570112225735, \
-28.154841346708814`}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.558620374546444*^9, 3.558620449707376*^9, 3.558620487958643*^9, 
   3.5586206041944475`*^9, 3.5586206757205725`*^9, {3.558620705875426*^9, 
   3.5586207306326694`*^9}, 3.558620772097542*^9, 3.5586208781777287`*^9, 
   3.558621105906928*^9, 3.5586212244827366`*^9, 3.5586213450241485`*^9, 
   3.5586214924756074`*^9, 3.5586294487171545`*^9, 3.55862948589202*^9, 
   3.5586295771365805`*^9, 3.5586299860600986`*^9, 3.558630065011837*^9, 
   3.558632437205775*^9, 3.5684746518344784`*^9, 3.5684747114577827`*^9, {
   3.5684795799065895`*^9, 3.568479591076209*^9}, 3.584297090595293*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.558620374546444*^9, 3.558620449707376*^9, 3.558620487958643*^9, 
   3.5586206041944475`*^9, 3.5586206757205725`*^9, {3.558620705875426*^9, 
   3.5586207306326694`*^9}, 3.558620772097542*^9, 3.5586208781777287`*^9, 
   3.558621105906928*^9, 3.5586212244827366`*^9, 3.5586213450241485`*^9, 
   3.5586214924756074`*^9, 3.5586294487171545`*^9, 3.55862948589202*^9, 
   3.5586295771365805`*^9, 3.5586299860600986`*^9, 3.558630065011837*^9, 
   3.558632437205775*^9, 3.5684746518344784`*^9, 3.5684747114577827`*^9, {
   3.5684795799065895`*^9, 3.568479591076209*^9}, 3.584297090595293*^9}],

Cell[BoxData["\<\"--------------------------------------------- \"\>"], \
"Print",
 CellChangeTimes->{
  3.558620374546444*^9, 3.558620449707376*^9, 3.558620487958643*^9, 
   3.5586206041944475`*^9, 3.5586206757205725`*^9, {3.558620705875426*^9, 
   3.5586207306326694`*^9}, 3.558620772097542*^9, 3.5586208781777287`*^9, 
   3.558621105906928*^9, 3.5586212244827366`*^9, 3.5586213450241485`*^9, 
   3.5586214924756074`*^9, 3.5586294487171545`*^9, 3.55862948589202*^9, 
   3.5586295771365805`*^9, 3.5586299860600986`*^9, 3.558630065011837*^9, 
   3.558632437205775*^9, 3.5684746518344784`*^9, 3.5684747114577827`*^9, {
   3.5684795799065895`*^9, 3.568479591076209*^9}, 3.584297090595293*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.558620374546444*^9, 3.558620449707376*^9, 3.558620487958643*^9, 
   3.5586206041944475`*^9, 3.5586206757205725`*^9, {3.558620705875426*^9, 
   3.5586207306326694`*^9}, 3.558620772097542*^9, 3.5586208781777287`*^9, 
   3.558621105906928*^9, 3.5586212244827366`*^9, 3.5586213450241485`*^9, 
   3.5586214924756074`*^9, 3.5586294487171545`*^9, 3.55862948589202*^9, 
   3.5586295771365805`*^9, 3.5586299860600986`*^9, 3.558630065011837*^9, 
   3.558632437205775*^9, 3.5684746518344784`*^9, 3.5684747114577827`*^9, {
   3.5684795799065895`*^9, 3.568479591076209*^9}, 3.584297090595293*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Create Householder for column \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"  and apply\"\>"}],
  SequenceForm["Create Householder for column ", 2, "  and apply"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.558620374546444*^9, 3.558620449707376*^9, 3.558620487958643*^9, 
   3.5586206041944475`*^9, 3.5586206757205725`*^9, {3.558620705875426*^9, 
   3.5586207306326694`*^9}, 3.558620772097542*^9, 3.5586208781777287`*^9, 
   3.558621105906928*^9, 3.5586212244827366`*^9, 3.5586213450241485`*^9, 
   3.5586214924756074`*^9, 3.5586294487171545`*^9, 3.55862948589202*^9, 
   3.5586295771365805`*^9, 3.5586299860600986`*^9, 3.558630065011837*^9, 
   3.558632437205775*^9, 3.5684746518344784`*^9, 3.5684747114577827`*^9, {
   3.5684795799065895`*^9, 3.568479591076209*^9}, 3.584297090595293*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"column =\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.`", ",", "0.6644022855585774`", ",", "0.3288045711171548`", ",", 
     RowBox[{"-", "0.006793143324267781`"}], ",", 
     RowBox[{"-", "0.3423908577656904`"}], ",", 
     RowBox[{"-", "0.677988572207113`"}], ",", 
     RowBox[{"-", "1.0135862866485357`"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"  gamma=\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1.4675987714106857`"}], 
   "\[InvisibleSpace]", "\<\"  normal = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "0.`", ",", "0.8522657587080417`", ",", "0.13143937070471828`", ",", 
     RowBox[{"-", "0.0027155537425012713`"}], ",", 
     RowBox[{"-", "0.13687047818972084`"}], ",", 
     RowBox[{"-", "0.2710254026369404`"}], ",", 
     RowBox[{"-", "0.40518032708416`"}]}], "}"}]}],
  SequenceForm[
  "column =", {0., 0.6644022855585774, 
   0.3288045711171548, -0.006793143324267781, -0.3423908577656904, \
-0.677988572207113, -1.0135862866485357`}, "  gamma=", -1.4675987714106857`, 
   "  normal = ", {0., 0.8522657587080417, 
   0.13143937070471828`, -0.0027155537425012713`, -0.13687047818972084`, \
-0.2710254026369404, -0.40518032708416}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.558620374546444*^9, 3.558620449707376*^9, 3.558620487958643*^9, 
   3.5586206041944475`*^9, 3.5586206757205725`*^9, {3.558620705875426*^9, 
   3.5586207306326694`*^9}, 3.558620772097542*^9, 3.5586208781777287`*^9, 
   3.558621105906928*^9, 3.5586212244827366`*^9, 3.5586213450241485`*^9, 
   3.5586214924756074`*^9, 3.5586294487171545`*^9, 3.55862948589202*^9, 
   3.5586295771365805`*^9, 3.5586299860600986`*^9, 3.558630065011837*^9, 
   3.558632437205775*^9, 3.5684746518344784`*^9, 3.5684747114577827`*^9, {
   3.5684795799065895`*^9, 3.568479591076209*^9}, 3.584297090595293*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"normal matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.`", "0.`", "0.`", "0.`", "0.`", "0.`", "0.`"},
       {"0.`", "0.726356923466194`", "0.11202127499776428`", 
        RowBox[{"-", "0.002314373470665308`"}], 
        RowBox[{"-", "0.11665002193909492`"}], 
        RowBox[{"-", "0.23098567040752446`"}], 
        RowBox[{"-", "0.34532131887595413`"}]},
       {"0.`", "0.11202127499776428`", "0.017276308171252357`", 
        RowBox[{"-", "0.00035693067502920976`"}], 
        RowBox[{"-", "0.017990169521310776`"}], 
        RowBox[{"-", "0.03562340836759234`"}], 
        RowBox[{"-", "0.053256647213873916`"}]},
       {"0.`", 
        RowBox[{"-", "0.002314373470665308`"}], 
        RowBox[{"-", "0.00035693067502920976`"}], "7.374232128412662`*^-6", 
        "0.0003716791392860351`", "0.0007359840464436575`", 
        "0.00110028895360128`"},
       {"0.`", 
        RowBox[{"-", "0.11665002193909492`"}], 
        RowBox[{"-", "0.017990169521310776`"}], "0.0003716791392860351`", 
        "0.01873352779988285`", "0.03709537646047966`", 
        "0.05545722512107648`"},
       {"0.`", 
        RowBox[{"-", "0.23098567040752446`"}], 
        RowBox[{"-", "0.03562340836759234`"}], "0.0007359840464436575`", 
        "0.03709537646047966`", "0.07345476887451566`", 
        "0.10981416128855168`"},
       {"0.`", 
        RowBox[{"-", "0.34532131887595413`"}], 
        RowBox[{"-", "0.053256647213873916`"}], "0.00110028895360128`", 
        "0.05545722512107648`", "0.10981416128855168`", "0.1641710974560269`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   "\[InvisibleSpace]", "\<\"  (must be symmetric and rank deficient)\"\>"}],
  SequenceForm["normal matrix = ", 
   MatrixForm[CompressedData["
1:eJxTTMoPSmViYGBgh2JKwbXQD/cD7J7bbwydpJC7do/944wDp6d/TdrvGOM3
99idvftnR8nbfZhwdn/v4dPT9kle2w/TB1NfFxqb9XDDRPtErcbJvinm+y/G
/bzGnDNpf03MJWtr20X7J3Jq9JS4rIbrg5kPU79tmVod67t7dtPji/bvjbaw
9xQq2/JQ1sM+pWqmyye2IHuYPph7YObD1J//+OXIQ73J9vy8ZZ5a/xbZWyws
3PA4ZQ1cH8z9MPfAzIepf6XA2/bu7CZ7P+v458dl9sD1wfwLcz/MPTDzYeoZ
Lzv97mM+ag8AyPeSgg==
    "]], "  (must be symmetric and rank deficient)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.558620374546444*^9, 3.558620449707376*^9, 3.558620487958643*^9, 
   3.5586206041944475`*^9, 3.5586206757205725`*^9, {3.558620705875426*^9, 
   3.5586207306326694`*^9}, 3.558620772097542*^9, 3.5586208781777287`*^9, 
   3.558621105906928*^9, 3.5586212244827366`*^9, 3.5586213450241485`*^9, 
   3.5586214924756074`*^9, 3.5586294487171545`*^9, 3.55862948589202*^9, 
   3.5586295771365805`*^9, 3.5586299860600986`*^9, 3.558630065011837*^9, 
   3.558632437205775*^9, 3.5684746518344784`*^9, 3.5684747114577827`*^9, {
   3.5684795799065895`*^9, 3.568479591076209*^9}, 3.584297090605293*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"HHicol = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.`", "0.`", "0.`", "0.`", "0.`", "0.`", "0.`"},
       {"0.`", 
        RowBox[{"-", "0.4527138469323879`"}], 
        RowBox[{"-", "0.22404254999552856`"}], "0.004628746941330616`", 
        "0.23330004387818984`", "0.461971340815049`", "0.6906426377519083`"},
       {"0.`", 
        RowBox[{"-", "0.22404254999552856`"}], "0.9654473836574953`", 
        "0.0007138613500584195`", "0.03598033904262156`", 
        "0.07124681673518468`", "0.10651329442774783`"},
       {"0.`", "0.004628746941330616`", "0.0007138613500584195`", 
        "0.9999852515357431`", 
        RowBox[{"-", "0.0007433582785720702`"}], 
        RowBox[{"-", "0.001471968092887315`"}], 
        RowBox[{"-", "0.00220057790720256`"}]},
       {"0.`", "0.23330004387818984`", "0.03598033904262156`", 
        RowBox[{"-", "0.0007433582785720702`"}], "0.9625329444002343`", 
        RowBox[{"-", "0.07419075292095932`"}], 
        RowBox[{"-", "0.11091445024215296`"}]},
       {"0.`", "0.461971340815049`", "0.07124681673518468`", 
        RowBox[{"-", "0.001471968092887315`"}], 
        RowBox[{"-", "0.07419075292095932`"}], "0.8530904622509687`", 
        RowBox[{"-", "0.21962832257710335`"}]},
       {"0.`", "0.6906426377519083`", "0.10651329442774783`", 
        RowBox[{"-", "0.00220057790720256`"}], 
        RowBox[{"-", "0.11091445024215296`"}], 
        RowBox[{"-", "0.21962832257710335`"}], "0.6716578050879463`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   "\[InvisibleSpace]", "\<\"  (must be symmetric and orthogonal)\"\>"}],
  SequenceForm["HHicol = ", 
   MatrixForm[CompressedData["
1:eJxTTMoPSmViYGBgh2II+GDPQCaICD9Y7/zzzv6NoZMUctee2f8448Dp6V+L
7B1j/OYeu3PWfk6UvN2HCXftew+fnrZP8hncHpj6FVpRLz8+eWefqNU42TfF
3f5S3M9rzDmL7GtiLllb226yn8ip0VPishuuD2Y+TP3Nxl+CD/+/t58eX7R/
b7THfk+hsi0PZSP2p1TNdPnElrQfpg/mHpj5MPWPN2x4LHj2nT0/b5mn1r9N
+y0WFm54nLIHrg/mfph7YObD1B/bXhPX4vPa3s86/vlxmTNwfTD/wtwPcw/M
fJj6hmlxTRZ1T+0BXTyXNw==
    "]], "  (must be symmetric and orthogonal)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.558620374546444*^9, 3.558620449707376*^9, 3.558620487958643*^9, 
   3.5586206041944475`*^9, 3.5586206757205725`*^9, {3.558620705875426*^9, 
   3.5586207306326694`*^9}, 3.558620772097542*^9, 3.5586208781777287`*^9, 
   3.558621105906928*^9, 3.5586212244827366`*^9, 3.5586213450241485`*^9, 
   3.5586214924756074`*^9, 3.5586294487171545`*^9, 3.55862948589202*^9, 
   3.5586295771365805`*^9, 3.5586299860600986`*^9, 3.558630065011837*^9, 
   3.558632437205775*^9, 3.5684746518344784`*^9, 3.5684747114577827`*^9, {
   3.5684795799065895`*^9, 3.568479591076209*^9}, 3.584297090605293*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"mat = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "95.39392014169457`"}], 
        RowBox[{"-", "2.2013981571160284`"}]},
       {"0.`", 
        RowBox[{"-", "1.4675987714106862`"}]},
       {"0.`", 
        RowBox[{"-", "5.551115123125783`*^-17"}]},
       {"0.`", "8.673617379884035`*^-19"},
       {"0.`", "5.551115123125783`*^-17"},
       {"0.`", "1.1102230246251565`*^-16"},
       {"0.`", "1.3877787807814457`*^-16"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"  rhs = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         RowBox[{"-", "54.51081150953975`"}]},
        {
         RowBox[{"-", "51.10388579019353`"}]},
        {"11.911002494766457`"},
        {"13.63683963056935`"},
        {"5.362676766372243`"},
        {
         RowBox[{"-", "17.91148609782487`"}]},
        {"3.814351037978035`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["mat = ", 
   MatrixForm[{{-95.39392014169457, -2.2013981571160284`}, {
    0., -1.4675987714106862`}, {0., -5.551115123125783*^-17}, {0., 
    8.673617379884035*^-19}, {0., 5.551115123125783*^-17}, {0., 
    1.1102230246251565`*^-16}, {0., 1.3877787807814457`*^-16}}], "  rhs = ", 
   MatrixForm[{-54.51081150953975, -51.10388579019353, 11.911002494766457`, 
    13.63683963056935, 5.362676766372243, -17.91148609782487, 
    3.814351037978035}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.558620374546444*^9, 3.558620449707376*^9, 3.558620487958643*^9, 
   3.5586206041944475`*^9, 3.5586206757205725`*^9, {3.558620705875426*^9, 
   3.5586207306326694`*^9}, 3.558620772097542*^9, 3.5586208781777287`*^9, 
   3.558621105906928*^9, 3.5586212244827366`*^9, 3.5586213450241485`*^9, 
   3.5586214924756074`*^9, 3.5586294487171545`*^9, 3.55862948589202*^9, 
   3.5586295771365805`*^9, 3.5586299860600986`*^9, 3.558630065011837*^9, 
   3.558632437205775*^9, 3.5684746518344784`*^9, 3.5684747114577827`*^9, {
   3.5684795799065895`*^9, 3.568479591076209*^9}, 3.584297090605293*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"soln = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         RowBox[{"-", "0.23214285714285715`"}]},
        {"34.82142857142857`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["soln = ", 
   MatrixForm[{-0.23214285714285715`, 34.82142857142857}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.558620374546444*^9, 3.558620449707376*^9, 3.558620487958643*^9, 
   3.5586206041944475`*^9, 3.5586206757205725`*^9, {3.558620705875426*^9, 
   3.5586207306326694`*^9}, 3.558620772097542*^9, 3.5586208781777287`*^9, 
   3.558621105906928*^9, 3.5586212244827366`*^9, 3.5586213450241485`*^9, 
   3.5586214924756074`*^9, 3.5586294487171545`*^9, 3.55862948589202*^9, 
   3.5586295771365805`*^9, 3.5586299860600986`*^9, 3.558630065011837*^9, 
   3.558632437205775*^9, 3.5684746518344784`*^9, 3.5684747114577827`*^9, {
   3.5684795799065895`*^9, 3.568479591076209*^9}, 3.584297090605293*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Check soln correct mat.soln=\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"34.82142857142857`"},
        {"32.5`"},
        {"30.178571428571427`"},
        {"27.857142857142854`"},
        {"25.535714285714285`"},
        {"23.214285714285715`"},
        {"20.89285714285714`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\" =? rhs =\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"30.`"},
        {"25.`"},
        {"40.`"},
        {"40.`"},
        {"30.`"},
        {"5.`"},
        {"25.`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Check soln correct mat.soln=", 
   MatrixForm[{34.82142857142857, 32.5, 30.178571428571427`, 
    27.857142857142854`, 25.535714285714285`, 23.214285714285715`, 
    20.89285714285714}], " =? rhs =", 
   MatrixForm[{30., 25., 40., 40., 30., 5., 25.}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.558620374546444*^9, 3.558620449707376*^9, 3.558620487958643*^9, 
   3.5586206041944475`*^9, 3.5586206757205725`*^9, {3.558620705875426*^9, 
   3.5586207306326694`*^9}, 3.558620772097542*^9, 3.5586208781777287`*^9, 
   3.558621105906928*^9, 3.5586212244827366`*^9, 3.5586213450241485`*^9, 
   3.5586214924756074`*^9, 3.5586294487171545`*^9, 3.55862948589202*^9, 
   3.5586295771365805`*^9, 3.5586299860600986`*^9, 3.558630065011837*^9, 
   3.558632437205775*^9, 3.5684746518344784`*^9, 3.5684747114577827`*^9, {
   3.5684795799065895`*^9, 3.568479591076209*^9}, 3.584297090605293*^9}]
}, Open  ]]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.558563815215494*^9, 3.558563833592326*^9}, {
  3.5585639392669115`*^9, 3.5585639402809134`*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1006, 630},
WindowMargins->{{Automatic, 89}, {Automatic, 5}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 673, 13, 135, "Subtitle"],
Cell[1255, 37, 822, 14, 181, "Subsubtitle"],
Cell[2080, 53, 300, 7, 62, "Text"],
Cell[2383, 62, 1814, 28, 72, "Input"],
Cell[CellGroupData[{
Cell[4222, 94, 211, 5, 97, "Section"],
Cell[4436, 101, 7713, 174, 572, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12186, 280, 113, 1, 71, "Section"],
Cell[12302, 283, 3433, 73, 172, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15772, 361, 165, 5, 97, "Section"],
Cell[CellGroupData[{
Cell[15962, 370, 10306, 226, 1112, "Input"],
Cell[CellGroupData[{
Cell[26293, 600, 651, 9, 23, "Print"],
Cell[26947, 611, 2353, 56, 110, "Print"],
Cell[29303, 669, 645, 9, 23, "Print"],
Cell[29951, 680, 692, 10, 23, "Print"],
Cell[30646, 692, 645, 9, 23, "Print"],
Cell[31294, 703, 867, 14, 23, "Print"],
Cell[32164, 719, 1567, 30, 43, "Print"],
Cell[33734, 751, 3124, 61, 140, "Print"],
Cell[36861, 814, 3962, 85, 140, "Print"],
Cell[40826, 901, 3163, 77, 110, "Print"],
Cell[43992, 980, 643, 9, 23, "Print"],
Cell[44638, 991, 690, 10, 23, "Print"],
Cell[45331, 1003, 643, 9, 23, "Print"],
Cell[45977, 1014, 867, 14, 23, "Print"],
Cell[46847, 1030, 1875, 36, 43, "Print"],
Cell[48725, 1068, 3301, 67, 143, "Print"],
Cell[52029, 1137, 3212, 63, 110, "Print"],
Cell[55244, 1202, 3128, 74, 125, "Print"],
Cell[58375, 1278, 1513, 34, 36, "Print"],
Cell[59891, 1314, 2644, 66, 110, "Print"]
}, Open  ]]
}, Open  ]],
Cell[62562, 1384, 145, 2, 31, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
