(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    125153,       2502]
NotebookOptionsPosition[    124272,       2468]
NotebookOutlinePosition[    124615,       2483]
CellTagsIndexPosition[    124572,       2480]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 "\n"
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
  3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
  3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
  3.5842134956497355`*^9, 3.5842135862546945`*^9}},
 FontFamily->"Arial"],

Cell[TextData[{
 "\n",
 StyleBox["Inner Products",
  FontWeight->"Bold"],
 "\nCompare the dot product (dotprod in the code) with a \
\[OpenCurlyDoubleQuote]made up\[CloseCurlyDoubleQuote] inner product (called \
\[OpenCurlyDoubleQuote]weirdprod\[CloseCurlyDoubleQuote] in the code).\nThe \
weirdprod is the example used in Section 14.3: for vectors v and w is <v,w> = \
4v_ 1w_ 1 + 2v_ 2w_ 2 \nFor a number ( \[OpenCurlyDoubleQuote]num\
\[CloseCurlyDoubleQuote] ) of vectors u_i  in [0, 2Pi], the following is \
calculated and plotted\n-- the inner product <u,e1> is calculated.\n-- length \
of each u_i is calculated using each inner product\n-- distance of u_i to e1\n\
\n"
}], "Subsubtitle",
 CellChangeTimes->{{3.584298804909936*^9, 3.5842988132899475`*^9}, {
  3.5842989116100855`*^9, 3.5842989709701686`*^9}, {3.584299060890294*^9, 
  3.584299161380435*^9}, {3.5842992856726103`*^9, 3.584299536172961*^9}}],

Cell[CellGroupData[{

Cell["\<\

Initialize coordinate system and vectors\
\>", "Section",
 CellChangeTimes->{{3.58429882893997*^9, 3.584298863750018*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"numu", " ", "=", " ", "50"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"origin", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"e1", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"e2", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Unit", " ", "vectors"}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"degrees", " ", "=", " ", 
   RowBox[{"360", "/", "numu"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"u", " ", "=", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"RotationMatrix", "[", 
        RowBox[{"degrees", "*", 
         RowBox[{"(", 
          RowBox[{"i", "-", "1"}], ")"}], " ", "Degree"}], "]"}], ".", "e1"}],
       ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "numu"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rads", " ", "=", " ", 
   RowBox[{"2", 
    RowBox[{"Pi", "/", "numu"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rad", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"rads", "*", 
      RowBox[{"(", 
       RowBox[{"i", "-", "1"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "numu"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.558273439677145*^9, 3.558273448491161*^9}, {
   3.5582734990664496`*^9, 3.558273502248855*^9}, {3.5582736105130453`*^9, 
   3.5582739749140854`*^9}, {3.5582740485930147`*^9, 3.558274314542282*^9}, {
   3.5582743626371665`*^9, 3.5582745263282537`*^9}, {3.5582745681363273`*^9, 
   3.558274577948745*^9}, {3.5582759285523167`*^9, 3.55827594777155*^9}, {
   3.558275979892007*^9, 3.5582759846188154`*^9}, {3.5582760232288833`*^9, 
   3.5582760957066107`*^9}, {3.55827618091396*^9, 3.558276193362782*^9}, {
   3.5582762979297657`*^9, 3.558276308490984*^9}, {3.5582763425146437`*^9, 
   3.5582763434194455`*^9}, {3.558276565986636*^9, 3.5582765716806464`*^9}, {
   3.558276628511546*^9, 3.5582766762944303`*^9}, {3.558276774793003*^9, 
   3.5582771439208517`*^9}, {3.558721911369444*^9, 3.5587219129450464`*^9}, {
   3.5587219461263046`*^9, 3.558721996171192*^9}, {3.5587222896403956`*^9, 
   3.5587223392117095`*^9}, {3.558722384030588*^9, 3.558722436836681*^9}, {
   3.5587225537160873`*^9, 3.558722570454917*^9}, {3.5590704697335815`*^9, 
   3.559070566765752*^9}, {3.5590706689615307`*^9, 3.559070690068368*^9}, {
   3.5590707436856623`*^9, 3.5590707485528708`*^9}, {3.559070797162556*^9, 
   3.559070811405381*^9}, {3.559070874382692*^9, 3.559070874725892*^9}, {
   3.559071028479762*^9, 3.5590710427849874`*^9}, {3.559071127820737*^9, 
   3.5590711507059774`*^9}, {3.559071194682454*^9, 3.5590712427461386`*^9}, {
   3.5842991185703754`*^9, 3.5842991328603954`*^9}, 3.584299215300511*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

Define the inner products and calculate length and distance with them\
\>", "Section",
 CellChangeTimes->{{3.584299218330515*^9, 3.5842992710625896`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"<", "u"}], ",", " ", 
    RowBox[{"e1", ">", " ", 
     RowBox[{"using", " ", "inner", " ", "product", " ", "defs"}]}]}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dotprod", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"rad", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ".", "e1"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numu"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"weirdprod", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"rad", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"4", "*", 
           RowBox[{"u", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], "*", 
           RowBox[{"e1", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], " ", "+", " ", 
          RowBox[{"2", "*", 
           RowBox[{"u", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "2"}], "]"}], "]"}], "*", 
           RowBox[{"e1", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numu"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"\"\<rad = \>\"", ",", 
       RowBox[{"rad", "//", "N"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Dot Products: \>\"", ",", 
       RowBox[{
        RowBox[{"MatrixForm", "[", "dotprod", "]"}], "//", "N"}]}], "]"}], 
     ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Inner Products: \>\"", ",", 
       RowBox[{
        RowBox[{"MatrixForm", "[", "weirdprod", "]"}], "//", "N"}]}], "]"}], 
     ";"}], "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"||", " ", "u", " ", "||", " ", 
     RowBox[{"using", " ", "inner", " ", "product"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"dpnorm", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"rad", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "1"}], "]"}], "]"}], "^", "2"}], " ", "+", 
           " ", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "2"}], "]"}], "]"}], "^", "2"}]}], "]"}]}], 
        "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numu"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"weirdnorm", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"rad", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"4", "*", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "1"}], "]"}], "]"}], "^", "2"}]}], " ", "+", 
           " ", 
           RowBox[{"2", "*", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "2"}], "]"}], "]"}], "^", "2"}]}]}], "]"}]}],
         "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numu"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "distance", " ", "from", " ", "u", " ", "to", " ", "e1", " ", "using", 
     " ", "inner", " ", "product"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dpdist", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"rad", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "1"}], "]"}], "]"}], "-", 
              RowBox[{"e1", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "^", "2"}], " ", "+", 
           " ", 
           RowBox[{
            RowBox[{"(", " ", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "2"}], "]"}], "]"}], "-", 
              RowBox[{"e1", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "^", "2"}]}], "]"}]}],
         "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numu"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"weirddist", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"rad", "[", 
          RowBox[{"[", "i", "]"}], "]"}], ",", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"4", "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "1"}], "]"}], "]"}], "-", 
               RowBox[{"e1", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "^", "2"}]}], " ", 
           "+", " ", 
           RowBox[{"2", "*", 
            RowBox[{
             RowBox[{"(", " ", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "2"}], "]"}], "]"}], "-", 
               RowBox[{"e1", "[", 
                RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "^", "2"}]}]}], 
          "]"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numu"}], "}"}]}], "]"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.558273439677145*^9, 3.558273448491161*^9}, {
   3.5582734990664496`*^9, 3.558273502248855*^9}, {3.5582736105130453`*^9, 
   3.5582739749140854`*^9}, {3.5582740485930147`*^9, 3.558274314542282*^9}, {
   3.5582743626371665`*^9, 3.5582745263282537`*^9}, {3.5582745681363273`*^9, 
   3.558274577948745*^9}, {3.5582759285523167`*^9, 3.55827594777155*^9}, {
   3.558275979892007*^9, 3.5582759846188154`*^9}, {3.5582760232288833`*^9, 
   3.5582760957066107`*^9}, {3.55827618091396*^9, 3.558276193362782*^9}, {
   3.5582762979297657`*^9, 3.558276308490984*^9}, {3.5582763425146437`*^9, 
   3.5582763434194455`*^9}, {3.558276565986636*^9, 3.5582765716806464`*^9}, {
   3.558276628511546*^9, 3.5582766762944303`*^9}, {3.558276774793003*^9, 
   3.5582771439208517`*^9}, {3.558721911369444*^9, 3.5587219129450464`*^9}, {
   3.5587219461263046`*^9, 3.558721996171192*^9}, {3.5587222896403956`*^9, 
   3.5587223392117095`*^9}, {3.558722384030588*^9, 3.558722436836681*^9}, {
   3.5587225537160873`*^9, 3.558722570454917*^9}, {3.5590704697335815`*^9, 
   3.559070566765752*^9}, {3.5590706689615307`*^9, 3.559070690068368*^9}, {
   3.5590707436856623`*^9, 3.5590707485528708`*^9}, {3.559070797162556*^9, 
   3.559070811405381*^9}, {3.559070874382692*^9, 3.559070874725892*^9}, {
   3.559071028479762*^9, 3.5590710427849874`*^9}, {3.559071127820737*^9, 
   3.5590711507059774`*^9}, {3.559071194682454*^9, 3.5590712427461386`*^9}, {
   3.5842991185703754`*^9, 3.5842991328603954`*^9}, 3.584299215300511*^9, 
   3.5842995594029937`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

Graphics\
\>", "Section",
 CellChangeTimes->{{3.584299563482999*^9, 3.584299569033007*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetOptions", "[", 
    RowBox[{"Graphics", ",", 
     RowBox[{"BaseStyle", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontFamily", "->", "\"\<Helvetica\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "10"}]}], "}"}]}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pic1", " ", "=", " ", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Thick", ",", "Black", ",", " ", 
       RowBox[{"Line", "[", 
        RowBox[{"{", "dotprod", "}"}], "]"}], ",", " ", "Gray", ",", " ", 
       RowBox[{"Line", "[", 
        RowBox[{"{", "weirdprod", "}"}], "]"}]}], "}"}], ",", " ", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"Ticks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "Pi", ",", 
          RowBox[{"2", "Pi"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "4"}], ",", 
          RowBox[{"-", "2"}], ",", "0", ",", "2", ",", "4"}], "}"}]}], 
       "}"}]}]}], "]"}]}], " ", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<innerprodgraph.eps\>\"", ",", " ", "pic1"}], "]"}], ";"}], 
   " ", "*)"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pic2", " ", "=", " ", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Thick", ",", " ", "Black", ",", " ", 
       RowBox[{"Line", "[", 
        RowBox[{"{", "dpnorm", "}"}], "]"}], ",", " ", "Gray", ",", " ", 
       RowBox[{"Line", "[", 
        RowBox[{"{", "weirdnorm", "}"}], "]"}]}], "}"}], ",", " ", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", " ", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", " ", 
     RowBox[{"Ticks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "Pi", ",", 
          RowBox[{"2", "Pi"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], "}"}]}]}], "]"}]}], " ", 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<innerprod2norm.eps\>\"", ",", " ", "pic2"}], "]"}], ";"}], 
   " ", "*)"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pic3", " ", "=", " ", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Thick", ",", "Black", ",", " ", 
       RowBox[{"Line", "[", 
        RowBox[{"{", "dpdist", "}"}], "]"}], ",", " ", "Gray", ",", " ", 
       RowBox[{"Line", "[", 
        RowBox[{"{", "weirddist", "}"}], "]"}]}], "}"}], ",", " ", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", " ", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ",", 
     RowBox[{"Ticks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "Pi", ",", 
          RowBox[{"2", "Pi"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "2", ",", "4"}], "}"}]}], "}"}]}]}], "]"}]}], " ", 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<innerproddist.eps\>\"", ",", " ", "pic3"}], "]"}], ";"}], 
   " ", "*)"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"pic4", " ", "=", " ", 
  RowBox[{"GraphicsRow", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"pic1", ",", " ", "pic2", ",", " ", "pic3"}], "}"}], ",", 
    RowBox[{"Alignment", "\[Rule]", "Center"}], ",", " ", 
    RowBox[{"ImageSize", "\[Rule]", "Full"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<InnerProducts.eps\>\"", ",", " ", "pic4"}], "]"}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.558273439677145*^9, 3.558273448491161*^9}, {
   3.5582734990664496`*^9, 3.558273502248855*^9}, {3.5582736105130453`*^9, 
   3.5582739749140854`*^9}, {3.5582740485930147`*^9, 3.558274314542282*^9}, {
   3.5582743626371665`*^9, 3.5582745263282537`*^9}, {3.5582745681363273`*^9, 
   3.558274577948745*^9}, {3.5582759285523167`*^9, 3.55827594777155*^9}, {
   3.558275979892007*^9, 3.5582759846188154`*^9}, {3.5582760232288833`*^9, 
   3.5582760957066107`*^9}, {3.55827618091396*^9, 3.558276193362782*^9}, {
   3.5582762979297657`*^9, 3.558276308490984*^9}, {3.5582763425146437`*^9, 
   3.5582763434194455`*^9}, {3.558276565986636*^9, 3.5582765716806464`*^9}, {
   3.558276628511546*^9, 3.5582766762944303`*^9}, {3.558276774793003*^9, 
   3.5582771439208517`*^9}, {3.558721911369444*^9, 3.5587219129450464`*^9}, {
   3.5587219461263046`*^9, 3.558721996171192*^9}, {3.5587222896403956`*^9, 
   3.5587223392117095`*^9}, {3.558722384030588*^9, 3.558722436836681*^9}, {
   3.5587225537160873`*^9, 3.558722570454917*^9}, {3.5590704697335815`*^9, 
   3.559070566765752*^9}, {3.5590706689615307`*^9, 3.559070690068368*^9}, {
   3.5590707436856623`*^9, 3.5590707485528708`*^9}, {3.559070797162556*^9, 
   3.559070811405381*^9}, {3.559070874382692*^9, 3.559070874725892*^9}, {
   3.559071028479762*^9, 3.5590710427849874`*^9}, {3.559071127820737*^9, 
   3.5590711507059774`*^9}, {3.559071194682454*^9, 3.5590712427461386`*^9}, {
   3.5842991185703754`*^9, 3.5842991328603954`*^9}, 3.584299215300511*^9, 
   3.5842995594029937`*^9}],

Cell[BoxData[
 GraphicsBox[
  {GrayLevel[0], Thickness[Large], 
   LineBox[NCache[{{{0, 1}, {
       Rational[1, 25] Pi, Cos[Rational[36, 5] Degree]}, {
       Rational[2, 25] Pi, Cos[Rational[72, 5] Degree]}, {
       Rational[3, 25] Pi, Cos[Rational[108, 5] Degree]}, {
       Rational[4, 25] Pi, Cos[Rational[144, 5] Degree]}, {
       Rational[1, 5] Pi, Rational[1, 4] (1 + 5^Rational[1, 2])}, {
       Rational[6, 25] Pi, Cos[Rational[216, 5] Degree]}, {
       Rational[7, 25] Pi, Sin[Rational[198, 5] Degree]}, {
       Rational[8, 25] Pi, Sin[Rational[162, 5] Degree]}, {
       Rational[9, 25] Pi, Sin[Rational[126, 5] Degree]}, {
       Rational[2, 5] Pi, Rational[1, 4] (-1 + 5^Rational[1, 2])}, {
       Rational[11, 25] Pi, Sin[Rational[54, 5] Degree]}, {
       Rational[12, 25] Pi, Sin[Rational[18, 5] Degree]}, {
       Rational[13, 25] Pi, -Sin[Rational[18, 5] Degree]}, {
       Rational[14, 25] Pi, -Sin[Rational[54, 5] Degree]}, {
       Rational[3, 5] Pi, Rational[1, 4] (1 - 5^Rational[1, 2])}, {
       Rational[16, 25] Pi, -Sin[Rational[126, 5] Degree]}, {
       Rational[17, 25] Pi, -Sin[Rational[162, 5] Degree]}, {
       Rational[18, 25] Pi, -Sin[Rational[198, 5] Degree]}, {
       Rational[19, 25] Pi, -Cos[Rational[216, 5] Degree]}, {
       Rational[4, 5] Pi, Rational[1, 4] (-1 - 5^Rational[1, 2])}, {
       Rational[21, 25] Pi, -Cos[Rational[144, 5] Degree]}, {
       Rational[22, 25] Pi, -Cos[Rational[108, 5] Degree]}, {
       Rational[23, 25] Pi, -Cos[Rational[72, 5] Degree]}, {
       Rational[24, 25] Pi, -Cos[Rational[36, 5] Degree]}, {Pi, -1}, {
       Rational[26, 25] Pi, -Cos[Rational[36, 5] Degree]}, {
       Rational[27, 25] Pi, -Cos[Rational[72, 5] Degree]}, {
       Rational[28, 25] Pi, -Cos[Rational[108, 5] Degree]}, {
       Rational[29, 25] Pi, -Cos[Rational[144, 5] Degree]}, {
       Rational[6, 5] Pi, Rational[1, 4] (-1 - 5^Rational[1, 2])}, {
       Rational[31, 25] Pi, -Cos[Rational[216, 5] Degree]}, {
       Rational[32, 25] Pi, -Sin[Rational[198, 5] Degree]}, {
       Rational[33, 25] Pi, -Sin[Rational[162, 5] Degree]}, {
       Rational[34, 25] Pi, -Sin[Rational[126, 5] Degree]}, {
       Rational[7, 5] Pi, Rational[1, 4] (1 - 5^Rational[1, 2])}, {
       Rational[36, 25] Pi, -Sin[Rational[54, 5] Degree]}, {
       Rational[37, 25] Pi, -Sin[Rational[18, 5] Degree]}, {
       Rational[38, 25] Pi, Sin[Rational[18, 5] Degree]}, {
       Rational[39, 25] Pi, Sin[Rational[54, 5] Degree]}, {
       Rational[8, 5] Pi, Rational[1, 4] (-1 + 5^Rational[1, 2])}, {
       Rational[41, 25] Pi, Sin[Rational[126, 5] Degree]}, {
       Rational[42, 25] Pi, Sin[Rational[162, 5] Degree]}, {
       Rational[43, 25] Pi, Sin[Rational[198, 5] Degree]}, {
       Rational[44, 25] Pi, Cos[Rational[216, 5] Degree]}, {
       Rational[9, 5] Pi, Rational[1, 4] (1 + 5^Rational[1, 2])}, {
       Rational[46, 25] Pi, Cos[Rational[144, 5] Degree]}, {
       Rational[47, 25] Pi, Cos[Rational[108, 5] Degree]}, {
       Rational[48, 25] Pi, Cos[Rational[72, 5] Degree]}, {
       Rational[49, 25] Pi, Cos[Rational[36, 5] Degree]}}}, {{{0, 1}, {
       0.12566370614359174`, 0.9921147013144779}, {0.25132741228718347`, 
       0.9685831611286311}, {0.37699111843077515`, 0.9297764858882515}, {
       0.5026548245743669, 0.8763066800438636}, {0.6283185307179586, 
       0.8090169943749475}, {0.7539822368615503, 0.7289686274214116}, {
       0.8796459430051422, 0.6374239897486897}, {1.0053096491487339`, 
       0.5358267949789967}, {1.1309733552923256`, 0.42577929156507266`}, {
       1.2566370614359172`, 0.30901699437494745`}, {1.382300767579509, 
       0.18738131458572463`}, {1.5079644737231006`, 0.06279051952931337}, {
       1.6336281798666925`, -0.06279051952931337}, {
       1.7592918860102844`, -0.18738131458572463`}, {
       1.8849555921538759`, -0.30901699437494745`}, {
       2.0106192982974678`, -0.42577929156507266`}, {
       2.1362830044410597`, -0.5358267949789967}, {
       2.261946710584651, -0.6374239897486897}, {
       2.3876104167282426`, -0.7289686274214116}, {
       2.5132741228718345`, -0.8090169943749475}, {
       2.638937829015426, -0.8763066800438636}, {
       2.764601535159018, -0.9297764858882515}, {
       2.8902652413026098`, -0.9685831611286311}, {
       3.015928947446201, -0.9921147013144779}, {3.141592653589793, -1}, {
       3.267256359733385, -0.9921147013144779}, {
       3.392920065876977, -0.9685831611286311}, {
       3.518583772020569, -0.9297764858882515}, {
       3.64424747816416, -0.8763066800438636}, {
       3.7699111843077517`, -0.8090169943749475}, {
       3.8955748904513436`, -0.7289686274214116}, {
       4.0212385965949355`, -0.6374239897486897}, {
       4.1469023027385274`, -0.5358267949789967}, {
       4.272566008882119, -0.42577929156507266`}, {
       4.39822971502571, -0.30901699437494745`}, {
       4.523893421169302, -0.18738131458572463`}, {
       4.649557127312894, -0.06279051952931337}, {4.775220833456485, 
       0.06279051952931337}, {4.900884539600077, 0.18738131458572463`}, {
       5.026548245743669, 0.30901699437494745`}, {5.15221195188726, 
       0.42577929156507266`}, {5.277875658030852, 0.5358267949789967}, {
       5.403539364174444, 0.6374239897486897}, {5.529203070318036, 
       0.7289686274214116}, {5.654866776461628, 0.8090169943749475}, {
       5.7805304826052195`, 0.8763066800438636}, {5.9061941887488105`, 
       0.9297764858882515}, {6.031857894892402, 0.9685831611286311}, {
       6.157521601035994, 0.9921147013144779}}}]], 
   {GrayLevel[0.5], 
    LineBox[NCache[{{{0, 4}, {
        Rational[1, 25] Pi, 4 Cos[Rational[36, 5] Degree]}, {
        Rational[2, 25] Pi, 4 Cos[Rational[72, 5] Degree]}, {
        Rational[3, 25] Pi, 4 Cos[Rational[108, 5] Degree]}, {
        Rational[4, 25] Pi, 4 Cos[Rational[144, 5] Degree]}, {
        Rational[1, 5] Pi, 1 + 5^Rational[1, 2]}, {
        Rational[6, 25] Pi, 4 Cos[Rational[216, 5] Degree]}, {
        Rational[7, 25] Pi, 4 Sin[Rational[198, 5] Degree]}, {
        Rational[8, 25] Pi, 4 Sin[Rational[162, 5] Degree]}, {
        Rational[9, 25] Pi, 4 Sin[Rational[126, 5] Degree]}, {
        Rational[2, 5] Pi, -1 + 5^Rational[1, 2]}, {
        Rational[11, 25] Pi, 4 Sin[Rational[54, 5] Degree]}, {
        Rational[12, 25] Pi, 4 Sin[Rational[18, 5] Degree]}, {
        Rational[13, 25] Pi, (-4) Sin[Rational[18, 5] Degree]}, {
        Rational[14, 25] Pi, (-4) Sin[Rational[54, 5] Degree]}, {
        Rational[3, 5] Pi, 1 - 5^Rational[1, 2]}, {
        Rational[16, 25] Pi, (-4) Sin[Rational[126, 5] Degree]}, {
        Rational[17, 25] Pi, (-4) Sin[Rational[162, 5] Degree]}, {
        Rational[18, 25] Pi, (-4) Sin[Rational[198, 5] Degree]}, {
        Rational[19, 25] Pi, (-4) Cos[Rational[216, 5] Degree]}, {
        Rational[4, 5] Pi, -1 - 5^Rational[1, 2]}, {
        Rational[21, 25] Pi, (-4) Cos[Rational[144, 5] Degree]}, {
        Rational[22, 25] Pi, (-4) Cos[Rational[108, 5] Degree]}, {
        Rational[23, 25] Pi, (-4) Cos[Rational[72, 5] Degree]}, {
        Rational[24, 25] Pi, (-4) Cos[Rational[36, 5] Degree]}, {Pi, -4}, {
        Rational[26, 25] Pi, (-4) Cos[Rational[36, 5] Degree]}, {
        Rational[27, 25] Pi, (-4) Cos[Rational[72, 5] Degree]}, {
        Rational[28, 25] Pi, (-4) Cos[Rational[108, 5] Degree]}, {
        Rational[29, 25] Pi, (-4) Cos[Rational[144, 5] Degree]}, {
        Rational[6, 5] Pi, -1 - 5^Rational[1, 2]}, {
        Rational[31, 25] Pi, (-4) Cos[Rational[216, 5] Degree]}, {
        Rational[32, 25] Pi, (-4) Sin[Rational[198, 5] Degree]}, {
        Rational[33, 25] Pi, (-4) Sin[Rational[162, 5] Degree]}, {
        Rational[34, 25] Pi, (-4) Sin[Rational[126, 5] Degree]}, {
        Rational[7, 5] Pi, 1 - 5^Rational[1, 2]}, {
        Rational[36, 25] Pi, (-4) Sin[Rational[54, 5] Degree]}, {
        Rational[37, 25] Pi, (-4) Sin[Rational[18, 5] Degree]}, {
        Rational[38, 25] Pi, 4 Sin[Rational[18, 5] Degree]}, {
        Rational[39, 25] Pi, 4 Sin[Rational[54, 5] Degree]}, {
        Rational[8, 5] Pi, -1 + 5^Rational[1, 2]}, {
        Rational[41, 25] Pi, 4 Sin[Rational[126, 5] Degree]}, {
        Rational[42, 25] Pi, 4 Sin[Rational[162, 5] Degree]}, {
        Rational[43, 25] Pi, 4 Sin[Rational[198, 5] Degree]}, {
        Rational[44, 25] Pi, 4 Cos[Rational[216, 5] Degree]}, {
        Rational[9, 5] Pi, 1 + 5^Rational[1, 2]}, {
        Rational[46, 25] Pi, 4 Cos[Rational[144, 5] Degree]}, {
        Rational[47, 25] Pi, 4 Cos[Rational[108, 5] Degree]}, {
        Rational[48, 25] Pi, 4 Cos[Rational[72, 5] Degree]}, {
        Rational[49, 25] Pi, 4 Cos[Rational[36, 5] Degree]}}}, {{{0, 4}, {
        0.12566370614359174`, 3.9684588052579115`}, {0.25132741228718347`, 
        3.8743326445145243`}, {0.37699111843077515`, 3.719105943553006}, {
        0.5026548245743669, 3.5052267201754543`}, {0.6283185307179586, 
        3.23606797749979}, {0.7539822368615503, 2.915874509685646}, {
        0.8796459430051422, 2.549695958994759}, {1.0053096491487339`, 
        2.1433071799159866`}, {1.1309733552923256`, 1.7031171662602906`}, {
        1.2566370614359172`, 1.2360679774997898`}, {1.382300767579509, 
        0.7495252583428985}, {1.5079644737231006`, 0.2511620781172535}, {
        1.6336281798666925`, -0.2511620781172535}, {
        1.7592918860102844`, -0.7495252583428985}, {
        1.8849555921538759`, -1.2360679774997898`}, {
        2.0106192982974678`, -1.7031171662602906`}, {
        2.1362830044410597`, -2.1433071799159866`}, {
        2.261946710584651, -2.549695958994759}, {
        2.3876104167282426`, -2.915874509685646}, {
        2.5132741228718345`, -3.23606797749979}, {
        2.638937829015426, -3.5052267201754543`}, {
        2.764601535159018, -3.719105943553006}, {
        2.8902652413026098`, -3.8743326445145243`}, {
        3.015928947446201, -3.9684588052579115`}, {3.141592653589793, -4}, {
        3.267256359733385, -3.9684588052579115`}, {
        3.392920065876977, -3.8743326445145243`}, {
        3.518583772020569, -3.719105943553006}, {
        3.64424747816416, -3.5052267201754543`}, {
        3.7699111843077517`, -3.23606797749979}, {
        3.8955748904513436`, -2.915874509685646}, {
        4.0212385965949355`, -2.549695958994759}, {
        4.1469023027385274`, -2.1433071799159866`}, {
        4.272566008882119, -1.7031171662602906`}, {
        4.39822971502571, -1.2360679774997898`}, {
        4.523893421169302, -0.7495252583428985}, {
        4.649557127312894, -0.2511620781172535}, {4.775220833456485, 
        0.2511620781172535}, {4.900884539600077, 0.7495252583428985}, {
        5.026548245743669, 1.2360679774997898`}, {5.15221195188726, 
        1.7031171662602906`}, {5.277875658030852, 2.1433071799159866`}, {
        5.403539364174444, 2.549695958994759}, {5.529203070318036, 
        2.915874509685646}, {5.654866776461628, 3.23606797749979}, {
        5.7805304826052195`, 3.5052267201754543`}, {5.9061941887488105`, 
        3.719105943553006}, {6.031857894892402, 3.8743326445145243`}, {
        6.157521601035994, 3.9684588052579115`}}}]]}},
  Axes->True,
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 10},
  Ticks->{{{0, 
      FormBox["0", TraditionalForm]}, {
      NCache[Pi, 3.141592653589793], 
      FormBox["\[Pi]", TraditionalForm]}, {
      NCache[2 Pi, 6.283185307179586], 
      FormBox[
       RowBox[{"2", " ", "\[Pi]"}], TraditionalForm]}}, {{-4, 
      FormBox[
       RowBox[{"-", "4"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}}}]], "Output",
 CellChangeTimes->{{3.5582743680815763`*^9, 3.5582743827300014`*^9}, 
   3.558274418594465*^9, {3.558274448920918*^9, 3.55827451848144*^9}, 
   3.5582745802887487`*^9, 3.558276097188613*^9, 3.5582761943767834`*^9, 
   3.558276309598586*^9, 3.5582763441214466`*^9, {3.55827664791798*^9, 
   3.558276676887231*^9}, 3.558276792421034*^9, 3.5582771456524544`*^9, 
   3.5587220034720054`*^9, 3.5587223438605175`*^9, 3.5587224413606887`*^9, 
   3.5590705725221615`*^9, 3.5590706959807787`*^9, 3.5590707505652742`*^9, 
   3.559070812637783*^9, 3.5590710541574078`*^9, 3.559071151610779*^9, 
   3.559071244540142*^9}],

Cell[BoxData[
 GraphicsBox[
  {GrayLevel[0], Thickness[Large], 
   LineBox[NCache[{{{0, 1}, {
       Rational[1, 25] 
        Pi, (Cos[Rational[36, 5] Degree]^2 + Sin[Rational[36, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[2, 25] 
        Pi, (Cos[Rational[72, 5] Degree]^2 + Sin[Rational[72, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[3, 25] 
        Pi, (Cos[Rational[108, 5] Degree]^2 + Sin[Rational[108, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[4, 25] 
        Pi, (Cos[Rational[144, 5] Degree]^2 + Sin[Rational[144, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[1, 5] 
        Pi, (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2] + 
         Rational[1, 16] (1 + 5^Rational[1, 2])^2)^Rational[1, 2]}, {
       Rational[6, 25] 
        Pi, (Cos[Rational[216, 5] Degree]^2 + Sin[Rational[216, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[7, 25] 
        Pi, (Cos[Rational[198, 5] Degree]^2 + Sin[Rational[198, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[8, 25] 
        Pi, (Cos[Rational[162, 5] Degree]^2 + Sin[Rational[162, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[9, 25] 
        Pi, (Cos[Rational[126, 5] Degree]^2 + Sin[Rational[126, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[2, 5] 
        Pi, (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2] + 
         Rational[1, 16] (-1 + 5^Rational[1, 2])^2)^Rational[1, 2]}, {
       Rational[11, 25] 
        Pi, (Cos[Rational[54, 5] Degree]^2 + Sin[Rational[54, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[12, 25] 
        Pi, (Cos[Rational[18, 5] Degree]^2 + Sin[Rational[18, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[13, 25] 
        Pi, (Cos[Rational[18, 5] Degree]^2 + Sin[Rational[18, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[14, 25] 
        Pi, (Cos[Rational[54, 5] Degree]^2 + Sin[Rational[54, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[3, 5] 
        Pi, (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2] + 
         Rational[1, 16] (1 - 5^Rational[1, 2])^2)^Rational[1, 2]}, {
       Rational[16, 25] 
        Pi, (Cos[Rational[126, 5] Degree]^2 + Sin[Rational[126, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[17, 25] 
        Pi, (Cos[Rational[162, 5] Degree]^2 + Sin[Rational[162, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[18, 25] 
        Pi, (Cos[Rational[198, 5] Degree]^2 + Sin[Rational[198, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[19, 25] 
        Pi, (Cos[Rational[216, 5] Degree]^2 + Sin[Rational[216, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[4, 5] 
        Pi, (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2] + 
         Rational[1, 16] (-1 - 5^Rational[1, 2])^2)^Rational[1, 2]}, {
       Rational[21, 25] 
        Pi, (Cos[Rational[144, 5] Degree]^2 + Sin[Rational[144, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[22, 25] 
        Pi, (Cos[Rational[108, 5] Degree]^2 + Sin[Rational[108, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[23, 25] 
        Pi, (Cos[Rational[72, 5] Degree]^2 + Sin[Rational[72, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[24, 25] 
        Pi, (Cos[Rational[36, 5] Degree]^2 + Sin[Rational[36, 5] Degree]^2)^
        Rational[1, 2]}, {Pi, 1}, {
       Rational[26, 25] 
        Pi, (Cos[Rational[36, 5] Degree]^2 + Sin[Rational[36, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[27, 25] 
        Pi, (Cos[Rational[72, 5] Degree]^2 + Sin[Rational[72, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[28, 25] 
        Pi, (Cos[Rational[108, 5] Degree]^2 + Sin[Rational[108, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[29, 25] 
        Pi, (Cos[Rational[144, 5] Degree]^2 + Sin[Rational[144, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[6, 5] 
        Pi, (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2] + 
         Rational[1, 16] (-1 - 5^Rational[1, 2])^2)^Rational[1, 2]}, {
       Rational[31, 25] 
        Pi, (Cos[Rational[216, 5] Degree]^2 + Sin[Rational[216, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[32, 25] 
        Pi, (Cos[Rational[198, 5] Degree]^2 + Sin[Rational[198, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[33, 25] 
        Pi, (Cos[Rational[162, 5] Degree]^2 + Sin[Rational[162, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[34, 25] 
        Pi, (Cos[Rational[126, 5] Degree]^2 + Sin[Rational[126, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[7, 5] 
        Pi, (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2] + 
         Rational[1, 16] (1 - 5^Rational[1, 2])^2)^Rational[1, 2]}, {
       Rational[36, 25] 
        Pi, (Cos[Rational[54, 5] Degree]^2 + Sin[Rational[54, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[37, 25] 
        Pi, (Cos[Rational[18, 5] Degree]^2 + Sin[Rational[18, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[38, 25] 
        Pi, (Cos[Rational[18, 5] Degree]^2 + Sin[Rational[18, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[39, 25] 
        Pi, (Cos[Rational[54, 5] Degree]^2 + Sin[Rational[54, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[8, 5] 
        Pi, (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2] + 
         Rational[1, 16] (-1 + 5^Rational[1, 2])^2)^Rational[1, 2]}, {
       Rational[41, 25] 
        Pi, (Cos[Rational[126, 5] Degree]^2 + Sin[Rational[126, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[42, 25] 
        Pi, (Cos[Rational[162, 5] Degree]^2 + Sin[Rational[162, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[43, 25] 
        Pi, (Cos[Rational[198, 5] Degree]^2 + Sin[Rational[198, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[44, 25] 
        Pi, (Cos[Rational[216, 5] Degree]^2 + Sin[Rational[216, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[9, 5] 
        Pi, (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2] + 
         Rational[1, 16] (1 + 5^Rational[1, 2])^2)^Rational[1, 2]}, {
       Rational[46, 25] 
        Pi, (Cos[Rational[144, 5] Degree]^2 + Sin[Rational[144, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[47, 25] 
        Pi, (Cos[Rational[108, 5] Degree]^2 + Sin[Rational[108, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[48, 25] 
        Pi, (Cos[Rational[72, 5] Degree]^2 + Sin[Rational[72, 5] Degree]^2)^
        Rational[1, 2]}, {
       Rational[49, 25] 
        Pi, (Cos[Rational[36, 5] Degree]^2 + Sin[Rational[36, 5] Degree]^2)^
        Rational[1, 2]}}}, {{{0, 1}, {0.12566370614359174`, 1.}, {
       0.25132741228718347`, 1.}, {0.37699111843077515`, 1.}, {
       0.5026548245743669, 1.}, {0.6283185307179586, 1.}, {0.7539822368615503,
        1.}, {0.8796459430051422, 1.}, {1.0053096491487339`, 1.}, {
       1.1309733552923256`, 1.}, {1.2566370614359172`, 1.}, {
       1.382300767579509, 1.}, {1.5079644737231006`, 1.}, {
       1.6336281798666925`, 1.}, {1.7592918860102844`, 1.}, {
       1.8849555921538759`, 1.}, {2.0106192982974678`, 1.}, {
       2.1362830044410597`, 1.}, {2.261946710584651, 1.}, {
       2.3876104167282426`, 1.}, {2.5132741228718345`, 1.}, {
       2.638937829015426, 1.}, {2.764601535159018, 1.}, {2.8902652413026098`, 
       1.}, {3.015928947446201, 1.}, {3.141592653589793, 1}, {
       3.267256359733385, 1.}, {3.392920065876977, 1.}, {3.518583772020569, 
       1.}, {3.64424747816416, 1.}, {3.7699111843077517`, 1.}, {
       3.8955748904513436`, 1.}, {4.0212385965949355`, 1.}, {
       4.1469023027385274`, 1.}, {4.272566008882119, 1.}, {4.39822971502571, 
       1.}, {4.523893421169302, 1.}, {4.649557127312894, 1.}, {
       4.775220833456485, 1.}, {4.900884539600077, 1.}, {5.026548245743669, 
       1.}, {5.15221195188726, 1.}, {5.277875658030852, 1.}, {
       5.403539364174444, 1.}, {5.529203070318036, 1.}, {5.654866776461628, 
       1.}, {5.7805304826052195`, 1.}, {5.9061941887488105`, 1.}, {
       6.031857894892402, 1.}, {6.157521601035994, 1.}}}]], 
   {GrayLevel[0.5], 
    LineBox[NCache[{{{0, 2}, {
        Rational[1, 25] 
         Pi, (4 Cos[Rational[36, 5] Degree]^2 + 
          2 Sin[Rational[36, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[2, 25] 
         Pi, (4 Cos[Rational[72, 5] Degree]^2 + 
          2 Sin[Rational[72, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[3, 25] 
         Pi, (4 Cos[Rational[108, 5] Degree]^2 + 
          2 Sin[Rational[108, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[4, 25] 
         Pi, (4 Cos[Rational[144, 5] Degree]^2 + 
          2 Sin[Rational[144, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[1, 5] 
         Pi, (2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2]) + 
          Rational[1, 4] (1 + 5^Rational[1, 2])^2)^Rational[1, 2]}, {
        Rational[6, 25] 
         Pi, (4 Cos[Rational[216, 5] Degree]^2 + 
          2 Sin[Rational[216, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[7, 25] 
         Pi, (2 Cos[Rational[198, 5] Degree]^2 + 
          4 Sin[Rational[198, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[8, 25] 
         Pi, (2 Cos[Rational[162, 5] Degree]^2 + 
          4 Sin[Rational[162, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[9, 25] 
         Pi, (2 Cos[Rational[126, 5] Degree]^2 + 
          4 Sin[Rational[126, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[2, 5] 
         Pi, (2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2]) + 
          Rational[1, 4] (-1 + 5^Rational[1, 2])^2)^Rational[1, 2]}, {
        Rational[11, 25] 
         Pi, (2 Cos[Rational[54, 5] Degree]^2 + 
          4 Sin[Rational[54, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[12, 25] 
         Pi, (2 Cos[Rational[18, 5] Degree]^2 + 
          4 Sin[Rational[18, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[13, 25] 
         Pi, (2 Cos[Rational[18, 5] Degree]^2 + 
          4 Sin[Rational[18, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[14, 25] 
         Pi, (2 Cos[Rational[54, 5] Degree]^2 + 
          4 Sin[Rational[54, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[3, 5] 
         Pi, (Rational[1, 4] (1 - 5^Rational[1, 2])^2 + 
          2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2]))^
         Rational[1, 2]}, {
        Rational[16, 25] 
         Pi, (2 Cos[Rational[126, 5] Degree]^2 + 
          4 Sin[Rational[126, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[17, 25] 
         Pi, (2 Cos[Rational[162, 5] Degree]^2 + 
          4 Sin[Rational[162, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[18, 25] 
         Pi, (2 Cos[Rational[198, 5] Degree]^2 + 
          4 Sin[Rational[198, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[19, 25] 
         Pi, (4 Cos[Rational[216, 5] Degree]^2 + 
          2 Sin[Rational[216, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[4, 5] 
         Pi, (Rational[1, 4] (-1 - 5^Rational[1, 2])^2 + 
          2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2]))^
         Rational[1, 2]}, {
        Rational[21, 25] 
         Pi, (4 Cos[Rational[144, 5] Degree]^2 + 
          2 Sin[Rational[144, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[22, 25] 
         Pi, (4 Cos[Rational[108, 5] Degree]^2 + 
          2 Sin[Rational[108, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[23, 25] 
         Pi, (4 Cos[Rational[72, 5] Degree]^2 + 
          2 Sin[Rational[72, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[24, 25] 
         Pi, (4 Cos[Rational[36, 5] Degree]^2 + 
          2 Sin[Rational[36, 5] Degree]^2)^Rational[1, 2]}, {Pi, 2}, {
        Rational[26, 25] 
         Pi, (4 Cos[Rational[36, 5] Degree]^2 + 
          2 Sin[Rational[36, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[27, 25] 
         Pi, (4 Cos[Rational[72, 5] Degree]^2 + 
          2 Sin[Rational[72, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[28, 25] 
         Pi, (4 Cos[Rational[108, 5] Degree]^2 + 
          2 Sin[Rational[108, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[29, 25] 
         Pi, (4 Cos[Rational[144, 5] Degree]^2 + 
          2 Sin[Rational[144, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[6, 5] 
         Pi, (Rational[1, 4] (-1 - 5^Rational[1, 2])^2 + 
          2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2]))^
         Rational[1, 2]}, {
        Rational[31, 25] 
         Pi, (4 Cos[Rational[216, 5] Degree]^2 + 
          2 Sin[Rational[216, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[32, 25] 
         Pi, (2 Cos[Rational[198, 5] Degree]^2 + 
          4 Sin[Rational[198, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[33, 25] 
         Pi, (2 Cos[Rational[162, 5] Degree]^2 + 
          4 Sin[Rational[162, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[34, 25] 
         Pi, (2 Cos[Rational[126, 5] Degree]^2 + 
          4 Sin[Rational[126, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[7, 5] 
         Pi, (Rational[1, 4] (1 - 5^Rational[1, 2])^2 + 
          2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2]))^
         Rational[1, 2]}, {
        Rational[36, 25] 
         Pi, (2 Cos[Rational[54, 5] Degree]^2 + 
          4 Sin[Rational[54, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[37, 25] 
         Pi, (2 Cos[Rational[18, 5] Degree]^2 + 
          4 Sin[Rational[18, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[38, 25] 
         Pi, (2 Cos[Rational[18, 5] Degree]^2 + 
          4 Sin[Rational[18, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[39, 25] 
         Pi, (2 Cos[Rational[54, 5] Degree]^2 + 
          4 Sin[Rational[54, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[8, 5] 
         Pi, (2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2]) + 
          Rational[1, 4] (-1 + 5^Rational[1, 2])^2)^Rational[1, 2]}, {
        Rational[41, 25] 
         Pi, (2 Cos[Rational[126, 5] Degree]^2 + 
          4 Sin[Rational[126, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[42, 25] 
         Pi, (2 Cos[Rational[162, 5] Degree]^2 + 
          4 Sin[Rational[162, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[43, 25] 
         Pi, (2 Cos[Rational[198, 5] Degree]^2 + 
          4 Sin[Rational[198, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[44, 25] 
         Pi, (4 Cos[Rational[216, 5] Degree]^2 + 
          2 Sin[Rational[216, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[9, 5] 
         Pi, (2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2]) + 
          Rational[1, 4] (1 + 5^Rational[1, 2])^2)^Rational[1, 2]}, {
        Rational[46, 25] 
         Pi, (4 Cos[Rational[144, 5] Degree]^2 + 
          2 Sin[Rational[144, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[47, 25] 
         Pi, (4 Cos[Rational[108, 5] Degree]^2 + 
          2 Sin[Rational[108, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[48, 25] 
         Pi, (4 Cos[Rational[72, 5] Degree]^2 + 
          2 Sin[Rational[72, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[49, 25] 
         Pi, (4 Cos[Rational[36, 5] Degree]^2 + 
          2 Sin[Rational[36, 5] Degree]^2)^Rational[1, 2]}}}, {{{0, 2}, {
        0.12566370614359174`, 1.9921303072662269`}, {0.25132741228718347`, 
        1.968833837591142}, {0.37699111843077515`, 1.9310537608832676`}, {
        0.5026548245743669, 1.8803794284609148`}, {0.6283185307179586, 
        1.8190703654270628`}, {0.7539822368615503, 1.7500830036113468`}, {
        0.8796459430051422, 1.6770863679054442`}, {1.0053096491487339`, 
        1.6044378169424103`}, {1.1309733552923256`, 1.5370673408316602`}, {
        1.2566370614359172`, 1.480196948255553}, {1.382300767579509, 
        1.4388271314205014`}, {1.5079644737231006`, 1.4169986939604151`}, {
        1.6336281798666925`, 1.4169986939604151`}, {1.7592918860102844`, 
        1.4388271314205014`}, {1.8849555921538759`, 1.480196948255553}, {
        2.0106192982974678`, 1.5370673408316602`}, {2.1362830044410597`, 
        1.6044378169424103`}, {2.261946710584651, 1.6770863679054442`}, {
        2.3876104167282426`, 1.7500830036113468`}, {2.5132741228718345`, 
        1.8190703654270628`}, {2.638937829015426, 1.8803794284609148`}, {
        2.764601535159018, 1.9310537608832676`}, {2.8902652413026098`, 
        1.968833837591142}, {3.015928947446201, 1.9921303072662269`}, {
        3.141592653589793, 2}, {3.267256359733385, 1.9921303072662269`}, {
        3.392920065876977, 1.968833837591142}, {3.518583772020569, 
        1.9310537608832676`}, {3.64424747816416, 1.8803794284609148`}, {
        3.7699111843077517`, 1.8190703654270628`}, {3.8955748904513436`, 
        1.7500830036113468`}, {4.0212385965949355`, 1.6770863679054442`}, {
        4.1469023027385274`, 1.6044378169424103`}, {4.272566008882119, 
        1.5370673408316602`}, {4.39822971502571, 1.480196948255553}, {
        4.523893421169302, 1.4388271314205014`}, {4.649557127312894, 
        1.4169986939604151`}, {4.775220833456485, 1.4169986939604151`}, {
        4.900884539600077, 1.4388271314205014`}, {5.026548245743669, 
        1.480196948255553}, {5.15221195188726, 1.5370673408316602`}, {
        5.277875658030852, 1.6044378169424103`}, {5.403539364174444, 
        1.6770863679054442`}, {5.529203070318036, 1.7500830036113468`}, {
        5.654866776461628, 1.8190703654270628`}, {5.7805304826052195`, 
        1.8803794284609148`}, {5.9061941887488105`, 1.9310537608832676`}, {
        6.031857894892402, 1.968833837591142}, {6.157521601035994, 
        1.9921303072662269`}}}]]}},
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 10},
  Ticks->{{{0, 
      FormBox["0", TraditionalForm]}, {
      NCache[Pi, 3.141592653589793], 
      FormBox["\[Pi]", TraditionalForm]}, {
      NCache[2 Pi, 6.283185307179586], 
      FormBox[
       RowBox[{"2", " ", "\[Pi]"}], TraditionalForm]}}, {{0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}}}]], "Output",
 CellChangeTimes->{{3.5582743680815763`*^9, 3.5582743827300014`*^9}, 
   3.558274418594465*^9, {3.558274448920918*^9, 3.55827451848144*^9}, 
   3.5582745802887487`*^9, 3.558276097188613*^9, 3.5582761943767834`*^9, 
   3.558276309598586*^9, 3.5582763441214466`*^9, {3.55827664791798*^9, 
   3.558276676887231*^9}, 3.558276792421034*^9, 3.5582771456524544`*^9, 
   3.5587220034720054`*^9, 3.5587223438605175`*^9, 3.5587224413606887`*^9, 
   3.5590705725221615`*^9, 3.5590706959807787`*^9, 3.5590707505652742`*^9, 
   3.559070812637783*^9, 3.5590710541574078`*^9, 3.559071151610779*^9, 
   3.559071244571342*^9}],

Cell[BoxData[
 GraphicsBox[
  {GrayLevel[0], Thickness[Large], 
   LineBox[NCache[{{{0, 0}, {
       Rational[1, 25] 
        Pi, ((-1 + Cos[Rational[36, 5] Degree])^2 + 
         Sin[Rational[36, 5] Degree]^2)^Rational[1, 2]}, {
       Rational[2, 25] 
        Pi, ((-1 + Cos[Rational[72, 5] Degree])^2 + 
         Sin[Rational[72, 5] Degree]^2)^Rational[1, 2]}, {
       Rational[3, 25] 
        Pi, ((-1 + Cos[Rational[108, 5] Degree])^2 + 
         Sin[Rational[108, 5] Degree]^2)^Rational[1, 2]}, {
       Rational[4, 25] 
        Pi, ((-1 + Cos[Rational[144, 5] Degree])^2 + 
         Sin[Rational[144, 5] Degree]^2)^Rational[1, 2]}, {
       Rational[1, 5] 
        Pi, (Rational[5, 8] + 
         Rational[-1, 8] 
          5^Rational[1, 2] + (-1 + Rational[1, 4] (1 + 5^Rational[1, 2]))^2)^
        Rational[1, 2]}, {
       Rational[6, 25] 
        Pi, ((-1 + Cos[Rational[216, 5] Degree])^2 + 
         Sin[Rational[216, 5] Degree]^2)^Rational[1, 2]}, {
       Rational[7, 25] 
        Pi, (Cos[Rational[198, 5] Degree]^2 + (-1 + 
           Sin[Rational[198, 5] Degree])^2)^Rational[1, 2]}, {
       Rational[8, 25] 
        Pi, (Cos[Rational[162, 5] Degree]^2 + (-1 + 
           Sin[Rational[162, 5] Degree])^2)^Rational[1, 2]}, {
       Rational[9, 25] 
        Pi, (Cos[Rational[126, 5] Degree]^2 + (-1 + 
           Sin[Rational[126, 5] Degree])^2)^Rational[1, 2]}, {
       Rational[2, 5] 
        Pi, (Rational[5, 8] + 
         Rational[1, 8] 
          5^Rational[1, 2] + (-1 + Rational[1, 4] (-1 + 5^Rational[1, 2]))^2)^
        Rational[1, 2]}, {
       Rational[11, 25] 
        Pi, (Cos[Rational[54, 5] Degree]^2 + (-1 + 
           Sin[Rational[54, 5] Degree])^2)^Rational[1, 2]}, {
       Rational[12, 25] 
        Pi, (Cos[Rational[18, 5] Degree]^2 + (-1 + 
           Sin[Rational[18, 5] Degree])^2)^Rational[1, 2]}, {
       Rational[13, 25] 
        Pi, (Cos[Rational[18, 5] Degree]^2 + (-1 - Sin[
           Rational[18, 5] Degree])^2)^Rational[1, 2]}, {
       Rational[14, 25] 
        Pi, (Cos[Rational[54, 5] Degree]^2 + (-1 - Sin[
           Rational[54, 5] Degree])^2)^Rational[1, 2]}, {
       Rational[3, 5] 
        Pi, (Rational[5, 8] + 
         Rational[1, 8] 
          5^Rational[1, 2] + (-1 + Rational[1, 4] (1 - 5^Rational[1, 2]))^2)^
        Rational[1, 2]}, {
       Rational[16, 25] 
        Pi, (Cos[Rational[126, 5] Degree]^2 + (-1 - Sin[
           Rational[126, 5] Degree])^2)^Rational[1, 2]}, {
       Rational[17, 25] 
        Pi, (Cos[Rational[162, 5] Degree]^2 + (-1 - Sin[
           Rational[162, 5] Degree])^2)^Rational[1, 2]}, {
       Rational[18, 25] 
        Pi, (Cos[Rational[198, 5] Degree]^2 + (-1 - Sin[
           Rational[198, 5] Degree])^2)^Rational[1, 2]}, {
       Rational[19, 25] 
        Pi, ((-1 - Cos[Rational[216, 5] Degree])^2 + 
         Sin[Rational[216, 5] Degree]^2)^Rational[1, 2]}, {
       Rational[4, 5] 
        Pi, (Rational[5, 8] + 
         Rational[-1, 8] 
          5^Rational[1, 2] + (-1 + Rational[1, 4] (-1 - 5^Rational[1, 2]))^2)^
        Rational[1, 2]}, {
       Rational[21, 25] 
        Pi, ((-1 - Cos[Rational[144, 5] Degree])^2 + 
         Sin[Rational[144, 5] Degree]^2)^Rational[1, 2]}, {
       Rational[22, 25] 
        Pi, ((-1 - Cos[Rational[108, 5] Degree])^2 + 
         Sin[Rational[108, 5] Degree]^2)^Rational[1, 2]}, {
       Rational[23, 25] 
        Pi, ((-1 - Cos[Rational[72, 5] Degree])^2 + 
         Sin[Rational[72, 5] Degree]^2)^Rational[1, 2]}, {
       Rational[24, 25] 
        Pi, ((-1 - Cos[Rational[36, 5] Degree])^2 + 
         Sin[Rational[36, 5] Degree]^2)^Rational[1, 2]}, {Pi, 2}, {
       Rational[26, 25] 
        Pi, ((-1 - Cos[Rational[36, 5] Degree])^2 + 
         Sin[Rational[36, 5] Degree]^2)^Rational[1, 2]}, {
       Rational[27, 25] 
        Pi, ((-1 - Cos[Rational[72, 5] Degree])^2 + 
         Sin[Rational[72, 5] Degree]^2)^Rational[1, 2]}, {
       Rational[28, 25] 
        Pi, ((-1 - Cos[Rational[108, 5] Degree])^2 + 
         Sin[Rational[108, 5] Degree]^2)^Rational[1, 2]}, {
       Rational[29, 25] 
        Pi, ((-1 - Cos[Rational[144, 5] Degree])^2 + 
         Sin[Rational[144, 5] Degree]^2)^Rational[1, 2]}, {
       Rational[6, 5] 
        Pi, (Rational[5, 8] + 
         Rational[-1, 8] 
          5^Rational[1, 2] + (-1 + Rational[1, 4] (-1 - 5^Rational[1, 2]))^2)^
        Rational[1, 2]}, {
       Rational[31, 25] 
        Pi, ((-1 - Cos[Rational[216, 5] Degree])^2 + 
         Sin[Rational[216, 5] Degree]^2)^Rational[1, 2]}, {
       Rational[32, 25] 
        Pi, (Cos[Rational[198, 5] Degree]^2 + (-1 - Sin[
           Rational[198, 5] Degree])^2)^Rational[1, 2]}, {
       Rational[33, 25] 
        Pi, (Cos[Rational[162, 5] Degree]^2 + (-1 - Sin[
           Rational[162, 5] Degree])^2)^Rational[1, 2]}, {
       Rational[34, 25] 
        Pi, (Cos[Rational[126, 5] Degree]^2 + (-1 - Sin[
           Rational[126, 5] Degree])^2)^Rational[1, 2]}, {
       Rational[7, 5] 
        Pi, (Rational[5, 8] + 
         Rational[1, 8] 
          5^Rational[1, 2] + (-1 + Rational[1, 4] (1 - 5^Rational[1, 2]))^2)^
        Rational[1, 2]}, {
       Rational[36, 25] 
        Pi, (Cos[Rational[54, 5] Degree]^2 + (-1 - Sin[
           Rational[54, 5] Degree])^2)^Rational[1, 2]}, {
       Rational[37, 25] 
        Pi, (Cos[Rational[18, 5] Degree]^2 + (-1 - Sin[
           Rational[18, 5] Degree])^2)^Rational[1, 2]}, {
       Rational[38, 25] 
        Pi, (Cos[Rational[18, 5] Degree]^2 + (-1 + 
           Sin[Rational[18, 5] Degree])^2)^Rational[1, 2]}, {
       Rational[39, 25] 
        Pi, (Cos[Rational[54, 5] Degree]^2 + (-1 + 
           Sin[Rational[54, 5] Degree])^2)^Rational[1, 2]}, {
       Rational[8, 5] 
        Pi, (Rational[5, 8] + 
         Rational[1, 8] 
          5^Rational[1, 2] + (-1 + Rational[1, 4] (-1 + 5^Rational[1, 2]))^2)^
        Rational[1, 2]}, {
       Rational[41, 25] 
        Pi, (Cos[Rational[126, 5] Degree]^2 + (-1 + 
           Sin[Rational[126, 5] Degree])^2)^Rational[1, 2]}, {
       Rational[42, 25] 
        Pi, (Cos[Rational[162, 5] Degree]^2 + (-1 + 
           Sin[Rational[162, 5] Degree])^2)^Rational[1, 2]}, {
       Rational[43, 25] 
        Pi, (Cos[Rational[198, 5] Degree]^2 + (-1 + 
           Sin[Rational[198, 5] Degree])^2)^Rational[1, 2]}, {
       Rational[44, 25] 
        Pi, ((-1 + Cos[Rational[216, 5] Degree])^2 + 
         Sin[Rational[216, 5] Degree]^2)^Rational[1, 2]}, {
       Rational[9, 5] 
        Pi, (Rational[5, 8] + 
         Rational[-1, 8] 
          5^Rational[1, 2] + (-1 + Rational[1, 4] (1 + 5^Rational[1, 2]))^2)^
        Rational[1, 2]}, {
       Rational[46, 25] 
        Pi, ((-1 + Cos[Rational[144, 5] Degree])^2 + 
         Sin[Rational[144, 5] Degree]^2)^Rational[1, 2]}, {
       Rational[47, 25] 
        Pi, ((-1 + Cos[Rational[108, 5] Degree])^2 + 
         Sin[Rational[108, 5] Degree]^2)^Rational[1, 2]}, {
       Rational[48, 25] 
        Pi, ((-1 + Cos[Rational[72, 5] Degree])^2 + 
         Sin[Rational[72, 5] Degree]^2)^Rational[1, 2]}, {
       Rational[49, 25] 
        Pi, ((-1 + Cos[Rational[36, 5] Degree])^2 + 
         Sin[Rational[36, 5] Degree]^2)^Rational[1, 2]}}}, {{{0, 0}, {
       0.12566370614359174`, 0.12558103905862678`}, {0.25132741228718347`, 
       0.2506664671286085}, {0.37699111843077515`, 0.37476262917144926`}, {
       0.5026548245743669, 0.4973797743297096}, {0.6283185307179586, 
       0.6180339887498948}, {0.7539822368615503, 0.736249105369356}, {
       0.8796459430051422, 0.8515585831301452}, {1.0053096491487339`, 
       0.9635073482034305}, {1.1309733552923256`, 1.0716535899579933`}, {
       1.2566370614359172`, 1.1755705045849463`}, {1.382300767579509, 
       1.2748479794973795`}, {1.5079644737231006`, 1.3690942118573775`}, {
       1.6336281798666925`, 1.457937254842823}, {1.7592918860102844`, 
       1.5410264855515785`}, {1.8849555921538759`, 1.618033988749895}, {
       2.0106192982974678`, 1.6886558510040304`}, {2.1362830044410597`, 
       1.7526133600877272`}, {2.261946710584651, 1.8096541049320392`}, {
       2.3876104167282426`, 1.859552971776503}, {2.5132741228718345`, 
       1.902113032590307}, {2.638937829015426, 1.9371663222572622`}, {
       2.764601535159018, 1.9645745014573772`}, {2.8902652413026098`, 
       1.9842294026289555`}, {3.015928947446201, 1.9960534568565433`}, {
       3.141592653589793, 2}, {3.267256359733385, 1.9960534568565433`}, {
       3.392920065876977, 1.9842294026289555`}, {3.518583772020569, 
       1.9645745014573772`}, {3.64424747816416, 1.9371663222572622`}, {
       3.7699111843077517`, 1.902113032590307}, {3.8955748904513436`, 
       1.859552971776503}, {4.0212385965949355`, 1.8096541049320392`}, {
       4.1469023027385274`, 1.7526133600877272`}, {4.272566008882119, 
       1.6886558510040304`}, {4.39822971502571, 1.618033988749895}, {
       4.523893421169302, 1.5410264855515785`}, {4.649557127312894, 
       1.457937254842823}, {4.775220833456485, 1.3690942118573775`}, {
       4.900884539600077, 1.2748479794973795`}, {5.026548245743669, 
       1.1755705045849463`}, {5.15221195188726, 1.0716535899579933`}, {
       5.277875658030852, 0.9635073482034305}, {5.403539364174444, 
       0.8515585831301452}, {5.529203070318036, 0.736249105369356}, {
       5.654866776461628, 0.6180339887498948}, {5.7805304826052195`, 
       0.4973797743297096}, {5.9061941887488105`, 0.37476262917144926`}, {
       6.031857894892402, 0.2506664671286085}, {6.157521601035994, 
       0.12558103905862678`}}}]], 
   {GrayLevel[0.5], 
    LineBox[NCache[{{{0, 0}, {
        Rational[1, 25] 
         Pi, (4 (-1 + Cos[Rational[36, 5] Degree])^2 + 
          2 Sin[Rational[36, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[2, 25] 
         Pi, (4 (-1 + Cos[Rational[72, 5] Degree])^2 + 
          2 Sin[Rational[72, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[3, 25] 
         Pi, (4 (-1 + Cos[Rational[108, 5] Degree])^2 + 
          2 Sin[Rational[108, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[4, 25] 
         Pi, (4 (-1 + Cos[Rational[144, 5] Degree])^2 + 
          2 Sin[Rational[144, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[1, 5] 
         Pi, (2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2]) + 
          4 (-1 + Rational[1, 4] (1 + 5^Rational[1, 2]))^2)^Rational[1, 2]}, {
        Rational[6, 25] 
         Pi, (4 (-1 + Cos[Rational[216, 5] Degree])^2 + 
          2 Sin[Rational[216, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[7, 25] 
         Pi, (2 Cos[Rational[198, 5] Degree]^2 + 
          4 (-1 + Sin[Rational[198, 5] Degree])^2)^Rational[1, 2]}, {
        Rational[8, 25] 
         Pi, (2 Cos[Rational[162, 5] Degree]^2 + 
          4 (-1 + Sin[Rational[162, 5] Degree])^2)^Rational[1, 2]}, {
        Rational[9, 25] 
         Pi, (2 Cos[Rational[126, 5] Degree]^2 + 
          4 (-1 + Sin[Rational[126, 5] Degree])^2)^Rational[1, 2]}, {
        Rational[2, 5] 
         Pi, (2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2]) + 
          4 (-1 + Rational[1, 4] (-1 + 5^Rational[1, 2]))^2)^
         Rational[1, 2]}, {
        Rational[11, 25] 
         Pi, (2 Cos[Rational[54, 5] Degree]^2 + 
          4 (-1 + Sin[Rational[54, 5] Degree])^2)^Rational[1, 2]}, {
        Rational[12, 25] 
         Pi, (2 Cos[Rational[18, 5] Degree]^2 + 
          4 (-1 + Sin[Rational[18, 5] Degree])^2)^Rational[1, 2]}, {
        Rational[13, 25] 
         Pi, (2 Cos[Rational[18, 5] Degree]^2 + 
          4 (-1 - Sin[Rational[18, 5] Degree])^2)^Rational[1, 2]}, {
        Rational[14, 25] 
         Pi, (2 Cos[Rational[54, 5] Degree]^2 + 
          4 (-1 - Sin[Rational[54, 5] Degree])^2)^Rational[1, 2]}, {
        Rational[3, 5] 
         Pi, (2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2]) + 
          4 (-1 + Rational[1, 4] (1 - 5^Rational[1, 2]))^2)^Rational[1, 2]}, {
        Rational[16, 25] 
         Pi, (2 Cos[Rational[126, 5] Degree]^2 + 
          4 (-1 - Sin[Rational[126, 5] Degree])^2)^Rational[1, 2]}, {
        Rational[17, 25] 
         Pi, (2 Cos[Rational[162, 5] Degree]^2 + 
          4 (-1 - Sin[Rational[162, 5] Degree])^2)^Rational[1, 2]}, {
        Rational[18, 25] 
         Pi, (2 Cos[Rational[198, 5] Degree]^2 + 
          4 (-1 - Sin[Rational[198, 5] Degree])^2)^Rational[1, 2]}, {
        Rational[19, 25] 
         Pi, (4 (-1 - Cos[Rational[216, 5] Degree])^2 + 
          2 Sin[Rational[216, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[4, 5] 
         Pi, (2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2]) + 
          4 (-1 + Rational[1, 4] (-1 - 5^Rational[1, 2]))^2)^
         Rational[1, 2]}, {
        Rational[21, 25] 
         Pi, (4 (-1 - Cos[Rational[144, 5] Degree])^2 + 
          2 Sin[Rational[144, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[22, 25] 
         Pi, (4 (-1 - Cos[Rational[108, 5] Degree])^2 + 
          2 Sin[Rational[108, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[23, 25] 
         Pi, (4 (-1 - Cos[Rational[72, 5] Degree])^2 + 
          2 Sin[Rational[72, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[24, 25] 
         Pi, (4 (-1 - Cos[Rational[36, 5] Degree])^2 + 
          2 Sin[Rational[36, 5] Degree]^2)^Rational[1, 2]}, {Pi, 4}, {
        Rational[26, 25] 
         Pi, (4 (-1 - Cos[Rational[36, 5] Degree])^2 + 
          2 Sin[Rational[36, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[27, 25] 
         Pi, (4 (-1 - Cos[Rational[72, 5] Degree])^2 + 
          2 Sin[Rational[72, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[28, 25] 
         Pi, (4 (-1 - Cos[Rational[108, 5] Degree])^2 + 
          2 Sin[Rational[108, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[29, 25] 
         Pi, (4 (-1 - Cos[Rational[144, 5] Degree])^2 + 
          2 Sin[Rational[144, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[6, 5] 
         Pi, (2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2]) + 
          4 (-1 + Rational[1, 4] (-1 - 5^Rational[1, 2]))^2)^
         Rational[1, 2]}, {
        Rational[31, 25] 
         Pi, (4 (-1 - Cos[Rational[216, 5] Degree])^2 + 
          2 Sin[Rational[216, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[32, 25] 
         Pi, (2 Cos[Rational[198, 5] Degree]^2 + 
          4 (-1 - Sin[Rational[198, 5] Degree])^2)^Rational[1, 2]}, {
        Rational[33, 25] 
         Pi, (2 Cos[Rational[162, 5] Degree]^2 + 
          4 (-1 - Sin[Rational[162, 5] Degree])^2)^Rational[1, 2]}, {
        Rational[34, 25] 
         Pi, (2 Cos[Rational[126, 5] Degree]^2 + 
          4 (-1 - Sin[Rational[126, 5] Degree])^2)^Rational[1, 2]}, {
        Rational[7, 5] 
         Pi, (2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2]) + 
          4 (-1 + Rational[1, 4] (1 - 5^Rational[1, 2]))^2)^Rational[1, 2]}, {
        Rational[36, 25] 
         Pi, (2 Cos[Rational[54, 5] Degree]^2 + 
          4 (-1 - Sin[Rational[54, 5] Degree])^2)^Rational[1, 2]}, {
        Rational[37, 25] 
         Pi, (2 Cos[Rational[18, 5] Degree]^2 + 
          4 (-1 - Sin[Rational[18, 5] Degree])^2)^Rational[1, 2]}, {
        Rational[38, 25] 
         Pi, (2 Cos[Rational[18, 5] Degree]^2 + 
          4 (-1 + Sin[Rational[18, 5] Degree])^2)^Rational[1, 2]}, {
        Rational[39, 25] 
         Pi, (2 Cos[Rational[54, 5] Degree]^2 + 
          4 (-1 + Sin[Rational[54, 5] Degree])^2)^Rational[1, 2]}, {
        Rational[8, 5] 
         Pi, (2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2]) + 
          4 (-1 + Rational[1, 4] (-1 + 5^Rational[1, 2]))^2)^
         Rational[1, 2]}, {
        Rational[41, 25] 
         Pi, (2 Cos[Rational[126, 5] Degree]^2 + 
          4 (-1 + Sin[Rational[126, 5] Degree])^2)^Rational[1, 2]}, {
        Rational[42, 25] 
         Pi, (2 Cos[Rational[162, 5] Degree]^2 + 
          4 (-1 + Sin[Rational[162, 5] Degree])^2)^Rational[1, 2]}, {
        Rational[43, 25] 
         Pi, (2 Cos[Rational[198, 5] Degree]^2 + 
          4 (-1 + Sin[Rational[198, 5] Degree])^2)^Rational[1, 2]}, {
        Rational[44, 25] 
         Pi, (4 (-1 + Cos[Rational[216, 5] Degree])^2 + 
          2 Sin[Rational[216, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[9, 5] 
         Pi, (2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2]) + 
          4 (-1 + Rational[1, 4] (1 + 5^Rational[1, 2]))^2)^Rational[1, 2]}, {
        Rational[46, 25] 
         Pi, (4 (-1 + Cos[Rational[144, 5] Degree])^2 + 
          2 Sin[Rational[144, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[47, 25] 
         Pi, (4 (-1 + Cos[Rational[108, 5] Degree])^2 + 
          2 Sin[Rational[108, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[48, 25] 
         Pi, (4 (-1 + Cos[Rational[72, 5] Degree])^2 + 
          2 Sin[Rational[72, 5] Degree]^2)^Rational[1, 2]}, {
        Rational[49, 25] 
         Pi, (4 (-1 + Cos[Rational[36, 5] Degree])^2 + 
          2 Sin[Rational[36, 5] Degree]^2)^Rational[1, 2]}}}, {{{0, 0}, {
        0.12566370614359174`, 0.177948168332266}, {0.25132741228718347`, 
        0.3572693535902774}, {0.37699111843077515`, 0.5392186386943614}, {
        0.5026548245743669, 0.7248264306908848}, {0.6283185307179586, 
        0.9148120240658012}, {0.7539822368615503, 1.109523095820011}, {
        0.8796459430051422, 1.3089028869342283`}, {1.0053096491487339`, 
        1.5124835035804371`}, {1.1309733552923256`, 1.7194015463906998`}, {
        1.2566370614359172`, 1.9284312408342366`}, {1.382300767579509, 
        2.1380301675668547`}, {1.5079644737231006`, 2.3463932199124287`}, {
        1.6336281798666925`, 2.5515112100322095`}, {1.7592918860102844`, 
        2.751231366279024}, {1.8849555921538759`, 2.9433176791886795`}, {
        2.0106192982974678`, 3.12550961329059}, {2.1362830044410597`, 
        3.2955781083547238`}, {2.261946710584651, 3.451378073089616}, {
        2.3876104167282426`, 3.5908967597106725`}, {2.5132741228718345`, 
        3.7122975297481915`}, {2.638937829015426, 3.8139586043020843`}, {
        2.764601535159018, 3.894506453265602}, {2.8902652413026098`, 
        3.952843529545903}, {3.015928947446201, 3.9881701031481165`}, {
        3.141592653589793, 4}, {3.267256359733385, 3.9881701031481165`}, {
        3.392920065876977, 3.952843529545903}, {3.518583772020569, 
        3.894506453265602}, {3.64424747816416, 3.8139586043020843`}, {
        3.7699111843077517`, 3.7122975297481915`}, {3.8955748904513436`, 
        3.5908967597106725`}, {4.0212385965949355`, 3.451378073089616}, {
        4.1469023027385274`, 3.2955781083547238`}, {4.272566008882119, 
        3.12550961329059}, {4.39822971502571, 2.9433176791886795`}, {
        4.523893421169302, 2.751231366279024}, {4.649557127312894, 
        2.5515112100322095`}, {4.775220833456485, 2.3463932199124287`}, {
        4.900884539600077, 2.1380301675668547`}, {5.026548245743669, 
        1.9284312408342366`}, {5.15221195188726, 1.7194015463906998`}, {
        5.277875658030852, 1.5124835035804371`}, {5.403539364174444, 
        1.3089028869342283`}, {5.529203070318036, 1.109523095820011}, {
        5.654866776461628, 0.9148120240658012}, {5.7805304826052195`, 
        0.7248264306908848}, {5.9061941887488105`, 0.5392186386943614}, {
        6.031857894892402, 0.3572693535902774}, {6.157521601035994, 
        0.177948168332266}}}]]}},
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 10},
  Ticks->{{{0, 
      FormBox["0", TraditionalForm]}, {
      NCache[Pi, 3.141592653589793], 
      FormBox["\[Pi]", TraditionalForm]}, {
      NCache[2 Pi, 6.283185307179586], 
      FormBox[
       RowBox[{"2", " ", "\[Pi]"}], TraditionalForm]}}, {{0, 
      FormBox["0", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}}}]], "Output",
 CellChangeTimes->{{3.5582743680815763`*^9, 3.5582743827300014`*^9}, 
   3.558274418594465*^9, {3.558274448920918*^9, 3.55827451848144*^9}, 
   3.5582745802887487`*^9, 3.558276097188613*^9, 3.5582761943767834`*^9, 
   3.558276309598586*^9, 3.5582763441214466`*^9, {3.55827664791798*^9, 
   3.558276676887231*^9}, 3.558276792421034*^9, 3.5582771456524544`*^9, 
   3.5587220034720054`*^9, 3.5587223438605175`*^9, 3.5587224413606887`*^9, 
   3.5590705725221615`*^9, 3.5590706959807787`*^9, 3.5590707505652742`*^9, 
   3.559070812637783*^9, 3.5590710541574078`*^9, 3.559071151610779*^9, 
   3.5590712445869417`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[
      {GrayLevel[0], Thickness[Large], 
       LineBox[NCache[{{{0, 1}, {
           Rational[1, 25] Pi, Cos[Rational[36, 5] Degree]}, {
           Rational[2, 25] Pi, Cos[Rational[72, 5] Degree]}, {
           Rational[3, 25] Pi, Cos[Rational[108, 5] Degree]}, {
           Rational[4, 25] Pi, Cos[Rational[144, 5] Degree]}, {
           Rational[1, 5] Pi, Rational[1, 4] (1 + 5^Rational[1, 2])}, {
           Rational[6, 25] Pi, Cos[Rational[216, 5] Degree]}, {
           Rational[7, 25] Pi, Sin[Rational[198, 5] Degree]}, {
           Rational[8, 25] Pi, Sin[Rational[162, 5] Degree]}, {
           Rational[9, 25] Pi, Sin[Rational[126, 5] Degree]}, {
           Rational[2, 5] Pi, Rational[1, 4] (-1 + 5^Rational[1, 2])}, {
           Rational[11, 25] Pi, Sin[Rational[54, 5] Degree]}, {
           Rational[12, 25] Pi, Sin[Rational[18, 5] Degree]}, {
           Rational[13, 25] Pi, -Sin[Rational[18, 5] Degree]}, {
           Rational[14, 25] Pi, -Sin[Rational[54, 5] Degree]}, {
           Rational[3, 5] Pi, Rational[1, 4] (1 - 5^Rational[1, 2])}, {
           Rational[16, 25] Pi, -Sin[Rational[126, 5] Degree]}, {
           Rational[17, 25] Pi, -Sin[Rational[162, 5] Degree]}, {
           Rational[18, 25] Pi, -Sin[Rational[198, 5] Degree]}, {
           Rational[19, 25] Pi, -Cos[Rational[216, 5] Degree]}, {
           Rational[4, 5] Pi, Rational[1, 4] (-1 - 5^Rational[1, 2])}, {
           Rational[21, 25] Pi, -Cos[Rational[144, 5] Degree]}, {
           Rational[22, 25] Pi, -Cos[Rational[108, 5] Degree]}, {
           Rational[23, 25] Pi, -Cos[Rational[72, 5] Degree]}, {
           Rational[24, 25] Pi, -Cos[Rational[36, 5] Degree]}, {Pi, -1}, {
           Rational[26, 25] Pi, -Cos[Rational[36, 5] Degree]}, {
           Rational[27, 25] Pi, -Cos[Rational[72, 5] Degree]}, {
           Rational[28, 25] Pi, -Cos[Rational[108, 5] Degree]}, {
           Rational[29, 25] Pi, -Cos[Rational[144, 5] Degree]}, {
           Rational[6, 5] Pi, Rational[1, 4] (-1 - 5^Rational[1, 2])}, {
           Rational[31, 25] Pi, -Cos[Rational[216, 5] Degree]}, {
           Rational[32, 25] Pi, -Sin[Rational[198, 5] Degree]}, {
           Rational[33, 25] Pi, -Sin[Rational[162, 5] Degree]}, {
           Rational[34, 25] Pi, -Sin[Rational[126, 5] Degree]}, {
           Rational[7, 5] Pi, Rational[1, 4] (1 - 5^Rational[1, 2])}, {
           Rational[36, 25] Pi, -Sin[Rational[54, 5] Degree]}, {
           Rational[37, 25] Pi, -Sin[Rational[18, 5] Degree]}, {
           Rational[38, 25] Pi, Sin[Rational[18, 5] Degree]}, {
           Rational[39, 25] Pi, Sin[Rational[54, 5] Degree]}, {
           Rational[8, 5] Pi, Rational[1, 4] (-1 + 5^Rational[1, 2])}, {
           Rational[41, 25] Pi, Sin[Rational[126, 5] Degree]}, {
           Rational[42, 25] Pi, Sin[Rational[162, 5] Degree]}, {
           Rational[43, 25] Pi, Sin[Rational[198, 5] Degree]}, {
           Rational[44, 25] Pi, Cos[Rational[216, 5] Degree]}, {
           Rational[9, 5] Pi, Rational[1, 4] (1 + 5^Rational[1, 2])}, {
           Rational[46, 25] Pi, Cos[Rational[144, 5] Degree]}, {
           Rational[47, 25] Pi, Cos[Rational[108, 5] Degree]}, {
           Rational[48, 25] Pi, Cos[Rational[72, 5] Degree]}, {
           Rational[49, 25] Pi, Cos[Rational[36, 5] Degree]}}}, {{{0, 1}, {
           0.12566370614359174`, 0.9921147013144779}, {0.25132741228718347`, 
           0.9685831611286311}, {0.37699111843077515`, 0.9297764858882515}, {
           0.5026548245743669, 0.8763066800438636}, {0.6283185307179586, 
           0.8090169943749475}, {0.7539822368615503, 0.7289686274214116}, {
           0.8796459430051422, 0.6374239897486897}, {1.0053096491487339`, 
           0.5358267949789967}, {1.1309733552923256`, 0.42577929156507266`}, {
           1.2566370614359172`, 0.30901699437494745`}, {1.382300767579509, 
           0.18738131458572463`}, {1.5079644737231006`, 
           0.06279051952931337}, {
           1.6336281798666925`, -0.06279051952931337}, {
           1.7592918860102844`, -0.18738131458572463`}, {
           1.8849555921538759`, -0.30901699437494745`}, {
           2.0106192982974678`, -0.42577929156507266`}, {
           2.1362830044410597`, -0.5358267949789967}, {
           2.261946710584651, -0.6374239897486897}, {
           2.3876104167282426`, -0.7289686274214116}, {
           2.5132741228718345`, -0.8090169943749475}, {
           2.638937829015426, -0.8763066800438636}, {
           2.764601535159018, -0.9297764858882515}, {
           2.8902652413026098`, -0.9685831611286311}, {
           3.015928947446201, -0.9921147013144779}, {3.141592653589793, -1}, {
           3.267256359733385, -0.9921147013144779}, {
           3.392920065876977, -0.9685831611286311}, {
           3.518583772020569, -0.9297764858882515}, {
           3.64424747816416, -0.8763066800438636}, {
           3.7699111843077517`, -0.8090169943749475}, {
           3.8955748904513436`, -0.7289686274214116}, {
           4.0212385965949355`, -0.6374239897486897}, {
           4.1469023027385274`, -0.5358267949789967}, {
           4.272566008882119, -0.42577929156507266`}, {
           4.39822971502571, -0.30901699437494745`}, {
           4.523893421169302, -0.18738131458572463`}, {
           4.649557127312894, -0.06279051952931337}, {4.775220833456485, 
           0.06279051952931337}, {4.900884539600077, 0.18738131458572463`}, {
           5.026548245743669, 0.30901699437494745`}, {5.15221195188726, 
           0.42577929156507266`}, {5.277875658030852, 0.5358267949789967}, {
           5.403539364174444, 0.6374239897486897}, {5.529203070318036, 
           0.7289686274214116}, {5.654866776461628, 0.8090169943749475}, {
           5.7805304826052195`, 0.8763066800438636}, {5.9061941887488105`, 
           0.9297764858882515}, {6.031857894892402, 0.9685831611286311}, {
           6.157521601035994, 0.9921147013144779}}}]], 
       {GrayLevel[0.5], 
        LineBox[NCache[{{{0, 4}, {
            Rational[1, 25] Pi, 4 Cos[Rational[36, 5] Degree]}, {
            Rational[2, 25] Pi, 4 Cos[Rational[72, 5] Degree]}, {
            Rational[3, 25] Pi, 4 Cos[Rational[108, 5] Degree]}, {
            Rational[4, 25] Pi, 4 Cos[Rational[144, 5] Degree]}, {
            Rational[1, 5] Pi, 1 + 5^Rational[1, 2]}, {
            Rational[6, 25] Pi, 4 Cos[Rational[216, 5] Degree]}, {
            Rational[7, 25] Pi, 4 Sin[Rational[198, 5] Degree]}, {
            Rational[8, 25] Pi, 4 Sin[Rational[162, 5] Degree]}, {
            Rational[9, 25] Pi, 4 Sin[Rational[126, 5] Degree]}, {
            Rational[2, 5] Pi, -1 + 5^Rational[1, 2]}, {
            Rational[11, 25] Pi, 4 Sin[Rational[54, 5] Degree]}, {
            Rational[12, 25] Pi, 4 Sin[Rational[18, 5] Degree]}, {
            Rational[13, 25] Pi, (-4) Sin[Rational[18, 5] Degree]}, {
            Rational[14, 25] Pi, (-4) Sin[Rational[54, 5] Degree]}, {
            Rational[3, 5] Pi, 1 - 5^Rational[1, 2]}, {
            Rational[16, 25] Pi, (-4) Sin[Rational[126, 5] Degree]}, {
            Rational[17, 25] Pi, (-4) Sin[Rational[162, 5] Degree]}, {
            Rational[18, 25] Pi, (-4) Sin[Rational[198, 5] Degree]}, {
            Rational[19, 25] Pi, (-4) Cos[Rational[216, 5] Degree]}, {
            Rational[4, 5] Pi, -1 - 5^Rational[1, 2]}, {
            Rational[21, 25] Pi, (-4) Cos[Rational[144, 5] Degree]}, {
            Rational[22, 25] Pi, (-4) Cos[Rational[108, 5] Degree]}, {
            Rational[23, 25] Pi, (-4) Cos[Rational[72, 5] Degree]}, {
            Rational[24, 25] Pi, (-4) Cos[Rational[36, 5] Degree]}, {
            Pi, -4}, {
            Rational[26, 25] Pi, (-4) Cos[Rational[36, 5] Degree]}, {
            Rational[27, 25] Pi, (-4) Cos[Rational[72, 5] Degree]}, {
            Rational[28, 25] Pi, (-4) Cos[Rational[108, 5] Degree]}, {
            Rational[29, 25] Pi, (-4) Cos[Rational[144, 5] Degree]}, {
            Rational[6, 5] Pi, -1 - 5^Rational[1, 2]}, {
            Rational[31, 25] Pi, (-4) Cos[Rational[216, 5] Degree]}, {
            Rational[32, 25] Pi, (-4) Sin[Rational[198, 5] Degree]}, {
            Rational[33, 25] Pi, (-4) Sin[Rational[162, 5] Degree]}, {
            Rational[34, 25] Pi, (-4) Sin[Rational[126, 5] Degree]}, {
            Rational[7, 5] Pi, 1 - 5^Rational[1, 2]}, {
            Rational[36, 25] Pi, (-4) Sin[Rational[54, 5] Degree]}, {
            Rational[37, 25] Pi, (-4) Sin[Rational[18, 5] Degree]}, {
            Rational[38, 25] Pi, 4 Sin[Rational[18, 5] Degree]}, {
            Rational[39, 25] Pi, 4 Sin[Rational[54, 5] Degree]}, {
            Rational[8, 5] Pi, -1 + 5^Rational[1, 2]}, {
            Rational[41, 25] Pi, 4 Sin[Rational[126, 5] Degree]}, {
            Rational[42, 25] Pi, 4 Sin[Rational[162, 5] Degree]}, {
            Rational[43, 25] Pi, 4 Sin[Rational[198, 5] Degree]}, {
            Rational[44, 25] Pi, 4 Cos[Rational[216, 5] Degree]}, {
            Rational[9, 5] Pi, 1 + 5^Rational[1, 2]}, {
            Rational[46, 25] Pi, 4 Cos[Rational[144, 5] Degree]}, {
            Rational[47, 25] Pi, 4 Cos[Rational[108, 5] Degree]}, {
            Rational[48, 25] Pi, 4 Cos[Rational[72, 5] Degree]}, {
            Rational[49, 25] Pi, 4 Cos[Rational[36, 5] Degree]}}}, {{{0, 4}, {
            0.12566370614359174`, 3.9684588052579115`}, {0.25132741228718347`,
             3.8743326445145243`}, {0.37699111843077515`, 
            3.719105943553006}, {0.5026548245743669, 3.5052267201754543`}, {
            0.6283185307179586, 3.23606797749979}, {0.7539822368615503, 
            2.915874509685646}, {0.8796459430051422, 2.549695958994759}, {
            1.0053096491487339`, 2.1433071799159866`}, {1.1309733552923256`, 
            1.7031171662602906`}, {1.2566370614359172`, 
            1.2360679774997898`}, {1.382300767579509, 0.7495252583428985}, {
            1.5079644737231006`, 0.2511620781172535}, {
            1.6336281798666925`, -0.2511620781172535}, {
            1.7592918860102844`, -0.7495252583428985}, {
            1.8849555921538759`, -1.2360679774997898`}, {
            2.0106192982974678`, -1.7031171662602906`}, {
            2.1362830044410597`, -2.1433071799159866`}, {
            2.261946710584651, -2.549695958994759}, {
            2.3876104167282426`, -2.915874509685646}, {
            2.5132741228718345`, -3.23606797749979}, {
            2.638937829015426, -3.5052267201754543`}, {
            2.764601535159018, -3.719105943553006}, {
            2.8902652413026098`, -3.8743326445145243`}, {
            3.015928947446201, -3.9684588052579115`}, {
            3.141592653589793, -4}, {
            3.267256359733385, -3.9684588052579115`}, {
            3.392920065876977, -3.8743326445145243`}, {
            3.518583772020569, -3.719105943553006}, {
            3.64424747816416, -3.5052267201754543`}, {
            3.7699111843077517`, -3.23606797749979}, {
            3.8955748904513436`, -2.915874509685646}, {
            4.0212385965949355`, -2.549695958994759}, {
            4.1469023027385274`, -2.1433071799159866`}, {
            4.272566008882119, -1.7031171662602906`}, {
            4.39822971502571, -1.2360679774997898`}, {
            4.523893421169302, -0.7495252583428985}, {
            4.649557127312894, -0.2511620781172535}, {4.775220833456485, 
            0.2511620781172535}, {4.900884539600077, 0.7495252583428985}, {
            5.026548245743669, 1.2360679774997898`}, {5.15221195188726, 
            1.7031171662602906`}, {5.277875658030852, 2.1433071799159866`}, {
            5.403539364174444, 2.549695958994759}, {5.529203070318036, 
            2.915874509685646}, {5.654866776461628, 3.23606797749979}, {
            5.7805304826052195`, 3.5052267201754543`}, {5.9061941887488105`, 
            3.719105943553006}, {6.031857894892402, 3.8743326445145243`}, {
            6.157521601035994, 3.9684588052579115`}}}]]}},
      Axes->True,
      BaseStyle->{FontFamily -> "Helvetica", FontSize -> 10},
      Ticks->{{{0, 
          FormBox["0", TraditionalForm]}, {
          NCache[Pi, 3.141592653589793], 
          FormBox["\[Pi]", TraditionalForm]}, {
          NCache[2 Pi, 6.283185307179586], 
          FormBox[
           RowBox[{"2", " ", "\[Pi]"}], TraditionalForm]}}, {{-4, 
          FormBox[
           RowBox[{"-", "4"}], TraditionalForm]}, {-2, 
          FormBox[
           RowBox[{"-", "2"}], TraditionalForm]}, {0, 
          FormBox["0", TraditionalForm]}, {2, 
          FormBox["2", TraditionalForm]}, {4, 
          FormBox["4", TraditionalForm]}}}], {193.5, -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[
      {GrayLevel[0], Thickness[Large], 
       LineBox[NCache[{{{0, 1}, {
           Rational[1, 25] 
            Pi, (Cos[Rational[36, 5] Degree]^2 + 
             Sin[Rational[36, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[2, 25] 
            Pi, (Cos[Rational[72, 5] Degree]^2 + 
             Sin[Rational[72, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[3, 25] 
            Pi, (Cos[Rational[108, 5] Degree]^2 + 
             Sin[Rational[108, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[4, 25] 
            Pi, (Cos[Rational[144, 5] Degree]^2 + 
             Sin[Rational[144, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[1, 5] 
            Pi, (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2] + 
             Rational[1, 16] (1 + 5^Rational[1, 2])^2)^Rational[1, 2]}, {
           Rational[6, 25] 
            Pi, (Cos[Rational[216, 5] Degree]^2 + 
             Sin[Rational[216, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[7, 25] 
            Pi, (Cos[Rational[198, 5] Degree]^2 + 
             Sin[Rational[198, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[8, 25] 
            Pi, (Cos[Rational[162, 5] Degree]^2 + 
             Sin[Rational[162, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[9, 25] 
            Pi, (Cos[Rational[126, 5] Degree]^2 + 
             Sin[Rational[126, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[2, 5] 
            Pi, (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2] + 
             Rational[1, 16] (-1 + 5^Rational[1, 2])^2)^Rational[1, 2]}, {
           Rational[11, 25] 
            Pi, (Cos[Rational[54, 5] Degree]^2 + 
             Sin[Rational[54, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[12, 25] 
            Pi, (Cos[Rational[18, 5] Degree]^2 + 
             Sin[Rational[18, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[13, 25] 
            Pi, (Cos[Rational[18, 5] Degree]^2 + 
             Sin[Rational[18, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[14, 25] 
            Pi, (Cos[Rational[54, 5] Degree]^2 + 
             Sin[Rational[54, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[3, 5] 
            Pi, (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2] + 
             Rational[1, 16] (1 - 5^Rational[1, 2])^2)^Rational[1, 2]}, {
           Rational[16, 25] 
            Pi, (Cos[Rational[126, 5] Degree]^2 + 
             Sin[Rational[126, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[17, 25] 
            Pi, (Cos[Rational[162, 5] Degree]^2 + 
             Sin[Rational[162, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[18, 25] 
            Pi, (Cos[Rational[198, 5] Degree]^2 + 
             Sin[Rational[198, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[19, 25] 
            Pi, (Cos[Rational[216, 5] Degree]^2 + 
             Sin[Rational[216, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[4, 5] 
            Pi, (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2] + 
             Rational[1, 16] (-1 - 5^Rational[1, 2])^2)^Rational[1, 2]}, {
           Rational[21, 25] 
            Pi, (Cos[Rational[144, 5] Degree]^2 + 
             Sin[Rational[144, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[22, 25] 
            Pi, (Cos[Rational[108, 5] Degree]^2 + 
             Sin[Rational[108, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[23, 25] 
            Pi, (Cos[Rational[72, 5] Degree]^2 + 
             Sin[Rational[72, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[24, 25] 
            Pi, (Cos[Rational[36, 5] Degree]^2 + 
             Sin[Rational[36, 5] Degree]^2)^Rational[1, 2]}, {Pi, 1}, {
           Rational[26, 25] 
            Pi, (Cos[Rational[36, 5] Degree]^2 + 
             Sin[Rational[36, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[27, 25] 
            Pi, (Cos[Rational[72, 5] Degree]^2 + 
             Sin[Rational[72, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[28, 25] 
            Pi, (Cos[Rational[108, 5] Degree]^2 + 
             Sin[Rational[108, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[29, 25] 
            Pi, (Cos[Rational[144, 5] Degree]^2 + 
             Sin[Rational[144, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[6, 5] 
            Pi, (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2] + 
             Rational[1, 16] (-1 - 5^Rational[1, 2])^2)^Rational[1, 2]}, {
           Rational[31, 25] 
            Pi, (Cos[Rational[216, 5] Degree]^2 + 
             Sin[Rational[216, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[32, 25] 
            Pi, (Cos[Rational[198, 5] Degree]^2 + 
             Sin[Rational[198, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[33, 25] 
            Pi, (Cos[Rational[162, 5] Degree]^2 + 
             Sin[Rational[162, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[34, 25] 
            Pi, (Cos[Rational[126, 5] Degree]^2 + 
             Sin[Rational[126, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[7, 5] 
            Pi, (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2] + 
             Rational[1, 16] (1 - 5^Rational[1, 2])^2)^Rational[1, 2]}, {
           Rational[36, 25] 
            Pi, (Cos[Rational[54, 5] Degree]^2 + 
             Sin[Rational[54, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[37, 25] 
            Pi, (Cos[Rational[18, 5] Degree]^2 + 
             Sin[Rational[18, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[38, 25] 
            Pi, (Cos[Rational[18, 5] Degree]^2 + 
             Sin[Rational[18, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[39, 25] 
            Pi, (Cos[Rational[54, 5] Degree]^2 + 
             Sin[Rational[54, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[8, 5] 
            Pi, (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2] + 
             Rational[1, 16] (-1 + 5^Rational[1, 2])^2)^Rational[1, 2]}, {
           Rational[41, 25] 
            Pi, (Cos[Rational[126, 5] Degree]^2 + 
             Sin[Rational[126, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[42, 25] 
            Pi, (Cos[Rational[162, 5] Degree]^2 + 
             Sin[Rational[162, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[43, 25] 
            Pi, (Cos[Rational[198, 5] Degree]^2 + 
             Sin[Rational[198, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[44, 25] 
            Pi, (Cos[Rational[216, 5] Degree]^2 + 
             Sin[Rational[216, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[9, 5] 
            Pi, (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2] + 
             Rational[1, 16] (1 + 5^Rational[1, 2])^2)^Rational[1, 2]}, {
           Rational[46, 25] 
            Pi, (Cos[Rational[144, 5] Degree]^2 + 
             Sin[Rational[144, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[47, 25] 
            Pi, (Cos[Rational[108, 5] Degree]^2 + 
             Sin[Rational[108, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[48, 25] 
            Pi, (Cos[Rational[72, 5] Degree]^2 + 
             Sin[Rational[72, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[49, 25] 
            Pi, (Cos[Rational[36, 5] Degree]^2 + 
             Sin[Rational[36, 5] Degree]^2)^Rational[1, 2]}}}, {{{0, 1}, {
           0.12566370614359174`, 1.}, {0.25132741228718347`, 1.}, {
           0.37699111843077515`, 1.}, {0.5026548245743669, 1.}, {
           0.6283185307179586, 1.}, {0.7539822368615503, 1.}, {
           0.8796459430051422, 1.}, {1.0053096491487339`, 1.}, {
           1.1309733552923256`, 1.}, {1.2566370614359172`, 1.}, {
           1.382300767579509, 1.}, {1.5079644737231006`, 1.}, {
           1.6336281798666925`, 1.}, {1.7592918860102844`, 1.}, {
           1.8849555921538759`, 1.}, {2.0106192982974678`, 1.}, {
           2.1362830044410597`, 1.}, {2.261946710584651, 1.}, {
           2.3876104167282426`, 1.}, {2.5132741228718345`, 1.}, {
           2.638937829015426, 1.}, {2.764601535159018, 1.}, {
           2.8902652413026098`, 1.}, {3.015928947446201, 1.}, {
           3.141592653589793, 1}, {3.267256359733385, 1.}, {3.392920065876977,
            1.}, {3.518583772020569, 1.}, {3.64424747816416, 1.}, {
           3.7699111843077517`, 1.}, {3.8955748904513436`, 1.}, {
           4.0212385965949355`, 1.}, {4.1469023027385274`, 1.}, {
           4.272566008882119, 1.}, {4.39822971502571, 1.}, {4.523893421169302,
            1.}, {4.649557127312894, 1.}, {4.775220833456485, 1.}, {
           4.900884539600077, 1.}, {5.026548245743669, 1.}, {5.15221195188726,
            1.}, {5.277875658030852, 1.}, {5.403539364174444, 1.}, {
           5.529203070318036, 1.}, {5.654866776461628, 1.}, {
           5.7805304826052195`, 1.}, {5.9061941887488105`, 1.}, {
           6.031857894892402, 1.}, {6.157521601035994, 1.}}}]], 
       {GrayLevel[0.5], 
        LineBox[NCache[{{{0, 2}, {
            Rational[1, 25] 
             Pi, (4 Cos[Rational[36, 5] Degree]^2 + 
              2 Sin[Rational[36, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[2, 25] 
             Pi, (4 Cos[Rational[72, 5] Degree]^2 + 
              2 Sin[Rational[72, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[3, 25] 
             Pi, (4 Cos[Rational[108, 5] Degree]^2 + 
              2 Sin[Rational[108, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[4, 25] 
             Pi, (4 Cos[Rational[144, 5] Degree]^2 + 
              2 Sin[Rational[144, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[1, 5] 
             Pi, (2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2])^2)^Rational[1, 2]}, {
            Rational[6, 25] 
             Pi, (4 Cos[Rational[216, 5] Degree]^2 + 
              2 Sin[Rational[216, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[7, 25] 
             Pi, (2 Cos[Rational[198, 5] Degree]^2 + 
              4 Sin[Rational[198, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[8, 25] 
             Pi, (2 Cos[Rational[162, 5] Degree]^2 + 
              4 Sin[Rational[162, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[9, 25] 
             Pi, (2 Cos[Rational[126, 5] Degree]^2 + 
              4 Sin[Rational[126, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[2, 5] 
             Pi, (2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2]) + 
              Rational[1, 4] (-1 + 5^Rational[1, 2])^2)^Rational[1, 2]}, {
            Rational[11, 25] 
             Pi, (2 Cos[Rational[54, 5] Degree]^2 + 
              4 Sin[Rational[54, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[12, 25] 
             Pi, (2 Cos[Rational[18, 5] Degree]^2 + 
              4 Sin[Rational[18, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[13, 25] 
             Pi, (2 Cos[Rational[18, 5] Degree]^2 + 
              4 Sin[Rational[18, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[14, 25] 
             Pi, (2 Cos[Rational[54, 5] Degree]^2 + 
              4 Sin[Rational[54, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[3, 5] 
             Pi, (Rational[1, 4] (1 - 5^Rational[1, 2])^2 + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2]))^
             Rational[1, 2]}, {
            Rational[16, 25] 
             Pi, (2 Cos[Rational[126, 5] Degree]^2 + 
              4 Sin[Rational[126, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[17, 25] 
             Pi, (2 Cos[Rational[162, 5] Degree]^2 + 
              4 Sin[Rational[162, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[18, 25] 
             Pi, (2 Cos[Rational[198, 5] Degree]^2 + 
              4 Sin[Rational[198, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[19, 25] 
             Pi, (4 Cos[Rational[216, 5] Degree]^2 + 
              2 Sin[Rational[216, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[4, 5] 
             Pi, (Rational[1, 4] (-1 - 5^Rational[1, 2])^2 + 
              2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2]))^
             Rational[1, 2]}, {
            Rational[21, 25] 
             Pi, (4 Cos[Rational[144, 5] Degree]^2 + 
              2 Sin[Rational[144, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[22, 25] 
             Pi, (4 Cos[Rational[108, 5] Degree]^2 + 
              2 Sin[Rational[108, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[23, 25] 
             Pi, (4 Cos[Rational[72, 5] Degree]^2 + 
              2 Sin[Rational[72, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[24, 25] 
             Pi, (4 Cos[Rational[36, 5] Degree]^2 + 
              2 Sin[Rational[36, 5] Degree]^2)^Rational[1, 2]}, {Pi, 2}, {
            Rational[26, 25] 
             Pi, (4 Cos[Rational[36, 5] Degree]^2 + 
              2 Sin[Rational[36, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[27, 25] 
             Pi, (4 Cos[Rational[72, 5] Degree]^2 + 
              2 Sin[Rational[72, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[28, 25] 
             Pi, (4 Cos[Rational[108, 5] Degree]^2 + 
              2 Sin[Rational[108, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[29, 25] 
             Pi, (4 Cos[Rational[144, 5] Degree]^2 + 
              2 Sin[Rational[144, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[6, 5] 
             Pi, (Rational[1, 4] (-1 - 5^Rational[1, 2])^2 + 
              2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2]))^
             Rational[1, 2]}, {
            Rational[31, 25] 
             Pi, (4 Cos[Rational[216, 5] Degree]^2 + 
              2 Sin[Rational[216, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[32, 25] 
             Pi, (2 Cos[Rational[198, 5] Degree]^2 + 
              4 Sin[Rational[198, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[33, 25] 
             Pi, (2 Cos[Rational[162, 5] Degree]^2 + 
              4 Sin[Rational[162, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[34, 25] 
             Pi, (2 Cos[Rational[126, 5] Degree]^2 + 
              4 Sin[Rational[126, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[7, 5] 
             Pi, (Rational[1, 4] (1 - 5^Rational[1, 2])^2 + 
              2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2]))^
             Rational[1, 2]}, {
            Rational[36, 25] 
             Pi, (2 Cos[Rational[54, 5] Degree]^2 + 
              4 Sin[Rational[54, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[37, 25] 
             Pi, (2 Cos[Rational[18, 5] Degree]^2 + 
              4 Sin[Rational[18, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[38, 25] 
             Pi, (2 Cos[Rational[18, 5] Degree]^2 + 
              4 Sin[Rational[18, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[39, 25] 
             Pi, (2 Cos[Rational[54, 5] Degree]^2 + 
              4 Sin[Rational[54, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[8, 5] 
             Pi, (2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2]) + 
              Rational[1, 4] (-1 + 5^Rational[1, 2])^2)^Rational[1, 2]}, {
            Rational[41, 25] 
             Pi, (2 Cos[Rational[126, 5] Degree]^2 + 
              4 Sin[Rational[126, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[42, 25] 
             Pi, (2 Cos[Rational[162, 5] Degree]^2 + 
              4 Sin[Rational[162, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[43, 25] 
             Pi, (2 Cos[Rational[198, 5] Degree]^2 + 
              4 Sin[Rational[198, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[44, 25] 
             Pi, (4 Cos[Rational[216, 5] Degree]^2 + 
              2 Sin[Rational[216, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[9, 5] 
             Pi, (2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2]) + 
              Rational[1, 4] (1 + 5^Rational[1, 2])^2)^Rational[1, 2]}, {
            Rational[46, 25] 
             Pi, (4 Cos[Rational[144, 5] Degree]^2 + 
              2 Sin[Rational[144, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[47, 25] 
             Pi, (4 Cos[Rational[108, 5] Degree]^2 + 
              2 Sin[Rational[108, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[48, 25] 
             Pi, (4 Cos[Rational[72, 5] Degree]^2 + 
              2 Sin[Rational[72, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[49, 25] 
             Pi, (4 Cos[Rational[36, 5] Degree]^2 + 
              2 Sin[Rational[36, 5] Degree]^2)^Rational[1, 2]}}}, {{{0, 2}, {
            0.12566370614359174`, 1.9921303072662269`}, {0.25132741228718347`,
             1.968833837591142}, {0.37699111843077515`, 
            1.9310537608832676`}, {0.5026548245743669, 1.8803794284609148`}, {
            0.6283185307179586, 1.8190703654270628`}, {0.7539822368615503, 
            1.7500830036113468`}, {0.8796459430051422, 1.6770863679054442`}, {
            1.0053096491487339`, 1.6044378169424103`}, {1.1309733552923256`, 
            1.5370673408316602`}, {1.2566370614359172`, 1.480196948255553}, {
            1.382300767579509, 1.4388271314205014`}, {1.5079644737231006`, 
            1.4169986939604151`}, {1.6336281798666925`, 
            1.4169986939604151`}, {1.7592918860102844`, 
            1.4388271314205014`}, {1.8849555921538759`, 1.480196948255553}, {
            2.0106192982974678`, 1.5370673408316602`}, {2.1362830044410597`, 
            1.6044378169424103`}, {2.261946710584651, 1.6770863679054442`}, {
            2.3876104167282426`, 1.7500830036113468`}, {2.5132741228718345`, 
            1.8190703654270628`}, {2.638937829015426, 1.8803794284609148`}, {
            2.764601535159018, 1.9310537608832676`}, {2.8902652413026098`, 
            1.968833837591142}, {3.015928947446201, 1.9921303072662269`}, {
            3.141592653589793, 2}, {3.267256359733385, 1.9921303072662269`}, {
            3.392920065876977, 1.968833837591142}, {3.518583772020569, 
            1.9310537608832676`}, {3.64424747816416, 1.8803794284609148`}, {
            3.7699111843077517`, 1.8190703654270628`}, {3.8955748904513436`, 
            1.7500830036113468`}, {4.0212385965949355`, 
            1.6770863679054442`}, {4.1469023027385274`, 
            1.6044378169424103`}, {4.272566008882119, 1.5370673408316602`}, {
            4.39822971502571, 1.480196948255553}, {4.523893421169302, 
            1.4388271314205014`}, {4.649557127312894, 1.4169986939604151`}, {
            4.775220833456485, 1.4169986939604151`}, {4.900884539600077, 
            1.4388271314205014`}, {5.026548245743669, 1.480196948255553}, {
            5.15221195188726, 1.5370673408316602`}, {5.277875658030852, 
            1.6044378169424103`}, {5.403539364174444, 1.6770863679054442`}, {
            5.529203070318036, 1.7500830036113468`}, {5.654866776461628, 
            1.8190703654270628`}, {5.7805304826052195`, 
            1.8803794284609148`}, {5.9061941887488105`, 
            1.9310537608832676`}, {6.031857894892402, 1.968833837591142}, {
            6.157521601035994, 1.9921303072662269`}}}]]}},
      Axes->True,
      AxesOrigin->{0, 0},
      BaseStyle->{FontFamily -> "Helvetica", FontSize -> 10},
      Ticks->{{{0, 
          FormBox["0", TraditionalForm]}, {
          NCache[Pi, 3.141592653589793], 
          FormBox["\[Pi]", TraditionalForm]}, {
          NCache[2 Pi, 6.283185307179586], 
          FormBox[
           RowBox[{"2", " ", "\[Pi]"}], TraditionalForm]}}, {{0, 
          FormBox["0", TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}, {2, 
          FormBox["2", TraditionalForm]}}}], {580.5, -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[
      {GrayLevel[0], Thickness[Large], 
       LineBox[NCache[{{{0, 0}, {
           Rational[1, 25] 
            Pi, ((-1 + Cos[Rational[36, 5] Degree])^2 + 
             Sin[Rational[36, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[2, 25] 
            Pi, ((-1 + Cos[Rational[72, 5] Degree])^2 + 
             Sin[Rational[72, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[3, 25] 
            Pi, ((-1 + Cos[Rational[108, 5] Degree])^2 + 
             Sin[Rational[108, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[4, 25] 
            Pi, ((-1 + Cos[Rational[144, 5] Degree])^2 + 
             Sin[Rational[144, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[1, 5] 
            Pi, (Rational[5, 8] + 
             Rational[-1, 8] 
              5^Rational[1, 2] + (-1 + 
               Rational[1, 4] (1 + 5^Rational[1, 2]))^2)^Rational[1, 2]}, {
           Rational[6, 25] 
            Pi, ((-1 + Cos[Rational[216, 5] Degree])^2 + 
             Sin[Rational[216, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[7, 25] 
            Pi, (Cos[Rational[198, 5] Degree]^2 + (-1 + 
               Sin[Rational[198, 5] Degree])^2)^Rational[1, 2]}, {
           Rational[8, 25] 
            Pi, (Cos[Rational[162, 5] Degree]^2 + (-1 + 
               Sin[Rational[162, 5] Degree])^2)^Rational[1, 2]}, {
           Rational[9, 25] 
            Pi, (Cos[Rational[126, 5] Degree]^2 + (-1 + 
               Sin[Rational[126, 5] Degree])^2)^Rational[1, 2]}, {
           Rational[2, 5] 
            Pi, (Rational[5, 8] + 
             Rational[1, 8] 
              5^Rational[1, 2] + (-1 + 
               Rational[1, 4] (-1 + 5^Rational[1, 2]))^2)^Rational[1, 2]}, {
           Rational[11, 25] 
            Pi, (Cos[Rational[54, 5] Degree]^2 + (-1 + 
               Sin[Rational[54, 5] Degree])^2)^Rational[1, 2]}, {
           Rational[12, 25] 
            Pi, (Cos[Rational[18, 5] Degree]^2 + (-1 + 
               Sin[Rational[18, 5] Degree])^2)^Rational[1, 2]}, {
           Rational[13, 25] 
            Pi, (Cos[Rational[18, 5] Degree]^2 + (-1 - Sin[
               Rational[18, 5] Degree])^2)^Rational[1, 2]}, {
           Rational[14, 25] 
            Pi, (Cos[Rational[54, 5] Degree]^2 + (-1 - Sin[
               Rational[54, 5] Degree])^2)^Rational[1, 2]}, {
           Rational[3, 5] 
            Pi, (Rational[5, 8] + 
             Rational[1, 8] 
              5^Rational[1, 2] + (-1 + 
               Rational[1, 4] (1 - 5^Rational[1, 2]))^2)^Rational[1, 2]}, {
           Rational[16, 25] 
            Pi, (Cos[Rational[126, 5] Degree]^2 + (-1 - Sin[
               Rational[126, 5] Degree])^2)^Rational[1, 2]}, {
           Rational[17, 25] 
            Pi, (Cos[Rational[162, 5] Degree]^2 + (-1 - Sin[
               Rational[162, 5] Degree])^2)^Rational[1, 2]}, {
           Rational[18, 25] 
            Pi, (Cos[Rational[198, 5] Degree]^2 + (-1 - Sin[
               Rational[198, 5] Degree])^2)^Rational[1, 2]}, {
           Rational[19, 25] 
            Pi, ((-1 - Cos[Rational[216, 5] Degree])^2 + 
             Sin[Rational[216, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[4, 5] 
            Pi, (Rational[5, 8] + 
             Rational[-1, 8] 
              5^Rational[1, 2] + (-1 + 
               Rational[1, 4] (-1 - 5^Rational[1, 2]))^2)^Rational[1, 2]}, {
           Rational[21, 25] 
            Pi, ((-1 - Cos[Rational[144, 5] Degree])^2 + 
             Sin[Rational[144, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[22, 25] 
            Pi, ((-1 - Cos[Rational[108, 5] Degree])^2 + 
             Sin[Rational[108, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[23, 25] 
            Pi, ((-1 - Cos[Rational[72, 5] Degree])^2 + 
             Sin[Rational[72, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[24, 25] 
            Pi, ((-1 - Cos[Rational[36, 5] Degree])^2 + 
             Sin[Rational[36, 5] Degree]^2)^Rational[1, 2]}, {Pi, 2}, {
           Rational[26, 25] 
            Pi, ((-1 - Cos[Rational[36, 5] Degree])^2 + 
             Sin[Rational[36, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[27, 25] 
            Pi, ((-1 - Cos[Rational[72, 5] Degree])^2 + 
             Sin[Rational[72, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[28, 25] 
            Pi, ((-1 - Cos[Rational[108, 5] Degree])^2 + 
             Sin[Rational[108, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[29, 25] 
            Pi, ((-1 - Cos[Rational[144, 5] Degree])^2 + 
             Sin[Rational[144, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[6, 5] 
            Pi, (Rational[5, 8] + 
             Rational[-1, 8] 
              5^Rational[1, 2] + (-1 + 
               Rational[1, 4] (-1 - 5^Rational[1, 2]))^2)^Rational[1, 2]}, {
           Rational[31, 25] 
            Pi, ((-1 - Cos[Rational[216, 5] Degree])^2 + 
             Sin[Rational[216, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[32, 25] 
            Pi, (Cos[Rational[198, 5] Degree]^2 + (-1 - Sin[
               Rational[198, 5] Degree])^2)^Rational[1, 2]}, {
           Rational[33, 25] 
            Pi, (Cos[Rational[162, 5] Degree]^2 + (-1 - Sin[
               Rational[162, 5] Degree])^2)^Rational[1, 2]}, {
           Rational[34, 25] 
            Pi, (Cos[Rational[126, 5] Degree]^2 + (-1 - Sin[
               Rational[126, 5] Degree])^2)^Rational[1, 2]}, {
           Rational[7, 5] 
            Pi, (Rational[5, 8] + 
             Rational[1, 8] 
              5^Rational[1, 2] + (-1 + 
               Rational[1, 4] (1 - 5^Rational[1, 2]))^2)^Rational[1, 2]}, {
           Rational[36, 25] 
            Pi, (Cos[Rational[54, 5] Degree]^2 + (-1 - Sin[
               Rational[54, 5] Degree])^2)^Rational[1, 2]}, {
           Rational[37, 25] 
            Pi, (Cos[Rational[18, 5] Degree]^2 + (-1 - Sin[
               Rational[18, 5] Degree])^2)^Rational[1, 2]}, {
           Rational[38, 25] 
            Pi, (Cos[Rational[18, 5] Degree]^2 + (-1 + 
               Sin[Rational[18, 5] Degree])^2)^Rational[1, 2]}, {
           Rational[39, 25] 
            Pi, (Cos[Rational[54, 5] Degree]^2 + (-1 + 
               Sin[Rational[54, 5] Degree])^2)^Rational[1, 2]}, {
           Rational[8, 5] 
            Pi, (Rational[5, 8] + 
             Rational[1, 8] 
              5^Rational[1, 2] + (-1 + 
               Rational[1, 4] (-1 + 5^Rational[1, 2]))^2)^Rational[1, 2]}, {
           Rational[41, 25] 
            Pi, (Cos[Rational[126, 5] Degree]^2 + (-1 + 
               Sin[Rational[126, 5] Degree])^2)^Rational[1, 2]}, {
           Rational[42, 25] 
            Pi, (Cos[Rational[162, 5] Degree]^2 + (-1 + 
               Sin[Rational[162, 5] Degree])^2)^Rational[1, 2]}, {
           Rational[43, 25] 
            Pi, (Cos[Rational[198, 5] Degree]^2 + (-1 + 
               Sin[Rational[198, 5] Degree])^2)^Rational[1, 2]}, {
           Rational[44, 25] 
            Pi, ((-1 + Cos[Rational[216, 5] Degree])^2 + 
             Sin[Rational[216, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[9, 5] 
            Pi, (Rational[5, 8] + 
             Rational[-1, 8] 
              5^Rational[1, 2] + (-1 + 
               Rational[1, 4] (1 + 5^Rational[1, 2]))^2)^Rational[1, 2]}, {
           Rational[46, 25] 
            Pi, ((-1 + Cos[Rational[144, 5] Degree])^2 + 
             Sin[Rational[144, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[47, 25] 
            Pi, ((-1 + Cos[Rational[108, 5] Degree])^2 + 
             Sin[Rational[108, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[48, 25] 
            Pi, ((-1 + Cos[Rational[72, 5] Degree])^2 + 
             Sin[Rational[72, 5] Degree]^2)^Rational[1, 2]}, {
           Rational[49, 25] 
            Pi, ((-1 + Cos[Rational[36, 5] Degree])^2 + 
             Sin[Rational[36, 5] Degree]^2)^Rational[1, 2]}}}, {{{0, 0}, {
           0.12566370614359174`, 0.12558103905862678`}, {0.25132741228718347`,
            0.2506664671286085}, {0.37699111843077515`, 
           0.37476262917144926`}, {0.5026548245743669, 0.4973797743297096}, {
           0.6283185307179586, 0.6180339887498948}, {0.7539822368615503, 
           0.736249105369356}, {0.8796459430051422, 0.8515585831301452}, {
           1.0053096491487339`, 0.9635073482034305}, {1.1309733552923256`, 
           1.0716535899579933`}, {1.2566370614359172`, 1.1755705045849463`}, {
           1.382300767579509, 1.2748479794973795`}, {1.5079644737231006`, 
           1.3690942118573775`}, {1.6336281798666925`, 1.457937254842823}, {
           1.7592918860102844`, 1.5410264855515785`}, {1.8849555921538759`, 
           1.618033988749895}, {2.0106192982974678`, 1.6886558510040304`}, {
           2.1362830044410597`, 1.7526133600877272`}, {2.261946710584651, 
           1.8096541049320392`}, {2.3876104167282426`, 1.859552971776503}, {
           2.5132741228718345`, 1.902113032590307}, {2.638937829015426, 
           1.9371663222572622`}, {2.764601535159018, 1.9645745014573772`}, {
           2.8902652413026098`, 1.9842294026289555`}, {3.015928947446201, 
           1.9960534568565433`}, {3.141592653589793, 2}, {3.267256359733385, 
           1.9960534568565433`}, {3.392920065876977, 1.9842294026289555`}, {
           3.518583772020569, 1.9645745014573772`}, {3.64424747816416, 
           1.9371663222572622`}, {3.7699111843077517`, 1.902113032590307}, {
           3.8955748904513436`, 1.859552971776503}, {4.0212385965949355`, 
           1.8096541049320392`}, {4.1469023027385274`, 1.7526133600877272`}, {
           4.272566008882119, 1.6886558510040304`}, {4.39822971502571, 
           1.618033988749895}, {4.523893421169302, 1.5410264855515785`}, {
           4.649557127312894, 1.457937254842823}, {4.775220833456485, 
           1.3690942118573775`}, {4.900884539600077, 1.2748479794973795`}, {
           5.026548245743669, 1.1755705045849463`}, {5.15221195188726, 
           1.0716535899579933`}, {5.277875658030852, 0.9635073482034305}, {
           5.403539364174444, 0.8515585831301452}, {5.529203070318036, 
           0.736249105369356}, {5.654866776461628, 0.6180339887498948}, {
           5.7805304826052195`, 0.4973797743297096}, {5.9061941887488105`, 
           0.37476262917144926`}, {6.031857894892402, 0.2506664671286085}, {
           6.157521601035994, 0.12558103905862678`}}}]], 
       {GrayLevel[0.5], 
        LineBox[NCache[{{{0, 0}, {
            Rational[1, 25] 
             Pi, (4 (-1 + Cos[Rational[36, 5] Degree])^2 + 
              2 Sin[Rational[36, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[2, 25] 
             Pi, (4 (-1 + Cos[Rational[72, 5] Degree])^2 + 
              2 Sin[Rational[72, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[3, 25] 
             Pi, (4 (-1 + Cos[Rational[108, 5] Degree])^2 + 
              2 Sin[Rational[108, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[4, 25] 
             Pi, (4 (-1 + Cos[Rational[144, 5] Degree])^2 + 
              2 Sin[Rational[144, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[1, 5] 
             Pi, (2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2]) + 
              4 (-1 + Rational[1, 4] (1 + 5^Rational[1, 2]))^2)^
             Rational[1, 2]}, {
            Rational[6, 25] 
             Pi, (4 (-1 + Cos[Rational[216, 5] Degree])^2 + 
              2 Sin[Rational[216, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[7, 25] 
             Pi, (2 Cos[Rational[198, 5] Degree]^2 + 
              4 (-1 + Sin[Rational[198, 5] Degree])^2)^Rational[1, 2]}, {
            Rational[8, 25] 
             Pi, (2 Cos[Rational[162, 5] Degree]^2 + 
              4 (-1 + Sin[Rational[162, 5] Degree])^2)^Rational[1, 2]}, {
            Rational[9, 25] 
             Pi, (2 Cos[Rational[126, 5] Degree]^2 + 
              4 (-1 + Sin[Rational[126, 5] Degree])^2)^Rational[1, 2]}, {
            Rational[2, 5] 
             Pi, (2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2]) + 
              4 (-1 + Rational[1, 4] (-1 + 5^Rational[1, 2]))^2)^
             Rational[1, 2]}, {
            Rational[11, 25] 
             Pi, (2 Cos[Rational[54, 5] Degree]^2 + 
              4 (-1 + Sin[Rational[54, 5] Degree])^2)^Rational[1, 2]}, {
            Rational[12, 25] 
             Pi, (2 Cos[Rational[18, 5] Degree]^2 + 
              4 (-1 + Sin[Rational[18, 5] Degree])^2)^Rational[1, 2]}, {
            Rational[13, 25] 
             Pi, (2 Cos[Rational[18, 5] Degree]^2 + 
              4 (-1 - Sin[Rational[18, 5] Degree])^2)^Rational[1, 2]}, {
            Rational[14, 25] 
             Pi, (2 Cos[Rational[54, 5] Degree]^2 + 
              4 (-1 - Sin[Rational[54, 5] Degree])^2)^Rational[1, 2]}, {
            Rational[3, 5] 
             Pi, (2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2]) + 
              4 (-1 + Rational[1, 4] (1 - 5^Rational[1, 2]))^2)^
             Rational[1, 2]}, {
            Rational[16, 25] 
             Pi, (2 Cos[Rational[126, 5] Degree]^2 + 
              4 (-1 - Sin[Rational[126, 5] Degree])^2)^Rational[1, 2]}, {
            Rational[17, 25] 
             Pi, (2 Cos[Rational[162, 5] Degree]^2 + 
              4 (-1 - Sin[Rational[162, 5] Degree])^2)^Rational[1, 2]}, {
            Rational[18, 25] 
             Pi, (2 Cos[Rational[198, 5] Degree]^2 + 
              4 (-1 - Sin[Rational[198, 5] Degree])^2)^Rational[1, 2]}, {
            Rational[19, 25] 
             Pi, (4 (-1 - Cos[Rational[216, 5] Degree])^2 + 
              2 Sin[Rational[216, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[4, 5] 
             Pi, (2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2]) + 
              4 (-1 + Rational[1, 4] (-1 - 5^Rational[1, 2]))^2)^
             Rational[1, 2]}, {
            Rational[21, 25] 
             Pi, (4 (-1 - Cos[Rational[144, 5] Degree])^2 + 
              2 Sin[Rational[144, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[22, 25] 
             Pi, (4 (-1 - Cos[Rational[108, 5] Degree])^2 + 
              2 Sin[Rational[108, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[23, 25] 
             Pi, (4 (-1 - Cos[Rational[72, 5] Degree])^2 + 
              2 Sin[Rational[72, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[24, 25] 
             Pi, (4 (-1 - Cos[Rational[36, 5] Degree])^2 + 
              2 Sin[Rational[36, 5] Degree]^2)^Rational[1, 2]}, {Pi, 4}, {
            Rational[26, 25] 
             Pi, (4 (-1 - Cos[Rational[36, 5] Degree])^2 + 
              2 Sin[Rational[36, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[27, 25] 
             Pi, (4 (-1 - Cos[Rational[72, 5] Degree])^2 + 
              2 Sin[Rational[72, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[28, 25] 
             Pi, (4 (-1 - Cos[Rational[108, 5] Degree])^2 + 
              2 Sin[Rational[108, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[29, 25] 
             Pi, (4 (-1 - Cos[Rational[144, 5] Degree])^2 + 
              2 Sin[Rational[144, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[6, 5] 
             Pi, (2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2]) + 
              4 (-1 + Rational[1, 4] (-1 - 5^Rational[1, 2]))^2)^
             Rational[1, 2]}, {
            Rational[31, 25] 
             Pi, (4 (-1 - Cos[Rational[216, 5] Degree])^2 + 
              2 Sin[Rational[216, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[32, 25] 
             Pi, (2 Cos[Rational[198, 5] Degree]^2 + 
              4 (-1 - Sin[Rational[198, 5] Degree])^2)^Rational[1, 2]}, {
            Rational[33, 25] 
             Pi, (2 Cos[Rational[162, 5] Degree]^2 + 
              4 (-1 - Sin[Rational[162, 5] Degree])^2)^Rational[1, 2]}, {
            Rational[34, 25] 
             Pi, (2 Cos[Rational[126, 5] Degree]^2 + 
              4 (-1 - Sin[Rational[126, 5] Degree])^2)^Rational[1, 2]}, {
            Rational[7, 5] 
             Pi, (2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2]) + 
              4 (-1 + Rational[1, 4] (1 - 5^Rational[1, 2]))^2)^
             Rational[1, 2]}, {
            Rational[36, 25] 
             Pi, (2 Cos[Rational[54, 5] Degree]^2 + 
              4 (-1 - Sin[Rational[54, 5] Degree])^2)^Rational[1, 2]}, {
            Rational[37, 25] 
             Pi, (2 Cos[Rational[18, 5] Degree]^2 + 
              4 (-1 - Sin[Rational[18, 5] Degree])^2)^Rational[1, 2]}, {
            Rational[38, 25] 
             Pi, (2 Cos[Rational[18, 5] Degree]^2 + 
              4 (-1 + Sin[Rational[18, 5] Degree])^2)^Rational[1, 2]}, {
            Rational[39, 25] 
             Pi, (2 Cos[Rational[54, 5] Degree]^2 + 
              4 (-1 + Sin[Rational[54, 5] Degree])^2)^Rational[1, 2]}, {
            Rational[8, 5] 
             Pi, (2 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2]) + 
              4 (-1 + Rational[1, 4] (-1 + 5^Rational[1, 2]))^2)^
             Rational[1, 2]}, {
            Rational[41, 25] 
             Pi, (2 Cos[Rational[126, 5] Degree]^2 + 
              4 (-1 + Sin[Rational[126, 5] Degree])^2)^Rational[1, 2]}, {
            Rational[42, 25] 
             Pi, (2 Cos[Rational[162, 5] Degree]^2 + 
              4 (-1 + Sin[Rational[162, 5] Degree])^2)^Rational[1, 2]}, {
            Rational[43, 25] 
             Pi, (2 Cos[Rational[198, 5] Degree]^2 + 
              4 (-1 + Sin[Rational[198, 5] Degree])^2)^Rational[1, 2]}, {
            Rational[44, 25] 
             Pi, (4 (-1 + Cos[Rational[216, 5] Degree])^2 + 
              2 Sin[Rational[216, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[9, 5] 
             Pi, (2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2]) + 
              4 (-1 + Rational[1, 4] (1 + 5^Rational[1, 2]))^2)^
             Rational[1, 2]}, {
            Rational[46, 25] 
             Pi, (4 (-1 + Cos[Rational[144, 5] Degree])^2 + 
              2 Sin[Rational[144, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[47, 25] 
             Pi, (4 (-1 + Cos[Rational[108, 5] Degree])^2 + 
              2 Sin[Rational[108, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[48, 25] 
             Pi, (4 (-1 + Cos[Rational[72, 5] Degree])^2 + 
              2 Sin[Rational[72, 5] Degree]^2)^Rational[1, 2]}, {
            Rational[49, 25] 
             Pi, (4 (-1 + Cos[Rational[36, 5] Degree])^2 + 
              2 Sin[Rational[36, 5] Degree]^2)^Rational[1, 2]}}}, {{{0, 0}, {
            0.12566370614359174`, 0.177948168332266}, {0.25132741228718347`, 
            0.3572693535902774}, {0.37699111843077515`, 0.5392186386943614}, {
            0.5026548245743669, 0.7248264306908848}, {0.6283185307179586, 
            0.9148120240658012}, {0.7539822368615503, 1.109523095820011}, {
            0.8796459430051422, 1.3089028869342283`}, {1.0053096491487339`, 
            1.5124835035804371`}, {1.1309733552923256`, 
            1.7194015463906998`}, {1.2566370614359172`, 
            1.9284312408342366`}, {1.382300767579509, 2.1380301675668547`}, {
            1.5079644737231006`, 2.3463932199124287`}, {1.6336281798666925`, 
            2.5515112100322095`}, {1.7592918860102844`, 2.751231366279024}, {
            1.8849555921538759`, 2.9433176791886795`}, {2.0106192982974678`, 
            3.12550961329059}, {2.1362830044410597`, 3.2955781083547238`}, {
            2.261946710584651, 3.451378073089616}, {2.3876104167282426`, 
            3.5908967597106725`}, {2.5132741228718345`, 
            3.7122975297481915`}, {2.638937829015426, 3.8139586043020843`}, {
            2.764601535159018, 3.894506453265602}, {2.8902652413026098`, 
            3.952843529545903}, {3.015928947446201, 3.9881701031481165`}, {
            3.141592653589793, 4}, {3.267256359733385, 3.9881701031481165`}, {
            3.392920065876977, 3.952843529545903}, {3.518583772020569, 
            3.894506453265602}, {3.64424747816416, 3.8139586043020843`}, {
            3.7699111843077517`, 3.7122975297481915`}, {3.8955748904513436`, 
            3.5908967597106725`}, {4.0212385965949355`, 3.451378073089616}, {
            4.1469023027385274`, 3.2955781083547238`}, {4.272566008882119, 
            3.12550961329059}, {4.39822971502571, 2.9433176791886795`}, {
            4.523893421169302, 2.751231366279024}, {4.649557127312894, 
            2.5515112100322095`}, {4.775220833456485, 2.3463932199124287`}, {
            4.900884539600077, 2.1380301675668547`}, {5.026548245743669, 
            1.9284312408342366`}, {5.15221195188726, 1.7194015463906998`}, {
            5.277875658030852, 1.5124835035804371`}, {5.403539364174444, 
            1.3089028869342283`}, {5.529203070318036, 1.109523095820011}, {
            5.654866776461628, 0.9148120240658012}, {5.7805304826052195`, 
            0.7248264306908848}, {5.9061941887488105`, 0.5392186386943614}, {
            6.031857894892402, 0.3572693535902774}, {6.157521601035994, 
            0.177948168332266}}}]]}},
      Axes->True,
      AxesOrigin->{0, 0},
      BaseStyle->{FontFamily -> "Helvetica", FontSize -> 10},
      Ticks->{{{0, 
          FormBox["0", TraditionalForm]}, {
          NCache[Pi, 3.141592653589793], 
          FormBox["\[Pi]", TraditionalForm]}, {
          NCache[2 Pi, 6.283185307179586], 
          FormBox[
           RowBox[{"2", " ", "\[Pi]"}], TraditionalForm]}}, {{0, 
          FormBox["0", TraditionalForm]}, {2, 
          FormBox["2", TraditionalForm]}, {4, 
          FormBox["4", TraditionalForm]}}}], {967.5, -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}]}, {}},
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 10},
  ContentSelectable->True,
  ImageSize->Full,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.5582743680815763`*^9, 3.5582743827300014`*^9}, 
   3.558274418594465*^9, {3.558274448920918*^9, 3.55827451848144*^9}, 
   3.5582745802887487`*^9, 3.558276097188613*^9, 3.5582761943767834`*^9, 
   3.558276309598586*^9, 3.5582763441214466`*^9, {3.55827664791798*^9, 
   3.558276676887231*^9}, 3.558276792421034*^9, 3.5582771456524544`*^9, 
   3.5587220034720054`*^9, 3.5587223438605175`*^9, 3.5587224413606887`*^9, 
   3.5590705725221615`*^9, 3.5590706959807787`*^9, 3.5590707505652742`*^9, 
   3.559070812637783*^9, 3.5590710541574078`*^9, 3.559071151610779*^9, 
   3.5590712446337423`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{996, 630},
WindowMargins->{{Automatic, 13}, {Automatic, 18}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 673, 13, 135, "Subtitle"],
Cell[1255, 37, 912, 16, 200, "Subsubtitle"],
Cell[CellGroupData[{
Cell[2192, 57, 133, 4, 97, "Section"],
Cell[2328, 63, 3129, 70, 252, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5494, 138, 165, 4, 97, "Section"],
Cell[5662, 144, 7786, 203, 332, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13485, 352, 102, 4, 97, "Section"],
Cell[CellGroupData[{
Cell[13612, 360, 5606, 132, 432, "Input"],
Cell[19221, 494, 12243, 206, 447, "Output"],
Cell[31467, 702, 18448, 373, 148, "Output"],
Cell[49918, 1077, 20234, 401, 257, "Output"],
Cell[70155, 1480, 54077, 983, 311, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
