(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     28579,        767]
NotebookOptionsPosition[     27511,        728]
NotebookOutlinePosition[     27855,        743]
CellTagsIndexPosition[     27812,        740]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 "\n"
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
  3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
  3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
  3.5842134956497355`*^9, 3.5842135862546945`*^9}},
 FontFamily->"Arial"],

Cell[TextData[{
 "\n",
 StyleBox["Least Squares and the Pseudoinverse",
  FontWeight->"Bold"],
 "\nFind the least squares solution to an overdetermined linear system using \
the pseudoinverse.\n\n",
 "For more on SVD and Pseudoinverse, see SVD_basics.nb",
 "\n"
}], "Subsubtitle",
 CellChangeTimes->{{3.569585100963764*^9, 3.5695851255182076`*^9}, {
  3.584363246264943*^9, 3.584363305685026*^9}}],

Cell[CellGroupData[{

Cell["\<\

Linear systems to choose from 
-- load one into m, rhs \
\>", "Section",
 CellChangeTimes->{{3.5843633201950464`*^9, 3.584363368865114*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Matrix", " ", "from", " ", "PLA", " ", "Example", " ", "in", " ", 
    "Gensys", " ", "and", " ", "Householder"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"m0", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"30", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"40", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"50", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"60", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rhs0", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
      "30", ",", "25", ",", "40", ",", "40", ",", "30", ",", "5", ",", "25"}],
       "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rhs1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rhs2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rhs3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3", ",", "1"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "===", "===", "===", "===", "===", "===", "===", "===", "===", "===", "===",
       "===", "===", "===", "===", "===", "==="}], "="}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m", " ", "=", " ", "m3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rhs", " ", "=", " ", "rhs3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Matrix", " ", 
     RowBox[{"dimensions", ":", " ", 
      RowBox[{"msize", " ", "x", " ", "nsize"}]}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"msize", ",", " ", "nsize"}], "}"}], " ", "=", " ", 
     RowBox[{"Dimensions", "[", "m", "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.5695851505406513`*^9, 3.5695853111117334`*^9}, {
   3.569585364822628*^9, 3.569585528856916*^9}, {3.5695856687111616`*^9, 
   3.569585759238121*^9}, {3.5695857922945786`*^9, 3.569585845927473*^9}, {
   3.5695858821819363`*^9, 3.569585897859964*^9}, {3.569585996857738*^9, 
   3.569586103421525*^9}, {3.569586190625678*^9, 3.569586191078079*^9}, {
   3.5695862329017525`*^9, 3.5695863192479043`*^9}, {3.569586349730358*^9, 
   3.569586432379303*^9}, {3.5695977346225176`*^9, 3.569597770611781*^9}, {
   3.569603744132657*^9, 3.5696038745956864`*^9}, {3.569604778475464*^9, 
   3.5696048005651026`*^9}, {3.5696051986607924`*^9, 3.56960520844201*^9}, 
   3.5843633945951505`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

Find SVD and pseudoinverse of matrix. Solve linear system.\
\>", "Section",
 CellChangeTimes->{{3.5843633985951557`*^9, 3.5843634119051747`*^9}, {
  3.5843634425352173`*^9, 3.5843634868752794`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"uu", ",", "sigma", ",", "vv"}], "}"}], "=", 
    RowBox[{"SingularValueDecomposition", "[", "m", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<m =   \>\"", ",", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "m", "]"}], "//", "N"}], ",", 
    "\"\<  size mxn=\>\"", ",", "msize", ",", "\"\< x \>\"", ",", "nsize", 
    ",", "\"\<  rhs= \>\"", ",", 
    RowBox[{"MatrixForm", "[", "rhs", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<rank=\>\"", ",", 
    RowBox[{"MatrixRank", "[", "m", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<uu =  \>\"", ",", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "uu", "]"}], "//", "N"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<vv =  \>\"", ",", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "vv", "]"}], "//", "N"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<sigma=\>\"", ",", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "sigma", "]"}], "//", "N"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", "Pseudoinverse", " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"size", " ", "nsize", " ", "x", " ", 
    RowBox[{"msize", " ", "--"}], " ", "copy", " ", "transpose", " ", "sigma",
     " ", "into", " ", "matrix", " ", "to", " ", "create"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sigmadagger", " ", "=", "  ", 
    RowBox[{"Transpose", "[", "sigma", "]"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"non", "-", 
    RowBox[{"zero", " ", "diagonal", " ", "elements", " ", 
     RowBox[{"1", "/", "sigma_ii"}]}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"min", " ", "=", " ", 
   RowBox[{"Min", "[", 
    RowBox[{"msize", ",", " ", "nsize"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"sigmadagger", "[", 
       RowBox[{"[", 
        RowBox[{"i", ",", "i"}], "]"}], "]"}], " ", "=", " ", 
      RowBox[{"1", "/", 
       RowBox[{"sigma", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "i"}], "]"}], "]"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "min"}], "}"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<Sigma = \>\"", ",", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "sigma", "]"}], "//", "N"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Sigma^{dagger} = \>\"", ",", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "sigmadagger", "]"}], "//", "N"}]}], "]"}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mdagger", " ", "=", " ", 
   RowBox[{"vv", ".", "sigmadagger", ".", 
    RowBox[{"Transpose", "[", "uu", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<m^dagger =\>\"", ",", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "mdagger", "]"}], "//", "N"}]}], "]"}], 
   ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Least", " ", "squares", " ", "solution", " ", "to", " ", "linear", " ", 
     "system", " ", 
     RowBox[{"m", ".", "x"}]}], " ", "=", " ", "rhs"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Step", " ", "1"}], ":", " ", 
     RowBox[{"compute", " ", "z"}]}], " ", "=", " ", 
    RowBox[{
     RowBox[{"uu", "^", "T"}], ".", "rhs"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"z", " ", "=", " ", 
    RowBox[{
     RowBox[{"Transpose", "[", "uu", "]"}], ".", "rhs"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Step", " ", "2"}], ":", " ", 
     RowBox[{"compute", " ", "y"}]}], " ", "=", " ", 
    RowBox[{
     RowBox[{"Sigma", "^", "dagger"}], ".", "z"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"y", " ", "=", " ", 
    RowBox[{"sigmadagger", ".", "z"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Step", " ", "3"}], ":", " ", 
     RowBox[{"solve", " ", 
      RowBox[{
       RowBox[{"V", "^", "T"}], ".", "x"}]}]}], " ", "=", " ", "y"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"x", " ", "=", " ", 
    RowBox[{"vv", ".", "y"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<z = uu^T.rhs = \>\"", ",", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "z", "]"}], "//", "N"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\"\<y = sigma^dagger.z = \>\"", ",", 
    RowBox[{
     RowBox[{"MatrixForm", "[", "y", "]"}], "//", "N"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"\"\<x = V.y solution x=\>\"", ",", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "x", "]"}], "//", "N"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5695851505406513`*^9, 3.5695853111117334`*^9}, {
   3.569585364822628*^9, 3.569585528856916*^9}, {3.5695856687111616`*^9, 
   3.569585759238121*^9}, {3.5695857922945786`*^9, 3.569585845927473*^9}, {
   3.5695858821819363`*^9, 3.569585897859964*^9}, {3.569585996857738*^9, 
   3.569586103421525*^9}, {3.569586190625678*^9, 3.569586191078079*^9}, {
   3.5695862329017525`*^9, 3.5695863192479043`*^9}, {3.569586349730358*^9, 
   3.569586432379303*^9}, {3.5695977346225176`*^9, 3.569597770611781*^9}, {
   3.569603744132657*^9, 3.5696038745956864`*^9}, {3.569604778475464*^9, 
   3.5696048005651026`*^9}, {3.5696051986607924`*^9, 3.56960520844201*^9}, 
   3.5843633945951505`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"m =   \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"3.`", "0.`", "0.`"},
       {"0.`", "1.`", "2.`"},
       {"0.`", "1.`", "0.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"  size mxn=\"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" x \"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\"  rhs= \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"3"},
        {"3"},
        {"1"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["m =   ", 
   MatrixForm[{{3., 0., 0.}, {0., 1., 2.}, {0., 1., 0.}}], "  size mxn=", 3, 
   " x ", 3, "  rhs= ", 
   MatrixForm[{3, 3, 1}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.569585517702896*^9, 3.56958553108772*^9}, 
   3.569585729800869*^9, {3.569585793589381*^9, 3.569585816412221*^9}, {
   3.569586096479513*^9, 3.5695861038427258`*^9}, 3.5695861940888844`*^9, 
   3.569586321899909*^9, 3.5695864328629036`*^9, 3.569597742484932*^9, 
   3.569597772858185*^9, 3.5696038811320972`*^9, {3.569604783467473*^9, 
   3.569604801610305*^9}, 3.5696052110784144`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"rank=\"\>", "\[InvisibleSpace]", "3"}],
  SequenceForm["rank=", 3],
  Editable->False]], "Print",
 CellChangeTimes->{{3.569585517702896*^9, 3.56958553108772*^9}, 
   3.569585729800869*^9, {3.569585793589381*^9, 3.569585816412221*^9}, {
   3.569586096479513*^9, 3.5695861038427258`*^9}, 3.5695861940888844`*^9, 
   3.569586321899909*^9, 3.5695864328629036`*^9, 3.569597742484932*^9, 
   3.569597772858185*^9, 3.5696038811320972`*^9, {3.569604783467473*^9, 
   3.569604801610305*^9}, 3.5696052110784144`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"uu =  \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.`", "0.`", "0.`"},
       {"0.`", "0.9732489894677301`", "0.22975292054736118`"},
       {"0.`", "0.22975292054736118`", 
        RowBox[{"-", "0.9732489894677303`"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["uu =  ", 
   MatrixForm[{{1., 0., 0.}, {0., 0.9732489894677301, 0.22975292054736118`}, {
    0., 0.22975292054736118`, -0.9732489894677303}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.569585517702896*^9, 3.56958553108772*^9}, 
   3.569585729800869*^9, {3.569585793589381*^9, 3.569585816412221*^9}, {
   3.569586096479513*^9, 3.5695861038427258`*^9}, 3.5695861940888844`*^9, 
   3.569586321899909*^9, 3.5695864328629036`*^9, 3.569597742484932*^9, 
   3.569597772858185*^9, 3.5696038811320972`*^9, {3.569604783467473*^9, 
   3.569604801610305*^9}, 3.5696052110784144`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vv =  \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.`", "0.`", "0.`"},
       {"0.`", "0.5257311121191336`", 
        RowBox[{"-", "0.85065080835204`"}]},
       {"0.`", "0.8506508083520399`", "0.5257311121191336`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["vv =  ", 
   MatrixForm[{{1., 0., 0.}, {0., 0.5257311121191336, -0.85065080835204}, {0.,
     0.8506508083520399, 0.5257311121191336}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.569585517702896*^9, 3.56958553108772*^9}, 
   3.569585729800869*^9, {3.569585793589381*^9, 3.569585816412221*^9}, {
   3.569586096479513*^9, 3.5695861038427258`*^9}, 3.5695861940888844`*^9, 
   3.569586321899909*^9, 3.5695864328629036`*^9, 3.569597742484932*^9, 
   3.569597772858185*^9, 3.5696038811320972`*^9, {3.569604783467473*^9, 
   3.569604801610305*^9}, 3.569605211094014*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"sigma=\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"3.`", "0.`", "0.`"},
       {"0.`", "2.288245611270737`", "0.`"},
       {"0.`", "0.`", "0.8740320488976421`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["sigma=", 
   MatrixForm[{{3., 0., 0.}, {0., 2.288245611270737, 0.}, {0., 0., 
    0.8740320488976421}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.569585517702896*^9, 3.56958553108772*^9}, 
   3.569585729800869*^9, {3.569585793589381*^9, 3.569585816412221*^9}, {
   3.569586096479513*^9, 3.5695861038427258`*^9}, 3.5695861940888844`*^9, 
   3.569586321899909*^9, 3.5695864328629036`*^9, 3.569597742484932*^9, 
   3.569597772858185*^9, 3.5696038811320972`*^9, {3.569604783467473*^9, 
   3.569604801610305*^9}, 3.569605211094014*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sigma = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"3.`", "0.`", "0.`"},
       {"0.`", "2.288245611270737`", "0.`"},
       {"0.`", "0.`", "0.8740320488976421`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Sigma = ", 
   MatrixForm[{{3., 0., 0.}, {0., 2.288245611270737, 0.}, {0., 0., 
    0.8740320488976421}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.569585517702896*^9, 3.56958553108772*^9}, 
   3.569585729800869*^9, {3.569585793589381*^9, 3.569585816412221*^9}, {
   3.569586096479513*^9, 3.5695861038427258`*^9}, 3.5695861940888844`*^9, 
   3.569586321899909*^9, 3.5695864328629036`*^9, 3.569597742484932*^9, 
   3.569597772858185*^9, 3.5696038811320972`*^9, {3.569604783467473*^9, 
   3.569604801610305*^9}, 3.569605211094014*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sigma^{dagger} = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.3333333333333333`", "0.`", "0.`"},
       {"0.`", "0.4370160244488211`", "0.`"},
       {"0.`", "0.`", "1.1441228056353687`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Sigma^{dagger} = ", 
   MatrixForm[{{0.3333333333333333, 0., 0.}, {0., 0.4370160244488211, 0.}, {
    0., 0., 1.1441228056353687`}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.569585517702896*^9, 3.56958553108772*^9}, 
   3.569585729800869*^9, {3.569585793589381*^9, 3.569585816412221*^9}, {
   3.569586096479513*^9, 3.5695861038427258`*^9}, 3.5695861940888844`*^9, 
   3.569586321899909*^9, 3.5695864328629036`*^9, 3.569597742484932*^9, 
   3.569597772858185*^9, 3.5696038811320972`*^9, {3.569604783467473*^9, 
   3.569604801610305*^9}, 3.569605211094014*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"m^dagger =\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.3333333333333333`", "0.`", "0.`"},
       {"0.`", "0.`", "1.0000000000000002`"},
       {"0.`", "0.5`", 
        RowBox[{"-", "0.5000000000000002`"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["m^dagger =", 
   MatrixForm[{{0.3333333333333333, 0., 0.}, {0., 0., 1.0000000000000002`}, {
    0., 0.5, -0.5000000000000002}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.569585517702896*^9, 3.56958553108772*^9}, 
   3.569585729800869*^9, {3.569585793589381*^9, 3.569585816412221*^9}, {
   3.569586096479513*^9, 3.5695861038427258`*^9}, 3.5695861940888844`*^9, 
   3.569586321899909*^9, 3.5695864328629036`*^9, 3.569597742484932*^9, 
   3.569597772858185*^9, 3.5696038811320972`*^9, {3.569604783467473*^9, 
   3.569604801610305*^9}, 3.569605211094014*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"z = uu^T.rhs = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"3.`"},
        {"3.149499888950551`"},
        {
         RowBox[{"-", "0.28399022782564676`"}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["z = uu^T.rhs = ", 
   MatrixForm[{3., 3.149499888950551, -0.28399022782564676`}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.569585517702896*^9, 3.56958553108772*^9}, 
   3.569585729800869*^9, {3.569585793589381*^9, 3.569585816412221*^9}, {
   3.569586096479513*^9, 3.5695861038427258`*^9}, 3.5695861940888844`*^9, 
   3.569586321899909*^9, 3.5695864328629036`*^9, 3.569597742484932*^9, 
   3.569597772858185*^9, 3.5696038811320972`*^9, {3.569604783467473*^9, 
   3.569604801610305*^9}, 3.569605211094014*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"y = sigma^dagger.z = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"1.`"},
        {"1.3763819204711734`"},
        {
         RowBox[{"-", "0.3249196962329065`"}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["y = sigma^dagger.z = ", 
   MatrixForm[{1., 1.3763819204711734`, -0.3249196962329065}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.569585517702896*^9, 3.56958553108772*^9}, 
   3.569585729800869*^9, {3.569585793589381*^9, 3.569585816412221*^9}, {
   3.569586096479513*^9, 3.5695861038427258`*^9}, 3.5695861940888844`*^9, 
   3.569586321899909*^9, 3.5695864328629036`*^9, 3.569597742484932*^9, 
   3.569597772858185*^9, 3.5696038811320972`*^9, {3.569604783467473*^9, 
   3.569604801610305*^9}, 3.569605211094014*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"x = V.y solution x=\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"1.`"},
        {"1.`"},
        {"0.9999999999999996`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["x = V.y solution x=", 
   MatrixForm[{1., 1., 0.9999999999999996}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.569585517702896*^9, 3.56958553108772*^9}, 
   3.569585729800869*^9, {3.569585793589381*^9, 3.569585816412221*^9}, {
   3.569586096479513*^9, 3.5695861038427258`*^9}, 3.5695861940888844`*^9, 
   3.569586321899909*^9, 3.5695864328629036`*^9, 3.569597742484932*^9, 
   3.569597772858185*^9, 3.5696038811320972`*^9, {3.569604783467473*^9, 
   3.569604801610305*^9}, 3.569605211094014*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{900, 630},
WindowMargins->{{Automatic, 105}, {Automatic, -4}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 673, 13, 135, "Subtitle"],
Cell[1255, 37, 397, 10, 124, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1677, 51, 151, 5, 123, "Section"],
Cell[1831, 58, 4078, 110, 412, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5946, 173, 209, 5, 97, "Section"],
Cell[CellGroupData[{
Cell[6180, 182, 6223, 174, 712, "Input"],
Cell[CellGroupData[{
Cell[12428, 360, 2189, 54, 50, "Print"],
Cell[14620, 416, 555, 10, 23, "Print"],
Cell[15178, 428, 1421, 31, 50, "Print"],
Cell[16602, 461, 1409, 31, 50, "Print"],
Cell[18014, 494, 1322, 30, 50, "Print"],
Cell[19339, 526, 1326, 30, 50, "Print"],
Cell[20668, 558, 1379, 30, 50, "Print"],
Cell[22050, 590, 1392, 31, 50, "Print"],
Cell[23445, 623, 1349, 32, 50, "Print"],
Cell[24797, 657, 1361, 32, 50, "Print"],
Cell[26161, 691, 1298, 31, 50, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
