(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     79876,       1548]
NotebookOptionsPosition[     79085,       1516]
NotebookOutlinePosition[     79429,       1531]
CellTagsIndexPosition[     79386,       1528]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9},
 FontFamily->"Arial"],

Cell[TextData[{
 StyleBox["Least Squares Sphere Fit",
  FontWeight->"Bold"],
 "\nSee Section 12.8 Application: Fitting data to a femur head\nProblem: \
given vectors v_1 ... v_L that are approximately equal length, rho_1 ... \
rho_L, find a sphere of radius r that closely fits the v_i.\nLeast squares \
solution, as derived in this section is \nr = (rho_1 + ... + rho_L)/L\n\n"
}], "Subsubtitle",
 CellChangeTimes->{{3.521285770562706*^9, 3.5212857934635463`*^9}, {
   3.5219829731352015`*^9, 3.5219829756466722`*^9}, 3.521984166802264*^9, 
   3.522076214608384*^9, {3.5220762786335373`*^9, 3.5220762906452293`*^9}, 
   3.5220763897182894`*^9, {3.522076465423148*^9, 3.522076517791005*^9}, {
   3.522546363017193*^9, 3.522546371849698*^9}, {3.549917976966034*^9, 
   3.5499179800704393`*^9}, 3.54991802565372*^9, {3.549918093685439*^9, 
   3.5499180939038396`*^9}, {3.5502416466103563`*^9, 
   3.5502416570467744`*^9}, {3.550684920625272*^9, 3.5506849343688955`*^9}, {
   3.5510400348821135`*^9, 3.551040037986519*^9}, 3.5846387733770747`*^9, {
   3.5846429101538496`*^9, 3.5846431614390907`*^9}, {3.584643331011389*^9, 
   3.5846433545050297`*^9}, {3.5846455388704677`*^9, 3.584645596325369*^9}},
 FontFamily->"Arial",
 FontSize->18,
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"unit", " ", "sphere"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"sphere", "[", 
      RowBox[{"u_", ",", "v_"}], "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Cos", "[", "u", "]"}], "*", 
        RowBox[{"Sin", "[", "v", "]"}]}], ",", 
       RowBox[{
        RowBox[{"Sin", "[", "u", "]"}], "*", 
        RowBox[{"Sin", "[", "v", "]"}]}], ",", 
       RowBox[{"Cos", "[", "v", "]"}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "Input", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"numpts", "=", "30"}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"number", " ", "of", " ", "data", " ", "points"}], " ", "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"vp", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "2"}], ",", "0"}], "}"}]}], ";", " ", 
    RowBox[{"(*", " ", "Viewpoint", " ", "*)"}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"generate", " ", "v_i", " ", "by", " ", "creating", " ", "u"}], 
      ",", 
      RowBox[{
      "v", " ", "parameters", " ", "to", " ", "be", " ", "matched", " ", 
       "with", " ", "parametric", " ", "unit", " ", "sphere", " ", "and", " ",
        "then", " ", "scaling", " ", "by", " ", "random", " ", "radius", " ", 
       "value"}]}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"uparams", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"2", "Pi"}]}], "}"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numpts"}], "}"}]}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"vparams", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "Pi"}], "}"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numpts"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "generate", " ", "a", " ", "real", " ", "number", " ", "between", " ", 
     "0.8", " ", "and", " ", "1.2"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"radii", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0.8", ",", "1.2"}], "}"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numpts"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "put", " ", "info", " ", "together", " ", "to", " ", "form", " ", "v_i"}],
     " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"spherepoints", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"radii", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "*", 
        RowBox[{"sphere", "[", 
         RowBox[{
          RowBox[{"uparams", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{"vparams", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numpts"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lsqradius", " ", "=", " ", 
     RowBox[{
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"radii", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "numpts"}], "}"}]}], "]"}], "/", "numpts"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<uparams = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "uparams", "]"}], ",", 
      "\"\<   vparams = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "vparams", "]"}], ",", "\"\<   radii = \>\"",
       ",", 
      RowBox[{"MatrixForm", "[", "radii", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<Input vectors v_i:\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"MatrixForm", "[", "spherepoints", "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Least squares sphere fit: radius =\>\"", ",", "lsqradius"}],
      "]"}], ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.521285770562706*^9, 3.5212857934635463`*^9}, {
   3.5219829731352015`*^9, 3.5219829756466722`*^9}, 3.521984166802264*^9, 
   3.522076214608384*^9, {3.5220762786335373`*^9, 3.5220762906452293`*^9}, 
   3.5220763897182894`*^9, {3.522076465423148*^9, 3.522076517791005*^9}, {
   3.522546363017193*^9, 3.522546371849698*^9}, {3.549917976966034*^9, 
   3.5499179800704393`*^9}, 3.54991802565372*^9, {3.5499181756323833`*^9, 
   3.549918182777196*^9}, {3.5499182151784525`*^9, 3.5499183228654413`*^9}, {
   3.5499183786667395`*^9, 3.549918474825309*^9}, {3.549918560516259*^9, 
   3.5499186703716516`*^9}, {3.5499187201357393`*^9, 3.549918722397743*^9}, {
   3.5499188226123195`*^9, 3.549918878039217*^9}, {3.549918917725686*^9, 
   3.5499189405797267`*^9}, {3.5499189727313833`*^9, 3.549918998362228*^9}, {
   3.5499382665619974`*^9, 3.549938375886989*^9}, {3.54993849025079*^9, 
   3.549938544788486*^9}, 3.5499788864685516`*^9, {3.549979037064417*^9, 
   3.5499790619152603`*^9}, {3.5499791165193567`*^9, 
   3.5499791904634867`*^9}, {3.550004519087002*^9, 3.550004539304637*^9}, {
   3.5500045737650976`*^9, 3.5500046265555906`*^9}, {3.5500917205667505`*^9, 
   3.5500917305975685`*^9}, 3.5502416798540144`*^9, {3.550241711022869*^9, 
   3.550241762268959*^9}, {3.5502417985390234`*^9, 3.5502418016278286`*^9}, {
   3.5502419389080696`*^9, 3.5502419770033364`*^9}, {3.550243934213974*^9, 
   3.550244083709037*^9}, 3.5502441381063323`*^9, 3.5502441836896124`*^9, {
   3.550244216090869*^9, 3.550244234764102*^9}, 3.550244310018634*^9, 
   3.5502443821687613`*^9, 3.5502444651921067`*^9, {3.550244539198637*^9, 
   3.5502445433950443`*^9}, {3.550244608583959*^9, 3.550244647646428*^9}, {
   3.550244706364931*^9, 3.550244726785367*^9}, {3.55024477406905*^9, 
   3.550244775020652*^9}, {3.550246771964559*^9, 3.5502467792497716`*^9}, {
   3.550246817017438*^9, 3.5502469819409275`*^9}, {3.5502470893471165`*^9, 
   3.55024712000117*^9}, {3.550247569079159*^9, 3.55024764363169*^9}, 
   3.550247683177759*^9, {3.550247733987049*^9, 3.5502477634711003`*^9}, {
   3.550247855090061*^9, 3.550247878224902*^9}, 3.55024791131256*^9, {
   3.550248052477208*^9, 3.5502480533976097`*^9}, {3.5502480849564652`*^9, 
   3.5502481141441164`*^9}, {3.5502482168546968`*^9, 3.5502482987236404`*^9}, 
   3.550248345617323*^9, {3.5502486504886584`*^9, 3.550248653998665*^9}, {
   3.5502522459413757`*^9, 3.5502522518381863`*^9}, {3.5502523071402836`*^9, 
   3.55025232239711*^9}, {3.5502593252746115`*^9, 3.55025934193544*^9}, {
   3.550259374617498*^9, 3.550259636853958*^9}, {3.550259684808443*^9, 
   3.550259768128189*^9}, {3.550259885939596*^9, 3.550259898669218*^9}, {
   3.5502599416160936`*^9, 3.550260112997995*^9}, {3.550260169048893*^9, 
   3.5502602252557917`*^9}, {3.5502603200415583`*^9, 
   3.5502603729100513`*^9}, {3.550260825435646*^9, 3.550260838383669*^9}, {
   3.550260877243337*^9, 3.5502608789749403`*^9}, {3.5502609684410973`*^9, 
   3.5502609825279217`*^9}, {3.55026101566238*^9, 3.5502610186575856`*^9}, {
   3.550261444602337*^9, 3.550261459406763*^9}, 3.550261559418538*^9, 
   3.5502616415214825`*^9, 3.5502618005637617`*^9, {3.550261855725459*^9, 
   3.550261859157465*^9}, {3.5506849419661093`*^9, 3.5506850057546215`*^9}, 
   3.550695411390498*^9, {3.5506955372671194`*^9, 3.5506955487331395`*^9}, 
   3.550695628386879*^9, {3.5506958415612535`*^9, 3.550695891777742*^9}, {
   3.550696089445689*^9, 3.550696114702133*^9}, 3.5506961568066072`*^9, {
   3.550696257676385*^9, 3.550696273510412*^9}, {3.5506965086496253`*^9, 
   3.5506965539521046`*^9}, {3.5506965858853607`*^9, 
   3.5506965934981747`*^9}, {3.5506969919852743`*^9, 3.55069701201571*^9}, {
   3.55069748455614*^9, 3.5506975142429914`*^9}, {3.5506979592493734`*^9, 
   3.5506980208382816`*^9}, {3.550705079195479*^9, 3.5507051943080807`*^9}, {
   3.5507052244785337`*^9, 3.550705226319337*^9}, {3.550705418667675*^9, 
   3.550705445343722*^9}, 3.5507054805841837`*^9, {3.5507055466347*^9, 
   3.5507056026075983`*^9}, {3.550705718125801*^9, 3.5507057200602045`*^9}, 
   3.5507058073267574`*^9, {3.55070591687015*^9, 3.5507059421421947`*^9}, 
   3.5507061305749254`*^9, 3.550706162398981*^9, {3.5507062223342867`*^9, 
   3.550706227123495*^9}, {3.550706379098962*^9, 3.5507063811425657`*^9}, 
   3.55075793721472*^9, {3.5507863943459177`*^9, 3.5507864191655617`*^9}, 
   3.5507865242941465`*^9, 3.5507865612662115`*^9, 3.550786657643181*^9, 
   3.55078670857727*^9, {3.550786977974143*^9, 3.5507870076453953`*^9}, {
   3.550787042152656*^9, 3.550787048829468*^9}, {3.550787086706334*^9, 
   3.5507870890775385`*^9}, {3.5507875171578903`*^9, 3.5507875957664285`*^9}, 
   3.5507876481357203`*^9, {3.5507879186401954`*^9, 3.550787931962619*^9}, 
   3.550802195475177*^9, 3.550852739192292*^9, {3.5508527865851755`*^9, 
   3.550852802278803*^9}, {3.5508528389232674`*^9, 3.5508528566760983`*^9}, {
   3.550852926470621*^9, 3.5508529299962273`*^9}, {3.5508530494144373`*^9, 
   3.5508530503972387`*^9}, {3.5508531316421814`*^9, 
   3.5508531680994453`*^9}, {3.5508532459591823`*^9, 
   3.5508532465207834`*^9}, {3.5508532854740515`*^9, 3.550853285630052*^9}, {
   3.5508534851232023`*^9, 3.5508534852948027`*^9}, {3.5510399634495883`*^9, 
   3.5510400113260727`*^9}, {3.5510400555209503`*^9, 
   3.5510400859254036`*^9}, {3.5510401600879335`*^9, 
   3.5510401849855776`*^9}, {3.584643217287189*^9, 3.5846432294240103`*^9}, {
   3.584643392537897*^9, 3.5846434230359507`*^9}, {3.58464353046054*^9, 
   3.5846435761374207`*^9}, {3.5846436874124155`*^9, 3.584643732387295*^9}, {
   3.5846437646949515`*^9, 3.584643990723748*^9}, {3.5846440225478044`*^9, 
   3.584644112715963*^9}, {3.5846441497036276`*^9, 3.584644177050476*^9}, {
   3.58464435595159*^9, 3.5846444142956924`*^9}, {3.5846444758066006`*^9, 
   3.5846444768830023`*^9}, {3.5846445083482575`*^9, 
   3.5846445864419947`*^9}, {3.5846451444081745`*^9, 3.584645144532975*^9}},
 FontFamily->"Courier New"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"uparams = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"2.4583079381182245`"},
        {"2.6079757532491`"},
        {"3.748972997541843`"},
        {"3.5936219388437234`"},
        {"6.223457836895024`"},
        {"2.547979775622828`"},
        {"3.049164054655952`"},
        {"1.106718826037202`"},
        {"4.19991126357499`"},
        {"1.178468475175655`"},
        {"0.7273702286440944`"},
        {"0.17270118735089923`"},
        {"2.3020772731140706`"},
        {"3.73409744955344`"},
        {"4.291540234437999`"},
        {"3.6898822672291107`"},
        {"5.90847300502128`"},
        {"0.27078970915702616`"},
        {"2.3558678868210947`"},
        {"4.743641978333207`"},
        {"3.409890889065018`"},
        {"1.774804921617255`"},
        {"1.1793792373727348`"},
        {"1.9208803043137763`"},
        {"6.1542696931894465`"},
        {"2.3105162051569668`"},
        {"1.3437014229734618`"},
        {"3.259229080970931`"},
        {"4.649670367538066`"},
        {"3.1534689759546666`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"   vparams = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"1.0937512158796885`"},
        {"0.9192203616746575`"},
        {"2.5646524640929123`"},
        {"2.8521452708094603`"},
        {"1.9886652986353823`"},
        {"0.40271998319879554`"},
        {"2.3055083632844804`"},
        {"0.5687622296242987`"},
        {"0.9639876724188339`"},
        {"0.3309329696202892`"},
        {"2.4443757496297627`"},
        {"2.2581929925220647`"},
        {"2.1831934536906905`"},
        {"0.3880154271118714`"},
        {"0.47863510734187686`"},
        {"2.3447753782520344`"},
        {"0.46626462835874793`"},
        {"2.030661982332637`"},
        {"1.0261276630676601`"},
        {"2.8038614363499335`"},
        {"1.600393112830286`"},
        {"2.3508306982101956`"},
        {"2.405578792648269`"},
        {"2.632888766690111`"},
        {"2.5458897108788285`"},
        {"1.4532527668378297`"},
        {"1.5929387065843983`"},
        {"1.7718026622160883`"},
        {"2.7014775918214804`"},
        {"0.10263858646205781`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"   radii = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"1.0039361150341493`"},
        {"0.897528535165963`"},
        {"0.8594445135780093`"},
        {"0.9021101128827557`"},
        {"0.9473823357846807`"},
        {"1.0578652575320882`"},
        {"0.8681176774223458`"},
        {"0.961472707383441`"},
        {"0.9954327870983819`"},
        {"0.8470801426422618`"},
        {"1.1899850462547215`"},
        {"0.9173258722330017`"},
        {"1.0425769214931355`"},
        {"0.8729316762454944`"},
        {"1.1657379068898817`"},
        {"0.9118886838279175`"},
        {"0.8810723789148271`"},
        {"1.1059800987230255`"},
        {"1.156248425415572`"},
        {"1.1769905850521933`"},
        {"0.8510486653417992`"},
        {"0.8660598345444486`"},
        {"0.8044980729990668`"},
        {"0.93675058371446`"},
        {"1.1432711917779101`"},
        {"1.1434401698562096`"},
        {"0.9279834441759658`"},
        {"0.8509353042895755`"},
        {"1.1060349986644915`"},
        {"1.096817828516995`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["uparams = ", 
   MatrixForm[{2.4583079381182245`, 2.6079757532491, 3.748972997541843, 
    3.5936219388437234`, 6.223457836895024, 2.547979775622828, 
    3.049164054655952, 1.106718826037202, 4.19991126357499, 1.178468475175655,
     0.7273702286440944, 0.17270118735089923`, 2.3020772731140706`, 
    3.73409744955344, 4.291540234437999, 3.6898822672291107`, 
    5.90847300502128, 0.27078970915702616`, 2.3558678868210947`, 
    4.743641978333207, 3.409890889065018, 1.774804921617255, 
    1.1793792373727348`, 1.9208803043137763`, 6.1542696931894465`, 
    2.3105162051569668`, 1.3437014229734618`, 3.259229080970931, 
    4.649670367538066, 3.1534689759546666`}], "   vparams = ", 
   MatrixForm[{1.0937512158796885`, 0.9192203616746575, 2.5646524640929123`, 
    2.8521452708094603`, 1.9886652986353823`, 0.40271998319879554`, 
    2.3055083632844804`, 0.5687622296242987, 0.9639876724188339, 
    0.3309329696202892, 2.4443757496297627`, 2.2581929925220647`, 
    2.1831934536906905`, 0.3880154271118714, 0.47863510734187686`, 
    2.3447753782520344`, 0.46626462835874793`, 2.030661982332637, 
    1.0261276630676601`, 2.8038614363499335`, 1.600393112830286, 
    2.3508306982101956`, 2.405578792648269, 2.632888766690111, 
    2.5458897108788285`, 1.4532527668378297`, 1.5929387065843983`, 
    1.7718026622160883`, 2.7014775918214804`, 0.10263858646205781`}], 
   "   radii = ", 
   MatrixForm[{1.0039361150341493`, 0.897528535165963, 0.8594445135780093, 
    0.9021101128827557, 0.9473823357846807, 1.0578652575320882`, 
    0.8681176774223458, 0.961472707383441, 0.9954327870983819, 
    0.8470801426422618, 1.1899850462547215`, 0.9173258722330017, 
    1.0425769214931355`, 0.8729316762454944, 1.1657379068898817`, 
    0.9118886838279175, 0.8810723789148271, 1.1059800987230255`, 
    1.156248425415572, 1.1769905850521933`, 0.8510486653417992, 
    0.8660598345444486, 0.8044980729990668, 0.93675058371446, 
    1.1432711917779101`, 1.1434401698562096`, 0.9279834441759658, 
    0.8509353042895755, 1.1060349986644915`, 1.096817828516995}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5846443156723194`*^9, {3.5846444040464745`*^9, 3.5846444178056984`*^9}, 
   3.5846444812822104`*^9, 3.584644597892415*^9, 3.5846451474189796`*^9, {
   3.584645254934369*^9, 3.584645269083594*^9}, {3.584645504737608*^9, 
   3.584645516968029*^9}}],

Cell[BoxData["\<\"Input vectors v_i:\"\>"], "Print",
 CellChangeTimes->{
  3.5846443156723194`*^9, {3.5846444040464745`*^9, 3.5846444178056984`*^9}, 
   3.5846444812822104`*^9, 3.584644597892415*^9, 3.5846451474189796`*^9, {
   3.584645254934369*^9, 3.584645269083594*^9}, {3.584645504737608*^9, 
   3.584645516968029*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "0.6916341839406054`"}], "0.5630653121031537`", 
      "0.46096348334857434`"},
     {
      RowBox[{"-", "0.6144342348492636`"}], "0.36299910070377617`", 
      "0.5442974328164785`"},
     {
      RowBox[{"-", "0.3849485160536798`"}], 
      RowBox[{"-", "0.26754947916814315`"}], 
      RowBox[{"-", "0.7203310267538573`"}]},
     {
      RowBox[{"-", "0.23162175639239388`"}], 
      RowBox[{"-", "0.11246633600292835`"}], 
      RowBox[{"-", "0.8645839120623962`"}]},
     {"0.8643216224613258`", 
      RowBox[{"-", "0.0516852187553487`"}], 
      RowBox[{"-", "0.38446074086292664`"}]},
     {
      RowBox[{"-", "0.3436730878099503`"}], "0.23191091076987094`", 
      "0.9732343198194843`"},
     {
      RowBox[{"-", "0.6414143985436032`"}], "0.05945443802961905`", 
      RowBox[{"-", "0.5819630924660927`"}]},
     {"0.2317838031093958`", "0.46306982444100825`", "0.8101063963156708`"},
     {
      RowBox[{"-", "0.40095942854701355`"}], 
      RowBox[{"-", "0.7126695564167561`"}], "0.567644319663686`"},
     {"0.1052345982272427`", "0.2543257946060287`", "0.801117243350059`"},
     {"0.5707059443203232`", "0.5080382894744763`", 
      RowBox[{"-", "0.912280785643953`"}]},
     {"0.6984546606695868`", "0.12183766245172335`", 
      RowBox[{"-", "0.58206823213887`"}]},
     {
      RowBox[{"-", "0.5697283067802584`"}], "0.6349879166252738`", 
      RowBox[{"-", "0.5993051304830437`"}]},
     {
      RowBox[{"-", "0.27397826595376457`"}], 
      RowBox[{"-", "0.1844392796657973`"}], "0.8080394627084116`"},
     {
      RowBox[{"-", "0.2193432836248809`"}], 
      RowBox[{"-", "0.4900530000798829`"}], "1.0347373814651541`"},
     {
      RowBox[{"-", "0.5565334978615251`"}], 
      RowBox[{"-", "0.33990525976749314`"}], 
      RowBox[{"-", "0.6373977187234204`"}]},
     {"0.3686051378550637`", 
      RowBox[{"-", "0.14497031413843098`"}], "0.7870212177902747`"},
     {"0.9549671047958375`", "0.26510700355299116`", 
      RowBox[{"-", "0.49086462919668944`"}]},
     {
      RowBox[{"-", "0.6990564380611173`"}], "0.6995132156411861`", 
      "0.599092462667175`"},
     {"0.012186456597680069`", 
      RowBox[{"-", "0.3898022408181202`"}], 
      RowBox[{"-", "1.1105010313503854`"}]},
     {
      RowBox[{"-", "0.8202416655632341`"}], 
      RowBox[{"-", "0.2255064863016717`"}], 
      RowBox[{"-", "0.02518462804933533`"}]},
     {
      RowBox[{"-", "0.12473308636470799`"}], "0.6029051022956259`", 
      RowBox[{"-", "0.6091032193339588`"}]},
     {"0.20604397144385178`", "0.49924345814724336`", 
      RowBox[{"-", "0.5962541411076646`"}]},
     {
      RowBox[{"-", "0.15647979171324655`"}], "0.4285665563421349`", 
      RowBox[{"-", "0.818135953041916`"}]},
     {"0.6361558321472485`", 
      RowBox[{"-", "0.08246777713482172`"}], 
      RowBox[{"-", "0.9463476321673585`"}]},
     {
      RowBox[{"-", "0.7654527720867407`"}], "0.838782495984025`", 
      "0.13409474328373325`"},
     {"0.2088823731451687`", "0.9039354431225449`", 
      RowBox[{"-", "0.02054608285729596`"}]},
     {
      RowBox[{"-", "0.828040135474412`"}], 
      RowBox[{"-", "0.09785950426696437`"}], 
      RowBox[{"-", "0.1698939185331065`"}]},
     {
      RowBox[{"-", "0.02953483583484193`"}], 
      RowBox[{"-", "0.4702925976787379`"}], 
      RowBox[{"-", "1.0006327919429563`"}]},
     {
      RowBox[{"-", "0.11237035201171361`"}], 
      RowBox[{"-", "0.0013346092728947828`"}], "1.0910455864717974`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{
  3.5846443156723194`*^9, {3.5846444040464745`*^9, 3.5846444178056984`*^9}, 
   3.5846444812822104`*^9, 3.584644597892415*^9, 3.5846451474189796`*^9, {
   3.584645254934369*^9, 3.584645269083594*^9}, {3.584645504737608*^9, 
   3.584645516983629*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Least squares sphere fit: radius =\"\>", "\[InvisibleSpace]", 
   "0.9829315957818254`"}],
  SequenceForm["Least squares sphere fit: radius =", 0.9829315957818254],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5846443156723194`*^9, {3.5846444040464745`*^9, 3.5846444178056984`*^9}, 
   3.5846444812822104`*^9, 3.584644597892415*^9, 3.5846451474189796`*^9, {
   3.584645254934369*^9, 3.584645269083594*^9}, {3.584645504737608*^9, 
   3.584645516983629*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics", "Section",
 CellChangeTimes->{{3.5846440770074997`*^9, 3.5846440819839087`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"sphereplot", "=", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"lsqradius", "*", 
       RowBox[{"sphere", "[", 
        RowBox[{"u", ",", "v"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"v", ",", "0", ",", "Pi"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"White", ",", 
         RowBox[{"Opacity", "[", "0.1", "]"}], ",", 
         RowBox[{"Specularity", "[", 
          RowBox[{"1", ",", "10"}], "]"}]}], "}"}]}], ",", 
      RowBox[{"Mesh", "\[Rule]", " ", "None"}], ",", 
      RowBox[{"Axes", "\[Rule]", "False"}], ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Color", " ", "points", " ", "on", " ", "backside", " ", "by", " ", 
    "sphere", " ", "a", " ", "light", " ", "gray"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "checks", " ", "which", " ", "points", " ", "are", " ", "visible"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"viz", " ", "=", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"spherepoints", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ".", "vp"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "numpts"}], "}"}]}], "]"}]}], ";"}], " ", 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "if", " ", "point", " ", "behind", " ", "sphere", " ", "or", " ", 
     "inside", " ", "sphere"}], ",", " ", 
    RowBox[{"color", " ", "lightgray"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"spointplot", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Graphics3D", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PointSize", "[", "Large", "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"viz", "[", 
              RowBox[{"[", "i", "]"}], "]"}], "<", "0"}], " ", "||", " ", 
            RowBox[{
             RowBox[{"Norm", "[", 
              RowBox[{"spherepoints", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "]"}], "<", "lsqradius"}]}], 
           ",", "LightGray", ",", "Black"}], "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"spherepoints", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "]"}]}], "}"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "numpts"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"sphereplot", ",", "spointplot"}], "}"}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", " ", "vp"}]}], "]"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.521285770562706*^9, 3.5212857934635463`*^9}, {
   3.5219829731352015`*^9, 3.5219829756466722`*^9}, 3.521984166802264*^9, 
   3.522076214608384*^9, {3.5220762786335373`*^9, 3.5220762906452293`*^9}, 
   3.5220763897182894`*^9, {3.522076465423148*^9, 3.522076517791005*^9}, {
   3.522546363017193*^9, 3.522546371849698*^9}, {3.549917976966034*^9, 
   3.5499179800704393`*^9}, 3.54991802565372*^9, {3.5499181756323833`*^9, 
   3.549918182777196*^9}, {3.5499182151784525`*^9, 3.5499183228654413`*^9}, {
   3.5499183786667395`*^9, 3.549918474825309*^9}, {3.549918560516259*^9, 
   3.5499186703716516`*^9}, {3.5499187201357393`*^9, 3.549918722397743*^9}, {
   3.5499188226123195`*^9, 3.549918878039217*^9}, {3.549918917725686*^9, 
   3.5499189405797267`*^9}, {3.5499189727313833`*^9, 3.549918998362228*^9}, {
   3.5499382665619974`*^9, 3.549938375886989*^9}, {3.54993849025079*^9, 
   3.549938544788486*^9}, 3.5499788864685516`*^9, {3.549979037064417*^9, 
   3.5499790619152603`*^9}, {3.5499791165193567`*^9, 
   3.5499791904634867`*^9}, {3.550004519087002*^9, 3.550004539304637*^9}, {
   3.5500045737650976`*^9, 3.5500046265555906`*^9}, {3.5500917205667505`*^9, 
   3.5500917305975685`*^9}, 3.5502416798540144`*^9, {3.550241711022869*^9, 
   3.550241762268959*^9}, {3.5502417985390234`*^9, 3.5502418016278286`*^9}, {
   3.5502419389080696`*^9, 3.5502419770033364`*^9}, {3.550243934213974*^9, 
   3.550244083709037*^9}, 3.5502441381063323`*^9, 3.5502441836896124`*^9, {
   3.550244216090869*^9, 3.550244234764102*^9}, 3.550244310018634*^9, 
   3.5502443821687613`*^9, 3.5502444651921067`*^9, {3.550244539198637*^9, 
   3.5502445433950443`*^9}, {3.550244608583959*^9, 3.550244647646428*^9}, {
   3.550244706364931*^9, 3.550244726785367*^9}, {3.55024477406905*^9, 
   3.550244775020652*^9}, {3.550246771964559*^9, 3.5502467792497716`*^9}, {
   3.550246817017438*^9, 3.5502469819409275`*^9}, {3.5502470893471165`*^9, 
   3.55024712000117*^9}, {3.550247569079159*^9, 3.55024764363169*^9}, 
   3.550247683177759*^9, {3.550247733987049*^9, 3.5502477634711003`*^9}, {
   3.550247855090061*^9, 3.550247878224902*^9}, 3.55024791131256*^9, {
   3.550248052477208*^9, 3.5502480533976097`*^9}, {3.5502480849564652`*^9, 
   3.5502481141441164`*^9}, {3.5502482168546968`*^9, 3.5502482987236404`*^9}, 
   3.550248345617323*^9, {3.5502486504886584`*^9, 3.550248653998665*^9}, {
   3.5502522459413757`*^9, 3.5502522518381863`*^9}, {3.5502523071402836`*^9, 
   3.55025232239711*^9}, {3.5502593252746115`*^9, 3.55025934193544*^9}, {
   3.550259374617498*^9, 3.550259636853958*^9}, {3.550259684808443*^9, 
   3.550259768128189*^9}, {3.550259885939596*^9, 3.550259898669218*^9}, {
   3.5502599416160936`*^9, 3.550260112997995*^9}, {3.550260169048893*^9, 
   3.5502602252557917`*^9}, {3.5502603200415583`*^9, 
   3.5502603729100513`*^9}, {3.550260825435646*^9, 3.550260838383669*^9}, {
   3.550260877243337*^9, 3.5502608789749403`*^9}, {3.5502609684410973`*^9, 
   3.5502609825279217`*^9}, {3.55026101566238*^9, 3.5502610186575856`*^9}, {
   3.550261444602337*^9, 3.550261459406763*^9}, 3.550261559418538*^9, 
   3.5502616415214825`*^9, 3.5502618005637617`*^9, {3.550261855725459*^9, 
   3.550261859157465*^9}, {3.5506849419661093`*^9, 3.5506850057546215`*^9}, 
   3.550695411390498*^9, {3.5506955372671194`*^9, 3.5506955487331395`*^9}, 
   3.550695628386879*^9, {3.5506958415612535`*^9, 3.550695891777742*^9}, {
   3.550696089445689*^9, 3.550696114702133*^9}, 3.5506961568066072`*^9, {
   3.550696257676385*^9, 3.550696273510412*^9}, {3.5506965086496253`*^9, 
   3.5506965539521046`*^9}, {3.5506965858853607`*^9, 
   3.5506965934981747`*^9}, {3.5506969919852743`*^9, 3.55069701201571*^9}, {
   3.55069748455614*^9, 3.5506975142429914`*^9}, {3.5506979592493734`*^9, 
   3.5506980208382816`*^9}, {3.550705079195479*^9, 3.5507051943080807`*^9}, {
   3.5507052244785337`*^9, 3.550705226319337*^9}, {3.550705418667675*^9, 
   3.550705445343722*^9}, 3.5507054805841837`*^9, {3.5507055466347*^9, 
   3.5507056026075983`*^9}, {3.550705718125801*^9, 3.5507057200602045`*^9}, 
   3.5507058073267574`*^9, {3.55070591687015*^9, 3.5507059421421947`*^9}, 
   3.5507061305749254`*^9, 3.550706162398981*^9, {3.5507062223342867`*^9, 
   3.550706227123495*^9}, {3.550706379098962*^9, 3.5507063811425657`*^9}, 
   3.55075793721472*^9, {3.5507863943459177`*^9, 3.5507864191655617`*^9}, 
   3.5507865242941465`*^9, 3.5507865612662115`*^9, 3.550786657643181*^9, 
   3.55078670857727*^9, {3.550786977974143*^9, 3.5507870076453953`*^9}, {
   3.550787042152656*^9, 3.550787048829468*^9}, {3.550787086706334*^9, 
   3.5507870890775385`*^9}, {3.5507875171578903`*^9, 3.5507875957664285`*^9}, 
   3.5507876481357203`*^9, {3.5507879186401954`*^9, 3.550787931962619*^9}, 
   3.550802195475177*^9, 3.550852739192292*^9, {3.5508527865851755`*^9, 
   3.550852802278803*^9}, {3.5508528389232674`*^9, 3.5508528566760983`*^9}, {
   3.550852926470621*^9, 3.5508529299962273`*^9}, {3.5508530494144373`*^9, 
   3.5508530503972387`*^9}, {3.5508531316421814`*^9, 
   3.5508531680994453`*^9}, {3.5508532459591823`*^9, 
   3.5508532465207834`*^9}, {3.5508532854740515`*^9, 3.550853285630052*^9}, {
   3.5508534851232023`*^9, 3.5508534852948027`*^9}, {3.5510399634495883`*^9, 
   3.5510400113260727`*^9}, {3.5510400555209503`*^9, 
   3.5510400859254036`*^9}, {3.5510401600879335`*^9, 
   3.5510401849855776`*^9}, {3.584643217287189*^9, 3.5846432294240103`*^9}, {
   3.584643392537897*^9, 3.5846434230359507`*^9}, {3.58464353046054*^9, 
   3.5846435761374207`*^9}, {3.5846436874124155`*^9, 3.584643732387295*^9}, {
   3.5846437646949515`*^9, 3.584643990723748*^9}, {3.5846440225478044`*^9, 
   3.584644074012295*^9}, {3.584644192120102*^9, 3.5846442361745796`*^9}, {
   3.5846442913050766`*^9, 3.5846442961410847`*^9}, {3.5846451838918443`*^9, 
   3.5846452085398874`*^9}, 3.5846452503479605`*^9, {3.5846456104745936`*^9, 
   3.5846456631246862`*^9}},
 FontFamily->"Courier New"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJxlm3lcT/n3xwcNBg1ijCzD2Hdj+TGUz2UYS9lGZGm+lmJQlpGULSNrlCVr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    "], {
     {GrayLevel[1], Opacity[0.1], EdgeForm[None], Specularity[
       GrayLevel[1], 10], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNm3f819Mexz/fYxMapCTtQUpLE/0KmaWhIdGyqTSISoNkZ5P2kNIgWRk3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        "]]]}, {}, {}, {}, {}},
    VertexNormals->CompressedData["
1:eJxNW3lcD90bjagoRbYsFZW1skZSvlOyRklRRKgQhQgtUgqlPe0ilTWl0KKN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     "]], 
   {GrayLevel[0.85], PointSize[Large], 
    Point3DBox[{-0.6916341839406054, 0.5630653121031537, 
     0.46096348334857434`}]}, 
   {GrayLevel[0.85], PointSize[Large], 
    Point3DBox[{-0.6144342348492636, 0.36299910070377617`, 
     0.5442974328164785}]}, 
   {GrayLevel[0.85], PointSize[Large], 
    Point3DBox[{-0.3849485160536798, -0.26754947916814315`, \
-0.7203310267538573}]}, 
   {GrayLevel[0.85], PointSize[Large], 
    Point3DBox[{-0.23162175639239388`, -0.11246633600292835`, \
-0.8645839120623962}]}, 
   {GrayLevel[0.85], PointSize[Large], 
    Point3DBox[{
     0.8643216224613258, -0.0516852187553487, -0.38446074086292664`}]}, 
   {GrayLevel[0.85], PointSize[Large], 
    Point3DBox[{-0.3436730878099503, 0.23191091076987094`, 
     0.9732343198194843}]}, 
   {GrayLevel[0.85], PointSize[Large], 
    Point3DBox[{-0.6414143985436032, 
     0.05945443802961905, -0.5819630924660927}]}, 
   {GrayLevel[0.85], PointSize[Large], 
    Point3DBox[{0.2317838031093958, 0.46306982444100825`, 
     0.8101063963156708}]}, 
   {GrayLevel[0], PointSize[Large], 
    Point3DBox[{-0.40095942854701355`, -0.7126695564167561, 
     0.567644319663686}]}, 
   {GrayLevel[0.85], PointSize[Large], 
    Point3DBox[{0.1052345982272427, 0.2543257946060287, 0.801117243350059}]}, 
   {GrayLevel[0.85], PointSize[Large], 
    Point3DBox[{0.5707059443203232, 0.5080382894744763, -0.912280785643953}]}, 
   {GrayLevel[0.85], PointSize[Large], 
    Point3DBox[{0.6984546606695868, 
     0.12183766245172335`, -0.58206823213887}]}, 
   {GrayLevel[0.85], PointSize[Large], 
    Point3DBox[{-0.5697283067802584, 
     0.6349879166252738, -0.5993051304830437}]}, 
   {GrayLevel[0.85], PointSize[Large], 
    Point3DBox[{-0.27397826595376457`, -0.1844392796657973, 
     0.8080394627084116}]}, 
   {GrayLevel[0], PointSize[Large], 
    Point3DBox[{-0.2193432836248809, -0.4900530000798829, 
     1.0347373814651541`}]}, 
   {GrayLevel[0.85], PointSize[Large], 
    Point3DBox[{-0.5565334978615251, -0.33990525976749314`, \
-0.6373977187234204}]}, 
   {GrayLevel[0.85], PointSize[Large], 
    Point3DBox[{0.3686051378550637, -0.14497031413843098`, 
     0.7870212177902747}]}, 
   {GrayLevel[0.85], PointSize[Large], 
    Point3DBox[{0.9549671047958375, 
     0.26510700355299116`, -0.49086462919668944`}]}, 
   {GrayLevel[0.85], PointSize[Large], 
    Point3DBox[{-0.6990564380611173, 0.6995132156411861, 0.599092462667175}]}, 
   {GrayLevel[0], PointSize[Large], 
    Point3DBox[{
     0.012186456597680069`, -0.3898022408181202, -1.1105010313503854`}]}, 
   {GrayLevel[0.85], PointSize[Large], 
    Point3DBox[{-0.8202416655632341, -0.2255064863016717, \
-0.02518462804933533}]}, 
   {GrayLevel[0.85], PointSize[Large], 
    Point3DBox[{-0.12473308636470799`, 
     0.6029051022956259, -0.6091032193339588}]}, 
   {GrayLevel[0.85], PointSize[Large], 
    Point3DBox[{0.20604397144385178`, 
     0.49924345814724336`, -0.5962541411076646}]}, 
   {GrayLevel[0.85], PointSize[Large], 
    Point3DBox[{-0.15647979171324655`, 
     0.4285665563421349, -0.818135953041916}]}, 
   {GrayLevel[0], PointSize[Large], 
    Point3DBox[{
     0.6361558321472485, -0.08246777713482172, -0.9463476321673585}]}, 
   {GrayLevel[0.85], PointSize[Large], 
    Point3DBox[{-0.7654527720867407, 0.838782495984025, 
     0.13409474328373325`}]}, 
   {GrayLevel[0.85], PointSize[Large], 
    Point3DBox[{0.2088823731451687, 
     0.9039354431225449, -0.02054608285729596}]}, 
   {GrayLevel[0.85], PointSize[Large], 
    Point3DBox[{-0.828040135474412, -0.09785950426696437, \
-0.1698939185331065}]}, 
   {GrayLevel[0], PointSize[Large], 
    Point3DBox[{-0.02953483583484193, -0.4702925976787379, \
-1.0006327919429563`}]}, 
   {GrayLevel[0], PointSize[Large], 
    Point3DBox[{-0.11237035201171361`, -0.0013346092728947828`, 
     1.0910455864717974`}]}},
  AutomaticImageSize->True,
  BaseStyle->{},
  Boxed->False,
  ImageSize->{366.49949076304273`, 383.4510785543495},
  PlotRange->{{-0.9829315957818254, 0.9829315957817264}, {-0.9829315957818007,
    0.9829315957818007}, {-0.9829315957818007, 0.9829315957818007}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  ViewPoint->{0, -2, 0},
  ViewVertical->{-0.4694506865246416, -0.5649789166947083, \
-0.6785387804775993}]], "Output",
 CellChangeTimes->{{3.550246929041235*^9, 3.55024698323573*^9}, {
   3.5502470910319195`*^9, 3.550247133183193*^9}, {3.5502475724331646`*^9, 
   3.5502475994056125`*^9}, 3.5502476454256935`*^9, 3.550247684238561*^9, {
   3.550247735157051*^9, 3.5502477642511015`*^9}, {3.5502478563224635`*^9, 
   3.5502478792857037`*^9}, 3.550247912388962*^9, 3.5502480544428115`*^9, {
   3.550248086500868*^9, 3.5502481152673187`*^9}, 3.5502482997376423`*^9, 
   3.5502483521225348`*^9, 3.5502486549190664`*^9, 3.5502522574073963`*^9, 
   3.550259774961001*^9, 3.55025989958962*^9, 3.550260053795891*^9, {
   3.5502600863375483`*^9, 3.5502601138715963`*^9}, {3.5502601953661394`*^9, 
   3.5502602261137934`*^9}, 3.5502609834327235`*^9, 3.550261029234404*^9, 
   3.5502614611383657`*^9, 3.5502615614933424`*^9, 3.5502616435026865`*^9, 
   3.5502618031065664`*^9, 3.550261860998268*^9, 3.55068502211905*^9, 
   3.5506954127945004`*^9, 3.550695549809541*^9, 3.5506956293228807`*^9, {
   3.5506958480976653`*^9, 3.5506958938993454`*^9}, 3.5506961176661386`*^9, 
   3.5506962052134924`*^9, {3.550696258565586*^9, 3.550696274680414*^9}, {
   3.550696509772827*^9, 3.5506965553249073`*^9}, 3.550696594465376*^9, {
   3.5506969931864767`*^9, 3.5506970132949114`*^9}, 3.5506974879725456`*^9, 
   3.550697522495406*^9, 3.5507054489629283`*^9, 3.550705484484191*^9, {
   3.550705584293166*^9, 3.5507056057120037`*^9}, 3.5507057238510113`*^9, 
   3.5507059178061514`*^9, 3.5507061323377285`*^9, 3.550758017710861*^9, 
   3.550786421599166*^9, 3.550786489474885*^9, 3.550786525557749*^9, 
   3.5507866117167*^9, {3.550786658469982*^9, 3.5507866839760265`*^9}, {
   3.5507869793313456`*^9, 3.5507870090493975`*^9}, 3.5507870510602713`*^9, {
   3.5507870898263397`*^9, 3.5507871190919914`*^9}, 3.550787524224703*^9, {
   3.5507875610251675`*^9, 3.5507876027708406`*^9}, 3.550787648837722*^9, {
   3.550787783465958*^9, 3.550787785993162*^9}, 3.5507879342870226`*^9, 
   3.550802196801179*^9, {3.550852695091015*^9, 3.550852753934318*^9}, 
   3.5508528046500072`*^9, 3.5508528613249063`*^9, {3.550852930994629*^9, 
   3.550852938435842*^9}, {3.550853041645623*^9, 3.550853063017661*^9}, {
   3.5508532506391907`*^9, 3.550853286768854*^9}, 3.5846387857790966`*^9, 
   3.5846443158595195`*^9, {3.584644404171275*^9, 3.5846444178992987`*^9}, 
   3.5846444813602104`*^9, 3.584644597954815*^9, 3.5846451474969807`*^9, {
   3.584645255012369*^9, 3.584645269161594*^9}, {3.584645504815608*^9, 
   3.584645517046029*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{977, 713},
WindowMargins->{{Automatic, 96}, {Automatic, -26}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 691, 12, 107, "Subtitle"],
Cell[1273, 36, 1257, 21, 185, "Subsubtitle"],
Cell[CellGroupData[{
Cell[2555, 61, 10469, 204, 492, "Input"],
Cell[CellGroupData[{
Cell[13049, 269, 7384, 183, 455, "Print"],
Cell[20436, 454, 323, 5, 23, "Print"],
Cell[20762, 461, 4281, 106, 455, "Print"],
Cell[25046, 569, 514, 10, 23, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25609, 585, 97, 1, 71, "Section"],
Cell[CellGroupData[{
Cell[25731, 590, 8980, 166, 352, "Input"],
Cell[34714, 758, 44331, 753, 398, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
