(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     80884,       1627]
NotebookOptionsPosition[     79535,       1578]
NotebookOutlinePosition[     79880,       1593]
CellTagsIndexPosition[     79837,       1590]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 "\n"
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
  3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
  3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
  3.5842134956497355`*^9, 3.5842135862546945`*^9}},
 FontFamily->"Arial"],

Cell[TextData[{
 StyleBox["Least Squares Approximation\n",
  FontWeight->"Bold"],
 "Find the least squares best fit line to data.\nUse data from ",
 StyleBox["Mathematica\[CloseCurlyQuote]s ",
  FontSlant->"Italic"],
 "Financial Data and use the best fit line for spotting a trend in the data. \
\nThis example is for AIG\[CloseCurlyQuote]s stock from 1/1/2000 to today.\n\
Also: input test data sets\nThis nb uses the normal equations and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s LinearSolve routine.\nSee Section 12.7 Gauss for Linear \
Systems, Least Squares"
}], "Subsubtitle",
 CellChangeTimes->{{3.5562232910449495`*^9, 3.556223445675123*^9}, {
   3.556223501633399*^9, 3.5562235029438243`*^9}, {3.55622355732647*^9, 
   3.5562236229725323`*^9}, {3.5562237423616285`*^9, 3.556223790348151*^9}, {
   3.5562240731697826`*^9, 3.5562241075825005`*^9}, {3.5562242107764373`*^9, 
   3.5562242889168377`*^9}, {3.5562243303348374`*^9, 3.556224376120837*^9}, {
   3.55622441025364*^9, 3.556224466320759*^9}, {3.5562247655169945`*^9, 
   3.5562249432500734`*^9}, {3.5562251930728493`*^9, 3.556225294927208*^9}, {
   3.556225331775117*^9, 3.556225341135297*^9}, {3.556372110172995*^9, 
   3.5563721420330963`*^9}, {3.556372207032649*^9, 3.556372241356609*^9}, {
   3.5563722910171385`*^9, 3.55637231009814*^9}, {3.556372398638355*^9, 
   3.556372404520233*^9}, {3.5563725707292457`*^9, 3.5563726082177277`*^9}, {
   3.5563729619470067`*^9, 3.556372963319842*^9}, {3.5563730041772895`*^9, 
   3.556373034910077*^9}, {3.5563732031753683`*^9, 3.556373220164095*^9}, {
   3.5563751493745923`*^9, 3.556375343927513*^9}, {3.5563753740827*^9, 
   3.5563753826628103`*^9}, {3.556375422646123*^9, 3.556375423644535*^9}, 
   3.556397167661307*^9, {3.556397215741123*^9, 3.5563972634777355`*^9}, {
   3.556397805408103*^9, 3.5563980967087708`*^9}, 3.5563982686689296`*^9, 
   3.5563983072638245`*^9, {3.5563983619431615`*^9, 3.556398437980486*^9}, {
   3.556399599735585*^9, 3.5563996541348777`*^9}, {3.556399727191514*^9, 
   3.556399758766521*^9}, {3.5563998810884733`*^9, 3.5563999199800215`*^9}, {
   3.5563999578263493`*^9, 3.556400019743663*^9}, {3.584301301845433*^9, 
   3.584301305555438*^9}, {3.5843013475654974`*^9, 3.584301426735608*^9}, {
   3.584301605105858*^9, 3.5843016620759373`*^9}, {3.5843018641902227`*^9, 
   3.5843018911002607`*^9}, {3.5843020266004505`*^9, 
   3.5843020868705344`*^9}, {3.5843021260605893`*^9, 3.5843021562006316`*^9}}],

Cell[CellGroupData[{

Cell["Initialize output folders and graphics ", "Section",
 CellChangeTimes->{{3.5564000400551233`*^9, 3.5564000402267256`*^9}, {
   3.556400077058798*^9, 3.5564001576650314`*^9}, {3.5564070623926153`*^9, 
   3.556407109801927*^9}, 3.5843012992554293`*^9, {3.5843014462556353`*^9, 
   3.5843014481956377`*^9}, {3.5843016837259674`*^9, 3.584301693185981*^9}},
 FontFamily->"Arial"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"to", " ", "enable", " ", "file", " ", 
    RowBox[{"export", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetOptions", "[", 
     RowBox[{"Plot", ",", 
      RowBox[{"BaseStyle", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontFamily", "->", "\"\<Helvetica\>\""}], ",", 
         RowBox[{"FontSize", "\[Rule]", "10"}]}], "}"}]}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetOptions", "[", 
     RowBox[{"ListPlot", ",", 
      RowBox[{"BaseStyle", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontFamily", "->", "\"\<Helvetica\>\""}], ",", 
         RowBox[{"FontSize", "\[Rule]", "10"}]}], "}"}]}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetOptions", "[", 
     RowBox[{"DateListPlot", ",", 
      RowBox[{"BaseStyle", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontFamily", "->", "\"\<Helvetica\>\""}], ",", 
         RowBox[{"FontSize", "\[Rule]", "10"}]}], "}"}]}]}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.5562232910449495`*^9, 3.556223445675123*^9}, {
   3.556223501633399*^9, 3.5562235029438243`*^9}, {3.55622355732647*^9, 
   3.5562236229725323`*^9}, {3.5562237423616285`*^9, 3.556223790348151*^9}, {
   3.5562240731697826`*^9, 3.5562241075825005`*^9}, {3.5562242107764373`*^9, 
   3.5562242889168377`*^9}, {3.5562243303348374`*^9, 3.556224376120837*^9}, {
   3.55622441025364*^9, 3.556224466320759*^9}, {3.5562247655169945`*^9, 
   3.5562249432500734`*^9}, {3.5562251930728493`*^9, 3.556225294927208*^9}, {
   3.556225331775117*^9, 3.556225341135297*^9}, {3.556372110172995*^9, 
   3.5563721420330963`*^9}, {3.556372207032649*^9, 3.556372241356609*^9}, {
   3.5563722910171385`*^9, 3.55637231009814*^9}, {3.556372398638355*^9, 
   3.556372404520233*^9}, {3.5563725707292457`*^9, 3.5563726082177277`*^9}, {
   3.5563729619470067`*^9, 3.556372963319842*^9}, {3.5563730041772895`*^9, 
   3.556373034910077*^9}, {3.5563732031753683`*^9, 3.556373220164095*^9}, {
   3.5563751493745923`*^9, 3.556375343927513*^9}, {3.5563753740827*^9, 
   3.5563753826628103`*^9}, {3.556375422646123*^9, 3.556375423644535*^9}, 
   3.556397167661307*^9, {3.556397215741123*^9, 3.5563972634777355`*^9}, {
   3.556397805408103*^9, 3.5563980967087708`*^9}, 3.5563982686689296`*^9, 
   3.5563983072638245`*^9, {3.5563983619431615`*^9, 3.556398437980486*^9}, {
   3.556399599735585*^9, 3.5563996541348777`*^9}, {3.556399727191514*^9, 
   3.556399758766521*^9}, {3.5563998810884733`*^9, 3.5563999199800215`*^9}, {
   3.5563999578263493`*^9, 3.5563999919285064`*^9}, {3.5564001643107166`*^9, 
   3.556400253575061*^9}, {3.556400334930104*^9, 3.5564003712785697`*^9}, {
   3.5564066189968443`*^9, 3.556406623365012*^9}, {3.5564066674679084`*^9, 
   3.556406669667593*^9}, {3.556406934750961*^9, 3.55640694874443*^9}, {
   3.556407000334622*^9, 3.5564070417066174`*^9}, {3.55640735219796*^9, 
   3.5564073582508373`*^9}, {3.5564075366391244`*^9, 
   3.5564075462176476`*^9}, {3.556417673377757*^9, 3.5564177899587994`*^9}, {
   3.556417926273054*^9, 3.5564180029951153`*^9}, {3.5564181395200768`*^9, 
   3.5564181692072573`*^9}, {3.56253442823825*^9, 3.562534485927789*^9}, {
   3.56788265970753*^9, 3.5678826705651493`*^9}, {3.567882757582102*^9, 
   3.5678827606709075`*^9}, {3.5679048805569677`*^9, 
   3.5679049276470337`*^9}, {3.5679051315789194`*^9, 3.567905143588937*^9}, {
   3.5679053474048223`*^9, 3.567905401494898*^9}, {3.567905579779948*^9, 
   3.567905629962019*^9}, {3.567905674832082*^9, 3.567905712726935*^9}, {
   3.5679058971095934`*^9, 3.5679059548096743`*^9}, 3.567947666443416*^9, {
   3.567947956808223*^9, 3.5679481971153603`*^9}, {3.567948349812374*^9, 
   3.5679483540123796`*^9}, {3.5679485003666286`*^9, 3.567948517836653*^9}, {
   3.567948557716709*^9, 3.5679485666567216`*^9}, {3.5679486439668293`*^9, 
   3.567948744559371*^9}, {3.567949174149973*^9, 3.567949190279996*^9}, {
   3.5679492586924915`*^9, 3.567949265482501*^9}, {3.5679493054025574`*^9, 
   3.5679493123925667`*^9}, {3.567949344575012*^9, 3.5679493979350867`*^9}, {
   3.567949503257634*^9, 3.5679496443226323`*^9}, {3.5679496894326954`*^9, 
   3.5679496907026973`*^9}, {3.567949738135164*^9, 3.5679497575651913`*^9}, {
   3.567951797916055*^9, 3.5679518015560603`*^9}, {3.5680538110760365`*^9, 
   3.568053884082986*^9}, {3.568053979578285*^9, 3.568054054267505*^9}, {
   3.56805408883703*^9, 3.568054104514927*^9}, {3.5689873101826115`*^9, 
   3.568987311586614*^9}, {3.568987771194628*^9, 3.568987774143033*^9}, {
   3.5689878901344376`*^9, 3.5689878981684523`*^9}, {3.568987937386921*^9, 
   3.5689880431395063`*^9}, 3.5843014603456545`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Create data", "Section",
 CellChangeTimes->{{3.584301465125662*^9, 3.5843014748356752`*^9}, 
   3.584302336880884*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"list", "=", 
    RowBox[{"FinancialData", "[", 
     RowBox[{"\"\<AIG\>\"", ",", "\"\<Jan. 1, 2000\>\""}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<financial data = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "list", "]"}]}], "]"}], ";"}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"length", "=", 
   RowBox[{"Length", "[", "list", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"list", "[", 
      RowBox[{"[", 
       RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "length"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"datplot", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{"data", ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.4", "]"}], ",", 
         RowBox[{"PointSize", "[", "0.004", "]"}]}], "}"}]}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "length"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<mat=\>\"", ",", 
      RowBox[{"MatrixForm", "[", "mat", "]"}]}], "]"}], ";"}], " ", 
   "*)"}]}]}], "Input",
 CellChangeTimes->{{3.5562232910449495`*^9, 3.556223445675123*^9}, {
   3.556223501633399*^9, 3.5562235029438243`*^9}, {3.55622355732647*^9, 
   3.5562236229725323`*^9}, {3.5562237423616285`*^9, 3.556223790348151*^9}, {
   3.5562240731697826`*^9, 3.5562241075825005`*^9}, {3.5562242107764373`*^9, 
   3.5562242889168377`*^9}, {3.5562243303348374`*^9, 3.556224376120837*^9}, {
   3.55622441025364*^9, 3.556224466320759*^9}, {3.5562247655169945`*^9, 
   3.5562249432500734`*^9}, {3.5562251930728493`*^9, 3.556225294927208*^9}, {
   3.556225331775117*^9, 3.556225341135297*^9}, {3.556372110172995*^9, 
   3.5563721420330963`*^9}, {3.556372207032649*^9, 3.556372241356609*^9}, {
   3.5563722910171385`*^9, 3.55637231009814*^9}, {3.556372398638355*^9, 
   3.556372404520233*^9}, {3.5563725707292457`*^9, 3.5563726082177277`*^9}, {
   3.5563729619470067`*^9, 3.556372963319842*^9}, {3.5563730041772895`*^9, 
   3.556373034910077*^9}, {3.5563732031753683`*^9, 3.556373220164095*^9}, {
   3.5563751493745923`*^9, 3.556375343927513*^9}, {3.5563753740827*^9, 
   3.5563753826628103`*^9}, {3.556375422646123*^9, 3.556375423644535*^9}, 
   3.556397167661307*^9, {3.556397215741123*^9, 3.5563972634777355`*^9}, {
   3.556397805408103*^9, 3.5563980967087708`*^9}, 3.5563982686689296`*^9, 
   3.5563983072638245`*^9, {3.5563983619431615`*^9, 3.556398437980486*^9}, {
   3.556399599735585*^9, 3.5563996541348777`*^9}, {3.556399727191514*^9, 
   3.556399758766521*^9}, {3.5563998810884733`*^9, 3.5563999199800215`*^9}, {
   3.5563999578263493`*^9, 3.5563999919285064`*^9}, {3.5564001643107166`*^9, 
   3.556400253575061*^9}, {3.556400334930104*^9, 3.5564003712785697`*^9}, {
   3.5564066189968443`*^9, 3.556406623365012*^9}, {3.5564066674679084`*^9, 
   3.556406669667593*^9}, {3.556406934750961*^9, 3.55640694874443*^9}, {
   3.556407000334622*^9, 3.5564070417066174`*^9}, {3.55640735219796*^9, 
   3.5564073582508373`*^9}, {3.5564075366391244`*^9, 
   3.5564075462176476`*^9}, {3.556417673377757*^9, 3.5564177899587994`*^9}, {
   3.556417926273054*^9, 3.5564180029951153`*^9}, {3.5564181395200768`*^9, 
   3.5564181692072573`*^9}, {3.56253442823825*^9, 3.562534485927789*^9}, {
   3.56788265970753*^9, 3.5678826705651493`*^9}, {3.567882757582102*^9, 
   3.5678827606709075`*^9}, {3.5679048805569677`*^9, 
   3.5679049276470337`*^9}, {3.5679051315789194`*^9, 3.567905143588937*^9}, {
   3.5679053474048223`*^9, 3.567905401494898*^9}, {3.567905579779948*^9, 
   3.567905629962019*^9}, {3.567905674832082*^9, 3.567905712726935*^9}, {
   3.5679058971095934`*^9, 3.5679059548096743`*^9}, 3.567947666443416*^9, {
   3.567947956808223*^9, 3.5679481971153603`*^9}, {3.567948349812374*^9, 
   3.5679483540123796`*^9}, {3.5679485003666286`*^9, 3.567948517836653*^9}, {
   3.567948557716709*^9, 3.5679485666567216`*^9}, {3.5679486439668293`*^9, 
   3.567948744559371*^9}, {3.567949174149973*^9, 3.567949190279996*^9}, {
   3.5679492586924915`*^9, 3.567949265482501*^9}, {3.5679493054025574`*^9, 
   3.5679493123925667`*^9}, {3.567949344575012*^9, 3.5679493979350867`*^9}, {
   3.567949503257634*^9, 3.5679496443226323`*^9}, {3.5679496894326954`*^9, 
   3.5679496907026973`*^9}, {3.567949738135164*^9, 3.5679497575651913`*^9}, {
   3.567951797916055*^9, 3.5679518015560603`*^9}, {3.5680538110760365`*^9, 
   3.568053884082986*^9}, {3.568053979578285*^9, 3.568054054267505*^9}, {
   3.56805408883703*^9, 3.568054104514927*^9}, {3.5689873101826115`*^9, 
   3.568987311586614*^9}, {3.568987771194628*^9, 3.568987774143033*^9}, {
   3.5689878901344376`*^9, 3.5689878981684523`*^9}, {3.568987937386921*^9, 
   3.5689880431395063`*^9}, 3.5843014603456545`*^9, 3.584301503775716*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Solve least squares and form line for graphics", "Section",
 CellChangeTimes->{{3.5843015083257217`*^9, 3.5843015456057744`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Solve", " ", "the", " ", "least", " ", "squares", " ", 
    RowBox[{"system", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Print", "[", "\"\<Least squares line coefficients:\>\"", "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"coeffs", "=", 
    RowBox[{"LinearSolve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Transpose", "[", "mat", "]"}], ".", "mat"}], ",", 
      RowBox[{
       RowBox[{"Transpose", "[", "mat", "]"}], ".", "data"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"the", " ", "least", " ", "squares", " ", 
     RowBox[{"line", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"line", "[", "x_", "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"coeffs", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "*", "x"}], "+", 
      RowBox[{"coeffs", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lineplot", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"line", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1", ",", "length"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.01", "]"}], ",", " ", "Black"}], 
         "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"pic", "=", 
     RowBox[{"Show", "[", 
      RowBox[{"{", 
       RowBox[{"datplot", ",", "lineplot"}], "}"}], "]"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"-", "Better"}]}]}]}]}], " ", "than", " ", "above", " ", 
     RowBox[{"plot", ":", " ", 
      RowBox[{
       RowBox[{"uses", " ", "date", " ", "in", " ", 
        RowBox[{
         RowBox[{"plot", " ", "--"}], "--"}]}], "-", 
       RowBox[{"--", "--"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"the", " ", "data", " ", "run", " ", "from", " ", "1"}], " ", 
        "..."}], " ", "length"}], ";", " ", 
      RowBox[{"since", " ", "they", " ", "are", " ", "dates"}]}], ",", " ", 
     RowBox[{
      RowBox[{
      "use", " ", "the", " ", "integer", " ", "i", " ", "as", " ", "the", " ",
        "x"}], "-", "coordinate"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"linelist", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"list", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
        RowBox[{"line", "[", "1", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"list", "[", 
         RowBox[{"[", 
          RowBox[{"length", ",", "1"}], "]"}], "]"}], ",", 
        RowBox[{"line", "[", "length", "]"}]}], "}"}]}], "}"}]}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"pic", " ", "=", 
    RowBox[{"DateListPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"list", ",", "linelist"}], "}"}], ",", 
      RowBox[{"Joined", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"False", ",", "True"}], "}"}]}], ",", " ", 
      RowBox[{"GridLines", "\[Rule]", "False"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Automatic", ",", "None"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.005", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0", "]"}], ",", " ", 
           RowBox[{"Thickness", "[", "0.009", "]"}]}], "}"}]}], "}"}]}]}], 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<lsq_Dow.eps\>\"", ",", "pic"}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5562232910449495`*^9, 3.556223445675123*^9}, {
   3.556223501633399*^9, 3.5562235029438243`*^9}, {3.55622355732647*^9, 
   3.5562236229725323`*^9}, {3.5562237423616285`*^9, 3.556223790348151*^9}, {
   3.5562240731697826`*^9, 3.5562241075825005`*^9}, {3.5562242107764373`*^9, 
   3.5562242889168377`*^9}, {3.5562243303348374`*^9, 3.556224376120837*^9}, {
   3.55622441025364*^9, 3.556224466320759*^9}, {3.5562247655169945`*^9, 
   3.5562249432500734`*^9}, {3.5562251930728493`*^9, 3.556225294927208*^9}, {
   3.556225331775117*^9, 3.556225341135297*^9}, {3.556372110172995*^9, 
   3.5563721420330963`*^9}, {3.556372207032649*^9, 3.556372241356609*^9}, {
   3.5563722910171385`*^9, 3.55637231009814*^9}, {3.556372398638355*^9, 
   3.556372404520233*^9}, {3.5563725707292457`*^9, 3.5563726082177277`*^9}, {
   3.5563729619470067`*^9, 3.556372963319842*^9}, {3.5563730041772895`*^9, 
   3.556373034910077*^9}, {3.5563732031753683`*^9, 3.556373220164095*^9}, {
   3.5563751493745923`*^9, 3.556375343927513*^9}, {3.5563753740827*^9, 
   3.5563753826628103`*^9}, {3.556375422646123*^9, 3.556375423644535*^9}, 
   3.556397167661307*^9, {3.556397215741123*^9, 3.5563972634777355`*^9}, {
   3.556397805408103*^9, 3.5563980967087708`*^9}, 3.5563982686689296`*^9, 
   3.5563983072638245`*^9, {3.5563983619431615`*^9, 3.556398437980486*^9}, {
   3.556399599735585*^9, 3.5563996541348777`*^9}, {3.556399727191514*^9, 
   3.556399758766521*^9}, {3.5563998810884733`*^9, 3.5563999199800215`*^9}, {
   3.5563999578263493`*^9, 3.5563999919285064`*^9}, {3.5564001643107166`*^9, 
   3.556400253575061*^9}, {3.556400334930104*^9, 3.5564003712785697`*^9}, {
   3.5564066189968443`*^9, 3.556406623365012*^9}, {3.5564066674679084`*^9, 
   3.556406669667593*^9}, {3.556406934750961*^9, 3.55640694874443*^9}, {
   3.556407000334622*^9, 3.5564070417066174`*^9}, {3.55640735219796*^9, 
   3.5564073582508373`*^9}, {3.5564075366391244`*^9, 
   3.5564075462176476`*^9}, {3.556417673377757*^9, 3.5564177899587994`*^9}, {
   3.556417926273054*^9, 3.5564180029951153`*^9}, {3.5564181395200768`*^9, 
   3.5564181692072573`*^9}, {3.56253442823825*^9, 3.562534485927789*^9}, {
   3.56788265970753*^9, 3.5678826705651493`*^9}, {3.567882757582102*^9, 
   3.5678827606709075`*^9}, {3.5679048805569677`*^9, 
   3.5679049276470337`*^9}, {3.5679051315789194`*^9, 3.567905143588937*^9}, {
   3.5679053474048223`*^9, 3.567905401494898*^9}, {3.567905579779948*^9, 
   3.567905629962019*^9}, {3.567905674832082*^9, 3.567905712726935*^9}, {
   3.5679058971095934`*^9, 3.5679059548096743`*^9}, 3.567947666443416*^9, {
   3.567947956808223*^9, 3.5679481971153603`*^9}, {3.567948349812374*^9, 
   3.5679483540123796`*^9}, {3.5679485003666286`*^9, 3.567948517836653*^9}, {
   3.567948557716709*^9, 3.5679485666567216`*^9}, {3.5679486439668293`*^9, 
   3.567948744559371*^9}, {3.567949174149973*^9, 3.567949190279996*^9}, {
   3.5679492586924915`*^9, 3.567949265482501*^9}, {3.5679493054025574`*^9, 
   3.5679493123925667`*^9}, {3.567949344575012*^9, 3.5679493979350867`*^9}, {
   3.567949503257634*^9, 3.5679496443226323`*^9}, {3.5679496894326954`*^9, 
   3.5679496907026973`*^9}, {3.567949738135164*^9, 3.5679497575651913`*^9}, {
   3.567951797916055*^9, 3.5679518015560603`*^9}, {3.5680538110760365`*^9, 
   3.568053884082986*^9}, {3.568053979578285*^9, 3.568054054267505*^9}, {
   3.56805408883703*^9, 3.568054104514927*^9}, {3.5689873101826115`*^9, 
   3.568987311586614*^9}, {3.568987771194628*^9, 3.568987774143033*^9}, {
   3.5689878901344376`*^9, 3.5689878981684523`*^9}, {3.568987937386921*^9, 
   3.5689880431395063`*^9}, 3.5843014603456545`*^9, 3.584301503775716*^9, {
   3.5843017387000475`*^9, 3.5843017489800615`*^9}}],

Cell[BoxData["\<\"Least squares line coefficients:\"\>"], "Print",
 CellChangeTimes->{3.5680541066510487`*^9, 3.56898728645497*^9, 
  3.568987316750223*^9, 3.5689877814126453`*^9, 3.5689879087608705`*^9, 
  3.5689879788517933`*^9, 3.5689880495979176`*^9, 3.584301579965822*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.462748811516643`"}], ",", "1477.9342107789028`"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.5679496079701815`*^9, 3.567949646142635*^9}, 
   3.5679496928127003`*^9, {3.567949739925166*^9, 3.5679497595351934`*^9}, 
   3.5679508466927214`*^9, 3.567951223454049*^9, {3.5679513679358516`*^9, 
   3.5679513857158766`*^9}, 3.56796149047641*^9, 3.568050397203508*^9, 
   3.5680526826105795`*^9, 3.568053854459298*^9, 3.5680540634900327`*^9, 
   3.5680541066650496`*^9, 3.56898728645497*^9, 3.568987316750223*^9, 
   3.5689877814126453`*^9, 3.56898790877647*^9, 3.5689879788517933`*^9, 
   3.5689880496135178`*^9, 3.5843015799958224`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2000", ",", "1", ",", "3"}], "}"}], ",", 
     "1477.4714619673862`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2013", ",", "7", ",", "30"}], "}"}], ",", 
     RowBox[{"-", "101.89023173891633`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.5679496079701815`*^9, 3.567949646142635*^9}, 
   3.5679496928127003`*^9, {3.567949739925166*^9, 3.5679497595351934`*^9}, 
   3.5679508466927214`*^9, 3.567951223454049*^9, {3.5679513679358516`*^9, 
   3.5679513857158766`*^9}, 3.56796149047641*^9, 3.568050397203508*^9, 
   3.5680526826105795`*^9, 3.568053854459298*^9, 3.5680540634900327`*^9, 
   3.5680541066650496`*^9, 3.56898728645497*^9, 3.568987316750223*^9, 
   3.5689877814126453`*^9, 3.56898790877647*^9, 3.5689879788517933`*^9, 
   3.5689880496135178`*^9, 3.5843015800158224`*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, {}, 
    {GrayLevel[0], Thickness[0.009], 
     LineBox[{{3.1558464*^9, 1477.4714619673862`}, {
      3.5841312*^9, -101.89023173891633`}}]}}, {{}, 
    {GrayLevel[0.5], PointSize[0.005], PointBox[CompressedData["
1:eJxUXWW4U0sSDPBwC+4Q3CG4Q3CH4A7BHYI7BHcI7hDcITg8LLhDcIfg3GDB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      "]]}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  AxesOrigin->NCache[{3155846400, 0}, {3.1558464*^9, 0}],
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 10},
  Frame->True,
  FrameTicks->{{Automatic, None}, {{{
       NCache[3155673600, 3.1556736*^9], 
       FormBox["\"2000\"", TraditionalForm]}, {
       NCache[3313526400, 3.3135264*^9], 
       FormBox["\"2005\"", TraditionalForm]}, {
       NCache[3471292800, 3.4712928*^9], 
       FormBox["\"2010\"", TraditionalForm]}, {
       NCache[3629059200, 3.6290592*^9], 
       FormBox["\"2015\"", TraditionalForm]}, {
       NCache[3187296000, 3.187296*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3218832000, 3.218832*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3250368000, 3.250368*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3281904000, 3.281904*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3345062400, 3.3450624*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3376598400, 3.3765984*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3408134400, 3.4081344*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3439756800, 3.4397568*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3502828800, 3.5028288*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3534364800, 3.5343648*^9], 
       FormBox["\"\"", TraditionalForm]}, {
       NCache[3565987200, 3.5659872*^9], 
       FormBox["\"\"", TraditionalForm]}}, None}},
  PlotRange->{{3.1558464*^9, 3.5841312*^9}, {-101.89023173891633`, 1631.8}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->None]], "Output",
 CellChangeTimes->{{3.5679496079701815`*^9, 3.567949646142635*^9}, 
   3.5679496928127003`*^9, {3.567949739925166*^9, 3.5679497595351934`*^9}, 
   3.5679508466927214`*^9, 3.567951223454049*^9, {3.5679513679358516`*^9, 
   3.5679513857158766`*^9}, 3.56796149047641*^9, 3.568050397203508*^9, 
   3.5680526826105795`*^9, 3.568053854459298*^9, 3.5680540634900327`*^9, 
   3.5680541066650496`*^9, 3.56898728645497*^9, 3.568987316750223*^9, 
   3.5689877814126453`*^9, 3.56898790877647*^9, 3.5689879788517933`*^9, 
   3.5689880496135178`*^9, 3.5843015801858225`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["More data sets -- repeat least squares best fit line", "Section",
 CellChangeTimes->{{3.5843017676400876`*^9, 3.584301808760145*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"For", " ", "example", " ", "in", " ", "gensys"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"experiment1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "30"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "25"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "40"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"30", ",", "40"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"40", ",", "30"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"50", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"60", ",", "25"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"For", " ", "exercises"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"experiment2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"experiment3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "2"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"experiment4", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "4"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "3"}], "}"}]}], "}"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"experiment", " ", "=", " ", "experiment1"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"elngth", " ", "=", " ", 
     RowBox[{"Length", "[", "experiment", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"emat", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"experiment", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "elngth"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"edata", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"experiment", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "elngth"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<matrix =\>\"", ",", 
      RowBox[{"MatrixForm", "[", "emat", "]"}], ",", "\"\<  rhs=\>\"", ",", 
      RowBox[{"MatrixForm", "[", "edata", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"Solve", " ", "the", " ", "least", " ", "squares", " ", 
     RowBox[{"system", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ecoeffs", "=", 
     RowBox[{"LinearSolve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Transpose", "[", "emat", "]"}], ".", "emat"}], ",", 
       RowBox[{
        RowBox[{"Transpose", "[", "emat", "]"}], ".", "edata"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<normal equations: \>\"", ",", 
      RowBox[{"MatrixForm", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "emat", "]"}], ".", "emat"}], "]"}], ",", 
      "\"\<u =\>\"", ",", 
      RowBox[{"MatrixForm", "[", 
       RowBox[{
        RowBox[{"Transpose", "[", "emat", "]"}], ".", "edata"}], "]"}]}], 
     "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
     "\"\<coefficients =\>\"", ",", "ecoeffs", ",", "\"\<  as decimal \>\"", 
      ",", 
      RowBox[{"ecoeffs", "//", "N"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"eline", "[", "x_", "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{"ecoeffs", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "*", "x"}], "+", 
      RowBox[{"ecoeffs", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"elinelist", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"experiment", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
         RowBox[{"eline", "[", 
          RowBox[{"experiment", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "1"}], "]"}], "]"}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"experiment", "[", 
          RowBox[{"[", 
           RowBox[{"elngth", ",", "1"}], "]"}], "]"}], ",", 
         RowBox[{"eline", "[", 
          RowBox[{"experiment", "[", 
           RowBox[{"[", 
            RowBox[{"elngth", ",", "1"}], "]"}], "]"}], "]"}]}], "}"}]}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Line approx: end1=\>\"", ",", 
      RowBox[{"elinelist", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", "\"\<  end2=\>\"", ",", 
      RowBox[{"elinelist", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"pic2", " ", "=", " ", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"experiment", ",", "elinelist"}], "}"}], ",", 
      RowBox[{"Joined", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"False", ",", "True"}], "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", 
           RowBox[{"PointSize", "[", "0.02", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0", "]"}], ",", 
           RowBox[{"Thickness", "[", "0.008", "]"}]}], "}"}]}], "}"}]}]}], 
     "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<lsq_experiment.eps\>\"", ",", "pic2"}], "]"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5679499849415135`*^9, 3.5679500025915384`*^9}, {
   3.5679500711352344`*^9, 3.567950202285418*^9}, {3.5679502616487017`*^9, 
   3.5679503113987713`*^9}, {3.5679503543624315`*^9, 3.567950646957641*^9}, {
   3.5679507305901585`*^9, 3.5679507643902063`*^9}, {3.567950809472669*^9, 
   3.5679508644927464`*^9}, 3.567950894805189*^9, {3.5679509752453012`*^9, 
   3.567951042287795*^9}, 3.567951093420267*^9, {3.5679511466503415`*^9, 
   3.5679511871203985`*^9}, {3.567951246774082*^9, 3.5679512774041247`*^9}, 
   3.567951337734209*^9, {3.5679513756358624`*^9, 3.5679513793058677`*^9}, {
   3.567951415078318*^9, 3.5679514417683554`*^9}, {3.5679514810684104`*^9, 
   3.567951545722101*^9}, {3.5679515796421485`*^9, 3.5679516337722244`*^9}, {
   3.5679516883859005`*^9, 3.567951706825927*^9}, {3.5679517481459846`*^9, 
   3.5679517659360094`*^9}, {3.5679614034906573`*^9, 3.567961483690398*^9}, {
   3.567961532471684*^9, 3.5679615509889164`*^9}, {3.568046879753888*^9, 
   3.5680469336943693`*^9}, {3.568050345402861*^9, 3.5680503923252287`*^9}, {
   3.5680514214825077`*^9, 3.568051458650623*^9}, {3.568051665258252*^9, 
   3.5680517121526995`*^9}, {3.568052136102805*^9, 3.5680521674070487`*^9}, {
   3.56805260360752*^9, 3.5680526600683355`*^9}, {3.5680527169552984`*^9, 
   3.568052731411125*^9}, {3.5680527956975393`*^9, 3.568052860040185*^9}, {
   3.568053547561305*^9, 3.568053547636309*^9}, {3.568053579438116*^9, 
   3.5680535973561287`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "4"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.5679502030054193`*^9, {3.567950271378715*^9, 3.567950311928772*^9}, {
   3.5679507500301857`*^9, 3.567950765240207*^9}, 3.5679508159626784`*^9, {
   3.5679508470327215`*^9, 3.56795089552519*^9}, 3.5679509860653167`*^9, 
   3.567951016547759*^9, 3.567951130520319*^9, 3.5679511882840004`*^9, {
   3.56795122378405*^9, 3.567951278214126*^9}, {3.567951368395852*^9, 
   3.567951386035877*^9}, {3.5679514369583483`*^9, 3.567951442208356*^9}, {
   3.567951482388412*^9, 3.567951515172058*^9}, 3.5679515466521025`*^9, 
   3.567951635502227*^9, 3.567951707535928*^9, 3.567951768636013*^9, 
   3.5679614908196106`*^9, 3.567961551909318*^9, 3.5680503975285263`*^9, {
   3.5680514393405247`*^9, 3.5680514639269247`*^9}, 3.568051713495776*^9, 
   3.5680521682930994`*^9, {3.5680526619064407`*^9, 3.568052682906596*^9}, {
   3.568052724340721*^9, 3.5680527320741634`*^9}, 3.5680528239151316`*^9, 
   3.568052869846746*^9, 3.568053548926383*^9, {3.5680535804021716`*^9, 
   3.5680535983341846`*^9}, 3.568053857927497*^9, 3.568054063831052*^9, 
   3.5689872868449707`*^9, 3.5689873169218235`*^9, 3.568987781709046*^9, 
   3.568987909072871*^9, 3.568987979116994*^9, 3.5689880498943186`*^9, 
   3.584301580335823*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"matrix =\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "1"},
       {"10", "1"},
       {"20", "1"},
       {"30", "1"},
       {"40", "1"},
       {"50", "1"},
       {"60", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"  rhs=\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"30"},
        {"25"},
        {"40"},
        {"40"},
        {"30"},
        {"5"},
        {"25"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["matrix =", 
   MatrixForm[{{0, 1}, {10, 1}, {20, 1}, {30, 1}, {40, 1}, {50, 1}, {60, 1}}],
    "  rhs=", 
   MatrixForm[{30, 25, 40, 40, 30, 5, 25}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5679509860753164`*^9, 3.5679510165577593`*^9, 3.567951130520319*^9, 
   3.567951188294*^9, {3.56795122379405*^9, 3.567951278214126*^9}, {
   3.567951368395852*^9, 3.567951386035877*^9}, {3.5679514369583483`*^9, 
   3.567951442208356*^9}, {3.567951482398412*^9, 3.567951515172058*^9}, 
   3.5679515466621027`*^9, 3.567951635502227*^9, 3.5679517075459275`*^9, 
   3.5679517686460133`*^9, 3.5679614908196106`*^9, 3.567961551909318*^9, 
   3.5680503975215263`*^9, {3.5680514393325243`*^9, 3.568051463917924*^9}, 
   3.568051713485776*^9, 3.5680521682970996`*^9, {3.5680526619094405`*^9, 
   3.5680526829105964`*^9}, {3.5680527243447213`*^9, 3.568052732077163*^9}, 
   3.568052823918132*^9, 3.5680528698497467`*^9, 3.568053548931383*^9, {
   3.568053580404172*^9, 3.568053598337185*^9}, 3.5680538579304967`*^9, 
   3.568054063834052*^9, 3.568987286860571*^9, 3.5689873169218235`*^9, 
   3.568987781709046*^9, 3.568987909088471*^9, 3.568987979132594*^9, 
   3.5689880498943186`*^9, 3.584301580335823*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"normal equations: \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"9100", "210"},
       {"210", "7"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"u =\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"5200"},
        {"195"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["normal equations: ", 
   MatrixForm[{{9100, 210}, {210, 7}}], "u =", 
   MatrixForm[{5200, 195}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5679509860753164`*^9, 3.5679510165577593`*^9, 3.567951130520319*^9, 
   3.567951188294*^9, {3.56795122379405*^9, 3.567951278214126*^9}, {
   3.567951368395852*^9, 3.567951386035877*^9}, {3.5679514369583483`*^9, 
   3.567951442208356*^9}, {3.567951482398412*^9, 3.567951515172058*^9}, 
   3.5679515466621027`*^9, 3.567951635502227*^9, 3.5679517075459275`*^9, 
   3.5679517686460133`*^9, 3.5679614908196106`*^9, 3.567961551909318*^9, 
   3.5680503975215263`*^9, {3.5680514393325243`*^9, 3.568051463917924*^9}, 
   3.568051713485776*^9, 3.5680521682970996`*^9, {3.5680526619094405`*^9, 
   3.5680526829105964`*^9}, {3.5680527243447213`*^9, 3.568052732077163*^9}, 
   3.568052823918132*^9, 3.5680528698497467`*^9, 3.568053548931383*^9, {
   3.568053580404172*^9, 3.568053598337185*^9}, 3.5680538579304967`*^9, 
   3.568054063834052*^9, 3.568987286860571*^9, 3.5689873169218235`*^9, 
   3.568987781709046*^9, 3.568987909088471*^9, 3.568987979132594*^9, 
   3.5689880498943186`*^9, 3.584301580335823*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"coefficients =\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["13", "56"]}], ",", 
     FractionBox["975", "28"]}], "}"}], 
   "\[InvisibleSpace]", "\<\"  as decimal \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.23214285714285715`"}], ",", "34.82142857142857`"}], 
    "}"}]}],
  SequenceForm["coefficients =", {
    Rational[-13, 56], 
    Rational[975, 28]}, "  as decimal ", {-0.23214285714285715`, 
   34.82142857142857}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5679509860753164`*^9, 3.5679510165577593`*^9, 3.567951130520319*^9, 
   3.567951188294*^9, {3.56795122379405*^9, 3.567951278214126*^9}, {
   3.567951368395852*^9, 3.567951386035877*^9}, {3.5679514369583483`*^9, 
   3.567951442208356*^9}, {3.567951482398412*^9, 3.567951515172058*^9}, 
   3.5679515466621027`*^9, 3.567951635502227*^9, 3.5679517075459275`*^9, 
   3.5679517686460133`*^9, 3.5679614908196106`*^9, 3.567961551909318*^9, 
   3.5680503975215263`*^9, {3.5680514393325243`*^9, 3.568051463917924*^9}, 
   3.568051713485776*^9, 3.5680521682970996`*^9, {3.5680526619094405`*^9, 
   3.5680526829105964`*^9}, {3.5680527243447213`*^9, 3.568052732077163*^9}, 
   3.568052823918132*^9, 3.5680528698497467`*^9, 3.568053548931383*^9, {
   3.568053580404172*^9, 3.568053598337185*^9}, 3.5680538579304967`*^9, 
   3.568054063834052*^9, 3.568987286860571*^9, 3.5689873169218235`*^9, 
   3.568987781709046*^9, 3.568987909088471*^9, 3.568987979132594*^9, 
   3.5689880498943186`*^9, 3.584301580335823*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Line approx: end1=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox["975", "28"]}], "}"}], 
   "\[InvisibleSpace]", "\<\"  end2=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"60", ",", 
     FractionBox["585", "28"]}], "}"}]}],
  SequenceForm["Line approx: end1=", {0, 
    Rational[975, 28]}, "  end2=", {60, 
    Rational[585, 28]}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5679509860753164`*^9, 3.5679510165577593`*^9, 3.567951130520319*^9, 
   3.567951188294*^9, {3.56795122379405*^9, 3.567951278214126*^9}, {
   3.567951368395852*^9, 3.567951386035877*^9}, {3.5679514369583483`*^9, 
   3.567951442208356*^9}, {3.567951482398412*^9, 3.567951515172058*^9}, 
   3.5679515466621027`*^9, 3.567951635502227*^9, 3.5679517075459275`*^9, 
   3.5679517686460133`*^9, 3.5679614908196106`*^9, 3.567961551909318*^9, 
   3.5680503975215263`*^9, {3.5680514393325243`*^9, 3.568051463917924*^9}, 
   3.568051713485776*^9, 3.5680521682970996`*^9, {3.5680526619094405`*^9, 
   3.5680526829105964`*^9}, {3.5680527243447213`*^9, 3.568052732077163*^9}, 
   3.568052823918132*^9, 3.5680528698497467`*^9, 3.568053548931383*^9, {
   3.568053580404172*^9, 3.568053598337185*^9}, 3.5680538579304967`*^9, 
   3.568054063834052*^9, 3.568987286860571*^9, 3.5689873169218235`*^9, 
   3.568987781709046*^9, 3.568987909088471*^9, 3.568987979132594*^9, 
   3.5689880498943186`*^9, 3.584301580335823*^9}]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[{{{}, {}, {}, 
    {GrayLevel[0], Thickness[0.008], 
     LineBox[{{0., 34.82142857142857}, {60., 20.892857142857142`}}]}}, {{}, 
    {GrayLevel[0.5], PointSize[0.02], 
     PointBox[{{0., 30.}, {10., 25.}, {20., 40.}, {30., 40.}, {40., 30.}, {
      50., 5.}, {60., 25.}}]}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 10},
  PlotRange->{{0., 60.}, {0, 40.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5679502030054193`*^9, {3.567950271378715*^9, 3.567950311928772*^9}, {
   3.5679507500301857`*^9, 3.567950765240207*^9}, 3.5679508159626784`*^9, {
   3.5679508470327215`*^9, 3.56795089552519*^9}, 3.5679509860653167`*^9, 
   3.567951016547759*^9, 3.567951130520319*^9, 3.5679511882840004`*^9, {
   3.56795122378405*^9, 3.567951278214126*^9}, {3.567951368395852*^9, 
   3.567951386035877*^9}, {3.5679514369583483`*^9, 3.567951442208356*^9}, {
   3.567951482388412*^9, 3.567951515172058*^9}, 3.5679515466521025`*^9, 
   3.567951635502227*^9, 3.567951707535928*^9, 3.567951768636013*^9, 
   3.5679614908196106`*^9, 3.567961551909318*^9, 3.5680503975285263`*^9, {
   3.5680514393405247`*^9, 3.5680514639269247`*^9}, 3.568051713495776*^9, 
   3.5680521682930994`*^9, {3.5680526619064407`*^9, 3.568052682906596*^9}, {
   3.568052724340721*^9, 3.5680527320741634`*^9}, 3.5680528239151316`*^9, 
   3.568052869846746*^9, 3.568053548926383*^9, {3.5680535804021716`*^9, 
   3.5680535983341846`*^9}, 3.568053857927497*^9, 3.568054063831052*^9, 
   3.5689872868449707`*^9, 3.5689873169218235`*^9, 3.568987781709046*^9, 
   3.568987909072871*^9, 3.568987979116994*^9, 3.5689880498943186`*^9, 
   3.584301580345823*^9}]
}, Open  ]],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{{3.5680468243462024`*^9, 3.568046872233077*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1142, 688},
WindowMargins->{{Automatic, 114}, {Automatic, 25}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 673, 13, 135, "Subtitle"],
Cell[1255, 37, 2477, 38, 145, "Subsubtitle"],
Cell[CellGroupData[{
Cell[3757, 79, 380, 5, 71, "Section"],
Cell[4140, 86, 5200, 92, 132, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9377, 183, 124, 2, 71, "Section"],
Cell[9504, 187, 5329, 101, 212, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14870, 293, 135, 1, 71, "Section"],
Cell[CellGroupData[{
Cell[15030, 298, 8164, 171, 412, "Input"],
Cell[23197, 471, 277, 3, 23, "Print"],
Cell[23477, 476, 691, 12, 30, "Output"],
Cell[24171, 490, 928, 20, 30, "Output"],
Cell[25102, 512, 33854, 568, 237, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[59005, 1086, 139, 1, 71, "Section"],
Cell[CellGroupData[{
Cell[59169, 1091, 8450, 219, 652, "Input"],
Cell[67622, 1312, 1419, 25, 30, "Output"],
Cell[CellGroupData[{
Cell[69066, 1341, 2790, 69, 110, "Print"],
Cell[71859, 1412, 2575, 58, 36, "Print"],
Cell[74437, 1472, 1610, 32, 40, "Print"],
Cell[76050, 1506, 1485, 28, 40, "Print"]
}, Open  ]],
Cell[77550, 1537, 1829, 33, 247, "Output"]
}, Open  ]],
Cell[79394, 1573, 113, 1, 52, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
