(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     19614,        571]
NotebookOptionsPosition[     18763,        536]
NotebookOutlinePosition[     19106,        551]
CellTagsIndexPosition[     19063,        548]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 "\n"
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
  3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
  3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
  3.5842134956497355`*^9, 3.5842135862546945`*^9}},
 FontFamily->"Arial"],

Cell[TextData[{
 StyleBox["LU Decomposition for solving a linear system",
  FontWeight->"Bold"],
 "\nCompute the LU decomposition of a matrix using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s routine.\nUse this decompositon to solve a linear \
system."
}], "Subsubtitle",
 CellChangeTimes->{{3.5843636610855236`*^9, 3.584363703855583*^9}, {
  3.584363824445752*^9, 3.5843638381157713`*^9}, {3.584366906332074*^9, 
  3.584366916142088*^9}, {3.5843669467121305`*^9, 3.584366950282136*^9}}],

Cell[CellGroupData[{

Cell["\<\

Input linear system
--- choose one matrix/right-hand side pair and load into m,b\
\>", "Section",
 CellChangeTimes->{{3.5843645599607844`*^9, 3.5843645872008224`*^9}, {
  3.5843647776010895`*^9, 3.5843648073911304`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"m0", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "0", ",", 
         RowBox[{"-", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "2", ",", 
         RowBox[{"-", "4"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b0", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "4", ",", "0"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "same", " ", "as", " ", "m0", " ", "but", " ", "requires", " ", 
     "pivoting"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "0", ",", 
         RowBox[{"-", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "2", ",", 
         RowBox[{"-", "4"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"4", ",", 
       RowBox[{"-", "2"}], ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"example", " ", "in", " ", "section", " ", "12.5"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "2", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "2", ",", 
         RowBox[{"-", "3"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "2"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Load", " ", "system", " ", "to", " ", "use"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m", " ", "=", " ", "m0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", " ", "=", " ", "b0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<m=   \>\"", ",", 
      RowBox[{"MatrixForm", "[", "m", "]"}], ",", "\"\<  b=\>\"", ",", 
      RowBox[{"MatrixForm", "[", "b", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.584364590930828*^9, 3.5843646258208766`*^9}, {
  3.584364660870926*^9, 3.5843647413710384`*^9}, {3.5843648181311455`*^9, 
  3.5843648335611677`*^9}, {3.58436487111122*^9, 3.584364871981221*^9}, {
  3.5843669601921496`*^9, 3.5843669640921555`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"m=   \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"4", "0", 
        RowBox[{"-", "2"}]},
       {"0", 
        RowBox[{"-", "2"}], "0"},
       {"4", "2", 
        RowBox[{"-", "4"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"  b=\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         RowBox[{"-", "2"}]},
        {"4"},
        {"0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["m=   ", 
   MatrixForm[{{4, 0, -2}, {0, -2, 0}, {4, 2, -4}}], "  b=", 
   MatrixForm[{-2, 4, 0}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.584366069122897*^9, 3.5843669693221626`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

Find the LU decomposition of matrix m\
\>", "Section",
 CellChangeTimes->{{3.584364891811249*^9, 3.584364908191272*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "lu", " ", "is", " ", "lower", " ", "and", " ", "upper", " ", "matrices", 
     " ", "combined"}], ",", " ", 
    RowBox[{"p", " ", "is", " ", "the", " ", "pivoting", " ", "vector"}], ",",
     " ", 
    RowBox[{"c", " ", "is", " ", "a", " ", 
     RowBox[{"norm", " ", "--"}], " ", "not", " ", "used", " ", "here"}]}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lu", ",", " ", "p", ",", " ", "c"}], "}"}], " ", "=", " ", 
     RowBox[{"LUDecomposition", "[", "m", "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Lower L and upper U matrices combined = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "lu", "]"}], ",", "\"\<  pivoting=\>\"", ",", 
      RowBox[{"MatrixForm", "[", "p", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"l", "=", 
     RowBox[{
      RowBox[{"lu", " ", 
       RowBox[{"SparseArray", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
           RowBox[{"j", "<", "i"}]}], "\[Rule]", "1"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "3"}], "}"}]}], "]"}]}], "+", 
      RowBox[{"IdentityMatrix", "[", "3", "]"}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"u", "=", 
     RowBox[{"lu", " ", 
      RowBox[{"SparseArray", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
          RowBox[{"j", "\[GreaterEqual]", "i"}]}], "\[Rule]", "1"}], ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "3"}], "}"}]}], "]"}]}]}], ";"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<L = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "l", "]"}], ",", "\"\<   U = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "u", "]"}], ",", "\"\<    LU= \>\"", ",", 
      RowBox[{"MatrixForm", "[", 
       RowBox[{"l", ".", "u"}], "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Use", " ", 
     RowBox[{"M", "'"}], "s", " ", "forward", " ", "and", " ", "back", " ", 
     "substitution"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"y", " ", "=", " ", 
     RowBox[{"LinearSolve", "[", 
      RowBox[{"l", ",", 
       RowBox[{"b", "[", 
        RowBox[{"[", "p", "]"}], "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"soln", "=", " ", 
     RowBox[{"LinearSolve", "[", 
      RowBox[{"u", ",", "y"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<solution = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "soln", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<check if correct: m.soln = \>\"", ",", 
      RowBox[{"MatrixForm", "[", 
       RowBox[{"m", ".", "soln"}], "]"}], ",", "\"\<  =? b =\>\"", ",", 
      RowBox[{"MatrixForm", "[", "b", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", " ", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5681382352299*^9, 3.568138290438397*^9}, {
   3.568138364351327*^9, 3.5681384117442102`*^9}, 3.56813854827565*^9, {
   3.568138584296113*^9, 3.5681386278981895`*^9}, {3.584363846455783*^9, 
   3.584363868475814*^9}, {3.584363905235865*^9, 3.584363911995875*^9}, {
   3.584364848451188*^9, 3.584364868921217*^9}, {3.5843649127712784`*^9, 
   3.5843649542813363`*^9}, {3.5843663747653265`*^9, 3.584366803295926*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Lower L and upper U matrices combined = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"4", "0", 
        RowBox[{"-", "2"}]},
       {"0", 
        RowBox[{"-", "2"}], "0"},
       {"1", 
        RowBox[{"-", "1"}], 
        RowBox[{"-", "2"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"  pivoting=\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"1"},
        {"2"},
        {"3"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Lower L and upper U matrices combined = ", 
   MatrixForm[{{4, 0, -2}, {0, -2, 0}, {1, -1, -2}}], "  pivoting=", 
   MatrixForm[{1, 2, 3}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.568138413834614*^9, 3.568138549461252*^9, {3.568138612625763*^9, 
   3.568138629333392*^9}, 3.584366069182897*^9, 3.5843664138253813`*^9, 
   3.58436649169549*^9, 3.5843665318855467`*^9, 3.5843667512058535`*^9, 
   3.5843669693621626`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"L = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0"},
       {"0", "1", "0"},
       {"1", 
        RowBox[{"-", "1"}], "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"   U = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"4", "0", 
        RowBox[{"-", "2"}]},
       {"0", 
        RowBox[{"-", "2"}], "0"},
       {"0", "0", 
        RowBox[{"-", "2"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"    LU= \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"4", "0", 
        RowBox[{"-", "2"}]},
       {"0", 
        RowBox[{"-", "2"}], "0"},
       {"4", "2", 
        RowBox[{"-", "4"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["L = ", 
   MatrixForm[{{1, 0, 0}, {0, 1, 0}, {1, -1, 1}}], "   U = ", 
   MatrixForm[{{4, 0, -2}, {0, -2, 0}, {0, 0, -2}}], "    LU= ", 
   MatrixForm[{{4, 0, -2}, {0, -2, 0}, {4, 2, -4}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.568138413834614*^9, 3.568138549461252*^9, {3.568138612625763*^9, 
   3.568138629333392*^9}, 3.584366069182897*^9, 3.5843664138253813`*^9, 
   3.58436649169549*^9, 3.5843665318855467`*^9, 3.5843667512058535`*^9, 
   3.5843669693621626`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"solution = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         RowBox[{"-", "2"}]},
        {
         RowBox[{"-", "2"}]},
        {
         RowBox[{"-", "3"}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["solution = ", 
   MatrixForm[{-2, -2, -3}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.568138413834614*^9, 3.568138549461252*^9, {3.568138612625763*^9, 
   3.568138629333392*^9}, 3.584366069182897*^9, 3.5843664138253813`*^9, 
   3.58436649169549*^9, 3.5843665318855467`*^9, 3.5843667512058535`*^9, 
   3.5843669693621626`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"check if correct: m.soln = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         RowBox[{"-", "2"}]},
        {"4"},
        {"0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"  =? b =\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         RowBox[{"-", "2"}]},
        {"4"},
        {"0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["check if correct: m.soln = ", 
   MatrixForm[{-2, 4, 0}], "  =? b =", 
   MatrixForm[{-2, 4, 0}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.568138413834614*^9, 3.568138549461252*^9, {3.568138612625763*^9, 
   3.568138629333392*^9}, 3.584366069182897*^9, 3.5843664138253813`*^9, 
   3.58436649169549*^9, 3.5843665318855467`*^9, 3.5843667512058535`*^9, 
   3.5843669693621626`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{966, 721},
WindowMargins->{{Automatic, 26}, {Automatic, -7}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 673, 13, 135, "Subtitle"],
Cell[1255, 37, 517, 11, 68, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1797, 52, 231, 6, 123, "Section"],
Cell[CellGroupData[{
Cell[2053, 62, 2934, 81, 332, "Input"],
Cell[4990, 145, 1740, 50, 50, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6779, 201, 131, 4, 97, "Section"],
Cell[CellGroupData[{
Cell[6935, 209, 3825, 94, 452, "Input"],
Cell[CellGroupData[{
Cell[10785, 307, 2025, 55, 50, "Print"],
Cell[12813, 364, 2772, 75, 50, "Print"],
Cell[15588, 441, 1176, 33, 50, "Print"],
Cell[16767, 476, 1944, 54, 50, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
