(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      9179,        253]
NotebookOptionsPosition[      8741,        233]
NotebookOutlinePosition[      9084,        248]
CellTagsIndexPosition[      9041,        245]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9},
 FontFamily->"Arial"],

Cell[TextData[{
 StyleBox["Linear Combinations",
  FontWeight->"Bold"],
 "\nInput vector a is blue;\nInput vector b is green;\nResult of the linear \
combination is red. \nresult vector = s*a + t*b\n\nNote that as we change s, \
the result changes parallel to a, and as we change t, it changes parallel to \
b."
}], "Subsubtitle",
 CellChangeTimes->{{3.5847368559477196`*^9, 3.584736865207733*^9}, {
  3.584736913957801*^9, 3.5847369821778965`*^9}, {3.5847371722681627`*^9, 
  3.5847372099382153`*^9}, {3.5847377282889414`*^9, 3.584737732498947*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Input", " ", "vectors"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Select", " ", "a", " ", "set", " ", "and", " ", "load", " ", "into", " ",
      "a"}], ",", "b"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"a0", " ", "=", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], ";", "  ", 
    RowBox[{"b0", " ", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a1", "=", 
     RowBox[{"{", 
      StyleBox[
       RowBox[{"2", ",", "1"}],
       FontColor->GrayLevel[0]], "}"}]}], ";", "  ", 
    RowBox[{"b1", " ", "=", 
     RowBox[{"{", 
      StyleBox[
       RowBox[{
        RowBox[{"-", "2"}], ",", "1"}],
       FontColor->GrayLevel[0]], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", " ", "=", " ", "a1"}], ";"}], "   ", 
   RowBox[{"(*", 
    RowBox[{"in", " ", "blue"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", " ", "b1"}], ";", "  ", 
    RowBox[{"(*", " ", 
     RowBox[{"in", " ", "green"}], " ", "*)"}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{"create", " ", "a", " ", "range", " ", "for", " ", "plotting"}], 
     " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"lgth", " ", "=", " ", 
     RowBox[{"Norm", "[", "a", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Norm", "[", "b", "]"}], " ", ">", " ", "lgth"}], ",", 
      RowBox[{"lgth", " ", "=", " ", 
       RowBox[{"Norm", "[", "b", "]"}]}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "graphics", " ", "entities", " ", "for", " ", "input", " ", "vectors"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"arrowa", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", "a"}], "}"}], "]"}]}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"arrowb", " ", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", "b"}], "}"}], "]"}]}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "Blue", ",", "arrowa", ",", " ", "Green", ",", "arrowb", ",", "Red", 
         ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}], ",", 
              RowBox[{
               RowBox[{"s", "*", "a"}], "+", 
               RowBox[{"t", "*", "b"}]}]}], "}"}], "]"}]}], "}"}]}], " ", 
        "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "lgth"}], ",", "lgth"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "lgth"}], ",", "lgth"}], "}"}]}], "}"}]}]}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", "0.5"}], "}"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "0.5"}], "}"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", " ", 
     RowBox[{"Alignment", "\[Rule]", "Left"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\< \>\"", ",", "\"\< \>\"", ",", "\"\<red = s*blue + t*green\>\"", 
        ",", "\"\< \>\""}], "}"}]}]}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5847368384476953`*^9, 3.584736838767696*^9}, {
  3.5847370457279854`*^9, 3.584737055147999*^9}, {3.5847373217983723`*^9, 
  3.5847373397883973`*^9}, {3.5847373995584807`*^9, 3.584737632378807*^9}, {
  3.5847376733988647`*^9, 3.5847376874188843`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`s$$ = 0.8880000000000001, $CellContext`t$$ =
     1., Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`s$$], 0.5}, -1, 1}, {{
       Hold[$CellContext`t$$], 0.5}, -1, 1}}, Typeset`size$$ = {
    360., {178., 182.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`s$65167$$ = 
    0, $CellContext`t$65168$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`s$$ = 0.5, $CellContext`t$$ = 0.5}, 
      "ControllerVariables" :> {
        Hold[$CellContext`s$$, $CellContext`s$65167$$, 0], 
        Hold[$CellContext`t$$, $CellContext`t$65168$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Graphics[{Blue, $CellContext`arrowa, Green, $CellContext`arrowb, Red, {
          Arrowheads[Large], 
          
          Arrow[{{0, 
            0}, $CellContext`s$$ $CellContext`a + $CellContext`t$$ \
$CellContext`b}]}}, 
        PlotRange -> {{-$CellContext`lgth, $CellContext`lgth}, \
{-$CellContext`lgth, $CellContext`lgth}}], 
      "Specifications" :> {{{$CellContext`s$$, 0.5}, -1, 
         1}, {{$CellContext`t$$, 0.5}, -1, 1}}, 
      "Options" :> {
       Alignment -> Left, 
        FrameLabel -> {" ", " ", "red = s*blue + t*green", " "}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{433., {261., 266.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.5847368930377717`*^9, 3.5847373415183997`*^9, 3.5847375268486595`*^9, {
   3.58473762020879*^9, 3.584737633048808*^9}, {3.5847376777788706`*^9, 
   3.584737688818886*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{910, 630},
WindowMargins->{{Automatic, 96}, {Automatic, 44}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 691, 12, 107, "Subtitle"],
Cell[1273, 36, 550, 10, 143, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1848, 50, 4538, 127, 432, "Input"],
Cell[6389, 179, 2324, 50, 544, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

