(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     14241,        395]
NotebookOptionsPosition[     13798,        375]
NotebookOutlinePosition[     14142,        390]
CellTagsIndexPosition[     14099,        387]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9},
 FontFamily->"Arial"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  StyleBox[
   RowBox[{
    StyleBox[
     RowBox[{"Linear", " ", "combinations", " ", "3", "D"}],
     FontWeight->"Bold"], "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
     "An", " ", "example", " ", "of", " ", "a", " ", "linear", " ", "space", 
      " ", "is", "  ", "all", " ", "3", "D", " ", "vectors", " ", 
      StyleBox["v",
       FontWeight->"Bold"]}], "=", 
     RowBox[{
      RowBox[{
       FormBox[
        RowBox[{"(", GridBox[{
           {
            SubscriptBox["x", "1"]},
           {
            SubscriptBox["x", "2"]},
           {
            SubscriptBox["x", "3"]}
          }], ")"}],
        TraditionalForm], " ", ".", "\[IndentingNewLine]", "Linear"}], " ", 
      "combinations", " ", "are", " ", "defined", " ", "by"}]}], "\n", 
    RowBox[{
     RowBox[{
      RowBox[{"s", 
       FormBox[
        RowBox[{
         SubscriptBox["", "1"], 
         SubscriptBox[
          StyleBox["v",
           FontWeight->"Bold"], "1"]}],
        TraditionalForm]}], "+", 
      RowBox[{"s", 
       FormBox[
        RowBox[{
         SubscriptBox["", "2"], 
         SubscriptBox[
          StyleBox["v",
           FontWeight->"Bold"], "2"]}],
        TraditionalForm]}], "+", 
      RowBox[{"s", 
       FormBox[
        RowBox[{
         SubscriptBox["", "3"], 
         SubscriptBox[
          StyleBox["v",
           FontWeight->"Bold"], "3"]}],
        TraditionalForm]}]}], ";", 
     RowBox[{
      RowBox[{"s", 
       FormBox[
        SubscriptBox["", "i"],
        TraditionalForm], "\[Epsilon]", " ", 
       RowBox[{
       "\[DoubleStruckCapitalR]", ".", " ", "\[IndentingNewLine]", "The"}], 
       " ", "zero", " ", "vector", " ", "now", " ", "is", " ", 
       StyleBox["0",
        FontWeight->"Bold"]}], "=", 
      RowBox[{
       RowBox[{
        FormBox[
         RowBox[{"(", GridBox[{
            {"0"},
            {"0"},
            {"0"}
           }], ")"}],
         TraditionalForm], ".", "\[IndentingNewLine]", "A"}], " ", "matrix", 
       " ", "is", " ", "defined", " ", "by", 
       RowBox[{
        FormBox[
         RowBox[{"(", GridBox[{
            {
             SubscriptBox["a", "11"], 
             SubscriptBox["a", "12"], 
             SubscriptBox["a", "13"]},
            {
             SubscriptBox["a", "21"], 
             SubscriptBox["a", "22"], 
             SubscriptBox["a", "23"]},
            {
             SubscriptBox["a", "31"], 
             SubscriptBox["a", "32"], 
             SubscriptBox["a", "33"]}
           }], ")"}],
         TraditionalForm], ".", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        "The"}], " ", "gray", " ", "triangle", " ", "in", " ", "the", " ", 
       "following", " ", "cell", " ", "defines", " ", "the", " ", 
       StyleBox["plane",
        FontSlant->"Italic"], 
       StyleBox[" ",
        FontSlant->"Italic"], "formed", " ", "by"}]}]}], " ", 
    "\[IndentingNewLine]", 
    RowBox[{
     StyleBox["a",
      FontWeight->"Bold"], 
     StyleBox[",",
      FontWeight->"Bold"], 
     StyleBox["b",
      FontWeight->"Bold"], 
     StyleBox[",",
      FontWeight->"Bold"], 
     RowBox[{
      StyleBox["c",
       FontWeight->"Bold"], 
      StyleBox[" ",
       FontWeight->"Bold"], 
      RowBox[{
       StyleBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"in", " ", "red"}], ",", " ", "green", ",", " ", "blue", 
          ",", " ", 
          RowBox[{"resp", "."}]}], ")"}],
        FontWeight->"Plain"], 
       StyleBox[".",
        FontWeight->"Plain"], "\[IndentingNewLine]", "The"}], " ", "result", 
      " ", "of", " ", "the", " ", "linear", " ", "coombinations", " ", "is", 
      " ", "shown", " ", "as", " ", "a", " ", "3", "D", " ", "tube", " ", 
      RowBox[{"vector", "."}]}]}]}],
   FontFamily->"Arial"]}]], "Subsubtitle",
 CellChangeTimes->{{3.5848150461226587`*^9, 3.584815258442956*^9}, {
  3.584815484623273*^9, 3.5848155103133087`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"aa", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], ";"}], 
   RowBox[{"(*", "  ", 
    RowBox[{"Red", " ", "Arrow"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bb", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], ";"}], " ", 
   RowBox[{"(*", "  ", 
    RowBox[{"Green", " ", "Arrow"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cc", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ";"}], "  ", 
   RowBox[{"(*", "  ", 
    RowBox[{"Blue", " ", "Arrow"}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"arrowaa", "=", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "aa"}], "}"}], 
        "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"arrowbb", " ", "=", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "bb"}], "}"}], 
        "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"arrowcc", " ", "=", 
     RowBox[{"{", 
      RowBox[{"Blue", ",", 
       RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "cc"}], "}"}], 
        "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"plotting", " ", "area", " ", 
     RowBox[{"range", ":", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "range"}], " ", "to"}], " ", "+", " ", 
       RowBox[{"range", " ", "in", " ", "each", " ", "coordinate"}]}]}]}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"range", " ", "=", " ", "2.1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"r", ",", "s", ",", 
     RowBox[{"t", " ", "parameter", " ", "extents"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xtnts", " ", "=", " ", "2"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Graphics3D", "[", 
      RowBox[{
       RowBox[{"{", " ", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Arrowheads", "[", ".06", "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Arrow", "[", 
            RowBox[{"Tube", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
                RowBox[{
                 RowBox[{"r", "*", "aa"}], "+", 
                 RowBox[{"s", "*", "bb"}], "+", 
                 RowBox[{"t", "*", "cc"}]}]}], "}"}], ",", ".008"}], "]"}], 
            "]"}]}], "}"}], ",", "\[IndentingNewLine]", "Thick", ",", 
         "arrowaa", ",", " ", "arrowbb", ",", " ", "arrowcc", ",", " ", 
         "\[IndentingNewLine]", "LightGray", ",", 
         RowBox[{"Opacity", "[", "0.8", "]"}], ",", 
         RowBox[{"Polygon", "[", 
          RowBox[{"{", 
           RowBox[{"aa", ",", "bb", ",", "cc"}], "}"}], "]"}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "range"}], ",", "range"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "range"}], ",", "range"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "range"}], ",", "range"}], "}"}]}], "}"}]}]}], "]"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", "1"}], "}"}], ",", 
       RowBox[{"-", "xtnts"}], ",", "xtnts"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", "1"}], "}"}], ",", 
       RowBox[{"-", "xtnts"}], ",", "xtnts"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "1"}], "}"}], ",", 
       RowBox[{"-", "xtnts"}], ",", "xtnts"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\< \>\"", ",", "\"\< \>\"", ",", 
        "\"\<Linear combination: v = r*red + s*green + t*blue\>\"", ",", 
        "\"\< \>\""}], "}"}]}]}], "]"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5848152836129913`*^9, 3.584815340853071*^9}, {
  3.58481538276313*^9, 3.584815461773241*^9}, {3.5848155192833214`*^9, 
  3.584815522613326*^9}, {3.5848155786834044`*^9, 3.584815641813493*^9}, {
  3.5848157471036406`*^9, 3.5848158144937344`*^9}, {3.584815922733886*^9, 
  3.584815923713887*^9}, {3.584815986713976*^9, 3.584816001183996*^9}, {
  3.584816033304041*^9, 3.5848160345140424`*^9}, {3.584816075094099*^9, 
  3.584816075964101*^9}, {3.5848161674442286`*^9, 3.5848162966044097`*^9}, {
  3.5848163414044724`*^9, 3.584816361854501*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`r$$ = 
    0.16000000000000014`, $CellContext`s$$ = 1.21, $CellContext`t$$ = 
    1.4500000000000002`, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`r$$], 1}, -2, 2}, {{
       Hold[$CellContext`s$$], 1}, -2, 2}, {{
       Hold[$CellContext`t$$], 1}, -2, 2}}, Typeset`size$$ = {
    360., {193., 198.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`r$85228$$ = 
    0, $CellContext`s$85229$$ = 0, $CellContext`t$85230$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`r$$ = 1, $CellContext`s$$ = 
        1, $CellContext`t$$ = 1}, "ControllerVariables" :> {
        Hold[$CellContext`r$$, $CellContext`r$85228$$, 0], 
        Hold[$CellContext`s$$, $CellContext`s$85229$$, 0], 
        Hold[$CellContext`t$$, $CellContext`t$85230$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics3D[{{
          Arrowheads[0.06], 
          Arrow[
           
           Tube[{{0, 0, 
             0}, $CellContext`r$$ $CellContext`aa + $CellContext`s$$ \
$CellContext`bb + $CellContext`t$$ $CellContext`cc}, 0.008]]}, 
         Thick, $CellContext`arrowaa, $CellContext`arrowbb, \
$CellContext`arrowcc, LightGray, 
         Opacity[0.8], 
         Polygon[{$CellContext`aa, $CellContext`bb, $CellContext`cc}]}, Boxed -> 
        False, PlotRange -> {{-$CellContext`range, $CellContext`range}, \
{-$CellContext`range, $CellContext`range}, {-$CellContext`range, \
$CellContext`range}}], 
      "Specifications" :> {{{$CellContext`r$$, 1}, -2, 
         2}, {{$CellContext`s$$, 1}, -2, 2}, {{$CellContext`t$$, 1}, -2, 2}}, 
      "Options" :> {
       FrameLabel -> {
         " ", " ", "Linear combination: v = r*red + s*green + t*blue", " "}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{433., {293., 298.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.5848153432930746`*^9, 3.584815458433236*^9, 3.5848156503735046`*^9, 
   3.5848158159937363`*^9, 3.5848159317138987`*^9, {3.584815988013977*^9, 
   3.5848160353240433`*^9}, 3.584816077894103*^9, {3.5848162883043976`*^9, 
   3.5848162973944106`*^9}, {3.5848163444644766`*^9, 3.584816362784502*^9}, 
   3.584897163182599*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1010, 630},
WindowMargins->{{Automatic, 26}, {Automatic, 48}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 691, 12, 107, "Subtitle"],
Cell[1273, 36, 3967, 125, 406, "Subsubtitle"],
Cell[CellGroupData[{
Cell[5265, 165, 5534, 144, 472, "Input"],
Cell[10802, 311, 2968, 60, 608, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
