(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     26238,        740]
NotebookOptionsPosition[     24915,        689]
NotebookOutlinePosition[     25259,        704]
CellTagsIndexPosition[     25216,        701]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 "\n"
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
  3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
  3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
  3.5842134956497355`*^9, 3.5842135862546945`*^9}},
 FontFamily->"Arial"],

Cell[TextData[{
 StyleBox["Linear Systems viewed as a line intersection problem",
  FontWeight->"Bold"],
 "\n\nThese examples come from Chapter 5 in PLA.\n1. unique solution, \n2. \
inconsistent linear system, \n3. overdetermined linear system.\n4. \
homogeneous sys with trivial solution only\n5. homogeneous sys with \
nontrivial solutions\n\nIn the book, mostly we  take a \
\[OpenCurlyDoubleQuote]column view\[CloseCurlyDoubleQuote] -- or coordinate \
system transformation view. This demonstrates that a \
\[OpenCurlyDoubleQuote]row view\[CloseCurlyDoubleQuote] is also possible, and \
the classification of the systems is identical."
}], "Subsubtitle",
 CellChangeTimes->{{3.5589757342528048`*^9, 3.558975757668446*^9}, {
  3.5843626596841216`*^9, 3.5843626851041574`*^9}, {3.584362728534218*^9, 
  3.584362742234237*^9}}],

Cell["\<\

\
\>", "Subsubtitle",
 CellChangeTimes->{{3.5589757849840937`*^9, 3.558975950863552*^9}, {
   3.5589801207896233`*^9, 3.558980167083271*^9}, 3.584362680704151*^9}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetOptions", "[", 
     RowBox[{"Graphics", ",", 
      RowBox[{"BaseStyle", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontFamily", "->", "\"\<Helvetica\>\""}], ",", 
         RowBox[{"FontSize", "\[Rule]", "10"}]}], "}"}]}]}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.5589765897252665`*^9, 3.558976603609291*^9}, {
  3.558977283645685*^9, 3.558977283754885*^9}, {3.5589795215513487`*^9, 
  3.5589795218423653`*^9}}],

Cell[CellGroupData[{

Cell["\<\

System #1 : unique solution
  2u_1 + 4u_2 = 4
  u_1 + 6u_2 = 4
\
\>", "Section",
 CellChangeTimes->{{3.5589760237476573`*^9, 3.5589760605077085`*^9}, 
   3.558976885049385*^9, {3.558977004030794*^9, 3.558977027321635*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "6"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"4", ",", "4"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"u1", " ", "=", " ", 
     RowBox[{"LinearSolve", "[", 
      RowBox[{"A1", ",", "b1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Example 1: Intersection point =\>\"", ",", "u1"}], "]"}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Select", " ", "endpoints", " ", "of", " ", "lines", " ", "for", " ", 
     "good", " ", "graphics"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ex1l1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", 
         RowBox[{"10", "/", "4"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ex1l2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", 
         RowBox[{"7", "/", "6"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"plotEx1", " ", "=", " ", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Black", ",", " ", 
        RowBox[{"Line", "[", "ex1l1", "]"}], ",", " ", "Gray", ",", " ", 
        RowBox[{"Line", "[", "ex1l2", "]"}], ",", " ", "Black", ",", " ", 
        RowBox[{"PointSize", "[", "Large", "]"}], ",", 
        RowBox[{"Point", "[", "u1", "]"}]}], "}"}], ",", " ", 
      RowBox[{"Axes", "\[Rule]", "True"}], ",", " ", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "3"}], ",", 
           RowBox[{"-", "2"}], ",", 
           RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2"}], "}"}]}], 
        "}"}]}]}], "]"}]}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.558976062447712*^9, 3.5589761285650043`*^9}, {
  3.5589761763090725`*^9, 3.5589761960891004`*^9}, {3.5589762759948144`*^9, 
  3.558976539824388*^9}, {3.55897661474771*^9, 3.558976686414236*^9}, {
  3.5589779020547237`*^9, 3.5589779200957556`*^9}, {3.5589781861389723`*^9, 
  3.558978222195035*^9}, {3.558978264125433*^9, 3.5589782754490805`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Example 1: Intersection point =\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     FractionBox["1", "2"]}], "}"}]}],
  SequenceForm["Example 1: Intersection point =", {1, 
    Rational[1, 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5589763851313686`*^9, 3.5589765066743417`*^9, 3.5589765406143894`*^9, 
   3.558976623374525*^9, {3.5589766602529902`*^9, 3.558976687147437*^9}, {
   3.5589772656744537`*^9, 3.558977288966895*^9}, {3.558977907916059*^9, 
   3.5589779211598167`*^9}, 3.558978277392192*^9, 3.558979361929219*^9, 
   3.5589795285097466`*^9, 3.559070281612851*^9, 3.559070353497777*^9, 
   3.5843628277243567`*^9}],

Cell[BoxData[
 GraphicsBox[
  {GrayLevel[0], Thickness[Large], 
   LineBox[NCache[{{-3, Rational[5, 2]}, {4, -1}}, {{-3, 2.5}, {4, -1}}]], 
   {GrayLevel[0.5], 
    LineBox[NCache[{{-3, Rational[7, 6]}, {4, 
       0}}, {{-3, 1.1666666666666667`}, {4, 0}}]]}, 
   {GrayLevel[0], PointSize[Large], 
    PointBox[NCache[{1, Rational[1, 2]}, {1, 0.5}]]}},
  Axes->True,
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 10},
  Ticks->{{{-3, 
      FormBox[
       RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}, {{-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}}}]], "Output",
 CellChangeTimes->{
  3.5589765067143416`*^9, 3.5589765406143894`*^9, 3.558976623374525*^9, {
   3.5589766602529902`*^9, 3.558976687147437*^9}, {3.5589772656744537`*^9, 
   3.558977288966895*^9}, {3.5589779079190593`*^9, 3.558977921162817*^9}, 
   3.558978277409193*^9, 3.558979361931219*^9, 3.558979528511747*^9, 
   3.559070281675251*^9, 3.559070353497777*^9, 3.584362827784357*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

System #2 : inconsistent
  2u_1 + u_2 = 1
  4u_1 + 2u_2 = 1\
\>", "Section",
 CellChangeTimes->{{3.5589768245836787`*^9, 3.5589768444581137`*^9}, {
  3.5589769768555465`*^9, 3.558976997572383*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ex2l1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
    RowBox[{"ex2l2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"5", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{
          RowBox[{"-", "3"}], "/", "2"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ex2l1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}], ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ex2l2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}], ",", 
         RowBox[{"3", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"plotEx2", " ", "=", " ", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Black", ",", " ", 
        RowBox[{"Line", "[", "ex2l1", "]"}], ",", " ", "Gray", ",", " ", 
        RowBox[{"Line", "[", "ex2l2", "]"}], ",", " ", "Black"}], "}"}], ",", 
      " ", 
      RowBox[{"Axes", "\[Rule]", "True"}], ",", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "1"}], "/", "2"}], ",", "0", ",", 
           RowBox[{"1", "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3"}], 
          "}"}]}], "}"}]}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.558976891195796*^9, {3.5589769263894577`*^9, 3.5589769748587427`*^9}, {
   3.5589770344040475`*^9, 3.5589770778033237`*^9}, 3.5589773972990503`*^9, {
   3.558977885882799*^9, 3.55897789028205*^9}, {3.558977928112214*^9, 
   3.558977931813426*^9}, {3.55897803504033*^9, 3.558978074447584*^9}, {
   3.55897829536222*^9, 3.5589783245378885`*^9}, {3.5589791423436594`*^9, 
   3.5589792580682783`*^9}}],

Cell[BoxData[
 GraphicsBox[
  {GrayLevel[0], Thickness[Large], 
   LineBox[NCache[{{Rational[-1, 2], 2}, {Rational[1, 2], 0}}, {{-0.5, 2}, {
      0.5, 0}}]], 
   {GrayLevel[0.5], 
    LineBox[NCache[{{Rational[-1, 2], Rational[3, 2]}, {
       Rational[1, 2], Rational[-1, 2]}}, {{-0.5, 1.5}, {0.5, -0.5}}]]}, 
   {GrayLevel[0]}},
  Axes->True,
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 10},
  Ticks->{{{
      NCache[
       Rational[-1, 2], -0.5], 
      FormBox[
       RowBox[{"-", 
         FractionBox["1", "2"]}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {
      NCache[
       Rational[1, 2], 0.5], 
      FormBox[
       FractionBox["1", "2"], TraditionalForm]}}, {{-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}}}]], "Output",
 CellChangeTimes->{
  3.558977079815727*^9, {3.5589772657212534`*^9, 3.558977289006895*^9}, 
   3.55897740425906*^9, 3.558977891483119*^9, 3.558977949556441*^9, 
   3.558978050984242*^9, 3.5589783256429515`*^9, {3.5589792351049647`*^9, 
   3.558979260636425*^9}, 3.5589793619632206`*^9, 3.558979528552749*^9, 
   3.559070281737651*^9, 3.559070353528977*^9, 3.5843628278043566`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

System #2 : inconsistent
2 u_ 1 + u_ 2 = 3
4 u_ 1 + 2 u_ 2 = 6\
\>", "Section",
 CellChangeTimes->{{3.5589774410015125`*^9, 3.5589774728115573`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"ex3l1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", 
         RowBox[{"-", "3"}]}], "}"}]}], "}"}]}], ";"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ex3l1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"plotEx3", " ", "=", " ", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Thick", ",", "Black", ",", " ", 
        RowBox[{"Line", "[", "ex3l1", "]"}], ",", " ", "Black"}], "}"}], ",", 
      " ", 
      RowBox[{"Axes", "\[Rule]", "True"}], ",", " ", 
      RowBox[{"Ticks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", 
           RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "2"}], ",", 
           RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2", ",", "3", ",", 
           "4", ",", "5", ",", "6"}], "}"}]}], "}"}]}]}], 
     "]"}]}]}]}]], "Input",
 CellChangeTimes->{
  3.5589774558715334`*^9, {3.5589777755284867`*^9, 3.558977822043147*^9}, {
   3.558977863486518*^9, 3.558977877368312*^9}, {3.55897793677271*^9, 
   3.5589779377827673`*^9}, {3.5589783495623198`*^9, 3.558978393408828*^9}, {
   3.558979329983392*^9, 3.5589793573769584`*^9}}],

Cell[BoxData[
 GraphicsBox[
  {GrayLevel[0], Thickness[Large], LineBox[{{-1, 5}, {2, -1}}], 
   {GrayLevel[0]}},
  Axes->True,
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 10},
  Ticks->{{{-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}}, {{-2, 
      FormBox[
       RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}, {3, 
      FormBox["3", TraditionalForm]}, {4, 
      FormBox["4", TraditionalForm]}, {5, 
      FormBox["5", TraditionalForm]}, {6, 
      FormBox["6", TraditionalForm]}}}]], "Output",
 CellChangeTimes->{
  3.5589778243562794`*^9, {3.5589778648675966`*^9, 3.5589778780683517`*^9}, 
   3.558977941906003*^9, 3.558978394686901*^9, {3.5589793586580315`*^9, 
   3.558979361993222*^9}, 3.55897952857775*^9, 3.5590702817688513`*^9, 
   3.559070353560177*^9, 3.584362827824357*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"pic", " ", "=", " ", 
    RowBox[{"GraphicsRow", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"plotEx1", ",", " ", "plotEx2", ",", " ", "plotEx3"}], "}"}], 
      ",", 
      RowBox[{"Alignment", "\[Rule]", "Center"}], ",", " ", 
      RowBox[{"ImageSize", "\[Rule]", "Full"}]}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<LinearSysLines.eps\>\"", ",", " ", "pic"}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.558978435328225*^9, 3.558978453701276*^9}, {
  3.558978564491613*^9, 3.55897857615728*^9}, {3.5589786274392138`*^9, 
  3.558978627853237*^9}, {3.558978684356469*^9, 3.5589787250797977`*^9}, {
  3.5589787562605815`*^9, 3.558978759242752*^9}, {3.558978814316902*^9, 
  3.558978814713925*^9}, {3.5589788625136585`*^9, 3.5589788643067617`*^9}, {
  3.5589794605658607`*^9, 3.5589794780858626`*^9}, {3.5590702686960278`*^9, 
  3.5590702764960413`*^9}, {3.5590703264005294`*^9, 3.5590703338417425`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[
      {GrayLevel[0], Thickness[Large], 
       LineBox[NCache[{{-3, Rational[5, 2]}, {4, -1}}, {{-3, 2.5}, {4, -1}}]], 
       {GrayLevel[0.5], 
        LineBox[NCache[{{-3, Rational[7, 6]}, {4, 
           0}}, {{-3, 1.1666666666666667`}, {4, 0}}]]}, 
       {GrayLevel[0], PointSize[Large], 
        PointBox[NCache[{1, Rational[1, 2]}, {1, 0.5}]]}},
      Axes->True,
      BaseStyle->{FontFamily -> "Helvetica", FontSize -> 10},
      Ticks->{{{-3, 
          FormBox[
           RowBox[{"-", "3"}], TraditionalForm]}, {-2, 
          FormBox[
           RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {0, 
          FormBox["0", TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}, {2, 
          FormBox["2", TraditionalForm]}, {3, 
          FormBox["3", TraditionalForm]}}, {{-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {0, 
          FormBox["0", TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}, {2, 
          FormBox["2", TraditionalForm]}}}], {193.5, -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[
      {GrayLevel[0], Thickness[Large], 
       LineBox[NCache[{{Rational[-1, 2], 2}, {
          Rational[1, 2], 0}}, {{-0.5, 2}, {0.5, 0}}]], 
       {GrayLevel[0.5], 
        LineBox[NCache[{{Rational[-1, 2], Rational[3, 2]}, {
           Rational[1, 2], Rational[-1, 2]}}, {{-0.5, 1.5}, {0.5, -0.5}}]]}, 
       {GrayLevel[0]}},
      Axes->True,
      BaseStyle->{FontFamily -> "Helvetica", FontSize -> 10},
      Ticks->{{{
          NCache[
           Rational[-1, 2], -0.5], 
          FormBox[
           RowBox[{"-", 
             FractionBox["1", "2"]}], TraditionalForm]}, {0, 
          FormBox["0", TraditionalForm]}, {
          NCache[
           Rational[1, 2], 0.5], 
          FormBox[
           FractionBox["1", "2"], TraditionalForm]}}, {{-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {0, 
          FormBox["0", TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}, {2, 
          FormBox["2", TraditionalForm]}, {3, 
          FormBox["3", TraditionalForm]}}}], {580.5, -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[
      {GrayLevel[0], Thickness[Large], LineBox[{{-1, 5}, {2, -1}}], 
       {GrayLevel[0]}},
      Axes->True,
      BaseStyle->{FontFamily -> "Helvetica", FontSize -> 10},
      Ticks->{{{-2, 
          FormBox[
           RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {0, 
          FormBox["0", TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}, {2, 
          FormBox["2", TraditionalForm]}}, {{-2, 
          FormBox[
           RowBox[{"-", "2"}], TraditionalForm]}, {-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {0, 
          FormBox["0", TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}, {2, 
          FormBox["2", TraditionalForm]}, {3, 
          FormBox["3", TraditionalForm]}, {4, 
          FormBox["4", TraditionalForm]}, {5, 
          FormBox["5", TraditionalForm]}, {6, 
          FormBox["6", TraditionalForm]}}}], {967.5, -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}]}, {}},
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 10},
  ContentSelectable->True,
  ImageSize->Full,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.5589784591915903`*^9, 3.558978577343348*^9, 
  3.558978629041305*^9, 3.558978815783986*^9, 3.5589788646957836`*^9, 
  3.5589793620322247`*^9, 3.558979484636237*^9, 3.558979528622753*^9, 
  3.559070281940451*^9, 3.5590703536069775`*^9, 3.584362827944357*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

Homogeneous systems : trivial solution and non - trivial solution\
\>", "Section",
 CellChangeTimes->{{3.584362795624312*^9, 3.584362818804344*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Homogeneous", " ", "-", " ", 
    RowBox[{"trivial", " ", "solution"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"hex1l1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hex1l2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "4"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plothex1", " ", "=", " ", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Thick", ",", " ", "Black", ",", " ", 
         RowBox[{"Line", "[", "hex1l1", "]"}], ",", " ", "Gray", ",", " ", 
         RowBox[{"Line", "[", "hex1l2", "]"}]}], "}"}], ",", " ", 
       RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Homogeneous", " ", "--"}], " ", "non"}], "-", 
     RowBox[{"trivial", " ", 
      RowBox[{"soln", " ", "--"}], " ", "identical", " ", "lines"}]}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hex2l1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", 
         RowBox[{"3", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plothex2", " ", "=", " ", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Thick", ",", " ", "Black", ",", " ", 
         RowBox[{"Line", "[", "hex2l1", "]"}]}], "}"}], ",", " ", 
       RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"pic2", " ", "=", 
    RowBox[{"GraphicsRow", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"plothex1", ",", " ", "plothex2"}], "}"}], ",", 
      RowBox[{"Alignment", "\[Rule]", "Center"}], ",", " ", 
      RowBox[{"ImageSize", "\[Rule]", "Full"}]}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<HomoSysLines.eps\>\"", ",", " ", "pic2"}], "]"}], ";"}], 
   " ", "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5589801751517324`*^9, 3.5589805479770565`*^9}, {
  3.559070295434475*^9, 3.55907029838288*^9}, {3.559070343186159*^9, 
  3.55907034962897*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[
      {GrayLevel[0], Thickness[Large], LineBox[{{-2, 1}, {2, -1}}], 
       {GrayLevel[0.5], LineBox[{{-2, 4}, {2, -4}}]}},
      Axes->True,
      BaseStyle->{FontFamily -> "Helvetica", FontSize -> 10}], {192., -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[
      {GrayLevel[0], Thickness[Large], 
       LineBox[NCache[{{-3, Rational[3, 2]}, {2, -1}}, {{-3, 1.5}, {2, -1}}]]},
      Axes->True,
      BaseStyle->{FontFamily -> "Helvetica", FontSize -> 10}], {576., -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}]}, {}},
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 10},
  ContentSelectable->True,
  ImageSize->Full,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.558980390175031*^9, 3.558980424439991*^9, {3.558980463268212*^9, 
   3.5589804861135187`*^9}, 3.5589805180893474`*^9, 3.558980548634094*^9, 
   3.5590702820028515`*^9, 3.5590703539501777`*^9, 3.584362828484358*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1110, 630},
WindowMargins->{{Automatic, 67}, {Automatic, 27}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 673, 13, 135, "Subtitle"],
Cell[1255, 37, 828, 14, 219, "Subsubtitle"],
Cell[2086, 53, 174, 5, 47, "Subsubtitle"],
Cell[2263, 60, 668, 18, 72, "Input"],
Cell[CellGroupData[{
Cell[2956, 82, 233, 8, 175, "Section"],
Cell[CellGroupData[{
Cell[3214, 94, 2931, 77, 272, "Input"],
Cell[6148, 173, 711, 15, 40, "Print"],
Cell[6862, 190, 1405, 32, 202, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8316, 228, 208, 7, 149, "Section"],
Cell[CellGroupData[{
Cell[8549, 239, 2782, 80, 192, "Input"],
Cell[11334, 321, 1341, 33, 447, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12724, 360, 160, 6, 149, "Section"],
Cell[CellGroupData[{
Cell[12909, 370, 1764, 50, 92, "Input"],
Cell[14676, 422, 1199, 29, 447, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15912, 456, 1050, 22, 72, "Input"],
Cell[16965, 480, 3801, 89, 350, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20815, 575, 159, 4, 97, "Section"],
Cell[CellGroupData[{
Cell[20999, 583, 2868, 78, 312, "Input"],
Cell[23870, 663, 1005, 21, 525, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
