(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     17502,        526]
NotebookOptionsPosition[     16717,        496]
NotebookOutlinePosition[     17060,        511]
CellTagsIndexPosition[     17017,        508]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9},
 FontFamily->"Arial"],

Cell[TextData[{
 StyleBox["Linear combinations and linear systems",
  FontWeight->"Bold"],
 "\nGiven three vectors ",
 StyleBox["a,b,c",
  FontWeight->"Bold"],
 ", how can we write ",
 StyleBox["c",
  FontWeight->"Bold"],
 " as a linear combination of ",
 StyleBox["a",
  FontWeight->"Bold"],
 " and ",
 StyleBox["b",
  FontWeight->"Bold"],
 ", i.e., what are s and t in\n\n\t s",
 StyleBox["a",
  FontWeight->"Bold"],
 " + t",
 StyleBox["b",
  FontWeight->"Bold"],
 " = ",
 StyleBox["c",
  FontWeight->"Bold"],
 "?\nIn matrix form, with M=[",
 StyleBox["a,b",
  FontWeight->"Bold"],
 "] and",
 StyleBox[" v",
  FontWeight->"Bold"],
 "=",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", GridBox[{
      {"s"},
      {"t"}
     }], ")"}], TraditionalForm]]],
 ":\n\tM",
 StyleBox["v",
  FontWeight->"Bold"],
 " = ",
 StyleBox["c",
  FontWeight->"Bold"],
 ".\n\t\[LineSeparator]Another way of saying this would be: what vector ",
 StyleBox["v",
  FontWeight->"Bold"],
 " is mapped to ",
 StyleBox["c",
  FontWeight->"Bold"],
 " by matrix M?\n\t\nSolution: multiply both sides by the inverse ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["M", 
    RowBox[{"-", "1"}]], TraditionalForm]]],
 " (assuming it exists!)\n\n\t",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["v",
     FontWeight->"Bold"], "=", 
    SuperscriptBox["M", 
     RowBox[{"-", "1"}]]}], TraditionalForm]]],
 StyleBox["c",
  FontWeight->"Bold"]
}], "Subsubtitle",
 CellChangeTimes->{{3.5848141921214633`*^9, 3.5848142265815115`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.584814276581581*^9, 3.584814284841593*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Input", " ", "vectors"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Write", " ", "c", " ", "as", " ", "a", " ", "linear", " ", "combination", 
    " ", "of", " ", "a", " ", "and", " ", "b"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "=", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", "=", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Form", " ", "a", " ", "matrix", " ", "with", " ", "a", " ", "and", " ", 
     "b", " ", "as", " ", "column", " ", "vectors"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat", "=", " ", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<Find s and t such that \>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<c = s\>\"", ",", 
      RowBox[{"MatrixForm", "[", "a", "]"}], ",", "\"\< + t\>\"", ",", 
      RowBox[{"MatrixForm", "[", "b", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Solve Mv = c where M = [a b] = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "mat", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"v", " ", "=", " ", 
     RowBox[{
      RowBox[{"Inverse", "[", "mat", "]"}], ".", "c"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<direct solution: v = M^{-1}c = \>\"", ",", " ", 
      RowBox[{"MatrixForm", "[", "v", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<check: \>\"", ",", 
      RowBox[{"MatrixForm", "[", "mat", "]"}], ",", "\"\<.\>\"", ",", 
      RowBox[{"MatrixForm", "[", "v", "]"}], ",", "\"\< = \>\"", ",", 
      RowBox[{"MatrixForm", "[", 
       RowBox[{"mat", ".", "v"}], "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Alternatively", " ", 
     RowBox[{"(", 
      RowBox[{
      "and", " ", "recommend", " ", "for", " ", "larger", " ", "systems"}], 
      ")"}]}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"v", "=", 
     RowBox[{"LinearSolve", "[", 
      RowBox[{"mat", ",", "c"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Solution with LinearSolve: \>\"", ",", " ", 
      RowBox[{"MatrixForm", "[", "v", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", "\"\<(Recommended for systems larger than 3x3)\>\"", "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<check: \>\"", ",", 
      RowBox[{"MatrixForm", "[", "mat", "]"}], ",", "\"\<.\>\"", ",", 
      RowBox[{"MatrixForm", "[", "v", "]"}], ",", "\"\< = \>\"", ",", 
      RowBox[{"MatrixForm", "[", 
       RowBox[{"mat", ".", "v"}], "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.584814266901568*^9, 3.584814386341735*^9}, {
  3.584814433631801*^9, 3.584814539361949*^9}, {3.5848145819220085`*^9, 
  3.584814614702055*^9}, {3.5848146486321025`*^9, 3.58481467552214*^9}, {
  3.584814708942187*^9, 3.5848147296822157`*^9}, {3.5848971990526495`*^9, 
  3.5848972026126537`*^9}, {3.584897255432728*^9, 3.5848972608627357`*^9}, {
  3.584897298062788*^9, 3.5848973048427973`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Find s and t such that \"\>"], "Print",
 CellChangeTimes->{
  3.5848143951817474`*^9, 3.584814628442074*^9, {3.5848972427227106`*^9, 
   3.5848972621227374`*^9}, 3.584897305672798*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"c = s\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"1"},
        {"1"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\" + t\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"0"},
        {"1"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["c = s", 
   MatrixForm[{1, 1}], " + t", 
   MatrixForm[{0, 1}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5848143951817474`*^9, 3.584814628442074*^9, {3.5848972427227106`*^9, 
   3.5848972621227374`*^9}, 3.584897305672798*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Solve Mv = c where M = [a b] = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0"},
       {"1", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Solve Mv = c where M = [a b] = ", 
   MatrixForm[{{1, 0}, {1, 1}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5848143951817474`*^9, 3.584814628442074*^9, {3.5848972427227106`*^9, 
   3.5848972621227374`*^9}, 3.584897305672798*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"direct solution: v = M^{-1}c = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"1"},
        {"0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["direct solution: v = M^{-1}c = ", 
   MatrixForm[{1, 0}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5848143951817474`*^9, 3.584814628442074*^9, {3.5848972427227106`*^9, 
   3.5848972621227374`*^9}, 3.584897305672798*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"check: \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0"},
       {"1", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\".\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"1"},
        {"0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"1"},
        {"1"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["check: ", 
   MatrixForm[{{1, 0}, {1, 1}}], ".", 
   MatrixForm[{1, 0}], " = ", 
   MatrixForm[{1, 1}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5848143951817474`*^9, 3.584814628442074*^9, {3.5848972427227106`*^9, 
   3.5848972621227374`*^9}, 3.584897305672798*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Solution with LinearSolve: \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"1"},
        {"0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Solution with LinearSolve: ", 
   MatrixForm[{1, 0}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5848143951817474`*^9, 3.584814628442074*^9, {3.5848972427227106`*^9, 
   3.5848972621227374`*^9}, 3.584897305672798*^9}],

Cell[BoxData["\<\"(Recommended for systems larger than 3x3)\"\>"], "Print",
 CellChangeTimes->{
  3.5848143951817474`*^9, 3.584814628442074*^9, {3.5848972427227106`*^9, 
   3.5848972621227374`*^9}, 3.5848973056827984`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"check: \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0"},
       {"1", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\".\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"1"},
        {"0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\" = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"1"},
        {"1"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["check: ", 
   MatrixForm[{{1, 0}, {1, 1}}], ".", 
   MatrixForm[{1, 0}], " = ", 
   MatrixForm[{1, 1}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5848143951817474`*^9, 3.584814628442074*^9, {3.5848972427227106`*^9, 
   3.5848972621227374`*^9}, 3.5848973056827984`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{890, 630},
WindowMargins->{{Automatic, 15}, {47, Automatic}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 691, 12, 107, "Subtitle"],
Cell[1273, 36, 1500, 65, 267, "Subsubtitle"],
Cell[2776, 103, 92, 1, 31, "Input"],
Cell[CellGroupData[{
Cell[2893, 108, 3906, 98, 492, "Input"],
Cell[CellGroupData[{
Cell[6824, 210, 202, 3, 23, "Print"],
Cell[7029, 215, 1685, 48, 36, "Print"],
Cell[8717, 265, 965, 25, 36, "Print"],
Cell[9685, 292, 1001, 27, 36, "Print"],
Cell[10689, 321, 2381, 67, 36, "Print"],
Cell[13073, 390, 993, 27, 36, "Print"],
Cell[14069, 419, 222, 3, 23, "Print"],
Cell[14294, 424, 2383, 67, 36, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
