(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      8210,        214]
NotebookOptionsPosition[      7635,        191]
NotebookOutlinePosition[      8080,        208]
CellTagsIndexPosition[      8037,        205]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9},
 FontFamily->"Arial"],

Cell[TextData[{
 StyleBox["Local to global coordinate system transformation\n",
  FontWeight->"Bold"],
 "Move 2D slider in the local coordinate system and the corresponding point \
appears in the global system"
}], "Subsubtitle",
 CellChangeTimes->{{3.5847261496181755`*^9, 3.5847261626881933`*^9}, {
  3.584729251274519*^9, 3.5847292683545427`*^9}, {3.5847302077258577`*^9, 
  3.5847302350858965`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"global", " ", "system"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"min1", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"max1", " ", "=", " ", "10"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"min2", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"max2", " ", "=", " ", "10"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"min", " ", "=", " ", 
     RowBox[{"Min", "[", 
      RowBox[{"min1", ",", "min2", ",", " ", "max1", ",", " ", "max2"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"max", " ", "=", " ", 
     RowBox[{"Max", "[", 
      RowBox[{"min1", ",", "min2", ",", " ", "max1", ",", " ", "max2"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"g1", "[", "l1_", "]"}], " ", ":=", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "l1"}], ")"}], "*", "min1"}], " ", "+", " ", 
      RowBox[{"l1", "*", "max1"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"g2", "[", "l2_", "]"}], " ", ":=", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "l2"}], ")"}], "*", "min2"}], " ", "+", " ", 
      RowBox[{"l2", "*", "max2"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"Manipulate", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"g1", "[", 
             RowBox[{"d", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
            RowBox[{"g2", "[", 
             RowBox[{"d", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
       ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"min", ",", "max"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"min", ",", "max"}], "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"Axes", "\[Rule]", "True"}], ",", " ", 
       RowBox[{"GridLines", "\[Rule]", "Automatic"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", " ", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Global goordinates\>\"", ",", "\"\< \>\"", ",", 
        "\"\<Local to global coordinates\>\"", ",", "\"\< \>\""}], "}"}]}]}], 
    "]"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.584726185648226*^9, 3.584726247888313*^9}, {
   3.5847266592188888`*^9, 3.5847266598988895`*^9}, {3.5847267183789716`*^9, 
   3.584726770259044*^9}, {3.584726807319096*^9, 3.58472700300937*^9}, {
   3.5847273724198875`*^9, 3.584727387889909*^9}, {3.584727650740277*^9, 
   3.5847277483504133`*^9}, {3.5847278031604905`*^9, 3.584727898830624*^9}, {
   3.5847282024310493`*^9, 3.584728258551128*^9}, {3.584728311301202*^9, 
   3.5847283354912357`*^9}, {3.5847286518336797`*^9, 3.584728705763755*^9}, {
   3.584728735923797*^9, 3.584728764273837*^9}, 3.5847290086441793`*^9}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`d$$ = {1., 0.845}, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`d$$], {0, 0}, {1, 1}}}, Typeset`size$$ = {
    450., {223., 230.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`d$35550$$ = {0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`d$$ = {0, 0}}, 
      "ControllerVariables" :> {
        Hold[$CellContext`d$$, $CellContext`d$35550$$, {0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         PointSize[Large], Red, 
         Point[{
           $CellContext`g1[
            Part[$CellContext`d$$, 1]], 
           $CellContext`g2[
            Part[$CellContext`d$$, 2]]}]}, 
        PlotRange -> {{$CellContext`min, $CellContext`max}, \
{$CellContext`min, $CellContext`max}}, Axes -> True, GridLines -> Automatic], 
      "Specifications" :> {{$CellContext`d$$, {0, 0}, {1, 1}}}, 
      "Options" :> {
       FrameLabel -> {
         "Global goordinates", " ", "Local to global coordinates", " "}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{541., {339., 346.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.5847277519304185`*^9, {3.5847278434405465`*^9, 3.584727869590583*^9}, 
   3.5847279005206265`*^9, {3.5847282189210725`*^9, 3.5847282598411293`*^9}, 
   3.5847283364412365`*^9, 3.584728707683758*^9, 3.5847287391238017`*^9, 
   3.5847290111641827`*^9}]
}, Open  ]],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{{3.5847271261695423`*^9, 3.58472715263958*^9}, {
   3.584727183939623*^9, 3.5847271980396433`*^9}, {3.5847272388597*^9, 
   3.5847272607697306`*^9}, {3.5847273050597925`*^9, 3.5847273255298214`*^9}, 
   3.5847273663898787`*^9}]
}, Open  ]]
},
WindowSize->{1033, 630},
WindowMargins->{{Automatic, 42}, {Automatic, 29}},
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.25, 1.25 Inherited],
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 691, 12, 135, "Subtitle"],
Cell[1273, 36, 403, 8, 61, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1701, 48, 3429, 85, 344, "Input"],
Cell[5133, 135, 2179, 46, 705, "Output"]
}, Open  ]],
Cell[7327, 184, 292, 4, 72, "Input"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
