(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     11156,        315]
NotebookOptionsPosition[     10252,        279]
NotebookOutlinePosition[     10695,        296]
CellTagsIndexPosition[     10652,        293]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 "\n"
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
  3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
  3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
  3.5842134956497355`*^9, 3.5842135862546945`*^9}},
 FontFamily->"Arial"],

Cell[TextData[{
 "\n",
 StyleBox["Matrix Norms",
  FontWeight->"Bold"],
 "\nUse M\[CloseCurlyQuote]s Norm routine to check some popular the matrix \
p-norms.\nTest the 2-norm estimate method based on the max vector 2-norm of \
all 2-norm unit vectors."
}], "Subsubtitle",
 CellChangeTimes->{{3.5843737152607527`*^9, 3.58437380643088*^9}, {
  3.5843779998287582`*^9, 3.584378076328865*^9}}],

Cell[CellGroupData[{

Cell["\<\

Check some popular matrix p - norms\
\>", "Section",
 CellChangeTimes->{{3.5843780818188725`*^9, 3.584378095608892*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Input", " ", "matrix"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"aa", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "4", ",", "5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "6", ",", 
         RowBox[{"-", "7"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "Norms", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"norm1", " ", "=", " ", 
     RowBox[{
      RowBox[{"Norm", "[", 
       RowBox[{"aa", ",", "1"}], "]"}], "//", "N"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"norm2", " ", "=", " ", 
     RowBox[{
      RowBox[{"Norm", "[", 
       RowBox[{"aa", ",", "2"}], "]"}], "//", "N"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"normi", " ", "=", " ", 
     RowBox[{
      RowBox[{"Norm", "[", 
       RowBox[{"aa", ",", "Infinity"}], "]"}], "//", "N"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"normf", " ", "=", " ", 
     RowBox[{
      RowBox[{"Norm", "[", 
       RowBox[{"aa", ",", "\"\<Frobenius\>\""}], "]"}], "//", "N"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Input matrix \>\"", ",", 
      RowBox[{"MatrixForm", "[", "aa", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
     "\"\<1-norm = \>\"", ",", "norm1", ",", "\"\<   2-norm = \>\"", ",", 
      "norm2", ",", "\"\<   Frobenius-norm = \>\"", ",", "normf", ",", 
      "\"\<   infinity-norm = \>\"", ",", "normi"}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.555542107309539*^9, 3.5555423269489784`*^9}, {
   3.5555443135478497`*^9, 3.555544327385493*^9}, {3.5556199522742786`*^9, 
   3.5556200097309203`*^9}, {3.5556200865789833`*^9, 3.555620175423831*^9}, {
   3.5556202187464194`*^9, 3.5556202617725983`*^9}, {3.5556202982309666`*^9, 
   3.555620304517968*^9}, {3.5556220912213435`*^9, 3.5556221440134354`*^9}, {
   3.555706929469805*^9, 3.5557070087359457`*^9}, {3.5557083468844337`*^9, 
   3.5557083567283487`*^9}, 3.5557084506901608`*^9, {3.5843738160408936`*^9, 
   3.584373949941081*^9}, {3.5843739852211304`*^9, 3.5843740348412*^9}},
 FontFamily->"Courier New"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Input matrix \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "2", "3"},
       {"3", "4", "5"},
       {"5", "6", 
        RowBox[{"-", "7"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Input matrix ", 
   MatrixForm[{{1, 2, 3}, {3, 4, 5}, {5, 6, -7}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.5843739397110662`*^9, 3.5843739514710827`*^9}, 
   3.5843740187311773`*^9, 3.584377561148144*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"1-norm = \"\>", "\[InvisibleSpace]", "15.`", 
   "\[InvisibleSpace]", "\<\"   2-norm = \"\>", "\[InvisibleSpace]", 
   "10.503622435309884`", "\[InvisibleSpace]", "\<\"   Frobenius-norm = \"\>",
    "\[InvisibleSpace]", "13.19090595827292`", 
   "\[InvisibleSpace]", "\<\"   infinity-norm = \"\>", "\[InvisibleSpace]", 
   "18.`"}],
  SequenceForm[
  "1-norm = ", 15., "   2-norm = ", 10.503622435309884`, 
   "   Frobenius-norm = ", 13.19090595827292, "   infinity-norm = ", 18.],
  Editable->False]], "Print",
 CellChangeTimes->{{3.5843739397110662`*^9, 3.5843739514710827`*^9}, 
   3.5843740187311773`*^9, 3.584377561158144*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

For a 2x2 matrix, compare matrix 2 - norm and an estimate to it: 
max ||Av_i|| (See Section 13.3 Matrix Norms)\
\>", "Section",
 CellChangeTimes->{{3.5843770993174973`*^9, 3.5843771758576045`*^9}, 
   3.5843772924677677`*^9, {3.584377519448086*^9, 3.584377531028102*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Input", " ", "a", " ", "2", "x2", " ", "matrix"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"bb", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "3"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "choose", " ", "the", " ", "number", " ", "of", " ", "unit", " ", 
     "vectors", " ", "to", " ", "compute"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"try", " ", "different", " ", 
      RowBox[{"values", ":", " ", "4"}]}], ",", "12", ",", " ", "30", ",", 
     " ", ".."}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"num", " ", "=", " ", "4"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"step", " ", "=", " ", 
    RowBox[{"2", 
     RowBox[{"Pi", "/", "num"}]}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lengths", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Norm", "[", 
        RowBox[{"bb", ".", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Cos", "[", "t", "]"}], ",", 
           RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "step"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"norm2est", " ", "=", " ", 
     RowBox[{
      RowBox[{"Max", "[", "lengths", "]"}], "//", "N"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"norm2", " ", "=", " ", 
     RowBox[{
      RowBox[{"Norm", "[", 
       RowBox[{"bb", ",", "2"}], "]"}], "//", "N"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
     "\"\<2-norm =\>\"", ",", "norm2", ",", "\"\<   2-norm estimate = \>\"", 
      ",", "norm2est", ",", "\"\<   Difference = \>\"", ",", 
      RowBox[{"norm2", "-", "norm2est"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.555683769840248*^9, 3.5556838249256134`*^9}, {
  3.555684310194766*^9, 3.555684455248215*^9}, {3.555684551362896*^9, 
  3.5556846017369103`*^9}, {3.5556846451063004`*^9, 3.555684647633581*^9}, {
  3.584377188227622*^9, 3.5843771917176266`*^9}, {3.58437723685769*^9, 
  3.5843772671977324`*^9}, {3.584377314087798*^9, 3.584377344877841*^9}, {
  3.584377381187892*^9, 3.5843775135880775`*^9}, {3.5843775472181244`*^9, 
  3.584377631098242*^9}, {3.584377681798313*^9, 3.5843778065684876`*^9}, {
  3.5843778902186046`*^9, 3.584377976078725*^9}},
 FontFamily->"Courier New"],

Cell[BoxData[
 FractionBox["\[Pi]", "2"]], "Output",
 CellChangeTimes->{{3.584377602398202*^9, 3.584377632438244*^9}, {
   3.5843776837383156`*^9, 3.584377726088375*^9}, 3.584377807488489*^9, {
   3.5843778928386087`*^9, 3.5843779195786457`*^9}, {3.5843779666587114`*^9, 
   3.584377976758726*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"2-norm =\"\>", "\[InvisibleSpace]", "4.754135216376082`", 
   "\[InvisibleSpace]", "\<\"   2-norm estimate = \"\>", "\[InvisibleSpace]", 
   "3.605551275463989`", "\[InvisibleSpace]", "\<\"   Difference = \"\>", 
   "\[InvisibleSpace]", "1.148583940912093`"}],
  SequenceForm[
  "2-norm =", 4.754135216376082, "   2-norm estimate = ", 3.605551275463989, 
   "   Difference = ", 1.148583940912093],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5843774465179834`*^9, {3.5843775615881443`*^9, 3.584377632438244*^9}, {
   3.5843776837383156`*^9, 3.584377726088375*^9}, 3.584377807498489*^9, {
   3.5843778928786087`*^9, 3.584377919588646*^9}, {3.5843779666587114`*^9, 
   3.584377976758726*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{993, 721},
WindowMargins->{{Automatic, 74}, {2, Automatic}},
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.25, 1.25 Inherited],
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 673, 13, 171, "Subtitle"],
Cell[1255, 37, 389, 9, 109, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1669, 50, 131, 4, 121, "Section"],
Cell[CellGroupData[{
Cell[1825, 58, 2518, 62, 344, "Input"],
Cell[CellGroupData[{
Cell[4368, 124, 980, 26, 60, "Print"],
Cell[5351, 152, 680, 13, 27, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6092, 172, 282, 6, 153, "Section"],
Cell[CellGroupData[{
Cell[6399, 182, 2760, 69, 344, "Input"],
Cell[9162, 253, 298, 5, 50, "Output"],
Cell[9463, 260, 749, 14, 27, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
