(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    100630,       2045]
NotebookOptionsPosition[     99737,       2013]
NotebookOutlinePosition[    100080,       2028]
CellTagsIndexPosition[    100037,       2025]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9},
 FontFamily->"Arial"],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{
    RowBox[{"We", " ", "can", " ", "define", " ", 
     StyleBox["powers",
      FontSlant->"Italic"], " ", "of", " ", "a", " ", 
     RowBox[{"matrix", ":", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      SuperscriptBox["M", "2"]}]}], " ", "=", " ", 
    RowBox[{"M", ".", "M"}]}], ",", " ", 
   RowBox[{
    SuperscriptBox["M", "3"], "=", " ", 
    RowBox[{
     RowBox[{"M", ".", 
      SuperscriptBox["M", "2"]}], "  ", 
     RowBox[{"etc", ".", "\[LineSeparator]", "\[LineSeparator]", "Some"}], 
     " ", "examples", " ", 
     RowBox[{"below", ".", " ", 
      RowBox[{"(", 
       RowBox[{"Play", " ", "with", " ", "the", " ", "matrix", " ", 
        RowBox[{"elements", "!"}]}], ")"}]}]}]}]}],
  FontFamily->"Arial"]], "Subsubtitle",
 CellChangeTimes->{
  3.5848058375892105`*^9, {3.584811651001902*^9, 3.5848116609019156`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Input", " ", 
    RowBox[{"matrix", " ", "--"}], " ", "load", " ", "a", " ", "selectoin", 
    " ", "into", " ", "mat"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"mymat1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5", ",", "2"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mymat2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.5", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mymat3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Sqrt", "[", "2", "]"}], "/", "2"}], ",", " ", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"Sqrt", "[", "2", "]"}]}], "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"Sqrt", "[", "2", "]"}], "/", "2"}], ",", 
         RowBox[{
          RowBox[{"Sqrt", "[", "2", "]"}], "/", "2"}]}], "}"}]}], "}"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mymat4", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mymat5", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.5"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat", " ", "=", " ", "mymat1"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Plot", " ", "action", " ", "of", " ", "M"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"input", " ", 
     RowBox[{"vectors", "/", "points"}], " ", "on", " ", "a", " ", 
     RowBox[{"circle", " ", "--"}], " ", "plot", " ", "in", " ", "green"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"circpoints", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", "t", "]"}], ",", 
         RowBox[{"Sin", "[", "t", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"2", " ", "Pi"}], ",", "0.1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"apply", " ", "linear", " ", "map", " ", "to", " ", "circle", " ", 
     RowBox[{"points", " ", "--"}], " ", "plot", " ", "in", " ", "red"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ellpoints", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"mat", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Cos", "[", "t", "]"}], ",", 
          RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "plot", " ", "points", " ", "and", " ", "a", " ", "line", " ", 
     "connecting", " ", "corresponding", " ", "points"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"circle", " ", "points", " ", "in", " ", "green"}], ";", " ", 
     RowBox[{"ellipse", " ", "points", " ", "in", " ", "red"}]}], " ", "*)"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pplot", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "Large", "]"}], ",", "Green", ",", 
        RowBox[{"Point", "[", "circpoints", "]"}], ",", "Red", ",", " ", 
        RowBox[{"Point", "[", "ellpoints", "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"line", "[", "t_", "]"}], ":=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"Line", "[", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"mat", ".", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", "t", "]"}], ",", 
            RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Cos", "[", "t", "]"}], ",", 
           RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], "}"}], "]"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lineplot", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"line", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Plot", " ", "action", " ", "of", " ", 
     RowBox[{"M", "^", "2"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat2", "=", " ", 
     RowBox[{"mat", ".", "mat"}]}], ";"}], " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ellpoints2", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"mat2", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Cos", "[", "t", "]"}], ",", 
          RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"plot", " ", 
     RowBox[{"M", "^", "2"}], " ", "ellipse", " ", "points", " ", "in", " ", 
     "orange"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pplot2", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "Large", "]"}], ",", "Green", ",", 
        RowBox[{"Point", "[", "circpoints", "]"}], ",", "Orange", ",", " ", 
        RowBox[{"Point", "[", "ellpoints2", "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"line2", "[", "t_", "]"}], ":=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"Line", "[", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"mat2", ".", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", "t", "]"}], ",", 
            RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Cos", "[", "t", "]"}], ",", 
           RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], "}"}], "]"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lineplot2", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"line2", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Plot", " ", "action", " ", "of", " ", 
     RowBox[{"M", "^", "3"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat3", "=", " ", 
     RowBox[{"mat", ".", "mat", ".", "mat"}]}], ";"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Plot", " ", 
     RowBox[{"M", "^", "3"}], " ", "action", " ", "in", " ", "yellow"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ellpoints3", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"mat3", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Cos", "[", "t", "]"}], ",", 
          RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pplot3", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "Large", "]"}], ",", "Green", ",", 
        RowBox[{"Point", "[", "circpoints", "]"}], ",", "Yellow", ",", " ", 
        RowBox[{"Point", "[", "ellpoints3", "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"line3", "[", "t_", "]"}], ":=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"Line", "[", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"mat3", ".", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", "t", "]"}], ",", 
            RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Cos", "[", "t", "]"}], ",", 
           RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], "}"}], "]"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lineplot3", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"line3", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", 
     "\"\<Start with the green vectors v_i defining a circle\>\"", "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", 
     "\"\<Apply linear map M repeatedly: Mv_i, M^2v_i, M^3v_i\>\"", "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<green -> red -> orange -> yellow\>\"", "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<M=\>\"", ",", 
      RowBox[{"MatrixForm", "[", "mat", "]"}], ",", "\"\<    M^2=\>\"", ",", 
      RowBox[{"MatrixForm", "[", "mat2", "]"}], ",", "\"\<    M^3=\>\"", ",", 
      RowBox[{"MatrixForm", "[", "mat3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"{", 
     RowBox[{
     "lineplot", ",", "pplot", ",", "lineplot2", ",", "pplot2", ",", 
      "lineplot3", ",", "pplot3"}], "}"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<Without the lines \>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"{", 
     RowBox[{"pplot", ",", "pplot2", ",", "pplot3"}], "}"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<M and M^2\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"{", 
     RowBox[{"lineplot", ",", "pplot", ",", "lineplot2", ",", "pplot2"}], 
     "}"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<M^2 and M^3\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"{", 
     RowBox[{"lineplot2", ",", "pplot2", ",", "lineplot3", ",", "pplot3"}], 
     "}"}], "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.584805973799401*^9, 3.584806223959751*^9}, 
   3.584806420350026*^9, {3.5848064642900877`*^9, 3.5848065426601973`*^9}, {
   3.5848065812502513`*^9, 3.5848065899602633`*^9}, {3.584806620260306*^9, 
   3.5848068043505635`*^9}, {3.584809883445425*^9, 3.5848099129854665`*^9}, {
   3.584809956445527*^9, 3.5848099783255577`*^9}, {3.584810024905623*^9, 
   3.5848102544459443`*^9}, {3.5848102901359944`*^9, 
   3.5848103234660406`*^9}, {3.5848103610960937`*^9, 3.584810361216094*^9}, {
   3.584810423386181*^9, 3.584810543696349*^9}, {3.584810603576433*^9, 
   3.5848106202364564`*^9}, {3.5848106605465126`*^9, 3.584810716080593*^9}, {
   3.5848108727108126`*^9, 3.584810881060824*^9}, {3.5848111894012556`*^9, 
   3.5848112393513255`*^9}, {3.5848114369916024`*^9, 3.5848116308618736`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Start with the green vectors v_i defining a circle\"\>"], \
"Print",
 CellChangeTimes->{
  3.584809923685481*^9, {3.5848099681255436`*^9, 3.584809979465559*^9}, 
   3.584810104535734*^9, {3.584810152895802*^9, 3.584810187855851*^9}, {
   3.584810305096015*^9, 3.5848103267460456`*^9}, 3.584810362266095*^9, {
   3.584810452766222*^9, 3.5848104796962595`*^9}, 3.5848105254063234`*^9, 
   3.5848106236364613`*^9, 3.584810717160595*^9, 3.584810883240827*^9, {
   3.584811200281271*^9, 3.5848112257313066`*^9}, {3.58481141427157*^9, 
   3.5848114694716477`*^9}, {3.584811500751692*^9, 3.5848115178517156`*^9}, {
   3.5848115556617684`*^9, 3.5848116316518745`*^9}}],

Cell[BoxData["\<\"Apply linear map M repeatedly: Mv_i, M^2v_i, M^3v_i\"\>"], \
"Print",
 CellChangeTimes->{
  3.584809923685481*^9, {3.5848099681255436`*^9, 3.584809979465559*^9}, 
   3.584810104535734*^9, {3.584810152895802*^9, 3.584810187855851*^9}, {
   3.584810305096015*^9, 3.5848103267460456`*^9}, 3.584810362266095*^9, {
   3.584810452766222*^9, 3.5848104796962595`*^9}, 3.5848105254063234`*^9, 
   3.5848106236364613`*^9, 3.584810717160595*^9, 3.584810883240827*^9, {
   3.584811200281271*^9, 3.5848112257313066`*^9}, {3.58481141427157*^9, 
   3.5848114694716477`*^9}, {3.584811500751692*^9, 3.5848115178517156`*^9}, {
   3.5848115556617684`*^9, 3.5848116316518745`*^9}}],

Cell[BoxData["\<\"green -> red -> orange -> yellow\"\>"], "Print",
 CellChangeTimes->{
  3.584809923685481*^9, {3.5848099681255436`*^9, 3.584809979465559*^9}, 
   3.584810104535734*^9, {3.584810152895802*^9, 3.584810187855851*^9}, {
   3.584810305096015*^9, 3.5848103267460456`*^9}, 3.584810362266095*^9, {
   3.584810452766222*^9, 3.5848104796962595`*^9}, 3.5848105254063234`*^9, 
   3.5848106236364613`*^9, 3.584810717160595*^9, 3.584810883240827*^9, {
   3.584811200281271*^9, 3.5848112257313066`*^9}, {3.58481141427157*^9, 
   3.5848114694716477`*^9}, {3.584811500751692*^9, 3.5848115178517156`*^9}, {
   3.5848115556617684`*^9, 3.5848116316518745`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"M=\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "2"}], "1"},
       {"0.5`", "2"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"    M^2=\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"4.5`", "0.`"},
       {"0.`", "4.5`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"    M^3=\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "9.`"}], "4.5`"},
       {"2.25`", "9.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["M=", 
   MatrixForm[{{-2, 1}, {0.5, 2}}], "    M^2=", 
   MatrixForm[{{4.5, 0.}, {0., 4.5}}], "    M^3=", 
   MatrixForm[{{-9., 4.5}, {2.25, 9.}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.584809923685481*^9, {3.5848099681255436`*^9, 3.584809979465559*^9}, 
   3.584810104535734*^9, {3.584810152895802*^9, 3.584810187855851*^9}, {
   3.584810305096015*^9, 3.5848103267460456`*^9}, 3.584810362266095*^9, {
   3.584810452766222*^9, 3.5848104796962595`*^9}, 3.5848105254063234`*^9, 
   3.5848106236364613`*^9, 3.584810717160595*^9, 3.584810883240827*^9, {
   3.584811200281271*^9, 3.5848112257313066`*^9}, {3.58481141427157*^9, 
   3.5848114694716477`*^9}, {3.584811500751692*^9, 3.5848115178517156`*^9}, {
   3.5848115556617684`*^9, 3.5848116316518745`*^9}}]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[{LineBox[{{-2., 0.5}, {1., 0.}}], 
   LineBox[{{-1.8901749139092234`, 0.6971689159326693}, {0.9950041652780258, 
    0.09983341664682815}}], 
   LineBox[{{-1.761463824887422, 0.8873719505107432}, {0.9800665778412416, 
    0.19866933079506122`}}], 
   LineBox[{{-1.6151527715898724`, 1.068708657885482}, {0.955336489125606, 
    0.2955202066613396}}], 
   LineBox[{{-1.4527036456971196`, 1.2393671816187437`}, {0.9210609940028851, 
    0.3894183423086505}}], 
   LineBox[{{-1.2757395851765425`, 1.3976423581535924`}, {0.8775825618903728, 
    0.479425538604203}}], 
   LineBox[{{-1.086028756424321, 1.54195275424491}, {0.8253356149096782, 
    0.5646424733950355}}], 
   LineBox[{{-0.8854666873312856, 1.6708564681176266`}, {0.7648421872844884, 
    0.6442176872376911}}], 
   LineBox[{{-0.676057327794808, 1.7830655364726282`}, {0.6967067093471654, 
    0.7173560908995228}}], 
   LineBox[{{-0.45989302691384537`, 1.877458803390299}, {0.6216099682706644, 
    0.7833269096274834}}], 
   LineBox[{{-0.2391336269283828, 1.953093122549863}, {0.5403023058681397, 
    0.8414709848078965}}], 
   LineBox[{{-0.015984882789719213`, 2.0092127808356595`}, {
    0.4535961214255773, 0.8912073600614354}}], 
   LineBox[{{0.2073235770138796, 2.0452570491727897`}, {0.3623577544766734, 
    0.9320390859672264}}], 
   LineBox[{{0.42856052816801826`, 2.0608657851466794`}, {
    0.26749882862458735`, 0.963558185417193}}], 
   LineBox[{{0.6455154441879787, 2.055883031427041}, {0.16996714290024081`, 
    0.9854497299884603}}], 
   LineBox[{{0.8560205832686486, 2.0303585740419603`}, {0.0707372016677029, 
    0.9974949866040544}}], 
   LineBox[{{1.0579726476440827`, 1.984547444932366}, {-0.029199522301288815`,
     0.9995736030415051}}], 
   LineBox[{{1.2493537990435182`, 
    1.9189073737571747`}, {-0.12884449429552486`, 0.9916648104524686}}], 
   LineBox[{{1.4282518202643693`, 1.8340942144098467`}, {-0.2272020946930871, 
    0.9738476308781951}}], 
   LineBox[{{1.5928792214144216`, 1.7309553919430771`}, {-0.3232895668635036, 
    0.9463000876874145}}], 
   LineBox[{{1.7415910999199666`, 1.6105214353777921`}, {-0.4161468365471424, 
    0.9092974268256817}}], 
   LineBox[{{1.872901575848589, 1.4739956809978185`}, {-0.5048461045998576, 
    0.8632093666488737}}], 
   LineBox[{{1.9854986383302817`, 1.3227422490115073`}, {-0.5885011172553458, 
    0.8084964038195901}}], 
   LineBox[{{2.0782572547363687`, 1.1582724137135278`}, {-0.6662760212798244, 
    0.74570521217672}}], 
   LineBox[{{2.150250611633642, 0.9822295033316784}, {-0.7373937155412458, 
    0.6754631805511506}}], 
   LineBox[{{2.200759375197824, 0.7963724804344463}, {-0.8011436155469337, 
    0.5984721441039565}}], 
   LineBox[{{2.229278878559359, 0.6025583669584547}, {-0.8568887533689473, 
    0.5155013718214642}}], 
   LineBox[{{2.235524164267952, 0.40272368945912895`}, {-0.9040721420170612, 
    0.4273798802338298}}], 
   LineBox[{{2.2194328314932212`, 0.19886512997748018`}, {-0.9422223406686583,
     0.33498815015590466`}}], 
   LineBox[{{
    2.181165659513163, -0.0069804241468313655`}, {-0.9709581651495907, 
    0.23924932921398198`}}], 
   LineBox[{{2.121105001260758, -0.21275623218048828`}, {-0.9899924966004454, 
    0.1411200080598672}}], 
   LineBox[{{
    2.0398509629798496`, -0.41640625027005873`}, {-0.9991351502732795, 
    0.04158066243329049}}], 
   LineBox[{{
    1.938215408161926, -0.6158956747525367}, {-0.9982947757947531, \
-0.058374143427580086`}}], 
   LineBox[{{
    1.817213845674481, -0.8092312732409297}, {-0.9874797699088649, \
-0.15774569414324865`}}], 
   LineBox[{{
    1.67805528313209, -0.9944813003433938}, {-0.9667981925794609, \
-0.25554110202683167`}}], 
   LineBox[{{
    1.5221301468919728`, -1.1697947990246378`}, {-0.9364566872907963, \
-0.35078322768961984`}}], 
   LineBox[{{
    1.3509963893734416`, -1.3334200947567785`}, {-0.896758416334147, \
-0.44252044329485246`}}], 
   LineBox[{{
    1.1663639225123226`, -1.4837222976721909`}, {-0.848100031710408, \
-0.5298361409084934}}], 
   LineBox[{{
    0.9700775328861138, -1.6191996378426468`}, {-0.7909677119144165, \
-0.6118578909427193}}], 
   LineBox[{{
    0.7640984492163057, -1.7384984704680182`}, {-0.7259323042001399, \
-0.6877661591839741}}], 
   LineBox[{{
    0.5504847464192957, -1.8404268010476623`}, {-0.6536436208636119, \
-0.7568024953079282}}], 
   LineBox[{{
    0.3313707820021262, -1.9239661953954559`}, {-0.5748239465332685, \
-0.8182771110644108}}], 
   LineBox[{{
    0.10894587026781066`, -1.9882819554975262`}, {-0.4902608213406994, \
-0.8715757724135882}}], 
   LineBox[{{-0.114567592589504, -2.0327314595388977`}, \
{-0.40079917207997545`, -0.9161659367494549}}], 
   LineBox[{{-0.3369363339326774, -2.056870582768242}, \
{-0.30733286997841935`, -0.9516020738895161}}], 
   LineBox[{{-0.5559385188035376, -2.0604581350455837`}, \
{-0.2107957994307797, -0.977530117665097}}], 
   LineBox[{{-0.7693859497633566, -2.043458270734456}, \
{-0.11215252693505398`, -0.9936910036334645}}], 
   LineBox[{{-0.9751459306383197, -2.006040846859647}, {-0.01238866346289056, \
-0.9999232575641008}}], 
   LineBox[{{-1.171162575714735, -1.9485797259519575`}, {
    0.08749898343944727, -0.9961646088358406}}], 
   LineBox[{{-1.355477351469484, -1.8716490405373771`}, {
    0.18651236942257576`, -0.9824526126243325}}], 
   LineBox[{{-1.526248645589591, -1.7760174565946638`}, {
    0.28366218546322625`, -0.9589242746631385}}], 
   LineBox[{{-1.6817701677536943`, -1.6626404932989738`}, {
    0.37797774271298107`, -0.9258146823277321}}], 
   LineBox[{{-1.8204879983209072`, -1.5326509757901177`}, {
    0.4685166713003771, -0.8834546557201531}}], 
   LineBox[{{-1.941016114582224, -1.3873477163582209`}, {
    0.5543743361791615, -0.8322674422239008}}], 
   LineBox[{{-2.0421502394412565`, -1.228182537140657}, {
    0.6346928759426347, -0.7727644875559871}}], 
   LineBox[{{-2.122879874152912, -1.0567457639951539`}, {
    0.70866977429126, -0.7055403255703919}}], 
   LineBox[{{-2.182398394892821, -0.8747503364895166}, {
    0.7755658785102502, -0.6312666378723208}}], 
   LineBox[{{-2.220111112275957, -0.6840146927756953}, {
    0.8347127848391598, -0.5506855425976376}}], 
   LineBox[{{-2.2356412132963954`, -0.4864446003568535}, {
    0.8855195169413194, -0.4646021794137566}}], 
   LineBox[{{-2.228833526318308, -0.2840141142884541}, {
    0.9274784307440359, -0.373876664830236}}], 
   LineBox[{{-2.1997560714996576`, -0.07874585307266874}, {
    0.960170286650366, -0.27941549819892586`}}], 
   LineBox[{{-2.1486993811572646`, 0.12730921067710232`}, {
    0.9832684384425847, -0.18216250427209502`}}], 
   LineBox[{{-2.0761735968639314`, 0.332092242876616}, {
    0.9965420970232175, -0.0830894028174964}}], 
   {RGBColor[0, 1, 0], PointSize[Large], PointBox[CompressedData["
1:eJw1hgsw2wccgI1iVOfRlpXi5t1WvO9iVH/UqOLqWW+zmbZDVaauJqOrjZ6x
2s5U0/WMpivWzqMETTx+6LIUY+IVFo8gJPL6pz2pOq623W7f3Xff915qduQF
dTU1NfjHf/sfSvj/Bkwat414BDiOlI80VzCBmpp3m5FEQM+Ej/Ve1hCwdJyn
zCsV4MFi3R7dmIDXdL4oOl8OmZdObHjJZiG8MFHL4bAMlJohueLmRTiUGHTS
Ll0CCX4PTW4ZrkBlTW1kdb4YmEcC06/UCOEC7bPFzJB1GH2Dg1Wb63B0pbLa
S7gKfo3JNA3DDSjX6tB3CF4GhZ7Od9FyCRh+zNF6qr0Anp+QQtnFMhjP965a
dOEB+7wp3X9SDimhxz9tt+BCiAV7O29aARqxB3u+GGCDxvIHS6OlBDRss8Om
zdqgPMvxHlVKgLtxCpu6XoPs0wJO0S4BFZfpm9uF/dhJc+Z1dRNAfcc2THVo
FJWHe4sGjxHQEuDB/L11CmM9TS1NghSgmRMVa0f/CwMZXMmrd+Uw/BNtX7u9
AHdypJBeKwVKU2mI2vQKvs17NOe+tAFCZxcTq8g1tHKOI3HnRVDK/Z7BoomQ
xn2mSqtZg8LyEmKLvoFPhv880GK3CpTNG6/uZ0qxu6Sue/e6AOo1LrY7KGSo
12Bj45rAh1BKbF6LnQL715KtcyjTMOz7gG9sROCkS9DM09oxmFgr6dvXTGDi
dGeWp8Eg2NTHnJG8JtDJgPaVfvBD6Bxhrmi/JNCNJH6fvNqEnfsbHLPvEnhH
r2tY3fU3VO/78Jm6UoG5oXsGQwnjmGI6oJG7JUfLVNZ176szGO84wTjVJsMX
XKW/X+Q8kucKm+jWUvQzc5JlbApQ3Mgvvhe2gXX9sr2YqlUUPfdInfES4Vi7
JclJfR0HbPha9RIhNlvMLzDJYkwjZbio0law9/kKNcpZguacMtmVj5Zw1mh8
6eWqFKO8jSuf1M+hbdlbXt4Rcnw0mFoQ+3gSlQ4BrjevKjDDJy46cWcYb/hy
fORnCCy7FX9Cu7MHWbLkgxF/EOiREe7vlfINRsrI+il7BH7pey7u/MVO2PPR
+7FKQGCacYH9gyUO/Cy1uuZLIXAuOJNSYj8B7ncFqqIWBT5OElYMucwC02r2
aGCdHBUZ5HjS7gLwbFhtpwNkOO+WC9m9y0A26okm7kvw21bb7EthQqBout0p
YIkxaEr75OWmdYht1T039MM6Fut+XZrNFQNDVW0S4y7E428OVG91SKCOQz1L
rl1G+5wGLVKMDIaXKji6PQt4LHz7lKhJDma9+9Noch6qrD7X6WIqoJ/eWvZi
mYsM2tkU4hoBSTvuvCMRHBz7Jd/311UCzEf7+HEBHfg3aMAd2w==
     "]], 
    {RGBColor[1, 0, 0], PointBox[CompressedData["
1:eJwBAQT++yFib1JlAgAAAD8AAAACAAAAAAAAAAAAAMAAAAAAAADgPw5b7wwo
Pv6/rP62LzVP5j8iqA+x9C78v5uaWtxZZew/LVvAbqrX+b+IH+k/bhnxPx3J
kC1GPve/dJyMrnLU8z/Uu0jpbWn0v0xivDu+XPY/Z7p1sF9g8b8fWLem1qv4
P2sh+Tu+Vey/HgHu/dO7+j/9MSP6QqLlv+ZkXLpvh/w/7jeQKeNu3b/IYAI+
Egr+P6AAhEHum86/kU72kt4//z8guz9TV16Qv60ngybeEgBA1G97N5SJyj+A
4lC6r1wAQNijNSOJbds/6zNlM6d8AECCNTsBEKjkPzoLg81ycgBAIe86R4Vk
6z+sTtWiLD4AQBQaG7p07fA/mYRV0rTA/z9+Z8BoWv3zP+1x5TfYs/4/ls6n
lB7a9j8Ixcosc1j9PwM/J+xufPk/oa/zR/6x+z8mkxKhjt37PwVG5x+yxPk/
SFiOpGf3/T9IS8V+fJX3P/QYXjiaxP8/rKvIxvMp9T+6I+5WRaAAQCkjjKdI
iPI/Kl25l7YzAUBsOj+RbG7vP2u4NrsnmwFApM/cI+J76T+nmygqkNUBQD6R
AHwoSOM/tJY3flriAUBySuOUOcbZP950FwBmwQFAaLbInml0yT9yIzb7BnMB
QMD9w1aBl3y/P2Ae5gX4AEDuIJ6hmDvLv1OztWGdUQBAGKKwZmam2r9Miuoo
7gL/P4HrmdhqteO/IypQ004T/T8mDK/7OOXpv+XqHn9Q2fo/dauucsrS77/X
gRIkpVr4P6d3TcB6t/K/3ffVY66d9T8P9CxPsFX1v5bLZjdtqfI/j5GNl1O9
978wkcoJ4ArvP9qqI+E96Pm/AN5Jl35z6D8I5qzF49D7v9Qq2i+SneE/3ueS
X2Ny/b8WJOPLLTXVPxZU/caQyP6/KKLVZeDjuz+8a2G9AND/v5B2Wj9NVL2/
yCgitghDAMCMzMRpXZDVv6PAaJB4dADAyyGbkz/K4b8rYoZ50XsAwFiJh0jP
nui/k1xcpgBZAMAAaR09ZTTvv16evSRfDADAD+cP+BS98r/7y0nvYS3/v2t7
8AQJsPW/PiqrQ0by/b8G8iWzg2v4v9gv00eRavy/sj/e1Yfo+r8kl/vqLJr6
v+LH+AW4IP2/eTeTB72F+L/4O9LpZg7/v4AF34STMva/ollf3VJWAMBNmWi7
oqbzvzqWhnGo+wDARbsIP27o8L+vQidKjXUBwCZm7Gr0/eu//bBlncnCAcAr
kO7HcuPlvw2VRdyX4gHAbU12iOgh37+4H/6rptQBwA0qHolJLdK/0iUSthmZ
AcAsiqQvsCi0vxAMGE2JMAHAsDorEKtLwD9QyxrnAJwAwEBDmtL/QNU/bfUJ
Yw==
      "]]}}, LineBox[{{4.5, 0.}, {1., 0.}}], 
   LineBox[{{4.477518743751117, 0.4492503749107267}, {0.9950041652780258, 
    0.09983341664682815}}], 
   LineBox[{{4.410299600285588, 0.8940119885777755}, {0.9800665778412416, 
    0.19866933079506122`}}], 
   LineBox[{{4.299014201065227, 1.329840929976028}, {0.955336489125606, 
    0.2955202066613396}}], 
   LineBox[{{4.144774473012983, 1.7523825403889273`}, {0.9210609940028851, 
    0.3894183423086505}}], 
   LineBox[{{3.9491215285066774`, 2.1574149237189135`}, {0.8775825618903728, 
    0.479425538604203}}], 
   LineBox[{{3.7140102670935518`, 2.5408911302776596`}, {0.8253356149096782, 
    0.5646424733950355}}], 
   LineBox[{{3.4417898427801976`, 2.89897959256961}, {0.7648421872844884, 
    0.6442176872376911}}], 
   LineBox[{{3.1351801920622444`, 3.2281024090478527`}, {0.6967067093471654, 
    0.7173560908995228}}], 
   LineBox[{{2.79724485721799, 3.5249710933236753`}, {0.6216099682706644, 
    0.7833269096274834}}], 
   LineBox[{{2.4313603764066283`, 3.7866194316355344`}, {0.5403023058681397, 
    0.8414709848078965}}], 
   LineBox[{{2.041182546415098, 4.01043312027646}, {0.4535961214255773, 
    0.8912073600614354}}], 
   LineBox[{{1.6306098951450303`, 4.194175886852519}, {0.3623577544766734, 
    0.9320390859672264}}], 
   LineBox[{{1.203744728810643, 4.336011834377368}, {0.26749882862458735`, 
    0.963558185417193}}], 
   LineBox[{{0.7648521430510836, 4.434523784948071}, {0.16996714290024081`, 
    0.9854497299884603}}], 
   LineBox[{{0.3183174075046631, 4.488727439718245}, {0.0707372016677029, 
    0.9974949866040544}}], 
   LineBox[{{-0.13139785035579968`, 
    4.498081213686773}, {-0.029199522301288815`, 0.9995736030415051}}], 
   LineBox[{{-0.5798002243298619, 4.462491647036108}, {-0.12884449429552486`, 
    0.9916648104524686}}], 
   LineBox[{{-1.022409426118892, 4.382314338951878}, {-0.2272020946930871, 
    0.9738476308781951}}], 
   LineBox[{{-1.4548030508857661`, 4.258350394593365}, {-0.3232895668635036, 
    0.9463000876874145}}], 
   LineBox[{{-1.872660764462141, 4.091838420715567}, {-0.4161468365471424, 
    0.9092974268256817}}], 
   LineBox[{{-2.271807470699359, 3.8844421499199315`}, {-0.5048461045998576, 
    0.8632093666488737}}], 
   LineBox[{{-2.648255027649056, 3.6382338171881554`}, {-0.5885011172553458, 
    0.8084964038195901}}], 
   LineBox[{{-2.9982420957592097`, 3.35567345479524}, {-0.6662760212798244, 
    0.74570521217672}}], 
   LineBox[{{-3.318271719935606, 3.039584312480178}, {-0.7373937155412458, 
    0.6754631805511506}}], 
   LineBox[{{-3.605146269961202, 2.6931246484678044`}, {-0.8011436155469337, 
    0.5984721441039565}}], 
   LineBox[{{-3.855999390160263, 2.3197561731965886`}, {-0.8568887533689473, 
    0.5155013718214642}}], 
   LineBox[{{-4.068324639076775, 1.9232094610522341`}, {-0.9040721420170612, 
    0.4273798802338298}}], 
   LineBox[{{-4.2400005330089625`, 1.507446675701571}, {-0.9422223406686583, 
    0.33498815015590466`}}], 
   LineBox[{{-4.369311743173158, 1.076621981462919}, {-0.9709581651495907, 
    0.23924932921398198`}}], 
   LineBox[{{-4.454966234702004, 0.6350400362694024}, {-0.9899924966004454, 
    0.1411200080598672}}], 
   LineBox[{{-4.4961081762297574`, 
    0.18711298094980722`}, {-0.9991351502732795, 0.04158066243329049}}], 
   LineBox[{{-4.492326491076389, -0.2626836454241104}, {-0.9982947757947531, \
-0.058374143427580086`}}], 
   LineBox[{{-4.443658964589892, -0.709855623644619}, {-0.9874797699088649, \
-0.15774569414324865`}}], 
   LineBox[{{-4.350591866607574, -1.1499349591207424`}, {-0.9667981925794609, \
-0.25554110202683167`}}], 
   LineBox[{{-4.214055092808583, -1.5785245246032893`}, {-0.9364566872907963, \
-0.35078322768961984`}}], 
   LineBox[{{-4.035412873503661, -1.991341994826836}, {-0.896758416334147, \
-0.44252044329485246`}}], 
   LineBox[{{-3.8164501426968362`, -2.3842626340882203`}, \
{-0.848100031710408, -0.5298361409084934}}], 
   LineBox[{{-3.5593547036148743`, -2.7533605092422366`}, \
{-0.7909677119144165, -0.6118578909427193}}], 
   LineBox[{{-3.2666953689006295`, -3.0949477163278836`}, \
{-0.7259323042001399, -0.6877661591839741}}], 
   LineBox[{{-2.9413962938862537`, -3.405611228885677}, {-0.6536436208636119, \
-0.7568024953079282}}], 
   LineBox[{{-2.586707759399708, -3.682246999789849}, {-0.5748239465332685, \
-0.8182771110644108}}], 
   LineBox[{{-2.2061736960331473`, -3.922090975861147}, {-0.4902608213406994, \
-0.8715757724135882}}], 
   LineBox[{{-1.8035962743598895`, -4.122746715372547}, \
{-0.40079917207997545`, -0.9161659367494549}}], 
   LineBox[{{-1.382997914902887, -4.2822093325028225`}, \
{-0.30733286997841935`, -0.9516020738895161}}], 
   LineBox[{{-0.9485810974385086, -4.3988855294929365`}, \
{-0.2107957994307797, -0.977530117665097}}], 
   LineBox[{{-0.504686371207743, -4.471609516350591}, {-0.11215252693505398`, \
-0.9936910036334645}}], 
   LineBox[{{-0.05574898558300752, -4.499654659038454}, \
{-0.01238866346289056, -0.9999232575641008}}], 
   LineBox[{{0.39374542547751273`, -4.482740739761282}, {
    0.08749898343944727, -0.9961646088358406}}], 
   LineBox[{{0.8393056624015909, -4.421036756809496}, {
    0.18651236942257576`, -0.9824526126243325}}], 
   LineBox[{{1.276479834584518, -4.315159235984123}, {
    0.28366218546322625`, -0.9589242746631385}}], 
   LineBox[{{1.7008998422084147`, -4.1661660704747945`}, {
    0.37797774271298107`, -0.9258146823277321}}], 
   LineBox[{{2.108325020851697, -3.975545950740689}, {
    0.4685166713003771, -0.8834546557201531}}], 
   LineBox[{{2.494684512806227, -3.7452034900075537`}, {
    0.5543743361791615, -0.8322674422239008}}], 
   LineBox[{{2.8561179417418563`, -3.477440194001942}, {
    0.6346928759426347, -0.7727644875559871}}], 
   LineBox[{{3.18901398431067, -3.1749314650667637`}, {
    0.70866977429126, -0.7055403255703919}}], 
   LineBox[{{3.4900464532961255`, -2.8406998704254436`}, {
    0.7755658785102502, -0.6312666378723208}}], 
   LineBox[{{3.756207531776219, -2.478084941689369}, {
    0.8347127848391598, -0.5506855425976376}}], 
   LineBox[{{3.984837826235937, -2.090709807361905}, {
    0.8855195169413194, -0.4646021794137566}}], 
   LineBox[{{4.1736529383481615`, -1.682444991736062}, {
    0.9274784307440359, -0.373876664830236}}], 
   LineBox[{{4.320766289926647, -1.2573697418951664`}, {
    0.960170286650366, -0.27941549819892586`}}], 
   LineBox[{{4.424707972991631, -0.8197312692244276}, {
    0.9832684384425847, -0.18216250427209502`}}], 
   LineBox[{{4.484439436604479, -0.3739023126787338}, {
    0.9965420970232175, -0.0830894028174964}}], 
   {RGBColor[0, 1, 0], PointSize[Large], PointBox[CompressedData["
1:eJw1hgsw2wccgI1iVOfRlpXi5t1WvO9iVH/UqOLqWW+zmbZDVaauJqOrjZ6x
2s5U0/WMpivWzqMETTx+6LIUY+IVFo8gJPL6pz2pOq623W7f3Xff915qduQF
dTU1NfjHf/sfSvj/Bkwat414BDiOlI80VzCBmpp3m5FEQM+Ej/Ve1hCwdJyn
zCsV4MFi3R7dmIDXdL4oOl8OmZdObHjJZiG8MFHL4bAMlJohueLmRTiUGHTS
Ll0CCX4PTW4ZrkBlTW1kdb4YmEcC06/UCOEC7bPFzJB1GH2Dg1Wb63B0pbLa
S7gKfo3JNA3DDSjX6tB3CF4GhZ7Od9FyCRh+zNF6qr0Anp+QQtnFMhjP965a
dOEB+7wp3X9SDimhxz9tt+BCiAV7O29aARqxB3u+GGCDxvIHS6OlBDRss8Om
zdqgPMvxHlVKgLtxCpu6XoPs0wJO0S4BFZfpm9uF/dhJc+Z1dRNAfcc2THVo
FJWHe4sGjxHQEuDB/L11CmM9TS1NghSgmRMVa0f/CwMZXMmrd+Uw/BNtX7u9
AHdypJBeKwVKU2mI2vQKvs17NOe+tAFCZxcTq8g1tHKOI3HnRVDK/Z7BoomQ
xn2mSqtZg8LyEmKLvoFPhv880GK3CpTNG6/uZ0qxu6Sue/e6AOo1LrY7KGSo
12Bj45rAh1BKbF6LnQL715KtcyjTMOz7gG9sROCkS9DM09oxmFgr6dvXTGDi
dGeWp8Eg2NTHnJG8JtDJgPaVfvBD6Bxhrmi/JNCNJH6fvNqEnfsbHLPvEnhH
r2tY3fU3VO/78Jm6UoG5oXsGQwnjmGI6oJG7JUfLVNZ176szGO84wTjVJsMX
XKW/X+Q8kucKm+jWUvQzc5JlbApQ3Mgvvhe2gXX9sr2YqlUUPfdInfES4Vi7
JclJfR0HbPha9RIhNlvMLzDJYkwjZbio0law9/kKNcpZguacMtmVj5Zw1mh8
6eWqFKO8jSuf1M+hbdlbXt4Rcnw0mFoQ+3gSlQ4BrjevKjDDJy46cWcYb/hy
fORnCCy7FX9Cu7MHWbLkgxF/EOiREe7vlfINRsrI+il7BH7pey7u/MVO2PPR
+7FKQGCacYH9gyUO/Cy1uuZLIXAuOJNSYj8B7ncFqqIWBT5OElYMucwC02r2
aGCdHBUZ5HjS7gLwbFhtpwNkOO+WC9m9y0A26okm7kvw21bb7EthQqBout0p
YIkxaEr75OWmdYht1T039MM6Fut+XZrNFQNDVW0S4y7E428OVG91SKCOQz1L
rl1G+5wGLVKMDIaXKji6PQt4LHz7lKhJDma9+9Noch6qrD7X6WIqoJ/eWvZi
mYsM2tkU4hoBSTvuvCMRHBz7Jd/311UCzEf7+HEBHfg3aMAd2w==
     "]], 
    {RGBColor[1, 0.5, 0], PointBox[CompressedData["
1:eJwBAQT++yFib1JlAgAAAD8AAAACAAAAAAAAAAAAEkAAAAAAAAAAAF2Nbqz6
6BFAkkT9pITA3D9lJxOUJaQRQBSNpQe/m+w/eXVaxzAyEUB6EXJIB0f1P6yL
a8I/lBBAWNRQRsIJ/D/67CYHzZcPQFczasFiQgFAdmbRA0u2DUCF6Zm6vlME
QESR8xzJiAtA8NxuNhwxB0Byyz9a2RQJQKf+F1sn0wlAYD5l6cFgBkBJXWkL
JDMMQFynqxFtcwNAjC7qIP9KDkCaJtCDV1QAQNCH2fquChBACunCZvoW+j8/
0C4L1sYQQOuVL9WJQvM/CuF+fBNYEUDjwZUzq3noP5K+ls3zvBFA3Li++U9f
1D+e/Uj3dPQRQH18BQ+l0cC/jyVuAAn+EUAgujYzuY3iv+bFCmmX2RFAJdiE
/Mlb8L9XXPpofYcRQGXOWpDfRve/sb9+AY0IEUBG4D0ia/b9v2f1FeQKXhBA
o7IrZaksAsBa4ehnVhMPQB7D+VSgLwXA6THgVBobDUDgNRZaZvwHwAY1A1Nr
2ApAuesiC9KLCsDLS3yUEVEIQO08du1W1wzAB8SJ74SLBUD+ElE1FtkOwHKW
FFPcjgJADWLp5PZFEMDuO6lId8X+PysvIbPC9RDAeKLJZ4Ae+D9y1IvbLHoR
wHebiPjXOfE/RlErq+LREcAGsG17P1LkP3S9IMgD/BHANBLrclHzxz+Wgohv
JPgRwGyZkhDPz9C/lvYdiU7GEcAq7g0kI7fmv+FK5Y0BZxHAAjYfMyJm8r/V
nhxCMdsQwGOuke6iQfm/8ji2RUMkEMAv7G5sidz/v16ULQMXiA7Aqd6zSfgS
A8AFHnf1jnkMwLRY6t/hBgbABGJ7LjEiCsBIqsPyc8IIwFmJtsf6hwfAhKKX
GbE+C8AQc3fWk7EEwNUhP+o9dQ3AABAOZT6mAcAzFco7cWAPwL0CWcSH2/y/
td2gULF9EMD/Gu9rwiD2vwfntnv7IBHAF0XjvsZa7r9IFMBydZgRwJ5fYghk
JuC/KdXkmu3iEcB6d7qLIYusv+50j3il/xHAjwhYAyAz2T/f4qaWU+4RwDCZ
a4yX2+o/jKRzQiSvEcA0tHgedmz0Py1WThq5QhHAQOjAwOI2+z+IkzlwJ6oQ
wCYsL4LZ3QBAcmkRCevND8A4uWInHfUDQH6UUz8t9g3AnmYKXVTZBkAeRhgq
zNELwNHOiMMZgwlAYgbMd0JmCcDUa5N5nesLQGrUidrAuQbA773PiLYMDkCU
IKoyHtMDwGxgfKfy4A9A4l1AEMa5AMAXPWwT0rEQQL40jXBL6/q/qpNT9XZI
EUAYtwa8Lx70v+VlmaXmshFAyHoaEj076r+Eb0TkEPARQMGmNvcD7te/EoTT
ZA==
      "]]}}, LineBox[{{-9., 2.25}, {1., 0.}}], 
   LineBox[{{-8.505787112591506, 3.137260121697012}, {0.9950041652780258, 
    0.09983341664682815}}], 
   LineBox[{{-7.9265872119934, 3.993173777298345}, {0.9800665778412416, 
    0.19866933079506122`}}], 
   LineBox[{{-7.268187472154427, 4.80918896048467}, {0.955336489125606, 
    0.2955202066613396}}], 
   LineBox[{{-6.5371664056370395`, 5.577152317284346}, {0.9210609940028851, 
    0.3894183423086505}}], 
   LineBox[{{-5.740828133294441, 6.289390611691166}, {0.8775825618903728, 
    0.479425538604203}}], 
   LineBox[{{-4.887129403909444, 6.9387873941020946`}, {0.8253356149096782, 
    0.5646424733950355}}], 
   LineBox[{{-3.984600092990785, 7.518854106529319}, {0.7648421872844884, 
    0.6442176872376911}}], 
   LineBox[{{-3.042257975076636, 8.023794914126828}, {0.6967067093471654, 
    0.7173560908995228}}], 
   LineBox[{{-2.0695186211123047`, 8.448564615256345}, {0.6216099682706644, 
    0.7833269096274834}}], 
   LineBox[{{-1.0761013211777222`, 8.788919051474384}, {0.5403023058681397, 
    0.8414709848078965}}], 
   LineBox[{{-0.0719319725537364, 9.041457513760468}, {0.4535961214255773, 
    0.8912073600614354}}], 
   LineBox[{{0.9329560965624584, 9.203656721277554}, {0.3623577544766734, 
    0.9320390859672264}}], 
   LineBox[{{1.928522376756082, 9.273896033160058}, {0.26749882862458735`, 
    0.963558185417193}}], 
   LineBox[{{2.904819498845904, 9.251473641421684}, {0.16996714290024081`, 
    0.9854497299884603}}], 
   LineBox[{{3.8520926247089187`, 9.13661358318882}, {0.0707372016677029, 
    0.9974949866040544}}], 
   LineBox[{{4.760876914398373, 8.930463502195646}, {-0.029199522301288815`, 
    0.9995736030415051}}], 
   LineBox[{{5.622092095695832, 8.635083181907286}, {-0.12884449429552486`, 
    0.9916648104524686}}], 
   LineBox[{{6.427133191189663, 8.25342396484431}, {-0.2272020946930871, 
    0.9738476308781951}}], 
   LineBox[{{7.167956496364898, 7.789299263743847}, {-0.3232895668635036, 
    0.9463000876874145}}], 
   LineBox[{{7.837159949639849, 7.247346459200064}, {-0.4161468365471424, 
    0.9092974268256817}}], 
   LineBox[{{8.42805709131865, 6.632980564490183}, {-0.5048461045998576, 
    0.8632093666488737}}], 
   LineBox[{{8.934743872486267, 5.952340120551783}, {-0.5885011172553458, 
    0.8084964038195901}}], 
   LineBox[{{9.35215764631366, 5.212225861710875}, {-0.6662760212798244, 
    0.74570521217672}}], 
   LineBox[{{9.67612775235139, 4.420032764992553}, {-0.7373937155412458, 
    0.6754631805511506}}], 
   LineBox[{{9.903417188390208, 3.583676161955008}, {-0.8011436155469337, 
    0.5984721441039565}}], 
   LineBox[{{10.031754953517115`, 2.7115126513130456`}, {-0.8568887533689473, 
    0.5155013718214642}}], 
   LineBox[{{10.059858739205785`, 1.8122566025660807`}, {-0.9040721420170612, 
    0.4273798802338298}}], 
   LineBox[{{9.987447741719496, 0.8948930848986607}, {-0.9422223406686583, 
    0.33498815015590466`}}], 
   LineBox[{{9.815245467809236, -0.03141190866074117}, {-0.9709581651495907, 
    0.23924932921398198`}}], 
   LineBox[{{9.54497250567341, -0.9574030448121973}, {-0.9899924966004454, 
    0.1411200080598672}}], 
   LineBox[{{9.179329333409322, -1.8738281262152643`}, {-0.9991351502732795, 
    0.04158066243329049}}], 
   LineBox[{{
    8.721969336728668, -2.771530536386415}, {-0.9982947757947531, \
-0.058374143427580086`}}], 
   LineBox[{{
    8.177462305535164, -3.6415407295841837`}, {-0.9874797699088649, \
-0.15774569414324865`}}], 
   LineBox[{{
    7.551248774094406, -4.475165851545272}, {-0.9667981925794609, \
-0.25554110202683167`}}], 
   LineBox[{{
    6.849585661013877, -5.26407659561087}, {-0.9364566872907963, \
-0.35078322768961984`}}], 
   LineBox[{{
    6.0794837521804865`, -6.000390426405502}, {-0.896758416334147, \
-0.44252044329485246`}}], 
   LineBox[{{
    5.248637651305453, -6.676750339524858}, {-0.848100031710408, \
-0.5298361409084934}}], 
   LineBox[{{
    4.365348897987512, -7.28639837029191}, {-0.7909677119144165, \
-0.6118578909427193}}], 
   LineBox[{{
    3.4384430214733754`, -7.823243117106082}, {-0.7259323042001399, \
-0.6877661591839741}}], 
   LineBox[{{
    2.4771813588868303`, -8.28192060471448}, {-0.6536436208636119, \
-0.7568024953079282}}], 
   LineBox[{{
    1.4911685190095674`, -8.65784787927955}, {-0.5748239465332685, \
-0.8182771110644108}}], 
   LineBox[{{
    0.4902564162051477, -8.947268799738868}, {-0.4902608213406994, \
-0.8715757724135882}}], 
   LineBox[{{-0.5155541666527683, -9.14729156792504}, {-0.40079917207997545`, \
-0.9161659367494549}}], 
   LineBox[{{-1.5162135026970485`, -9.255917622457089}, \
{-0.30733286997841935`, -0.9516020738895161}}], 
   LineBox[{{-2.501723334615919, -9.272061607705128}, {-0.2107957994307797, \
-0.977530117665097}}], 
   LineBox[{{-3.4622367739351048`, -9.195562218305053}, \
{-0.11215252693505398`, -0.9936910036334645}}], 
   LineBox[{{-4.3881566878724385`, -9.027183810868411}, \
{-0.01238866346289056, -0.9999232575641008}}], 
   LineBox[{{-5.270231590716308, -8.768608766783808}, {
    0.08749898343944727, -0.9961646088358406}}], 
   LineBox[{{-6.099648081612678, -8.422420682418196}, {
    0.18651236942257576`, -0.9824526126243325}}], 
   LineBox[{{-6.8681189051531595`, -7.992078554675988}, {
    0.28366218546322625`, -0.9589242746631385}}], 
   LineBox[{{-7.567965754891624, -7.481882219845382}, {
    0.37797774271298107`, -0.9258146823277321}}], 
   LineBox[{{-8.192195992444084, -6.896929391055529}, {
    0.4685166713003771, -0.8834546557201531}}], 
   LineBox[{{-8.734572515620009, -6.243064723611994}, {
    0.5543743361791615, -0.8322674422239008}}], 
   LineBox[{{-9.189676077485654, -5.526821417132956}, {
    0.6346928759426347, -0.7727644875559871}}], 
   LineBox[{{-9.552959433688104, -4.755355937978193}, {
    0.70866977429126, -0.7055403255703919}}], 
   LineBox[{{-9.820792777017694, -3.9363765142028244`}, {
    0.7755658785102502, -0.6312666378723208}}], 
   LineBox[{{-9.990500005241806, -3.0780661174906285`}, {
    0.8347127848391598, -0.5506855425976376}}], 
   LineBox[{{-10.060385459833778`, -2.189000701605841}, {
    0.8855195169413194, -0.4646021794137566}}], 
   LineBox[{{-10.029750868432386`, -1.2780635142980432`}, {
    0.9274784307440359, -0.373876664830236}}], 
   LineBox[{{-9.89890232174846, -0.35435633882700923`}, {
    0.960170286650366, -0.27941549819892586`}}], 
   LineBox[{{-9.66914721520769, 0.5728914480469602}, {
    0.9832684384425847, -0.18216250427209502`}}], 
   LineBox[{{-9.342781185887691, 1.494415092944772}, {
    0.9965420970232175, -0.0830894028174964}}], 
   {RGBColor[0, 1, 0], PointSize[Large], PointBox[CompressedData["
1:eJw1hgsw2wccgI1iVOfRlpXi5t1WvO9iVH/UqOLqWW+zmbZDVaauJqOrjZ6x
2s5U0/WMpivWzqMETTx+6LIUY+IVFo8gJPL6pz2pOq623W7f3Xff915qduQF
dTU1NfjHf/sfSvj/Bkwat414BDiOlI80VzCBmpp3m5FEQM+Ej/Ve1hCwdJyn
zCsV4MFi3R7dmIDXdL4oOl8OmZdObHjJZiG8MFHL4bAMlJohueLmRTiUGHTS
Ll0CCX4PTW4ZrkBlTW1kdb4YmEcC06/UCOEC7bPFzJB1GH2Dg1Wb63B0pbLa
S7gKfo3JNA3DDSjX6tB3CF4GhZ7Od9FyCRh+zNF6qr0Anp+QQtnFMhjP965a
dOEB+7wp3X9SDimhxz9tt+BCiAV7O29aARqxB3u+GGCDxvIHS6OlBDRss8Om
zdqgPMvxHlVKgLtxCpu6XoPs0wJO0S4BFZfpm9uF/dhJc+Z1dRNAfcc2THVo
FJWHe4sGjxHQEuDB/L11CmM9TS1NghSgmRMVa0f/CwMZXMmrd+Uw/BNtX7u9
AHdypJBeKwVKU2mI2vQKvs17NOe+tAFCZxcTq8g1tHKOI3HnRVDK/Z7BoomQ
xn2mSqtZg8LyEmKLvoFPhv880GK3CpTNG6/uZ0qxu6Sue/e6AOo1LrY7KGSo
12Bj45rAh1BKbF6LnQL715KtcyjTMOz7gG9sROCkS9DM09oxmFgr6dvXTGDi
dGeWp8Eg2NTHnJG8JtDJgPaVfvBD6Bxhrmi/JNCNJH6fvNqEnfsbHLPvEnhH
r2tY3fU3VO/78Jm6UoG5oXsGQwnjmGI6oJG7JUfLVNZ176szGO84wTjVJsMX
XKW/X+Q8kucKm+jWUvQzc5JlbApQ3Mgvvhe2gXX9sr2YqlUUPfdInfES4Vi7
JclJfR0HbPha9RIhNlvMLzDJYkwjZbio0law9/kKNcpZguacMtmVj5Zw1mh8
6eWqFKO8jSuf1M+hbdlbXt4Rcnw0mFoQ+3gSlQ4BrjevKjDDJy46cWcYb/hy
fORnCCy7FX9Cu7MHWbLkgxF/EOiREe7vlfINRsrI+il7BH7pey7u/MVO2PPR
+7FKQGCacYH9gyUO/Cy1uuZLIXAuOJNSYj8B7ncFqqIWBT5OElYMucwC02r2
aGCdHBUZ5HjS7gLwbFhtpwNkOO+WC9m9y0A26okm7kvw21bb7EthQqBout0p
YIkxaEr75OWmdYht1T039MM6Fut+XZrNFQNDVW0S4y7E428OVG91SKCOQz1L
rl1G+5wGLVKMDIaXKji6PQt4LHz7lKhJDma9+9Noch6qrD7X6WIqoJ/eWvZi
mYsM2tkU4hoBSTvuvCMRHBz7Jd/311UCzEf7+HEBHfg3aMAd2w==
     "]], 
    {RGBColor[1, 1, 0], PointBox[CompressedData["
1:eJwlxQsw1AkcwPFlvR/Lei5rX/9F6iTtaqo77A9pu9E5NHnkRqU8dsuFi4w7
o+VaspJcuc1xDqdcQljMlG5/zFwxIUu6PeI8WtfDKptDU9xj+s5858OJPxWR
oE8ikQT//b8fIvCD+rCrbm/Bij4H86aaxuhOpuBRtV04qmDhK63G0VBnBZcT
5d3VNgzMDpo3rvS1hcDZwDcUd2fU944z0PvcAUJH0679sOKA5Yt8cqSHEyjS
vr12otgWiaCSr8N76CAPziJnTlthQE9jTqgtE/zkSTGySBPsXRtVe1mw4Qzr
6P3DJSRMjZwJvKFhQzSMG3TuXFLyim/wtN9x4GzbdT9C3KasKz7wcrc9AcOT
4l/vjWsFwxsVrcHJBEREVwo/ntgQiMZVTr7FBPAq4/Vs/Iyh5iR/U89ZAgw/
I17bqyggWdu2UxdMQFROXDjX3BbKncM6E55w4MvT6g7DHAewt06r3hzMAXGf
b1J8hxOMUXj9KGHDU/eb/e8bXeCKm87a34MFRRqfDIhhwW9eT4/tW3eBBmrp
/i0TbGhdrqJ4FjqD6aJCWT7FAaKnRsB76Ai8Zw/0QhUElFzP6Q7/ww4eFt4S
bz3EhcnSdiqjmQpZF6vaioe4IBdFJ8c1WoBLS8q2QGtXSKg7K9vaagiy8xuD
9UxX6G3PvU/6570g+5gzlr3lgs9gzchK7YJg5q/K8aQaLqD/EO6y/0m513O2
1siRCxYaVYd53aLyrmjBUhVLQGynlM9/t658oCWv1qdxYMmjiU/zNMJ2x8nI
J4fY0Kh1pU9zLDGwT/9itg8T0iFv+tI8Fakjl/veJtCh0j2KJqbYo7ozzPt4
OA1Ky2xiEkk0NKs/MFWxYQcYlGu2oXDGxiWJITOTCjvY+6qC3RiITnzxosQc
+vPi/UkhLPRKHcvYoyJDSm2vJqqUjeWFh8+NTqwK9ucunlKFcTA5sjT9iyN/
CioGpGKShoOK2dqvTuROK2dS5gdEIQQyE9cdRIFryi51Rq1xPoEGUoq0gGyA
aV5dDSEyAvOz5dt/aTNH92eb7rCPE2gtO6LLukDFLREHTV9aErg0R/2+y84e
7+ZddSg4z0F1UYmbWSINe4XWUqGajcJbRZuXs+j46Mpg6twqCxuMK4blwUw0
MYstTNcyMPV1bH5SPBuTfzzXcLqcjt0B0jmnLA56z2f/rVmj4eM95rsZRwnM
vDlmc4bugHqirlwGnYvNI8+NvjG0RYOPTr7x/5mLL3SfrrXlWKFLko2KeMdF
7/gF9ky1CTYLh35/wXTFElnvgE2+HrbM5Ug+sXLF0FcBt3Xpy8oL4kcLvgNc
TKVf3XGv6bGyzPJOZkUkFw1qvdPZB2cFt103yJIWAhtk2gHW81XBvynWxxo=

      "]]}}},
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 12}]], "Output",
 CellChangeTimes->{
  3.5848060119894543`*^9, 3.5848099237054815`*^9, {3.5848099681455436`*^9, 
   3.5848099794955597`*^9}, 3.5848101045557346`*^9, {3.584810152915802*^9, 
   3.584810187875851*^9}, {3.5848103051160154`*^9, 3.5848103267860456`*^9}, 
   3.584810362286095*^9, {3.584810452826222*^9, 3.5848104797262597`*^9}, 
   3.5848105254363236`*^9, 3.584810623666461*^9, 3.5848107171805944`*^9, 
   3.5848108832708273`*^9, {3.584811200321271*^9, 3.5848112257713065`*^9}, {
   3.584811414301571*^9, 3.5848114694916477`*^9}, {3.5848115007816916`*^9, 
   3.5848115178717155`*^9}, {3.5848115556917686`*^9, 3.584811631671875*^9}}],

Cell[BoxData["\<\"Without the lines \"\>"], "Print",
 CellChangeTimes->{
  3.584809923685481*^9, {3.5848099681255436`*^9, 3.584809979465559*^9}, 
   3.584810104535734*^9, {3.584810152895802*^9, 3.584810187855851*^9}, {
   3.584810305096015*^9, 3.5848103267460456`*^9}, 3.584810362266095*^9, {
   3.584810452766222*^9, 3.5848104796962595`*^9}, 3.5848105254063234`*^9, 
   3.5848106236364613`*^9, 3.584810717160595*^9, 3.584810883240827*^9, {
   3.584811200281271*^9, 3.5848112257313066`*^9}, {3.58481141427157*^9, 
   3.5848114694716477`*^9}, {3.584811500751692*^9, 3.5848115178517156`*^9}, {
   3.5848115556617684`*^9, 3.5848116316818748`*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0, 1, 0], PointSize[Large], PointBox[CompressedData["
1:eJw1hgsw2wccgI1iVOfRlpXi5t1WvO9iVH/UqOLqWW+zmbZDVaauJqOrjZ6x
2s5U0/WMpivWzqMETTx+6LIUY+IVFo8gJPL6pz2pOq623W7f3Xff915qduQF
dTU1NfjHf/sfSvj/Bkwat414BDiOlI80VzCBmpp3m5FEQM+Ej/Ve1hCwdJyn
zCsV4MFi3R7dmIDXdL4oOl8OmZdObHjJZiG8MFHL4bAMlJohueLmRTiUGHTS
Ll0CCX4PTW4ZrkBlTW1kdb4YmEcC06/UCOEC7bPFzJB1GH2Dg1Wb63B0pbLa
S7gKfo3JNA3DDSjX6tB3CF4GhZ7Od9FyCRh+zNF6qr0Anp+QQtnFMhjP965a
dOEB+7wp3X9SDimhxz9tt+BCiAV7O29aARqxB3u+GGCDxvIHS6OlBDRss8Om
zdqgPMvxHlVKgLtxCpu6XoPs0wJO0S4BFZfpm9uF/dhJc+Z1dRNAfcc2THVo
FJWHe4sGjxHQEuDB/L11CmM9TS1NghSgmRMVa0f/CwMZXMmrd+Uw/BNtX7u9
AHdypJBeKwVKU2mI2vQKvs17NOe+tAFCZxcTq8g1tHKOI3HnRVDK/Z7BoomQ
xn2mSqtZg8LyEmKLvoFPhv880GK3CpTNG6/uZ0qxu6Sue/e6AOo1LrY7KGSo
12Bj45rAh1BKbF6LnQL715KtcyjTMOz7gG9sROCkS9DM09oxmFgr6dvXTGDi
dGeWp8Eg2NTHnJG8JtDJgPaVfvBD6Bxhrmi/JNCNJH6fvNqEnfsbHLPvEnhH
r2tY3fU3VO/78Jm6UoG5oXsGQwnjmGI6oJG7JUfLVNZ176szGO84wTjVJsMX
XKW/X+Q8kucKm+jWUvQzc5JlbApQ3Mgvvhe2gXX9sr2YqlUUPfdInfES4Vi7
JclJfR0HbPha9RIhNlvMLzDJYkwjZbio0law9/kKNcpZguacMtmVj5Zw1mh8
6eWqFKO8jSuf1M+hbdlbXt4Rcnw0mFoQ+3gSlQ4BrjevKjDDJy46cWcYb/hy
fORnCCy7FX9Cu7MHWbLkgxF/EOiREe7vlfINRsrI+il7BH7pey7u/MVO2PPR
+7FKQGCacYH9gyUO/Cy1uuZLIXAuOJNSYj8B7ncFqqIWBT5OElYMucwC02r2
aGCdHBUZ5HjS7gLwbFhtpwNkOO+WC9m9y0A26okm7kvw21bb7EthQqBout0p
YIkxaEr75OWmdYht1T039MM6Fut+XZrNFQNDVW0S4y7E428OVG91SKCOQz1L
rl1G+5wGLVKMDIaXKji6PQt4LHz7lKhJDma9+9Noch6qrD7X6WIqoJ/eWvZi
mYsM2tkU4hoBSTvuvCMRHBz7Jd/311UCzEf7+HEBHfg3aMAd2w==
     "]], 
    {RGBColor[1, 0, 0], PointBox[CompressedData["
1:eJwBAQT++yFib1JlAgAAAD8AAAACAAAAAAAAAAAAAMAAAAAAAADgPw5b7wwo
Pv6/rP62LzVP5j8iqA+x9C78v5uaWtxZZew/LVvAbqrX+b+IH+k/bhnxPx3J
kC1GPve/dJyMrnLU8z/Uu0jpbWn0v0xivDu+XPY/Z7p1sF9g8b8fWLem1qv4
P2sh+Tu+Vey/HgHu/dO7+j/9MSP6QqLlv+ZkXLpvh/w/7jeQKeNu3b/IYAI+
Egr+P6AAhEHum86/kU72kt4//z8guz9TV16Qv60ngybeEgBA1G97N5SJyj+A
4lC6r1wAQNijNSOJbds/6zNlM6d8AECCNTsBEKjkPzoLg81ycgBAIe86R4Vk
6z+sTtWiLD4AQBQaG7p07fA/mYRV0rTA/z9+Z8BoWv3zP+1x5TfYs/4/ls6n
lB7a9j8Ixcosc1j9PwM/J+xufPk/oa/zR/6x+z8mkxKhjt37PwVG5x+yxPk/
SFiOpGf3/T9IS8V+fJX3P/QYXjiaxP8/rKvIxvMp9T+6I+5WRaAAQCkjjKdI
iPI/Kl25l7YzAUBsOj+RbG7vP2u4NrsnmwFApM/cI+J76T+nmygqkNUBQD6R
AHwoSOM/tJY3flriAUBySuOUOcbZP950FwBmwQFAaLbInml0yT9yIzb7BnMB
QMD9w1aBl3y/P2Ae5gX4AEDuIJ6hmDvLv1OztWGdUQBAGKKwZmam2r9Miuoo
7gL/P4HrmdhqteO/IypQ004T/T8mDK/7OOXpv+XqHn9Q2fo/dauucsrS77/X
gRIkpVr4P6d3TcB6t/K/3ffVY66d9T8P9CxPsFX1v5bLZjdtqfI/j5GNl1O9
978wkcoJ4ArvP9qqI+E96Pm/AN5Jl35z6D8I5qzF49D7v9Qq2i+SneE/3ueS
X2Ny/b8WJOPLLTXVPxZU/caQyP6/KKLVZeDjuz+8a2G9AND/v5B2Wj9NVL2/
yCgitghDAMCMzMRpXZDVv6PAaJB4dADAyyGbkz/K4b8rYoZ50XsAwFiJh0jP
nui/k1xcpgBZAMAAaR09ZTTvv16evSRfDADAD+cP+BS98r/7y0nvYS3/v2t7
8AQJsPW/PiqrQ0by/b8G8iWzg2v4v9gv00eRavy/sj/e1Yfo+r8kl/vqLJr6
v+LH+AW4IP2/eTeTB72F+L/4O9LpZg7/v4AF34STMva/ollf3VJWAMBNmWi7
oqbzvzqWhnGo+wDARbsIP27o8L+vQidKjXUBwCZm7Gr0/eu//bBlncnCAcAr
kO7HcuPlvw2VRdyX4gHAbU12iOgh37+4H/6rptQBwA0qHolJLdK/0iUSthmZ
AcAsiqQvsCi0vxAMGE2JMAHAsDorEKtLwD9QyxrnAJwAwEBDmtL/QNU/bfUJ
Yw==
      "]]}}, 
   {RGBColor[0, 1, 0], PointSize[Large], PointBox[CompressedData["
1:eJw1hgsw2wccgI1iVOfRlpXi5t1WvO9iVH/UqOLqWW+zmbZDVaauJqOrjZ6x
2s5U0/WMpivWzqMETTx+6LIUY+IVFo8gJPL6pz2pOq623W7f3Xff915qduQF
dTU1NfjHf/sfSvj/Bkwat414BDiOlI80VzCBmpp3m5FEQM+Ej/Ve1hCwdJyn
zCsV4MFi3R7dmIDXdL4oOl8OmZdObHjJZiG8MFHL4bAMlJohueLmRTiUGHTS
Ll0CCX4PTW4ZrkBlTW1kdb4YmEcC06/UCOEC7bPFzJB1GH2Dg1Wb63B0pbLa
S7gKfo3JNA3DDSjX6tB3CF4GhZ7Od9FyCRh+zNF6qr0Anp+QQtnFMhjP965a
dOEB+7wp3X9SDimhxz9tt+BCiAV7O29aARqxB3u+GGCDxvIHS6OlBDRss8Om
zdqgPMvxHlVKgLtxCpu6XoPs0wJO0S4BFZfpm9uF/dhJc+Z1dRNAfcc2THVo
FJWHe4sGjxHQEuDB/L11CmM9TS1NghSgmRMVa0f/CwMZXMmrd+Uw/BNtX7u9
AHdypJBeKwVKU2mI2vQKvs17NOe+tAFCZxcTq8g1tHKOI3HnRVDK/Z7BoomQ
xn2mSqtZg8LyEmKLvoFPhv880GK3CpTNG6/uZ0qxu6Sue/e6AOo1LrY7KGSo
12Bj45rAh1BKbF6LnQL715KtcyjTMOz7gG9sROCkS9DM09oxmFgr6dvXTGDi
dGeWp8Eg2NTHnJG8JtDJgPaVfvBD6Bxhrmi/JNCNJH6fvNqEnfsbHLPvEnhH
r2tY3fU3VO/78Jm6UoG5oXsGQwnjmGI6oJG7JUfLVNZ176szGO84wTjVJsMX
XKW/X+Q8kucKm+jWUvQzc5JlbApQ3Mgvvhe2gXX9sr2YqlUUPfdInfES4Vi7
JclJfR0HbPha9RIhNlvMLzDJYkwjZbio0law9/kKNcpZguacMtmVj5Zw1mh8
6eWqFKO8jSuf1M+hbdlbXt4Rcnw0mFoQ+3gSlQ4BrjevKjDDJy46cWcYb/hy
fORnCCy7FX9Cu7MHWbLkgxF/EOiREe7vlfINRsrI+il7BH7pey7u/MVO2PPR
+7FKQGCacYH9gyUO/Cy1uuZLIXAuOJNSYj8B7ncFqqIWBT5OElYMucwC02r2
aGCdHBUZ5HjS7gLwbFhtpwNkOO+WC9m9y0A26okm7kvw21bb7EthQqBout0p
YIkxaEr75OWmdYht1T039MM6Fut+XZrNFQNDVW0S4y7E428OVG91SKCOQz1L
rl1G+5wGLVKMDIaXKji6PQt4LHz7lKhJDma9+9Noch6qrD7X6WIqoJ/eWvZi
mYsM2tkU4hoBSTvuvCMRHBz7Jd/311UCzEf7+HEBHfg3aMAd2w==
     "]], 
    {RGBColor[1, 0.5, 0], PointBox[CompressedData["
1:eJwBAQT++yFib1JlAgAAAD8AAAACAAAAAAAAAAAAEkAAAAAAAAAAAF2Nbqz6
6BFAkkT9pITA3D9lJxOUJaQRQBSNpQe/m+w/eXVaxzAyEUB6EXJIB0f1P6yL
a8I/lBBAWNRQRsIJ/D/67CYHzZcPQFczasFiQgFAdmbRA0u2DUCF6Zm6vlME
QESR8xzJiAtA8NxuNhwxB0Byyz9a2RQJQKf+F1sn0wlAYD5l6cFgBkBJXWkL
JDMMQFynqxFtcwNAjC7qIP9KDkCaJtCDV1QAQNCH2fquChBACunCZvoW+j8/
0C4L1sYQQOuVL9WJQvM/CuF+fBNYEUDjwZUzq3noP5K+ls3zvBFA3Li++U9f
1D+e/Uj3dPQRQH18BQ+l0cC/jyVuAAn+EUAgujYzuY3iv+bFCmmX2RFAJdiE
/Mlb8L9XXPpofYcRQGXOWpDfRve/sb9+AY0IEUBG4D0ia/b9v2f1FeQKXhBA
o7IrZaksAsBa4ehnVhMPQB7D+VSgLwXA6THgVBobDUDgNRZaZvwHwAY1A1Nr
2ApAuesiC9KLCsDLS3yUEVEIQO08du1W1wzAB8SJ74SLBUD+ElE1FtkOwHKW
FFPcjgJADWLp5PZFEMDuO6lId8X+PysvIbPC9RDAeKLJZ4Ae+D9y1IvbLHoR
wHebiPjXOfE/RlErq+LREcAGsG17P1LkP3S9IMgD/BHANBLrclHzxz+Wgohv
JPgRwGyZkhDPz9C/lvYdiU7GEcAq7g0kI7fmv+FK5Y0BZxHAAjYfMyJm8r/V
nhxCMdsQwGOuke6iQfm/8ji2RUMkEMAv7G5sidz/v16ULQMXiA7Aqd6zSfgS
A8AFHnf1jnkMwLRY6t/hBgbABGJ7LjEiCsBIqsPyc8IIwFmJtsf6hwfAhKKX
GbE+C8AQc3fWk7EEwNUhP+o9dQ3AABAOZT6mAcAzFco7cWAPwL0CWcSH2/y/
td2gULF9EMD/Gu9rwiD2vwfntnv7IBHAF0XjvsZa7r9IFMBydZgRwJ5fYghk
JuC/KdXkmu3iEcB6d7qLIYusv+50j3il/xHAjwhYAyAz2T/f4qaWU+4RwDCZ
a4yX2+o/jKRzQiSvEcA0tHgedmz0Py1WThq5QhHAQOjAwOI2+z+IkzlwJ6oQ
wCYsL4LZ3QBAcmkRCevND8A4uWInHfUDQH6UUz8t9g3AnmYKXVTZBkAeRhgq
zNELwNHOiMMZgwlAYgbMd0JmCcDUa5N5nesLQGrUidrAuQbA773PiLYMDkCU
IKoyHtMDwGxgfKfy4A9A4l1AEMa5AMAXPWwT0rEQQL40jXBL6/q/qpNT9XZI
EUAYtwa8Lx70v+VlmaXmshFAyHoaEj076r+Eb0TkEPARQMGmNvcD7te/EoTT
ZA==
      "]]}}, 
   {RGBColor[0, 1, 0], PointSize[Large], PointBox[CompressedData["
1:eJw1hgsw2wccgI1iVOfRlpXi5t1WvO9iVH/UqOLqWW+zmbZDVaauJqOrjZ6x
2s5U0/WMpivWzqMETTx+6LIUY+IVFo8gJPL6pz2pOq623W7f3Xff915qduQF
dTU1NfjHf/sfSvj/Bkwat414BDiOlI80VzCBmpp3m5FEQM+Ej/Ve1hCwdJyn
zCsV4MFi3R7dmIDXdL4oOl8OmZdObHjJZiG8MFHL4bAMlJohueLmRTiUGHTS
Ll0CCX4PTW4ZrkBlTW1kdb4YmEcC06/UCOEC7bPFzJB1GH2Dg1Wb63B0pbLa
S7gKfo3JNA3DDSjX6tB3CF4GhZ7Od9FyCRh+zNF6qr0Anp+QQtnFMhjP965a
dOEB+7wp3X9SDimhxz9tt+BCiAV7O29aARqxB3u+GGCDxvIHS6OlBDRss8Om
zdqgPMvxHlVKgLtxCpu6XoPs0wJO0S4BFZfpm9uF/dhJc+Z1dRNAfcc2THVo
FJWHe4sGjxHQEuDB/L11CmM9TS1NghSgmRMVa0f/CwMZXMmrd+Uw/BNtX7u9
AHdypJBeKwVKU2mI2vQKvs17NOe+tAFCZxcTq8g1tHKOI3HnRVDK/Z7BoomQ
xn2mSqtZg8LyEmKLvoFPhv880GK3CpTNG6/uZ0qxu6Sue/e6AOo1LrY7KGSo
12Bj45rAh1BKbF6LnQL715KtcyjTMOz7gG9sROCkS9DM09oxmFgr6dvXTGDi
dGeWp8Eg2NTHnJG8JtDJgPaVfvBD6Bxhrmi/JNCNJH6fvNqEnfsbHLPvEnhH
r2tY3fU3VO/78Jm6UoG5oXsGQwnjmGI6oJG7JUfLVNZ176szGO84wTjVJsMX
XKW/X+Q8kucKm+jWUvQzc5JlbApQ3Mgvvhe2gXX9sr2YqlUUPfdInfES4Vi7
JclJfR0HbPha9RIhNlvMLzDJYkwjZbio0law9/kKNcpZguacMtmVj5Zw1mh8
6eWqFKO8jSuf1M+hbdlbXt4Rcnw0mFoQ+3gSlQ4BrjevKjDDJy46cWcYb/hy
fORnCCy7FX9Cu7MHWbLkgxF/EOiREe7vlfINRsrI+il7BH7pey7u/MVO2PPR
+7FKQGCacYH9gyUO/Cy1uuZLIXAuOJNSYj8B7ncFqqIWBT5OElYMucwC02r2
aGCdHBUZ5HjS7gLwbFhtpwNkOO+WC9m9y0A26okm7kvw21bb7EthQqBout0p
YIkxaEr75OWmdYht1T039MM6Fut+XZrNFQNDVW0S4y7E428OVG91SKCOQz1L
rl1G+5wGLVKMDIaXKji6PQt4LHz7lKhJDma9+9Noch6qrD7X6WIqoJ/eWvZi
mYsM2tkU4hoBSTvuvCMRHBz7Jd/311UCzEf7+HEBHfg3aMAd2w==
     "]], 
    {RGBColor[1, 1, 0], PointBox[CompressedData["
1:eJwlxQsw1AkcwPFlvR/Lei5rX/9F6iTtaqo77A9pu9E5NHnkRqU8dsuFi4w7
o+VaspJcuc1xDqdcQljMlG5/zFwxIUu6PeI8WtfDKptDU9xj+s5858OJPxWR
oE8ikQT//b8fIvCD+rCrbm/Bij4H86aaxuhOpuBRtV04qmDhK63G0VBnBZcT
5d3VNgzMDpo3rvS1hcDZwDcUd2fU944z0PvcAUJH0679sOKA5Yt8cqSHEyjS
vr12otgWiaCSr8N76CAPziJnTlthQE9jTqgtE/zkSTGySBPsXRtVe1mw4Qzr
6P3DJSRMjZwJvKFhQzSMG3TuXFLyim/wtN9x4GzbdT9C3KasKz7wcrc9AcOT
4l/vjWsFwxsVrcHJBEREVwo/ntgQiMZVTr7FBPAq4/Vs/Iyh5iR/U89ZAgw/
I17bqyggWdu2UxdMQFROXDjX3BbKncM6E55w4MvT6g7DHAewt06r3hzMAXGf
b1J8hxOMUXj9KGHDU/eb/e8bXeCKm87a34MFRRqfDIhhwW9eT4/tW3eBBmrp
/i0TbGhdrqJ4FjqD6aJCWT7FAaKnRsB76Ai8Zw/0QhUElFzP6Q7/ww4eFt4S
bz3EhcnSdiqjmQpZF6vaioe4IBdFJ8c1WoBLS8q2QGtXSKg7K9vaagiy8xuD
9UxX6G3PvU/6570g+5gzlr3lgs9gzchK7YJg5q/K8aQaLqD/EO6y/0m513O2
1siRCxYaVYd53aLyrmjBUhVLQGynlM9/t658oCWv1qdxYMmjiU/zNMJ2x8nI
J4fY0Kh1pU9zLDGwT/9itg8T0iFv+tI8Fakjl/veJtCh0j2KJqbYo7ozzPt4
OA1Ky2xiEkk0NKs/MFWxYQcYlGu2oXDGxiWJITOTCjvY+6qC3RiITnzxosQc
+vPi/UkhLPRKHcvYoyJDSm2vJqqUjeWFh8+NTqwK9ucunlKFcTA5sjT9iyN/
CioGpGKShoOK2dqvTuROK2dS5gdEIQQyE9cdRIFryi51Rq1xPoEGUoq0gGyA
aV5dDSEyAvOz5dt/aTNH92eb7rCPE2gtO6LLukDFLREHTV9aErg0R/2+y84e
7+ZddSg4z0F1UYmbWSINe4XWUqGajcJbRZuXs+j46Mpg6twqCxuMK4blwUw0
MYstTNcyMPV1bH5SPBuTfzzXcLqcjt0B0jmnLA56z2f/rVmj4eM95rsZRwnM
vDlmc4bugHqirlwGnYvNI8+NvjG0RYOPTr7x/5mLL3SfrrXlWKFLko2KeMdF
7/gF9ky1CTYLh35/wXTFElnvgE2+HrbM5Ug+sXLF0FcBt3Xpy8oL4kcLvgNc
TKVf3XGv6bGyzPJOZkUkFw1qvdPZB2cFt103yJIWAhtk2gHW81XBvynWxxo=

      "]]}}},
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 12}]], "Output",
 CellChangeTimes->{
  3.5848060119894543`*^9, 3.5848099237054815`*^9, {3.5848099681455436`*^9, 
   3.5848099794955597`*^9}, 3.5848101045557346`*^9, {3.584810152915802*^9, 
   3.584810187875851*^9}, {3.5848103051160154`*^9, 3.5848103267860456`*^9}, 
   3.584810362286095*^9, {3.584810452826222*^9, 3.5848104797262597`*^9}, 
   3.5848105254363236`*^9, 3.584810623666461*^9, 3.5848107171805944`*^9, 
   3.5848108832708273`*^9, {3.584811200321271*^9, 3.5848112257713065`*^9}, {
   3.584811414301571*^9, 3.5848114694916477`*^9}, {3.5848115007816916`*^9, 
   3.5848115178717155`*^9}, {3.5848115556917686`*^9, 3.5848116316818748`*^9}}],

Cell[BoxData["\<\"M and M^2\"\>"], "Print",
 CellChangeTimes->{
  3.584809923685481*^9, {3.5848099681255436`*^9, 3.584809979465559*^9}, 
   3.584810104535734*^9, {3.584810152895802*^9, 3.584810187855851*^9}, {
   3.584810305096015*^9, 3.5848103267460456`*^9}, 3.584810362266095*^9, {
   3.584810452766222*^9, 3.5848104796962595`*^9}, 3.5848105254063234`*^9, 
   3.5848106236364613`*^9, 3.584810717160595*^9, 3.584810883240827*^9, {
   3.584811200281271*^9, 3.5848112257313066`*^9}, {3.58481141427157*^9, 
   3.5848114694716477`*^9}, {3.584811500751692*^9, 3.5848115178517156`*^9}, {
   3.5848115556617684`*^9, 3.5848116316818748`*^9}}],

Cell[BoxData[
 GraphicsBox[{LineBox[{{-2., 0.5}, {1., 0.}}], 
   LineBox[{{-1.8901749139092234`, 0.6971689159326693}, {0.9950041652780258, 
    0.09983341664682815}}], 
   LineBox[{{-1.761463824887422, 0.8873719505107432}, {0.9800665778412416, 
    0.19866933079506122`}}], 
   LineBox[{{-1.6151527715898724`, 1.068708657885482}, {0.955336489125606, 
    0.2955202066613396}}], 
   LineBox[{{-1.4527036456971196`, 1.2393671816187437`}, {0.9210609940028851, 
    0.3894183423086505}}], 
   LineBox[{{-1.2757395851765425`, 1.3976423581535924`}, {0.8775825618903728, 
    0.479425538604203}}], 
   LineBox[{{-1.086028756424321, 1.54195275424491}, {0.8253356149096782, 
    0.5646424733950355}}], 
   LineBox[{{-0.8854666873312856, 1.6708564681176266`}, {0.7648421872844884, 
    0.6442176872376911}}], 
   LineBox[{{-0.676057327794808, 1.7830655364726282`}, {0.6967067093471654, 
    0.7173560908995228}}], 
   LineBox[{{-0.45989302691384537`, 1.877458803390299}, {0.6216099682706644, 
    0.7833269096274834}}], 
   LineBox[{{-0.2391336269283828, 1.953093122549863}, {0.5403023058681397, 
    0.8414709848078965}}], 
   LineBox[{{-0.015984882789719213`, 2.0092127808356595`}, {
    0.4535961214255773, 0.8912073600614354}}], 
   LineBox[{{0.2073235770138796, 2.0452570491727897`}, {0.3623577544766734, 
    0.9320390859672264}}], 
   LineBox[{{0.42856052816801826`, 2.0608657851466794`}, {
    0.26749882862458735`, 0.963558185417193}}], 
   LineBox[{{0.6455154441879787, 2.055883031427041}, {0.16996714290024081`, 
    0.9854497299884603}}], 
   LineBox[{{0.8560205832686486, 2.0303585740419603`}, {0.0707372016677029, 
    0.9974949866040544}}], 
   LineBox[{{1.0579726476440827`, 1.984547444932366}, {-0.029199522301288815`,
     0.9995736030415051}}], 
   LineBox[{{1.2493537990435182`, 
    1.9189073737571747`}, {-0.12884449429552486`, 0.9916648104524686}}], 
   LineBox[{{1.4282518202643693`, 1.8340942144098467`}, {-0.2272020946930871, 
    0.9738476308781951}}], 
   LineBox[{{1.5928792214144216`, 1.7309553919430771`}, {-0.3232895668635036, 
    0.9463000876874145}}], 
   LineBox[{{1.7415910999199666`, 1.6105214353777921`}, {-0.4161468365471424, 
    0.9092974268256817}}], 
   LineBox[{{1.872901575848589, 1.4739956809978185`}, {-0.5048461045998576, 
    0.8632093666488737}}], 
   LineBox[{{1.9854986383302817`, 1.3227422490115073`}, {-0.5885011172553458, 
    0.8084964038195901}}], 
   LineBox[{{2.0782572547363687`, 1.1582724137135278`}, {-0.6662760212798244, 
    0.74570521217672}}], 
   LineBox[{{2.150250611633642, 0.9822295033316784}, {-0.7373937155412458, 
    0.6754631805511506}}], 
   LineBox[{{2.200759375197824, 0.7963724804344463}, {-0.8011436155469337, 
    0.5984721441039565}}], 
   LineBox[{{2.229278878559359, 0.6025583669584547}, {-0.8568887533689473, 
    0.5155013718214642}}], 
   LineBox[{{2.235524164267952, 0.40272368945912895`}, {-0.9040721420170612, 
    0.4273798802338298}}], 
   LineBox[{{2.2194328314932212`, 0.19886512997748018`}, {-0.9422223406686583,
     0.33498815015590466`}}], 
   LineBox[{{
    2.181165659513163, -0.0069804241468313655`}, {-0.9709581651495907, 
    0.23924932921398198`}}], 
   LineBox[{{2.121105001260758, -0.21275623218048828`}, {-0.9899924966004454, 
    0.1411200080598672}}], 
   LineBox[{{
    2.0398509629798496`, -0.41640625027005873`}, {-0.9991351502732795, 
    0.04158066243329049}}], 
   LineBox[{{
    1.938215408161926, -0.6158956747525367}, {-0.9982947757947531, \
-0.058374143427580086`}}], 
   LineBox[{{
    1.817213845674481, -0.8092312732409297}, {-0.9874797699088649, \
-0.15774569414324865`}}], 
   LineBox[{{
    1.67805528313209, -0.9944813003433938}, {-0.9667981925794609, \
-0.25554110202683167`}}], 
   LineBox[{{
    1.5221301468919728`, -1.1697947990246378`}, {-0.9364566872907963, \
-0.35078322768961984`}}], 
   LineBox[{{
    1.3509963893734416`, -1.3334200947567785`}, {-0.896758416334147, \
-0.44252044329485246`}}], 
   LineBox[{{
    1.1663639225123226`, -1.4837222976721909`}, {-0.848100031710408, \
-0.5298361409084934}}], 
   LineBox[{{
    0.9700775328861138, -1.6191996378426468`}, {-0.7909677119144165, \
-0.6118578909427193}}], 
   LineBox[{{
    0.7640984492163057, -1.7384984704680182`}, {-0.7259323042001399, \
-0.6877661591839741}}], 
   LineBox[{{
    0.5504847464192957, -1.8404268010476623`}, {-0.6536436208636119, \
-0.7568024953079282}}], 
   LineBox[{{
    0.3313707820021262, -1.9239661953954559`}, {-0.5748239465332685, \
-0.8182771110644108}}], 
   LineBox[{{
    0.10894587026781066`, -1.9882819554975262`}, {-0.4902608213406994, \
-0.8715757724135882}}], 
   LineBox[{{-0.114567592589504, -2.0327314595388977`}, \
{-0.40079917207997545`, -0.9161659367494549}}], 
   LineBox[{{-0.3369363339326774, -2.056870582768242}, \
{-0.30733286997841935`, -0.9516020738895161}}], 
   LineBox[{{-0.5559385188035376, -2.0604581350455837`}, \
{-0.2107957994307797, -0.977530117665097}}], 
   LineBox[{{-0.7693859497633566, -2.043458270734456}, \
{-0.11215252693505398`, -0.9936910036334645}}], 
   LineBox[{{-0.9751459306383197, -2.006040846859647}, {-0.01238866346289056, \
-0.9999232575641008}}], 
   LineBox[{{-1.171162575714735, -1.9485797259519575`}, {
    0.08749898343944727, -0.9961646088358406}}], 
   LineBox[{{-1.355477351469484, -1.8716490405373771`}, {
    0.18651236942257576`, -0.9824526126243325}}], 
   LineBox[{{-1.526248645589591, -1.7760174565946638`}, {
    0.28366218546322625`, -0.9589242746631385}}], 
   LineBox[{{-1.6817701677536943`, -1.6626404932989738`}, {
    0.37797774271298107`, -0.9258146823277321}}], 
   LineBox[{{-1.8204879983209072`, -1.5326509757901177`}, {
    0.4685166713003771, -0.8834546557201531}}], 
   LineBox[{{-1.941016114582224, -1.3873477163582209`}, {
    0.5543743361791615, -0.8322674422239008}}], 
   LineBox[{{-2.0421502394412565`, -1.228182537140657}, {
    0.6346928759426347, -0.7727644875559871}}], 
   LineBox[{{-2.122879874152912, -1.0567457639951539`}, {
    0.70866977429126, -0.7055403255703919}}], 
   LineBox[{{-2.182398394892821, -0.8747503364895166}, {
    0.7755658785102502, -0.6312666378723208}}], 
   LineBox[{{-2.220111112275957, -0.6840146927756953}, {
    0.8347127848391598, -0.5506855425976376}}], 
   LineBox[{{-2.2356412132963954`, -0.4864446003568535}, {
    0.8855195169413194, -0.4646021794137566}}], 
   LineBox[{{-2.228833526318308, -0.2840141142884541}, {
    0.9274784307440359, -0.373876664830236}}], 
   LineBox[{{-2.1997560714996576`, -0.07874585307266874}, {
    0.960170286650366, -0.27941549819892586`}}], 
   LineBox[{{-2.1486993811572646`, 0.12730921067710232`}, {
    0.9832684384425847, -0.18216250427209502`}}], 
   LineBox[{{-2.0761735968639314`, 0.332092242876616}, {
    0.9965420970232175, -0.0830894028174964}}], 
   {RGBColor[0, 1, 0], PointSize[Large], PointBox[CompressedData["
1:eJw1hgsw2wccgI1iVOfRlpXi5t1WvO9iVH/UqOLqWW+zmbZDVaauJqOrjZ6x
2s5U0/WMpivWzqMETTx+6LIUY+IVFo8gJPL6pz2pOq623W7f3Xff915qduQF
dTU1NfjHf/sfSvj/Bkwat414BDiOlI80VzCBmpp3m5FEQM+Ej/Ve1hCwdJyn
zCsV4MFi3R7dmIDXdL4oOl8OmZdObHjJZiG8MFHL4bAMlJohueLmRTiUGHTS
Ll0CCX4PTW4ZrkBlTW1kdb4YmEcC06/UCOEC7bPFzJB1GH2Dg1Wb63B0pbLa
S7gKfo3JNA3DDSjX6tB3CF4GhZ7Od9FyCRh+zNF6qr0Anp+QQtnFMhjP965a
dOEB+7wp3X9SDimhxz9tt+BCiAV7O29aARqxB3u+GGCDxvIHS6OlBDRss8Om
zdqgPMvxHlVKgLtxCpu6XoPs0wJO0S4BFZfpm9uF/dhJc+Z1dRNAfcc2THVo
FJWHe4sGjxHQEuDB/L11CmM9TS1NghSgmRMVa0f/CwMZXMmrd+Uw/BNtX7u9
AHdypJBeKwVKU2mI2vQKvs17NOe+tAFCZxcTq8g1tHKOI3HnRVDK/Z7BoomQ
xn2mSqtZg8LyEmKLvoFPhv880GK3CpTNG6/uZ0qxu6Sue/e6AOo1LrY7KGSo
12Bj45rAh1BKbF6LnQL715KtcyjTMOz7gG9sROCkS9DM09oxmFgr6dvXTGDi
dGeWp8Eg2NTHnJG8JtDJgPaVfvBD6Bxhrmi/JNCNJH6fvNqEnfsbHLPvEnhH
r2tY3fU3VO/78Jm6UoG5oXsGQwnjmGI6oJG7JUfLVNZ176szGO84wTjVJsMX
XKW/X+Q8kucKm+jWUvQzc5JlbApQ3Mgvvhe2gXX9sr2YqlUUPfdInfES4Vi7
JclJfR0HbPha9RIhNlvMLzDJYkwjZbio0law9/kKNcpZguacMtmVj5Zw1mh8
6eWqFKO8jSuf1M+hbdlbXt4Rcnw0mFoQ+3gSlQ4BrjevKjDDJy46cWcYb/hy
fORnCCy7FX9Cu7MHWbLkgxF/EOiREe7vlfINRsrI+il7BH7pey7u/MVO2PPR
+7FKQGCacYH9gyUO/Cy1uuZLIXAuOJNSYj8B7ncFqqIWBT5OElYMucwC02r2
aGCdHBUZ5HjS7gLwbFhtpwNkOO+WC9m9y0A26okm7kvw21bb7EthQqBout0p
YIkxaEr75OWmdYht1T039MM6Fut+XZrNFQNDVW0S4y7E428OVG91SKCOQz1L
rl1G+5wGLVKMDIaXKji6PQt4LHz7lKhJDma9+9Noch6qrD7X6WIqoJ/eWvZi
mYsM2tkU4hoBSTvuvCMRHBz7Jd/311UCzEf7+HEBHfg3aMAd2w==
     "]], 
    {RGBColor[1, 0, 0], PointBox[CompressedData["
1:eJwBAQT++yFib1JlAgAAAD8AAAACAAAAAAAAAAAAAMAAAAAAAADgPw5b7wwo
Pv6/rP62LzVP5j8iqA+x9C78v5uaWtxZZew/LVvAbqrX+b+IH+k/bhnxPx3J
kC1GPve/dJyMrnLU8z/Uu0jpbWn0v0xivDu+XPY/Z7p1sF9g8b8fWLem1qv4
P2sh+Tu+Vey/HgHu/dO7+j/9MSP6QqLlv+ZkXLpvh/w/7jeQKeNu3b/IYAI+
Egr+P6AAhEHum86/kU72kt4//z8guz9TV16Qv60ngybeEgBA1G97N5SJyj+A
4lC6r1wAQNijNSOJbds/6zNlM6d8AECCNTsBEKjkPzoLg81ycgBAIe86R4Vk
6z+sTtWiLD4AQBQaG7p07fA/mYRV0rTA/z9+Z8BoWv3zP+1x5TfYs/4/ls6n
lB7a9j8Ixcosc1j9PwM/J+xufPk/oa/zR/6x+z8mkxKhjt37PwVG5x+yxPk/
SFiOpGf3/T9IS8V+fJX3P/QYXjiaxP8/rKvIxvMp9T+6I+5WRaAAQCkjjKdI
iPI/Kl25l7YzAUBsOj+RbG7vP2u4NrsnmwFApM/cI+J76T+nmygqkNUBQD6R
AHwoSOM/tJY3flriAUBySuOUOcbZP950FwBmwQFAaLbInml0yT9yIzb7BnMB
QMD9w1aBl3y/P2Ae5gX4AEDuIJ6hmDvLv1OztWGdUQBAGKKwZmam2r9Miuoo
7gL/P4HrmdhqteO/IypQ004T/T8mDK/7OOXpv+XqHn9Q2fo/dauucsrS77/X
gRIkpVr4P6d3TcB6t/K/3ffVY66d9T8P9CxPsFX1v5bLZjdtqfI/j5GNl1O9
978wkcoJ4ArvP9qqI+E96Pm/AN5Jl35z6D8I5qzF49D7v9Qq2i+SneE/3ueS
X2Ny/b8WJOPLLTXVPxZU/caQyP6/KKLVZeDjuz+8a2G9AND/v5B2Wj9NVL2/
yCgitghDAMCMzMRpXZDVv6PAaJB4dADAyyGbkz/K4b8rYoZ50XsAwFiJh0jP
nui/k1xcpgBZAMAAaR09ZTTvv16evSRfDADAD+cP+BS98r/7y0nvYS3/v2t7
8AQJsPW/PiqrQ0by/b8G8iWzg2v4v9gv00eRavy/sj/e1Yfo+r8kl/vqLJr6
v+LH+AW4IP2/eTeTB72F+L/4O9LpZg7/v4AF34STMva/ollf3VJWAMBNmWi7
oqbzvzqWhnGo+wDARbsIP27o8L+vQidKjXUBwCZm7Gr0/eu//bBlncnCAcAr
kO7HcuPlvw2VRdyX4gHAbU12iOgh37+4H/6rptQBwA0qHolJLdK/0iUSthmZ
AcAsiqQvsCi0vxAMGE2JMAHAsDorEKtLwD9QyxrnAJwAwEBDmtL/QNU/bfUJ
Yw==
      "]]}}, LineBox[{{4.5, 0.}, {1., 0.}}], 
   LineBox[{{4.477518743751117, 0.4492503749107267}, {0.9950041652780258, 
    0.09983341664682815}}], 
   LineBox[{{4.410299600285588, 0.8940119885777755}, {0.9800665778412416, 
    0.19866933079506122`}}], 
   LineBox[{{4.299014201065227, 1.329840929976028}, {0.955336489125606, 
    0.2955202066613396}}], 
   LineBox[{{4.144774473012983, 1.7523825403889273`}, {0.9210609940028851, 
    0.3894183423086505}}], 
   LineBox[{{3.9491215285066774`, 2.1574149237189135`}, {0.8775825618903728, 
    0.479425538604203}}], 
   LineBox[{{3.7140102670935518`, 2.5408911302776596`}, {0.8253356149096782, 
    0.5646424733950355}}], 
   LineBox[{{3.4417898427801976`, 2.89897959256961}, {0.7648421872844884, 
    0.6442176872376911}}], 
   LineBox[{{3.1351801920622444`, 3.2281024090478527`}, {0.6967067093471654, 
    0.7173560908995228}}], 
   LineBox[{{2.79724485721799, 3.5249710933236753`}, {0.6216099682706644, 
    0.7833269096274834}}], 
   LineBox[{{2.4313603764066283`, 3.7866194316355344`}, {0.5403023058681397, 
    0.8414709848078965}}], 
   LineBox[{{2.041182546415098, 4.01043312027646}, {0.4535961214255773, 
    0.8912073600614354}}], 
   LineBox[{{1.6306098951450303`, 4.194175886852519}, {0.3623577544766734, 
    0.9320390859672264}}], 
   LineBox[{{1.203744728810643, 4.336011834377368}, {0.26749882862458735`, 
    0.963558185417193}}], 
   LineBox[{{0.7648521430510836, 4.434523784948071}, {0.16996714290024081`, 
    0.9854497299884603}}], 
   LineBox[{{0.3183174075046631, 4.488727439718245}, {0.0707372016677029, 
    0.9974949866040544}}], 
   LineBox[{{-0.13139785035579968`, 
    4.498081213686773}, {-0.029199522301288815`, 0.9995736030415051}}], 
   LineBox[{{-0.5798002243298619, 4.462491647036108}, {-0.12884449429552486`, 
    0.9916648104524686}}], 
   LineBox[{{-1.022409426118892, 4.382314338951878}, {-0.2272020946930871, 
    0.9738476308781951}}], 
   LineBox[{{-1.4548030508857661`, 4.258350394593365}, {-0.3232895668635036, 
    0.9463000876874145}}], 
   LineBox[{{-1.872660764462141, 4.091838420715567}, {-0.4161468365471424, 
    0.9092974268256817}}], 
   LineBox[{{-2.271807470699359, 3.8844421499199315`}, {-0.5048461045998576, 
    0.8632093666488737}}], 
   LineBox[{{-2.648255027649056, 3.6382338171881554`}, {-0.5885011172553458, 
    0.8084964038195901}}], 
   LineBox[{{-2.9982420957592097`, 3.35567345479524}, {-0.6662760212798244, 
    0.74570521217672}}], 
   LineBox[{{-3.318271719935606, 3.039584312480178}, {-0.7373937155412458, 
    0.6754631805511506}}], 
   LineBox[{{-3.605146269961202, 2.6931246484678044`}, {-0.8011436155469337, 
    0.5984721441039565}}], 
   LineBox[{{-3.855999390160263, 2.3197561731965886`}, {-0.8568887533689473, 
    0.5155013718214642}}], 
   LineBox[{{-4.068324639076775, 1.9232094610522341`}, {-0.9040721420170612, 
    0.4273798802338298}}], 
   LineBox[{{-4.2400005330089625`, 1.507446675701571}, {-0.9422223406686583, 
    0.33498815015590466`}}], 
   LineBox[{{-4.369311743173158, 1.076621981462919}, {-0.9709581651495907, 
    0.23924932921398198`}}], 
   LineBox[{{-4.454966234702004, 0.6350400362694024}, {-0.9899924966004454, 
    0.1411200080598672}}], 
   LineBox[{{-4.4961081762297574`, 
    0.18711298094980722`}, {-0.9991351502732795, 0.04158066243329049}}], 
   LineBox[{{-4.492326491076389, -0.2626836454241104}, {-0.9982947757947531, \
-0.058374143427580086`}}], 
   LineBox[{{-4.443658964589892, -0.709855623644619}, {-0.9874797699088649, \
-0.15774569414324865`}}], 
   LineBox[{{-4.350591866607574, -1.1499349591207424`}, {-0.9667981925794609, \
-0.25554110202683167`}}], 
   LineBox[{{-4.214055092808583, -1.5785245246032893`}, {-0.9364566872907963, \
-0.35078322768961984`}}], 
   LineBox[{{-4.035412873503661, -1.991341994826836}, {-0.896758416334147, \
-0.44252044329485246`}}], 
   LineBox[{{-3.8164501426968362`, -2.3842626340882203`}, \
{-0.848100031710408, -0.5298361409084934}}], 
   LineBox[{{-3.5593547036148743`, -2.7533605092422366`}, \
{-0.7909677119144165, -0.6118578909427193}}], 
   LineBox[{{-3.2666953689006295`, -3.0949477163278836`}, \
{-0.7259323042001399, -0.6877661591839741}}], 
   LineBox[{{-2.9413962938862537`, -3.405611228885677}, {-0.6536436208636119, \
-0.7568024953079282}}], 
   LineBox[{{-2.586707759399708, -3.682246999789849}, {-0.5748239465332685, \
-0.8182771110644108}}], 
   LineBox[{{-2.2061736960331473`, -3.922090975861147}, {-0.4902608213406994, \
-0.8715757724135882}}], 
   LineBox[{{-1.8035962743598895`, -4.122746715372547}, \
{-0.40079917207997545`, -0.9161659367494549}}], 
   LineBox[{{-1.382997914902887, -4.2822093325028225`}, \
{-0.30733286997841935`, -0.9516020738895161}}], 
   LineBox[{{-0.9485810974385086, -4.3988855294929365`}, \
{-0.2107957994307797, -0.977530117665097}}], 
   LineBox[{{-0.504686371207743, -4.471609516350591}, {-0.11215252693505398`, \
-0.9936910036334645}}], 
   LineBox[{{-0.05574898558300752, -4.499654659038454}, \
{-0.01238866346289056, -0.9999232575641008}}], 
   LineBox[{{0.39374542547751273`, -4.482740739761282}, {
    0.08749898343944727, -0.9961646088358406}}], 
   LineBox[{{0.8393056624015909, -4.421036756809496}, {
    0.18651236942257576`, -0.9824526126243325}}], 
   LineBox[{{1.276479834584518, -4.315159235984123}, {
    0.28366218546322625`, -0.9589242746631385}}], 
   LineBox[{{1.7008998422084147`, -4.1661660704747945`}, {
    0.37797774271298107`, -0.9258146823277321}}], 
   LineBox[{{2.108325020851697, -3.975545950740689}, {
    0.4685166713003771, -0.8834546557201531}}], 
   LineBox[{{2.494684512806227, -3.7452034900075537`}, {
    0.5543743361791615, -0.8322674422239008}}], 
   LineBox[{{2.8561179417418563`, -3.477440194001942}, {
    0.6346928759426347, -0.7727644875559871}}], 
   LineBox[{{3.18901398431067, -3.1749314650667637`}, {
    0.70866977429126, -0.7055403255703919}}], 
   LineBox[{{3.4900464532961255`, -2.8406998704254436`}, {
    0.7755658785102502, -0.6312666378723208}}], 
   LineBox[{{3.756207531776219, -2.478084941689369}, {
    0.8347127848391598, -0.5506855425976376}}], 
   LineBox[{{3.984837826235937, -2.090709807361905}, {
    0.8855195169413194, -0.4646021794137566}}], 
   LineBox[{{4.1736529383481615`, -1.682444991736062}, {
    0.9274784307440359, -0.373876664830236}}], 
   LineBox[{{4.320766289926647, -1.2573697418951664`}, {
    0.960170286650366, -0.27941549819892586`}}], 
   LineBox[{{4.424707972991631, -0.8197312692244276}, {
    0.9832684384425847, -0.18216250427209502`}}], 
   LineBox[{{4.484439436604479, -0.3739023126787338}, {
    0.9965420970232175, -0.0830894028174964}}], 
   {RGBColor[0, 1, 0], PointSize[Large], PointBox[CompressedData["
1:eJw1hgsw2wccgI1iVOfRlpXi5t1WvO9iVH/UqOLqWW+zmbZDVaauJqOrjZ6x
2s5U0/WMpivWzqMETTx+6LIUY+IVFo8gJPL6pz2pOq623W7f3Xff915qduQF
dTU1NfjHf/sfSvj/Bkwat414BDiOlI80VzCBmpp3m5FEQM+Ej/Ve1hCwdJyn
zCsV4MFi3R7dmIDXdL4oOl8OmZdObHjJZiG8MFHL4bAMlJohueLmRTiUGHTS
Ll0CCX4PTW4ZrkBlTW1kdb4YmEcC06/UCOEC7bPFzJB1GH2Dg1Wb63B0pbLa
S7gKfo3JNA3DDSjX6tB3CF4GhZ7Od9FyCRh+zNF6qr0Anp+QQtnFMhjP965a
dOEB+7wp3X9SDimhxz9tt+BCiAV7O29aARqxB3u+GGCDxvIHS6OlBDRss8Om
zdqgPMvxHlVKgLtxCpu6XoPs0wJO0S4BFZfpm9uF/dhJc+Z1dRNAfcc2THVo
FJWHe4sGjxHQEuDB/L11CmM9TS1NghSgmRMVa0f/CwMZXMmrd+Uw/BNtX7u9
AHdypJBeKwVKU2mI2vQKvs17NOe+tAFCZxcTq8g1tHKOI3HnRVDK/Z7BoomQ
xn2mSqtZg8LyEmKLvoFPhv880GK3CpTNG6/uZ0qxu6Sue/e6AOo1LrY7KGSo
12Bj45rAh1BKbF6LnQL715KtcyjTMOz7gG9sROCkS9DM09oxmFgr6dvXTGDi
dGeWp8Eg2NTHnJG8JtDJgPaVfvBD6Bxhrmi/JNCNJH6fvNqEnfsbHLPvEnhH
r2tY3fU3VO/78Jm6UoG5oXsGQwnjmGI6oJG7JUfLVNZ176szGO84wTjVJsMX
XKW/X+Q8kucKm+jWUvQzc5JlbApQ3Mgvvhe2gXX9sr2YqlUUPfdInfES4Vi7
JclJfR0HbPha9RIhNlvMLzDJYkwjZbio0law9/kKNcpZguacMtmVj5Zw1mh8
6eWqFKO8jSuf1M+hbdlbXt4Rcnw0mFoQ+3gSlQ4BrjevKjDDJy46cWcYb/hy
fORnCCy7FX9Cu7MHWbLkgxF/EOiREe7vlfINRsrI+il7BH7pey7u/MVO2PPR
+7FKQGCacYH9gyUO/Cy1uuZLIXAuOJNSYj8B7ncFqqIWBT5OElYMucwC02r2
aGCdHBUZ5HjS7gLwbFhtpwNkOO+WC9m9y0A26okm7kvw21bb7EthQqBout0p
YIkxaEr75OWmdYht1T039MM6Fut+XZrNFQNDVW0S4y7E428OVG91SKCOQz1L
rl1G+5wGLVKMDIaXKji6PQt4LHz7lKhJDma9+9Noch6qrD7X6WIqoJ/eWvZi
mYsM2tkU4hoBSTvuvCMRHBz7Jd/311UCzEf7+HEBHfg3aMAd2w==
     "]], 
    {RGBColor[1, 0.5, 0], PointBox[CompressedData["
1:eJwBAQT++yFib1JlAgAAAD8AAAACAAAAAAAAAAAAEkAAAAAAAAAAAF2Nbqz6
6BFAkkT9pITA3D9lJxOUJaQRQBSNpQe/m+w/eXVaxzAyEUB6EXJIB0f1P6yL
a8I/lBBAWNRQRsIJ/D/67CYHzZcPQFczasFiQgFAdmbRA0u2DUCF6Zm6vlME
QESR8xzJiAtA8NxuNhwxB0Byyz9a2RQJQKf+F1sn0wlAYD5l6cFgBkBJXWkL
JDMMQFynqxFtcwNAjC7qIP9KDkCaJtCDV1QAQNCH2fquChBACunCZvoW+j8/
0C4L1sYQQOuVL9WJQvM/CuF+fBNYEUDjwZUzq3noP5K+ls3zvBFA3Li++U9f
1D+e/Uj3dPQRQH18BQ+l0cC/jyVuAAn+EUAgujYzuY3iv+bFCmmX2RFAJdiE
/Mlb8L9XXPpofYcRQGXOWpDfRve/sb9+AY0IEUBG4D0ia/b9v2f1FeQKXhBA
o7IrZaksAsBa4ehnVhMPQB7D+VSgLwXA6THgVBobDUDgNRZaZvwHwAY1A1Nr
2ApAuesiC9KLCsDLS3yUEVEIQO08du1W1wzAB8SJ74SLBUD+ElE1FtkOwHKW
FFPcjgJADWLp5PZFEMDuO6lId8X+PysvIbPC9RDAeKLJZ4Ae+D9y1IvbLHoR
wHebiPjXOfE/RlErq+LREcAGsG17P1LkP3S9IMgD/BHANBLrclHzxz+Wgohv
JPgRwGyZkhDPz9C/lvYdiU7GEcAq7g0kI7fmv+FK5Y0BZxHAAjYfMyJm8r/V
nhxCMdsQwGOuke6iQfm/8ji2RUMkEMAv7G5sidz/v16ULQMXiA7Aqd6zSfgS
A8AFHnf1jnkMwLRY6t/hBgbABGJ7LjEiCsBIqsPyc8IIwFmJtsf6hwfAhKKX
GbE+C8AQc3fWk7EEwNUhP+o9dQ3AABAOZT6mAcAzFco7cWAPwL0CWcSH2/y/
td2gULF9EMD/Gu9rwiD2vwfntnv7IBHAF0XjvsZa7r9IFMBydZgRwJ5fYghk
JuC/KdXkmu3iEcB6d7qLIYusv+50j3il/xHAjwhYAyAz2T/f4qaWU+4RwDCZ
a4yX2+o/jKRzQiSvEcA0tHgedmz0Py1WThq5QhHAQOjAwOI2+z+IkzlwJ6oQ
wCYsL4LZ3QBAcmkRCevND8A4uWInHfUDQH6UUz8t9g3AnmYKXVTZBkAeRhgq
zNELwNHOiMMZgwlAYgbMd0JmCcDUa5N5nesLQGrUidrAuQbA773PiLYMDkCU
IKoyHtMDwGxgfKfy4A9A4l1AEMa5AMAXPWwT0rEQQL40jXBL6/q/qpNT9XZI
EUAYtwa8Lx70v+VlmaXmshFAyHoaEj076r+Eb0TkEPARQMGmNvcD7te/EoTT
ZA==
      "]]}}},
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 12}]], "Output",
 CellChangeTimes->{
  3.5848060119894543`*^9, 3.5848099237054815`*^9, {3.5848099681455436`*^9, 
   3.5848099794955597`*^9}, 3.5848101045557346`*^9, {3.584810152915802*^9, 
   3.584810187875851*^9}, {3.5848103051160154`*^9, 3.5848103267860456`*^9}, 
   3.584810362286095*^9, {3.584810452826222*^9, 3.5848104797262597`*^9}, 
   3.5848105254363236`*^9, 3.584810623666461*^9, 3.5848107171805944`*^9, 
   3.5848108832708273`*^9, {3.584811200321271*^9, 3.5848112257713065`*^9}, {
   3.584811414301571*^9, 3.5848114694916477`*^9}, {3.5848115007816916`*^9, 
   3.5848115178717155`*^9}, {3.5848115556917686`*^9, 3.5848116317018747`*^9}}],

Cell[BoxData["\<\"M^2 and M^3\"\>"], "Print",
 CellChangeTimes->{
  3.584809923685481*^9, {3.5848099681255436`*^9, 3.584809979465559*^9}, 
   3.584810104535734*^9, {3.584810152895802*^9, 3.584810187855851*^9}, {
   3.584810305096015*^9, 3.5848103267460456`*^9}, 3.584810362266095*^9, {
   3.584810452766222*^9, 3.5848104796962595`*^9}, 3.5848105254063234`*^9, 
   3.5848106236364613`*^9, 3.584810717160595*^9, 3.584810883240827*^9, {
   3.584811200281271*^9, 3.5848112257313066`*^9}, {3.58481141427157*^9, 
   3.5848114694716477`*^9}, {3.584811500751692*^9, 3.5848115178517156`*^9}, {
   3.5848115556617684`*^9, 3.5848116317018747`*^9}}],

Cell[BoxData[
 GraphicsBox[{LineBox[{{4.5, 0.}, {1., 0.}}], 
   LineBox[{{4.477518743751117, 0.4492503749107267}, {0.9950041652780258, 
    0.09983341664682815}}], 
   LineBox[{{4.410299600285588, 0.8940119885777755}, {0.9800665778412416, 
    0.19866933079506122`}}], 
   LineBox[{{4.299014201065227, 1.329840929976028}, {0.955336489125606, 
    0.2955202066613396}}], 
   LineBox[{{4.144774473012983, 1.7523825403889273`}, {0.9210609940028851, 
    0.3894183423086505}}], 
   LineBox[{{3.9491215285066774`, 2.1574149237189135`}, {0.8775825618903728, 
    0.479425538604203}}], 
   LineBox[{{3.7140102670935518`, 2.5408911302776596`}, {0.8253356149096782, 
    0.5646424733950355}}], 
   LineBox[{{3.4417898427801976`, 2.89897959256961}, {0.7648421872844884, 
    0.6442176872376911}}], 
   LineBox[{{3.1351801920622444`, 3.2281024090478527`}, {0.6967067093471654, 
    0.7173560908995228}}], 
   LineBox[{{2.79724485721799, 3.5249710933236753`}, {0.6216099682706644, 
    0.7833269096274834}}], 
   LineBox[{{2.4313603764066283`, 3.7866194316355344`}, {0.5403023058681397, 
    0.8414709848078965}}], 
   LineBox[{{2.041182546415098, 4.01043312027646}, {0.4535961214255773, 
    0.8912073600614354}}], 
   LineBox[{{1.6306098951450303`, 4.194175886852519}, {0.3623577544766734, 
    0.9320390859672264}}], 
   LineBox[{{1.203744728810643, 4.336011834377368}, {0.26749882862458735`, 
    0.963558185417193}}], 
   LineBox[{{0.7648521430510836, 4.434523784948071}, {0.16996714290024081`, 
    0.9854497299884603}}], 
   LineBox[{{0.3183174075046631, 4.488727439718245}, {0.0707372016677029, 
    0.9974949866040544}}], 
   LineBox[{{-0.13139785035579968`, 
    4.498081213686773}, {-0.029199522301288815`, 0.9995736030415051}}], 
   LineBox[{{-0.5798002243298619, 4.462491647036108}, {-0.12884449429552486`, 
    0.9916648104524686}}], 
   LineBox[{{-1.022409426118892, 4.382314338951878}, {-0.2272020946930871, 
    0.9738476308781951}}], 
   LineBox[{{-1.4548030508857661`, 4.258350394593365}, {-0.3232895668635036, 
    0.9463000876874145}}], 
   LineBox[{{-1.872660764462141, 4.091838420715567}, {-0.4161468365471424, 
    0.9092974268256817}}], 
   LineBox[{{-2.271807470699359, 3.8844421499199315`}, {-0.5048461045998576, 
    0.8632093666488737}}], 
   LineBox[{{-2.648255027649056, 3.6382338171881554`}, {-0.5885011172553458, 
    0.8084964038195901}}], 
   LineBox[{{-2.9982420957592097`, 3.35567345479524}, {-0.6662760212798244, 
    0.74570521217672}}], 
   LineBox[{{-3.318271719935606, 3.039584312480178}, {-0.7373937155412458, 
    0.6754631805511506}}], 
   LineBox[{{-3.605146269961202, 2.6931246484678044`}, {-0.8011436155469337, 
    0.5984721441039565}}], 
   LineBox[{{-3.855999390160263, 2.3197561731965886`}, {-0.8568887533689473, 
    0.5155013718214642}}], 
   LineBox[{{-4.068324639076775, 1.9232094610522341`}, {-0.9040721420170612, 
    0.4273798802338298}}], 
   LineBox[{{-4.2400005330089625`, 1.507446675701571}, {-0.9422223406686583, 
    0.33498815015590466`}}], 
   LineBox[{{-4.369311743173158, 1.076621981462919}, {-0.9709581651495907, 
    0.23924932921398198`}}], 
   LineBox[{{-4.454966234702004, 0.6350400362694024}, {-0.9899924966004454, 
    0.1411200080598672}}], 
   LineBox[{{-4.4961081762297574`, 
    0.18711298094980722`}, {-0.9991351502732795, 0.04158066243329049}}], 
   LineBox[{{-4.492326491076389, -0.2626836454241104}, {-0.9982947757947531, \
-0.058374143427580086`}}], 
   LineBox[{{-4.443658964589892, -0.709855623644619}, {-0.9874797699088649, \
-0.15774569414324865`}}], 
   LineBox[{{-4.350591866607574, -1.1499349591207424`}, {-0.9667981925794609, \
-0.25554110202683167`}}], 
   LineBox[{{-4.214055092808583, -1.5785245246032893`}, {-0.9364566872907963, \
-0.35078322768961984`}}], 
   LineBox[{{-4.035412873503661, -1.991341994826836}, {-0.896758416334147, \
-0.44252044329485246`}}], 
   LineBox[{{-3.8164501426968362`, -2.3842626340882203`}, \
{-0.848100031710408, -0.5298361409084934}}], 
   LineBox[{{-3.5593547036148743`, -2.7533605092422366`}, \
{-0.7909677119144165, -0.6118578909427193}}], 
   LineBox[{{-3.2666953689006295`, -3.0949477163278836`}, \
{-0.7259323042001399, -0.6877661591839741}}], 
   LineBox[{{-2.9413962938862537`, -3.405611228885677}, {-0.6536436208636119, \
-0.7568024953079282}}], 
   LineBox[{{-2.586707759399708, -3.682246999789849}, {-0.5748239465332685, \
-0.8182771110644108}}], 
   LineBox[{{-2.2061736960331473`, -3.922090975861147}, {-0.4902608213406994, \
-0.8715757724135882}}], 
   LineBox[{{-1.8035962743598895`, -4.122746715372547}, \
{-0.40079917207997545`, -0.9161659367494549}}], 
   LineBox[{{-1.382997914902887, -4.2822093325028225`}, \
{-0.30733286997841935`, -0.9516020738895161}}], 
   LineBox[{{-0.9485810974385086, -4.3988855294929365`}, \
{-0.2107957994307797, -0.977530117665097}}], 
   LineBox[{{-0.504686371207743, -4.471609516350591}, {-0.11215252693505398`, \
-0.9936910036334645}}], 
   LineBox[{{-0.05574898558300752, -4.499654659038454}, \
{-0.01238866346289056, -0.9999232575641008}}], 
   LineBox[{{0.39374542547751273`, -4.482740739761282}, {
    0.08749898343944727, -0.9961646088358406}}], 
   LineBox[{{0.8393056624015909, -4.421036756809496}, {
    0.18651236942257576`, -0.9824526126243325}}], 
   LineBox[{{1.276479834584518, -4.315159235984123}, {
    0.28366218546322625`, -0.9589242746631385}}], 
   LineBox[{{1.7008998422084147`, -4.1661660704747945`}, {
    0.37797774271298107`, -0.9258146823277321}}], 
   LineBox[{{2.108325020851697, -3.975545950740689}, {
    0.4685166713003771, -0.8834546557201531}}], 
   LineBox[{{2.494684512806227, -3.7452034900075537`}, {
    0.5543743361791615, -0.8322674422239008}}], 
   LineBox[{{2.8561179417418563`, -3.477440194001942}, {
    0.6346928759426347, -0.7727644875559871}}], 
   LineBox[{{3.18901398431067, -3.1749314650667637`}, {
    0.70866977429126, -0.7055403255703919}}], 
   LineBox[{{3.4900464532961255`, -2.8406998704254436`}, {
    0.7755658785102502, -0.6312666378723208}}], 
   LineBox[{{3.756207531776219, -2.478084941689369}, {
    0.8347127848391598, -0.5506855425976376}}], 
   LineBox[{{3.984837826235937, -2.090709807361905}, {
    0.8855195169413194, -0.4646021794137566}}], 
   LineBox[{{4.1736529383481615`, -1.682444991736062}, {
    0.9274784307440359, -0.373876664830236}}], 
   LineBox[{{4.320766289926647, -1.2573697418951664`}, {
    0.960170286650366, -0.27941549819892586`}}], 
   LineBox[{{4.424707972991631, -0.8197312692244276}, {
    0.9832684384425847, -0.18216250427209502`}}], 
   LineBox[{{4.484439436604479, -0.3739023126787338}, {
    0.9965420970232175, -0.0830894028174964}}], 
   {RGBColor[0, 1, 0], PointSize[Large], PointBox[CompressedData["
1:eJw1hgsw2wccgI1iVOfRlpXi5t1WvO9iVH/UqOLqWW+zmbZDVaauJqOrjZ6x
2s5U0/WMpivWzqMETTx+6LIUY+IVFo8gJPL6pz2pOq623W7f3Xff915qduQF
dTU1NfjHf/sfSvj/Bkwat414BDiOlI80VzCBmpp3m5FEQM+Ej/Ve1hCwdJyn
zCsV4MFi3R7dmIDXdL4oOl8OmZdObHjJZiG8MFHL4bAMlJohueLmRTiUGHTS
Ll0CCX4PTW4ZrkBlTW1kdb4YmEcC06/UCOEC7bPFzJB1GH2Dg1Wb63B0pbLa
S7gKfo3JNA3DDSjX6tB3CF4GhZ7Od9FyCRh+zNF6qr0Anp+QQtnFMhjP965a
dOEB+7wp3X9SDimhxz9tt+BCiAV7O29aARqxB3u+GGCDxvIHS6OlBDRss8Om
zdqgPMvxHlVKgLtxCpu6XoPs0wJO0S4BFZfpm9uF/dhJc+Z1dRNAfcc2THVo
FJWHe4sGjxHQEuDB/L11CmM9TS1NghSgmRMVa0f/CwMZXMmrd+Uw/BNtX7u9
AHdypJBeKwVKU2mI2vQKvs17NOe+tAFCZxcTq8g1tHKOI3HnRVDK/Z7BoomQ
xn2mSqtZg8LyEmKLvoFPhv880GK3CpTNG6/uZ0qxu6Sue/e6AOo1LrY7KGSo
12Bj45rAh1BKbF6LnQL715KtcyjTMOz7gG9sROCkS9DM09oxmFgr6dvXTGDi
dGeWp8Eg2NTHnJG8JtDJgPaVfvBD6Bxhrmi/JNCNJH6fvNqEnfsbHLPvEnhH
r2tY3fU3VO/78Jm6UoG5oXsGQwnjmGI6oJG7JUfLVNZ176szGO84wTjVJsMX
XKW/X+Q8kucKm+jWUvQzc5JlbApQ3Mgvvhe2gXX9sr2YqlUUPfdInfES4Vi7
JclJfR0HbPha9RIhNlvMLzDJYkwjZbio0law9/kKNcpZguacMtmVj5Zw1mh8
6eWqFKO8jSuf1M+hbdlbXt4Rcnw0mFoQ+3gSlQ4BrjevKjDDJy46cWcYb/hy
fORnCCy7FX9Cu7MHWbLkgxF/EOiREe7vlfINRsrI+il7BH7pey7u/MVO2PPR
+7FKQGCacYH9gyUO/Cy1uuZLIXAuOJNSYj8B7ncFqqIWBT5OElYMucwC02r2
aGCdHBUZ5HjS7gLwbFhtpwNkOO+WC9m9y0A26okm7kvw21bb7EthQqBout0p
YIkxaEr75OWmdYht1T039MM6Fut+XZrNFQNDVW0S4y7E428OVG91SKCOQz1L
rl1G+5wGLVKMDIaXKji6PQt4LHz7lKhJDma9+9Noch6qrD7X6WIqoJ/eWvZi
mYsM2tkU4hoBSTvuvCMRHBz7Jd/311UCzEf7+HEBHfg3aMAd2w==
     "]], 
    {RGBColor[1, 0.5, 0], PointBox[CompressedData["
1:eJwBAQT++yFib1JlAgAAAD8AAAACAAAAAAAAAAAAEkAAAAAAAAAAAF2Nbqz6
6BFAkkT9pITA3D9lJxOUJaQRQBSNpQe/m+w/eXVaxzAyEUB6EXJIB0f1P6yL
a8I/lBBAWNRQRsIJ/D/67CYHzZcPQFczasFiQgFAdmbRA0u2DUCF6Zm6vlME
QESR8xzJiAtA8NxuNhwxB0Byyz9a2RQJQKf+F1sn0wlAYD5l6cFgBkBJXWkL
JDMMQFynqxFtcwNAjC7qIP9KDkCaJtCDV1QAQNCH2fquChBACunCZvoW+j8/
0C4L1sYQQOuVL9WJQvM/CuF+fBNYEUDjwZUzq3noP5K+ls3zvBFA3Li++U9f
1D+e/Uj3dPQRQH18BQ+l0cC/jyVuAAn+EUAgujYzuY3iv+bFCmmX2RFAJdiE
/Mlb8L9XXPpofYcRQGXOWpDfRve/sb9+AY0IEUBG4D0ia/b9v2f1FeQKXhBA
o7IrZaksAsBa4ehnVhMPQB7D+VSgLwXA6THgVBobDUDgNRZaZvwHwAY1A1Nr
2ApAuesiC9KLCsDLS3yUEVEIQO08du1W1wzAB8SJ74SLBUD+ElE1FtkOwHKW
FFPcjgJADWLp5PZFEMDuO6lId8X+PysvIbPC9RDAeKLJZ4Ae+D9y1IvbLHoR
wHebiPjXOfE/RlErq+LREcAGsG17P1LkP3S9IMgD/BHANBLrclHzxz+Wgohv
JPgRwGyZkhDPz9C/lvYdiU7GEcAq7g0kI7fmv+FK5Y0BZxHAAjYfMyJm8r/V
nhxCMdsQwGOuke6iQfm/8ji2RUMkEMAv7G5sidz/v16ULQMXiA7Aqd6zSfgS
A8AFHnf1jnkMwLRY6t/hBgbABGJ7LjEiCsBIqsPyc8IIwFmJtsf6hwfAhKKX
GbE+C8AQc3fWk7EEwNUhP+o9dQ3AABAOZT6mAcAzFco7cWAPwL0CWcSH2/y/
td2gULF9EMD/Gu9rwiD2vwfntnv7IBHAF0XjvsZa7r9IFMBydZgRwJ5fYghk
JuC/KdXkmu3iEcB6d7qLIYusv+50j3il/xHAjwhYAyAz2T/f4qaWU+4RwDCZ
a4yX2+o/jKRzQiSvEcA0tHgedmz0Py1WThq5QhHAQOjAwOI2+z+IkzlwJ6oQ
wCYsL4LZ3QBAcmkRCevND8A4uWInHfUDQH6UUz8t9g3AnmYKXVTZBkAeRhgq
zNELwNHOiMMZgwlAYgbMd0JmCcDUa5N5nesLQGrUidrAuQbA773PiLYMDkCU
IKoyHtMDwGxgfKfy4A9A4l1AEMa5AMAXPWwT0rEQQL40jXBL6/q/qpNT9XZI
EUAYtwa8Lx70v+VlmaXmshFAyHoaEj076r+Eb0TkEPARQMGmNvcD7te/EoTT
ZA==
      "]]}}, LineBox[{{-9., 2.25}, {1., 0.}}], 
   LineBox[{{-8.505787112591506, 3.137260121697012}, {0.9950041652780258, 
    0.09983341664682815}}], 
   LineBox[{{-7.9265872119934, 3.993173777298345}, {0.9800665778412416, 
    0.19866933079506122`}}], 
   LineBox[{{-7.268187472154427, 4.80918896048467}, {0.955336489125606, 
    0.2955202066613396}}], 
   LineBox[{{-6.5371664056370395`, 5.577152317284346}, {0.9210609940028851, 
    0.3894183423086505}}], 
   LineBox[{{-5.740828133294441, 6.289390611691166}, {0.8775825618903728, 
    0.479425538604203}}], 
   LineBox[{{-4.887129403909444, 6.9387873941020946`}, {0.8253356149096782, 
    0.5646424733950355}}], 
   LineBox[{{-3.984600092990785, 7.518854106529319}, {0.7648421872844884, 
    0.6442176872376911}}], 
   LineBox[{{-3.042257975076636, 8.023794914126828}, {0.6967067093471654, 
    0.7173560908995228}}], 
   LineBox[{{-2.0695186211123047`, 8.448564615256345}, {0.6216099682706644, 
    0.7833269096274834}}], 
   LineBox[{{-1.0761013211777222`, 8.788919051474384}, {0.5403023058681397, 
    0.8414709848078965}}], 
   LineBox[{{-0.0719319725537364, 9.041457513760468}, {0.4535961214255773, 
    0.8912073600614354}}], 
   LineBox[{{0.9329560965624584, 9.203656721277554}, {0.3623577544766734, 
    0.9320390859672264}}], 
   LineBox[{{1.928522376756082, 9.273896033160058}, {0.26749882862458735`, 
    0.963558185417193}}], 
   LineBox[{{2.904819498845904, 9.251473641421684}, {0.16996714290024081`, 
    0.9854497299884603}}], 
   LineBox[{{3.8520926247089187`, 9.13661358318882}, {0.0707372016677029, 
    0.9974949866040544}}], 
   LineBox[{{4.760876914398373, 8.930463502195646}, {-0.029199522301288815`, 
    0.9995736030415051}}], 
   LineBox[{{5.622092095695832, 8.635083181907286}, {-0.12884449429552486`, 
    0.9916648104524686}}], 
   LineBox[{{6.427133191189663, 8.25342396484431}, {-0.2272020946930871, 
    0.9738476308781951}}], 
   LineBox[{{7.167956496364898, 7.789299263743847}, {-0.3232895668635036, 
    0.9463000876874145}}], 
   LineBox[{{7.837159949639849, 7.247346459200064}, {-0.4161468365471424, 
    0.9092974268256817}}], 
   LineBox[{{8.42805709131865, 6.632980564490183}, {-0.5048461045998576, 
    0.8632093666488737}}], 
   LineBox[{{8.934743872486267, 5.952340120551783}, {-0.5885011172553458, 
    0.8084964038195901}}], 
   LineBox[{{9.35215764631366, 5.212225861710875}, {-0.6662760212798244, 
    0.74570521217672}}], 
   LineBox[{{9.67612775235139, 4.420032764992553}, {-0.7373937155412458, 
    0.6754631805511506}}], 
   LineBox[{{9.903417188390208, 3.583676161955008}, {-0.8011436155469337, 
    0.5984721441039565}}], 
   LineBox[{{10.031754953517115`, 2.7115126513130456`}, {-0.8568887533689473, 
    0.5155013718214642}}], 
   LineBox[{{10.059858739205785`, 1.8122566025660807`}, {-0.9040721420170612, 
    0.4273798802338298}}], 
   LineBox[{{9.987447741719496, 0.8948930848986607}, {-0.9422223406686583, 
    0.33498815015590466`}}], 
   LineBox[{{9.815245467809236, -0.03141190866074117}, {-0.9709581651495907, 
    0.23924932921398198`}}], 
   LineBox[{{9.54497250567341, -0.9574030448121973}, {-0.9899924966004454, 
    0.1411200080598672}}], 
   LineBox[{{9.179329333409322, -1.8738281262152643`}, {-0.9991351502732795, 
    0.04158066243329049}}], 
   LineBox[{{
    8.721969336728668, -2.771530536386415}, {-0.9982947757947531, \
-0.058374143427580086`}}], 
   LineBox[{{
    8.177462305535164, -3.6415407295841837`}, {-0.9874797699088649, \
-0.15774569414324865`}}], 
   LineBox[{{
    7.551248774094406, -4.475165851545272}, {-0.9667981925794609, \
-0.25554110202683167`}}], 
   LineBox[{{
    6.849585661013877, -5.26407659561087}, {-0.9364566872907963, \
-0.35078322768961984`}}], 
   LineBox[{{
    6.0794837521804865`, -6.000390426405502}, {-0.896758416334147, \
-0.44252044329485246`}}], 
   LineBox[{{
    5.248637651305453, -6.676750339524858}, {-0.848100031710408, \
-0.5298361409084934}}], 
   LineBox[{{
    4.365348897987512, -7.28639837029191}, {-0.7909677119144165, \
-0.6118578909427193}}], 
   LineBox[{{
    3.4384430214733754`, -7.823243117106082}, {-0.7259323042001399, \
-0.6877661591839741}}], 
   LineBox[{{
    2.4771813588868303`, -8.28192060471448}, {-0.6536436208636119, \
-0.7568024953079282}}], 
   LineBox[{{
    1.4911685190095674`, -8.65784787927955}, {-0.5748239465332685, \
-0.8182771110644108}}], 
   LineBox[{{
    0.4902564162051477, -8.947268799738868}, {-0.4902608213406994, \
-0.8715757724135882}}], 
   LineBox[{{-0.5155541666527683, -9.14729156792504}, {-0.40079917207997545`, \
-0.9161659367494549}}], 
   LineBox[{{-1.5162135026970485`, -9.255917622457089}, \
{-0.30733286997841935`, -0.9516020738895161}}], 
   LineBox[{{-2.501723334615919, -9.272061607705128}, {-0.2107957994307797, \
-0.977530117665097}}], 
   LineBox[{{-3.4622367739351048`, -9.195562218305053}, \
{-0.11215252693505398`, -0.9936910036334645}}], 
   LineBox[{{-4.3881566878724385`, -9.027183810868411}, \
{-0.01238866346289056, -0.9999232575641008}}], 
   LineBox[{{-5.270231590716308, -8.768608766783808}, {
    0.08749898343944727, -0.9961646088358406}}], 
   LineBox[{{-6.099648081612678, -8.422420682418196}, {
    0.18651236942257576`, -0.9824526126243325}}], 
   LineBox[{{-6.8681189051531595`, -7.992078554675988}, {
    0.28366218546322625`, -0.9589242746631385}}], 
   LineBox[{{-7.567965754891624, -7.481882219845382}, {
    0.37797774271298107`, -0.9258146823277321}}], 
   LineBox[{{-8.192195992444084, -6.896929391055529}, {
    0.4685166713003771, -0.8834546557201531}}], 
   LineBox[{{-8.734572515620009, -6.243064723611994}, {
    0.5543743361791615, -0.8322674422239008}}], 
   LineBox[{{-9.189676077485654, -5.526821417132956}, {
    0.6346928759426347, -0.7727644875559871}}], 
   LineBox[{{-9.552959433688104, -4.755355937978193}, {
    0.70866977429126, -0.7055403255703919}}], 
   LineBox[{{-9.820792777017694, -3.9363765142028244`}, {
    0.7755658785102502, -0.6312666378723208}}], 
   LineBox[{{-9.990500005241806, -3.0780661174906285`}, {
    0.8347127848391598, -0.5506855425976376}}], 
   LineBox[{{-10.060385459833778`, -2.189000701605841}, {
    0.8855195169413194, -0.4646021794137566}}], 
   LineBox[{{-10.029750868432386`, -1.2780635142980432`}, {
    0.9274784307440359, -0.373876664830236}}], 
   LineBox[{{-9.89890232174846, -0.35435633882700923`}, {
    0.960170286650366, -0.27941549819892586`}}], 
   LineBox[{{-9.66914721520769, 0.5728914480469602}, {
    0.9832684384425847, -0.18216250427209502`}}], 
   LineBox[{{-9.342781185887691, 1.494415092944772}, {
    0.9965420970232175, -0.0830894028174964}}], 
   {RGBColor[0, 1, 0], PointSize[Large], PointBox[CompressedData["
1:eJw1hgsw2wccgI1iVOfRlpXi5t1WvO9iVH/UqOLqWW+zmbZDVaauJqOrjZ6x
2s5U0/WMpivWzqMETTx+6LIUY+IVFo8gJPL6pz2pOq623W7f3Xff915qduQF
dTU1NfjHf/sfSvj/Bkwat414BDiOlI80VzCBmpp3m5FEQM+Ej/Ve1hCwdJyn
zCsV4MFi3R7dmIDXdL4oOl8OmZdObHjJZiG8MFHL4bAMlJohueLmRTiUGHTS
Ll0CCX4PTW4ZrkBlTW1kdb4YmEcC06/UCOEC7bPFzJB1GH2Dg1Wb63B0pbLa
S7gKfo3JNA3DDSjX6tB3CF4GhZ7Od9FyCRh+zNF6qr0Anp+QQtnFMhjP965a
dOEB+7wp3X9SDimhxz9tt+BCiAV7O29aARqxB3u+GGCDxvIHS6OlBDRss8Om
zdqgPMvxHlVKgLtxCpu6XoPs0wJO0S4BFZfpm9uF/dhJc+Z1dRNAfcc2THVo
FJWHe4sGjxHQEuDB/L11CmM9TS1NghSgmRMVa0f/CwMZXMmrd+Uw/BNtX7u9
AHdypJBeKwVKU2mI2vQKvs17NOe+tAFCZxcTq8g1tHKOI3HnRVDK/Z7BoomQ
xn2mSqtZg8LyEmKLvoFPhv880GK3CpTNG6/uZ0qxu6Sue/e6AOo1LrY7KGSo
12Bj45rAh1BKbF6LnQL715KtcyjTMOz7gG9sROCkS9DM09oxmFgr6dvXTGDi
dGeWp8Eg2NTHnJG8JtDJgPaVfvBD6Bxhrmi/JNCNJH6fvNqEnfsbHLPvEnhH
r2tY3fU3VO/78Jm6UoG5oXsGQwnjmGI6oJG7JUfLVNZ176szGO84wTjVJsMX
XKW/X+Q8kucKm+jWUvQzc5JlbApQ3Mgvvhe2gXX9sr2YqlUUPfdInfES4Vi7
JclJfR0HbPha9RIhNlvMLzDJYkwjZbio0law9/kKNcpZguacMtmVj5Zw1mh8
6eWqFKO8jSuf1M+hbdlbXt4Rcnw0mFoQ+3gSlQ4BrjevKjDDJy46cWcYb/hy
fORnCCy7FX9Cu7MHWbLkgxF/EOiREe7vlfINRsrI+il7BH7pey7u/MVO2PPR
+7FKQGCacYH9gyUO/Cy1uuZLIXAuOJNSYj8B7ncFqqIWBT5OElYMucwC02r2
aGCdHBUZ5HjS7gLwbFhtpwNkOO+WC9m9y0A26okm7kvw21bb7EthQqBout0p
YIkxaEr75OWmdYht1T039MM6Fut+XZrNFQNDVW0S4y7E428OVG91SKCOQz1L
rl1G+5wGLVKMDIaXKji6PQt4LHz7lKhJDma9+9Noch6qrD7X6WIqoJ/eWvZi
mYsM2tkU4hoBSTvuvCMRHBz7Jd/311UCzEf7+HEBHfg3aMAd2w==
     "]], 
    {RGBColor[1, 1, 0], PointBox[CompressedData["
1:eJwlxQsw1AkcwPFlvR/Lei5rX/9F6iTtaqo77A9pu9E5NHnkRqU8dsuFi4w7
o+VaspJcuc1xDqdcQljMlG5/zFwxIUu6PeI8WtfDKptDU9xj+s5858OJPxWR
oE8ikQT//b8fIvCD+rCrbm/Bij4H86aaxuhOpuBRtV04qmDhK63G0VBnBZcT
5d3VNgzMDpo3rvS1hcDZwDcUd2fU944z0PvcAUJH0679sOKA5Yt8cqSHEyjS
vr12otgWiaCSr8N76CAPziJnTlthQE9jTqgtE/zkSTGySBPsXRtVe1mw4Qzr
6P3DJSRMjZwJvKFhQzSMG3TuXFLyim/wtN9x4GzbdT9C3KasKz7wcrc9AcOT
4l/vjWsFwxsVrcHJBEREVwo/ntgQiMZVTr7FBPAq4/Vs/Iyh5iR/U89ZAgw/
I17bqyggWdu2UxdMQFROXDjX3BbKncM6E55w4MvT6g7DHAewt06r3hzMAXGf
b1J8hxOMUXj9KGHDU/eb/e8bXeCKm87a34MFRRqfDIhhwW9eT4/tW3eBBmrp
/i0TbGhdrqJ4FjqD6aJCWT7FAaKnRsB76Ai8Zw/0QhUElFzP6Q7/ww4eFt4S
bz3EhcnSdiqjmQpZF6vaioe4IBdFJ8c1WoBLS8q2QGtXSKg7K9vaagiy8xuD
9UxX6G3PvU/6570g+5gzlr3lgs9gzchK7YJg5q/K8aQaLqD/EO6y/0m513O2
1siRCxYaVYd53aLyrmjBUhVLQGynlM9/t658oCWv1qdxYMmjiU/zNMJ2x8nI
J4fY0Kh1pU9zLDGwT/9itg8T0iFv+tI8Fakjl/veJtCh0j2KJqbYo7ozzPt4
OA1Ky2xiEkk0NKs/MFWxYQcYlGu2oXDGxiWJITOTCjvY+6qC3RiITnzxosQc
+vPi/UkhLPRKHcvYoyJDSm2vJqqUjeWFh8+NTqwK9ucunlKFcTA5sjT9iyN/
CioGpGKShoOK2dqvTuROK2dS5gdEIQQyE9cdRIFryi51Rq1xPoEGUoq0gGyA
aV5dDSEyAvOz5dt/aTNH92eb7rCPE2gtO6LLukDFLREHTV9aErg0R/2+y84e
7+ZddSg4z0F1UYmbWSINe4XWUqGajcJbRZuXs+j46Mpg6twqCxuMK4blwUw0
MYstTNcyMPV1bH5SPBuTfzzXcLqcjt0B0jmnLA56z2f/rVmj4eM95rsZRwnM
vDlmc4bugHqirlwGnYvNI8+NvjG0RYOPTr7x/5mLL3SfrrXlWKFLko2KeMdF
7/gF9ky1CTYLh35/wXTFElnvgE2+HrbM5Ug+sXLF0FcBt3Xpy8oL4kcLvgNc
TKVf3XGv6bGyzPJOZkUkFw1qvdPZB2cFt103yJIWAhtk2gHW81XBvynWxxo=

      "]]}}},
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 12}]], "Output",
 CellChangeTimes->{
  3.5848060119894543`*^9, 3.5848099237054815`*^9, {3.5848099681455436`*^9, 
   3.5848099794955597`*^9}, 3.5848101045557346`*^9, {3.584810152915802*^9, 
   3.584810187875851*^9}, {3.5848103051160154`*^9, 3.5848103267860456`*^9}, 
   3.584810362286095*^9, {3.584810452826222*^9, 3.5848104797262597`*^9}, 
   3.5848105254363236`*^9, 3.584810623666461*^9, 3.5848107171805944`*^9, 
   3.5848108832708273`*^9, {3.584811200321271*^9, 3.5848112257713065`*^9}, {
   3.584811414301571*^9, 3.5848114694916477`*^9}, {3.5848115007816916`*^9, 
   3.5848115178717155`*^9}, {3.5848115556917686`*^9, 3.5848116317018747`*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{985, 630},
WindowMargins->{{Automatic, 27}, {39, Automatic}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 691, 12, 107, "Subtitle"],
Cell[1273, 36, 890, 23, 123, "Subsubtitle"],
Cell[CellGroupData[{
Cell[2188, 63, 12017, 324, 1152, "Input"],
Cell[CellGroupData[{
Cell[14230, 391, 678, 10, 23, "Print"],
Cell[14911, 403, 679, 10, 23, "Print"],
Cell[15593, 415, 658, 9, 23, "Print"],
Cell[16254, 426, 2859, 71, 36, "Print"]
}, Open  ]],
Cell[19128, 500, 29412, 560, 347, "Output"],
Cell[48543, 1062, 644, 9, 23, "Print"],
Cell[49190, 1073, 9572, 164, 347, "Output"],
Cell[58765, 1239, 635, 9, 23, "Print"],
Cell[59403, 1250, 19900, 374, 374, "Output"],
Cell[79306, 1626, 637, 9, 23, "Print"],
Cell[79946, 1637, 19763, 372, 347, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
