(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     15301,        451]
NotebookOptionsPosition[     14669,        425]
NotebookOutlinePosition[     15013,        440]
CellTagsIndexPosition[     14970,        437]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9},
 FontFamily->"Arial"],

Cell[TextData[{
 "\n",
 Cell[BoxData[{
  StyleBox[
   RowBox[{
   "Matrix", " ", "products", " ", "do", " ", "not", " ", "commute", " ", 
    RowBox[{"(", 
     RowBox[{"in", " ", "general"}], ")"}]}],
   FontSize->16,
   FontWeight->"Bold"], "\[IndentingNewLine]", 
  RowBox[{
   StyleBox[
    RowBox[{
     RowBox[{"A", " ", "vector", " ", 
      StyleBox["v",
       FontWeight->"Bold"], " ", "may", " ", "be", " ", "transformed", " ", 
      "using", " ", "a", " ", "linear", " ", "map", " ", "M"}], ",", 
     RowBox[{
      RowBox[{
      "and", " ", "then", " ", "the", " ", "result", " ", "may", " ", "again",
        " ", "be", " ", "transformed", " ", "by", " ", "using", " ", "a", " ",
        "linear", " ", "map", " ", 
       RowBox[{"N", ":", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"N", 
         RowBox[{"(", 
          StyleBox[
           RowBox[{"M", 
            StyleBox["v",
             FontWeight->"Bold"]}]], ")"}]}]}]}], " ", "=", " ", 
      RowBox[{
       RowBox[{
        StyleBox[
         RowBox[{"NM", 
          StyleBox["v",
           FontWeight->"Bold"]}]], ".", "\[IndentingNewLine]", "N"}], "=", 
       FormBox[
        RowBox[{"(", GridBox[{
           {
            SubscriptBox["n", 
             RowBox[{"1", ",", "1"}]], 
            SubscriptBox["n", 
             RowBox[{"1", ",", "2"}]]},
           {
            SubscriptBox["n", 
             RowBox[{"2", ",", "1"}]], 
            SubscriptBox["n", 
             RowBox[{"2", ",", "2"}]]}
          }], ")"}],
        TraditionalForm]}]}], ",", "  ", 
     RowBox[{"M", "=", 
      RowBox[{
       RowBox[{
        RowBox[{
         FormBox[
          RowBox[{"(", GridBox[{
             {
              SubscriptBox["m", 
               RowBox[{"1", ",", "1"}]], 
              SubscriptBox["m", 
               RowBox[{"1", ",", "2"}]]},
             {
              SubscriptBox["m", 
               RowBox[{"2", ",", "1"}]], 
              SubscriptBox["m", 
               RowBox[{"2", ",", "2"}]]}
            }], ")"}],
          TraditionalForm], ".", "\[IndentingNewLine]", "\[LineSeparator]", 
         "The"}], " ", 
        StyleBox["product",
         FontSlant->"Italic"], 
        StyleBox[" ",
         FontSlant->"Italic"], 
        StyleBox["matrix",
         FontSlant->"Italic"], " ", "L"}], "=", 
       RowBox[{
       "NM", " ", "of", " ", "the", " ", "combined", " ", "action", " ", 
        "has", " ", "elements"}]}]}]}],
    FontSize->16], 
   StyleBox[" ",
    FontSize->16]}], "\[LineSeparator]", 
  RowBox[{
   StyleBox[
    RowBox[{
     RowBox[{
      SubscriptBox["l", 
       RowBox[{"i", ",", "j", " "}]], " ", "where", " ", 
      SubscriptBox["l", 
       RowBox[{"i", ",", "j", " "}]], " ", "is", " ", "the", " ", "dot", " ", 
      "product", " ", "of", " ", "the", " ", "ith", "  ", "row", " ", "of", 
      " ", "N", " ", "a", " ", "nd", " ", "the", " ", "jth", " ", "column", 
      " ", "of", " ", 
      RowBox[{"M", ".", "\[IndentingNewLine]", "\[LineSeparator]", 
       RowBox[{
       "Example", ":", "\[IndentingNewLine]", "\[IndentingNewLine]", " ", 
        SubscriptBox["l", 
         RowBox[{"2", ",", "1", " "}]]}]}]}], "=", 
     RowBox[{
      RowBox[{
       SubscriptBox["n", 
        RowBox[{"2", ",", "1"}]], 
       SubscriptBox["m", 
        RowBox[{"1", ",", "1"}]]}], " ", "+", " ", 
      RowBox[{
       SubscriptBox["n", 
        RowBox[{"2", ",", "2"}]], 
       RowBox[{
        SubscriptBox["m", 
         RowBox[{"2", ",", "1"}]], ".", "\t", "\[LineSeparator]", 
        "\[LineSeparator]", "Matrix"}], " ", "products", " ", "do", " ", 
       "not", " ", "commute"}]}]}],
    FontSize->16], 
   StyleBox[",",
    FontSize->16], 
   StyleBox[" ",
    FontSize->16], 
   StyleBox[
    RowBox[{"i", ".", "e", "."}],
    FontSize->16], 
   StyleBox[",",
    FontSize->16], 
   StyleBox[" ",
    FontSize->16], 
   RowBox[{
    StyleBox[
     RowBox[{"MN", " ", "\[NotEqual]", " ", 
      RowBox[{"NM", " ", 
       RowBox[{"(", 
        RowBox[{"in", " ", "general"}], ")"}]}]}],
     FontSize->16], 
    StyleBox[":",
     FontSize->16], "\[IndentingNewLine]"}]}]}], "Text",
  CellChangeTimes->{{3.519343221986912*^9, 3.5193433078338623`*^9}, {
   3.519351908016968*^9, 3.519352031428785*^9}, {3.5193521237809467`*^9, 
   3.519352178131442*^9}, {3.5193522528867736`*^9, 3.519352315099683*^9}, {
   3.519352373818186*^9, 3.519352430181085*^9}, {3.5193525004592085`*^9, 
   3.51935262627343*^9}, {3.51935269503835*^9, 3.519352729873212*^9}, {
   3.5193921680083575`*^9, 3.5193923207545004`*^9}, {3.5193923566044493`*^9, 
   3.51939238719703*^9}, {3.51939241964607*^9, 3.519392435121766*^9}, {
   3.519392782811124*^9, 3.519392814579239*^9}, {3.519392873153652*^9, 
   3.5193928801126795`*^9}, {3.5193929873596277`*^9, 3.519392994255491*^9}},
  FontFamily->"Arial",
  FontSize->24]
}], "Subsubtitle",
 CellChangeTimes->{{3.519060513774078*^9, 3.5190605260200996`*^9}, 
   3.5191436408642206`*^9, {3.5191438075661135`*^9, 3.519143812292922*^9}, 
   3.5191438595610046`*^9, {3.5191573389486732`*^9, 3.5191573410390773`*^9}, 
   3.51921540749041*^9, {3.5192361023063602`*^9, 3.519236108593171*^9}, 
   3.519393240993213*^9, 3.5193932719777927`*^9, 3.5193933692964272`*^9, {
   3.519393589768115*^9, 3.5193936292376328`*^9}, 3.519398591297525*^9, {
   3.519398648690026*^9, 3.5193986712476654`*^9}, {3.5194068042615175`*^9, 
   3.519406806476722*^9}, {3.519419397075637*^9, 3.519419397075637*^9}, {
   3.519419497239813*^9, 3.519419497239813*^9}, {3.519476298619652*^9, 
   3.519476298619652*^9}, {3.5198401391985917`*^9, 3.5198401425993977`*^9}, {
   3.5199956478175983`*^9, 3.5199957173313203`*^9}, {3.5212333647649345`*^9, 
   3.521233422797036*^9}, {3.5212334840895443`*^9, 3.5212334901423545`*^9}, {
   3.584803378853767*^9, 3.584803393953788*^9}},
 FontFamily->"Arial",
 FontColor->GrayLevel[0]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"input", " ", "matrices"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"mat1", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        StyleBox[
         RowBox[{"1", ",", "1"}],
         FontColor->GrayLevel[0]], 
        StyleBox["}",
         FontColor->GrayLevel[0]]}], 
       StyleBox[",",
        FontColor->GrayLevel[0]], 
       StyleBox[
        RowBox[{"{", 
         RowBox[{"1", ",", "3"}], "}"}],
        FontColor->GrayLevel[0]]}], 
      StyleBox["}",
       FontColor->GrayLevel[0]]}]}], 
    StyleBox[";",
     FontColor->GrayLevel[0]]}], 
   StyleBox["\[IndentingNewLine]",
    FontColor->GrayLevel[0]], 
   StyleBox[
    RowBox[{
     RowBox[{"mat2", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4"}], "}"}]}], "}"}]}], ";"}],
    FontColor->GrayLevel[0]], 
   StyleBox["\[IndentingNewLine]",
    FontColor->GrayLevel[0]], 
   StyleBox["\[IndentingNewLine]",
    FontColor->GrayLevel[0]], 
   RowBox[{
    RowBox[{"Print", "[", "\"\<mat1.mat2   mat2.mat1\>\"", "]"}], ";"}], 
   StyleBox["\[IndentingNewLine]",
    FontColor->GrayLevel[0]], 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", 
      RowBox[{"mat1", ".", "mat2"}], "]"}], ",", "\"\< \[NotEqual]  \>\"", 
     ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"mat2", ".", "mat1"}], "]"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"angle1", " ", "=", " ", 
     RowBox[{"Pi", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rot2d1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", "angle1", "]"}], ",", 
         RowBox[{"-", 
          RowBox[{"Sin", "[", "angle1", "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Sin", "[", "angle1", "]"}], ",", 
         RowBox[{"Cos", "[", "angle1", "]"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"angle2", " ", "=", " ", 
     RowBox[{"Pi", "/", "3"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rot2d2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", "angle2", "]"}], ",", 
         RowBox[{"-", 
          RowBox[{"Sin", "[", "angle2", "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Sin", "[", "angle2", "]"}], ",", 
         RowBox[{"Cos", "[", "angle2", "]"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\< \>\"", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<2D Rotation matrices do commute\>\"", "]"}], 
    ";"}], 
   StyleBox["\[IndentingNewLine]",
    FontColor->GrayLevel[0]], 
   RowBox[{"Print", "[", 
    RowBox[{
     RowBox[{"MatrixForm", "[", 
      RowBox[{"rot2d1", ".", "rot2d2"}], "]"}], ",", "\"\< =  \>\"", ",", 
     RowBox[{"MatrixForm", "[", 
      RowBox[{"rot2d2", ".", "rot2d1"}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.584803521703967*^9, 3.584803589184061*^9}, {
  3.5848036402741327`*^9, 3.584803913724516*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"mat1.mat2   mat2.mat1\"\>"], "Print",
 CellChangeTimes->{{3.584803889204481*^9, 3.584803915444518*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"3", "6"},
       {"9", "14"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\" \[NotEqual]  \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2", "6"},
       {"7", "15"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{3, 6}, {9, 14}}], " \[NotEqual]  ", 
   MatrixForm[{{2, 6}, {7, 15}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.584803889204481*^9, 3.584803915444518*^9}}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{{3.584803889204481*^9, 3.584803915444518*^9}}],

Cell[BoxData["\<\"2D Rotation matrices do commute\"\>"], "Print",
 CellChangeTimes->{{3.584803889204481*^9, 3.584803915444518*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", 
         FractionBox[
          SqrtBox["3"], "2"]}], 
        RowBox[{"-", 
         FractionBox["1", "2"]}]},
       {
        FractionBox["1", "2"], 
        RowBox[{"-", 
         FractionBox[
          SqrtBox["3"], "2"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\" =  \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", 
         FractionBox[
          SqrtBox["3"], "2"]}], 
        RowBox[{"-", 
         FractionBox["1", "2"]}]},
       {
        FractionBox["1", "2"], 
        RowBox[{"-", 
         FractionBox[
          SqrtBox["3"], "2"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
   MatrixForm[{{Rational[-1, 2] 3^Rational[1, 2], 
      Rational[-1, 2]}, {
      Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}}], " =  ", 
   MatrixForm[{{Rational[-1, 2] 3^Rational[1, 2], 
      Rational[-1, 2]}, {
      Rational[1, 2], Rational[-1, 2] 3^Rational[1, 2]}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.584803889204481*^9, 3.584803915444518*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1029, 630},
WindowMargins->{{Automatic, 29}, {Automatic, 41}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 691, 12, 107, "Subtitle"],
Cell[1273, 36, 5890, 157, 548, "Subsubtitle"],
Cell[CellGroupData[{
Cell[7188, 197, 3401, 102, 352, "Input"],
Cell[CellGroupData[{
Cell[10614, 303, 121, 1, 23, "Print"],
Cell[10738, 306, 1511, 42, 36, "Print"],
Cell[12252, 350, 101, 1, 23, "Print"],
Cell[12356, 353, 131, 1, 23, "Print"],
Cell[12490, 356, 2139, 64, 71, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
