(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     30233,        676]
NotebookOptionsPosition[     29683,        652]
NotebookOutlinePosition[     30026,        667]
CellTagsIndexPosition[     29983,        664]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9},
 FontFamily->"Arial"],

Cell[TextData[{
 StyleBox["Transpose of a matrix",
  FontWeight->"Bold"],
 "\nThe transpose M^T of matrix M is formed by making the columns of M the \
rows of M^T\nFor a 2x2 matrix: simply exchange the off-diagonal elements.\n\
Here we visualize the action ellipses of M and M^T"
}], "Subsubtitle",
 CellChangeTimes->{{3.584811896592246*^9, 3.5848120334724374`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Input", " ", 
    RowBox[{"matrix", " ", "--"}], " ", "select", " ", "one", " ", "and", " ",
     "load", " ", "into", " ", "mat"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"mat1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", 
         RowBox[{"-", "4"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat4", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat", " ", "=", " ", "mat4"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "points", " ", "on", " ", "circle", " ", "and", " ", "points", " ", "on", 
     " ", "action", " ", "ellipse", " ", "for", " ", "mat"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"circpoints", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", "t", "]"}], ",", 
         RowBox[{"Sin", "[", "t", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"2", " ", "Pi"}], ",", "0.1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ellpoints", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"mat", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Cos", "[", "t", "]"}], ",", 
          RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Circle", " ", "is", " ", "green"}], ";", " ", 
     RowBox[{"Action", " ", "ellipse", " ", "is", " ", "red"}]}], " ", "*)"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pplot", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "Large", "]"}], ",", "Green", ",", 
        RowBox[{"Point", "[", "circpoints", "]"}], ",", "Red", ",", " ", 
        RowBox[{"Point", "[", "ellpoints", "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"line", "[", "t_", "]"}], ":=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"Line", "[", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"mat", ".", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", "t", "]"}], ",", 
            RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Cos", "[", "t", "]"}], ",", 
           RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], "}"}], "]"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lineplot", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"line", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Form", " ", "transpose"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mat2", "=", " ", 
     RowBox[{"Transpose", "[", "mat", "]"}]}], ";"}], "  ", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "action", " ", "ellipse", " ", "for", " ", "transpose", " ", "is", " ", 
     "in", " ", "orange"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ellpoints2", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"mat2", ".", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Cos", "[", "t", "]"}], ",", 
          RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pplot2", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "Large", "]"}], ",", "Green", ",", 
        RowBox[{"Point", "[", "circpoints", "]"}], ",", "Orange", ",", " ", 
        RowBox[{"Point", "[", "ellpoints2", "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"line2", "[", "t_", "]"}], ":=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"Line", "[", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"mat2", ".", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Cos", "[", "t", "]"}], ",", 
            RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Cos", "[", "t", "]"}], ",", 
           RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], "}"}], "]"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lineplot2", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"line2", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"2", "Pi"}], ",", "0.1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<Unit circle points in green\>\"", "]"}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<(red) M = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "mat", "]"}], ",", 
      "\"\<   (orange) M^T = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "mat2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"{", 
     RowBox[{"lineplot", ",", "pplot", ",", "lineplot2", ",", "pplot2"}], 
     "}"}], "]"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.584812037642443*^9, 3.5848121080525417`*^9}, {
  3.5848121434525914`*^9, 3.5848122800127826`*^9}, {3.5848123152228317`*^9, 
  3.584812538083144*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Unit circle points in green\"\>"], "Print",
 CellChangeTimes->{
  3.5848124599230347`*^9, {3.584812505323098*^9, 3.584812539003145*^9}, 
   3.5848973591728735`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"(red) M = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2", "1"},
       {"0", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   "\[InvisibleSpace]", "\<\"   (orange) M^T = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2", "0"},
       {"1", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["(red) M = ", 
   MatrixForm[{{2, 1}, {0, 1}}], "   (orange) M^T = ", 
   MatrixForm[{{2, 0}, {1, 1}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5848124599230347`*^9, {3.584812505323098*^9, 3.584812539003145*^9}, 
   3.5848973591728735`*^9}]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[{LineBox[{{2., 0.}, {1., 0.}}], 
   LineBox[{{2.08984174720288, 0.09983341664682815}, {0.9950041652780258, 
    0.09983341664682815}}], 
   LineBox[{{2.1588024864775446`, 0.19866933079506122`}, {0.9800665778412416, 
    0.19866933079506122`}}], 
   LineBox[{{2.206193184912552, 0.2955202066613396}, {0.955336489125606, 
    0.2955202066613396}}], 
   LineBox[{{2.2315403303144206`, 0.3894183423086505}, {0.9210609940028851, 
    0.3894183423086505}}], 
   LineBox[{{2.2345906623849485`, 0.479425538604203}, {0.8775825618903728, 
    0.479425538604203}}], 
   LineBox[{{2.2153137032143917`, 0.5646424733950355}, {0.8253356149096782, 
    0.5646424733950355}}], 
   LineBox[{{2.173902061806668, 0.6442176872376911}, {0.7648421872844884, 
    0.6442176872376911}}], 
   LineBox[{{2.1107695095938537`, 0.7173560908995228}, {0.6967067093471654, 
    0.7173560908995228}}], 
   LineBox[{{2.026546846168812, 0.7833269096274834}, {0.6216099682706644, 
    0.7833269096274834}}], 
   LineBox[{{1.9220755965441758`, 0.8414709848078965}, {0.5403023058681397, 
    0.8414709848078965}}], 
   LineBox[{{1.79839960291259, 0.8912073600614354}, {0.4535961214255773, 
    0.8912073600614354}}], 
   LineBox[{{1.656754594920573, 0.9320390859672264}, {0.3623577544766734, 
    0.9320390859672264}}], 
   LineBox[{{1.4985558426663677`, 0.963558185417193}, {0.26749882862458735`, 
    0.963558185417193}}], 
   LineBox[{{1.3253840157889418`, 0.9854497299884603}, {0.16996714290024081`, 
    0.9854497299884603}}], 
   LineBox[{{1.1389693899394602`, 0.9974949866040544}, {0.0707372016677029, 
    0.9974949866040544}}], 
   LineBox[{{0.9411745584389275, 0.9995736030415051}, {-0.029199522301288815`,
     0.9995736030415051}}], 
   LineBox[{{0.7339758218614189, 0.9916648104524686}, {-0.12884449429552486`, 
    0.9916648104524686}}], 
   LineBox[{{0.5194434414920209, 0.9738476308781951}, {-0.2272020946930871, 
    0.9738476308781951}}], 
   LineBox[{{0.2997209539604073, 0.9463000876874145}, {-0.3232895668635036, 
    0.9463000876874145}}], 
   LineBox[{{0.0770037537313969, 0.9092974268256817}, {-0.4161468365471424, 
    0.9092974268256817}}], 
   LineBox[{{-0.14648284255084143`, 0.8632093666488737}, {-0.5048461045998576,
     0.8632093666488737}}], 
   LineBox[{{-0.36850583069110154`, 0.8084964038195901}, {-0.5885011172553458,
     0.8084964038195901}}], 
   LineBox[{{-0.5868468303829288, 0.74570521217672}, {-0.6662760212798244, 
    0.74570521217672}}], 
   LineBox[{{-0.7993242505313409, 0.6754631805511506}, {-0.7373937155412458, 
    0.6754631805511506}}], 
   LineBox[{{-1.0038150869899107`, 0.5984721441039565}, {-0.8011436155469337, 
    0.5984721441039565}}], 
   LineBox[{{-1.1982761349164304`, 0.5155013718214642}, {-0.8568887533689473, 
    0.5155013718214642}}], 
   LineBox[{{-1.3807644038002926`, 0.4273798802338298}, {-0.9040721420170612, 
    0.4273798802338298}}], 
   LineBox[{{-1.549456531181412, 0.33498815015590466`}, {-0.9422223406686583, 
    0.33498815015590466`}}], 
   LineBox[{{-1.7026670010851994`, 
    0.23924932921398198`}, {-0.9709581651495907, 0.23924932921398198`}}], 
   LineBox[{{-1.8388649851410237`, 0.1411200080598672}, {-0.9899924966004454, 
    0.1411200080598672}}], 
   LineBox[{{-1.9566896381132686`, 0.04158066243329049}, {-0.9991351502732795,
     0.04158066243329049}}], 
   LineBox[{{-2.0549636950170864`, -0.058374143427580086`}, \
{-0.9982947757947531, -0.058374143427580086`}}], 
   LineBox[{{-2.132705233960978, -0.15774569414324865`}, \
{-0.9874797699088649, -0.15774569414324865`}}], 
   LineBox[{{-2.1891374871857536`, -0.25554110202683167`}, \
{-0.9667981925794609, -0.25554110202683167`}}], 
   LineBox[{{-2.2236966022712124`, -0.35078322768961984`}, \
{-0.9364566872907963, -0.35078322768961984`}}], 
   LineBox[{{-2.2360372759631466`, -0.44252044329485246`}, \
{-0.896758416334147, -0.44252044329485246`}}], 
   LineBox[{{-2.2260362043293096`, -0.5298361409084934}, {-0.848100031710408, \
-0.5298361409084934}}], 
   LineBox[{{-2.1937933147715523`, -0.6118578909427193}, \
{-0.7909677119144165, -0.6118578909427193}}], 
   LineBox[{{-2.139630767584254, -0.6877661591839741}, {-0.7259323042001399, \
-0.6877661591839741}}], 
   LineBox[{{-2.064089737035152, -0.7568024953079282}, {-0.6536436208636119, \
-0.7568024953079282}}], 
   LineBox[{{-1.9679250041309477`, -0.8182771110644108}, \
{-0.5748239465332685, -0.8182771110644108}}], 
   LineBox[{{-1.852097415094987, -0.8715757724135882}, {-0.4902608213406994, \
-0.8715757724135882}}], 
   LineBox[{{-1.7177642809094058`, -0.9161659367494549}, \
{-0.40079917207997545`, -0.9161659367494549}}], 
   LineBox[{{-1.5662678138463548`, -0.9516020738895161}, \
{-0.30733286997841935`, -0.9516020738895161}}], 
   LineBox[{{-1.3991217165266563`, -0.977530117665097}, {-0.2107957994307797, \
-0.977530117665097}}], 
   LineBox[{{-1.2179960575035724`, -0.9936910036334645}, \
{-0.11215252693505398`, -0.9936910036334645}}], 
   LineBox[{{-1.024700584489882, -0.9999232575641008}, {-0.01238866346289056, \
-0.9999232575641008}}], 
   LineBox[{{-0.821166641956946, -0.9961646088358406}, {
    0.08749898343944727, -0.9961646088358406}}], 
   LineBox[{{-0.609427873779181, -0.9824526126243325}, {
    0.18651236942257576`, -0.9824526126243325}}], 
   LineBox[{{-0.39159990373668596`, -0.9589242746631385}, {
    0.28366218546322625`, -0.9589242746631385}}], 
   LineBox[{{-0.16985919690176998`, -0.9258146823277321}, {
    0.37797774271298107`, -0.9258146823277321}}], 
   LineBox[{{0.05357868688060108, -0.8834546557201531}, {
    0.4685166713003771, -0.8834546557201531}}], 
   LineBox[{{0.2764812301344223, -0.8322674422239008}, {
    0.5543743361791615, -0.8322674422239008}}], 
   LineBox[{{0.4966212643292822, -0.7727644875559871}, {
    0.6346928759426347, -0.7727644875559871}}], 
   LineBox[{{0.7117992230121281, -0.7055403255703919}, {
    0.70866977429126, -0.7055403255703919}}], 
   LineBox[{{0.9198651191481795, -0.6312666378723208}, {
    0.7755658785102502, -0.6312666378723208}}], 
   LineBox[{{1.118740027080682, -0.5506855425976376}, {
    0.8347127848391598, -0.5506855425976376}}], 
   LineBox[{{1.306436854468882, -0.4646021794137566}, {
    0.8855195169413194, -0.4646021794137566}}], 
   LineBox[{{1.4810801966578357`, -0.373876664830236}, {
    0.9274784307440359, -0.373876664830236}}], 
   LineBox[{{1.640925075101806, -0.27941549819892586`}, {
    0.960170286650366, -0.27941549819892586`}}], 
   LineBox[{{1.7843743726130743`, -0.18216250427209502`}, {
    0.9832684384425847, -0.18216250427209502`}}], 
   LineBox[{{1.9099947912289386`, -0.0830894028174964}, {
    0.9965420970232175, -0.0830894028174964}}], 
   {RGBColor[0, 1, 0], PointSize[Large], PointBox[CompressedData["
1:eJw1hgsw2wccgI1iVOfRlpXi5t1WvO9iVH/UqOLqWW+zmbZDVaauJqOrjZ6x
2s5U0/WMpivWzqMETTx+6LIUY+IVFo8gJPL6pz2pOq623W7f3Xff915qduQF
dTU1NfjHf/sfSvj/Bkwat414BDiOlI80VzCBmpp3m5FEQM+Ej/Ve1hCwdJyn
zCsV4MFi3R7dmIDXdL4oOl8OmZdObHjJZiG8MFHL4bAMlJohueLmRTiUGHTS
Ll0CCX4PTW4ZrkBlTW1kdb4YmEcC06/UCOEC7bPFzJB1GH2Dg1Wb63B0pbLa
S7gKfo3JNA3DDSjX6tB3CF4GhZ7Od9FyCRh+zNF6qr0Anp+QQtnFMhjP965a
dOEB+7wp3X9SDimhxz9tt+BCiAV7O29aARqxB3u+GGCDxvIHS6OlBDRss8Om
zdqgPMvxHlVKgLtxCpu6XoPs0wJO0S4BFZfpm9uF/dhJc+Z1dRNAfcc2THVo
FJWHe4sGjxHQEuDB/L11CmM9TS1NghSgmRMVa0f/CwMZXMmrd+Uw/BNtX7u9
AHdypJBeKwVKU2mI2vQKvs17NOe+tAFCZxcTq8g1tHKOI3HnRVDK/Z7BoomQ
xn2mSqtZg8LyEmKLvoFPhv880GK3CpTNG6/uZ0qxu6Sue/e6AOo1LrY7KGSo
12Bj45rAh1BKbF6LnQL715KtcyjTMOz7gG9sROCkS9DM09oxmFgr6dvXTGDi
dGeWp8Eg2NTHnJG8JtDJgPaVfvBD6Bxhrmi/JNCNJH6fvNqEnfsbHLPvEnhH
r2tY3fU3VO/78Jm6UoG5oXsGQwnjmGI6oJG7JUfLVNZ176szGO84wTjVJsMX
XKW/X+Q8kucKm+jWUvQzc5JlbApQ3Mgvvhe2gXX9sr2YqlUUPfdInfES4Vi7
JclJfR0HbPha9RIhNlvMLzDJYkwjZbio0law9/kKNcpZguacMtmVj5Zw1mh8
6eWqFKO8jSuf1M+hbdlbXt4Rcnw0mFoQ+3gSlQ4BrjevKjDDJy46cWcYb/hy
fORnCCy7FX9Cu7MHWbLkgxF/EOiREe7vlfINRsrI+il7BH7pey7u/MVO2PPR
+7FKQGCacYH9gyUO/Cy1uuZLIXAuOJNSYj8B7ncFqqIWBT5OElYMucwC02r2
aGCdHBUZ5HjS7gLwbFhtpwNkOO+WC9m9y0A26okm7kvw21bb7EthQqBout0p
YIkxaEr75OWmdYht1T039MM6Fut+XZrNFQNDVW0S4y7E428OVG91SKCOQz1L
rl1G+5wGLVKMDIaXKji6PQt4LHz7lKhJDma9+9Noch6qrD7X6WIqoJ/eWvZi
mYsM2tkU4hoBSTvuvCMRHBz7Jd/311UCzEf7+HEBHfg3aMAd2w==
     "]], 
    {RGBColor[1, 0, 0], PointBox[CompressedData["
1:eJwBAQT++yFib1JlAgAAAD8AAAACAAAAAAAAAAAAAEAAAAAAAAAAADpqMPP+
twBALMuLy66OuT9pju88OkUBQLzSPSP/bck/JNzOnEimAUA0urqVzenSP2k+
E9Ex2gFAa2cr6Trs2D9mH7cRceABQPAFS3Tort4/4H0NZPa4AUBaQaUXjRHi
PzdVocMmZAFAuRlGaW6d5D/my+gf2+IAQM3+v8KU9OY/HttgMV42AEBBqF2Y
AxHpPwKNOVfSwP4/7gwJj1Tt6j8kYnqpPsb8PzhjLUzFhOw/yucqGxGC+j/F
VRqiQ9PtP1W197AV+vc/Sx7F+XfV7j9CRqfexTT1PwPhRN/NiO8/+vWO9zc5
8j+LbSybeuvvP2JRihsaHu4/xULgx4H87z9vYt7cunznP7aYL9e3u+8/s44q
2kef4D/wFb2BwinvP1Dly8ugLtM/VzgaHxdI7j8IEvKbhLazP0a00er2GO0/
ZCoXJfO/wr/7cus/aZ/rP7AHzXqZlde/CNeq2TPf6T+mMAgBc8fivyIvWC3R
3Oc/eNFdcxCU6b+Y0cP1ZJ3lPySmnWigD/C/scrPDa8m4z+SsbCYIyzzv7uF
oLv8fuA/49lcapwX9r8MpyQkMVrbP9z2f+6Syvi/wOVdI3Jw1T+wOtrAHz77
v9MwSNa4n84/JwvPsP1r/b9b1bZtOBDCP6PlQcuZTv+/LhCYgg9KpT+QhkTO
kHAAwDIt6Dk3462/pPb+wscPAcCXDLfKAjHEv5BIz4NagwHAdEz/EMla0L9z
2bdxIcoBwB9iun47c9a/azDngmfjAcDx0fBDQVLcv2xzyhHszgHAQRsu7Gr0
4L+cBGmC44wBwKDA7P9WlOO/Z1FivPYdAcDOsx8tLgLmvwya5HpBgwDArh7c
3bk36L/Ckdvtnnz/v73I4npTL+q/+mwt5jCi/b/YEtDf8uPrv7ziC2b2e/u/
JYoBOjtR7b/N9dPWbg/5v/AoRTGGc+6/mq/5c81i9r+AQMc97Ufvvw4oGm/p
fPO/uuxdE1HM77/SN6lwLGXwv1LsNw9f/++/3634Q/9G6r//PQyalODvv3Lg
ZOJugOO/pOsidkBw77+0nOoK+Q/ZvzOZ4PWBr+6/OBjPN/K9xb+5ItgcRqDt
v3Bh1Geqbqs/1yS6skJF7L8Cp1hU3rHRPzcSvFTvoeq/ULcyjqTI3z9wBTKX
fLrovzn4BCoPx+Y/V7AKTsmT5r9UH2/5iG/tP7T1lhdWM+S/WppQ8Vvm8T+g
x3pJN5/hvzS6w1Qq5/Q/yt+Oxwq83b/iYPYlgbL3Pxu9C2SY7de/RfrLpjpB
+j/AorCK8eHRv0gZYyTMjPw/XPsz1xlRx7/8vL2yVo/+Px3NvttYRbW/Ntge
cw==
      "]]}}, LineBox[{{2., 1.}, {1., 0.}}], 
   LineBox[{{1.9900083305560516`, 1.094837581924854}, {0.9950041652780258, 
    0.09983341664682815}}], 
   LineBox[{{1.9601331556824833`, 1.1787359086363027`}, {0.9800665778412416, 
    0.19866933079506122`}}], 
   LineBox[{{1.910672978251212, 1.2508566957869456`}, {0.955336489125606, 
    0.2955202066613396}}], 
   LineBox[{{1.8421219880057702`, 1.3104793363115357`}, {0.9210609940028851, 
    0.3894183423086505}}], 
   LineBox[{{1.7551651237807455`, 1.3570081004945758`}, {0.8775825618903728, 
    0.479425538604203}}], 
   LineBox[{{1.6506712298193564`, 1.3899780883047137`}, {0.8253356149096782, 
    0.5646424733950355}}], 
   LineBox[{{1.5296843745689768`, 1.4090598745221796`}, {0.7648421872844884, 
    0.6442176872376911}}], 
   LineBox[{{1.3934134186943308`, 1.4140628002466882`}, {0.6967067093471654, 
    0.7173560908995228}}], 
   LineBox[{{1.2432199365413288`, 1.4049368778981477`}, {0.6216099682706644, 
    0.7833269096274834}}], 
   LineBox[{{1.0806046117362793`, 1.381773290676036}, {0.5403023058681397, 
    0.8414709848078965}}], 
   LineBox[{{0.9071922428511546, 1.3448034814870127`}, {0.4535961214255773, 
    0.8912073600614354}}], 
   LineBox[{{0.7247155089533468, 1.2943968404438997`}, {0.3623577544766734, 
    0.9320390859672264}}], 
   LineBox[{{0.5349976572491747, 1.2310570140417803`}, {0.26749882862458735`, 
    0.963558185417193}}], 
   LineBox[{{0.33993428580048163`, 1.155416872888701}, {0.16996714290024081`, 
    0.9854497299884603}}], 
   LineBox[{{0.1414744033354058, 1.0682321882717574`}, {0.0707372016677029, 
    0.9974949866040544}}], 
   LineBox[{{-0.05839904460257763, 
    0.9703740807402162}, {-0.029199522301288815`, 0.9995736030415051}}], 
   LineBox[{{-0.2576889885910497, 0.8628203161569437}, {-0.12884449429552486`,
     0.9916648104524686}}], 
   LineBox[{{-0.4544041893861742, 0.7466455361851081}, {-0.2272020946930871, 
    0.9738476308781951}}], 
   LineBox[{{-0.6465791337270071, 0.623010520823911}, {-0.3232895668635036, 
    0.9463000876874145}}], 
   LineBox[{{-0.8322936730942848, 0.4931505902785393}, {-0.4161468365471424, 
    0.9092974268256817}}], 
   LineBox[{{-1.0096922091997151`, 
    0.35836326204901614`}, {-0.5048461045998576, 0.8632093666488737}}], 
   LineBox[{{-1.1770022345106916`, 
    0.21999528656424427`}, {-0.5885011172553458, 0.8084964038195901}}], 
   LineBox[{{-1.3325520425596489`, 0.0794291908968956}, {-0.6662760212798244, 
    0.74570521217672}}], 
   LineBox[{{-1.4747874310824916`, -0.061930534990095154`}, \
{-0.7373937155412458, 0.6754631805511506}}], 
   LineBox[{{-1.6022872310938674`, -0.20267147144297715`}, \
{-0.8011436155469337, 0.5984721441039565}}], 
   LineBox[{{-1.7137775067378946`, -0.34138738154748316`}, \
{-0.8568887533689473, 0.5155013718214642}}], 
   LineBox[{{-1.8081442840341224`, -0.47669226178323143`}, \
{-0.9040721420170612, 0.4273798802338298}}], 
   LineBox[{{-1.8844446813373166`, -0.6072341905127536}, {-0.9422223406686583,
     0.33498815015590466`}}], 
   LineBox[{{-1.9419163302991813`, -0.7317088359356086}, {-0.9709581651495907,
     0.23924932921398198`}}], 
   LineBox[{{-1.9799849932008908`, -0.8488724885405782}, {-0.9899924966004454,
     0.1411200080598672}}], 
   LineBox[{{-1.998270300546559, -0.957554487839989}, {-0.9991351502732795, 
    0.04158066243329049}}], 
   LineBox[{{-1.9965895515895062`, -1.0566689192223333`}, \
{-0.9982947757947531, -0.058374143427580086`}}], 
   LineBox[{{-1.9749595398177298`, -1.1452254640521136`}, \
{-0.9874797699088649, -0.15774569414324865`}}], 
   LineBox[{{-1.9335963851589217`, -1.2223392946062925`}, \
{-0.9667981925794609, -0.25554110202683167`}}], 
   LineBox[{{-1.8729133745815927`, -1.2872399149804161`}, \
{-0.9364566872907963, -0.35078322768961984`}}], 
   LineBox[{{-1.793516832668294, -1.3392788596289995`}, {-0.896758416334147, \
-0.44252044329485246`}}], 
   LineBox[{{-1.696200063420816, -1.3779361726189014`}, {-0.848100031710408, \
-0.5298361409084934}}], 
   LineBox[{{-1.581935423828833, -1.4028256028571358`}, {-0.7909677119144165, \
-0.6118578909427193}}], 
   LineBox[{{-1.4518646084002798`, -1.4136984633841139`}, \
{-0.7259323042001399, -0.6877661591839741}}], 
   LineBox[{{-1.3072872417272239`, -1.4104461161715403`}, \
{-0.6536436208636119, -0.7568024953079282}}], 
   LineBox[{{-1.149647893066537, -1.3931010575976792`}, {-0.5748239465332685, \
-0.8182771110644108}}], 
   LineBox[{{-0.9805216426813989, -1.3618365937542876`}, \
{-0.4902608213406994, -0.8715757724135882}}], 
   LineBox[{{-0.8015983441599509, -1.3169651088294303`}, \
{-0.40079917207997545`, -0.9161659367494549}}], 
   LineBox[{{-0.6146657399568387, -1.2589349438679354`}, \
{-0.30733286997841935`, -0.9516020738895161}}], 
   LineBox[{{-0.4215915988615594, -1.1883259170958766`}, \
{-0.2107957994307797, -0.977530117665097}}], 
   LineBox[{{-0.22430505387010796`, -1.1058435305685186`}, \
{-0.11215252693505398`, -0.9936910036334645}}], 
   LineBox[{{-0.02477732692578112, -1.0123119210269913`}, \
{-0.01238866346289056, -0.9999232575641008}}], 
   LineBox[{{0.17499796687889455`, -0.9086656253963933}, {
    0.08749898343944727, -0.9961646088358406}}], 
   LineBox[{{0.3730247388451515, -0.7959402432017567}, {
    0.18651236942257576`, -0.9824526126243325}}], 
   LineBox[{{0.5673243709264525, -0.6752620891999122}, {
    0.28366218546322625`, -0.9589242746631385}}], 
   LineBox[{{0.7559554854259621, -0.5478369396147511}, {
    0.37797774271298107`, -0.9258146823277321}}], 
   LineBox[{{0.9370333426007542, -0.41493798441977603`}, {
    0.4685166713003771, -0.8834546557201531}}], 
   LineBox[{{1.108748672358323, -0.27789310604473927`}, {
    0.5543743361791615, -0.8322674422239008}}], 
   LineBox[{{1.2693857518852694`, -0.13807161161335246`}, {
    0.6346928759426347, -0.7727644875559871}}], 
   LineBox[{{1.41733954858252, 0.0031294487208680666`}, {
    0.70866977429126, -0.7055403255703919}}], 
   LineBox[{{1.5511317570205003`, 0.14429924063792932`}, {
    0.7755658785102502, -0.6312666378723208}}], 
   LineBox[{{1.6694255696783196`, 0.2840272422415222}, {
    0.8347127848391598, -0.5506855425976376}}], 
   LineBox[{{1.7710390338826387`, 0.4209173375275628}, {
    0.8855195169413194, -0.4646021794137566}}], 
   LineBox[{{1.8549568614880718`, 0.5536017659138}, {
    0.9274784307440359, -0.373876664830236}}], 
   LineBox[{{1.920340573300732, 0.6807547884514401}, {
    0.960170286650366, -0.27941549819892586`}}], 
   LineBox[{{1.9665368768851694`, 0.8011059341704897}, {
    0.9832684384425847, -0.18216250427209502`}}], 
   LineBox[{{1.993084194046435, 0.9134526942057211}, {
    0.9965420970232175, -0.0830894028174964}}], 
   {RGBColor[0, 1, 0], PointSize[Large], PointBox[CompressedData["
1:eJw1hgsw2wccgI1iVOfRlpXi5t1WvO9iVH/UqOLqWW+zmbZDVaauJqOrjZ6x
2s5U0/WMpivWzqMETTx+6LIUY+IVFo8gJPL6pz2pOq623W7f3Xff915qduQF
dTU1NfjHf/sfSvj/Bkwat414BDiOlI80VzCBmpp3m5FEQM+Ej/Ve1hCwdJyn
zCsV4MFi3R7dmIDXdL4oOl8OmZdObHjJZiG8MFHL4bAMlJohueLmRTiUGHTS
Ll0CCX4PTW4ZrkBlTW1kdb4YmEcC06/UCOEC7bPFzJB1GH2Dg1Wb63B0pbLa
S7gKfo3JNA3DDSjX6tB3CF4GhZ7Od9FyCRh+zNF6qr0Anp+QQtnFMhjP965a
dOEB+7wp3X9SDimhxz9tt+BCiAV7O29aARqxB3u+GGCDxvIHS6OlBDRss8Om
zdqgPMvxHlVKgLtxCpu6XoPs0wJO0S4BFZfpm9uF/dhJc+Z1dRNAfcc2THVo
FJWHe4sGjxHQEuDB/L11CmM9TS1NghSgmRMVa0f/CwMZXMmrd+Uw/BNtX7u9
AHdypJBeKwVKU2mI2vQKvs17NOe+tAFCZxcTq8g1tHKOI3HnRVDK/Z7BoomQ
xn2mSqtZg8LyEmKLvoFPhv880GK3CpTNG6/uZ0qxu6Sue/e6AOo1LrY7KGSo
12Bj45rAh1BKbF6LnQL715KtcyjTMOz7gG9sROCkS9DM09oxmFgr6dvXTGDi
dGeWp8Eg2NTHnJG8JtDJgPaVfvBD6Bxhrmi/JNCNJH6fvNqEnfsbHLPvEnhH
r2tY3fU3VO/78Jm6UoG5oXsGQwnjmGI6oJG7JUfLVNZ176szGO84wTjVJsMX
XKW/X+Q8kucKm+jWUvQzc5JlbApQ3Mgvvhe2gXX9sr2YqlUUPfdInfES4Vi7
JclJfR0HbPha9RIhNlvMLzDJYkwjZbio0law9/kKNcpZguacMtmVj5Zw1mh8
6eWqFKO8jSuf1M+hbdlbXt4Rcnw0mFoQ+3gSlQ4BrjevKjDDJy46cWcYb/hy
fORnCCy7FX9Cu7MHWbLkgxF/EOiREe7vlfINRsrI+il7BH7pey7u/MVO2PPR
+7FKQGCacYH9gyUO/Cy1uuZLIXAuOJNSYj8B7ncFqqIWBT5OElYMucwC02r2
aGCdHBUZ5HjS7gLwbFhtpwNkOO+WC9m9y0A26okm7kvw21bb7EthQqBout0p
YIkxaEr75OWmdYht1T039MM6Fut+XZrNFQNDVW0S4y7E428OVG91SKCOQz1L
rl1G+5wGLVKMDIaXKji6PQt4LHz7lKhJDma9+9Noch6qrD7X6WIqoJ/eWvZi
mYsM2tkU4hoBSTvuvCMRHBz7Jd/311UCzEf7+HEBHfg3aMAd2w==
     "]], 
    {RGBColor[1, 0.5, 0], PointBox[CompressedData["
1:eJwtxQlMkwcYgOFyrATFbXIuIk65RRAmZDiur9ERtTpLuBE3WNOKlNsgcm6E
AVZx4JiQEp1HmeUeIJeo4wOcXBIGRCBQwXFZQEvvvxRaui3bm7x5DtCTApm6
JBIJ/vlf/4/yH2LosahWGU9p4eeBG7Gp+RLIpF8paz2vhVtxNq57XkvhiaHr
K6vSbWC5F9Ly9OSwweULgjM0EFZ39HCnUg4BOZFkRzM12OZS9p9tV4Bp5Ekf
+9hN8BwhaiJ8CSj95V5gecYG8PjSr/OKCGByUubiThNQ8ZITQLpPwN6F0nKv
JRkc9k+3uJdJQBG57SNHqgSeGUbRuiwJ2P1tP/mxgRD+ujZQFZCvgNEM71tz
bgIINdybNt0mh6gzThdb9s2Dr7Vw8uIjGeiFmTzL6pkAOt82pjxbClWqF7QJ
y16ILi/lZlpIwN086kXm2wY0obZJvtolguJ4rlyVM4qlGvK5L+68g8wP7WgK
01kMHJe5FCwJoNHfo7OvaQlzzXJ7W0SL8MGloDB77hpeJWjf9Ze8gaG7HP0W
BzHSqx+mxYsmIbmBfZo0IcVoHvvoiOMwLLm6WVgHKlCsgub0kFZgj91sfcJR
Ikn75/vItkbMKSoQKbkqdNObKrSRDGKyPJd4ELeFrNnuy9TpCeTpXWhxXFcj
Jbrq2P68OTyTHHal0X4b43OqmWmJizhEqeSbG2uxzGM3z5ElwPHlgi7937SY
5fZJJXHwHdryQk+sbWjxgJ0L7dSv69j+snPBQKpFfwfnOqsVMbbvrHJOqtBi
YkytaCpQirpd3zzXFW/jviOihy3FMoza06OXqtRgh13JPJsjxwjn8Va/R2qs
oTLrGhMU6Dmd08C12UKfzYlhshGBK9X8/Ns0Ff7hwTimSiFQMOBBn/RS4jm/
2hN5dwnsseWTeWtyfPwgUur6E4EMF5abgiHFj7N4IbZUAq36r79PjBah+9Md
h8yGFBjkbV7azFtFQVChDtVYgbW99OywukW09n+q5NjKkeUbHhy5NYPCqkRD
up4Mr/8YccigfRg/L2Go2c0S9GAFHPeKqkBNubU64YgYv6ecDQ+50Aeiy7qi
QRMhMsyzHSrfTMHOt8frw9JXcZoal1zgsAB9slpfvL2MdeeXigfdVoAhZ4bM
X53HdZZnhItaCN1zPkbhxTP4+kgqJP0ugfauEifS4BjeaLJLiqHJ4WbQZ/eD
63vw5CsDn/gGAkgSG42QGwv5O35gJ41tACWo6TkzvRectneVK9s2wTTBviLX
ZRwcLlWRXULVkK/f7U8Tz8DBAJWfoEEDd1JkRpYd86CwTjfs6NyGsrFPv+wa
WIZWzqkoUZoWZiuyV6u5qzBSk0GpX9SC06iOnY63EP4GrRQZXg==
      "]]}}}]], "Output",
 CellChangeTimes->{
  3.584812282392786*^9, 3.584812364622901*^9, 3.584812459943034*^9, {
   3.584812505353098*^9, 3.584812539023145*^9}, 3.584897359192873*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{970, 630},
WindowMargins->{{Automatic, 32}, {Automatic, 54}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 691, 12, 107, "Subtitle"],
Cell[1273, 36, 366, 7, 86, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1664, 47, 6773, 192, 612, "Input"],
Cell[CellGroupData[{
Cell[8462, 243, 182, 3, 23, "Print"],
Cell[8647, 248, 1627, 44, 36, "Print"]
}, Open  ]],
Cell[10289, 295, 19366, 353, 248, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
