(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     18969,        453]
NotebookOptionsPosition[     18420,        429]
NotebookOutlinePosition[     18763,        444]
CellTagsIndexPosition[     18720,        441]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9},
 FontFamily->"Arial"],

Cell[TextData[{
 StyleBox["Null space",
  FontWeight->"Bold"],
 "\n\nA matrix M maps all vectors of a linear space S of dimension d to \
another liner space S\[CloseCurlyQuote] of dimension d\[CloseCurlyQuote]. \n\
Which vectors of S are mapped to the zero vector by M? \nThose are vectors of \
a (d - d') - dimensional space N, called the null space of M. \n"
}], "Subsubtitle",
 CellChangeTimes->{{3.5848220914830456`*^9, 3.5848221205530863`*^9}, {
  3.58482217332316*^9, 3.5848222129032154`*^9}, {3.58482225193327*^9, 
  3.584822262733285*^9}, {3.584882597976875*^9, 3.5848825993028774`*^9}}],

Cell[CellGroupData[{

Cell["\<\
3x3 rank 2 matrix: 1D null space \
\>", "Section",
 CellChangeTimes->{{3.584882505702713*^9, 3.5848825805672445`*^9}}],

Cell["\<\
Contruct a 3 x 3 matrix based on two vectors mm1 and mm2: 
[mm1  mm2   r*mm1 + s*mm2]\
\>", "Text",
 CellChangeTimes->{{3.584882706381465*^9, 3.5848828078908434`*^9}, {
  3.584896251391322*^9, 3.5848962613313365`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"aa", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], ";", " ", 
    RowBox[{"(*", "  ", "green", " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"bb", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], ";", " ", 
    RowBox[{"(*", "  ", "green", " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"cc", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ";"}], " ", 
   RowBox[{"(*", "  ", "green", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Two", " ", 
     RowBox[{"vectors", " ", "--"}], " ", "two", " ", "columns", " ", "of", 
     " ", "the", " ", "matrix"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"mm1", "=", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"mm2", "=", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], ";"}], 
    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mm1", "=", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mm2", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0.5"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "create", " ", "a", " ", "reasonable", " ", "size", " ", "of", " ", "the",
      " ", "viewing", " ", "area"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"range", "=", 
     RowBox[{"Max", "[", 
      RowBox[{
       RowBox[{"Norm", "[", "aa", "]"}], ",", 
       RowBox[{"Norm", "[", "bb", "]"}], ",", 
       RowBox[{"Norm", "[", "cc", "]"}], ",", 
       RowBox[{"Norm", "[", "mm1", "]"}], ",", 
       RowBox[{"Norm", "[", "mm2", "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"graphics", " ", "entities", " ", "for", " ", "the", " ", "a"}], 
     ",", "b", ",", 
     RowBox[{"c", " ", "vectors"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"arrowaa", "=", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "aa"}], "}"}], 
        "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"arrowbb", " ", "=", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "bb"}], "}"}], 
        "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"arrowcc", " ", "=", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "cc"}], "}"}], 
        "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{
      "for", " ", "linearly", " ", "independent", " ", "mm13", " ", "and", 
       " ", "m23"}], ",", " ", 
      RowBox[{"mmat", " ", "has", " ", "rank", " ", "2"}]}], " ", "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"mm", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{"mm1", ",", "mm2", ",", " ", 
         RowBox[{
          RowBox[{"r", "*", "mm1"}], " ", "+", 
          RowBox[{"s", "*", "mm2"}]}]}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"mmat", "=", " ", 
       RowBox[{"Transpose", "[", "mm", "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"get", " ", "null", " ", 
        RowBox[{"space", ":", " ", 
         RowBox[{
         "Mathematica", " ", "returns", " ", "a", " ", "matrix", " ", "of", 
          " ", "elements"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"nn", "=", 
       RowBox[{"NullSpace", "[", "mmat", "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"map", " ", "vectors", " ", "a"}], ",", "b", ",", 
        RowBox[{
        "c", " ", "by", " ", "the", " ", "rank", " ", "deficient", " ", 
         "matrix"}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"mapa", "=", 
       RowBox[{"mmat", ".", "aa"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"mapb", "=", 
       RowBox[{"mmat", ".", "bb"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"mapc", "=", 
       RowBox[{"mmat", ".", "cc"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "graphics", " ", "entities", " ", "for", " ", "the", " ", "v", "*", 
        " ", "vectors"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"arrowrsa", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "mapa"}], "}"}], 
          "]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"arrowrsb", " ", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "mapb"}], "}"}], 
          "]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"arrowrsc", " ", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "mapc"}], "}"}], 
          "]"}]}], "}"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"null", " ", 
        RowBox[{"space", " ", "--"}], " ", "in", " ", "this", " ", "case", 
        " ", "represented", " ", "by", " ", "a", " ", 
        RowBox[{"vector", " ", "--"}], "  ", "will", " ", "be", " ", 
        "displayed", " ", "as", " ", "a", " ", "tube", " ", "arrow"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"arrownn", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Arrowheads", "[", ".06", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"Tube", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
              RowBox[{"nn", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", ".005"}], "]"}], 
          "]"}]}], "}"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Graphics3D", "[", 
       RowBox[{
        RowBox[{"{", " ", 
         RowBox[{
          RowBox[{"Arrowheads", "[", ".06", "]"}], ",", "Thick", ",", 
          "\[IndentingNewLine]", "arrowaa", ",", " ", "arrowbb", ",", " ", 
          "arrowcc", ",", "arrownn", ",", "\[IndentingNewLine]", "Red", ",", 
          " ", "arrowrsa", ",", "arrowrsb", ",", "arrowrsc", ",", 
          "\[IndentingNewLine]", "LightRed", ",", 
          RowBox[{"Opacity", "[", "0.5", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Polygon", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "mapa", ",", 
             "mapb", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Polygon", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "mapa", ",", 
             "mapc", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Polygon", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "mapb", ",", 
             "mapc", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}]}], 
         "}"}], ",", 
        RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"MatrixForm", "[", "mmat", "]"}], ",", "15"}], "]"}]}], 
        ",", " ", 
        RowBox[{"PlotRange", "\[Rule]", "range"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", "0.333"}], "}"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", "0.333"}], "}"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\>\"", ",", "\"\< \>\"", ",", "\"\<Null space: tube vector\>\"", 
        ",", "\"\< \>\""}], "}"}]}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5848223031033416`*^9, 3.5848224192135043`*^9}, {
   3.584822454843554*^9, 3.5848226499258356`*^9}, {3.584822696545901*^9, 
   3.5848226971259017`*^9}, {3.5848229586362677`*^9, 
   3.5848229826063013`*^9}, {3.5848230832364426`*^9, 
   3.5848231969066014`*^9}, {3.584823326816783*^9, 3.584823373246848*^9}, {
   3.5848236436572266`*^9, 3.584823705007313*^9}, {3.584823774927411*^9, 
   3.5848237842074237`*^9}, 3.5848238962175803`*^9, {3.5848239679976807`*^9, 
   3.58482397434769*^9}, {3.5848240644678164`*^9, 3.584824111627882*^9}, {
   3.584825065273221*^9, 3.5848250755232353`*^9}, {3.584825151073341*^9, 
   3.5848251516833415`*^9}, 3.584825201493411*^9, {3.5848253187435756`*^9, 
   3.584825441883748*^9}, {3.5848254865738106`*^9, 3.584825547523896*^9}, {
   3.5848256308040123`*^9, 3.5848256314740133`*^9}, {3.5848826713594036`*^9, 
   3.58488269187344*^9}, {3.5848828108392487`*^9, 3.5848829224262447`*^9}, {
   3.5848829775099416`*^9, 3.584883001346783*^9}, {3.5848830383812485`*^9, 
   3.5848831278630056`*^9}, {3.584883166098673*^9, 3.584883264675246*^9}, 
   3.5848833004305086`*^9, {3.584883357635809*^9, 3.5848833723310347`*^9}, {
   3.5848834466339655`*^9, 3.58488346064279*^9}, {3.584883569858582*^9, 
   3.584883596175828*^9}, {3.584883638311502*^9, 3.5848836532875285`*^9}, {
   3.584883863747498*^9, 3.5848838723119135`*^9}, {3.5848839465992436`*^9, 
   3.584883951856453*^9}, 3.584884292888652*^9, {3.584884450199328*^9, 
   3.5848844582489424`*^9}, {3.5848957414106083`*^9, 3.584895781600665*^9}, {
   3.5848958249507256`*^9, 3.584895870020788*^9}, {3.584895917440855*^9, 
   3.584895974710935*^9}, {3.584896176851218*^9, 3.5848961775412188`*^9}, {
   3.58489628552137*^9, 3.5848962963713856`*^9}, {3.584896333831438*^9, 
   3.584896344101452*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`r$$ = 0.7650000000000001, $CellContext`s$$ =
     0.22999999999999998`, Typeset`show$$ = True, Typeset`bookmarkList$$ = {},
     Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`r$$], 0.333}, -1, 1}, {{
       Hold[$CellContext`s$$], 0.333}, -1, 1}}, Typeset`size$$ = {
    346., {214., 218.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`r$70886$$ = 
    0, $CellContext`s$70887$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`r$$ = 0.333, $CellContext`s$$ = 0.333}, 
      "ControllerVariables" :> {
        Hold[$CellContext`r$$, $CellContext`r$70886$$, 0], 
        Hold[$CellContext`s$$, $CellContext`s$70887$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`mm = {$CellContext`mm1, $CellContext`mm2, \
$CellContext`r$$ $CellContext`mm1 + $CellContext`s$$ $CellContext`mm2}; \
$CellContext`mmat = Transpose[$CellContext`mm]; $CellContext`nn = 
        NullSpace[$CellContext`mmat]; $CellContext`mapa = 
        Dot[$CellContext`mmat, $CellContext`aa]; $CellContext`mapb = 
        Dot[$CellContext`mmat, $CellContext`bb]; $CellContext`mapc = 
        Dot[$CellContext`mmat, $CellContext`cc]; $CellContext`arrowrsa = {
          Arrowheads[Large], 
          Arrow[{{0, 0, 0}, $CellContext`mapa}]}; $CellContext`arrowrsb = {
          Arrowheads[Large], 
          Arrow[{{0, 0, 0}, $CellContext`mapb}]}; $CellContext`arrowrsc = {
          Arrowheads[Large], 
          Arrow[{{0, 0, 0}, $CellContext`mapc}]}; $CellContext`arrownn = {
          Arrowheads[0.06], 
          Arrow[
           Tube[{{0, 0, 0}, 
             Part[$CellContext`nn, 1]}, 0.005]]}; Graphics3D[{
          Arrowheads[0.06], 
          Thick, $CellContext`arrowaa, $CellContext`arrowbb, \
$CellContext`arrowcc, $CellContext`arrownn, 
          Red, $CellContext`arrowrsa, $CellContext`arrowrsb, \
$CellContext`arrowrsc, LightRed, 
          Opacity[0.5], 
          
          Polygon[{{0, 0, 0}, $CellContext`mapa, $CellContext`mapb, {0, 0, 
            0}}], 
          
          Polygon[{{0, 0, 0}, $CellContext`mapa, $CellContext`mapc, {0, 0, 
            0}}], 
          
          Polygon[{{0, 0, 0}, $CellContext`mapb, $CellContext`mapc, {0, 0, 
            0}}]}, Boxed -> False, PlotLabel -> Style[
           MatrixForm[$CellContext`mmat], 15], 
         PlotRange -> $CellContext`range]), 
      "Specifications" :> {{{$CellContext`r$$, 0.333}, -1, 
         1}, {{$CellContext`s$$, 0.333}, -1, 1}}, 
      "Options" :> {FrameLabel -> {"", " ", "Null space: tube vector", " "}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{419., {296., 301.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.584822652115839*^9, 3.5848226986759043`*^9, 3.584823018686352*^9, {
   3.5848231158764877`*^9, 3.5848231446665287`*^9}, 3.584823264136696*^9, {
   3.584823341316804*^9, 3.584823375816852*^9}, 3.584823730337348*^9, 
   3.584823785947426*^9, {3.584823955187663*^9, 3.5848239755176916`*^9}, 
   3.584824115067887*^9, 3.5848250768232365`*^9, 3.584825154523346*^9, 
   3.5848252032734137`*^9, 3.584825345333613*^9, {3.5848254143037095`*^9, 
   3.58482544336375*^9}, {3.584825525573865*^9, 3.5848255488138976`*^9}, 
   3.584825632454015*^9, 3.5848825916900635`*^9, {3.5848832468912144`*^9, 
   3.584883265829648*^9}, 3.584883410473102*^9, 3.5848834755720167`*^9, 
   3.5848835982506313`*^9, 3.584883666219951*^9, 3.58488387622752*^9, 
   3.5848839533696556`*^9, 3.5848843006106653`*^9, 3.5848844603237457`*^9, 
   3.584895782680666*^9, 3.584895872730792*^9, 3.584895922280862*^9, 
   3.584895976790938*^9, 3.5848961785812206`*^9, 3.5848962972313867`*^9, 
   3.584896358061472*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{997, 697},
WindowMargins->{{Automatic, 23}, {Automatic, 10}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 691, 12, 107, "Subtitle"],
Cell[1273, 36, 595, 10, 124, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1893, 50, 128, 3, 71, "Section"],
Cell[2024, 55, 228, 5, 45, "Text"],
Cell[CellGroupData[{
Cell[2277, 64, 11679, 273, 1132, "Input"],
Cell[13959, 339, 4421, 85, 614, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
