(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    182949,       3699]
NotebookOptionsPosition[    180791,       3626]
NotebookOutlinePosition[    181135,       3641]
CellTagsIndexPosition[    181092,       3638]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 "\n"
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
  3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
  3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
  3.5842134956497355`*^9, 3.5842135862546945`*^9}},
 FontFamily->"Arial"],

Cell[TextData[{
 "\n",
 StyleBox["Principal Components Analysis",
  FontWeight->"Bold"],
 "\nInput a set of 2D data points (dataraw).\nMean adjust the data and create \
the covariance matrix based on the data (L).\nL is symmetric and positive \
definite.\nThe eigenvectors are used to axis-align the data so the coordinate \
data corresponds to the trend lines. The eigenvectors form the principal \
axes.\nData compression is demonstrated by removing one of the dimensions of \
the data.\nThe quadratic form of L  is displayed."
}], "Subsubtitle",
 CellChangeTimes->{{3.5629609749859915`*^9, 3.562960993986825*^9}, {
  3.5843842211677895`*^9, 3.584384241187817*^9}, {3.58438552140961*^9, 
  3.5843855877097034`*^9}, {3.5843857066398697`*^9, 3.584385715049882*^9}, {
  3.5843863240207343`*^9, 3.5843863274007387`*^9}, {3.5843865877911034`*^9, 
  3.5843866042211266`*^9}, {3.584386637091172*^9, 3.5843866920812497`*^9}, {
  3.5843867406913176`*^9, 3.5843868215014305`*^9}, {3.5843880375731335`*^9, 
  3.584388065453172*^9}}],

Cell[CellGroupData[{

Cell["\<\

Initialize\
\>", "Section",
 CellChangeTimes->{{3.584384308097911*^9, 3.5843843141879196`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetOptions", "[", 
     RowBox[{"Graphics", ",", 
      RowBox[{"BaseStyle", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontFamily", "->", "\"\<Helvetica\>\""}], ",", " ", 
         RowBox[{"FontSize", "\[Rule]", "14"}]}], "}"}]}]}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.56296104822812*^9, 3.562961048820921*^9}, {
   3.563294498799999*^9, 3.563294503698408*^9}, 3.563296025242427*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

Quadratic Form routine\
\>", "Section",
 CellChangeTimes->{{3.5843842692978563`*^9, 3.5843842844378777`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "matrix", " ", "must", " ", "be", " ", "a", " ", "2", "x2", " ", 
    "matrix"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"quadform", "[", 
     RowBox[{"matrix_", ",", "x_", ",", "y_"}], "]"}], " ", ":=", " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ".", "matrix", ".", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.5629610336576943`*^9, 3.5629610374641013`*^9}, {
  3.584384264097849*^9, 3.5843842670378532`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Select a  2D data set  (Load into dataraw)\
\>", "Section",
 CellChangeTimes->{{3.5629610747481666`*^9, 3.5629610907537947`*^9}, {
  3.5629613382482295`*^9, 3.562961365189477*^9}, {3.5843843317679443`*^9, 
  3.584384332637945*^9}, {3.5843856047297273`*^9, 3.5843856364997716`*^9}, {
  3.5843880870932026`*^9, 3.5843880875932035`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"===", "===", "===", 
    RowBox[{"\[Equal]", " ", 
     RowBox[{
     "Pick", " ", "a", " ", "dataset", "*", " ", "and", " ", "load", " ", 
      "into", " ", "dataraw", " ", "below"}]}], " ", "===", "===", "===", "===",
     "==="}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"These", " ", "are", " ", "sample", " ", 
    RowBox[{"(", 
     RowBox[{"x", ",", "y"}], ")"}], " ", "data", " ", "sets"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dataset1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "4"}], ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataset2", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "^", "i"}], "*", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "20"}], "}"}]}], "]"}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataset3", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2.5", ",", "2.4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5", ",", "0.7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.2", ",", "2.9"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.9", ",", "2.2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3.1", ",", "3.0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2.3", ",", "2.7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1.6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1.1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.5", ",", "1.6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.1", ",", "0.9"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "data", " ", "set", " ", "for", " ", "example", " ", "in", " ", "pla"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"num", " ", "=", " ", "30"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"span", " ", "=", " ", "8"}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"0", " ", "to", " ", "4", 
      RowBox[{"Pi", " ", "--"}], " ", "how", " ", "many", " ", 
      "osscilations"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"alpha", " ", "=", " ", "0.5"}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"height", " ", "of", " ", "first", " ", "fct"}], " ", "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"beta", " ", "=", " ", "8"}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"height", " ", "of", " ", "second", " ", "fct"}], " ", "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"eps", " ", "=", " ", 
     RowBox[{"alpha", "/", "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataset4", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "num"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"t", " ", "=", " ", 
        RowBox[{"i", "/", "num"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"i", "<", 
          RowBox[{"num", "/", "2"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"dataset4", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "1"}], "]"}], "]"}], "=", "i"}], ";", " ", 
           RowBox[{
            RowBox[{"dataset4", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
            RowBox[{"alpha", "*", 
             RowBox[{"Sin", "[", 
              RowBox[{"t", "*", "span", "*", "Pi"}], "]"}]}]}], ";", " ", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"OddQ", "[", "i", "]"}], ",", 
             RowBox[{
              RowBox[{"dataset4", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "2"}], "]"}], "]"}], " ", "=", " ", 
              RowBox[{
               RowBox[{"dataset4", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "2"}], "]"}], "]"}], " ", "-", " ", 
               "eps"}]}]}], "]"}]}], ")"}], ",", "\[IndentingNewLine]", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"dataset4", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "1"}], "]"}], "]"}], "=", 
            RowBox[{"num", "-", "i"}]}], ";", " ", 
           RowBox[{
            RowBox[{"dataset4", "[", 
             RowBox[{"[", 
              RowBox[{"i", ",", "2"}], "]"}], "]"}], "=", 
            RowBox[{"beta", " ", "*", 
             RowBox[{"Sin", "[", 
              RowBox[{"t", "*", "span", "*", "Pi"}], "]"}]}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"OddQ", "[", "i", "]"}], ",", " ", 
             RowBox[{
              RowBox[{"dataset4", "[", 
               RowBox[{"[", 
                RowBox[{"i", ",", "1"}], "]"}], "]"}], " ", "=", " ", 
              RowBox[{
               RowBox[{"dataset4", "[", 
                RowBox[{"[", 
                 RowBox[{"i", ",", "1"}], "]"}], "]"}], " ", "+", " ", 
               RowBox[{"t", "/", "4"}]}]}]}], "]"}]}], ")"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "num"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataset5", " ", "=", " ", 
     StyleBox[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0.2586492190255054`", ",", 
          RowBox[{"-", "0.24982020398969373`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.24195063915894233`", ",", "0.4177285410261078`"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.16222559872708464`"}], ",", "0.873256667081868`"}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.6364862116578429`"}], ",", "0.34132814074209206`"}],
          "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.20542824345058763`"}], ",", 
          RowBox[{"-", "0.5919132891026786`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.5184193551100265`"}], ",", 
          RowBox[{"-", "0.2958374862545301`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.3610299946042095`"}], ",", 
          RowBox[{"-", "0.9837605315323228`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.931198398794101`"}], ",", 
          RowBox[{"-", "1.0342244779351786`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.03901433907598939`"}], ",", 
          RowBox[{"-", "0.7784886706713943`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.08287091200739916`"}], ",", 
          RowBox[{"-", "0.4911539090939807`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.8010838318737261`"}], ",", 
          RowBox[{"-", "1.1286849812994695`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.3181487992370489`"}], ",", 
          RowBox[{"-", "1.265095119410212`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2.217561747001315`"}], ",", 
          RowBox[{"-", "2.225399822195609`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.222135019884535`"}], ",", 
          RowBox[{"-", "2.856990313699244`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.5576919394647883`"}], ",", 
          RowBox[{"-", "3.536640783248112`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.6115191343860502`"}], ",", 
          RowBox[{"-", "2.601707245188453`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.03343673550537307`"}], ",", 
          RowBox[{"-", "2.178822189104959`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.5644598531078024`", ",", 
          RowBox[{"-", "2.481247854480976`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.3612104166088237`", ",", 
          RowBox[{"-", "1.719486672180596`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.4727230239437934`", ",", 
          RowBox[{"-", "2.1564524726501073`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.20669019770139396`", ",", 
          RowBox[{"-", "2.0342247562223554`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1.0769334472941452`", ",", 
          RowBox[{"-", "1.1308962422890985`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.7880105442823702`", ",", 
          RowBox[{"-", "0.6375035959772797`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.8745888860464461`", ",", 
          RowBox[{"-", "0.6746091098268372`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1.5876496622635443`", ",", 
          RowBox[{"-", "1.3746302537334278`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.7671188901011226`", ",", 
          RowBox[{"-", "0.7170425910198066`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.577665386294282`", ",", "0.20608228539508122`"}], "}"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.21158686864883292`"}], ",", 
          RowBox[{"-", "0.7786299985841536`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.1995201236430968`"}], ",", 
          RowBox[{"-", "1.1141119454752553`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.1289116208805776`"}], ",", 
          RowBox[{"-", "1.588060659539158`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.8551479263692938`"}], ",", 
          RowBox[{"-", "1.5882307379049463`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.17676982915670125`"}], ",", 
          RowBox[{"-", "2.0858857774046102`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.955970149670629`"}], ",", 
          RowBox[{"-", "1.5313028321758573`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.187577545670488`"}], ",", 
          RowBox[{"-", "1.674413763152916`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.14910063557042896`"}], ",", 
          RowBox[{"-", "1.9169703247718526`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.9576209850385107`"}], ",", 
          RowBox[{"-", "2.9131908339504564`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.806919205697715`"}], ",", 
          RowBox[{"-", "3.2809577118232833`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2.330758903611346`"}], ",", 
          RowBox[{"-", "4.204006901458898`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.8837551257902896`"}], ",", 
          RowBox[{"-", "4.600229434793662`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2.5243125692315282`"}], ",", 
          RowBox[{"-", "4.607473215915704`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3.1750208538335842`"}], ",", 
          RowBox[{"-", "4.894153659565937`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "3.0205865436615182`"}], ",", 
          RowBox[{"-", "4.06950303994598`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2.2810772316814933`"}], ",", 
          RowBox[{"-", "4.777445439320624`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2.776919606734547`"}], ",", 
          RowBox[{"-", "5.29627340568657`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2.291365974264228`"}], ",", 
          RowBox[{"-", "5.25641578217145`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2.4307125833910925`"}], ",", 
          RowBox[{"-", "6.246148523440047`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2.1254047676092025`"}], ",", 
          RowBox[{"-", "6.2890388071963175`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2.397222167431219`"}], ",", 
          RowBox[{"-", "6.2010651464761395`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2.5077258755926266`"}], ",", 
          RowBox[{"-", "6.08164880917676`"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2.4867820803224547`"}], ",", 
          RowBox[{"-", "6.488820145528062`"}]}], "}"}]}], "}"}],
      FontSize->9]}], 
    StyleBox[";",
     FontSize->9]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataset6", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   StyleBox[
    RowBox[{
     StyleBox[
      RowBox[{"(", "*"}]], " ", 
     RowBox[{
     "load", " ", "one", " ", "of", " ", "the", " ", "data", " ", "sets", " ",
       "above", " ", "into", " ", "dataraw"}], " ", 
     StyleBox[
      RowBox[{"*", ")"}]]}],
    FontSize->9], 
   StyleBox["\[IndentingNewLine]",
    FontSize->9], 
   RowBox[{
    RowBox[{"dataraw", " ", "=", " ", "dataset5"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5629611077110243`*^9, 3.5629611083506255`*^9}, {
   3.5629613274374104`*^9, 3.5629613337398214`*^9}, {3.562961382396307*^9, 
   3.5629613843619103`*^9}, {3.5629616592655935`*^9, 
   3.5629617369381294`*^9}, {3.5629618952160077`*^9, 3.562961895309608*^9}, {
   3.5629622527998357`*^9, 3.562962252924636*^9}, {3.5632234617686186`*^9, 
   3.5632234734218397`*^9}, {3.5632783802654886`*^9, 
   3.5632783984083204`*^9}, {3.5632790449006367`*^9, 3.563279279543022*^9}, {
   3.5632793767847843`*^9, 3.5632793908544073`*^9}, {3.563279559900692*^9, 
   3.5632796079843664`*^9}, {3.563279639035617*^9, 3.5632796706524715`*^9}, {
   3.5632797153549433`*^9, 3.5632797181473484`*^9}, {3.5632797491421995`*^9, 
   3.5632797567390127`*^9}, {3.563279819402314*^9, 3.563279838814746*^9}, {
   3.563279932471696*^9, 3.5632801101335945`*^9}, {3.563280140451641*^9, 
   3.563280147131652*^9}, {3.563280192720522*^9, 3.5632803101399045`*^9}, {
   3.5632803684087863`*^9, 3.563280404648837*^9}, {3.5632804354496803`*^9, 
   3.5632804554205093`*^9}, 3.563280503616977*^9, {3.563280614177532*^9, 
   3.5632806203723416`*^9}, {3.5632806526575875`*^9, 3.563280738126107*^9}, {
   3.563280787767377*^9, 3.563280796448989*^9}, {3.563286259312584*^9, 
   3.563286286565832*^9}, {3.5632878020302176`*^9, 3.563287802981819*^9}, {
   3.563287909405206*^9, 3.5632879264404364`*^9}, {3.5632879682485094`*^9, 
   3.563287972304517*^9}, {3.563288020227801*^9, 3.5632880382302322`*^9}, {
   3.563293054296923*^9, 3.563293055229325*^9}, {3.563295119325369*^9, 
   3.5632951195553694`*^9}, {3.5632959034118233`*^9, 
   3.5632959631227226`*^9}, {3.5633004214433136`*^9, 3.563300421493314*^9}, {
   3.5633005614083257`*^9, 3.5633005615083256`*^9}, {3.5633006042999873`*^9, 
   3.563300604399987*^9}, {3.5635542314485016`*^9, 3.5635544568844976`*^9}, {
   3.5635546492328353`*^9, 3.56355465193164*^9}, {3.5635546954245167`*^9, 
   3.563554722428164*^9}, {3.563554785421075*^9, 3.56355478872828*^9}, {
   3.563554827322748*^9, 3.5635548348731613`*^9}, {3.5635549031388817`*^9, 
   3.563554927272124*^9}, {3.5639048246387587`*^9, 3.5639048711268406`*^9}, {
   3.563905198883416*^9, 3.563905213703442*^9}, {3.5639053146824193`*^9, 
   3.5639053173812237`*^9}, {3.5639053564436927`*^9, 3.563905359204898*^9}, {
   3.5639054998235445`*^9, 3.5639055030371504`*^9}, {3.5647751646368093`*^9, 
   3.56477516513601*^9}, {3.570201025057173*^9, 3.5702010262427745`*^9}, {
   3.570201066366045*^9, 3.570201066522045*^9}, {3.5843843642079897`*^9, 
   3.58438436463799*^9}, {3.5843843964880342`*^9, 3.5843844671681337`*^9}, {
   3.5843845018481817`*^9, 3.5843845442882414`*^9}, {3.5843847897085853`*^9, 
   3.584384790428586*^9}, {3.584386841011458*^9, 3.584386841071458*^9}, {
   3.584388103283225*^9, 3.584388117403245*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Mean adjust data and create covariance matrix 
(Also: create additional copies of data for plotting purposes )\
\>", "Section",
 CellChangeTimes->{{3.5843844812781534`*^9, 3.584384494218171*^9}, {
  3.5843849664088326`*^9, 3.5843849945288715`*^9}, {3.5843856622998075`*^9, 
  3.5843856685498166`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "translate", " ", "data", " ", "so", " ", "the", " ", "centroid", " ", 
    "is", " ", "at", " ", "the", " ", "origin"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"numdata", " ", "=", 
     RowBox[{"Length", "[", "dataraw", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"\"\<numdata = \>\"", ",", "numdata"}], "]"}], ";"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"centroid", " ", "=", " ", 
     RowBox[{
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{"dataraw", "[", 
         RowBox[{"[", "i", "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "numdata"}], "}"}]}], "]"}], "/", 
      "numdata"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"data", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"dataraw", "[", 
         RowBox[{"[", "i", "]"}], "]"}], " ", "-", " ", "centroid"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numdata"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Mean adjusted data = \>\"", ",", 
       RowBox[{
        RowBox[{"MatrixForm", "[", "data", "]"}], "//", "N"}]}], "]"}], ";"}],
     " ", "*)"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "map", " ", "the", " ", "data", " ", "into", " ", "3", "D", " ", "by", 
      " ", "adding", " ", "z"}], "=", 
     RowBox[{"0", " ", "coordinate"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "This", " ", "is", " ", "for", " ", "plotting", " ", "the", " ", "data", 
     " ", "with", " ", "the", " ", "3", "d", " ", "quadratic", " ", "form"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"data3d", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"data", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
         RowBox[{"data", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numdata"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "version", " ", "of", " ", "data", " ", "all", " ", "in", 
     " ", "quadrant", " ", 
     RowBox[{"I", " ", "--"}], " ", "to", " ", "pretend", " ", "this", " ", 
     "is", " ", "a", " ", "scatter", " ", "plot", " ", "where", " ", "only", 
     " ", "positive", " ", "values", " ", "would", " ", "be", " ", 
     "meaningful"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "This", " ", "is", " ", "just", " ", "for", " ", "a", " ", "figure", " ", 
     "for", " ", "PLA"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"minx", " ", "=", " ", 
     RowBox[{"data", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"miny", " ", "=", " ", 
     RowBox[{"data", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eps", " ", "=", " ", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"data", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "1"}], "]"}], "]"}], " ", "<", " ", "minx"}], 
         ",", 
         RowBox[{"minx", " ", "=", " ", 
          RowBox[{"data", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "1"}], "]"}], "]"}]}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"data", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2"}], "]"}], "]"}], " ", "<", " ", "miny"}], 
         ",", 
         RowBox[{"miny", " ", "=", " ", 
          RowBox[{"data", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2"}], "]"}], "]"}]}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"i", ",", "2", ",", "numdata"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"minx", " ", "=", " ", 
     RowBox[{"minx", " ", "-", " ", "eps"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"miny", " ", "=", " ", 
     RowBox[{"miny", " ", "-", " ", "eps"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"datapos", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"data", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "1"}], "]"}], "]"}], " ", "-", " ", "minx"}], 
         ",", " ", 
         RowBox[{
          RowBox[{"data", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "2"}], "]"}], "]"}], " ", "-", " ", "miny"}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numdata"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Form", " ", "covariance", " ", "matrix"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"L", "=", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"Transpose", "[", "data", "]"}], ".", "data"}], "//", "N"}]}], 
    ";"}], " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Since", " ", "we", " ", "are", " ", "dealing", " ", "with", " ", "the", 
      " ", "entire", " ", "\"\<population\>\"", " ", "and", " ", "not", " ", 
      "just", " ", "a", " ", "sample"}], ",", " ", 
     RowBox[{
     "we", " ", "divide", " ", "by", " ", "the", " ", "number", " ", "of", 
      " ", "data"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"L", " ", "=", " ", 
     RowBox[{"L", "/", "numdata"}]}], ";"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Covariance matrix = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "L", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.5629611077110243`*^9, 3.5629611083506255`*^9}, {
   3.5629613274374104`*^9, 3.5629613337398214`*^9}, {3.562961382396307*^9, 
   3.5629613843619103`*^9}, {3.5629616592655935`*^9, 
   3.5629617369381294`*^9}, {3.5629618952160077`*^9, 3.562961895309608*^9}, {
   3.5629622527998357`*^9, 3.562962252924636*^9}, {3.5632234617686186`*^9, 
   3.5632234734218397`*^9}, {3.5632783802654886`*^9, 
   3.5632783984083204`*^9}, {3.5632790449006367`*^9, 3.563279279543022*^9}, {
   3.5632793767847843`*^9, 3.5632793908544073`*^9}, {3.563279559900692*^9, 
   3.5632796079843664`*^9}, {3.563279639035617*^9, 3.5632796706524715`*^9}, {
   3.5632797153549433`*^9, 3.5632797181473484`*^9}, {3.5632797491421995`*^9, 
   3.5632797567390127`*^9}, {3.563279819402314*^9, 3.563279838814746*^9}, {
   3.563279932471696*^9, 3.5632801101335945`*^9}, {3.563280140451641*^9, 
   3.563280147131652*^9}, {3.563280192720522*^9, 3.5632803101399045`*^9}, {
   3.5632803684087863`*^9, 3.563280404648837*^9}, {3.5632804354496803`*^9, 
   3.5632804554205093`*^9}, 3.563280503616977*^9, {3.563280614177532*^9, 
   3.5632806203723416`*^9}, {3.5632806526575875`*^9, 3.563280738126107*^9}, {
   3.563280787767377*^9, 3.563280796448989*^9}, {3.563286259312584*^9, 
   3.563286286565832*^9}, {3.5632878020302176`*^9, 3.563287802981819*^9}, {
   3.563287909405206*^9, 3.5632879264404364`*^9}, {3.5632879682485094`*^9, 
   3.563287972304517*^9}, {3.563288020227801*^9, 3.5632880382302322`*^9}, {
   3.563293054296923*^9, 3.563293055229325*^9}, {3.563295119325369*^9, 
   3.5632951195553694`*^9}, {3.5632959034118233`*^9, 
   3.5632959631227226`*^9}, {3.5633004214433136`*^9, 3.563300421493314*^9}, {
   3.5633005614083257`*^9, 3.5633005615083256`*^9}, {3.5633006042999873`*^9, 
   3.563300604399987*^9}, {3.5635542314485016`*^9, 3.5635544568844976`*^9}, {
   3.5635546492328353`*^9, 3.56355465193164*^9}, {3.5635546954245167`*^9, 
   3.563554722428164*^9}, {3.563554785421075*^9, 3.56355478872828*^9}, {
   3.563554827322748*^9, 3.5635548348731613`*^9}, {3.5635549031388817`*^9, 
   3.563554927272124*^9}, {3.5639048246387587`*^9, 3.5639048711268406`*^9}, {
   3.563905198883416*^9, 3.563905213703442*^9}, {3.5639053146824193`*^9, 
   3.5639053173812237`*^9}, {3.5639053564436927`*^9, 3.563905359204898*^9}, {
   3.5639054998235445`*^9, 3.5639055030371504`*^9}, {3.5647751646368093`*^9, 
   3.56477516513601*^9}, {3.570201025057173*^9, 3.5702010262427745`*^9}, {
   3.570201066366045*^9, 3.570201066522045*^9}, {3.5843843642079897`*^9, 
   3.58438436463799*^9}, {3.5843843964880342`*^9, 3.5843844671681337`*^9}, {
   3.584384574988284*^9, 3.584384708948472*^9}, {3.5843848706086984`*^9, 
   3.584384922718771*^9}, {3.584385691649849*^9, 3.5843856945498533`*^9}, 
   3.584385733379907*^9, {3.5843868821215153`*^9, 3.584386886371522*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Covariance matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.4721248955528696`", "1.9133624428999825`"},
       {"1.9133624428999825`", "3.9845724521912214`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Covariance matrix = ", 
   MatrixForm[{{1.4721248955528696`, 1.9133624428999825`}, {
    1.9133624428999825`, 3.9845724521912214`}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.56390532081323*^9, 3.563905362870904*^9, 
  3.563905505876355*^9, 3.563905783525643*^9, 3.5647751277271447`*^9, 
  3.564775168318416*^9, 3.570200732832661*^9, 3.5702009634682646`*^9, 
  3.5702010296435804`*^9, 3.570201071420454*^9, 3.5843845513582516`*^9, 
  3.584384793768591*^9, 3.5843857365799117`*^9, 3.5843868451614637`*^9, 
  3.5843868912815285`*^9, 3.5843869423316*^9, 3.5843879135529594`*^9, 
  3.584388300313501*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[Cell["\<\
L is covariance matrix: Get eigenvalues and eigenvectors\
\>", "Subsubsection",
  CellChangeTimes->{{3.558012896554343*^9, 
   3.5580129159615765`*^9}}]], "Section",
 CellChangeTimes->{{3.5629611417970843`*^9, 3.562961142109085*^9}, {
   3.562961397029133*^9, 3.562961416123566*^9}, 3.584384948178807*^9, {
   3.584385169019116*^9, 3.5843851836391363`*^9}, {3.5843881670033145`*^9, 
   3.584388181493335*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"SVD", " ", "of", " ", "L"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", ",", "sigma", ",", "v"}], "}"}], " ", "=", " ", 
     RowBox[{"SingularValueDecomposition", "[", "L", "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<SVD of L -- a 2x2 symmetric matrix\>\"", "]"}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Check SVD: L = \>\"", ",", " ", 
      RowBox[{"MatrixForm", "[", "L", "]"}], ",", "\"\<   USigmaV^T = \>\"", 
      ",", 
      RowBox[{"MatrixForm", "[", 
       RowBox[{"u", ".", "sigma", ".", 
        RowBox[{"Transpose", "[", "v", "]"}]}], "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<u =  \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "u", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<v =  \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "v", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<sigma=\>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "sigma", "]"}], "//", "N"}]}], "]"}], ";"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Eigendecomposition", " ", "of", " ", "L"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"evals", " ", "=", " ", 
     RowBox[{"Eigenvalues", "[", "L", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lambda", " ", "=", " ", 
     RowBox[{"DiagonalMatrix", "[", "evals", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"evecs", " ", "=", " ", 
     RowBox[{"Eigenvectors", "[", "L", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"evecs", "[", 
        RowBox[{"[", "i", "]"}], "]"}], " ", "=", " ", 
       RowBox[{
        RowBox[{"evecs", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "/", 
        RowBox[{"Norm", "[", 
         RowBox[{"evecs", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "]"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "2"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Evals = \>\"", ",", 
      RowBox[{"evals", "//", "N"}], ",", "\"\< as matrix = \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "lambda", "]"}], "//", "N"}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Evecs (rows) = \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "evecs", "]"}], "//", "N"}]}], "]"}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "evecs", " ", "returned", " ", "in", " ", "transpose", " ", "form"}], 
     ",", " ", 
     RowBox[{
     "so", " ", "that", " ", "refleced", " ", "in", " ", "R", " ", "and", " ", 
      RowBox[{"R", "^", "T"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Check eigendecomposition: L = \>\"", ",", " ", 
      RowBox[{"MatrixForm", "[", "L", "]"}], ",", "\"\< R.Lambda.R^T = \>\"", 
      ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", 
        RowBox[{
         RowBox[{"Transpose", "[", "evecs", "]"}], ".", "lambda", ".", 
         "evecs"}], "]"}], "//", "N"}]}], "]"}], ";"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"For", " ", 
      RowBox[{"plotting", ":", " ", 
       RowBox[{
       "Create", " ", "major", " ", "and", " ", "minor", " ", "axes"}]}]}], 
     ",", " ", 
     RowBox[{"scaled", " ", "by", " ", "eigenvalues"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"major", " ", "=", " ", 
     RowBox[{
      RowBox[{"lambda", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], "*", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"evecs", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
        RowBox[{"evecs", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"minor", " ", "=", " ", 
     RowBox[{
      RowBox[{"lambda", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "2"}], "]"}], "]"}], "*", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"evecs", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", 
        RowBox[{"evecs", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "2"}], "]"}], "]"}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"major3d", " ", "=", " ", 
     RowBox[{
      RowBox[{"lambda", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], "*", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"evecs", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
        RowBox[{"evecs", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", "0"}], "}"}]}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"minor3d", " ", "=", " ", 
     RowBox[{
      RowBox[{"lambda", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "2"}], "]"}], "]"}], "*", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"evecs", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", 
        RowBox[{"evecs", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "2"}], "]"}], "]"}], ",", "0"}], "}"}]}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<major=\>\"", ",", "major", ",", "\"\<  minor=\>\"", ",", "minor"}], 
    "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "create", " ", "ellipse", " ", "with", " ", "major", " ", "axis", " ", 
     "on", " ", "x", " ", "axis"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ellipsedata", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"lambda", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "1"}], "]"}], "]"}], "*", 
          RowBox[{"Cos", "[", "alpha", "]"}]}], ",", 
         RowBox[{
          RowBox[{"lambda", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "2"}], "]"}], "]"}], "*", 
          RowBox[{"Sin", "[", "alpha", "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"alpha", ",", "0", ",", 
         RowBox[{"2", "*", "Pi"}], ",", "0.1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"numedata", " ", "=", " ", 
     RowBox[{"Length", "[", "ellipsedata", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Rotate", " ", "ellipse", " ", "data", " ", "to", " ", "align", " ", 
     "with", " ", "eigenvectors"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "A", " ", "little", " ", "tricky", " ", "because", " ", "Mathematica", 
     " ", "has", " ", "data", " ", "as", " ", "row", " ", "vectors"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "want", " ", "xhat", " ", "on", " ", "ellipse", " ", "from", " ", "x", 
      " ", "in", " ", "standard", " ", 
      RowBox[{"position", ":", " ", "xhat"}]}], "  ", "=", " ", 
     RowBox[{"R", ".", "x"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Since", " ", "ellipse", " ", "data", " ", "row", " ", "by", " ", 
      "row"}], ",", " ", 
     RowBox[{"use", " ", 
      RowBox[{
       RowBox[{"x", "^", "T"}], ".", 
       RowBox[{"R", "^", "T"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Eigenvectors", " ", "are", " ", "in", " ", "row", " ", "format"}], ",", 
     " ", 
     RowBox[{"so", " ", "switch", " ", "that", " ", 
      RowBox[{"too", " ", "--"}], " ", "dont", " ", "use", " ", 
      "Transpose"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ellipsedata", " ", "=", " ", 
     RowBox[{"ellipsedata", ".", "evecs"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ellipse3d", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ellipsedata", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
         RowBox[{"ellipsedata", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numedata"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"PCA", " ", "--"}], " ", "define", " ", "principal", " ", 
     "axes"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Compute", " ", "transformed", " ", "data", " ", "set", " ", "to", " ", 
     "be", " ", "aligned", " ", "with", " ", "x", " ", 
     RowBox[{"and", "/", "or"}], " ", "y", " ", "axis"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"evec1", " ", "=", " ", 
     RowBox[{"evecs", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"evec2", " ", "=", " ", 
     RowBox[{"evecs", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Transform", " ", "data", " ", "using", " ", "both", " ", "eigenvecs"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pca12", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"evecs", ".", 
        RowBox[{"data", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numdata"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"\"\<PCA both evecs: \>\"", ",", 
       RowBox[{"MatrixForm", "[", "pca12", "]"}]}], "]"}], ";"}], " ", "*)"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Transform", " ", "data", " ", "using", " ", "only", " ", "dominant", " ",
      "evec"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pca1", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"evec1", ".", 
          RowBox[{"data", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numdata"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"\"\<PCA dominant evec: \>\"", ",", 
       RowBox[{"MatrixForm", "[", "pca1", "]"}]}], "]"}], ";"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Transform", " ", "data", " ", "using", " ", "non"}], "-", 
     RowBox[{"dominant", " ", "eigenvector"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pca2", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"evec2", ".", 
          RowBox[{"data", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numdata"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"\"\<data=\>\"", ",", 
       RowBox[{"MatrixForm", "[", "data", "]"}], ",", "\"\<  pca12=\>\"", ",", 
       RowBox[{"MatrixForm", "[", "pca12", "]"}], ",", "\"\<  pca1=\>\"", ",", 
       RowBox[{"MatrixForm", "[", "pca1", "]"}], ",", "\"\<  pca2=\>\"", ",", 
       RowBox[{"MatrixForm", "[", "pca2", "]"}]}], "]"}], ";"}], 
    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Check", " ", "l", 
     RowBox[{"(", "d", ")"}], " ", 
     RowBox[{"function", " ", "--"}], " ", "distance", " ", "of", " ", 
     "points", " ", "to", " ", "evecs"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"levec1", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"levec2", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"dist", " ", "=", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"evec1", ".", 
           RowBox[{"dataraw", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], ")"}], "^", "2"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"levec1", " ", "=", " ", 
        RowBox[{"levec1", " ", "+", " ", "dist"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"dist", " ", "=", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"evec2", ".", 
           RowBox[{"dataraw", "[", 
            RowBox[{"[", "i", "]"}], "]"}]}], ")"}], "^", "2"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"levec2", " ", "=", " ", 
        RowBox[{"levec2", " ", "+", " ", "dist"}]}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "numdata"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
     "\"\<distance function wrt evec1 = \>\"", ",", "levec1", ",", 
      "\"\<  wrt evec2 = \>\"", ",", "levec2"}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5629611581147127`*^9, 3.5629611583643136`*^9}, {
   3.562961432331995*^9, 3.562961508241728*^9}, 3.5632236114196815`*^9, {
   3.5632879921789513`*^9, 3.5632879960321584`*^9}, {3.56330020455578*^9, 
   3.5633003812080555`*^9}, {3.5633004584445705`*^9, 3.563300475092597*^9}, {
   3.5633005322966843`*^9, 3.5633005371466913`*^9}, {3.56330057869835*^9, 
   3.5633005789783497`*^9}, {3.563628565922803*^9, 3.5636285747680182`*^9}, {
   3.5639057305791497`*^9, 3.5639057805772376`*^9}, {3.5843850923490086`*^9, 
   3.5843851565990987`*^9}, {3.5843852330892057`*^9, 
   3.5843852359692097`*^9}, {3.584385755239938*^9, 3.5843857812699747`*^9}, {
   3.5843858742401047`*^9, 3.584386045450344*^9}, {3.5843861566105003`*^9, 
   3.5843862269805984`*^9}, {3.5843869171015644`*^9, 
   3.5843869278515797`*^9}, {3.584388215203382*^9, 3.584388243893422*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"SVD of L -- a 2x2 symmetric matrix\"\>"], "Print",
 CellChangeTimes->{
  3.5632878218110523`*^9, 3.563287999916565*^9, 3.5632880548754616`*^9, 
   3.563293060392934*^9, 3.5632944310454845`*^9, 3.5632945083480153`*^9, 
   3.563294583621745*^9, 3.5632949028434505`*^9, {3.5632950295424356`*^9, 
   3.5632950767065077`*^9}, 3.5632951225753736`*^9, 3.5632952436631594`*^9, 
   3.5632955167415843`*^9, {3.563295618775353*^9, 3.5632956371045847`*^9}, 
   3.563295956718712*^9, 3.563296028686833*^9, {3.5632961411122174`*^9, 
   3.563296158276246*^9}, 3.5632962031539145`*^9, 3.5632962552043934`*^9, {
   3.563296330050512*^9, 3.563296364579362*^9}, 3.563296399795413*^9, 
   3.563296432859861*^9, 3.5632965004575644`*^9, 3.5632966149969416`*^9, 
   3.563296896136158*^9, 3.563296927501004*^9, 3.563296971660668*^9, 
   3.5632970643692045`*^9, 3.5632973648556476`*^9, 3.563297506177058*^9, {
   3.563297927564948*^9, 3.5632979712770195`*^9}, {3.5632980847368026`*^9, 
   3.5632981113080473`*^9}, 3.563298151138112*^9, 3.5632982441166573`*^9, 
   3.563298332437597*^9, 3.563298371659258*^9, 3.5632985891555862`*^9, 
   3.563300385109662*^9, 3.5633004255693197`*^9, 3.5633004800182047`*^9, {
   3.5633005406766963`*^9, 3.563300565288331*^9}, 3.5633006078547926`*^9, 
   3.5635545715290985`*^9, 3.5635546554728465`*^9, {3.5635547684794445`*^9, 
   3.563554791583085*^9}, 3.563554838086767*^9, 3.56355490806849*^9, 
   3.563554980686618*^9, 3.563555187530182*^9, 3.5636282348122215`*^9, 
   3.563628428502161*^9, 3.5636285948764534`*^9, 3.5636288605249276`*^9, 
   3.563628905640207*^9, 3.563629004049999*^9, {3.5636290939685574`*^9, 
   3.5636292347588043`*^9}, 3.563629355159816*^9, {3.5636295702037935`*^9, 
   3.563629592948634*^9}, 3.563630250774191*^9, 3.563904875463648*^9, 
   3.563905217244648*^9, 3.5639053208288302`*^9, 3.563905362902104*^9, 
   3.5639055058919554`*^9, 3.563905783556843*^9, 3.564775127867545*^9, 
   3.564775168349616*^9, 3.5702007330510616`*^9, 3.5702009634838643`*^9, 
   3.5702010296591806`*^9, 3.570201071451654*^9, 3.5843845514482517`*^9, 
   3.5843847937985907`*^9, 3.584385736609912*^9, 3.584386845191464*^9, 
   3.5843868913015285`*^9, 3.5843869423515997`*^9, 3.58438791357296*^9, 
   3.584388300333501*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Check SVD: L = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.4721248955528696`", "1.9133624428999825`"},
       {"1.9133624428999825`", "3.9845724521912214`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"   USigmaV^T = \"\>",
    "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.4721248955528698`", "1.913362442899983`"},
       {"1.913362442899983`", "3.9845724521912214`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Check SVD: L = ", 
   MatrixForm[{{1.4721248955528696`, 1.9133624428999825`}, {
    1.9133624428999825`, 3.9845724521912214`}}], "   USigmaV^T = ", 
   MatrixForm[{{1.4721248955528698`, 1.913362442899983}, {1.913362442899983, 
    3.9845724521912214`}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5632878218110523`*^9, 3.563287999916565*^9, 3.5632880548754616`*^9, 
   3.563293060392934*^9, 3.5632944310454845`*^9, 3.5632945083480153`*^9, 
   3.563294583621745*^9, 3.5632949028434505`*^9, {3.5632950295424356`*^9, 
   3.5632950767065077`*^9}, 3.5632951225753736`*^9, 3.5632952436631594`*^9, 
   3.5632955167415843`*^9, {3.563295618775353*^9, 3.5632956371045847`*^9}, 
   3.563295956718712*^9, 3.563296028686833*^9, {3.5632961411122174`*^9, 
   3.563296158276246*^9}, 3.5632962031539145`*^9, 3.5632962552043934`*^9, {
   3.563296330050512*^9, 3.563296364579362*^9}, 3.563296399795413*^9, 
   3.563296432859861*^9, 3.5632965004575644`*^9, 3.5632966149969416`*^9, 
   3.563296896136158*^9, 3.563296927501004*^9, 3.563296971660668*^9, 
   3.5632970643692045`*^9, 3.5632973648556476`*^9, 3.563297506177058*^9, {
   3.563297927564948*^9, 3.5632979712770195`*^9}, {3.5632980847368026`*^9, 
   3.5632981113080473`*^9}, 3.563298151138112*^9, 3.5632982441166573`*^9, 
   3.563298332437597*^9, 3.563298371659258*^9, 3.5632985891555862`*^9, 
   3.563300385109662*^9, 3.5633004255693197`*^9, 3.5633004800182047`*^9, {
   3.5633005406766963`*^9, 3.563300565288331*^9}, 3.5633006078547926`*^9, 
   3.5635545715290985`*^9, 3.5635546554728465`*^9, {3.5635547684794445`*^9, 
   3.563554791583085*^9}, 3.563554838086767*^9, 3.56355490806849*^9, 
   3.563554980686618*^9, 3.563555187530182*^9, 3.5636282348122215`*^9, 
   3.563628428502161*^9, 3.5636285948764534`*^9, 3.5636288605249276`*^9, 
   3.563628905640207*^9, 3.563629004049999*^9, {3.5636290939685574`*^9, 
   3.5636292347588043`*^9}, 3.563629355159816*^9, {3.5636295702037935`*^9, 
   3.563629592948634*^9}, 3.563630250774191*^9, 3.563904875463648*^9, 
   3.563905217244648*^9, 3.5639053208288302`*^9, 3.563905362902104*^9, 
   3.5639055058919554`*^9, 3.563905783556843*^9, 3.564775127867545*^9, 
   3.564775168349616*^9, 3.5702007330510616`*^9, 3.5702009634838643`*^9, 
   3.5702010296591806`*^9, 3.570201071451654*^9, 3.5843845514482517`*^9, 
   3.5843847937985907`*^9, 3.584385736609912*^9, 3.584386845191464*^9, 
   3.5843868913015285`*^9, 3.5843869423515997`*^9, 3.58438791357296*^9, 
   3.584388300333501*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"u =  \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "0.4749560777187253`"}], 
        RowBox[{"-", "0.8800095023566759`"}]},
       {
        RowBox[{"-", "0.8800095023566759`"}], "0.4749560777187253`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["u =  ", 
   MatrixForm[{{-0.4749560777187253, -0.8800095023566759}, \
{-0.8800095023566759, 0.4749560777187253}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5632878218110523`*^9, 3.563287999916565*^9, 3.5632880548754616`*^9, 
   3.563293060392934*^9, 3.5632944310454845`*^9, 3.5632945083480153`*^9, 
   3.563294583621745*^9, 3.5632949028434505`*^9, {3.5632950295424356`*^9, 
   3.5632950767065077`*^9}, 3.5632951225753736`*^9, 3.5632952436631594`*^9, 
   3.5632955167415843`*^9, {3.563295618775353*^9, 3.5632956371045847`*^9}, 
   3.563295956718712*^9, 3.563296028686833*^9, {3.5632961411122174`*^9, 
   3.563296158276246*^9}, 3.5632962031539145`*^9, 3.5632962552043934`*^9, {
   3.563296330050512*^9, 3.563296364579362*^9}, 3.563296399795413*^9, 
   3.563296432859861*^9, 3.5632965004575644`*^9, 3.5632966149969416`*^9, 
   3.563296896136158*^9, 3.563296927501004*^9, 3.563296971660668*^9, 
   3.5632970643692045`*^9, 3.5632973648556476`*^9, 3.563297506177058*^9, {
   3.563297927564948*^9, 3.5632979712770195`*^9}, {3.5632980847368026`*^9, 
   3.5632981113080473`*^9}, 3.563298151138112*^9, 3.5632982441166573`*^9, 
   3.563298332437597*^9, 3.563298371659258*^9, 3.5632985891555862`*^9, 
   3.563300385109662*^9, 3.5633004255693197`*^9, 3.5633004800182047`*^9, {
   3.5633005406766963`*^9, 3.563300565288331*^9}, 3.5633006078547926`*^9, 
   3.5635545715290985`*^9, 3.5635546554728465`*^9, {3.5635547684794445`*^9, 
   3.563554791583085*^9}, 3.563554838086767*^9, 3.56355490806849*^9, 
   3.563554980686618*^9, 3.563555187530182*^9, 3.5636282348122215`*^9, 
   3.563628428502161*^9, 3.5636285948764534`*^9, 3.5636288605249276`*^9, 
   3.563628905640207*^9, 3.563629004049999*^9, {3.5636290939685574`*^9, 
   3.5636292347588043`*^9}, 3.563629355159816*^9, {3.5636295702037935`*^9, 
   3.563629592948634*^9}, 3.563630250774191*^9, 3.563904875463648*^9, 
   3.563905217244648*^9, 3.5639053208288302`*^9, 3.563905362902104*^9, 
   3.5639055058919554`*^9, 3.563905783556843*^9, 3.564775127867545*^9, 
   3.564775168349616*^9, 3.5702007330510616`*^9, 3.5702009634838643`*^9, 
   3.5702010296591806`*^9, 3.570201071451654*^9, 3.5843845514482517`*^9, 
   3.5843847937985907`*^9, 3.584385736609912*^9, 3.584386845191464*^9, 
   3.5843868913015285`*^9, 3.5843869423515997`*^9, 3.58438791357296*^9, 
   3.584388300343501*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"v =  \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "0.47495607771872517`"}], 
        RowBox[{"-", "0.8800095023566756`"}]},
       {
        RowBox[{"-", "0.8800095023566756`"}], "0.47495607771872517`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["v =  ", 
   MatrixForm[{{-0.47495607771872517`, -0.8800095023566756}, \
{-0.8800095023566756, 0.47495607771872517`}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5632878218110523`*^9, 3.563287999916565*^9, 3.5632880548754616`*^9, 
   3.563293060392934*^9, 3.5632944310454845`*^9, 3.5632945083480153`*^9, 
   3.563294583621745*^9, 3.5632949028434505`*^9, {3.5632950295424356`*^9, 
   3.5632950767065077`*^9}, 3.5632951225753736`*^9, 3.5632952436631594`*^9, 
   3.5632955167415843`*^9, {3.563295618775353*^9, 3.5632956371045847`*^9}, 
   3.563295956718712*^9, 3.563296028686833*^9, {3.5632961411122174`*^9, 
   3.563296158276246*^9}, 3.5632962031539145`*^9, 3.5632962552043934`*^9, {
   3.563296330050512*^9, 3.563296364579362*^9}, 3.563296399795413*^9, 
   3.563296432859861*^9, 3.5632965004575644`*^9, 3.5632966149969416`*^9, 
   3.563296896136158*^9, 3.563296927501004*^9, 3.563296971660668*^9, 
   3.5632970643692045`*^9, 3.5632973648556476`*^9, 3.563297506177058*^9, {
   3.563297927564948*^9, 3.5632979712770195`*^9}, {3.5632980847368026`*^9, 
   3.5632981113080473`*^9}, 3.563298151138112*^9, 3.5632982441166573`*^9, 
   3.563298332437597*^9, 3.563298371659258*^9, 3.5632985891555862`*^9, 
   3.563300385109662*^9, 3.5633004255693197`*^9, 3.5633004800182047`*^9, {
   3.5633005406766963`*^9, 3.563300565288331*^9}, 3.5633006078547926`*^9, 
   3.5635545715290985`*^9, 3.5635546554728465`*^9, {3.5635547684794445`*^9, 
   3.563554791583085*^9}, 3.563554838086767*^9, 3.56355490806849*^9, 
   3.563554980686618*^9, 3.563555187530182*^9, 3.5636282348122215`*^9, 
   3.563628428502161*^9, 3.5636285948764534`*^9, 3.5636288605249276`*^9, 
   3.563628905640207*^9, 3.563629004049999*^9, {3.5636290939685574`*^9, 
   3.5636292347588043`*^9}, 3.563629355159816*^9, {3.5636295702037935`*^9, 
   3.563629592948634*^9}, 3.563630250774191*^9, 3.563904875463648*^9, 
   3.563905217244648*^9, 3.5639053208288302`*^9, 3.563905362902104*^9, 
   3.5639055058919554`*^9, 3.563905783556843*^9, 3.564775127867545*^9, 
   3.564775168349616*^9, 3.5702007330510616`*^9, 3.5702009634838643`*^9, 
   3.5702010296591806`*^9, 3.570201071451654*^9, 3.5843845514482517`*^9, 
   3.5843847937985907`*^9, 3.584385736609912*^9, 3.584386845191464*^9, 
   3.5843868913015285`*^9, 3.5843869423515997`*^9, 3.58438791357296*^9, 
   3.584388300343501*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"sigma=\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"5.017246666163248`", "0.`"},
       {"0.`", "0.4394506815808436`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["sigma=", 
   MatrixForm[{{5.017246666163248, 0.}, {0., 0.4394506815808436}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5632878218110523`*^9, 3.563287999916565*^9, 3.5632880548754616`*^9, 
   3.563293060392934*^9, 3.5632944310454845`*^9, 3.5632945083480153`*^9, 
   3.563294583621745*^9, 3.5632949028434505`*^9, {3.5632950295424356`*^9, 
   3.5632950767065077`*^9}, 3.5632951225753736`*^9, 3.5632952436631594`*^9, 
   3.5632955167415843`*^9, {3.563295618775353*^9, 3.5632956371045847`*^9}, 
   3.563295956718712*^9, 3.563296028686833*^9, {3.5632961411122174`*^9, 
   3.563296158276246*^9}, 3.5632962031539145`*^9, 3.5632962552043934`*^9, {
   3.563296330050512*^9, 3.563296364579362*^9}, 3.563296399795413*^9, 
   3.563296432859861*^9, 3.5632965004575644`*^9, 3.5632966149969416`*^9, 
   3.563296896136158*^9, 3.563296927501004*^9, 3.563296971660668*^9, 
   3.5632970643692045`*^9, 3.5632973648556476`*^9, 3.563297506177058*^9, {
   3.563297927564948*^9, 3.5632979712770195`*^9}, {3.5632980847368026`*^9, 
   3.5632981113080473`*^9}, 3.563298151138112*^9, 3.5632982441166573`*^9, 
   3.563298332437597*^9, 3.563298371659258*^9, 3.5632985891555862`*^9, 
   3.563300385109662*^9, 3.5633004255693197`*^9, 3.5633004800182047`*^9, {
   3.5633005406766963`*^9, 3.563300565288331*^9}, 3.5633006078547926`*^9, 
   3.5635545715290985`*^9, 3.5635546554728465`*^9, {3.5635547684794445`*^9, 
   3.563554791583085*^9}, 3.563554838086767*^9, 3.56355490806849*^9, 
   3.563554980686618*^9, 3.563555187530182*^9, 3.5636282348122215`*^9, 
   3.563628428502161*^9, 3.5636285948764534`*^9, 3.5636288605249276`*^9, 
   3.563628905640207*^9, 3.563629004049999*^9, {3.5636290939685574`*^9, 
   3.5636292347588043`*^9}, 3.563629355159816*^9, {3.5636295702037935`*^9, 
   3.563629592948634*^9}, 3.563630250774191*^9, 3.563904875463648*^9, 
   3.563905217244648*^9, 3.5639053208288302`*^9, 3.563905362902104*^9, 
   3.5639055058919554`*^9, 3.563905783556843*^9, 3.564775127867545*^9, 
   3.564775168349616*^9, 3.5702007330510616`*^9, 3.5702009634838643`*^9, 
   3.5702010296591806`*^9, 3.570201071451654*^9, 3.5843845514482517`*^9, 
   3.5843847937985907`*^9, 3.584385736609912*^9, 3.584386845191464*^9, 
   3.5843868913015285`*^9, 3.5843869423515997`*^9, 3.58438791357296*^9, 
   3.584388300343501*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"5.017246666163247`", ",", "0.43945068158084366`"}], "}"}], 
   "\[InvisibleSpace]", "\<\" as matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"5.017246666163247`", "0.`"},
       {"0.`", "0.43945068158084366`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
  "Evals = ", {5.017246666163247, 0.43945068158084366`}, " as matrix = ", 
   MatrixForm[{{5.017246666163247, 0.}, {0., 0.43945068158084366`}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5632878218110523`*^9, 3.563287999916565*^9, 3.5632880548754616`*^9, 
   3.563293060392934*^9, 3.5632944310454845`*^9, 3.5632945083480153`*^9, 
   3.563294583621745*^9, 3.5632949028434505`*^9, {3.5632950295424356`*^9, 
   3.5632950767065077`*^9}, 3.5632951225753736`*^9, 3.5632952436631594`*^9, 
   3.5632955167415843`*^9, {3.563295618775353*^9, 3.5632956371045847`*^9}, 
   3.563295956718712*^9, 3.563296028686833*^9, {3.5632961411122174`*^9, 
   3.563296158276246*^9}, 3.5632962031539145`*^9, 3.5632962552043934`*^9, {
   3.563296330050512*^9, 3.563296364579362*^9}, 3.563296399795413*^9, 
   3.563296432859861*^9, 3.5632965004575644`*^9, 3.5632966149969416`*^9, 
   3.563296896136158*^9, 3.563296927501004*^9, 3.563296971660668*^9, 
   3.5632970643692045`*^9, 3.5632973648556476`*^9, 3.563297506177058*^9, {
   3.563297927564948*^9, 3.5632979712770195`*^9}, {3.5632980847368026`*^9, 
   3.5632981113080473`*^9}, 3.563298151138112*^9, 3.5632982441166573`*^9, 
   3.563298332437597*^9, 3.563298371659258*^9, 3.5632985891555862`*^9, 
   3.563300385109662*^9, 3.5633004255693197`*^9, 3.5633004800182047`*^9, {
   3.5633005406766963`*^9, 3.563300565288331*^9}, 3.5633006078547926`*^9, 
   3.5635545715290985`*^9, 3.5635546554728465`*^9, {3.5635547684794445`*^9, 
   3.563554791583085*^9}, 3.563554838086767*^9, 3.56355490806849*^9, 
   3.563554980686618*^9, 3.563555187530182*^9, 3.5636282348122215`*^9, 
   3.563628428502161*^9, 3.5636285948764534`*^9, 3.5636288605249276`*^9, 
   3.563628905640207*^9, 3.563629004049999*^9, {3.5636290939685574`*^9, 
   3.5636292347588043`*^9}, 3.563629355159816*^9, {3.5636295702037935`*^9, 
   3.563629592948634*^9}, 3.563630250774191*^9, 3.563904875463648*^9, 
   3.563905217244648*^9, 3.5639053208288302`*^9, 3.563905362902104*^9, 
   3.5639055058919554`*^9, 3.563905783556843*^9, 3.564775127867545*^9, 
   3.564775168349616*^9, 3.5702007330510616`*^9, 3.5702009634838643`*^9, 
   3.5702010296591806`*^9, 3.570201071451654*^9, 3.5843845514482517`*^9, 
   3.5843847937985907`*^9, 3.584385736609912*^9, 3.584386845191464*^9, 
   3.5843868913015285`*^9, 3.5843869423515997`*^9, 3.58438791357296*^9, 
   3.584388300343501*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Evecs (rows) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.4749560777187251`", "0.8800095023566759`"},
       {
        RowBox[{"-", "0.8800095023566759`"}], "0.4749560777187251`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Evecs (rows) = ", 
   MatrixForm[{{0.4749560777187251, 0.8800095023566759}, {-0.8800095023566759,
     0.4749560777187251}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5632878218110523`*^9, 3.563287999916565*^9, 3.5632880548754616`*^9, 
   3.563293060392934*^9, 3.5632944310454845`*^9, 3.5632945083480153`*^9, 
   3.563294583621745*^9, 3.5632949028434505`*^9, {3.5632950295424356`*^9, 
   3.5632950767065077`*^9}, 3.5632951225753736`*^9, 3.5632952436631594`*^9, 
   3.5632955167415843`*^9, {3.563295618775353*^9, 3.5632956371045847`*^9}, 
   3.563295956718712*^9, 3.563296028686833*^9, {3.5632961411122174`*^9, 
   3.563296158276246*^9}, 3.5632962031539145`*^9, 3.5632962552043934`*^9, {
   3.563296330050512*^9, 3.563296364579362*^9}, 3.563296399795413*^9, 
   3.563296432859861*^9, 3.5632965004575644`*^9, 3.5632966149969416`*^9, 
   3.563296896136158*^9, 3.563296927501004*^9, 3.563296971660668*^9, 
   3.5632970643692045`*^9, 3.5632973648556476`*^9, 3.563297506177058*^9, {
   3.563297927564948*^9, 3.5632979712770195`*^9}, {3.5632980847368026`*^9, 
   3.5632981113080473`*^9}, 3.563298151138112*^9, 3.5632982441166573`*^9, 
   3.563298332437597*^9, 3.563298371659258*^9, 3.5632985891555862`*^9, 
   3.563300385109662*^9, 3.5633004255693197`*^9, 3.5633004800182047`*^9, {
   3.5633005406766963`*^9, 3.563300565288331*^9}, 3.5633006078547926`*^9, 
   3.5635545715290985`*^9, 3.5635546554728465`*^9, {3.5635547684794445`*^9, 
   3.563554791583085*^9}, 3.563554838086767*^9, 3.56355490806849*^9, 
   3.563554980686618*^9, 3.563555187530182*^9, 3.5636282348122215`*^9, 
   3.563628428502161*^9, 3.5636285948764534`*^9, 3.5636288605249276`*^9, 
   3.563628905640207*^9, 3.563629004049999*^9, {3.5636290939685574`*^9, 
   3.5636292347588043`*^9}, 3.563629355159816*^9, {3.5636295702037935`*^9, 
   3.563629592948634*^9}, 3.563630250774191*^9, 3.563904875463648*^9, 
   3.563905217244648*^9, 3.5639053208288302`*^9, 3.563905362902104*^9, 
   3.5639055058919554`*^9, 3.563905783556843*^9, 3.564775127867545*^9, 
   3.564775168349616*^9, 3.5702007330510616`*^9, 3.5702009634838643`*^9, 
   3.5702010296591806`*^9, 3.570201071451654*^9, 3.5843845514482517`*^9, 
   3.5843847937985907`*^9, 3.584385736609912*^9, 3.584386845191464*^9, 
   3.5843868913015285`*^9, 3.5843869423515997`*^9, 3.58438791357296*^9, 
   3.5843883003535013`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Check eigendecomposition: L = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.4721248955528696`", "1.9133624428999825`"},
       {"1.9133624428999825`", "3.9845724521912214`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   "\[InvisibleSpace]", "\<\" R.Lambda.R^T = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.4721248955528692`", "1.913362442899982`"},
       {"1.913362442899982`", "3.9845724521912214`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Check eigendecomposition: L = ", 
   MatrixForm[{{1.4721248955528696`, 1.9133624428999825`}, {
    1.9133624428999825`, 3.9845724521912214`}}], " R.Lambda.R^T = ", 
   MatrixForm[{{1.4721248955528692`, 1.913362442899982}, {1.913362442899982, 
    3.9845724521912214`}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5632878218110523`*^9, 3.563287999916565*^9, 3.5632880548754616`*^9, 
   3.563293060392934*^9, 3.5632944310454845`*^9, 3.5632945083480153`*^9, 
   3.563294583621745*^9, 3.5632949028434505`*^9, {3.5632950295424356`*^9, 
   3.5632950767065077`*^9}, 3.5632951225753736`*^9, 3.5632952436631594`*^9, 
   3.5632955167415843`*^9, {3.563295618775353*^9, 3.5632956371045847`*^9}, 
   3.563295956718712*^9, 3.563296028686833*^9, {3.5632961411122174`*^9, 
   3.563296158276246*^9}, 3.5632962031539145`*^9, 3.5632962552043934`*^9, {
   3.563296330050512*^9, 3.563296364579362*^9}, 3.563296399795413*^9, 
   3.563296432859861*^9, 3.5632965004575644`*^9, 3.5632966149969416`*^9, 
   3.563296896136158*^9, 3.563296927501004*^9, 3.563296971660668*^9, 
   3.5632970643692045`*^9, 3.5632973648556476`*^9, 3.563297506177058*^9, {
   3.563297927564948*^9, 3.5632979712770195`*^9}, {3.5632980847368026`*^9, 
   3.5632981113080473`*^9}, 3.563298151138112*^9, 3.5632982441166573`*^9, 
   3.563298332437597*^9, 3.563298371659258*^9, 3.5632985891555862`*^9, 
   3.563300385109662*^9, 3.5633004255693197`*^9, 3.5633004800182047`*^9, {
   3.5633005406766963`*^9, 3.563300565288331*^9}, 3.5633006078547926`*^9, 
   3.5635545715290985`*^9, 3.5635546554728465`*^9, {3.5635547684794445`*^9, 
   3.563554791583085*^9}, 3.563554838086767*^9, 3.56355490806849*^9, 
   3.563554980686618*^9, 3.563555187530182*^9, 3.5636282348122215`*^9, 
   3.563628428502161*^9, 3.5636285948764534`*^9, 3.5636288605249276`*^9, 
   3.563628905640207*^9, 3.563629004049999*^9, {3.5636290939685574`*^9, 
   3.5636292347588043`*^9}, 3.563629355159816*^9, {3.5636295702037935`*^9, 
   3.563629592948634*^9}, 3.563630250774191*^9, 3.563904875463648*^9, 
   3.563905217244648*^9, 3.5639053208288302`*^9, 3.563905362902104*^9, 
   3.5639055058919554`*^9, 3.563905783556843*^9, 3.564775127867545*^9, 
   3.564775168349616*^9, 3.5702007330510616`*^9, 3.5702009634838643`*^9, 
   3.5702010296591806`*^9, 3.570201071451654*^9, 3.5843845514482517`*^9, 
   3.5843847937985907`*^9, 3.584385736609912*^9, 3.584386845191464*^9, 
   3.5843868913015285`*^9, 3.5843869423515997`*^9, 3.58438791357296*^9, 
   3.5843883003535013`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"major=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2.3829717975082456`", ",", "4.41522474189101`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"  minor=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.38672077560826024`"}], ",", "0.2087197720744579`"}], 
    "}"}]}],
  SequenceForm[
  "major=", {2.3829717975082456`, 4.41522474189101}, 
   "  minor=", {-0.38672077560826024`, 0.2087197720744579}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5632878218110523`*^9, 3.563287999916565*^9, 3.5632880548754616`*^9, 
   3.563293060392934*^9, 3.5632944310454845`*^9, 3.5632945083480153`*^9, 
   3.563294583621745*^9, 3.5632949028434505`*^9, {3.5632950295424356`*^9, 
   3.5632950767065077`*^9}, 3.5632951225753736`*^9, 3.5632952436631594`*^9, 
   3.5632955167415843`*^9, {3.563295618775353*^9, 3.5632956371045847`*^9}, 
   3.563295956718712*^9, 3.563296028686833*^9, {3.5632961411122174`*^9, 
   3.563296158276246*^9}, 3.5632962031539145`*^9, 3.5632962552043934`*^9, {
   3.563296330050512*^9, 3.563296364579362*^9}, 3.563296399795413*^9, 
   3.563296432859861*^9, 3.5632965004575644`*^9, 3.5632966149969416`*^9, 
   3.563296896136158*^9, 3.563296927501004*^9, 3.563296971660668*^9, 
   3.5632970643692045`*^9, 3.5632973648556476`*^9, 3.563297506177058*^9, {
   3.563297927564948*^9, 3.5632979712770195`*^9}, {3.5632980847368026`*^9, 
   3.5632981113080473`*^9}, 3.563298151138112*^9, 3.5632982441166573`*^9, 
   3.563298332437597*^9, 3.563298371659258*^9, 3.5632985891555862`*^9, 
   3.563300385109662*^9, 3.5633004255693197`*^9, 3.5633004800182047`*^9, {
   3.5633005406766963`*^9, 3.563300565288331*^9}, 3.5633006078547926`*^9, 
   3.5635545715290985`*^9, 3.5635546554728465`*^9, {3.5635547684794445`*^9, 
   3.563554791583085*^9}, 3.563554838086767*^9, 3.56355490806849*^9, 
   3.563554980686618*^9, 3.563555187530182*^9, 3.5636282348122215`*^9, 
   3.563628428502161*^9, 3.5636285948764534`*^9, 3.5636288605249276`*^9, 
   3.563628905640207*^9, 3.563629004049999*^9, {3.5636290939685574`*^9, 
   3.5636292347588043`*^9}, 3.563629355159816*^9, {3.5636295702037935`*^9, 
   3.563629592948634*^9}, 3.563630250774191*^9, 3.563904875463648*^9, 
   3.563905217244648*^9, 3.5639053208288302`*^9, 3.563905362902104*^9, 
   3.5639055058919554`*^9, 3.563905783556843*^9, 3.564775127867545*^9, 
   3.564775168349616*^9, 3.5702007330510616`*^9, 3.5702009634838643`*^9, 
   3.5702010296591806`*^9, 3.570201071451654*^9, 3.5843845514482517`*^9, 
   3.5843847937985907`*^9, 3.584385736609912*^9, 3.584386845191464*^9, 
   3.5843868913015285`*^9, 3.5843869423515997`*^9, 3.58438791357296*^9, 
   3.5843883003535013`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"distance function wrt evec1 = \"\>", "\[InvisibleSpace]", 
   "562.6416907814317`", "\[InvisibleSpace]", "\<\"  wrt evec2 = \"\>", 
   "\[InvisibleSpace]", "29.02038578201318`"}],
  SequenceForm[
  "distance function wrt evec1 = ", 562.6416907814317, "  wrt evec2 = ", 
   29.02038578201318],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5632878218110523`*^9, 3.563287999916565*^9, 3.5632880548754616`*^9, 
   3.563293060392934*^9, 3.5632944310454845`*^9, 3.5632945083480153`*^9, 
   3.563294583621745*^9, 3.5632949028434505`*^9, {3.5632950295424356`*^9, 
   3.5632950767065077`*^9}, 3.5632951225753736`*^9, 3.5632952436631594`*^9, 
   3.5632955167415843`*^9, {3.563295618775353*^9, 3.5632956371045847`*^9}, 
   3.563295956718712*^9, 3.563296028686833*^9, {3.5632961411122174`*^9, 
   3.563296158276246*^9}, 3.5632962031539145`*^9, 3.5632962552043934`*^9, {
   3.563296330050512*^9, 3.563296364579362*^9}, 3.563296399795413*^9, 
   3.563296432859861*^9, 3.5632965004575644`*^9, 3.5632966149969416`*^9, 
   3.563296896136158*^9, 3.563296927501004*^9, 3.563296971660668*^9, 
   3.5632970643692045`*^9, 3.5632973648556476`*^9, 3.563297506177058*^9, {
   3.563297927564948*^9, 3.5632979712770195`*^9}, {3.5632980847368026`*^9, 
   3.5632981113080473`*^9}, 3.563298151138112*^9, 3.5632982441166573`*^9, 
   3.563298332437597*^9, 3.563298371659258*^9, 3.5632985891555862`*^9, 
   3.563300385109662*^9, 3.5633004255693197`*^9, 3.5633004800182047`*^9, {
   3.5633005406766963`*^9, 3.563300565288331*^9}, 3.5633006078547926`*^9, 
   3.5635545715290985`*^9, 3.5635546554728465`*^9, {3.5635547684794445`*^9, 
   3.563554791583085*^9}, 3.563554838086767*^9, 3.56355490806849*^9, 
   3.563554980686618*^9, 3.563555187530182*^9, 3.5636282348122215`*^9, 
   3.563628428502161*^9, 3.5636285948764534`*^9, 3.5636288605249276`*^9, 
   3.563628905640207*^9, 3.563629004049999*^9, {3.5636290939685574`*^9, 
   3.5636292347588043`*^9}, 3.563629355159816*^9, {3.5636295702037935`*^9, 
   3.563629592948634*^9}, 3.563630250774191*^9, 3.563904875463648*^9, 
   3.563905217244648*^9, 3.5639053208288302`*^9, 3.563905362902104*^9, 
   3.5639055058919554`*^9, 3.563905783556843*^9, 3.564775127867545*^9, 
   3.564775168349616*^9, 3.5702007330510616`*^9, 3.5702009634838643`*^9, 
   3.5702010296591806`*^9, 3.570201071451654*^9, 3.5843845514482517`*^9, 
   3.5843847937985907`*^9, 3.584385736609912*^9, 3.584386845191464*^9, 
   3.5843868913015285`*^9, 3.5843869423515997`*^9, 3.58438791357296*^9, 
   3.5843883003535013`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Plot", "Section",
 CellChangeTimes->{{3.5629611707663355`*^9, 3.562961171078336*^9}, {
  3.5629615203941493`*^9, 3.5629615228433533`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "input", " ", "data", " ", "in", " ", "3", "d", " ", "form", " ", "for", 
    " ", "use", " ", "with", " ", "quadratic", " ", "form"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"plotdata", " ", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Black", ",", " ", 
         RowBox[{"PointSize", "[", "0.015", "]"}], ",", 
         RowBox[{"Point", "[", "data3d", "]"}]}], "}"}], ",", " ", 
       RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}], " ", ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Quadratic", " ", "form", " ", "evaluated", " ", "over", " ", "unit", " ",
      "circle"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"range", " ", "=", " ", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotqform", " ", "=", " ", 
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{"quadform", "[", 
        RowBox[{"L", ",", "x", ",", "y"}], "]"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "range"}], ",", "range"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "range"}], ",", "range"}], "}"}], ",", " ", 
       RowBox[{"RegionFunction", "\[Rule]", 
        RowBox[{"Function", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "^", "2"}], "+", 
            RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "1"}]}], "]"}]}], ",", 
       RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.7", "]"}], ",", " ", 
          RowBox[{"Opacity", "[", "0.8", "]"}], ",", 
          RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Major", " ", "and", " ", "minor", " ", "axes", " ", "of", " ", "action", 
     " ", 
     RowBox[{"ellipse", " ", "--"}], " ", "mapped", " ", "to", " ", "3", "d", 
     " ", 
     RowBox[{"(", 
      RowBox[{"z", "=", "0"}], ")"}], "  ", "for", " ", "use", " ", "with", 
     " ", "quadratic", " ", "form"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotmmaxes", " ", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0.3", "]"}], ",", 
        RowBox[{"Thickness", "[", "0.008", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "major3d"}], "}"}],
          "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"-", "major3d"}]}], "}"}], "]"}], ",", " ", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "minor3d"}], "}"}],
          "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"-", "minor3d"}]}], "}"}], "]"}]}], "}"}], "]"}]}], ";"}], 
   " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Action", " ", 
      RowBox[{"ellipse", "  ", "--"}], " ", "in", " ", "3", "d", " ", 
      "form"}], ",", " ", 
     RowBox[{"z", "=", 
      RowBox[{
       RowBox[{"0", "  ", "--"}], " ", "not", " ", "plotting"}]}]}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotellipse", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"i", " ", "\[LessEqual]", " ", "numedata"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Graphics3D", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"GrayLevel", "[", "0.3", "]"}], ",", 
            RowBox[{"Thickness", "[", "0.001", "]"}], ",", " ", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ellipse3d", "[", 
                RowBox[{"[", 
                 RowBox[{"i", "-", "1"}], "]"}], "]"}], ",", 
               RowBox[{"ellipse3d", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Graphics3D", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"GrayLevel", "[", "0.3", "]"}], ",", 
            RowBox[{"Thickness", "[", "0.001", "]"}], ",", " ", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ellipse3d", "[", 
                RowBox[{"[", "numedata", "]"}], "]"}], ",", 
               RowBox[{"ellipse3d", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
          "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"i", ",", "2", ",", 
         RowBox[{"numedata", "+", "1"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Plot", " ", "2", "d", " ", "data", " ", "set", " ", "and", " ", 
     "transformed", " ", "data", " ", "sets"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pointsize0", " ", "=", " ", "0.015"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pointsize", " ", "=", "   ", "0.015"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "input", " ", "data", " ", "2", "d", " ", "translated", " ", "to", " ", 
     "quadrant", " ", 
     RowBox[{"I", " ", "--"}], " ", "just", " ", "for", " ", "use", " ", "in",
      " ", "Figure"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotdatapos", " ", "=", " ", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Black", ",", " ", 
         RowBox[{"PointSize", "[", 
          RowBox[{"pointsize", "*", "2"}], "]"}], ",", 
         RowBox[{"Point", "[", "datapos", "]"}]}], "}"}], ",", " ", 
       RowBox[{"Axes", "\[Rule]", "True"}], ",", " ", 
       RowBox[{"AxesOrigin", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]}], " ", ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"input", " ", "data", " ", "2", "d"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotdata2d", "=", " ", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Black", ",", " ", 
         RowBox[{"PointSize", "[", "pointsize", "]"}], ",", 
         RowBox[{"Point", "[", "data", "]"}]}], "}"}], ",", " ", 
       RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}], " ", ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "major", " ", "and", " ", "minor", " ", "axis", " ", "of", " ", "action", 
     " ", "ellipse"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotmmaxes2d", " ", "=", " ", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GrayLevel", "[", "0.3", "]"}], ",", 
        RowBox[{"Thickness", "[", "0.008", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", "major"}], "}"}], "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"-", "major"}]}], "}"}], "]"}], ",", " ", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", "minor"}], "}"}], "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"-", "minor"}]}], "}"}], "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Action", " ", 
     RowBox[{"ellipse", " ", "--"}], " ", "not", " ", "plotting"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotellipse2d", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"i", " ", "\[LessEqual]", " ", "numedata"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"GrayLevel", "[", "0.3", "]"}], ",", 
            RowBox[{"Thickness", "[", "0.002", "]"}], ",", " ", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ellipsedata", "[", 
                RowBox[{"[", 
                 RowBox[{"i", "-", "1"}], "]"}], "]"}], ",", 
               RowBox[{"ellipsedata", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"GrayLevel", "[", "0.3", "]"}], ",", 
            RowBox[{"Thickness", "[", "0.002", "]"}], ",", " ", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ellipsedata", "[", 
                RowBox[{"[", "numedata", "]"}], "]"}], ",", 
               RowBox[{"ellipsedata", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
          "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"i", ",", "2", ",", 
         RowBox[{"numedata", "+", "1"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pointsize2", " ", "=", "   ", "0.01"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pointsize3", " ", "=", " ", "0.02"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Plot", " ", "PCA", " ", "results"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Axis", " ", "aligned", " ", "data"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotpca12", "=", " ", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Black", ",", " ", 
         RowBox[{"PointSize", "[", "pointsize2", "]"}], ",", 
         RowBox[{"Point", "[", "pca12", "]"}]}], "}"}], ",", " ", 
       RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}], " ", ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Data", " ", "with", " ", "non"}], "-", 
     RowBox[{"dominant", " ", "coordinate", " ", 
      RowBox[{"removed", " ", "--"}], " ", "keep", " ", "highest", " ", 
      "variance", " ", "data"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotpca1", "=", " ", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "pointsize3", "]"}], ",", 
         RowBox[{"Point", "[", "pca1", "]"}]}], "}"}], ",", " ", 
       RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}], " ", ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "data", " ", "with", " ", "dominant", " ", "coordinate", " ", "removed"}],
     " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotpca2", "=", " ", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", " ", 
         RowBox[{"PointSize", "[", "pointsize3", "]"}], ",", 
         RowBox[{"Point", "[", "pca2", "]"}]}], "}"}], ",", " ", 
       RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}], " ", ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"++", 
      RowBox[{"++", 
       RowBox[{"+", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"DISPLAY", " ", "++"}], "++"}], "++"}]}]}]}], "+"}], " ", 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Quadratic", " ", "form"}], ",", " ", 
     RowBox[{"action", " ", "ellipse"}], ",", " ", "data", ",", " ", 
     "eigenvectors"}], "  ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\< \>\"", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", "\"\<Input 2D data --> Covariance matrix L\>\"", "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", 
     "\"\<Plot of data, quadratic form of L, and principal axes\>\"", "]"}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"plotqform", ",", "plotmmaxes", ",", "plotdata", ",", 
     RowBox[{"Boxed", "\[Rule]", "True"}], ",", " ", 
     RowBox[{"Axes", "\[Rule]", "False"}], ",", " ", 
     RowBox[{"BoxRatios", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"BoxStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Thickness", "[", "0.003", "]"}], "]"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"ViewPoint", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", "2"}], ",", "1.0"}], "}"}]}]}], "]"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tness", " ", "=", " ", "0.0008"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"This", " ", "plot", " ", "was", " ", "used", " ", "for", " ", 
     RowBox[{"Figure", "/", "storyline"}], " ", "in", " ", "PLA"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Print", "[", "\"\<Plot of input data in QI\>\"", "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Show", "[", 
      RowBox[{"plotdatapos", ",", " ", 
       RowBox[{"Axes", "\[Rule]", "True"}], ",", " ", 
       RowBox[{"Ticks", "\[Rule]", "False"}], ",", 
       RowBox[{"AxesStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{"Thickness", "[", 
          RowBox[{"tness", "*", "4"}], "]"}], "]"}]}]}], "]"}]}], 
    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", "\"\<Plot of input 2D data with principal axes\>\"", "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"plotdata2d", ",", "plotmmaxes2d", ",", " ", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", " ", 
     RowBox[{"Ticks", "\[Rule]", "False"}], ",", 
     RowBox[{"AxesStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Thickness", "[", "tness", "]"}], "]"}]}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", 
     "\"\<Plot of 2D input data so that coordinates correspond to trend lines \
in data \>\"", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"plotpca12", ",", " ", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", " ", 
     RowBox[{"Ticks", "\[Rule]", "False"}], ",", 
     RowBox[{"AxesStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Thickness", "[", "tness", "]"}], "]"}]}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", 
     "\"\<Plot of input data, axis aligned data, and highest variance \
coordinate \>\"", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"plotpca12", ",", "plotpca1", ",", " ", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", " ", 
     RowBox[{"AxesStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Thickness", "[", "tness", "]"}], "]"}]}], ",", 
     RowBox[{"Ticks", "\[Rule]", "False"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", 
     "\"\<Plot of input data, axis aligned data, and lowest variance \
coordinate \>\"", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"plotpca2", ",", "plotpca12", ",", " ", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", " ", 
     RowBox[{"Ticks", "\[Rule]", "False"}], ",", 
     RowBox[{"AxesStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Thickness", "[", "tness", "]"}], "]"}]}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.5629611848063602`*^9, 3.5629611850403605`*^9}, {
   3.562961534324974*^9, 3.5629615854774637`*^9}, {3.562961772537392*^9, 
   3.562961833330699*^9}, {3.562961978660554*^9, 3.5629620170366216`*^9}, {
   3.562962049063478*^9, 3.5629621460020485`*^9}, {3.562962195610135*^9, 
   3.562962208480158*^9}, {3.563223631496917*^9, 3.563223632042918*^9}, {
   3.5632942812732296`*^9, 3.563294308572477*^9}, {3.563294374010188*^9, 
   3.563294426942677*^9}, {3.5632944700471497`*^9, 3.5632944706399508`*^9}, {
   3.563294569706521*^9, 3.563294570876523*^9}, {3.5632948592369814`*^9, 
   3.5632948631613874`*^9}, {3.5632948980622425`*^9, 3.563294899700246*^9}, {
   3.563294969861149*^9, 3.5632950869353237`*^9}, {3.563295142727805*^9, 
   3.563295151589419*^9}, 3.5632951906222773`*^9, {3.563295231250739*^9, 
   3.563295236386348*^9}, {3.563295553948047*^9, 3.563295579638089*^9}, {
   3.563295614535347*^9, 3.563295633968979*^9}, {3.5632957089287043`*^9, 
   3.5632957486867704`*^9}, {3.5632958072660656`*^9, 
   3.5632958396237197`*^9}, {3.5632960985021496`*^9, 3.56329619978391*^9}, {
   3.563296238558767*^9, 3.563296238968767*^9}, {3.563296286686043*^9, 
   3.5632963618193583`*^9}, {3.563296393418604*^9, 3.563296395918607*^9}, 
   3.563296429169856*^9, {3.5632964603715005`*^9, 3.563296540646826*^9}, {
   3.563296858311302*^9, 3.5632969244234*^9}, {3.56329695889065*^9, 
   3.5632969678306627`*^9}, {3.5632970173175373`*^9, 
   3.5632970202575417`*^9}, {3.5632972742691145`*^9, 3.563297279509122*^9}, {
   3.56329731948678*^9, 3.5632973621272435`*^9}, {3.563297456193781*^9, 
   3.5632975025894527`*^9}, {3.5632979216161385`*^9, 3.563297967579813*^9}, {
   3.5632980404419317`*^9, 3.5632981082504416`*^9}, {3.563298138499693*^9, 
   3.5632981471893053`*^9}, {3.5632982122414093`*^9, 3.563298240253451*^9}, {
   3.5632983120195656`*^9, 3.56329832811119*^9}, {3.563298364270447*^9, 
   3.563298368426453*^9}, {3.563298503941455*^9, 3.563298504783857*^9}, {
   3.5632985709843597`*^9, 3.563298584187179*^9}, {3.563554502296177*^9, 
   3.5635545671922913`*^9}, {3.563554615973577*^9, 3.563554635832412*^9}, {
   3.5635547591662283`*^9, 3.563554764329838*^9}, {3.5635549697665987`*^9, 
   3.563554977441812*^9}, {3.563555167562147*^9, 3.5635551822261724`*^9}, {
   3.563628281534303*^9, 3.5636284221061497`*^9}, {3.5636288540665164`*^9, 
   3.5636288564065204`*^9}, {3.563628891912183*^9, 3.5636289027386017`*^9}, {
   3.5636289884031715`*^9, 3.5636289971703873`*^9}, {3.563629080193733*^9, 
   3.5636292321848*^9}, {3.5636293519306107`*^9, 3.563629352242611*^9}, {
   3.563629552544563*^9, 3.5636295890174265`*^9}, 3.563630247373385*^9, {
   3.5702008639556894`*^9, 3.57020086428329*^9}, {3.5702008965441465`*^9, 
   3.5702009089305687`*^9}, {3.5702009442490306`*^9, 
   3.5702009595058575`*^9}, {3.584386996861676*^9, 3.584387400782242*^9}, {
   3.584387491622369*^9, 3.5843879348929896`*^9}, 3.5843879692430377`*^9, {
   3.584388278823471*^9, 3.584388283083477*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.5843879136829596`*^9, 3.5843883004335012`*^9}],

Cell[BoxData["\<\"Input 2D data --> Covariance matrix L\"\>"], "Print",
 CellChangeTimes->{3.5843879136829596`*^9, 3.5843883004335012`*^9}],

Cell[BoxData["\<\"Plot of data, quadratic form of L, and principal \
axes\"\>"], "Print",
 CellChangeTimes->{3.5843879136829596`*^9, 3.5843883004335012`*^9}]
}, Open  ]],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx1XAl0jVfXjphiSGQwFK2SpqqooZQStV8xxdyqolpTDV+rrqKK1qzVoBrE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    "], {{
      {GrayLevel[0.7], Opacity[0.8], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNmwnYl9PWh5/hM8/zPETmECJDyRAZm8wylqkMUcYipDooc4ZjzFxmcjgc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           "]], Polygon3DBox[CompressedData["
1:eJwtlWnQz1UYhs/v/7yWbPEy9rfGmkQpWSqTspWtiYrMWLK0l13bpHWKDxiG
MCXZ2lRC2ZkogwpNTWPLUiP7UpaikK577v+Ha859zvkt5zznfp5Ta8CQ7oNz
KaXRUAD9I6UimI0+CPWylKrDfHRtxq+DB2A3/UvwJPo/PvAt+g8YRL8lfI0+
DhdzfkZzG+Ep9O2wCf0ntENfBWfRmyGHHgxn0POgH7o0aI365hr0atiALs66
ZqI/hbLounAM/Sy04IVCmIyeBNN5Pph/A/0mZOgPGRuB/oR2JO052jG0Y/U/
5hfSn43+HK6kfy18ge4DvzFXmv4o9AL0M7Tnae+grQmnkmOSwnvWXhXTGehq
MCN5D4+jnwjHpiQ0QleAI+jl8Dz6BVgiDfehr4F/0b9AN3RDuIDelTx3L+xM
fuZSzmeis5iZHJsTUDHnGBWEY6C9V2U/VdAT4Rv6U+EGdCEcRa+CpehKcAxd
yPNDNac1863m0ABdHg4nr/nBvGfklb1aE888rDWgK/H+pnAMFbub6D+ErhFe
6wEogx4Q9kIR3I9+ES4me7AV+nfomjmmrcPf0LvyWA/09fIoeg+8hH4Z9qEn
QC/0aLicPNY2nAPy/vfyILo+LEZvT45FSfg1OSbybnvYkuzhpqyjJvyM7sT4
3/kcUu4oh26m/VhrRq+D4ejPoFyWfxa9HzrTX5SsF8K25DHt9bawV7Tnfegu
YW90oj8Q3RSaZD6jVehb4Ub6lWFBOOaKtTzdEBopd/I+PkV7CLbqPDirI+Ez
1tmWh9Poe2CH9kL/UH7P2qv2vJ22WXhvrRmvDw2gTj7PLvDONHQxeQ3WaS3Q
GH01lA17Ul5Ujj4iDXUye2ZWOOeV6yVgibwsz6ErKKfDHpU3y8Br4Wc0l+BL
9DhYk/zOMvR4WEu/Iv254Rqg3C+V+WzeC/9LZ1QMPSc8VwQr0CvDtUU582h4
j9rbSfp96S8Pf1tnPiWcA/J+AXSg/6Pii36f+W3oK8LebMXYdPRUeCc5ZvJy
k3AuytOKzXqolTlGOuvHwv/Wmav2vRX+l2qgvLFBOZHZI/r22+Faqn8oFh+F
Y6eY6GxeD8dOZ6Ra0zhcm1Rz3tW/w2v/QZ4Me1JeVM40R7cI1xLVcNXGO+G7
5BpZKuwZeWVK8tl8EK6tOiPFJsK5rxgtRi+C1ck1WHdFm3Cu6s44HPawvPsX
/bvRe+GuzDVqWNjT8rI8vhHdMbx23SFr0V+Fc113wHPhO0V3iTx/HP0T3JK5
hp4M54Ry4R/mL9M+rbHkPZYLe0ZeUa5oLgvfdXpGtax7uJarpql2Fg/XctVQ
3QUlwrVLd4JqVc9wLVXNehX9Sjh2qkm9wx6SdxSj/wEZLPqD
           "]], 
          Polygon3DBox[{{300, 248, 886, 174, 804}, {296, 247, 884, 171, 
           803}}]}],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl1FOsXUEYBtDT3tq2k9q2nfrWtt2mqW3btm3btm3rrV4nfVjzzd4zmfln
srNTt+ga2iVMIBCIqFkny5BZf5PsFRIInGETm1lKZGOV5Baek5at5l6TH/hI
b97Th2p8oSrf+ER/4oUNBJ7I6qSnJi8JZQC1eEptMlOPV9RlIPV5RgMGMyhY
G7doRE7GB2tjG43ZzkpWMYEdHCMuOxnGcHJxlFTOOtPZsstTnnPTMlg7u1jN
Giaym+PEZw9NWEseJrGOvNwmCkMYSkNuEok4ZOceOchGHW4Qkdhk4S5ZyUQN
rhOBWGTgDhnpR18q85gqjGMs6VjBYY4QkzGMZjnLCE+M4P7uIJT07mG97Old
OKIzipHB+o0dkiP4ziMq8I5uvKU75fnMa77yhq7B/X0Pl2VZUlCGS4ShM3+N
X5AlSUYJzvPH+47ylzwri9KB9hTmBUVIwnwSs4ADHGQu85jFHGbz01ptZTsK
sT9Yh3On0ZzQT0QbWvPD3BlyJlOZzjT2sZcpJGQyCchPPqLSlILcpwCt+G29
czIpzSjOA4rRiQAXSU5zSvOQUnQhLFdISQuiEcJVypGKk6RmIRU5zXo2sIgl
LGYjPUL+/xf+Ae6Ygw4=
       "]]}},
    VertexNormals->CompressedData["
1:eJw0WHc81m/UltKi0BINJBpGqEThSCFSpKWySsioUBJSyi6U3fDLCiUjlDKP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     "]], 
   {GrayLevel[0.3], Thickness[0.008], 
    Line3DBox[{{0, 0, 0}, {2.3829717975082456`, 4.41522474189101, 0.}}], 
    Line3DBox[{{0, 0, 0}, {-2.3829717975082456`, -4.41522474189101, 0.}}], 
    Line3DBox[{{0, 0, 0}, {-0.38672077560826024`, 0.2087197720744579, 0.}}], 
    Line3DBox[{{0, 0, 0}, {0.38672077560826024`, -0.2087197720744579, 0.}}]}, 
   {GrayLevel[0], PointSize[0.015], 
    Point3DBox[{{1.1142766043945715`, 2.1259840726567023`, 0}, {
      1.0975780245280085`, 2.793532817672504, 0}, {
      0.6934017866419816, 3.249060943728264, 0}, {
      0.21914117371122332`, 2.717132417388488, 0}, {
      0.6501991419184786, 1.7838909875437174`, 0}, {
      0.3372080302590398, 2.079966790391866, 0}, {
      0.49459739076485676`, 1.3920437451140732`, 0}, {-0.0755710134250348, 
       1.3415797987112175`, 0}, {
      0.8166130462930768, 1.5973156059750018`, 0}, {
      0.7727564733616671, 1.8846503675524153`, 0}, {
      0.054543553495340125`, 1.2471192953469266`, 0}, {-0.4625214138679826, 
       1.110709157236184, 0}, {-1.3619343616322488`, 0.1504044544507872, 
       0}, {-0.36650763451546886`, -0.481186037052848, 
       0}, {-0.7020645540957221, -1.160836506601716, 0}, {
      0.24410825098301603`, -0.22590296854205683`, 0}, {
      0.8221906498636932, 0.19698208754143698`, 0}, {
      1.4200872384768686`, -0.10544357783457992`, 0}, {
      1.2168378019778898`, 0.6563176044658001, 0}, {
      1.3283504093128595`, 0.21935180399628873`, 0}, {
      1.06231758307046, 0.3415795204240406, 0}, {
      1.9325608326632113`, 1.2449080343572976`, 0}, {
      1.6436379296514363`, 1.7383006806691164`, 0}, {
      1.7302162714155123`, 1.7011951668195588`, 0}, {
      2.4432770476326104`, 1.0011740229129682`, 0}, {
      1.6227462754701887`, 1.6587616856265894`, 0}, {
      1.4332927716633481`, 2.5818865620414773`, 0}, {
      0.6440405167202333, 1.5971742780622424`, 0}, {-0.34389273827403055`, 
       1.2616923311711408`, 0}, {-0.2732842355115114, 0.7877436171072381, 
       0}, {0.0004794589997724197, 0.7875735387414498, 0}, {
      0.678857556212365, 0.2899184992417858, 0}, {-0.10034276430156275`, 
       0.8445014444705388, 0}, {0.6680498396985782, 0.7013905134934801, 0}, {
      0.7065267497986373, 0.45883395187454346`, 
       0}, {-0.10199359966944443`, -0.5373865573040604, 
       0}, {-0.9512918203286488, -0.9051534351768873, 
       0}, {-1.47513151824228, -1.8282026248125023`, 
       0}, {-1.0281277404212235`, -2.224425158147266, 
       0}, {-1.6686851838624621`, -2.2316689392693076`, 
       0}, {-2.319393468464518, -2.518349382919541, 
       0}, {-2.164959158292452, -1.693698763299584, 
       0}, {-1.4254498463124272`, -2.4016411626742276`, 
       0}, {-1.9212922213654808`, -2.920469129040174, 
       0}, {-1.4357385888951617`, -2.880611505525054, 
       0}, {-1.5750851980220264`, -3.8703442467936506`, 
       0}, {-1.2697773822401364`, -3.9132345305499214`, 
       0}, {-1.5415947820621527`, -3.8252608698297434`, 
       0}, {-1.6520984902235605`, -3.7058445325303637`, 
       0}, {-1.6311546949533886`, -4.113015868881666, 0}}]}},
  Axes->False,
  BoxRatios->Automatic,
  BoxStyle->Directive[
    Thickness[0.003]],
  Boxed->True,
  ImageSize->{366.66666666666595`, 298.6666666666667},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->All,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  ViewAngle->0.4797378934096499,
  ViewCenter->{{0.5, 0.5, 0.5}, {0.5151279238760621, 0.5735456257112174}},
  ViewPoint->{1.8853113761088822`, -1.01961510721919, 0.6371703447625594},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{
  3.5632878218890524`*^9, 3.5632879999789653`*^9, 3.563288054937862*^9, 
   3.5632930604553337`*^9, 3.5632944311234846`*^9, 3.5632945084260154`*^9, 
   3.5632945836973457`*^9, 3.5632949029234505`*^9, {3.563295029622436*^9, 
   3.563295076786508*^9}, {3.5632951226553736`*^9, 3.5632951448818083`*^9}, 
   3.5632952438191595`*^9, 3.563295517331585*^9, {3.5632955672828674`*^9, 
   3.5632955811824913`*^9}, {3.563295618875353*^9, 3.563295637198185*^9}, 
   3.5632957499815726`*^9, {3.5632958127112746`*^9, 3.5632958412617226`*^9}, 
   3.5632959568287125`*^9, 3.5632960287980328`*^9, {3.5632961412214174`*^9, 
   3.5632961583854465`*^9}, 3.5632962032639146`*^9, 3.5632962553291936`*^9, {
   3.563296330175312*^9, 3.5632963647293625`*^9}, 3.563296399925413*^9, 
   3.5632964329898615`*^9, 3.563296500587564*^9, 3.5632966151269417`*^9, 
   3.563296896276558*^9, 3.5632969276414046`*^9, 3.563296971790668*^9, 
   3.563297064499205*^9, {3.5632973352568045`*^9, 3.563297364980448*^9}, 
   3.5632974740982084`*^9, 3.563297506317058*^9, {3.563297927694148*^9, 
   3.5632979714138193`*^9}, {3.5632980848768024`*^9, 3.563298111432847*^9}, 
   3.563298151268112*^9, 3.5632982442466574`*^9, 3.563298332573197*^9, 
   3.5632983717892585`*^9, 3.5632985892955866`*^9, 3.563300385265662*^9, 
   3.56330042574092*^9, 3.5633004801782045`*^9, {3.5633005408366966`*^9, 
   3.5633005654283314`*^9}, 3.5633006079947925`*^9, 3.563554571653899*^9, 
   3.5635546555976467`*^9, {3.5635547686198454`*^9, 3.5635547917078857`*^9}, 
   3.563554838211567*^9, 3.5635549081932907`*^9, 3.5635549808114176`*^9, 
   3.563555187654982*^9, 3.563628234968221*^9, 3.5636284286269617`*^9, 
   3.5636285950012536`*^9, 3.563628860618528*^9, 3.563628905733807*^9, 
   3.5636290041591997`*^9, {3.5636290940621576`*^9, 3.5636292348524046`*^9}, 
   3.5636293552690163`*^9, {3.563629570312994*^9, 3.563629593042234*^9}, 
   3.5636302508833914`*^9, 3.5639048755728483`*^9, 3.5639052173382483`*^9, 
   3.5639053209224305`*^9, 3.563905362995704*^9, 3.5639055059855556`*^9, 
   3.5639057836660433`*^9, 3.5647751282731457`*^9, 3.5647751684588165`*^9, 
   3.5702007336594625`*^9, 3.5702008672628956`*^9, {3.570200898759351*^9, 
   3.5702009101005707`*^9}, 3.5702009635774646`*^9, 3.570201029768381*^9, 
   3.570201071560854*^9, 3.584384551618252*^9, 3.584384793888591*^9, 
   3.584385736699912*^9, 3.584386845301464*^9, 3.5843868914115286`*^9, 
   3.5843869424516*^9, 3.58438791370296*^9, 3.584388300453501*^9}],

Cell[BoxData["\<\"Plot of input 2D data with principal axes\"\>"], "Print",
 CellChangeTimes->{3.5843879136829596`*^9, 3.584388300453501*^9}],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], PointSize[0.015], PointBox[CompressedData["
1:eJwBMQPO/CFib1JlAgAAADIAAAACAAAAbilptBPU8T/3BP/vAwIBQFB/gvmt
j/E/KqbhuydZBkBhsJPxWDDmP7kwAKoT/glANPwlZ9EMzD8Jrrzrr7wFQAmr
TW5uzuQ/EBKyRtGK/D9aUHr90JTVP0P+66DFowBAUmiB0Hun3z9i3H2pz0X2
P1ikLzefWLO/6AUHYRx39T81GuqusSHqP1DZEM+ajvk/fYqbyGu66D8Wg9Ak
hyf+P5Cy8PQh7as/Hpy7XDP08z+Gz5Bq85ndv3QnG/d2xfE/diVor3vK9b8g
+YQCdEDDP86b/m/cdNe/0MMbhcDL3r/Ps3AVUHfmv1S3/UzJkvK/tPFTbfA+
zz/AjfpyY+rMv8W6B8RiT+o/MLPxg7U2yT8Gmmtlrbj2P6BsX65Z/rq/RoFA
6ip48z+UB9/GjQDlP/gH2lvsQPU/4Mc9TLgTzD/iDdS4QP/wP3gYTVlw3NU/
thpd6MTr/j/OeeGvJOvzP84WJUlXTPo/EGrhXxTQ+z92yctB9677P/6mWWwY
OPs/KzI11tSLA0BYQWANzwTwP7KabczE9vk/DPx5sUmK+j9IMr5mxO72P6SZ
TyS0pwRAUZiT2/qb5D/IoqSdBo75P54BDrBWAta/ouc/TOQv9D8GMoIpfX3R
v3h3IxoyNek/AKhKufxrPz9Q3QJszTPpPwljUnszueU/gO0vUgaO0j84wRA7
ELC5v4ifreQnBus/WU+zDqpg5T+Mu6WEynHmP11MhPzdm+Y/WB5mFIld3T/Y
SPumQBy6v4DKHUtFMuG/f3Eoi/tw7r8UTD5WBPfsvwZkwoEjmve/NH9AZVFA
/b80g9MSNnPwvxgj1WqfywHA9CRAPO+y+r8WSa0+ddoBwI/jrCkejgLAZlR8
XJQlBMCLVXAb1lEBwJRb2t9jGfu/agCAf6TO9r9ITlOkjzYDwNQujemcvf6/
JqQx6x5dB8D8js4Gyfj2vwKxhQt+CwfATrFeiYwz+b+C7GELd/YOwALAnhYC
UfS/kFHS501OD8BUQkpKX6r4v7ay9F4img7Aqn+U0/5u+r8AOnrRkaUNwKSq
WKo1Gfq/ZhqTbrpzEMDQD5z8
     "]]}, 
   {GrayLevel[0.3], Thickness[0.008], 
    LineBox[{{0, 0}, {2.3829717975082456`, 4.41522474189101}}], 
    LineBox[{{0, 0}, {-2.3829717975082456`, -4.41522474189101}}], 
    LineBox[{{0, 0}, {-0.38672077560826024`, 0.2087197720744579}}], 
    LineBox[{{0, 0}, {0.38672077560826024`, -0.2087197720744579}}]}},
  Axes->True,
  AxesStyle->Directive[
    Thickness[0.0008]],
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 14},
  Ticks->False]], "Output",
 CellChangeTimes->{
  3.5632878218890524`*^9, 3.5632879999789653`*^9, 3.563288054937862*^9, 
   3.5632930604553337`*^9, 3.5632944311234846`*^9, 3.5632945084260154`*^9, 
   3.5632945836973457`*^9, 3.5632949029234505`*^9, {3.563295029622436*^9, 
   3.563295076786508*^9}, {3.5632951226553736`*^9, 3.5632951448818083`*^9}, 
   3.5632952438191595`*^9, 3.563295517331585*^9, {3.5632955672828674`*^9, 
   3.5632955811824913`*^9}, {3.563295618875353*^9, 3.563295637198185*^9}, 
   3.5632957499815726`*^9, {3.5632958127112746`*^9, 3.5632958412617226`*^9}, 
   3.5632959568287125`*^9, 3.5632960287980328`*^9, {3.5632961412214174`*^9, 
   3.5632961583854465`*^9}, 3.5632962032639146`*^9, 3.5632962553291936`*^9, {
   3.563296330175312*^9, 3.5632963647293625`*^9}, 3.563296399925413*^9, 
   3.5632964329898615`*^9, 3.563296500587564*^9, 3.5632966151269417`*^9, 
   3.563296896276558*^9, 3.5632969276414046`*^9, 3.563296971790668*^9, 
   3.563297064499205*^9, {3.5632973352568045`*^9, 3.563297364980448*^9}, 
   3.5632974740982084`*^9, 3.563297506317058*^9, {3.563297927694148*^9, 
   3.5632979714138193`*^9}, {3.5632980848768024`*^9, 3.563298111432847*^9}, 
   3.563298151268112*^9, 3.5632982442466574`*^9, 3.563298332573197*^9, 
   3.5632983717892585`*^9, 3.5632985892955866`*^9, 3.563300385265662*^9, 
   3.56330042574092*^9, 3.5633004801782045`*^9, {3.5633005408366966`*^9, 
   3.5633005654283314`*^9}, 3.5633006079947925`*^9, 3.563554571653899*^9, 
   3.5635546555976467`*^9, {3.5635547686198454`*^9, 3.5635547917078857`*^9}, 
   3.563554838211567*^9, 3.5635549081932907`*^9, 3.5635549808114176`*^9, 
   3.563555187654982*^9, 3.563628234968221*^9, 3.5636284286269617`*^9, 
   3.5636285950012536`*^9, 3.563628860618528*^9, 3.563628905733807*^9, 
   3.5636290041591997`*^9, {3.5636290940621576`*^9, 3.5636292348524046`*^9}, 
   3.5636293552690163`*^9, {3.563629570312994*^9, 3.563629593042234*^9}, 
   3.5636302508833914`*^9, 3.5639048755728483`*^9, 3.5639052173382483`*^9, 
   3.5639053209224305`*^9, 3.563905362995704*^9, 3.5639055059855556`*^9, 
   3.5639057836660433`*^9, 3.5647751282731457`*^9, 3.5647751684588165`*^9, 
   3.5702007336594625`*^9, 3.5702008672628956`*^9, {3.570200898759351*^9, 
   3.5702009101005707`*^9}, 3.5702009635774646`*^9, 3.570201029768381*^9, 
   3.570201071560854*^9, 3.584384551618252*^9, 3.584384793888591*^9, 
   3.584385736699912*^9, 3.584386845301464*^9, 3.5843868914115286`*^9, 
   3.5843869424516*^9, 3.58438791370296*^9, 3.584388300453501*^9}],

Cell[BoxData["\<\"Plot of 2D input data so that coordinates correspond to \
trend lines in data \"\>"], "Print",
 CellChangeTimes->{3.5843879136829596`*^9, 3.584388300453501*^9}],

Cell[BoxData[
 GraphicsBox[
  {GrayLevel[0], PointSize[0.01], PointBox[CompressedData["
1:eJwBMQPO/CFib1JlAgAAADIAAAACAAAA/BqgZXEzA0AA4QXjEOCdP941o85L
1gdANA+CnmoZ1z+Ut580IYIJQOTbXTLR2u0/Tz3zbyP2A0DkqmLEEJDxP5L6
D7P6Dv4/Ds/Fjgyb0T8RaGp6Stn/P8rbNHjfHeY/G+9IBNlb9z+Wt9MAmOrM
P+a7pn67UPI/vR18uaqE5j/wWoOyNbL8PzCLWYR8fqQ/HgdSBEw0AECUYtHB
K4jLP6n9lg5g+fE/9HIxpSJr4T8RbSwljD/oP2qroBvt5+0/gZniK8x24L+i
cnTQt1H0P4WcSTbpHuO/5PvXcZgPuD9I1x5REa71v9jcDBWlBLE/jxVtCg42
tb9mLe/WeZ3Uv/h8tVEQC+I/pHx4Fsco5L/nkrONL53iP/8jQAbdy/S/3Caw
Tfh88j+EGnxUmkrov0gC5PC2Xeo/Bd3rMFUJ8b+ZIbODxMPpP0bh/Z5Buei/
a7GT93cbAEDSuV4+FcDxv6kN3+emewJAqdEiD5nd479sAvpr/owCQN5itbUd
3ua/OLKDuflUAEAE1aBgIsv6v7hfJgX71wFAk7IzcnZ85L9OvCNjaJ8HQOAu
ruZC76G/S5i1aflh+z9459zov43IP3xN9FqOTe4/QmFt0i3c7D+iRn55kQfi
P+HK3dUZq+M/AjVEUIMv5j9oYKeQu+nXP8IM8hRce+I/mPZDO8Rr3b9djuMN
oEHmP6pRys9jUt8/MgU7PKDn7T+sXScR/03Qv9BzHue7qOc/KaVSykHY2b87
v7l94a7gv/qfQB9wLsW/PpNhDk7587+WthXILhDaP7ZFRU7FeQLAWNNOwxGC
2z9ajG+8D5EDwKCHx7dIbMO/wG5QfDENBsAYuVtKGCXaP+3vE/vQigrAnFM6
rRkK6z8Ipoe1XCYEwIg1mz6unPE/hoyLDe5SBsAAVldrwh29P0BZVqlN3AvA
dOzb6S1v0z+exyasKrwJwEAaVjykzbq/Gw8hnbudEMAsyW6TFfDcv4ClmgPl
LxDACvhZoOW357+Ul+WT0WQQwEgpYpAgdN2/2llc/fMuEMAUZOzZnZnTv7NR
lWCukxHAnGFfEQiU4L9Ku5sP
    "]]},
  Axes->True,
  AxesStyle->Directive[
    Thickness[0.0008]],
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 14},
  Ticks->False]], "Output",
 CellChangeTimes->{
  3.5632878218890524`*^9, 3.5632879999789653`*^9, 3.563288054937862*^9, 
   3.5632930604553337`*^9, 3.5632944311234846`*^9, 3.5632945084260154`*^9, 
   3.5632945836973457`*^9, 3.5632949029234505`*^9, {3.563295029622436*^9, 
   3.563295076786508*^9}, {3.5632951226553736`*^9, 3.5632951448818083`*^9}, 
   3.5632952438191595`*^9, 3.563295517331585*^9, {3.5632955672828674`*^9, 
   3.5632955811824913`*^9}, {3.563295618875353*^9, 3.563295637198185*^9}, 
   3.5632957499815726`*^9, {3.5632958127112746`*^9, 3.5632958412617226`*^9}, 
   3.5632959568287125`*^9, 3.5632960287980328`*^9, {3.5632961412214174`*^9, 
   3.5632961583854465`*^9}, 3.5632962032639146`*^9, 3.5632962553291936`*^9, {
   3.563296330175312*^9, 3.5632963647293625`*^9}, 3.563296399925413*^9, 
   3.5632964329898615`*^9, 3.563296500587564*^9, 3.5632966151269417`*^9, 
   3.563296896276558*^9, 3.5632969276414046`*^9, 3.563296971790668*^9, 
   3.563297064499205*^9, {3.5632973352568045`*^9, 3.563297364980448*^9}, 
   3.5632974740982084`*^9, 3.563297506317058*^9, {3.563297927694148*^9, 
   3.5632979714138193`*^9}, {3.5632980848768024`*^9, 3.563298111432847*^9}, 
   3.563298151268112*^9, 3.5632982442466574`*^9, 3.563298332573197*^9, 
   3.5632983717892585`*^9, 3.5632985892955866`*^9, 3.563300385265662*^9, 
   3.56330042574092*^9, 3.5633004801782045`*^9, {3.5633005408366966`*^9, 
   3.5633005654283314`*^9}, 3.5633006079947925`*^9, 3.563554571653899*^9, 
   3.5635546555976467`*^9, {3.5635547686198454`*^9, 3.5635547917078857`*^9}, 
   3.563554838211567*^9, 3.5635549081932907`*^9, 3.5635549808114176`*^9, 
   3.563555187654982*^9, 3.563628234968221*^9, 3.5636284286269617`*^9, 
   3.5636285950012536`*^9, 3.563628860618528*^9, 3.563628905733807*^9, 
   3.5636290041591997`*^9, {3.5636290940621576`*^9, 3.5636292348524046`*^9}, 
   3.5636293552690163`*^9, {3.563629570312994*^9, 3.563629593042234*^9}, 
   3.5636302508833914`*^9, 3.5639048755728483`*^9, 3.5639052173382483`*^9, 
   3.5639053209224305`*^9, 3.563905362995704*^9, 3.5639055059855556`*^9, 
   3.5639057836660433`*^9, 3.5647751282731457`*^9, 3.5647751684588165`*^9, 
   3.5702007336594625`*^9, 3.5702008672628956`*^9, {3.570200898759351*^9, 
   3.5702009101005707`*^9}, 3.5702009635774646`*^9, 3.570201029768381*^9, 
   3.570201071560854*^9, 3.584384551618252*^9, 3.584384793888591*^9, 
   3.584385736699912*^9, 3.584386845301464*^9, 3.5843868914115286`*^9, 
   3.5843869424516*^9, 3.58438791370296*^9, 3.584388300463501*^9}],

Cell[BoxData["\<\"Plot of input data, axis aligned data, and highest variance \
coordinate \"\>"], "Print",
 CellChangeTimes->{3.5843879136829596`*^9, 3.584388300463501*^9}],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], PointSize[0.01], PointBox[CompressedData["
1:eJwBMQPO/CFib1JlAgAAADIAAAACAAAA/BqgZXEzA0AA4QXjEOCdP941o85L
1gdANA+CnmoZ1z+Ut580IYIJQOTbXTLR2u0/Tz3zbyP2A0DkqmLEEJDxP5L6
D7P6Dv4/Ds/Fjgyb0T8RaGp6Stn/P8rbNHjfHeY/G+9IBNlb9z+Wt9MAmOrM
P+a7pn67UPI/vR18uaqE5j/wWoOyNbL8PzCLWYR8fqQ/HgdSBEw0AECUYtHB
K4jLP6n9lg5g+fE/9HIxpSJr4T8RbSwljD/oP2qroBvt5+0/gZniK8x24L+i
cnTQt1H0P4WcSTbpHuO/5PvXcZgPuD9I1x5REa71v9jcDBWlBLE/jxVtCg42
tb9mLe/WeZ3Uv/h8tVEQC+I/pHx4Fsco5L/nkrONL53iP/8jQAbdy/S/3Caw
Tfh88j+EGnxUmkrov0gC5PC2Xeo/Bd3rMFUJ8b+ZIbODxMPpP0bh/Z5Buei/
a7GT93cbAEDSuV4+FcDxv6kN3+emewJAqdEiD5nd479sAvpr/owCQN5itbUd
3ua/OLKDuflUAEAE1aBgIsv6v7hfJgX71wFAk7IzcnZ85L9OvCNjaJ8HQOAu
ruZC76G/S5i1aflh+z9459zov43IP3xN9FqOTe4/QmFt0i3c7D+iRn55kQfi
P+HK3dUZq+M/AjVEUIMv5j9oYKeQu+nXP8IM8hRce+I/mPZDO8Rr3b9djuMN
oEHmP6pRys9jUt8/MgU7PKDn7T+sXScR/03Qv9BzHue7qOc/KaVSykHY2b87
v7l94a7gv/qfQB9wLsW/PpNhDk7587+WthXILhDaP7ZFRU7FeQLAWNNOwxGC
2z9ajG+8D5EDwKCHx7dIbMO/wG5QfDENBsAYuVtKGCXaP+3vE/vQigrAnFM6
rRkK6z8Ipoe1XCYEwIg1mz6unPE/hoyLDe5SBsAAVldrwh29P0BZVqlN3AvA
dOzb6S1v0z+exyasKrwJwEAaVjykzbq/Gw8hnbudEMAsyW6TFfDcv4ClmgPl
LxDACvhZoOW357+Ul+WT0WQQwEgpYpAgdN2/2llc/fMuEMAUZOzZnZnTv7NR
lWCukxHAnGFfEQiU4L9Ku5sP
     "]]}, 
   {GrayLevel[0.5], PointSize[0.02], 
    PointBox[{{2.4001186313138287`, 0}, {2.9796367782171123`, 0}, {
      3.1885398970834533`, 0}, {2.4951847787957955`, 0}, {
      1.878657054388587, 0}, {1.990549543558249, 0}, {
      1.4599237601641508`, 0}, {1.1447100589100443`, 0}, {
      1.7935082410019128`, 0}, {2.0255356156857394`, 0}, {
      1.1233826227106454`, 0}, {
      0.757757256130761, 0}, {-0.5145016533977441, 0}, {-0.5975233135512928, 
       0}, {-1.3549969834106879`, 0}, {-0.0828560615019198, 0}, {
      0.5638505550267885, 0}, {0.5816877143484732, 0}, {
      1.1555102381411677`, 0}, {0.823939772119112, 0}, {
      0.8051474163303737, 0}, {2.0134124128291453`, 0}, {
      2.310376941198872, 0}, {2.318844646041091, 0}, {
      2.0414919369998437`, 0}, {2.2304592516265664`, 0}, {
      2.9528358216553334`, 0}, {1.71141949932782, 0}, {
      0.9469672943545642, 0}, {0.5634238598742807, 0}, {
      0.6932999198631082, 0}, {0.577558556470102, 0}, {
      0.695510890127888, 0}, {0.9345246483209506, 0}, {
      0.7393474115411838, 0}, {-0.5213477569177266, 0}, {-1.2483654557956494`,
        0}, {-2.30945836209204, 0}, {-2.4458307954351257`, 
       0}, {-2.756442042545899, 0}, {-3.317781411691604, 
       0}, {-2.5187315160771995`, 0}, {-2.7904931123935652`, 
       0}, {-3.4825700025059234`, 0}, {-3.21687826627108, 
       0}, {-4.154036002295267, 0}, {-4.046772056878922, 
       0}, {-4.09845572556323, 0}, {-4.045852621804864, 
       0}, {-4.394219884027211, 0}}]}},
  Axes->True,
  AxesStyle->Directive[
    Thickness[0.0008]],
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 14},
  Ticks->False]], "Output",
 CellChangeTimes->{
  3.5632878218890524`*^9, 3.5632879999789653`*^9, 3.563288054937862*^9, 
   3.5632930604553337`*^9, 3.5632944311234846`*^9, 3.5632945084260154`*^9, 
   3.5632945836973457`*^9, 3.5632949029234505`*^9, {3.563295029622436*^9, 
   3.563295076786508*^9}, {3.5632951226553736`*^9, 3.5632951448818083`*^9}, 
   3.5632952438191595`*^9, 3.563295517331585*^9, {3.5632955672828674`*^9, 
   3.5632955811824913`*^9}, {3.563295618875353*^9, 3.563295637198185*^9}, 
   3.5632957499815726`*^9, {3.5632958127112746`*^9, 3.5632958412617226`*^9}, 
   3.5632959568287125`*^9, 3.5632960287980328`*^9, {3.5632961412214174`*^9, 
   3.5632961583854465`*^9}, 3.5632962032639146`*^9, 3.5632962553291936`*^9, {
   3.563296330175312*^9, 3.5632963647293625`*^9}, 3.563296399925413*^9, 
   3.5632964329898615`*^9, 3.563296500587564*^9, 3.5632966151269417`*^9, 
   3.563296896276558*^9, 3.5632969276414046`*^9, 3.563296971790668*^9, 
   3.563297064499205*^9, {3.5632973352568045`*^9, 3.563297364980448*^9}, 
   3.5632974740982084`*^9, 3.563297506317058*^9, {3.563297927694148*^9, 
   3.5632979714138193`*^9}, {3.5632980848768024`*^9, 3.563298111432847*^9}, 
   3.563298151268112*^9, 3.5632982442466574`*^9, 3.563298332573197*^9, 
   3.5632983717892585`*^9, 3.5632985892955866`*^9, 3.563300385265662*^9, 
   3.56330042574092*^9, 3.5633004801782045`*^9, {3.5633005408366966`*^9, 
   3.5633005654283314`*^9}, 3.5633006079947925`*^9, 3.563554571653899*^9, 
   3.5635546555976467`*^9, {3.5635547686198454`*^9, 3.5635547917078857`*^9}, 
   3.563554838211567*^9, 3.5635549081932907`*^9, 3.5635549808114176`*^9, 
   3.563555187654982*^9, 3.563628234968221*^9, 3.5636284286269617`*^9, 
   3.5636285950012536`*^9, 3.563628860618528*^9, 3.563628905733807*^9, 
   3.5636290041591997`*^9, {3.5636290940621576`*^9, 3.5636292348524046`*^9}, 
   3.5636293552690163`*^9, {3.563629570312994*^9, 3.563629593042234*^9}, 
   3.5636302508833914`*^9, 3.5639048755728483`*^9, 3.5639052173382483`*^9, 
   3.5639053209224305`*^9, 3.563905362995704*^9, 3.5639055059855556`*^9, 
   3.5639057836660433`*^9, 3.5647751282731457`*^9, 3.5647751684588165`*^9, 
   3.5702007336594625`*^9, 3.5702008672628956`*^9, {3.570200898759351*^9, 
   3.5702009101005707`*^9}, 3.5702009635774646`*^9, 3.570201029768381*^9, 
   3.570201071560854*^9, 3.584384551618252*^9, 3.584384793888591*^9, 
   3.584385736699912*^9, 3.584386845301464*^9, 3.5843868914115286`*^9, 
   3.5843869424516*^9, 3.58438791370296*^9, 3.584388300463501*^9}],

Cell[BoxData["\<\"Plot of input data, axis aligned data, and lowest variance \
coordinate \"\>"], "Print",
 CellChangeTimes->{3.5843879136829596`*^9, 3.584388300463501*^9}],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0.5], PointSize[0.02], 
    PointBox[{{0, 0.029175056320554837`}, {0, 0.36092629889775485`}, {
      0, 0.9329610809062356}, {0, 1.0976722403817627`}, {
      0, 0.27508844320912906`}, {0, 0.6911465976507938}, {
      0, 0.22590923347837294`}, {0, 0.7036946890593111}, {
      0, 0.040027514606455816`}, {0, 0.21509310687794836`}, {
      0, 0.5443280435971176}, {0, 0.9345613040544383}, {
      0, 1.2699506895798227`}, {0, 0.09398796824824235}, {
      0, 0.06647712482377999}, {0, -0.32211156835247434`}, {
      0, -0.6299777449493331}, {0, -1.2997713321840363`}, {
      0, -0.7591067934125282}, {0, -1.0647785101880924`}, {
      0, -0.7726142983729367}, {0, -1.1093952595070857`}, {
      0, -0.6208005233407238}, {0, -0.7146137761111182}, {
      0, -1.6745933317700414`}, {0, -0.6401931982523642}, {
      0, -0.035028544100979664`}, {0, 0.1918258559251702}, {
      0, 0.9018773183734441}, {0, 0.6146363427236247}, {
      0, 0.3736409103999052}, {0, -0.4597025469555347}, {
      0, 0.48940367977163624`}, {0, -0.254760519744617}, {
      0, -0.403824279385463}, {0, -0.16547967458723162`}, {
      0, 0.40723771609814585`}, {0, 0.4298138053230125}, {
      0, -0.1517420670853058}, {0, 0.40851409207870537`}, {
      0, 0.8449829467159478}, {0, 1.100752110057643}, {
      0, 0.11373534317620937`}, {0, 0.303660848978047}, {
      0, -0.10470034096770409`}, {0, -0.4521535815976161}, {
      0, -0.7411983615745623}, {0, -0.46021284198709056`}, {
      0, -0.30625101358015283`}, {0, -0.5180702533062234}}]}, 
   {GrayLevel[0], PointSize[0.01], PointBox[CompressedData["
1:eJwBMQPO/CFib1JlAgAAADIAAAACAAAA/BqgZXEzA0AA4QXjEOCdP941o85L
1gdANA+CnmoZ1z+Ut580IYIJQOTbXTLR2u0/Tz3zbyP2A0DkqmLEEJDxP5L6
D7P6Dv4/Ds/Fjgyb0T8RaGp6Stn/P8rbNHjfHeY/G+9IBNlb9z+Wt9MAmOrM
P+a7pn67UPI/vR18uaqE5j/wWoOyNbL8PzCLWYR8fqQ/HgdSBEw0AECUYtHB
K4jLP6n9lg5g+fE/9HIxpSJr4T8RbSwljD/oP2qroBvt5+0/gZniK8x24L+i
cnTQt1H0P4WcSTbpHuO/5PvXcZgPuD9I1x5REa71v9jcDBWlBLE/jxVtCg42
tb9mLe/WeZ3Uv/h8tVEQC+I/pHx4Fsco5L/nkrONL53iP/8jQAbdy/S/3Caw
Tfh88j+EGnxUmkrov0gC5PC2Xeo/Bd3rMFUJ8b+ZIbODxMPpP0bh/Z5Buei/
a7GT93cbAEDSuV4+FcDxv6kN3+emewJAqdEiD5nd479sAvpr/owCQN5itbUd
3ua/OLKDuflUAEAE1aBgIsv6v7hfJgX71wFAk7IzcnZ85L9OvCNjaJ8HQOAu
ruZC76G/S5i1aflh+z9459zov43IP3xN9FqOTe4/QmFt0i3c7D+iRn55kQfi
P+HK3dUZq+M/AjVEUIMv5j9oYKeQu+nXP8IM8hRce+I/mPZDO8Rr3b9djuMN
oEHmP6pRys9jUt8/MgU7PKDn7T+sXScR/03Qv9BzHue7qOc/KaVSykHY2b87
v7l94a7gv/qfQB9wLsW/PpNhDk7587+WthXILhDaP7ZFRU7FeQLAWNNOwxGC
2z9ajG+8D5EDwKCHx7dIbMO/wG5QfDENBsAYuVtKGCXaP+3vE/vQigrAnFM6
rRkK6z8Ipoe1XCYEwIg1mz6unPE/hoyLDe5SBsAAVldrwh29P0BZVqlN3AvA
dOzb6S1v0z+exyasKrwJwEAaVjykzbq/Gw8hnbudEMAsyW6TFfDcv4ClmgPl
LxDACvhZoOW357+Ul+WT0WQQwEgpYpAgdN2/2llc/fMuEMAUZOzZnZnTv7NR
lWCukxHAnGFfEQiU4L9Ku5sP
     "]]}},
  Axes->True,
  AxesStyle->Directive[
    Thickness[0.0008]],
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 14},
  Ticks->False]], "Output",
 CellChangeTimes->{
  3.5632878218890524`*^9, 3.5632879999789653`*^9, 3.563288054937862*^9, 
   3.5632930604553337`*^9, 3.5632944311234846`*^9, 3.5632945084260154`*^9, 
   3.5632945836973457`*^9, 3.5632949029234505`*^9, {3.563295029622436*^9, 
   3.563295076786508*^9}, {3.5632951226553736`*^9, 3.5632951448818083`*^9}, 
   3.5632952438191595`*^9, 3.563295517331585*^9, {3.5632955672828674`*^9, 
   3.5632955811824913`*^9}, {3.563295618875353*^9, 3.563295637198185*^9}, 
   3.5632957499815726`*^9, {3.5632958127112746`*^9, 3.5632958412617226`*^9}, 
   3.5632959568287125`*^9, 3.5632960287980328`*^9, {3.5632961412214174`*^9, 
   3.5632961583854465`*^9}, 3.5632962032639146`*^9, 3.5632962553291936`*^9, {
   3.563296330175312*^9, 3.5632963647293625`*^9}, 3.563296399925413*^9, 
   3.5632964329898615`*^9, 3.563296500587564*^9, 3.5632966151269417`*^9, 
   3.563296896276558*^9, 3.5632969276414046`*^9, 3.563296971790668*^9, 
   3.563297064499205*^9, {3.5632973352568045`*^9, 3.563297364980448*^9}, 
   3.5632974740982084`*^9, 3.563297506317058*^9, {3.563297927694148*^9, 
   3.5632979714138193`*^9}, {3.5632980848768024`*^9, 3.563298111432847*^9}, 
   3.563298151268112*^9, 3.5632982442466574`*^9, 3.563298332573197*^9, 
   3.5632983717892585`*^9, 3.5632985892955866`*^9, 3.563300385265662*^9, 
   3.56330042574092*^9, 3.5633004801782045`*^9, {3.5633005408366966`*^9, 
   3.5633005654283314`*^9}, 3.5633006079947925`*^9, 3.563554571653899*^9, 
   3.5635546555976467`*^9, {3.5635547686198454`*^9, 3.5635547917078857`*^9}, 
   3.563554838211567*^9, 3.5635549081932907`*^9, 3.5635549808114176`*^9, 
   3.563555187654982*^9, 3.563628234968221*^9, 3.5636284286269617`*^9, 
   3.5636285950012536`*^9, 3.563628860618528*^9, 3.563628905733807*^9, 
   3.5636290041591997`*^9, {3.5636290940621576`*^9, 3.5636292348524046`*^9}, 
   3.5636293552690163`*^9, {3.563629570312994*^9, 3.563629593042234*^9}, 
   3.5636302508833914`*^9, 3.5639048755728483`*^9, 3.5639052173382483`*^9, 
   3.5639053209224305`*^9, 3.563905362995704*^9, 3.5639055059855556`*^9, 
   3.5639057836660433`*^9, 3.5647751282731457`*^9, 3.5647751684588165`*^9, 
   3.5702007336594625`*^9, 3.5702008672628956`*^9, {3.570200898759351*^9, 
   3.5702009101005707`*^9}, 3.5702009635774646`*^9, 3.570201029768381*^9, 
   3.570201071560854*^9, 3.584384551618252*^9, 3.584384793888591*^9, 
   3.584385736699912*^9, 3.584386845301464*^9, 3.5843868914115286`*^9, 
   3.5843869424516*^9, 3.58438791370296*^9, 3.584388300463501*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1112, 708},
WindowMargins->{{Automatic, 35}, {10, Automatic}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 673, 13, 135, "Subtitle"],
Cell[1255, 37, 1023, 17, 162, "Subsubtitle"],
Cell[CellGroupData[{
Cell[2303, 58, 106, 4, 97, "Section"],
Cell[2412, 64, 640, 17, 72, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3089, 86, 120, 4, 97, "Section"],
Cell[3212, 92, 619, 16, 72, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3868, 113, 344, 6, 71, "Section"],
Cell[4215, 121, 17894, 441, 872, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22146, 567, 311, 6, 97, "Section"],
Cell[CellGroupData[{
Cell[22482, 577, 9334, 212, 672, "Input"],
Cell[31819, 791, 1394, 30, 36, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33262, 827, 432, 8, 72, "Section"],
Cell[CellGroupData[{
Cell[33719, 839, 14962, 394, 1412, "Input"],
Cell[CellGroupData[{
Cell[48706, 1237, 2251, 31, 23, "Print"],
Cell[50960, 1270, 3985, 74, 36, "Print"],
Cell[54948, 1346, 3168, 57, 36, "Print"],
Cell[58119, 1405, 3174, 57, 36, "Print"],
Cell[61296, 1464, 3027, 53, 36, "Print"],
Cell[64326, 1519, 3258, 57, 36, "Print"],
Cell[67587, 1578, 3143, 55, 36, "Print"],
Cell[70733, 1635, 4019, 74, 36, "Print"],
Cell[74755, 1711, 2701, 44, 23, "Print"],
Cell[77459, 1757, 2556, 39, 23, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[80076, 1803, 144, 2, 71, "Section"],
Cell[CellGroupData[{
Cell[80245, 1809, 19880, 467, 1592, "Input"],
Cell[CellGroupData[{
Cell[100150, 2280, 103, 1, 23, "Print"],
Cell[100256, 2283, 139, 1, 23, "Print"],
Cell[100398, 2286, 157, 2, 23, "Print"]
}, Open  ]],
Cell[100570, 2291, 60755, 1006, 314, "Output"],
Cell[161328, 3299, 141, 1, 23, "Print"],
Cell[161472, 3302, 4160, 66, 447, "Output"],
Cell[165635, 3370, 178, 2, 23, "Print"],
Cell[165816, 3374, 3845, 61, 164, "Output"],
Cell[169664, 3437, 173, 2, 23, "Print"],
Cell[169840, 3441, 5348, 87, 164, "Output"],
Cell[175191, 3530, 172, 2, 23, "Print"],
Cell[175366, 3534, 5385, 87, 164, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
