(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      8587,        240]
NotebookOptionsPosition[      8152,        220]
NotebookOutlinePosition[      8495,        235]
CellTagsIndexPosition[      8452,        232]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9},
 FontFamily->"Arial"],

Cell[TextData[{
 StyleBox["Points, Lines, and Vectors",
  FontWeight->"Bold"],
 "\[LineSeparator]A vector denotes a direction; it is not fixed anywhere in a \
coordinate system. A ",
 StyleBox["point",
  FontSlant->"Italic"],
 " defines a fixed position.\nA ",
 StyleBox["line",
  FontSlant->"Italic"],
 " through a point ",
 StyleBox["p",
  FontWeight->"Bold"],
 " with direction",
 StyleBox[" v",
  FontWeight->"Bold"],
 " is given by the ",
 StyleBox["parametric equation",
  FontSlant->"Italic"],
 "\n",
 Cell[BoxData[
  FormBox["\t", TraditionalForm]]],
 "\n\t",
 StyleBox["l",
  FontWeight->"Bold"],
 "(t)=",
 StyleBox["p",
  FontWeight->"Bold"],
 " + t",
 StyleBox["v",
  FontWeight->"Bold"],
 "."
}], "Subtitle",
 CellChangeTimes->{{3.519060513774078*^9, 3.5190605260200996`*^9}, 
   3.5191436408642206`*^9, {3.5191438075661135`*^9, 3.519143812292922*^9}, 
   3.5191438595610046`*^9, {3.519157313645429*^9, 3.5191573189026384`*^9}, {
   3.5199954282316127`*^9, 3.5199954583084655`*^9}, {3.521982554375939*^9, 
   3.5219825769305024`*^9}, {3.52198408942924*^9, 3.5219840905523973`*^9}, 
   3.5847992962780437`*^9},
 FontSize->18,
 FontColor->GrayLevel[0]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "input", " ", "point", " ", "p", " ", "and", " ", "vector", " ", "v"}], 
   " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"p", "=", 
     RowBox[{"{", 
      StyleBox[
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}],
       FontColor->GrayLevel[0]], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"v", "=", 
     RowBox[{"{", 
      StyleBox[
       RowBox[{"2", ",", 
        RowBox[{"-", "1"}]}],
       FontColor->GrayLevel[0]], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"start", " ", "and", " ", "end", " ", "t"}], "-", 
     RowBox[{"paramter", " ", "for", " ", "line", " ", "definition"}]}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"startt", " ", "=", " ", 
     RowBox[{"-", "1"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"endt", " ", "=", " ", "2"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"parametric", " ", "equation", " ", "of", " ", "line"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"l", "[", "t_", "]"}], ":=", " ", 
     RowBox[{"p", " ", "+", " ", 
      RowBox[{"t", "*", "v"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"graphics", " ", "entities"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"arrowpv", "=", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Thick", ",", 
       RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{"p", ",", 
          RowBox[{"p", "+", "v"}]}], "}"}], "]"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lineplot", "=", 
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{"l", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "startt", ",", "endt"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", " ", "Thick"}], ",", 
       RowBox[{"PlotLabel", "\[Rule]", 
        RowBox[{"Style", "[", 
         RowBox[{"\"\<Line: l(t) = p + t*v\>\"", ",", "20"}], "]"}]}]}], 
      "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"arrowplot", "=", 
     RowBox[{"Graphics", "[", "arrowpv", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pplot", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
        RowBox[{"Point", "[", "p", "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"lineplot", ",", "arrowplot", ",", "pplot"}], "]"}], 
   " "}]}]], "Input",
 CellChangeTimes->{{3.584799341918108*^9, 3.5847995129683475`*^9}, {
  3.58479955811841*^9, 3.584799592988459*^9}, {3.58479962938851*^9, 
  3.5847996585585513`*^9}, {3.584799691298597*^9, 3.584799755868687*^9}, {
  3.584799794458741*^9, 3.58479990062889*^9}, {3.584799947798956*^9, 
  3.5848000208190584`*^9}, {3.5848000618791156`*^9, 3.584800079849141*^9}, {
  3.584800166549262*^9, 3.584800195549303*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {Hue[0.67, 0.6, 0.6], Thickness[Large], LineBox[CompressedData["
1:eJwt1H9ME2cYwPHyq68zTsXBYBORn3EFxqAJYhR43pHhFGTEDgQdCCvdJBMG
ZrMKakQFFSWMMWAONmUMUYcSfijaoTwHFkWBoaAGgSkwYEXbXsUWugrtWM9L
Lp/L5X2+7939ca7idNEXljweL3L+/F/uWMC8vqD1ESdWr5slDKcJxD/apUn1
hOE0gdxXMKDUEIbTBMcSRJcfjxCG0wSLm6tSGm8ShtMETtKN9788RhhOE6xR
FlV2LyYMpwlC/PQHN7/BZziNcMXlZqLA3obhnIOUX9uiOz2tGc5ZUGQW57i7
WTGcr2DA2NnU84Elw2mA8sGH7kKBBcP5L5RusKvevorHcOqBL8+IaUkzopX4
mtfT1TOwvzrhgbdkFkP6fJ/ZC6fh0Yh93IcHDPhcs/BiRYgOqoID+c/P6LH3
9PIjuigtLN04J7Aom8bjVcZiXuRLSLxUIMImLdZt+fhC4mdTEN4q10z+PoVn
k8T6b2NewEVdsuz8eQ0+MtTHR0drYNjmlzdXFqlQc/jPo0vuqKHyYPMP7Ycm
8T7+dWeUUYJXTYb79aZxLIm5Zrt98Bk8C0g/fbJsBHVlgT1h3Qrws8oe4rsP
YhfP5WprxwTYGT/5rrS8D3Ox77fxiTHo//pz/7q/b+Hg+z586dAoZFQaL3SX
1KKdLiqtVjsMzA6JR4XfJciRyeZ0Pk+gMDG/J/HwbXBSOC1KWTkAi9J7r9Zs
7oOsjrc9vGIfwRAbUb87ZxCWLdi2qj24F77aU5i9p2MEfGyfGpemd4Fb2Jiz
JG8cru8ObAtUyaGiUX1/T/kkZPuHXXMpkkFchnjfuhQV0ANKD4+WKlg2bZHy
vFADtC2El7aiCOOta3/eVDoFw24Z45KGyyiXFXTZZM5/53/WCh3GWrEA7x4V
5UzDGqPX8nDbuyhNXRc0k6oHZb90r/rxPVToQ2+TTQa49yK3YMmpB9jy8OxQ
zaezsL8mQhZ7rh/rtgarzq0xQlJj1kDUriG0cnCUL3fnUb6v3/HA9cP4UhO/
/x1PCzoxItMLw0dxl3OQ8Ka9JR0N2is56j2GrtoNl5retaKhiu+3pQVMYNIK
jeeWxdaUWTsccdFJgZImcZ73nDXtSG1fFmuYxJ9mLBvCeXwqZG0kJTwlJuQH
99tP8ekfjvvqvMdU6FM6lB05zadxPjKLcqUKDWf2CXINfKqFGdFCnQpPNcqy
tJaE+u34RqewUWPvQMCKvrcIrbqyc231KjWuF/iKCwMIzRfFy112qtH3lrNy
YSah8eZ91Djbc6M49AChenNXjZ2P44OzDhFaau6ymKIqK5jMI/SeuctipZ2D
f0cZoR+Zuyw6JC+R5l4nlOuyOJFa63yDIbTL3GHxsjTytlZOKNdhUXTipKOk
e/75zB0W8+tJc+gTQh3NHRa3NVcnZ40Sys2xKGgPW9QwQSg3x+Kt/iMJruz8
+5jnWCwedeNvfUnoe+Z1LCYrW2sLZwjl1rEonE6K7XhFqMR8n8XX/y/KqcH/
AEEnclo=
      "]]}}, 
   {RGBColor[1, 0, 0], Thickness[Large], Arrowheads[Large], 
    ArrowBox[{{-1, 1}, {1, 0}}]}, 
   {RGBColor[1, 0, 0], PointSize[Large], PointBox[{-1, 1}]}},
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 12},
  PlotLabel->FormBox[
    StyleBox["\"Line: l(t) = p + t*v\"", 20, StripOnInput -> False], 
    TraditionalForm],
  PlotRange->{{-3., 3.}, {-1., 2.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.584799431988234*^9, {3.584799473458292*^9, 3.584799513938349*^9}, {
   3.584799802828753*^9, 3.584799837698802*^9}, 3.5847998699788475`*^9, {
   3.58479998636901*^9, 3.58480002202906*^9}, {3.5848000657391214`*^9, 
   3.5848000818791437`*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{911, 630},
WindowMargins->{{Automatic, 49}, {Automatic, 35}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 691, 12, 107, "Subtitle"],
Cell[1273, 36, 1162, 40, 154, "Subtitle"],
Cell[CellGroupData[{
Cell[2460, 80, 3236, 86, 412, "Input"],
Cell[5699, 168, 2425, 48, 226, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
