(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     23636,        589]
NotebookOptionsPosition[     22747,        552]
NotebookOutlinePosition[     23091,        567]
CellTagsIndexPosition[     23048,        564]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 "\n"
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
  3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
  3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
  3.5842134956497355`*^9, 3.5842135862546945`*^9}},
 FontFamily->"Arial"],

Cell[TextData[{
 StyleBox["Polynomial interpolation",
  FontWeight->"Bold"],
 " \nPolynomial defined as p (t) = a0 + a1t + a2t^2 + a3t^3  + a4t^4 + ... + \
ant^n\nFit a degree n polynomial to (n+1) pairs of data (t_i, p(t_i))  i=0,n\n\
\nSet up linear system Ma = b where\nthe ith row of M is [1  t_i  t_i^2 .... \
t_i^n], \na is [a0 a1 ... an]^T,\nb = [p(t_0  p(t_1) ... p(t_n)]^T\n\n"
}], "Subsubtitle",
 CellChangeTimes->{{3.5590460729870405`*^9, 3.5590461031262937`*^9}, {
  3.584399435402521*^9, 3.584399436272522*^9}, {3.5843994665225644`*^9, 
  3.5843994799925833`*^9}, {3.5843995354426613`*^9, 3.58439955590269*^9}, {
  3.584399598612749*^9, 3.5843996905928783`*^9}, {3.5843999170231953`*^9, 
  3.584399931913216*^9}, {3.5843999621532583`*^9, 3.584400114783472*^9}}],

Cell[CellGroupData[{

Cell["Create input data", "Section",
 CellChangeTimes->{{3.584399702352895*^9, 3.5843997122929087`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Pick", " ", "a", " ", "data", " ", "set", " ", "and", " ", "load", " ", 
    "it", " ", "into", " ", "data"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"data1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"5", ",", "7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"13", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"data2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.25", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5", ",", " ", "0.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.75", ",", "0.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"data3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"data", " ", "=", " ", "data2"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"n", " ", "is", " ", "degree", " ", "of", " ", "curve"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n", " ", "=", " ", 
     RowBox[{
      RowBox[{"Length", "[", "data", "]"}], " ", "-", " ", "1"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<data = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "data", "]"}], ",", 
      "\"\<  fit degree n=\>\"", ",", "n", ",", "\"\< curve\>\""}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.5590461057782984`*^9, 3.5590463148498654`*^9}, 
   3.559046438183682*^9, {3.559046534233051*^9, 3.559046667691285*^9}, {
   3.5590467503402305`*^9, 3.5590467721334686`*^9}, {3.5590468028343225`*^9, 
   3.559046884406866*^9}, {3.559047004542677*^9, 3.559047122432084*^9}, {
   3.559047156221743*^9, 3.559047298244393*^9}, {3.559047462278681*^9, 
   3.5590474913415318`*^9}, {3.5590475480632315`*^9, 3.559047590261306*^9}, {
   3.559047977578786*^9, 3.559047991728011*^9}, {3.5590480708357496`*^9, 
   3.5590480775749617`*^9}, {3.5590483661754684`*^9, 
   3.5590483753482847`*^9}, {3.5590484106355467`*^9, 
   3.5590484175931587`*^9}, {3.5590484915060883`*^9, 
   3.5590485353265657`*^9}, {3.5590486376471453`*^9, 3.55904864056435*^9}, {
   3.559048851514722*^9, 3.559048920342043*^9}, {3.559070397926655*^9, 
   3.5590703985506563`*^9}, {3.5843997191729183`*^9, 
   3.5843998142130513`*^9}, {3.5843998443030934`*^9, 3.584399855123109*^9}, {
   3.5844001333034983`*^9, 3.5844001349135003`*^9}, {3.584400171443551*^9, 
   3.584400204073597*^9}, {3.584400374683836*^9, 3.584400387933854*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"data = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0"},
       {"1", "2"},
       {"5", "7"},
       {"10", "7"},
       {"13", "1"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"  fit degree n=\"\>",
    "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\" curve\"\>"}],
  SequenceForm["data = ", 
   MatrixForm[{{0, 0}, {1, 2}, {5, 7}, {10, 7}, {13, 1}}], "  fit degree n=", 
   4, " curve"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.5844003699938297`*^9, 3.5844003803938437`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

Set up linear system and solve\
\>", "Section",
 CellChangeTimes->{{3.5844002062436*^9, 3.5844002236736245`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Create", " ", "Vandermonde", " ", "matrix"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"M", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"j", "\[Equal]", "0"}], ",", "1", ",", 
         RowBox[{
          RowBox[{"data", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "1"}], "]"}], "]"}], "^", "j"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"n", "+", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "0", ",", "n"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"data", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"n", "+", "1"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"acoeff", " ", "=", " ", 
     RowBox[{"LinearSolve", "[", 
      RowBox[{"M", ",", "b"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<M = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "M", "]"}], ",", "\"\<  b=\>\"", ",", 
      RowBox[{"MatrixForm", "[", "b", "]"}], ",", "\"\<  acoeff = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "acoeff", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Evaluate", " ", "the", " ", "polynomial", " ", "at", " ", "parameter", 
     " ", "t"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"poly", "[", 
      RowBox[{"n_", ",", " ", "acoeff_", ",", "t_"}], "]"}], " ", ":=", " ", 
     RowBox[{"(", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"acoeff", "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "+", " ", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"acoeff", "[", 
           RowBox[{"[", 
            RowBox[{"i", "+", "1"}], "]"}], "]"}], "*", 
          RowBox[{"t", "^", "i"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}]}], ")"}]}], ";"}],
    "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5590461057782984`*^9, 3.5590463148498654`*^9}, 
   3.559046438183682*^9, {3.559046534233051*^9, 3.559046667691285*^9}, {
   3.5590467503402305`*^9, 3.5590467721334686`*^9}, {3.5590468028343225`*^9, 
   3.559046884406866*^9}, {3.559047004542677*^9, 3.559047122432084*^9}, {
   3.559047156221743*^9, 3.559047298244393*^9}, {3.559047462278681*^9, 
   3.5590474913415318`*^9}, {3.5590475480632315`*^9, 3.559047590261306*^9}, {
   3.559047977578786*^9, 3.559047991728011*^9}, {3.5590480708357496`*^9, 
   3.5590480775749617`*^9}, {3.5590483661754684`*^9, 
   3.5590483753482847`*^9}, {3.5590484106355467`*^9, 
   3.5590484175931587`*^9}, {3.5590484915060883`*^9, 
   3.5590485353265657`*^9}, {3.5590486376471453`*^9, 3.55904864056435*^9}, {
   3.559048851514722*^9, 3.559048920342043*^9}, {3.559070397926655*^9, 
   3.5590703985506563`*^9}, {3.5843997191729183`*^9, 
   3.5843998142130513`*^9}, {3.5843998443030934`*^9, 3.584399855123109*^9}, {
   3.5844001333034983`*^9, 3.5844001349135003`*^9}, {3.584400171443551*^9, 
   3.584400204073597*^9}, 3.584400243363652*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"M = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0", "0", "0"},
       {"1", "1", "1", "1", "1"},
       {"1", "5", "25", "125", "625"},
       {"1", "10", "100", "1000", "10000"},
       {"1", "13", "169", "2197", "28561"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"  b=\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"0"},
        {"2"},
        {"7"},
        {"7"},
        {"1"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"  acoeff = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"0"},
        {
         FractionBox["3853", "1755"]},
        {
         RowBox[{"-", 
          FractionBox["563", "2700"]}]},
        {
         FractionBox["487", "35100"]},
        {
         RowBox[{"-", 
          FractionBox["7", "8775"]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["M = ", 
   MatrixForm[{{1, 0, 0, 0, 0}, {1, 1, 1, 1, 1}, {1, 5, 25, 125, 625}, {1, 10,
     100, 1000, 10000}, {1, 13, 169, 2197, 28561}}], "  b=", 
   MatrixForm[{0, 2, 7, 7, 1}], "  acoeff = ", 
   MatrixForm[{0, 
     Rational[3853, 1755], 
     Rational[-563, 2700], 
     Rational[487, 35100], 
     Rational[-7, 8775]}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.58440037012383*^9, 3.5844003804238443`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics", "Section",
 CellChangeTimes->{{3.5844002464836564`*^9, 3.5844002526636653`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Graphics", ",", 
    RowBox[{"BaseStyle", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontFamily", "->", "\"\<Helvetica\>\""}], ",", 
       RowBox[{"FontSize", "\[Rule]", "10"}]}], "}"}]}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetOptions", "[", 
    RowBox[{"Plot", ",", 
     RowBox[{"BaseStyle", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FontFamily", "->", "\"\<Helvetica\>\""}], ",", 
        RowBox[{"FontSize", "\[Rule]", "10"}]}], "}"}]}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotpoly", " ", "=", " ", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"poly", "[", 
      RowBox[{"n", ",", " ", "acoeff", ",", "t"}], "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"data", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
       RowBox[{"data", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"n", "+", "1"}], ",", "1"}], "]"}], "]"}]}], "}"}], ",", 
     " ", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Gray", ",", "Thick"}], "}"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plotpoints", " ", "=", " ", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Black", ",", 
      RowBox[{"PointSize", "[", "Large", "]"}], ",", 
      RowBox[{"Point", "[", "data", "]"}]}], "}"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"pic", " ", "=", " ", 
  RowBox[{"Show", "[", 
   RowBox[{"plotpoly", ",", "plotpoints"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Export", "[", 
    RowBox[{"\"\<PolyInterp.eps\>\"", ",", " ", "pic"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5590461057782984`*^9, 3.5590463148498654`*^9}, 
   3.559046438183682*^9, {3.559046534233051*^9, 3.559046667691285*^9}, {
   3.5590467503402305`*^9, 3.5590467721334686`*^9}, {3.5590468028343225`*^9, 
   3.559046884406866*^9}, {3.559047004542677*^9, 3.559047122432084*^9}, {
   3.559047156221743*^9, 3.559047298244393*^9}, {3.559047462278681*^9, 
   3.5590474913415318`*^9}, {3.5590475480632315`*^9, 3.559047590261306*^9}, {
   3.559047977578786*^9, 3.559047991728011*^9}, {3.5590480708357496`*^9, 
   3.5590480775749617`*^9}, {3.5590483661754684`*^9, 
   3.5590483753482847`*^9}, {3.5590484106355467`*^9, 
   3.5590484175931587`*^9}, {3.5590484915060883`*^9, 
   3.5590485353265657`*^9}, {3.5590486376471453`*^9, 3.55904864056435*^9}, {
   3.559048851514722*^9, 3.559048920342043*^9}, {3.559070397926655*^9, 
   3.5590703985506563`*^9}, {3.5843997191729183`*^9, 
   3.5843998142130513`*^9}, {3.5843998443030934`*^9, 3.584399855123109*^9}, {
   3.5844001333034983`*^9, 3.5844001349135003`*^9}, {3.584400171443551*^9, 
   3.584400204073597*^9}, 3.584400243363652*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {GrayLevel[0.5], Thickness[Large], LineBox[CompressedData["
1:eJwV13k8VF0YB3BFQrbsY2buvTNlGaRNiuQ+lJIkIaGUlJIohpJdlhZEREpE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      "]]}}, 
   {GrayLevel[0], PointSize[Large], 
    PointBox[{{0, 0}, {1, 2}, {5, 7}, {10, 7}, {13, 1}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 10},
  PlotRange->{{0, 13}, {0., 8.0718697623941}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.559047572352474*^9, 3.559047591150507*^9}, {
   3.5590479802463903`*^9, 3.5590479933036137`*^9}, 3.5590480783861628`*^9, 
   3.5590483762686863`*^9, 3.559048423536769*^9, 3.559048538493371*^9, 
   3.559048643122755*^9, {3.559048896832802*^9, 3.5590489212624445`*^9}, 
   3.559070402949864*^9, {3.5844003702438297`*^9, 3.584400380453844*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1035, 630},
WindowMargins->{{Automatic, 44}, {53, Automatic}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 673, 13, 135, "Subtitle"],
Cell[1255, 37, 774, 12, 200, "Subsubtitle"],
Cell[CellGroupData[{
Cell[2054, 53, 104, 1, 71, "Section"],
Cell[CellGroupData[{
Cell[2183, 58, 3291, 80, 232, "Input"],
Cell[5477, 140, 1080, 28, 80, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6606, 174, 124, 4, 97, "Section"],
Cell[CellGroupData[{
Cell[6755, 182, 3500, 83, 252, "Input"],
Cell[10258, 267, 2965, 85, 120, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13272, 358, 97, 1, 71, "Section"],
Cell[CellGroupData[{
Cell[13394, 363, 3091, 75, 212, "Input"],
Cell[16488, 440, 6219, 107, 248, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
