(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     56122,       1410]
NotebookOptionsPosition[     53833,       1333]
NotebookOutlinePosition[     54276,       1350]
CellTagsIndexPosition[     54233,       1347]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 "\n"
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
  3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
  3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
  3.5842134956497355`*^9, 3.5842135862546945`*^9}},
 FontFamily->"Arial"],

Cell[TextData[{
 "\n",
 StyleBox["Power Method",
  FontWeight->"Bold"],
 "\nAn iterative method for finding the dominant eigenvector and eigenvalue \
of a diagonizable matrix.\nThe implementation here requires the dominant \
eigenvalue be greater than the next one,  lambda_1 > lambda_2.\n\nAlgorithm \
from \[OpenCurlyDoubleQuote]Numerical Analysis\[CloseCurlyDoubleQuote] by \
Burden, Faires, and Reynolds\nProblem with algorithm: it is possible to get \
caught in a local minimum, so the tolerance end condition will terminate the \
iteration while still far from the true eigenvalue.\n\nAt the end of the nb \
is a test of the conceptual idea behind the power method. (See the \
introduction to Section 15.2 for more details.)"
}], "Subsubtitle",
 CellChangeTimes->{{3.5606081356701775`*^9, 3.5606081535478086`*^9}, {
  3.560618344672784*^9, 3.560618399368861*^9}, {3.5844471410067883`*^9, 
  3.5844471416307893`*^9}, {3.5844472371341567`*^9, 3.5844472551833887`*^9}, {
  3.584448097298868*^9, 3.584448141431346*^9}, {3.584463770918034*^9, 
  3.5844638354865475`*^9}}],

Cell[CellGroupData[{

Cell[TextData[{
 "\nInitialize and select i",
 StyleBox["nput ",
  FontColor->GrayLevel[0]]
}], "Section",
 CellChangeTimes->{{3.560624026911503*^9, 3.560624040411522*^9}, {
  3.5606240734031696`*^9, 3.560624091403595*^9}, {3.584447306023878*^9, 
  3.584447307708681*^9}, {3.584447414350468*^9, 3.584447434006503*^9}, {
  3.5844474653157578`*^9, 3.584447514908245*^9}}],

Cell["\<\

Select an A* and evec* pair and load into A and evec at end of this section\
\>", "Text",
 CellChangeTimes->{{3.5844475102282367`*^9, 3.584447542925894*^9}, {
  3.584463623482175*^9, 3.5844636344645944`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"establish", " ", "a", " ", "zero", " ", "tolerance"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"zero", " ", "=", " ", "0.0000005"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "maximum", " ", "number", " ", "of", " ", "iterations", " ", "to", " ", 
     "allow"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"maxiter", " ", "=", " ", "100"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "temp", " ", "storage", " ", "of", " ", "iterative", " ", "evecs", " ", 
     "for", " ", "graphics"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"temp", " ", "=", " ", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "maxiter"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"temp", "[", 
       RowBox[{"[", "1", "]"}], "]"}], " ", "=", " ", "evec1"}], ";"}], 
    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "tolerance", " ", "to", " ", "check", " ", "difference", " ", "in", " ", 
     "dominant", " ", "eigenvalue", " ", "from", " ", "one", " ", "iteration",
      " ", "to", " ", "the", " ", "next"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"tol", " ", "=", " ", "0.0005"}], ";", " ", 
     RowBox[{
     "used", " ", "for", " ", "power", " ", "method", " ", "section", " ", 
      "example", " ", "in", " ", "PLA"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tol", " ", "=", " ", "0.00000005"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"numiter", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"examples", " ", "from", " ", "PLA"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "0.1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.1", ",", "2"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "0.1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"evec1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"1.5", ",", 
       RowBox[{"-", "0.1"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A4", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "4"}], ",", "14", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5"}], ",", "13", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0", ",", "2"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"evec4", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "This", " ", "one", " ", "caused", " ", "trouble", " ", "with", " ", 
     "guess", " ", "of", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", ",", "0", ",", "0"}], ")"}], " ", "--"}], " ", "from", 
     " ", "PLA", " ", "2", "nd", " ", 
     RowBox[{"ed", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A5", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"evec5", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Stochastic", " ", "matrix", " ", "from", " ", "google", " ", "example"}],
     " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A7", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"1", "/", "2"}], ",", 
         RowBox[{"1", "/", "3"}], ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "3"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"1", "/", "2"}], ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "3"}], ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"evec7", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Stochastic", " ", "matrix", " ", "from", " ", "Austin", " ", "article", 
     " ", "on", " ", "Google", " ", "pagerank"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A8", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
         RowBox[{"1", "/", "3"}], ",", "0"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", 
         RowBox[{"1", "/", "2"}], ",", 
         RowBox[{"1", "/", "3"}], ",", "0", ",", "0", ",", "0", ",", "0"}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0", ",", "0", ",", "0", ",", "0", ",",
          "0", ",", "0", ",", "0"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
         "0"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}], ",", 
         RowBox[{"1", "/", "3"}], ",", "0", ",", "0", ",", 
         RowBox[{"1", "/", "3"}], ",", "0"}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", 
         RowBox[{"1", "/", "3"}], ",", 
         RowBox[{"1", "/", "3"}], ",", "0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
         RowBox[{"1", "/", "3"}], ",", "0", ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
         RowBox[{"1", "/", "3"}], ",", "1", ",", 
         RowBox[{"1", "/", "3"}], ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"evec8", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
       "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A9", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "2"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"evec9", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"--", 
     RowBox[{"--", " ", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", "-"}]}]}]}]}]}]}]}]}]}]}]}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"--", 
     RowBox[{"--", " ", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", "-"}]}]}]}]}]}]}]}]}]}]}]}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Load", " ", "the", " ", "matrix", " ", "and", " ", "guess", " ", "evec", 
     " ", "to", " ", "run"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", " ", "=", " ", "A9"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"evec", " ", "=", " ", "evec9"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.560608670389061*^9, 3.5606086912266965`*^9}, {
   3.560608785791654*^9, 3.5606087868264556`*^9}, {3.560608827200922*^9, 
   3.5606088416777472`*^9}, {3.560609245202427*^9, 3.5606092575568485`*^9}, {
   3.560609352689008*^9, 3.560609352954209*^9}, 3.5606093974674845`*^9, {
   3.560610453463828*^9, 3.560610554541605*^9}, {3.5606105893348656`*^9, 
   3.56061060323449*^9}, 3.560617639080141*^9, {3.560617696660225*^9, 
   3.560617783124753*^9}, {3.5606178134151964`*^9, 3.5606179059209323`*^9}, {
   3.56061793895858*^9, 3.5606179998558674`*^9}, {3.560618622853217*^9, 
   3.5606186255832205`*^9}, {3.5606186846257067`*^9, 3.560618714744149*^9}, {
   3.5606187945970645`*^9, 3.5606188421087313`*^9}, {3.5606189107872467`*^9, 
   3.560619022771414*^9}, {3.5606191049143343`*^9, 3.56061910922434*^9}, {
   3.560621340916233*^9, 3.560621372267085*^9}, {3.5606214967952795`*^9, 
   3.5606217293944583`*^9}, {3.5606218074633856`*^9, 
   3.5606218229158115`*^9}, {3.5606218798171077`*^9, 3.560621938728005*^9}, {
   3.5606219698684564`*^9, 3.5606219738308635`*^9}, {3.560622008653721*^9, 
   3.560622088455039*^9}, {3.560622147071129*^9, 3.5606221727307673`*^9}, {
   3.5606222085740175`*^9, 3.560622261324092*^9}, {3.5606223018505487`*^9, 
   3.5606223019597487`*^9}, {3.560622345467012*^9, 3.560622393786682*^9}, {
   3.560622926441865*^9, 3.560622926551065*^9}, {3.5606230020943756`*^9, 
   3.5606230204920034`*^9}, {3.5606230700880804`*^9, 3.560623072600085*^9}, {
   3.5606231538858013`*^9, 3.5606231540614014`*^9}, {3.5606237094486194`*^9, 
   3.5606237311086516`*^9}, {3.560623832816805*^9, 3.5606238680280604`*^9}, {
   3.5606239884426455`*^9, 3.560623988732646*^9}, 3.560624021691496*^9, {
   3.560624064741957*^9, 3.560624065961959*^9}, {3.5606240977436037`*^9, 
   3.5606240979436045`*^9}, {3.5606241848785324`*^9, 
   3.5606242195605893`*^9}, {3.5606242961499147`*^9, 
   3.5606243121295424`*^9}, {3.5606244220421257`*^9, 3.560624430092939*^9}, {
   3.560624590709197*^9, 3.560624616953241*^9}, {3.560624653789299*^9, 
   3.560624653869299*^9}, {3.560627041667231*^9, 3.560627148576992*^9}, {
   3.5606271939882574`*^9, 3.5606271940662575`*^9}, {3.5606276600669875`*^9, 
   3.5606276604569883`*^9}, 3.5606277862583976`*^9, {3.5606283637829432`*^9, 
   3.5606283971877975`*^9}, {3.5606287258183126`*^9, 
   3.5606287264111137`*^9}, {3.5607173076819944`*^9, 3.560717426413803*^9}, {
   3.5607175841300793`*^9, 3.560717636078171*^9}, {3.561147917187654*^9, 
   3.561147993518588*^9}, {3.5611482999811263`*^9, 3.5611483641128387`*^9}, {
   3.561226686898325*^9, 3.5612269355507593`*^9}, {3.5612269960320654`*^9, 
   3.5612270052048817`*^9}, {3.5612271522799377`*^9, 3.561227189470403*^9}, {
   3.561227420553609*^9, 3.5612274239700155`*^9}, {3.5614959254377975`*^9, 
   3.561495977463889*^9}, {3.561661783426611*^9, 3.5616617838322115`*^9}, {
   3.561661817481471*^9, 3.5616618176686707`*^9}, {3.5616619681153355`*^9, 
   3.5616619797529554`*^9}, {3.5844473186131*^9, 3.5844473580187693`*^9}, {
   3.584447398890841*^9, 3.5844474030248485`*^9}, 3.584447442336917*^9, {
   3.584452071109448*^9, 3.5844520742138534`*^9}, {3.5844636590034375`*^9, 
   3.584463684868283*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Routines",
 FontColor->GrayLevel[0]]], "Section",
 CellChangeTimes->{{3.560618409012475*^9, 3.5606184322733116`*^9}, 
   3.584447180693258*^9}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Find", " ", "the", " ", "index", " ", "of", " ", "the", " ", "element", 
    " ", "with", " ", "max", " ", "absolute", " ", "value"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"maxnormindex", "[", "v_", "]"}], " ", ":=", " ", 
    RowBox[{"(", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"m", " ", "=", " ", 
       RowBox[{"Abs", "[", 
        RowBox[{"v", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";", 
      RowBox[{"i", " ", "=", " ", "1"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Abs", "[", 
            RowBox[{"v", "[", 
             RowBox[{"[", "j", "]"}], "]"}], "]"}], " ", ">", " ", "m"}], ",",
           "\[IndentingNewLine]", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"m", "=", 
             RowBox[{"v", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}], ";", " ", 
            RowBox[{"i", "=", "j"}]}], ")"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"j", ",", "2", ",", 
          RowBox[{"Length", "[", "v", "]"}]}], "}"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{
         "\"\<vector=\>\"", ",", "v", ",", "\"\< max element i=\>\"", ",", 
          "i"}], "]"}], ";"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"Return", "[", "i", "]"}], ";"}], "\[IndentingNewLine]", 
     ")"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"powermethod", "[", 
     RowBox[{
     "zero_", ",", "maxiter_", ",", " ", "tol_", ",", " ", "A_", ",", 
      "lambda_", ",", " ", "evec_"}], "]"}], " ", ":=", " ", 
    RowBox[{"(", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"dummy", " ", "vars"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"isuccess", " ", "=", " ", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"y", " ", "=", " ", 
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", 
           RowBox[{"Length", "[", "evec", "]"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"lambda0", " ", "=", " ", "lambda"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<Input: A=\>\"", ",", 
        RowBox[{"MatrixForm", "[", "A", "]"}], ",", "\"\<  evec=\>\"", ",", 
        "evec", ",", "\"\<  lambda=\>\"", ",", "lambda"}], "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "scale", " ", "evec", " ", "by", " ", "max", " ", "norm", " ", 
        "element"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"imax", " ", "=", 
       RowBox[{"maxnormindex", "[", "evec", "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"val", " ", "=", " ", 
       RowBox[{"evec", "[", 
        RowBox[{"[", "imax", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"newevec", " ", "=", " ", 
       RowBox[{"evec", "/", "val"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", 
       RowBox[{"\"\<evec max-normed = \>\"", ",", "newevec"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"temp", "[", 
          RowBox[{"[", "1", "]"}], "]"}], " ", "=", " ", "newevec"}], ";"}], 
       " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"new", " ", "evec"}], " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", " ", "=", " ", 
           RowBox[{"A", ".", "newevec"}]}], ";", "\[IndentingNewLine]", " ", 
          RowBox[{"Print", "[", 
           RowBox[{"\"\<new evec y=\>\"", ",", 
            RowBox[{"y", "//", "N"}]}], "]"}], ";", " ", 
          "\[IndentingNewLine]", 
          RowBox[{"lambdanew", " ", "=", " ", 
           RowBox[{"y", "[", 
            RowBox[{"[", "imax", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"Print", "[", 
           RowBox[{"\"\<grab element for lambdanew = \>\"", ",", 
            RowBox[{"lambdanew", "//", "N"}]}], "]"}], ";", " ", 
          "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"imax", " ", "=", " ", 
           RowBox[{"maxnormindex", "[", "y", "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Abs", "[", 
              RowBox[{"y", "[", 
               RowBox[{"[", "imax", "]"}], "]"}], "]"}], " ", "<", " ", 
             "zero"}], ",", "\[IndentingNewLine]", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
              "Print", "[", 
               "\"\<Eigenvalue zero; select new evector guess and \
restart\>\"", "]"}], ";", " ", 
              RowBox[{"Return", "[", "lambdanew", "]"}]}], ")"}]}], "]"}], 
          ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"scale", " ", "new", " ", "evec"}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"newevec", " ", "=", " ", 
           RowBox[{"y", "/", 
            RowBox[{"y", "[", 
             RowBox[{"[", "imax", "]"}], "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"temp", "[", 
              RowBox[{"[", "k", "]"}], "]"}], " ", "=", " ", "newevec"}], 
            ";"}], " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{"Check", " ", "if", " ", "we", " ", "are", " ", 
            RowBox[{"done", " ", "--"}], " ", "previous", " ", "and", " ", 
            "current", " ", "evalue", " ", "close"}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Abs", "[", 
              RowBox[{"lambdanew", " ", "-", " ", "lambda0"}], "]"}], "<", 
             " ", "tol"}], ",", " ", "\[IndentingNewLine]", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"isuccess", " ", "=", " ", "1"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"Print", "[", 
               RowBox[{"\"\<Success: Return evec=\>\"", ",", 
                RowBox[{"newevec", "//", "N"}], ",", "\"\<  lambdanew = \>\"",
                 ",", 
                RowBox[{"lambdanew", "//", "N"}], ",", 
                "\"\< difference to old = \>\"", ",", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"lambdanew", " ", "-", " ", "lambda0"}], ")"}], "//",
                  "N"}]}], "]"}], ";", "\[IndentingNewLine]", 
              RowBox[{"numiter", " ", "=", " ", "k"}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"Return", "[", "lambdanew", "]"}]}], ")"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{"Print", " ", "status"}], " ", "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"(", 
             RowBox[{"Print", "[", 
              RowBox[{
              "\"\<k=\>\"", ",", "k", ",", "\"\<  current evec=\>\"", ",", 
               RowBox[{"newevec", "//", "N"}], ",", "\"\<  lambdanew=\>\"", 
               ",", 
               RowBox[{"lambdanew", "//", "N"}]}], "]"}], ")"}]}], "]"}], ";",
           "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"(*", " ", 
           RowBox[{
           "Check", " ", "if", " ", "maximum", " ", "number", " ", "of", " ", 
            "iteration", " ", "surpassed"}], " ", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"k", " ", "\[Equal]", " ", "maxiter"}], ",", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"Print", "[", 
               RowBox[{"\"\<Max iters exceeded  evecnew=\>\"", ",", 
                RowBox[{"newevec", "//", "N"}], ",", "\"\<  lambdanew=\>\"", 
                ",", 
                RowBox[{"lambdanew", "//", "N"}]}], "]"}], ";", " ", 
              "\[IndentingNewLine]", 
              RowBox[{"numiter", "=", "k"}], ";", "\[IndentingNewLine]", 
              RowBox[{"Return", "[", "lambdanew", "]"}]}], ")"}]}], "]"}], 
          ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"lambda0", " ", "=", " ", "lambdanew"}]}], ")"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{"k", ",", "2", ",", "maxiter"}], "}"}]}], "]"}], ";"}], 
     "\[IndentingNewLine]", ")"}]}]}]}]], "Input",
 CellChangeTimes->CompressedData["
1:eJwd0FtIkwEYxvFlEBWNSsvO2sDONZPZqLWwz4tVw2gtWGsTpTSRNS08sNyk
JspmGQSdSSJdBSLjCyfMYkRkQTR1HbCc05Zhyhi0oKsgob7/Lh5+F8/Le/Eo
zpw3ns2QyWTbpaDW3qAyepPCgtavezCQqNXgm+RfAacsx61YtaqhHos9jibU
qgJOrMnqu4xOzVAbflB03sCW8p+3MGgsf4ibx651oc8s9uOT/epn6f72zpf4
ZSD0Nv3/yqVhtHpDIzgrrP+OcVee8oSkTG9WoyrechDD8yJ6vLfFdQyT3QVF
JkmDpkeHC6MX9KjLUZegfVGmAXcoNSYc3DhqQVuZWIq7Vy4+jbHmVCV+bs23
oyVVkXYwnO1Cd0G+Bz++cnek7/0rruNFy907OHGgqhNTtQkfrp0TenFdpVzE
4WLfC4xmKV/j/bFHEUzmifKTkoUOcTnGRjtWY0phWIOHP9m0WP1NV4KeI789
qG/suoqaInuvWdJR9z6t91ds5hQ7z/lmcdnkOZeVffdON2PI3+7DH/vGH2Pk
phDAP+Omfgyo64cw82kwgtn+qSiO7KqZQNfSbdPonJTPYHhT+B8WbkjML5UU
7Q9ysO1QTy4ezY0r0VbxToVNZYE+d3tSqHu+JICxamcQt2Y0DuB/eGRTmQ==

  "]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Run power method", "Section",
 CellChangeTimes->{{3.584447445098122*^9, 3.5844474520713344`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"initialize", " ", "dominant", " ", "eigenvalue"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"lambda", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<Let Mathematica compute:\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Eigenvalues of A = \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", 
        RowBox[{"Eigenvalues", "[", "A", "]"}], "]"}], "//", "N"}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mevec", " ", "=", " ", 
     RowBox[{"Eigenvectors", "[", "A", "]"}]}], ";"}], "\[IndentingNewLine]", 
   StyleBox[
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"\"\<Eigenvectors of A = \>\"", ",", 
       RowBox[{"MatrixForm", "[", 
        RowBox[{"mevec", "//", "N"}], "]"}]}], "]"}], ";"}],
    FontSize->12], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   StyleBox[
    RowBox[{
     RowBox[{"Print", "[", "\"\<Power Method:\>\"", "]"}], ";"}],
    FontSize->12], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"powermethod", "[", 
     RowBox[{
     "zero", ",", "maxiter", ",", " ", "tol", ",", " ", "A", ",", " ", 
      "lambda", ",", " ", "evec"}], "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<numiter=\>\"", ",", "numiter", ",", "\"\<  temp =\>\"", ",", 
       RowBox[{"MatrixForm", "[", "temp", "]"}]}], "]"}], ";"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Graphics", " ", "for", " ", "PLA", " ", "figures"}], " ", "*)"}],
    "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"origin", " ", "=", " ", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"initarrow", " ", "=", " ", "\[IndentingNewLine]", 
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.008", "]"}], ",", " ", 
         RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
         RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{"origin", ",", " ", "evec"}], "}"}], "]"}]}], "}"}], 
       "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"tval", "[", "i_", "]"}], " ", ":=", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"i", "-", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"numiter", " ", "-", " ", "1"}], ")"}]}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"arrows", " ", "=", " ", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Graphics", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Thickness", "[", "0.003", "]"}], ",", " ", 
           RowBox[{"GrayLevel", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", 
                RowBox[{"tval", "[", "i", "]"}]}], ")"}], "0.0"}], " ", "+", 
             " ", 
             RowBox[{
              RowBox[{"tval", "[", "i", "]"}], "*", "0.99"}]}], "]"}], ",", 
           RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{"origin", ",", " ", 
              RowBox[{"temp", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], "]"}],
         ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "numiter"}], "}"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"opoint", " ", "=", " ", 
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PointSize", "[", "Large", "]"}], ",", " ", 
         RowBox[{"GrayLevel", "[", "0", "]"}], ",", " ", 
         RowBox[{"Point", "[", "origin", "]"}]}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"pic", " ", "=", " ", 
      RowBox[{"Show", "[", 
       RowBox[{"initarrow", ",", " ", "arrows", ",", "opoint"}], "]"}]}]}], 
    "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"Export", "[", 
       RowBox[{"\"\<PowerMethod.eps\>\"", ",", " ", "pic"}], "]"}], ";"}], 
     " ", "*)"}], "\[IndentingNewLine]", "*)"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.560608670389061*^9, 3.5606086912266965`*^9}, {
   3.560608785791654*^9, 3.5606087868264556`*^9}, {3.560608827200922*^9, 
   3.5606088416777472`*^9}, {3.560609245202427*^9, 3.5606092575568485`*^9}, {
   3.560609352689008*^9, 3.560609352954209*^9}, 3.5606093974674845`*^9, {
   3.560610453463828*^9, 3.560610554541605*^9}, {3.5606105893348656`*^9, 
   3.56061060323449*^9}, 3.560617639080141*^9, {3.560617696660225*^9, 
   3.560617783124753*^9}, {3.5606178134151964`*^9, 3.5606179059209323`*^9}, {
   3.56061793895858*^9, 3.5606179998558674`*^9}, {3.560618622853217*^9, 
   3.5606186255832205`*^9}, {3.5606186846257067`*^9, 3.560618714744149*^9}, {
   3.5606187945970645`*^9, 3.5606188421087313`*^9}, {3.5606189107872467`*^9, 
   3.560619022771414*^9}, {3.5606191049143343`*^9, 3.56061910922434*^9}, {
   3.560621340916233*^9, 3.560621372267085*^9}, {3.5606214967952795`*^9, 
   3.5606217293944583`*^9}, {3.5606218074633856`*^9, 
   3.5606218229158115`*^9}, {3.5606218798171077`*^9, 3.560621938728005*^9}, {
   3.5606219698684564`*^9, 3.5606219738308635`*^9}, {3.560622008653721*^9, 
   3.560622088455039*^9}, {3.560622147071129*^9, 3.5606221727307673`*^9}, {
   3.5606222085740175`*^9, 3.560622261324092*^9}, {3.5606223018505487`*^9, 
   3.5606223019597487`*^9}, {3.560622345467012*^9, 3.560622393786682*^9}, {
   3.560622926441865*^9, 3.560622926551065*^9}, {3.5606230020943756`*^9, 
   3.5606230204920034`*^9}, {3.5606230700880804`*^9, 3.560623072600085*^9}, {
   3.5606231538858013`*^9, 3.5606231540614014`*^9}, {3.5606237094486194`*^9, 
   3.5606237311086516`*^9}, {3.560623832816805*^9, 3.5606238680280604`*^9}, {
   3.5606239884426455`*^9, 3.560623988732646*^9}, 3.560624021691496*^9, {
   3.560624064741957*^9, 3.560624065961959*^9}, {3.5606240977436037`*^9, 
   3.5606240979436045`*^9}, {3.5606241848785324`*^9, 
   3.5606242195605893`*^9}, {3.5606242961499147`*^9, 
   3.5606243121295424`*^9}, {3.5606244220421257`*^9, 3.560624430092939*^9}, {
   3.560624590709197*^9, 3.560624616953241*^9}, {3.560624653789299*^9, 
   3.560624653869299*^9}, {3.560627041667231*^9, 3.560627148576992*^9}, {
   3.5606271939882574`*^9, 3.5606271940662575`*^9}, {3.5606276600669875`*^9, 
   3.5606276604569883`*^9}, 3.5606277862583976`*^9, {3.5606283637829432`*^9, 
   3.5606283971877975`*^9}, {3.5606287258183126`*^9, 
   3.5606287264111137`*^9}, {3.5607173076819944`*^9, 3.560717426413803*^9}, {
   3.5607175841300793`*^9, 3.560717636078171*^9}, {3.561147917187654*^9, 
   3.561147993518588*^9}, {3.5611482999811263`*^9, 3.5611483641128387`*^9}, {
   3.561226686898325*^9, 3.5612269355507593`*^9}, {3.5612269960320654`*^9, 
   3.5612270052048817`*^9}, {3.5612271522799377`*^9, 3.561227189470403*^9}, {
   3.561227420553609*^9, 3.5612274239700155`*^9}, {3.5614959254377975`*^9, 
   3.561495977463889*^9}, {3.561661783426611*^9, 3.5616617838322115`*^9}, {
   3.561661817481471*^9, 3.5616618176686707`*^9}, {3.5616619681153355`*^9, 
   3.5616619797529554`*^9}, {3.5844473186131*^9, 3.5844473580187693`*^9}, {
   3.584447398890841*^9, 3.5844474030248485`*^9}, 3.584447442336917*^9, {
   3.5844475669967365`*^9, 3.584447577089954*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Let Mathematica compute:\"\>"], "Print",
 CellChangeTimes->{3.5844519749664793`*^9, 3.584452077583459*^9, 
  3.5844633159136343`*^9, 3.584463688596689*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Eigenvalues of A = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"4.645751311064591`"},
        {"3.`"},
        {
         RowBox[{"-", "0.6457513110645907`"}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Eigenvalues of A = ", 
   MatrixForm[{4.645751311064591, 3., -0.6457513110645907}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.5844519749664793`*^9, 3.584452077583459*^9, 
  3.5844633159136343`*^9, 3.584463688596689*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Eigenvectors of A = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.5485837703548635`", "0.5485837703548635`", "1.`"},
       {
        RowBox[{"-", "1.`"}], "1.`", "1.`"},
       {
        RowBox[{"-", "0.21525043702153024`"}], 
        RowBox[{"-", "1.2152504370215302`"}], "1.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Eigenvectors of A = ", 
   MatrixForm[{{1.5485837703548635`, 0.5485837703548635, 1.}, {-1., 1., 
    1.}, {-0.21525043702153024`, -1.2152504370215302`, 1.}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.5844519749664793`*^9, 3.584452077583459*^9, 
  3.5844633159136343`*^9, 3.5844636889710903`*^9}],

Cell[BoxData["\<\"Power Method:\"\>"], "Print",
 CellChangeTimes->{3.5844519749664793`*^9, 3.584452077583459*^9, 
  3.5844633159136343`*^9, 3.5844636889710903`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Input: A=\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"4", "0", "1"},
       {"0", "1", "2"},
       {"1", "2", "2"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"  evec=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], 
   "\[InvisibleSpace]", "\<\"  lambda=\"\>", "\[InvisibleSpace]", "0"}],
  SequenceForm["Input: A=", 
   MatrixForm[{{4, 0, 1}, {0, 1, 2}, {1, 2, 2}}], "  evec=", {1, 1, 1}, 
   "  lambda=", 0],
  Editable->False]], "Print",
 CellChangeTimes->{3.5844519749664793`*^9, 3.584452077583459*^9, 
  3.5844633159136343`*^9, 3.58446368898669*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"evec max-normed = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}],
  SequenceForm["evec max-normed = ", {1, 1, 1}],
  Editable->False]], "Print",
 CellChangeTimes->{3.5844519749664793`*^9, 3.584452077583459*^9, 
  3.5844633159136343`*^9, 3.58446368898669*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"new evec y=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"5.`", ",", "3.`", ",", "5.`"}], "}"}]}],
  SequenceForm["new evec y=", {5., 3., 5.}],
  Editable->False]], "Print",
 CellChangeTimes->{3.5844519749664793`*^9, 3.584452077583459*^9, 
  3.5844633159136343`*^9, 3.58446368898669*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"grab element for lambdanew = \"\>", "\[InvisibleSpace]", 
   "5.`"}],
  SequenceForm["grab element for lambdanew = ", 5.],
  Editable->False]], "Print",
 CellChangeTimes->{3.5844519749664793`*^9, 3.584452077583459*^9, 
  3.5844633159136343`*^9, 3.58446368898669*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"  current evec=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.6`", ",", "1.`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"  lambdanew=\"\>", "\[InvisibleSpace]", "5.`"}],
  SequenceForm["k=", 2, "  current evec=", {1., 0.6, 1.}, "  lambdanew=", 5.],
  Editable->False]], "Print",
 CellChangeTimes->{3.5844519749664793`*^9, 3.584452077583459*^9, 
  3.5844633159136343`*^9, 3.58446368898669*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"new evec y=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"5.`", ",", "2.6`", ",", "4.2`"}], "}"}]}],
  SequenceForm["new evec y=", {5., 2.6, 4.2}],
  Editable->False]], "Print",
 CellChangeTimes->{3.5844519749664793`*^9, 3.584452077583459*^9, 
  3.5844633159136343`*^9, 3.58446368898669*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"grab element for lambdanew = \"\>", "\[InvisibleSpace]", 
   "5.`"}],
  SequenceForm["grab element for lambdanew = ", 5.],
  Editable->False]], "Print",
 CellChangeTimes->{3.5844519749664793`*^9, 3.584452077583459*^9, 
  3.5844633159136343`*^9, 3.58446368898669*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Success: Return evec=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.52`", ",", "0.84`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"  lambdanew = \"\>", "\[InvisibleSpace]", "5.`", 
   "\[InvisibleSpace]", "\<\" difference to old = \"\>", "\[InvisibleSpace]", 
   "0.`"}],
  SequenceForm[
  "Success: Return evec=", {1., 0.52, 0.84}, "  lambdanew = ", 5., 
   " difference to old = ", 0.],
  Editable->False]], "Print",
 CellChangeTimes->{3.5844519749664793`*^9, 3.584452077583459*^9, 
  3.5844633159136343`*^9, 3.58446368898669*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

Verify success\
\>", "Section",
 CellChangeTimes->{{3.5844478113087654`*^9, 3.5844478311052003`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Check", " ", "that", " ", "first", " ", "eigenvec", " ", "is", " ", 
    "stationary", " ", "vector"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "The", " ", "two", " ", "print", " ", "outs", " ", "should", " ", "be", 
    " ", "the", " ", "same"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<dominant eigenvector = \>\"", ",", 
      RowBox[{
       RowBox[{"mevec", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<dominant eigenvector*evalue = \>\"", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"mevec", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "*", "lambdanew"}], "//", "N"}]}], 
     "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<check evec stationary: Av = lambda *v? \>\"", ",", 
      RowBox[{
       RowBox[{"A", ".", 
        RowBox[{"mevec", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Power method success? 0=no 1=yes \>\"", ",", "isuccess"}], 
     "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<powermethod calculated dominant eigenvector: \>\"", ",", 
      RowBox[{"newevec", "//", "N"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.561148168426095*^9, 3.5611481941505404`*^9}, {
  3.5611484344689627`*^9, 3.5611484493045883`*^9}, {3.561227203682028*^9, 
  3.561227325689842*^9}, {3.561227551328639*^9, 3.5612276490628104`*^9}, {
  3.5612277564865985`*^9, 3.5612277656750145`*^9}, {3.5614960890820847`*^9, 
  3.561496168455024*^9}, {3.584447714791396*^9, 3.5844477149005957`*^9}, {
  3.58446339854538*^9, 3.5844634028977876`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"dominant eigenvector = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1.5485837703548635`", ",", "0.5485837703548635`", ",", "1.`"}], 
    "}"}]}],
  SequenceForm[
  "dominant eigenvector = ", {1.5485837703548635`, 0.5485837703548635, 1.}],
  Editable->False]], "Print",
 CellChangeTimes->{3.5844519751848793`*^9, 3.5844520776926594`*^9, 
  3.584463316116435*^9, 3.58446368903349*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"dominant eigenvector*evalue = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"7.742918851774318`", ",", "2.7429188517743173`", ",", "5.`"}], 
    "}"}]}],
  SequenceForm[
  "dominant eigenvector*evalue = ", {7.742918851774318, 2.7429188517743173`, 
   5.}],
  Editable->False]], "Print",
 CellChangeTimes->{3.5844519751848793`*^9, 3.5844520776926594`*^9, 
  3.584463316116435*^9, 3.58446368903349*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"check evec stationary: Av = lambda *v? \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
    "7.194335081419454`", ",", "2.5485837703548633`", ",", 
     "4.64575131106459`"}], "}"}]}],
  SequenceForm[
  "check evec stationary: Av = lambda *v? ", {7.194335081419454, 
   2.5485837703548633`, 4.64575131106459}],
  Editable->False]], "Print",
 CellChangeTimes->{3.5844519751848793`*^9, 3.5844520776926594`*^9, 
  3.584463316116435*^9, 3.58446368903349*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Power method success? 0=no 1=yes \"\>", "\[InvisibleSpace]", 
   "1"}],
  SequenceForm["Power method success? 0=no 1=yes ", 1],
  Editable->False]], "Print",
 CellChangeTimes->{3.5844519751848793`*^9, 3.5844520776926594`*^9, 
  3.584463316116435*^9, 3.58446368903349*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"powermethod calculated dominant eigenvector: \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.52`", ",", "0.84`"}], "}"}]}],
  SequenceForm[
  "powermethod calculated dominant eigenvector: ", {1., 0.52, 0.84}],
  Editable->False]], "Print",
 CellChangeTimes->{3.5844519751848793`*^9, 3.5844520776926594`*^9, 
  3.584463316116435*^9, 3.58446368903349*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Test conceptual idea of power method", "Section",
 CellChangeTimes->{{3.5844488746326337`*^9, 3.5844488906694617`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"numrepeat", " ", "=", " ", "10"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"guess", " ", "=", " ", "evec"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", "\"\<Test the conceptual idea of power method\>\"", "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", 
     "\"\<Check if components of eigenvector from successive iterations, \
r^{i+1}/r^i,  converge to dominant eigenvalue\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<A = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "A", "]"}], ",", "\"\<  guess evec=\>\"", 
      ",", 
      RowBox[{"MatrixForm", "[", "guess", "]"}], ",", 
      "\"\<     numrepeat=\>\"", ",", "numrepeat"}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"new", " ", "=", " ", 
         RowBox[{"A", ".", "guess"}]}], ";", " ", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"i", "<", " ", "numrepeat"}], ",", " ", 
          RowBox[{"guess", " ", "=", "  ", "new"}]}], "]"}]}], ")"}], ",", 
      " ", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "numrepeat"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sizeA", " ", "=", " ", 
     RowBox[{"Dimensions", "[", "A", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ratios", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"new", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "/", 
          RowBox[{"guess", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "//", "N"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", 
         RowBox[{"sizeA", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"trueevals", " ", "=", " ", 
     RowBox[{"Eigenvalues", "[", "A", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<A's true dominant eigenvalue = \>\"", ",", 
      RowBox[{
       RowBox[{"trueevals", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<ratios: \>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{
       "\"\<ratio for component\>\"", ",", "i", ",", "\"\< = \>\"", ",", 
        RowBox[{"ratios", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", 
        RowBox[{"sizeA", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "  ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", 
     "\"\<Are all ratios converging to the dominant eigenvalue?\>\"", "]"}], 
    ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.561496197330675*^9, 3.5614962997096553`*^9}, {
  3.561496411494644*^9, 3.5614965014132023`*^9}, {3.5614965432992754`*^9, 
  3.561496714915177*^9}, {3.5614971469915285`*^9, 3.5614971966308155`*^9}, {
  3.584448448268285*^9, 3.5844485164092045`*^9}, {3.5844485836297226`*^9, 
  3.5844485899165335`*^9}, {3.5844486360614147`*^9, 3.5844486507722406`*^9}, {
  3.5844487480696115`*^9, 3.584448862277412*^9}, {3.584449181110772*^9, 
  3.5844492717625313`*^9}, {3.5844493078297944`*^9, 3.5844493778271174`*^9}, {
  3.584451734460857*^9, 3.584451848933858*^9}, {3.58445188429912*^9, 
  3.5844519469488297`*^9}, {3.5844519928597107`*^9, 3.584452042623798*^9}, {
  3.5844521818696423`*^9, 3.5844522049732833`*^9}, {3.5844522507905636`*^9, 
  3.5844523786951885`*^9}, {3.584463434222643*^9, 3.5844634374050484`*^9}, {
  3.584463522674798*^9, 3.5844635753404903`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Test the conceptual idea of power method\"\>"], "Print",
 CellChangeTimes->{
  3.5844519752160797`*^9, 3.58445207772386*^9, 3.5844633161476345`*^9, {
   3.584463524390801*^9, 3.5844635513632483`*^9}, 3.5844636890490904`*^9}],

Cell[BoxData["\<\"Check if components of eigenvector from successive \
iterations, r^{i+1}/r^i,  converge to dominant eigenvalue\"\>"], "Print",
 CellChangeTimes->{
  3.5844519752160797`*^9, 3.58445207772386*^9, 3.5844633161476345`*^9, {
   3.584463524390801*^9, 3.5844635513632483`*^9}, 3.5844636890490904`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"A = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"4", "0", "1"},
       {"0", "1", "2"},
       {"1", "2", "2"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"  guess evec=\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"1"},
        {"1"},
        {"1"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"     numrepeat=\"\>",
    "\[InvisibleSpace]", "10"}],
  SequenceForm["A = ", 
   MatrixForm[{{4, 0, 1}, {0, 1, 2}, {1, 2, 2}}], "  guess evec=", 
   MatrixForm[{1, 1, 1}], "     numrepeat=", 10],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5844519752160797`*^9, 3.58445207772386*^9, 3.5844633161476345`*^9, {
   3.584463524390801*^9, 3.5844635513632483`*^9}, 3.58446368906469*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"A's true dominant eigenvalue = \"\>", "\[InvisibleSpace]", 
   "4.645751311064591`"}],
  SequenceForm["A's true dominant eigenvalue = ", 4.645751311064591],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5844519752160797`*^9, 3.58445207772386*^9, 3.5844633161476345`*^9, {
   3.584463524390801*^9, 3.5844635513632483`*^9}, 3.58446368906469*^9}],

Cell[BoxData["\<\"ratios: \"\>"], "Print",
 CellChangeTimes->{
  3.5844519752160797`*^9, 3.58445207772386*^9, 3.5844633161476345`*^9, {
   3.584463524390801*^9, 3.5844635513632483`*^9}, 3.58446368906469*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"ratio for component\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\" = \"\>", "\[InvisibleSpace]", 
   "4.654053788054122`"}],
  SequenceForm["ratio for component", 1, " = ", 4.654053788054122],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5844519752160797`*^9, 3.58445207772386*^9, 3.5844633161476345`*^9, {
   3.584463524390801*^9, 3.5844635513632483`*^9}, 3.58446368906469*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"ratio for component\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" = \"\>", "\[InvisibleSpace]", 
   "4.654053788054122`"}],
  SequenceForm["ratio for component", 2, " = ", 4.654053788054122],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5844519752160797`*^9, 3.58445207772386*^9, 3.5844633161476345`*^9, {
   3.584463524390801*^9, 3.5844635513632483`*^9}, 3.58446368906469*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"ratio for component\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\" = \"\>", "\[InvisibleSpace]", 
   "4.654053788054122`"}],
  SequenceForm["ratio for component", 3, " = ", 4.654053788054122],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5844519752160797`*^9, 3.58445207772386*^9, 3.5844633161476345`*^9, {
   3.584463524390801*^9, 3.5844635513632483`*^9}, 3.58446368906469*^9}],

Cell[BoxData["\<\"Are all ratios converging to the dominant \
eigenvalue?\"\>"], "Print",
 CellChangeTimes->{
  3.5844519752160797`*^9, 3.58445207772386*^9, 3.5844633161476345`*^9, {
   3.584463524390801*^9, 3.5844635513632483`*^9}, 3.58446368906469*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1082, 630},
WindowMargins->{{Automatic, 41}, {28, Automatic}},
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.5, 1.5 Inherited],
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 673, 13, 291, "Subtitle"],
Cell[1255, 37, 1072, 18, 386, "Subsubtitle"],
Cell[CellGroupData[{
Cell[2352, 59, 369, 8, 143, "Section"],
Cell[2724, 69, 219, 5, 70, "Text"],
Cell[2946, 76, 12889, 315, 1583, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15872, 396, 167, 3, 105, "Section"],
Cell[16042, 401, 9638, 218, 1691, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25717, 624, 103, 1, 105, "Section"],
Cell[CellGroupData[{
Cell[25845, 629, 7846, 162, 935, "Input"],
Cell[CellGroupData[{
Cell[33716, 795, 173, 2, 32, "Print"],
Cell[33892, 799, 1062, 28, 70, "Print"],
Cell[34957, 829, 1206, 29, 70, "Print"],
Cell[36166, 860, 164, 2, 32, "Print"],
Cell[36333, 864, 1184, 30, 70, "Print"],
Cell[37520, 896, 353, 8, 32, "Print"],
Cell[37876, 906, 348, 8, 32, "Print"],
Cell[38227, 916, 315, 7, 32, "Print"],
Cell[38545, 925, 529, 10, 32, "Print"],
Cell[39077, 937, 352, 8, 32, "Print"],
Cell[39432, 947, 315, 7, 32, "Print"],
Cell[39750, 956, 603, 13, 32, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40414, 976, 112, 4, 143, "Section"],
Cell[CellGroupData[{
Cell[40551, 984, 1975, 47, 233, "Input"],
Cell[CellGroupData[{
Cell[42551, 1035, 445, 10, 32, "Print"],
Cell[42999, 1047, 461, 11, 32, "Print"],
Cell[43463, 1060, 517, 13, 32, "Print"],
Cell[43983, 1075, 320, 7, 32, "Print"],
Cell[44306, 1084, 431, 10, 32, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[44798, 1101, 125, 1, 105, "Section"],
Cell[CellGroupData[{
Cell[44948, 1106, 4157, 103, 665, "Input"],
Cell[CellGroupData[{
Cell[49130, 1213, 242, 3, 32, "Print"],
Cell[49375, 1218, 312, 4, 58, "Print"],
Cell[49690, 1224, 1856, 49, 70, "Print"],
Cell[51549, 1275, 400, 8, 32, "Print"],
Cell[51952, 1285, 207, 3, 32, "Print"],
Cell[52162, 1290, 452, 9, 32, "Print"],
Cell[52617, 1301, 452, 9, 32, "Print"],
Cell[53072, 1312, 452, 9, 32, "Print"],
Cell[53527, 1323, 254, 4, 32, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
