(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     47249,       1146]
NotebookOptionsPosition[     46118,       1102]
NotebookOutlinePosition[     46462,       1117]
CellTagsIndexPosition[     46419,       1114]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 "\n"
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
  3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
  3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
  3.5842134956497355`*^9, 3.5842135862546945`*^9}},
 FontFamily->"Arial"],

Cell[TextData[{
 "\n",
 StyleBox["Projection 3D",
  FontWeight->"Bold"],
 "\nConstruct an orthogonal and oblique projection and apply the projections \
to a sample of 3D vectors spanning 90 degrees.\nLast section allows user to \
enter u1, u2 vectors defining the plane for an orthogonal projection and the \
projection matrix is constructed from this input."
}], "Subsubtitle",
 CellChangeTimes->{{3.5597615527441206`*^9, 3.5597615647717414`*^9}, 
   3.5844681782683744`*^9, {3.584468983104988*^9, 3.584469034772279*^9}, {
   3.584469713545071*^9, 3.5844697666787643`*^9}}],

Cell[CellGroupData[{

Cell["\<\

Creates a figure for PLA -- Linear3D Projection section\
\>", "Section",
 CellChangeTimes->{
  3.559761567704547*^9, {3.5672655834794493`*^9, 3.5672656127223005`*^9}, {
   3.5844683905691476`*^9, 3.58446839191075*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Number", " ", "of", " ", "vectors", " ", "to", " ", "draw"}], " ",
    "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"numu", " ", "=", " ", "10"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Oblique", " ", "angle", " ", "for", " ", 
     RowBox[{"projection", " ", "--"}], " ", "in", " ", "degrees", " ", "and",
      " ", "converted", " ", "to", " ", "radians", " ", "here"}], " ", "*)"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"obliqueangle", " ", "=", " ", 
     RowBox[{"45", "*", 
      RowBox[{"(", 
       RowBox[{"Pi", "/", "180"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"define", " ", "coordinate", " ", "system"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"origin", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", " ", "0"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"e1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", " ", "0"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"e2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", " ", "0"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"v", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "1"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"create", " ", "numu", " ", "vectors", " ", 
     RowBox[{"u", "[", "i", "]"}], " ", "between", " ", "0", " ", "and", " ", 
     "90", " ", "degrees"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"degrees", " ", "=", " ", 
     RowBox[{"90", "/", "numu"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"u", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"RotationMatrix", "[", 
         RowBox[{
          RowBox[{"degrees", "*", 
           RowBox[{"(", 
            RowBox[{"i", "-", "1"}], ")"}], " ", "Degree"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "]"}], ".", "v"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numu"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<u = \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "u", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Orthogonal", " ", "projection"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Rortho", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Apply", " ", "matrix", " ", "to", " ", "u", " ", "vectors"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"uortho", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Rortho", ".", 
        RowBox[{"u", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numu"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Orthogonal projection matrix = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "Rortho", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "oblique", " ", "projection", " ", "matrix", " ", "and", 
     " ", "apply", " ", "to", " ", "u", " ", "vectors"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", " ", "=", " ", 
     RowBox[{"Cos", "[", "obliqueangle", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"s", " ", "=", " ", 
     RowBox[{"Sin", "[", "obliqueangle", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Roblique", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "s"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"uoblique", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Roblique", " ", ".", 
        RowBox[{"u", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numu"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Oblique projection matrix = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "Roblique", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.559761599840603*^9, 3.559761616407832*^9}, {
  3.559761648621889*^9, 3.559761664877117*^9}, {3.559762022374942*^9, 
  3.5597620257601476`*^9}, {3.559762106977488*^9, 3.559762336317088*^9}, {
  3.5597632937063613`*^9, 3.559763310772791*^9}, {3.5597633472108545`*^9, 
  3.5597634166309767`*^9}, {3.5597646845007944`*^9, 3.5597646923476086`*^9}, {
  3.5597733462109146`*^9, 3.5597733743845644`*^9}, {3.5597753556304207`*^9, 
  3.5597753557864213`*^9}, {3.559775649302932*^9, 3.559775684753394*^9}, {
  3.559775935930234*^9, 3.5597759568974705`*^9}, {3.5597760938673096`*^9, 
  3.5597760943197103`*^9}, {3.5597761856706696`*^9, 3.559776217354325*^9}, {
  3.5844683336446476`*^9, 3.5844683724419155`*^9}, {3.584468404531172*^9, 
  3.584468453608858*^9}, {3.584468520954177*^9, 3.584468690386074*^9}, {
  3.584469637276537*^9, 3.5844696404745426`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"u = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.`", "0.`", "1.`"},
       {"0.9876883405951378`", "0.15643446504023087`", "1.`"},
       {"0.9510565162951535`", "0.30901699437494745`", "1.`"},
       {"0.8910065241883679`", "0.45399049973954675`", "1.`"},
       {"0.8090169943749475`", "0.5877852522924731`", "1.`"},
       {"0.7071067811865475`", "0.7071067811865475`", "1.`"},
       {"0.5877852522924731`", "0.8090169943749475`", "1.`"},
       {"0.45399049973954675`", "0.8910065241883679`", "1.`"},
       {"0.30901699437494745`", "0.9510565162951535`", "1.`"},
       {"0.15643446504023087`", "0.9876883405951378`", "1.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["u = ", 
   MatrixForm[{{1., 0., 1.}, {0.9876883405951378, 0.15643446504023087`, 1.}, {
    0.9510565162951535, 0.30901699437494745`, 1.}, {0.8910065241883679, 
    0.45399049973954675`, 1.}, {0.8090169943749475, 0.5877852522924731, 1.}, {
    0.7071067811865475, 0.7071067811865475, 1.}, {0.5877852522924731, 
    0.8090169943749475, 1.}, {0.45399049973954675`, 0.8910065241883679, 1.}, {
    0.30901699437494745`, 0.9510565162951535, 1.}, {0.15643446504023087`, 
    0.9876883405951378, 1.}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.5844688330483246`*^9, 3.5844695706956205`*^9, 
  3.584469645279351*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Orthogonal projection matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Orthogonal projection matrix = ", 
   MatrixForm[{{1, 0, 0}, {0, 1, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.5844688330483246`*^9, 3.5844695706956205`*^9, 
  3.584469645279351*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Oblique projection matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", 
        FractionBox["1", 
         SqrtBox["2"]]},
       {"0", "1", 
        FractionBox["1", 
         SqrtBox["2"]]},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Oblique projection matrix = ", 
   MatrixForm[{{1, 0, 2^Rational[-1, 2]}, {0, 1, 2^Rational[-1, 2]}, {0, 0, 
     0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.5844688330483246`*^9, 3.5844695706956205`*^9, 
  3.5844696452949514`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

Graphics\
\>", "Section",
 CellChangeTimes->{{3.5844688073394794`*^9, 3.5844688123938885`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"athick", " ", "=", " ", "0.005"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dirthick", " ", "=", " ", "0.01"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"viewpoint", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"2.5", ",", 
       RowBox[{"-", "2"}], ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"uarrows", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Graphics3D", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Thickness", "[", "athick", "]"}], ",", " ", 
           RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", 
           RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{"origin", ",", " ", 
              RowBox[{"u", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], ",", 
         " ", 
         RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
         RowBox[{"Axes", "\[Rule]", "False"}], ",", " ", 
         RowBox[{"Boxed", "\[Rule]", "False"}], ",", " ", 
         RowBox[{"ViewPoint", "\[Rule]", "viewpoint"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numu"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"uorthoarrows", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Graphics3D", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Thickness", "[", "athick", "]"}], ",", " ", 
           RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
           RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{"origin", ",", " ", 
              RowBox[{"uortho", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], ",", 
         " ", 
         RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numu"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"orthodir", " ", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "dirthick", "]"}], ",", " ", 
         RowBox[{"GrayLevel", "[", "0.9", "]"}], ",", 
         RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
            RowBox[{"uortho", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], ",", 
       " ", 
       RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"uobliquearrows", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Graphics3D", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Thickness", "[", "athick", "]"}], ",", " ", 
           RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
           RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{"origin", ",", " ", 
              RowBox[{"uoblique", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], ",", 
         " ", 
         RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numu"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"obliquedir", " ", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "dirthick", "]"}], ",", " ", 
         RowBox[{"GrayLevel", "[", "0.9", "]"}], ",", 
         RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
            RowBox[{"uoblique", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], ",", 
       " ", 
       RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"gortho", " ", "=", " ", 
     RowBox[{"Show", "[", 
      RowBox[{"uarrows", ",", " ", "uorthoarrows", ",", " ", "orthodir"}], 
      " ", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"goblique", " ", "=", " ", 
     RowBox[{"Show", "[", 
      RowBox[{"uarrows", ",", " ", "uobliquearrows", ",", " ", "obliquedir"}],
       " ", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"pic", " ", "=", " ", 
    RowBox[{"GraphicsRow", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"gortho", ",", " ", "goblique"}], "}"}], ",", 
      RowBox[{"Alignment", "\[Rule]", "Center"}], ",", " ", 
      RowBox[{"ImageSize", "\[Rule]", "Full"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<Projections3D.eps\>\"", ",", " ", "pic"}], "]"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5597616704619274`*^9, 3.559761707680791*^9}, {
   3.5597617402380486`*^9, 3.559761746431259*^9}, {3.5597618813954945`*^9, 
   3.5597618870739045`*^9}, {3.5597620577154026`*^9, 3.559762091627061*^9}, {
   3.5597623538671193`*^9, 3.5597623861131754`*^9}, {3.5597624346540585`*^9, 
   3.559762529998624*^9}, {3.5597626037031517`*^9, 3.559762623837587*^9}, {
   3.5597647197108555`*^9, 3.559764732128477*^9}, {3.559773293593622*^9, 
   3.559773332983691*^9}, {3.5597733828865795`*^9, 3.5597734779375467`*^9}, {
   3.559773536752448*^9, 3.5597736550738554`*^9}, {3.559773690112316*^9, 
   3.559773755836031*^9}, {3.5597738045081162`*^9, 3.55977384659699*^9}, {
   3.559774687040056*^9, 3.559774766039394*^9}, {3.559774800923854*^9, 
   3.559774806805064*^9}, {3.559774909393643*^9, 3.5597749726077523`*^9}, {
   3.559775042295074*^9, 3.55977507463593*^9}, 3.559775108019989*^9, {
   3.559775139207242*^9, 3.5597753373159885`*^9}, {3.5597754449909754`*^9, 
   3.559775537796338*^9}, {3.559775991560731*^9, 3.559776000374747*^9}, {
   3.5597760756300783`*^9, 3.5597761018389235`*^9}, {3.5597761407773914`*^9, 
   3.55977616286703*^9}, 3.584468829195118*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     Graphics3DBox[{
       {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
        Arrow3DBox[{{0, 0, 0}, {1, 0, 1}}]}, 
       {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
        Arrow3DBox[
         NCache[{{0, 0, 0}, {Cos[9 Degree], Sin[9 Degree], 1}}, {{0, 0, 0}, {
           0.9876883405951378, 0.15643446504023087`, 1}}]]}, 
       {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
        Arrow3DBox[
         NCache[{{0, 0, 0}, {
           Rational[1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^
             Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 1}}, {{0,
            0, 0}, {0.9510565162951535, 0.30901699437494745`, 1}}]]}, 
       {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
        Arrow3DBox[
         NCache[{{0, 0, 0}, {Cos[27 Degree], Sin[27 Degree], 1}}, {{0, 0, 
           0}, {0.8910065241883679, 0.45399049973954675`, 1}}]]}, 
       {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
        Arrow3DBox[
         NCache[{{0, 0, 0}, {
           Rational[1, 4] (1 + 5^Rational[1, 2]), 
            Rational[1, 2] (Rational[1, 2] (5 - 5^Rational[1, 2]))^
             Rational[1, 2], 1}}, {{0, 0, 0}, {
           0.8090169943749475, 0.5877852522924731, 1}}]]}, 
       {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
        Arrow3DBox[
         NCache[{{0, 0, 0}, {2^Rational[-1, 2], 2^Rational[-1, 2], 1}}, {{0, 
           0, 0}, {0.7071067811865475, 0.7071067811865475, 1}}]]}, 
       {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
        Arrow3DBox[
         NCache[{{0, 0, 0}, {
           Rational[1, 2] (Rational[1, 2] (5 - 5^Rational[1, 2]))^
             Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 1}}, {{0, 
           0, 0}, {0.5877852522924731, 0.8090169943749475, 1}}]]}, 
       {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
        Arrow3DBox[
         NCache[{{0, 0, 0}, {Sin[27 Degree], Cos[27 Degree], 1}}, {{0, 0, 
           0}, {0.45399049973954675`, 0.8910065241883679, 1}}]]}, 
       {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
        Arrow3DBox[
         NCache[{{0, 0, 0}, {
           Rational[1, 4] (-1 + 5^Rational[1, 2]), 
            Rational[1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^
             Rational[1, 2], 1}}, {{0, 0, 0}, {
           0.30901699437494745`, 0.9510565162951535, 1}}]]}, 
       {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
        Arrow3DBox[
         NCache[{{0, 0, 0}, {Sin[9 Degree], Cos[9 Degree], 1}}, {{0, 0, 0}, {
           0.15643446504023087`, 0.9876883405951378, 1}}]]}, 
       {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
        StyleBox[Arrow3DBox[{{0, 0, 0}, {1, 0, 0}}],
         FontColor->GrayLevel[0.]]}, 
       {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
        StyleBox[
         Arrow3DBox[
          NCache[{{0, 0, 0}, {Cos[9 Degree], Sin[9 Degree], 0}}, {{0, 0, 0}, {
            0.9876883405951378, 0.15643446504023087`, 0}}]],
         FontColor->GrayLevel[0.]]}, 
       {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
        StyleBox[
         Arrow3DBox[
          NCache[{{0, 0, 0}, {
            Rational[1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^
              Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 0}}, {{
            0, 0, 0}, {0.9510565162951535, 0.30901699437494745`, 0}}]],
         FontColor->GrayLevel[0.]]}, 
       {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
        StyleBox[
         Arrow3DBox[
          NCache[{{0, 0, 0}, {Cos[27 Degree], Sin[27 Degree], 0}}, {{0, 0, 
            0}, {0.8910065241883679, 0.45399049973954675`, 0}}]],
         FontColor->GrayLevel[0.]]}, 
       {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
        StyleBox[
         Arrow3DBox[
          NCache[{{0, 0, 0}, {
            Rational[1, 4] (1 + 5^Rational[1, 2]), 
             Rational[1, 2] (Rational[1, 2] (5 - 5^Rational[1, 2]))^
              Rational[1, 2], 0}}, {{0, 0, 0}, {
            0.8090169943749475, 0.5877852522924731, 0}}]],
         FontColor->GrayLevel[0.]]}, 
       {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
        StyleBox[
         Arrow3DBox[
          NCache[{{0, 0, 0}, {2^Rational[-1, 2], 2^Rational[-1, 2], 0}}, {{0, 
            0, 0}, {0.7071067811865475, 0.7071067811865475, 0}}]],
         FontColor->GrayLevel[0.]]}, 
       {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
        StyleBox[
         Arrow3DBox[
          NCache[{{0, 0, 0}, {
            Rational[1, 2] (Rational[1, 2] (5 - 5^Rational[1, 2]))^
              Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 0}}, {{0,
             0, 0}, {0.5877852522924731, 0.8090169943749475, 0}}]],
         FontColor->GrayLevel[0.]]}, 
       {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
        StyleBox[
         Arrow3DBox[
          NCache[{{0, 0, 0}, {Sin[27 Degree], Cos[27 Degree], 0}}, {{0, 0, 
            0}, {0.45399049973954675`, 0.8910065241883679, 0}}]],
         FontColor->GrayLevel[0.]]}, 
       {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
        StyleBox[
         Arrow3DBox[
          NCache[{{0, 0, 0}, {
            Rational[1, 4] (-1 + 5^Rational[1, 2]), 
             Rational[1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^
              Rational[1, 2], 0}}, {{0, 0, 0}, {
            0.30901699437494745`, 0.9510565162951535, 0}}]],
         FontColor->GrayLevel[0.]]}, 
       {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
        StyleBox[
         Arrow3DBox[
          NCache[{{0, 0, 0}, {Sin[9 Degree], Cos[9 Degree], 0}}, {{0, 0, 0}, {
            0.15643446504023087`, 0.9876883405951378, 0}}]],
         FontColor->GrayLevel[0.]]}, 
       {GrayLevel[0.9], Thickness[0.01], Arrowheads[Large], 
        Arrow3DBox[{{1, 0, 1}, {1, 0, 0}}]}},
      AspectRatio->1,
      Axes->False,
      Boxed->False,
      ViewPoint->{2.5, -2, 1}], {192., -189.}, ImageScaled[{0.5, 0.5}], {360., 360.},
     ContentSelectable->True], InsetBox[
     Graphics3DBox[{
       {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
        Arrow3DBox[{{0, 0, 0}, {1, 0, 1}}]}, 
       {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
        Arrow3DBox[
         NCache[{{0, 0, 0}, {Cos[9 Degree], Sin[9 Degree], 1}}, {{0, 0, 0}, {
           0.9876883405951378, 0.15643446504023087`, 1}}]]}, 
       {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
        Arrow3DBox[
         NCache[{{0, 0, 0}, {
           Rational[1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^
             Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 1}}, {{0,
            0, 0}, {0.9510565162951535, 0.30901699437494745`, 1}}]]}, 
       {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
        Arrow3DBox[
         NCache[{{0, 0, 0}, {Cos[27 Degree], Sin[27 Degree], 1}}, {{0, 0, 
           0}, {0.8910065241883679, 0.45399049973954675`, 1}}]]}, 
       {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
        Arrow3DBox[
         NCache[{{0, 0, 0}, {
           Rational[1, 4] (1 + 5^Rational[1, 2]), 
            Rational[1, 2] (Rational[1, 2] (5 - 5^Rational[1, 2]))^
             Rational[1, 2], 1}}, {{0, 0, 0}, {
           0.8090169943749475, 0.5877852522924731, 1}}]]}, 
       {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
        Arrow3DBox[
         NCache[{{0, 0, 0}, {2^Rational[-1, 2], 2^Rational[-1, 2], 1}}, {{0, 
           0, 0}, {0.7071067811865475, 0.7071067811865475, 1}}]]}, 
       {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
        Arrow3DBox[
         NCache[{{0, 0, 0}, {
           Rational[1, 2] (Rational[1, 2] (5 - 5^Rational[1, 2]))^
             Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 1}}, {{0, 
           0, 0}, {0.5877852522924731, 0.8090169943749475, 1}}]]}, 
       {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
        Arrow3DBox[
         NCache[{{0, 0, 0}, {Sin[27 Degree], Cos[27 Degree], 1}}, {{0, 0, 
           0}, {0.45399049973954675`, 0.8910065241883679, 1}}]]}, 
       {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
        Arrow3DBox[
         NCache[{{0, 0, 0}, {
           Rational[1, 4] (-1 + 5^Rational[1, 2]), 
            Rational[1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^
             Rational[1, 2], 1}}, {{0, 0, 0}, {
           0.30901699437494745`, 0.9510565162951535, 1}}]]}, 
       {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
        Arrow3DBox[
         NCache[{{0, 0, 0}, {Sin[9 Degree], Cos[9 Degree], 1}}, {{0, 0, 0}, {
           0.15643446504023087`, 0.9876883405951378, 1}}]]}, 
       {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
        StyleBox[
         Arrow3DBox[
          NCache[{{0, 0, 0}, {
            1 + 2^Rational[-1, 2], 2^Rational[-1, 2], 0}}, {{0, 0, 0}, {
            1.7071067811865475`, 0.7071067811865475, 0}}]],
         FontColor->GrayLevel[0.]]}, 
       {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
        StyleBox[
         Arrow3DBox[
          NCache[{{0, 0, 0}, {
            2^Rational[-1, 2] + Cos[9 Degree], 2^Rational[-1, 2] + 
             Sin[9 Degree], 0}}, {{0, 0, 0}, {
            1.6947951217816852`, 0.8635412462267783, 0}}]],
         FontColor->GrayLevel[0.]]}, 
       {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
        StyleBox[
         Arrow3DBox[
          NCache[{{0, 0, 0}, {
            2^Rational[-1, 2] + 
             Rational[1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^
               Rational[1, 2], 2^Rational[-1, 2] + 
             Rational[1, 4] (-1 + 5^Rational[1, 2]), 0}}, {{0, 0, 0}, {
            1.658163297481701, 1.016123775561495, 0}}]],
         FontColor->GrayLevel[0.]]}, 
       {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
        StyleBox[
         Arrow3DBox[
          NCache[{{0, 0, 0}, {
            2^Rational[-1, 2] + Cos[27 Degree], 2^Rational[-1, 2] + 
             Sin[27 Degree], 0}}, {{0, 0, 0}, {
            1.5981133053749152`, 1.1610972809260942`, 0}}]],
         FontColor->GrayLevel[0.]]}, 
       {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
        StyleBox[
         Arrow3DBox[
          NCache[{{0, 0, 0}, {
            2^Rational[-1, 2] + Rational[1, 4] (1 + 5^Rational[1, 2]), 
             2^Rational[-1, 2] + 
             Rational[1, 2] (Rational[1, 2] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], 0}}, {{0, 0, 0}, {
            1.516123775561495, 1.2948920334790206`, 0}}]],
         FontColor->GrayLevel[0.]]}, 
       {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
        StyleBox[
         Arrow3DBox[
          NCache[{{0, 0, 0}, {2^Rational[1, 2], 2^Rational[1, 2], 0}}, {{0, 0,
             0}, {1.4142135623730951`, 1.4142135623730951`, 0}}]],
         FontColor->GrayLevel[0.]]}, 
       {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
        StyleBox[
         Arrow3DBox[
          NCache[{{0, 0, 0}, {
            2^Rational[-1, 2] + 
             Rational[1, 2] (Rational[1, 2] (5 - 5^Rational[1, 2]))^
               Rational[1, 2], 2^Rational[-1, 2] + 
             Rational[1, 4] (1 + 5^Rational[1, 2]), 0}}, {{0, 0, 0}, {
            1.2948920334790206`, 1.516123775561495, 0}}]],
         FontColor->GrayLevel[0.]]}, 
       {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
        StyleBox[
         Arrow3DBox[
          NCache[{{0, 0, 0}, {
            2^Rational[-1, 2] + Sin[27 Degree], 2^Rational[-1, 2] + 
             Cos[27 Degree], 0}}, {{0, 0, 0}, {
            1.1610972809260942`, 1.5981133053749152`, 0}}]],
         FontColor->GrayLevel[0.]]}, 
       {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
        StyleBox[
         Arrow3DBox[
          NCache[{{0, 0, 0}, {
            2^Rational[-1, 2] + Rational[1, 4] (-1 + 5^Rational[1, 2]), 
             2^Rational[-1, 2] + 
             Rational[1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^
               Rational[1, 2], 0}}, {{0, 0, 0}, {
            1.016123775561495, 1.658163297481701, 0}}]],
         FontColor->GrayLevel[0.]]}, 
       {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
        StyleBox[
         Arrow3DBox[
          NCache[{{0, 0, 0}, {
            2^Rational[-1, 2] + Sin[9 Degree], 2^Rational[-1, 2] + 
             Cos[9 Degree], 0}}, {{0, 0, 0}, {
            0.8635412462267783, 1.6947951217816852`, 0}}]],
         FontColor->GrayLevel[0.]]}, 
       {GrayLevel[0.9], Thickness[0.01], Arrowheads[Large], 
        Arrow3DBox[
         NCache[{{1, 0, 1}, {1 + 2^Rational[-1, 2], 2^Rational[-1, 2], 0}}, {{
           1, 0, 1}, {1.7071067811865475`, 0.7071067811865475, 0}}]]}},
      AspectRatio->1,
      Axes->False,
      Boxed->False,
      ViewPoint->{2.5, -2, 1}], {576., -189.}, ImageScaled[{0.5, 0.5}], {360., 360.},
     ContentSelectable->True]}, {}},
  ContentSelectable->True,
  ImageSize->Full,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.559761767865697*^9, {3.5597620303465557`*^9, 3.5597620929374633`*^9}, 
   3.5597623937427883`*^9, 3.5597625429310465`*^9, {3.5597626075043583`*^9, 
   3.5597626253507895`*^9}, {3.559763297996369*^9, 3.5597633183232045`*^9}, {
   3.55976339608574*^9, 3.559763423260988*^9}, 3.5597647019548254`*^9, 
   3.55976473364168*^9, 3.5597733047944417`*^9, 3.55977348023075*^9, 
   3.559773591800144*^9, {3.559773632422615*^9, 3.559773656212657*^9}, 
   3.5597737706716566`*^9, 3.559773851448599*^9, 3.5597747124213004`*^9, 
   3.5597747676617966`*^9, 3.5597748087706676`*^9, {3.5597749211716633`*^9, 
   3.559774973528154*^9}, {3.5597750447130785`*^9, 3.559775076242733*^9}, 
   3.559775109330391*^9, {3.559775142966849*^9, 3.5597752075061617`*^9}, 
   3.559775277753085*^9, {3.5597753145399485`*^9, 3.5597753685628433`*^9}, {
   3.55977545324339*^9, 3.5597755382799387`*^9}, {3.559775946179452*^9, 
   3.5597759599394755`*^9}, {3.55977600210635*^9, 3.559776019827981*^9}, {
   3.559776077174481*^9, 3.559776106777732*^9}, 3.559776163709431*^9, {
   3.5597762092579107`*^9, 3.55977622041193*^9}, 3.5672631801698294`*^9, 
   3.5672655738854322`*^9, 3.5672656213647156`*^9, 3.567265667150796*^9, 
   3.584464231462043*^9, 3.5844688330951247`*^9, 3.5844695707580204`*^9, 
   3.584469645341751*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Another orthogonal projection example\
\>", "Section",
 CellChangeTimes->{{3.567265552918996*^9, 3.5672655685814233`*^9}, {
  3.56726585174592*^9, 3.567265883725976*^9}, {3.5844688683355865`*^9, 
  3.584468892094428*^9}, {3.5844690885455737`*^9, 3.5844691000427933`*^9}}],

Cell["\<\

u_1 = [1/sqrt2, 0, 1/sqrt2]^T   and   u_2 = [0,1,0]^T
u1 and u2 must be orthonormal\
\>", "Text",
 CellChangeTimes->{{3.584468873249595*^9, 3.5844688978976383`*^9}, {
  3.584469421730959*^9, 3.584469428719771*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Specify", " ", "two", " ", "orthonormal", " ", "vectors"}], ",", 
    " ", 
    RowBox[{"defining", " ", "projection", " ", "plane"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Would", " ", "be", " ", "good", " ", "to", " ", "add", " ", "check", " ", 
    "for", " ", "orthonormal", " ", "condition", " ", "and", " ", "correct", 
    " ", "for", " ", "user"}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"u1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", "2", "]"}]}], ",", " ", "0", ",", " ", 
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", "2", "]"}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"u2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"u1", " ", "=", " ", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"u2", " ", "=", " ", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], ";"}], 
    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Form", " ", "A"}], " ", "=", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"[", 
        RowBox[{"u1", ",", " ", "u2"}], "]"}], " ", "--"}], " ", "as", " ", 
      "column", " ", 
      RowBox[{"vectors", ".", " ", "Mathematica"}], " ", "form", " ", "makes",
       " ", "it", " ", "easier", " ", "to", " ", "form", " ", 
      RowBox[{"A", "^", "T"}], " ", "first"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"AT", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"u1", ",", " ", "u2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", " ", "=", " ", 
     RowBox[{"Transpose", "[", "AT", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Orthognonal", " ", "projection", " ", "matrix"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Rortho2", " ", "=", " ", 
     RowBox[{"A", ".", "AT"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Apply", " ", "linear", " ", "map", " ", "to", " ", "u", " ", "vectors"}],
     " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"uortho2", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Rortho2", ".", 
        RowBox[{"u", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numu"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Orthogonal projection matrix = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "Rortho2", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"uorthoarrows2", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Graphics3D", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Thickness", "[", "athick", "]"}], ",", " ", 
           RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
           RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", 
           RowBox[{"Arrow", "[", 
            RowBox[{"{", 
             RowBox[{"origin", ",", " ", 
              RowBox[{"uortho2", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], ",", 
         " ", 
         RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numu"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"orthodir2", " ", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "dirthick", "]"}], ",", " ", 
         RowBox[{"GrayLevel", "[", "0.9", "]"}], ",", 
         RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", "numu", "]"}], "]"}], ",", " ", 
            RowBox[{"uortho2", "[", 
             RowBox[{"[", "numu", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], ",", 
       " ", 
       RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"gortho2", " ", "=", " ", 
    RowBox[{"Show", "[", 
     RowBox[{"uarrows", ",", " ", "uorthoarrows2", ",", " ", "orthodir2"}], 
     " ", "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.5672654423460016`*^9, 3.5672655404545736`*^9}, {
  3.5672656283067274`*^9, 3.567265697180848*^9}, {3.567265773308982*^9, 
  3.567265790827813*^9}, {3.584469107187606*^9, 3.584469148605679*^9}, {
  3.5844692548262653`*^9, 3.5844693766780796`*^9}, {3.5844694347881813`*^9, 
  3.58446962738612*^9}, {3.5844696886006274`*^9, 3.584469698647045*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Orthogonal projection matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0"},
       {"0", "1", "0"},
       {"0", "0", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Orthogonal projection matrix = ", 
   MatrixForm[{{1, 0, 0}, {0, 1, 0}, {0, 0, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.5844693546508408`*^9, 3.584469377988482*^9}, 
   3.584469571007621*^9, 3.584469645560152*^9}],

Cell[BoxData[
 Graphics3DBox[{
   {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
    Arrow3DBox[{{0, 0, 0}, {1, 0, 1}}]}, 
   {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
    Arrow3DBox[
     NCache[{{0, 0, 0}, {Cos[9 Degree], Sin[9 Degree], 1}}, {{0, 0, 0}, {
       0.9876883405951378, 0.15643446504023087`, 1}}]]}, 
   {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
    Arrow3DBox[
     NCache[{{0, 0, 0}, {
       Rational[1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2], 
        Rational[1, 4] (-1 + 5^Rational[1, 2]), 1}}, {{0, 0, 0}, {
       0.9510565162951535, 0.30901699437494745`, 1}}]]}, 
   {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
    Arrow3DBox[
     NCache[{{0, 0, 0}, {Cos[27 Degree], Sin[27 Degree], 1}}, {{0, 0, 0}, {
       0.8910065241883679, 0.45399049973954675`, 1}}]]}, 
   {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
    Arrow3DBox[
     NCache[{{0, 0, 0}, {
       Rational[1, 4] (1 + 5^Rational[1, 2]), 
        Rational[1, 2] (Rational[1, 2] (5 - 5^Rational[1, 2]))^Rational[1, 2],
         1}}, {{0, 0, 0}, {0.8090169943749475, 0.5877852522924731, 1}}]]}, 
   {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
    Arrow3DBox[
     NCache[{{0, 0, 0}, {2^Rational[-1, 2], 2^Rational[-1, 2], 1}}, {{0, 0, 
       0}, {0.7071067811865475, 0.7071067811865475, 1}}]]}, 
   {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
    Arrow3DBox[
     NCache[{{0, 0, 0}, {
       Rational[1, 2] (Rational[1, 2] (5 - 5^Rational[1, 2]))^Rational[1, 2], 
        Rational[1, 4] (1 + 5^Rational[1, 2]), 1}}, {{0, 0, 0}, {
       0.5877852522924731, 0.8090169943749475, 1}}]]}, 
   {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
    Arrow3DBox[
     NCache[{{0, 0, 0}, {Sin[27 Degree], Cos[27 Degree], 1}}, {{0, 0, 0}, {
       0.45399049973954675`, 0.8910065241883679, 1}}]]}, 
   {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
    Arrow3DBox[
     NCache[{{0, 0, 0}, {
       Rational[1, 4] (-1 + 5^Rational[1, 2]), 
        Rational[1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2],
         1}}, {{0, 0, 0}, {0.30901699437494745`, 0.9510565162951535, 1}}]]}, 
   {GrayLevel[0.5], Thickness[0.005], Arrowheads[Medium], 
    Arrow3DBox[
     NCache[{{0, 0, 0}, {Sin[9 Degree], Cos[9 Degree], 1}}, {{0, 0, 0}, {
       0.15643446504023087`, 0.9876883405951378, 1}}]]}, 
   {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
    StyleBox[Arrow3DBox[{{0, 0, 0}, {1, 0, 0}}],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
    StyleBox[
     Arrow3DBox[
      NCache[{{0, 0, 0}, {Cos[9 Degree], Sin[9 Degree], 0}}, {{0, 0, 0}, {
        0.9876883405951378, 0.15643446504023087`, 0}}]],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
    StyleBox[
     Arrow3DBox[
      NCache[{{0, 0, 0}, {
        Rational[1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^Rational[1, 2],
          Rational[1, 4] (-1 + 5^Rational[1, 2]), 0}}, {{0, 0, 0}, {
        0.9510565162951535, 0.30901699437494745`, 0}}]],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
    StyleBox[
     Arrow3DBox[
      NCache[{{0, 0, 0}, {Cos[27 Degree], Sin[27 Degree], 0}}, {{0, 0, 0}, {
        0.8910065241883679, 0.45399049973954675`, 0}}]],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
    StyleBox[
     Arrow3DBox[
      NCache[{{0, 0, 0}, {
        Rational[1, 4] (1 + 5^Rational[1, 2]), 
         Rational[1, 2] (Rational[1, 2] (5 - 5^Rational[1, 2]))^
          Rational[1, 2], 0}}, {{0, 0, 0}, {
        0.8090169943749475, 0.5877852522924731, 0}}]],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
    StyleBox[
     Arrow3DBox[
      NCache[{{0, 0, 0}, {2^Rational[-1, 2], 2^Rational[-1, 2], 0}}, {{0, 0, 
        0}, {0.7071067811865475, 0.7071067811865475, 0}}]],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
    StyleBox[
     Arrow3DBox[
      NCache[{{0, 0, 0}, {
        Rational[1, 2] (Rational[1, 2] (5 - 5^Rational[1, 2]))^Rational[1, 2],
          Rational[1, 4] (1 + 5^Rational[1, 2]), 0}}, {{0, 0, 0}, {
        0.5877852522924731, 0.8090169943749475, 0}}]],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
    StyleBox[
     Arrow3DBox[
      NCache[{{0, 0, 0}, {Sin[27 Degree], Cos[27 Degree], 0}}, {{0, 0, 0}, {
        0.45399049973954675`, 0.8910065241883679, 0}}]],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
    StyleBox[
     Arrow3DBox[
      NCache[{{0, 0, 0}, {
        Rational[1, 4] (-1 + 5^Rational[1, 2]), 
         Rational[1, 2] (Rational[1, 2] (5 + 5^Rational[1, 2]))^
          Rational[1, 2], 0}}, {{0, 0, 0}, {
        0.30901699437494745`, 0.9510565162951535, 0}}]],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.], Thickness[0.005], Arrowheads[Medium], 
    StyleBox[
     Arrow3DBox[
      NCache[{{0, 0, 0}, {Sin[9 Degree], Cos[9 Degree], 0}}, {{0, 0, 0}, {
        0.15643446504023087`, 0.9876883405951378, 0}}]],
     FontColor->GrayLevel[0.]]}, 
   {GrayLevel[0.9], Thickness[0.01], Arrowheads[Large], 
    Arrow3DBox[
     NCache[{{Sin[9 Degree], Cos[9 Degree], 1}, {
       Sin[9 Degree], Cos[9 Degree], 0}}, {{
       0.15643446504023087`, 0.9876883405951378, 1}, {
       0.15643446504023087`, 0.9876883405951378, 0}}]]}},
  AspectRatio->1,
  AutomaticImageSize->True,
  Axes->False,
  Boxed->False,
  ImageSize->{375.65581414188074`, 335.41222900291876`},
  ViewPoint->{3.1742623108502928`, -0.9516768195814318, 0.5180444121759553},
  ViewVertical->{-0.9508802733531099, 
   0.31174217174515545`, -0.03196507214331484}]], "Output",
 CellChangeTimes->{{3.5672656346247387`*^9, 3.5672656983196507`*^9}, {
   3.5672657762261877`*^9, 3.5672657918574147`*^9}, 3.584464231774043*^9, 
   3.584468833360325*^9, {3.5844693073983583`*^9, 3.584469377988482*^9}, 
   3.5844695710388207`*^9, 3.5844696455757523`*^9}]
}, Open  ]]
}, Open  ]],

Cell["", "Section"]
}, Open  ]]
},
WindowSize->{1109, 630},
WindowMargins->{{Automatic, 46}, {Automatic, 21}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 673, 13, 135, "Subtitle"],
Cell[1255, 37, 574, 11, 86, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1854, 52, 229, 6, 97, "Section"],
Cell[CellGroupData[{
Cell[2108, 62, 6008, 153, 632, "Input"],
Cell[CellGroupData[{
Cell[8141, 219, 1869, 38, 155, "Print"],
Cell[10013, 259, 964, 25, 50, "Print"],
Cell[10980, 286, 1090, 30, 84, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12131, 323, 106, 4, 97, "Section"],
Cell[CellGroupData[{
Cell[12262, 331, 6664, 157, 472, "Input"],
Cell[18929, 490, 14258, 289, 524, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33236, 785, 281, 5, 71, "Section"],
Cell[33520, 792, 225, 6, 62, "Text"],
Cell[CellGroupData[{
Cell[33770, 802, 5176, 132, 552, "Input"],
Cell[38949, 936, 987, 25, 46, "Print"],
Cell[39939, 963, 6117, 132, 350, "Output"]
}, Open  ]]
}, Open  ]],
Cell[46083, 1099, 19, 0, 70, "Section"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
