(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     42139,       1180]
NotebookOptionsPosition[     40580,       1122]
NotebookOutlinePosition[     40924,       1137]
CellTagsIndexPosition[     40881,       1134]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9},
 FontFamily->"Arial"],

Cell[TextData[{
 "\n",
 StyleBox["Pseudoinverse",
  FontWeight->"Bold"],
 "\nInput a matrix m dimension msize x nsize.\nCompute the pseudoinverve \
A^dagger = V.Sigma^dagger.U^T\nUse the pseudoinverse to find the least \
squares solution to an overdetermined linear system "
}], "Subsubtitle",
 CellChangeTimes->{{3.584650069201517*^9, 3.5846500726491227`*^9}, {
  3.584650157341672*^9, 3.5846501606644773`*^9}, {3.584651159893032*^9, 
  3.5846511626230373`*^9}, {3.5847151368294086`*^9, 3.584715145579421*^9}, {
  3.584715180039469*^9, 3.5847152385995507`*^9}, {3.5847154204698057`*^9, 
  3.584715449359846*^9}}],

Cell[CellGroupData[{

Cell["Input", "Section",
 CellChangeTimes->{{3.5846510751380835`*^9, 3.58465107869489*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Pick", " ", "an", " ", "input", " ", "matrix", " ", "and", " ", "load", 
    " ", "into", " ", "m", " ", "below"}], " ", "*)"}], "\[IndentingNewLine]",
   "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"m0", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "  ", 
   RowBox[{"(*", " ", 
    RowBox[{"shear", " ", "in", " ", "pla"}], " ", "*)"}], 
   "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"m1", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"3", "x2", " ", "example", " ", "in", " ", "pla"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.8"}], ",", " ", "0", ",", " ", "0.8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "1.5", ",", " ", 
         RowBox[{"-", "0.3"}]}], "}"}]}], "}"}]}], ";"}], "  ", 
   RowBox[{"(*", " ", 
    RowBox[{"2", "x3", " ", "example", " ", "in", " ", "pla"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"this", " ", "is", " ", "the", " ", "vv", " ", "from", " ", "2", 
     RowBox[{"x3", " ", "--"}], " ", "to", " ", "see", " ", "that", " ", "it",
      " ", "is", " ", "a", " ", "rotation"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m2v", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.6336240919231784`"}], ",", "0.38421179904749553`", 
         ",", "0.6714922215537678`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.7126647870884324`"}], ",", 
         RowBox[{"-", "0.6276244963818958`"}], ",", 
         RowBox[{"-", "0.31336303672509164`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.30104719128190993`", ",", 
         RowBox[{"-", "0.6771032306923801`"}], ",", "0.6714922215537679`"}], 
        "}"}]}], "}"}]}], ";"}], " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m2u", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.38491388955472267`", ",", 
         RowBox[{"-", "0.9229524893665191`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.9229524893665191`"}], ",", 
         RowBox[{"-", "0.38491388955472267`"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m4", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "4"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m5", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m6", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m7", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0.5"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m8", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m9", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m10", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m11", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m12", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Set", " ", "the", " ", "matrix", " ", "to", " ", "use"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m", " ", "=", " ", "m1"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Matrix", " ", 
     RowBox[{"dimensions", ":", " ", 
      RowBox[{"msize", " ", "x", " ", "nsize"}]}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"msize", ",", " ", "nsize"}], "}"}], " ", "=", " ", 
     RowBox[{"Dimensions", "[", "m", "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.5846510679776707`*^9, 3.584651096572521*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Get SVD", "Section",
 CellChangeTimes->{{3.584651106010538*^9, 3.584651110674946*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"SVD", " ", "of", " ", "m"}], " ", "=", " ", 
    RowBox[{"uu", ".", "sigma", ".", 
     RowBox[{"vv", "^", "T"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"uu", ",", "sigma", ",", "vv"}], "}"}], "=", 
     RowBox[{"SingularValueDecomposition", "[", "m", "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<m =   \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "m", "]"}], "//", "N"}], ",", 
      "\"\<  size mxn=\>\"", ",", "msize", ",", "\"\< x \>\"", ",", "nsize", 
      ",", "\"\<    rank=\>\"", ",", 
      RowBox[{"MatrixRank", "[", "m", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<uu =  \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "uu", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<vv =  \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "vv", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<sigma=\>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "sigma", "]"}], "//", "N"}]}], "]"}], 
    ";"}]}]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"m =   \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.`", "0.`"},
       {"0.`", "2.`"},
       {"0.`", "1.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"  size mxn=\"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" x \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\"    rank=\"\>", 
   "\[InvisibleSpace]", "2"}],
  SequenceForm["m =   ", 
   MatrixForm[{{1., 0.}, {0., 2.}, {0., 1.}}], "  size mxn=", 3, " x ", 2, 
   "    rank=", 2],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5847143129382553`*^9, 3.5847144326384225`*^9, 3.5847146077386675`*^9, {
   3.58471483110898*^9, 3.584714850859008*^9}, {3.584715063049305*^9, 
   3.5847150924593463`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"uu =  \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.`", "1.`", "0.`"},
       {"0.8944271909999159`", "0.`", 
        RowBox[{"-", "0.4472135954999579`"}]},
       {"0.4472135954999579`", "0.`", "0.8944271909999159`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["uu =  ", 
   MatrixForm[{{0., 1., 0.}, {0.8944271909999159, 0., -0.4472135954999579}, {
    0.4472135954999579, 0., 0.8944271909999159}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5847143129382553`*^9, 3.5847144326384225`*^9, 3.5847146077386675`*^9, {
   3.58471483110898*^9, 3.584714850859008*^9}, {3.584715063049305*^9, 
   3.5847150924593463`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vv =  \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.`", "1.`"},
       {"1.`", "0.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["vv =  ", 
   MatrixForm[{{0., 1.}, {1., 0.}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5847143129382553`*^9, 3.5847144326384225`*^9, 3.5847146077386675`*^9, {
   3.58471483110898*^9, 3.584714850859008*^9}, {3.584715063049305*^9, 
   3.584715092469346*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"sigma=\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2.23606797749979`", "0.`"},
       {"0.`", "1.`"},
       {"0.`", "0.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["sigma=", 
   MatrixForm[{{2.23606797749979, 0.}, {0., 1.}, {0., 0.}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5847143129382553`*^9, 3.5847144326384225`*^9, 3.5847146077386675`*^9, {
   3.58471483110898*^9, 3.584714850859008*^9}, {3.584715063049305*^9, 
   3.584715092469346*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

Pseudoinverse\
\>", "Section",
 CellChangeTimes->{{3.584651134511788*^9, 3.5846511406581984`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"size", " ", "nsize", " ", "x", " ", 
    RowBox[{"msize", " ", "--"}], " ", "copy", " ", "transpose", " ", "sigma",
     " ", "into", " ", "matrix", " ", "to", " ", "create"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"sigmadagger", " ", "=", "  ", 
     RowBox[{"Transpose", "[", "sigma", "]"}]}], ";"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"non", "-", 
     RowBox[{"zero", " ", "diagonal", " ", "elements", " ", 
      RowBox[{"1", "/", "sigma_ii"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"min", " ", "=", " ", 
     RowBox[{"Min", "[", 
      RowBox[{"msize", ",", " ", "nsize"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"sigmadagger", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "i"}], "]"}], "]"}], " ", "=", " ", 
       RowBox[{"1", "/", 
        RowBox[{"sigma", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "i"}], "]"}], "]"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "min"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Sigma = \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "sigma", "]"}], "//", "N"}], ",", 
      "\"\<  Sigma^{dagger} = \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "sigmadagger", "]"}], "//", "N"}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mdagger", " ", "=", " ", 
     RowBox[{"vv", ".", "sigmadagger", ".", 
      RowBox[{"Transpose", "[", "uu", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<m = \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "m", "]"}], "//", "N"}], ",", 
      "\"\<  m^dagger =\>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "mdagger", "]"}], "//", "N"}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Check", " ", "solution"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"check1", " ", "should", " ", "return", " ", "m"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"check1", " ", "=", " ", 
     RowBox[{"m", ".", "mdagger", ".", "m"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"check2", " ", "should", " ", "return", " ", "mdagger"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"check2", " ", "=", " ", 
     RowBox[{"mdagger", ".", "m", ".", "mdagger"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<check1: m.mdagger.m = m? =\>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "check1", "]"}], "//", "N"}], ",", 
      "\"\<    check2: mdagger.m.mdagger = mdagger? =\>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "check2", "]"}], "//", "N"}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"msize", " ", "\[Equal]", " ", "nsize"}], ",", 
      RowBox[{"(", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"mi", " ", "=", " ", 
         RowBox[{"Inverse", "[", "m", "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Print", "[", 
         RowBox[{"\"\<Square and nonsigular m has inverse m^{-1} = \>\"", ",", 
          RowBox[{
           RowBox[{"MatrixForm", "[", "mi", "]"}], "//", "N"}]}], "]"}]}], 
       ")"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.584650185452921*^9, 3.584650185686921*^9}, {
  3.584714384468355*^9, 3.584714422738409*^9}, {3.584714457258457*^9, 
  3.5847146430187173`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sigma = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2.23606797749979`", "0.`"},
       {"0.`", "1.`"},
       {"0.`", "0.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   "\[InvisibleSpace]", "\<\"  Sigma^{dagger} = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.4472135954999579`", "0.`", "0.`"},
       {"0.`", "1.`", "0.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Sigma = ", 
   MatrixForm[{{2.23606797749979, 0.}, {0., 1.}, {0., 0.}}], 
   "  Sigma^{dagger} = ", 
   MatrixForm[{{0.4472135954999579, 0., 0.}, {0., 1., 0.}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5847143129782553`*^9, 3.584714432678423*^9, 3.5847146077786674`*^9, {
   3.5847148311389804`*^9, 3.584714850889008*^9}, {3.584715063089305*^9, 
   3.5847150924993467`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"m = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.`", "0.`"},
       {"0.`", "2.`"},
       {"0.`", "1.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"  m^dagger =\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.`", "0.`", "0.`"},
       {"0.`", "0.4`", "0.2`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["m = ", 
   MatrixForm[{{1., 0.}, {0., 2.}, {0., 1.}}], "  m^dagger =", 
   MatrixForm[{{1., 0., 0.}, {0., 0.4, 0.2}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5847143129782553`*^9, 3.584714432678423*^9, 3.5847146077786674`*^9, {
   3.5847148311389804`*^9, 3.584714850889008*^9}, {3.584715063089305*^9, 
   3.5847150924993467`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"check1: m.mdagger.m = m? =\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.`", "0.`"},
       {"0.`", "2.`"},
       {"0.`", "1.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   "\[InvisibleSpace]", "\<\"    check2: mdagger.m.mdagger = mdagger? =\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.`", "0.`", "0.`"},
       {"0.`", "0.4`", "0.2`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["check1: m.mdagger.m = m? =", 
   MatrixForm[{{1., 0.}, {0., 2.}, {0., 1.}}], 
   "    check2: mdagger.m.mdagger = mdagger? =", 
   MatrixForm[{{1., 0., 0.}, {0., 0.4, 0.2}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5847143129782553`*^9, 3.584714432678423*^9, 3.5847146077786674`*^9, {
   3.5847148311389804`*^9, 3.584714850889008*^9}, {3.584715063089305*^9, 
   3.5847150924993467`*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Find the least squares solution to an overdetermined system: m.x = b using \
the pseudoinverse
\
\>", "Section",
 CellChangeTimes->{{3.5847146546687336`*^9, 3.5847146701187553`*^9}, {
  3.5847153016596394`*^9, 3.5847153099396505`*^9}, {3.5847153793097477`*^9, 
  3.584715404199783*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"m", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"30", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"40", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"50", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"60", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
      "30", ",", "25", ",", "40", ",", "40", ",", "30", ",", "5", ",", "25"}],
       "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"SVD", " ", "of", " ", "m"}], " ", "=", " ", 
     RowBox[{"uu", ".", "sigma", ".", 
      RowBox[{"vv", "^", "T"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"uu", ",", "sigma", ",", "vv"}], "}"}], "=", 
     RowBox[{"SingularValueDecomposition", "[", "m", "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<m =   \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "m", "]"}], "//", "N"}], ",", 
      "\"\<  size mxn=\>\"", ",", "msize", ",", "\"\< x \>\"", ",", "nsize", 
      ",", "\"\<    rank=\>\"", ",", 
      RowBox[{"MatrixRank", "[", "m", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<uu =  \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "uu", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<vv =  \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "vv", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<sigma=\>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "sigma", "]"}], "//", "N"}]}], "]"}], ";"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"size", " ", "nsize", " ", "x", " ", 
     RowBox[{"msize", " ", "--"}], " ", "copy", " ", "transpose", " ", 
     "sigma", " ", "into", " ", "matrix", " ", "to", " ", "create"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sigmadagger", " ", "=", "  ", 
     RowBox[{"Transpose", "[", "sigma", "]"}]}], ";"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"non", "-", 
     RowBox[{"zero", " ", "diagonal", " ", "elements", " ", 
      RowBox[{"1", "/", "sigma_ii"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"min", " ", "=", " ", 
     RowBox[{"Min", "[", 
      RowBox[{"msize", ",", " ", "nsize"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"sigmadagger", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "i"}], "]"}], "]"}], " ", "=", " ", 
       RowBox[{"1", "/", 
        RowBox[{"sigma", "[", 
         RowBox[{"[", 
          RowBox[{"i", ",", "i"}], "]"}], "]"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "min"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Sigma^{dagger} = \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "sigmadagger", "]"}], "//", "N"}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"z", " ", "=", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"Transpose", "[", "uu", "]"}], ".", "b"}], " ", "//", "N"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"y", " ", "=", " ", 
     RowBox[{
      RowBox[{"sigmadagger", ".", "z"}], " ", "//", "N"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", " ", "=", " ", 
     RowBox[{
      RowBox[{"vv", ".", "y"}], " ", "//", "N"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<z = U^T.b = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "z", "]"}], ",", 
      "\"\<   y = SigmaDagger.z = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "y", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<LSQ solution x = V.y = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "x", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.584714672738759*^9, 3.5847146793087683`*^9}, {
  3.584714728228836*^9, 3.5847148439689984`*^9}, {3.584714890789064*^9, 
  3.5847150890693417`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"m =   \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.`", "1.`"},
       {"10.`", "1.`"},
       {"20.`", "1.`"},
       {"30.`", "1.`"},
       {"40.`", "1.`"},
       {"50.`", "1.`"},
       {"60.`", "1.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"  size mxn=\"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" x \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\"    rank=\"\>", 
   "\[InvisibleSpace]", "2"}],
  SequenceForm["m =   ", 
   MatrixForm[{{0., 1.}, {10., 1.}, {20., 1.}, {30., 1.}, {40., 1.}, {50., 
    1.}, {60., 1.}}], "  size mxn=", 3, " x ", 2, "    rank=", 2],
  Editable->False]], "Print",
 CellChangeTimes->{{3.584714831308981*^9, 3.5847148532490115`*^9}, {
  3.584715063129305*^9, 3.5847150925293465`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"uu =  \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.00024184028930494066`", "0.6813851009517223`", 
        "0.6350006350009525`", 
        RowBox[{"-", "0.024906774069335894`"}], 
        RowBox[{"-", "0.11859297582504699`"}], 
        RowBox[{"-", "0.2042471087466174`"}], 
        RowBox[{"-", "0.27583864218368526`"}]},
       {"0.10501450806126876`", "0.524105179149124`", 
        RowBox[{"-", "0.7620007620011431`"}], 
        RowBox[{"-", "0.12453387034667947`"}], 
        RowBox[{"-", "0.15247668320363186`"}], 
        RowBox[{"-", "0.1974388717883968`"}], 
        RowBox[{"-", "0.23643312187173018`"}]},
       {"0.2097871758332326`", "0.3668252573465259`", "0.`", "0.`", "0.`", 
        "0.`", "0.9063269671749657`"},
       {"0.31455984360519645`", "0.2095453355439276`", "0.`", "0.`", "0.`", 
        "0.9123037524015577`", 
        RowBox[{"-", "0.15762208124782012`"}]},
       {"0.4193325113771602`", "0.05226541374132942`", "0.`", "0.`", 
        "0.8809763918432063`", 
        RowBox[{"-", "0.17701416091373506`"}], 
        RowBox[{"-", "0.11821656093586509`"}]},
       {"0.524105179149124`", 
        RowBox[{"-", "0.10501450806126869`"}], "0.`", "0.7721099961494128`", 
        RowBox[{"-", "0.28801151271797126`"}], 
        RowBox[{"-", "0.17020592395551448`"}], 
        RowBox[{"-", "0.07881104062391006`"}]},
       {"0.628877846921088`", 
        RowBox[{"-", "0.26229442986386714`"}], "0.1270001270001905`", 
        RowBox[{"-", "0.6226693517333973`"}], 
        RowBox[{"-", "0.32189522009655613`"}], 
        RowBox[{"-", "0.1633976869972939`"}], 
        RowBox[{"-", "0.03940552031195503`"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["uu =  ", 
   MatrixForm[CompressedData["
1:eJxTTMoPSmViYGBgh+LXc/xdLmzStz9oPknhxdmn9jLTOG69CXxiP7HeL0Cz
ceb+OqMtP6Rj9u2vctF/d0Tl1P5PO0/KhS+/uH9+1y5R60e77Pc0NVtWHH1g
v8eXK8c/6cX+UvmkJcUP9+/X7XsoH91yeP8MjaU+a11P7q9cI3C8wPnc/h1l
KxP9bp2yL5z9colA1XV7BgJg/q/8zIUMb+0Fr1jN2a94xf580oy1iZdO4dQn
uGzS4umGb+2XyXLf+qpzZP+RNwvYI67dsv9vVebacWgVhj6Oig9pXw3e2H+6
wpaRtuIY1J379sP8NQviz/0w9VO5z7AqbH1h/3HD/2vH8y7tF9hZc8zv5NH9
EPu27BfvN8s/Iv/EfjNPz+S8kxf2195j8+hyPGC/Mniv24s3j/dnZB/OeDfz
yn69uZ9UzF8dgepbsh8A/FWqKw==
    "]]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.584714831308981*^9, 3.5847148532490115`*^9}, {
  3.584715063129305*^9, 3.5847150925393467`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vv =  \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.9997337081918022`", 
        RowBox[{"-", "0.023076236804738838`"}]},
       {"0.02307623680473883`", "0.9997337081918023`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["vv =  ", 
   MatrixForm[{{0.9997337081918022, -0.023076236804738838`}, {
    0.02307623680473883, 0.9997337081918023}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.584714831308981*^9, 3.5847148532490115`*^9}, {
  3.584715063129305*^9, 3.5847150925493464`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"sigma=\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"95.41932351743758`", "0.`"},
       {"0.`", "1.4672080542932737`"},
       {"0.`", "0.`"},
       {"0.`", "0.`"},
       {"0.`", "0.`"},
       {"0.`", "0.`"},
       {"0.`", "0.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["sigma=", 
   MatrixForm[{{95.41932351743758, 0.}, {0., 1.4672080542932737`}, {0., 0.}, {
    0., 0.}, {0., 0.}, {0., 0.}, {0., 0.}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.584714831308981*^9, 3.5847148532490115`*^9}, {
  3.584715063129305*^9, 3.5847150925493464`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sigma^{dagger} = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.01048005753066624`", "0.`", "0.`", "0.`", "0.`", "0.`", "0.`"},
       {"0.`", "0.6815665965531256`", "0.`", "0.`", "0.`", "0.`", "0.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Sigma^{dagger} = ", 
   MatrixForm[{{0.01048005753066624, 0., 0., 0., 0., 0., 0.}, {0., 
    0.6815665965531256, 0., 0., 0., 0., 0.}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.584714831308981*^9, 3.5847148532490115`*^9}, {
  3.584715063129305*^9, 3.5847150925493464`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"z = U^T.b = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"54.52894609783566`"},
        {"51.08453534823478`"},
        {"3.1750031750047625`"},
        {
         RowBox[{"-", "15.566733793334937`"}]},
        {"9.572147334450225`"},
        {"15.182368416831896`"},
        {"10.836518085787628`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   "\[InvisibleSpace]", "\<\"   y = SigmaDagger.z = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"0.571466492191916`"},
        {"34.817512893794216`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["z = U^T.b = ", 
   MatrixForm[{54.52894609783566, 51.08453534823478, 
    3.1750031750047625`, -15.566733793334937`, 9.572147334450225, 
    15.182368416831896`, 10.836518085787628`}], "   y = SigmaDagger.z = ", 
   MatrixForm[{0.571466492191916, 34.817512893794216`}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.584714831308981*^9, 3.5847148532490115`*^9}, {
  3.584715063129305*^9, 3.5847150925493464`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"LSQ solution x = V.y = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         RowBox[{"-", "0.23214285714285732`"}]},
        {"34.82142857142858`"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["LSQ solution x = V.y = ", 
   MatrixForm[{-0.23214285714285732`, 34.82142857142858}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.584714831308981*^9, 3.5847148532490115`*^9}, {
  3.584715063129305*^9, 3.5847150925493464`*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1014, 630},
WindowMargins->{{Automatic, 32}, {41, Automatic}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 691, 12, 107, "Subtitle"],
Cell[1273, 36, 613, 12, 105, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1911, 52, 91, 1, 71, "Section"],
Cell[2005, 55, 6711, 198, 612, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8753, 258, 92, 1, 71, "Section"],
Cell[CellGroupData[{
Cell[8870, 263, 1400, 40, 152, "Input"],
Cell[CellGroupData[{
Cell[10295, 307, 1271, 31, 50, "Print"],
Cell[11569, 340, 1202, 29, 50, "Print"],
Cell[12774, 371, 976, 26, 36, "Print"],
Cell[13753, 399, 1037, 27, 50, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14851, 433, 109, 4, 97, "Section"],
Cell[CellGroupData[{
Cell[14985, 441, 3908, 97, 512, "Input"],
Cell[CellGroupData[{
Cell[18918, 542, 1844, 47, 50, "Print"],
Cell[20765, 591, 1762, 46, 50, "Print"],
Cell[22530, 639, 1874, 48, 50, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24465, 694, 296, 7, 97, "Section"],
Cell[CellGroupData[{
Cell[24786, 705, 4940, 135, 612, "Input"],
Cell[CellGroupData[{
Cell[29751, 844, 1339, 33, 110, "Print"],
Cell[31093, 879, 2907, 63, 110, "Print"],
Cell[34003, 944, 1066, 26, 36, "Print"],
Cell[35072, 972, 1134, 30, 110, "Print"],
Cell[36209, 1004, 1104, 25, 36, "Print"],
Cell[37316, 1031, 2153, 56, 110, "Print"],
Cell[39472, 1089, 1056, 27, 36, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
