(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    215954,       4260]
NotebookOptionsPosition[    214057,       4194]
NotebookOutlinePosition[    214400,       4209]
CellTagsIndexPosition[    214357,       4206]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 "\n"
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
  3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
  3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
  3.5842134956497355`*^9, 3.5842135862546945`*^9}},
 FontFamily->"Arial"],

Cell[TextData[{
 "\n",
 StyleBox["Quadratic Forms",
  FontWeight->"Bold"],
 "\nInput a 2x2 matrix A and form positive definite matrix M=A^TA\n\nPlot the \
quadratic form, z=1 plane, and the ellipse in the z=1 plane. \nThis ellipse \
has major and minor axis 1/sqrt(lambda_2) and 1/sqrt(lambda_1), resp.\n\nPlot \
the action of the matrix action ellipse with the major and minor axes.\nThese \
axes are the eigenvectors scaled by the eigenvalues.\n\nSee nb QuadraticForm2 \
for more info on quadratic forms, symmetric, positive def matrices."
}], "Subsubtitle",
 CellChangeTimes->{{3.562962338225586*^9, 3.562962378723257*^9}, {
  3.563126295812194*^9, 3.5631262964227037`*^9}, {3.5844702933512897`*^9, 
  3.5844703044585094`*^9}, {3.5844703986670747`*^9, 3.5844704207903137`*^9}, {
  3.58447152321305*^9, 3.584471677840522*^9}, {3.5844717087129755`*^9, 
  3.5844717108969793`*^9}}],

Cell[CellGroupData[{

Cell["\<\

Quadratic Form Routine\
\>", "Section",
 CellChangeTimes->{{3.5844703210881386`*^9, 3.584470334550962*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "matrix", " ", "must", " ", "be", " ", "a", " ", "2", "x2", " ", 
    "matrix"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"quadform", "[", 
      RowBox[{"matrix_", ",", "x_", ",", "y_"}], "]"}], " ", ":=", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ".", "matrix", ".", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]}]}], " ", ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5579492297547054`*^9, 3.5579492485059385`*^9}, {
   3.557949284604402*^9, 3.5579493679865484`*^9}, {3.5579494026186094`*^9, 
   3.557949529337632*^9}, {3.557949698441929*^9, 3.5579497110311513`*^9}, {
   3.5580126605847435`*^9, 3.5580126671559544`*^9}, {3.558019931475663*^9, 
   3.558019950320496*^9}, {3.558020368153619*^9, 3.5580203776280355`*^9}, {
   3.5580268663285685`*^9, 3.5580269109758472`*^9}, {3.558027595584237*^9, 
   3.5580276247094884`*^9}, {3.5625927074201603`*^9, 3.562592718430176*^9}, {
   3.5629623893780756`*^9, 3.5629623946196847`*^9}, {3.5630183737894073`*^9, 
   3.563018374903471*^9}, 3.5630184329657555`*^9, {3.5630184634554954`*^9, 
   3.5630184934889884`*^9}, {3.5634038976690164`*^9, 3.563403997228391*^9}, {
   3.563451145633128*^9, 3.563451160219154*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

Initialize for output\
\>", "Section",
 CellChangeTimes->{{3.5844703387941694`*^9, 3.5844703483413863`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Graphics", ",", 
    RowBox[{"BaseStyle", "->", 
     RowBox[{"{", 
      RowBox[{"FontFamily", "->", "\"\<Helvetica\>\""}], "}"}]}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Graphics3D", ",", 
    RowBox[{"BaseStyle", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontFamily", "->", "\"\<Helvetica\>\""}], ",", " ", 
       RowBox[{"FontSize", "\[Rule]", "14"}]}], "}"}]}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Plot3D", ",", 
    RowBox[{"BaseStyle", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"FontFamily", "->", "\"\<Helvetica\>\""}], ",", " ", 
       RowBox[{"FontSize", "\[Rule]", "14"}]}], "}"}]}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.5629609063614707`*^9, 3.5629609408063316`*^9}, {
  3.5634553769774933`*^9, 3.5634553944943223`*^9}, {3.563455802999426*^9, 
  3.56345586246673*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Create positive definite matrix M = A^TA \
\>", "Section",
 CellChangeTimes->{{3.558012681715579*^9, 3.5580127045312166`*^9}, {
  3.5580273059597316`*^9, 3.5580273095633383`*^9}, {3.558027394168686*^9, 
  3.55802739672709*^9}, {3.562962413854519*^9, 3.5629624426209693`*^9}, {
  3.563127294386272*^9, 3.5631273041986895`*^9}, {3.584470377794238*^9, 
  3.5844703878562555`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Pick", " ", "an", " ", "input", " ", "matrix", " ", "A"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"A1", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", " ", "0.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A2", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", " ", "=", " ", "A1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Form", " ", "a", " ", "pos", " ", "def", " ", "matrix", " ", "M"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"M", " ", "=", " ", 
     RowBox[{
      RowBox[{"Transpose", "[", "A", "]"}], ".", "A"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.557949581519724*^9, 3.557949799873307*^9}, 
   3.557949971333208*^9, {3.5579501281758833`*^9, 3.5579502312920647`*^9}, {
   3.5580127316624627`*^9, 3.5580128244570208`*^9}, {3.5580128584574785`*^9, 
   3.558012889298331*^9}, {3.5580203415075727`*^9, 3.5580203504775887`*^9}, {
   3.558026838108119*^9, 3.558026856859352*^9}, {3.558027348282606*^9, 
   3.5580273665502377`*^9}, {3.558027444017972*^9, 3.5580274518335857`*^9}, {
   3.562605759388289*^9, 3.562605772383112*^9}, {3.562956113885852*^9, 
   3.5629561186438603`*^9}, {3.5629570091246243`*^9, 3.562957043803486*^9}, {
   3.562962465319009*^9, 3.562962469421816*^9}, 3.5629717020698113`*^9, 
   3.5629717609131145`*^9, 3.563018203571597*^9, {3.5630182342037*^9, 
   3.563018271345617*^9}, {3.5631305346609216`*^9, 3.563130555408958*^9}, {
   3.563130587888215*^9, 3.563130601507039*^9}, {3.563131156478014*^9, 
   3.5631311633420258`*^9}, 3.5631311939960794`*^9, {3.563131225383335*^9, 
   3.563131229704542*^9}, {3.5634025076441746`*^9, 3.563402532791419*^9}, {
   3.5634498758688984`*^9, 3.5634498790825043`*^9}, {3.56344992798859*^9, 
   3.5634499340726004`*^9}, 3.5634505251732388`*^9, 3.563450748534431*^9, {
   3.563451029444124*^9, 3.563451030317726*^9}, 3.5634512448805027`*^9, 
   3.563451275284956*^9, {3.563454338606902*^9, 3.563454341394107*^9}, {
   3.5634544130458317`*^9, 3.5634544728223314`*^9}, 3.5634736159587393`*^9, 
   3.5634736549432077`*^9, {3.5634883777354093`*^9, 3.5634883800442133`*^9}, {
   3.563488493050812*^9, 3.563488512972047*^9}, {3.563488549288911*^9, 
   3.563488553532118*^9}, {3.5638942982900195`*^9, 3.5638943312372775`*^9}, {
   3.567105915556183*^9, 3.567105915656183*^9}, {3.5844704332859354`*^9, 
   3.5844704564207764`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Find decomposition of M and extract information wanted for visualization\
\>", "Section",
 CellChangeTimes->{{3.558012896554343*^9, 3.5580129159615765`*^9}, {
  3.562962489623852*^9, 3.562962494927861*^9}, {3.563127314494707*^9, 
  3.56312731588311*^9}, {3.5634881520030127`*^9, 3.5634881882886763`*^9}, {
  3.5844704837988243`*^9, 3.584470510490471*^9}, {3.5844705501457405`*^9, 
  3.5844705697861753`*^9}}],

Cell["\<\
Find SVD and eigen things
SVD = Eigendecomposition (R.Lambda.R^T) for positive definite matrices\
\>", "Text",
 CellChangeTimes->{{3.584470491598838*^9, 3.5844705283369026`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", ",", "sigma", ",", "v"}], "}"}], " ", "=", " ", 
     RowBox[{"SingularValueDecomposition", "[", "M", "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<SVD(M) => U=\>\"", ",", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "u", "]"}], "//", "N"}], ",", 
     "\"\<  Sigma=\>\"", ",", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "sigma", "]"}], "//", "N"}], ",", 
     "\"\<  V=\>\"", ",", 
     RowBox[{
      RowBox[{"MatrixForm", "[", "v", "]"}], "//", "N"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Check SVD: M= ULU^T = \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", 
        RowBox[{"u", ".", "sigma", ".", 
         RowBox[{"Transpose", "[", "v", "]"}]}], "]"}], "//", "N"}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"evals", " ", "=", " ", 
     RowBox[{"Eigenvalues", "[", "M", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lambda", " ", "=", " ", 
     RowBox[{"DiagonalMatrix", "[", "evals", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"evecs", " ", "=", " ", 
     RowBox[{"Eigenvectors", "[", "M", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Normalize", " ", "eigenvectors"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"evecs", "[", 
        RowBox[{"[", "i", "]"}], "]"}], " ", "=", " ", 
       RowBox[{
        RowBox[{"evecs", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "/", 
        RowBox[{"Norm", "[", 
         RowBox[{"evecs", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "]"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "2"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Evals = \>\"", ",", 
      RowBox[{"evals", "//", "N"}], ",", "\"\< as matrix = \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "lambda", "]"}], "//", "N"}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Evecs (rows) = \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "evecs", "]"}], "//", "N"}]}], "]"}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "evecs", " ", "returned", " ", "in", " ", "transpose", " ", "form"}], 
     ",", " ", 
     RowBox[{
     "so", " ", "that", " ", "refleced", " ", "in", " ", "R", " ", "and", " ", 
      RowBox[{"R", "^", "T"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Check decomposition: m = R.Lambda.R^T = \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", 
        RowBox[{
         RowBox[{"Transpose", "[", "evecs", "]"}], ".", "lambda", ".", 
         "evecs"}], "]"}], "//", "N"}]}], "]"}], ";"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"===", "===", "===", "===", "===", " ", 
      RowBox[{"Action", " ", "Ellipse"}], " ", "===", "===", "===", "===", "===",
       "===", "===", "===", "===", "===", "===", "===", "==="}], "="}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "ellipse", " ", "from", " ", "eigenvectors", " ", "and", 
     " ", "eigenvalues"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "create", " ", "major", " ", "and", " ", "minor", " ", "axis", " ", "in", 
     " ", "2", "d", " ", "and", " ", "3", "d"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"major2d", " ", "=", " ", 
     RowBox[{
      RowBox[{"sigma", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], "*", 
      RowBox[{"evecs", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"major3d", " ", "=", " ", 
     RowBox[{
      RowBox[{"sigma", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], "*", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"evecs", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
        RowBox[{"evecs", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", "0"}], "}"}]}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"minor2d", " ", "=", " ", 
     RowBox[{
      RowBox[{"sigma", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "2"}], "]"}], "]"}], "*", 
      RowBox[{"evecs", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"minor3d", " ", "=", " ", 
     RowBox[{
      RowBox[{"sigma", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "2"}], "]"}], "]"}], "*", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"evecs", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "1"}], "]"}], "]"}], ",", 
        RowBox[{"evecs", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "2"}], "]"}], "]"}], ",", "0"}], "}"}]}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<major=\>\"", ",", 
     RowBox[{"major2d", "//", "N"}], ",", "\"\<  minor=\>\"", ",", 
     RowBox[{"minor2d", "//", "N"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "create", " ", "ellipse", " ", "with", " ", "major", " ", "axis", " ", 
     "on", " ", "x", " ", "axis"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ellipsedata", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"sigma", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "1"}], "]"}], "]"}], "*", 
          RowBox[{"Cos", "[", "alpha", "]"}]}], ",", 
         RowBox[{
          RowBox[{"sigma", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "2"}], "]"}], "]"}], "*", 
          RowBox[{"Sin", "[", "alpha", "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"alpha", ",", "0", ",", 
         RowBox[{"2", "*", "Pi"}], ",", "0.1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"numedata", " ", "=", " ", 
     RowBox[{"Length", "[", "ellipsedata", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "want", " ", "xhat", " ", "on", " ", "ellipse", " ", "from", " ", "x", 
      " ", "in", " ", "standard", " ", 
      RowBox[{"position", ":", " ", "xhat"}]}], "  ", "=", " ", 
     RowBox[{"R", ".", "x"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Since", " ", "ellipse", " ", "data", " ", "row", " ", "by", " ", 
      "row"}], ",", " ", 
     RowBox[{"use", " ", 
      RowBox[{
       RowBox[{"x", "^", "T"}], ".", 
       RowBox[{"R", "^", "T"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Eigenvectors", " ", "are", " ", "in", " ", "row", " ", "format"}], ",", 
     " ", 
     RowBox[{"so", " ", "switch", " ", "that", " ", 
      RowBox[{"too", " ", "--"}], " ", "dont", " ", "use", " ", "T"}]}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ellipsedata", " ", "=", " ", 
     RowBox[{"ellipsedata", ".", "evecs"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ellipse3d", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ellipsedata", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
         RowBox[{"ellipsedata", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numedata"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "===", "===", "===", "===", "===", "===", "===", "===", "===", "===", "===",
       "===", "===", "===", "===", "===", "===", "==="}], "="}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "ellipse", " ", "that", " ", "is", " ", "a", " ", "contour", " ", "at", 
      " ", "z"}], "=", 
     RowBox[{"1", " ", "on", " ", "quadratic", " ", "form"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"lambda", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1"}], "]"}], "]"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"lambda", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "2"}], "]"}], "]"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
     "\"\<z=1 contour ellipse: ax_1^2 + bx_2^2 = 1 where  a=\>\"", ",", "a", 
      ",", "\"\<  b=\>\"", ",", "b"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qformellipsedata", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a", "*", 
          RowBox[{"Cos", "[", "alpha", "]"}]}], ",", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", "alpha", "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"alpha", ",", "0", ",", 
         RowBox[{"2", "*", "Pi"}], ",", "0.1"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qformnumedata", " ", "=", " ", 
     RowBox[{"Length", "[", "qformellipsedata", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "want", " ", "xhat", " ", "on", " ", "ellipse", " ", "from", " ", "x", 
      " ", "in", " ", "standard", " ", 
      RowBox[{"position", ":", " ", "xhat"}]}], "  ", "=", " ", 
     RowBox[{"R", ".", "x"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Since", " ", "ellipse", " ", "data", " ", "row", " ", "by", " ", 
      "row"}], ",", " ", 
     RowBox[{"use", " ", 
      RowBox[{
       RowBox[{"x", "^", "T"}], ".", 
       RowBox[{"R", "^", "T"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Eigenvectors", " ", "are", " ", "in", " ", "row", " ", "format"}], ",", 
     " ", 
     RowBox[{"so", " ", "switch", " ", "that", " ", 
      RowBox[{"too", " ", "--"}], " ", "dont", " ", "use", " ", "T"}]}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qformellipseunrotated", " ", "=", " ", "qformellipsedata"}], 
    ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"saved", " ", "to", " ", "look", " ", "at"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qformellipsedata", " ", "=", " ", 
     RowBox[{"qformellipsedata", ".", "evecs"}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qformellipse3d", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"qformellipsedata", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
         RowBox[{"qformellipsedata", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", "1"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "qformnumedata"}], "}"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Select", " ", "number", " ", "of", " ", "unit", " ", "vectors", " ", 
     "to", " ", "project", " ", "onto"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"numu", " ", "=", " ", "100"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"origin", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"e1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"e2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"degrees", " ", "=", " ", 
     RowBox[{"360", "/", "numu"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"units", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"RotationMatrix", "[", 
         RowBox[{"degrees", "*", 
          RowBox[{"(", 
           RowBox[{"i", "-", "1"}], ")"}], " ", "Degree"}], "]"}], ".", 
        "e1"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numu"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Multiply", " ", "each", " ", "unit", " ", "vector", " ", "times", " ", 
     "matrix", " ", "m"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mu", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"M", ".", 
        RowBox[{"units", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numu"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{
  3.558012921577586*^9, {3.5580129992225194`*^9, 3.55801311946832*^9}, {
   3.5580138701712303`*^9, 3.558013912257703*^9}, {3.558015124609336*^9, 
   3.558015133922552*^9}, {3.558015188328246*^9, 3.558015285505615*^9}, {
   3.558015591553745*^9, 3.5580156294482107`*^9}, {3.55801573258399*^9, 
   3.5580157631928415`*^9}, {3.558015804305313*^9, 3.558015852948198*^9}, {
   3.558018802370921*^9, 3.558018937598756*^9}, {3.5580189838480344`*^9, 
   3.558019007967676*^9}, {3.558019141029504*^9, 3.5580191414195046`*^9}, {
   3.558019174341962*^9, 3.558019215571233*^9}, {3.5580192615865126`*^9, 
   3.558019298308977*^9}, {3.558019328467428*^9, 3.5580194250967965`*^9}, {
   3.5580194698204737`*^9, 3.5580194970289207`*^9}, {3.558019579289462*^9, 
   3.5580196020675015`*^9}, {3.558027518055702*^9, 3.5580275471773524`*^9}, {
   3.558027740108889*^9, 3.558027742480093*^9}, {3.558027815605017*^9, 
   3.558027878706327*^9}, 3.558029330979233*^9, {3.558031470155314*^9, 
   3.558031494674556*^9}, {3.5625932228077493`*^9, 3.562593228929358*^9}, {
   3.5625933071938777`*^9, 3.562593310739883*^9}, {3.562593590514715*^9, 
   3.562593598796728*^9}, {3.562594005221675*^9, 3.5625940080296793`*^9}, {
   3.562594164903555*^9, 3.56259416799236*^9}, {3.562594280452958*^9, 
   3.5625943217618303`*^9}, {3.5625945375882096`*^9, 
   3.5625945381186104`*^9}, {3.5626057791379237`*^9, 3.5626058275784087`*^9}, 
   3.56260611296531*^9, {3.562606874939704*^9, 3.56260690671696*^9}, 
   3.562938400773972*^9, {3.5629384334872293`*^9, 3.562938435484033*^9}, {
   3.5629411083771276`*^9, 3.562941135926776*^9}, {3.5629564927481174`*^9, 
   3.5629566042415133`*^9}, {3.5629566620084147`*^9, 3.5629567394781513`*^9}, 
   3.562956770818606*^9, {3.5629568786615953`*^9, 3.56295689841123*^9}, 
   3.5629627516263123`*^9, {3.562962820219632*^9, 3.5629628710757217`*^9}, {
   3.562962911136592*^9, 3.5629629119945936`*^9}, {3.5629631583502264`*^9, 
   3.562963171189049*^9}, {3.5629632546335955`*^9, 3.562963254742796*^9}, {
   3.5629634903188095`*^9, 3.562963491223611*^9}, {3.562963564075739*^9, 
   3.5629635649181404`*^9}, 3.5629636196898365`*^9, {3.562963662699112*^9, 
   3.5629636663183184`*^9}, {3.5629637353172398`*^9, 3.56296373556684*^9}, {
   3.562963848308238*^9, 3.562963878385091*^9}, {3.562971715392235*^9, 
   3.562971740601879*^9}, {3.562971895962552*^9, 3.5629719612018666`*^9}, {
   3.563017262626853*^9, 3.563017293215087*^9}, {3.56312734447796*^9, 
   3.563127400762859*^9}, 3.563131298079462*^9, {3.563401853722226*^9, 
   3.5634018794622717`*^9}, {3.56340194677639*^9, 3.563401954904004*^9}, {
   3.563402011188903*^9, 3.563402109515876*^9}, {3.563402381907954*^9, 
   3.563402387570764*^9}, {3.5634033414032393`*^9, 3.5634033647876806`*^9}, {
   3.5634041697178946`*^9, 3.5634043265761695`*^9}, {3.5634044128131213`*^9, 
   3.5634044414235716`*^9}, {3.563449770287913*^9, 3.563449779647929*^9}, {
   3.5634498252936096`*^9, 3.5634498292248163`*^9}, {3.563450434318679*^9, 
   3.563450437345084*^9}, {3.5634505608037014`*^9, 3.5634505628785048`*^9}, 
   3.563450626011816*^9, {3.5634506612366776`*^9, 3.5634506726870975`*^9}, 
   3.5634508655346365`*^9, 3.563451088739828*^9, 3.5634538619094744`*^9, 
   3.563453934746002*^9, {3.5634542642415757`*^9, 3.563454279811202*^9}, {
   3.563475536216113*^9, 3.563475576776184*^9}, {3.5634756466331067`*^9, 
   3.563475702028804*^9}, {3.5634882014706993`*^9, 3.563488227959546*^9}, {
   3.5634882730436254`*^9, 3.5634882865844493`*^9}, {3.5648506213299313`*^9, 
   3.56485062621274*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SVD(M) => U=\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "0.9509826718461248`"}], 
        RowBox[{"-", "0.30924417189076625`"}]},
       {
        RowBox[{"-", "0.30924417189076625`"}], "0.9509826718461248`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"  Sigma=\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"4.325183813591931`", "0.`"},
       {"0.`", "0.9248161864080695`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"  V=\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "0.950982671846125`"}], 
        RowBox[{"-", "0.3092441718907662`"}]},
       {
        RowBox[{"-", "0.3092441718907662`"}], "0.950982671846125`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["SVD(M) => U=", 
   MatrixForm[{{-0.9509826718461248, -0.30924417189076625`}, \
{-0.30924417189076625`, 0.9509826718461248}}], "  Sigma=", 
   MatrixForm[{{4.325183813591931, 0.}, {0., 0.9248161864080695}}], "  V=", 
   MatrixForm[{{-0.950982671846125, -0.3092441718907662}, \
{-0.3092441718907662, 0.950982671846125}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.562962327492767*^9, {3.562963239049168*^9, 3.562963258705202*^9}, 
   3.562963569878949*^9, 3.5629636234182434`*^9, {3.5629637164256067`*^9, 
   3.5629637404964485`*^9}, 3.5629638383866205`*^9, {3.5629638906155124`*^9, 
   3.5629639198187637`*^9}, 3.5629714510965705`*^9, {3.562971508863472*^9, 
   3.5629715325287137`*^9}, 3.5629715639003687`*^9, 3.5629716552073293`*^9, 
   3.5629717068902197`*^9, 3.562971766248324*^9, 3.562971824046426*^9, {
   3.562971926211005*^9, 3.562971964353072*^9}, 3.563017127907094*^9, 
   3.5630172641359315`*^9, 3.5630173330075383`*^9, 3.563017881057996*^9, 
   3.5630179964426584`*^9, {3.5630182117726355`*^9, 3.5630182749487715`*^9}, 
   3.563018378694688*^9, 3.563018436978981*^9, {3.5630184681535463`*^9, 
   3.563018512205042*^9}, {3.5630204386916666`*^9, 3.563020454307294*^9}, 
   3.563020493541363*^9, 3.5630233528839097`*^9, 3.563023386845169*^9, 
   3.563023475624925*^9, 3.5630465147084837`*^9, 3.563106682008746*^9, 
   3.5631304963316545`*^9, 3.5631305635209723`*^9, 3.5631306095098534`*^9, 
   3.563130678305974*^9, 3.5631310314437943`*^9, 3.5631310942183046`*^9, {
   3.563131170284038*^9, 3.563131197116085*^9}, 3.5631312339165497`*^9, 
   3.5631313008094673`*^9, 3.563131338701934*^9, 3.5631317297010207`*^9, 
   3.5631318828776894`*^9, 3.563402198545232*^9, 3.563402391486371*^9, {
   3.5634025115909815`*^9, 3.5634025365510254`*^9}, {3.56340337046609*^9, 
   3.56340339879574*^9}, 3.5634037025126734`*^9, 3.5634041006877728`*^9, 
   3.563404333689782*^9, 3.563404449363985*^9, 3.5634497855915394`*^9, 
   3.5634498402384357`*^9, 3.56344988253011*^9, 3.5634499386902084`*^9, 
   3.56345044032469*^9, {3.5634505069368067`*^9, 3.5634505313820496`*^9}, 
   3.563450574406925*^9, 3.5634506311130247`*^9, 3.563450675791503*^9, 
   3.563450752964839*^9, 3.563450869169443*^9, 3.56345095297279*^9, 
   3.5634510333441315`*^9, 3.5634511199866834`*^9, 3.5634511660691643`*^9, {
   3.5634512482345085`*^9, 3.563451278217761*^9}, 3.5634538651230803`*^9, 
   3.5634539380844083`*^9, 3.56345413809256*^9, {3.5634542850216117`*^9, 
   3.5634543119856577`*^9}, 3.563454344638912*^9, {3.563454393140197*^9, 
   3.563454416082637*^9}, {3.5634544480050907`*^9, 3.5634544760359373`*^9}, 
   3.563455174444749*^9, 3.563455289930546*^9, 3.5634553230262012`*^9, 
   3.56345563631714*^9, 3.5634557905194035`*^9, 3.5634558408918924`*^9, 
   3.563455893644384*^9, 3.5634561370540032`*^9, 3.5634562098721294`*^9, 
   3.5634736195311456`*^9, 3.5634736586716146`*^9, 3.5634755811285915`*^9, 
   3.5634758200274115`*^9, 3.5634883830394187`*^9, {3.563488497028819*^9, 
   3.563488516731653*^9}, 3.5634885600997295`*^9, 3.5634886021886034`*^9, 
   3.5635534807523813`*^9, 3.563555401080557*^9, 3.563555650977396*^9, 
   3.5635557272927303`*^9, 3.563894336650487*^9, 3.564775259796977*^9, 
   3.564850497153713*^9, 3.5671058896761465`*^9, 3.56710592080619*^9, 
   3.5671059789762716`*^9, 3.584470463206788*^9, 3.5844711614172144`*^9, 
   3.5844714596429386`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Check SVD: M= ULU^T = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"4.000000000000001`", "1.`"},
       {"1.0000000000000007`", "1.2500000000000002`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Check SVD: M= ULU^T = ", 
   MatrixForm[{{4.000000000000001, 1.}, {1.0000000000000007`, 
    1.2500000000000002`}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.562962327492767*^9, {3.562963239049168*^9, 3.562963258705202*^9}, 
   3.562963569878949*^9, 3.5629636234182434`*^9, {3.5629637164256067`*^9, 
   3.5629637404964485`*^9}, 3.5629638383866205`*^9, {3.5629638906155124`*^9, 
   3.5629639198187637`*^9}, 3.5629714510965705`*^9, {3.562971508863472*^9, 
   3.5629715325287137`*^9}, 3.5629715639003687`*^9, 3.5629716552073293`*^9, 
   3.5629717068902197`*^9, 3.562971766248324*^9, 3.562971824046426*^9, {
   3.562971926211005*^9, 3.562971964353072*^9}, 3.563017127907094*^9, 
   3.5630172641359315`*^9, 3.5630173330075383`*^9, 3.563017881057996*^9, 
   3.5630179964426584`*^9, {3.5630182117726355`*^9, 3.5630182749487715`*^9}, 
   3.563018378694688*^9, 3.563018436978981*^9, {3.5630184681535463`*^9, 
   3.563018512205042*^9}, {3.5630204386916666`*^9, 3.563020454307294*^9}, 
   3.563020493541363*^9, 3.5630233528839097`*^9, 3.563023386845169*^9, 
   3.563023475624925*^9, 3.5630465147084837`*^9, 3.563106682008746*^9, 
   3.5631304963316545`*^9, 3.5631305635209723`*^9, 3.5631306095098534`*^9, 
   3.563130678305974*^9, 3.5631310314437943`*^9, 3.5631310942183046`*^9, {
   3.563131170284038*^9, 3.563131197116085*^9}, 3.5631312339165497`*^9, 
   3.5631313008094673`*^9, 3.563131338701934*^9, 3.5631317297010207`*^9, 
   3.5631318828776894`*^9, 3.563402198545232*^9, 3.563402391486371*^9, {
   3.5634025115909815`*^9, 3.5634025365510254`*^9}, {3.56340337046609*^9, 
   3.56340339879574*^9}, 3.5634037025126734`*^9, 3.5634041006877728`*^9, 
   3.563404333689782*^9, 3.563404449363985*^9, 3.5634497855915394`*^9, 
   3.5634498402384357`*^9, 3.56344988253011*^9, 3.5634499386902084`*^9, 
   3.56345044032469*^9, {3.5634505069368067`*^9, 3.5634505313820496`*^9}, 
   3.563450574406925*^9, 3.5634506311130247`*^9, 3.563450675791503*^9, 
   3.563450752964839*^9, 3.563450869169443*^9, 3.56345095297279*^9, 
   3.5634510333441315`*^9, 3.5634511199866834`*^9, 3.5634511660691643`*^9, {
   3.5634512482345085`*^9, 3.563451278217761*^9}, 3.5634538651230803`*^9, 
   3.5634539380844083`*^9, 3.56345413809256*^9, {3.5634542850216117`*^9, 
   3.5634543119856577`*^9}, 3.563454344638912*^9, {3.563454393140197*^9, 
   3.563454416082637*^9}, {3.5634544480050907`*^9, 3.5634544760359373`*^9}, 
   3.563455174444749*^9, 3.563455289930546*^9, 3.5634553230262012`*^9, 
   3.56345563631714*^9, 3.5634557905194035`*^9, 3.5634558408918924`*^9, 
   3.563455893644384*^9, 3.5634561370540032`*^9, 3.5634562098721294`*^9, 
   3.5634736195311456`*^9, 3.5634736586716146`*^9, 3.5634755811285915`*^9, 
   3.5634758200274115`*^9, 3.5634883830394187`*^9, {3.563488497028819*^9, 
   3.563488516731653*^9}, 3.5634885600997295`*^9, 3.5634886021886034`*^9, 
   3.5635534807523813`*^9, 3.563555401080557*^9, 3.563555650977396*^9, 
   3.5635557272927303`*^9, 3.563894336650487*^9, 3.564775259796977*^9, 
   3.564850497153713*^9, 3.5671058896761465`*^9, 3.56710592080619*^9, 
   3.5671059789762716`*^9, 3.584470463206788*^9, 3.5844711614172144`*^9, 
   3.5844714596429386`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"4.325183813591931`", ",", "0.9248161864080695`"}], "}"}], 
   "\[InvisibleSpace]", "\<\" as matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"4.325183813591931`", "0.`"},
       {"0.`", "0.9248161864080695`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[
  "Evals = ", {4.325183813591931, 0.9248161864080695}, " as matrix = ", 
   MatrixForm[{{4.325183813591931, 0.}, {0., 0.9248161864080695}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.562962327492767*^9, {3.562963239049168*^9, 3.562963258705202*^9}, 
   3.562963569878949*^9, 3.5629636234182434`*^9, {3.5629637164256067`*^9, 
   3.5629637404964485`*^9}, 3.5629638383866205`*^9, {3.5629638906155124`*^9, 
   3.5629639198187637`*^9}, 3.5629714510965705`*^9, {3.562971508863472*^9, 
   3.5629715325287137`*^9}, 3.5629715639003687`*^9, 3.5629716552073293`*^9, 
   3.5629717068902197`*^9, 3.562971766248324*^9, 3.562971824046426*^9, {
   3.562971926211005*^9, 3.562971964353072*^9}, 3.563017127907094*^9, 
   3.5630172641359315`*^9, 3.5630173330075383`*^9, 3.563017881057996*^9, 
   3.5630179964426584`*^9, {3.5630182117726355`*^9, 3.5630182749487715`*^9}, 
   3.563018378694688*^9, 3.563018436978981*^9, {3.5630184681535463`*^9, 
   3.563018512205042*^9}, {3.5630204386916666`*^9, 3.563020454307294*^9}, 
   3.563020493541363*^9, 3.5630233528839097`*^9, 3.563023386845169*^9, 
   3.563023475624925*^9, 3.5630465147084837`*^9, 3.563106682008746*^9, 
   3.5631304963316545`*^9, 3.5631305635209723`*^9, 3.5631306095098534`*^9, 
   3.563130678305974*^9, 3.5631310314437943`*^9, 3.5631310942183046`*^9, {
   3.563131170284038*^9, 3.563131197116085*^9}, 3.5631312339165497`*^9, 
   3.5631313008094673`*^9, 3.563131338701934*^9, 3.5631317297010207`*^9, 
   3.5631318828776894`*^9, 3.563402198545232*^9, 3.563402391486371*^9, {
   3.5634025115909815`*^9, 3.5634025365510254`*^9}, {3.56340337046609*^9, 
   3.56340339879574*^9}, 3.5634037025126734`*^9, 3.5634041006877728`*^9, 
   3.563404333689782*^9, 3.563404449363985*^9, 3.5634497855915394`*^9, 
   3.5634498402384357`*^9, 3.56344988253011*^9, 3.5634499386902084`*^9, 
   3.56345044032469*^9, {3.5634505069368067`*^9, 3.5634505313820496`*^9}, 
   3.563450574406925*^9, 3.5634506311130247`*^9, 3.563450675791503*^9, 
   3.563450752964839*^9, 3.563450869169443*^9, 3.56345095297279*^9, 
   3.5634510333441315`*^9, 3.5634511199866834`*^9, 3.5634511660691643`*^9, {
   3.5634512482345085`*^9, 3.563451278217761*^9}, 3.5634538651230803`*^9, 
   3.5634539380844083`*^9, 3.56345413809256*^9, {3.5634542850216117`*^9, 
   3.5634543119856577`*^9}, 3.563454344638912*^9, {3.563454393140197*^9, 
   3.563454416082637*^9}, {3.5634544480050907`*^9, 3.5634544760359373`*^9}, 
   3.563455174444749*^9, 3.563455289930546*^9, 3.5634553230262012`*^9, 
   3.56345563631714*^9, 3.5634557905194035`*^9, 3.5634558408918924`*^9, 
   3.563455893644384*^9, 3.5634561370540032`*^9, 3.5634562098721294`*^9, 
   3.5634736195311456`*^9, 3.5634736586716146`*^9, 3.5634755811285915`*^9, 
   3.5634758200274115`*^9, 3.5634883830394187`*^9, {3.563488497028819*^9, 
   3.563488516731653*^9}, 3.5634885600997295`*^9, 3.5634886021886034`*^9, 
   3.5635534807523813`*^9, 3.563555401080557*^9, 3.563555650977396*^9, 
   3.5635557272927303`*^9, 3.563894336650487*^9, 3.564775259796977*^9, 
   3.564850497153713*^9, 3.5671058896761465`*^9, 3.56710592080619*^9, 
   3.5671059789762716`*^9, 3.584470463206788*^9, 3.5844711614172144`*^9, 
   3.5844714596585383`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Evecs (rows) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "0.9509826718461248`"}], 
        RowBox[{"-", "0.30924417189076614`"}]},
       {"0.30924417189076614`", 
        RowBox[{"-", "0.9509826718461248`"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Evecs (rows) = ", 
   MatrixForm[{{-0.9509826718461248, -0.30924417189076614`}, {
    0.30924417189076614`, -0.9509826718461248}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.562962327492767*^9, {3.562963239049168*^9, 3.562963258705202*^9}, 
   3.562963569878949*^9, 3.5629636234182434`*^9, {3.5629637164256067`*^9, 
   3.5629637404964485`*^9}, 3.5629638383866205`*^9, {3.5629638906155124`*^9, 
   3.5629639198187637`*^9}, 3.5629714510965705`*^9, {3.562971508863472*^9, 
   3.5629715325287137`*^9}, 3.5629715639003687`*^9, 3.5629716552073293`*^9, 
   3.5629717068902197`*^9, 3.562971766248324*^9, 3.562971824046426*^9, {
   3.562971926211005*^9, 3.562971964353072*^9}, 3.563017127907094*^9, 
   3.5630172641359315`*^9, 3.5630173330075383`*^9, 3.563017881057996*^9, 
   3.5630179964426584`*^9, {3.5630182117726355`*^9, 3.5630182749487715`*^9}, 
   3.563018378694688*^9, 3.563018436978981*^9, {3.5630184681535463`*^9, 
   3.563018512205042*^9}, {3.5630204386916666`*^9, 3.563020454307294*^9}, 
   3.563020493541363*^9, 3.5630233528839097`*^9, 3.563023386845169*^9, 
   3.563023475624925*^9, 3.5630465147084837`*^9, 3.563106682008746*^9, 
   3.5631304963316545`*^9, 3.5631305635209723`*^9, 3.5631306095098534`*^9, 
   3.563130678305974*^9, 3.5631310314437943`*^9, 3.5631310942183046`*^9, {
   3.563131170284038*^9, 3.563131197116085*^9}, 3.5631312339165497`*^9, 
   3.5631313008094673`*^9, 3.563131338701934*^9, 3.5631317297010207`*^9, 
   3.5631318828776894`*^9, 3.563402198545232*^9, 3.563402391486371*^9, {
   3.5634025115909815`*^9, 3.5634025365510254`*^9}, {3.56340337046609*^9, 
   3.56340339879574*^9}, 3.5634037025126734`*^9, 3.5634041006877728`*^9, 
   3.563404333689782*^9, 3.563404449363985*^9, 3.5634497855915394`*^9, 
   3.5634498402384357`*^9, 3.56344988253011*^9, 3.5634499386902084`*^9, 
   3.56345044032469*^9, {3.5634505069368067`*^9, 3.5634505313820496`*^9}, 
   3.563450574406925*^9, 3.5634506311130247`*^9, 3.563450675791503*^9, 
   3.563450752964839*^9, 3.563450869169443*^9, 3.56345095297279*^9, 
   3.5634510333441315`*^9, 3.5634511199866834`*^9, 3.5634511660691643`*^9, {
   3.5634512482345085`*^9, 3.563451278217761*^9}, 3.5634538651230803`*^9, 
   3.5634539380844083`*^9, 3.56345413809256*^9, {3.5634542850216117`*^9, 
   3.5634543119856577`*^9}, 3.563454344638912*^9, {3.563454393140197*^9, 
   3.563454416082637*^9}, {3.5634544480050907`*^9, 3.5634544760359373`*^9}, 
   3.563455174444749*^9, 3.563455289930546*^9, 3.5634553230262012`*^9, 
   3.56345563631714*^9, 3.5634557905194035`*^9, 3.5634558408918924`*^9, 
   3.563455893644384*^9, 3.5634561370540032`*^9, 3.5634562098721294`*^9, 
   3.5634736195311456`*^9, 3.5634736586716146`*^9, 3.5634755811285915`*^9, 
   3.5634758200274115`*^9, 3.5634883830394187`*^9, {3.563488497028819*^9, 
   3.563488516731653*^9}, 3.5634885600997295`*^9, 3.5634886021886034`*^9, 
   3.5635534807523813`*^9, 3.563555401080557*^9, 3.563555650977396*^9, 
   3.5635557272927303`*^9, 3.563894336650487*^9, 3.564775259796977*^9, 
   3.564850497153713*^9, 3.5671058896761465`*^9, 3.56710592080619*^9, 
   3.5671059789762716`*^9, 3.584470463206788*^9, 3.5844711614172144`*^9, 
   3.5844714596585383`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Check decomposition: m = R.Lambda.R^T = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"4.000000000000001`", "1.`"},
       {"1.`", "1.25`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Check decomposition: m = R.Lambda.R^T = ", 
   MatrixForm[{{4.000000000000001, 1.}, {1., 1.25}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.562962327492767*^9, {3.562963239049168*^9, 3.562963258705202*^9}, 
   3.562963569878949*^9, 3.5629636234182434`*^9, {3.5629637164256067`*^9, 
   3.5629637404964485`*^9}, 3.5629638383866205`*^9, {3.5629638906155124`*^9, 
   3.5629639198187637`*^9}, 3.5629714510965705`*^9, {3.562971508863472*^9, 
   3.5629715325287137`*^9}, 3.5629715639003687`*^9, 3.5629716552073293`*^9, 
   3.5629717068902197`*^9, 3.562971766248324*^9, 3.562971824046426*^9, {
   3.562971926211005*^9, 3.562971964353072*^9}, 3.563017127907094*^9, 
   3.5630172641359315`*^9, 3.5630173330075383`*^9, 3.563017881057996*^9, 
   3.5630179964426584`*^9, {3.5630182117726355`*^9, 3.5630182749487715`*^9}, 
   3.563018378694688*^9, 3.563018436978981*^9, {3.5630184681535463`*^9, 
   3.563018512205042*^9}, {3.5630204386916666`*^9, 3.563020454307294*^9}, 
   3.563020493541363*^9, 3.5630233528839097`*^9, 3.563023386845169*^9, 
   3.563023475624925*^9, 3.5630465147084837`*^9, 3.563106682008746*^9, 
   3.5631304963316545`*^9, 3.5631305635209723`*^9, 3.5631306095098534`*^9, 
   3.563130678305974*^9, 3.5631310314437943`*^9, 3.5631310942183046`*^9, {
   3.563131170284038*^9, 3.563131197116085*^9}, 3.5631312339165497`*^9, 
   3.5631313008094673`*^9, 3.563131338701934*^9, 3.5631317297010207`*^9, 
   3.5631318828776894`*^9, 3.563402198545232*^9, 3.563402391486371*^9, {
   3.5634025115909815`*^9, 3.5634025365510254`*^9}, {3.56340337046609*^9, 
   3.56340339879574*^9}, 3.5634037025126734`*^9, 3.5634041006877728`*^9, 
   3.563404333689782*^9, 3.563404449363985*^9, 3.5634497855915394`*^9, 
   3.5634498402384357`*^9, 3.56344988253011*^9, 3.5634499386902084`*^9, 
   3.56345044032469*^9, {3.5634505069368067`*^9, 3.5634505313820496`*^9}, 
   3.563450574406925*^9, 3.5634506311130247`*^9, 3.563450675791503*^9, 
   3.563450752964839*^9, 3.563450869169443*^9, 3.56345095297279*^9, 
   3.5634510333441315`*^9, 3.5634511199866834`*^9, 3.5634511660691643`*^9, {
   3.5634512482345085`*^9, 3.563451278217761*^9}, 3.5634538651230803`*^9, 
   3.5634539380844083`*^9, 3.56345413809256*^9, {3.5634542850216117`*^9, 
   3.5634543119856577`*^9}, 3.563454344638912*^9, {3.563454393140197*^9, 
   3.563454416082637*^9}, {3.5634544480050907`*^9, 3.5634544760359373`*^9}, 
   3.563455174444749*^9, 3.563455289930546*^9, 3.5634553230262012`*^9, 
   3.56345563631714*^9, 3.5634557905194035`*^9, 3.5634558408918924`*^9, 
   3.563455893644384*^9, 3.5634561370540032`*^9, 3.5634562098721294`*^9, 
   3.5634736195311456`*^9, 3.5634736586716146`*^9, 3.5634755811285915`*^9, 
   3.5634758200274115`*^9, 3.5634883830394187`*^9, {3.563488497028819*^9, 
   3.563488516731653*^9}, 3.5634885600997295`*^9, 3.5634886021886034`*^9, 
   3.5635534807523813`*^9, 3.563555401080557*^9, 3.563555650977396*^9, 
   3.5635557272927303`*^9, 3.563894336650487*^9, 3.564775259796977*^9, 
   3.564850497153713*^9, 3.5671058896761465`*^9, 3.56710592080619*^9, 
   3.5671059789762716`*^9, 3.584470463206788*^9, 3.5844711614172144`*^9, 
   3.5844714596585383`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"major=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "4.113174859275266`"}], ",", 
     RowBox[{"-", "1.3375378867095824`"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"  minor=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0.2859940157169399`", ",", 
     RowBox[{"-", "0.8794841679168898`"}]}], "}"}]}],
  SequenceForm[
  "major=", {-4.113174859275266, -1.3375378867095824`}, "  minor=", {
   0.2859940157169399, -0.8794841679168898}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.562962327492767*^9, {3.562963239049168*^9, 3.562963258705202*^9}, 
   3.562963569878949*^9, 3.5629636234182434`*^9, {3.5629637164256067`*^9, 
   3.5629637404964485`*^9}, 3.5629638383866205`*^9, {3.5629638906155124`*^9, 
   3.5629639198187637`*^9}, 3.5629714510965705`*^9, {3.562971508863472*^9, 
   3.5629715325287137`*^9}, 3.5629715639003687`*^9, 3.5629716552073293`*^9, 
   3.5629717068902197`*^9, 3.562971766248324*^9, 3.562971824046426*^9, {
   3.562971926211005*^9, 3.562971964353072*^9}, 3.563017127907094*^9, 
   3.5630172641359315`*^9, 3.5630173330075383`*^9, 3.563017881057996*^9, 
   3.5630179964426584`*^9, {3.5630182117726355`*^9, 3.5630182749487715`*^9}, 
   3.563018378694688*^9, 3.563018436978981*^9, {3.5630184681535463`*^9, 
   3.563018512205042*^9}, {3.5630204386916666`*^9, 3.563020454307294*^9}, 
   3.563020493541363*^9, 3.5630233528839097`*^9, 3.563023386845169*^9, 
   3.563023475624925*^9, 3.5630465147084837`*^9, 3.563106682008746*^9, 
   3.5631304963316545`*^9, 3.5631305635209723`*^9, 3.5631306095098534`*^9, 
   3.563130678305974*^9, 3.5631310314437943`*^9, 3.5631310942183046`*^9, {
   3.563131170284038*^9, 3.563131197116085*^9}, 3.5631312339165497`*^9, 
   3.5631313008094673`*^9, 3.563131338701934*^9, 3.5631317297010207`*^9, 
   3.5631318828776894`*^9, 3.563402198545232*^9, 3.563402391486371*^9, {
   3.5634025115909815`*^9, 3.5634025365510254`*^9}, {3.56340337046609*^9, 
   3.56340339879574*^9}, 3.5634037025126734`*^9, 3.5634041006877728`*^9, 
   3.563404333689782*^9, 3.563404449363985*^9, 3.5634497855915394`*^9, 
   3.5634498402384357`*^9, 3.56344988253011*^9, 3.5634499386902084`*^9, 
   3.56345044032469*^9, {3.5634505069368067`*^9, 3.5634505313820496`*^9}, 
   3.563450574406925*^9, 3.5634506311130247`*^9, 3.563450675791503*^9, 
   3.563450752964839*^9, 3.563450869169443*^9, 3.56345095297279*^9, 
   3.5634510333441315`*^9, 3.5634511199866834`*^9, 3.5634511660691643`*^9, {
   3.5634512482345085`*^9, 3.563451278217761*^9}, 3.5634538651230803`*^9, 
   3.5634539380844083`*^9, 3.56345413809256*^9, {3.5634542850216117`*^9, 
   3.5634543119856577`*^9}, 3.563454344638912*^9, {3.563454393140197*^9, 
   3.563454416082637*^9}, {3.5634544480050907`*^9, 3.5634544760359373`*^9}, 
   3.563455174444749*^9, 3.563455289930546*^9, 3.5634553230262012`*^9, 
   3.56345563631714*^9, 3.5634557905194035`*^9, 3.5634558408918924`*^9, 
   3.563455893644384*^9, 3.5634561370540032`*^9, 3.5634562098721294`*^9, 
   3.5634736195311456`*^9, 3.5634736586716146`*^9, 3.5634755811285915`*^9, 
   3.5634758200274115`*^9, 3.5634883830394187`*^9, {3.563488497028819*^9, 
   3.563488516731653*^9}, 3.5634885600997295`*^9, 3.5634886021886034`*^9, 
   3.5635534807523813`*^9, 3.563555401080557*^9, 3.563555650977396*^9, 
   3.5635557272927303`*^9, 3.563894336650487*^9, 3.564775259796977*^9, 
   3.564850497153713*^9, 3.5671058896761465`*^9, 3.56710592080619*^9, 
   3.5671059789762716`*^9, 3.584470463206788*^9, 3.5844711614172144`*^9, 
   3.5844714596585383`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"z=1 contour ellipse: ax_1^2 + bx_2^2 = 1 where  a=\"\>", 
   "\[InvisibleSpace]", "0.4808368190998037`", 
   "\[InvisibleSpace]", "\<\"  b=\"\>", "\[InvisibleSpace]", 
   "1.0398538134747513`"}],
  SequenceForm[
  "z=1 contour ellipse: ax_1^2 + bx_2^2 = 1 where  a=", 0.4808368190998037, 
   "  b=", 1.0398538134747513`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.562962327492767*^9, {3.562963239049168*^9, 3.562963258705202*^9}, 
   3.562963569878949*^9, 3.5629636234182434`*^9, {3.5629637164256067`*^9, 
   3.5629637404964485`*^9}, 3.5629638383866205`*^9, {3.5629638906155124`*^9, 
   3.5629639198187637`*^9}, 3.5629714510965705`*^9, {3.562971508863472*^9, 
   3.5629715325287137`*^9}, 3.5629715639003687`*^9, 3.5629716552073293`*^9, 
   3.5629717068902197`*^9, 3.562971766248324*^9, 3.562971824046426*^9, {
   3.562971926211005*^9, 3.562971964353072*^9}, 3.563017127907094*^9, 
   3.5630172641359315`*^9, 3.5630173330075383`*^9, 3.563017881057996*^9, 
   3.5630179964426584`*^9, {3.5630182117726355`*^9, 3.5630182749487715`*^9}, 
   3.563018378694688*^9, 3.563018436978981*^9, {3.5630184681535463`*^9, 
   3.563018512205042*^9}, {3.5630204386916666`*^9, 3.563020454307294*^9}, 
   3.563020493541363*^9, 3.5630233528839097`*^9, 3.563023386845169*^9, 
   3.563023475624925*^9, 3.5630465147084837`*^9, 3.563106682008746*^9, 
   3.5631304963316545`*^9, 3.5631305635209723`*^9, 3.5631306095098534`*^9, 
   3.563130678305974*^9, 3.5631310314437943`*^9, 3.5631310942183046`*^9, {
   3.563131170284038*^9, 3.563131197116085*^9}, 3.5631312339165497`*^9, 
   3.5631313008094673`*^9, 3.563131338701934*^9, 3.5631317297010207`*^9, 
   3.5631318828776894`*^9, 3.563402198545232*^9, 3.563402391486371*^9, {
   3.5634025115909815`*^9, 3.5634025365510254`*^9}, {3.56340337046609*^9, 
   3.56340339879574*^9}, 3.5634037025126734`*^9, 3.5634041006877728`*^9, 
   3.563404333689782*^9, 3.563404449363985*^9, 3.5634497855915394`*^9, 
   3.5634498402384357`*^9, 3.56344988253011*^9, 3.5634499386902084`*^9, 
   3.56345044032469*^9, {3.5634505069368067`*^9, 3.5634505313820496`*^9}, 
   3.563450574406925*^9, 3.5634506311130247`*^9, 3.563450675791503*^9, 
   3.563450752964839*^9, 3.563450869169443*^9, 3.56345095297279*^9, 
   3.5634510333441315`*^9, 3.5634511199866834`*^9, 3.5634511660691643`*^9, {
   3.5634512482345085`*^9, 3.563451278217761*^9}, 3.5634538651230803`*^9, 
   3.5634539380844083`*^9, 3.56345413809256*^9, {3.5634542850216117`*^9, 
   3.5634543119856577`*^9}, 3.563454344638912*^9, {3.563454393140197*^9, 
   3.563454416082637*^9}, {3.5634544480050907`*^9, 3.5634544760359373`*^9}, 
   3.563455174444749*^9, 3.563455289930546*^9, 3.5634553230262012`*^9, 
   3.56345563631714*^9, 3.5634557905194035`*^9, 3.5634558408918924`*^9, 
   3.563455893644384*^9, 3.5634561370540032`*^9, 3.5634562098721294`*^9, 
   3.5634736195311456`*^9, 3.5634736586716146`*^9, 3.5634755811285915`*^9, 
   3.5634758200274115`*^9, 3.5634883830394187`*^9, {3.563488497028819*^9, 
   3.563488516731653*^9}, 3.5634885600997295`*^9, 3.5634886021886034`*^9, 
   3.5635534807523813`*^9, 3.563555401080557*^9, 3.563555650977396*^9, 
   3.5635557272927303`*^9, 3.563894336650487*^9, 3.564775259796977*^9, 
   3.564850497153713*^9, 3.5671058896761465`*^9, 3.56710592080619*^9, 
   3.5671059789762716`*^9, 3.584470463206788*^9, 3.5844711614172144`*^9, 
   3.5844714596585383`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics", "Section",
 CellChangeTimes->{{3.558026954381522*^9, 3.558026963005937*^9}, {
  3.584470620548664*^9, 3.58447063515029*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Use", " ", "dominant", " ", "eigenvalue", " ", "to", " ", "set", " ", 
    "plot", " ", "range", " ", "for", " ", "surgace"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"range", " ", "=", " ", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"plotqform", " ", "=", " ", 
      RowBox[{"Plot3D", "[", 
       RowBox[{
        RowBox[{"quadform", "[", 
         RowBox[{"M", ",", "x", ",", "y"}], "]"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "range"}], ",", "range"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "range"}], ",", "range"}], "}"}], ",", " ", 
        RowBox[{"RegionFunction", "\[Rule]", 
         RowBox[{"Function", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x", ",", "y"}], "}"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"x", "^", "2"}], "+", 
             RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "1"}]}], "]"}]}], ",", 
        RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"Directive", "[", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0.7", "]"}], ",", " ", 
           RowBox[{"Opacity", "[", "0.8", "]"}], ",", 
           RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]}]}], 
       "]"}]}], ";"}], "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotqform", " ", "=", " ", 
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{"quadform", "[", 
        RowBox[{"M", ",", "x", ",", "y"}], "]"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "range"}], ",", "range"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "range"}], ",", "range"}], "}"}], ",", " ", 
       RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
       RowBox[{"Ticks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", "None", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"quadform", "[", 
             RowBox[{"M", ",", "1", ",", "1"}], "]"}]}], "}"}]}], "}"}]}], 
       ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.7", "]"}], ",", " ", 
          RowBox[{"Opacity", "[", "0.8", "]"}], ",", 
          RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]}]}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotmmaxes", " ", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "0.005", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "major3d"}], "}"}],
          "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "minor3d"}], "}"}],
          "]"}]}], "}"}], "]"}]}], ";"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rad", " ", "=", " ", "0.015"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotaxes", " ", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", " ", 
       RowBox[{"Black", ",", 
        RowBox[{"Arrowheads", "[", "0.03", "]"}], ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"Tube", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", "rad"}],
           "]"}], "]"}], ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"Tube", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], ",", "rad"}],
           "]"}], "]"}]}], "}"}], "]"}]}], ";"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotellipse", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"i", " ", "\[LessEqual]", " ", "numedata"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Graphics3D", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ellipse3d", "[", 
                RowBox[{"[", 
                 RowBox[{"i", "-", "1"}], "]"}], "]"}], ",", 
               RowBox[{"ellipse3d", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Graphics3D", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"ellipse3d", "[", 
                RowBox[{"[", "numedata", "]"}], "]"}], ",", 
               RowBox[{"ellipse3d", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
          "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"i", ",", "2", ",", 
         RowBox[{"numedata", "+", "1"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotqformellipse", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"i", " ", "\[LessEqual]", " ", "numedata"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Graphics3D", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"qformellipse3d", "[", 
                RowBox[{"[", 
                 RowBox[{"i", "-", "1"}], "]"}], "]"}], ",", 
               RowBox[{"qformellipse3d", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Graphics3D", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"qformellipse3d", "[", 
                RowBox[{"[", "numedata", "]"}], "]"}], ",", 
               RowBox[{"qformellipse3d", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
          "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"i", ",", "2", ",", 
         RowBox[{"numedata", "+", "1"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotqformellipseunrotated", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"i", " ", "\[LessEqual]", " ", "numedata"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"qformellipseunrotated", "[", 
                RowBox[{"[", 
                 RowBox[{"i", "-", "1"}], "]"}], "]"}], ",", 
               RowBox[{"qformellipseunrotated", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"qformellipseunrotated", "[", 
                RowBox[{"[", "numedata", "]"}], "]"}], ",", 
               RowBox[{"qformellipseunrotated", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
          "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"i", ",", "2", ",", 
         RowBox[{"numedata", "+", "1"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"extents", " ", "of", " ", 
      RowBox[{"plane", " ", "--"}], " ", "plotting", " ", "surface", " ", 
      "over", " ", "unit", " ", "circle"}], ",", " ", 
     RowBox[{"so", " ", "make", " ", "plane", " ", "same", " ", "idea"}]}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"val", " ", "=", " ", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"create", " ", "plane", " ", "at", " ", "z"}], "=", 
     RowBox[{"lambda_", "1"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"zval", " ", "=", " ", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotplane3d", " ", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EdgeForm", "[", "Thin", "]"}], ",", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "val"}], ",", "val", ",", "zval"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"val", ",", "val", ",", "zval"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"val", ",", 
             RowBox[{"-", "val"}], ",", "zval"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "val"}], ",", 
             RowBox[{"-", "val"}], ",", "zval"}], "}"}]}], "}"}], "]"}]}], 
       "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"uarrows2d", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.003", "]"}], ",", " ", "Yellow", ",", 
          RowBox[{"Arrowheads", "[", "Small", "]"}], ",", 
          RowBox[{"Arrow", "[", 
           RowBox[{"{", 
            RowBox[{"origin", ",", " ", 
             RowBox[{"units", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], "]"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numu"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ulines2d", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"i", " ", "\[LessEqual]", " ", "numu"}], ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "0.007", "]"}], ",", " ", "Yellow", ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"units", "[", 
                RowBox[{"[", 
                 RowBox[{"i", "-", "1"}], "]"}], "]"}], ",", " ", 
               RowBox[{"units", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "0.007", "]"}], ",", " ", "Yellow", ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"units", "[", 
                RowBox[{"[", "numu", "]"}], "]"}], ",", " ", 
               RowBox[{"units", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
          "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "2", ",", 
         RowBox[{"numu", "+", "1"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"muarrows2d", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.003", "]"}], ",", " ", 
          RowBox[{"GrayLevel", "[", "0.4", "]"}], ",", 
          RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", 
          RowBox[{"Arrow", "[", 
           RowBox[{"{", 
            RowBox[{"origin", ",", " ", 
             RowBox[{"mu", "[", 
              RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], "]"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numu"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mulines2d", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"i", " ", "\[LessEqual]", " ", "numu"}], ",", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", 
            RowBox[{"GrayLevel", "[", "0.4", "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"mu", "[", 
                RowBox[{"[", 
                 RowBox[{"i", "-", "1"}], "]"}], "]"}], ",", " ", 
               RowBox[{"mu", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", 
            RowBox[{"GrayLevel", "[", "0.4", "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"mu", "[", 
                RowBox[{"[", "numu", "]"}], "]"}], ",", " ", 
               RowBox[{"mu", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
          "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "2", ",", 
         RowBox[{"numu", "+", "1"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"majorarrow2d", " ", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.007", "]"}], ",", " ", "Black", ",", 
         RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", " ", "major2d"}], "}"}], 
          "]"}]}], "}"}], ",", " ", 
       RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"minorarrow2d", " ", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "0.007", "]"}], ",", " ", "Black", ",", 
         RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], ",", " ", "minor2d"}], "}"}], 
          "]"}]}], "}"}], ",", 
       RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"++", 
     RowBox[{"++", 
      RowBox[{"++", 
       RowBox[{"++", " ", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"DISPLAY", " ", "++"}], "++"}], "++"}], "++"}]}]}]}]}], 
    " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Matrix M = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "M", "]"}]}], "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{
    "Print", "[", "\"\<Graphics: quadratic form, z=1 plane,\>\"", "]"}], 
    ";"}], "\n", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
     "\"\<and z=1 contour ellipse: ax_1^2 + bx_2^2 = 1 where  a=\>\"", ",", 
      "a", ",", "\"\<  b=\>\"", ",", "b"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", "\"\<a = 1/sqrt(lambda_1)  and   b = 1/sqrt(lambda_2)\>\"", 
     "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", "\"\<(Note: z-direction scale different than x and y)\>\"", 
     "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "took", " ", "out", " ", "plotellipse", " ", "and", " ", "plotmmaxes"}], 
     " ", ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", " ", 
     RowBox[{"BoxRatios", "\[Rule]", 
      RowBox[{"Automatic", " ", "plotaxes"}]}], ",", " ", 
     RowBox[{"BoxStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{
        RowBox[{"Thickness", "[", "0.0008", "]"}], ",", " ", "Black"}], 
       "]"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"plotqform", ",", "plotqformellipse", ",", "plotplane3d", ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}], " ", ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", " ", 
     RowBox[{"ViewPoint", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", "2"}], ",", "1.0"}], "}"}]}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", 
     "\"\<Vectors in unit circle and mapped by M to form action ellipse\>\"", 
     "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<major axis=\>\"", ",", 
      RowBox[{"major2d", "//", "N"}], ",", "\"\<  minor axis=\>\"", ",", 
      RowBox[{"minor2d", "//", "N"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", 
     "\"\<(major axis is lambda_1 times dominant eigenvector\>\"", "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", 
     "\"\<minor axis is lambda_2 times non-dominant eigenvector)\>\"", "]"}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Show", "[", "plotqformellipseunrotated", "]"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{
    "uarrows2d", ",", "muarrows2d", ",", " ", "majorarrow2d", ",", " ", 
     "minorarrow2d"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{
    "ulines2d", ",", " ", "mulines2d", ",", " ", "majorarrow2d", ",", " ", 
     "minorarrow2d"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.5579497071467443`*^9, 3.5579497131839547`*^9}, {
   3.557949980693225*^9, 3.5579500477109423`*^9}, {3.5579500807830005`*^9, 
   3.5579501065074453`*^9}, {3.5580147970179644`*^9, 3.558014807752783*^9}, {
   3.558014847956053*^9, 3.558014864507682*^9}, 3.5580149337390018`*^9, {
   3.558014971725068*^9, 3.5580151149529185`*^9}, {3.5580151450297713`*^9, 
   3.5580151520965843`*^9}, {3.5580152623063745`*^9, 
   3.5580153239772816`*^9}, {3.5580153653145533`*^9, 3.558015370415762*^9}, {
   3.558015417440644*^9, 3.558015484913561*^9}, {3.5580155335876455`*^9, 
   3.558015564169297*^9}, {3.558015642068633*^9, 3.5580157166875625`*^9}, {
   3.558015873992635*^9, 3.5580159309391336`*^9}, {3.5580159888124347`*^9, 
   3.558016001661256*^9}, {3.5580190583193626`*^9, 3.558019131388687*^9}, {
   3.558019516824154*^9, 3.5580195570126233`*^9}, {3.5580196659156094`*^9, 
   3.5580197379293346`*^9}, {3.5580197746533985`*^9, 
   3.5580197786782055`*^9}, {3.5580198148794665`*^9, 3.558019827031888*^9}, 
   3.558019857624341*^9, {3.5580200392090464`*^9, 3.5580200802683187`*^9}, {
   3.558020389499656*^9, 3.5580204072992873`*^9}, {3.558026665673829*^9, 
   3.55802666640703*^9}, {3.558026716150714*^9, 3.5580267699648037`*^9}, {
   3.558027646988327*^9, 3.558027689611601*^9}, 3.5580279602792683`*^9, 
   3.5580293549180737`*^9, {3.562592733732999*^9, 3.562592734923001*^9}, {
   3.562592993249793*^9, 3.5625929937597938`*^9}, 3.5625936625344377`*^9, {
   3.5625937005205045`*^9, 3.5625937292557545`*^9}, {3.562593785041453*^9, 
   3.5625937854314537`*^9}, {3.5625941002102413`*^9, 3.562594106762253*^9}, {
   3.5626035579904222`*^9, 3.5626035681928406`*^9}, {3.5626036758330297`*^9, 
   3.562603679639436*^9}, {3.5626058836137075`*^9, 3.5626059328161936`*^9}, {
   3.5626060367747765`*^9, 3.5626060841832595`*^9}, {3.5626069224261875`*^9, 
   3.5626069273869963`*^9}, {3.5629384219120092`*^9, 3.562938424517214*^9}, {
   3.5629568073850703`*^9, 3.562956816776287*^9}, {3.5629569213432703`*^9, 
   3.5629569397357025`*^9}, 3.562956984570182*^9, 3.5629570537875032`*^9, {
   3.5629631772106595`*^9, 3.56296318877028*^9}, {3.5629632304847527`*^9, 
   3.5629632308279533`*^9}, {3.5629636851319513`*^9, 
   3.5629637089999933`*^9}, {3.5629639137347527`*^9, 3.5629639164335575`*^9}, 
   3.5629714426569557`*^9, {3.5629714996906557`*^9, 3.562971525836302*^9}, {
   3.5629715561315556`*^9, 3.562971560546363*^9}, {3.5629716147564583`*^9, 
   3.5629716513073225`*^9}, {3.5629717981815805`*^9, 
   3.5629718191012173`*^9}, {3.562971919159793*^9, 3.5629719230442*^9}, {
   3.5630170372489643`*^9, 3.563017139575762*^9}, {3.563017190502761*^9, 
   3.563017235244293*^9}, {3.5630173030186367`*^9, 3.5630173180374956`*^9}, {
   3.5630173533329105`*^9, 3.5630174260060616`*^9}, {3.5630174565602913`*^9, 
   3.5630175160848427`*^9}, {3.563017555807592*^9, 3.5630175559816017`*^9}, {
   3.563017657917475*^9, 3.563017689822647*^9}, {3.5630178641210012`*^9, 
   3.5630178673052096`*^9}, {3.563017926462633*^9, 3.5630179334180307`*^9}, {
   3.563017978317836*^9, 3.5630179915093837`*^9}, {3.5630180497294626`*^9, 
   3.563018095692047*^9}, {3.5630181546462345`*^9, 3.5630181869260745`*^9}, {
   3.5630183245564194`*^9, 3.5630183635428286`*^9}, {3.563018406749262*^9, 
   3.5630184073422956`*^9}, {3.5630185019784737`*^9, 
   3.5630185572098145`*^9}, {3.5630186131764603`*^9, 3.563018620056072*^9}, {
   3.5630186502577252`*^9, 3.563018655093734*^9}, {3.563018732282669*^9, 
   3.5630187654639273`*^9}, {3.5630188454452677`*^9, 
   3.5630189351922255`*^9}, {3.5630189784667015`*^9, 3.563018984644313*^9}, {
   3.563020430080451*^9, 3.5630204779413357`*^9}, {3.5630233078934307`*^9, 
   3.563023613279567*^9}, {3.5630236670216613`*^9, 3.5630237071761317`*^9}, 
   3.563023737533785*^9, {3.5630240855859966`*^9, 3.5630241347104826`*^9}, {
   3.563024220760234*^9, 3.563024263098708*^9}, {3.563024304407581*^9, 
   3.5630243047039814`*^9}, {3.5631066648267636`*^9, 
   3.5631066779165125`*^9}, {3.563130267947253*^9, 3.5631302693044558`*^9}, {
   3.563130668852357*^9, 3.563130673891166*^9}, {3.5631309247084064`*^9, 
   3.563130933038821*^9}, {3.563130964847277*^9, 3.563130965003278*^9}, {
   3.5631309975293345`*^9, 3.563131015001365*^9}, {3.563131087182692*^9, 
   3.563131090521098*^9}, {3.5631313303247194`*^9, 3.5631313340375257`*^9}, 
   3.563131527680666*^9, {3.5631315622659264`*^9, 3.563131620142028*^9}, {
   3.5631316515604835`*^9, 3.5631317182350006`*^9}, 3.563131755831066*^9, {
   3.5631317996359434`*^9, 3.5631318767156787`*^9}, {3.5634021316211147`*^9, 
   3.563402192929222*^9}, {3.5634033916353273`*^9, 3.563403395332534*^9}, {
   3.563403670829018*^9, 3.563403698316266*^9}, {3.5634504805259604`*^9, 
   3.563450501242797*^9}, 3.5634505714117203`*^9, 3.563450653857865*^9, {
   3.5634509011806993`*^9, 3.5634509486983824`*^9}, {3.563450997729269*^9, 
   3.563450997963269*^9}, {3.5634510802066135`*^9, 3.5634511160710764`*^9}, {
   3.5634512042424316`*^9, 3.5634512229780645`*^9}, {3.5634538283226156`*^9, 
   3.563453879662306*^9}, {3.563453922718381*^9, 3.5634539234359827`*^9}, {
   3.5634539663360577`*^9, 3.5634540046185255`*^9}, {3.5634541209333296`*^9, 
   3.563454130246546*^9}, {3.56345419148505*^9, 3.5634541923586516`*^9}, {
   3.563454301315239*^9, 3.563454308850052*^9}, {3.5634543888033895`*^9, 
   3.5634543890529895`*^9}, {3.5634545731117034`*^9, 3.563454585404525*^9}, {
   3.5634551681891375`*^9, 3.56345516970234*^9}, {3.5634552035303984`*^9, 
   3.563455211767213*^9}, {3.5634552472488737`*^9, 3.563455265725705*^9}, 
   3.5634553199529963`*^9, {3.5634554936872945`*^9, 3.5634555467533855`*^9}, {
   3.5634555904654617`*^9, 3.5634555952702703`*^9}, {3.563455630891532*^9, 
   3.563455673392002*^9}, {3.5634557063576593`*^9, 3.5634557747157764`*^9}, {
   3.56345607197029*^9, 3.5634561514684286`*^9}, {3.5634561924504995`*^9, 
   3.56345620449012*^9}, {3.5634757244928436`*^9, 3.563475725865646*^9}, {
   3.563475765770516*^9, 3.563475814739002*^9}, {3.563488594903391*^9, 
   3.563488597929796*^9}, 3.5635552977303753`*^9, {3.5635553461060605`*^9, 
   3.563555350942069*^9}, {3.5635553839361267`*^9, 3.5635554291762066`*^9}, {
   3.563555645922987*^9, 3.5635556464845877`*^9}, {3.563555685890257*^9, 
   3.563555717152712*^9}, {3.5671059725762625`*^9, 3.567105975896267*^9}, {
   3.5671062427466407`*^9, 3.567106245166644*^9}, 3.567106286336702*^9, {
   3.5844706861155796`*^9, 3.5844707412772765`*^9}, {3.584470790495363*^9, 
   3.5844708550170765`*^9}, {3.584470901193157*^9, 3.5844709047187634`*^9}, {
   3.584470968741276*^9, 3.584471057801832*^9}, {3.584471132167163*^9, 
   3.5844711831324525`*^9}, {3.5844712807106237`*^9, 3.584471313455082*^9}, {
   3.5844713505363464`*^9, 3.5844714541205287`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Matrix M = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"4.`", "1.`"},
       {"1.`", "1.25`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Matrix M = ", 
   MatrixForm[{{4., 1.}, {1., 1.25}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.5844711614796143`*^9, 3.5844714597209387`*^9}],

Cell[BoxData["\<\"Graphics: quadratic form, z=1 plane,\"\>"], "Print",
 CellChangeTimes->{3.5844711614796143`*^9, 3.5844714597209387`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"and z=1 contour ellipse: ax_1^2 + bx_2^2 = 1 where  a=\"\>", 
   "\[InvisibleSpace]", "0.4808368190998037`", 
   "\[InvisibleSpace]", "\<\"  b=\"\>", "\[InvisibleSpace]", 
   "1.0398538134747513`"}],
  SequenceForm[
  "and z=1 contour ellipse: ax_1^2 + bx_2^2 = 1 where  a=", 
   0.4808368190998037, "  b=", 1.0398538134747513`],
  Editable->False]], "Print",
 CellChangeTimes->{3.5844711614796143`*^9, 3.5844714597209387`*^9}],

Cell[BoxData["\<\"a = 1/sqrt(lambda_1)  and   b = 1/sqrt(lambda_2)\"\>"], \
"Print",
 CellChangeTimes->{3.5844711614796143`*^9, 3.5844714597209387`*^9}],

Cell[BoxData["\<\"(Note: z-direction scale different than x and y)\"\>"], \
"Print",
 CellChangeTimes->{3.5844711614796143`*^9, 3.5844714597209387`*^9}]
}, Open  ]],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx1m3t0VdURxkOMyEujPEQigqxSlFoUlFZRZGJpVcTYFvqgdmEtCIKV+qgP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    "], {{
      {GrayLevel[0.7], Opacity[0.8], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNmwn4V2P2wO+92aMIUbSKokKJkCVLhMpWtpSKLFFJZW9UsiYhESG7TPZs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          "]]],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0Lsuw2EYwOGvTtU69QpI67BxBVwBg4iWIDS1YNCt5Qp0tCCxmOoKuAIG
s3Pr2FkiImL2fDE8/b1vv3+/f9JsqTy3nQghrDHcFkKcr3x8aIYhJphihmW2
2KXGEafs+825HuilLuis+27MWT2235rvuGfJ/qBVZyvmeX207+iqPa+N+B4t
2pvmJ5554ZU33ik5L3iuZc7pif3afMEZdQ7Zi/ezGd/PNJNUPD+uZR3UX8bc
M6Bp3fB9v7mPXn7oiXc4+9ZRTeuifumIpuJ/oJ/aTZIuOumgHcdhPfH/v/8B
hzAsaA==
       "]]}},
    VertexNormals->CompressedData["
1:eJwtm3dczt///yOVkmSUFSrSIGWkrJ4pWhSiSCFSeIcSiUhGRImWSqU9SENT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     "]], 
   {Thickness[0.005], 
    Line3DBox[{{-0.45726748294952313`, -0.14869598393710892`, 
       1}, {-0.4228797450349864, -0.2466766877252818, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.4228797450349864, -0.2466766877252818, 
       1}, {-0.38426673249351884`, -0.3421926795901756, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.38426673249351884`, -0.3421926795901756, 
       1}, {-0.34181425378266994`, -0.4342895953144653, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.34181425378266994`, -0.4342895953144653, 
       1}, {-0.2959464800367947, -0.5220472329594268, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.2959464800367947, -0.5220472329594268, 
       1}, {-0.2471217068892917, -0.6045887472185297, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.2471217068892917, -0.6045887472185297, 
       1}, {-0.19582777533412643`, -0.6810894105658942, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.19582777533412643`, -0.6810894105658942, 
       1}, {-0.14257719737987895`, -0.7507848536611105, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.14257719737987895`, -0.7507848536611105, 
       1}, {-0.08790203519916703, -0.8129787026750218, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.08790203519916703, -0.8129787026750218, 
       1}, {-0.03234858493929477, -0.8670495372268343, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.03234858493929477, -0.8670495372268343, 1}, {
      0.02352808168827042, -0.9124570994111476, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.02352808168827042, -0.9124570994111476, 1}, {
      0.07916966350095625, -0.9487476918763609, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.07916966350095625, -0.9487476918763609, 1}, {
      0.13402020820595195`, -0.9755587110186362, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.13402020820595195`, -0.9755587110186362, 1}, {
      0.18753166729174445`, -0.992622269997249, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.18753166729174445`, -0.992622269997249, 1}, {
      0.23916937194768545`, -0.9997678753713478, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.23916937194768545`, -0.9997678753713478, 1}, {
      0.2884173752980083, -0.996924130614057, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.2884173752980083, -0.996924130614057, 1}, {
      0.33478360757246234`, -0.9841194494829749, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.33478360757246234`, -0.9841194494829749, 1}, {
      0.3778047927047997, -0.9614817721192986, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.3778047927047997, -0.9614817721192986, 1}, {
      0.41705107723409124`, -0.9292372867122244, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.41705107723409124`, -0.9292372867122244, 1}, {
      0.45213032525841723`, -0.8877081695013301, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.45213032525841723`, -0.8877081695013301, 1}, {
      0.482692036527176, -0.8373093656980859, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.482692036527176, -0.8373093656980859, 1}, {
      0.5084308485237291, -0.7785444434904643, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.5084308485237291, -0.7785444434904643, 1}, {
      0.5290895875467267, -0.7120005625560629, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.5290895875467267, -0.7120005625560629, 1}, {
      0.5444618383047226, -0.6383426073566962, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.5444618383047226, -0.6383426073566962, 1}, {
      0.5543940063495331, -0.5583065438326329, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.5543940063495331, -0.5583065438326329, 1}, {
      0.5587868527411927, -0.47269206587420143`, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.5587868527411927, -0.47269206587420143`, 1}, {
      0.5575964856106381, -0.38235460504477714`, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.5575964856106381, -0.38235460504477714`, 1}, {
      0.5508347987127545, -0.288196783391374, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.5508347987127545, -0.288196783391374, 1}, {
      0.5385693525879093, -0.1911593947435151, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.5385693525879093, -0.1911593947435151, 1}, {
      0.5209226995193643, -0.09221200461227363, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.5209226995193643, -0.09221200461227363, 1}, {
      0.4980711590313726, 0.0076567373878169975`, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.4980711590313726, 0.0076567373878169975`, 1}, {
      0.4702430561627752, 0.10744897579890994`, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.4702430561627752, 0.10744897579890994`, 1}, {
      0.43771644011868704`, 0.20616761956172933`, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.43771644011868704`, 0.20616761956172933`, 1}, {
      0.4008163060947512, 0.3028263046198422, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.4008163060947512, 0.3028263046198422, 1}, {
      0.359911348032572, 0.39645924934326116`, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.359911348032572, 0.39645924934326116`, 1}, {
      0.31541027475172584`, 0.4861309042992459, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.31541027475172584`, 0.4861309042992459, 1}, {
      0.2677577262663351, 0.5709452999529852, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.2677577262663351, 0.5709452999529852, 1}, {
      0.21742983108902797`, 0.6500549988990183, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.21742983108902797`, 0.6500549988990183, 1}, {
      0.1649294489122258, 0.722669563175666, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.1649294489122258, 0.722669563175666, 1}, {
      0.11078114620031995`, 0.7880634520598601, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0.11078114620031995`, 0.7880634520598601, 1}, {
      0.05552595489495915, 0.8455832714302145, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{
      0.05552595489495915, 0.8455832714302145, 1}, {-0.0002840333972722875, 
       0.8946543022651063, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.0002840333972722875, 0.8946543022651063, 
       1}, {-0.056091183721686616`, 0.9347862430451586, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.056091183721686616`, 0.9347862430451586, 
       1}, {-0.11133788947963402`, 0.9655781086839529, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.11133788947963402`, 0.9655781086839529, 
       1}, {-0.16547214384931463`, 0.9867222370384645, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.16547214384931463`, 0.9867222370384645, 
       1}, {-0.21795305525547082`, 0.9980073629674943, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.21795305525547082`, 0.9980073629674943, 
       1}, {-0.26825625177921625`, 0.9993207292231264, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.26825625177921625`, 0.9993207292231264, 
       1}, {-0.31587912050891065`, 0.9906492130838752, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.31587912050891065`, 0.9906492130838752, 
       1}, {-0.3603458294822352, 0.9720794574725823, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.3603458294822352, 0.9720794574725823, 
       1}, {-0.40121208204186753`, 0.9437970052489708, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.40121208204186753`, 0.9437970052489708, 
       1}, {-0.4380695561008192, 0.9060844453267229, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.4380695561008192, 0.9060844453267229, 
       1}, {-0.4705499839617545, 0.8593185891384669, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.4705499839617545, 0.8593185891384669, 
       1}, {-0.49832883192608846`, 0.8039667056604994, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.49832883192608846`, 0.8039667056604994, 
       1}, {-0.5211285429274283, 0.7405818526156316, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.5211285429274283, 0.7405818526156316, 
       1}, {-0.5387213097900305, 0.669797350503242, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.5387213097900305, 0.669797350503242, 
       1}, {-0.5509313514027997, 0.5923204546701915, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.5509313514027997, 0.5923204546701915, 
       1}, {-0.5576366690660445, 0.5089252886491864, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.5576366690660445, 0.5089252886491864, 
       1}, {-0.5587702654621568, 0.42044510937233337`, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.5587702654621568, 0.42044510937233337`, 
       1}, {-0.5543208140706639, 0.32776398154330655`, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.5543208140706639, 0.32776398154330655`, 
       1}, {-0.5443327723390765, 0.2318079443550673, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.5443327723390765, 0.2318079443550673, 
       1}, {-0.5289059374787691, 0.133535758812351, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.5289059374787691, 0.133535758812351, 
       1}, {-0.508194449324232, 0.033929328108634055`, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.508194449324232, 0.033929328108634055`, 
       1}, {-0.48240525021879793`, -0.06601611322599878, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{-0.48240525021879793`, -0.06601611322599878, 
       1}, {-0.45726748294952313`, -0.14869598393710892`, 1}}]}, 
   {EdgeForm[Thickness[Tiny]], 
    Polygon3DBox[{{-1, 1, 1}, {1, 1, 1}, {1, -1, 1}, {-1, -1, 1}}]}},
  AutomaticImageSize->True,
  Axes->True,
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 14},
  BoxRatios->{1, 1, 0.4},
  Boxed->False,
  ImageSize->{389.50718853308416`, 294.62134856674675`},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{-1, 1}, {-1, 1}, {0., 7.249997928571577}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{{{-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}}, None, {{0, 
      FormBox["0", TraditionalForm]}, {7.25, 
      FormBox["7.25`", TraditionalForm]}}},
  ViewPoint->{-0.839929423000204, -1.7387778936327347`, 1.127461751454414},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{
  3.5634561548848343`*^9, 3.5634562099657297`*^9, 3.5634736196091456`*^9, 
   3.5634736587496147`*^9, 3.5634755812065916`*^9, 3.5634758201210113`*^9, 
   3.5634883831330185`*^9, {3.563488497122419*^9, 3.5634885168096533`*^9}, 
   3.5634885601777296`*^9, 3.5634886022822037`*^9, 3.5635534811423817`*^9, {
   3.563555401158557*^9, 3.563555430112208*^9}, 3.5635556510709963`*^9, 
   3.5635556870290594`*^9, 3.5635557273707304`*^9, 3.563894337087288*^9, 
   3.564775259984177*^9, 3.5648504973409133`*^9, 3.5671058905461473`*^9, 
   3.5671059210361905`*^9, 3.5671059790562716`*^9, 3.584470463596789*^9, 
   3.5844711615108147`*^9, 3.5844714597365384`*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Vectors in unit circle and mapped by M to form action \
ellipse\"\>"], "Print",
 CellChangeTimes->{3.5844711614796143`*^9, 3.584471459752138*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"major axis=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "4.113174859275266`"}], ",", 
     RowBox[{"-", "1.3375378867095824`"}]}], "}"}], 
   "\[InvisibleSpace]", "\<\"  minor axis=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"0.2859940157169399`", ",", 
     RowBox[{"-", "0.8794841679168898`"}]}], "}"}]}],
  SequenceForm[
  "major axis=", {-4.113174859275266, -1.3375378867095824`}, 
   "  minor axis=", {0.2859940157169399, -0.8794841679168898}],
  Editable->False]], "Print",
 CellChangeTimes->{3.5844711614796143`*^9, 3.584471459752138*^9}],

Cell[BoxData["\<\"(major axis is lambda_1 times dominant eigenvector\"\>"], \
"Print",
 CellChangeTimes->{3.5844711614796143`*^9, 3.584471459752138*^9}],

Cell[BoxData["\<\"minor axis is lambda_2 times non-dominant \
eigenvector)\"\>"], "Print",
 CellChangeTimes->{3.5844711614796143`*^9, 3.584471459752138*^9}]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[{{0, 0}, {1, 0}}]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Cos[Rational[18, 5] Degree], Sin[Rational[18, 5] Degree]}}, {{0, 0}, {
       0.9980267284282716, 0.06279051952931337}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Cos[Rational[36, 5] Degree], Sin[Rational[36, 5] Degree]}}, {{0, 0}, {
       0.9921147013144779, 0.12533323356430426`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Cos[Rational[54, 5] Degree], Sin[Rational[54, 5] Degree]}}, {{0, 0}, {
       0.9822872507286887, 0.18738131458572463`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Cos[Rational[72, 5] Degree], Sin[Rational[72, 5] Degree]}}, {{0, 0}, {
       0.9685831611286311, 0.2486898871648548}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2],
         Rational[1, 4] (-1 + 5^Rational[1, 2])}}, {{0, 0}, {
       0.9510565162951535, 0.30901699437494745`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Cos[Rational[108, 5] Degree], Sin[Rational[108, 5] Degree]}}, {{0, 
       0}, {0.9297764858882515, 0.368124552684678}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Cos[Rational[126, 5] Degree], Sin[Rational[126, 5] Degree]}}, {{0, 
       0}, {0.9048270524660196, 0.42577929156507266`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Cos[Rational[144, 5] Degree], Sin[Rational[144, 5] Degree]}}, {{0, 
       0}, {0.8763066800438636, 0.4817536741017153}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[
     NCache[{{0, 0}, {
       Cos[Rational[162, 5] Degree], Sin[Rational[162, 5] Degree]}}, {{0, 
       0}, {0.8443279255020151, 0.5358267949789967}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}}, {{0, 0}, {
       0.8090169943749475, 0.5877852522924731}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Cos[Rational[198, 5] Degree], Sin[Rational[198, 5] Degree]}}, {{0, 
       0}, {0.7705132427757891, 0.6374239897486897}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Cos[Rational[216, 5] Degree], Sin[Rational[216, 5] Degree]}}, {{0, 
       0}, {0.7289686274214116, 0.6845471059286887}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Sin[Rational[216, 5] Degree], Cos[Rational[216, 5] Degree]}}, {{0, 
       0}, {0.6845471059286887, 0.7289686274214116}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Sin[Rational[198, 5] Degree], Cos[Rational[198, 5] Degree]}}, {{0, 
       0}, {0.6374239897486897, 0.7705132427757891}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2])}}, {{0, 0}, {
       0.5877852522924731, 0.8090169943749475}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Sin[Rational[162, 5] Degree], Cos[Rational[162, 5] Degree]}}, {{0, 
       0}, {0.5358267949789967, 0.8443279255020151}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Sin[Rational[144, 5] Degree], Cos[Rational[144, 5] Degree]}}, {{0, 
       0}, {0.4817536741017153, 0.8763066800438636}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Sin[Rational[126, 5] Degree], Cos[Rational[126, 5] Degree]}}, {{0, 
       0}, {0.42577929156507266`, 0.9048270524660196}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Sin[Rational[108, 5] Degree], Cos[Rational[108, 5] Degree]}}, {{0, 
       0}, {0.368124552684678, 0.9297764858882515}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}}, {{0, 0}, {
       0.30901699437494745`, 0.9510565162951535}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Sin[Rational[72, 5] Degree], Cos[Rational[72, 5] Degree]}}, {{0, 0}, {
       0.2486898871648548, 0.9685831611286311}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Sin[Rational[54, 5] Degree], Cos[Rational[54, 5] Degree]}}, {{0, 0}, {
       0.18738131458572463`, 0.9822872507286887}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Sin[Rational[36, 5] Degree], Cos[Rational[36, 5] Degree]}}, {{0, 0}, {
       0.12533323356430426`, 0.9921147013144779}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Sin[Rational[18, 5] Degree], Cos[Rational[18, 5] Degree]}}, {{0, 0}, {
       0.06279051952931337, 0.9980267284282716}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[{{0, 0}, {0, 1}}]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Sin[Rational[18, 5] Degree], Cos[Rational[18, 5] Degree]}}, {{0, 
       0}, {-0.06279051952931337, 0.9980267284282716}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Sin[Rational[36, 5] Degree], Cos[Rational[36, 5] Degree]}}, {{0, 
       0}, {-0.12533323356430426`, 0.9921147013144779}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Sin[Rational[54, 5] Degree], Cos[Rational[54, 5] Degree]}}, {{0, 
       0}, {-0.18738131458572463`, 0.9822872507286887}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Sin[Rational[72, 5] Degree], Cos[Rational[72, 5] Degree]}}, {{0, 
       0}, {-0.2486898871648548, 0.9685831611286311}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}}, {{0, 
       0}, {-0.30901699437494745`, 0.9510565162951535}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Sin[Rational[108, 5] Degree], Cos[Rational[108, 5] Degree]}}, {{
       0, 0}, {-0.368124552684678, 0.9297764858882515}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Sin[Rational[126, 5] Degree], Cos[Rational[126, 5] Degree]}}, {{
       0, 0}, {-0.42577929156507266`, 0.9048270524660196}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Sin[Rational[144, 5] Degree], Cos[Rational[144, 5] Degree]}}, {{
       0, 0}, {-0.4817536741017153, 0.8763066800438636}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Sin[Rational[162, 5] Degree], Cos[Rational[162, 5] Degree]}}, {{
       0, 0}, {-0.5358267949789967, 0.8443279255020151}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2])}}, {{0, 
       0}, {-0.5877852522924731, 0.8090169943749475}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Sin[Rational[198, 5] Degree], Cos[Rational[198, 5] Degree]}}, {{
       0, 0}, {-0.6374239897486897, 0.7705132427757891}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Sin[Rational[216, 5] Degree], Cos[Rational[216, 5] Degree]}}, {{
       0, 0}, {-0.6845471059286887, 0.7289686274214116}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Cos[Rational[216, 5] Degree], Sin[Rational[216, 5] Degree]}}, {{
       0, 0}, {-0.7289686274214116, 0.6845471059286887}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Cos[Rational[198, 5] Degree], Sin[Rational[198, 5] Degree]}}, {{
       0, 0}, {-0.7705132427757891, 0.6374239897486897}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}}, {{0, 
       0}, {-0.8090169943749475, 0.5877852522924731}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Cos[Rational[162, 5] Degree], Sin[Rational[162, 5] Degree]}}, {{
       0, 0}, {-0.8443279255020151, 0.5358267949789967}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Cos[Rational[144, 5] Degree], Sin[Rational[144, 5] Degree]}}, {{
       0, 0}, {-0.8763066800438636, 0.4817536741017153}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Cos[Rational[126, 5] Degree], Sin[Rational[126, 5] Degree]}}, {{
       0, 0}, {-0.9048270524660196, 0.42577929156507266`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Cos[Rational[108, 5] Degree], Sin[Rational[108, 5] Degree]}}, {{
       0, 0}, {-0.9297764858882515, 0.368124552684678}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2])}}, {{0, 
       0}, {-0.9510565162951535, 0.30901699437494745`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Cos[Rational[72, 5] Degree], Sin[Rational[72, 5] Degree]}}, {{0, 
       0}, {-0.9685831611286311, 0.2486898871648548}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Cos[Rational[54, 5] Degree], Sin[Rational[54, 5] Degree]}}, {{0, 
       0}, {-0.9822872507286887, 0.18738131458572463`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Cos[Rational[36, 5] Degree], Sin[Rational[36, 5] Degree]}}, {{0, 
       0}, {-0.9921147013144779, 0.12533323356430426`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Cos[Rational[18, 5] Degree], Sin[Rational[18, 5] Degree]}}, {{0, 
       0}, {-0.9980267284282716, 0.06279051952931337}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[{{0, 0}, {-1, 0}}]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Cos[Rational[18, 5] Degree], -Sin[Rational[18, 5] Degree]}}, {{0,
        0}, {-0.9980267284282716, -0.06279051952931337}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Cos[Rational[36, 5] Degree], -Sin[Rational[36, 5] Degree]}}, {{0,
        0}, {-0.9921147013144779, -0.12533323356430426`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Cos[Rational[54, 5] Degree], -Sin[Rational[54, 5] Degree]}}, {{0,
        0}, {-0.9822872507286887, -0.18738131458572463`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Cos[Rational[72, 5] Degree], -Sin[Rational[72, 5] Degree]}}, {{0,
        0}, {-0.9685831611286311, -0.2486898871648548}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2])}}, {{0, 
       0}, {-0.9510565162951535, -0.30901699437494745`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Cos[Rational[108, 5] Degree], -Sin[Rational[108, 5] Degree]}}, {{
       0, 0}, {-0.9297764858882515, -0.368124552684678}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Cos[Rational[126, 5] Degree], -Sin[Rational[126, 5] Degree]}}, {{
       0, 0}, {-0.9048270524660196, -0.42577929156507266`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Cos[Rational[144, 5] Degree], -Sin[Rational[144, 5] Degree]}}, {{
       0, 0}, {-0.8763066800438636, -0.4817536741017153}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Cos[Rational[162, 5] Degree], -Sin[Rational[162, 5] Degree]}}, {{
       0, 0}, {-0.8443279255020151, -0.5358267949789967}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Rational[1, 4] (-1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}}, {{0, 
       0}, {-0.8090169943749475, -0.5877852522924731}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Cos[Rational[198, 5] Degree], -Sin[Rational[198, 5] Degree]}}, {{
       0, 0}, {-0.7705132427757891, -0.6374239897486897}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Cos[Rational[216, 5] Degree], -Sin[Rational[216, 5] Degree]}}, {{
       0, 0}, {-0.7289686274214116, -0.6845471059286887}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Sin[Rational[216, 5] Degree], -Cos[Rational[216, 5] Degree]}}, {{
       0, 0}, {-0.6845471059286887, -0.7289686274214116}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Sin[Rational[198, 5] Degree], -Cos[Rational[198, 5] Degree]}}, {{
       0, 0}, {-0.6374239897486897, -0.7705132427757891}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{0, 
       0}, {-0.5877852522924731, -0.8090169943749475}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Sin[Rational[162, 5] Degree], -Cos[Rational[162, 5] Degree]}}, {{
       0, 0}, {-0.5358267949789967, -0.8443279255020151}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Sin[Rational[144, 5] Degree], -Cos[Rational[144, 5] Degree]}}, {{
       0, 0}, {-0.4817536741017153, -0.8763066800438636}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Sin[Rational[126, 5] Degree], -Cos[Rational[126, 5] Degree]}}, {{
       0, 0}, {-0.42577929156507266`, -0.9048270524660196}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Sin[Rational[108, 5] Degree], -Cos[Rational[108, 5] Degree]}}, {{
       0, 0}, {-0.368124552684678, -0.9297764858882515}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Rational[1, 4] (1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2]}}, {{0, 
       0}, {-0.30901699437494745`, -0.9510565162951535}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[
     NCache[{{0, 
       0}, {-Sin[Rational[72, 5] Degree], -Cos[Rational[72, 5] Degree]}}, {{0,
        0}, {-0.2486898871648548, -0.9685831611286311}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Sin[Rational[54, 5] Degree], -Cos[Rational[54, 5] Degree]}}, {{0,
        0}, {-0.18738131458572463`, -0.9822872507286887}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Sin[Rational[36, 5] Degree], -Cos[Rational[36, 5] Degree]}}, {{0,
        0}, {-0.12533323356430426`, -0.9921147013144779}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {-Sin[Rational[18, 5] Degree], -Cos[Rational[18, 5] Degree]}}, {{0,
        0}, {-0.06279051952931337, -0.9980267284282716}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[{{0, 0}, {0, -1}}]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Sin[Rational[18, 5] Degree], -Cos[Rational[18, 5] Degree]}}, {{0, 0}, {
       0.06279051952931337, -0.9980267284282716}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Sin[Rational[36, 5] Degree], -Cos[Rational[36, 5] Degree]}}, {{0, 0}, {
       0.12533323356430426`, -0.9921147013144779}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Sin[Rational[54, 5] Degree], -Cos[Rational[54, 5] Degree]}}, {{0, 0}, {
       0.18738131458572463`, -0.9822872507286887}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Sin[Rational[72, 5] Degree], -Cos[Rational[72, 5] Degree]}}, {{0, 0}, {
       0.2486898871648548, -0.9685831611286311}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Rational[1, 4] (-1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}}, {{0, 0}, {
       0.30901699437494745`, -0.9510565162951535}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Sin[Rational[108, 5] Degree], -Cos[Rational[108, 5] Degree]}}, {{0, 
       0}, {0.368124552684678, -0.9297764858882515}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Sin[Rational[126, 5] Degree], -Cos[Rational[126, 5] Degree]}}, {{0, 
       0}, {0.42577929156507266`, -0.9048270524660196}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Sin[Rational[144, 5] Degree], -Cos[Rational[144, 5] Degree]}}, {{0, 
       0}, {0.4817536741017153, -0.8763066800438636}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Sin[Rational[162, 5] Degree], -Cos[Rational[162, 5] Degree]}}, {{0, 
       0}, {0.5358267949789967, -0.8443279255020151}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{0, 0}, {
       0.5877852522924731, -0.8090169943749475}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Sin[Rational[198, 5] Degree], -Cos[Rational[198, 5] Degree]}}, {{0, 
       0}, {0.6374239897486897, -0.7705132427757891}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Sin[Rational[216, 5] Degree], -Cos[Rational[216, 5] Degree]}}, {{0, 
       0}, {0.6845471059286887, -0.7289686274214116}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Cos[Rational[216, 5] Degree], -Sin[Rational[216, 5] Degree]}}, {{0, 
       0}, {0.7289686274214116, -0.6845471059286887}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Cos[Rational[198, 5] Degree], -Sin[Rational[198, 5] Degree]}}, {{0, 
       0}, {0.7705132427757891, -0.6374239897486897}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Rational[1, 4] (1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}}, {{0, 0}, {
       0.8090169943749475, -0.5877852522924731}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Cos[Rational[162, 5] Degree], -Sin[Rational[162, 5] Degree]}}, {{0, 
       0}, {0.8443279255020151, -0.5358267949789967}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Cos[Rational[144, 5] Degree], -Sin[Rational[144, 5] Degree]}}, {{0, 
       0}, {0.8763066800438636, -0.4817536741017153}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Cos[Rational[126, 5] Degree], -Sin[Rational[126, 5] Degree]}}, {{0, 
       0}, {0.9048270524660196, -0.42577929156507266`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Cos[Rational[108, 5] Degree], -Sin[Rational[108, 5] Degree]}}, {{0, 
       0}, {0.9297764858882515, -0.368124552684678}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 
       0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2],
         Rational[1, 4] (1 - 5^Rational[1, 2])}}, {{0, 0}, {
       0.9510565162951535, -0.30901699437494745`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Cos[Rational[72, 5] Degree], -Sin[Rational[72, 5] Degree]}}, {{0, 0}, {
       0.9685831611286311, -0.2486898871648548}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Cos[Rational[54, 5] Degree], -Sin[Rational[54, 5] Degree]}}, {{0, 0}, {
       0.9822872507286887, -0.18738131458572463`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[
     NCache[{{0, 0}, {
       Cos[Rational[36, 5] Degree], -Sin[Rational[36, 5] Degree]}}, {{0, 0}, {
       0.9921147013144779, -0.12533323356430426`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.003], Arrowheads[Small], 
    ArrowBox[NCache[{{0, 0}, {
       Cos[Rational[18, 5] Degree], -Sin[Rational[18, 5] Degree]}}, {{0, 0}, {
       0.9980267284282716, -0.06279051952931337}}]]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {4., 1.}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {4.0548974332424, 1.0765148778399132`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {4.093792038822215, 1.148781243269858}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {4.116530317500479, 1.2165138939608444`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {4.123022531679379, 1.2794455200846997`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {4.113243059555561, 1.3373277592638377`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {4.087230496237684, 1.3899321767440989`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {4.045087501429151, 1.4370511669223605`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {3.9869803942771695`, 1.4784987726710077`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {3.913138496987057, 1.514111419225761}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {3.823853229792263, 1.543748559740539}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {3.7194769608518463`, 1.5672932299616513`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {3.600421615614335, 1.5846525098322726`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {3.4671570511361667`, 1.5957578902054532`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {3.320209201770548, 1.6005655432184263`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {3.16015800354484, 1.5990564952611575`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {2.9876351054180015`, 1.5912367018565154`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {2.8033213764507248`, 1.5771370241565448`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {2.60794421872631, 1.5568131071475972`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {2.4022746966269635`, 1.5303451600449922`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {2.1871244937949434`, 1.4978376397438893`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {1.9633427097880503`, 1.4594188385756437`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {1.7318125090715872`, 1.4152403779965854`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {1.493447635571695, 1.3654766102074016`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {1.249188806545525, 1.310323930064653}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {1., 1.25}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {0.7468646503110181, 1.184742891006026}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {0.49078176705726084`, 1.1148101430787931`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {0.2327619923857902, 1.0404777488251362`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-0.026176387530788103`, 0.962039064245934}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-0.2850114612046363, 0.8798036509939944}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-0.5427217248504604, 0.7940960546756364}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-0.7982901137942711, 0.7052545240174519}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-1.0507080163629978`, 0.6136296759531142}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-1.2989792544139716`, 0.5195831118985222}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-1.542124014794945, 0.4234859906762112}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-1.77918271621897, 0.32571756372104665`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-2.009219796293343, 0.22666367834807577`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-2.2313274037569575`, 0.12671525498944936`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-2.444628981354467, 0.02626674441007304}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-2.6482827252073164`, -0.07428542900935597}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-2.8414849070290638`, -0.17454443177826928`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-3.023473046073739, -0.27411458741671946`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-3.1935289182990054`, -0.3726029380096787}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-3.350981390868328, -0.469620795032404}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-3.4952090708056667`, -0.5647852733264692}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-3.6256427573496697`, -0.6577208021725626}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-3.74176768832903, -0.7480606074965329}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-3.8431255716936072`, -0.8354481593590976}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-3.9293163941837728`, -0.9195385790166298}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-4., -1.}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-4.0548974332424, -1.0765148778399132`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-4.093792038822215, -1.148781243269858}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-4.116530317500479, -1.2165138939608444`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-4.123022531679379, -1.2794455200846997`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-4.113243059555561, -1.3373277592638377`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-4.087230496237684, -1.3899321767440989`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-4.045087501429151, -1.4370511669223605`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-3.9869803942771695`, -1.4784987726710077`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-3.913138496987057, -1.514111419225761}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-3.823853229792263, -1.543748559740539}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-3.7194769608518463`, -1.5672932299616513`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-3.600421615614335, -1.5846525098322726`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-3.4671570511361667`, -1.5957578902054532`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-3.320209201770548, -1.6005655432184263`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-3.16015800354484, -1.5990564952611575`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-2.9876351054180015`, -1.5912367018565154`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-2.8033213764507248`, -1.5771370241565448`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-2.60794421872631, -1.5568131071475972`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-2.4022746966269635`, -1.5303451600449922`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-2.1871244937949434`, -1.4978376397438893`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-1.9633427097880503`, -1.4594188385756437`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-1.7318125090715872`, -1.4152403779965854`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-1.493447635571695, -1.3654766102074016`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-1.249188806545525, -1.310323930064653}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-1., -1.25}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-0.7468646503110181, -1.184742891006026}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-0.49078176705726084`, -1.1148101430787931`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-0.2327619923857902, -1.0404777488251362`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {0.026176387530788103`, -0.962039064245934}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {0.2850114612046363, -0.8798036509939944}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {0.5427217248504604, -0.7940960546756364}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {0.7982901137942711, -0.7052545240174519}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {1.0507080163629978`, -0.6136296759531142}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {1.2989792544139716`, -0.5195831118985222}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {1.542124014794945, -0.4234859906762112}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {1.77918271621897, -0.32571756372104665`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {2.009219796293343, -0.22666367834807577`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {2.2313274037569575`, -0.12671525498944936`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {2.444628981354467, -0.02626674441007304}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {2.6482827252073164`, 0.07428542900935597}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {2.8414849070290638`, 0.17454443177826928`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {3.023473046073739, 0.27411458741671946`}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {3.1935289182990054`, 0.3726029380096787}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {3.350981390868328, 0.469620795032404}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {3.4952090708056667`, 0.5647852733264692}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {3.6256427573496697`, 0.6577208021725626}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {3.74176768832903, 0.7480606074965329}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {3.8431255716936072`, 0.8354481593590976}}]}, 
   {GrayLevel[0.4], Thickness[0.003], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {3.9293163941837728`, 0.9195385790166298}}]}, 
   {GrayLevel[0], Thickness[0.007], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-4.113174859275266, -1.3375378867095824`}}]}, 
   {GrayLevel[0], Thickness[0.007], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {0.2859940157169399, -0.8794841679168898}}]}},
  BaseStyle->{FontFamily -> "Helvetica"}]], "Output",
 CellChangeTimes->{
  3.5634561548848343`*^9, 3.5634562099657297`*^9, 3.5634736196091456`*^9, 
   3.5634736587496147`*^9, 3.5634755812065916`*^9, 3.5634758201210113`*^9, 
   3.5634883831330185`*^9, {3.563488497122419*^9, 3.5634885168096533`*^9}, 
   3.5634885601777296`*^9, 3.5634886022822037`*^9, 3.5635534811423817`*^9, {
   3.563555401158557*^9, 3.563555430112208*^9}, 3.5635556510709963`*^9, 
   3.5635556870290594`*^9, 3.5635557273707304`*^9, 3.563894337087288*^9, 
   3.564775259984177*^9, 3.5648504973409133`*^9, 3.5671058905461473`*^9, 
   3.5671059210361905`*^9, 3.5671059790562716`*^9, 3.584470463596789*^9, 
   3.5844711615108147`*^9, 3.5844714597989388`*^9}],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{1, 0}, {
       Cos[Rational[18, 5] Degree], Sin[Rational[18, 5] Degree]}}, {{1, 0}, {
       0.9980267284282716, 0.06279051952931337}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Cos[Rational[18, 5] Degree], Sin[Rational[18, 5] Degree]}, {
       Cos[Rational[36, 5] Degree], Sin[Rational[36, 5] Degree]}}, {{
      0.9980267284282716, 0.06279051952931337}, {0.9921147013144779, 
      0.12533323356430426`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Cos[Rational[36, 5] Degree], Sin[Rational[36, 5] Degree]}, {
       Cos[Rational[54, 5] Degree], Sin[Rational[54, 5] Degree]}}, {{
      0.9921147013144779, 0.12533323356430426`}, {0.9822872507286887, 
      0.18738131458572463`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Cos[Rational[54, 5] Degree], Sin[Rational[54, 5] Degree]}, {
       Cos[Rational[72, 5] Degree], Sin[Rational[72, 5] Degree]}}, {{
      0.9822872507286887, 0.18738131458572463`}, {0.9685831611286311, 
      0.2486898871648548}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Cos[Rational[72, 5] Degree], Sin[
        Rational[72, 5] Degree]}, {(Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        Rational[1, 4] (-1 + 5^Rational[1, 2])}}, {{0.9685831611286311, 
      0.2486898871648548}, {0.9510565162951535, 0.30901699437494745`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2])}, {
       Cos[Rational[108, 5] Degree], Sin[Rational[108, 5] Degree]}}, {{
      0.9510565162951535, 0.30901699437494745`}, {0.9297764858882515, 
      0.368124552684678}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Cos[Rational[108, 5] Degree], Sin[Rational[108, 5] Degree]}, {
       Cos[Rational[126, 5] Degree], Sin[Rational[126, 5] Degree]}}, {{
      0.9297764858882515, 0.368124552684678}, {0.9048270524660196, 
      0.42577929156507266`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Cos[Rational[126, 5] Degree], Sin[Rational[126, 5] Degree]}, {
       Cos[Rational[144, 5] Degree], Sin[Rational[144, 5] Degree]}}, {{
      0.9048270524660196, 0.42577929156507266`}, {0.8763066800438636, 
      0.4817536741017153}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Cos[Rational[144, 5] Degree], Sin[Rational[144, 5] Degree]}, {
       Cos[Rational[162, 5] Degree], Sin[Rational[162, 5] Degree]}}, {{
      0.8763066800438636, 0.4817536741017153}, {0.8443279255020151, 
      0.5358267949789967}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Cos[Rational[162, 5] Degree], Sin[Rational[162, 5] Degree]}, {
       Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}}, {{
      0.8443279255020151, 0.5358267949789967}, {0.8090169943749475, 
      0.5877852522924731}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
       Cos[Rational[198, 5] Degree], Sin[Rational[198, 5] Degree]}}, {{
      0.8090169943749475, 0.5877852522924731}, {0.7705132427757891, 
      0.6374239897486897}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Cos[Rational[198, 5] Degree], Sin[Rational[198, 5] Degree]}, {
       Cos[Rational[216, 5] Degree], Sin[Rational[216, 5] Degree]}}, {{
      0.7705132427757891, 0.6374239897486897}, {0.7289686274214116, 
      0.6845471059286887}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Cos[Rational[216, 5] Degree], Sin[Rational[216, 5] Degree]}, {
       Sin[Rational[216, 5] Degree], Cos[Rational[216, 5] Degree]}}, {{
      0.7289686274214116, 0.6845471059286887}, {0.6845471059286887, 
      0.7289686274214116}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[
     NCache[{{Sin[Rational[216, 5] Degree], Cos[Rational[216, 5] Degree]}, {
       Sin[Rational[198, 5] Degree], Cos[Rational[198, 5] Degree]}}, {{
      0.6845471059286887, 0.7289686274214116}, {0.6374239897486897, 
      0.7705132427757891}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Sin[Rational[198, 5] Degree], Cos[
        Rational[198, 5] Degree]}, {(Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        Rational[1, 4] (1 + 5^Rational[1, 2])}}, {{0.6374239897486897, 
      0.7705132427757891}, {0.5877852522924731, 0.8090169943749475}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2])}, {
       Sin[Rational[162, 5] Degree], Cos[Rational[162, 5] Degree]}}, {{
      0.5877852522924731, 0.8090169943749475}, {0.5358267949789967, 
      0.8443279255020151}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Sin[Rational[162, 5] Degree], Cos[Rational[162, 5] Degree]}, {
       Sin[Rational[144, 5] Degree], Cos[Rational[144, 5] Degree]}}, {{
      0.5358267949789967, 0.8443279255020151}, {0.4817536741017153, 
      0.8763066800438636}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Sin[Rational[144, 5] Degree], Cos[Rational[144, 5] Degree]}, {
       Sin[Rational[126, 5] Degree], Cos[Rational[126, 5] Degree]}}, {{
      0.4817536741017153, 0.8763066800438636}, {0.42577929156507266`, 
      0.9048270524660196}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Sin[Rational[126, 5] Degree], Cos[Rational[126, 5] Degree]}, {
       Sin[Rational[108, 5] Degree], Cos[Rational[108, 5] Degree]}}, {{
      0.42577929156507266`, 0.9048270524660196}, {0.368124552684678, 
      0.9297764858882515}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Sin[Rational[108, 5] Degree], Cos[Rational[108, 5] Degree]}, {
       Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}}, {{
      0.368124552684678, 0.9297764858882515}, {0.30901699437494745`, 
      0.9510565162951535}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
       Sin[Rational[72, 5] Degree], Cos[Rational[72, 5] Degree]}}, {{
      0.30901699437494745`, 0.9510565162951535}, {0.2486898871648548, 
      0.9685831611286311}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Sin[Rational[72, 5] Degree], Cos[Rational[72, 5] Degree]}, {
       Sin[Rational[54, 5] Degree], Cos[Rational[54, 5] Degree]}}, {{
      0.2486898871648548, 0.9685831611286311}, {0.18738131458572463`, 
      0.9822872507286887}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Sin[Rational[54, 5] Degree], Cos[Rational[54, 5] Degree]}, {
       Sin[Rational[36, 5] Degree], Cos[Rational[36, 5] Degree]}}, {{
      0.18738131458572463`, 0.9822872507286887}, {0.12533323356430426`, 
      0.9921147013144779}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Sin[Rational[36, 5] Degree], Cos[Rational[36, 5] Degree]}, {
       Sin[Rational[18, 5] Degree], Cos[Rational[18, 5] Degree]}}, {{
      0.12533323356430426`, 0.9921147013144779}, {0.06279051952931337, 
      0.9980267284282716}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Sin[Rational[18, 5] Degree], Cos[Rational[18, 5] Degree]}, {0, 1}}, {{
       0.06279051952931337, 0.9980267284282716}, {0, 1}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{0, 
       1}, {-Sin[Rational[18, 5] Degree], Cos[Rational[18, 5] Degree]}}, {{0, 
       1}, {-0.06279051952931337, 0.9980267284282716}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Sin[Rational[18, 5] Degree], Cos[
        Rational[18, 5] Degree]}, {-Sin[Rational[36, 5] Degree], Cos[
        Rational[36, 5] Degree]}}, {{-0.06279051952931337, 
      0.9980267284282716}, {-0.12533323356430426`, 0.9921147013144779}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Sin[Rational[36, 5] Degree], Cos[
        Rational[36, 5] Degree]}, {-Sin[Rational[54, 5] Degree], Cos[
        Rational[54, 5] Degree]}}, {{-0.12533323356430426`, 
      0.9921147013144779}, {-0.18738131458572463`, 0.9822872507286887}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Sin[Rational[54, 5] Degree], Cos[
        Rational[54, 5] Degree]}, {-Sin[Rational[72, 5] Degree], Cos[
        Rational[72, 5] Degree]}}, {{-0.18738131458572463`, 
      0.9822872507286887}, {-0.2486898871648548, 0.9685831611286311}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Sin[Rational[72, 5] Degree], Cos[
        Rational[72, 5] Degree]}, {
       Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2]}}, {{-0.2486898871648548, 
      0.9685831611286311}, {-0.30901699437494745`, 0.9510565162951535}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {-
        Sin[Rational[108, 5] Degree], Cos[
        Rational[108, 5] Degree]}}, {{-0.30901699437494745`, 
      0.9510565162951535}, {-0.368124552684678, 0.9297764858882515}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Sin[Rational[108, 5] Degree], Cos[
        Rational[108, 5] Degree]}, {-Sin[Rational[126, 5] Degree], Cos[
        Rational[126, 5] Degree]}}, {{-0.368124552684678, 
      0.9297764858882515}, {-0.42577929156507266`, 0.9048270524660196}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Sin[Rational[126, 5] Degree], Cos[
        Rational[126, 5] Degree]}, {-Sin[Rational[144, 5] Degree], Cos[
        Rational[144, 5] Degree]}}, {{-0.42577929156507266`, 
      0.9048270524660196}, {-0.4817536741017153, 0.8763066800438636}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[
     NCache[{{-Sin[Rational[144, 5] Degree], Cos[Rational[144, 5] Degree]}, {-
        Sin[Rational[162, 5] Degree], Cos[
        Rational[162, 5] Degree]}}, {{-0.4817536741017153, 
      0.8763066800438636}, {-0.5358267949789967, 0.8443279255020151}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Sin[Rational[162, 5] Degree], Cos[
        Rational[162, 5] 
         Degree]}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], 
        Rational[1, 4] (1 + 5^Rational[1, 2])}}, {{-0.5358267949789967, 
      0.8443279255020151}, {-0.5877852522924731, 0.8090169943749475}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2])}, {-
        Sin[Rational[198, 5] Degree], Cos[
        Rational[198, 5] Degree]}}, {{-0.5877852522924731, 
      0.8090169943749475}, {-0.6374239897486897, 0.7705132427757891}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Sin[Rational[198, 5] Degree], Cos[
        Rational[198, 5] Degree]}, {-Sin[Rational[216, 5] Degree], Cos[
        Rational[216, 5] Degree]}}, {{-0.6374239897486897, 
      0.7705132427757891}, {-0.6845471059286887, 0.7289686274214116}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Sin[Rational[216, 5] Degree], Cos[
        Rational[216, 5] Degree]}, {-Cos[Rational[216, 5] Degree], Sin[
        Rational[216, 5] Degree]}}, {{-0.6845471059286887, 
      0.7289686274214116}, {-0.7289686274214116, 0.6845471059286887}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Cos[Rational[216, 5] Degree], Sin[
        Rational[216, 5] Degree]}, {-Cos[Rational[198, 5] Degree], Sin[
        Rational[198, 5] Degree]}}, {{-0.7289686274214116, 
      0.6845471059286887}, {-0.7705132427757891, 0.6374239897486897}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Cos[Rational[198, 5] Degree], Sin[
        Rational[198, 5] Degree]}, {
       Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2]}}, {{-0.7705132427757891, 
      0.6374239897486897}, {-0.8090169943749475, 0.5877852522924731}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {-
        Cos[Rational[162, 5] Degree], Sin[
        Rational[162, 5] Degree]}}, {{-0.8090169943749475, 
      0.5877852522924731}, {-0.8443279255020151, 0.5358267949789967}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Cos[Rational[162, 5] Degree], Sin[
        Rational[162, 5] Degree]}, {-Cos[Rational[144, 5] Degree], Sin[
        Rational[144, 5] Degree]}}, {{-0.8443279255020151, 
      0.5358267949789967}, {-0.8763066800438636, 0.4817536741017153}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Cos[Rational[144, 5] Degree], Sin[
        Rational[144, 5] Degree]}, {-Cos[Rational[126, 5] Degree], Sin[
        Rational[126, 5] Degree]}}, {{-0.8763066800438636, 
      0.4817536741017153}, {-0.9048270524660196, 0.42577929156507266`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Cos[Rational[126, 5] Degree], Sin[
        Rational[126, 5] Degree]}, {-Cos[Rational[108, 5] Degree], Sin[
        Rational[108, 5] Degree]}}, {{-0.9048270524660196, 
      0.42577929156507266`}, {-0.9297764858882515, 0.368124552684678}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Cos[Rational[108, 5] Degree], Sin[
        Rational[108, 5] 
         Degree]}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], 
        Rational[1, 4] (-1 + 5^Rational[1, 2])}}, {{-0.9297764858882515, 
      0.368124552684678}, {-0.9510565162951535, 0.30901699437494745`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2])}, {-
        Cos[Rational[72, 5] Degree], Sin[
        Rational[72, 5] Degree]}}, {{-0.9510565162951535, 
      0.30901699437494745`}, {-0.9685831611286311, 0.2486898871648548}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Cos[Rational[72, 5] Degree], Sin[
        Rational[72, 5] Degree]}, {-Cos[Rational[54, 5] Degree], Sin[
        Rational[54, 5] Degree]}}, {{-0.9685831611286311, 
      0.2486898871648548}, {-0.9822872507286887, 0.18738131458572463`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Cos[Rational[54, 5] Degree], Sin[
        Rational[54, 5] Degree]}, {-Cos[Rational[36, 5] Degree], Sin[
        Rational[36, 5] Degree]}}, {{-0.9822872507286887, 
      0.18738131458572463`}, {-0.9921147013144779, 0.12533323356430426`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Cos[Rational[36, 5] Degree], Sin[
        Rational[36, 5] Degree]}, {-Cos[Rational[18, 5] Degree], Sin[
        Rational[18, 5] Degree]}}, {{-0.9921147013144779, 
      0.12533323356430426`}, {-0.9980267284282716, 0.06279051952931337}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Cos[Rational[18, 5] Degree], Sin[
        Rational[18, 5] Degree]}, {-1, 0}}, {{-0.9980267284282716, 
       0.06279051952931337}, {-1, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-1, 
       0}, {-Cos[Rational[18, 5] Degree], -
        Sin[Rational[18, 5] Degree]}}, {{-1, 
       0}, {-0.9980267284282716, -0.06279051952931337}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Cos[Rational[18, 5] Degree], -
        Sin[Rational[18, 5] Degree]}, {-Cos[Rational[36, 5] Degree], -
        Sin[Rational[36, 5] 
          Degree]}}, {{-0.9980267284282716, -0.06279051952931337}, \
{-0.9921147013144779, -0.12533323356430426`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Cos[Rational[36, 5] Degree], -
        Sin[Rational[36, 5] Degree]}, {-Cos[Rational[54, 5] Degree], -
        Sin[Rational[54, 5] 
          Degree]}}, {{-0.9921147013144779, -0.12533323356430426`}, \
{-0.9822872507286887, -0.18738131458572463`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[
     NCache[{{-Cos[Rational[54, 5] Degree], -Sin[Rational[54, 5] Degree]}, {-
        Cos[Rational[72, 5] Degree], -
        Sin[Rational[72, 5] 
          Degree]}}, {{-0.9822872507286887, -0.18738131458572463`}, \
{-0.9685831611286311, -0.2486898871648548}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Cos[Rational[72, 5] Degree], -
        Sin[Rational[72, 5] Degree]}, {-(Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        Rational[1, 4] (1 - 5^
         Rational[
          1, 2])}}, {{-0.9685831611286311, -0.2486898871648548}, \
{-0.9510565162951535, -0.30901699437494745`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2])}, {-
        Cos[Rational[108, 5] Degree], -
        Sin[Rational[108, 5] 
          Degree]}}, {{-0.9510565162951535, -0.30901699437494745`}, \
{-0.9297764858882515, -0.368124552684678}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Cos[Rational[108, 5] Degree], -
        Sin[Rational[108, 5] Degree]}, {-Cos[Rational[126, 5] Degree], -
        Sin[Rational[126, 5] 
          Degree]}}, {{-0.9297764858882515, -0.368124552684678}, \
{-0.9048270524660196, -0.42577929156507266`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Cos[Rational[126, 5] Degree], -
        Sin[Rational[126, 5] Degree]}, {-Cos[Rational[144, 5] Degree], -
        Sin[Rational[144, 5] 
          Degree]}}, {{-0.9048270524660196, -0.42577929156507266`}, \
{-0.8763066800438636, -0.4817536741017153}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Cos[Rational[144, 5] Degree], -
        Sin[Rational[144, 5] Degree]}, {-Cos[Rational[162, 5] Degree], -
        Sin[Rational[162, 5] 
          Degree]}}, {{-0.8763066800438636, -0.4817536741017153}, \
{-0.8443279255020151, -0.5358267949789967}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Cos[Rational[162, 5] Degree], -
        Sin[Rational[162, 5] Degree]}, {
       Rational[1, 4] (-1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^
         Rational[
          1, 2]}}, {{-0.8443279255020151, -0.5358267949789967}, \
{-0.8090169943749475, -0.5877852522924731}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Rational[1, 4] (-1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {-
        Cos[Rational[198, 5] Degree], -
        Sin[Rational[198, 5] 
          Degree]}}, {{-0.8090169943749475, -0.5877852522924731}, \
{-0.7705132427757891, -0.6374239897486897}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Cos[Rational[198, 5] Degree], -
        Sin[Rational[198, 5] Degree]}, {-Cos[Rational[216, 5] Degree], -
        Sin[Rational[216, 5] 
          Degree]}}, {{-0.7705132427757891, -0.6374239897486897}, \
{-0.7289686274214116, -0.6845471059286887}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Cos[Rational[216, 5] Degree], -
        Sin[Rational[216, 5] Degree]}, {-Sin[Rational[216, 5] Degree], -
        Cos[Rational[216, 5] 
          Degree]}}, {{-0.7289686274214116, -0.6845471059286887}, \
{-0.6845471059286887, -0.7289686274214116}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Sin[Rational[216, 5] Degree], -
        Cos[Rational[216, 5] Degree]}, {-Sin[Rational[198, 5] Degree], -
        Cos[Rational[198, 5] 
          Degree]}}, {{-0.6845471059286887, -0.7289686274214116}, \
{-0.6374239897486897, -0.7705132427757891}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Sin[Rational[198, 5] Degree], -
        Cos[Rational[198, 5] Degree]}, {-(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        Rational[1, 4] (-1 - 5^
         Rational[
          1, 2])}}, {{-0.6374239897486897, -0.7705132427757891}, \
{-0.5877852522924731, -0.8090169943749475}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2])}, {-
        Sin[Rational[162, 5] Degree], -
        Cos[Rational[162, 5] 
          Degree]}}, {{-0.5877852522924731, -0.8090169943749475}, \
{-0.5358267949789967, -0.8443279255020151}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Sin[Rational[162, 5] Degree], -
        Cos[Rational[162, 5] Degree]}, {-Sin[Rational[144, 5] Degree], -
        Cos[Rational[144, 5] 
          Degree]}}, {{-0.5358267949789967, -0.8443279255020151}, \
{-0.4817536741017153, -0.8763066800438636}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Sin[Rational[144, 5] Degree], -
        Cos[Rational[144, 5] Degree]}, {-Sin[Rational[126, 5] Degree], -
        Cos[Rational[126, 5] 
          Degree]}}, {{-0.4817536741017153, -0.8763066800438636}, \
{-0.42577929156507266`, -0.9048270524660196}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Sin[Rational[126, 5] Degree], -
        Cos[Rational[126, 5] Degree]}, {-Sin[Rational[108, 5] Degree], -
        Cos[Rational[108, 5] 
          Degree]}}, {{-0.42577929156507266`, -0.9048270524660196}, \
{-0.368124552684678, -0.9297764858882515}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Sin[Rational[108, 5] Degree], -
        Cos[Rational[108, 5] Degree]}, {
       Rational[1, 4] (1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[
          1, 2]}}, {{-0.368124552684678, -0.9297764858882515}, \
{-0.30901699437494745`, -0.9510565162951535}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Rational[1, 4] (1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2]}, {-Sin[Rational[72, 5] Degree], -
        Cos[Rational[72, 5] 
          Degree]}}, {{-0.30901699437494745`, -0.9510565162951535}, \
{-0.2486898871648548, -0.9685831611286311}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Sin[Rational[72, 5] Degree], -
        Cos[Rational[72, 5] Degree]}, {-Sin[Rational[54, 5] Degree], -
        Cos[Rational[54, 5] 
          Degree]}}, {{-0.2486898871648548, -0.9685831611286311}, \
{-0.18738131458572463`, -0.9822872507286887}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Sin[Rational[54, 5] Degree], -
        Cos[Rational[54, 5] Degree]}, {-Sin[Rational[36, 5] Degree], -
        Cos[Rational[36, 5] 
          Degree]}}, {{-0.18738131458572463`, -0.9822872507286887}, \
{-0.12533323356430426`, -0.9921147013144779}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Sin[Rational[36, 5] Degree], -
        Cos[Rational[36, 5] Degree]}, {-Sin[Rational[18, 5] Degree], -
        Cos[Rational[18, 5] 
          Degree]}}, {{-0.12533323356430426`, -0.9921147013144779}, \
{-0.06279051952931337, -0.9980267284282716}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{-Sin[Rational[18, 5] Degree], -
        Cos[Rational[18, 5] Degree]}, {
       0, -1}}, {{-0.06279051952931337, -0.9980267284282716}, {0, -1}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{0, -1}, {
       Sin[Rational[18, 5] Degree], -Cos[Rational[18, 5] Degree]}}, {{
       0, -1}, {0.06279051952931337, -0.9980267284282716}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Sin[Rational[18, 5] Degree], -Cos[Rational[18, 5] Degree]}, {
       Sin[Rational[36, 5] Degree], -Cos[Rational[36, 5] Degree]}}, {{
      0.06279051952931337, -0.9980267284282716}, {
      0.12533323356430426`, -0.9921147013144779}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Sin[Rational[36, 5] Degree], -Cos[Rational[36, 5] Degree]}, {
       Sin[Rational[54, 5] Degree], -Cos[Rational[54, 5] Degree]}}, {{
      0.12533323356430426`, -0.9921147013144779}, {
      0.18738131458572463`, -0.9822872507286887}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Sin[Rational[54, 5] Degree], -Cos[Rational[54, 5] Degree]}, {
       Sin[Rational[72, 5] Degree], -Cos[Rational[72, 5] Degree]}}, {{
      0.18738131458572463`, -0.9822872507286887}, {
      0.2486898871648548, -0.9685831611286311}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[
     NCache[{{Sin[Rational[72, 5] Degree], -Cos[Rational[72, 5] Degree]}, {
       Rational[1, 4] (-1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}}, {{
      0.2486898871648548, -0.9685831611286311}, {
      0.30901699437494745`, -0.9510565162951535}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Rational[1, 4] (-1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
       Sin[Rational[108, 5] Degree], -Cos[Rational[108, 5] Degree]}}, {{
      0.30901699437494745`, -0.9510565162951535}, {
      0.368124552684678, -0.9297764858882515}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Sin[Rational[108, 5] Degree], -Cos[Rational[108, 5] Degree]}, {
       Sin[Rational[126, 5] Degree], -Cos[Rational[126, 5] Degree]}}, {{
      0.368124552684678, -0.9297764858882515}, {
      0.42577929156507266`, -0.9048270524660196}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Sin[Rational[126, 5] Degree], -Cos[Rational[126, 5] Degree]}, {
       Sin[Rational[144, 5] Degree], -Cos[Rational[144, 5] Degree]}}, {{
      0.42577929156507266`, -0.9048270524660196}, {
      0.4817536741017153, -0.8763066800438636}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Sin[Rational[144, 5] Degree], -Cos[Rational[144, 5] Degree]}, {
       Sin[Rational[162, 5] Degree], -Cos[Rational[162, 5] Degree]}}, {{
      0.4817536741017153, -0.8763066800438636}, {
      0.5358267949789967, -0.8443279255020151}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Sin[Rational[162, 5] Degree], -
        Cos[Rational[162, 5] Degree]}, {(Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        Rational[1, 4] (-1 - 5^Rational[1, 2])}}, {{
      0.5358267949789967, -0.8443279255020151}, {
      0.5877852522924731, -0.8090169943749475}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2])}, {
       Sin[Rational[198, 5] Degree], -Cos[Rational[198, 5] Degree]}}, {{
      0.5877852522924731, -0.8090169943749475}, {
      0.6374239897486897, -0.7705132427757891}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Sin[Rational[198, 5] Degree], -Cos[Rational[198, 5] Degree]}, {
       Sin[Rational[216, 5] Degree], -Cos[Rational[216, 5] Degree]}}, {{
      0.6374239897486897, -0.7705132427757891}, {
      0.6845471059286887, -0.7289686274214116}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Sin[Rational[216, 5] Degree], -Cos[Rational[216, 5] Degree]}, {
       Cos[Rational[216, 5] Degree], -Sin[Rational[216, 5] Degree]}}, {{
      0.6845471059286887, -0.7289686274214116}, {
      0.7289686274214116, -0.6845471059286887}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Cos[Rational[216, 5] Degree], -Sin[Rational[216, 5] Degree]}, {
       Cos[Rational[198, 5] Degree], -Sin[Rational[198, 5] Degree]}}, {{
      0.7289686274214116, -0.6845471059286887}, {
      0.7705132427757891, -0.6374239897486897}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Cos[Rational[198, 5] Degree], -Sin[Rational[198, 5] Degree]}, {
       Rational[1, 4] (1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}}, {{
      0.7705132427757891, -0.6374239897486897}, {
      0.8090169943749475, -0.5877852522924731}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Rational[1, 4] (1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
       Cos[Rational[162, 5] Degree], -Sin[Rational[162, 5] Degree]}}, {{
      0.8090169943749475, -0.5877852522924731}, {
      0.8443279255020151, -0.5358267949789967}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Cos[Rational[162, 5] Degree], -Sin[Rational[162, 5] Degree]}, {
       Cos[Rational[144, 5] Degree], -Sin[Rational[144, 5] Degree]}}, {{
      0.8443279255020151, -0.5358267949789967}, {
      0.8763066800438636, -0.4817536741017153}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Cos[Rational[144, 5] Degree], -Sin[Rational[144, 5] Degree]}, {
       Cos[Rational[126, 5] Degree], -Sin[Rational[126, 5] Degree]}}, {{
      0.8763066800438636, -0.4817536741017153}, {
      0.9048270524660196, -0.42577929156507266`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Cos[Rational[126, 5] Degree], -Sin[Rational[126, 5] Degree]}, {
       Cos[Rational[108, 5] Degree], -Sin[Rational[108, 5] Degree]}}, {{
      0.9048270524660196, -0.42577929156507266`}, {
      0.9297764858882515, -0.368124552684678}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Cos[Rational[108, 5] Degree], -
        Sin[Rational[108, 5] Degree]}, {(Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        Rational[1, 4] (1 - 5^Rational[1, 2])}}, {{
      0.9297764858882515, -0.368124552684678}, {
      0.9510565162951535, -0.30901699437494745`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2])}, {
       Cos[Rational[72, 5] Degree], -Sin[Rational[72, 5] Degree]}}, {{
      0.9510565162951535, -0.30901699437494745`}, {
      0.9685831611286311, -0.2486898871648548}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Cos[Rational[72, 5] Degree], -Sin[Rational[72, 5] Degree]}, {
       Cos[Rational[54, 5] Degree], -Sin[Rational[54, 5] Degree]}}, {{
      0.9685831611286311, -0.2486898871648548}, {
      0.9822872507286887, -0.18738131458572463`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Cos[Rational[54, 5] Degree], -Sin[Rational[54, 5] Degree]}, {
       Cos[Rational[36, 5] Degree], -Sin[Rational[36, 5] Degree]}}, {{
      0.9822872507286887, -0.18738131458572463`}, {
      0.9921147013144779, -0.12533323356430426`}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Cos[Rational[36, 5] Degree], -Sin[Rational[36, 5] Degree]}, {
       Cos[Rational[18, 5] Degree], -Sin[Rational[18, 5] Degree]}}, {{
      0.9921147013144779, -0.12533323356430426`}, {
      0.9980267284282716, -0.06279051952931337}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    LineBox[NCache[{{
       Cos[Rational[18, 5] Degree], -Sin[Rational[18, 5] Degree]}, {1, 0}}, {{
       0.9980267284282716, -0.06279051952931337}, {1, 0}}]]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{4., 1.}, {4.0548974332424, 1.0765148778399132`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{4.0548974332424, 1.0765148778399132`}, {4.093792038822215, 
     1.148781243269858}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{4.093792038822215, 1.148781243269858}, {4.116530317500479, 
     1.2165138939608444`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{4.116530317500479, 1.2165138939608444`}, {4.123022531679379, 
     1.2794455200846997`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{4.123022531679379, 1.2794455200846997`}, {4.113243059555561, 
     1.3373277592638377`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{4.113243059555561, 1.3373277592638377`}, {4.087230496237684, 
     1.3899321767440989`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{4.087230496237684, 1.3899321767440989`}, {4.045087501429151, 
     1.4370511669223605`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{4.045087501429151, 1.4370511669223605`}, {3.9869803942771695`, 
     1.4784987726710077`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{3.9869803942771695`, 1.4784987726710077`}, {3.913138496987057, 
     1.514111419225761}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{3.913138496987057, 1.514111419225761}, {3.823853229792263, 
     1.543748559740539}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{3.823853229792263, 1.543748559740539}, {3.7194769608518463`, 
     1.5672932299616513`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{3.7194769608518463`, 1.5672932299616513`}, {3.600421615614335, 
     1.5846525098322726`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{3.600421615614335, 1.5846525098322726`}, {3.4671570511361667`, 
     1.5957578902054532`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{3.4671570511361667`, 1.5957578902054532`}, {3.320209201770548, 
     1.6005655432184263`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{3.320209201770548, 1.6005655432184263`}, {3.16015800354484, 
     1.5990564952611575`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{3.16015800354484, 1.5990564952611575`}, {2.9876351054180015`, 
     1.5912367018565154`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{2.9876351054180015`, 1.5912367018565154`}, {2.8033213764507248`,
      1.5771370241565448`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{2.8033213764507248`, 1.5771370241565448`}, {2.60794421872631, 
     1.5568131071475972`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{2.60794421872631, 1.5568131071475972`}, {2.4022746966269635`, 
     1.5303451600449922`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{2.4022746966269635`, 1.5303451600449922`}, {2.1871244937949434`,
      1.4978376397438893`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{2.1871244937949434`, 1.4978376397438893`}, {1.9633427097880503`,
      1.4594188385756437`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{1.9633427097880503`, 1.4594188385756437`}, {1.7318125090715872`,
      1.4152403779965854`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{1.7318125090715872`, 1.4152403779965854`}, {1.493447635571695, 
     1.3654766102074016`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{1.493447635571695, 1.3654766102074016`}, {1.249188806545525, 
     1.310323930064653}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{1.249188806545525, 1.310323930064653}, {1., 1.25}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{1., 1.25}, {0.7468646503110181, 1.184742891006026}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{0.7468646503110181, 1.184742891006026}, {0.49078176705726084`, 
     1.1148101430787931`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{0.49078176705726084`, 1.1148101430787931`}, {0.2327619923857902,
      1.0404777488251362`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{0.2327619923857902, 
     1.0404777488251362`}, {-0.026176387530788103`, 0.962039064245934}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-0.026176387530788103`, 
     0.962039064245934}, {-0.2850114612046363, 0.8798036509939944}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-0.2850114612046363, 0.8798036509939944}, {-0.5427217248504604, 
     0.7940960546756364}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-0.5427217248504604, 0.7940960546756364}, {-0.7982901137942711, 
     0.7052545240174519}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-0.7982901137942711, 0.7052545240174519}, {-1.0507080163629978`,
      0.6136296759531142}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-1.0507080163629978`, 
     0.6136296759531142}, {-1.2989792544139716`, 0.5195831118985222}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-1.2989792544139716`, 0.5195831118985222}, {-1.542124014794945, 
     0.4234859906762112}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-1.542124014794945, 0.4234859906762112}, {-1.77918271621897, 
     0.32571756372104665`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-1.77918271621897, 0.32571756372104665`}, {-2.009219796293343, 
     0.22666367834807577`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-2.009219796293343, 
     0.22666367834807577`}, {-2.2313274037569575`, 0.12671525498944936`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-2.2313274037569575`, 
     0.12671525498944936`}, {-2.444628981354467, 0.02626674441007304}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-2.444628981354467, 
     0.02626674441007304}, {-2.6482827252073164`, -0.07428542900935597}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-2.6482827252073164`, -0.07428542900935597}, \
{-2.8414849070290638`, -0.17454443177826928`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-2.8414849070290638`, -0.17454443177826928`}, \
{-3.023473046073739, -0.27411458741671946`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-3.023473046073739, -0.27411458741671946`}, \
{-3.1935289182990054`, -0.3726029380096787}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-3.1935289182990054`, -0.3726029380096787}, \
{-3.350981390868328, -0.469620795032404}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-3.350981390868328, -0.469620795032404}, {-3.4952090708056667`, \
-0.5647852733264692}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-3.4952090708056667`, -0.5647852733264692}, \
{-3.6256427573496697`, -0.6577208021725626}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-3.6256427573496697`, -0.6577208021725626}, {-3.74176768832903, \
-0.7480606074965329}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-3.74176768832903, -0.7480606074965329}, {-3.8431255716936072`, \
-0.8354481593590976}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-3.8431255716936072`, -0.8354481593590976}, \
{-3.9293163941837728`, -0.9195385790166298}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-3.9293163941837728`, -0.9195385790166298}, {-4., -1.}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-4., -1.}, {-4.0548974332424, -1.0765148778399132`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-4.0548974332424, -1.0765148778399132`}, {-4.093792038822215, \
-1.148781243269858}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-4.093792038822215, -1.148781243269858}, {-4.116530317500479, \
-1.2165138939608444`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-4.116530317500479, -1.2165138939608444`}, {-4.123022531679379, \
-1.2794455200846997`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-4.123022531679379, -1.2794455200846997`}, {-4.113243059555561, \
-1.3373277592638377`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-4.113243059555561, -1.3373277592638377`}, {-4.087230496237684, \
-1.3899321767440989`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-4.087230496237684, -1.3899321767440989`}, {-4.045087501429151, \
-1.4370511669223605`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-4.045087501429151, -1.4370511669223605`}, \
{-3.9869803942771695`, -1.4784987726710077`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-3.9869803942771695`, -1.4784987726710077`}, \
{-3.913138496987057, -1.514111419225761}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-3.913138496987057, -1.514111419225761}, {-3.823853229792263, \
-1.543748559740539}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-3.823853229792263, -1.543748559740539}, {-3.7194769608518463`, \
-1.5672932299616513`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-3.7194769608518463`, -1.5672932299616513`}, \
{-3.600421615614335, -1.5846525098322726`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-3.600421615614335, -1.5846525098322726`}, \
{-3.4671570511361667`, -1.5957578902054532`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-3.4671570511361667`, -1.5957578902054532`}, \
{-3.320209201770548, -1.6005655432184263`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-3.320209201770548, -1.6005655432184263`}, {-3.16015800354484, \
-1.5990564952611575`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-3.16015800354484, -1.5990564952611575`}, \
{-2.9876351054180015`, -1.5912367018565154`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-2.9876351054180015`, -1.5912367018565154`}, \
{-2.8033213764507248`, -1.5771370241565448`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-2.8033213764507248`, -1.5771370241565448`}, \
{-2.60794421872631, -1.5568131071475972`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-2.60794421872631, -1.5568131071475972`}, \
{-2.4022746966269635`, -1.5303451600449922`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-2.4022746966269635`, -1.5303451600449922`}, \
{-2.1871244937949434`, -1.4978376397438893`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-2.1871244937949434`, -1.4978376397438893`}, \
{-1.9633427097880503`, -1.4594188385756437`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-1.9633427097880503`, -1.4594188385756437`}, \
{-1.7318125090715872`, -1.4152403779965854`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-1.7318125090715872`, -1.4152403779965854`}, \
{-1.493447635571695, -1.3654766102074016`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-1.493447635571695, -1.3654766102074016`}, {-1.249188806545525, \
-1.310323930064653}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-1.249188806545525, -1.310323930064653}, {-1., -1.25}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-1., -1.25}, {-0.7468646503110181, -1.184742891006026}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-0.7468646503110181, -1.184742891006026}, \
{-0.49078176705726084`, -1.1148101430787931`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-0.49078176705726084`, -1.1148101430787931`}, \
{-0.2327619923857902, -1.0404777488251362`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{-0.2327619923857902, -1.0404777488251362`}, {
     0.026176387530788103`, -0.962039064245934}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{0.026176387530788103`, -0.962039064245934}, {
     0.2850114612046363, -0.8798036509939944}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{0.2850114612046363, -0.8798036509939944}, {
     0.5427217248504604, -0.7940960546756364}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{0.5427217248504604, -0.7940960546756364}, {
     0.7982901137942711, -0.7052545240174519}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{0.7982901137942711, -0.7052545240174519}, {
     1.0507080163629978`, -0.6136296759531142}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{1.0507080163629978`, -0.6136296759531142}, {
     1.2989792544139716`, -0.5195831118985222}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{1.2989792544139716`, -0.5195831118985222}, {
     1.542124014794945, -0.4234859906762112}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{1.542124014794945, -0.4234859906762112}, {
     1.77918271621897, -0.32571756372104665`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{1.77918271621897, -0.32571756372104665`}, {
     2.009219796293343, -0.22666367834807577`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{2.009219796293343, -0.22666367834807577`}, {
     2.2313274037569575`, -0.12671525498944936`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{2.2313274037569575`, -0.12671525498944936`}, {
     2.444628981354467, -0.02626674441007304}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{2.444628981354467, -0.02626674441007304}, {2.6482827252073164`, 
     0.07428542900935597}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{2.6482827252073164`, 0.07428542900935597}, {2.8414849070290638`,
      0.17454443177826928`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{2.8414849070290638`, 0.17454443177826928`}, {3.023473046073739, 
     0.27411458741671946`}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{3.023473046073739, 0.27411458741671946`}, {3.1935289182990054`, 
     0.3726029380096787}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{3.1935289182990054`, 0.3726029380096787}, {3.350981390868328, 
     0.469620795032404}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{3.350981390868328, 0.469620795032404}, {3.4952090708056667`, 
     0.5647852733264692}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{3.4952090708056667`, 0.5647852733264692}, {3.6256427573496697`, 
     0.6577208021725626}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{3.6256427573496697`, 0.6577208021725626}, {3.74176768832903, 
     0.7480606074965329}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{3.74176768832903, 0.7480606074965329}, {3.8431255716936072`, 
     0.8354481593590976}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{3.8431255716936072`, 0.8354481593590976}, {3.9293163941837728`, 
     0.9195385790166298}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    LineBox[{{3.9293163941837728`, 0.9195385790166298}, {4., 1.}}]}, 
   {GrayLevel[0], Thickness[0.007], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {-4.113174859275266, -1.3375378867095824`}}]}, 
   {GrayLevel[0], Thickness[0.007], Arrowheads[Medium], 
    ArrowBox[{{0, 0}, {0.2859940157169399, -0.8794841679168898}}]}},
  BaseStyle->{FontFamily -> "Helvetica"}]], "Output",
 CellChangeTimes->{
  3.5634561548848343`*^9, 3.5634562099657297`*^9, 3.5634736196091456`*^9, 
   3.5634736587496147`*^9, 3.5634755812065916`*^9, 3.5634758201210113`*^9, 
   3.5634883831330185`*^9, {3.563488497122419*^9, 3.5634885168096533`*^9}, 
   3.5634885601777296`*^9, 3.5634886022822037`*^9, 3.5635534811423817`*^9, {
   3.563555401158557*^9, 3.563555430112208*^9}, 3.5635556510709963`*^9, 
   3.5635556870290594`*^9, 3.5635557273707304`*^9, 3.563894337087288*^9, 
   3.564775259984177*^9, 3.5648504973409133`*^9, 3.5671058905461473`*^9, 
   3.5671059210361905`*^9, 3.5671059790562716`*^9, 3.584470463596789*^9, 
   3.5844711615108147`*^9, 3.5844714598457384`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1112, 721},
WindowMargins->{{Automatic, 26}, {5, Automatic}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 673, 13, 135, "Subtitle"],
Cell[1255, 37, 881, 15, 219, "Subsubtitle"],
Cell[CellGroupData[{
Cell[2161, 56, 118, 4, 97, "Section"],
Cell[2282, 62, 1385, 27, 112, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3704, 94, 119, 4, 97, "Section"],
Cell[3826, 100, 1136, 32, 92, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4999, 137, 387, 7, 71, "Section"],
Cell[5389, 146, 2840, 57, 172, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8266, 208, 418, 7, 71, "Section"],
Cell[8687, 217, 188, 4, 45, "Text"],
Cell[CellGroupData[{
Cell[8900, 225, 17130, 419, 1232, "Input"],
Cell[CellGroupData[{
Cell[26055, 648, 5705, 110, 36, "Print"],
Cell[31763, 760, 3920, 65, 36, "Print"],
Cell[35686, 827, 4074, 68, 36, "Print"],
Cell[39763, 897, 4019, 68, 36, "Print"],
Cell[43785, 967, 3893, 65, 36, "Print"],
Cell[47681, 1034, 3559, 56, 23, "Print"],
Cell[51243, 1092, 3405, 51, 23, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[54709, 1150, 141, 2, 71, "Section"],
Cell[CellGroupData[{
Cell[54875, 1156, 25898, 588, 1452, "Input"],
Cell[CellGroupData[{
Cell[80798, 1748, 864, 23, 36, "Print"],
Cell[81665, 1773, 138, 1, 23, "Print"],
Cell[81806, 1776, 476, 10, 23, "Print"],
Cell[82285, 1788, 152, 2, 23, "Print"],
Cell[82440, 1792, 152, 2, 23, "Print"]
}, Open  ]],
Cell[82607, 1797, 45742, 805, 310, "Output"],
Cell[CellGroupData[{
Cell[128374, 2606, 163, 2, 23, "Print"],
Cell[128540, 2610, 640, 15, 23, "Print"],
Cell[129183, 2627, 152, 2, 23, "Print"],
Cell[129338, 2631, 156, 2, 23, "Print"]
}, Open  ]],
Cell[129509, 2636, 36863, 631, 164, "Output"],
Cell[166375, 3269, 47642, 920, 164, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
