(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    570639,       9916]
NotebookOptionsPosition[    567927,       9831]
NotebookOutlinePosition[    568270,       9846]
CellTagsIndexPosition[    568227,       9843]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.5844774675020905`*^9},
 FontFamily->"Arial"],

Cell[TextData[{
 "\n",
 StyleBox["Quadratic Forms for 2x2 matrices",
  FontWeight->"Bold"],
 "\n",
 StyleBox["The quadratic form for a matrix M is q = x^TMx.\nSuppose M is \
symmetric. If q>0 then M is positive definite and it will have real, positive \
eigenvalues and the eigenvalues are equal to the singular values in this \
case.\n(M does not have to be symmetric to be positive definite, but this is \
a standard restriction because we are interested in real eigenvalues.)\nThe \
action of the matrix, Mx, maps a circle to an ellipsoid (ellipse for 2d). The \
singular values/eigenvectors form the axis of this ellipsoid with the major \
and minor axes defined be the dominant and smallest singular values.\nThe \
ratio of the major to minor axis is a measure of the condition of the map.\n\n\
If M is symmetric, then the singular values have the same absolute value as \
the singular values.\nIf M is pos def, then the singular values equal the \
eigenvalues.",
  FontWeight->"Plain"]
}], "Subsubtitle",
 CellChangeTimes->{{3.563109257183752*^9, 3.563109368813145*^9}, {
  3.5631094023192024`*^9, 3.5631095936539345`*^9}, {3.563109632654003*^9, 
  3.5631096816940866`*^9}, {3.563109793290678*^9, 3.563109828533139*^9}, {
  3.5631118632806425`*^9, 3.563111906150715*^9}, {3.584477434679633*^9, 
  3.5844774351320343`*^9}}],

Cell[TextData[{
 "\n",
 StyleBox["This nb displays the following.",
  FontWeight->"Bold"],
 "\nPART I -- used for creating figures for PLA\n --  quadratic forms: enter \
matrix and then  (x,y,qform) is displayed over unit circle \n -- contour plot \
of qform. \n    Note that the dominant eigenvalue/vector is in the direction \
of greatest change of the qform, so the contour plot and the singular \
value-ellipse will be perpendicular\n \n PART II -- used for fun/explore\n -- \
CONS (curve on surface): the unit circle is mapped to the qform\n -- major \
and minor axes are displayed in the z=0 plane along with the ellipse \
representing the action of the matrix on a unit circle\n -- planes z=lambda_1 \
and z=lambda_2 are displayed. Note that the qform evaluated at an eigenvector \
results in a z-value equal the eigenvalue, therefore the planes should \
intersect the qform in these places.\n e.g., r1 is eigenvector. r1^T M r1 = \
r1^T (lamda1 x r1) = lamda1\n \nPlots are accompanyed by captions explaining \
what is displayed.\n \n SEE QuadraticForm.nb for more plots "
}], "Subsubtitle",
 CellChangeTimes->{{3.563019793318533*^9, 3.5630202126628695`*^9}, 
   3.563107961078686*^9, {3.5631079919263396`*^9, 3.563108045357233*^9}, {
   3.563108092828116*^9, 3.5631080994737277`*^9}, {3.5631293369404154`*^9, 
   3.563129360590057*^9}, {3.564851072794724*^9, 3.5648511802789125`*^9}, {
   3.5648515093926907`*^9, 3.5648515348519354`*^9}, {3.5648527433704586`*^9, 
   3.5648527554448795`*^9}, {3.5846309798814964`*^9, 3.584630980801898*^9}, {
   3.5846314337642937`*^9, 3.584631469332356*^9}}],

Cell[CellGroupData[{

Cell["Initialize for output", "Section",
 CellChangeTimes->{{3.5846310102703495`*^9, 3.584631021096769*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SetOptions", "[", 
     RowBox[{"ContourPlot", ",", 
      RowBox[{"BaseStyle", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"FontFamily", "->", "\"\<Helvetica\>\""}], ",", " ", 
         RowBox[{"FontSize", "\[Rule]", "18"}]}], "}"}]}]}], "]"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.562935344494604*^9, 3.5629353449626045`*^9}, {
   3.5629625917416315`*^9, 3.562962592272032*^9}, 3.5630206280291986`*^9, {
   3.5630473928460264`*^9, 3.563047398680437*^9}, 3.5630499400101023`*^9, 
   3.5630499822237763`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compute quadratic form given 2 x2 matrix and (x, y) pair", "Section",
 CellChangeTimes->{{3.5846310278515806`*^9, 3.5846310601124372`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"qform", "[", 
      RowBox[{"matrix_", ",", "x_", ",", "y_"}], "]"}], " ", ":=", " ", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ".", "matrix", ".", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}]}]}], " ", ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5625268410742383`*^9, 3.56252685904547*^9}, {
  3.5625268910567265`*^9, 3.5625269629572525`*^9}, {3.5630223183653855`*^9, 
  3.5630223220001917`*^9}, {3.56302274401484*^9, 3.5630228094413548`*^9}, {
  3.563024352486865*^9, 3.563024353391667*^9}, {3.563129626991725*^9, 
  3.5631296402205477`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Input a symmetric 2 x2 matrix -- load selection into m\
\>", "Section",
 CellChangeTimes->{{3.584631094416898*^9, 3.584631125039751*^9}, {
  3.5846311559434056`*^9, 3.584631157831009*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"2", "x2", " ", "symmetric", " ", 
    RowBox[{"matrices", " ", "--"}], " ", "no", " ", "need", " ", "to", " ", 
    "be", " ", "pos", " ", "def"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "These", " ", "are", " ", "the", " ", "examples", " ", "in", " ", 
    "quadratic", " ", "form", " ", "section", " ", "of", " ", "PLA"}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ellipse1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0.5"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hyper1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0.5"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"parab1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"just", " ", "for", " ", "play"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"any", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.25", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1.25"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Choose", " ", "one", " ", "matrix", " ", "from", " ", "above", " ", "to",
      " ", "work", " ", "with"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m", " ", "=", " ", "any"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.562527977099434*^9, 3.562528030170727*^9}, {
   3.5626246659103155`*^9, 3.5626247088259907`*^9}, {3.5628482185450497`*^9, 
   3.5628482474519005`*^9}, {3.5628483525180845`*^9, 
   3.5628483676969113`*^9}, {3.5628483997393675`*^9, 3.562848419192602*^9}, {
   3.5628513968391533`*^9, 3.562851399647158*^9}, {3.562851864044374*^9, 
   3.5628518686463823`*^9}, {3.562851903621643*^9, 3.5628519314364924`*^9}, {
   3.56293986255894*^9, 3.56293988563138*^9}, {3.562952880109372*^9, 
   3.562952885226181*^9}, 3.5629546922865553`*^9, {3.562954764093481*^9, 
   3.5629547730790973`*^9}, {3.5629548438096213`*^9, 
   3.5629548460716257`*^9}, {3.562954892356907*^9, 3.5629549083001347`*^9}, {
   3.562954947830604*^9, 3.5629549526198125`*^9}, {3.56295504795158*^9, 
   3.5629550516019864`*^9}, {3.562955439153467*^9, 3.5629554687779193`*^9}, {
   3.5629555810981164`*^9, 3.562955583516121*^9}, {3.5629556205037856`*^9, 
   3.5629556239669914`*^9}, {3.5629558280933504`*^9, 
   3.5629558386545687`*^9}, {3.5629626079032593`*^9, 
   3.5629626415213184`*^9}, {3.5630207529542184`*^9, 
   3.5630207539370203`*^9}, {3.5630218511649475`*^9, 
   3.5630218780749946`*^9}, {3.5630219782115707`*^9, 3.563021979459573*^9}, {
   3.563022957423215*^9, 3.563022958312416*^9}, {3.56302450319873*^9, 
   3.5630245044467325`*^9}, 3.5630247607239823`*^9, 3.563025016611232*^9, {
   3.563045227721823*^9, 3.56304523174663*^9}, 3.5630452821191187`*^9, {
   3.5630454068101377`*^9, 3.5630454293989773`*^9}, 3.563046282127675*^9, {
   3.5630464314511375`*^9, 3.5630464524955745`*^9}, {3.563046707587222*^9, 
   3.5630467081644235`*^9}, {3.5630468730255127`*^9, 3.563046877705521*^9}, {
   3.5630486643562593`*^9, 3.563048665479461*^9}, {3.563048746287603*^9, 
   3.5630487478008056`*^9}, {3.5630500352030697`*^9, 3.563050036139071*^9}, {
   3.563050069064328*^9, 3.563050070359131*^9}, {3.563107635659331*^9, 
   3.5631076369073334`*^9}, {3.5631076717697926`*^9, 
   3.5631076788834047`*^9}, {3.56310812359137*^9, 3.563108134168189*^9}, {
   3.5631110662704735`*^9, 3.5631110675340757`*^9}, {3.5631111644218445`*^9, 
   3.5631111682438507`*^9}, {3.5631112118147273`*^9, 
   3.5631112853456545`*^9}, {3.5631114652743587`*^9, 3.5631115358380804`*^9}, 
   3.5631115779205523`*^9, {3.5631116336418476`*^9, 3.5631116338966484`*^9}, {
   3.5631119425583773`*^9, 3.563111944985181*^9}, {3.5631129782293596`*^9, 
   3.5631129988057957`*^9}, {3.5631130555554905`*^9, 
   3.5631130573494935`*^9}, {3.5631136879789944`*^9, 3.563113689960198*^9}, {
   3.5631277390182533`*^9, 3.5631277408746567`*^9}, {3.5631299494538918`*^9, 
   3.5631299507642937`*^9}, {3.5631300411700525`*^9, 3.563130064351693*^9}, {
   3.5631307246848555`*^9, 3.5631307725301394`*^9}, 3.5633729849331164`*^9, 
   3.564843491150599*^9, {3.564843527654663*^9, 3.5648435279822636`*^9}, {
   3.564843636246454*^9, 3.5648436649505043`*^9}, {3.5648508606031513`*^9, 
   3.564850860930752*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Computation of SVD, eigen things, and action ellipse semi-major and minor axes\
\>", "Section",
 CellChangeTimes->{{3.5846311696246295`*^9, 3.5846312325395403`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Check", " ", "for", " ", "symmetric", " ", "matrix", " ", "and", " ", 
    "if", " ", "it", " ", "is", " ", "pos", " ", "def"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"m", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "2"}], "]"}], "]"}], " ", "\[NotEqual]", " ", 
       RowBox[{"m", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "1"}], "]"}], "]"}]}], ",", " ", 
      RowBox[{
      "Print", "[", 
       "\"\<STOP! Enter a symmetric matrix to ensure real evalues!\>\"", 
       "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Det", "[", "m", "]"}], " ", ">", "0"}], ",", 
      RowBox[{"Print", "[", "\"\<Matrix is positive definite\>\"", "]"}], ",", 
      RowBox[{
      "Print", "[", "\"\<Matrix is not positive definite\>\"", "]"}]}], "]"}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "SVD", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", ",", "sigma", ",", "v"}], "}"}], " ", "=", " ", 
     RowBox[{"SingularValueDecomposition", "[", "m", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<matrix m=\>\"", ",", 
      RowBox[{"MatrixForm", "[", "m", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<SVD(m) =>\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<U=    \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "u", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<V=    \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "v", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Sigma=\>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "sigma", "]"}], "//", "N"}]}], "]"}], ";"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Evals", " ", "and", " ", "vectors", " ", "another", " ", "way"}],
     " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"evals", " ", "=", " ", 
     RowBox[{"Eigenvalues", "[", "m", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"lambda", " ", "=", " ", 
     RowBox[{"DiagonalMatrix", "[", "evals", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"evecs", " ", "=", " ", 
     RowBox[{"Eigenvectors", "[", "m", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"evecs", "[", 
        RowBox[{"[", "i", "]"}], "]"}], " ", "=", " ", 
       RowBox[{
        RowBox[{"evecs", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "/", 
        RowBox[{"Norm", "[", 
         RowBox[{"evecs", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "]"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "2"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Evals = \>\"", ",", 
      RowBox[{"evals", "//", "N"}], ",", "\"\< as matrix = \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "lambda", "]"}], "//", "N"}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Evecs (rows) = \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "evecs", "]"}], "//", "N"}]}], "]"}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "evecs", " ", "returned", " ", "in", " ", "transpose", " ", "form"}], 
     ",", " ", 
     RowBox[{
     "so", " ", "that", " ", "refleced", " ", "in", " ", "R", " ", "and", " ", 
      RowBox[{"R", "^", "T"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Check decomposition: m = R.Lambda.R^T = \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", 
        RowBox[{
         RowBox[{"Transpose", "[", "evecs", "]"}], ".", "lambda", ".", 
         "evecs"}], "]"}], "//", "N"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", 
     "\"\<Notice variation is sign of eigenvectors that are returned from SVD \
or Eign*\>\"", "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"--", 
       RowBox[{"--", " ", "this"}]}], " ", "is", " ", "ellipse", " ", "that", 
      " ", "aligns", " ", "with", " ", 
      RowBox[{"evecs", " ", "--"}]}], "-"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Create", " ", "an", " ", "Ellipse", " ", "with", " ", "major", " ", 
      "axis", " ", "on", " ", "x"}], "-", 
     RowBox[{
     "axis", " ", "defined", " ", "by", " ", "singular", " ", "values"}]}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "and", " ", "then", " ", "rotate", " ", "it", " ", "by", " ", 
     "eigenvalues", " ", "in", " ", "the", " ", "SVD"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ellipsedata", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"sigma", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "1"}], "]"}], "]"}], "*", 
          RowBox[{"Cos", "[", "alpha", "]"}]}], ",", 
         RowBox[{
          RowBox[{"sigma", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "2"}], "]"}], "]"}], "*", 
          RowBox[{"Sin", "[", "alpha", "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"alpha", ",", "0", ",", 
         RowBox[{"2", "*", "Pi"}], ",", "0.2"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"numedata", " ", "=", " ", 
     RowBox[{"Length", "[", "ellipsedata", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "want", " ", "xhat", " ", "on", " ", "ellipse", " ", "from", " ", "x", 
      " ", "in", " ", "standard", " ", 
      RowBox[{"position", ":", " ", "xhat"}]}], "  ", "=", " ", 
     RowBox[{"U", ".", "x"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Since", " ", "ellipse", " ", "data", " ", "row", " ", "by", " ", 
      "row"}], ",", " ", 
     RowBox[{"use", " ", 
      RowBox[{
       RowBox[{"x", "^", "T"}], ".", 
       RowBox[{"U", "^", "T"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Eigenvectors", " ", "are", " ", "in", " ", "row", " ", "format"}], ",", 
     " ", 
     RowBox[{"so", " ", "switch", " ", "that", " ", 
      RowBox[{"too", " ", "--"}], " ", "dont", " ", "use", " ", "T"}]}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ellipsedata", " ", "=", " ", 
     RowBox[{"ellipsedata", ".", "evecs"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ellipse3d", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ellipsedata", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
         RowBox[{"ellipsedata", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", "0"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numedata"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", " ", 
    RowBox[{
    "create", " ", "major", " ", "and", " ", "minor", " ", "axis", " ", "in", 
     " ", "2", "d", " ", "and", " ", "3", "d"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "could", " ", "use", " ", "the", " ", "lambda", " ", "here", " ", "as", 
      " ", "well"}], ";", " ", 
     RowBox[{"sign", " ", "is", " ", "only", " ", "difference"}]}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"major2d", " ", "=", " ", 
     RowBox[{
      RowBox[{"sigma", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], "*", 
      RowBox[{"evecs", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"major3d", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"major2d", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"major2d", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", "0"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"minor2d", " ", "=", " ", 
     RowBox[{
      RowBox[{"sigma", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "2"}], "]"}], "]"}], "*", 
      RowBox[{"evecs", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"minor3d", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"minor2d", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"minor2d", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", "0"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<major=\>\"", ",", 
      RowBox[{"major2d", "//", "N"}], ",", "\"\<  minor=\>\"", ",", 
      RowBox[{"minor2d", "//", "N"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "set", " ", "of", " ", "unit", " ", "vectors"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Select", " ", "number", " ", "of", " ", "unit", " ", "vectors", " ", 
     "to", " ", "project", " ", "onto"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"numu", " ", "=", " ", "100"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"origin", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"e1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"e2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"degrees", " ", "=", " ", 
     RowBox[{"360", "/", "numu"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"units", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"RotationMatrix", "[", 
         RowBox[{"degrees", "*", 
          RowBox[{"(", 
           RowBox[{"i", "-", "1"}], ")"}], " ", "Degree"}], "]"}], ".", 
        "e1"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numu"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"units3d", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"units", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
         RowBox[{"units", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numu"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Action", " ", "of", " ", 
     RowBox[{"matrix", ":", " ", 
      RowBox[{
      "Multiply", " ", "each", " ", "unit", " ", "vector", " ", "times", " ", 
       "matrix", " ", "m"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mu", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"m", ".", 
        RowBox[{"units", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numu"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mu3d", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"mu", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
         RowBox[{"mu", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numu"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Create", " ", "a", " ", "curve", " ", "on", " ", "the", " ", "surface"}],
     "  ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"For", " ", "each", " ", "vector", " ", "evaluate", " ", 
     RowBox[{"x", "^", "TAx"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cons3d", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"units", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
         RowBox[{"units", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
         RowBox[{"qform", "[", 
          RowBox[{"m", ",", 
           RowBox[{"units", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
           RowBox[{"units", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "2"}], "]"}], "]"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numu"}], "}"}]}], "]"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.5625265986810126`*^9, 3.562526638601483*^9}, {
   3.5625268060521765`*^9, 3.5625268933187304`*^9}, {3.5625269897580996`*^9, 
   3.562526991848503*^9}, {3.5625270459805984`*^9, 3.562527062859828*^9}, {
   3.5625271371315584`*^9, 3.562527140844365*^9}, {3.562527171810419*^9, 
   3.562527256674568*^9}, {3.5625272931786327`*^9, 3.562527376513979*^9}, {
   3.562527418103652*^9, 3.5625275318590517`*^9}, {3.562527721945386*^9, 
   3.56252779283191*^9}, {3.562527834936384*^9, 3.56252786691644*^9}, {
   3.562527914808524*^9, 3.56252792387214*^9}, {3.5625279833082447`*^9, 
   3.562527990203457*^9}, {3.5625280206547103`*^9, 3.5625280491715603`*^9}, {
   3.5626247123983974`*^9, 3.562624712819598*^9}, {3.5628482525687094`*^9, 
   3.56284825305231*^9}, {3.56284849206033*^9, 3.5628485136819677`*^9}, {
   3.5628510001304564`*^9, 3.562851066617773*^9}, {3.562851403328765*^9, 
   3.5628514363228226`*^9}, {3.5628517021316895`*^9, 3.562851818601494*^9}, {
   3.562935187363274*^9, 3.562935210864769*^9}, {3.562935658803956*^9, 
   3.562935701938032*^9}, {3.562935737303294*^9, 3.5629358704339275`*^9}, {
   3.5629359249716234`*^9, 3.5629359585116825`*^9}, {3.562936085355505*^9, 
   3.5629361249483747`*^9}, {3.5629361551812277`*^9, 3.562936174447262*^9}, {
   3.562936341539155*^9, 3.5629363485903673`*^9}, {3.562936461550166*^9, 
   3.562936514527859*^9}, {3.5629375970449605`*^9, 3.562937613066189*^9}, {
   3.5629376730014935`*^9, 3.5629376847951145`*^9}, 3.562937948669578*^9, {
   3.562938284569368*^9, 3.5629383060350056`*^9}, {3.562938354894292*^9, 
   3.562938387701149*^9}, {3.562938488602126*^9, 3.562938552718239*^9}, {
   3.562938679218861*^9, 3.562938748592183*^9}, {3.562939055865923*^9, 
   3.5629390767855597`*^9}, {3.5629391093428164`*^9, 
   3.5629391264248466`*^9}, {3.562939188232155*^9, 3.562939284359524*^9}, {
   3.5629395350363646`*^9, 3.562939539466772*^9}, {3.562939594082468*^9, 
   3.562939834900091*^9}, {3.562939946112686*^9, 3.562939956174704*^9}, {
   3.5629400150804076`*^9, 3.562940024409224*^9}, {3.5629403613074155`*^9, 
   3.5629404665452003`*^9}, {3.5629405047184677`*^9, 
   3.5629405967898293`*^9}, {3.5629406646031485`*^9, 
   3.5629406667871523`*^9}, {3.5629410097849545`*^9, 3.562941078269075*^9}, {
   3.5629415135265646`*^9, 3.562941591011901*^9}, {3.562941629824769*^9, 
   3.5629416843000646`*^9}, {3.5629417588525953`*^9, 3.562941817929899*^9}, {
   3.562941864901582*^9, 3.5629418686143885`*^9}, {3.562941946567725*^9, 
   3.562941987954598*^9}, {3.5629420363302827`*^9, 3.562942037110284*^9}, {
   3.5629420696675415`*^9, 3.562942082459564*^9}, {3.5629421352032566`*^9, 
   3.5629421903805532`*^9}, {3.562942235636233*^9, 3.56294226254628*^9}, {
   3.5629422948227367`*^9, 3.5629423062419567`*^9}, {3.562942339142415*^9, 
   3.562942386566498*^9}, {3.562942418312554*^9, 3.5629424222125607`*^9}, {
   3.562943160452657*^9, 3.5629432116051474`*^9}, {3.562943245020406*^9, 
   3.5629432920076885`*^9}, 3.5629433588694057`*^9, {3.56294361740866*^9, 
   3.5629437726757326`*^9}, {3.562943850519869*^9, 3.562943851845872*^9}, {
   3.562943895182748*^9, 3.5629439806084976`*^9}, {3.5629440219797707`*^9, 
   3.5629440476574154`*^9}, {3.562944103115513*^9, 3.562944107889121*^9}, {
   3.5629441556096053`*^9, 3.5629441626920176`*^9}, {3.5629442200065184`*^9, 
   3.562944223703725*^9}, {3.562952779785596*^9, 3.562952788334411*^9}, {
   3.562952869938154*^9, 3.56295287308936*^9}, {3.5629529676411257`*^9, 
   3.562952971478733*^9}, {3.5629530101824007`*^9, 3.5629530105880013`*^9}, {
   3.562953056171282*^9, 3.5629531224245977`*^9}, {3.5629532502356224`*^9, 
   3.5629533903862686`*^9}, {3.562953599442236*^9, 3.5629536505947256`*^9}, {
   3.5629537395616817`*^9, 3.562953744616091*^9}, {3.562953794192978*^9, 
   3.5629537998869877`*^9}, {3.562954104711523*^9, 3.5629541083307295`*^9}, {
   3.5629541680632343`*^9, 3.562954210276909*^9}, {3.562954254284586*^9, 
   3.562954258980194*^9}, {3.562954435775305*^9, 3.5629545274254656`*^9}, {
   3.562954634207653*^9, 3.562954637655259*^9}, 3.5629550272035437`*^9, {
   3.562955221470685*^9, 3.5629552356979094`*^9}, {3.5629553739921527`*^9, 
   3.5629553941317883`*^9}, {3.5629556649794636`*^9, 3.562955689533907*^9}, 
   3.5629557473476086`*^9, {3.562955801620104*^9, 3.5629558249577446`*^9}, {
   3.5629626386665134`*^9, 3.5629626581197476`*^9}, {3.562962920855409*^9, 
   3.562962943350649*^9}, {3.562962980634714*^9, 3.5629630624412575`*^9}, 
   3.5629631505034122`*^9, 3.562963224962343*^9, {3.5629633583269777`*^9, 
   3.5629633595281796`*^9}, 3.5629634150486774`*^9, {3.562971424966525*^9, 
   3.5629714293969326`*^9}, {3.563019131892971*^9, 3.5630191375557814`*^9}, {
   3.5630191774138513`*^9, 3.5630192123111124`*^9}, {3.5630192800620317`*^9, 
   3.5630193090936823`*^9}, {3.563019352758159*^9, 3.5630193605893726`*^9}, {
   3.5630194725195694`*^9, 3.563019473252771*^9}, {3.563019516776847*^9, 
   3.563019517213648*^9}, {3.563019547852102*^9, 3.563019558881321*^9}, {
   3.563019611235013*^9, 3.5630196763027277`*^9}, {3.5630197070815816`*^9, 
   3.5630197861737204`*^9}, {3.563020265359762*^9, 3.5630203922659845`*^9}, {
   3.563020521761812*^9, 3.5630205223546133`*^9}, {3.563020580605116*^9, 
   3.563020584349122*^9}, {3.5630206613976574`*^9, 3.563020666233666*^9}, {
   3.5630206983697224`*^9, 3.5630207176669564`*^9}, {3.563020812998724*^9, 
   3.5630208246207447`*^9}, {3.5630209153817034`*^9, 3.563020931075331*^9}, {
   3.5630218225544972`*^9, 3.5630218348161187`*^9}, {3.5630219002270336`*^9, 
   3.5630219161858616`*^9}, {3.5630220087096243`*^9, 
   3.5630220949465756`*^9}, {3.563022417848963*^9, 3.5630224736970615`*^9}, {
   3.563022508894125*^9, 3.5630225129813323`*^9}, {3.563022857427039*^9, 
   3.563022911886735*^9}, {3.56302437825811*^9, 3.563024400098149*^9}, {
   3.5630245341023846`*^9, 3.5630245372535896`*^9}, {3.5630245674240427`*^9, 
   3.563024570341248*^9}, {3.563024602258904*^9, 3.5630246923802624`*^9}, {
   3.563027080182856*^9, 3.5630270813840585`*^9}, {3.563027113598115*^9, 
   3.563027126280937*^9}, {3.5630271800854316`*^9, 3.563027253733161*^9}, {
   3.5630273223108816`*^9, 3.5630275376692595`*^9}, {3.5630276212386065`*^9, 
   3.563027702202749*^9}, {3.5630277364604087`*^9, 3.5630277384104123`*^9}, {
   3.563027803540527*^9, 3.5630278124169426`*^9}, {3.5630278875154743`*^9, 
   3.563027893084684*^9}, {3.563029271924306*^9, 3.5630295382479734`*^9}, {
   3.5630296076056957`*^9, 3.5630296123481035`*^9}, {3.563029643860159*^9, 
   3.5630296441877594`*^9}, {3.5630297454319377`*^9, 
   3.5630297841980057`*^9}, {3.5630298296720853`*^9, 
   3.5630298360992966`*^9}, {3.5630298662385497`*^9, 3.5630298987802067`*^9}, 
   3.563044599608452*^9, 3.5630450903635817`*^9, {3.563045150080487*^9, 
   3.563045201404577*^9}, {3.5630457174846835`*^9, 3.563045779120392*^9}, {
   3.5630458359356914`*^9, 3.563045867619347*^9}, {3.5630465994790325`*^9, 
   3.5630466061402445`*^9}, {3.5630471765828466`*^9, 3.563047219482922*^9}, {
   3.5630472528825808`*^9, 3.5630472574845886`*^9}, {3.5630473246271067`*^9, 
   3.5630473706471877`*^9}, {3.563047751802657*^9, 3.563047755780664*^9}, {
   3.5630478119407625`*^9, 3.5630478454496217`*^9}, {3.563047965304632*^9, 
   3.5630480575163937`*^9}, {3.5630480976864643`*^9, 
   3.5630481031776743`*^9}, {3.5630483461185007`*^9, 
   3.5630483592693243`*^9}, {3.563048402949401*^9, 3.563048403729402*^9}, 
   3.5630485265676174`*^9, {3.5630485720260973`*^9, 3.5630485817293143`*^9}, {
   3.563049919028065*^9, 3.563049925658077*^9}, {3.5631065644520226`*^9, 
   3.563106567955223*^9}, {3.563109842013562*^9, 3.563109966426976*^9}, {
   3.563110016914663*^9, 3.5631101294912586`*^9}, {3.5631101707941275`*^9, 
   3.5631102424866486`*^9}, {3.5631114044434557`*^9, 3.563111444570324*^9}, {
   3.5631115804165564`*^9, 3.5631115924285774`*^9}, {3.5631116232670307`*^9, 
   3.5631116245150323`*^9}, {3.5631117161571903`*^9, 3.563111816042161*^9}, {
   3.563112052957365*^9, 3.5631120538153667`*^9}, {3.5631120983410435`*^9, 
   3.563112115501074*^9}, {3.5631121632691574`*^9, 3.563112174361576*^9}, {
   3.563112229478071*^9, 3.5631122380580864`*^9}, {3.5631122705845423`*^9, 
   3.5631123421894674`*^9}, {3.563112380971134*^9, 3.563112414632393*^9}, {
   3.5631124955241303`*^9, 3.5631127002512836`*^9}, {3.5631127333261404`*^9, 
   3.5631127803786216`*^9}, {3.563113139168031*^9, 3.5631133131259365`*^9}, {
   3.563113346463195*^9, 3.563113354466009*^9}, {3.5631276750269403`*^9, 
   3.563127704729393*^9}, {3.563127965671051*^9, 3.5631280451999907`*^9}, {
   3.5631280917816725`*^9, 3.5631280955100794`*^9}, 3.563128150225375*^9, {
   3.563128218444295*^9, 3.563128234855524*^9}, {3.563128416437667*^9, 
   3.5631284475441213`*^9}, {3.5631287854326468`*^9, 3.563128823309513*^9}, {
   3.5631289349433093`*^9, 3.5631289366281123`*^9}, {3.5631294499314137`*^9, 
   3.5631294705546503`*^9}, {3.5631296640105896`*^9, 3.563129685788228*^9}, 
   3.563129775815986*^9, {3.5631298631449394`*^9, 3.563129868339749*^9}, {
   3.5631304509355745`*^9, 3.5631304666604023`*^9}, {3.563373097463274*^9, 
   3.5633731463233423`*^9}, {3.563373199503417*^9, 3.563373217403442*^9}, {
   3.5634017291248074`*^9, 3.5634017856593065`*^9}, {3.564843880558483*^9, 
   3.5648439526462097`*^9}, {3.5648440313171473`*^9, 3.564844035326355*^9}, {
   3.564850781713813*^9, 3.564850814895071*^9}, {3.5648509087760363`*^9, 
   3.564850913362444*^9}, {3.564851637390916*^9, 3.5648518457760816`*^9}, {
   3.564851890735361*^9, 3.5648520119007735`*^9}, {3.5648521277777767`*^9, 
   3.564852164999442*^9}, {3.564852474098385*^9, 3.5648525013048334`*^9}, {
   3.564852558884534*^9, 3.5648525953573985`*^9}, {3.56485264187668*^9, 
   3.5648527084419966`*^9}, {3.584631303036064*^9, 3.584631336856923*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

Plotting\
\>", "Section",
 CellChangeTimes->{{3.5846313414589314`*^9, 3.584631348712944*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"--", 
    RowBox[{"--", 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", " ", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"PLOTTING", " ", "--"}], "--"}], "--"}], "--"}], 
                    "--"}], "--"}], "--"}], "--"}], "--"}], "--"}], "--"}], 
              "--"}]}]}]}]}]}]}]}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Choose", " ", "x"}], ",", 
    RowBox[{
     RowBox[{"y", " ", 
      RowBox[{"extents", " ", "--"}]}], " ", "+", 
     RowBox[{"range", " ", "to"}], " ", "-", 
     RowBox[{
      RowBox[{"range", " ", "--"}], " ", "for", " ", "plotting", " ", "and", 
      " ", "matrix", " ", "from", " ", "above"}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"range", " ", "=", " ", "1"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Quadratic", " ", "form", " ", "surface"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"qsurface3d", " ", "=", " ", 
     RowBox[{"Plot3D", "[", 
      RowBox[{
       RowBox[{"qform", "[", 
        RowBox[{"m", ",", "x", ",", "y"}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "range"}], ",", "range"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "range"}], ",", "range"}], "}"}], ",", " ", 
       RowBox[{"RegionFunction", "\[Rule]", 
        RowBox[{"Function", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "^", "2"}], "+", 
            RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "1"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Mesh", "\[Rule]", "None"}], ",", " ", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.7", "]"}], ",", " ", 
          RowBox[{"Opacity", "[", "0.8", "]"}], ",", " ", 
          RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]}]}], 
      " ", "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"curve", " ", "on", " ", "surface"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotcons3d", " ", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Blue", ",", 
         RowBox[{"Thickness", "[", "0.003", "]"}], ",", " ", 
         RowBox[{"Line", "[", 
          RowBox[{"{", "cons3d", "}"}], "]"}]}], "}"}], ",", 
       RowBox[{"Boxed", "\[Rule]", "True"}], ",", " ", 
       RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "plot", " ", "unit", " ", "vectors", " ", "as", " ", "a", " ", "circle"}],
     " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ulines3d", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"i", " ", "\[LessEqual]", " ", "numu"}], ",", 
         RowBox[{"Graphics3D", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "0.007", "]"}], ",", " ", "Yellow", ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"units3d", "[", 
                RowBox[{"[", 
                 RowBox[{"i", "-", "1"}], "]"}], "]"}], ",", " ", 
               RowBox[{"units3d", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Graphics3D", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "0.007", "]"}], ",", " ", "Yellow", ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"units3d", "[", 
                RowBox[{"[", "numu", "]"}], "]"}], ",", " ", 
               RowBox[{"units3d", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
          "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "2", ",", 
         RowBox[{"numu", "+", "1"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "plot", " ", "semi", " ", "major", " ", "and", " ", "minor", " ", 
     "axes"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotmmaxes", " ", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "0.005", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "major3d"}], "}"}],
          "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "minor3d"}], "}"}],
          "]"}]}], "}"}], "]"}]}], ";"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"plot", " ", "action", " ", 
     RowBox[{"ellipse", " ", "--"}], " ", "matrix", " ", "applied", " ", "to",
      " ", "unit", " ", "vectors", " ", "u"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mulines3d", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"i", " ", "\[LessEqual]", " ", "numu"}], ",", 
         RowBox[{"Graphics3D", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", 
            RowBox[{"GrayLevel", "[", "0.4", "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"mu3d", "[", 
                RowBox[{"[", 
                 RowBox[{"i", "-", "1"}], "]"}], "]"}], ",", " ", 
               RowBox[{"mu3d", "[", 
                RowBox[{"[", "i", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Graphics3D", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "0.005", "]"}], ",", " ", 
            RowBox[{"GrayLevel", "[", "0.4", "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"mu3d", "[", 
                RowBox[{"[", "numu", "]"}], "]"}], ",", " ", 
               RowBox[{"mu3d", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
          "]"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "2", ",", 
         RowBox[{"numu", "+", "1"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"plot", " ", "x", " ", "and", " ", "y", " ", "axes"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rad", " ", "=", " ", "0.015"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotaxes", " ", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", " ", 
       RowBox[{"Black", ",", 
        RowBox[{"Arrowheads", "[", "0.03", "]"}], ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"Tube", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", "rad"}],
           "]"}], "]"}], ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"Tube", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], ",", "rad"}],
           "]"}], "]"}]}], "}"}], "]"}]}], ";"}], " ", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Plotting", " ", "z"}], "=", 
     RowBox[{"constant", " ", "planes"}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"extents", " ", "of", " ", 
      RowBox[{"plane", " ", "--"}], " ", "plotting", " ", "surface", " ", 
      "over", " ", "unit", " ", "circle"}], ",", " ", 
     RowBox[{"so", " ", "make", " ", "plane", " ", "same", " ", "idea"}]}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"val", " ", "=", " ", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"create", " ", "plane", " ", "at", " ", "z"}], "=", 
     RowBox[{"lambda_", "1"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"zval", " ", "=", " ", 
     RowBox[{"lambda", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotplane3d", " ", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EdgeForm", "[", "Thin", "]"}], ",", "Yellow", ",", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "val"}], ",", "val", ",", "zval"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"val", ",", "val", ",", "zval"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"val", ",", 
             RowBox[{"-", "val"}], ",", "zval"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "val"}], ",", 
             RowBox[{"-", "val"}], ",", "zval"}], "}"}]}], "}"}], "]"}]}], 
       "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"create", " ", "plane", " ", "at", " ", "z"}], "=", 
     RowBox[{"lambda_", "2"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"zval2", " ", "=", " ", 
     RowBox[{"lambda", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "2"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotplane23d", " ", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EdgeForm", "[", "Thin", "]"}], ",", "Green", ",", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "val"}], ",", "val", ",", "zval2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"val", ",", "val", ",", "zval2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"val", ",", 
             RowBox[{"-", "val"}], ",", "zval2"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "val"}], ",", 
             RowBox[{"-", "val"}], ",", "zval2"}], "}"}]}], "}"}], "]"}]}], 
       "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"create", " ", "plane", " ", "at", " ", "z"}], "=", "1"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotplanez13d", " ", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"EdgeForm", "[", "Thin", "]"}], ",", "LightGreen", ",", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "val"}], ",", "val", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"val", ",", "val", ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"val", ",", 
             RowBox[{"-", "val"}], ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "val"}], ",", 
             RowBox[{"-", "val"}], ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}],
       "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"-", " ", "Play"}]}]}], " ", "with", " ", 
      RowBox[{"ellipses", " ", "--"}]}], "-"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"parametric", " ", "eqn", " ", "of", " ", "ellipse"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotellipsepara", " ", "=", " ", 
     RowBox[{"ParametricPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"sigma", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "1"}], "]"}], "]"}], "*", 
          RowBox[{"Cos", "[", "alpha", "]"}]}], ",", 
         RowBox[{
          RowBox[{"sigma", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "2"}], "]"}], "]"}], "*", 
          RowBox[{"Sin", "[", "alpha", "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"alpha", ",", "0", ",", 
         RowBox[{"2", "*", "Pi"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "implicit", " ", "equation", " ", "of", " ", "ellipse", " ", "that", " ", 
     "is", " ", "contour", " ", "in", " ", "quadratic", " ", "form"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sigma", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1"}], "]"}], "]"}], "^", "2"}], ")"}]}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", " ", "=", " ", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sigma", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "2"}], "]"}], "]"}], "^", "2"}], ")"}]}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotellipseimplicit", " ", "=", " ", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"a", "*", 
              RowBox[{"x", "^", "2"}]}]}], ")"}], "/", "b"}], "]"}], ",", 
         RowBox[{"-", 
          RowBox[{"Sqrt", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", 
              RowBox[{"a", "*", 
               RowBox[{"x", "^", "2"}]}]}], ")"}], "/", "b"}], "]"}]}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"1", "/", "a"}], "]"}]}], ",", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"1", "/", "a"}], "]"}]}], "}"}], ",", " ", 
       RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5625265986810126`*^9, 3.562526638601483*^9}, {
   3.5625268060521765`*^9, 3.5625268933187304`*^9}, {3.5625269897580996`*^9, 
   3.562526991848503*^9}, {3.5625270459805984`*^9, 3.562527062859828*^9}, {
   3.5625271371315584`*^9, 3.562527140844365*^9}, {3.562527171810419*^9, 
   3.562527256674568*^9}, {3.5625272931786327`*^9, 3.562527376513979*^9}, {
   3.562527418103652*^9, 3.5625275318590517`*^9}, {3.562527721945386*^9, 
   3.56252779283191*^9}, {3.562527834936384*^9, 3.56252786691644*^9}, {
   3.562527914808524*^9, 3.56252792387214*^9}, {3.5625279833082447`*^9, 
   3.562527990203457*^9}, {3.5625280206547103`*^9, 3.5625280491715603`*^9}, {
   3.5626247123983974`*^9, 3.562624712819598*^9}, {3.5628482525687094`*^9, 
   3.56284825305231*^9}, {3.56284849206033*^9, 3.5628485136819677`*^9}, {
   3.5628510001304564`*^9, 3.562851066617773*^9}, {3.562851403328765*^9, 
   3.5628514363228226`*^9}, {3.5628517021316895`*^9, 3.562851818601494*^9}, {
   3.562935187363274*^9, 3.562935210864769*^9}, {3.562935658803956*^9, 
   3.562935701938032*^9}, {3.562935737303294*^9, 3.5629358704339275`*^9}, {
   3.5629359249716234`*^9, 3.5629359585116825`*^9}, {3.562936085355505*^9, 
   3.5629361249483747`*^9}, {3.5629361551812277`*^9, 3.562936174447262*^9}, {
   3.562936341539155*^9, 3.5629363485903673`*^9}, {3.562936461550166*^9, 
   3.562936514527859*^9}, {3.5629375970449605`*^9, 3.562937613066189*^9}, {
   3.5629376730014935`*^9, 3.5629376847951145`*^9}, 3.562937948669578*^9, {
   3.562938284569368*^9, 3.5629383060350056`*^9}, {3.562938354894292*^9, 
   3.562938387701149*^9}, {3.562938488602126*^9, 3.562938552718239*^9}, {
   3.562938679218861*^9, 3.562938748592183*^9}, {3.562939055865923*^9, 
   3.5629390767855597`*^9}, {3.5629391093428164`*^9, 
   3.5629391264248466`*^9}, {3.562939188232155*^9, 3.562939284359524*^9}, {
   3.5629395350363646`*^9, 3.562939539466772*^9}, {3.562939594082468*^9, 
   3.562939834900091*^9}, {3.562939946112686*^9, 3.562939956174704*^9}, {
   3.5629400150804076`*^9, 3.562940024409224*^9}, {3.5629403613074155`*^9, 
   3.5629404665452003`*^9}, {3.5629405047184677`*^9, 
   3.5629405967898293`*^9}, {3.5629406646031485`*^9, 
   3.5629406667871523`*^9}, {3.5629410097849545`*^9, 3.562941078269075*^9}, {
   3.5629415135265646`*^9, 3.562941591011901*^9}, {3.562941629824769*^9, 
   3.5629416843000646`*^9}, {3.5629417588525953`*^9, 3.562941817929899*^9}, {
   3.562941864901582*^9, 3.5629418686143885`*^9}, {3.562941946567725*^9, 
   3.562941987954598*^9}, {3.5629420363302827`*^9, 3.562942037110284*^9}, {
   3.5629420696675415`*^9, 3.562942082459564*^9}, {3.5629421352032566`*^9, 
   3.5629421903805532`*^9}, {3.562942235636233*^9, 3.56294226254628*^9}, {
   3.5629422948227367`*^9, 3.5629423062419567`*^9}, {3.562942339142415*^9, 
   3.562942386566498*^9}, {3.562942418312554*^9, 3.5629424222125607`*^9}, {
   3.562943160452657*^9, 3.5629432116051474`*^9}, {3.562943245020406*^9, 
   3.5629432920076885`*^9}, 3.5629433588694057`*^9, {3.56294361740866*^9, 
   3.5629437726757326`*^9}, {3.562943850519869*^9, 3.562943851845872*^9}, {
   3.562943895182748*^9, 3.5629439806084976`*^9}, {3.5629440219797707`*^9, 
   3.5629440476574154`*^9}, {3.562944103115513*^9, 3.562944107889121*^9}, {
   3.5629441556096053`*^9, 3.5629441626920176`*^9}, {3.5629442200065184`*^9, 
   3.562944223703725*^9}, {3.562952779785596*^9, 3.562952788334411*^9}, {
   3.562952869938154*^9, 3.56295287308936*^9}, {3.5629529676411257`*^9, 
   3.562952971478733*^9}, {3.5629530101824007`*^9, 3.5629530105880013`*^9}, {
   3.562953056171282*^9, 3.5629531224245977`*^9}, {3.5629532502356224`*^9, 
   3.5629533903862686`*^9}, {3.562953599442236*^9, 3.5629536505947256`*^9}, {
   3.5629537395616817`*^9, 3.562953744616091*^9}, {3.562953794192978*^9, 
   3.5629537998869877`*^9}, {3.562954104711523*^9, 3.5629541083307295`*^9}, {
   3.5629541680632343`*^9, 3.562954210276909*^9}, {3.562954254284586*^9, 
   3.562954258980194*^9}, {3.562954435775305*^9, 3.5629545274254656`*^9}, {
   3.562954634207653*^9, 3.562954637655259*^9}, 3.5629550272035437`*^9, {
   3.562955221470685*^9, 3.5629552356979094`*^9}, {3.5629553739921527`*^9, 
   3.5629553941317883`*^9}, {3.5629556649794636`*^9, 3.562955689533907*^9}, 
   3.5629557473476086`*^9, {3.562955801620104*^9, 3.5629558249577446`*^9}, {
   3.5629626386665134`*^9, 3.5629626581197476`*^9}, {3.562962920855409*^9, 
   3.562962943350649*^9}, {3.562962980634714*^9, 3.5629630624412575`*^9}, 
   3.5629631505034122`*^9, 3.562963224962343*^9, {3.5629633583269777`*^9, 
   3.5629633595281796`*^9}, 3.5629634150486774`*^9, {3.562971424966525*^9, 
   3.5629714293969326`*^9}, {3.563019131892971*^9, 3.5630191375557814`*^9}, {
   3.5630191774138513`*^9, 3.5630192123111124`*^9}, {3.5630192800620317`*^9, 
   3.5630193090936823`*^9}, {3.563019352758159*^9, 3.5630193605893726`*^9}, {
   3.5630194725195694`*^9, 3.563019473252771*^9}, {3.563019516776847*^9, 
   3.563019517213648*^9}, {3.563019547852102*^9, 3.563019558881321*^9}, {
   3.563019611235013*^9, 3.5630196763027277`*^9}, {3.5630197070815816`*^9, 
   3.5630197861737204`*^9}, {3.563020265359762*^9, 3.5630203922659845`*^9}, {
   3.563020521761812*^9, 3.5630205223546133`*^9}, {3.563020580605116*^9, 
   3.563020584349122*^9}, {3.5630206613976574`*^9, 3.563020666233666*^9}, {
   3.5630206983697224`*^9, 3.5630207176669564`*^9}, {3.563020812998724*^9, 
   3.5630208246207447`*^9}, {3.5630209153817034`*^9, 3.563020931075331*^9}, {
   3.5630218225544972`*^9, 3.5630218348161187`*^9}, {3.5630219002270336`*^9, 
   3.5630219161858616`*^9}, {3.5630220087096243`*^9, 
   3.5630220949465756`*^9}, {3.563022417848963*^9, 3.5630224736970615`*^9}, {
   3.563022508894125*^9, 3.5630225129813323`*^9}, {3.563022857427039*^9, 
   3.563022911886735*^9}, {3.56302437825811*^9, 3.563024400098149*^9}, {
   3.5630245341023846`*^9, 3.5630245372535896`*^9}, {3.5630245674240427`*^9, 
   3.563024570341248*^9}, {3.563024602258904*^9, 3.5630246923802624`*^9}, {
   3.563027080182856*^9, 3.5630270813840585`*^9}, {3.563027113598115*^9, 
   3.563027126280937*^9}, {3.5630271800854316`*^9, 3.563027253733161*^9}, {
   3.5630273223108816`*^9, 3.5630275376692595`*^9}, {3.5630276212386065`*^9, 
   3.563027702202749*^9}, {3.5630277364604087`*^9, 3.5630277384104123`*^9}, {
   3.563027803540527*^9, 3.5630278124169426`*^9}, {3.5630278875154743`*^9, 
   3.563027893084684*^9}, {3.563029271924306*^9, 3.5630295382479734`*^9}, {
   3.5630296076056957`*^9, 3.5630296123481035`*^9}, {3.563029643860159*^9, 
   3.5630296441877594`*^9}, {3.5630297454319377`*^9, 
   3.5630297841980057`*^9}, {3.5630298296720853`*^9, 
   3.5630298360992966`*^9}, {3.5630298662385497`*^9, 3.5630298987802067`*^9}, 
   3.563044599608452*^9, 3.5630450903635817`*^9, {3.563045150080487*^9, 
   3.563045201404577*^9}, {3.5630457174846835`*^9, 3.563045779120392*^9}, {
   3.5630458359356914`*^9, 3.563045867619347*^9}, {3.5630465994790325`*^9, 
   3.5630466061402445`*^9}, {3.5630471765828466`*^9, 3.563047219482922*^9}, {
   3.5630472528825808`*^9, 3.5630472574845886`*^9}, {3.5630473246271067`*^9, 
   3.5630473706471877`*^9}, {3.563047751802657*^9, 3.563047755780664*^9}, {
   3.5630478119407625`*^9, 3.5630478454496217`*^9}, {3.563047965304632*^9, 
   3.5630480575163937`*^9}, {3.5630480976864643`*^9, 
   3.5630481031776743`*^9}, {3.5630483461185007`*^9, 
   3.5630483592693243`*^9}, {3.563048402949401*^9, 3.563048403729402*^9}, 
   3.5630485265676174`*^9, {3.5630485720260973`*^9, 3.5630485817293143`*^9}, {
   3.563049919028065*^9, 3.563049925658077*^9}, {3.5631065644520226`*^9, 
   3.563106567955223*^9}, {3.563109842013562*^9, 3.563109966426976*^9}, {
   3.563110016914663*^9, 3.5631101294912586`*^9}, {3.5631101707941275`*^9, 
   3.5631102424866486`*^9}, {3.5631114044434557`*^9, 3.563111444570324*^9}, {
   3.5631115804165564`*^9, 3.5631115924285774`*^9}, {3.5631116232670307`*^9, 
   3.5631116245150323`*^9}, {3.5631117161571903`*^9, 3.563111816042161*^9}, {
   3.563112052957365*^9, 3.5631120538153667`*^9}, {3.5631120983410435`*^9, 
   3.563112115501074*^9}, {3.5631121632691574`*^9, 3.563112174361576*^9}, {
   3.563112229478071*^9, 3.5631122380580864`*^9}, {3.5631122705845423`*^9, 
   3.5631123421894674`*^9}, {3.563112380971134*^9, 3.563112414632393*^9}, {
   3.5631124955241303`*^9, 3.5631127002512836`*^9}, {3.5631127333261404`*^9, 
   3.5631127803786216`*^9}, {3.563113139168031*^9, 3.5631133131259365`*^9}, {
   3.563113346463195*^9, 3.563113354466009*^9}, {3.5631276750269403`*^9, 
   3.563127704729393*^9}, {3.563127965671051*^9, 3.5631280451999907`*^9}, {
   3.5631280917816725`*^9, 3.5631280955100794`*^9}, 3.563128150225375*^9, {
   3.563128218444295*^9, 3.563128234855524*^9}, {3.563128416437667*^9, 
   3.5631284475441213`*^9}, {3.5631287854326468`*^9, 3.563128823309513*^9}, {
   3.5631289349433093`*^9, 3.5631289366281123`*^9}, {3.5631294499314137`*^9, 
   3.5631294705546503`*^9}, {3.5631296640105896`*^9, 3.563129685788228*^9}, 
   3.563129775815986*^9, {3.5631298631449394`*^9, 3.563129868339749*^9}, {
   3.5631304509355745`*^9, 3.5631304666604023`*^9}, {3.563373097463274*^9, 
   3.5633731463233423`*^9}, {3.563373199503417*^9, 3.563373217403442*^9}, {
   3.5634017291248074`*^9, 3.5634017856593065`*^9}, {3.564843880558483*^9, 
   3.5648439526462097`*^9}, {3.5648440313171473`*^9, 3.564844035326355*^9}, {
   3.564850781713813*^9, 3.564850814895071*^9}, {3.5648509087760363`*^9, 
   3.564850913362444*^9}, {3.564851637390916*^9, 3.5648518457760816`*^9}, {
   3.564851890735361*^9, 3.5648520119007735`*^9}, {3.5648521277777767`*^9, 
   3.564852164999442*^9}, {3.564852474098385*^9, 3.5648525013048334`*^9}, {
   3.564852558884534*^9, 3.5648525953573985`*^9}, {3.56485264187668*^9, 
   3.5648527084419966`*^9}, {3.584631303036064*^9, 3.5846314127198563`*^9}, {
   3.584631499596409*^9, 3.584631655487483*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Display the graphics constructions from above ", "Section",
 CellChangeTimes->{{3.5846316626010957`*^9, 3.584631673162314*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"--", 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"-", " ", 
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"DISPLAY", " ", "--"}], "--"}], "--"}], "--"}], 
                    "--"}], "--"}], "--"}], "--"}], "--"}], "--"}], 
                  "--"}]}]}]}]}]}]}]}]}]}]}]}]}]}], "-"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Print", "[", "\"\<   \>\"", "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"PLOTS", " ", "FOR", " ", "PLA", " ", "FIGURES"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", "\"\<Quadratic Form x^T M x over the unit circle\>\"", 
     "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"qsurface3d", ",", "plotaxes", ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}], ",", " ", 
     RowBox[{"Axes", "\[Rule]", "False"}], ",", " ", 
     RowBox[{"ViewPoint", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", "4"}], ",", "2"}], "}"}]}], ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"BoxRatios", "\[Rule]", "Automatic"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", 
     "\"\<Contour plot of quadratic Form x^T M x over the unit circle\>\"", 
     "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"qform", "[", 
       RowBox[{"m", ",", "x", ",", "y"}], "]"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "range"}], ",", "range"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "range"}], ",", "range"}], "}"}], ",", " ", 
     RowBox[{"RegionFunction", "\[Rule]", 
      RowBox[{"Function", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "2"}], "+", 
          RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "1"}]}], "]"}]}], ",", 
     RowBox[{"ColorFunction", "\[Rule]", 
      RowBox[{"ColorData", "[", "\"\<GrayTones\>\"", "]"}]}], ",", 
     RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
     RowBox[{"ContourStyle", "\[Rule]", 
      RowBox[{"Opacity", "[", "0", "]"}]}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", "None"}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", "None"}], 
         "}"}]}], "}"}]}], ",", " ", 
     RowBox[{"FrameStyle", "\[Rule]", "Thick"}], ",", 
     RowBox[{"FrameTicksStyle", "\[Rule]", "Thick"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"FUN", " ", "PLOTS"}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Plane", " ", "should", " ", "touch", " ", "quadratic", " ", "form", " ", 
     "function", " ", "value", " ", "associated", " ", "with", " ", "major", 
     " ", "axis"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", "\"\<Quadratic Form x^T M x over the unit circle\>\"", 
     "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", 
     "\"\<  Green plane is qform = lambda1 -- evec r1 then r1^T M r1 = \
lambda1. \>\"", "]"}], ";"}], " ", "\n", 
   RowBox[{
    RowBox[{
    "Print", "[", 
     "\"\<     This plane touches the unit circle CONS in an eigendirection \
\>\"", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<  Blue plane is qform = 1\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", 
     "\"\<Yellow unit circle mapped to action ellipse in gray\>\"", "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{
    "qsurface3d", ",", " ", "plotcons3d", ",", "ulines3d", ",", "plotplane3d",
      ",", "plotplanez13d", ",", "plotmmaxes", ",", "mulines3d", ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}], ",", " ", 
     RowBox[{"Axes", "\[Rule]", "False"}], ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", " ", 
     RowBox[{"BoxRatios", "\[Rule]", "Automatic"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Plane", " ", "should", " ", "touch", " ", "quadratic", " ", "form", " ", 
     "function", " ", "value", " ", "associated", " ", "with", " ", "minor", 
     " ", "axis"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", "\"\<Quadratic Form x^T M x over the unit circle\>\"", 
     "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", 
     "\"\<  Green plane is qform = lambda2 -- evec r2 then r2^T M r2 = \
lambda2. \>\"", "]"}], ";"}], " ", "\n", 
   RowBox[{
    RowBox[{
    "Print", "[", 
     "\"\<     This plane touches the unit circle CONS in an eigendirection \
\>\"", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<  Blue plane is qform = 1\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", 
     "\"\<Yellow unit circle mapped to action ellipse in gray\>\"", "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{
    "qsurface3d", ",", " ", "plotcons3d", ",", "ulines3d", ",", 
     "plotplane23d", ",", "plotplanez13d", ",", "plotmmaxes", ",", 
     "mulines3d", ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}], ",", " ", 
     RowBox[{"Axes", "\[Rule]", "False"}], ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"BoxRatios", "\[Rule]", "Automatic"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", 
     "\"\<Action of the matrix ellipse -- 2 definitions in axis aligned \
position\>\"", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Parametric: [x,y] = [\>\"", ",", 
      RowBox[{"sigma", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", "\"\<,Cos[alpha],\>\"", 
      ",", " ", 
      RowBox[{"sigma", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "2"}], "]"}], "]"}], ",", "\"\<Sin[alpha]]\>\""}], 
     "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
     "\"\<Implicit: \>\"", ",", "a", ",", "\"\<x^2 + \>\"", ",", "b", ",", 
      "\"\<y^2 = 1\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", "plotellipsepara", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", "plotellipseimplicit", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5625265986810126`*^9, 3.562526638601483*^9}, {
   3.5625268060521765`*^9, 3.5625268933187304`*^9}, {3.5625269897580996`*^9, 
   3.562526991848503*^9}, {3.5625270459805984`*^9, 3.562527062859828*^9}, {
   3.5625271371315584`*^9, 3.562527140844365*^9}, {3.562527171810419*^9, 
   3.562527256674568*^9}, {3.5625272931786327`*^9, 3.562527376513979*^9}, {
   3.562527418103652*^9, 3.5625275318590517`*^9}, {3.562527721945386*^9, 
   3.56252779283191*^9}, {3.562527834936384*^9, 3.56252786691644*^9}, {
   3.562527914808524*^9, 3.56252792387214*^9}, {3.5625279833082447`*^9, 
   3.562527990203457*^9}, {3.5625280206547103`*^9, 3.5625280491715603`*^9}, {
   3.5626247123983974`*^9, 3.562624712819598*^9}, {3.5628482525687094`*^9, 
   3.56284825305231*^9}, {3.56284849206033*^9, 3.5628485136819677`*^9}, {
   3.5628510001304564`*^9, 3.562851066617773*^9}, {3.562851403328765*^9, 
   3.5628514363228226`*^9}, {3.5628517021316895`*^9, 3.562851818601494*^9}, {
   3.562935187363274*^9, 3.562935210864769*^9}, {3.562935658803956*^9, 
   3.562935701938032*^9}, {3.562935737303294*^9, 3.5629358704339275`*^9}, {
   3.5629359249716234`*^9, 3.5629359585116825`*^9}, {3.562936085355505*^9, 
   3.5629361249483747`*^9}, {3.5629361551812277`*^9, 3.562936174447262*^9}, {
   3.562936341539155*^9, 3.5629363485903673`*^9}, {3.562936461550166*^9, 
   3.562936514527859*^9}, {3.5629375970449605`*^9, 3.562937613066189*^9}, {
   3.5629376730014935`*^9, 3.5629376847951145`*^9}, 3.562937948669578*^9, {
   3.562938284569368*^9, 3.5629383060350056`*^9}, {3.562938354894292*^9, 
   3.562938387701149*^9}, {3.562938488602126*^9, 3.562938552718239*^9}, {
   3.562938679218861*^9, 3.562938748592183*^9}, {3.562939055865923*^9, 
   3.5629390767855597`*^9}, {3.5629391093428164`*^9, 
   3.5629391264248466`*^9}, {3.562939188232155*^9, 3.562939284359524*^9}, {
   3.5629395350363646`*^9, 3.562939539466772*^9}, {3.562939594082468*^9, 
   3.562939834900091*^9}, {3.562939946112686*^9, 3.562939956174704*^9}, {
   3.5629400150804076`*^9, 3.562940024409224*^9}, {3.5629403613074155`*^9, 
   3.5629404665452003`*^9}, {3.5629405047184677`*^9, 
   3.5629405967898293`*^9}, {3.5629406646031485`*^9, 
   3.5629406667871523`*^9}, {3.5629410097849545`*^9, 3.562941078269075*^9}, {
   3.5629415135265646`*^9, 3.562941591011901*^9}, {3.562941629824769*^9, 
   3.5629416843000646`*^9}, {3.5629417588525953`*^9, 3.562941817929899*^9}, {
   3.562941864901582*^9, 3.5629418686143885`*^9}, {3.562941946567725*^9, 
   3.562941987954598*^9}, {3.5629420363302827`*^9, 3.562942037110284*^9}, {
   3.5629420696675415`*^9, 3.562942082459564*^9}, {3.5629421352032566`*^9, 
   3.5629421903805532`*^9}, {3.562942235636233*^9, 3.56294226254628*^9}, {
   3.5629422948227367`*^9, 3.5629423062419567`*^9}, {3.562942339142415*^9, 
   3.562942386566498*^9}, {3.562942418312554*^9, 3.5629424222125607`*^9}, {
   3.562943160452657*^9, 3.5629432116051474`*^9}, {3.562943245020406*^9, 
   3.5629432920076885`*^9}, 3.5629433588694057`*^9, {3.56294361740866*^9, 
   3.5629437726757326`*^9}, {3.562943850519869*^9, 3.562943851845872*^9}, {
   3.562943895182748*^9, 3.5629439806084976`*^9}, {3.5629440219797707`*^9, 
   3.5629440476574154`*^9}, {3.562944103115513*^9, 3.562944107889121*^9}, {
   3.5629441556096053`*^9, 3.5629441626920176`*^9}, {3.5629442200065184`*^9, 
   3.562944223703725*^9}, {3.562952779785596*^9, 3.562952788334411*^9}, {
   3.562952869938154*^9, 3.56295287308936*^9}, {3.5629529676411257`*^9, 
   3.562952971478733*^9}, {3.5629530101824007`*^9, 3.5629530105880013`*^9}, {
   3.562953056171282*^9, 3.5629531224245977`*^9}, {3.5629532502356224`*^9, 
   3.5629533903862686`*^9}, {3.562953599442236*^9, 3.5629536505947256`*^9}, {
   3.5629537395616817`*^9, 3.562953744616091*^9}, {3.562953794192978*^9, 
   3.5629537998869877`*^9}, {3.562954104711523*^9, 3.5629541083307295`*^9}, {
   3.5629541680632343`*^9, 3.562954210276909*^9}, {3.562954254284586*^9, 
   3.562954258980194*^9}, {3.562954435775305*^9, 3.5629545274254656`*^9}, {
   3.562954634207653*^9, 3.562954637655259*^9}, 3.5629550272035437`*^9, {
   3.562955221470685*^9, 3.5629552356979094`*^9}, {3.5629553739921527`*^9, 
   3.5629553941317883`*^9}, {3.5629556649794636`*^9, 3.562955689533907*^9}, 
   3.5629557473476086`*^9, {3.562955801620104*^9, 3.5629558249577446`*^9}, {
   3.5629626386665134`*^9, 3.5629626581197476`*^9}, {3.562962920855409*^9, 
   3.562962943350649*^9}, {3.562962980634714*^9, 3.5629630624412575`*^9}, 
   3.5629631505034122`*^9, 3.562963224962343*^9, {3.5629633583269777`*^9, 
   3.5629633595281796`*^9}, 3.5629634150486774`*^9, {3.562971424966525*^9, 
   3.5629714293969326`*^9}, {3.563019131892971*^9, 3.5630191375557814`*^9}, {
   3.5630191774138513`*^9, 3.5630192123111124`*^9}, {3.5630192800620317`*^9, 
   3.5630193090936823`*^9}, {3.563019352758159*^9, 3.5630193605893726`*^9}, {
   3.5630194725195694`*^9, 3.563019473252771*^9}, {3.563019516776847*^9, 
   3.563019517213648*^9}, {3.563019547852102*^9, 3.563019558881321*^9}, {
   3.563019611235013*^9, 3.5630196763027277`*^9}, {3.5630197070815816`*^9, 
   3.5630197861737204`*^9}, {3.563020265359762*^9, 3.5630203922659845`*^9}, {
   3.563020521761812*^9, 3.5630205223546133`*^9}, {3.563020580605116*^9, 
   3.563020584349122*^9}, {3.5630206613976574`*^9, 3.563020666233666*^9}, {
   3.5630206983697224`*^9, 3.5630207176669564`*^9}, {3.563020812998724*^9, 
   3.5630208246207447`*^9}, {3.5630209153817034`*^9, 3.563020931075331*^9}, {
   3.5630218225544972`*^9, 3.5630218348161187`*^9}, {3.5630219002270336`*^9, 
   3.5630219161858616`*^9}, {3.5630220087096243`*^9, 
   3.5630220949465756`*^9}, {3.563022417848963*^9, 3.5630224736970615`*^9}, {
   3.563022508894125*^9, 3.5630225129813323`*^9}, {3.563022857427039*^9, 
   3.563022911886735*^9}, {3.56302437825811*^9, 3.563024400098149*^9}, {
   3.5630245341023846`*^9, 3.5630245372535896`*^9}, {3.5630245674240427`*^9, 
   3.563024570341248*^9}, {3.563024602258904*^9, 3.5630246923802624`*^9}, {
   3.563027080182856*^9, 3.5630270813840585`*^9}, {3.563027113598115*^9, 
   3.563027126280937*^9}, {3.5630271800854316`*^9, 3.563027253733161*^9}, {
   3.5630273223108816`*^9, 3.5630275376692595`*^9}, {3.5630276212386065`*^9, 
   3.563027702202749*^9}, {3.5630277364604087`*^9, 3.5630277384104123`*^9}, {
   3.563027803540527*^9, 3.5630278124169426`*^9}, {3.5630278875154743`*^9, 
   3.563027893084684*^9}, {3.563029271924306*^9, 3.5630295382479734`*^9}, {
   3.5630296076056957`*^9, 3.5630296123481035`*^9}, {3.563029643860159*^9, 
   3.5630296441877594`*^9}, {3.5630297454319377`*^9, 
   3.5630297841980057`*^9}, {3.5630298296720853`*^9, 
   3.5630298360992966`*^9}, {3.5630298662385497`*^9, 3.5630298987802067`*^9}, 
   3.563044599608452*^9, 3.5630450903635817`*^9, {3.563045150080487*^9, 
   3.563045201404577*^9}, {3.5630457174846835`*^9, 3.563045779120392*^9}, {
   3.5630458359356914`*^9, 3.563045867619347*^9}, {3.5630465994790325`*^9, 
   3.5630466061402445`*^9}, {3.5630471765828466`*^9, 3.563047219482922*^9}, {
   3.5630472528825808`*^9, 3.5630472574845886`*^9}, {3.5630473246271067`*^9, 
   3.5630473706471877`*^9}, {3.563047751802657*^9, 3.563047755780664*^9}, {
   3.5630478119407625`*^9, 3.5630478454496217`*^9}, {3.563047965304632*^9, 
   3.5630480575163937`*^9}, {3.5630480976864643`*^9, 
   3.5630481031776743`*^9}, {3.5630483461185007`*^9, 
   3.5630483592693243`*^9}, {3.563048402949401*^9, 3.563048403729402*^9}, 
   3.5630485265676174`*^9, {3.5630485720260973`*^9, 3.5630485817293143`*^9}, {
   3.563049919028065*^9, 3.563049925658077*^9}, {3.5631065644520226`*^9, 
   3.563106567955223*^9}, {3.563109842013562*^9, 3.563109966426976*^9}, {
   3.563110016914663*^9, 3.5631101294912586`*^9}, {3.5631101707941275`*^9, 
   3.5631102424866486`*^9}, {3.5631114044434557`*^9, 3.563111444570324*^9}, {
   3.5631115804165564`*^9, 3.5631115924285774`*^9}, {3.5631116232670307`*^9, 
   3.5631116245150323`*^9}, {3.5631117161571903`*^9, 3.563111816042161*^9}, {
   3.563112052957365*^9, 3.5631120538153667`*^9}, {3.5631120983410435`*^9, 
   3.563112115501074*^9}, {3.5631121632691574`*^9, 3.563112174361576*^9}, {
   3.563112229478071*^9, 3.5631122380580864`*^9}, {3.5631122705845423`*^9, 
   3.5631123421894674`*^9}, {3.563112380971134*^9, 3.563112414632393*^9}, {
   3.5631124955241303`*^9, 3.5631127002512836`*^9}, {3.5631127333261404`*^9, 
   3.5631127803786216`*^9}, {3.563113139168031*^9, 3.5631133131259365`*^9}, {
   3.563113346463195*^9, 3.563113354466009*^9}, {3.5631276750269403`*^9, 
   3.563127704729393*^9}, {3.563127965671051*^9, 3.5631280451999907`*^9}, {
   3.5631280917816725`*^9, 3.5631280955100794`*^9}, 3.563128150225375*^9, {
   3.563128218444295*^9, 3.563128234855524*^9}, {3.563128416437667*^9, 
   3.5631284475441213`*^9}, {3.5631287854326468`*^9, 3.563128823309513*^9}, {
   3.5631289349433093`*^9, 3.5631289366281123`*^9}, {3.5631294499314137`*^9, 
   3.5631294705546503`*^9}, {3.5631296640105896`*^9, 3.563129685788228*^9}, 
   3.563129775815986*^9, {3.5631298631449394`*^9, 3.563129868339749*^9}, {
   3.5631304509355745`*^9, 3.5631304666604023`*^9}, {3.563373097463274*^9, 
   3.5633731463233423`*^9}, {3.563373199503417*^9, 3.563373217403442*^9}, {
   3.5634017291248074`*^9, 3.5634017856593065`*^9}, {3.564843880558483*^9, 
   3.5648439526462097`*^9}, {3.5648440313171473`*^9, 3.564844035326355*^9}, {
   3.564850781713813*^9, 3.564850814895071*^9}, {3.5648509087760363`*^9, 
   3.564850913362444*^9}, {3.564851637390916*^9, 3.5648518457760816`*^9}, {
   3.564851890735361*^9, 3.5648520119007735`*^9}, {3.5648521277777767`*^9, 
   3.564852164999442*^9}, {3.564852474098385*^9, 3.5648525013048334`*^9}, {
   3.564852558884534*^9, 3.5648525953573985`*^9}, {3.56485264187668*^9, 
   3.5648527084419966`*^9}, {3.584631303036064*^9, 3.5846314127198563`*^9}, {
   3.584631499596409*^9, 3.584631655487483*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Matrix is positive definite\"\>"], "Print",
 CellChangeTimes->{
  3.5629550986360693`*^9, 3.5629552384747143`*^9, 3.562955397017793*^9, {
   3.5629554461890793`*^9, 3.562955473286327*^9}, 3.562955546996456*^9, 
   3.5629555878685284`*^9, 3.562955627133797*^9, {3.5629556758214827`*^9, 
   3.5629556912499104`*^9}, 3.562955749516012*^9, 3.5629558033673067`*^9, 
   3.562955842694976*^9, 3.562963384191823*^9, 3.562963419042284*^9, 
   3.5630191524226074`*^9, 3.5630192141363153`*^9, {3.5630192856000414`*^9, 
   3.563019310185684*^9}, {3.5630193541153617`*^9, 3.5630193621181755`*^9}, 
   3.563019561034125*^9, {3.563020346167904*^9, 3.563020394621589*^9}, 
   3.563020527315422*^9, 3.5630205861275253`*^9, 3.563020631508005*^9, {
   3.5630206764048843`*^9, 3.563020718712158*^9}, 3.563020757727827*^9, {
   3.56302081655553*^9, 3.5630208254007454`*^9}, 3.5630209318085327`*^9, {
   3.5630218360797205`*^9, 3.563021863426569*^9}, {3.5630219037370396`*^9, 
   3.563021918635066*^9}, {3.5630219850131826`*^9, 3.5630220960697775`*^9}, 
   3.56302247810887*^9, 3.5630225147597356`*^9, {3.5630227914389234`*^9, 
   3.5630228139497633`*^9}, {3.563022860718645*^9, 3.563022961978423*^9}, 
   3.5630244252141933`*^9, {3.56302450898634*^9, 3.563024538470392*^9}, 
   3.563024573898054*^9, {3.5630246048485084`*^9, 3.5630246393713694`*^9}, {
   3.563024669666622*^9, 3.5630246931290636`*^9}, 3.5630247649359894`*^9, 
   3.5630250207452393`*^9, 3.563025263450465*^9, 3.563027130305744*^9, 
   3.563027228117916*^9, {3.5630274502935066`*^9, 3.5630274739899483`*^9}, {
   3.5630277148231707`*^9, 3.5630277394712143`*^9}, {3.5630294341021905`*^9, 
   3.5630294574242315`*^9}, 3.563029489903489*^9, 3.5630295392931757`*^9, 
   3.5630296129097047`*^9, 3.5630297851964073`*^9, {3.5630298821349773`*^9, 
   3.5630298996070085`*^9}, 3.563044604979759*^9, 3.5630450931871867`*^9, 
   3.563045157209699*^9, 3.5630452052109833`*^9, 3.563045235787037*^9, 
   3.563045378652088*^9, {3.5630454110377455`*^9, 3.5630454334393845`*^9}, 
   3.5630456828994226`*^9, 3.563045781709996*^9, 3.5630458374644938`*^9, 
   3.5630458690857496`*^9, 3.5630462941864967`*^9, 3.56304645572478*^9, 
   3.5630465521329494`*^9, 3.5630466124582553`*^9, 3.5630467308312635`*^9, 
   3.563046882213929*^9, 3.5630472614469957`*^9, 3.563047348963149*^9, 
   3.5630474030328445`*^9, 3.563047851564832*^9, {3.5630480367371573`*^9, 
   3.563048060277599*^9}, 3.563048104690877*^9, 3.5630483629041305`*^9, 
   3.5630484046654034`*^9, 3.563048588827327*^9, 3.5630486703622694`*^9, 
   3.563048753229615*^9, {3.5630499328496895`*^9, 3.5630499471237144`*^9}, 
   3.5630499856557827`*^9, 3.563050042004681*^9, 3.563050077238743*^9, 
   3.5631065732665267`*^9, 3.563107642632543*^9, 3.5631076836570134`*^9, 
   3.5631110719644833`*^9, 3.5631115400192876`*^9, 3.563111598825388*^9, 
   3.5631116390814567`*^9, 3.56311182131497*^9, 3.563111949317589*^9, 
   3.563112783982228*^9, {3.5631129837985697`*^9, 3.5631130017854013`*^9}, 
   3.5631130626691027`*^9, 3.5631136942970057`*^9, 3.5631277471770678`*^9, 
   3.5631281219113255`*^9, 3.563128153298581*^9, 3.5631282388959312`*^9, 
   3.5631284212424755`*^9, 3.5631284518497286`*^9, 3.563128793934662*^9, 
   3.563128826367119*^9, 3.563128943382924*^9, 3.563129369794073*^9, {
   3.563129454533422*^9, 3.5631294742986565`*^9}, 3.5631296986894507`*^9, 
   3.5631297798251934`*^9, 3.563129872910557*^9, 3.563129954773501*^9, {
   3.563130047488064*^9, 3.563130067580899*^9}, 3.56313047110641*^9, 
   3.5631307464312935`*^9, 3.563130776866947*^9, 3.5633730059831457`*^9, 
   3.5633731021632805`*^9, 3.5633731485033455`*^9, 3.5633732187334433`*^9, 
   3.563553505104024*^9, 3.5647835560879936`*^9, 3.5648433002062635`*^9, 
   3.5648434942862043`*^9, 3.564843533863474*^9, {3.5648436392572594`*^9, 
   3.5648436681173096`*^9}, 3.564843956452616*^9, 3.564844038914361*^9, 
   3.564850817734276*^9, 3.5648508642847576`*^9, 3.56485091665405*^9, 
   3.5648515516219654`*^9, 3.5648525078256445`*^9, 3.5648526023930106`*^9, 
   3.564852654668702*^9, 3.567106143036501*^9, 3.584477521649786*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"matrix m=\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.25`", "1"},
       {"1", "1.25`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["matrix m=", 
   MatrixForm[{{1.25, 1}, {1, 1.25}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5629550986360693`*^9, 3.5629552384747143`*^9, 3.562955397017793*^9, {
   3.5629554461890793`*^9, 3.562955473286327*^9}, 3.562955546996456*^9, 
   3.5629555878685284`*^9, 3.562955627133797*^9, {3.5629556758214827`*^9, 
   3.5629556912499104`*^9}, 3.562955749516012*^9, 3.5629558033673067`*^9, 
   3.562955842694976*^9, 3.562963384191823*^9, 3.562963419042284*^9, 
   3.5630191524226074`*^9, 3.5630192141363153`*^9, {3.5630192856000414`*^9, 
   3.563019310185684*^9}, {3.5630193541153617`*^9, 3.5630193621181755`*^9}, 
   3.563019561034125*^9, {3.563020346167904*^9, 3.563020394621589*^9}, 
   3.563020527315422*^9, 3.5630205861275253`*^9, 3.563020631508005*^9, {
   3.5630206764048843`*^9, 3.563020718712158*^9}, 3.563020757727827*^9, {
   3.56302081655553*^9, 3.5630208254007454`*^9}, 3.5630209318085327`*^9, {
   3.5630218360797205`*^9, 3.563021863426569*^9}, {3.5630219037370396`*^9, 
   3.563021918635066*^9}, {3.5630219850131826`*^9, 3.5630220960697775`*^9}, 
   3.56302247810887*^9, 3.5630225147597356`*^9, {3.5630227914389234`*^9, 
   3.5630228139497633`*^9}, {3.563022860718645*^9, 3.563022961978423*^9}, 
   3.5630244252141933`*^9, {3.56302450898634*^9, 3.563024538470392*^9}, 
   3.563024573898054*^9, {3.5630246048485084`*^9, 3.5630246393713694`*^9}, {
   3.563024669666622*^9, 3.5630246931290636`*^9}, 3.5630247649359894`*^9, 
   3.5630250207452393`*^9, 3.563025263450465*^9, 3.563027130305744*^9, 
   3.563027228117916*^9, {3.5630274502935066`*^9, 3.5630274739899483`*^9}, {
   3.5630277148231707`*^9, 3.5630277394712143`*^9}, {3.5630294341021905`*^9, 
   3.5630294574242315`*^9}, 3.563029489903489*^9, 3.5630295392931757`*^9, 
   3.5630296129097047`*^9, 3.5630297851964073`*^9, {3.5630298821349773`*^9, 
   3.5630298996070085`*^9}, 3.563044604979759*^9, 3.5630450931871867`*^9, 
   3.563045157209699*^9, 3.5630452052109833`*^9, 3.563045235787037*^9, 
   3.563045378652088*^9, {3.5630454110377455`*^9, 3.5630454334393845`*^9}, 
   3.5630456828994226`*^9, 3.563045781709996*^9, 3.5630458374644938`*^9, 
   3.5630458690857496`*^9, 3.5630462941864967`*^9, 3.56304645572478*^9, 
   3.5630465521329494`*^9, 3.5630466124582553`*^9, 3.5630467308312635`*^9, 
   3.563046882213929*^9, 3.5630472614469957`*^9, 3.563047348963149*^9, 
   3.5630474030328445`*^9, 3.563047851564832*^9, {3.5630480367371573`*^9, 
   3.563048060277599*^9}, 3.563048104690877*^9, 3.5630483629041305`*^9, 
   3.5630484046654034`*^9, 3.563048588827327*^9, 3.5630486703622694`*^9, 
   3.563048753229615*^9, {3.5630499328496895`*^9, 3.5630499471237144`*^9}, 
   3.5630499856557827`*^9, 3.563050042004681*^9, 3.563050077238743*^9, 
   3.5631065732665267`*^9, 3.563107642632543*^9, 3.5631076836570134`*^9, 
   3.5631110719644833`*^9, 3.5631115400192876`*^9, 3.563111598825388*^9, 
   3.5631116390814567`*^9, 3.56311182131497*^9, 3.563111949317589*^9, 
   3.563112783982228*^9, {3.5631129837985697`*^9, 3.5631130017854013`*^9}, 
   3.5631130626691027`*^9, 3.5631136942970057`*^9, 3.5631277471770678`*^9, 
   3.5631281219113255`*^9, 3.563128153298581*^9, 3.5631282388959312`*^9, 
   3.5631284212424755`*^9, 3.5631284518497286`*^9, 3.563128793934662*^9, 
   3.563128826367119*^9, 3.563128943382924*^9, 3.563129369794073*^9, {
   3.563129454533422*^9, 3.5631294742986565`*^9}, 3.5631296986894507`*^9, 
   3.5631297798251934`*^9, 3.563129872910557*^9, 3.563129954773501*^9, {
   3.563130047488064*^9, 3.563130067580899*^9}, 3.56313047110641*^9, 
   3.5631307464312935`*^9, 3.563130776866947*^9, 3.5633730059831457`*^9, 
   3.5633731021632805`*^9, 3.5633731485033455`*^9, 3.5633732187334433`*^9, 
   3.563553505104024*^9, 3.5647835560879936`*^9, 3.5648433002062635`*^9, 
   3.5648434942862043`*^9, 3.564843533863474*^9, {3.5648436392572594`*^9, 
   3.5648436681173096`*^9}, 3.564843956452616*^9, 3.564844038914361*^9, 
   3.564850817734276*^9, 3.5648508642847576`*^9, 3.56485091665405*^9, 
   3.5648515516219654`*^9, 3.5648525078256445`*^9, 3.5648526023930106`*^9, 
   3.564852654668702*^9, 3.567106143036501*^9, 3.584477521649786*^9}],

Cell[BoxData["\<\"SVD(m) =>\"\>"], "Print",
 CellChangeTimes->{
  3.5629550986360693`*^9, 3.5629552384747143`*^9, 3.562955397017793*^9, {
   3.5629554461890793`*^9, 3.562955473286327*^9}, 3.562955546996456*^9, 
   3.5629555878685284`*^9, 3.562955627133797*^9, {3.5629556758214827`*^9, 
   3.5629556912499104`*^9}, 3.562955749516012*^9, 3.5629558033673067`*^9, 
   3.562955842694976*^9, 3.562963384191823*^9, 3.562963419042284*^9, 
   3.5630191524226074`*^9, 3.5630192141363153`*^9, {3.5630192856000414`*^9, 
   3.563019310185684*^9}, {3.5630193541153617`*^9, 3.5630193621181755`*^9}, 
   3.563019561034125*^9, {3.563020346167904*^9, 3.563020394621589*^9}, 
   3.563020527315422*^9, 3.5630205861275253`*^9, 3.563020631508005*^9, {
   3.5630206764048843`*^9, 3.563020718712158*^9}, 3.563020757727827*^9, {
   3.56302081655553*^9, 3.5630208254007454`*^9}, 3.5630209318085327`*^9, {
   3.5630218360797205`*^9, 3.563021863426569*^9}, {3.5630219037370396`*^9, 
   3.563021918635066*^9}, {3.5630219850131826`*^9, 3.5630220960697775`*^9}, 
   3.56302247810887*^9, 3.5630225147597356`*^9, {3.5630227914389234`*^9, 
   3.5630228139497633`*^9}, {3.563022860718645*^9, 3.563022961978423*^9}, 
   3.5630244252141933`*^9, {3.56302450898634*^9, 3.563024538470392*^9}, 
   3.563024573898054*^9, {3.5630246048485084`*^9, 3.5630246393713694`*^9}, {
   3.563024669666622*^9, 3.5630246931290636`*^9}, 3.5630247649359894`*^9, 
   3.5630250207452393`*^9, 3.563025263450465*^9, 3.563027130305744*^9, 
   3.563027228117916*^9, {3.5630274502935066`*^9, 3.5630274739899483`*^9}, {
   3.5630277148231707`*^9, 3.5630277394712143`*^9}, {3.5630294341021905`*^9, 
   3.5630294574242315`*^9}, 3.563029489903489*^9, 3.5630295392931757`*^9, 
   3.5630296129097047`*^9, 3.5630297851964073`*^9, {3.5630298821349773`*^9, 
   3.5630298996070085`*^9}, 3.563044604979759*^9, 3.5630450931871867`*^9, 
   3.563045157209699*^9, 3.5630452052109833`*^9, 3.563045235787037*^9, 
   3.563045378652088*^9, {3.5630454110377455`*^9, 3.5630454334393845`*^9}, 
   3.5630456828994226`*^9, 3.563045781709996*^9, 3.5630458374644938`*^9, 
   3.5630458690857496`*^9, 3.5630462941864967`*^9, 3.56304645572478*^9, 
   3.5630465521329494`*^9, 3.5630466124582553`*^9, 3.5630467308312635`*^9, 
   3.563046882213929*^9, 3.5630472614469957`*^9, 3.563047348963149*^9, 
   3.5630474030328445`*^9, 3.563047851564832*^9, {3.5630480367371573`*^9, 
   3.563048060277599*^9}, 3.563048104690877*^9, 3.5630483629041305`*^9, 
   3.5630484046654034`*^9, 3.563048588827327*^9, 3.5630486703622694`*^9, 
   3.563048753229615*^9, {3.5630499328496895`*^9, 3.5630499471237144`*^9}, 
   3.5630499856557827`*^9, 3.563050042004681*^9, 3.563050077238743*^9, 
   3.5631065732665267`*^9, 3.563107642632543*^9, 3.5631076836570134`*^9, 
   3.5631110719644833`*^9, 3.5631115400192876`*^9, 3.563111598825388*^9, 
   3.5631116390814567`*^9, 3.56311182131497*^9, 3.563111949317589*^9, 
   3.563112783982228*^9, {3.5631129837985697`*^9, 3.5631130017854013`*^9}, 
   3.5631130626691027`*^9, 3.5631136942970057`*^9, 3.5631277471770678`*^9, 
   3.5631281219113255`*^9, 3.563128153298581*^9, 3.5631282388959312`*^9, 
   3.5631284212424755`*^9, 3.5631284518497286`*^9, 3.563128793934662*^9, 
   3.563128826367119*^9, 3.563128943382924*^9, 3.563129369794073*^9, {
   3.563129454533422*^9, 3.5631294742986565`*^9}, 3.5631296986894507`*^9, 
   3.5631297798251934`*^9, 3.563129872910557*^9, 3.563129954773501*^9, {
   3.563130047488064*^9, 3.563130067580899*^9}, 3.56313047110641*^9, 
   3.5631307464312935`*^9, 3.563130776866947*^9, 3.5633730059831457`*^9, 
   3.5633731021632805`*^9, 3.5633731485033455`*^9, 3.5633732187334433`*^9, 
   3.563553505104024*^9, 3.5647835560879936`*^9, 3.5648433002062635`*^9, 
   3.5648434942862043`*^9, 3.564843533863474*^9, {3.5648436392572594`*^9, 
   3.5648436681173096`*^9}, 3.564843956452616*^9, 3.564844038914361*^9, 
   3.564850817734276*^9, 3.5648508642847576`*^9, 3.56485091665405*^9, 
   3.5648515516219654`*^9, 3.5648525078256445`*^9, 3.5648526023930106`*^9, 
   3.564852654668702*^9, 3.567106143036501*^9, 3.584477521649786*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"U=    \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "0.7071067811865475`"}], 
        RowBox[{"-", "0.7071067811865475`"}]},
       {
        RowBox[{"-", "0.7071067811865475`"}], "0.7071067811865475`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["U=    ", 
   MatrixForm[{{-0.7071067811865475, -0.7071067811865475}, \
{-0.7071067811865475, 0.7071067811865475}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5629550986360693`*^9, 3.5629552384747143`*^9, 3.562955397017793*^9, {
   3.5629554461890793`*^9, 3.562955473286327*^9}, 3.562955546996456*^9, 
   3.5629555878685284`*^9, 3.562955627133797*^9, {3.5629556758214827`*^9, 
   3.5629556912499104`*^9}, 3.562955749516012*^9, 3.5629558033673067`*^9, 
   3.562955842694976*^9, 3.562963384191823*^9, 3.562963419042284*^9, 
   3.5630191524226074`*^9, 3.5630192141363153`*^9, {3.5630192856000414`*^9, 
   3.563019310185684*^9}, {3.5630193541153617`*^9, 3.5630193621181755`*^9}, 
   3.563019561034125*^9, {3.563020346167904*^9, 3.563020394621589*^9}, 
   3.563020527315422*^9, 3.5630205861275253`*^9, 3.563020631508005*^9, {
   3.5630206764048843`*^9, 3.563020718712158*^9}, 3.563020757727827*^9, {
   3.56302081655553*^9, 3.5630208254007454`*^9}, 3.5630209318085327`*^9, {
   3.5630218360797205`*^9, 3.563021863426569*^9}, {3.5630219037370396`*^9, 
   3.563021918635066*^9}, {3.5630219850131826`*^9, 3.5630220960697775`*^9}, 
   3.56302247810887*^9, 3.5630225147597356`*^9, {3.5630227914389234`*^9, 
   3.5630228139497633`*^9}, {3.563022860718645*^9, 3.563022961978423*^9}, 
   3.5630244252141933`*^9, {3.56302450898634*^9, 3.563024538470392*^9}, 
   3.563024573898054*^9, {3.5630246048485084`*^9, 3.5630246393713694`*^9}, {
   3.563024669666622*^9, 3.5630246931290636`*^9}, 3.5630247649359894`*^9, 
   3.5630250207452393`*^9, 3.563025263450465*^9, 3.563027130305744*^9, 
   3.563027228117916*^9, {3.5630274502935066`*^9, 3.5630274739899483`*^9}, {
   3.5630277148231707`*^9, 3.5630277394712143`*^9}, {3.5630294341021905`*^9, 
   3.5630294574242315`*^9}, 3.563029489903489*^9, 3.5630295392931757`*^9, 
   3.5630296129097047`*^9, 3.5630297851964073`*^9, {3.5630298821349773`*^9, 
   3.5630298996070085`*^9}, 3.563044604979759*^9, 3.5630450931871867`*^9, 
   3.563045157209699*^9, 3.5630452052109833`*^9, 3.563045235787037*^9, 
   3.563045378652088*^9, {3.5630454110377455`*^9, 3.5630454334393845`*^9}, 
   3.5630456828994226`*^9, 3.563045781709996*^9, 3.5630458374644938`*^9, 
   3.5630458690857496`*^9, 3.5630462941864967`*^9, 3.56304645572478*^9, 
   3.5630465521329494`*^9, 3.5630466124582553`*^9, 3.5630467308312635`*^9, 
   3.563046882213929*^9, 3.5630472614469957`*^9, 3.563047348963149*^9, 
   3.5630474030328445`*^9, 3.563047851564832*^9, {3.5630480367371573`*^9, 
   3.563048060277599*^9}, 3.563048104690877*^9, 3.5630483629041305`*^9, 
   3.5630484046654034`*^9, 3.563048588827327*^9, 3.5630486703622694`*^9, 
   3.563048753229615*^9, {3.5630499328496895`*^9, 3.5630499471237144`*^9}, 
   3.5630499856557827`*^9, 3.563050042004681*^9, 3.563050077238743*^9, 
   3.5631065732665267`*^9, 3.563107642632543*^9, 3.5631076836570134`*^9, 
   3.5631110719644833`*^9, 3.5631115400192876`*^9, 3.563111598825388*^9, 
   3.5631116390814567`*^9, 3.56311182131497*^9, 3.563111949317589*^9, 
   3.563112783982228*^9, {3.5631129837985697`*^9, 3.5631130017854013`*^9}, 
   3.5631130626691027`*^9, 3.5631136942970057`*^9, 3.5631277471770678`*^9, 
   3.5631281219113255`*^9, 3.563128153298581*^9, 3.5631282388959312`*^9, 
   3.5631284212424755`*^9, 3.5631284518497286`*^9, 3.563128793934662*^9, 
   3.563128826367119*^9, 3.563128943382924*^9, 3.563129369794073*^9, {
   3.563129454533422*^9, 3.5631294742986565`*^9}, 3.5631296986894507`*^9, 
   3.5631297798251934`*^9, 3.563129872910557*^9, 3.563129954773501*^9, {
   3.563130047488064*^9, 3.563130067580899*^9}, 3.56313047110641*^9, 
   3.5631307464312935`*^9, 3.563130776866947*^9, 3.5633730059831457`*^9, 
   3.5633731021632805`*^9, 3.5633731485033455`*^9, 3.5633732187334433`*^9, 
   3.563553505104024*^9, 3.5647835560879936`*^9, 3.5648433002062635`*^9, 
   3.5648434942862043`*^9, 3.564843533863474*^9, {3.5648436392572594`*^9, 
   3.5648436681173096`*^9}, 3.564843956452616*^9, 3.564844038914361*^9, 
   3.564850817734276*^9, 3.5648508642847576`*^9, 3.56485091665405*^9, 
   3.5648515516219654`*^9, 3.5648525078256445`*^9, 3.5648526023930106`*^9, 
   3.564852654668702*^9, 3.567106143036501*^9, 3.584477521649786*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"V=    \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "0.7071067811865474`"}], 
        RowBox[{"-", "0.7071067811865476`"}]},
       {
        RowBox[{"-", "0.7071067811865475`"}], "0.7071067811865475`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["V=    ", 
   MatrixForm[{{-0.7071067811865474, -0.7071067811865476}, \
{-0.7071067811865475, 0.7071067811865475}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5629550986360693`*^9, 3.5629552384747143`*^9, 3.562955397017793*^9, {
   3.5629554461890793`*^9, 3.562955473286327*^9}, 3.562955546996456*^9, 
   3.5629555878685284`*^9, 3.562955627133797*^9, {3.5629556758214827`*^9, 
   3.5629556912499104`*^9}, 3.562955749516012*^9, 3.5629558033673067`*^9, 
   3.562955842694976*^9, 3.562963384191823*^9, 3.562963419042284*^9, 
   3.5630191524226074`*^9, 3.5630192141363153`*^9, {3.5630192856000414`*^9, 
   3.563019310185684*^9}, {3.5630193541153617`*^9, 3.5630193621181755`*^9}, 
   3.563019561034125*^9, {3.563020346167904*^9, 3.563020394621589*^9}, 
   3.563020527315422*^9, 3.5630205861275253`*^9, 3.563020631508005*^9, {
   3.5630206764048843`*^9, 3.563020718712158*^9}, 3.563020757727827*^9, {
   3.56302081655553*^9, 3.5630208254007454`*^9}, 3.5630209318085327`*^9, {
   3.5630218360797205`*^9, 3.563021863426569*^9}, {3.5630219037370396`*^9, 
   3.563021918635066*^9}, {3.5630219850131826`*^9, 3.5630220960697775`*^9}, 
   3.56302247810887*^9, 3.5630225147597356`*^9, {3.5630227914389234`*^9, 
   3.5630228139497633`*^9}, {3.563022860718645*^9, 3.563022961978423*^9}, 
   3.5630244252141933`*^9, {3.56302450898634*^9, 3.563024538470392*^9}, 
   3.563024573898054*^9, {3.5630246048485084`*^9, 3.5630246393713694`*^9}, {
   3.563024669666622*^9, 3.5630246931290636`*^9}, 3.5630247649359894`*^9, 
   3.5630250207452393`*^9, 3.563025263450465*^9, 3.563027130305744*^9, 
   3.563027228117916*^9, {3.5630274502935066`*^9, 3.5630274739899483`*^9}, {
   3.5630277148231707`*^9, 3.5630277394712143`*^9}, {3.5630294341021905`*^9, 
   3.5630294574242315`*^9}, 3.563029489903489*^9, 3.5630295392931757`*^9, 
   3.5630296129097047`*^9, 3.5630297851964073`*^9, {3.5630298821349773`*^9, 
   3.5630298996070085`*^9}, 3.563044604979759*^9, 3.5630450931871867`*^9, 
   3.563045157209699*^9, 3.5630452052109833`*^9, 3.563045235787037*^9, 
   3.563045378652088*^9, {3.5630454110377455`*^9, 3.5630454334393845`*^9}, 
   3.5630456828994226`*^9, 3.563045781709996*^9, 3.5630458374644938`*^9, 
   3.5630458690857496`*^9, 3.5630462941864967`*^9, 3.56304645572478*^9, 
   3.5630465521329494`*^9, 3.5630466124582553`*^9, 3.5630467308312635`*^9, 
   3.563046882213929*^9, 3.5630472614469957`*^9, 3.563047348963149*^9, 
   3.5630474030328445`*^9, 3.563047851564832*^9, {3.5630480367371573`*^9, 
   3.563048060277599*^9}, 3.563048104690877*^9, 3.5630483629041305`*^9, 
   3.5630484046654034`*^9, 3.563048588827327*^9, 3.5630486703622694`*^9, 
   3.563048753229615*^9, {3.5630499328496895`*^9, 3.5630499471237144`*^9}, 
   3.5630499856557827`*^9, 3.563050042004681*^9, 3.563050077238743*^9, 
   3.5631065732665267`*^9, 3.563107642632543*^9, 3.5631076836570134`*^9, 
   3.5631110719644833`*^9, 3.5631115400192876`*^9, 3.563111598825388*^9, 
   3.5631116390814567`*^9, 3.56311182131497*^9, 3.563111949317589*^9, 
   3.563112783982228*^9, {3.5631129837985697`*^9, 3.5631130017854013`*^9}, 
   3.5631130626691027`*^9, 3.5631136942970057`*^9, 3.5631277471770678`*^9, 
   3.5631281219113255`*^9, 3.563128153298581*^9, 3.5631282388959312`*^9, 
   3.5631284212424755`*^9, 3.5631284518497286`*^9, 3.563128793934662*^9, 
   3.563128826367119*^9, 3.563128943382924*^9, 3.563129369794073*^9, {
   3.563129454533422*^9, 3.5631294742986565`*^9}, 3.5631296986894507`*^9, 
   3.5631297798251934`*^9, 3.563129872910557*^9, 3.563129954773501*^9, {
   3.563130047488064*^9, 3.563130067580899*^9}, 3.56313047110641*^9, 
   3.5631307464312935`*^9, 3.563130776866947*^9, 3.5633730059831457`*^9, 
   3.5633731021632805`*^9, 3.5633731485033455`*^9, 3.5633732187334433`*^9, 
   3.563553505104024*^9, 3.5647835560879936`*^9, 3.5648433002062635`*^9, 
   3.5648434942862043`*^9, 3.564843533863474*^9, {3.5648436392572594`*^9, 
   3.5648436681173096`*^9}, 3.564843956452616*^9, 3.564844038914361*^9, 
   3.564850817734276*^9, 3.5648508642847576`*^9, 3.56485091665405*^9, 
   3.5648515516219654`*^9, 3.5648525078256445`*^9, 3.5648526023930106`*^9, 
   3.564852654668702*^9, 3.567106143036501*^9, 3.584477521649786*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Sigma=\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2.25`", "0.`"},
       {"0.`", "0.25`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Sigma=", 
   MatrixForm[{{2.25, 0.}, {0., 0.25}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5629550986360693`*^9, 3.5629552384747143`*^9, 3.562955397017793*^9, {
   3.5629554461890793`*^9, 3.562955473286327*^9}, 3.562955546996456*^9, 
   3.5629555878685284`*^9, 3.562955627133797*^9, {3.5629556758214827`*^9, 
   3.5629556912499104`*^9}, 3.562955749516012*^9, 3.5629558033673067`*^9, 
   3.562955842694976*^9, 3.562963384191823*^9, 3.562963419042284*^9, 
   3.5630191524226074`*^9, 3.5630192141363153`*^9, {3.5630192856000414`*^9, 
   3.563019310185684*^9}, {3.5630193541153617`*^9, 3.5630193621181755`*^9}, 
   3.563019561034125*^9, {3.563020346167904*^9, 3.563020394621589*^9}, 
   3.563020527315422*^9, 3.5630205861275253`*^9, 3.563020631508005*^9, {
   3.5630206764048843`*^9, 3.563020718712158*^9}, 3.563020757727827*^9, {
   3.56302081655553*^9, 3.5630208254007454`*^9}, 3.5630209318085327`*^9, {
   3.5630218360797205`*^9, 3.563021863426569*^9}, {3.5630219037370396`*^9, 
   3.563021918635066*^9}, {3.5630219850131826`*^9, 3.5630220960697775`*^9}, 
   3.56302247810887*^9, 3.5630225147597356`*^9, {3.5630227914389234`*^9, 
   3.5630228139497633`*^9}, {3.563022860718645*^9, 3.563022961978423*^9}, 
   3.5630244252141933`*^9, {3.56302450898634*^9, 3.563024538470392*^9}, 
   3.563024573898054*^9, {3.5630246048485084`*^9, 3.5630246393713694`*^9}, {
   3.563024669666622*^9, 3.5630246931290636`*^9}, 3.5630247649359894`*^9, 
   3.5630250207452393`*^9, 3.563025263450465*^9, 3.563027130305744*^9, 
   3.563027228117916*^9, {3.5630274502935066`*^9, 3.5630274739899483`*^9}, {
   3.5630277148231707`*^9, 3.5630277394712143`*^9}, {3.5630294341021905`*^9, 
   3.5630294574242315`*^9}, 3.563029489903489*^9, 3.5630295392931757`*^9, 
   3.5630296129097047`*^9, 3.5630297851964073`*^9, {3.5630298821349773`*^9, 
   3.5630298996070085`*^9}, 3.563044604979759*^9, 3.5630450931871867`*^9, 
   3.563045157209699*^9, 3.5630452052109833`*^9, 3.563045235787037*^9, 
   3.563045378652088*^9, {3.5630454110377455`*^9, 3.5630454334393845`*^9}, 
   3.5630456828994226`*^9, 3.563045781709996*^9, 3.5630458374644938`*^9, 
   3.5630458690857496`*^9, 3.5630462941864967`*^9, 3.56304645572478*^9, 
   3.5630465521329494`*^9, 3.5630466124582553`*^9, 3.5630467308312635`*^9, 
   3.563046882213929*^9, 3.5630472614469957`*^9, 3.563047348963149*^9, 
   3.5630474030328445`*^9, 3.563047851564832*^9, {3.5630480367371573`*^9, 
   3.563048060277599*^9}, 3.563048104690877*^9, 3.5630483629041305`*^9, 
   3.5630484046654034`*^9, 3.563048588827327*^9, 3.5630486703622694`*^9, 
   3.563048753229615*^9, {3.5630499328496895`*^9, 3.5630499471237144`*^9}, 
   3.5630499856557827`*^9, 3.563050042004681*^9, 3.563050077238743*^9, 
   3.5631065732665267`*^9, 3.563107642632543*^9, 3.5631076836570134`*^9, 
   3.5631110719644833`*^9, 3.5631115400192876`*^9, 3.563111598825388*^9, 
   3.5631116390814567`*^9, 3.56311182131497*^9, 3.563111949317589*^9, 
   3.563112783982228*^9, {3.5631129837985697`*^9, 3.5631130017854013`*^9}, 
   3.5631130626691027`*^9, 3.5631136942970057`*^9, 3.5631277471770678`*^9, 
   3.5631281219113255`*^9, 3.563128153298581*^9, 3.5631282388959312`*^9, 
   3.5631284212424755`*^9, 3.5631284518497286`*^9, 3.563128793934662*^9, 
   3.563128826367119*^9, 3.563128943382924*^9, 3.563129369794073*^9, {
   3.563129454533422*^9, 3.5631294742986565`*^9}, 3.5631296986894507`*^9, 
   3.5631297798251934`*^9, 3.563129872910557*^9, 3.563129954773501*^9, {
   3.563130047488064*^9, 3.563130067580899*^9}, 3.56313047110641*^9, 
   3.5631307464312935`*^9, 3.563130776866947*^9, 3.5633730059831457`*^9, 
   3.5633731021632805`*^9, 3.5633731485033455`*^9, 3.5633732187334433`*^9, 
   3.563553505104024*^9, 3.5647835560879936`*^9, 3.5648433002062635`*^9, 
   3.5648434942862043`*^9, 3.564843533863474*^9, {3.5648436392572594`*^9, 
   3.5648436681173096`*^9}, 3.564843956452616*^9, 3.564844038914361*^9, 
   3.564850817734276*^9, 3.5648508642847576`*^9, 3.56485091665405*^9, 
   3.5648515516219654`*^9, 3.5648525078256445`*^9, 3.5648526023930106`*^9, 
   3.564852654668702*^9, 3.567106143036501*^9, 3.5844775216653857`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Evals = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2.25`", ",", "0.25`"}], "}"}], 
   "\[InvisibleSpace]", "\<\" as matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2.25`", "0.`"},
       {"0.`", "0.25`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Evals = ", {2.25, 0.25}, " as matrix = ", 
   MatrixForm[{{2.25, 0.}, {0., 0.25}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5629550986360693`*^9, 3.5629552384747143`*^9, 3.562955397017793*^9, {
   3.5629554461890793`*^9, 3.562955473286327*^9}, 3.562955546996456*^9, 
   3.5629555878685284`*^9, 3.562955627133797*^9, {3.5629556758214827`*^9, 
   3.5629556912499104`*^9}, 3.562955749516012*^9, 3.5629558033673067`*^9, 
   3.562955842694976*^9, 3.562963384191823*^9, 3.562963419042284*^9, 
   3.5630191524226074`*^9, 3.5630192141363153`*^9, {3.5630192856000414`*^9, 
   3.563019310185684*^9}, {3.5630193541153617`*^9, 3.5630193621181755`*^9}, 
   3.563019561034125*^9, {3.563020346167904*^9, 3.563020394621589*^9}, 
   3.563020527315422*^9, 3.5630205861275253`*^9, 3.563020631508005*^9, {
   3.5630206764048843`*^9, 3.563020718712158*^9}, 3.563020757727827*^9, {
   3.56302081655553*^9, 3.5630208254007454`*^9}, 3.5630209318085327`*^9, {
   3.5630218360797205`*^9, 3.563021863426569*^9}, {3.5630219037370396`*^9, 
   3.563021918635066*^9}, {3.5630219850131826`*^9, 3.5630220960697775`*^9}, 
   3.56302247810887*^9, 3.5630225147597356`*^9, {3.5630227914389234`*^9, 
   3.5630228139497633`*^9}, {3.563022860718645*^9, 3.563022961978423*^9}, 
   3.5630244252141933`*^9, {3.56302450898634*^9, 3.563024538470392*^9}, 
   3.563024573898054*^9, {3.5630246048485084`*^9, 3.5630246393713694`*^9}, {
   3.563024669666622*^9, 3.5630246931290636`*^9}, 3.5630247649359894`*^9, 
   3.5630250207452393`*^9, 3.563025263450465*^9, 3.563027130305744*^9, 
   3.563027228117916*^9, {3.5630274502935066`*^9, 3.5630274739899483`*^9}, {
   3.5630277148231707`*^9, 3.5630277394712143`*^9}, {3.5630294341021905`*^9, 
   3.5630294574242315`*^9}, 3.563029489903489*^9, 3.5630295392931757`*^9, 
   3.5630296129097047`*^9, 3.5630297851964073`*^9, {3.5630298821349773`*^9, 
   3.5630298996070085`*^9}, 3.563044604979759*^9, 3.5630450931871867`*^9, 
   3.563045157209699*^9, 3.5630452052109833`*^9, 3.563045235787037*^9, 
   3.563045378652088*^9, {3.5630454110377455`*^9, 3.5630454334393845`*^9}, 
   3.5630456828994226`*^9, 3.563045781709996*^9, 3.5630458374644938`*^9, 
   3.5630458690857496`*^9, 3.5630462941864967`*^9, 3.56304645572478*^9, 
   3.5630465521329494`*^9, 3.5630466124582553`*^9, 3.5630467308312635`*^9, 
   3.563046882213929*^9, 3.5630472614469957`*^9, 3.563047348963149*^9, 
   3.5630474030328445`*^9, 3.563047851564832*^9, {3.5630480367371573`*^9, 
   3.563048060277599*^9}, 3.563048104690877*^9, 3.5630483629041305`*^9, 
   3.5630484046654034`*^9, 3.563048588827327*^9, 3.5630486703622694`*^9, 
   3.563048753229615*^9, {3.5630499328496895`*^9, 3.5630499471237144`*^9}, 
   3.5630499856557827`*^9, 3.563050042004681*^9, 3.563050077238743*^9, 
   3.5631065732665267`*^9, 3.563107642632543*^9, 3.5631076836570134`*^9, 
   3.5631110719644833`*^9, 3.5631115400192876`*^9, 3.563111598825388*^9, 
   3.5631116390814567`*^9, 3.56311182131497*^9, 3.563111949317589*^9, 
   3.563112783982228*^9, {3.5631129837985697`*^9, 3.5631130017854013`*^9}, 
   3.5631130626691027`*^9, 3.5631136942970057`*^9, 3.5631277471770678`*^9, 
   3.5631281219113255`*^9, 3.563128153298581*^9, 3.5631282388959312`*^9, 
   3.5631284212424755`*^9, 3.5631284518497286`*^9, 3.563128793934662*^9, 
   3.563128826367119*^9, 3.563128943382924*^9, 3.563129369794073*^9, {
   3.563129454533422*^9, 3.5631294742986565`*^9}, 3.5631296986894507`*^9, 
   3.5631297798251934`*^9, 3.563129872910557*^9, 3.563129954773501*^9, {
   3.563130047488064*^9, 3.563130067580899*^9}, 3.56313047110641*^9, 
   3.5631307464312935`*^9, 3.563130776866947*^9, 3.5633730059831457`*^9, 
   3.5633731021632805`*^9, 3.5633731485033455`*^9, 3.5633732187334433`*^9, 
   3.563553505104024*^9, 3.5647835560879936`*^9, 3.5648433002062635`*^9, 
   3.5648434942862043`*^9, 3.564843533863474*^9, {3.5648436392572594`*^9, 
   3.5648436681173096`*^9}, 3.564843956452616*^9, 3.564844038914361*^9, 
   3.564850817734276*^9, 3.5648508642847576`*^9, 3.56485091665405*^9, 
   3.5648515516219654`*^9, 3.5648525078256445`*^9, 3.5648526023930106`*^9, 
   3.564852654668702*^9, 3.567106143036501*^9, 3.5844775216653857`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Evecs (rows) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.7071067811865475`", "0.7071067811865475`"},
       {
        RowBox[{"-", "0.7071067811865475`"}], "0.7071067811865475`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Evecs (rows) = ", 
   MatrixForm[{{0.7071067811865475, 0.7071067811865475}, {-0.7071067811865475,
     0.7071067811865475}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5629550986360693`*^9, 3.5629552384747143`*^9, 3.562955397017793*^9, {
   3.5629554461890793`*^9, 3.562955473286327*^9}, 3.562955546996456*^9, 
   3.5629555878685284`*^9, 3.562955627133797*^9, {3.5629556758214827`*^9, 
   3.5629556912499104`*^9}, 3.562955749516012*^9, 3.5629558033673067`*^9, 
   3.562955842694976*^9, 3.562963384191823*^9, 3.562963419042284*^9, 
   3.5630191524226074`*^9, 3.5630192141363153`*^9, {3.5630192856000414`*^9, 
   3.563019310185684*^9}, {3.5630193541153617`*^9, 3.5630193621181755`*^9}, 
   3.563019561034125*^9, {3.563020346167904*^9, 3.563020394621589*^9}, 
   3.563020527315422*^9, 3.5630205861275253`*^9, 3.563020631508005*^9, {
   3.5630206764048843`*^9, 3.563020718712158*^9}, 3.563020757727827*^9, {
   3.56302081655553*^9, 3.5630208254007454`*^9}, 3.5630209318085327`*^9, {
   3.5630218360797205`*^9, 3.563021863426569*^9}, {3.5630219037370396`*^9, 
   3.563021918635066*^9}, {3.5630219850131826`*^9, 3.5630220960697775`*^9}, 
   3.56302247810887*^9, 3.5630225147597356`*^9, {3.5630227914389234`*^9, 
   3.5630228139497633`*^9}, {3.563022860718645*^9, 3.563022961978423*^9}, 
   3.5630244252141933`*^9, {3.56302450898634*^9, 3.563024538470392*^9}, 
   3.563024573898054*^9, {3.5630246048485084`*^9, 3.5630246393713694`*^9}, {
   3.563024669666622*^9, 3.5630246931290636`*^9}, 3.5630247649359894`*^9, 
   3.5630250207452393`*^9, 3.563025263450465*^9, 3.563027130305744*^9, 
   3.563027228117916*^9, {3.5630274502935066`*^9, 3.5630274739899483`*^9}, {
   3.5630277148231707`*^9, 3.5630277394712143`*^9}, {3.5630294341021905`*^9, 
   3.5630294574242315`*^9}, 3.563029489903489*^9, 3.5630295392931757`*^9, 
   3.5630296129097047`*^9, 3.5630297851964073`*^9, {3.5630298821349773`*^9, 
   3.5630298996070085`*^9}, 3.563044604979759*^9, 3.5630450931871867`*^9, 
   3.563045157209699*^9, 3.5630452052109833`*^9, 3.563045235787037*^9, 
   3.563045378652088*^9, {3.5630454110377455`*^9, 3.5630454334393845`*^9}, 
   3.5630456828994226`*^9, 3.563045781709996*^9, 3.5630458374644938`*^9, 
   3.5630458690857496`*^9, 3.5630462941864967`*^9, 3.56304645572478*^9, 
   3.5630465521329494`*^9, 3.5630466124582553`*^9, 3.5630467308312635`*^9, 
   3.563046882213929*^9, 3.5630472614469957`*^9, 3.563047348963149*^9, 
   3.5630474030328445`*^9, 3.563047851564832*^9, {3.5630480367371573`*^9, 
   3.563048060277599*^9}, 3.563048104690877*^9, 3.5630483629041305`*^9, 
   3.5630484046654034`*^9, 3.563048588827327*^9, 3.5630486703622694`*^9, 
   3.563048753229615*^9, {3.5630499328496895`*^9, 3.5630499471237144`*^9}, 
   3.5630499856557827`*^9, 3.563050042004681*^9, 3.563050077238743*^9, 
   3.5631065732665267`*^9, 3.563107642632543*^9, 3.5631076836570134`*^9, 
   3.5631110719644833`*^9, 3.5631115400192876`*^9, 3.563111598825388*^9, 
   3.5631116390814567`*^9, 3.56311182131497*^9, 3.563111949317589*^9, 
   3.563112783982228*^9, {3.5631129837985697`*^9, 3.5631130017854013`*^9}, 
   3.5631130626691027`*^9, 3.5631136942970057`*^9, 3.5631277471770678`*^9, 
   3.5631281219113255`*^9, 3.563128153298581*^9, 3.5631282388959312`*^9, 
   3.5631284212424755`*^9, 3.5631284518497286`*^9, 3.563128793934662*^9, 
   3.563128826367119*^9, 3.563128943382924*^9, 3.563129369794073*^9, {
   3.563129454533422*^9, 3.5631294742986565`*^9}, 3.5631296986894507`*^9, 
   3.5631297798251934`*^9, 3.563129872910557*^9, 3.563129954773501*^9, {
   3.563130047488064*^9, 3.563130067580899*^9}, 3.56313047110641*^9, 
   3.5631307464312935`*^9, 3.563130776866947*^9, 3.5633730059831457`*^9, 
   3.5633731021632805`*^9, 3.5633731485033455`*^9, 3.5633732187334433`*^9, 
   3.563553505104024*^9, 3.5647835560879936`*^9, 3.5648433002062635`*^9, 
   3.5648434942862043`*^9, 3.564843533863474*^9, {3.5648436392572594`*^9, 
   3.5648436681173096`*^9}, 3.564843956452616*^9, 3.564844038914361*^9, 
   3.564850817734276*^9, 3.5648508642847576`*^9, 3.56485091665405*^9, 
   3.5648515516219654`*^9, 3.5648525078256445`*^9, 3.5648526023930106`*^9, 
   3.564852654668702*^9, 3.567106143036501*^9, 3.5844775216653857`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Check decomposition: m = R.Lambda.R^T = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.2499999999999998`", "0.9999999999999998`"},
       {"0.9999999999999998`", "1.2499999999999998`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Check decomposition: m = R.Lambda.R^T = ", 
   MatrixForm[{{1.2499999999999998`, 0.9999999999999998}, {0.9999999999999998,
     1.2499999999999998`}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5629550986360693`*^9, 3.5629552384747143`*^9, 3.562955397017793*^9, {
   3.5629554461890793`*^9, 3.562955473286327*^9}, 3.562955546996456*^9, 
   3.5629555878685284`*^9, 3.562955627133797*^9, {3.5629556758214827`*^9, 
   3.5629556912499104`*^9}, 3.562955749516012*^9, 3.5629558033673067`*^9, 
   3.562955842694976*^9, 3.562963384191823*^9, 3.562963419042284*^9, 
   3.5630191524226074`*^9, 3.5630192141363153`*^9, {3.5630192856000414`*^9, 
   3.563019310185684*^9}, {3.5630193541153617`*^9, 3.5630193621181755`*^9}, 
   3.563019561034125*^9, {3.563020346167904*^9, 3.563020394621589*^9}, 
   3.563020527315422*^9, 3.5630205861275253`*^9, 3.563020631508005*^9, {
   3.5630206764048843`*^9, 3.563020718712158*^9}, 3.563020757727827*^9, {
   3.56302081655553*^9, 3.5630208254007454`*^9}, 3.5630209318085327`*^9, {
   3.5630218360797205`*^9, 3.563021863426569*^9}, {3.5630219037370396`*^9, 
   3.563021918635066*^9}, {3.5630219850131826`*^9, 3.5630220960697775`*^9}, 
   3.56302247810887*^9, 3.5630225147597356`*^9, {3.5630227914389234`*^9, 
   3.5630228139497633`*^9}, {3.563022860718645*^9, 3.563022961978423*^9}, 
   3.5630244252141933`*^9, {3.56302450898634*^9, 3.563024538470392*^9}, 
   3.563024573898054*^9, {3.5630246048485084`*^9, 3.5630246393713694`*^9}, {
   3.563024669666622*^9, 3.5630246931290636`*^9}, 3.5630247649359894`*^9, 
   3.5630250207452393`*^9, 3.563025263450465*^9, 3.563027130305744*^9, 
   3.563027228117916*^9, {3.5630274502935066`*^9, 3.5630274739899483`*^9}, {
   3.5630277148231707`*^9, 3.5630277394712143`*^9}, {3.5630294341021905`*^9, 
   3.5630294574242315`*^9}, 3.563029489903489*^9, 3.5630295392931757`*^9, 
   3.5630296129097047`*^9, 3.5630297851964073`*^9, {3.5630298821349773`*^9, 
   3.5630298996070085`*^9}, 3.563044604979759*^9, 3.5630450931871867`*^9, 
   3.563045157209699*^9, 3.5630452052109833`*^9, 3.563045235787037*^9, 
   3.563045378652088*^9, {3.5630454110377455`*^9, 3.5630454334393845`*^9}, 
   3.5630456828994226`*^9, 3.563045781709996*^9, 3.5630458374644938`*^9, 
   3.5630458690857496`*^9, 3.5630462941864967`*^9, 3.56304645572478*^9, 
   3.5630465521329494`*^9, 3.5630466124582553`*^9, 3.5630467308312635`*^9, 
   3.563046882213929*^9, 3.5630472614469957`*^9, 3.563047348963149*^9, 
   3.5630474030328445`*^9, 3.563047851564832*^9, {3.5630480367371573`*^9, 
   3.563048060277599*^9}, 3.563048104690877*^9, 3.5630483629041305`*^9, 
   3.5630484046654034`*^9, 3.563048588827327*^9, 3.5630486703622694`*^9, 
   3.563048753229615*^9, {3.5630499328496895`*^9, 3.5630499471237144`*^9}, 
   3.5630499856557827`*^9, 3.563050042004681*^9, 3.563050077238743*^9, 
   3.5631065732665267`*^9, 3.563107642632543*^9, 3.5631076836570134`*^9, 
   3.5631110719644833`*^9, 3.5631115400192876`*^9, 3.563111598825388*^9, 
   3.5631116390814567`*^9, 3.56311182131497*^9, 3.563111949317589*^9, 
   3.563112783982228*^9, {3.5631129837985697`*^9, 3.5631130017854013`*^9}, 
   3.5631130626691027`*^9, 3.5631136942970057`*^9, 3.5631277471770678`*^9, 
   3.5631281219113255`*^9, 3.563128153298581*^9, 3.5631282388959312`*^9, 
   3.5631284212424755`*^9, 3.5631284518497286`*^9, 3.563128793934662*^9, 
   3.563128826367119*^9, 3.563128943382924*^9, 3.563129369794073*^9, {
   3.563129454533422*^9, 3.5631294742986565`*^9}, 3.5631296986894507`*^9, 
   3.5631297798251934`*^9, 3.563129872910557*^9, 3.563129954773501*^9, {
   3.563130047488064*^9, 3.563130067580899*^9}, 3.56313047110641*^9, 
   3.5631307464312935`*^9, 3.563130776866947*^9, 3.5633730059831457`*^9, 
   3.5633731021632805`*^9, 3.5633731485033455`*^9, 3.5633732187334433`*^9, 
   3.563553505104024*^9, 3.5647835560879936`*^9, 3.5648433002062635`*^9, 
   3.5648434942862043`*^9, 3.564843533863474*^9, {3.5648436392572594`*^9, 
   3.5648436681173096`*^9}, 3.564843956452616*^9, 3.564844038914361*^9, 
   3.564850817734276*^9, 3.5648508642847576`*^9, 3.56485091665405*^9, 
   3.5648515516219654`*^9, 3.5648525078256445`*^9, 3.5648526023930106`*^9, 
   3.564852654668702*^9, 3.567106143036501*^9, 3.5844775216653857`*^9}],

Cell[BoxData["\<\"Notice variation is sign of eigenvectors that are returned \
from SVD or Eign*\"\>"], "Print",
 CellChangeTimes->{
  3.5629550986360693`*^9, 3.5629552384747143`*^9, 3.562955397017793*^9, {
   3.5629554461890793`*^9, 3.562955473286327*^9}, 3.562955546996456*^9, 
   3.5629555878685284`*^9, 3.562955627133797*^9, {3.5629556758214827`*^9, 
   3.5629556912499104`*^9}, 3.562955749516012*^9, 3.5629558033673067`*^9, 
   3.562955842694976*^9, 3.562963384191823*^9, 3.562963419042284*^9, 
   3.5630191524226074`*^9, 3.5630192141363153`*^9, {3.5630192856000414`*^9, 
   3.563019310185684*^9}, {3.5630193541153617`*^9, 3.5630193621181755`*^9}, 
   3.563019561034125*^9, {3.563020346167904*^9, 3.563020394621589*^9}, 
   3.563020527315422*^9, 3.5630205861275253`*^9, 3.563020631508005*^9, {
   3.5630206764048843`*^9, 3.563020718712158*^9}, 3.563020757727827*^9, {
   3.56302081655553*^9, 3.5630208254007454`*^9}, 3.5630209318085327`*^9, {
   3.5630218360797205`*^9, 3.563021863426569*^9}, {3.5630219037370396`*^9, 
   3.563021918635066*^9}, {3.5630219850131826`*^9, 3.5630220960697775`*^9}, 
   3.56302247810887*^9, 3.5630225147597356`*^9, {3.5630227914389234`*^9, 
   3.5630228139497633`*^9}, {3.563022860718645*^9, 3.563022961978423*^9}, 
   3.5630244252141933`*^9, {3.56302450898634*^9, 3.563024538470392*^9}, 
   3.563024573898054*^9, {3.5630246048485084`*^9, 3.5630246393713694`*^9}, {
   3.563024669666622*^9, 3.5630246931290636`*^9}, 3.5630247649359894`*^9, 
   3.5630250207452393`*^9, 3.563025263450465*^9, 3.563027130305744*^9, 
   3.563027228117916*^9, {3.5630274502935066`*^9, 3.5630274739899483`*^9}, {
   3.5630277148231707`*^9, 3.5630277394712143`*^9}, {3.5630294341021905`*^9, 
   3.5630294574242315`*^9}, 3.563029489903489*^9, 3.5630295392931757`*^9, 
   3.5630296129097047`*^9, 3.5630297851964073`*^9, {3.5630298821349773`*^9, 
   3.5630298996070085`*^9}, 3.563044604979759*^9, 3.5630450931871867`*^9, 
   3.563045157209699*^9, 3.5630452052109833`*^9, 3.563045235787037*^9, 
   3.563045378652088*^9, {3.5630454110377455`*^9, 3.5630454334393845`*^9}, 
   3.5630456828994226`*^9, 3.563045781709996*^9, 3.5630458374644938`*^9, 
   3.5630458690857496`*^9, 3.5630462941864967`*^9, 3.56304645572478*^9, 
   3.5630465521329494`*^9, 3.5630466124582553`*^9, 3.5630467308312635`*^9, 
   3.563046882213929*^9, 3.5630472614469957`*^9, 3.563047348963149*^9, 
   3.5630474030328445`*^9, 3.563047851564832*^9, {3.5630480367371573`*^9, 
   3.563048060277599*^9}, 3.563048104690877*^9, 3.5630483629041305`*^9, 
   3.5630484046654034`*^9, 3.563048588827327*^9, 3.5630486703622694`*^9, 
   3.563048753229615*^9, {3.5630499328496895`*^9, 3.5630499471237144`*^9}, 
   3.5630499856557827`*^9, 3.563050042004681*^9, 3.563050077238743*^9, 
   3.5631065732665267`*^9, 3.563107642632543*^9, 3.5631076836570134`*^9, 
   3.5631110719644833`*^9, 3.5631115400192876`*^9, 3.563111598825388*^9, 
   3.5631116390814567`*^9, 3.56311182131497*^9, 3.563111949317589*^9, 
   3.563112783982228*^9, {3.5631129837985697`*^9, 3.5631130017854013`*^9}, 
   3.5631130626691027`*^9, 3.5631136942970057`*^9, 3.5631277471770678`*^9, 
   3.5631281219113255`*^9, 3.563128153298581*^9, 3.5631282388959312`*^9, 
   3.5631284212424755`*^9, 3.5631284518497286`*^9, 3.563128793934662*^9, 
   3.563128826367119*^9, 3.563128943382924*^9, 3.563129369794073*^9, {
   3.563129454533422*^9, 3.5631294742986565`*^9}, 3.5631296986894507`*^9, 
   3.5631297798251934`*^9, 3.563129872910557*^9, 3.563129954773501*^9, {
   3.563130047488064*^9, 3.563130067580899*^9}, 3.56313047110641*^9, 
   3.5631307464312935`*^9, 3.563130776866947*^9, 3.5633730059831457`*^9, 
   3.5633731021632805`*^9, 3.5633731485033455`*^9, 3.5633732187334433`*^9, 
   3.563553505104024*^9, 3.5647835560879936`*^9, 3.5648433002062635`*^9, 
   3.5648434942862043`*^9, 3.564843533863474*^9, {3.5648436392572594`*^9, 
   3.5648436681173096`*^9}, 3.564843956452616*^9, 3.564844038914361*^9, 
   3.564850817734276*^9, 3.5648508642847576`*^9, 3.56485091665405*^9, 
   3.5648515516219654`*^9, 3.5648525078256445`*^9, 3.5648526023930106`*^9, 
   3.564852654668702*^9, 3.567106143036501*^9, 3.5844775216653857`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"major=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1.590990257669732`", ",", "1.590990257669732`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"  minor=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.17677669529663687`"}], ",", "0.17677669529663687`"}], 
    "}"}]}],
  SequenceForm[
  "major=", {1.590990257669732, 1.590990257669732}, 
   "  minor=", {-0.17677669529663687`, 0.17677669529663687`}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5629550986360693`*^9, 3.5629552384747143`*^9, 3.562955397017793*^9, {
   3.5629554461890793`*^9, 3.562955473286327*^9}, 3.562955546996456*^9, 
   3.5629555878685284`*^9, 3.562955627133797*^9, {3.5629556758214827`*^9, 
   3.5629556912499104`*^9}, 3.562955749516012*^9, 3.5629558033673067`*^9, 
   3.562955842694976*^9, 3.562963384191823*^9, 3.562963419042284*^9, 
   3.5630191524226074`*^9, 3.5630192141363153`*^9, {3.5630192856000414`*^9, 
   3.563019310185684*^9}, {3.5630193541153617`*^9, 3.5630193621181755`*^9}, 
   3.563019561034125*^9, {3.563020346167904*^9, 3.563020394621589*^9}, 
   3.563020527315422*^9, 3.5630205861275253`*^9, 3.563020631508005*^9, {
   3.5630206764048843`*^9, 3.563020718712158*^9}, 3.563020757727827*^9, {
   3.56302081655553*^9, 3.5630208254007454`*^9}, 3.5630209318085327`*^9, {
   3.5630218360797205`*^9, 3.563021863426569*^9}, {3.5630219037370396`*^9, 
   3.563021918635066*^9}, {3.5630219850131826`*^9, 3.5630220960697775`*^9}, 
   3.56302247810887*^9, 3.5630225147597356`*^9, {3.5630227914389234`*^9, 
   3.5630228139497633`*^9}, {3.563022860718645*^9, 3.563022961978423*^9}, 
   3.5630244252141933`*^9, {3.56302450898634*^9, 3.563024538470392*^9}, 
   3.563024573898054*^9, {3.5630246048485084`*^9, 3.5630246393713694`*^9}, {
   3.563024669666622*^9, 3.5630246931290636`*^9}, 3.5630247649359894`*^9, 
   3.5630250207452393`*^9, 3.563025263450465*^9, 3.563027130305744*^9, 
   3.563027228117916*^9, {3.5630274502935066`*^9, 3.5630274739899483`*^9}, {
   3.5630277148231707`*^9, 3.5630277394712143`*^9}, {3.5630294341021905`*^9, 
   3.5630294574242315`*^9}, 3.563029489903489*^9, 3.5630295392931757`*^9, 
   3.5630296129097047`*^9, 3.5630297851964073`*^9, {3.5630298821349773`*^9, 
   3.5630298996070085`*^9}, 3.563044604979759*^9, 3.5630450931871867`*^9, 
   3.563045157209699*^9, 3.5630452052109833`*^9, 3.563045235787037*^9, 
   3.563045378652088*^9, {3.5630454110377455`*^9, 3.5630454334393845`*^9}, 
   3.5630456828994226`*^9, 3.563045781709996*^9, 3.5630458374644938`*^9, 
   3.5630458690857496`*^9, 3.5630462941864967`*^9, 3.56304645572478*^9, 
   3.5630465521329494`*^9, 3.5630466124582553`*^9, 3.5630467308312635`*^9, 
   3.563046882213929*^9, 3.5630472614469957`*^9, 3.563047348963149*^9, 
   3.5630474030328445`*^9, 3.563047851564832*^9, {3.5630480367371573`*^9, 
   3.563048060277599*^9}, 3.563048104690877*^9, 3.5630483629041305`*^9, 
   3.5630484046654034`*^9, 3.563048588827327*^9, 3.5630486703622694`*^9, 
   3.563048753229615*^9, {3.5630499328496895`*^9, 3.5630499471237144`*^9}, 
   3.5630499856557827`*^9, 3.563050042004681*^9, 3.563050077238743*^9, 
   3.5631065732665267`*^9, 3.563107642632543*^9, 3.5631076836570134`*^9, 
   3.5631110719644833`*^9, 3.5631115400192876`*^9, 3.563111598825388*^9, 
   3.5631116390814567`*^9, 3.56311182131497*^9, 3.563111949317589*^9, 
   3.563112783982228*^9, {3.5631129837985697`*^9, 3.5631130017854013`*^9}, 
   3.5631130626691027`*^9, 3.5631136942970057`*^9, 3.5631277471770678`*^9, 
   3.5631281219113255`*^9, 3.563128153298581*^9, 3.5631282388959312`*^9, 
   3.5631284212424755`*^9, 3.5631284518497286`*^9, 3.563128793934662*^9, 
   3.563128826367119*^9, 3.563128943382924*^9, 3.563129369794073*^9, {
   3.563129454533422*^9, 3.5631294742986565`*^9}, 3.5631296986894507`*^9, 
   3.5631297798251934`*^9, 3.563129872910557*^9, 3.563129954773501*^9, {
   3.563130047488064*^9, 3.563130067580899*^9}, 3.56313047110641*^9, 
   3.5631307464312935`*^9, 3.563130776866947*^9, 3.5633730059831457`*^9, 
   3.5633731021632805`*^9, 3.5633731485033455`*^9, 3.5633732187334433`*^9, 
   3.563553505104024*^9, 3.5647835560879936`*^9, 3.5648433002062635`*^9, 
   3.5648434942862043`*^9, 3.564843533863474*^9, {3.5648436392572594`*^9, 
   3.5648436681173096`*^9}, 3.564843956452616*^9, 3.564844038914361*^9, 
   3.564850817734276*^9, 3.5648508642847576`*^9, 3.56485091665405*^9, 
   3.5648515516219654`*^9, 3.5648525078256445`*^9, 3.5648526023930106`*^9, 
   3.564852654668702*^9, 3.567106143036501*^9, 3.5844775216653857`*^9}],

Cell[BoxData["\<\"   \"\>"], "Print",
 CellChangeTimes->{
  3.5629550986360693`*^9, 3.5629552384747143`*^9, 3.562955397017793*^9, {
   3.5629554461890793`*^9, 3.562955473286327*^9}, 3.562955546996456*^9, 
   3.5629555878685284`*^9, 3.562955627133797*^9, {3.5629556758214827`*^9, 
   3.5629556912499104`*^9}, 3.562955749516012*^9, 3.5629558033673067`*^9, 
   3.562955842694976*^9, 3.562963384191823*^9, 3.562963419042284*^9, 
   3.5630191524226074`*^9, 3.5630192141363153`*^9, {3.5630192856000414`*^9, 
   3.563019310185684*^9}, {3.5630193541153617`*^9, 3.5630193621181755`*^9}, 
   3.563019561034125*^9, {3.563020346167904*^9, 3.563020394621589*^9}, 
   3.563020527315422*^9, 3.5630205861275253`*^9, 3.563020631508005*^9, {
   3.5630206764048843`*^9, 3.563020718712158*^9}, 3.563020757727827*^9, {
   3.56302081655553*^9, 3.5630208254007454`*^9}, 3.5630209318085327`*^9, {
   3.5630218360797205`*^9, 3.563021863426569*^9}, {3.5630219037370396`*^9, 
   3.563021918635066*^9}, {3.5630219850131826`*^9, 3.5630220960697775`*^9}, 
   3.56302247810887*^9, 3.5630225147597356`*^9, {3.5630227914389234`*^9, 
   3.5630228139497633`*^9}, {3.563022860718645*^9, 3.563022961978423*^9}, 
   3.5630244252141933`*^9, {3.56302450898634*^9, 3.563024538470392*^9}, 
   3.563024573898054*^9, {3.5630246048485084`*^9, 3.5630246393713694`*^9}, {
   3.563024669666622*^9, 3.5630246931290636`*^9}, 3.5630247649359894`*^9, 
   3.5630250207452393`*^9, 3.563025263450465*^9, 3.563027130305744*^9, 
   3.563027228117916*^9, {3.5630274502935066`*^9, 3.5630274739899483`*^9}, {
   3.5630277148231707`*^9, 3.5630277394712143`*^9}, {3.5630294341021905`*^9, 
   3.5630294574242315`*^9}, 3.563029489903489*^9, 3.5630295392931757`*^9, 
   3.5630296129097047`*^9, 3.5630297851964073`*^9, {3.5630298821349773`*^9, 
   3.5630298996070085`*^9}, 3.563044604979759*^9, 3.5630450931871867`*^9, 
   3.563045157209699*^9, 3.5630452052109833`*^9, 3.563045235787037*^9, 
   3.563045378652088*^9, {3.5630454110377455`*^9, 3.5630454334393845`*^9}, 
   3.5630456828994226`*^9, 3.563045781709996*^9, 3.5630458374644938`*^9, 
   3.5630458690857496`*^9, 3.5630462941864967`*^9, 3.56304645572478*^9, 
   3.5630465521329494`*^9, 3.5630466124582553`*^9, 3.5630467308312635`*^9, 
   3.563046882213929*^9, 3.5630472614469957`*^9, 3.563047348963149*^9, 
   3.5630474030328445`*^9, 3.563047851564832*^9, {3.5630480367371573`*^9, 
   3.563048060277599*^9}, 3.563048104690877*^9, 3.5630483629041305`*^9, 
   3.5630484046654034`*^9, 3.563048588827327*^9, 3.5630486703622694`*^9, 
   3.563048753229615*^9, {3.5630499328496895`*^9, 3.5630499471237144`*^9}, 
   3.5630499856557827`*^9, 3.563050042004681*^9, 3.563050077238743*^9, 
   3.5631065732665267`*^9, 3.563107642632543*^9, 3.5631076836570134`*^9, 
   3.5631110719644833`*^9, 3.5631115400192876`*^9, 3.563111598825388*^9, 
   3.5631116390814567`*^9, 3.56311182131497*^9, 3.563111949317589*^9, 
   3.563112783982228*^9, {3.5631129837985697`*^9, 3.5631130017854013`*^9}, 
   3.5631130626691027`*^9, 3.5631136942970057`*^9, 3.5631277471770678`*^9, 
   3.5631281219113255`*^9, 3.563128153298581*^9, 3.5631282388959312`*^9, 
   3.5631284212424755`*^9, 3.5631284518497286`*^9, 3.563128793934662*^9, 
   3.563128826367119*^9, 3.563128943382924*^9, 3.563129369794073*^9, {
   3.563129454533422*^9, 3.5631294742986565`*^9}, 3.5631296986894507`*^9, 
   3.5631297798251934`*^9, 3.563129872910557*^9, 3.563129954773501*^9, {
   3.563130047488064*^9, 3.563130067580899*^9}, 3.56313047110641*^9, 
   3.5631307464312935`*^9, 3.563130776866947*^9, 3.5633730059831457`*^9, 
   3.5633731021632805`*^9, 3.5633731485033455`*^9, 3.5633732187334433`*^9, 
   3.563553505104024*^9, 3.5647835560879936`*^9, 3.5648433002062635`*^9, 
   3.5648434942862043`*^9, 3.564843533863474*^9, {3.5648436392572594`*^9, 
   3.5648436681173096`*^9}, 3.564843956452616*^9, 3.564844038914361*^9, 
   3.564850817734276*^9, 3.5648508642847576`*^9, 3.56485091665405*^9, 
   3.5648515516219654`*^9, 3.5648525078256445`*^9, 3.5648526023930106`*^9, 
   3.564852654668702*^9, 3.567106143036501*^9, 3.5844775216653857`*^9}],

Cell[BoxData["\<\"Quadratic Form x^T M x over the unit circle\"\>"], "Print",
 CellChangeTimes->{
  3.5629550986360693`*^9, 3.5629552384747143`*^9, 3.562955397017793*^9, {
   3.5629554461890793`*^9, 3.562955473286327*^9}, 3.562955546996456*^9, 
   3.5629555878685284`*^9, 3.562955627133797*^9, {3.5629556758214827`*^9, 
   3.5629556912499104`*^9}, 3.562955749516012*^9, 3.5629558033673067`*^9, 
   3.562955842694976*^9, 3.562963384191823*^9, 3.562963419042284*^9, 
   3.5630191524226074`*^9, 3.5630192141363153`*^9, {3.5630192856000414`*^9, 
   3.563019310185684*^9}, {3.5630193541153617`*^9, 3.5630193621181755`*^9}, 
   3.563019561034125*^9, {3.563020346167904*^9, 3.563020394621589*^9}, 
   3.563020527315422*^9, 3.5630205861275253`*^9, 3.563020631508005*^9, {
   3.5630206764048843`*^9, 3.563020718712158*^9}, 3.563020757727827*^9, {
   3.56302081655553*^9, 3.5630208254007454`*^9}, 3.5630209318085327`*^9, {
   3.5630218360797205`*^9, 3.563021863426569*^9}, {3.5630219037370396`*^9, 
   3.563021918635066*^9}, {3.5630219850131826`*^9, 3.5630220960697775`*^9}, 
   3.56302247810887*^9, 3.5630225147597356`*^9, {3.5630227914389234`*^9, 
   3.5630228139497633`*^9}, {3.563022860718645*^9, 3.563022961978423*^9}, 
   3.5630244252141933`*^9, {3.56302450898634*^9, 3.563024538470392*^9}, 
   3.563024573898054*^9, {3.5630246048485084`*^9, 3.5630246393713694`*^9}, {
   3.563024669666622*^9, 3.5630246931290636`*^9}, 3.5630247649359894`*^9, 
   3.5630250207452393`*^9, 3.563025263450465*^9, 3.563027130305744*^9, 
   3.563027228117916*^9, {3.5630274502935066`*^9, 3.5630274739899483`*^9}, {
   3.5630277148231707`*^9, 3.5630277394712143`*^9}, {3.5630294341021905`*^9, 
   3.5630294574242315`*^9}, 3.563029489903489*^9, 3.5630295392931757`*^9, 
   3.5630296129097047`*^9, 3.5630297851964073`*^9, {3.5630298821349773`*^9, 
   3.5630298996070085`*^9}, 3.563044604979759*^9, 3.5630450931871867`*^9, 
   3.563045157209699*^9, 3.5630452052109833`*^9, 3.563045235787037*^9, 
   3.563045378652088*^9, {3.5630454110377455`*^9, 3.5630454334393845`*^9}, 
   3.5630456828994226`*^9, 3.563045781709996*^9, 3.5630458374644938`*^9, 
   3.5630458690857496`*^9, 3.5630462941864967`*^9, 3.56304645572478*^9, 
   3.5630465521329494`*^9, 3.5630466124582553`*^9, 3.5630467308312635`*^9, 
   3.563046882213929*^9, 3.5630472614469957`*^9, 3.563047348963149*^9, 
   3.5630474030328445`*^9, 3.563047851564832*^9, {3.5630480367371573`*^9, 
   3.563048060277599*^9}, 3.563048104690877*^9, 3.5630483629041305`*^9, 
   3.5630484046654034`*^9, 3.563048588827327*^9, 3.5630486703622694`*^9, 
   3.563048753229615*^9, {3.5630499328496895`*^9, 3.5630499471237144`*^9}, 
   3.5630499856557827`*^9, 3.563050042004681*^9, 3.563050077238743*^9, 
   3.5631065732665267`*^9, 3.563107642632543*^9, 3.5631076836570134`*^9, 
   3.5631110719644833`*^9, 3.5631115400192876`*^9, 3.563111598825388*^9, 
   3.5631116390814567`*^9, 3.56311182131497*^9, 3.563111949317589*^9, 
   3.563112783982228*^9, {3.5631129837985697`*^9, 3.5631130017854013`*^9}, 
   3.5631130626691027`*^9, 3.5631136942970057`*^9, 3.5631277471770678`*^9, 
   3.5631281219113255`*^9, 3.563128153298581*^9, 3.5631282388959312`*^9, 
   3.5631284212424755`*^9, 3.5631284518497286`*^9, 3.563128793934662*^9, 
   3.563128826367119*^9, 3.563128943382924*^9, 3.563129369794073*^9, {
   3.563129454533422*^9, 3.5631294742986565`*^9}, 3.5631296986894507`*^9, 
   3.5631297798251934`*^9, 3.563129872910557*^9, 3.563129954773501*^9, {
   3.563130047488064*^9, 3.563130067580899*^9}, 3.56313047110641*^9, 
   3.5631307464312935`*^9, 3.563130776866947*^9, 3.5633730059831457`*^9, 
   3.5633731021632805`*^9, 3.5633731485033455`*^9, 3.5633732187334433`*^9, 
   3.563553505104024*^9, 3.5647835560879936`*^9, 3.5648433002062635`*^9, 
   3.5648434942862043`*^9, 3.564843533863474*^9, {3.5648436392572594`*^9, 
   3.5648436681173096`*^9}, 3.564843956452616*^9, 3.564844038914361*^9, 
   3.564850817734276*^9, 3.5648508642847576`*^9, 3.56485091665405*^9, 
   3.5648515516219654`*^9, 3.5648525078256445`*^9, 3.5648526023930106`*^9, 
   3.564852654668702*^9, 3.567106143036501*^9, 3.5844775216653857`*^9}]
}, Open  ]],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx1mw+czlX2x59BCimprdj+qUlh1YZdod+c0dqaktqw/SFipJX1RFO/lD+F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    "], {{
      {GrayLevel[0.7], Opacity[0.8], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNmgf811MXx7/3JimU0FY0jbSslPGUrR6EpDIaSiKFRIqGpK3pSbLKLCMk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           "]], Polygon3DBox[CompressedData["
1:eJwtlWmwz1UYx895yGXMmJIwQ4YXBi96kytLQpFCIVlqRpE96xhEDCaNItKL
ZO1SyhYRKROGse9bhqLszKCkCJHi852vF5/7+z7nnP9Znu1W6zao3cBIKfWF
4tAc4zY0zSlNxf4FvQbWo8sxNhHdFf7HPgkz0INgK/pPaIFuDJVZ+wDUgiqw
hLnXGP8IvoZijJ1lbABaF5iG1j2m8ue5sNaeL+ts2Ja8ZiN6A8xAF7DHFHQP
yOgzjBWh68Je9DWYgx4Ce9B/w5foI1CW9beT3/IeHE9+02fo4bAffRPmohvA
AfQN2I/uAt/KN9AP/SNcQG9JvsskOJV8p5boJlAN/Rtjw9Cd4HryHQvlOyjF
fCUYp7cXS6l19hnjsZfAf8l33If+Hlagy7DmEnoB3MF+Its3m6Fkto9Goa/p
DdgLsLejO0ARehfUYPwvvrOgPePvQ3e4i30CPkF3hLnoi8mxnQ//JsdYvtwF
pbN9Wi/sM/lqHzQM+1S+nA9r0QfhQdZuSvZJXfRYxn5WjPm+AvPQl+BJ9Odw
C30QdqA7h99yCF5FjwzP/ZPs27fCZ8vHH6CXKpmyY6KzqmafNfZ+bPaGfakY
LUZ/JR8z/7YIn6G9lQOb0LWhYraPJ6N7K2bo08z3RL8Il9E/wBvoF+D35D2f
R08P++JR2I3eCTWzfaicVM2oVlQzOmtmOEY68zi6LVzBLo/dGt0MzmH/keyr
RsrJZJ/1Ca/R3DrlSLhmVauK6ePsUQh9lTfYK/h+E6597TkiHBPFQjXxUzjn
lGsP3/+t7qLfao9b8CxMwW7CXAly+Sj2Mew22EPDOaVcUk0WMD9Y+Yp+KTtX
nwr7Rjn7hXIBaiW/aRt6C3yaXDPqVf3Dtaeepdp5Jxw71dAy9PJwr9Gd6oR7
hHrDbnhatagzWTtAMQ77WL5Vjv6KbhPufY9A/XBPUS9Rjq4Mr9Fc8eza6RWO
vWpItboaSmTXrGJ9GB7Kjvke5X3Yl4/BKvR34d65KDm33gzHTjk2K9wz1Cuu
MvZ62Mfy7Urs2fJN+G3yqXJ/QrhXqwYuoseEa0d3OBGuSdViBezzyqVwb9Od
R6Mz+7fKjoFy+Zlwb1BOn0KfDvdi9Wj1qnflk+SepVpoGq4N1YR6/4fhXq3/
AdWze5B6j3rQIr4Lw7HQHh/r7uG7qcfeAy4q6Z0=
           "]]}],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl01VvFkEUBuBti0v4DSSEGy64KO5S3EtwAqV4gBZ3CO4ORQrFnUJx9yLF
3d29uOuz4eLZd87M5pszu/vlj0+MTYgIgiCTDMJxQZdkOS8yCKI5TDoHOMRB
HnCf/TRkH7Ek0I1qzKI7f0hkLsV4TWOS6M1ferGQkrylKbPpTxAVBP3kYsrw
gebMoTpl+cggWvCclmQwlBdc5gonOMVJrrKcdbaIobBzp8mV5l5yjeucJq+1
YfIG2fTTSm5272dZkVWsZhQ5rI8Mf5fRRKnHyDjGk1M9TqYygSzqibIdU8il
nizXM5Ws6mkyjQ1U4Xv4zO1/U84gn/52y1s8pR63wx7D9+W+AtaTZLRMl/XN
3+E8F9jDXZ7RgHvM5CJd2MsluvKDqmxkE9P5Rgx16cRvOtORSXylMnVozy86
0JaxfKEStWnDT+JZyxqGE+k5jJC72ElrzvGYJ9RiB9s5yxkqUDN8j84cSyHn
T5UrzJWnBtvYSh5rj+QWctsrgiHGS1nGYD5RjiWU5j0DacYA3lGKRZQgk740
oQ9vKE4KRXlFTxYwnx5kt2+KHhsZH+dh+E3o7Yg8xlGKkBz5/z/7D2OZiFo=

       "]]}},
    VertexNormals->CompressedData["
1:eJxFWwc4lu37LkUaVJpfKl9DS6ElaVztQYP6aGjSTihfX5N2KdHUkFFIIlJK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     "]], 
   {GrayLevel[0], Arrowheads[0.03], 
    Arrow3DBox[TubeBox[{{0, 0, 0}, {1, 0, 0}}, 0.015]], 
    Arrow3DBox[TubeBox[{{0, 0, 0}, {0, 1, 0}}, 0.015]]}},
  AutomaticImageSize->True,
  Axes->False,
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 14},
  BoxRatios->Automatic,
  Boxed->False,
  ImageSize->{376.7329079297922, 436.4210408992874},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->All,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  ViewPoint->{1.670215286294344, -1.9250895207713763`, 3.6748348581187864`},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{
  3.5630465521797495`*^9, 3.5630466125362554`*^9, 3.563046731314864*^9, 
   3.5630468822919292`*^9, 3.563047261540596*^9, 3.5630473490411496`*^9, 
   3.5630474031108446`*^9, 3.5630478516584325`*^9, {3.5630480368307576`*^9, 
   3.5630480603555984`*^9}, 3.563048104768877*^9, 3.56304836298213*^9, 
   3.563048404759004*^9, 3.563048588905327*^9, 3.5630486704402695`*^9, 
   3.5630487533232155`*^9, {3.5630499329276896`*^9, 3.5630499472173147`*^9}, 
   3.5630499857493825`*^9, 3.563050042098282*^9, 3.563050077316743*^9, 
   3.563106573353532*^9, 3.563107642713743*^9, 3.5631076837506137`*^9, 
   3.5631110720424833`*^9, 3.5631115401692877`*^9, 3.563111598918988*^9, 
   3.5631116391906567`*^9, 3.5631118214397707`*^9, 3.5631119494375887`*^9, 
   3.563112784091428*^9, {3.5631129839077697`*^9, 3.563113002315802*^9}, 
   3.563113062778303*^9, 3.5631136944218063`*^9, 3.5631277472706676`*^9, 
   3.563128122207726*^9, 3.5631281534077806`*^9, 3.5631282389895315`*^9, 
   3.563128421320475*^9, 3.563128451958929*^9, 3.563128794043862*^9, 
   3.563128826460719*^9, 3.5631289434921246`*^9, 3.5631293701060734`*^9, {
   3.563129454611422*^9, 3.5631294743922567`*^9}, 3.563129698767451*^9, 
   3.5631297799343934`*^9, 3.563129873004157*^9, 3.563129954867101*^9, {
   3.563130053197674*^9, 3.5631300680800996`*^9}, 3.5631304712000103`*^9, 
   3.5631307469304943`*^9, 3.5631307769449472`*^9, 3.5633730064431467`*^9, 
   3.5633731022532806`*^9, 3.5633731485833454`*^9, 3.563373218813444*^9, 
   3.563553505166424*^9, 3.564783556134794*^9, 3.564843301189065*^9, 
   3.5648434945358047`*^9, 3.5648435340038743`*^9, {3.56484363988126*^9, 
   3.56484366821091*^9}, 3.5648439565462165`*^9, 3.5648440390079613`*^9, 
   3.564850817812276*^9, 3.564850864347158*^9, 3.56485091674765*^9, 
   3.564851551715565*^9, 3.564852507934845*^9, 3.5648526025022106`*^9, 
   3.5648526547623024`*^9, 3.567106143076501*^9, 3.584477521680986*^9}],

Cell[BoxData["\<\"Contour plot of quadratic Form x^T M x over the unit circle\
\"\>"], "Print",
 CellChangeTimes->{
  3.5629550986360693`*^9, 3.5629552384747143`*^9, 3.562955397017793*^9, {
   3.5629554461890793`*^9, 3.562955473286327*^9}, 3.562955546996456*^9, 
   3.5629555878685284`*^9, 3.562955627133797*^9, {3.5629556758214827`*^9, 
   3.5629556912499104`*^9}, 3.562955749516012*^9, 3.5629558033673067`*^9, 
   3.562955842694976*^9, 3.562963384191823*^9, 3.562963419042284*^9, 
   3.5630191524226074`*^9, 3.5630192141363153`*^9, {3.5630192856000414`*^9, 
   3.563019310185684*^9}, {3.5630193541153617`*^9, 3.5630193621181755`*^9}, 
   3.563019561034125*^9, {3.563020346167904*^9, 3.563020394621589*^9}, 
   3.563020527315422*^9, 3.5630205861275253`*^9, 3.563020631508005*^9, {
   3.5630206764048843`*^9, 3.563020718712158*^9}, 3.563020757727827*^9, {
   3.56302081655553*^9, 3.5630208254007454`*^9}, 3.5630209318085327`*^9, {
   3.5630218360797205`*^9, 3.563021863426569*^9}, {3.5630219037370396`*^9, 
   3.563021918635066*^9}, {3.5630219850131826`*^9, 3.5630220960697775`*^9}, 
   3.56302247810887*^9, 3.5630225147597356`*^9, {3.5630227914389234`*^9, 
   3.5630228139497633`*^9}, {3.563022860718645*^9, 3.563022961978423*^9}, 
   3.5630244252141933`*^9, {3.56302450898634*^9, 3.563024538470392*^9}, 
   3.563024573898054*^9, {3.5630246048485084`*^9, 3.5630246393713694`*^9}, {
   3.563024669666622*^9, 3.5630246931290636`*^9}, 3.5630247649359894`*^9, 
   3.5630250207452393`*^9, 3.563025263450465*^9, 3.563027130305744*^9, 
   3.563027228117916*^9, {3.5630274502935066`*^9, 3.5630274739899483`*^9}, {
   3.5630277148231707`*^9, 3.5630277394712143`*^9}, {3.5630294341021905`*^9, 
   3.5630294574242315`*^9}, 3.563029489903489*^9, 3.5630295392931757`*^9, 
   3.5630296129097047`*^9, 3.5630297851964073`*^9, {3.5630298821349773`*^9, 
   3.5630298996070085`*^9}, 3.563044604979759*^9, 3.5630450931871867`*^9, 
   3.563045157209699*^9, 3.5630452052109833`*^9, 3.563045235787037*^9, 
   3.563045378652088*^9, {3.5630454110377455`*^9, 3.5630454334393845`*^9}, 
   3.5630456828994226`*^9, 3.563045781709996*^9, 3.5630458374644938`*^9, 
   3.5630458690857496`*^9, 3.5630462941864967`*^9, 3.56304645572478*^9, 
   3.5630465521329494`*^9, 3.5630466124582553`*^9, 3.5630467308312635`*^9, 
   3.563046882213929*^9, 3.5630472614469957`*^9, 3.563047348963149*^9, 
   3.5630474030328445`*^9, 3.563047851564832*^9, {3.5630480367371573`*^9, 
   3.563048060277599*^9}, 3.563048104690877*^9, 3.5630483629041305`*^9, 
   3.5630484046654034`*^9, 3.563048588827327*^9, 3.5630486703622694`*^9, 
   3.563048753229615*^9, {3.5630499328496895`*^9, 3.5630499471237144`*^9}, 
   3.5630499856557827`*^9, 3.563050042004681*^9, 3.563050077238743*^9, 
   3.5631065732665267`*^9, 3.563107642632543*^9, 3.5631076836570134`*^9, 
   3.5631110719644833`*^9, 3.5631115400192876`*^9, 3.563111598825388*^9, 
   3.5631116390814567`*^9, 3.56311182131497*^9, 3.563111949317589*^9, 
   3.563112783982228*^9, {3.5631129837985697`*^9, 3.5631130017854013`*^9}, 
   3.5631130626691027`*^9, 3.5631136942970057`*^9, 3.5631277471770678`*^9, 
   3.5631281219113255`*^9, 3.563128153298581*^9, 3.5631282388959312`*^9, 
   3.5631284212424755`*^9, 3.5631284518497286`*^9, 3.563128793934662*^9, 
   3.563128826367119*^9, 3.563128943382924*^9, 3.563129369794073*^9, {
   3.563129454533422*^9, 3.5631294742986565`*^9}, 3.5631296986894507`*^9, 
   3.5631297798251934`*^9, 3.563129872910557*^9, 3.563129954773501*^9, {
   3.563130047488064*^9, 3.563130067580899*^9}, 3.56313047110641*^9, 
   3.5631307464312935`*^9, 3.563130776866947*^9, 3.5633730059831457`*^9, 
   3.5633731021632805`*^9, 3.5633731485033455`*^9, 3.5633732187334433`*^9, 
   3.563553505104024*^9, 3.5647835560879936`*^9, 3.5648433002062635`*^9, 
   3.5648434942862043`*^9, 3.564843533863474*^9, {3.5648436392572594`*^9, 
   3.5648436681173096`*^9}, 3.564843956452616*^9, 3.564844038914361*^9, 
   3.564850817734276*^9, 3.5648508642847576`*^9, 3.56485091665405*^9, 
   3.5648515516219654`*^9, 3.5648525078256445`*^9, 3.5648526023930106`*^9, 
   3.564852654668702*^9, 3.567106143036501*^9, 3.584477521680986*^9}],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyFnQmcj9X3+OurhSRRKSUiKkqLRGm5aSVSlpLQrigiWVLa0L4jylpCaVH2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   "], {{
     {RGBColor[0.1, 0.1, 0.1], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3mYlMW1xr/uWXro6a+7iV4FRRAYlqgBF/CKGNxl2PRGFllUZFOM0Shi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         "]], PolygonBox[CompressedData["
1:eJwllWtM1mUYxh+Rg+X7/z+vYWmFlFtf6kttrTJN2zJRIaVCU/KExGwTsbKa
h9QyDFE3YCKbFhBIaG1mSxKy0gKtpK3Dp9bQleTstL6k9qVP/a5dH+531/Xe
h+d03fd/avVzT67PCSHsxnKxm9IQRseG0AapTkI4i2XhRfAKfBXZEPblh7AQ
nsLvjCH0UeA8dhe4lP9epc4AvAx8lPyLeSH0EH8BXgifhL8V/2T4IeoNjwuh
FzsIPoZ/lPhh7BL1VmZYCxsqCKESK8C/iPzZ7GE28avhO6k1DbsO/AJ2AHyZ
PfeRvwUro9Z/WEr83dF7u4DdA15N7aewJmovw7aRfwjfbeSPsL8viOkit5z/
PgcnWdd6DHsJ/isxz+Cr43yXwOsSn62I/A/xb4J3wIvhJ+H/EvMxsVvg18C3
89/7+EewqeANxB8ET8F/Aj6D9e4F38d5HwK3k7OG/GexDvAUYt4j/ietAd5I
fjv4d3IG4HvgR+GR+GF4PzlbwduwAfBbqc/6DjFvgjtT136EOy5J/cZ660qs
CVzDXZXpTbirGqwn9dkbic+w1s2Jz6I1d4OLU9eeK23BixJr5TjWBK6k1mLs
jQLXnEf8u/jKiZ+bWnPSnjSZQ/xX0WdVzE54Nbnl2BlyV2DFid+2H9svLale
rjUlbXXBf8ZXy3/deovUdzFzTAiD+EszPqPOtgBrS1yrkJgfWbs58d4nwL+P
XrsqY+1oD6vw1+dYk9Lm/cQE1h6DPQDeyn/d+P7gPJ/Cz2JH8twj6pVstHak
4Qg+zf7qtVf2N0f3G60l1ZgMPoV/B/4N+B9N3CvLsSUF7pn2xL2kPWgvhdHa
kkZuANeSXzLGPb4OvAeN9ZP/Cv24F/w6+YfJ7cWGiH+c/1rQIqFhFj+l8DX5
vtOhxD2sXp5PzQPgE1gH/Bw1PwI3YJvgs/BXk/9E4t7qxL6Et2W9djn+/eAV
iXt7Onx54j1oL7qzevhMbDG+Cvh2fJujc9Xz6v1p0XevmaTZJA1Ki5e4s1vx
3RKNe4gZBN+IP4LruI9xxO/ivxp4FpufeOZo9qgnR+DX4BM527fjQ/gL/Dc2
Ch6P/zj4F2oczrUGO6X91G+vGbMdfoz6TXmeiWsT11CtGZzhT/An0b2sGbIZ
/8vRs0dvprf7h5jCjPdwFfxNtDY1U/ZKu9GzUDPlRfgS4lZlPEtbsDnRZ9NM
naTZim9pxtqvx36I1r5mfAv+r6NniWZOg2Yv/GnyG/lvSL0U/RYbsZWJ31Rv
O4J/Ir46+Dz2fo437tL8Tq0VaaQVvjb12dvh++DTs559euMHwQ/jP59vDUqL
0oS0oTu4As+knq2KqYIvg9/B2q2qAe/LurbeSG+lGaNZI42fiZ4BmgXStLRd
Ep2rb94i+ITE2n+emtfjezvrs+gb1g1en1o7OqPOuov/Tmas+UbwqejZqm/K
6eieVm83wz/Q25Lz3Vh/U5bi6029VgM2CL6cunc0w38DX0nd+/qmXAXnJb5r
aVhaVo5yNUNKNN8Sv5U0LW03p57tWlNr65uvb79mymfw2sR7k0al1Q74kVxr
WtpWz6h3KrHX8O1I/K3XN0rfKmlAWtBMrFLvRc9evYneZkHqb4dqXtSsi64l
TUlb/wM7KBzj
         "]]}]}, 
     {RGBColor[0.2974243735492214, 0.3274982973392501, 0.35051780461161214`], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3m8ntO1x99z3uG855z3GSTE2KKttplEiwSVIgiiIVoln0pRw42hTYKE
SNGMtMg8yUzUkIZEDDmJiEQMEZFBEDH0VgkXV6+gtzqpru/5/c5H/9ifvZ79
7Gftvddee+01PQdeMPiHg+oLhcJ55UKhGPWQaqHwYpQ/NRQKE6Lh9eZC4aVo
7xn1G1GOjjI7ypwol0efBaVCYUP0O61e7+h/fPTv0RjfB7xng9re+A88s6IU
6wqFck24wLMyymS39w2czwbOMVEmRtv2KHvF+8ObYryAD2tSO/jnBc5box4f
pUNRMP1PijXMb1b/jxr0Dc97Bf4RzYJp3xz1lig/j2+TJq2r1qS5TPJ8ehpm
/ow50fNZFvNcHOW0+HZOlCejzI5Si7W/1aD284Iu5aDtb+Lb1xv1blHM7YUo
W6OsidKSBr2j3/KoeyeFwqEBPxHwb+PdnVFODTzFoNXMGLdvneoZUXoF/FGj
noGZ85Qo+wRcV9MzMLSYaFqxr/SB3idWhGdHQfvAviwqCN9tHgtazHb7rka1
Myb72dM0eSLwdIk59ot5nxZtp0e5JOjS0ii4f9TDo742SsX0v9Z7sTrm9p77
920W/Fi0Hdesb+h/Xcz14oDPaNA3tK8vCAe4Vte0nyOMExzvG+fHUXZFOSfm
Njj6TWvSPm8KXM9G29uB54WY+0X12qPLos+CmG+vKH+Jfi/Fu52ci2j/fZQ8
2tZG3/OjjIr2FVEPiHJ1wN2zQuHxgOfGHn4WY/6lpP1nvOtjPo112lf2966o
57gdGt/SLN6Fh6EXdFxVVYEuj1a1JtbG87DAdWzUcwtqP83r5QxeVdJ+tYs+
FzZr/n2ibWjgvqqotoui7GYcxxnPcMPQdnDQp5fpPzfmd0Oz5tuvrLkyT3Bc
bDys4wavkbNBn92iz8lVnc2TvKe9PBa0vdDfsq/gYr7bTQdwDAp6vxGlOfru
F237RukS69gSuDZXxScDY4z/4vwFzk+jvsQw9UDDQ4I/B1f03Nf8BT1botzt
8zUv9uNu9i7qUTHeyCbJBM7n5CiXliQnDiupfWCdxoVW0BTaDqiTrENuIgP3
L0mGHRHwSs5gUeflPu8D/c/MY91B097BO+uibVyUsVH2jG8f8/OvMuEfmYkf
eT8p8FRjrt2j3iP4bXms78po7x3PS+Lbi6McGfDb8c3vY11Los+yeD84xvxR
tK+pVzs8vyLmdm9V8urX8HKd+OuegF+J0g8axrvR9fp+QcDzo1SjtI85vMgZ
iXpx0Kw5ePePsXeroFOUuUXdEbd7PsWor4m2K6J0bBAdmHd9SfCJ0aeupPfQ
p3tFYw+OMtz1oDrdOQuMs2vgOT+ezyjo/RCvk32A5oujvVNFz8Abfbf0jfVc
FDhGF4WnR9TdjYf6cMNn1AuGDsfHfh0WcEPQ84f1gpnP9sD/Hc9/SLybGe+2
BU2+lav9lUR9Xo5ySDw/He9ujbHPSHRegdnLO+O7oSXxD/M917zUJdbYuUHP
l8S3A6L+eaa18+487p2y2qMqHAxdS+I9xh9W0tzAfZXxX1ERzLijo55R0v4j
42dazq8wTc6LNX4b+RLw5ILWPdxrh5ajzefwzi/h76jPj7WNCnznRn1kjNW+
or3vHTQZFvUxifaZtq4eZ5jHYj+vNv37Rf9yjH1MrPuOVHx1eyreAp7IulLN
7c3AuT7g+sDRNeAHm6Q37AoaPRR950Wf7xXV93teC+P08FhXxzdzYs7bU70/
yn24H47yubsg+twUzx1S8QA0+EWdZPD7ls8f5NIt/hz1szH++igNdap57lbV
/fjPJsntuwP3502Sgc+4f9eq6mf8bZPhLtF+UHy7wXjos8H9XwieeDjmNCXm
eGX0GRjt42o6u+zFWYFnZ4z344AvK0iufqVZZ3ZWTTAy9oGYT7ei1nWV7xV4
hjn+y/NEXp5h+fBG9H09yvIolbJ0npuj/X/i2/6+Hz+L7/6KXI2xbqoJRv5v
jXlui7I42vY3vHtV7S9EaYo+y6LvioD/L779XdSvoYvUpGe+1yjd5tp68Sy6
0Ep0lChLq9JBoDV0BsdK4+kE7QLeq6oxt3pc7iXuJ+5N5viZ5zm+pPXDW8hh
+qz2XfaZYXSNAdYNxnkNzH9ijHdW9BkVc34lk95wWyJ672eaf2HaMs6tNT0D
0wY8vEG6yZqAOwfObVXxN7zNHT0/ysya+J129Nsnol4XZVG0r23S855VtQHX
6lSvNTwt5jQy5v7VqB+Jse6J9lcDz9SqYOiGjEfWQ/+x0W9R7PUzsaY1URYG
vDbq5igzOBvxfs8ou0X7idF2TpyZ9gGfFPCF0X5DwHdkwr3M+NkjYMaHl/ub
V7tHW4vXix6NPj075lBu1Nq3NkgHgRboIe2insHeQPOY/3Tz3hq3Q0P6X2/d
5ukoT5pWT/oZHmkf9VNROlpfQA9BZ9jXewf8hL+FtswDfPs0aF5zPTd0CnSL
ZbGWMYbRJahHu/2fzerXxssj3T6rQd+02SnosdhNO2K8qU3S18BDn5trGnOe
6dCcSq4id5t9drAt0OcZA/zs1UlRDijIZusYOLL4Zkbsz/QoJ3MHltSOXseY
g6ybPRrtp5Yk908LGf9UwD+JcSfFd5sCPiG+nRTl+Ch7oJ/Efk8J+PJE+DoZ
J7ZV55rGBy+6X4N1S9aMnpxaf2ddnf0t/aE179F7Z9k2AV7rPelQVV++QbdE
b0P3jem28sUQ6/azY159onRBn8y1Dx9HXV+TDdZmfwFjOz0XuEo17UWHBtHs
Wc+BduxH5oztwbzRgY+1jj0rFz8tjPr4Rtke2B18VzZObC/gWbb5mAf2GvZo
oSZ9Et0SGFtvTtB8dpRT68U7/7Rty10EzHq6x560j7Z23L0NwtnX9iN2Yxvu
OuPMmkQb5MMc7wVzg7aZ2+GHZvPhzij3xTq6xjhLo14SZU5Nds3yKB/WZBcs
dTvneLHPMvt2tPcOHPcbD7z6caPkJ/Uu8y24wYN9AU9zN9xTkEz/bcCbYy53
RL0wymMF+TaYA3bwI026F5jPnY3qh114T1Uw/dkPZC6ygjb6TWdfDdOfO2h2
lCk1yYn2ljmLLaOw95E37SxzKLsFvCTw78xkT94eZ2FTWTYjtiV25HnWz5FZ
me+XDfXSRdBD0AWarBtsK8qOvbhebc1uZz94nms+zy0D0fGgIfuOj+Rw3xdz
KvKV7GX5yVrygG+tas7A9G31wZQkkw83DD7uuL7u092yGh3n6Cbdv4yPHV0z
DdoZ599SyYiBiWyf1bZ/BtjOQKfdHm0vR+kQcKWiZ2Bs7b+WdG/dUFGfk63D
ocsNSyR7XipJ/vD+JX/7YdT/G+VcWN53FncXtsEcy4GkJL0cXec78W5l1N+N
+gt0RvTmqG9KBd8YdZrKbvtRrnubu5y7+9B4/8OS7KfW9XmN2HOrrFs+WJSd
hk4Jjrb3I8uSo4Gqde6sh/k/VJa+MQz7PeAzy9L1nq1IF0EP4T0wfdBb0fGx
79DRj62XrH48+q+uaBxsp9HWFeHFv5i2q8p6Bj4kE827ZaL59RXNqyHqV6M+
MPq8UtKdAryhojmBoynaJ/u++VNR9GSOe1Qlj34ZixwZfXeUJMfAt8M4qV8x
zPfA3FnQclFJdMR3+Kjtu1dSwe2iPgVd1LYl/oGTS/IJ/MrvbkhlPz5o+k/w
PrKf16fqf10q+/QU4xnj8RhrVCY/y8hUtjz+QGyTLVFvLcoX8YD3Fxuc9/TD
Z9jJtjI+KXyJc/0tdvxFtnOnFWW/PO5v57hP2zdv08fniPM0M9V9NiPV/cc4
yBD8Dev8LXv7mfd3tucDvz1XlI3NuC1F2YHYZej5LYYPN9zPvo6+9nd0d3/e
4+tYXJSN32L7gP7LTOdWf0S92jmD5+fSJWqp9Alg+JT5bDSdz6kTzyIT4N9D
zcMbPG/64JvZYpqPqegdZxlZco6/He3+rHFondrRB8Z4LN7jl+hj3wTP7AV+
zgHR8ZyKbKoxgWyzz+TysnyO+BtvrEi2YGvtnsnGx+5fV5HP9K56rf0e21B8
v8lyaQB8XZJNhf77iG2oE9wHOdCuJP0Y3RhfAz6HwYn0l5nW5fYtStdKuGuK
km8HeO2sA5sdnX2oZRz20pSq9PBqzPHNaO8afcZH22FBn5dt43xsefJuUTwG
bZnXZs+tMQY8P+qfRX0A9nW9fFPY0Nxf2NQTAv/4imzFxywD4b3zLHNuLsj/
dLfpg8y62nu0e0k2FDQpWffk3V4l+bYYY10m2o5OtAdLTauDMsHfzLSOT7yW
TpngjlFPSNS2X9Q97NfFv4tOhc6MHvWbeHdp9Nk76k+Cb0fAFwGfXpEefKjl
2krbg+uj7ZmKZPZ9Ze0r34+tiEf/O8b+Q0k1NP9qjPduwF/J9B22NOuFr8ZF
+SCe3ympz0+j/f2ieIp9fasoOcB9t7isfmfWy/Z/x/0/KIoO0AbfUqu/i/uv
JP6Bj5pi7K3xvFsi/1DJPqLRrrlPdq/I14TPib1k/9g7cMFTx5sP4IfzEvly
wMnZhV+2tPFMJriaiTasF/o8XpaMAu/SgN8L+OyA05L2lzP0YVFnhO+gJ3Qk
JrXRZ3y07wTudOTDm6Y1dIberBWYmmf4mTvoVxXdMRclmmOe6N6ZbNo+VRFN
4atxhqEtc3/P83+6on7sOXvGfJF1yIYPrHu0VORLwt9yYKz/fc5/1Pf6G3Au
zjTuJYlwv2/82Nb44/genWSG74hJnOWizuzkouD7A36kJF8Y/q3eVfn08efv
dEwLPzA6NTo6ejV3Dv3Bia+Ofe7qtofdfmnM/5KK7J+PUrXXRf101M+UJG+J
ZS2syvZ4yf5q1otveInvOM4OMgt5tTQTfGKi7/ZukM3y7XjehQ7ocZZ7DsQN
bnHsAD5dabnwaSr4k1T+4ElF+YHb6MJdvG+m89MhcN+ey0b6RfTvmom3vhLt
t9Rkh7fGAFLZw5dHfWCUj6LPAYl0eWD0pEMz6Tf72x+M/EX2vpxKbu6byv4F
D3RbYX0ImbGA+GVV+/Ow+Rve/lamc7tP4HygLJjzu7Ck+XP2uVPPsp+fO+qE
ip7h/Xd9D/J8tvug2wNjj1zhvcX33sUwdwT33kLffV3NA0dYn0QuB1la4wnI
SWyWC3Lte13M9w+pZPK8RLbvMMvwQSXJ6w2+04f6Xl9tHwI88JOS4gvbfG+s
MX7eP22+wocEfAwyK8atRd8nHO9A30KXe66qdnQldPDbi9LD8Zewp/hM3kh1
39wX33YoaS+R21dbV2bOZcstnrmvmHur3p5pf/dOtYanPLe51tMYF/t7s+1x
1jvQOIm/EEcmBozOgu7CO2jdxXR+LdU5uT5RDIHzg38W/u1mHsZe5gwTe0bH
4N7lzn03Ff530D1StY+N+d5RUgwFOcn9+5j1541V0Qs7GL10lXVT/Ccd7W9B
p+ti/PMT7Qv7/HYqPfytVLgWeX+v8v6y3peL8p9Ct7GG0Uupebcz4K9VtDbk
1X2ZbIbjrds2WtfqlQo+LtVeomMTlzqwJP3pdT9vMT3/nImfJkX/g0qCt1kn
Aj9y/cVU998J1p2bfTccGs9/i7l0jLV+N+B/xHeHBnx4wJ8HfFii+xC5A7+0
6rZFnUV02LL12N+VdW9xBzyZCT7JsUfsTO5MfEv19i9NLQo/dJheVJwA+mBn
77I/hPZplvnIdOT1UabHluKXsbr55jvuh+nuP933BT7t7W4HP3fFVI97lPGz
X+j16PHoCsjvxeaBLoaRG9i5CzwmNWcNPXyrn4Hxo9/tcX+QK/7yRiI9+77/
wH2fcXKGH/B90c3nGp7PU+Ffw7dRbgv6Lg+6do/2v6PTJYp9occT/zrQfIH9
Up9Ibv0o+p6ZSmfaM9UdC8z9Tt833H9KLtl/WSoa0L7c6/vU60JG4YdBv92L
8xBw+0TrO7ok2wh9nHZ0+YPMg/htdjqW+mkmer9smvP+ReNEXwY/MvAFy0Xa
mQdzPdd7ur34JY7t3lPuPfiWuw87mFgs8n5EnPNTorzdID9xx5LWy7lFPrOm
N1PBfVPRC7o9lajvge6P/rW7dVT0ynbWi17MBJ+ZKI6N/cyecm9/YT58N5PM
PTuRLok9eYTpf4B1JPRo+iCTp+aKmfws5vJBqtjkIsdTiGMRzzo12vfg/Ka6
l/awDnl2Kpw3JaIr30LDVzPN/6xEdwWyD7l9YyIden0mPxx+T+xp/L172ueL
r7Rg3+mVFcVWiaueYDsR3fch9jXwXJEofndwVTE74mWvlMUDn2SC70LHC3gz
8ZFEOsUW+1/QkfpZT8L+PMf3Oz4YfPXwLedghv322CHYI9xL092O/4T8n94V
xcu4r+jDnUvMA/8pfnNwD/D88ZtNM05k5XTjwW+52fE+cJxuPNyj3KdPEZMs
y+7BpgJ+pCwdHr/QY2XZy1MT8VDnTG34ikbabnrY/Wcm0pOIoc1KxBP45LZH
WU2sItouz+Q3/HsieoEHntmSadyJ0b7Auhr+15ll+a1YCzKJ2CbnhZwJdJo/
pqL9JtN/cln+R+z08Yl4HZsSm3WT6TC3LPu5q/V8dLUf2x6EDpyRfqYV+0Os
cCy6cVWxo5rjR7l97Phs2WP4CT0NP9gs+/mJw/eo6L450foe+zWvrHgAfWjj
HbGDJzLZifvgy8w01+HQ3rS4MpFPq2dFNlNLprGuSSQzjnQcf1pN8Q9iAZMT
6anEn7kviUGwduwnYPTe2Z4P7cflwn9sLt8c4xwTcFMqGUHOC77h3ewzJ3aw
ynmJ+N2L9sNzZ95Rlp2JTJ1iPyk61KCK4izYJdgnyCzygMgHwn7AZ1+pym+P
H5B3bd8Ndp9lmfb754l844Pc3mzfO/51eHW1eZjY/MCK/O0DbRMxLuue67Vj
d84vS+96PNP8V0d9dK59/F6ueOuEqmKvqzL1vy6RrAEnMabe3lP2mjM90+cR
/XqgxyXfijkyH+Tf47bPv5ErH+PruWxTbNQ2/8BThrFXgZHh95fVh7YhjnUx
B3w4FcsuYmsTbH+h8+JPfLugHLGLnL/HOV5vHwg2Mn6Ns30mgDkX8Cb+MfTf
fiXpP+givF/v/ugb9EH3IJ6MTxN/Jv5LYPy26MBPWg+mXlf5Evc6f8u8LnTu
GXGcPb227b47uUPJDdjf+QkHN8gO3VbQ+dzXMPKeZ+JWWx2PpL2T443EN69q
VE4G+RjkuU10Xhz3BXjAsXtZ62Et5PWQ30NeCvkwXZ3nQ/+DjZ943GznEJKn
Nsl+urPtq0NHYr6XuT/wwbajqcEFTJyaODr5A+TGEVMk9kee5+uOyaGPnuj7
olOD7BB0KvQx7BF0M3KbXrZtAr/AN/ASeke3inSPzsjFitZySC74i0Q5Wp3d
/vWKbID7baN/zTjJ7yF35/1UbfRjTPIvyMMgT6O/eRe+JTcBHwr+E2r0b3Rv
ckWJd5E7iizjLBzss0/sa715Hjz4WLp4bsx/TCK/E/5FfDP3Gifr6+I+5HuR
d/WPqHcYJhfskKr2YkSM+w3PnzUSG+EuPMf3Fc/cWeT2oUeUE8kZ+vAe+pM/
B92JxSGbiMFB++3el1MS+V1vyjT+dtMKu5xcMexT4lKcS/i/S6724zLxI7wB
z2yI5yXca4ly0tgn8tCgzxLvL7Tp1La/geeggD9OtL6DPG478y7rIacIfue8
dM3F37/I5Ft+1nRgbawRW6C98y+IFT7pvAz0k2dS5cg8G/WGVDTYmH6ZS0Qs
ibjS/s7tuTRXf77rU5WP6237dPADYJs/77wK5CZntsVnnnbayIm9Jtq3OK6H
fCNHGd7DbiOGxT17nfOcaG8xLs4+MgAYnH2jPr9R4+PjutLt5G1d6Vg2Osl0
20rkAg33fqW5fHcjgm6nRd+fNUon/ryq/G5yD4iff1hVDH2l816xY99ynB5f
H7Yk+UnEbYmXFx3XJk+c+xY58GGuuT6UK1dnqu8maAcNieOT5wuML5FzVd8o
WpGf1cPxcfQF5sfciIuTx8McRjsfBj9MQnw+3vUoaZ415wZgp/COdnJYmp0D
NtM5QJwpzhcwMhgbgD7k53Afci9yDxL/7+8cAGzigY79cHf1cC4Ze4K/j33p
6LXCe4867xgakqMELchTOsR5P5wX5vY759iQr73a36BTQ1/uxP2cc8fciI3T
h/g4eTtznC80z7lDrO/OXDnPS4Jv78r178ADqfK8yANrlWVV5UYz1tqq/jFY
40J/7OG1fiafmZzfjfbzoGuM9/la6FwI9Cvmu8lzLnn/2LtrnXfP/pK70st5
buiwvZwvMcT6Grx4unPU+ztXAjpzz7LP3wn4uqr49BBiK1XlM2IjYR9hJwHv
Xaf41Huefx/brfDbTc7xQk++I5ePeYF9gfiy8K095/UCkz81zTk20Guz9xSe
fd5n/B77wbABJ5tu0LC98xbI8YBO9INGPZtEX+aGr5v8cvaXOfaxnIHOU31H
t5gPyT+BTqt8577qfuzFac4n5d0VueQbcm6Vz3LrHd0omiy1TITP2K/W/MCa
eAOeJ/eFsRif+B5zIPeDfycOc/4aeWzkv2W2cfHLITuRocjSDh4D/Oh3HQwj
8+iD3EMOYYMji/C3rzRtybUkJ4f5ocMOtB6LPlmxPQ1f8R8CdzDt7D37zlj4
CpnPQN/PlYJ8Xeho+KjI1YQP4AFsccYlPwo+X+F9xw8KjMwh1oEMRDbe7f2C
b9Dr0ePbdHhg5knd1TD8Sd5tN9/nnH/Ofhu/0qdsuYBcIud0qekOP/Q235Lf
utW65RTvIfyz2HlD5CDB+91MB/piK3KXYdNhL2IP8tze9L/XZ5pv4UPkEPcI
67vTa1xomHbmNMU8yX5xx0O3X+c6izdF3VCWnn+zxxrn8bijFhpPs2UePA8N
hthGgP/gQ+TFAp9ZZPjJPhfQgVjHAre3zQ99YYlzu5DJp7gPtBvv/0ROqn6Z
s8U5neTcv6JlEfNELu1rnRydY7zlHetl3ZMNTzLMGcf/id6JDo08G2s8fHur
zyb7c6/pvIf3pI3+i8xjG90H3kPWXec1Ms4U73Xb2IyFDITm8CS2763eX/T5
W92HerzhFuv26Azc4df4Hmdvxvpb6Daijbbmmx1e4ySv95Zcc7s5l/6N7YGO
hy8Gn0yXTL5Z9DF0S3xt+M2+wE+eKk9lTtS1RHGdOwM+IVGceDW59M6b6Rn4
v5/IH3s0MbREPsAjAu5l/0JP/OGJfKMD0OVS+XC/nSuPg/gtMSxiLcRcXiL3
PxOP9oz665nyur4R9eh4d3rAY1L5H/BN4IsgtkeMb1CqGB4xuGHRf2wqm3Nc
1GsT+bIvDfiCVHtyY8zhz6lyXv8/6ixTHlqeKf6Hn+6dTHFE4nFfTeXfx89/
ctS9U/ks5qfyS2KTH5Ep3kCs4bZUflL8pRsz+SLxSb6UKe6G3YvvtJPtJPYI
2Tnb9+nZjl29Fv2vTeQDejTgXyfy0/ZPFcsknrgtU24QcY6hiWKKxBP3TxWz
JBa5I/p8P1X8gv8wjnPMZXrUIxL5ac8KuL/z9n6QKk5DPCXJFOMk5rgjVR4c
enOr/popr6t91Lckius/l+l78ExM5YvHD39/tL9uHzqxgtcSxbv5F+fYRP9v
jI4+kxLl32wN+KBceQnfzOUbxz4jh6R7otyvcqoYIfrBioB3JbLHOkX/dW4n
lkh+AnktxJtuSBQzez36/yuRrdctV3waX+zj0X5krn+Wjsr1LxlxnVGJ4vv8
o4U99jXbQ928f8R8ji8od4Qckp9GvVemHIW9M7WRb4LdXZ/JfiO+OtRxSfy6
z8VY8wLvT6L9sVRxWf5TWZZKJ5kf7UtT6Yhzc+WOcldxp93mPGTykYmj4gsm
ljotl1yenssfNsj+sU25dJ0tuXJJ8BlhAz5oGwFb4bJEcQ5yvclVwNeD3+bh
XLbKI7lk2lmOO5N/0sW+jvf97wz/0BAzISZB3OS5XLry87lw4+fDz4x9uNz+
h/pU+Q27UtF6uf08cyuykXfZD4lfEr8oflTyPMjxIH8RH/oe9psd5/8fsYPI
jUaP5T35jvjA+QY8yBN84de7Hf8eOSjkkZDXA4yvj74jPS658fgV8SGTa0ne
Jr78GzLBPRPZddh312binxUV5Xjgh2cOzJd8B/rgX4Ie5G9Ck7axkZP4RCfZ
L/qZfcnoUdBjrv0GyEh8NMSI8GmQy/JTrwtfPzQhLk+eKLxBng+xKOJQ+GLw
yfwxBh5VVh/m8eNcviz++Wi9Sxq+/Jeus/caf0Wnhi9t/U6+X7BziRFiq5P/
XnIOPL508p+YI/Ev5nCxY8Lk4XFOmcPosua502vB935XpvaLE53pSaY/8x3l
/sgm7Hp8IpcmigWSd8M4EzwWehAwNAD3jcY/NNM+JL6nxnjf+f+Nvb0+09la
bRoOMk+i67K3LZYPnFXO7LxcZ5UzOyfX/37ENYhv4CvBZ/LLVHOH3oSg5nlP
4XP+gyQnGP5CF+jss/a8z9HGXHkA+EfHRP15Yj9jrn/n8DccGfhHJvabZjpP
LT5r+GTRIdAftlgmbM71T97u9mHCT+iU6P/MkbXDn/ikWGufePg3wIImlw==

         "]], PolygonBox[CompressedData["
1:eJwlmHl0VdUVxi9574UAOfdeiBUUi0LAAgWkQgNKEFRKoSwRESu1KNRqSygC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         "]]}]}, 
     {RGBColor[0.4752051298306019, 0.5025649761572332, 0.5130257019103541], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3eclcXVx+/uvXt37+4+xd4bIKIpShelSTNGFPWNHYwlElBCiUGkCSoq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         "]], PolygonBox[CompressedData["
1:eJwll2mQVdUVhW+/fq/72XDPuWEeSpECEXFAGmkxEGi6BUOKOFAKKjQKSAGK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         "]]}]}, 
     {RGBColor[0.7268676022239595, 0.7334053710556502, 0.7165659269045019], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3nYXEWVxjvf0t3f1337XiEJJAiCLCIgoDOC6BAh7BBW2RGVRSJLUJaE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         "]], PolygonBox[CompressedData["
1:eJwll3mwj2UUx9/7W+7c63qXESlThiRCZKuhsUQSZUlEZM8S6hYhS5lp5hqR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         "]]}]}, 
     {RGBColor[0.9174710680286675, 0.920644992046139, 0.8816527740047712], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXm0llUVxt+Cbx7eD1hhyZCUTPdeLpMuGWwpgvMimQ0NUC84pJmgDX+0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         "]], PolygonBox[CompressedData["
1:eJwtlUlsVlUYho/9ey/l/3vv+Vc4AKWNaYtWpIIuLCYimjgAKgitRRFoixZN
HBYOK1TYCIoLNya41KhRg6CCxerGKZo4IJMDlWqhIBRQoQNoGn1eXxdv7ved
93znnm88dR0PLX6wIoTwJKgETVkI43z3JyH8GUNozEMYKYSwHPIF5Nfh++AO
gBH4VaAZ+Tg29XDvg5PoB8EY3D/gGPKVYAdcZzmE+yaE8AX6AFyCfhr5atAD
fwTM5V9LwEb+90bmsz4shrCXvZehh/N8h1Hsh9Eb0hBKYCp8FRiBawJ3wU9A
H0ZuAR+w92/WBhPf+T30FP4Mcj1og1uLvqoqhA7wFPI4a0fhZoHt7B8Bjfwr
glr41dG+neBajXDd0f/SHXXX78AcfGkDm/DnN/TrkJeCZ9GPoU9NvfY4ejdn
vkV8JpVCuAnupcyx6sL/XXBPsOcG9t5BTk7DHQbXSgcb4DpBH7+/GJtW7jIE
f32lczgd7pXMud0H/oDfndmXHExTbqJzMf5/LSwAB7jPT+AB+JPo09h7Pnvm
KzboU1Ln7DHO/x29Dv1C+FsVa/TJqe/4aO6YKrZrwHrkU/C1qWP0CPxx9HnI
z3DfqPOUg2r+A04hF8EYZ88EKzj/EPsvwr6Z+HwMNxGMws1RzcDdEn3XSeBm
5JXRtgP4t5rzPynb9mvO34z8DTYt/L8VPAffz9qiknOkXK1D7+bug9g8jbwT
tE0M4Svsd6g+sRkrOAaKxWHW/oI7JCCf050T+yzfv2ft16Jrbj/yz2WfJZ8P
In8OZsNv0H2Qj4BXS/ZZvv+A/na17/gL8gLOvyDxP96FH2StP7HNUeQfy64t
2chWMVFsBsA7mWOgWLTiUw/y5fhztuAeU6+tiY7tNeB+5DOZa1E9r97fgs1Q
lWtGtdOr/uas7cS7PbcP8mU9ezYhbwXz4V8EfcjPq8YrvLYNeWHmvTpTZ2/N
XBvqAfXCt5l7vwimwJ9Ar0mdw4fhm8G5gntWvXsp+mjBNaxaPhvtu2xk2wA/
XHDPqHdWojdVuiZVm8q5ct8CvkSuAdWpa1y1XodeTt0T6o3O6NkxhP8N6Pvg
11Y458q9ek69J5s9mXtCvaEaa8/c8+p9xXAz+t3Rs62f87pyx1Sxncza7dEz
WLP4CvQO9J2ZZc04zbrbovdqBmoW7i67t1Wje5DvjJ6FmiGaJUOs7S25hlRL
egP0Figm2zLPHM0exaweeWF076sGVYuacZp16omm3D2l3lJNzcg9EzUblaOZ
uWe+Zr9ydAlyL/+YnXima7Yrhoql1rqiZ65m71Xo90a/Ef+9Fdz5Tc3OsnOl
N0dvj2Km2E1n/zL235i59jRzNXs1EzUbe9jzMtynrM0qusfV63rz9Pb1wr8G
3x59lt4YvTVLo2ev3jS9bSty761FXwL3Uea7aoZplqmH1Evq8c/Ql6PPSDzD
NMs0ozSrtHYP3CJQk/hN0tukmlftqwZ3qRej/6U3V2/vsty+yGaxaj1zb8sn
+fYvwRogJA==
         "]]}]}}, {{}, 
     TagBox[
      TooltipBox[
       {Opacity[0], LineBox[CompressedData["
1:eJwV0EcyA1AYwPHnAMQBtCz0eguCWDiBsbIwykK5grqwdAQ2wowwEwtlrS8Y
dZQokcQog51fFr/5f997My8l2j/cO1QUQhhkqzSEFPMkuGCFS9qLQxjQDj3X
M2654cXZREkI7+Zn84y5kSby9p5ICHG6WbP/aU5H3R/pnLbSxre9yjvHWqkn
GtUnHXef1mmtp4Gsvct7ncRYtf/qm46439dZbaaFL3u59w60TA+1Qh91zP2D
Tmk1NWTsdVrLAgl7n75qRGOF/8g8af7QuP1Tk/z4Hkt66mxZM4XPKfwW0tw7
29FdFtngztmebrJOkiuuyZMjyzb//otK0w==
         "]], LineBox[CompressedData["
1:eJwVzrkuhHEUhvGjsCaWW1Cg4FIIxjpjn8Ue7sDacgOUJFQqBGNrCJ0Q9MMF
UNCI8PuKJ8/7nfP+T77G7GJqoSwi8rhsiCjhDe94wiPmMYf22ogD7uBN3sAt
bjBbHzGDc7tq3yPyKAp1EeM8hhrzC/tJuYULfMx/3IPepKe/Z/Yl7/M3t/E0
n3GlG2k5g7zuMA+hyrxon5ebOcdH/MvdSCVv9HfMPuRd/uRWnuITLnejT+5H
TneQB1BhfmqflZt4gg/5hzvRhbR+UW/L/IG3uZTcke9wj1WsJf9vt84rWMIy
XvCKZ1zhGv93TjvN
         "]]},
       "2"],
      Annotation[#, 2, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0], LineBox[CompressedData["
1:eJwV0DsvQ2EYB/C3GAS9LCaLYqcNAwM+gwELg0htFURVsbszMVosbhufQGLi
E9DSSd1XERG/M/zyf97nfc5zTk56anYkHwsh5JlOhXBKlRPOWKRAJR7CoSzL
A7mQCCGrDjLjnKWeBgJ1xOg0MybHGY32mC9zlwzhljb3jRzp3ciC3hJFUuaT
7Km32GadTTb4ockzfbKXB+5pt+tJVinzSIVfms0PyH5eeaHD/Kf84o0P3vkj
YX5YDrHLDvvRHt/VEv0H9TxzXJudtGuCtDrOoP6x8wXndOk9yxqtzJDjiku+
3fdQUnfLondk1GtymRVK1Fglxz/KvT4T
         "]], LineBox[CompressedData["
1:eJwV0csr5WEcB+D35LJzHXcr/4CSW5qNS9aHUzYOC2qycxQlsURZjctcyLWZ
4pBSrLCgTNkct+K/YGuaccnzWzx93vfznu/vdmoGU4nhWAhhji+FIezQmxdC
Ws6wz5X9tMzIVH4IdfIfh9ZHdJOghC7itFJupoIyqqjk0lyJLKWITxRTTcxZ
bkEIOcwyQ5vu2LVOOOWWG1r0fWb6SXKuO6PDTDsFzgPZ1ln85hdx3a7cY5s0
OxTrs4hH38B1lvjDRfRO+hf5yn/eeSMvene/T9BJT/QNonvSbv8g72mybqae
RhqivX7Jfb8xQophkvoNuckq66yxRa6zMlnKFJN81i3LFb7zkx90epYFuUjG
+pqB6L+UTzzy12wtE9bzzr6ywLNuXI5ywBh3DPEBm61IfQ==
         "]]},
       "1.5`"],
      Annotation[#, 1.5, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0], LineBox[CompressedData["
1:eJwV0M8r33EcwPG3H7fFlJvS19d3SHzZfKf8jNNKaQcJh512o3zVcnObNg5T
vhwQhQ21A+7+AFvjwlYYNcpsHBCO2+zxPTx7vF+v9+fT99sn+nKgI5kRQnij
vrwQerWZG8JnfVI8J4R6NmhEb1VrV8csXSlDl8rUtX64H+Qxz3nCC37kPfN1
qtuHIdxp3HnF3QvGdGO3bG5kk5r13P43F+1/8T2jdkX8aZ7nKRd4xm5+5wyf
sEYJRcz7nOIep3nALn7jJCtYqbgKzbtMcYcT/MpObnGMJSxVmQrMEf/rHYvN
MT1Sm113+hvapzjKHq7yAZ/57i3Or5wP2W4+Yqtee/8v43b9zkOe+WN+bL5n
Ff+xmtnuapRIv8dhPU3PKrf74Jk15yWuc46z+qJtbaV/QxtK6j+u0Uya
         "]], LineBox[CompressedData["
1:eJwVz0kvnWEYgOGXRCnFYSNiZR6XhoXx0LVFIxKWhpYQ5xAs1JiQ2NmYNm0i
oZGopPUDsBMEiflntEtsXGdx5X6f53vPl+8U9sW+jCWFENaIR0I4JMY1N1zx
g5/8zQrhl/7RPa3KDKHeuYEVlqm1q9MirXLnn1bqf63WR33jiXLzs1bogd80
0WJe1KVsZYF0c7M7jTrPAjmJHe3ut3hWTAlFlFHKvufdzLizpN+1zT5KK7l2
T0zZP+q0PmsBD0yaN3WLbT5zR8z+VuN6r/kc+c4xc4Z+IpMO+986ZH+gw3qo
efZdfDO/6DobRBP/h6/2qe6l8ZGIeYBd50Hd007d0X4NmkSf/5SsUWqcXz0b
cR5NfIP3HpuH9VRX9UQjWkIK9eZZnSOVTu/4oBX2vc4Xzj16qeeMO58xwTs+
LEbf
         "]]},
       "1"],
      Annotation[#, 1, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       {Opacity[0], LineBox[CompressedData["
1:eJwV0TkvZWEcwOFXISGxFSQjsd0OhZlqxifgxlBw3USicnt8BgZjSZBYQmKs
FREaZhT2nQINhUwyM4RmepSeUzz5vf/3Pefc5cRSnU0daSGEXr7nhdBPH6mc
EP7zxDM/+cUWB9kh1LnmUNd5sTfPAvHcEGpptU66psa6WRPk2BtmhHpa3Pum
rzzwyCJLZDlr0L/8sP6js/pP1/TRc2f0s36hmjpnX5m0X2X+yCdKzOPcWk/o
nSb1Rke1XCuopMg8zJX1iF5rQi91SEu1jBiF5gHOrQf1Qpv0TPu0SIujz+eD
+VR79ER7Ne671nJk7jYf6jc91lX97axLZ6L/IPr91LDjfJdt9tljxf4yjdHz
Nd9eunUBGeZMOmiP3pV3MccCi0wzxT1tzsd0kw3eAen8TmE=
         "]], LineBox[CompressedData["
1:eJwV0T9Pk1EUx/GrC4EIpZBUBCHxXSigDi2KsBhZkdaOpUpUjNZYNNHECBuR
AZh1VKEI/gGTGk0QJkfqK4C41Nadzx2++Z7fOSf33ifPufzMjTsnQghLmO8M
YQGvsITXGGwPoZQI4TE65HbMqh9guiOEIn7aGdf/wRPySU5xnrd5Bxn1b07z
P26gjv9o4hRyzrjM1/kSJ+22ueet+g2quKJ31fybekT9Pr6D33GBu9Fjdps/
6BV5jXe5kxPxO3BXrnCv3U2+L2/wPf7Iv+JZ3IUkHspbfNb+Fy7Jn/gRf+Y9
PsM9OI0n8lfut/8Hc/IBl7nG+7zKK1jGU3mAU9wX34UqnslZ3/tc/QLf7Yzp
vVRf4ymzjHok3iu3IK1Xi/dhSD2M8/Ff4kLM+iv2L/IclzGlzmHUPMu30IqM
PM43MRn/nVxHA00c4TCeb1bwtkV1BX+xjmM9MU8d
         "]]},
       "0.5`"],
      Annotation[#, 0.5, "Tooltip"]& ], {}, {}}}],
  AspectRatio->1,
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 18},
  Frame->True,
  FrameStyle->Thickness[Large],
  FrameTicks->{{{{-1, 
       FormBox[
        RowBox[{"-", "1"}], TraditionalForm]}, {0, 
       FormBox["0", TraditionalForm]}, {1, 
       FormBox["1", TraditionalForm]}}, None}, {{{-1, 
       FormBox[
        RowBox[{"-", "1"}], TraditionalForm]}, {0, 
       FormBox["0", TraditionalForm]}, {1, 
       FormBox["1", TraditionalForm]}}, None}},
  FrameTicksStyle->Thickness[Large],
  PlotRange->{{-1, 1}, {-1, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5630465521797495`*^9, 3.5630466125362554`*^9, 3.563046731314864*^9, 
   3.5630468822919292`*^9, 3.563047261540596*^9, 3.5630473490411496`*^9, 
   3.5630474031108446`*^9, 3.5630478516584325`*^9, {3.5630480368307576`*^9, 
   3.5630480603555984`*^9}, 3.563048104768877*^9, 3.56304836298213*^9, 
   3.563048404759004*^9, 3.563048588905327*^9, 3.5630486704402695`*^9, 
   3.5630487533232155`*^9, {3.5630499329276896`*^9, 3.5630499472173147`*^9}, 
   3.5630499857493825`*^9, 3.563050042098282*^9, 3.563050077316743*^9, 
   3.563106573353532*^9, 3.563107642713743*^9, 3.5631076837506137`*^9, 
   3.5631110720424833`*^9, 3.5631115401692877`*^9, 3.563111598918988*^9, 
   3.5631116391906567`*^9, 3.5631118214397707`*^9, 3.5631119494375887`*^9, 
   3.563112784091428*^9, {3.5631129839077697`*^9, 3.563113002315802*^9}, 
   3.563113062778303*^9, 3.5631136944218063`*^9, 3.5631277472706676`*^9, 
   3.563128122207726*^9, 3.5631281534077806`*^9, 3.5631282389895315`*^9, 
   3.563128421320475*^9, 3.563128451958929*^9, 3.563128794043862*^9, 
   3.563128826460719*^9, 3.5631289434921246`*^9, 3.5631293701060734`*^9, {
   3.563129454611422*^9, 3.5631294743922567`*^9}, 3.563129698767451*^9, 
   3.5631297799343934`*^9, 3.563129873004157*^9, 3.563129954867101*^9, {
   3.563130053197674*^9, 3.5631300680800996`*^9}, 3.5631304712000103`*^9, 
   3.5631307469304943`*^9, 3.5631307769449472`*^9, 3.5633730064431467`*^9, 
   3.5633731022532806`*^9, 3.5633731485833454`*^9, 3.563373218813444*^9, 
   3.563553505166424*^9, 3.564783556134794*^9, 3.564843301189065*^9, 
   3.5648434945358047`*^9, 3.5648435340038743`*^9, {3.56484363988126*^9, 
   3.56484366821091*^9}, 3.5648439565462165`*^9, 3.5648440390079613`*^9, 
   3.564850817812276*^9, 3.564850864347158*^9, 3.56485091674765*^9, 
   3.564851551715565*^9, 3.564852507934845*^9, 3.5648526025022106`*^9, 
   3.5648526547623024`*^9, 3.567106143076501*^9, 3.5844775219929867`*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Quadratic Form x^T M x over the unit circle\"\>"], "Print",
 CellChangeTimes->{
  3.5629550986360693`*^9, 3.5629552384747143`*^9, 3.562955397017793*^9, {
   3.5629554461890793`*^9, 3.562955473286327*^9}, 3.562955546996456*^9, 
   3.5629555878685284`*^9, 3.562955627133797*^9, {3.5629556758214827`*^9, 
   3.5629556912499104`*^9}, 3.562955749516012*^9, 3.5629558033673067`*^9, 
   3.562955842694976*^9, 3.562963384191823*^9, 3.562963419042284*^9, 
   3.5630191524226074`*^9, 3.5630192141363153`*^9, {3.5630192856000414`*^9, 
   3.563019310185684*^9}, {3.5630193541153617`*^9, 3.5630193621181755`*^9}, 
   3.563019561034125*^9, {3.563020346167904*^9, 3.563020394621589*^9}, 
   3.563020527315422*^9, 3.5630205861275253`*^9, 3.563020631508005*^9, {
   3.5630206764048843`*^9, 3.563020718712158*^9}, 3.563020757727827*^9, {
   3.56302081655553*^9, 3.5630208254007454`*^9}, 3.5630209318085327`*^9, {
   3.5630218360797205`*^9, 3.563021863426569*^9}, {3.5630219037370396`*^9, 
   3.563021918635066*^9}, {3.5630219850131826`*^9, 3.5630220960697775`*^9}, 
   3.56302247810887*^9, 3.5630225147597356`*^9, {3.5630227914389234`*^9, 
   3.5630228139497633`*^9}, {3.563022860718645*^9, 3.563022961978423*^9}, 
   3.5630244252141933`*^9, {3.56302450898634*^9, 3.563024538470392*^9}, 
   3.563024573898054*^9, {3.5630246048485084`*^9, 3.5630246393713694`*^9}, {
   3.563024669666622*^9, 3.5630246931290636`*^9}, 3.5630247649359894`*^9, 
   3.5630250207452393`*^9, 3.563025263450465*^9, 3.563027130305744*^9, 
   3.563027228117916*^9, {3.5630274502935066`*^9, 3.5630274739899483`*^9}, {
   3.5630277148231707`*^9, 3.5630277394712143`*^9}, {3.5630294341021905`*^9, 
   3.5630294574242315`*^9}, 3.563029489903489*^9, 3.5630295392931757`*^9, 
   3.5630296129097047`*^9, 3.5630297851964073`*^9, {3.5630298821349773`*^9, 
   3.5630298996070085`*^9}, 3.563044604979759*^9, 3.5630450931871867`*^9, 
   3.563045157209699*^9, 3.5630452052109833`*^9, 3.563045235787037*^9, 
   3.563045378652088*^9, {3.5630454110377455`*^9, 3.5630454334393845`*^9}, 
   3.5630456828994226`*^9, 3.563045781709996*^9, 3.5630458374644938`*^9, 
   3.5630458690857496`*^9, 3.5630462941864967`*^9, 3.56304645572478*^9, 
   3.5630465521329494`*^9, 3.5630466124582553`*^9, 3.5630467308312635`*^9, 
   3.563046882213929*^9, 3.5630472614469957`*^9, 3.563047348963149*^9, 
   3.5630474030328445`*^9, 3.563047851564832*^9, {3.5630480367371573`*^9, 
   3.563048060277599*^9}, 3.563048104690877*^9, 3.5630483629041305`*^9, 
   3.5630484046654034`*^9, 3.563048588827327*^9, 3.5630486703622694`*^9, 
   3.563048753229615*^9, {3.5630499328496895`*^9, 3.5630499471237144`*^9}, 
   3.5630499856557827`*^9, 3.563050042004681*^9, 3.563050077238743*^9, 
   3.5631065732665267`*^9, 3.563107642632543*^9, 3.5631076836570134`*^9, 
   3.5631110719644833`*^9, 3.5631115400192876`*^9, 3.563111598825388*^9, 
   3.5631116390814567`*^9, 3.56311182131497*^9, 3.563111949317589*^9, 
   3.563112783982228*^9, {3.5631129837985697`*^9, 3.5631130017854013`*^9}, 
   3.5631130626691027`*^9, 3.5631136942970057`*^9, 3.5631277471770678`*^9, 
   3.5631281219113255`*^9, 3.563128153298581*^9, 3.5631282388959312`*^9, 
   3.5631284212424755`*^9, 3.5631284518497286`*^9, 3.563128793934662*^9, 
   3.563128826367119*^9, 3.563128943382924*^9, 3.563129369794073*^9, {
   3.563129454533422*^9, 3.5631294742986565`*^9}, 3.5631296986894507`*^9, 
   3.5631297798251934`*^9, 3.563129872910557*^9, 3.563129954773501*^9, {
   3.563130047488064*^9, 3.563130067580899*^9}, 3.56313047110641*^9, 
   3.5631307464312935`*^9, 3.563130776866947*^9, 3.5633730059831457`*^9, 
   3.5633731021632805`*^9, 3.5633731485033455`*^9, 3.5633732187334433`*^9, 
   3.563553505104024*^9, 3.5647835560879936`*^9, 3.5648433002062635`*^9, 
   3.5648434942862043`*^9, 3.564843533863474*^9, {3.5648436392572594`*^9, 
   3.5648436681173096`*^9}, 3.564843956452616*^9, 3.564844038914361*^9, 
   3.564850817734276*^9, 3.5648508642847576`*^9, 3.56485091665405*^9, 
   3.5648515516219654`*^9, 3.5648525078256445`*^9, 3.5648526023930106`*^9, 
   3.564852654668702*^9, 3.567106143036501*^9, 3.5844775219929867`*^9}],

Cell[BoxData["\<\"  Green plane is qform = lambda1 -- evec r1 then r1^T M r1 \
= lambda1. \"\>"], "Print",
 CellChangeTimes->{
  3.5629550986360693`*^9, 3.5629552384747143`*^9, 3.562955397017793*^9, {
   3.5629554461890793`*^9, 3.562955473286327*^9}, 3.562955546996456*^9, 
   3.5629555878685284`*^9, 3.562955627133797*^9, {3.5629556758214827`*^9, 
   3.5629556912499104`*^9}, 3.562955749516012*^9, 3.5629558033673067`*^9, 
   3.562955842694976*^9, 3.562963384191823*^9, 3.562963419042284*^9, 
   3.5630191524226074`*^9, 3.5630192141363153`*^9, {3.5630192856000414`*^9, 
   3.563019310185684*^9}, {3.5630193541153617`*^9, 3.5630193621181755`*^9}, 
   3.563019561034125*^9, {3.563020346167904*^9, 3.563020394621589*^9}, 
   3.563020527315422*^9, 3.5630205861275253`*^9, 3.563020631508005*^9, {
   3.5630206764048843`*^9, 3.563020718712158*^9}, 3.563020757727827*^9, {
   3.56302081655553*^9, 3.5630208254007454`*^9}, 3.5630209318085327`*^9, {
   3.5630218360797205`*^9, 3.563021863426569*^9}, {3.5630219037370396`*^9, 
   3.563021918635066*^9}, {3.5630219850131826`*^9, 3.5630220960697775`*^9}, 
   3.56302247810887*^9, 3.5630225147597356`*^9, {3.5630227914389234`*^9, 
   3.5630228139497633`*^9}, {3.563022860718645*^9, 3.563022961978423*^9}, 
   3.5630244252141933`*^9, {3.56302450898634*^9, 3.563024538470392*^9}, 
   3.563024573898054*^9, {3.5630246048485084`*^9, 3.5630246393713694`*^9}, {
   3.563024669666622*^9, 3.5630246931290636`*^9}, 3.5630247649359894`*^9, 
   3.5630250207452393`*^9, 3.563025263450465*^9, 3.563027130305744*^9, 
   3.563027228117916*^9, {3.5630274502935066`*^9, 3.5630274739899483`*^9}, {
   3.5630277148231707`*^9, 3.5630277394712143`*^9}, {3.5630294341021905`*^9, 
   3.5630294574242315`*^9}, 3.563029489903489*^9, 3.5630295392931757`*^9, 
   3.5630296129097047`*^9, 3.5630297851964073`*^9, {3.5630298821349773`*^9, 
   3.5630298996070085`*^9}, 3.563044604979759*^9, 3.5630450931871867`*^9, 
   3.563045157209699*^9, 3.5630452052109833`*^9, 3.563045235787037*^9, 
   3.563045378652088*^9, {3.5630454110377455`*^9, 3.5630454334393845`*^9}, 
   3.5630456828994226`*^9, 3.563045781709996*^9, 3.5630458374644938`*^9, 
   3.5630458690857496`*^9, 3.5630462941864967`*^9, 3.56304645572478*^9, 
   3.5630465521329494`*^9, 3.5630466124582553`*^9, 3.5630467308312635`*^9, 
   3.563046882213929*^9, 3.5630472614469957`*^9, 3.563047348963149*^9, 
   3.5630474030328445`*^9, 3.563047851564832*^9, {3.5630480367371573`*^9, 
   3.563048060277599*^9}, 3.563048104690877*^9, 3.5630483629041305`*^9, 
   3.5630484046654034`*^9, 3.563048588827327*^9, 3.5630486703622694`*^9, 
   3.563048753229615*^9, {3.5630499328496895`*^9, 3.5630499471237144`*^9}, 
   3.5630499856557827`*^9, 3.563050042004681*^9, 3.563050077238743*^9, 
   3.5631065732665267`*^9, 3.563107642632543*^9, 3.5631076836570134`*^9, 
   3.5631110719644833`*^9, 3.5631115400192876`*^9, 3.563111598825388*^9, 
   3.5631116390814567`*^9, 3.56311182131497*^9, 3.563111949317589*^9, 
   3.563112783982228*^9, {3.5631129837985697`*^9, 3.5631130017854013`*^9}, 
   3.5631130626691027`*^9, 3.5631136942970057`*^9, 3.5631277471770678`*^9, 
   3.5631281219113255`*^9, 3.563128153298581*^9, 3.5631282388959312`*^9, 
   3.5631284212424755`*^9, 3.5631284518497286`*^9, 3.563128793934662*^9, 
   3.563128826367119*^9, 3.563128943382924*^9, 3.563129369794073*^9, {
   3.563129454533422*^9, 3.5631294742986565`*^9}, 3.5631296986894507`*^9, 
   3.5631297798251934`*^9, 3.563129872910557*^9, 3.563129954773501*^9, {
   3.563130047488064*^9, 3.563130067580899*^9}, 3.56313047110641*^9, 
   3.5631307464312935`*^9, 3.563130776866947*^9, 3.5633730059831457`*^9, 
   3.5633731021632805`*^9, 3.5633731485033455`*^9, 3.5633732187334433`*^9, 
   3.563553505104024*^9, 3.5647835560879936`*^9, 3.5648433002062635`*^9, 
   3.5648434942862043`*^9, 3.564843533863474*^9, {3.5648436392572594`*^9, 
   3.5648436681173096`*^9}, 3.564843956452616*^9, 3.564844038914361*^9, 
   3.564850817734276*^9, 3.5648508642847576`*^9, 3.56485091665405*^9, 
   3.5648515516219654`*^9, 3.5648525078256445`*^9, 3.5648526023930106`*^9, 
   3.564852654668702*^9, 3.567106143036501*^9, 3.5844775219929867`*^9}],

Cell[BoxData["\<\"     This plane touches the unit circle CONS in an \
eigendirection \"\>"], "Print",
 CellChangeTimes->{
  3.5629550986360693`*^9, 3.5629552384747143`*^9, 3.562955397017793*^9, {
   3.5629554461890793`*^9, 3.562955473286327*^9}, 3.562955546996456*^9, 
   3.5629555878685284`*^9, 3.562955627133797*^9, {3.5629556758214827`*^9, 
   3.5629556912499104`*^9}, 3.562955749516012*^9, 3.5629558033673067`*^9, 
   3.562955842694976*^9, 3.562963384191823*^9, 3.562963419042284*^9, 
   3.5630191524226074`*^9, 3.5630192141363153`*^9, {3.5630192856000414`*^9, 
   3.563019310185684*^9}, {3.5630193541153617`*^9, 3.5630193621181755`*^9}, 
   3.563019561034125*^9, {3.563020346167904*^9, 3.563020394621589*^9}, 
   3.563020527315422*^9, 3.5630205861275253`*^9, 3.563020631508005*^9, {
   3.5630206764048843`*^9, 3.563020718712158*^9}, 3.563020757727827*^9, {
   3.56302081655553*^9, 3.5630208254007454`*^9}, 3.5630209318085327`*^9, {
   3.5630218360797205`*^9, 3.563021863426569*^9}, {3.5630219037370396`*^9, 
   3.563021918635066*^9}, {3.5630219850131826`*^9, 3.5630220960697775`*^9}, 
   3.56302247810887*^9, 3.5630225147597356`*^9, {3.5630227914389234`*^9, 
   3.5630228139497633`*^9}, {3.563022860718645*^9, 3.563022961978423*^9}, 
   3.5630244252141933`*^9, {3.56302450898634*^9, 3.563024538470392*^9}, 
   3.563024573898054*^9, {3.5630246048485084`*^9, 3.5630246393713694`*^9}, {
   3.563024669666622*^9, 3.5630246931290636`*^9}, 3.5630247649359894`*^9, 
   3.5630250207452393`*^9, 3.563025263450465*^9, 3.563027130305744*^9, 
   3.563027228117916*^9, {3.5630274502935066`*^9, 3.5630274739899483`*^9}, {
   3.5630277148231707`*^9, 3.5630277394712143`*^9}, {3.5630294341021905`*^9, 
   3.5630294574242315`*^9}, 3.563029489903489*^9, 3.5630295392931757`*^9, 
   3.5630296129097047`*^9, 3.5630297851964073`*^9, {3.5630298821349773`*^9, 
   3.5630298996070085`*^9}, 3.563044604979759*^9, 3.5630450931871867`*^9, 
   3.563045157209699*^9, 3.5630452052109833`*^9, 3.563045235787037*^9, 
   3.563045378652088*^9, {3.5630454110377455`*^9, 3.5630454334393845`*^9}, 
   3.5630456828994226`*^9, 3.563045781709996*^9, 3.5630458374644938`*^9, 
   3.5630458690857496`*^9, 3.5630462941864967`*^9, 3.56304645572478*^9, 
   3.5630465521329494`*^9, 3.5630466124582553`*^9, 3.5630467308312635`*^9, 
   3.563046882213929*^9, 3.5630472614469957`*^9, 3.563047348963149*^9, 
   3.5630474030328445`*^9, 3.563047851564832*^9, {3.5630480367371573`*^9, 
   3.563048060277599*^9}, 3.563048104690877*^9, 3.5630483629041305`*^9, 
   3.5630484046654034`*^9, 3.563048588827327*^9, 3.5630486703622694`*^9, 
   3.563048753229615*^9, {3.5630499328496895`*^9, 3.5630499471237144`*^9}, 
   3.5630499856557827`*^9, 3.563050042004681*^9, 3.563050077238743*^9, 
   3.5631065732665267`*^9, 3.563107642632543*^9, 3.5631076836570134`*^9, 
   3.5631110719644833`*^9, 3.5631115400192876`*^9, 3.563111598825388*^9, 
   3.5631116390814567`*^9, 3.56311182131497*^9, 3.563111949317589*^9, 
   3.563112783982228*^9, {3.5631129837985697`*^9, 3.5631130017854013`*^9}, 
   3.5631130626691027`*^9, 3.5631136942970057`*^9, 3.5631277471770678`*^9, 
   3.5631281219113255`*^9, 3.563128153298581*^9, 3.5631282388959312`*^9, 
   3.5631284212424755`*^9, 3.5631284518497286`*^9, 3.563128793934662*^9, 
   3.563128826367119*^9, 3.563128943382924*^9, 3.563129369794073*^9, {
   3.563129454533422*^9, 3.5631294742986565`*^9}, 3.5631296986894507`*^9, 
   3.5631297798251934`*^9, 3.563129872910557*^9, 3.563129954773501*^9, {
   3.563130047488064*^9, 3.563130067580899*^9}, 3.56313047110641*^9, 
   3.5631307464312935`*^9, 3.563130776866947*^9, 3.5633730059831457`*^9, 
   3.5633731021632805`*^9, 3.5633731485033455`*^9, 3.5633732187334433`*^9, 
   3.563553505104024*^9, 3.5647835560879936`*^9, 3.5648433002062635`*^9, 
   3.5648434942862043`*^9, 3.564843533863474*^9, {3.5648436392572594`*^9, 
   3.5648436681173096`*^9}, 3.564843956452616*^9, 3.564844038914361*^9, 
   3.564850817734276*^9, 3.5648508642847576`*^9, 3.56485091665405*^9, 
   3.5648515516219654`*^9, 3.5648525078256445`*^9, 3.5648526023930106`*^9, 
   3.564852654668702*^9, 3.567106143036501*^9, 3.5844775219929867`*^9}],

Cell[BoxData["\<\"  Blue plane is qform = 1\"\>"], "Print",
 CellChangeTimes->{
  3.5629550986360693`*^9, 3.5629552384747143`*^9, 3.562955397017793*^9, {
   3.5629554461890793`*^9, 3.562955473286327*^9}, 3.562955546996456*^9, 
   3.5629555878685284`*^9, 3.562955627133797*^9, {3.5629556758214827`*^9, 
   3.5629556912499104`*^9}, 3.562955749516012*^9, 3.5629558033673067`*^9, 
   3.562955842694976*^9, 3.562963384191823*^9, 3.562963419042284*^9, 
   3.5630191524226074`*^9, 3.5630192141363153`*^9, {3.5630192856000414`*^9, 
   3.563019310185684*^9}, {3.5630193541153617`*^9, 3.5630193621181755`*^9}, 
   3.563019561034125*^9, {3.563020346167904*^9, 3.563020394621589*^9}, 
   3.563020527315422*^9, 3.5630205861275253`*^9, 3.563020631508005*^9, {
   3.5630206764048843`*^9, 3.563020718712158*^9}, 3.563020757727827*^9, {
   3.56302081655553*^9, 3.5630208254007454`*^9}, 3.5630209318085327`*^9, {
   3.5630218360797205`*^9, 3.563021863426569*^9}, {3.5630219037370396`*^9, 
   3.563021918635066*^9}, {3.5630219850131826`*^9, 3.5630220960697775`*^9}, 
   3.56302247810887*^9, 3.5630225147597356`*^9, {3.5630227914389234`*^9, 
   3.5630228139497633`*^9}, {3.563022860718645*^9, 3.563022961978423*^9}, 
   3.5630244252141933`*^9, {3.56302450898634*^9, 3.563024538470392*^9}, 
   3.563024573898054*^9, {3.5630246048485084`*^9, 3.5630246393713694`*^9}, {
   3.563024669666622*^9, 3.5630246931290636`*^9}, 3.5630247649359894`*^9, 
   3.5630250207452393`*^9, 3.563025263450465*^9, 3.563027130305744*^9, 
   3.563027228117916*^9, {3.5630274502935066`*^9, 3.5630274739899483`*^9}, {
   3.5630277148231707`*^9, 3.5630277394712143`*^9}, {3.5630294341021905`*^9, 
   3.5630294574242315`*^9}, 3.563029489903489*^9, 3.5630295392931757`*^9, 
   3.5630296129097047`*^9, 3.5630297851964073`*^9, {3.5630298821349773`*^9, 
   3.5630298996070085`*^9}, 3.563044604979759*^9, 3.5630450931871867`*^9, 
   3.563045157209699*^9, 3.5630452052109833`*^9, 3.563045235787037*^9, 
   3.563045378652088*^9, {3.5630454110377455`*^9, 3.5630454334393845`*^9}, 
   3.5630456828994226`*^9, 3.563045781709996*^9, 3.5630458374644938`*^9, 
   3.5630458690857496`*^9, 3.5630462941864967`*^9, 3.56304645572478*^9, 
   3.5630465521329494`*^9, 3.5630466124582553`*^9, 3.5630467308312635`*^9, 
   3.563046882213929*^9, 3.5630472614469957`*^9, 3.563047348963149*^9, 
   3.5630474030328445`*^9, 3.563047851564832*^9, {3.5630480367371573`*^9, 
   3.563048060277599*^9}, 3.563048104690877*^9, 3.5630483629041305`*^9, 
   3.5630484046654034`*^9, 3.563048588827327*^9, 3.5630486703622694`*^9, 
   3.563048753229615*^9, {3.5630499328496895`*^9, 3.5630499471237144`*^9}, 
   3.5630499856557827`*^9, 3.563050042004681*^9, 3.563050077238743*^9, 
   3.5631065732665267`*^9, 3.563107642632543*^9, 3.5631076836570134`*^9, 
   3.5631110719644833`*^9, 3.5631115400192876`*^9, 3.563111598825388*^9, 
   3.5631116390814567`*^9, 3.56311182131497*^9, 3.563111949317589*^9, 
   3.563112783982228*^9, {3.5631129837985697`*^9, 3.5631130017854013`*^9}, 
   3.5631130626691027`*^9, 3.5631136942970057`*^9, 3.5631277471770678`*^9, 
   3.5631281219113255`*^9, 3.563128153298581*^9, 3.5631282388959312`*^9, 
   3.5631284212424755`*^9, 3.5631284518497286`*^9, 3.563128793934662*^9, 
   3.563128826367119*^9, 3.563128943382924*^9, 3.563129369794073*^9, {
   3.563129454533422*^9, 3.5631294742986565`*^9}, 3.5631296986894507`*^9, 
   3.5631297798251934`*^9, 3.563129872910557*^9, 3.563129954773501*^9, {
   3.563130047488064*^9, 3.563130067580899*^9}, 3.56313047110641*^9, 
   3.5631307464312935`*^9, 3.563130776866947*^9, 3.5633730059831457`*^9, 
   3.5633731021632805`*^9, 3.5633731485033455`*^9, 3.5633732187334433`*^9, 
   3.563553505104024*^9, 3.5647835560879936`*^9, 3.5648433002062635`*^9, 
   3.5648434942862043`*^9, 3.564843533863474*^9, {3.5648436392572594`*^9, 
   3.5648436681173096`*^9}, 3.564843956452616*^9, 3.564844038914361*^9, 
   3.564850817734276*^9, 3.5648508642847576`*^9, 3.56485091665405*^9, 
   3.5648515516219654`*^9, 3.5648525078256445`*^9, 3.5648526023930106`*^9, 
   3.564852654668702*^9, 3.567106143036501*^9, 3.5844775220085864`*^9}],

Cell[BoxData["\<\"Yellow unit circle mapped to action ellipse in gray\"\>"], \
"Print",
 CellChangeTimes->{
  3.5629550986360693`*^9, 3.5629552384747143`*^9, 3.562955397017793*^9, {
   3.5629554461890793`*^9, 3.562955473286327*^9}, 3.562955546996456*^9, 
   3.5629555878685284`*^9, 3.562955627133797*^9, {3.5629556758214827`*^9, 
   3.5629556912499104`*^9}, 3.562955749516012*^9, 3.5629558033673067`*^9, 
   3.562955842694976*^9, 3.562963384191823*^9, 3.562963419042284*^9, 
   3.5630191524226074`*^9, 3.5630192141363153`*^9, {3.5630192856000414`*^9, 
   3.563019310185684*^9}, {3.5630193541153617`*^9, 3.5630193621181755`*^9}, 
   3.563019561034125*^9, {3.563020346167904*^9, 3.563020394621589*^9}, 
   3.563020527315422*^9, 3.5630205861275253`*^9, 3.563020631508005*^9, {
   3.5630206764048843`*^9, 3.563020718712158*^9}, 3.563020757727827*^9, {
   3.56302081655553*^9, 3.5630208254007454`*^9}, 3.5630209318085327`*^9, {
   3.5630218360797205`*^9, 3.563021863426569*^9}, {3.5630219037370396`*^9, 
   3.563021918635066*^9}, {3.5630219850131826`*^9, 3.5630220960697775`*^9}, 
   3.56302247810887*^9, 3.5630225147597356`*^9, {3.5630227914389234`*^9, 
   3.5630228139497633`*^9}, {3.563022860718645*^9, 3.563022961978423*^9}, 
   3.5630244252141933`*^9, {3.56302450898634*^9, 3.563024538470392*^9}, 
   3.563024573898054*^9, {3.5630246048485084`*^9, 3.5630246393713694`*^9}, {
   3.563024669666622*^9, 3.5630246931290636`*^9}, 3.5630247649359894`*^9, 
   3.5630250207452393`*^9, 3.563025263450465*^9, 3.563027130305744*^9, 
   3.563027228117916*^9, {3.5630274502935066`*^9, 3.5630274739899483`*^9}, {
   3.5630277148231707`*^9, 3.5630277394712143`*^9}, {3.5630294341021905`*^9, 
   3.5630294574242315`*^9}, 3.563029489903489*^9, 3.5630295392931757`*^9, 
   3.5630296129097047`*^9, 3.5630297851964073`*^9, {3.5630298821349773`*^9, 
   3.5630298996070085`*^9}, 3.563044604979759*^9, 3.5630450931871867`*^9, 
   3.563045157209699*^9, 3.5630452052109833`*^9, 3.563045235787037*^9, 
   3.563045378652088*^9, {3.5630454110377455`*^9, 3.5630454334393845`*^9}, 
   3.5630456828994226`*^9, 3.563045781709996*^9, 3.5630458374644938`*^9, 
   3.5630458690857496`*^9, 3.5630462941864967`*^9, 3.56304645572478*^9, 
   3.5630465521329494`*^9, 3.5630466124582553`*^9, 3.5630467308312635`*^9, 
   3.563046882213929*^9, 3.5630472614469957`*^9, 3.563047348963149*^9, 
   3.5630474030328445`*^9, 3.563047851564832*^9, {3.5630480367371573`*^9, 
   3.563048060277599*^9}, 3.563048104690877*^9, 3.5630483629041305`*^9, 
   3.5630484046654034`*^9, 3.563048588827327*^9, 3.5630486703622694`*^9, 
   3.563048753229615*^9, {3.5630499328496895`*^9, 3.5630499471237144`*^9}, 
   3.5630499856557827`*^9, 3.563050042004681*^9, 3.563050077238743*^9, 
   3.5631065732665267`*^9, 3.563107642632543*^9, 3.5631076836570134`*^9, 
   3.5631110719644833`*^9, 3.5631115400192876`*^9, 3.563111598825388*^9, 
   3.5631116390814567`*^9, 3.56311182131497*^9, 3.563111949317589*^9, 
   3.563112783982228*^9, {3.5631129837985697`*^9, 3.5631130017854013`*^9}, 
   3.5631130626691027`*^9, 3.5631136942970057`*^9, 3.5631277471770678`*^9, 
   3.5631281219113255`*^9, 3.563128153298581*^9, 3.5631282388959312`*^9, 
   3.5631284212424755`*^9, 3.5631284518497286`*^9, 3.563128793934662*^9, 
   3.563128826367119*^9, 3.563128943382924*^9, 3.563129369794073*^9, {
   3.563129454533422*^9, 3.5631294742986565`*^9}, 3.5631296986894507`*^9, 
   3.5631297798251934`*^9, 3.563129872910557*^9, 3.563129954773501*^9, {
   3.563130047488064*^9, 3.563130067580899*^9}, 3.56313047110641*^9, 
   3.5631307464312935`*^9, 3.563130776866947*^9, 3.5633730059831457`*^9, 
   3.5633731021632805`*^9, 3.5633731485033455`*^9, 3.5633732187334433`*^9, 
   3.563553505104024*^9, 3.5647835560879936`*^9, 3.5648433002062635`*^9, 
   3.5648434942862043`*^9, 3.564843533863474*^9, {3.5648436392572594`*^9, 
   3.5648436681173096`*^9}, 3.564843956452616*^9, 3.564844038914361*^9, 
   3.564850817734276*^9, 3.5648508642847576`*^9, 3.56485091665405*^9, 
   3.5648515516219654`*^9, 3.5648525078256445`*^9, 3.5648526023930106`*^9, 
   3.564852654668702*^9, 3.567106143036501*^9, 3.5844775220085864`*^9}]
}, Open  ]],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx1mw+czlX2x59BCimprdj+qUlh1YZdod+c0dqaktqw/SFipJX1RFO/lD+F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    "], {{
      {GrayLevel[0.7], Opacity[0.8], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNmgf811MXx7/3JimU0FY0jbSslPGUrR6EpDIaSiKFRIqGpK3pSbLKLCMk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           "]], Polygon3DBox[CompressedData["
1:eJwtlWmwz1UYx895yGXMmJIwQ4YXBi96kytLQpFCIVlqRpE96xhEDCaNItKL
ZO1SyhYRKROGse9bhqLszKCkCJHi852vF5/7+z7nnP9Znu1W6zao3cBIKfWF
4tAc4zY0zSlNxf4FvQbWo8sxNhHdFf7HPgkz0INgK/pPaIFuDJVZ+wDUgiqw
hLnXGP8IvoZijJ1lbABaF5iG1j2m8ue5sNaeL+ts2Ja8ZiN6A8xAF7DHFHQP
yOgzjBWh68Je9DWYgx4Ce9B/w5foI1CW9beT3/IeHE9+02fo4bAffRPmohvA
AfQN2I/uAt/KN9AP/SNcQG9JvsskOJV8p5boJlAN/Rtjw9Cd4HryHQvlOyjF
fCUYp7cXS6l19hnjsZfAf8l33If+Hlagy7DmEnoB3MF+Its3m6Fkto9Goa/p
DdgLsLejO0ARehfUYPwvvrOgPePvQ3e4i30CPkF3hLnoi8mxnQ//JsdYvtwF
pbN9Wi/sM/lqHzQM+1S+nA9r0QfhQdZuSvZJXfRYxn5WjPm+AvPQl+BJ9Odw
C30QdqA7h99yCF5FjwzP/ZPs27fCZ8vHH6CXKpmyY6KzqmafNfZ+bPaGfakY
LUZ/JR8z/7YIn6G9lQOb0LWhYraPJ6N7K2bo08z3RL8Il9E/wBvoF+D35D2f
R08P++JR2I3eCTWzfaicVM2oVlQzOmtmOEY68zi6LVzBLo/dGt0MzmH/keyr
RsrJZJ/1Ca/R3DrlSLhmVauK6ePsUQh9lTfYK/h+E6597TkiHBPFQjXxUzjn
lGsP3/+t7qLfao9b8CxMwW7CXAly+Sj2Mew22EPDOaVcUk0WMD9Y+Yp+KTtX
nwr7Rjn7hXIBaiW/aRt6C3yaXDPqVf3Dtaeepdp5Jxw71dAy9PJwr9Gd6oR7
hHrDbnhatagzWTtAMQ77WL5Vjv6KbhPufY9A/XBPUS9Rjq4Mr9Fc8eza6RWO
vWpItboaSmTXrGJ9GB7Kjvke5X3Yl4/BKvR34d65KDm33gzHTjk2K9wz1Cuu
MvZ62Mfy7Urs2fJN+G3yqXJ/QrhXqwYuoseEa0d3OBGuSdViBezzyqVwb9Od
R6Mz+7fKjoFy+Zlwb1BOn0KfDvdi9Wj1qnflk+SepVpoGq4N1YR6/4fhXq3/
AdWze5B6j3rQIr4Lw7HQHh/r7uG7qcfeAy4q6Z0=
           "]]}],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl01VvFkEUBuBti0v4DSSEGy64KO5S3EtwAqV4gBZ3CO4ORQrFnUJx9yLF
3d29uOuz4eLZd87M5pszu/vlj0+MTYgIgiCTDMJxQZdkOS8yCKI5TDoHOMRB
HnCf/TRkH7Ek0I1qzKI7f0hkLsV4TWOS6M1ferGQkrylKbPpTxAVBP3kYsrw
gebMoTpl+cggWvCclmQwlBdc5gonOMVJrrKcdbaIobBzp8mV5l5yjeucJq+1
YfIG2fTTSm5272dZkVWsZhQ5rI8Mf5fRRKnHyDjGk1M9TqYygSzqibIdU8il
nizXM5Ws6mkyjQ1U4Xv4zO1/U84gn/52y1s8pR63wx7D9+W+AtaTZLRMl/XN
3+E8F9jDXZ7RgHvM5CJd2MsluvKDqmxkE9P5Rgx16cRvOtORSXylMnVozy86
0JaxfKEStWnDT+JZyxqGE+k5jJC72ElrzvGYJ9RiB9s5yxkqUDN8j84cSyHn
T5UrzJWnBtvYSh5rj+QWctsrgiHGS1nGYD5RjiWU5j0DacYA3lGKRZQgk740
oQ9vKE4KRXlFTxYwnx5kt2+KHhsZH+dh+E3o7Yg8xlGKkBz5/z/7D2OZiFo=

       "]]}},
    VertexNormals->CompressedData["
1:eJxFWwc4lu37LkUaVJpfKl9DS6ElaVztQYP6aGjSTihfX5N2KdHUkFFIIlJK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     "]], 
   {RGBColor[0, 0, 1], Thickness[0.003], 
    Line3DBox[
     NCache[{{{1, 0, 1.25}, {
        Cos[Rational[18, 5] Degree], Sin[Rational[18, 5] Degree], 
         1.3753332335643043`}, {
        Cos[Rational[36, 5] Degree], Sin[Rational[36, 5] Degree], 
         1.4986898871648549`}, {
        Cos[Rational[54, 5] Degree], Sin[Rational[54, 5] Degree], 
         1.618124552684678}, {
        Cos[Rational[72, 5] Degree], Sin[Rational[72, 5] Degree], 
         1.7317536741017152`}, {(Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (-1 + 5^Rational[1, 2]), 1.837785252292473}, {
        Cos[Rational[108, 5] Degree], Sin[Rational[108, 5] Degree], 
         1.9345471059286887`}, {
        Cos[Rational[126, 5] Degree], Sin[Rational[126, 5] Degree], 
         2.0205132427757895`}, {
        Cos[Rational[144, 5] Degree], Sin[Rational[144, 5] Degree], 
         2.0943279255020153`}, {
        Cos[Rational[162, 5] Degree], Sin[Rational[162, 5] Degree], 
         2.1548270524660196`}, {
        Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         2.2010565162951536`}, {
        Cos[Rational[198, 5] Degree], Sin[Rational[198, 5] Degree], 
         2.232287250728689}, {
        Cos[Rational[216, 5] Degree], Sin[Rational[216, 5] Degree], 
         2.248026728428272}, {
        Sin[Rational[216, 5] Degree], Cos[Rational[216, 5] Degree], 
         2.248026728428272}, {
        Sin[Rational[198, 5] Degree], Cos[Rational[198, 5] Degree], 
         2.232287250728689}, {(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (1 + 5^Rational[1, 2]), 2.2010565162951536`}, {
        Sin[Rational[162, 5] Degree], Cos[Rational[162, 5] Degree], 
         2.1548270524660196`}, {
        Sin[Rational[144, 5] Degree], Cos[Rational[144, 5] Degree], 
         2.0943279255020153`}, {
        Sin[Rational[126, 5] Degree], Cos[Rational[126, 5] Degree], 
         2.0205132427757895`}, {
        Sin[Rational[108, 5] Degree], Cos[Rational[108, 5] Degree], 
         1.9345471059286887`}, {
        Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         1.837785252292473}, {
        Sin[Rational[72, 5] Degree], Cos[Rational[72, 5] Degree], 
         1.7317536741017152`}, {
        Sin[Rational[54, 5] Degree], Cos[Rational[54, 5] Degree], 
         1.618124552684678}, {
        Sin[Rational[36, 5] Degree], Cos[Rational[36, 5] Degree], 
         1.4986898871648549`}, {
        Sin[Rational[18, 5] Degree], Cos[Rational[18, 5] Degree], 
         1.3753332335643043`}, {
        0, 1, 1.25}, {-Sin[Rational[18, 5] Degree], Cos[
         Rational[18, 5] Degree], 1.1246667664356957`}, {-
         Sin[Rational[36, 5] Degree], Cos[Rational[36, 5] Degree], 
         1.0013101128351451`}, {-Sin[Rational[54, 5] Degree], Cos[
         Rational[54, 5] Degree], 0.881875447315322}, {-
         Sin[Rational[72, 5] Degree], Cos[Rational[72, 5] Degree], 
         0.7682463258982846}, {
        Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         0.6622147477075266}, {-Sin[Rational[108, 5] Degree], Cos[
         Rational[108, 5] Degree], 0.5654528940713115}, {-
         Sin[Rational[126, 5] Degree], Cos[Rational[126, 5] Degree], 
         0.47948675722421097`}, {-Sin[Rational[144, 5] Degree], Cos[
         Rational[144, 5] Degree], 0.405672074497985}, {-
         Sin[Rational[162, 5] Degree], Cos[Rational[162, 5] Degree], 
         0.3451729475339805}, {-(Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (1 + 5^Rational[1, 2]), 0.29894348370484647`}, {-
         Sin[Rational[198, 5] Degree], Cos[Rational[198, 5] Degree], 
         0.2677127492713112}, {-Sin[Rational[216, 5] Degree], Cos[
         Rational[216, 5] Degree], 0.2519732715717285}, {-
         Cos[Rational[216, 5] Degree], Sin[Rational[216, 5] Degree], 
         0.2519732715717285}, {-Cos[Rational[198, 5] Degree], Sin[
         Rational[198, 5] Degree], 0.2677127492713112}, {
        Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         0.29894348370484647`}, {-Cos[Rational[162, 5] Degree], Sin[
         Rational[162, 5] Degree], 0.3451729475339805}, {-
         Cos[Rational[144, 5] Degree], Sin[Rational[144, 5] Degree], 
         0.405672074497985}, {-Cos[Rational[126, 5] Degree], Sin[
         Rational[126, 5] Degree], 0.47948675722421097`}, {-
         Cos[Rational[108, 5] Degree], Sin[Rational[108, 5] Degree], 
         0.5654528940713115}, {-(Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (-1 + 5^Rational[1, 2]), 0.6622147477075266}, {-
         Cos[Rational[72, 5] Degree], Sin[Rational[72, 5] Degree], 
         0.7682463258982846}, {-Cos[Rational[54, 5] Degree], Sin[
         Rational[54, 5] Degree], 0.881875447315322}, {-
         Cos[Rational[36, 5] Degree], Sin[Rational[36, 5] Degree], 
         1.0013101128351451`}, {-Cos[Rational[18, 5] Degree], Sin[
         Rational[18, 5] Degree], 1.1246667664356957`}, {-1, 0, 1.25}, {-
         Cos[Rational[18, 5] Degree], -Sin[Rational[18, 5] Degree], 
         1.3753332335643043`}, {-Cos[Rational[36, 5] Degree], -
         Sin[Rational[36, 5] Degree], 1.4986898871648549`}, {-
         Cos[Rational[54, 5] Degree], -Sin[Rational[54, 5] Degree], 
         1.618124552684678}, {-Cos[Rational[72, 5] Degree], -
         Sin[Rational[72, 5] Degree], 
         1.7317536741017152`}, {-(Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (1 - 5^Rational[1, 2]), 1.837785252292473}, {-
         Cos[Rational[108, 5] Degree], -Sin[Rational[108, 5] Degree], 
         1.9345471059286887`}, {-Cos[Rational[126, 5] Degree], -
         Sin[Rational[126, 5] Degree], 2.0205132427757895`}, {-
         Cos[Rational[144, 5] Degree], -Sin[Rational[144, 5] Degree], 
         2.0943279255020153`}, {-Cos[Rational[162, 5] Degree], -
         Sin[Rational[162, 5] Degree], 2.1548270524660196`}, {
        Rational[1, 4] (-1 - 5^
          Rational[1, 2]), -(Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         2.2010565162951536`}, {-Cos[Rational[198, 5] Degree], -
         Sin[Rational[198, 5] Degree], 2.232287250728689}, {-
         Cos[Rational[216, 5] Degree], -Sin[Rational[216, 5] Degree], 
         2.248026728428272}, {-Sin[Rational[216, 5] Degree], -
         Cos[Rational[216, 5] Degree], 2.248026728428272}, {-
         Sin[Rational[198, 5] Degree], -Cos[Rational[198, 5] Degree], 
         2.232287250728689}, {-(Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (-1 - 5^Rational[1, 2]), 2.2010565162951536`}, {-
         Sin[Rational[162, 5] Degree], -Cos[Rational[162, 5] Degree], 
         2.1548270524660196`}, {-Sin[Rational[144, 5] Degree], -
         Cos[Rational[144, 5] Degree], 2.0943279255020153`}, {-
         Sin[Rational[126, 5] Degree], -Cos[Rational[126, 5] Degree], 
         2.0205132427757895`}, {-Sin[Rational[108, 5] Degree], -
         Cos[Rational[108, 5] Degree], 1.9345471059286887`}, {
        Rational[1, 4] (1 - 5^
          Rational[1, 2]), -(Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         1.837785252292473}, {-Sin[Rational[72, 5] Degree], -
         Cos[Rational[72, 5] Degree], 1.7317536741017152`}, {-
         Sin[Rational[54, 5] Degree], -Cos[Rational[54, 5] Degree], 
         1.618124552684678}, {-Sin[Rational[36, 5] Degree], -
         Cos[Rational[36, 5] Degree], 1.4986898871648549`}, {-
         Sin[Rational[18, 5] Degree], -Cos[Rational[18, 5] Degree], 
         1.3753332335643043`}, {0, -1, 1.25}, {
        Sin[Rational[18, 5] Degree], -Cos[Rational[18, 5] Degree], 
         1.1246667664356957`}, {
        Sin[Rational[36, 5] Degree], -Cos[Rational[36, 5] Degree], 
         1.0013101128351451`}, {
        Sin[Rational[54, 5] Degree], -Cos[Rational[54, 5] Degree], 
         0.881875447315322}, {
        Sin[Rational[72, 5] Degree], -Cos[Rational[72, 5] Degree], 
         0.7682463258982846}, {
        Rational[1, 4] (-1 + 
          5^Rational[1, 2]), -(Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         0.6622147477075266}, {
        Sin[Rational[108, 5] Degree], -Cos[Rational[108, 5] Degree], 
         0.5654528940713115}, {
        Sin[Rational[126, 5] Degree], -Cos[Rational[126, 5] Degree], 
         0.47948675722421097`}, {
        Sin[Rational[144, 5] Degree], -Cos[Rational[144, 5] Degree], 
         0.405672074497985}, {
        Sin[Rational[162, 5] Degree], -Cos[Rational[162, 5] Degree], 
         0.3451729475339805}, {(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (-1 - 5^Rational[1, 2]), 0.29894348370484647`}, {
        Sin[Rational[198, 5] Degree], -Cos[Rational[198, 5] Degree], 
         0.2677127492713112}, {
        Sin[Rational[216, 5] Degree], -Cos[Rational[216, 5] Degree], 
         0.2519732715717285}, {
        Cos[Rational[216, 5] Degree], -Sin[Rational[216, 5] Degree], 
         0.2519732715717285}, {
        Cos[Rational[198, 5] Degree], -Sin[Rational[198, 5] Degree], 
         0.2677127492713112}, {
        Rational[1, 4] (1 + 
          5^Rational[1, 2]), -(Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         0.29894348370484647`}, {
        Cos[Rational[162, 5] Degree], -Sin[Rational[162, 5] Degree], 
         0.3451729475339805}, {
        Cos[Rational[144, 5] Degree], -Sin[Rational[144, 5] Degree], 
         0.405672074497985}, {
        Cos[Rational[126, 5] Degree], -Sin[Rational[126, 5] Degree], 
         0.47948675722421097`}, {
        Cos[Rational[108, 5] Degree], -Sin[Rational[108, 5] Degree], 
         0.5654528940713115}, {(Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (1 - 5^Rational[1, 2]), 0.6622147477075266}, {
        Cos[Rational[72, 5] Degree], -Sin[Rational[72, 5] Degree], 
         0.7682463258982846}, {
        Cos[Rational[54, 5] Degree], -Sin[Rational[54, 5] Degree], 
         0.881875447315322}, {
        Cos[Rational[36, 5] Degree], -Sin[Rational[36, 5] Degree], 
         1.0013101128351451`}, {
        Cos[Rational[18, 5] Degree], -Sin[Rational[18, 5] Degree], 
         1.1246667664356957`}}}, {{{1, 0, 1.25}, {0.9980267284282716, 
        0.06279051952931337, 1.3753332335643043`}, {0.9921147013144779, 
        0.12533323356430426`, 1.4986898871648549`}, {0.9822872507286887, 
        0.18738131458572463`, 1.618124552684678}, {0.9685831611286311, 
        0.2486898871648548, 1.7317536741017152`}, {0.9510565162951535, 
        0.30901699437494745`, 1.837785252292473}, {0.9297764858882515, 
        0.368124552684678, 1.9345471059286887`}, {0.9048270524660196, 
        0.42577929156507266`, 2.0205132427757895`}, {0.8763066800438636, 
        0.4817536741017153, 2.0943279255020153`}, {0.8443279255020151, 
        0.5358267949789967, 2.1548270524660196`}, {0.8090169943749475, 
        0.5877852522924731, 2.2010565162951536`}, {0.7705132427757891, 
        0.6374239897486897, 2.232287250728689}, {0.7289686274214116, 
        0.6845471059286887, 2.248026728428272}, {0.6845471059286887, 
        0.7289686274214116, 2.248026728428272}, {0.6374239897486897, 
        0.7705132427757891, 2.232287250728689}, {0.5877852522924731, 
        0.8090169943749475, 2.2010565162951536`}, {0.5358267949789967, 
        0.8443279255020151, 2.1548270524660196`}, {0.4817536741017153, 
        0.8763066800438636, 2.0943279255020153`}, {0.42577929156507266`, 
        0.9048270524660196, 2.0205132427757895`}, {0.368124552684678, 
        0.9297764858882515, 1.9345471059286887`}, {0.30901699437494745`, 
        0.9510565162951535, 1.837785252292473}, {0.2486898871648548, 
        0.9685831611286311, 1.7317536741017152`}, {0.18738131458572463`, 
        0.9822872507286887, 1.618124552684678}, {0.12533323356430426`, 
        0.9921147013144779, 1.4986898871648549`}, {0.06279051952931337, 
        0.9980267284282716, 1.3753332335643043`}, {
        0, 1, 1.25}, {-0.06279051952931337, 0.9980267284282716, 
        1.1246667664356957`}, {-0.12533323356430426`, 0.9921147013144779, 
        1.0013101128351451`}, {-0.18738131458572463`, 0.9822872507286887, 
        0.881875447315322}, {-0.2486898871648548, 0.9685831611286311, 
        0.7682463258982846}, {-0.30901699437494745`, 0.9510565162951535, 
        0.6622147477075266}, {-0.368124552684678, 0.9297764858882515, 
        0.5654528940713115}, {-0.42577929156507266`, 0.9048270524660196, 
        0.47948675722421097`}, {-0.4817536741017153, 0.8763066800438636, 
        0.405672074497985}, {-0.5358267949789967, 0.8443279255020151, 
        0.3451729475339805}, {-0.5877852522924731, 0.8090169943749475, 
        0.29894348370484647`}, {-0.6374239897486897, 0.7705132427757891, 
        0.2677127492713112}, {-0.6845471059286887, 0.7289686274214116, 
        0.2519732715717285}, {-0.7289686274214116, 0.6845471059286887, 
        0.2519732715717285}, {-0.7705132427757891, 0.6374239897486897, 
        0.2677127492713112}, {-0.8090169943749475, 0.5877852522924731, 
        0.29894348370484647`}, {-0.8443279255020151, 0.5358267949789967, 
        0.3451729475339805}, {-0.8763066800438636, 0.4817536741017153, 
        0.405672074497985}, {-0.9048270524660196, 0.42577929156507266`, 
        0.47948675722421097`}, {-0.9297764858882515, 0.368124552684678, 
        0.5654528940713115}, {-0.9510565162951535, 0.30901699437494745`, 
        0.6622147477075266}, {-0.9685831611286311, 0.2486898871648548, 
        0.7682463258982846}, {-0.9822872507286887, 0.18738131458572463`, 
        0.881875447315322}, {-0.9921147013144779, 0.12533323356430426`, 
        1.0013101128351451`}, {-0.9980267284282716, 0.06279051952931337, 
        1.1246667664356957`}, {-1, 0, 
         1.25}, {-0.9980267284282716, -0.06279051952931337, 
        1.3753332335643043`}, {-0.9921147013144779, -0.12533323356430426`, 
        1.4986898871648549`}, {-0.9822872507286887, -0.18738131458572463`, 
        1.618124552684678}, {-0.9685831611286311, -0.2486898871648548, 
        1.7317536741017152`}, {-0.9510565162951535, -0.30901699437494745`, 
        1.837785252292473}, {-0.9297764858882515, -0.368124552684678, 
        1.9345471059286887`}, {-0.9048270524660196, -0.42577929156507266`, 
        2.0205132427757895`}, {-0.8763066800438636, -0.4817536741017153, 
        2.0943279255020153`}, {-0.8443279255020151, -0.5358267949789967, 
        2.1548270524660196`}, {-0.8090169943749475, -0.5877852522924731, 
        2.2010565162951536`}, {-0.7705132427757891, -0.6374239897486897, 
        2.232287250728689}, {-0.7289686274214116, -0.6845471059286887, 
        2.248026728428272}, {-0.6845471059286887, -0.7289686274214116, 
        2.248026728428272}, {-0.6374239897486897, -0.7705132427757891, 
        2.232287250728689}, {-0.5877852522924731, -0.8090169943749475, 
        2.2010565162951536`}, {-0.5358267949789967, -0.8443279255020151, 
        2.1548270524660196`}, {-0.4817536741017153, -0.8763066800438636, 
        2.0943279255020153`}, {-0.42577929156507266`, -0.9048270524660196, 
        2.0205132427757895`}, {-0.368124552684678, -0.9297764858882515, 
        1.9345471059286887`}, {-0.30901699437494745`, -0.9510565162951535, 
        1.837785252292473}, {-0.2486898871648548, -0.9685831611286311, 
        1.7317536741017152`}, {-0.18738131458572463`, -0.9822872507286887, 
        1.618124552684678}, {-0.12533323356430426`, -0.9921147013144779, 
        1.4986898871648549`}, {-0.06279051952931337, -0.9980267284282716, 
        1.3753332335643043`}, {0, -1, 1.25}, {
        0.06279051952931337, -0.9980267284282716, 1.1246667664356957`}, {
        0.12533323356430426`, -0.9921147013144779, 1.0013101128351451`}, {
        0.18738131458572463`, -0.9822872507286887, 0.881875447315322}, {
        0.2486898871648548, -0.9685831611286311, 0.7682463258982846}, {
        0.30901699437494745`, -0.9510565162951535, 0.6622147477075266}, {
        0.368124552684678, -0.9297764858882515, 0.5654528940713115}, {
        0.42577929156507266`, -0.9048270524660196, 0.47948675722421097`}, {
        0.4817536741017153, -0.8763066800438636, 0.405672074497985}, {
        0.5358267949789967, -0.8443279255020151, 0.3451729475339805}, {
        0.5877852522924731, -0.8090169943749475, 0.29894348370484647`}, {
        0.6374239897486897, -0.7705132427757891, 0.2677127492713112}, {
        0.6845471059286887, -0.7289686274214116, 0.2519732715717285}, {
        0.7289686274214116, -0.6845471059286887, 0.2519732715717285}, {
        0.7705132427757891, -0.6374239897486897, 0.2677127492713112}, {
        0.8090169943749475, -0.5877852522924731, 0.29894348370484647`}, {
        0.8443279255020151, -0.5358267949789967, 0.3451729475339805}, {
        0.8763066800438636, -0.4817536741017153, 0.405672074497985}, {
        0.9048270524660196, -0.42577929156507266`, 0.47948675722421097`}, {
        0.9297764858882515, -0.368124552684678, 0.5654528940713115}, {
        0.9510565162951535, -0.30901699437494745`, 0.6622147477075266}, {
        0.9685831611286311, -0.2486898871648548, 0.7682463258982846}, {
        0.9822872507286887, -0.18738131458572463`, 0.881875447315322}, {
        0.9921147013144779, -0.12533323356430426`, 1.0013101128351451`}, {
        0.9980267284282716, -0.06279051952931337, 1.1246667664356957`}}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{1, 0, 0}, {
       Cos[Rational[18, 5] Degree], Sin[Rational[18, 5] Degree], 0}}, {{1, 0, 
       0}, {0.9980267284282716, 0.06279051952931337, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[18, 5] Degree], Sin[Rational[18, 5] Degree], 0}, {
       Cos[Rational[36, 5] Degree], Sin[Rational[36, 5] Degree], 0}}, {{
       0.9980267284282716, 0.06279051952931337, 0}, {
       0.9921147013144779, 0.12533323356430426`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[36, 5] Degree], Sin[Rational[36, 5] Degree], 0}, {
       Cos[Rational[54, 5] Degree], Sin[Rational[54, 5] Degree], 0}}, {{
       0.9921147013144779, 0.12533323356430426`, 0}, {
       0.9822872507286887, 0.18738131458572463`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[54, 5] Degree], Sin[Rational[54, 5] Degree], 0}, {
       Cos[Rational[72, 5] Degree], Sin[Rational[72, 5] Degree], 0}}, {{
       0.9822872507286887, 0.18738131458572463`, 0}, {
       0.9685831611286311, 0.2486898871648548, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[72, 5] Degree], Sin[Rational[72, 5] Degree], 
        0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 0}}, {{
       0.9685831611286311, 0.2486898871648548, 0}, {
       0.9510565162951535, 0.30901699437494745`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 0}, {
       Cos[Rational[108, 5] Degree], Sin[Rational[108, 5] Degree], 0}}, {{
       0.9510565162951535, 0.30901699437494745`, 0}, {
       0.9297764858882515, 0.368124552684678, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[108, 5] Degree], Sin[Rational[108, 5] Degree], 
        0}, {Cos[Rational[126, 5] Degree], Sin[Rational[126, 5] Degree], 
        0}}, {{0.9297764858882515, 0.368124552684678, 0}, {
       0.9048270524660196, 0.42577929156507266`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[126, 5] Degree], Sin[Rational[126, 5] Degree], 
        0}, {Cos[Rational[144, 5] Degree], Sin[Rational[144, 5] Degree], 
        0}}, {{0.9048270524660196, 0.42577929156507266`, 0}, {
       0.8763066800438636, 0.4817536741017153, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[144, 5] Degree], Sin[Rational[144, 5] Degree], 
        0}, {
       Cos[Rational[162, 5] Degree], Sin[Rational[162, 5] Degree], 0}}, {{
       0.8763066800438636, 0.4817536741017153, 0}, {
       0.8443279255020151, 0.5358267949789967, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[162, 5] Degree], Sin[Rational[162, 5] Degree], 
        0}, {Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}}, {{
       0.8443279255020151, 0.5358267949789967, 0}, {
       0.8090169943749475, 0.5877852522924731, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {
       Cos[Rational[198, 5] Degree], Sin[Rational[198, 5] Degree], 0}}, {{
       0.8090169943749475, 0.5877852522924731, 0}, {
       0.7705132427757891, 0.6374239897486897, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[198, 5] Degree], Sin[Rational[198, 5] Degree], 
        0}, {Cos[Rational[216, 5] Degree], Sin[Rational[216, 5] Degree], 
        0}}, {{0.7705132427757891, 0.6374239897486897, 0}, {
       0.7289686274214116, 0.6845471059286887, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[216, 5] Degree], Sin[Rational[216, 5] Degree], 
        0}, {Sin[Rational[216, 5] Degree], Cos[Rational[216, 5] Degree], 
        0}}, {{0.7289686274214116, 0.6845471059286887, 0}, {
       0.6845471059286887, 0.7289686274214116, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[216, 5] Degree], Cos[Rational[216, 5] Degree], 
        0}, {Sin[Rational[198, 5] Degree], Cos[Rational[198, 5] Degree], 
        0}}, {{0.6845471059286887, 0.7289686274214116, 0}, {
       0.6374239897486897, 0.7705132427757891, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[198, 5] Degree], Cos[Rational[198, 5] Degree], 
        0}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 0}}, {{
       0.6374239897486897, 0.7705132427757891, 0}, {
       0.5877852522924731, 0.8090169943749475, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 0}, {
       Sin[Rational[162, 5] Degree], Cos[Rational[162, 5] Degree], 0}}, {{
       0.5877852522924731, 0.8090169943749475, 0}, {
       0.5358267949789967, 0.8443279255020151, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[162, 5] Degree], Cos[Rational[162, 5] Degree], 
        0}, {Sin[Rational[144, 5] Degree], Cos[Rational[144, 5] Degree], 
        0}}, {{0.5358267949789967, 0.8443279255020151, 0}, {
       0.4817536741017153, 0.8763066800438636, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[144, 5] Degree], Cos[Rational[144, 5] Degree], 
        0}, {Sin[Rational[126, 5] Degree], Cos[Rational[126, 5] Degree], 
        0}}, {{0.4817536741017153, 0.8763066800438636, 0}, {
       0.42577929156507266`, 0.9048270524660196, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[126, 5] Degree], Cos[Rational[126, 5] Degree], 
        0}, {Sin[Rational[108, 5] Degree], Cos[Rational[108, 5] Degree], 
        0}}, {{0.42577929156507266`, 0.9048270524660196, 0}, {
       0.368124552684678, 0.9297764858882515, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[108, 5] Degree], Cos[Rational[108, 5] Degree], 
        0}, {Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}}, {{
       0.368124552684678, 0.9297764858882515, 0}, {
       0.30901699437494745`, 0.9510565162951535, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {
       Sin[Rational[72, 5] Degree], Cos[Rational[72, 5] Degree], 0}}, {{
       0.30901699437494745`, 0.9510565162951535, 0}, {
       0.2486898871648548, 0.9685831611286311, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[72, 5] Degree], Cos[Rational[72, 5] Degree], 0}, {
       Sin[Rational[54, 5] Degree], Cos[Rational[54, 5] Degree], 0}}, {{
       0.2486898871648548, 0.9685831611286311, 0}, {
       0.18738131458572463`, 0.9822872507286887, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[54, 5] Degree], Cos[Rational[54, 5] Degree], 0}, {
       Sin[Rational[36, 5] Degree], Cos[Rational[36, 5] Degree], 0}}, {{
       0.18738131458572463`, 0.9822872507286887, 0}, {
       0.12533323356430426`, 0.9921147013144779, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[36, 5] Degree], Cos[Rational[36, 5] Degree], 0}, {
       Sin[Rational[18, 5] Degree], Cos[Rational[18, 5] Degree], 0}}, {{
       0.12533323356430426`, 0.9921147013144779, 0}, {
       0.06279051952931337, 0.9980267284282716, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[18, 5] Degree], Cos[Rational[18, 5] Degree], 0}, {
       0, 1, 0}}, {{0.06279051952931337, 0.9980267284282716, 0}, {0, 1, 
       0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{0, 1, 
       0}, {-Sin[Rational[18, 5] Degree], Cos[Rational[18, 5] Degree], 0}}, {{
       0, 1, 0}, {-0.06279051952931337, 0.9980267284282716, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[18, 5] Degree], Cos[Rational[18, 5] Degree], 
        0}, {-Sin[Rational[36, 5] Degree], Cos[Rational[36, 5] Degree], 
        0}}, {{-0.06279051952931337, 0.9980267284282716, 
        0}, {-0.12533323356430426`, 0.9921147013144779, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[36, 5] Degree], Cos[Rational[36, 5] Degree], 
        0}, {-Sin[Rational[54, 5] Degree], Cos[Rational[54, 5] Degree], 
        0}}, {{-0.12533323356430426`, 0.9921147013144779, 
        0}, {-0.18738131458572463`, 0.9822872507286887, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[54, 5] Degree], Cos[Rational[54, 5] Degree], 
        0}, {-Sin[Rational[72, 5] Degree], Cos[Rational[72, 5] Degree], 
        0}}, {{-0.18738131458572463`, 0.9822872507286887, 
        0}, {-0.2486898871648548, 0.9685831611286311, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[72, 5] Degree], Cos[Rational[72, 5] Degree], 0}, {
       Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        0}}, {{-0.2486898871648548, 0.9685831611286311, 
        0}, {-0.30901699437494745`, 0.9510565162951535, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {-
        Sin[Rational[108, 5] Degree], Cos[Rational[108, 5] Degree], 
        0}}, {{-0.30901699437494745`, 0.9510565162951535, 
        0}, {-0.368124552684678, 0.9297764858882515, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[108, 5] Degree], Cos[Rational[108, 5] Degree], 
        0}, {-Sin[Rational[126, 5] Degree], Cos[Rational[126, 5] Degree], 
        0}}, {{-0.368124552684678, 0.9297764858882515, 
        0}, {-0.42577929156507266`, 0.9048270524660196, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[126, 5] Degree], Cos[Rational[126, 5] Degree], 
        0}, {-Sin[Rational[144, 5] Degree], Cos[Rational[144, 5] Degree], 
        0}}, {{-0.42577929156507266`, 0.9048270524660196, 
        0}, {-0.4817536741017153, 0.8763066800438636, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[144, 5] Degree], Cos[Rational[144, 5] Degree], 
        0}, {-Sin[Rational[162, 5] Degree], Cos[Rational[162, 5] Degree], 
        0}}, {{-0.4817536741017153, 0.8763066800438636, 
        0}, {-0.5358267949789967, 0.8443279255020151, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[162, 5] Degree], Cos[Rational[162, 5] Degree], 
        0}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
        0}}, {{-0.5358267949789967, 0.8443279255020151, 
        0}, {-0.5877852522924731, 0.8090169943749475, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 0}, {-
        Sin[Rational[198, 5] Degree], Cos[Rational[198, 5] Degree], 
        0}}, {{-0.5877852522924731, 0.8090169943749475, 
        0}, {-0.6374239897486897, 0.7705132427757891, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[198, 5] Degree], Cos[Rational[198, 5] Degree], 
        0}, {-Sin[Rational[216, 5] Degree], Cos[Rational[216, 5] Degree], 
        0}}, {{-0.6374239897486897, 0.7705132427757891, 
        0}, {-0.6845471059286887, 0.7289686274214116, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[216, 5] Degree], Cos[Rational[216, 5] Degree], 
        0}, {-Cos[Rational[216, 5] Degree], Sin[Rational[216, 5] Degree], 
        0}}, {{-0.6845471059286887, 0.7289686274214116, 
        0}, {-0.7289686274214116, 0.6845471059286887, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[216, 5] Degree], Sin[Rational[216, 5] Degree], 
        0}, {-Cos[Rational[198, 5] Degree], Sin[Rational[198, 5] Degree], 
        0}}, {{-0.7289686274214116, 0.6845471059286887, 
        0}, {-0.7705132427757891, 0.6374239897486897, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[198, 5] Degree], Sin[Rational[198, 5] Degree], 
        0}, {Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        0}}, {{-0.7705132427757891, 0.6374239897486897, 
        0}, {-0.8090169943749475, 0.5877852522924731, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {-
        Cos[Rational[162, 5] Degree], Sin[Rational[162, 5] Degree], 
        0}}, {{-0.8090169943749475, 0.5877852522924731, 
        0}, {-0.8443279255020151, 0.5358267949789967, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[162, 5] Degree], Sin[Rational[162, 5] Degree], 
        0}, {-Cos[Rational[144, 5] Degree], Sin[Rational[144, 5] Degree], 
        0}}, {{-0.8443279255020151, 0.5358267949789967, 
        0}, {-0.8763066800438636, 0.4817536741017153, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[144, 5] Degree], Sin[Rational[144, 5] Degree], 
        0}, {-Cos[Rational[126, 5] Degree], Sin[Rational[126, 5] Degree], 
        0}}, {{-0.8763066800438636, 0.4817536741017153, 
        0}, {-0.9048270524660196, 0.42577929156507266`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[126, 5] Degree], Sin[Rational[126, 5] Degree], 
        0}, {-Cos[Rational[108, 5] Degree], Sin[Rational[108, 5] Degree], 
        0}}, {{-0.9048270524660196, 0.42577929156507266`, 
        0}, {-0.9297764858882515, 0.368124552684678, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[108, 5] Degree], Sin[Rational[108, 5] Degree], 
        0}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 
        0}}, {{-0.9297764858882515, 0.368124552684678, 
        0}, {-0.9510565162951535, 0.30901699437494745`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 0}, {-
        Cos[Rational[72, 5] Degree], Sin[Rational[72, 5] Degree], 
        0}}, {{-0.9510565162951535, 0.30901699437494745`, 
        0}, {-0.9685831611286311, 0.2486898871648548, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[72, 5] Degree], Sin[Rational[72, 5] Degree], 
        0}, {-Cos[Rational[54, 5] Degree], Sin[Rational[54, 5] Degree], 
        0}}, {{-0.9685831611286311, 0.2486898871648548, 
        0}, {-0.9822872507286887, 0.18738131458572463`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[54, 5] Degree], Sin[Rational[54, 5] Degree], 
        0}, {-Cos[Rational[36, 5] Degree], Sin[Rational[36, 5] Degree], 
        0}}, {{-0.9822872507286887, 0.18738131458572463`, 
        0}, {-0.9921147013144779, 0.12533323356430426`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[36, 5] Degree], Sin[Rational[36, 5] Degree], 
        0}, {-Cos[Rational[18, 5] Degree], Sin[Rational[18, 5] Degree], 
        0}}, {{-0.9921147013144779, 0.12533323356430426`, 
        0}, {-0.9980267284282716, 0.06279051952931337, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[18, 5] Degree], Sin[Rational[18, 5] Degree], 
        0}, {-1, 0, 0}}, {{-0.9980267284282716, 0.06279051952931337, 0}, {-1, 
       0, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-1, 0, 
       0}, {-Cos[Rational[18, 5] Degree], -Sin[Rational[18, 5] Degree], 
        0}}, {{-1, 0, 0}, {-0.9980267284282716, -0.06279051952931337, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[18, 5] Degree], -Sin[Rational[18, 5] Degree], 
        0}, {-Cos[Rational[36, 5] Degree], -Sin[Rational[36, 5] Degree], 
        0}}, {{-0.9980267284282716, -0.06279051952931337, 
        0}, {-0.9921147013144779, -0.12533323356430426`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[36, 5] Degree], -Sin[Rational[36, 5] Degree], 
        0}, {-Cos[Rational[54, 5] Degree], -Sin[Rational[54, 5] Degree], 
        0}}, {{-0.9921147013144779, -0.12533323356430426`, 
        0}, {-0.9822872507286887, -0.18738131458572463`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[54, 5] Degree], -Sin[Rational[54, 5] Degree], 
        0}, {-Cos[Rational[72, 5] Degree], -Sin[Rational[72, 5] Degree], 
        0}}, {{-0.9822872507286887, -0.18738131458572463`, 
        0}, {-0.9685831611286311, -0.2486898871648548, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[72, 5] Degree], -Sin[Rational[72, 5] Degree], 
        0}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), 
        0}}, {{-0.9685831611286311, -0.2486898871648548, 
        0}, {-0.9510565162951535, -0.30901699437494745`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), 0}, {-
        Cos[Rational[108, 5] Degree], -Sin[Rational[108, 5] Degree], 
        0}}, {{-0.9510565162951535, -0.30901699437494745`, 
        0}, {-0.9297764858882515, -0.368124552684678, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[108, 5] Degree], -Sin[Rational[108, 5] Degree], 
        0}, {-Cos[Rational[126, 5] Degree], -Sin[Rational[126, 5] Degree], 
        0}}, {{-0.9297764858882515, -0.368124552684678, 
        0}, {-0.9048270524660196, -0.42577929156507266`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[126, 5] Degree], -Sin[Rational[126, 5] Degree], 
        0}, {-Cos[Rational[144, 5] Degree], -Sin[Rational[144, 5] Degree], 
        0}}, {{-0.9048270524660196, -0.42577929156507266`, 
        0}, {-0.8763066800438636, -0.4817536741017153, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[144, 5] Degree], -Sin[Rational[144, 5] Degree], 
        0}, {-Cos[Rational[162, 5] Degree], -Sin[Rational[162, 5] Degree], 
        0}}, {{-0.8763066800438636, -0.4817536741017153, 
        0}, {-0.8443279255020151, -0.5358267949789967, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[162, 5] Degree], -Sin[Rational[162, 5] Degree], 
        0}, {Rational[1, 4] (-1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        0}}, {{-0.8443279255020151, -0.5358267949789967, 
        0}, {-0.8090169943749475, -0.5877852522924731, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Rational[1, 4] (-1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {-
        Cos[Rational[198, 5] Degree], -Sin[Rational[198, 5] Degree], 
        0}}, {{-0.8090169943749475, -0.5877852522924731, 
        0}, {-0.7705132427757891, -0.6374239897486897, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[198, 5] Degree], -Sin[Rational[198, 5] Degree], 
        0}, {-Cos[Rational[216, 5] Degree], -Sin[Rational[216, 5] Degree], 
        0}}, {{-0.7705132427757891, -0.6374239897486897, 
        0}, {-0.7289686274214116, -0.6845471059286887, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[216, 5] Degree], -Sin[Rational[216, 5] Degree], 
        0}, {-Sin[Rational[216, 5] Degree], -Cos[Rational[216, 5] Degree], 
        0}}, {{-0.7289686274214116, -0.6845471059286887, 
        0}, {-0.6845471059286887, -0.7289686274214116, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[216, 5] Degree], -Cos[Rational[216, 5] Degree], 
        0}, {-Sin[Rational[198, 5] Degree], -Cos[Rational[198, 5] Degree], 
        0}}, {{-0.6845471059286887, -0.7289686274214116, 
        0}, {-0.6374239897486897, -0.7705132427757891, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[198, 5] Degree], -Cos[Rational[198, 5] Degree], 
        0}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
        0}}, {{-0.6374239897486897, -0.7705132427757891, 
        0}, {-0.5877852522924731, -0.8090169943749475, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 0}, {-
        Sin[Rational[162, 5] Degree], -Cos[Rational[162, 5] Degree], 
        0}}, {{-0.5877852522924731, -0.8090169943749475, 
        0}, {-0.5358267949789967, -0.8443279255020151, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[162, 5] Degree], -Cos[Rational[162, 5] Degree], 
        0}, {-Sin[Rational[144, 5] Degree], -Cos[Rational[144, 5] Degree], 
        0}}, {{-0.5358267949789967, -0.8443279255020151, 
        0}, {-0.4817536741017153, -0.8763066800438636, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[144, 5] Degree], -Cos[Rational[144, 5] Degree], 
        0}, {-Sin[Rational[126, 5] Degree], -Cos[Rational[126, 5] Degree], 
        0}}, {{-0.4817536741017153, -0.8763066800438636, 
        0}, {-0.42577929156507266`, -0.9048270524660196, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[126, 5] Degree], -Cos[Rational[126, 5] Degree], 
        0}, {-Sin[Rational[108, 5] Degree], -Cos[Rational[108, 5] Degree], 
        0}}, {{-0.42577929156507266`, -0.9048270524660196, 
        0}, {-0.368124552684678, -0.9297764858882515, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[108, 5] Degree], -Cos[Rational[108, 5] Degree], 
        0}, {Rational[1, 4] (1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], 0}}, {{-0.368124552684678, -0.9297764858882515, 
        0}, {-0.30901699437494745`, -0.9510565162951535, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Rational[1, 4] (1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], 0}, {-Sin[Rational[72, 5] Degree], -
        Cos[Rational[72, 5] Degree], 
        0}}, {{-0.30901699437494745`, -0.9510565162951535, 
        0}, {-0.2486898871648548, -0.9685831611286311, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[72, 5] Degree], -Cos[Rational[72, 5] Degree], 
        0}, {-Sin[Rational[54, 5] Degree], -Cos[Rational[54, 5] Degree], 
        0}}, {{-0.2486898871648548, -0.9685831611286311, 
        0}, {-0.18738131458572463`, -0.9822872507286887, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[54, 5] Degree], -Cos[Rational[54, 5] Degree], 
        0}, {-Sin[Rational[36, 5] Degree], -Cos[Rational[36, 5] Degree], 
        0}}, {{-0.18738131458572463`, -0.9822872507286887, 
        0}, {-0.12533323356430426`, -0.9921147013144779, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[36, 5] Degree], -Cos[Rational[36, 5] Degree], 
        0}, {-Sin[Rational[18, 5] Degree], -Cos[Rational[18, 5] Degree], 
        0}}, {{-0.12533323356430426`, -0.9921147013144779, 
        0}, {-0.06279051952931337, -0.9980267284282716, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[18, 5] Degree], -Cos[Rational[18, 5] Degree], 
        0}, {0, -1, 0}}, {{-0.06279051952931337, -0.9980267284282716, 0}, {
       0, -1, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{0, -1, 0}, {
       Sin[Rational[18, 5] Degree], -Cos[Rational[18, 5] Degree], 0}}, {{
       0, -1, 0}, {0.06279051952931337, -0.9980267284282716, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[18, 5] Degree], -Cos[Rational[18, 5] Degree], 0}, {
       Sin[Rational[36, 5] Degree], -Cos[Rational[36, 5] Degree], 0}}, {{
       0.06279051952931337, -0.9980267284282716, 0}, {
       0.12533323356430426`, -0.9921147013144779, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[36, 5] Degree], -Cos[Rational[36, 5] Degree], 0}, {
       Sin[Rational[54, 5] Degree], -Cos[Rational[54, 5] Degree], 0}}, {{
       0.12533323356430426`, -0.9921147013144779, 0}, {
       0.18738131458572463`, -0.9822872507286887, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[54, 5] Degree], -Cos[Rational[54, 5] Degree], 0}, {
       Sin[Rational[72, 5] Degree], -Cos[Rational[72, 5] Degree], 0}}, {{
       0.18738131458572463`, -0.9822872507286887, 0}, {
       0.2486898871648548, -0.9685831611286311, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[72, 5] Degree], -Cos[Rational[72, 5] Degree], 0}, {
       Rational[1, 4] (-1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}}, {{
       0.2486898871648548, -0.9685831611286311, 0}, {
       0.30901699437494745`, -0.9510565162951535, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Rational[1, 4] (-1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {
       Sin[Rational[108, 5] Degree], -Cos[Rational[108, 5] Degree], 0}}, {{
       0.30901699437494745`, -0.9510565162951535, 0}, {
       0.368124552684678, -0.9297764858882515, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[108, 5] Degree], -Cos[Rational[108, 5] Degree], 
        0}, {Sin[Rational[126, 5] Degree], -Cos[Rational[126, 5] Degree], 
        0}}, {{0.368124552684678, -0.9297764858882515, 0}, {
       0.42577929156507266`, -0.9048270524660196, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[126, 5] Degree], -Cos[Rational[126, 5] Degree], 
        0}, {Sin[Rational[144, 5] Degree], -Cos[Rational[144, 5] Degree], 
        0}}, {{0.42577929156507266`, -0.9048270524660196, 0}, {
       0.4817536741017153, -0.8763066800438636, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[144, 5] Degree], -Cos[Rational[144, 5] Degree], 
        0}, {Sin[Rational[162, 5] Degree], -Cos[Rational[162, 5] Degree], 
        0}}, {{0.4817536741017153, -0.8763066800438636, 0}, {
       0.5358267949789967, -0.8443279255020151, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[162, 5] Degree], -Cos[Rational[162, 5] Degree], 
        0}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 0}}, {{
       0.5358267949789967, -0.8443279255020151, 0}, {
       0.5877852522924731, -0.8090169943749475, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 0}, {
       Sin[Rational[198, 5] Degree], -Cos[Rational[198, 5] Degree], 0}}, {{
       0.5877852522924731, -0.8090169943749475, 0}, {
       0.6374239897486897, -0.7705132427757891, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[198, 5] Degree], -Cos[Rational[198, 5] Degree], 
        0}, {Sin[Rational[216, 5] Degree], -Cos[Rational[216, 5] Degree], 
        0}}, {{0.6374239897486897, -0.7705132427757891, 0}, {
       0.6845471059286887, -0.7289686274214116, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[216, 5] Degree], -Cos[Rational[216, 5] Degree], 
        0}, {Cos[Rational[216, 5] Degree], -Sin[Rational[216, 5] Degree], 
        0}}, {{0.6845471059286887, -0.7289686274214116, 0}, {
       0.7289686274214116, -0.6845471059286887, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[216, 5] Degree], -Sin[Rational[216, 5] Degree], 
        0}, {Cos[Rational[198, 5] Degree], -Sin[Rational[198, 5] Degree], 
        0}}, {{0.7289686274214116, -0.6845471059286887, 0}, {
       0.7705132427757891, -0.6374239897486897, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[198, 5] Degree], -Sin[Rational[198, 5] Degree], 
        0}, {Rational[1, 4] (1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}}, {{
       0.7705132427757891, -0.6374239897486897, 0}, {
       0.8090169943749475, -0.5877852522924731, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Rational[1, 4] (1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {
       Cos[Rational[162, 5] Degree], -Sin[Rational[162, 5] Degree], 0}}, {{
       0.8090169943749475, -0.5877852522924731, 0}, {
       0.8443279255020151, -0.5358267949789967, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[162, 5] Degree], -Sin[Rational[162, 5] Degree], 
        0}, {Cos[Rational[144, 5] Degree], -Sin[Rational[144, 5] Degree], 
        0}}, {{0.8443279255020151, -0.5358267949789967, 0}, {
       0.8763066800438636, -0.4817536741017153, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[144, 5] Degree], -Sin[Rational[144, 5] Degree], 
        0}, {Cos[Rational[126, 5] Degree], -Sin[Rational[126, 5] Degree], 
        0}}, {{0.8763066800438636, -0.4817536741017153, 0}, {
       0.9048270524660196, -0.42577929156507266`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[126, 5] Degree], -Sin[Rational[126, 5] Degree], 
        0}, {Cos[Rational[108, 5] Degree], -Sin[Rational[108, 5] Degree], 
        0}}, {{0.9048270524660196, -0.42577929156507266`, 0}, {
       0.9297764858882515, -0.368124552684678, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[108, 5] Degree], -Sin[Rational[108, 5] Degree], 
        0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), 0}}, {{
       0.9297764858882515, -0.368124552684678, 0}, {
       0.9510565162951535, -0.30901699437494745`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), 0}, {
       Cos[Rational[72, 5] Degree], -Sin[Rational[72, 5] Degree], 0}}, {{
       0.9510565162951535, -0.30901699437494745`, 0}, {
       0.9685831611286311, -0.2486898871648548, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[72, 5] Degree], -Sin[Rational[72, 5] Degree], 0}, {
       Cos[Rational[54, 5] Degree], -Sin[Rational[54, 5] Degree], 0}}, {{
       0.9685831611286311, -0.2486898871648548, 0}, {
       0.9822872507286887, -0.18738131458572463`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[54, 5] Degree], -Sin[Rational[54, 5] Degree], 0}, {
       Cos[Rational[36, 5] Degree], -Sin[Rational[36, 5] Degree], 0}}, {{
       0.9822872507286887, -0.18738131458572463`, 0}, {
       0.9921147013144779, -0.12533323356430426`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[36, 5] Degree], -Sin[Rational[36, 5] Degree], 0}, {
       Cos[Rational[18, 5] Degree], -Sin[Rational[18, 5] Degree], 0}}, {{
       0.9921147013144779, -0.12533323356430426`, 0}, {
       0.9980267284282716, -0.06279051952931337, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[18, 5] Degree], -Sin[Rational[18, 5] Degree], 0}, {
       1, 0, 0}}, {{0.9980267284282716, -0.06279051952931337, 0}, {1, 0, 
       0}}]]}, 
   {RGBColor[1, 1, 0], EdgeForm[Thickness[Tiny]], 
    Polygon3DBox[{{-1, 1, 2.25}, {1, 1, 2.25}, {
      1, -1, 2.25}, {-1, -1, 2.25}}]}, 
   {RGBColor[0.88, 1, 0.88], EdgeForm[Thickness[Tiny]], 
    Polygon3DBox[{{-1, 1, 1}, {1, 1, 1}, {1, -1, 1}, {-1, -1, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0, 0, 0}, {1.590990257669732, 1.590990257669732, 0}}], 
    Line3DBox[{{0, 0, 0}, {-0.17677669529663687`, 0.17677669529663687`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.25, 1., 0}, {1.310323930064653, 1.0765148778399132`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.310323930064653, 1.0765148778399132`, 0}, {
      1.3654766102074016`, 1.148781243269858, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.3654766102074016`, 1.148781243269858, 0}, {
      1.4152403779965854`, 1.2165138939608444`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.4152403779965854`, 1.2165138939608444`, 0}, {
      1.4594188385756437`, 1.2794455200846997`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.4594188385756437`, 1.2794455200846997`, 0}, {
      1.4978376397438893`, 1.3373277592638377`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.4978376397438893`, 1.3373277592638377`, 0}, {
      1.5303451600449922`, 1.3899321767440989`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.5303451600449922`, 1.3899321767440989`, 0}, {
      1.5568131071475972`, 1.4370511669223605`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.5568131071475972`, 1.4370511669223605`, 0}, {
      1.5771370241565448`, 1.4784987726710077`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.5771370241565448`, 1.4784987726710077`, 0}, {
      1.5912367018565154`, 1.514111419225761, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.5912367018565154`, 1.514111419225761, 0}, {
      1.5990564952611575`, 1.543748559740539, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.5990564952611575`, 1.543748559740539, 0}, {
      1.6005655432184263`, 1.5672932299616513`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.6005655432184263`, 1.5672932299616513`, 0}, {
      1.5957578902054532`, 1.5846525098322726`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.5957578902054532`, 1.5846525098322726`, 0}, {
      1.5846525098322726`, 1.5957578902054532`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.5846525098322726`, 1.5957578902054532`, 0}, {
      1.5672932299616513`, 1.6005655432184263`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.5672932299616513`, 1.6005655432184263`, 0}, {
      1.543748559740539, 1.5990564952611575`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.543748559740539, 1.5990564952611575`, 0}, {
      1.514111419225761, 1.5912367018565154`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.514111419225761, 1.5912367018565154`, 0}, {
      1.4784987726710077`, 1.5771370241565448`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.4784987726710077`, 1.5771370241565448`, 0}, {
      1.4370511669223605`, 1.5568131071475972`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.4370511669223605`, 1.5568131071475972`, 0}, {
      1.3899321767440989`, 1.5303451600449922`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.3899321767440989`, 1.5303451600449922`, 0}, {
      1.3373277592638377`, 1.4978376397438893`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.3373277592638377`, 1.4978376397438893`, 0}, {
      1.2794455200846997`, 1.4594188385756437`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.2794455200846997`, 1.4594188385756437`, 0}, {
      1.2165138939608444`, 1.4152403779965854`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.2165138939608444`, 1.4152403779965854`, 0}, {
      1.148781243269858, 1.3654766102074016`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.148781243269858, 1.3654766102074016`, 0}, {
      1.0765148778399132`, 1.310323930064653, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.0765148778399132`, 1.310323930064653, 0}, {1., 1.25, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1., 1.25, 0}, {0.9195385790166298, 1.184742891006026, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.9195385790166298, 1.184742891006026, 0}, {
      0.8354481593590976, 1.1148101430787931`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.8354481593590976, 1.1148101430787931`, 0}, {
      0.7480606074965329, 1.0404777488251362`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.7480606074965329, 1.0404777488251362`, 0}, {
      0.6577208021725626, 0.962039064245934, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.6577208021725626, 0.962039064245934, 0}, {
      0.5647852733264692, 0.8798036509939944, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.5647852733264692, 0.8798036509939944, 0}, {
      0.469620795032404, 0.7940960546756364, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.469620795032404, 0.7940960546756364, 0}, {
      0.3726029380096787, 0.7052545240174519, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.3726029380096787, 0.7052545240174519, 0}, {
      0.27411458741671946`, 0.6136296759531142, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.27411458741671946`, 0.6136296759531142, 0}, {
      0.17454443177826928`, 0.5195831118985222, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.17454443177826928`, 0.5195831118985222, 0}, {
      0.07428542900935597, 0.4234859906762112, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{
      0.07428542900935597, 0.4234859906762112, 0}, {-0.02626674441007304, 
       0.32571756372104665`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.02626674441007304, 0.32571756372104665`, 
       0}, {-0.12671525498944936`, 0.22666367834807577`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.12671525498944936`, 0.22666367834807577`, 
       0}, {-0.22666367834807577`, 0.12671525498944936`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.22666367834807577`, 0.12671525498944936`, 
       0}, {-0.32571756372104665`, 0.02626674441007304, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.32571756372104665`, 0.02626674441007304, 
       0}, {-0.4234859906762112, -0.07428542900935597, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.4234859906762112, -0.07428542900935597, 
       0}, {-0.5195831118985222, -0.17454443177826928`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.5195831118985222, -0.17454443177826928`, 
       0}, {-0.6136296759531142, -0.27411458741671946`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.6136296759531142, -0.27411458741671946`, 
       0}, {-0.7052545240174519, -0.3726029380096787, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.7052545240174519, -0.3726029380096787, 
       0}, {-0.7940960546756364, -0.469620795032404, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.7940960546756364, -0.469620795032404, 
       0}, {-0.8798036509939944, -0.5647852733264692, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.8798036509939944, -0.5647852733264692, 
       0}, {-0.962039064245934, -0.6577208021725626, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.962039064245934, -0.6577208021725626, 
       0}, {-1.0404777488251362`, -0.7480606074965329, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.0404777488251362`, -0.7480606074965329, 
       0}, {-1.1148101430787931`, -0.8354481593590976, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.1148101430787931`, -0.8354481593590976, 
       0}, {-1.184742891006026, -0.9195385790166298, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.184742891006026, -0.9195385790166298, 0}, {-1.25, -1., 
       0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.25, -1., 0}, {-1.310323930064653, -1.0765148778399132`, 
       0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.310323930064653, -1.0765148778399132`, 
       0}, {-1.3654766102074016`, -1.148781243269858, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.3654766102074016`, -1.148781243269858, 
       0}, {-1.4152403779965854`, -1.2165138939608444`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.4152403779965854`, -1.2165138939608444`, 
       0}, {-1.4594188385756437`, -1.2794455200846997`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.4594188385756437`, -1.2794455200846997`, 
       0}, {-1.4978376397438893`, -1.3373277592638377`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.4978376397438893`, -1.3373277592638377`, 
       0}, {-1.5303451600449922`, -1.3899321767440989`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.5303451600449922`, -1.3899321767440989`, 
       0}, {-1.5568131071475972`, -1.4370511669223605`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.5568131071475972`, -1.4370511669223605`, 
       0}, {-1.5771370241565448`, -1.4784987726710077`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.5771370241565448`, -1.4784987726710077`, 
       0}, {-1.5912367018565154`, -1.514111419225761, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.5912367018565154`, -1.514111419225761, 
       0}, {-1.5990564952611575`, -1.543748559740539, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.5990564952611575`, -1.543748559740539, 
       0}, {-1.6005655432184263`, -1.5672932299616513`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.6005655432184263`, -1.5672932299616513`, 
       0}, {-1.5957578902054532`, -1.5846525098322726`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.5957578902054532`, -1.5846525098322726`, 
       0}, {-1.5846525098322726`, -1.5957578902054532`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.5846525098322726`, -1.5957578902054532`, 
       0}, {-1.5672932299616513`, -1.6005655432184263`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.5672932299616513`, -1.6005655432184263`, 
       0}, {-1.543748559740539, -1.5990564952611575`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.543748559740539, -1.5990564952611575`, 
       0}, {-1.514111419225761, -1.5912367018565154`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.514111419225761, -1.5912367018565154`, 
       0}, {-1.4784987726710077`, -1.5771370241565448`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.4784987726710077`, -1.5771370241565448`, 
       0}, {-1.4370511669223605`, -1.5568131071475972`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.4370511669223605`, -1.5568131071475972`, 
       0}, {-1.3899321767440989`, -1.5303451600449922`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.3899321767440989`, -1.5303451600449922`, 
       0}, {-1.3373277592638377`, -1.4978376397438893`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.3373277592638377`, -1.4978376397438893`, 
       0}, {-1.2794455200846997`, -1.4594188385756437`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.2794455200846997`, -1.4594188385756437`, 
       0}, {-1.2165138939608444`, -1.4152403779965854`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.2165138939608444`, -1.4152403779965854`, 
       0}, {-1.148781243269858, -1.3654766102074016`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.148781243269858, -1.3654766102074016`, 
       0}, {-1.0765148778399132`, -1.310323930064653, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.0765148778399132`, -1.310323930064653, 0}, {-1., -1.25, 
       0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1., -1.25, 0}, {-0.9195385790166298, -1.184742891006026, 
       0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.9195385790166298, -1.184742891006026, 
       0}, {-0.8354481593590976, -1.1148101430787931`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.8354481593590976, -1.1148101430787931`, 
       0}, {-0.7480606074965329, -1.0404777488251362`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.7480606074965329, -1.0404777488251362`, 
       0}, {-0.6577208021725626, -0.962039064245934, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.6577208021725626, -0.962039064245934, 
       0}, {-0.5647852733264692, -0.8798036509939944, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.5647852733264692, -0.8798036509939944, 
       0}, {-0.469620795032404, -0.7940960546756364, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.469620795032404, -0.7940960546756364, 
       0}, {-0.3726029380096787, -0.7052545240174519, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.3726029380096787, -0.7052545240174519, 
       0}, {-0.27411458741671946`, -0.6136296759531142, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.27411458741671946`, -0.6136296759531142, 
       0}, {-0.17454443177826928`, -0.5195831118985222, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.17454443177826928`, -0.5195831118985222, 
       0}, {-0.07428542900935597, -0.4234859906762112, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.07428542900935597, -0.4234859906762112, 0}, {
      0.02626674441007304, -0.32571756372104665`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.02626674441007304, -0.32571756372104665`, 0}, {
      0.12671525498944936`, -0.22666367834807577`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.12671525498944936`, -0.22666367834807577`, 0}, {
      0.22666367834807577`, -0.12671525498944936`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.22666367834807577`, -0.12671525498944936`, 0}, {
      0.32571756372104665`, -0.02626674441007304, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.32571756372104665`, -0.02626674441007304, 0}, {
      0.4234859906762112, 0.07428542900935597, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.4234859906762112, 0.07428542900935597, 0}, {
      0.5195831118985222, 0.17454443177826928`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.5195831118985222, 0.17454443177826928`, 0}, {
      0.6136296759531142, 0.27411458741671946`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.6136296759531142, 0.27411458741671946`, 0}, {
      0.7052545240174519, 0.3726029380096787, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.7052545240174519, 0.3726029380096787, 0}, {
      0.7940960546756364, 0.469620795032404, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.7940960546756364, 0.469620795032404, 0}, {
      0.8798036509939944, 0.5647852733264692, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.8798036509939944, 0.5647852733264692, 0}, {
      0.962039064245934, 0.6577208021725626, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.962039064245934, 0.6577208021725626, 0}, {
      1.0404777488251362`, 0.7480606074965329, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.0404777488251362`, 0.7480606074965329, 0}, {
      1.1148101430787931`, 0.8354481593590976, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.1148101430787931`, 0.8354481593590976, 0}, {
      1.184742891006026, 0.9195385790166298, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.184742891006026, 0.9195385790166298, 0}, {1.25, 1., 0}}]}},
  AutomaticImageSize->True,
  Axes->False,
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 14},
  BoxRatios->Automatic,
  Boxed->False,
  ImageSize->{359.9894857120552, 321.9769701497035},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->All,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  ViewPoint->{0.7837035318095736, -4.102536195783925, 1.5984384681657127`},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{
  3.5630465521797495`*^9, 3.5630466125362554`*^9, 3.563046731314864*^9, 
   3.5630468822919292`*^9, 3.563047261540596*^9, 3.5630473490411496`*^9, 
   3.5630474031108446`*^9, 3.5630478516584325`*^9, {3.5630480368307576`*^9, 
   3.5630480603555984`*^9}, 3.563048104768877*^9, 3.56304836298213*^9, 
   3.563048404759004*^9, 3.563048588905327*^9, 3.5630486704402695`*^9, 
   3.5630487533232155`*^9, {3.5630499329276896`*^9, 3.5630499472173147`*^9}, 
   3.5630499857493825`*^9, 3.563050042098282*^9, 3.563050077316743*^9, 
   3.563106573353532*^9, 3.563107642713743*^9, 3.5631076837506137`*^9, 
   3.5631110720424833`*^9, 3.5631115401692877`*^9, 3.563111598918988*^9, 
   3.5631116391906567`*^9, 3.5631118214397707`*^9, 3.5631119494375887`*^9, 
   3.563112784091428*^9, {3.5631129839077697`*^9, 3.563113002315802*^9}, 
   3.563113062778303*^9, 3.5631136944218063`*^9, 3.5631277472706676`*^9, 
   3.563128122207726*^9, 3.5631281534077806`*^9, 3.5631282389895315`*^9, 
   3.563128421320475*^9, 3.563128451958929*^9, 3.563128794043862*^9, 
   3.563128826460719*^9, 3.5631289434921246`*^9, 3.5631293701060734`*^9, {
   3.563129454611422*^9, 3.5631294743922567`*^9}, 3.563129698767451*^9, 
   3.5631297799343934`*^9, 3.563129873004157*^9, 3.563129954867101*^9, {
   3.563130053197674*^9, 3.5631300680800996`*^9}, 3.5631304712000103`*^9, 
   3.5631307469304943`*^9, 3.5631307769449472`*^9, 3.5633730064431467`*^9, 
   3.5633731022532806`*^9, 3.5633731485833454`*^9, 3.563373218813444*^9, 
   3.563553505166424*^9, 3.564783556134794*^9, 3.564843301189065*^9, 
   3.5648434945358047`*^9, 3.5648435340038743`*^9, {3.56484363988126*^9, 
   3.56484366821091*^9}, 3.5648439565462165`*^9, 3.5648440390079613`*^9, 
   3.564850817812276*^9, 3.564850864347158*^9, 3.56485091674765*^9, 
   3.564851551715565*^9, 3.564852507934845*^9, 3.5648526025022106`*^9, 
   3.5648526547623024`*^9, 3.567106143076501*^9, 3.5844775220709867`*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Quadratic Form x^T M x over the unit circle\"\>"], "Print",
 CellChangeTimes->{
  3.5629550986360693`*^9, 3.5629552384747143`*^9, 3.562955397017793*^9, {
   3.5629554461890793`*^9, 3.562955473286327*^9}, 3.562955546996456*^9, 
   3.5629555878685284`*^9, 3.562955627133797*^9, {3.5629556758214827`*^9, 
   3.5629556912499104`*^9}, 3.562955749516012*^9, 3.5629558033673067`*^9, 
   3.562955842694976*^9, 3.562963384191823*^9, 3.562963419042284*^9, 
   3.5630191524226074`*^9, 3.5630192141363153`*^9, {3.5630192856000414`*^9, 
   3.563019310185684*^9}, {3.5630193541153617`*^9, 3.5630193621181755`*^9}, 
   3.563019561034125*^9, {3.563020346167904*^9, 3.563020394621589*^9}, 
   3.563020527315422*^9, 3.5630205861275253`*^9, 3.563020631508005*^9, {
   3.5630206764048843`*^9, 3.563020718712158*^9}, 3.563020757727827*^9, {
   3.56302081655553*^9, 3.5630208254007454`*^9}, 3.5630209318085327`*^9, {
   3.5630218360797205`*^9, 3.563021863426569*^9}, {3.5630219037370396`*^9, 
   3.563021918635066*^9}, {3.5630219850131826`*^9, 3.5630220960697775`*^9}, 
   3.56302247810887*^9, 3.5630225147597356`*^9, {3.5630227914389234`*^9, 
   3.5630228139497633`*^9}, {3.563022860718645*^9, 3.563022961978423*^9}, 
   3.5630244252141933`*^9, {3.56302450898634*^9, 3.563024538470392*^9}, 
   3.563024573898054*^9, {3.5630246048485084`*^9, 3.5630246393713694`*^9}, {
   3.563024669666622*^9, 3.5630246931290636`*^9}, 3.5630247649359894`*^9, 
   3.5630250207452393`*^9, 3.563025263450465*^9, 3.563027130305744*^9, 
   3.563027228117916*^9, {3.5630274502935066`*^9, 3.5630274739899483`*^9}, {
   3.5630277148231707`*^9, 3.5630277394712143`*^9}, {3.5630294341021905`*^9, 
   3.5630294574242315`*^9}, 3.563029489903489*^9, 3.5630295392931757`*^9, 
   3.5630296129097047`*^9, 3.5630297851964073`*^9, {3.5630298821349773`*^9, 
   3.5630298996070085`*^9}, 3.563044604979759*^9, 3.5630450931871867`*^9, 
   3.563045157209699*^9, 3.5630452052109833`*^9, 3.563045235787037*^9, 
   3.563045378652088*^9, {3.5630454110377455`*^9, 3.5630454334393845`*^9}, 
   3.5630456828994226`*^9, 3.563045781709996*^9, 3.5630458374644938`*^9, 
   3.5630458690857496`*^9, 3.5630462941864967`*^9, 3.56304645572478*^9, 
   3.5630465521329494`*^9, 3.5630466124582553`*^9, 3.5630467308312635`*^9, 
   3.563046882213929*^9, 3.5630472614469957`*^9, 3.563047348963149*^9, 
   3.5630474030328445`*^9, 3.563047851564832*^9, {3.5630480367371573`*^9, 
   3.563048060277599*^9}, 3.563048104690877*^9, 3.5630483629041305`*^9, 
   3.5630484046654034`*^9, 3.563048588827327*^9, 3.5630486703622694`*^9, 
   3.563048753229615*^9, {3.5630499328496895`*^9, 3.5630499471237144`*^9}, 
   3.5630499856557827`*^9, 3.563050042004681*^9, 3.563050077238743*^9, 
   3.5631065732665267`*^9, 3.563107642632543*^9, 3.5631076836570134`*^9, 
   3.5631110719644833`*^9, 3.5631115400192876`*^9, 3.563111598825388*^9, 
   3.5631116390814567`*^9, 3.56311182131497*^9, 3.563111949317589*^9, 
   3.563112783982228*^9, {3.5631129837985697`*^9, 3.5631130017854013`*^9}, 
   3.5631130626691027`*^9, 3.5631136942970057`*^9, 3.5631277471770678`*^9, 
   3.5631281219113255`*^9, 3.563128153298581*^9, 3.5631282388959312`*^9, 
   3.5631284212424755`*^9, 3.5631284518497286`*^9, 3.563128793934662*^9, 
   3.563128826367119*^9, 3.563128943382924*^9, 3.563129369794073*^9, {
   3.563129454533422*^9, 3.5631294742986565`*^9}, 3.5631296986894507`*^9, 
   3.5631297798251934`*^9, 3.563129872910557*^9, 3.563129954773501*^9, {
   3.563130047488064*^9, 3.563130067580899*^9}, 3.56313047110641*^9, 
   3.5631307464312935`*^9, 3.563130776866947*^9, 3.5633730059831457`*^9, 
   3.5633731021632805`*^9, 3.5633731485033455`*^9, 3.5633732187334433`*^9, 
   3.563553505104024*^9, 3.5647835560879936`*^9, 3.5648433002062635`*^9, 
   3.5648434942862043`*^9, 3.564843533863474*^9, {3.5648436392572594`*^9, 
   3.5648436681173096`*^9}, 3.564843956452616*^9, 3.564844038914361*^9, 
   3.564850817734276*^9, 3.5648508642847576`*^9, 3.56485091665405*^9, 
   3.5648515516219654`*^9, 3.5648525078256445`*^9, 3.5648526023930106`*^9, 
   3.564852654668702*^9, 3.567106143036501*^9, 3.5844775220709867`*^9}],

Cell[BoxData["\<\"  Green plane is qform = lambda2 -- evec r2 then r2^T M r2 \
= lambda2. \"\>"], "Print",
 CellChangeTimes->{
  3.5629550986360693`*^9, 3.5629552384747143`*^9, 3.562955397017793*^9, {
   3.5629554461890793`*^9, 3.562955473286327*^9}, 3.562955546996456*^9, 
   3.5629555878685284`*^9, 3.562955627133797*^9, {3.5629556758214827`*^9, 
   3.5629556912499104`*^9}, 3.562955749516012*^9, 3.5629558033673067`*^9, 
   3.562955842694976*^9, 3.562963384191823*^9, 3.562963419042284*^9, 
   3.5630191524226074`*^9, 3.5630192141363153`*^9, {3.5630192856000414`*^9, 
   3.563019310185684*^9}, {3.5630193541153617`*^9, 3.5630193621181755`*^9}, 
   3.563019561034125*^9, {3.563020346167904*^9, 3.563020394621589*^9}, 
   3.563020527315422*^9, 3.5630205861275253`*^9, 3.563020631508005*^9, {
   3.5630206764048843`*^9, 3.563020718712158*^9}, 3.563020757727827*^9, {
   3.56302081655553*^9, 3.5630208254007454`*^9}, 3.5630209318085327`*^9, {
   3.5630218360797205`*^9, 3.563021863426569*^9}, {3.5630219037370396`*^9, 
   3.563021918635066*^9}, {3.5630219850131826`*^9, 3.5630220960697775`*^9}, 
   3.56302247810887*^9, 3.5630225147597356`*^9, {3.5630227914389234`*^9, 
   3.5630228139497633`*^9}, {3.563022860718645*^9, 3.563022961978423*^9}, 
   3.5630244252141933`*^9, {3.56302450898634*^9, 3.563024538470392*^9}, 
   3.563024573898054*^9, {3.5630246048485084`*^9, 3.5630246393713694`*^9}, {
   3.563024669666622*^9, 3.5630246931290636`*^9}, 3.5630247649359894`*^9, 
   3.5630250207452393`*^9, 3.563025263450465*^9, 3.563027130305744*^9, 
   3.563027228117916*^9, {3.5630274502935066`*^9, 3.5630274739899483`*^9}, {
   3.5630277148231707`*^9, 3.5630277394712143`*^9}, {3.5630294341021905`*^9, 
   3.5630294574242315`*^9}, 3.563029489903489*^9, 3.5630295392931757`*^9, 
   3.5630296129097047`*^9, 3.5630297851964073`*^9, {3.5630298821349773`*^9, 
   3.5630298996070085`*^9}, 3.563044604979759*^9, 3.5630450931871867`*^9, 
   3.563045157209699*^9, 3.5630452052109833`*^9, 3.563045235787037*^9, 
   3.563045378652088*^9, {3.5630454110377455`*^9, 3.5630454334393845`*^9}, 
   3.5630456828994226`*^9, 3.563045781709996*^9, 3.5630458374644938`*^9, 
   3.5630458690857496`*^9, 3.5630462941864967`*^9, 3.56304645572478*^9, 
   3.5630465521329494`*^9, 3.5630466124582553`*^9, 3.5630467308312635`*^9, 
   3.563046882213929*^9, 3.5630472614469957`*^9, 3.563047348963149*^9, 
   3.5630474030328445`*^9, 3.563047851564832*^9, {3.5630480367371573`*^9, 
   3.563048060277599*^9}, 3.563048104690877*^9, 3.5630483629041305`*^9, 
   3.5630484046654034`*^9, 3.563048588827327*^9, 3.5630486703622694`*^9, 
   3.563048753229615*^9, {3.5630499328496895`*^9, 3.5630499471237144`*^9}, 
   3.5630499856557827`*^9, 3.563050042004681*^9, 3.563050077238743*^9, 
   3.5631065732665267`*^9, 3.563107642632543*^9, 3.5631076836570134`*^9, 
   3.5631110719644833`*^9, 3.5631115400192876`*^9, 3.563111598825388*^9, 
   3.5631116390814567`*^9, 3.56311182131497*^9, 3.563111949317589*^9, 
   3.563112783982228*^9, {3.5631129837985697`*^9, 3.5631130017854013`*^9}, 
   3.5631130626691027`*^9, 3.5631136942970057`*^9, 3.5631277471770678`*^9, 
   3.5631281219113255`*^9, 3.563128153298581*^9, 3.5631282388959312`*^9, 
   3.5631284212424755`*^9, 3.5631284518497286`*^9, 3.563128793934662*^9, 
   3.563128826367119*^9, 3.563128943382924*^9, 3.563129369794073*^9, {
   3.563129454533422*^9, 3.5631294742986565`*^9}, 3.5631296986894507`*^9, 
   3.5631297798251934`*^9, 3.563129872910557*^9, 3.563129954773501*^9, {
   3.563130047488064*^9, 3.563130067580899*^9}, 3.56313047110641*^9, 
   3.5631307464312935`*^9, 3.563130776866947*^9, 3.5633730059831457`*^9, 
   3.5633731021632805`*^9, 3.5633731485033455`*^9, 3.5633732187334433`*^9, 
   3.563553505104024*^9, 3.5647835560879936`*^9, 3.5648433002062635`*^9, 
   3.5648434942862043`*^9, 3.564843533863474*^9, {3.5648436392572594`*^9, 
   3.5648436681173096`*^9}, 3.564843956452616*^9, 3.564844038914361*^9, 
   3.564850817734276*^9, 3.5648508642847576`*^9, 3.56485091665405*^9, 
   3.5648515516219654`*^9, 3.5648525078256445`*^9, 3.5648526023930106`*^9, 
   3.564852654668702*^9, 3.567106143036501*^9, 3.5844775220709867`*^9}],

Cell[BoxData["\<\"     This plane touches the unit circle CONS in an \
eigendirection \"\>"], "Print",
 CellChangeTimes->{
  3.5629550986360693`*^9, 3.5629552384747143`*^9, 3.562955397017793*^9, {
   3.5629554461890793`*^9, 3.562955473286327*^9}, 3.562955546996456*^9, 
   3.5629555878685284`*^9, 3.562955627133797*^9, {3.5629556758214827`*^9, 
   3.5629556912499104`*^9}, 3.562955749516012*^9, 3.5629558033673067`*^9, 
   3.562955842694976*^9, 3.562963384191823*^9, 3.562963419042284*^9, 
   3.5630191524226074`*^9, 3.5630192141363153`*^9, {3.5630192856000414`*^9, 
   3.563019310185684*^9}, {3.5630193541153617`*^9, 3.5630193621181755`*^9}, 
   3.563019561034125*^9, {3.563020346167904*^9, 3.563020394621589*^9}, 
   3.563020527315422*^9, 3.5630205861275253`*^9, 3.563020631508005*^9, {
   3.5630206764048843`*^9, 3.563020718712158*^9}, 3.563020757727827*^9, {
   3.56302081655553*^9, 3.5630208254007454`*^9}, 3.5630209318085327`*^9, {
   3.5630218360797205`*^9, 3.563021863426569*^9}, {3.5630219037370396`*^9, 
   3.563021918635066*^9}, {3.5630219850131826`*^9, 3.5630220960697775`*^9}, 
   3.56302247810887*^9, 3.5630225147597356`*^9, {3.5630227914389234`*^9, 
   3.5630228139497633`*^9}, {3.563022860718645*^9, 3.563022961978423*^9}, 
   3.5630244252141933`*^9, {3.56302450898634*^9, 3.563024538470392*^9}, 
   3.563024573898054*^9, {3.5630246048485084`*^9, 3.5630246393713694`*^9}, {
   3.563024669666622*^9, 3.5630246931290636`*^9}, 3.5630247649359894`*^9, 
   3.5630250207452393`*^9, 3.563025263450465*^9, 3.563027130305744*^9, 
   3.563027228117916*^9, {3.5630274502935066`*^9, 3.5630274739899483`*^9}, {
   3.5630277148231707`*^9, 3.5630277394712143`*^9}, {3.5630294341021905`*^9, 
   3.5630294574242315`*^9}, 3.563029489903489*^9, 3.5630295392931757`*^9, 
   3.5630296129097047`*^9, 3.5630297851964073`*^9, {3.5630298821349773`*^9, 
   3.5630298996070085`*^9}, 3.563044604979759*^9, 3.5630450931871867`*^9, 
   3.563045157209699*^9, 3.5630452052109833`*^9, 3.563045235787037*^9, 
   3.563045378652088*^9, {3.5630454110377455`*^9, 3.5630454334393845`*^9}, 
   3.5630456828994226`*^9, 3.563045781709996*^9, 3.5630458374644938`*^9, 
   3.5630458690857496`*^9, 3.5630462941864967`*^9, 3.56304645572478*^9, 
   3.5630465521329494`*^9, 3.5630466124582553`*^9, 3.5630467308312635`*^9, 
   3.563046882213929*^9, 3.5630472614469957`*^9, 3.563047348963149*^9, 
   3.5630474030328445`*^9, 3.563047851564832*^9, {3.5630480367371573`*^9, 
   3.563048060277599*^9}, 3.563048104690877*^9, 3.5630483629041305`*^9, 
   3.5630484046654034`*^9, 3.563048588827327*^9, 3.5630486703622694`*^9, 
   3.563048753229615*^9, {3.5630499328496895`*^9, 3.5630499471237144`*^9}, 
   3.5630499856557827`*^9, 3.563050042004681*^9, 3.563050077238743*^9, 
   3.5631065732665267`*^9, 3.563107642632543*^9, 3.5631076836570134`*^9, 
   3.5631110719644833`*^9, 3.5631115400192876`*^9, 3.563111598825388*^9, 
   3.5631116390814567`*^9, 3.56311182131497*^9, 3.563111949317589*^9, 
   3.563112783982228*^9, {3.5631129837985697`*^9, 3.5631130017854013`*^9}, 
   3.5631130626691027`*^9, 3.5631136942970057`*^9, 3.5631277471770678`*^9, 
   3.5631281219113255`*^9, 3.563128153298581*^9, 3.5631282388959312`*^9, 
   3.5631284212424755`*^9, 3.5631284518497286`*^9, 3.563128793934662*^9, 
   3.563128826367119*^9, 3.563128943382924*^9, 3.563129369794073*^9, {
   3.563129454533422*^9, 3.5631294742986565`*^9}, 3.5631296986894507`*^9, 
   3.5631297798251934`*^9, 3.563129872910557*^9, 3.563129954773501*^9, {
   3.563130047488064*^9, 3.563130067580899*^9}, 3.56313047110641*^9, 
   3.5631307464312935`*^9, 3.563130776866947*^9, 3.5633730059831457`*^9, 
   3.5633731021632805`*^9, 3.5633731485033455`*^9, 3.5633732187334433`*^9, 
   3.563553505104024*^9, 3.5647835560879936`*^9, 3.5648433002062635`*^9, 
   3.5648434942862043`*^9, 3.564843533863474*^9, {3.5648436392572594`*^9, 
   3.5648436681173096`*^9}, 3.564843956452616*^9, 3.564844038914361*^9, 
   3.564850817734276*^9, 3.5648508642847576`*^9, 3.56485091665405*^9, 
   3.5648515516219654`*^9, 3.5648525078256445`*^9, 3.5648526023930106`*^9, 
   3.564852654668702*^9, 3.567106143036501*^9, 3.5844775220709867`*^9}],

Cell[BoxData["\<\"  Blue plane is qform = 1\"\>"], "Print",
 CellChangeTimes->{
  3.5629550986360693`*^9, 3.5629552384747143`*^9, 3.562955397017793*^9, {
   3.5629554461890793`*^9, 3.562955473286327*^9}, 3.562955546996456*^9, 
   3.5629555878685284`*^9, 3.562955627133797*^9, {3.5629556758214827`*^9, 
   3.5629556912499104`*^9}, 3.562955749516012*^9, 3.5629558033673067`*^9, 
   3.562955842694976*^9, 3.562963384191823*^9, 3.562963419042284*^9, 
   3.5630191524226074`*^9, 3.5630192141363153`*^9, {3.5630192856000414`*^9, 
   3.563019310185684*^9}, {3.5630193541153617`*^9, 3.5630193621181755`*^9}, 
   3.563019561034125*^9, {3.563020346167904*^9, 3.563020394621589*^9}, 
   3.563020527315422*^9, 3.5630205861275253`*^9, 3.563020631508005*^9, {
   3.5630206764048843`*^9, 3.563020718712158*^9}, 3.563020757727827*^9, {
   3.56302081655553*^9, 3.5630208254007454`*^9}, 3.5630209318085327`*^9, {
   3.5630218360797205`*^9, 3.563021863426569*^9}, {3.5630219037370396`*^9, 
   3.563021918635066*^9}, {3.5630219850131826`*^9, 3.5630220960697775`*^9}, 
   3.56302247810887*^9, 3.5630225147597356`*^9, {3.5630227914389234`*^9, 
   3.5630228139497633`*^9}, {3.563022860718645*^9, 3.563022961978423*^9}, 
   3.5630244252141933`*^9, {3.56302450898634*^9, 3.563024538470392*^9}, 
   3.563024573898054*^9, {3.5630246048485084`*^9, 3.5630246393713694`*^9}, {
   3.563024669666622*^9, 3.5630246931290636`*^9}, 3.5630247649359894`*^9, 
   3.5630250207452393`*^9, 3.563025263450465*^9, 3.563027130305744*^9, 
   3.563027228117916*^9, {3.5630274502935066`*^9, 3.5630274739899483`*^9}, {
   3.5630277148231707`*^9, 3.5630277394712143`*^9}, {3.5630294341021905`*^9, 
   3.5630294574242315`*^9}, 3.563029489903489*^9, 3.5630295392931757`*^9, 
   3.5630296129097047`*^9, 3.5630297851964073`*^9, {3.5630298821349773`*^9, 
   3.5630298996070085`*^9}, 3.563044604979759*^9, 3.5630450931871867`*^9, 
   3.563045157209699*^9, 3.5630452052109833`*^9, 3.563045235787037*^9, 
   3.563045378652088*^9, {3.5630454110377455`*^9, 3.5630454334393845`*^9}, 
   3.5630456828994226`*^9, 3.563045781709996*^9, 3.5630458374644938`*^9, 
   3.5630458690857496`*^9, 3.5630462941864967`*^9, 3.56304645572478*^9, 
   3.5630465521329494`*^9, 3.5630466124582553`*^9, 3.5630467308312635`*^9, 
   3.563046882213929*^9, 3.5630472614469957`*^9, 3.563047348963149*^9, 
   3.5630474030328445`*^9, 3.563047851564832*^9, {3.5630480367371573`*^9, 
   3.563048060277599*^9}, 3.563048104690877*^9, 3.5630483629041305`*^9, 
   3.5630484046654034`*^9, 3.563048588827327*^9, 3.5630486703622694`*^9, 
   3.563048753229615*^9, {3.5630499328496895`*^9, 3.5630499471237144`*^9}, 
   3.5630499856557827`*^9, 3.563050042004681*^9, 3.563050077238743*^9, 
   3.5631065732665267`*^9, 3.563107642632543*^9, 3.5631076836570134`*^9, 
   3.5631110719644833`*^9, 3.5631115400192876`*^9, 3.563111598825388*^9, 
   3.5631116390814567`*^9, 3.56311182131497*^9, 3.563111949317589*^9, 
   3.563112783982228*^9, {3.5631129837985697`*^9, 3.5631130017854013`*^9}, 
   3.5631130626691027`*^9, 3.5631136942970057`*^9, 3.5631277471770678`*^9, 
   3.5631281219113255`*^9, 3.563128153298581*^9, 3.5631282388959312`*^9, 
   3.5631284212424755`*^9, 3.5631284518497286`*^9, 3.563128793934662*^9, 
   3.563128826367119*^9, 3.563128943382924*^9, 3.563129369794073*^9, {
   3.563129454533422*^9, 3.5631294742986565`*^9}, 3.5631296986894507`*^9, 
   3.5631297798251934`*^9, 3.563129872910557*^9, 3.563129954773501*^9, {
   3.563130047488064*^9, 3.563130067580899*^9}, 3.56313047110641*^9, 
   3.5631307464312935`*^9, 3.563130776866947*^9, 3.5633730059831457`*^9, 
   3.5633731021632805`*^9, 3.5633731485033455`*^9, 3.5633732187334433`*^9, 
   3.563553505104024*^9, 3.5647835560879936`*^9, 3.5648433002062635`*^9, 
   3.5648434942862043`*^9, 3.564843533863474*^9, {3.5648436392572594`*^9, 
   3.5648436681173096`*^9}, 3.564843956452616*^9, 3.564844038914361*^9, 
   3.564850817734276*^9, 3.5648508642847576`*^9, 3.56485091665405*^9, 
   3.5648515516219654`*^9, 3.5648525078256445`*^9, 3.5648526023930106`*^9, 
   3.564852654668702*^9, 3.567106143036501*^9, 3.5844775220709867`*^9}],

Cell[BoxData["\<\"Yellow unit circle mapped to action ellipse in gray\"\>"], \
"Print",
 CellChangeTimes->{
  3.5629550986360693`*^9, 3.5629552384747143`*^9, 3.562955397017793*^9, {
   3.5629554461890793`*^9, 3.562955473286327*^9}, 3.562955546996456*^9, 
   3.5629555878685284`*^9, 3.562955627133797*^9, {3.5629556758214827`*^9, 
   3.5629556912499104`*^9}, 3.562955749516012*^9, 3.5629558033673067`*^9, 
   3.562955842694976*^9, 3.562963384191823*^9, 3.562963419042284*^9, 
   3.5630191524226074`*^9, 3.5630192141363153`*^9, {3.5630192856000414`*^9, 
   3.563019310185684*^9}, {3.5630193541153617`*^9, 3.5630193621181755`*^9}, 
   3.563019561034125*^9, {3.563020346167904*^9, 3.563020394621589*^9}, 
   3.563020527315422*^9, 3.5630205861275253`*^9, 3.563020631508005*^9, {
   3.5630206764048843`*^9, 3.563020718712158*^9}, 3.563020757727827*^9, {
   3.56302081655553*^9, 3.5630208254007454`*^9}, 3.5630209318085327`*^9, {
   3.5630218360797205`*^9, 3.563021863426569*^9}, {3.5630219037370396`*^9, 
   3.563021918635066*^9}, {3.5630219850131826`*^9, 3.5630220960697775`*^9}, 
   3.56302247810887*^9, 3.5630225147597356`*^9, {3.5630227914389234`*^9, 
   3.5630228139497633`*^9}, {3.563022860718645*^9, 3.563022961978423*^9}, 
   3.5630244252141933`*^9, {3.56302450898634*^9, 3.563024538470392*^9}, 
   3.563024573898054*^9, {3.5630246048485084`*^9, 3.5630246393713694`*^9}, {
   3.563024669666622*^9, 3.5630246931290636`*^9}, 3.5630247649359894`*^9, 
   3.5630250207452393`*^9, 3.563025263450465*^9, 3.563027130305744*^9, 
   3.563027228117916*^9, {3.5630274502935066`*^9, 3.5630274739899483`*^9}, {
   3.5630277148231707`*^9, 3.5630277394712143`*^9}, {3.5630294341021905`*^9, 
   3.5630294574242315`*^9}, 3.563029489903489*^9, 3.5630295392931757`*^9, 
   3.5630296129097047`*^9, 3.5630297851964073`*^9, {3.5630298821349773`*^9, 
   3.5630298996070085`*^9}, 3.563044604979759*^9, 3.5630450931871867`*^9, 
   3.563045157209699*^9, 3.5630452052109833`*^9, 3.563045235787037*^9, 
   3.563045378652088*^9, {3.5630454110377455`*^9, 3.5630454334393845`*^9}, 
   3.5630456828994226`*^9, 3.563045781709996*^9, 3.5630458374644938`*^9, 
   3.5630458690857496`*^9, 3.5630462941864967`*^9, 3.56304645572478*^9, 
   3.5630465521329494`*^9, 3.5630466124582553`*^9, 3.5630467308312635`*^9, 
   3.563046882213929*^9, 3.5630472614469957`*^9, 3.563047348963149*^9, 
   3.5630474030328445`*^9, 3.563047851564832*^9, {3.5630480367371573`*^9, 
   3.563048060277599*^9}, 3.563048104690877*^9, 3.5630483629041305`*^9, 
   3.5630484046654034`*^9, 3.563048588827327*^9, 3.5630486703622694`*^9, 
   3.563048753229615*^9, {3.5630499328496895`*^9, 3.5630499471237144`*^9}, 
   3.5630499856557827`*^9, 3.563050042004681*^9, 3.563050077238743*^9, 
   3.5631065732665267`*^9, 3.563107642632543*^9, 3.5631076836570134`*^9, 
   3.5631110719644833`*^9, 3.5631115400192876`*^9, 3.563111598825388*^9, 
   3.5631116390814567`*^9, 3.56311182131497*^9, 3.563111949317589*^9, 
   3.563112783982228*^9, {3.5631129837985697`*^9, 3.5631130017854013`*^9}, 
   3.5631130626691027`*^9, 3.5631136942970057`*^9, 3.5631277471770678`*^9, 
   3.5631281219113255`*^9, 3.563128153298581*^9, 3.5631282388959312`*^9, 
   3.5631284212424755`*^9, 3.5631284518497286`*^9, 3.563128793934662*^9, 
   3.563128826367119*^9, 3.563128943382924*^9, 3.563129369794073*^9, {
   3.563129454533422*^9, 3.5631294742986565`*^9}, 3.5631296986894507`*^9, 
   3.5631297798251934`*^9, 3.563129872910557*^9, 3.563129954773501*^9, {
   3.563130047488064*^9, 3.563130067580899*^9}, 3.56313047110641*^9, 
   3.5631307464312935`*^9, 3.563130776866947*^9, 3.5633730059831457`*^9, 
   3.5633731021632805`*^9, 3.5633731485033455`*^9, 3.5633732187334433`*^9, 
   3.563553505104024*^9, 3.5647835560879936`*^9, 3.5648433002062635`*^9, 
   3.5648434942862043`*^9, 3.564843533863474*^9, {3.5648436392572594`*^9, 
   3.5648436681173096`*^9}, 3.564843956452616*^9, 3.564844038914361*^9, 
   3.564850817734276*^9, 3.5648508642847576`*^9, 3.56485091665405*^9, 
   3.5648515516219654`*^9, 3.5648525078256445`*^9, 3.5648526023930106`*^9, 
   3.564852654668702*^9, 3.567106143036501*^9, 3.5844775220709867`*^9}]
}, Open  ]],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJx1mw+czlX2x59BCimprdj+qUlh1YZdod+c0dqaktqw/SFipJX1RFO/lD+F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    "], {{
      {GrayLevel[0.7], Opacity[0.8], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNmgf811MXx7/3JimU0FY0jbSslPGUrR6EpDIaSiKFRIqGpK3pSbLKLCMk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           "]], Polygon3DBox[CompressedData["
1:eJwtlWmwz1UYx895yGXMmJIwQ4YXBi96kytLQpFCIVlqRpE96xhEDCaNItKL
ZO1SyhYRKROGse9bhqLszKCkCJHi852vF5/7+z7nnP9Znu1W6zao3cBIKfWF
4tAc4zY0zSlNxf4FvQbWo8sxNhHdFf7HPgkz0INgK/pPaIFuDJVZ+wDUgiqw
hLnXGP8IvoZijJ1lbABaF5iG1j2m8ue5sNaeL+ts2Ja8ZiN6A8xAF7DHFHQP
yOgzjBWh68Je9DWYgx4Ce9B/w5foI1CW9beT3/IeHE9+02fo4bAffRPmohvA
AfQN2I/uAt/KN9AP/SNcQG9JvsskOJV8p5boJlAN/Rtjw9Cd4HryHQvlOyjF
fCUYp7cXS6l19hnjsZfAf8l33If+Hlagy7DmEnoB3MF+Its3m6Fkto9Goa/p
DdgLsLejO0ARehfUYPwvvrOgPePvQ3e4i30CPkF3hLnoi8mxnQ//JsdYvtwF
pbN9Wi/sM/lqHzQM+1S+nA9r0QfhQdZuSvZJXfRYxn5WjPm+AvPQl+BJ9Odw
C30QdqA7h99yCF5FjwzP/ZPs27fCZ8vHH6CXKpmyY6KzqmafNfZ+bPaGfakY
LUZ/JR8z/7YIn6G9lQOb0LWhYraPJ6N7K2bo08z3RL8Il9E/wBvoF+D35D2f
R08P++JR2I3eCTWzfaicVM2oVlQzOmtmOEY68zi6LVzBLo/dGt0MzmH/keyr
RsrJZJ/1Ca/R3DrlSLhmVauK6ePsUQh9lTfYK/h+E6597TkiHBPFQjXxUzjn
lGsP3/+t7qLfao9b8CxMwW7CXAly+Sj2Mew22EPDOaVcUk0WMD9Y+Yp+KTtX
nwr7Rjn7hXIBaiW/aRt6C3yaXDPqVf3Dtaeepdp5Jxw71dAy9PJwr9Gd6oR7
hHrDbnhatagzWTtAMQ77WL5Vjv6KbhPufY9A/XBPUS9Rjq4Mr9Fc8eza6RWO
vWpItboaSmTXrGJ9GB7Kjvke5X3Yl4/BKvR34d65KDm33gzHTjk2K9wz1Cuu
MvZ62Mfy7Urs2fJN+G3yqXJ/QrhXqwYuoseEa0d3OBGuSdViBezzyqVwb9Od
R6Mz+7fKjoFy+Zlwb1BOn0KfDvdi9Wj1qnflk+SepVpoGq4N1YR6/4fhXq3/
AdWze5B6j3rQIr4Lw7HQHh/r7uG7qcfeAy4q6Z0=
           "]]}],
        Lighting->"Neutral"]}, {}, {}, {}, {}}, 
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl01VvFkEUBuBti0v4DSSEGy64KO5S3EtwAqV4gBZ3CO4ORQrFnUJx9yLF
3d29uOuz4eLZd87M5pszu/vlj0+MTYgIgiCTDMJxQZdkOS8yCKI5TDoHOMRB
HnCf/TRkH7Ek0I1qzKI7f0hkLsV4TWOS6M1ferGQkrylKbPpTxAVBP3kYsrw
gebMoTpl+cggWvCclmQwlBdc5gonOMVJrrKcdbaIobBzp8mV5l5yjeucJq+1
YfIG2fTTSm5272dZkVWsZhQ5rI8Mf5fRRKnHyDjGk1M9TqYygSzqibIdU8il
nizXM5Ws6mkyjQ1U4Xv4zO1/U84gn/52y1s8pR63wx7D9+W+AtaTZLRMl/XN
3+E8F9jDXZ7RgHvM5CJd2MsluvKDqmxkE9P5Rgx16cRvOtORSXylMnVozy86
0JaxfKEStWnDT+JZyxqGE+k5jJC72ElrzvGYJ9RiB9s5yxkqUDN8j84cSyHn
T5UrzJWnBtvYSh5rj+QWctsrgiHGS1nGYD5RjiWU5j0DacYA3lGKRZQgk740
oQ9vKE4KRXlFTxYwnx5kt2+KHhsZH+dh+E3o7Yg8xlGKkBz5/z/7D2OZiFo=

       "]]}},
    VertexNormals->CompressedData["
1:eJxFWwc4lu37LkUaVJpfKl9DS6ElaVztQYP6aGjSTihfX5N2KdHUkFFIIlJK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     "]], 
   {RGBColor[0, 0, 1], Thickness[0.003], 
    Line3DBox[
     NCache[{{{1, 0, 1.25}, {
        Cos[Rational[18, 5] Degree], Sin[Rational[18, 5] Degree], 
         1.3753332335643043`}, {
        Cos[Rational[36, 5] Degree], Sin[Rational[36, 5] Degree], 
         1.4986898871648549`}, {
        Cos[Rational[54, 5] Degree], Sin[Rational[54, 5] Degree], 
         1.618124552684678}, {
        Cos[Rational[72, 5] Degree], Sin[Rational[72, 5] Degree], 
         1.7317536741017152`}, {(Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (-1 + 5^Rational[1, 2]), 1.837785252292473}, {
        Cos[Rational[108, 5] Degree], Sin[Rational[108, 5] Degree], 
         1.9345471059286887`}, {
        Cos[Rational[126, 5] Degree], Sin[Rational[126, 5] Degree], 
         2.0205132427757895`}, {
        Cos[Rational[144, 5] Degree], Sin[Rational[144, 5] Degree], 
         2.0943279255020153`}, {
        Cos[Rational[162, 5] Degree], Sin[Rational[162, 5] Degree], 
         2.1548270524660196`}, {
        Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         2.2010565162951536`}, {
        Cos[Rational[198, 5] Degree], Sin[Rational[198, 5] Degree], 
         2.232287250728689}, {
        Cos[Rational[216, 5] Degree], Sin[Rational[216, 5] Degree], 
         2.248026728428272}, {
        Sin[Rational[216, 5] Degree], Cos[Rational[216, 5] Degree], 
         2.248026728428272}, {
        Sin[Rational[198, 5] Degree], Cos[Rational[198, 5] Degree], 
         2.232287250728689}, {(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (1 + 5^Rational[1, 2]), 2.2010565162951536`}, {
        Sin[Rational[162, 5] Degree], Cos[Rational[162, 5] Degree], 
         2.1548270524660196`}, {
        Sin[Rational[144, 5] Degree], Cos[Rational[144, 5] Degree], 
         2.0943279255020153`}, {
        Sin[Rational[126, 5] Degree], Cos[Rational[126, 5] Degree], 
         2.0205132427757895`}, {
        Sin[Rational[108, 5] Degree], Cos[Rational[108, 5] Degree], 
         1.9345471059286887`}, {
        Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         1.837785252292473}, {
        Sin[Rational[72, 5] Degree], Cos[Rational[72, 5] Degree], 
         1.7317536741017152`}, {
        Sin[Rational[54, 5] Degree], Cos[Rational[54, 5] Degree], 
         1.618124552684678}, {
        Sin[Rational[36, 5] Degree], Cos[Rational[36, 5] Degree], 
         1.4986898871648549`}, {
        Sin[Rational[18, 5] Degree], Cos[Rational[18, 5] Degree], 
         1.3753332335643043`}, {
        0, 1, 1.25}, {-Sin[Rational[18, 5] Degree], Cos[
         Rational[18, 5] Degree], 1.1246667664356957`}, {-
         Sin[Rational[36, 5] Degree], Cos[Rational[36, 5] Degree], 
         1.0013101128351451`}, {-Sin[Rational[54, 5] Degree], Cos[
         Rational[54, 5] Degree], 0.881875447315322}, {-
         Sin[Rational[72, 5] Degree], Cos[Rational[72, 5] Degree], 
         0.7682463258982846}, {
        Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         0.6622147477075266}, {-Sin[Rational[108, 5] Degree], Cos[
         Rational[108, 5] Degree], 0.5654528940713115}, {-
         Sin[Rational[126, 5] Degree], Cos[Rational[126, 5] Degree], 
         0.47948675722421097`}, {-Sin[Rational[144, 5] Degree], Cos[
         Rational[144, 5] Degree], 0.405672074497985}, {-
         Sin[Rational[162, 5] Degree], Cos[Rational[162, 5] Degree], 
         0.3451729475339805}, {-(Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (1 + 5^Rational[1, 2]), 0.29894348370484647`}, {-
         Sin[Rational[198, 5] Degree], Cos[Rational[198, 5] Degree], 
         0.2677127492713112}, {-Sin[Rational[216, 5] Degree], Cos[
         Rational[216, 5] Degree], 0.2519732715717285}, {-
         Cos[Rational[216, 5] Degree], Sin[Rational[216, 5] Degree], 
         0.2519732715717285}, {-Cos[Rational[198, 5] Degree], Sin[
         Rational[198, 5] Degree], 0.2677127492713112}, {
        Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         0.29894348370484647`}, {-Cos[Rational[162, 5] Degree], Sin[
         Rational[162, 5] Degree], 0.3451729475339805}, {-
         Cos[Rational[144, 5] Degree], Sin[Rational[144, 5] Degree], 
         0.405672074497985}, {-Cos[Rational[126, 5] Degree], Sin[
         Rational[126, 5] Degree], 0.47948675722421097`}, {-
         Cos[Rational[108, 5] Degree], Sin[Rational[108, 5] Degree], 
         0.5654528940713115}, {-(Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (-1 + 5^Rational[1, 2]), 0.6622147477075266}, {-
         Cos[Rational[72, 5] Degree], Sin[Rational[72, 5] Degree], 
         0.7682463258982846}, {-Cos[Rational[54, 5] Degree], Sin[
         Rational[54, 5] Degree], 0.881875447315322}, {-
         Cos[Rational[36, 5] Degree], Sin[Rational[36, 5] Degree], 
         1.0013101128351451`}, {-Cos[Rational[18, 5] Degree], Sin[
         Rational[18, 5] Degree], 1.1246667664356957`}, {-1, 0, 1.25}, {-
         Cos[Rational[18, 5] Degree], -Sin[Rational[18, 5] Degree], 
         1.3753332335643043`}, {-Cos[Rational[36, 5] Degree], -
         Sin[Rational[36, 5] Degree], 1.4986898871648549`}, {-
         Cos[Rational[54, 5] Degree], -Sin[Rational[54, 5] Degree], 
         1.618124552684678}, {-Cos[Rational[72, 5] Degree], -
         Sin[Rational[72, 5] Degree], 
         1.7317536741017152`}, {-(Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (1 - 5^Rational[1, 2]), 1.837785252292473}, {-
         Cos[Rational[108, 5] Degree], -Sin[Rational[108, 5] Degree], 
         1.9345471059286887`}, {-Cos[Rational[126, 5] Degree], -
         Sin[Rational[126, 5] Degree], 2.0205132427757895`}, {-
         Cos[Rational[144, 5] Degree], -Sin[Rational[144, 5] Degree], 
         2.0943279255020153`}, {-Cos[Rational[162, 5] Degree], -
         Sin[Rational[162, 5] Degree], 2.1548270524660196`}, {
        Rational[1, 4] (-1 - 5^
          Rational[1, 2]), -(Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         2.2010565162951536`}, {-Cos[Rational[198, 5] Degree], -
         Sin[Rational[198, 5] Degree], 2.232287250728689}, {-
         Cos[Rational[216, 5] Degree], -Sin[Rational[216, 5] Degree], 
         2.248026728428272}, {-Sin[Rational[216, 5] Degree], -
         Cos[Rational[216, 5] Degree], 2.248026728428272}, {-
         Sin[Rational[198, 5] Degree], -Cos[Rational[198, 5] Degree], 
         2.232287250728689}, {-(Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (-1 - 5^Rational[1, 2]), 2.2010565162951536`}, {-
         Sin[Rational[162, 5] Degree], -Cos[Rational[162, 5] Degree], 
         2.1548270524660196`}, {-Sin[Rational[144, 5] Degree], -
         Cos[Rational[144, 5] Degree], 2.0943279255020153`}, {-
         Sin[Rational[126, 5] Degree], -Cos[Rational[126, 5] Degree], 
         2.0205132427757895`}, {-Sin[Rational[108, 5] Degree], -
         Cos[Rational[108, 5] Degree], 1.9345471059286887`}, {
        Rational[1, 4] (1 - 5^
          Rational[1, 2]), -(Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         1.837785252292473}, {-Sin[Rational[72, 5] Degree], -
         Cos[Rational[72, 5] Degree], 1.7317536741017152`}, {-
         Sin[Rational[54, 5] Degree], -Cos[Rational[54, 5] Degree], 
         1.618124552684678}, {-Sin[Rational[36, 5] Degree], -
         Cos[Rational[36, 5] Degree], 1.4986898871648549`}, {-
         Sin[Rational[18, 5] Degree], -Cos[Rational[18, 5] Degree], 
         1.3753332335643043`}, {0, -1, 1.25}, {
        Sin[Rational[18, 5] Degree], -Cos[Rational[18, 5] Degree], 
         1.1246667664356957`}, {
        Sin[Rational[36, 5] Degree], -Cos[Rational[36, 5] Degree], 
         1.0013101128351451`}, {
        Sin[Rational[54, 5] Degree], -Cos[Rational[54, 5] Degree], 
         0.881875447315322}, {
        Sin[Rational[72, 5] Degree], -Cos[Rational[72, 5] Degree], 
         0.7682463258982846}, {
        Rational[1, 4] (-1 + 
          5^Rational[1, 2]), -(Rational[5, 8] + 
           Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         0.6622147477075266}, {
        Sin[Rational[108, 5] Degree], -Cos[Rational[108, 5] Degree], 
         0.5654528940713115}, {
        Sin[Rational[126, 5] Degree], -Cos[Rational[126, 5] Degree], 
         0.47948675722421097`}, {
        Sin[Rational[144, 5] Degree], -Cos[Rational[144, 5] Degree], 
         0.405672074497985}, {
        Sin[Rational[162, 5] Degree], -Cos[Rational[162, 5] Degree], 
         0.3451729475339805}, {(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (-1 - 5^Rational[1, 2]), 0.29894348370484647`}, {
        Sin[Rational[198, 5] Degree], -Cos[Rational[198, 5] Degree], 
         0.2677127492713112}, {
        Sin[Rational[216, 5] Degree], -Cos[Rational[216, 5] Degree], 
         0.2519732715717285}, {
        Cos[Rational[216, 5] Degree], -Sin[Rational[216, 5] Degree], 
         0.2519732715717285}, {
        Cos[Rational[198, 5] Degree], -Sin[Rational[198, 5] Degree], 
         0.2677127492713112}, {
        Rational[1, 4] (1 + 
          5^Rational[1, 2]), -(Rational[5, 8] + 
           Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         0.29894348370484647`}, {
        Cos[Rational[162, 5] Degree], -Sin[Rational[162, 5] Degree], 
         0.3451729475339805}, {
        Cos[Rational[144, 5] Degree], -Sin[Rational[144, 5] Degree], 
         0.405672074497985}, {
        Cos[Rational[126, 5] Degree], -Sin[Rational[126, 5] Degree], 
         0.47948675722421097`}, {
        Cos[Rational[108, 5] Degree], -Sin[Rational[108, 5] Degree], 
         0.5654528940713115}, {(Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (1 - 5^Rational[1, 2]), 0.6622147477075266}, {
        Cos[Rational[72, 5] Degree], -Sin[Rational[72, 5] Degree], 
         0.7682463258982846}, {
        Cos[Rational[54, 5] Degree], -Sin[Rational[54, 5] Degree], 
         0.881875447315322}, {
        Cos[Rational[36, 5] Degree], -Sin[Rational[36, 5] Degree], 
         1.0013101128351451`}, {
        Cos[Rational[18, 5] Degree], -Sin[Rational[18, 5] Degree], 
         1.1246667664356957`}}}, {{{1, 0, 1.25}, {0.9980267284282716, 
        0.06279051952931337, 1.3753332335643043`}, {0.9921147013144779, 
        0.12533323356430426`, 1.4986898871648549`}, {0.9822872507286887, 
        0.18738131458572463`, 1.618124552684678}, {0.9685831611286311, 
        0.2486898871648548, 1.7317536741017152`}, {0.9510565162951535, 
        0.30901699437494745`, 1.837785252292473}, {0.9297764858882515, 
        0.368124552684678, 1.9345471059286887`}, {0.9048270524660196, 
        0.42577929156507266`, 2.0205132427757895`}, {0.8763066800438636, 
        0.4817536741017153, 2.0943279255020153`}, {0.8443279255020151, 
        0.5358267949789967, 2.1548270524660196`}, {0.8090169943749475, 
        0.5877852522924731, 2.2010565162951536`}, {0.7705132427757891, 
        0.6374239897486897, 2.232287250728689}, {0.7289686274214116, 
        0.6845471059286887, 2.248026728428272}, {0.6845471059286887, 
        0.7289686274214116, 2.248026728428272}, {0.6374239897486897, 
        0.7705132427757891, 2.232287250728689}, {0.5877852522924731, 
        0.8090169943749475, 2.2010565162951536`}, {0.5358267949789967, 
        0.8443279255020151, 2.1548270524660196`}, {0.4817536741017153, 
        0.8763066800438636, 2.0943279255020153`}, {0.42577929156507266`, 
        0.9048270524660196, 2.0205132427757895`}, {0.368124552684678, 
        0.9297764858882515, 1.9345471059286887`}, {0.30901699437494745`, 
        0.9510565162951535, 1.837785252292473}, {0.2486898871648548, 
        0.9685831611286311, 1.7317536741017152`}, {0.18738131458572463`, 
        0.9822872507286887, 1.618124552684678}, {0.12533323356430426`, 
        0.9921147013144779, 1.4986898871648549`}, {0.06279051952931337, 
        0.9980267284282716, 1.3753332335643043`}, {
        0, 1, 1.25}, {-0.06279051952931337, 0.9980267284282716, 
        1.1246667664356957`}, {-0.12533323356430426`, 0.9921147013144779, 
        1.0013101128351451`}, {-0.18738131458572463`, 0.9822872507286887, 
        0.881875447315322}, {-0.2486898871648548, 0.9685831611286311, 
        0.7682463258982846}, {-0.30901699437494745`, 0.9510565162951535, 
        0.6622147477075266}, {-0.368124552684678, 0.9297764858882515, 
        0.5654528940713115}, {-0.42577929156507266`, 0.9048270524660196, 
        0.47948675722421097`}, {-0.4817536741017153, 0.8763066800438636, 
        0.405672074497985}, {-0.5358267949789967, 0.8443279255020151, 
        0.3451729475339805}, {-0.5877852522924731, 0.8090169943749475, 
        0.29894348370484647`}, {-0.6374239897486897, 0.7705132427757891, 
        0.2677127492713112}, {-0.6845471059286887, 0.7289686274214116, 
        0.2519732715717285}, {-0.7289686274214116, 0.6845471059286887, 
        0.2519732715717285}, {-0.7705132427757891, 0.6374239897486897, 
        0.2677127492713112}, {-0.8090169943749475, 0.5877852522924731, 
        0.29894348370484647`}, {-0.8443279255020151, 0.5358267949789967, 
        0.3451729475339805}, {-0.8763066800438636, 0.4817536741017153, 
        0.405672074497985}, {-0.9048270524660196, 0.42577929156507266`, 
        0.47948675722421097`}, {-0.9297764858882515, 0.368124552684678, 
        0.5654528940713115}, {-0.9510565162951535, 0.30901699437494745`, 
        0.6622147477075266}, {-0.9685831611286311, 0.2486898871648548, 
        0.7682463258982846}, {-0.9822872507286887, 0.18738131458572463`, 
        0.881875447315322}, {-0.9921147013144779, 0.12533323356430426`, 
        1.0013101128351451`}, {-0.9980267284282716, 0.06279051952931337, 
        1.1246667664356957`}, {-1, 0, 
         1.25}, {-0.9980267284282716, -0.06279051952931337, 
        1.3753332335643043`}, {-0.9921147013144779, -0.12533323356430426`, 
        1.4986898871648549`}, {-0.9822872507286887, -0.18738131458572463`, 
        1.618124552684678}, {-0.9685831611286311, -0.2486898871648548, 
        1.7317536741017152`}, {-0.9510565162951535, -0.30901699437494745`, 
        1.837785252292473}, {-0.9297764858882515, -0.368124552684678, 
        1.9345471059286887`}, {-0.9048270524660196, -0.42577929156507266`, 
        2.0205132427757895`}, {-0.8763066800438636, -0.4817536741017153, 
        2.0943279255020153`}, {-0.8443279255020151, -0.5358267949789967, 
        2.1548270524660196`}, {-0.8090169943749475, -0.5877852522924731, 
        2.2010565162951536`}, {-0.7705132427757891, -0.6374239897486897, 
        2.232287250728689}, {-0.7289686274214116, -0.6845471059286887, 
        2.248026728428272}, {-0.6845471059286887, -0.7289686274214116, 
        2.248026728428272}, {-0.6374239897486897, -0.7705132427757891, 
        2.232287250728689}, {-0.5877852522924731, -0.8090169943749475, 
        2.2010565162951536`}, {-0.5358267949789967, -0.8443279255020151, 
        2.1548270524660196`}, {-0.4817536741017153, -0.8763066800438636, 
        2.0943279255020153`}, {-0.42577929156507266`, -0.9048270524660196, 
        2.0205132427757895`}, {-0.368124552684678, -0.9297764858882515, 
        1.9345471059286887`}, {-0.30901699437494745`, -0.9510565162951535, 
        1.837785252292473}, {-0.2486898871648548, -0.9685831611286311, 
        1.7317536741017152`}, {-0.18738131458572463`, -0.9822872507286887, 
        1.618124552684678}, {-0.12533323356430426`, -0.9921147013144779, 
        1.4986898871648549`}, {-0.06279051952931337, -0.9980267284282716, 
        1.3753332335643043`}, {0, -1, 1.25}, {
        0.06279051952931337, -0.9980267284282716, 1.1246667664356957`}, {
        0.12533323356430426`, -0.9921147013144779, 1.0013101128351451`}, {
        0.18738131458572463`, -0.9822872507286887, 0.881875447315322}, {
        0.2486898871648548, -0.9685831611286311, 0.7682463258982846}, {
        0.30901699437494745`, -0.9510565162951535, 0.6622147477075266}, {
        0.368124552684678, -0.9297764858882515, 0.5654528940713115}, {
        0.42577929156507266`, -0.9048270524660196, 0.47948675722421097`}, {
        0.4817536741017153, -0.8763066800438636, 0.405672074497985}, {
        0.5358267949789967, -0.8443279255020151, 0.3451729475339805}, {
        0.5877852522924731, -0.8090169943749475, 0.29894348370484647`}, {
        0.6374239897486897, -0.7705132427757891, 0.2677127492713112}, {
        0.6845471059286887, -0.7289686274214116, 0.2519732715717285}, {
        0.7289686274214116, -0.6845471059286887, 0.2519732715717285}, {
        0.7705132427757891, -0.6374239897486897, 0.2677127492713112}, {
        0.8090169943749475, -0.5877852522924731, 0.29894348370484647`}, {
        0.8443279255020151, -0.5358267949789967, 0.3451729475339805}, {
        0.8763066800438636, -0.4817536741017153, 0.405672074497985}, {
        0.9048270524660196, -0.42577929156507266`, 0.47948675722421097`}, {
        0.9297764858882515, -0.368124552684678, 0.5654528940713115}, {
        0.9510565162951535, -0.30901699437494745`, 0.6622147477075266}, {
        0.9685831611286311, -0.2486898871648548, 0.7682463258982846}, {
        0.9822872507286887, -0.18738131458572463`, 0.881875447315322}, {
        0.9921147013144779, -0.12533323356430426`, 1.0013101128351451`}, {
        0.9980267284282716, -0.06279051952931337, 1.1246667664356957`}}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{1, 0, 0}, {
       Cos[Rational[18, 5] Degree], Sin[Rational[18, 5] Degree], 0}}, {{1, 0, 
       0}, {0.9980267284282716, 0.06279051952931337, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[18, 5] Degree], Sin[Rational[18, 5] Degree], 0}, {
       Cos[Rational[36, 5] Degree], Sin[Rational[36, 5] Degree], 0}}, {{
       0.9980267284282716, 0.06279051952931337, 0}, {
       0.9921147013144779, 0.12533323356430426`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[36, 5] Degree], Sin[Rational[36, 5] Degree], 0}, {
       Cos[Rational[54, 5] Degree], Sin[Rational[54, 5] Degree], 0}}, {{
       0.9921147013144779, 0.12533323356430426`, 0}, {
       0.9822872507286887, 0.18738131458572463`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[54, 5] Degree], Sin[Rational[54, 5] Degree], 0}, {
       Cos[Rational[72, 5] Degree], Sin[Rational[72, 5] Degree], 0}}, {{
       0.9822872507286887, 0.18738131458572463`, 0}, {
       0.9685831611286311, 0.2486898871648548, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[72, 5] Degree], Sin[Rational[72, 5] Degree], 
        0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 0}}, {{
       0.9685831611286311, 0.2486898871648548, 0}, {
       0.9510565162951535, 0.30901699437494745`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 0}, {
       Cos[Rational[108, 5] Degree], Sin[Rational[108, 5] Degree], 0}}, {{
       0.9510565162951535, 0.30901699437494745`, 0}, {
       0.9297764858882515, 0.368124552684678, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[108, 5] Degree], Sin[Rational[108, 5] Degree], 
        0}, {Cos[Rational[126, 5] Degree], Sin[Rational[126, 5] Degree], 
        0}}, {{0.9297764858882515, 0.368124552684678, 0}, {
       0.9048270524660196, 0.42577929156507266`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[126, 5] Degree], Sin[Rational[126, 5] Degree], 
        0}, {Cos[Rational[144, 5] Degree], Sin[Rational[144, 5] Degree], 
        0}}, {{0.9048270524660196, 0.42577929156507266`, 0}, {
       0.8763066800438636, 0.4817536741017153, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[144, 5] Degree], Sin[Rational[144, 5] Degree], 
        0}, {
       Cos[Rational[162, 5] Degree], Sin[Rational[162, 5] Degree], 0}}, {{
       0.8763066800438636, 0.4817536741017153, 0}, {
       0.8443279255020151, 0.5358267949789967, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[162, 5] Degree], Sin[Rational[162, 5] Degree], 
        0}, {Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}}, {{
       0.8443279255020151, 0.5358267949789967, 0}, {
       0.8090169943749475, 0.5877852522924731, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {
       Cos[Rational[198, 5] Degree], Sin[Rational[198, 5] Degree], 0}}, {{
       0.8090169943749475, 0.5877852522924731, 0}, {
       0.7705132427757891, 0.6374239897486897, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[198, 5] Degree], Sin[Rational[198, 5] Degree], 
        0}, {Cos[Rational[216, 5] Degree], Sin[Rational[216, 5] Degree], 
        0}}, {{0.7705132427757891, 0.6374239897486897, 0}, {
       0.7289686274214116, 0.6845471059286887, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[216, 5] Degree], Sin[Rational[216, 5] Degree], 
        0}, {Sin[Rational[216, 5] Degree], Cos[Rational[216, 5] Degree], 
        0}}, {{0.7289686274214116, 0.6845471059286887, 0}, {
       0.6845471059286887, 0.7289686274214116, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[216, 5] Degree], Cos[Rational[216, 5] Degree], 
        0}, {Sin[Rational[198, 5] Degree], Cos[Rational[198, 5] Degree], 
        0}}, {{0.6845471059286887, 0.7289686274214116, 0}, {
       0.6374239897486897, 0.7705132427757891, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[198, 5] Degree], Cos[Rational[198, 5] Degree], 
        0}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 0}}, {{
       0.6374239897486897, 0.7705132427757891, 0}, {
       0.5877852522924731, 0.8090169943749475, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 0}, {
       Sin[Rational[162, 5] Degree], Cos[Rational[162, 5] Degree], 0}}, {{
       0.5877852522924731, 0.8090169943749475, 0}, {
       0.5358267949789967, 0.8443279255020151, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[162, 5] Degree], Cos[Rational[162, 5] Degree], 
        0}, {Sin[Rational[144, 5] Degree], Cos[Rational[144, 5] Degree], 
        0}}, {{0.5358267949789967, 0.8443279255020151, 0}, {
       0.4817536741017153, 0.8763066800438636, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[144, 5] Degree], Cos[Rational[144, 5] Degree], 
        0}, {Sin[Rational[126, 5] Degree], Cos[Rational[126, 5] Degree], 
        0}}, {{0.4817536741017153, 0.8763066800438636, 0}, {
       0.42577929156507266`, 0.9048270524660196, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[126, 5] Degree], Cos[Rational[126, 5] Degree], 
        0}, {Sin[Rational[108, 5] Degree], Cos[Rational[108, 5] Degree], 
        0}}, {{0.42577929156507266`, 0.9048270524660196, 0}, {
       0.368124552684678, 0.9297764858882515, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[108, 5] Degree], Cos[Rational[108, 5] Degree], 
        0}, {Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}}, {{
       0.368124552684678, 0.9297764858882515, 0}, {
       0.30901699437494745`, 0.9510565162951535, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {
       Sin[Rational[72, 5] Degree], Cos[Rational[72, 5] Degree], 0}}, {{
       0.30901699437494745`, 0.9510565162951535, 0}, {
       0.2486898871648548, 0.9685831611286311, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[72, 5] Degree], Cos[Rational[72, 5] Degree], 0}, {
       Sin[Rational[54, 5] Degree], Cos[Rational[54, 5] Degree], 0}}, {{
       0.2486898871648548, 0.9685831611286311, 0}, {
       0.18738131458572463`, 0.9822872507286887, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[54, 5] Degree], Cos[Rational[54, 5] Degree], 0}, {
       Sin[Rational[36, 5] Degree], Cos[Rational[36, 5] Degree], 0}}, {{
       0.18738131458572463`, 0.9822872507286887, 0}, {
       0.12533323356430426`, 0.9921147013144779, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[36, 5] Degree], Cos[Rational[36, 5] Degree], 0}, {
       Sin[Rational[18, 5] Degree], Cos[Rational[18, 5] Degree], 0}}, {{
       0.12533323356430426`, 0.9921147013144779, 0}, {
       0.06279051952931337, 0.9980267284282716, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[18, 5] Degree], Cos[Rational[18, 5] Degree], 0}, {
       0, 1, 0}}, {{0.06279051952931337, 0.9980267284282716, 0}, {0, 1, 
       0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{0, 1, 
       0}, {-Sin[Rational[18, 5] Degree], Cos[Rational[18, 5] Degree], 0}}, {{
       0, 1, 0}, {-0.06279051952931337, 0.9980267284282716, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[18, 5] Degree], Cos[Rational[18, 5] Degree], 
        0}, {-Sin[Rational[36, 5] Degree], Cos[Rational[36, 5] Degree], 
        0}}, {{-0.06279051952931337, 0.9980267284282716, 
        0}, {-0.12533323356430426`, 0.9921147013144779, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[36, 5] Degree], Cos[Rational[36, 5] Degree], 
        0}, {-Sin[Rational[54, 5] Degree], Cos[Rational[54, 5] Degree], 
        0}}, {{-0.12533323356430426`, 0.9921147013144779, 
        0}, {-0.18738131458572463`, 0.9822872507286887, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[54, 5] Degree], Cos[Rational[54, 5] Degree], 
        0}, {-Sin[Rational[72, 5] Degree], Cos[Rational[72, 5] Degree], 
        0}}, {{-0.18738131458572463`, 0.9822872507286887, 
        0}, {-0.2486898871648548, 0.9685831611286311, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[72, 5] Degree], Cos[Rational[72, 5] Degree], 0}, {
       Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        0}}, {{-0.2486898871648548, 0.9685831611286311, 
        0}, {-0.30901699437494745`, 0.9510565162951535, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Rational[1, 4] (1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {-
        Sin[Rational[108, 5] Degree], Cos[Rational[108, 5] Degree], 
        0}}, {{-0.30901699437494745`, 0.9510565162951535, 
        0}, {-0.368124552684678, 0.9297764858882515, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[108, 5] Degree], Cos[Rational[108, 5] Degree], 
        0}, {-Sin[Rational[126, 5] Degree], Cos[Rational[126, 5] Degree], 
        0}}, {{-0.368124552684678, 0.9297764858882515, 
        0}, {-0.42577929156507266`, 0.9048270524660196, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[126, 5] Degree], Cos[Rational[126, 5] Degree], 
        0}, {-Sin[Rational[144, 5] Degree], Cos[Rational[144, 5] Degree], 
        0}}, {{-0.42577929156507266`, 0.9048270524660196, 
        0}, {-0.4817536741017153, 0.8763066800438636, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[144, 5] Degree], Cos[Rational[144, 5] Degree], 
        0}, {-Sin[Rational[162, 5] Degree], Cos[Rational[162, 5] Degree], 
        0}}, {{-0.4817536741017153, 0.8763066800438636, 
        0}, {-0.5358267949789967, 0.8443279255020151, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[162, 5] Degree], Cos[Rational[162, 5] Degree], 
        0}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
        0}}, {{-0.5358267949789967, 0.8443279255020151, 
        0}, {-0.5877852522924731, 0.8090169943749475, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 0}, {-
        Sin[Rational[198, 5] Degree], Cos[Rational[198, 5] Degree], 
        0}}, {{-0.5877852522924731, 0.8090169943749475, 
        0}, {-0.6374239897486897, 0.7705132427757891, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[198, 5] Degree], Cos[Rational[198, 5] Degree], 
        0}, {-Sin[Rational[216, 5] Degree], Cos[Rational[216, 5] Degree], 
        0}}, {{-0.6374239897486897, 0.7705132427757891, 
        0}, {-0.6845471059286887, 0.7289686274214116, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[216, 5] Degree], Cos[Rational[216, 5] Degree], 
        0}, {-Cos[Rational[216, 5] Degree], Sin[Rational[216, 5] Degree], 
        0}}, {{-0.6845471059286887, 0.7289686274214116, 
        0}, {-0.7289686274214116, 0.6845471059286887, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[216, 5] Degree], Sin[Rational[216, 5] Degree], 
        0}, {-Cos[Rational[198, 5] Degree], Sin[Rational[198, 5] Degree], 
        0}}, {{-0.7289686274214116, 0.6845471059286887, 
        0}, {-0.7705132427757891, 0.6374239897486897, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[198, 5] Degree], Sin[Rational[198, 5] Degree], 
        0}, {Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        0}}, {{-0.7705132427757891, 0.6374239897486897, 
        0}, {-0.8090169943749475, 0.5877852522924731, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
         Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {-
        Cos[Rational[162, 5] Degree], Sin[Rational[162, 5] Degree], 
        0}}, {{-0.8090169943749475, 0.5877852522924731, 
        0}, {-0.8443279255020151, 0.5358267949789967, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[162, 5] Degree], Sin[Rational[162, 5] Degree], 
        0}, {-Cos[Rational[144, 5] Degree], Sin[Rational[144, 5] Degree], 
        0}}, {{-0.8443279255020151, 0.5358267949789967, 
        0}, {-0.8763066800438636, 0.4817536741017153, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[144, 5] Degree], Sin[Rational[144, 5] Degree], 
        0}, {-Cos[Rational[126, 5] Degree], Sin[Rational[126, 5] Degree], 
        0}}, {{-0.8763066800438636, 0.4817536741017153, 
        0}, {-0.9048270524660196, 0.42577929156507266`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[126, 5] Degree], Sin[Rational[126, 5] Degree], 
        0}, {-Cos[Rational[108, 5] Degree], Sin[Rational[108, 5] Degree], 
        0}}, {{-0.9048270524660196, 0.42577929156507266`, 
        0}, {-0.9297764858882515, 0.368124552684678, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[108, 5] Degree], Sin[Rational[108, 5] Degree], 
        0}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 
        0}}, {{-0.9297764858882515, 0.368124552684678, 
        0}, {-0.9510565162951535, 0.30901699437494745`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2]), 0}, {-
        Cos[Rational[72, 5] Degree], Sin[Rational[72, 5] Degree], 
        0}}, {{-0.9510565162951535, 0.30901699437494745`, 
        0}, {-0.9685831611286311, 0.2486898871648548, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[72, 5] Degree], Sin[Rational[72, 5] Degree], 
        0}, {-Cos[Rational[54, 5] Degree], Sin[Rational[54, 5] Degree], 
        0}}, {{-0.9685831611286311, 0.2486898871648548, 
        0}, {-0.9822872507286887, 0.18738131458572463`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[54, 5] Degree], Sin[Rational[54, 5] Degree], 
        0}, {-Cos[Rational[36, 5] Degree], Sin[Rational[36, 5] Degree], 
        0}}, {{-0.9822872507286887, 0.18738131458572463`, 
        0}, {-0.9921147013144779, 0.12533323356430426`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[36, 5] Degree], Sin[Rational[36, 5] Degree], 
        0}, {-Cos[Rational[18, 5] Degree], Sin[Rational[18, 5] Degree], 
        0}}, {{-0.9921147013144779, 0.12533323356430426`, 
        0}, {-0.9980267284282716, 0.06279051952931337, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[18, 5] Degree], Sin[Rational[18, 5] Degree], 
        0}, {-1, 0, 0}}, {{-0.9980267284282716, 0.06279051952931337, 0}, {-1, 
       0, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-1, 0, 
       0}, {-Cos[Rational[18, 5] Degree], -Sin[Rational[18, 5] Degree], 
        0}}, {{-1, 0, 0}, {-0.9980267284282716, -0.06279051952931337, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[18, 5] Degree], -Sin[Rational[18, 5] Degree], 
        0}, {-Cos[Rational[36, 5] Degree], -Sin[Rational[36, 5] Degree], 
        0}}, {{-0.9980267284282716, -0.06279051952931337, 
        0}, {-0.9921147013144779, -0.12533323356430426`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[36, 5] Degree], -Sin[Rational[36, 5] Degree], 
        0}, {-Cos[Rational[54, 5] Degree], -Sin[Rational[54, 5] Degree], 
        0}}, {{-0.9921147013144779, -0.12533323356430426`, 
        0}, {-0.9822872507286887, -0.18738131458572463`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[54, 5] Degree], -Sin[Rational[54, 5] Degree], 
        0}, {-Cos[Rational[72, 5] Degree], -Sin[Rational[72, 5] Degree], 
        0}}, {{-0.9822872507286887, -0.18738131458572463`, 
        0}, {-0.9685831611286311, -0.2486898871648548, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[72, 5] Degree], -Sin[Rational[72, 5] Degree], 
        0}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), 
        0}}, {{-0.9685831611286311, -0.2486898871648548, 
        0}, {-0.9510565162951535, -0.30901699437494745`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), 0}, {-
        Cos[Rational[108, 5] Degree], -Sin[Rational[108, 5] Degree], 
        0}}, {{-0.9510565162951535, -0.30901699437494745`, 
        0}, {-0.9297764858882515, -0.368124552684678, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[108, 5] Degree], -Sin[Rational[108, 5] Degree], 
        0}, {-Cos[Rational[126, 5] Degree], -Sin[Rational[126, 5] Degree], 
        0}}, {{-0.9297764858882515, -0.368124552684678, 
        0}, {-0.9048270524660196, -0.42577929156507266`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[126, 5] Degree], -Sin[Rational[126, 5] Degree], 
        0}, {-Cos[Rational[144, 5] Degree], -Sin[Rational[144, 5] Degree], 
        0}}, {{-0.9048270524660196, -0.42577929156507266`, 
        0}, {-0.8763066800438636, -0.4817536741017153, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[144, 5] Degree], -Sin[Rational[144, 5] Degree], 
        0}, {-Cos[Rational[162, 5] Degree], -Sin[Rational[162, 5] Degree], 
        0}}, {{-0.8763066800438636, -0.4817536741017153, 
        0}, {-0.8443279255020151, -0.5358267949789967, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[162, 5] Degree], -Sin[Rational[162, 5] Degree], 
        0}, {Rational[1, 4] (-1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
        0}}, {{-0.8443279255020151, -0.5358267949789967, 
        0}, {-0.8090169943749475, -0.5877852522924731, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Rational[1, 4] (-1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {-
        Cos[Rational[198, 5] Degree], -Sin[Rational[198, 5] Degree], 
        0}}, {{-0.8090169943749475, -0.5877852522924731, 
        0}, {-0.7705132427757891, -0.6374239897486897, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[198, 5] Degree], -Sin[Rational[198, 5] Degree], 
        0}, {-Cos[Rational[216, 5] Degree], -Sin[Rational[216, 5] Degree], 
        0}}, {{-0.7705132427757891, -0.6374239897486897, 
        0}, {-0.7289686274214116, -0.6845471059286887, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Cos[Rational[216, 5] Degree], -Sin[Rational[216, 5] Degree], 
        0}, {-Sin[Rational[216, 5] Degree], -Cos[Rational[216, 5] Degree], 
        0}}, {{-0.7289686274214116, -0.6845471059286887, 
        0}, {-0.6845471059286887, -0.7289686274214116, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[216, 5] Degree], -Cos[Rational[216, 5] Degree], 
        0}, {-Sin[Rational[198, 5] Degree], -Cos[Rational[198, 5] Degree], 
        0}}, {{-0.6845471059286887, -0.7289686274214116, 
        0}, {-0.6374239897486897, -0.7705132427757891, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[198, 5] Degree], -Cos[Rational[198, 5] Degree], 
        0}, {-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
        0}}, {{-0.6374239897486897, -0.7705132427757891, 
        0}, {-0.5877852522924731, -0.8090169943749475, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 0}, {-
        Sin[Rational[162, 5] Degree], -Cos[Rational[162, 5] Degree], 
        0}}, {{-0.5877852522924731, -0.8090169943749475, 
        0}, {-0.5358267949789967, -0.8443279255020151, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[162, 5] Degree], -Cos[Rational[162, 5] Degree], 
        0}, {-Sin[Rational[144, 5] Degree], -Cos[Rational[144, 5] Degree], 
        0}}, {{-0.5358267949789967, -0.8443279255020151, 
        0}, {-0.4817536741017153, -0.8763066800438636, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[144, 5] Degree], -Cos[Rational[144, 5] Degree], 
        0}, {-Sin[Rational[126, 5] Degree], -Cos[Rational[126, 5] Degree], 
        0}}, {{-0.4817536741017153, -0.8763066800438636, 
        0}, {-0.42577929156507266`, -0.9048270524660196, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[126, 5] Degree], -Cos[Rational[126, 5] Degree], 
        0}, {-Sin[Rational[108, 5] Degree], -Cos[Rational[108, 5] Degree], 
        0}}, {{-0.42577929156507266`, -0.9048270524660196, 
        0}, {-0.368124552684678, -0.9297764858882515, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[108, 5] Degree], -Cos[Rational[108, 5] Degree], 
        0}, {Rational[1, 4] (1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], 0}}, {{-0.368124552684678, -0.9297764858882515, 
        0}, {-0.30901699437494745`, -0.9510565162951535, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Rational[1, 4] (1 - 5^
         Rational[1, 2]), -(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
         Rational[1, 2], 0}, {-Sin[Rational[72, 5] Degree], -
        Cos[Rational[72, 5] Degree], 
        0}}, {{-0.30901699437494745`, -0.9510565162951535, 
        0}, {-0.2486898871648548, -0.9685831611286311, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[72, 5] Degree], -Cos[Rational[72, 5] Degree], 
        0}, {-Sin[Rational[54, 5] Degree], -Cos[Rational[54, 5] Degree], 
        0}}, {{-0.2486898871648548, -0.9685831611286311, 
        0}, {-0.18738131458572463`, -0.9822872507286887, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[54, 5] Degree], -Cos[Rational[54, 5] Degree], 
        0}, {-Sin[Rational[36, 5] Degree], -Cos[Rational[36, 5] Degree], 
        0}}, {{-0.18738131458572463`, -0.9822872507286887, 
        0}, {-0.12533323356430426`, -0.9921147013144779, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[36, 5] Degree], -Cos[Rational[36, 5] Degree], 
        0}, {-Sin[Rational[18, 5] Degree], -Cos[Rational[18, 5] Degree], 
        0}}, {{-0.12533323356430426`, -0.9921147013144779, 
        0}, {-0.06279051952931337, -0.9980267284282716, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{-Sin[Rational[18, 5] Degree], -Cos[Rational[18, 5] Degree], 
        0}, {0, -1, 0}}, {{-0.06279051952931337, -0.9980267284282716, 0}, {
       0, -1, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{0, -1, 0}, {
       Sin[Rational[18, 5] Degree], -Cos[Rational[18, 5] Degree], 0}}, {{
       0, -1, 0}, {0.06279051952931337, -0.9980267284282716, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[18, 5] Degree], -Cos[Rational[18, 5] Degree], 0}, {
       Sin[Rational[36, 5] Degree], -Cos[Rational[36, 5] Degree], 0}}, {{
       0.06279051952931337, -0.9980267284282716, 0}, {
       0.12533323356430426`, -0.9921147013144779, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[36, 5] Degree], -Cos[Rational[36, 5] Degree], 0}, {
       Sin[Rational[54, 5] Degree], -Cos[Rational[54, 5] Degree], 0}}, {{
       0.12533323356430426`, -0.9921147013144779, 0}, {
       0.18738131458572463`, -0.9822872507286887, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[54, 5] Degree], -Cos[Rational[54, 5] Degree], 0}, {
       Sin[Rational[72, 5] Degree], -Cos[Rational[72, 5] Degree], 0}}, {{
       0.18738131458572463`, -0.9822872507286887, 0}, {
       0.2486898871648548, -0.9685831611286311, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[72, 5] Degree], -Cos[Rational[72, 5] Degree], 0}, {
       Rational[1, 4] (-1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}}, {{
       0.2486898871648548, -0.9685831611286311, 0}, {
       0.30901699437494745`, -0.9510565162951535, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Rational[1, 4] (-1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {
       Sin[Rational[108, 5] Degree], -Cos[Rational[108, 5] Degree], 0}}, {{
       0.30901699437494745`, -0.9510565162951535, 0}, {
       0.368124552684678, -0.9297764858882515, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[108, 5] Degree], -Cos[Rational[108, 5] Degree], 
        0}, {Sin[Rational[126, 5] Degree], -Cos[Rational[126, 5] Degree], 
        0}}, {{0.368124552684678, -0.9297764858882515, 0}, {
       0.42577929156507266`, -0.9048270524660196, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[126, 5] Degree], -Cos[Rational[126, 5] Degree], 
        0}, {Sin[Rational[144, 5] Degree], -Cos[Rational[144, 5] Degree], 
        0}}, {{0.42577929156507266`, -0.9048270524660196, 0}, {
       0.4817536741017153, -0.8763066800438636, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[144, 5] Degree], -Cos[Rational[144, 5] Degree], 
        0}, {Sin[Rational[162, 5] Degree], -Cos[Rational[162, 5] Degree], 
        0}}, {{0.4817536741017153, -0.8763066800438636, 0}, {
       0.5358267949789967, -0.8443279255020151, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[162, 5] Degree], -Cos[Rational[162, 5] Degree], 
        0}, {(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 0}}, {{
       0.5358267949789967, -0.8443279255020151, 0}, {
       0.5877852522924731, -0.8090169943749475, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 0}, {
       Sin[Rational[198, 5] Degree], -Cos[Rational[198, 5] Degree], 0}}, {{
       0.5877852522924731, -0.8090169943749475, 0}, {
       0.6374239897486897, -0.7705132427757891, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[198, 5] Degree], -Cos[Rational[198, 5] Degree], 
        0}, {Sin[Rational[216, 5] Degree], -Cos[Rational[216, 5] Degree], 
        0}}, {{0.6374239897486897, -0.7705132427757891, 0}, {
       0.6845471059286887, -0.7289686274214116, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Sin[Rational[216, 5] Degree], -Cos[Rational[216, 5] Degree], 
        0}, {Cos[Rational[216, 5] Degree], -Sin[Rational[216, 5] Degree], 
        0}}, {{0.6845471059286887, -0.7289686274214116, 0}, {
       0.7289686274214116, -0.6845471059286887, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[216, 5] Degree], -Sin[Rational[216, 5] Degree], 
        0}, {Cos[Rational[198, 5] Degree], -Sin[Rational[198, 5] Degree], 
        0}}, {{0.7289686274214116, -0.6845471059286887, 0}, {
       0.7705132427757891, -0.6374239897486897, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[198, 5] Degree], -Sin[Rational[198, 5] Degree], 
        0}, {Rational[1, 4] (1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}}, {{
       0.7705132427757891, -0.6374239897486897, 0}, {
       0.8090169943749475, -0.5877852522924731, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Rational[1, 4] (1 + 
         5^Rational[1, 2]), -(Rational[5, 8] + 
          Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 0}, {
       Cos[Rational[162, 5] Degree], -Sin[Rational[162, 5] Degree], 0}}, {{
       0.8090169943749475, -0.5877852522924731, 0}, {
       0.8443279255020151, -0.5358267949789967, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[162, 5] Degree], -Sin[Rational[162, 5] Degree], 
        0}, {Cos[Rational[144, 5] Degree], -Sin[Rational[144, 5] Degree], 
        0}}, {{0.8443279255020151, -0.5358267949789967, 0}, {
       0.8763066800438636, -0.4817536741017153, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[144, 5] Degree], -Sin[Rational[144, 5] Degree], 
        0}, {Cos[Rational[126, 5] Degree], -Sin[Rational[126, 5] Degree], 
        0}}, {{0.8763066800438636, -0.4817536741017153, 0}, {
       0.9048270524660196, -0.42577929156507266`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[126, 5] Degree], -Sin[Rational[126, 5] Degree], 
        0}, {Cos[Rational[108, 5] Degree], -Sin[Rational[108, 5] Degree], 
        0}}, {{0.9048270524660196, -0.42577929156507266`, 0}, {
       0.9297764858882515, -0.368124552684678, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[108, 5] Degree], -Sin[Rational[108, 5] Degree], 
        0}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), 0}}, {{
       0.9297764858882515, -0.368124552684678, 0}, {
       0.9510565162951535, -0.30901699437494745`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
        Rational[1, 2], Rational[1, 4] (1 - 5^Rational[1, 2]), 0}, {
       Cos[Rational[72, 5] Degree], -Sin[Rational[72, 5] Degree], 0}}, {{
       0.9510565162951535, -0.30901699437494745`, 0}, {
       0.9685831611286311, -0.2486898871648548, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[72, 5] Degree], -Sin[Rational[72, 5] Degree], 0}, {
       Cos[Rational[54, 5] Degree], -Sin[Rational[54, 5] Degree], 0}}, {{
       0.9685831611286311, -0.2486898871648548, 0}, {
       0.9822872507286887, -0.18738131458572463`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[54, 5] Degree], -Sin[Rational[54, 5] Degree], 0}, {
       Cos[Rational[36, 5] Degree], -Sin[Rational[36, 5] Degree], 0}}, {{
       0.9822872507286887, -0.18738131458572463`, 0}, {
       0.9921147013144779, -0.12533323356430426`, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[36, 5] Degree], -Sin[Rational[36, 5] Degree], 0}, {
       Cos[Rational[18, 5] Degree], -Sin[Rational[18, 5] Degree], 0}}, {{
       0.9921147013144779, -0.12533323356430426`, 0}, {
       0.9980267284282716, -0.06279051952931337, 0}}]]}, 
   {RGBColor[1, 1, 0], Thickness[0.007], 
    Line3DBox[
     NCache[{{Cos[Rational[18, 5] Degree], -Sin[Rational[18, 5] Degree], 0}, {
       1, 0, 0}}, {{0.9980267284282716, -0.06279051952931337, 0}, {1, 0, 
       0}}]]}, 
   {RGBColor[0, 1, 0], EdgeForm[Thickness[Tiny]], 
    Polygon3DBox[{{-1, 1, 0.25}, {1, 1, 0.25}, {
      1, -1, 0.25}, {-1, -1, 0.25}}]}, 
   {RGBColor[0.88, 1, 0.88], EdgeForm[Thickness[Tiny]], 
    Polygon3DBox[{{-1, 1, 1}, {1, 1, 1}, {1, -1, 1}, {-1, -1, 1}}]}, 
   {Thickness[0.005], 
    Line3DBox[{{0, 0, 0}, {1.590990257669732, 1.590990257669732, 0}}], 
    Line3DBox[{{0, 0, 0}, {-0.17677669529663687`, 0.17677669529663687`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.25, 1., 0}, {1.310323930064653, 1.0765148778399132`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.310323930064653, 1.0765148778399132`, 0}, {
      1.3654766102074016`, 1.148781243269858, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.3654766102074016`, 1.148781243269858, 0}, {
      1.4152403779965854`, 1.2165138939608444`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.4152403779965854`, 1.2165138939608444`, 0}, {
      1.4594188385756437`, 1.2794455200846997`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.4594188385756437`, 1.2794455200846997`, 0}, {
      1.4978376397438893`, 1.3373277592638377`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.4978376397438893`, 1.3373277592638377`, 0}, {
      1.5303451600449922`, 1.3899321767440989`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.5303451600449922`, 1.3899321767440989`, 0}, {
      1.5568131071475972`, 1.4370511669223605`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.5568131071475972`, 1.4370511669223605`, 0}, {
      1.5771370241565448`, 1.4784987726710077`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.5771370241565448`, 1.4784987726710077`, 0}, {
      1.5912367018565154`, 1.514111419225761, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.5912367018565154`, 1.514111419225761, 0}, {
      1.5990564952611575`, 1.543748559740539, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.5990564952611575`, 1.543748559740539, 0}, {
      1.6005655432184263`, 1.5672932299616513`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.6005655432184263`, 1.5672932299616513`, 0}, {
      1.5957578902054532`, 1.5846525098322726`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.5957578902054532`, 1.5846525098322726`, 0}, {
      1.5846525098322726`, 1.5957578902054532`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.5846525098322726`, 1.5957578902054532`, 0}, {
      1.5672932299616513`, 1.6005655432184263`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.5672932299616513`, 1.6005655432184263`, 0}, {
      1.543748559740539, 1.5990564952611575`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.543748559740539, 1.5990564952611575`, 0}, {
      1.514111419225761, 1.5912367018565154`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.514111419225761, 1.5912367018565154`, 0}, {
      1.4784987726710077`, 1.5771370241565448`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.4784987726710077`, 1.5771370241565448`, 0}, {
      1.4370511669223605`, 1.5568131071475972`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.4370511669223605`, 1.5568131071475972`, 0}, {
      1.3899321767440989`, 1.5303451600449922`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.3899321767440989`, 1.5303451600449922`, 0}, {
      1.3373277592638377`, 1.4978376397438893`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.3373277592638377`, 1.4978376397438893`, 0}, {
      1.2794455200846997`, 1.4594188385756437`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.2794455200846997`, 1.4594188385756437`, 0}, {
      1.2165138939608444`, 1.4152403779965854`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.2165138939608444`, 1.4152403779965854`, 0}, {
      1.148781243269858, 1.3654766102074016`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.148781243269858, 1.3654766102074016`, 0}, {
      1.0765148778399132`, 1.310323930064653, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.0765148778399132`, 1.310323930064653, 0}, {1., 1.25, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1., 1.25, 0}, {0.9195385790166298, 1.184742891006026, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.9195385790166298, 1.184742891006026, 0}, {
      0.8354481593590976, 1.1148101430787931`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.8354481593590976, 1.1148101430787931`, 0}, {
      0.7480606074965329, 1.0404777488251362`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.7480606074965329, 1.0404777488251362`, 0}, {
      0.6577208021725626, 0.962039064245934, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.6577208021725626, 0.962039064245934, 0}, {
      0.5647852733264692, 0.8798036509939944, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.5647852733264692, 0.8798036509939944, 0}, {
      0.469620795032404, 0.7940960546756364, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.469620795032404, 0.7940960546756364, 0}, {
      0.3726029380096787, 0.7052545240174519, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.3726029380096787, 0.7052545240174519, 0}, {
      0.27411458741671946`, 0.6136296759531142, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.27411458741671946`, 0.6136296759531142, 0}, {
      0.17454443177826928`, 0.5195831118985222, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.17454443177826928`, 0.5195831118985222, 0}, {
      0.07428542900935597, 0.4234859906762112, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{
      0.07428542900935597, 0.4234859906762112, 0}, {-0.02626674441007304, 
       0.32571756372104665`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.02626674441007304, 0.32571756372104665`, 
       0}, {-0.12671525498944936`, 0.22666367834807577`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.12671525498944936`, 0.22666367834807577`, 
       0}, {-0.22666367834807577`, 0.12671525498944936`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.22666367834807577`, 0.12671525498944936`, 
       0}, {-0.32571756372104665`, 0.02626674441007304, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.32571756372104665`, 0.02626674441007304, 
       0}, {-0.4234859906762112, -0.07428542900935597, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.4234859906762112, -0.07428542900935597, 
       0}, {-0.5195831118985222, -0.17454443177826928`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.5195831118985222, -0.17454443177826928`, 
       0}, {-0.6136296759531142, -0.27411458741671946`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.6136296759531142, -0.27411458741671946`, 
       0}, {-0.7052545240174519, -0.3726029380096787, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.7052545240174519, -0.3726029380096787, 
       0}, {-0.7940960546756364, -0.469620795032404, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.7940960546756364, -0.469620795032404, 
       0}, {-0.8798036509939944, -0.5647852733264692, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.8798036509939944, -0.5647852733264692, 
       0}, {-0.962039064245934, -0.6577208021725626, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.962039064245934, -0.6577208021725626, 
       0}, {-1.0404777488251362`, -0.7480606074965329, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.0404777488251362`, -0.7480606074965329, 
       0}, {-1.1148101430787931`, -0.8354481593590976, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.1148101430787931`, -0.8354481593590976, 
       0}, {-1.184742891006026, -0.9195385790166298, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.184742891006026, -0.9195385790166298, 0}, {-1.25, -1., 
       0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.25, -1., 0}, {-1.310323930064653, -1.0765148778399132`, 
       0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.310323930064653, -1.0765148778399132`, 
       0}, {-1.3654766102074016`, -1.148781243269858, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.3654766102074016`, -1.148781243269858, 
       0}, {-1.4152403779965854`, -1.2165138939608444`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.4152403779965854`, -1.2165138939608444`, 
       0}, {-1.4594188385756437`, -1.2794455200846997`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.4594188385756437`, -1.2794455200846997`, 
       0}, {-1.4978376397438893`, -1.3373277592638377`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.4978376397438893`, -1.3373277592638377`, 
       0}, {-1.5303451600449922`, -1.3899321767440989`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.5303451600449922`, -1.3899321767440989`, 
       0}, {-1.5568131071475972`, -1.4370511669223605`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.5568131071475972`, -1.4370511669223605`, 
       0}, {-1.5771370241565448`, -1.4784987726710077`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.5771370241565448`, -1.4784987726710077`, 
       0}, {-1.5912367018565154`, -1.514111419225761, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.5912367018565154`, -1.514111419225761, 
       0}, {-1.5990564952611575`, -1.543748559740539, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.5990564952611575`, -1.543748559740539, 
       0}, {-1.6005655432184263`, -1.5672932299616513`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.6005655432184263`, -1.5672932299616513`, 
       0}, {-1.5957578902054532`, -1.5846525098322726`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.5957578902054532`, -1.5846525098322726`, 
       0}, {-1.5846525098322726`, -1.5957578902054532`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.5846525098322726`, -1.5957578902054532`, 
       0}, {-1.5672932299616513`, -1.6005655432184263`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.5672932299616513`, -1.6005655432184263`, 
       0}, {-1.543748559740539, -1.5990564952611575`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.543748559740539, -1.5990564952611575`, 
       0}, {-1.514111419225761, -1.5912367018565154`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.514111419225761, -1.5912367018565154`, 
       0}, {-1.4784987726710077`, -1.5771370241565448`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.4784987726710077`, -1.5771370241565448`, 
       0}, {-1.4370511669223605`, -1.5568131071475972`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.4370511669223605`, -1.5568131071475972`, 
       0}, {-1.3899321767440989`, -1.5303451600449922`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.3899321767440989`, -1.5303451600449922`, 
       0}, {-1.3373277592638377`, -1.4978376397438893`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.3373277592638377`, -1.4978376397438893`, 
       0}, {-1.2794455200846997`, -1.4594188385756437`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.2794455200846997`, -1.4594188385756437`, 
       0}, {-1.2165138939608444`, -1.4152403779965854`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.2165138939608444`, -1.4152403779965854`, 
       0}, {-1.148781243269858, -1.3654766102074016`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.148781243269858, -1.3654766102074016`, 
       0}, {-1.0765148778399132`, -1.310323930064653, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1.0765148778399132`, -1.310323930064653, 0}, {-1., -1.25, 
       0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-1., -1.25, 0}, {-0.9195385790166298, -1.184742891006026, 
       0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.9195385790166298, -1.184742891006026, 
       0}, {-0.8354481593590976, -1.1148101430787931`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.8354481593590976, -1.1148101430787931`, 
       0}, {-0.7480606074965329, -1.0404777488251362`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.7480606074965329, -1.0404777488251362`, 
       0}, {-0.6577208021725626, -0.962039064245934, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.6577208021725626, -0.962039064245934, 
       0}, {-0.5647852733264692, -0.8798036509939944, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.5647852733264692, -0.8798036509939944, 
       0}, {-0.469620795032404, -0.7940960546756364, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.469620795032404, -0.7940960546756364, 
       0}, {-0.3726029380096787, -0.7052545240174519, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.3726029380096787, -0.7052545240174519, 
       0}, {-0.27411458741671946`, -0.6136296759531142, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.27411458741671946`, -0.6136296759531142, 
       0}, {-0.17454443177826928`, -0.5195831118985222, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.17454443177826928`, -0.5195831118985222, 
       0}, {-0.07428542900935597, -0.4234859906762112, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{-0.07428542900935597, -0.4234859906762112, 0}, {
      0.02626674441007304, -0.32571756372104665`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.02626674441007304, -0.32571756372104665`, 0}, {
      0.12671525498944936`, -0.22666367834807577`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.12671525498944936`, -0.22666367834807577`, 0}, {
      0.22666367834807577`, -0.12671525498944936`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.22666367834807577`, -0.12671525498944936`, 0}, {
      0.32571756372104665`, -0.02626674441007304, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.32571756372104665`, -0.02626674441007304, 0}, {
      0.4234859906762112, 0.07428542900935597, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.4234859906762112, 0.07428542900935597, 0}, {
      0.5195831118985222, 0.17454443177826928`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.5195831118985222, 0.17454443177826928`, 0}, {
      0.6136296759531142, 0.27411458741671946`, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.6136296759531142, 0.27411458741671946`, 0}, {
      0.7052545240174519, 0.3726029380096787, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.7052545240174519, 0.3726029380096787, 0}, {
      0.7940960546756364, 0.469620795032404, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.7940960546756364, 0.469620795032404, 0}, {
      0.8798036509939944, 0.5647852733264692, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.8798036509939944, 0.5647852733264692, 0}, {
      0.962039064245934, 0.6577208021725626, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{0.962039064245934, 0.6577208021725626, 0}, {
      1.0404777488251362`, 0.7480606074965329, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.0404777488251362`, 0.7480606074965329, 0}, {
      1.1148101430787931`, 0.8354481593590976, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.1148101430787931`, 0.8354481593590976, 0}, {
      1.184742891006026, 0.9195385790166298, 0}}]}, 
   {GrayLevel[0.4], Thickness[0.005], 
    Line3DBox[{{1.184742891006026, 0.9195385790166298, 0}, {1.25, 1., 0}}]}},
  AutomaticImageSize->True,
  Axes->False,
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 14},
  BoxRatios->Automatic,
  Boxed->False,
  ImageSize->{359.9894857120552, 321.9769701497035},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->All,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  ViewPoint->{0.7837035318095736, -4.102536195783925, 1.5984384681657127`},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{
  3.5630465521797495`*^9, 3.5630466125362554`*^9, 3.563046731314864*^9, 
   3.5630468822919292`*^9, 3.563047261540596*^9, 3.5630473490411496`*^9, 
   3.5630474031108446`*^9, 3.5630478516584325`*^9, {3.5630480368307576`*^9, 
   3.5630480603555984`*^9}, 3.563048104768877*^9, 3.56304836298213*^9, 
   3.563048404759004*^9, 3.563048588905327*^9, 3.5630486704402695`*^9, 
   3.5630487533232155`*^9, {3.5630499329276896`*^9, 3.5630499472173147`*^9}, 
   3.5630499857493825`*^9, 3.563050042098282*^9, 3.563050077316743*^9, 
   3.563106573353532*^9, 3.563107642713743*^9, 3.5631076837506137`*^9, 
   3.5631110720424833`*^9, 3.5631115401692877`*^9, 3.563111598918988*^9, 
   3.5631116391906567`*^9, 3.5631118214397707`*^9, 3.5631119494375887`*^9, 
   3.563112784091428*^9, {3.5631129839077697`*^9, 3.563113002315802*^9}, 
   3.563113062778303*^9, 3.5631136944218063`*^9, 3.5631277472706676`*^9, 
   3.563128122207726*^9, 3.5631281534077806`*^9, 3.5631282389895315`*^9, 
   3.563128421320475*^9, 3.563128451958929*^9, 3.563128794043862*^9, 
   3.563128826460719*^9, 3.5631289434921246`*^9, 3.5631293701060734`*^9, {
   3.563129454611422*^9, 3.5631294743922567`*^9}, 3.563129698767451*^9, 
   3.5631297799343934`*^9, 3.563129873004157*^9, 3.563129954867101*^9, {
   3.563130053197674*^9, 3.5631300680800996`*^9}, 3.5631304712000103`*^9, 
   3.5631307469304943`*^9, 3.5631307769449472`*^9, 3.5633730064431467`*^9, 
   3.5633731022532806`*^9, 3.5633731485833454`*^9, 3.563373218813444*^9, 
   3.563553505166424*^9, 3.564783556134794*^9, 3.564843301189065*^9, 
   3.5648434945358047`*^9, 3.5648435340038743`*^9, {3.56484363988126*^9, 
   3.56484366821091*^9}, 3.5648439565462165`*^9, 3.5648440390079613`*^9, 
   3.564850817812276*^9, 3.564850864347158*^9, 3.56485091674765*^9, 
   3.564851551715565*^9, 3.564852507934845*^9, 3.5648526025022106`*^9, 
   3.5648526547623024`*^9, 3.567106143076501*^9, 3.5844775221333866`*^9}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Action of the matrix ellipse -- 2 definitions in axis \
aligned position\"\>"], "Print",
 CellChangeTimes->{
  3.5629550986360693`*^9, 3.5629552384747143`*^9, 3.562955397017793*^9, {
   3.5629554461890793`*^9, 3.562955473286327*^9}, 3.562955546996456*^9, 
   3.5629555878685284`*^9, 3.562955627133797*^9, {3.5629556758214827`*^9, 
   3.5629556912499104`*^9}, 3.562955749516012*^9, 3.5629558033673067`*^9, 
   3.562955842694976*^9, 3.562963384191823*^9, 3.562963419042284*^9, 
   3.5630191524226074`*^9, 3.5630192141363153`*^9, {3.5630192856000414`*^9, 
   3.563019310185684*^9}, {3.5630193541153617`*^9, 3.5630193621181755`*^9}, 
   3.563019561034125*^9, {3.563020346167904*^9, 3.563020394621589*^9}, 
   3.563020527315422*^9, 3.5630205861275253`*^9, 3.563020631508005*^9, {
   3.5630206764048843`*^9, 3.563020718712158*^9}, 3.563020757727827*^9, {
   3.56302081655553*^9, 3.5630208254007454`*^9}, 3.5630209318085327`*^9, {
   3.5630218360797205`*^9, 3.563021863426569*^9}, {3.5630219037370396`*^9, 
   3.563021918635066*^9}, {3.5630219850131826`*^9, 3.5630220960697775`*^9}, 
   3.56302247810887*^9, 3.5630225147597356`*^9, {3.5630227914389234`*^9, 
   3.5630228139497633`*^9}, {3.563022860718645*^9, 3.563022961978423*^9}, 
   3.5630244252141933`*^9, {3.56302450898634*^9, 3.563024538470392*^9}, 
   3.563024573898054*^9, {3.5630246048485084`*^9, 3.5630246393713694`*^9}, {
   3.563024669666622*^9, 3.5630246931290636`*^9}, 3.5630247649359894`*^9, 
   3.5630250207452393`*^9, 3.563025263450465*^9, 3.563027130305744*^9, 
   3.563027228117916*^9, {3.5630274502935066`*^9, 3.5630274739899483`*^9}, {
   3.5630277148231707`*^9, 3.5630277394712143`*^9}, {3.5630294341021905`*^9, 
   3.5630294574242315`*^9}, 3.563029489903489*^9, 3.5630295392931757`*^9, 
   3.5630296129097047`*^9, 3.5630297851964073`*^9, {3.5630298821349773`*^9, 
   3.5630298996070085`*^9}, 3.563044604979759*^9, 3.5630450931871867`*^9, 
   3.563045157209699*^9, 3.5630452052109833`*^9, 3.563045235787037*^9, 
   3.563045378652088*^9, {3.5630454110377455`*^9, 3.5630454334393845`*^9}, 
   3.5630456828994226`*^9, 3.563045781709996*^9, 3.5630458374644938`*^9, 
   3.5630458690857496`*^9, 3.5630462941864967`*^9, 3.56304645572478*^9, 
   3.5630465521329494`*^9, 3.5630466124582553`*^9, 3.5630467308312635`*^9, 
   3.563046882213929*^9, 3.5630472614469957`*^9, 3.563047348963149*^9, 
   3.5630474030328445`*^9, 3.563047851564832*^9, {3.5630480367371573`*^9, 
   3.563048060277599*^9}, 3.563048104690877*^9, 3.5630483629041305`*^9, 
   3.5630484046654034`*^9, 3.563048588827327*^9, 3.5630486703622694`*^9, 
   3.563048753229615*^9, {3.5630499328496895`*^9, 3.5630499471237144`*^9}, 
   3.5630499856557827`*^9, 3.563050042004681*^9, 3.563050077238743*^9, 
   3.5631065732665267`*^9, 3.563107642632543*^9, 3.5631076836570134`*^9, 
   3.5631110719644833`*^9, 3.5631115400192876`*^9, 3.563111598825388*^9, 
   3.5631116390814567`*^9, 3.56311182131497*^9, 3.563111949317589*^9, 
   3.563112783982228*^9, {3.5631129837985697`*^9, 3.5631130017854013`*^9}, 
   3.5631130626691027`*^9, 3.5631136942970057`*^9, 3.5631277471770678`*^9, 
   3.5631281219113255`*^9, 3.563128153298581*^9, 3.5631282388959312`*^9, 
   3.5631284212424755`*^9, 3.5631284518497286`*^9, 3.563128793934662*^9, 
   3.563128826367119*^9, 3.563128943382924*^9, 3.563129369794073*^9, {
   3.563129454533422*^9, 3.5631294742986565`*^9}, 3.5631296986894507`*^9, 
   3.5631297798251934`*^9, 3.563129872910557*^9, 3.563129954773501*^9, {
   3.563130047488064*^9, 3.563130067580899*^9}, 3.56313047110641*^9, 
   3.5631307464312935`*^9, 3.563130776866947*^9, 3.5633730059831457`*^9, 
   3.5633731021632805`*^9, 3.5633731485033455`*^9, 3.5633732187334433`*^9, 
   3.563553505104024*^9, 3.5647835560879936`*^9, 3.5648433002062635`*^9, 
   3.5648434942862043`*^9, 3.564843533863474*^9, {3.5648436392572594`*^9, 
   3.5648436681173096`*^9}, 3.564843956452616*^9, 3.564844038914361*^9, 
   3.564850817734276*^9, 3.5648508642847576`*^9, 3.56485091665405*^9, 
   3.5648515516219654`*^9, 3.5648525078256445`*^9, 3.5648526023930106`*^9, 
   3.564852654668702*^9, 3.567106143036501*^9, 3.5844775221333866`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Parametric: [x,y] = [\"\>", "\[InvisibleSpace]", "2.25`", 
   "\[InvisibleSpace]", "\<\",Cos[alpha],\"\>", "\[InvisibleSpace]", "0.25`", 
   "\[InvisibleSpace]", "\<\"Sin[alpha]]\"\>"}],
  SequenceForm[
  "Parametric: [x,y] = [", 2.25, ",Cos[alpha],", 0.25, "Sin[alpha]]"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5629550986360693`*^9, 3.5629552384747143`*^9, 3.562955397017793*^9, {
   3.5629554461890793`*^9, 3.562955473286327*^9}, 3.562955546996456*^9, 
   3.5629555878685284`*^9, 3.562955627133797*^9, {3.5629556758214827`*^9, 
   3.5629556912499104`*^9}, 3.562955749516012*^9, 3.5629558033673067`*^9, 
   3.562955842694976*^9, 3.562963384191823*^9, 3.562963419042284*^9, 
   3.5630191524226074`*^9, 3.5630192141363153`*^9, {3.5630192856000414`*^9, 
   3.563019310185684*^9}, {3.5630193541153617`*^9, 3.5630193621181755`*^9}, 
   3.563019561034125*^9, {3.563020346167904*^9, 3.563020394621589*^9}, 
   3.563020527315422*^9, 3.5630205861275253`*^9, 3.563020631508005*^9, {
   3.5630206764048843`*^9, 3.563020718712158*^9}, 3.563020757727827*^9, {
   3.56302081655553*^9, 3.5630208254007454`*^9}, 3.5630209318085327`*^9, {
   3.5630218360797205`*^9, 3.563021863426569*^9}, {3.5630219037370396`*^9, 
   3.563021918635066*^9}, {3.5630219850131826`*^9, 3.5630220960697775`*^9}, 
   3.56302247810887*^9, 3.5630225147597356`*^9, {3.5630227914389234`*^9, 
   3.5630228139497633`*^9}, {3.563022860718645*^9, 3.563022961978423*^9}, 
   3.5630244252141933`*^9, {3.56302450898634*^9, 3.563024538470392*^9}, 
   3.563024573898054*^9, {3.5630246048485084`*^9, 3.5630246393713694`*^9}, {
   3.563024669666622*^9, 3.5630246931290636`*^9}, 3.5630247649359894`*^9, 
   3.5630250207452393`*^9, 3.563025263450465*^9, 3.563027130305744*^9, 
   3.563027228117916*^9, {3.5630274502935066`*^9, 3.5630274739899483`*^9}, {
   3.5630277148231707`*^9, 3.5630277394712143`*^9}, {3.5630294341021905`*^9, 
   3.5630294574242315`*^9}, 3.563029489903489*^9, 3.5630295392931757`*^9, 
   3.5630296129097047`*^9, 3.5630297851964073`*^9, {3.5630298821349773`*^9, 
   3.5630298996070085`*^9}, 3.563044604979759*^9, 3.5630450931871867`*^9, 
   3.563045157209699*^9, 3.5630452052109833`*^9, 3.563045235787037*^9, 
   3.563045378652088*^9, {3.5630454110377455`*^9, 3.5630454334393845`*^9}, 
   3.5630456828994226`*^9, 3.563045781709996*^9, 3.5630458374644938`*^9, 
   3.5630458690857496`*^9, 3.5630462941864967`*^9, 3.56304645572478*^9, 
   3.5630465521329494`*^9, 3.5630466124582553`*^9, 3.5630467308312635`*^9, 
   3.563046882213929*^9, 3.5630472614469957`*^9, 3.563047348963149*^9, 
   3.5630474030328445`*^9, 3.563047851564832*^9, {3.5630480367371573`*^9, 
   3.563048060277599*^9}, 3.563048104690877*^9, 3.5630483629041305`*^9, 
   3.5630484046654034`*^9, 3.563048588827327*^9, 3.5630486703622694`*^9, 
   3.563048753229615*^9, {3.5630499328496895`*^9, 3.5630499471237144`*^9}, 
   3.5630499856557827`*^9, 3.563050042004681*^9, 3.563050077238743*^9, 
   3.5631065732665267`*^9, 3.563107642632543*^9, 3.5631076836570134`*^9, 
   3.5631110719644833`*^9, 3.5631115400192876`*^9, 3.563111598825388*^9, 
   3.5631116390814567`*^9, 3.56311182131497*^9, 3.563111949317589*^9, 
   3.563112783982228*^9, {3.5631129837985697`*^9, 3.5631130017854013`*^9}, 
   3.5631130626691027`*^9, 3.5631136942970057`*^9, 3.5631277471770678`*^9, 
   3.5631281219113255`*^9, 3.563128153298581*^9, 3.5631282388959312`*^9, 
   3.5631284212424755`*^9, 3.5631284518497286`*^9, 3.563128793934662*^9, 
   3.563128826367119*^9, 3.563128943382924*^9, 3.563129369794073*^9, {
   3.563129454533422*^9, 3.5631294742986565`*^9}, 3.5631296986894507`*^9, 
   3.5631297798251934`*^9, 3.563129872910557*^9, 3.563129954773501*^9, {
   3.563130047488064*^9, 3.563130067580899*^9}, 3.56313047110641*^9, 
   3.5631307464312935`*^9, 3.563130776866947*^9, 3.5633730059831457`*^9, 
   3.5633731021632805`*^9, 3.5633731485033455`*^9, 3.5633732187334433`*^9, 
   3.563553505104024*^9, 3.5647835560879936`*^9, 3.5648433002062635`*^9, 
   3.5648434942862043`*^9, 3.564843533863474*^9, {3.5648436392572594`*^9, 
   3.5648436681173096`*^9}, 3.564843956452616*^9, 3.564844038914361*^9, 
   3.564850817734276*^9, 3.5648508642847576`*^9, 3.56485091665405*^9, 
   3.5648515516219654`*^9, 3.5648525078256445`*^9, 3.5648526023930106`*^9, 
   3.564852654668702*^9, 3.567106143036501*^9, 3.5844775221333866`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Implicit: \"\>", "\[InvisibleSpace]", "0.19753086419753085`", 
   "\[InvisibleSpace]", "\<\"x^2 + \"\>", "\[InvisibleSpace]", "16.`", 
   "\[InvisibleSpace]", "\<\"y^2 = 1\"\>"}],
  SequenceForm["Implicit: ", 0.19753086419753085`, "x^2 + ", 16., "y^2 = 1"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5629550986360693`*^9, 3.5629552384747143`*^9, 3.562955397017793*^9, {
   3.5629554461890793`*^9, 3.562955473286327*^9}, 3.562955546996456*^9, 
   3.5629555878685284`*^9, 3.562955627133797*^9, {3.5629556758214827`*^9, 
   3.5629556912499104`*^9}, 3.562955749516012*^9, 3.5629558033673067`*^9, 
   3.562955842694976*^9, 3.562963384191823*^9, 3.562963419042284*^9, 
   3.5630191524226074`*^9, 3.5630192141363153`*^9, {3.5630192856000414`*^9, 
   3.563019310185684*^9}, {3.5630193541153617`*^9, 3.5630193621181755`*^9}, 
   3.563019561034125*^9, {3.563020346167904*^9, 3.563020394621589*^9}, 
   3.563020527315422*^9, 3.5630205861275253`*^9, 3.563020631508005*^9, {
   3.5630206764048843`*^9, 3.563020718712158*^9}, 3.563020757727827*^9, {
   3.56302081655553*^9, 3.5630208254007454`*^9}, 3.5630209318085327`*^9, {
   3.5630218360797205`*^9, 3.563021863426569*^9}, {3.5630219037370396`*^9, 
   3.563021918635066*^9}, {3.5630219850131826`*^9, 3.5630220960697775`*^9}, 
   3.56302247810887*^9, 3.5630225147597356`*^9, {3.5630227914389234`*^9, 
   3.5630228139497633`*^9}, {3.563022860718645*^9, 3.563022961978423*^9}, 
   3.5630244252141933`*^9, {3.56302450898634*^9, 3.563024538470392*^9}, 
   3.563024573898054*^9, {3.5630246048485084`*^9, 3.5630246393713694`*^9}, {
   3.563024669666622*^9, 3.5630246931290636`*^9}, 3.5630247649359894`*^9, 
   3.5630250207452393`*^9, 3.563025263450465*^9, 3.563027130305744*^9, 
   3.563027228117916*^9, {3.5630274502935066`*^9, 3.5630274739899483`*^9}, {
   3.5630277148231707`*^9, 3.5630277394712143`*^9}, {3.5630294341021905`*^9, 
   3.5630294574242315`*^9}, 3.563029489903489*^9, 3.5630295392931757`*^9, 
   3.5630296129097047`*^9, 3.5630297851964073`*^9, {3.5630298821349773`*^9, 
   3.5630298996070085`*^9}, 3.563044604979759*^9, 3.5630450931871867`*^9, 
   3.563045157209699*^9, 3.5630452052109833`*^9, 3.563045235787037*^9, 
   3.563045378652088*^9, {3.5630454110377455`*^9, 3.5630454334393845`*^9}, 
   3.5630456828994226`*^9, 3.563045781709996*^9, 3.5630458374644938`*^9, 
   3.5630458690857496`*^9, 3.5630462941864967`*^9, 3.56304645572478*^9, 
   3.5630465521329494`*^9, 3.5630466124582553`*^9, 3.5630467308312635`*^9, 
   3.563046882213929*^9, 3.5630472614469957`*^9, 3.563047348963149*^9, 
   3.5630474030328445`*^9, 3.563047851564832*^9, {3.5630480367371573`*^9, 
   3.563048060277599*^9}, 3.563048104690877*^9, 3.5630483629041305`*^9, 
   3.5630484046654034`*^9, 3.563048588827327*^9, 3.5630486703622694`*^9, 
   3.563048753229615*^9, {3.5630499328496895`*^9, 3.5630499471237144`*^9}, 
   3.5630499856557827`*^9, 3.563050042004681*^9, 3.563050077238743*^9, 
   3.5631065732665267`*^9, 3.563107642632543*^9, 3.5631076836570134`*^9, 
   3.5631110719644833`*^9, 3.5631115400192876`*^9, 3.563111598825388*^9, 
   3.5631116390814567`*^9, 3.56311182131497*^9, 3.563111949317589*^9, 
   3.563112783982228*^9, {3.5631129837985697`*^9, 3.5631130017854013`*^9}, 
   3.5631130626691027`*^9, 3.5631136942970057`*^9, 3.5631277471770678`*^9, 
   3.5631281219113255`*^9, 3.563128153298581*^9, 3.5631282388959312`*^9, 
   3.5631284212424755`*^9, 3.5631284518497286`*^9, 3.563128793934662*^9, 
   3.563128826367119*^9, 3.563128943382924*^9, 3.563129369794073*^9, {
   3.563129454533422*^9, 3.5631294742986565`*^9}, 3.5631296986894507`*^9, 
   3.5631297798251934`*^9, 3.563129872910557*^9, 3.563129954773501*^9, {
   3.563130047488064*^9, 3.563130067580899*^9}, 3.56313047110641*^9, 
   3.5631307464312935`*^9, 3.563130776866947*^9, 3.5633730059831457`*^9, 
   3.5633731021632805`*^9, 3.5633731485033455`*^9, 3.5633732187334433`*^9, 
   3.563553505104024*^9, 3.5647835560879936`*^9, 3.5648433002062635`*^9, 
   3.5648434942862043`*^9, 3.564843533863474*^9, {3.5648436392572594`*^9, 
   3.5648436681173096`*^9}, 3.564843956452616*^9, 3.564844038914361*^9, 
   3.564850817734276*^9, 3.5648508642847576`*^9, 3.56485091665405*^9, 
   3.5648515516219654`*^9, 3.5648525078256445`*^9, 3.5648526023930106`*^9, 
   3.564852654668702*^9, 3.567106143036501*^9, 3.5844775221333866`*^9}]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw123c8le//OPBzp0lGZfROpdLQIqOh0usIDTSMrFQySpIyUpQRSUlClAqR
vbfs17H3ubNnCMnO3uN3fx6/x/f8c87zcd/nPvd9vcZ1XX+cnboPlQ1W0Gg0
CxYa7X/v//+1gv5/n6YbL5CLywT95eoy2Q+eAMqDglLTlF+0n3vw3vMKmNZ4
Xhyk/DbWo6AnRh38T/hMtFJ+tUGK097zFmxoOH6mlHLAPfO615l60G1tuTeB
ss3qvrqKmLuwg9CK8aJ8kG/XJraA+xCv3ldtTtk+4+yns54PQd/m0KfLlPk0
TxyTzDOFkReH5nZTViDvMRUzzaHPaXx+aomgK/nJf76e/BhyM1x9CygXl4/w
G8Q8gULdla3vKOtHm7cYhlrB1qq7GcqUf00PaN/59gxsAw+pkosEPc5wX4ai
hx2MLcZwOlOuWrPx6pZCe7DluW50krJkvKywS+4LuCL4cvHDAkHPWPU2VTvD
EfZ8ETp2knKeQf6fnNSXIFp5kaN1nqDb+luxbk1ygtodt/w2UmbnTT1TFOUM
rudfqobNEXTVRqOajeGvIebY66jjlLf5zN3VDH4DR0W/SCrMEvS6HL6vNb5v
4crbXU1S0wS9FD+bPX73HpotzDzjpgi6VnNqWKGsO5zT8hncSjlG1z2gIs8d
GP2Tjv0TBH21dPcxZo4H5D/aJaM0RtBfGzl/9U39AOw8cmsCRgn6Y7t2h5cS
XvBz+emD/hGCnttyx+5uoheM2hftMPtH0Lmrn0ptj/WGps9cQpcGCfp01R4L
hZBPoH2PSVgNEHTcYBy1VtAH2iu32gX0E/TPvUMrGAE+YL0fDDp7CbriM1mf
rb6fwe1GwB/RPwR9h94oi4vnVygasu9fbiXoH2z5d/HbfoOn+itFmS0Eff47
bppfEQAc11uvf2om6C7dLCu6zwVAbdvwrS2NVHxMPWvCmAGQE5Z0sKuaoPdw
nT44+SsQXBaP7LMvJugmtzlTvOeD4MXb5vaFQoK+9I6r6QgEQ8p+XkeLAoKe
Y/lKrMghGOzHV71VzSXo9+7YnWhfFwJEyL2Yhgwqn65UmpfwhcKWhU2h/dFU
fJ91Fd0RCwfx7lDgjSLoAvevHvN9HA6ngmzKT0cQdNrTrNCytHDILubJsg4h
6My+VKmNEAHKT/i5MvwI+rvAyAPyCpFw5q4bcf4dQXf7su+Uom40XDq755y/
IUHve+fFWCcXDxHRhjtU7hD0j331SSN68fCisy2IRZ+grzHIdK9xiIf/ShLD
1W8R9JBA315XRjxIhN3MKL9G0O2M1CUrTyWA5SuHl93SBF3mX0eojWgiDN25
vOsXL0Gvf11/2PC/ZHjx4cO1tdwEnaVvzib7eDL82uxxTmQDQT+aZZTPrpYM
Jdbv9B+xEfSyzaOc3zyT4Sp/QjAu0+g3zM60OrKlgG7HhWbPvzT6ld3yUVcW
UoDN5viTDck0uvG15eTMph9wxk8xuyieRh9KMFGqmPoB46LA8jSGRr9q/ECk
YVMaeD/r82CG0ujiQme9Wi6lQZBd7k+FzzT6CWbqGf/cNOCY2fzW2YZGp8u0
rV4Vng4WFjxN62RodE3/5iNCjzLhlbVTKh1o9CA1MX9z10woKl0bZ36KRhde
2mOaFp4JBXz/JirFaXTajZJDwr8zYfze9JDKbho9wTZEqlQpC7on+g1CV9Lo
RV4PO36IZsOUxph848tlkOzzVLswmANy9r9Xfnq2DPKswmyrWRHYt8T+UjRb
Bl292KWMfQhVfDem/G4tA8/HX/asegi3FNZz1EsuA/Po7BpoQuiZjxQOGFyC
QzEM4/nbDBikP7OMU1iC9NbePvGLubB7R9IVdeklOOx1JcZWPRfcl+8FTB1b
gp8Rn1wLDHLBUmV9Mv+uJdi4L8lN2iEX7pTETi1PL8J09I8jtMxcGBHwdxL/
vghiPB8euB7Mg965XULaIwvwj91xV+HafBBNLvqS+WcBCnsXQhx48uHXhODE
ppYFYGtWtjq1Kx+2szgZxBUugOrkJpZvp/Kh2dTH1ePLAsT4JCocNsmHEKX7
sEpmAVgumc3rVeeD5IbFQ9lu81Dtl6O3+1MBsN00iTzjOA/LecYDckEFsGEs
xiD9yTzUV9Fv68YVQIDXQMAXnXkwvPWYzbW4ADpGV1uvF5uH1cIb1nyfLoDm
w2qS8TVzcLNQak29WiF8r/2qtn7jHATqkeTFDUUgNH7jd+LKObjgPSyYvq0I
xAse9ytNz8L19s+8uw4UAd+h/5ytWmdB/IJsacfZIrgaWKb2MHQWloq20jZY
UN8PycqcOTELYge+fpWsKwKfIi4jf40ZaOQqP/DBsxjmDyvoacvPwLPFXy9F
/IvB0c5Ka9PpGbil7cFRGFEMiqeOqBgLzEAQj01QC6MY/js78LvszzTEWl21
TB0uhqC+y1vOmE5DeX3kL4GLJSDu8evtFscpUCzPYI2aKYHXZ7ZNn7OYgtl9
JTMSLKVg9bFD8IHBFNz0kRz7wV4K1349rQ49PwV2hp/nw3eVAmvI0jTJNgXN
N4d5jyuWwsN+C9ZFz0l43aczQPMvhc3ah+vbfSdgcsn48vHTZVDes++D4rsJ
uGS8bc8vuTJQNd3wOclmArbefRrz7EoZpH9c7/Ho5gRwDD4v+a5bBic2WEWF
CkwA01frl8/rMtj0duHGmsBxaOYZP7qrhvq+Xk14+rcx6GqTj/qkWw5HONj/
vHcfg+milvk0o3Jw5boedPvFGBiJH4msMSsHl4c9ydO6Y2Aic2nzpEM52Gs1
eA7vGQPnxTqW3u/lEJb7xpI1ahQcN2nfc/1dDg90705zJ46AgNbdS3maFTC1
5BSu+30Eyt+IR7DdroCqdnmVaM8RkInfv++yYQWc0VgMFjcfgXX1bg45lhUg
HJkctFFiBGwfWL5S/FABzC+8zANG/8CsfuXZreUV4PDbacrDcAiEZwOabY9W
QmX9+3Y7uSEw3LXPxPx0JTxVi7Uw2DUESW2q8bdkKuHQ+LZyvtZBiPEuOSGg
RB1ftUTfcmUQDhrYC540rgSUYd3yTXwA6tZYJ/0KqIQCkcvS/6Z6Ibr8eh2T
hQlXL74X66nuBaN0/q8p65igd7R2U31sLxQlb6v7wMmE4vzHZMCdXghOPf3t
GD8TbsS2ynfV/YU75rk3eMSY4HuuWG1PUg+o22dtOXaTCQeLtsn3GHaDVvGf
8tk4JihV0PgcznVDc1P6FetkJtw272ndvLsbFOTeHhtPY4J3d8vj4+1doPMq
TYiZy4TT00Hlkte6YHxnmL1QDRPO9tNfatE7wcvjJpfJBBNqsborYlsnFGpu
kbGYYULo8WeFE3O/oS5spthsgQnWpjaiNim/QfyLUIHGShImJRz8NA/8hoMT
G++XbCIh83Kf8oVNHTDdKfXtqCgJx452ZYd1tMOnh5YvGBIkuJ9zHE790g5z
3G2hMidI8P9Z1ZbN0Q5dTMYPMSBBTDL598OpX2Dzpr8pSZGEm51cYeYFLWD+
qfqO9B0SGn3hAbdtC9QXxPFdvUeCVOI13djjLVCYlrSkZkxCTS+bADOyGQg1
UeNLZiS4CZaW57g3QYWCVXyrDQlbgtilLa43wJFPsvSXH0gIfdXsw83bADtb
fXas+0iCcuy1R3E/68EiarP1Kx8SPMVsOmrl6qFWQuqjkR8JHF/+eHWI1MEr
x2HdxlDqfn8/TFfrrwUjgbsLOyJIeM/J21kcXAscLrasulEk8Oxd6fD1v1pI
djdwqIwjoWNbWcU6lhp46/Cs+mIaCTG8bp2a2dUQtV1uhVoGCcFf970IeVIN
fK0fvmtlkWA0pfhVZLAKDmypF7vEIGHIPpV7Q91PmBXufdlQTEKneYOKiGIl
KCmteGdfR92Pc+2Rq4wKeLju+vtNDSSsXDsobiRRAYUht+b9G0kofV0g6rK1
HLaZT3J8ayHBZqo/wWawBMSIJ1tkf5OQRLczuK9TAla1cjpfOknYpcgqr1Jb
DGX6BHtfFwn79NwObswqgi2uxJeHPSSMM7Snr7wtAHWOdqudAySIakc1bVzO
h/xjjOGTg9R4f98z89MsHzbXni1RHKKe/9nlh6CVBw7H94dr/iPBybSRdaQy
Fwb7OWNVR0iwKpQ19JXOhdXDfnwXRkkI+/5quFeIAe7xpdybx0lQvGCXvFES
waF9JmyC8lKJDL/ijhyQkRrzK50gQZDnzveI4UzYq2mdoD1Fwgba5wvMugzw
ZY1gbpkmode55M1gVjoEV/2+VEW5rb2xl/ftD1hpW2i6b5bKHxa4J62VCnxb
j16updyTbhhssD8FlkSuij2do+5HquWf40wSLGPvtk3zJDRYbAv0LU4Eb7Ua
rhDKZMMP9viPCeC04i+r8AIJdE2JtzkG8dCttsgWS3ksYuV23zXRINQSvOvD
Igkb7Vvtv4VEwJHiyeMzlGcmfyd8lQmDVbUlKqpLJGztldD2+B0MfQdWWoZR
1l4zfeCF3XeItnL3H6VcFaFQen9bAISNaVSKLZNgKRFXEGT5FSoUFVbcp9zB
fHHWMPEjhOSrS32hfNvohu7eYQ/Q4jO1ZVA2F9k9maPiAqmuroW/KBcEdubt
L7cHoaHAjWOUt5QYGwHrAyh6FWWwSHnd2ZtpOkeU8eqh0Jxlyv/l1Zdd9nuC
Ikc9ts1S3t3cqgfqTmhpY+LQR9nEIMOgqt0NOwzODv2kXDkicuuwhBfW1Gy6
GUc5ttJbx3jGBzVFB2tfUk5+hTrBWX6480GDkhLlPb1xK43ogWg111XLTVmq
hWeFzfcgVKjadZOknj/Y5oGNy8pQ3GISNmRPue+UV7nHnXCcq3J23E8558w9
ac+SSHzr0CpQSo0v/5dK8bcHYnD0DSPvFmU3m+DpZ65xSFoqGQ9R8dma2Dci
Oh2Pp7TjtppR1t8VKLhTKBHTqxZqhqj49nQ8OMOmmYTC4zc9dSjfiy4a+Pcm
GRt0FtXLqPywKhWsZ2akIMCKPQcpXzhRy2a9NQ0jH0/UVc2QIPl6R7TcpXSs
izqbwUf5pJqeOKttBv7jSA9VpfKRCK8JeN6ehf8VzvskTZKg1rGKXPrJwNho
875VYyTkRl1zk7mXi0OGrjwrqfqgR8nddyTyUPJ1qcIsVU+7247UjIvmo+LP
toYSqt6qj8THeXoWoomuzJOFXqpeLS3iow4UIbv1qcXEvyTc/3jNKievCAfX
Tr7Xoeq5bag87edYMeYxD/wKoOpdIM9WNki5DJ9rBu5M/UXCp+/bpbU7ytBh
U/tReitVv+0KMRwm5ci1mc0hr5mE6NDfF2+9qUAaGZwfR/WfzfdulkchE3cv
vJ46VEX9nkjes0OXSCTz62qfkiQ83bPaOaSZxHV1IsNZlSRw8yxuYFj/xKcG
WHO4jIS1lecb73lXocnDb5aJeSQ8djJLW9dahYb3fSUZVD8Utxs7FbKrGvl3
wqmiHOq49sxfZlw1Phs3WMig+mnZ+Zej/aU12Fop8fJ8IgmM3rD0Y4t1SAj2
CQx9o+73wcms1zL1eFVOhc2O6u9rbXIv172px37jZal1X0kwzKe13+BtwEMz
r56tpuaH1W2N5QdEGvEYw9cw+C0Vr1bJxuBbzWiedvOryWMSzox783zPbMM2
MvuitAwJ27lt0uZWt6OAoTy1WybB8c+EubxyO/J82L+v7RQJ7Et72pi97Zib
v/uAOjU/JpY4eSS7dCDNxiH/124SvLWYFw1Tf+NNrr9whppv1dr/KZW0/MbK
f2uOrqBR+f+H+6Qg0YkrfdNls+eZ0JXwxq5UoRNVbdLSNo8zYccXlaT6jk58
t2cTr8FvJgyt5TfoX9eNWfbri1SzmHD+jJ7RuHA3hrNUL7j8YMKVT53BUyrd
+JNjQjctkQmxhWzvB/y60ftJU95MOBPqp9Zxuon+Qa7db2Y4vZngNGL8LFq9
BzOtcmw/32eCdlC30qpvvdj50dhLcCN1/vQC7VNeL85zTwrfXM+EjrH5+p09
vdh3bMbKfTUT5JJv/Nx1uA+V1Fr3tc5VwgWX/j8/M/pQ9T9/Lq6uSiibuLW+
rrYf48y+vhlIqIReOCImyTKEqcPJh20uVkLCK0Zj654hfFE4IZBwthI+zb99
+PTCELJ/tJxrPVUJ2xXenf/0bgiVrv98uFW4EkZeFnqb8Q3jyCYFj5MbK8HP
ql/t0/5/qHhup+5kYwUsWPAGRQWNYHVugpy5TgVMRBmMKSWN4BoF1xJhaj16
hzwrNZE3gm8PhFt1KVVAQ65v6qHOERRQinxwQqYCcgSRabxjFK9G6jDd91TA
wedPruz1HcWXEeIrF3vLoWdE00/ffQzns+0Ff1LrZcFlZSHHb2PoK6Q+kUyt
p+3bzU/4xY7hkGa68AetclATDm3KrxhDkfzJv6fky2FMXzOjee04dvM/DTqz
vxwclScrDtqPY+vV/xZZe8rg4JSl6Nn7E/juhZd9pVYZyH9jHV/5bAIPLA6x
71Iqg61dY725LpRFmEIPz5fB0r2xWwciJ1BeWmDjuHgZ6ArqLiX3TuDSx9u0
7+vLYHPxjh0x+pO4GC2S7Z9VCu/cVt5j1ZhC005a0j4+ar+SwZBguzuFvMN1
Rh/WlwKz3jtileUUrny7bv0MUQqLOj42fz9M4RUOd95oap1hIZmncZOcQt9z
QQGYWwK+ElkiPHLTyHI8QfyTUQnUnm+87XJwBhNfHty0/UcxpDhu8i86MYMf
/l2RfxRdDGsMvv9ekJvBum6dqKzAYnh1NsVUXWcG/S0aJmVci8FAu0mrwGsG
t/lfnVp/uxhWdCjaWS/MoLXI4LzLumIoeepVJV08i4Vy7nzyatR+sDCnMK1m
FtdsUS7okS+CJYWh6/s7ZlEhW2jMBoqA/SS37vTMLKZyqbV+FSqCsxIc9ucO
zOFsS7Hkx7lCMG5i1Y59O4fMnD0fnf0KwWE/V9L7i/PIf+kYi2l7AVw9ZzB6
WG0ey9wcZG5XF0DFRvZzBbrzePFu13OFwgI4trVAsOnZPHpvYutnjyoAK1Vt
haCYeTzM9WCzgmUBHLokvC+VcwE3T01vj2QrAP3hivvZlQvov3/9DI9YPuxS
ueap3rSAY2yR1Yq78+GyuMCtvu4FXDnatMuWNx8U3bjbxucX0GV4SPznXB58
8tDkDt6/iF3i4m/E8vNgZXK/vYnjImaLFDmPK+fBCh7Jn15HlvD6qx16jia5
YDa0x3jw5BIuyXiLqOrkwvpy0ueU3BJ6vP+za4dyLpQ8a/FhaC6hr8jEu4ij
uWC981eXvsMSHjPl/uOwwABd9aDD3NXUcVkeXpU3DJC0Nrk8Z7SM3oPnrdkA
Qa7iht8Zi2XU1FLSeLUTYecj/z3WNstIf894NcOCIHuppKH+/TKWeDIn80py
YPvhE8/2Ji/jZS/BlaNKOeCxythl6/wyBlkr70nXzYb8E+nX9kvTGH9Y/Lgk
bDPh+f105pQsjTG/9+Ryyu1M2HXouirjAo0hLRN/XlQuEwY+1b84f5XGUDvf
SnCvzwT5+P2Ke2/RGAMKdr9cPmeA8bErdbuf0xg7JOwuyialg/+fvmCBJBpj
uj2E4Ov8AW9OJywYp9IYYrdMk6sKfoB6n6tcajqN8T0jOvBV2A8Y3aIUdppB
Yyxr9p5vN/4BzstjXpsraYws+pSL4nQqrO9df399D42xFEg7tI0tFa6dPF/W
xk0wMp5PCpYKJ8PbxueZ3XwEo8v10AMVjmSw/s+//M8WgrH6RdVCw1ASrGce
k2vaQTAqdthw/4xOAt09vK+cDhEM7L+x3+ZAEhyKKXcaO0swdj934ajZnQgR
7p1EpBzB6BzI2LJ6ZSK0mta+175AMJ4sPFwh0ZUA1wWOtSVeIhjm1Z1v7AMT
wCA6Q2S3BsG4tcXH7te2BLjhnkr7z5hgDKTI0+N44kHp1WHpFyYEQ8T+WKNQ
Xxw83djg3P2IYDiRi5v6Q+Pg4d11e3wfEwyVwWBHpV1x0Dsr7EraEoxXk8bX
UjfHwsXci8/PuRMM1mbm9V6WaOD02xbyKI5gGLauPm5eGwY3vVt1tiQQjGdv
tt9K9g6DkosBKZhIMFL/NIT/UwuD9UEfhBZTCMaDhMh21aZQgG/TQjJZBKO8
xsa95VcIDNRnSM0XE4xLVhXxf/8EgT/fmus3SwmGz3rFC9WhQUBqXGbLLiMY
KU4z8z/uBoFov6ngg0qC8XBH+JRF33dYd6NYyKeaYEwLqY6mDgZC3bct0v+1
Egz7Jg3bqu5v4DPkc/foL4IhG2kxsvnON/hiuGvrpTaCYR300FPjrz90fpUW
fthBMNj9D3cz+vxAuUfzn003FT/OG2KSw1/hPFlta/mHYDyPnP4o9/ArrNp8
8YtRD3Xce2qfwsgXUBs6ZSHXSzDCzZ0unR37DG8yWmIKBwiGRtkyf/fkJ8Dx
xo9fBgnGoeOlGtmWn6AiYj3r/SGC4fyzN8d9+iP8Fr7otjRM5ZMqw2nvrDfs
Ohm/dmSUis/24xYbFj5Amti4VOAYwZhay2GGzz/Acvng/KVxghE//eaj4aIn
zLFrbvgyQTCu2hypjl7ygGDFcL+FKYIx7JLylka4w6/IVRrO0wRD0+w3y+a1
7yF8SK+IfYZghFRZv9zH4QbxbkE57LNUvowfERXd4gpeKecvOFPO3dVee3DH
W9BXNnNaoHyOs2ZeYK8L/K4c+K95jmBUPWDkTYq+hsjYVaZn5wnG+hT15obj
zhC47vSzUMprLzzST5Z6BVIO38JvLxAM77mHeOPiSzjT+q08jTLxfnnNwSuO
cHi/XiDbIsFYdfp24riqA5gZdOsHUzZWmeF/qmMP7BU2yv2UO7lyQgwrbEGY
22Ps4BLB6PGbSGlqeA6rXDnk7lEOOSHfIdNlDcfe/L34nXKimaVv2PBTaDXk
IBooX74rprtqzhJc3lsarVkmGGX+JyJurHoMyve4X4lT7hyV7YvnMof8e79U
rlP+Ysz9ZZnfFEbYSmpsKZ+8U3bH67IJPKguX+VPWbxkUHOXgRFonv/dl0b5
zBTnYsSzO6C+QNiTlIeNUuCQpy58dBEq+U2ZrxZ3qSrdAKbn1bx/lN+77c2/
YHsNZLMtTWYp1yVdtXukpgBl6T4VS5Q5OOCXh85xqgOntC5T9k60ecAWJ4Cc
HBX+C5S3hDo1sPrKoMTAr42T/7v+R4MSvkAlPBYyeKKPcqFgytAeC00M3zDP
1US5JUdl6WOQDsaws38toLyNfQsb3zt9HLHZ1xBF2fRg5GFPS0MMu3y10I2y
09QLyzU6xuhp7mbwgLKfOtd8xu5HOPO378d5yuNfHG+a/GeGQbH3s7ZRJne1
PtjGYYHdVdvM/1HjffqadkLxCkt8o8fWmkV5MPt8gvH0E+x4Tp92olx/oGuS
bdAKz1SlyrJRHqPLmhyvs8HT+jxPiql4C9d8ScwrtcMq4anrdpQh47awYLs9
PjV+KdVJ5U/EdPuLLzUO2GumfvId5Xj/z6/JSkcMaJjuE6cc2tZSvVz8ElPF
p29bUPn4LS7krFLWK7ww63iAg7I/66sR01RndEyXDA2i8rknNmDMNf41vuB1
/pFL5Tv7P9mVCcEu2Ho5SbaMqh8eemt1pKsbXpNzaT9KGZjWeyu+vke5jb/v
+1L1pjFwQd7smjsevpWlqTVJMCZbrYuf63sgLff0+89U/Sp91Km+5vABhR7x
Z7ZS9a1qI5CRs84L9yjPN22hzGRhW9rp4YW5t7+MOv8jGNKeC0TDN298fiDM
bQ/VPwyyf5BTWZ9Qbbpeg071l0ONZ0yEZX1Q/nI3n1o/wfjpeuHErXIf/J4b
8NiM6kdu7gmpUU2fUf/ckR8mVD/rH+4XH5z8iihU+eFxC8HYOZ4/bcEbgP51
DZXQTDDsmjVPVmkGoJrAG2JVEzU+F8o6hfwC8OoNGXX7eqr/1hv9VyYYiBZP
dhSdrCIYp+6fY6s+8h0ZrA9XYyFVf7QOs78XgzGb5rhGsoBgsF0MFB91Dcaw
6EdrY/MIxvXuwIOTZDCOn/3E9gapeOC/xwPXQnB40lOQJZ1gNB5fof/+dihe
nR1csTaKyv/UusPBT8Jxw9XUPKUIgiFTJ7SpLiUc86JkhT+FEYy9/GN9y+Ph
WGKix8oTTNXzwISwzKMIPPygtLPVl2C0bTU1tjWMxM38SU/93lH9WYvDMEM9
GrVLpvd/f0swqp98knH0jsbnpy64fX9DMN5wvtwmVxONm7eymH10Ihh6kQvv
ky7H4NObzUnyNgRD5zStRFIuFneuvuL15z41HmuN9z3cHI8Fdw2SQu4RjPsX
lhf5jsfj3r2t727fpfplFm9L1rV4jPLc/aRCl6o3LHaZ84xHl6CRAw81CYbk
qh3DsuwJCNU3PvdS8/3Q33vHOYlElGUxaIjjJxhpD+oC5f4k4ZNF08zozdT5
GU7ve1YlY/mcVlIwDxUfXq30F3uTUUuI3unESVm962vo3WQsStpxjZ2F6ifO
Kz9G9CUjS+M+LdE+ar1z59UR18EUfJb20qE2gcbgW9w26DD0A5cDz8UejaUx
tsknXdFkT0N659v1npE0hlOYWZHQ4TT0zqzWPx1EY1g3M0sSjdPw+cPlQHUv
6nq/1+40G0jDpZ1F9IjHNEY4fN778W86Frww/cuQoDEW7SIOSzRn4sOl+3T/
IzTGHSfnVW9nMvHSZuB/cojG0Eq8vKWZNwsT7NZf599NY9gNTTbqqGSh0pUG
QeFNNIbMkzjkrMhC3w/xhfMdy7j7jmznQGY27nq9R9LvyjLO39htoueN6K9l
sFbq3DI+sXqTl5CIGDrdtr/29DIuOHAqTJOIsW3jD3r3L2PdfWJQfBUDeddr
ykawLKNctvqyCTBwsN7dzi1lCR+8vpDGlsTAmfz7GnMbl9C1M+ZZ/sdcfPL3
JkqtW0Jbn6S/XUG5+On67B+r5UUs6bfZQEvIRcfVXs9aBxZx14M0j4PluZj1
5yerQsEiqnHeHby8nIubbAOrSfNF3BAgpFBwJw99AkYPvqH2B0NRA30qYvlo
zYw52Ze3gJaCHETPmXzUy2tSP5u2gByqmWbmCvm4Yra8uP37AjrUfNK018/H
uN0vi4qfLGD9pqKO2x/z8ewq9teXdyzgzNvNEtKz+fiKRy3tovE8KlSJ7dbO
LED72nqNxlvzWFUtLqtWUoBnaqLEb6nM4yuVMBv5ugLM2G8Xeu3kPEqpiArv
/FeA99xtu/+smcctfHQB512FWC4f1vMxcA4N11zdKPa6EOsLrnxVJWfRyrR6
+8DlIrTuX3YdzZ3F0ztpJjuvFyFT5LWwc/IsdlXK6CvdLcJmp1vuvp9nUSno
+Al/uyJcKah88pHeLP53RmfbQFwR7q2Sd86ZnMHI0H3tlzmL8R6x5dFGnhn8
eHxlyt7SYuy6VrCdsWYG9+WTrqU1xchbadpyd24a7Xys7O60FWPCo/WuIe3T
KFbVG+k2XowzkRz7miOm8Y7c+qpP20pQ+YGNyEGpaXRPHOV5+6gEFfaxiLy8
NYWCK3yjuzaU4sJwsIC10hR+KbXqKeAvxXqzNBcjmSm8mMrV/21PKW5U3NF2
ct8UysZHyspIlmJLXHzL5+FJHFGKZAGdUtx3+5Cs6vNJdG8rclsbU4qcJ4mg
mg8T2HtqUatGugzvtW7tuec0gX/SCs0y5cuwx+zwhXlLav9uJSvvp1KGlRq9
lpxaE+hROC5y2aAMaVE72xcFJtCz49pX/ddl2D95/vdk5DhacU7s0K0sQ6nb
LlvvZ4/hu9t7YzyUy9FASXjufuwYkse0c2O0yjEqKu+O4bcx5J/7ppqvW45x
rKvmVV6MYd2X7yPNZuVof3CvxZTsGE7C7tJMz3K8pjhSeb98FLd5JV07W1WO
NdolNqJ1IxjazbVw7WIFXm7dXK1RMIK8XuVxp5UqkHdjicWzpBG8v0fAkl+z
Al2e7k1L9BjBO2vyRXMNK1Byy93MvksjaLa2aV+McwVaXQpIm3f5hy0eRodX
FVQgq1D5ZobuENqeNl8VdqwSX+r8rJuAIXToaB57K1WJA1e+6O7cNoSmQ0nx
hrKVuHu17UbdhkF8f4v94zrlSrz/m/OXg8IgFq/YXd1rXIm9GesT5MUGMFki
8AF/YCUW+tfqnZjrxbM6Rp9lWZh4eyhcob2xFxVbqlsy1zJRI0dzj/2PXvzn
Y1txkIOJuuLNzDiLXrxZqpo0uZmJ43L32oqH/+K8g7KZqDATG7zW83T+7kHl
k/s+nldn4rk8P5WZ/G48XyXR+CeIicov9qoOBXajsYmrxaNwJp5pf3bpl103
mhSc8hmPZmLBcK5C7Klu7LojZdqVwsR07ce3eJK68M2hxwr3ipk4eeDQ4eWA
TlzumE1a38fEwwdXDTyz6kDWXd+vRO0lUeyO7MVplQ5UFfKa8jhA4v6Ee3MP
hDtQScQl/qEwiatjSdrXonbUYeHT5DpG4iZFNo/oz2349J7qzR5ZEnN9BB8d
OdOKAr/LL3frkNj2dF3Q17EWrHTPCD2lT6Jqx2DtUmgL1obuJ1zuUtf/p+ga
w9mCuD4vnc2ExK03VMNjO5pw7vS8QJA1iTSX2A/KLxrwmuaKuR2eJCZlF/0+
f7QBv8Eie68XiZPfNVyO9dVj2IrXvKGfSLx2gfMsTake7WwOrljjR6Kh4onY
8zvq8BPLVWHtMBI7muzFWGtrscz4RlVzBIncu3OwyLkWZ5vndK9GkxjS/1hR
+F8NJu3nu7IjgcTvbD8907OrcbiScVwlg8RXB8PzLptWY/TDfaffZJEIhjci
23ZXo4R5wf7UHBLN947ODL+tQvNTe3Mm8kiUFWOfqdH8iZEDGRkry0m0mJDS
cuorRxnu804Pm0gMn4x4LkvVkZ7MBvmZZhKljjuXLZSVIa+xxRarVhI9c5Kf
aEaXouN551bddup66htXFJsUY35GU0t9N4kq38WMVNqLMF9PY1yghxpv0UNb
m68UYdlQ6Kbbf0mUDpsfrD9SiOc6LB6U95H4MfTtYc+xPCyVd7WhD5PI8mGA
nNDNwwZ+iZqL/0jczdnbrFyTixdW6IoojJBY6CmSQSQz0G/h6tzRMRL1iyXr
lXczsObFJ0OBcRK5wrNrYT+i8LJJK22CRG1YzXOjPwuZsaM1UZMkPhD7kNVR
lonvz4qpP54isfGrmfmNqAx08RBuP0ZNmKrnNYVlqHlemevrQuAMiZktC7nR
ij/Q9EO8h8IsiQp3D77kOpyKL55WHBiivMvOLKl4KAkVFp8Ybp4n8fSiWDw/
MxG9u7LWf6csJ8acM4pNwJXpZsmCCyT+E+JvSXGLR7FtVrf8KOut7xad/RWL
l2IT2DkXqfEaUZ+x9Y9GgXU0fEq59sK5z4s3I5G/9KJ5M2Xj3QbBjwXCUfO1
5QGJJRIzThhH/G0PwbD2h91OlEVyuE+oBgSh852dgSTl+/L/dWTqBOKxpKc6
G5ZJPKJ6X/fMWX9M0TLYpUD5k+0ly8W8z1g40tjznHImqvKnynjj6JrimFDK
b24uPbpX4I7uonuelFAu++1xWNTlNRYt9p/tpHzz9s/4jXx2+Gp+w4YJyipT
xCtLcSP0TvP+vUj5jjZ/ro2bCrjmmicvU9bMWTEw02EJNYFRb2Ypl2h8Ut/7
8CVEdZ25PUD5KaEvUP7gHQhyiZ6qoywbPH5O4tgHEIhz5vtBeZ3tBjHblE+g
fF5+yp0yhr0TzZPwBbjp0KBL2a1x0nNZMwDEn57KPPS/8y0bpz9//g4XNjsG
DlPj8UE78YdIUzBoMwxdwimrGZScZWwOA87RxcdalNmTddYpaEQA7lfTX0l5
z6+8Z+SnKHDqfXUtlBr/lZ5OnrfZ4kGov4peTcXPyt36p8WeBHCisX+7Sdl3
X+eIIyTC+H8DV7qo+G/4I1XmZZ4Mzu5rI+vmSGTdRs57v0uBvaGvVWQoi4iz
E55hqZAucvhqBJVPYtcanli1pMFbFSuZm1T+HdRl1dWfTIeNeo9OxlD5ufbR
iQ0XOTOBs+qA0wSVv54eXXFLZ7Ph9KQvrzGV31tNRQvW1THgX3K+8PIoiUWm
Ql86b+cC9wHeUi7KwsQG2R/DueByNC9tC1VP3O8cXFXW5kOVIM9nPqr+ps+m
SKmeKoTbY+/1U6j6FGtcpq0tKYSYirfxb3qp+O8YeZOqWgRnJIdU1Kh63nAv
0YDFpBg6U9d9b6TqP2Pi6weNgFKIjhbWf0H1B9XEvuq2Q2WwIog039xG4smP
v0tvppfBqQr1X2FUP0nVH1JXqC6HZ8YvMI7qP2p7fWVrWJgQ7adVpldD9YtS
dQ9BdyZsYL2YlF1F4uCrXa+Nt5KwtYRnlvMniYFzX6fMt/yEewG9vn4VJDZ9
djJniFVB1RERpRuFVL1tGjYqfVoFqfk5h6zzSewfLDnCzKmCQL7Phu9zSTT4
5tddJl8NrCxrWIKySYzVtuB9r1sD1zS2/TRJIbHqxMS4uEcdtH9rO/U5iMQd
bvrDTa114DqyP29tIIk2fheyrITqYYqnVfOhP4lZXTSbUKwHnnV3GTs/k9iy
M+J04lADDHXI2PG7UfdvFM9hf6EZnFfgYz1LEieGg6XTPzRDvQXnI1lzEu1P
nBrvb2uGdKOk11sfUb/XcNPm+OMWuLj0enPiPRITo560mAW2gknvQrmZNonV
XyaP6sy0wQlVUk2BTmJMaLIen0w7bNcoCPU/TWI0h2524bt2mPF6trvvBIlf
j/L9dNzQAXuL9WL0REl8f6+23y20A85VsG36t5Ok+mxZBYP8Da/i7u7RIUgc
Mssfubi9GxrEikOS0pm4R611kwe9G1b/WuNNp+Zzyaf+p2p0u0FEy3GqMJ6J
MVeMnlwI64bdHV7cGWFMbI17mjwp8gdq3j1qPe/NxNNc2gMq9B54f9Dz65wJ
E3+7F5V0a/dCM0vg6cKtTHSMEzv33LYXoqRd0nX5qPVJglA2e0Av5AU4kjMb
mHhPKdpye1cvSNMXyjnWMJHH5ZTolGEfiMvlHuocqcS6mELPJ+b9cI/+KHdf
fiXutDWteO04CFfOt0mc0K3EVaHaiuxhg7Ag+J+C/vVK9JC/4/SmbBC+imv1
OKtWYk5x/azhhiHwb2pLSjlXiYaTWJnnPwT8CaxdUQcqcYrQPNb0YxhWTcRp
rRytQGp5viXEdASispwtLJ5UYMieXp4mhxGwV44Q9X5YgeNGsYprvUZgp96/
HzF3K5CsUFfXSB2BFCP2/UXqFVjUbamWMzcCM13cbV7HK3Dil0KUn8MorGk9
/C1qspxah++1dHYbg3sp99TJ++WosfYbW4X/GBhm8lzj0yvHiPF6U7a4MWDa
+CaqU/P2oKOJvzU5Bj/S5z7mXqDONx2c/Y9rHCSPJl88uaccX/ywqNBwH4dL
Vxodc1vLUPrxFOOH6wTwFoVtlzxXhne+SBdf8p2Ad4TPjMfpMoytMOFqi5oA
+i39l11iZXjfkl9rqGwChHqvZz0SKEPl+AqlorWTsN+LMSs+U4qaqzW4bjpO
wpd9NVw64aWomMzGucZiCtxOJCvqslD7jX3ZMm0vpoArboWC62wJXnLQWxn/
fgqGrkqejv9Xgl8+HdwqEzUF/wqGaT0tJbhZ4/SFfZ1T8IQ1Q21dcgkSZtpR
3ZenYds7L2VRvRIcXJUWvXX3DAT3rK7ky6b2P79uLZ4RnQHO+vN/XiYWo0nr
E9PrZ2bgrlIMDIYV459i2R8OGjOQo3ioMMKzGBc+puu4uM6AsJ/E9Y67xWjL
uWz0bHwGNuUVzUptKEaNRz/DmVmzcKpX+lnlrSI04CkTO1k2C+3nDt/3UinC
Aut1+v4Ns/CSZXRJ9XwRDt/4L+bq2CwoccwI5AsXoRuv2EPtfXPQl7g3UmWx
EEXFWu+yu89B9KXZyQufC5FesIWeeX0ezv0j7fwqCrDv2eATCcN54NidR37D
Anycwvs7xGIecjd/O+abWICu8hclTd/NQ+SOf+qOPgWYeMbCPyJnHn56bVdi
0y/AyJDww/4CC2D3vkd/1Ry1H25s0bdtWQD9OO3ArJ35eMAvXVWiZwHOFBwW
G+POx5btP/i6Rhag4ueO1YJr87F965P1B1cvgmf83peWw3m4wej4Xf0ji3BV
eK3Yn4w8vC5I+2ztuAgddSGC3cp5+Nh2YrXg7iWIf3eZw84uF4VMBLWGDy/B
yagdMoJmudiqtkkk8fgSHKvgEszXz8XG006qggpLMFrjNTp5MRfXjcrIR5ku
gfT0/b1C3LnYH9hTfiV7CVSyyNbcMAYGOPl2NF9ehhNpT6QKPiGOzNMsnNSX
wWr+yBH354g5qVWuQjrLUJRl9031NqLelWfnNEyXoSTnF3vxAcT6N5EBNz4s
g2zAcrtydg6Ompw4tFS3DH3ncjeu/52NS6SJScEBGn1Ira9GTDAL1XyO7gwQ
ptF/eJ/cyL8mC2/pPZ1+Ikajr9l9P2ChPxM924tZt56k0cfeny2OSsxEVwn+
pKMXaXTtcfb5DOlMFBBgORt7h0a3fqPc+f1mBrJOHpWL9afRnaQfS5Z8SMNH
t+2Lrn2n0Wl8q5XMLdLwmlTS15kQGl3gtqAL37U0PJaXLXUkhkaXTKS/VOBN
w0juHbJ3M2l0odrt73V9fqBkktTz8XrKLeo5ql9TsWbWecSGlaAP+Mc0Ofsm
41uPXnY3doK+f98DdcPnyejTvOn2Zy6CfjlsK7eMdjLO03VCAnkJuviSkclf
/mR02yTh9nQXQTc0mwsa/JKEj/1VhECSoC8IJhKjnxKxUXyROKBH0BOvNSru
pNatX0MatR8bEHRTOU5r14fx2H/M0TLrLkFnbZD8Pn41HnmV13dLGRP07980
idRN8Tg58dGH/TFBb3Xj+swnFofpX86MtDsR9Mr1uVdWnovB26XW0z3OBL3i
awHX7bUxyHj3X0rfG4KeWbsmLbUsGsNVXit1viPoH7y+TypeicaOpTAiwJug
C29tq9mrEYXqhGK9YjBBT3vrrO5nGIEfhuZYOUMJ+jnPeY/3ByLwunL0cEUY
QdcVKwh+NhiOvjf1ck9FEfQGP0536Ufh+O/Lk9d/Eqjx0Fm779WTMEzu1ZS5
l0PQnXwWQpdfhuCb07rHe5Cg20+UOH88F4KH9vLX3swl6EIi9hJCa0NQ6brI
apkCgs5Vky98+m0wzgpvkGkoJeiHHz9WFvIIQo2a1FrhWoJeo7M1fbtvIEoU
LvO51BH0VWyxx7arBWL8cNNAez1Bv/go9P5mrkAUaf4u86yJoJ/p2K+06BiA
m+xdwh+1EfSMJJLB2+CPm1deMwhoJ+iRTTvaCuX90T/HL66sg6DfaFzLuJ/j
h8QvGODoIuiK/unPfUN8cXRAavLaX4IuWTvv/NH8Cz5PNODW6iXoCVKXntL+
fsbWId0cjT6CHj2R6Kir9RnjZsIT5AYIOk/t/k+c0j74etUV9rZhgn5sk+Lt
jRwf8dHjFc9S/xF0FfOUZukX3ljNdsn0zQj1vO/li4wmvPCvUPjU9jGCPpwd
9S2i+QPWdtbfWDtJ0KuN/dk7Qj1w4avPuhTKv8qjytr/80C1im2ntaeofDrw
XKnZ1R0VjcIlvkwT9P5vQT/t/7ih9z/FuSMzBH19dKCvRvk7fM0/LpdHWcNu
veq+BFd0GPMyqZ0l6HrfhX9FPnfBJ5xSCtfmCPpar39aOrpvkOMHxPykLKJ9
ZCvHhdc4+RdpP+YJepv2rVyVTa+QHaZHdy4Q9DXcRkqDMy/ROGvhrjNl4v5h
G9s2RzTaM/NbepGgX9pymOYR8QJpp1P+fKSc9cqbZeN7e2xhMh/0UH7AsW2K
v88W2wIOWR9ZIuh0fX0r1uTnmLkjjfUx5RT+E1IjttY4b6gtkEx502DVUOXF
p7iKvjptiHIkYXI8mNsSd28Ort25TNCvVMgXmbebowvn3sdXKXeXhJ+TijRF
zRGbz1aUo7y9Slf0m2DQkW/SfpTFPvR8fmFnhI/GbB9kUtbVrlab4b6D+Szc
22opK0v+0TCMvI2f29Su/qWsMqU9GmKnhUPh0msmKcsJ224zj1TCTImf0v/7
P9zyqhDm40hp/L//y63R5hbfG+qR9f8AUWUSqg==
     "]]}},
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{},
  PlotRange->{{-2.249999737054139, 2.25}, {-0.24999996482030118`, 
   0.24999996956862214`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5630465521797495`*^9, 3.5630466125362554`*^9, 3.563046731314864*^9, 
   3.5630468822919292`*^9, 3.563047261540596*^9, 3.5630473490411496`*^9, 
   3.5630474031108446`*^9, 3.5630478516584325`*^9, {3.5630480368307576`*^9, 
   3.5630480603555984`*^9}, 3.563048104768877*^9, 3.56304836298213*^9, 
   3.563048404759004*^9, 3.563048588905327*^9, 3.5630486704402695`*^9, 
   3.5630487533232155`*^9, {3.5630499329276896`*^9, 3.5630499472173147`*^9}, 
   3.5630499857493825`*^9, 3.563050042098282*^9, 3.563050077316743*^9, 
   3.563106573353532*^9, 3.563107642713743*^9, 3.5631076837506137`*^9, 
   3.5631110720424833`*^9, 3.5631115401692877`*^9, 3.563111598918988*^9, 
   3.5631116391906567`*^9, 3.5631118214397707`*^9, 3.5631119494375887`*^9, 
   3.563112784091428*^9, {3.5631129839077697`*^9, 3.563113002315802*^9}, 
   3.563113062778303*^9, 3.5631136944218063`*^9, 3.5631277472706676`*^9, 
   3.563128122207726*^9, 3.5631281534077806`*^9, 3.5631282389895315`*^9, 
   3.563128421320475*^9, 3.563128451958929*^9, 3.563128794043862*^9, 
   3.563128826460719*^9, 3.5631289434921246`*^9, 3.5631293701060734`*^9, {
   3.563129454611422*^9, 3.5631294743922567`*^9}, 3.563129698767451*^9, 
   3.5631297799343934`*^9, 3.563129873004157*^9, 3.563129954867101*^9, {
   3.563130053197674*^9, 3.5631300680800996`*^9}, 3.5631304712000103`*^9, 
   3.5631307469304943`*^9, 3.5631307769449472`*^9, 3.5633730064431467`*^9, 
   3.5633731022532806`*^9, 3.5633731485833454`*^9, 3.563373218813444*^9, 
   3.563553505166424*^9, 3.564783556134794*^9, 3.564843301189065*^9, 
   3.5648434945358047`*^9, 3.5648435340038743`*^9, {3.56484363988126*^9, 
   3.56484366821091*^9}, 3.5648439565462165`*^9, 3.5648440390079613`*^9, 
   3.564850817812276*^9, 3.564850864347158*^9, 3.56485091674765*^9, 
   3.564851551715565*^9, 3.564852507934845*^9, 3.5648526025022106`*^9, 
   3.5648526547623024`*^9, 3.567106143076501*^9, 3.584477522148987*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw12Hk4Vd/XAPB7lAyppERUSJoMCZUp64ZEkpRMzZJvIYVKGhESIXPJEDIk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     "]]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], LineBox[CompressedData["
1:eJw12Hk4Vd/XAPB7lAyppERUSJoMCZUp+4REkpRMzZJvIYVKGhESIXPJEDIk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     "]]}},
  Axes->True,
  AxesOrigin->{0, 0},
  BaseStyle->{},
  PlotRange->{{-2.25, 2.25}, {-0.24999999703820877`, 0.24999999703820877`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.5630465521797495`*^9, 3.5630466125362554`*^9, 3.563046731314864*^9, 
   3.5630468822919292`*^9, 3.563047261540596*^9, 3.5630473490411496`*^9, 
   3.5630474031108446`*^9, 3.5630478516584325`*^9, {3.5630480368307576`*^9, 
   3.5630480603555984`*^9}, 3.563048104768877*^9, 3.56304836298213*^9, 
   3.563048404759004*^9, 3.563048588905327*^9, 3.5630486704402695`*^9, 
   3.5630487533232155`*^9, {3.5630499329276896`*^9, 3.5630499472173147`*^9}, 
   3.5630499857493825`*^9, 3.563050042098282*^9, 3.563050077316743*^9, 
   3.563106573353532*^9, 3.563107642713743*^9, 3.5631076837506137`*^9, 
   3.5631110720424833`*^9, 3.5631115401692877`*^9, 3.563111598918988*^9, 
   3.5631116391906567`*^9, 3.5631118214397707`*^9, 3.5631119494375887`*^9, 
   3.563112784091428*^9, {3.5631129839077697`*^9, 3.563113002315802*^9}, 
   3.563113062778303*^9, 3.5631136944218063`*^9, 3.5631277472706676`*^9, 
   3.563128122207726*^9, 3.5631281534077806`*^9, 3.5631282389895315`*^9, 
   3.563128421320475*^9, 3.563128451958929*^9, 3.563128794043862*^9, 
   3.563128826460719*^9, 3.5631289434921246`*^9, 3.5631293701060734`*^9, {
   3.563129454611422*^9, 3.5631294743922567`*^9}, 3.563129698767451*^9, 
   3.5631297799343934`*^9, 3.563129873004157*^9, 3.563129954867101*^9, {
   3.563130053197674*^9, 3.5631300680800996`*^9}, 3.5631304712000103`*^9, 
   3.5631307469304943`*^9, 3.5631307769449472`*^9, 3.5633730064431467`*^9, 
   3.5633731022532806`*^9, 3.5633731485833454`*^9, 3.563373218813444*^9, 
   3.563553505166424*^9, 3.564783556134794*^9, 3.564843301189065*^9, 
   3.5648434945358047`*^9, 3.5648435340038743`*^9, {3.56484363988126*^9, 
   3.56484366821091*^9}, 3.5648439565462165`*^9, 3.5648440390079613`*^9, 
   3.564850817812276*^9, 3.564850864347158*^9, 3.56485091674765*^9, 
   3.564851551715565*^9, 3.564852507934845*^9, 3.5648526025022106`*^9, 
   3.5648526547623024`*^9, 3.567106143076501*^9, 3.584477522148987*^9}]
}, Open  ]],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{{3.5629352689748716`*^9, 3.562935269427272*^9}, {
   3.562935380515067*^9, 3.5629354066139135`*^9}, {3.562935471322827*^9, 
   3.5629356124250746`*^9}, {3.562936614430434*^9, 3.562936718747818*^9}, {
   3.562936750228673*^9, 3.562936866121277*^9}, {3.5629369283185863`*^9, 
   3.5629371051604967`*^9}, {3.5629372137054873`*^9, 
   3.5629372487743487`*^9}, {3.562937376366973*^9, 3.562937513959214*^9}, {
   3.562938932344906*^9, 3.562938966696166*^9}, 3.562939037925891*^9, 
   3.5629391022760043`*^9, {3.5630216220005445`*^9, 3.563021658021008*^9}, 
   3.5630217237439237`*^9, {3.563021760528788*^9, 3.5630217973448524`*^9}, 
   3.5630219630171437`*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1123, 719},
WindowMargins->{{Automatic, 43}, {5, Automatic}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 693, 12, 107, "Subtitle"],
Cell[1275, 36, 1328, 23, 238, "Subsubtitle"],
Cell[2606, 61, 1601, 24, 352, "Subsubtitle"],
Cell[CellGroupData[{
Cell[4232, 89, 108, 1, 71, "Section"],
Cell[4343, 92, 754, 19, 72, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5134, 116, 145, 1, 71, "Section"],
Cell[5282, 119, 713, 17, 72, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6032, 141, 198, 4, 71, "Section"],
Cell[6233, 147, 4917, 100, 252, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11187, 252, 175, 3, 71, "Section"],
Cell[11365, 257, 23426, 509, 1212, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34828, 771, 104, 4, 97, "Section"],
Cell[34935, 777, 25147, 545, 1052, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60119, 1327, 133, 1, 71, "Section"],
Cell[CellGroupData[{
Cell[60277, 1332, 17546, 335, 892, "Input"],
Cell[CellGroupData[{
Cell[77848, 1671, 4087, 55, 23, "Print"],
Cell[81938, 1728, 4816, 77, 36, "Print"],
Cell[86757, 1807, 4069, 55, 23, "Print"],
Cell[90829, 1864, 5013, 81, 36, "Print"],
Cell[95845, 1947, 5013, 81, 36, "Print"],
Cell[100861, 2030, 4818, 77, 36, "Print"],
Cell[105682, 2109, 4986, 80, 36, "Print"],
Cell[110671, 2191, 4986, 79, 36, "Print"],
Cell[115660, 2272, 5017, 79, 36, "Print"],
Cell[120680, 2353, 4140, 56, 23, "Print"],
Cell[124823, 2411, 4546, 68, 23, "Print"],
Cell[129372, 2481, 4065, 55, 23, "Print"],
Cell[133440, 2538, 4105, 55, 23, "Print"]
}, Open  ]],
Cell[137560, 2596, 34961, 582, 451, "Output"],
Cell[172524, 3180, 4121, 56, 23, "Print"],
Cell[176648, 3238, 93984, 1574, 376, "Output"],
Cell[CellGroupData[{
Cell[270657, 4816, 4105, 55, 23, "Print"],
Cell[274765, 4873, 4134, 56, 23, "Print"],
Cell[278902, 4931, 4130, 56, 23, "Print"],
Cell[283035, 4989, 4087, 55, 23, "Print"],
Cell[287125, 5046, 4115, 56, 23, "Print"]
}, Open  ]],
Cell[291255, 5105, 102491, 1803, 337, "Output"],
Cell[CellGroupData[{
Cell[393771, 6912, 4105, 55, 23, "Print"],
Cell[397879, 6969, 4134, 56, 23, "Print"],
Cell[402016, 7027, 4130, 56, 23, "Print"],
Cell[406149, 7085, 4087, 55, 23, "Print"],
Cell[410239, 7142, 4115, 56, 23, "Print"]
}, Open  ]],
Cell[414369, 7201, 102491, 1803, 337, "Output"],
Cell[CellGroupData[{
Cell[516885, 9008, 4134, 56, 23, "Print"],
Cell[521022, 9066, 4380, 62, 23, "Print"],
Cell[525405, 9130, 4364, 61, 23, "Print"]
}, Open  ]],
Cell[529784, 9194, 20494, 338, 59, "Output"],
Cell[550281, 9534, 16884, 280, 59, "Output"]
}, Open  ]],
Cell[567180, 9817, 719, 10, 52, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
