(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     15671,        382]
NotebookOptionsPosition[     15232,        362]
NotebookOutlinePosition[     15575,        377]
CellTagsIndexPosition[     15532,        374]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9},
 FontFamily->"Arial"],

Cell[TextData[{
 StyleBox["Rank",
  FontWeight->"Bold"],
 "\nA matrix M maps all vectors of a linear space S of dimension d to another \
linear space S' (because M is a linear map). But S' is not always equal to S \
-- it may have a lower dimension d' \[LessSlantEqual] d. Then S' is spanned \
by a set of d' vectors and is a subspace of S. The dimension d' is called the \
rank of M.\nIn the following cell, 3 D space, spanned by three vectors a, b, \
c (in green), is mapped by a rank 2 matrix. The resulting space is 2 D and is \
shown as a plane with the three image vectors (in red) -- make sure to rotate \
the image! By manipulating r and s in Manipulate, the matrix changes, and so \
does the plane.\n   \n   "
}], "Subsubtitle",
 CellChangeTimes->{{3.5848187745023975`*^9, 3.584818784232411*^9}, {
  3.5848188413124905`*^9, 3.584818841552491*^9}, {3.5848967037619553`*^9, 
  3.584896745352014*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"e1", ",", "e2", ",", 
    RowBox[{"e3", " ", "axes"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"aa2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], ";"}], " ", 
   RowBox[{"(*", "  ", "green", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bb2", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], ";"}], 
   RowBox[{"(*", "  ", "green", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cc2", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ";"}], 
   RowBox[{"(*", "  ", "green", " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Define", " ", "two", " ", 
     RowBox[{"vectors", " ", "--"}], " ", "these", " ", "will", " ", "be", 
     " ", "the", " ", "columns", " ", "of", " ", "the", " ", "matrix"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Make", " ", "them", " ", "linearly", " ", "independent", " ", "in", " ", 
     "order", " ", "to", " ", "create", " ", "a", " ", "2", "d", " ", 
     "subspace"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mm1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mm2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0.5", ",", " ", "0.5"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"viewing", " ", "area", " ", "extents"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"range2", "=", 
     RowBox[{"Max", "[", 
      RowBox[{
       RowBox[{"Norm", "[", "aa2", "]"}], ",", 
       RowBox[{"Norm", "[", "bb2", "]"}], ",", 
       RowBox[{"Norm", "[", "cc2", "]"}], ",", " ", 
       RowBox[{"Norm", "[", "mm1", "]"}], ",", 
       RowBox[{"Norm", "[", "mm2", "]"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"graphics", " ", "entities"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"arrowaa2", "=", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "aa2"}], "}"}], 
        "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"arrowbb2", " ", "=", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "bb2"}], "}"}], 
        "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"arrowcc2", " ", "=", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "cc2"}], "}"}], 
        "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{"Define", " ", "matrix", " ", 
      RowBox[{"mmat2", " ", "--"}], " ", "has", " ", "rank", " ", "2", " ", 
      "as", " ", "long", " ", "as", " ", "mm1", " ", "and", " ", "mm2", " ", 
      "are", " ", "linerly", " ", "independent"}], " ", "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"mm", "=", 
       RowBox[{"{", 
        RowBox[{"mm1", ",", "mm2", ",", 
         RowBox[{
          RowBox[{"r", "*", "mm1"}], "+", 
          RowBox[{"s", "*", "mm2"}]}]}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"mmat2", " ", "=", " ", 
       RowBox[{"Transpose", "[", "mm", "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"map", " ", "the", " ", "a"}], ",", "b", ",", 
        RowBox[{"c", " ", "axes"}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"vrsa", "=", 
       RowBox[{"mmat2", ".", "aa2"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"vrsb", "=", 
       RowBox[{"mmat2", ".", "bb2"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"vrsc", "=", 
       RowBox[{"mmat2", ".", "cc2"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"make", " ", "the", " ", "graphics", " ", "arrows"}], " ", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"arrowrsaa2", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "vrsa"}], "}"}], 
          "]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"arrowrsbb2", " ", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "vrsb"}], "}"}], 
          "]"}]}], "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"arrowrscc2", " ", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "vrsc"}], "}"}], 
          "]"}]}], "}"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Graphics3D", "[", 
       RowBox[{
        RowBox[{"{", " ", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Arrowheads", "[", ".06", "]"}], "}"}], ",", "Thick", ",", 
          "\[IndentingNewLine]", "arrowaa2", ",", " ", "arrowbb2", ",", " ", 
          "arrowcc2", ",", "\[IndentingNewLine]", "Red", ",", " ", 
          "arrowrsaa2", ",", "arrowrsbb2", ",", "arrowrscc2", ",", 
          "\[IndentingNewLine]", "LightRed", ",", 
          RowBox[{"Opacity", "[", "0.5", "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Polygon", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "vrsa", ",", 
             "vrsb", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Polygon", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "vrsa", ",", 
             "vrsc", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Polygon", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "vrsb", ",", 
             "vrsc", ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}]}], 
         "}"}], ",", 
        RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"MatrixForm", "[", "mmat2", "]"}], ",", "15"}], "]"}]}], 
        ",", 
        RowBox[{"PlotRange", "\[Rule]", "range2"}]}], "]"}]}], ",", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", "0.333"}], "}"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", "0.333"}], "}"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\< \>\"", ",", "\"\< \>\"", ",", 
        "\"\<Rank deficient matrix maps green vectors to red vectors\>\"", 
        ",", "\"\< \>\""}], "}"}]}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5848188462524977`*^9, 3.5848189552526503`*^9}, {
  3.5848190702828116`*^9, 3.584819107832864*^9}, {3.584819166302946*^9, 
  3.5848192774531016`*^9}, {3.5848193147031536`*^9, 3.584819344053195*^9}, {
  3.5848193793332443`*^9, 3.5848194241833067`*^9}, {3.584819600733554*^9, 
  3.584819645703617*^9}, {3.5848197459337573`*^9, 3.5848198180038586`*^9}, {
  3.5848198793739443`*^9, 3.5848198856139526`*^9}, {3.5848199355040226`*^9, 
  3.5848199559740515`*^9}, {3.584820017660142*^9, 3.5848200421801767`*^9}, {
  3.5848201847303762`*^9, 3.5848201979103947`*^9}, {3.5848202570704775`*^9, 
  3.5848203204505663`*^9}, {3.584823505717034*^9, 3.5848235419470844`*^9}, {
  3.584896783382067*^9, 3.5848968097321043`*^9}, {3.5848968426621504`*^9, 
  3.5848968700821886`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`r$$ = -1., $CellContext`s$$ = 
    0.03499999999999992, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`r$$], 0.333}, -1, 1}, {{
       Hold[$CellContext`s$$], 0.333}, -1, 1}}, Typeset`size$$ = {
    370., {210., 214.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`r$80731$$ = 
    0, $CellContext`s$80732$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`r$$ = 0.333, $CellContext`s$$ = 0.333}, 
      "ControllerVariables" :> {
        Hold[$CellContext`r$$, $CellContext`r$80731$$, 0], 
        Hold[$CellContext`s$$, $CellContext`s$80732$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`mm = {$CellContext`mm1, $CellContext`mm2, \
$CellContext`r$$ $CellContext`mm1 + $CellContext`s$$ $CellContext`mm2}; \
$CellContext`mmat2 = Transpose[$CellContext`mm]; $CellContext`vrsa = 
        Dot[$CellContext`mmat2, $CellContext`aa2]; $CellContext`vrsb = 
        Dot[$CellContext`mmat2, $CellContext`bb2]; $CellContext`vrsc = 
        Dot[$CellContext`mmat2, $CellContext`cc2]; $CellContext`arrowrsaa2 = {
          Arrowheads[Large], 
          Arrow[{{0, 0, 0}, $CellContext`vrsa}]}; $CellContext`arrowrsbb2 = {
          Arrowheads[Large], 
          Arrow[{{0, 0, 0}, $CellContext`vrsb}]}; $CellContext`arrowrscc2 = {
          Arrowheads[Large], 
          Arrow[{{0, 0, 0}, $CellContext`vrsc}]}; Graphics3D[{{
           Arrowheads[0.06]}, 
          Thick, $CellContext`arrowaa2, $CellContext`arrowbb2, \
$CellContext`arrowcc2, 
          Red, $CellContext`arrowrsaa2, $CellContext`arrowrsbb2, \
$CellContext`arrowrscc2, LightRed, 
          Opacity[0.5], 
          
          Polygon[{{0, 0, 0}, $CellContext`vrsa, $CellContext`vrsb, {0, 0, 
            0}}], 
          
          Polygon[{{0, 0, 0}, $CellContext`vrsa, $CellContext`vrsc, {0, 0, 
            0}}], 
          
          Polygon[{{0, 0, 0}, $CellContext`vrsb, $CellContext`vrsc, {0, 0, 
            0}}]}, Boxed -> False, PlotLabel -> Style[
           MatrixForm[$CellContext`mmat2], 15], 
         PlotRange -> $CellContext`range2]), 
      "Specifications" :> {{{$CellContext`r$$, 0.333}, -1, 
         1}, {{$CellContext`s$$, 0.333}, -1, 1}}, 
      "Options" :> {
       FrameLabel -> {
         " ", " ", "Rank deficient matrix maps green vectors to red vectors", 
          " "}}, "DefaultOptions" :> {}],
     ImageSizeCache->{443., {293., 298.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.584819000782714*^9, 3.5848194356733227`*^9, 3.584819651513625*^9, {
   3.584819789943819*^9, 3.5848198089838457`*^9}, 3.5848198883239565`*^9, 
   3.5848199608140583`*^9, 3.5848200435901785`*^9, 3.584820200360398*^9, 
   3.5848203445105996`*^9, 3.584820453510752*^9, {3.584823528807066*^9, 
   3.584823543127086*^9}, 3.5848966779919195`*^9, 3.584896811982107*^9, 
   3.5848968715321903`*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1021, 630},
WindowMargins->{{Automatic, 2}, {52, Automatic}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 691, 12, 107, "Subtitle"],
Cell[1273, 36, 907, 15, 181, "Subsubtitle"],
Cell[CellGroupData[{
Cell[2205, 55, 9322, 227, 932, "Input"],
Cell[11530, 284, 3674, 74, 608, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
