(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     61234,       1615]
NotebookOptionsPosition[     59504,       1553]
NotebookOutlinePosition[     59849,       1568]
CellTagsIndexPosition[     59806,       1565]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9},
 FontFamily->"Arial"],

Cell[TextData[{
 "\n",
 StyleBox["Rotate a point about an arbitrary (unit) vector a",
  FontWeight->"Bold"],
 "\nCompare \n1) the method in PLA \[OpenCurlyDoubleQuote]one matrix\
\[CloseCurlyDoubleQuote] in 3D Linear Maps chapter\n2) a step-by-step \
contruction\n3) using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s routine\n\nProblem with stepwise solution: if rotation \
axis and e1 are identical, then it will fail to build a local frame. Need a \
test to choose a second vector not equal to input rotation vector."
}], "Subsubtitle",
 CellChangeTimes->{{3.5594017382365837`*^9, 3.559401777657853*^9}, {
  3.5846372836420574`*^9, 3.5846373189449196`*^9}, {3.5846385794271336`*^9, 
  3.584638603466776*^9}}],

Cell[CellGroupData[{

Cell[" Input and initialize", "Section",
 CellChangeTimes->{{3.584637446709144*^9, 3.584637454056757*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Input", " ", "angle"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"p", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Rotation", " ", "angle", " ", "in", " ", "degrees"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"degangle", " ", "=", " ", "90"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "arbitrary", " ", "vector", " ", "about", " ", "which", " ", "to", " ", 
     "roatate", " ", "point", " ", "p"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"angle", " ", "to", " ", "radians"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"angle", " ", "=", " ", 
     RowBox[{"degangle", "*", 
      RowBox[{"(", 
       RowBox[{"Pi", "/", "180"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c", " ", "=", " ", 
     RowBox[{"Cos", "[", "angle", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"s", " ", "=", " ", 
     RowBox[{"Sin", "[", "angle", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"normalize", " ", 
     RowBox[{"a", " ", "--"}], " ", "vector", " ", "about", " ", "which", " ",
      "to", " ", "rotate"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", " ", "=", " ", 
     RowBox[{"a", "/", 
      RowBox[{"Norm", "[", "a", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"coordinate", " ", "system"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"o", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"e1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"e2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"e3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Rotate p=\>\"", ",", 
      RowBox[{"MatrixForm", "[", "p", "]"}], ",", "\"\<  by \>\"", ",", 
      "degangle", ",", "\"\<degrees  about a=\>\"", ",", 
      RowBox[{"MatrixForm", "[", "a", "]"}]}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.55940183274155*^9, 3.559401882318437*^9}, {
   3.55940194663735*^9, 3.559402015979472*^9}, {3.559402403733753*^9, 
   3.559402485259496*^9}, {3.5594067330501575`*^9, 3.5594067457641797`*^9}, {
   3.559406861095182*^9, 3.5594068667267923`*^9}, {3.5594078379220977`*^9, 
   3.5594078557997293`*^9}, {3.559408047149665*^9, 3.559408048179267*^9}, {
   3.559408176302292*^9, 3.5594081780962954`*^9}, {3.5594082578748355`*^9, 
   3.5594082789504724`*^9}, {3.559408623305477*^9, 3.5594086417759094`*^9}, {
   3.559409682044937*^9, 3.5594096881601477`*^9}, {3.5846373347009473`*^9, 
   3.584637429252713*^9}, {3.58463749549043*^9, 3.584637513430461*^9}, 
   3.5846385446546726`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Rotate p=\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"1"},
        {"1"},
        {"0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"  by \"\>", 
   "\[InvisibleSpace]", "90", 
   "\[InvisibleSpace]", "\<\"degrees  about a=\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         FractionBox["1", 
          SqrtBox["3"]]},
        {
         FractionBox["1", 
          SqrtBox["3"]]},
        {
         FractionBox["1", 
          SqrtBox["3"]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Rotate p=", 
   MatrixForm[{1, 1, 0}], "  by ", 90, "degrees  about a=", 
   MatrixForm[{3^Rational[-1, 2], 3^Rational[-1, 2], 3^Rational[-1, 2]}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.559402460034252*^9, 3.5594024870690994`*^9}, 
   3.559406972292177*^9, 3.559407276133911*^9, 3.5594077079582696`*^9, {
   3.5594077922608175`*^9, 3.5594078135548553`*^9}, 3.5594078606357374`*^9, 
   3.5594080519388733`*^9, 3.5594081810291004`*^9, 3.5594082821640778`*^9, 
   3.559408632228693*^9, 3.5594089369908285`*^9, 3.5594090737094684`*^9, 
   3.5594095054058266`*^9, 3.5594096926841555`*^9, 3.584637435445924*^9, 
   3.5846377523760805`*^9, 3.584638062613826*^9, 3.5846384992429924`*^9, 
   3.5846385477746778`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rotation matrix in PLA", "Section",
 CellChangeTimes->{{3.559401786113068*^9, 3.5594018168607225`*^9}, 
   3.5594018891200495`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Raxis", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "^", "2"}], " ", "+", " ", 
          RowBox[{"c", "*", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{
              RowBox[{"a", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "^", "2"}]}], ")"}]}]}], ",", 
         " ", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "*", 
           RowBox[{"a", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{"(", 
            RowBox[{"1", "-", "c"}], ")"}]}], " ", "-", " ", 
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"[", "3", "]"}], "]"}], "*", "s"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "*", 
           RowBox[{"a", "[", 
            RowBox[{"[", "3", "]"}], "]"}], "*", 
           RowBox[{"(", 
            RowBox[{"1", "-", "c"}], ")"}]}], " ", "+", " ", 
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", "s"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "*", 
           RowBox[{"a", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{"(", 
            RowBox[{"1", "-", "c"}], ")"}]}], " ", "+", " ", 
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"[", "3", "]"}], "]"}], "*", "s"}]}], ",", " ", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "^", "2"}], " ", "+", " ", 
          RowBox[{"c", "*", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{
              RowBox[{"a", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "^", "2"}]}], ")"}]}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{"a", "[", 
            RowBox[{"[", "3", "]"}], "]"}], "*", 
           RowBox[{"(", 
            RowBox[{"1", "-", "c"}], ")"}]}], " ", "-", " ", 
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "*", "s"}]}]}], "}"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "*", 
           RowBox[{"a", "[", 
            RowBox[{"[", "3", "]"}], "]"}], "*", 
           RowBox[{"(", 
            RowBox[{"1", "-", "c"}], ")"}]}], " ", "-", " ", 
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", "s"}]}], ",", " ", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "*", 
           RowBox[{"a", "[", 
            RowBox[{"[", "3", "]"}], "]"}], "*", 
           RowBox[{"(", 
            RowBox[{"1", "-", "c"}], ")"}]}], " ", "+", " ", 
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "*", "s"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"a", "[", 
            RowBox[{"[", "3", "]"}], "]"}], "^", "2"}], " ", "+", " ", 
          RowBox[{"c", "*", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{
              RowBox[{"a", "[", 
               RowBox[{"[", "3", "]"}], "]"}], "^", "2"}]}], ")"}]}]}]}], 
        "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"newpRaxis", " ", "=", " ", 
     RowBox[{"Raxis", ".", "p"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Raxis = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "Raxis", "]"}], ",", "\"\<     newp = \>\"", 
      ",", 
      RowBox[{"MatrixForm", "[", "newpRaxis", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{
  3.5594018193099265`*^9, {3.5594018936440573`*^9, 3.5594019404285393`*^9}, {
   3.559402036072307*^9, 3.5594023105547895`*^9}, {3.5594025098607397`*^9, 
   3.559402592696885*^9}, {3.5594075263271503`*^9, 3.559407561442812*^9}, {
   3.5846374788764005`*^9, 3.584637484757611*^9}, {3.5846377817665324`*^9, 
   3.584637782109733*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Raxis = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox["1", "3"], 
        RowBox[{
         FractionBox["1", "3"], "-", 
         FractionBox["1", 
          SqrtBox["3"]]}], 
        RowBox[{
         FractionBox["1", "3"], "+", 
         FractionBox["1", 
          SqrtBox["3"]]}]},
       {
        RowBox[{
         FractionBox["1", "3"], "+", 
         FractionBox["1", 
          SqrtBox["3"]]}], 
        FractionBox["1", "3"], 
        RowBox[{
         FractionBox["1", "3"], "-", 
         FractionBox["1", 
          SqrtBox["3"]]}]},
       {
        RowBox[{
         FractionBox["1", "3"], "-", 
         FractionBox["1", 
          SqrtBox["3"]]}], 
        RowBox[{
         FractionBox["1", "3"], "+", 
         FractionBox["1", 
          SqrtBox["3"]]}], 
        FractionBox["1", "3"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"     newp = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         RowBox[{
          FractionBox["2", "3"], "-", 
          FractionBox["1", 
           SqrtBox["3"]]}]},
        {
         RowBox[{
          FractionBox["2", "3"], "+", 
          FractionBox["1", 
           SqrtBox["3"]]}]},
        {
         FractionBox["2", "3"]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Raxis = ", 
   MatrixForm[{{
      Rational[1, 3], Rational[1, 3] - 3^Rational[-1, 2], Rational[1, 3] + 
      3^Rational[-1, 2]}, {Rational[1, 3] + 3^Rational[-1, 2], 
      Rational[1, 3], Rational[1, 3] - 3^Rational[-1, 2]}, {
     Rational[1, 3] - 3^Rational[-1, 2], Rational[1, 3] + 3^Rational[-1, 2], 
      Rational[1, 3]}}], "     newp = ", 
   MatrixForm[{
    Rational[2, 3] - 3^Rational[-1, 2], Rational[2, 3] + 3^Rational[-1, 2], 
     Rational[2, 3]}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.559402543275998*^9, 3.55940259569209*^9, 3.559406972338978*^9, 
   3.5594072761651115`*^9, 3.5594077079894695`*^9, {3.5594077922764177`*^9, 
   3.5594078135860553`*^9}, 3.5594078606513376`*^9, 3.5594080519544735`*^9, 
   3.5594081810603004`*^9, 3.559408282195278*^9, 3.559408632244293*^9, 
   3.5594089370220284`*^9, 3.559409073725068*^9, 3.559409505468227*^9, 
   3.559409692715356*^9, 3.584637435508324*^9, 3.584637752407281*^9, 
   3.5846380626450253`*^9, 3.5846384992897925`*^9, 3.5846385478058777`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

Step-by-step construction : 
build orthonormal frame from a and e1 axis.
     a1 = a, a3 = a1 x e1, a2 = a3 x a1
Rotate frame to coincide with [e1, e2, e3]
Rotate by alpha around e1 axis
Rotate back to original a-frame\
\>", "Section",
 CellChangeTimes->{{3.559402608733713*^9, 3.5594027042838807`*^9}, {
  3.559402745920354*^9, 3.559402775576006*^9}, {3.5846375275328856`*^9, 
  3.584637534989699*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"build", " ", "orthonormal", " ", 
     RowBox[{"frame", " ", "--"}], " ", "a1"}], ",", " ", "a2", ",", " ", 
    RowBox[{
     RowBox[{"a3", " ", "--"}], " ", "with", " ", "successive", " ", "cross", 
     " ", "products"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"a1", " ", "=", " ", "a"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a3", "=", " ", 
     RowBox[{"Cross", "[", 
      RowBox[{"a1", ",", "e1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a3", " ", "=", " ", 
     RowBox[{"a3", "/", 
      RowBox[{"Norm", "[", "a3", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a2", " ", "=", " ", 
     RowBox[{"Cross", "[", 
      RowBox[{"a3", ",", "a1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a2", " ", "=", " ", 
     RowBox[{"a2", "/", 
      RowBox[{"Norm", "[", "a2", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Raframe", " ", "maps", " ", "from", " ", "e1"}], ",", "e2", ",", 
     RowBox[{"e3", " ", "to", " ", "a1"}], ",", "a2", ",", "a3"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Raframe", " ", "=", 
     RowBox[{"{", 
      RowBox[{"a1", ",", " ", "a2", ",", " ", "a3"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Since", " ", 
       RowBox[{"R", "^", "T"}]}], " ", "=", " ", 
      RowBox[{"R", "^", 
       RowBox[{"{", 
        RowBox[{"-", "1"}], "}"}]}]}], ",", " ", 
     RowBox[{"Reframe", " ", "maps", " ", "a1"}], ",", "a2", ",", 
     RowBox[{"a3", " ", "to", " ", "e1"}], ",", "e2", ",", "e3"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Reframe", " ", "=", " ", 
     RowBox[{"Transpose", "[", "Raframe", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"rotate", " ", "around", " ", "e1", " ", "axis"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Rangle", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "c", ",", 
         RowBox[{"-", "s"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "s", ",", "c"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Rotate", " ", "to", " ", "e1"}], ",", "e2", ",", 
     RowBox[{"e3", ";", " ", 
      RowBox[{"rotate", " ", "by", " ", "input", " ", "angle"}]}], ",", " ", 
     RowBox[{"then", " ", "rotate", " ", "back", " ", "to", " ", "a1"}], ",", 
     "a2", ",", "a3"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Rall", " ", "=", " ", 
     RowBox[{"Reframe", ".", "Rangle", ".", "Raframe"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"newpRall", " ", "=", " ", 
     RowBox[{"Rall", ".", "p"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Raframe = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "Raframe", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Reframe = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "Reframe", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Rangle = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "Rangle", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Rall = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "Rall", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
      RowBox[{"Mapped", " ", "point"}], ",", "\"\<newp = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "newpRall", "]"}], ",", 
      "\"\<  Method above newp =\>\"", ",", 
      RowBox[{"MatrixForm", "[", "newpRaxis", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<a1 = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "a1", "]"}], ",", "\[IndentingNewLine]", 
      "\"\<  a2 = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "a2", "]"}], ",", "\[IndentingNewLine]", 
      "\"\<  a3 = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "a3", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.559402779444813*^9, 3.559402860876956*^9}, {
   3.5594057464452243`*^9, 3.5594057669904604`*^9}, {3.5594059633636055`*^9, 
   3.5594060779614067`*^9}, {3.5594061396439147`*^9, 
   3.5594062334936795`*^9}, {3.559406286018972*^9, 3.5594063593235006`*^9}, 
   3.559406722800939*^9, {3.5594075339711637`*^9, 3.5594075409911766`*^9}, {
   3.55940773666232*^9, 3.5594077398291254`*^9}, {3.559407771497181*^9, 
   3.5594077875028095`*^9}, {3.5594081148381844`*^9, 
   3.5594081639314704`*^9}, {3.5594088773675237`*^9, 3.559408891688349*^9}, {
   3.5594090065669503`*^9, 3.5594090701058617`*^9}, {3.5594092798638306`*^9, 
   3.5594093019690695`*^9}, {3.5594094141644664`*^9, 3.559409441760915*^9}, {
   3.5846375614161453`*^9, 3.5846375916021986`*^9}, {3.5846376218818517`*^9, 
   3.584637622006652*^9}, {3.584637658619916*^9, 3.5846376587447166`*^9}, {
   3.5846376912707734`*^9, 3.5846377493808756`*^9}, {3.584637812888587*^9, 
   3.5846378694542866`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Raframe = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox["1", 
         SqrtBox["3"]], 
        FractionBox["1", 
         SqrtBox["3"]], 
        FractionBox["1", 
         SqrtBox["3"]]},
       {
        SqrtBox[
         FractionBox["2", "3"]], 
        RowBox[{"-", 
         FractionBox["1", 
          SqrtBox["6"]]}], 
        RowBox[{"-", 
         FractionBox["1", 
          SqrtBox["6"]]}]},
       {"0", 
        FractionBox["1", 
         SqrtBox["2"]], 
        RowBox[{"-", 
         FractionBox["1", 
          SqrtBox["2"]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Raframe = ", 
   MatrixForm[{{3^Rational[-1, 2], 3^Rational[-1, 2], 3^Rational[-1, 2]}, {
     Rational[2, 3]^Rational[1, 2], -6^Rational[-1, 2], -6^Rational[-1, 2]}, {
     0, 2^Rational[-1, 2], -2^Rational[-1, 2]}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.559406337311862*^9, 3.559406360945904*^9}, 
   3.5594069723701773`*^9, 3.5594072761807113`*^9, 3.5594077080050697`*^9, {
   3.5594077923076177`*^9, 3.559407813617255*^9}, 3.5594078607293377`*^9, 
   3.5594080519700737`*^9, {3.5594081579098597`*^9, 3.5594081810759*^9}, 
   3.5594082822108784`*^9, 3.5594086322754927`*^9, 3.559408937037628*^9, 
   3.5594090737562685`*^9, 3.559409293716655*^9, 3.5594094426033163`*^9, 
   3.5594095054838266`*^9, 3.559409692730956*^9, 3.5846374355551243`*^9, 
   3.584637752438481*^9, 3.5846380626762257`*^9, 3.5846384993053927`*^9, 
   3.584638547821478*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reframe = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox["1", 
         SqrtBox["3"]], 
        SqrtBox[
         FractionBox["2", "3"]], "0"},
       {
        FractionBox["1", 
         SqrtBox["3"]], 
        RowBox[{"-", 
         FractionBox["1", 
          SqrtBox["6"]]}], 
        FractionBox["1", 
         SqrtBox["2"]]},
       {
        FractionBox["1", 
         SqrtBox["3"]], 
        RowBox[{"-", 
         FractionBox["1", 
          SqrtBox["6"]]}], 
        RowBox[{"-", 
         FractionBox["1", 
          SqrtBox["2"]]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Reframe = ", 
   MatrixForm[{{3^Rational[-1, 2], Rational[2, 3]^Rational[1, 2], 0}, {
     3^Rational[-1, 2], -6^Rational[-1, 2], 2^Rational[-1, 2]}, {
     3^Rational[-1, 2], -6^Rational[-1, 2], -2^Rational[-1, 2]}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.559406337311862*^9, 3.559406360945904*^9}, 
   3.5594069723701773`*^9, 3.5594072761807113`*^9, 3.5594077080050697`*^9, {
   3.5594077923076177`*^9, 3.559407813617255*^9}, 3.5594078607293377`*^9, 
   3.5594080519700737`*^9, {3.5594081579098597`*^9, 3.5594081810759*^9}, 
   3.5594082822108784`*^9, 3.5594086322754927`*^9, 3.559408937037628*^9, 
   3.5594090737562685`*^9, 3.559409293716655*^9, 3.5594094426033163`*^9, 
   3.5594095054838266`*^9, 3.559409692730956*^9, 3.5846374355551243`*^9, 
   3.584637752438481*^9, 3.5846380626762257`*^9, 3.5846384993053927`*^9, 
   3.584638547837078*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Rangle = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0"},
       {"0", "0", 
        RowBox[{"-", "1"}]},
       {"0", "1", "0"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Rangle = ", 
   MatrixForm[{{1, 0, 0}, {0, 0, -1}, {0, 1, 0}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.559406337311862*^9, 3.559406360945904*^9}, 
   3.5594069723701773`*^9, 3.5594072761807113`*^9, 3.5594077080050697`*^9, {
   3.5594077923076177`*^9, 3.559407813617255*^9}, 3.5594078607293377`*^9, 
   3.5594080519700737`*^9, {3.5594081579098597`*^9, 3.5594081810759*^9}, 
   3.5594082822108784`*^9, 3.5594086322754927`*^9, 3.559408937037628*^9, 
   3.5594090737562685`*^9, 3.559409293716655*^9, 3.5594094426033163`*^9, 
   3.5594095054838266`*^9, 3.559409692730956*^9, 3.5846374355551243`*^9, 
   3.584637752438481*^9, 3.5846380626762257`*^9, 3.5846384993053927`*^9, 
   3.584638547837078*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Rall = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox["1", "3"], 
        RowBox[{
         FractionBox["1", "3"], "-", 
         FractionBox["1", 
          SqrtBox["3"]]}], 
        RowBox[{
         FractionBox["1", "3"], "+", 
         FractionBox["1", 
          SqrtBox["3"]]}]},
       {
        RowBox[{
         FractionBox["1", "3"], "+", 
         FractionBox["1", 
          SqrtBox["3"]]}], 
        FractionBox["1", "3"], 
        RowBox[{
         FractionBox["1", "3"], "-", 
         FractionBox["1", 
          SqrtBox["3"]]}]},
       {
        RowBox[{
         FractionBox["1", "3"], "-", 
         FractionBox["1", 
          SqrtBox["3"]]}], 
        RowBox[{
         FractionBox["1", "3"], "+", 
         FractionBox["1", 
          SqrtBox["3"]]}], 
        FractionBox["1", "3"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Rall = ", 
   MatrixForm[{{
      Rational[1, 3], Rational[1, 3] - 3^Rational[-1, 2], Rational[1, 3] + 
      3^Rational[-1, 2]}, {Rational[1, 3] + 3^Rational[-1, 2], 
      Rational[1, 3], Rational[1, 3] - 3^Rational[-1, 2]}, {
     Rational[1, 3] - 3^Rational[-1, 2], Rational[1, 3] + 3^Rational[-1, 2], 
      Rational[1, 3]}}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.559406337311862*^9, 3.559406360945904*^9}, 
   3.5594069723701773`*^9, 3.5594072761807113`*^9, 3.5594077080050697`*^9, {
   3.5594077923076177`*^9, 3.559407813617255*^9}, 3.5594078607293377`*^9, 
   3.5594080519700737`*^9, {3.5594081579098597`*^9, 3.5594081810759*^9}, 
   3.5594082822108784`*^9, 3.5594086322754927`*^9, 3.559408937037628*^9, 
   3.5594090737562685`*^9, 3.559409293716655*^9, 3.5594094426033163`*^9, 
   3.5594095054838266`*^9, 3.559409692730956*^9, 3.5846374355551243`*^9, 
   3.584637752438481*^9, 3.5846380626762257`*^9, 3.5846384993053927`*^9, 
   3.584638547837078*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Mapped", " ", "point"}], "\[InvisibleSpace]", "\<\"newp = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         RowBox[{
          FractionBox["2", "3"], "-", 
          FractionBox["1", 
           SqrtBox["3"]]}]},
        {
         RowBox[{
          FractionBox["2", "3"], "+", 
          FractionBox["1", 
           SqrtBox["3"]]}]},
        {
         FractionBox["2", "3"]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   "\[InvisibleSpace]", "\<\"  Method above newp =\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         RowBox[{
          FractionBox["2", "3"], "-", 
          FractionBox["1", 
           SqrtBox["3"]]}]},
        {
         RowBox[{
          FractionBox["2", "3"], "+", 
          FractionBox["1", 
           SqrtBox["3"]]}]},
        {
         FractionBox["2", "3"]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm[$CellContext`Mapped $CellContext`point, "newp = ", 
   MatrixForm[{
    Rational[2, 3] - 3^Rational[-1, 2], Rational[2, 3] + 3^Rational[-1, 2], 
     Rational[2, 3]}], "  Method above newp =", 
   MatrixForm[{
    Rational[2, 3] - 3^Rational[-1, 2], Rational[2, 3] + 3^Rational[-1, 2], 
     Rational[2, 3]}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.559406337311862*^9, 3.559406360945904*^9}, 
   3.5594069723701773`*^9, 3.5594072761807113`*^9, 3.5594077080050697`*^9, {
   3.5594077923076177`*^9, 3.559407813617255*^9}, 3.5594078607293377`*^9, 
   3.5594080519700737`*^9, {3.5594081579098597`*^9, 3.5594081810759*^9}, 
   3.5594082822108784`*^9, 3.5594086322754927`*^9, 3.559408937037628*^9, 
   3.5594090737562685`*^9, 3.559409293716655*^9, 3.5594094426033163`*^9, 
   3.5594095054838266`*^9, 3.559409692730956*^9, 3.5846374355551243`*^9, 
   3.584637752438481*^9, 3.5846380626762257`*^9, 3.5846384993053927`*^9, 
   3.584638547837078*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"a1 = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         FractionBox["1", 
          SqrtBox["3"]]},
        {
         FractionBox["1", 
          SqrtBox["3"]]},
        {
         FractionBox["1", 
          SqrtBox["3"]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"  a2 = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         SqrtBox[
          FractionBox["2", "3"]]},
        {
         RowBox[{"-", 
          FractionBox["1", 
           SqrtBox["6"]]}]},
        {
         RowBox[{"-", 
          FractionBox["1", 
           SqrtBox["6"]]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"  a3 = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"0"},
        {
         FractionBox["1", 
          SqrtBox["2"]]},
        {
         RowBox[{"-", 
          FractionBox["1", 
           SqrtBox["2"]]}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["a1 = ", 
   MatrixForm[{3^Rational[-1, 2], 3^Rational[-1, 2], 3^Rational[-1, 2]}], 
   "  a2 = ", 
   MatrixForm[{
    Rational[2, 3]^Rational[1, 2], -6^Rational[-1, 2], -6^Rational[-1, 2]}], 
   "  a3 = ", 
   MatrixForm[{0, 2^Rational[-1, 2], -2^Rational[-1, 2]}]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.559406337311862*^9, 3.559406360945904*^9}, 
   3.5594069723701773`*^9, 3.5594072761807113`*^9, 3.5594077080050697`*^9, {
   3.5594077923076177`*^9, 3.559407813617255*^9}, 3.5594078607293377`*^9, 
   3.5594080519700737`*^9, {3.5594081579098597`*^9, 3.5594081810759*^9}, 
   3.5594082822108784`*^9, 3.5594086322754927`*^9, 3.559408937037628*^9, 
   3.5594090737562685`*^9, 3.559409293716655*^9, 3.5594094426033163`*^9, 
   3.5594095054838266`*^9, 3.559409692730956*^9, 3.5846374355551243`*^9, 
   3.584637752438481*^9, 3.5846380626762257`*^9, 3.5846384993053927`*^9, 
   3.584638547837078*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

Mathematica command embedded in graphics display\
\>", "Section",
 CellChangeTimes->{{3.5594063763743305`*^9, 3.5594063969507666`*^9}, {
  3.5594067879934535`*^9, 3.559406792751462*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"input", " ", "point", " ", "and", " ", "vector"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ggiven", " ", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{"Red", ",", " ", 
        RowBox[{"PointSize", "[", "Large", "]"}], ",", 
        RowBox[{"Point", "[", "p", "]"}], ",", "\[IndentingNewLine]", "Red", 
        ",", " ", 
        RowBox[{"Thickness", "[", "0.008", "]"}], ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{"o", ",", "a"}], "}"}], "]"}], ",", " ", 
        RowBox[{"RGBColor", "[", 
         RowBox[{"0.6", ",", "0", ",", "0"}], "]"}], ",", " ", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{"o", ",", "a2"}], "}"}], "]"}], ",", " ", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{"o", ",", "a3"}], "}"}], "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"e1", ",", "e2", ",", 
     RowBox[{"e3", " ", "axes"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eaxes", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "0.005", "]"}], ",", "Black", ",", " ", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{"o", ",", "e1"}], "}"}], "]"}], ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{"o", ",", "e2"}], "}"}], "]"}], ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{"o", ",", "e3"}], "}"}], "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"point", " ", "from", " ", "one", " ", "matrix", " ", "method"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"gRaxis", " ", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{"Magenta", ",", 
        RowBox[{"PointSize", "[", "Large", "]"}], ",", 
        RowBox[{"Point", "[", "newpRaxis", "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"point", " ", "from", " ", "constructive", " ", "method"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"gRall", " ", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{"Cyan", ",", 
        RowBox[{"PointSize", "[", "Large", "]"}], ",", 
        RowBox[{"Point", "[", "newpRall", "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"point", " ", "using", " ", "Mathematica", " ", "commands"}], " ",
     "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mpnew", " ", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"PointSize", "[", "Large", "]"}], ",", 
        RowBox[{"Rotate", "[", 
         RowBox[{
          RowBox[{"Point", "[", "p", "]"}], ",", " ", "angle", ",", " ", 
          "a"}], "]"}]}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<Summary:\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<e1,e2,e3 axes colored black\>\"", "]"}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Rotate p=\>\"", ",", 
      RowBox[{"MatrixForm", "[", "p", "]"}], ",", 
      "\"\<  (color red)  by \>\"", ",", "degangle", ",", 
      "\"\<degrees  about a=\>\"", ",", 
      RowBox[{"MatrixForm", "[", "a", "]"}], ",", "\"\< colored red \>\""}], 
     "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<one matrix Raxis = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "Raxis", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<one matrix (Raxis) newp  = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "newpRaxis", "]"}], ",", 
      "\"\<  colored magenta\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<constructive method Rall= \>\"", ",", 
      RowBox[{"MatrixForm", "[", "Rall", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<constructive method (Rall) newp = \>\"", ",", 
      RowBox[{"MatrixForm", "[", "newpRall", "]"}], ",", 
      "\"\<  colord cyan\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", 
     "\"\<Mathematica routines consturction newp is colored blue\>\"", "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", 
     "\"\<If only blue point appears, then all points are equal\>\"", "]"}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{
    "ggiven", ",", "eaxes", ",", " ", "mpnew", ",", " ", "gRaxis", ",", " ", 
     "gRall"}], "]"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5594064202260075`*^9, 3.559406430771626*^9}, {
  3.559406469475294*^9, 3.559406549565835*^9}, {3.5594066119347444`*^9, 
  3.5594066611840305`*^9}, {3.5594066938004885`*^9, 3.5594067136437235`*^9}, {
  3.5594067634702106`*^9, 3.5594070269390736`*^9}, {3.559407127933651*^9, 
  3.5594073667856703`*^9}, {3.5594074009185305`*^9, 3.5594074328049865`*^9}, {
  3.5594074707754526`*^9, 3.559407493567093*^9}, {3.559407583782051*^9, 
  3.559407703933462*^9}, {3.559407752543148*^9, 3.5594077601871614`*^9}, {
  3.5594079035670133`*^9, 3.5594079430350823`*^9}, {3.5594086004046373`*^9, 
  3.55940860786145*^9}, {3.5594094661749573`*^9, 3.559409468109361*^9}, {
  3.559409718611401*^9, 3.5594097189078016`*^9}, {3.584637891965126*^9, 
  3.584638056405015*^9}, {3.584638122736331*^9, 3.5846381667128086`*^9}, {
  3.584638208489682*^9, 3.5846382274593153`*^9}, {3.584638267691786*^9, 
  3.5846384843449664`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Summary:\"\>"], "Print",
 CellChangeTimes->{
  3.5594077080362697`*^9, {3.5594077923232174`*^9, 3.5594078136328554`*^9}, 
   3.559407860744938*^9, 3.559408052001274*^9, 3.5594081810915003`*^9, 
   3.559408282226478*^9, 3.559408632291093*^9, 3.5594089370844283`*^9, 
   3.5594090737874684`*^9, 3.559409505515027*^9, {3.5594096927621555`*^9, 
   3.5594097203118043`*^9}, 3.5846374356019244`*^9, 3.584637752485281*^9, 
   3.584638062723026*^9, 3.584638499367793*^9, 3.584638547868278*^9}],

Cell[BoxData["\<\"e1,e2,e3 axes colored black\"\>"], "Print",
 CellChangeTimes->{
  3.5594077080362697`*^9, {3.5594077923232174`*^9, 3.5594078136328554`*^9}, 
   3.559407860744938*^9, 3.559408052001274*^9, 3.5594081810915003`*^9, 
   3.559408282226478*^9, 3.559408632291093*^9, 3.5594089370844283`*^9, 
   3.5594090737874684`*^9, 3.559409505515027*^9, {3.5594096927621555`*^9, 
   3.5594097203118043`*^9}, 3.5846374356019244`*^9, 3.584637752485281*^9, 
   3.584638062723026*^9, 3.584638499367793*^9, 3.584638547868278*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Rotate p=\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {"1"},
        {"1"},
        {"0"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   "\[InvisibleSpace]", "\<\"  (color red)  by \"\>", "\[InvisibleSpace]", 
   "90", "\[InvisibleSpace]", "\<\"degrees  about a=\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         FractionBox["1", 
          SqrtBox["3"]]},
        {
         FractionBox["1", 
          SqrtBox["3"]]},
        {
         FractionBox["1", 
          SqrtBox["3"]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\" colored red \"\>"}],
  SequenceForm["Rotate p=", 
   MatrixForm[{1, 1, 0}], "  (color red)  by ", 90, "degrees  about a=", 
   MatrixForm[{3^Rational[-1, 2], 3^Rational[-1, 2], 3^Rational[-1, 2]}], 
   " colored red "],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5594077080362697`*^9, {3.5594077923232174`*^9, 3.5594078136328554`*^9}, 
   3.559407860744938*^9, 3.559408052001274*^9, 3.5594081810915003`*^9, 
   3.559408282226478*^9, 3.559408632291093*^9, 3.5594089370844283`*^9, 
   3.5594090737874684`*^9, 3.559409505515027*^9, {3.5594096927621555`*^9, 
   3.5594097203118043`*^9}, 3.5846374356019244`*^9, 3.584637752485281*^9, 
   3.584638062723026*^9, 3.584638499367793*^9, 3.584638547868278*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"one matrix Raxis = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox["1", "3"], 
        RowBox[{
         FractionBox["1", "3"], "-", 
         FractionBox["1", 
          SqrtBox["3"]]}], 
        RowBox[{
         FractionBox["1", "3"], "+", 
         FractionBox["1", 
          SqrtBox["3"]]}]},
       {
        RowBox[{
         FractionBox["1", "3"], "+", 
         FractionBox["1", 
          SqrtBox["3"]]}], 
        FractionBox["1", "3"], 
        RowBox[{
         FractionBox["1", "3"], "-", 
         FractionBox["1", 
          SqrtBox["3"]]}]},
       {
        RowBox[{
         FractionBox["1", "3"], "-", 
         FractionBox["1", 
          SqrtBox["3"]]}], 
        RowBox[{
         FractionBox["1", "3"], "+", 
         FractionBox["1", 
          SqrtBox["3"]]}], 
        FractionBox["1", "3"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["one matrix Raxis = ", 
   MatrixForm[{{
      Rational[1, 3], Rational[1, 3] - 3^Rational[-1, 2], Rational[1, 3] + 
      3^Rational[-1, 2]}, {Rational[1, 3] + 3^Rational[-1, 2], 
      Rational[1, 3], Rational[1, 3] - 3^Rational[-1, 2]}, {
     Rational[1, 3] - 3^Rational[-1, 2], Rational[1, 3] + 3^Rational[-1, 2], 
      Rational[1, 3]}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5594077080362697`*^9, {3.5594077923232174`*^9, 3.5594078136328554`*^9}, 
   3.559407860744938*^9, 3.559408052001274*^9, 3.5594081810915003`*^9, 
   3.559408282226478*^9, 3.559408632291093*^9, 3.5594089370844283`*^9, 
   3.5594090737874684`*^9, 3.559409505515027*^9, {3.5594096927621555`*^9, 
   3.5594097203118043`*^9}, 3.5846374356019244`*^9, 3.584637752485281*^9, 
   3.584638062723026*^9, 3.584638499367793*^9, 3.584638547868278*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"one matrix (Raxis) newp  = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         RowBox[{
          FractionBox["2", "3"], "-", 
          FractionBox["1", 
           SqrtBox["3"]]}]},
        {
         RowBox[{
          FractionBox["2", "3"], "+", 
          FractionBox["1", 
           SqrtBox["3"]]}]},
        {
         FractionBox["2", "3"]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   "\[InvisibleSpace]", "\<\"  colored magenta\"\>"}],
  SequenceForm["one matrix (Raxis) newp  = ", 
   MatrixForm[{
    Rational[2, 3] - 3^Rational[-1, 2], Rational[2, 3] + 3^Rational[-1, 2], 
     Rational[2, 3]}], "  colored magenta"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5594077080362697`*^9, {3.5594077923232174`*^9, 3.5594078136328554`*^9}, 
   3.559407860744938*^9, 3.559408052001274*^9, 3.5594081810915003`*^9, 
   3.559408282226478*^9, 3.559408632291093*^9, 3.5594089370844283`*^9, 
   3.5594090737874684`*^9, 3.559409505515027*^9, {3.5594096927621555`*^9, 
   3.5594097203118043`*^9}, 3.5846374356019244`*^9, 3.584637752485281*^9, 
   3.584638062723026*^9, 3.584638499367793*^9, 3.584638547868278*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"constructive method Rall= \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox["1", "3"], 
        RowBox[{
         FractionBox["1", "3"], "-", 
         FractionBox["1", 
          SqrtBox["3"]]}], 
        RowBox[{
         FractionBox["1", "3"], "+", 
         FractionBox["1", 
          SqrtBox["3"]]}]},
       {
        RowBox[{
         FractionBox["1", "3"], "+", 
         FractionBox["1", 
          SqrtBox["3"]]}], 
        FractionBox["1", "3"], 
        RowBox[{
         FractionBox["1", "3"], "-", 
         FractionBox["1", 
          SqrtBox["3"]]}]},
       {
        RowBox[{
         FractionBox["1", "3"], "-", 
         FractionBox["1", 
          SqrtBox["3"]]}], 
        RowBox[{
         FractionBox["1", "3"], "+", 
         FractionBox["1", 
          SqrtBox["3"]]}], 
        FractionBox["1", "3"]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["constructive method Rall= ", 
   MatrixForm[{{
      Rational[1, 3], Rational[1, 3] - 3^Rational[-1, 2], Rational[1, 3] + 
      3^Rational[-1, 2]}, {Rational[1, 3] + 3^Rational[-1, 2], 
      Rational[1, 3], Rational[1, 3] - 3^Rational[-1, 2]}, {
     Rational[1, 3] - 3^Rational[-1, 2], Rational[1, 3] + 3^Rational[-1, 2], 
      Rational[1, 3]}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5594077080362697`*^9, {3.5594077923232174`*^9, 3.5594078136328554`*^9}, 
   3.559407860744938*^9, 3.559408052001274*^9, 3.5594081810915003`*^9, 
   3.559408282226478*^9, 3.559408632291093*^9, 3.5594089370844283`*^9, 
   3.5594090737874684`*^9, 3.559409505515027*^9, {3.5594096927621555`*^9, 
   3.5594097203118043`*^9}, 3.5846374356019244`*^9, 3.584637752485281*^9, 
   3.584638062723026*^9, 3.584638499367793*^9, 3.584638547868278*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"constructive method (Rall) newp = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", 
     TagBox[GridBox[{
        {
         RowBox[{
          FractionBox["2", "3"], "-", 
          FractionBox["1", 
           SqrtBox["3"]]}]},
        {
         RowBox[{
          FractionBox["2", "3"], "+", 
          FractionBox["1", 
           SqrtBox["3"]]}]},
        {
         FractionBox["2", "3"]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.5599999999999999]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Column], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"  colord cyan\"\>"}],
  SequenceForm["constructive method (Rall) newp = ", 
   MatrixForm[{
    Rational[2, 3] - 3^Rational[-1, 2], Rational[2, 3] + 3^Rational[-1, 2], 
     Rational[2, 3]}], "  colord cyan"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5594077080362697`*^9, {3.5594077923232174`*^9, 3.5594078136328554`*^9}, 
   3.559407860744938*^9, 3.559408052001274*^9, 3.5594081810915003`*^9, 
   3.559408282226478*^9, 3.559408632291093*^9, 3.5594089370844283`*^9, 
   3.5594090737874684`*^9, 3.559409505515027*^9, {3.5594096927621555`*^9, 
   3.5594097203118043`*^9}, 3.5846374356019244`*^9, 3.584637752485281*^9, 
   3.584638062723026*^9, 3.584638499367793*^9, 3.5846385478838778`*^9}],

Cell[BoxData["\<\"Mathematica routines consturction newp is colored \
blue\"\>"], "Print",
 CellChangeTimes->{
  3.5594077080362697`*^9, {3.5594077923232174`*^9, 3.5594078136328554`*^9}, 
   3.559407860744938*^9, 3.559408052001274*^9, 3.5594081810915003`*^9, 
   3.559408282226478*^9, 3.559408632291093*^9, 3.5594089370844283`*^9, 
   3.5594090737874684`*^9, 3.559409505515027*^9, {3.5594096927621555`*^9, 
   3.5594097203118043`*^9}, 3.5846374356019244`*^9, 3.584637752485281*^9, 
   3.584638062723026*^9, 3.584638499367793*^9, 3.5846385478838778`*^9}],

Cell[BoxData["\<\"If only blue point appears, then all points are \
equal\"\>"], "Print",
 CellChangeTimes->{
  3.5594077080362697`*^9, {3.5594077923232174`*^9, 3.5594078136328554`*^9}, 
   3.559407860744938*^9, 3.559408052001274*^9, 3.5594081810915003`*^9, 
   3.559408282226478*^9, 3.559408632291093*^9, 3.5594089370844283`*^9, 
   3.5594090737874684`*^9, 3.559409505515027*^9, {3.5594096927621555`*^9, 
   3.5594097203118043`*^9}, 3.5846374356019244`*^9, 3.584637752485281*^9, 
   3.584638062723026*^9, 3.584638499367793*^9, 3.5846385478838778`*^9}]
}, Open  ]],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[1, 0, 0], PointSize[Large], Point3DBox[{1, 1, 0}], 
    {RGBColor[1, 0, 0], Thickness[0.008], 
     Arrow3DBox[
      NCache[{{0, 0, 0}, {
        3^Rational[-1, 2], 3^Rational[-1, 2], 3^Rational[-1, 2]}}, {{0, 0, 
        0}, {0.5773502691896258, 0.5773502691896258, 0.5773502691896258}}]], 
     {RGBColor[0.6, 0, 0], 
      Arrow3DBox[
       NCache[{{0, 0, 0}, {
         Rational[2, 3]^
          Rational[1, 2], -6^Rational[-1, 2], -6^Rational[-1, 2]}}, {{0, 0, 
         0}, {0.816496580927726, -0.4082482904638631, -0.4082482904638631}}]],
       Arrow3DBox[
       NCache[{{0, 0, 0}, {0, 2^Rational[-1, 2], -2^Rational[-1, 2]}}, {{0, 0,
          0}, {0, 0.7071067811865475, -0.7071067811865475}}]]}}}, 
   {GrayLevel[0], Thickness[0.005], Arrow3DBox[{{0, 0, 0}, {1, 0, 0}}], 
    Arrow3DBox[{{0, 0, 0}, {0, 1, 0}}], Arrow3DBox[{{0, 0, 0}, {0, 0, 1}}]}, 
   {RGBColor[0, 0, 1], PointSize[Large], 
    GeometricTransformation3DBox[Point3DBox[{1, 1, 0}], 
     NCache[{{Rational[1, 3], Rational[1, 3] (1 - 3^Rational[1, 2]), 
        Rational[1, 3] (1 + 3^Rational[1, 2])}, {
       Rational[1, 3] (1 + 3^Rational[1, 2]), Rational[1, 3], 
        Rational[1, 3] (1 - 3^Rational[1, 2])}, {
       Rational[1, 3] (1 - 3^Rational[1, 2]), 
        Rational[1, 3] (1 + 3^Rational[1, 2]), Rational[1, 3]}}, {{
      0.3333333333333333, -0.2440169358562924, 0.910683602522959}, {
      0.910683602522959, 
      0.3333333333333333, -0.2440169358562924}, {-0.2440169358562924, 
      0.910683602522959, 0.3333333333333333}}]]}, 
   {RGBColor[1, 0, 1], PointSize[Large], 
    Point3DBox[
     NCache[{Rational[2, 3] - 3^Rational[-1, 2], Rational[2, 3] + 
       3^Rational[-1, 2], Rational[2, 3]}, {0.08931639747704079, 
      1.2440169358562925`, 0.6666666666666666}]]}, 
   {RGBColor[0, 1, 1], PointSize[Large], 
    Point3DBox[
     NCache[{Rational[2, 3] - 3^Rational[-1, 2], Rational[2, 3] + 
       3^Rational[-1, 2], Rational[2, 3]}, {0.08931639747704079, 
      1.2440169358562925`, 0.6666666666666666}]]}},
  AutomaticImageSize->True,
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 14},
  ImageSize->{360.2441328482143, 380.80654952912477`},
  ViewPoint->{2.8887466001432744`, -1.0358790301771377`, 1.4255166484471373`},
  ViewVertical->{0.31065030352783174`, -0.10806647558028741`, 
   0.9777244628772332}]], "Output",
 CellChangeTimes->{
  3.5594066621980324`*^9, {3.559406954539346*^9, 3.5594069723857775`*^9}, 
   3.559407009498243*^9, {3.5594072712355022`*^9, 3.55940729252954*^9}, {
   3.5594073302036057`*^9, 3.5594073677684717`*^9}, {3.5594074089057446`*^9, 
   3.5594074147713547`*^9}, {3.5594074602142344`*^9, 3.5594074727098565`*^9}, 
   3.5594077080518694`*^9, {3.5594077923388176`*^9, 3.559407813648455*^9}, 
   3.559407860822938*^9, 3.559408052016874*^9, 3.5594081811071005`*^9, 
   3.5594082822420783`*^9, 3.559408632306693*^9, 3.5594089371000285`*^9, 
   3.5594090738186684`*^9, 3.5594095055306273`*^9, {3.5594096927777557`*^9, 
   3.559409720343004*^9}, 3.584637435742325*^9, 3.5846377525320807`*^9, 
   3.5846380627542257`*^9, 3.5846384993989925`*^9, 3.584638547899478*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1042, 630},
WindowMargins->{{Automatic, 125}, {Automatic, 40}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 691, 12, 107, "Subtitle"],
Cell[1273, 36, 740, 15, 182, "Subsubtitle"],
Cell[CellGroupData[{
Cell[2038, 55, 106, 1, 71, "Section"],
Cell[CellGroupData[{
Cell[2169, 60, 3569, 86, 512, "Input"],
Cell[5741, 148, 2428, 62, 101, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8218, 216, 137, 2, 70, "Section"],
Cell[CellGroupData[{
Cell[8380, 222, 4856, 134, 281, "Input"],
Cell[13239, 358, 3445, 96, 80, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16733, 460, 414, 11, 222, "Section"],
Cell[CellGroupData[{
Cell[17172, 475, 5551, 134, 551, "Input"],
Cell[CellGroupData[{
Cell[22748, 613, 2044, 53, 95, "Print"],
Cell[24795, 668, 2044, 53, 95, "Print"],
Cell[26842, 723, 1466, 33, 46, "Print"],
Cell[28311, 758, 2419, 64, 80, "Print"],
Cell[30733, 824, 3003, 80, 79, "Print"],
Cell[33739, 906, 3577, 100, 95, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37377, 1013, 197, 5, 95, "Section"],
Cell[CellGroupData[{
Cell[37599, 1022, 6007, 142, 587, "Input"],
Cell[CellGroupData[{
Cell[43631, 1168, 503, 7, 21, "Print"],
Cell[44137, 1177, 522, 7, 21, "Print"],
Cell[44662, 1186, 2442, 63, 80, "Print"],
Cell[47107, 1251, 2290, 62, 80, "Print"],
Cell[49400, 1315, 1738, 44, 79, "Print"],
Cell[51141, 1361, 2304, 62, 80, "Print"],
Cell[53448, 1425, 1742, 43, 79, "Print"],
Cell[55193, 1470, 553, 8, 21, "Print"],
Cell[55749, 1480, 552, 8, 21, "Print"]
}, Open  ]],
Cell[56316, 1491, 3148, 57, 408, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
