(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     30442,        658]
NotebookOptionsPosition[     29884,        634]
NotebookOutlinePosition[     30228,        649]
CellTagsIndexPosition[     30185,        646]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 "\n"
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
  3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
  3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
  3.5842134956497355`*^9, 3.5842135862546945`*^9}},
 FontFamily->"Arial"],

Cell[TextData[{
 StyleBox["Action of the SVD building blocks",
  FontWeight->"Bold"],
 "\nPlot matrix action for matrices m, m^T.m, and  m.m^T\n\n\nDetails:\nGiven \
a matrix m. Form transpose of m, and call it mt\nForm m.mt and mt.m\nPlot the \
action of these matrices applied to points on the unit circle.\n\nQuestion: \
why does the action of matrix ellipse always line up with action of m.mt \
ellipse?\nAnswer: SVD reveals that Sigma.V^T is an ellipse with major axis on \
x-axis and minor axis on y-axis. \nThe matrix U then rotates the ellipse, \
forming the action ellipse for m.\nIf we consider the SVD of m.m^T, \n\
(U.Sigma.V^T)(U.Sigma.V^T)^T = U.(Sigma.Sigma^T).U^T \nthen we see that the \
position of the ellipse is also determined by U.\n\nOn the other hand, m^T.m \
has SVD   \n   (U.Sigma.V^T)^T (U.Sigma.V^T) = V.(Sigma^T.Sigma).V^T\n   and \
the position of the ellipse is determined by V.\n   \n   \nSVD finds \
orthonormal column vecs U such that A.V = Sigma.U for orthogonal V."
}], "Subsubtitle",
 CellChangeTimes->{{3.5658256398681107`*^9, 3.5658258425436664`*^9}, {
   3.566050023752941*^9, 3.5660503825934434`*^9}, {3.5660504395635233`*^9, 
   3.566050456023546*^9}, {3.5660506096737614`*^9, 3.566050628623788*^9}, {
   3.5660508480740952`*^9, 3.5660509171341915`*^9}, {3.5843701597666445`*^9, 
   3.5843703164568644`*^9}, 3.5843703873669634`*^9, {3.5843706897273865`*^9, 
   3.5843707056374087`*^9}, {3.5843727106062193`*^9, 
   3.5843727491762733`*^9}, {3.584372845186408*^9, 3.584372853086419*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"input", " ", "matrix", " ", "options"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"m0", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";", "      ", 
    RowBox[{"(*", " ", "identity", " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"m1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "1"}], "}"}]}], "}"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"shear", " ", "and", " ", "reflection"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "4"}], "}"}]}], "}"}]}], ";"}], "      ", 
   RowBox[{"(*", " ", "scale", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "4"}], "}"}]}], "}"}]}], ";"}], "      ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m", " ", "=", " ", "m3"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Form", " ", "the", " ", "matrices", " ", "that", " ", "we", " ", "want", 
     " ", "to", " ", "study"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mt", " ", "=", " ", 
     RowBox[{"Transpose", "[", "m", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mmt", " ", "=", " ", 
     RowBox[{"m", ".", "mt"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mtm", " ", "=", " ", 
     RowBox[{"mt", ".", "m"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "divisible", " ", "by", " ", "4", " ", "please", " ", "so", " ", "the", 
     " ", "special", " ", "points", " ", "will", " ", "be", " ", "on", " ", 
     "the", " ", "e1", " ", "and", " ", "e2", " ", "axes"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"numcirclepts", " ", "=", " ", "200"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"numcirclepts", " ", "/", "4"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"del", " ", "=", " ", 
     RowBox[{
      RowBox[{"6", "*", 
       RowBox[{"Pi", "/", "180"}]}], "//", 
      RowBox[{
       RowBox[{"N", " ", "--"}], " ", "was", " ", "using", " ", "#16", " ", 
       "for", " ", 
       RowBox[{"pi", "/", "2"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"del", " ", "=", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "*", "Pi"}], ")"}], "/", "numcirclepts"}], "//", "N"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"i1", " ", "=", " ", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"i2", " ", "=", " ", 
     RowBox[{
      RowBox[{"IntegerPart", "[", 
       RowBox[{"numcirclepts", " ", "/", "4"}], "]"}], " ", "+", " ", "1"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"points", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", "t", "]"}], ",", 
         RowBox[{"Sin", "[", "t", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", " ", 
         RowBox[{"2", "Pi"}], ",", "del"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"numpoints", "=", 
     RowBox[{"Length", "[", "points", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mpoints", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"m", ".", 
        RowBox[{"points", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numpoints"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mmtpoints", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"mmt", ".", 
        RowBox[{"points", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numpoints"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mtmpoints", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"mtm", ".", 
        RowBox[{"points", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numpoints"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"psize", " ", "=", " ", "0.015"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"psize1", " ", "=", " ", "0.04"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"psize2", " ", "=", " ", "0.02"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"thick", " ", "=", " ", "0.0055"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"thick2", " ", "=", " ", "0.005"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ploto", "=", " ", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Black", ",", 
        RowBox[{"Thickness", "[", "thick", "]"}], ",", 
        RowBox[{"Line", "[", "points", "]"}], ",", " ", "\[IndentingNewLine]", 
        RowBox[{"PointSize", "[", "psize", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"PointSize", "[", "psize1", " ", "]"}], ",", " ", 
        RowBox[{"Point", "[", 
         RowBox[{"points", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"PointSize", "[", "psize2", " ", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"points", "[", 
          RowBox[{"[", "i2", "]"}], "]"}], "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotm", " ", "=", " ", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Green", ",", 
        RowBox[{"Thickness", "[", "thick", "]"}], ",", 
        RowBox[{"Line", "[", "mpoints", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"PointSize", "[", "psize", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"PointSize", "[", "psize1", " ", "]"}], ",", " ", 
        RowBox[{"Point", "[", 
         RowBox[{"mpoints", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"PointSize", "[", "psize2", " ", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"mpoints", "[", 
          RowBox[{"[", "i2", "]"}], "]"}], "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotmtm", " ", "=", " ", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"Thickness", "[", "thick", "]"}], ",", 
        RowBox[{"Line", "[", "mtmpoints", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"PointSize", "[", "psize", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"PointSize", "[", "psize1", " ", "]"}], ",", " ", 
        RowBox[{"Point", "[", 
         RowBox[{"mtmpoints", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"PointSize", "[", "psize2", " ", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"mtmpoints", "[", 
          RowBox[{"[", "i2", "]"}], "]"}], "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotmmt", " ", "=", " ", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"Thickness", "[", "thick", "]"}], ",", 
        RowBox[{"Line", "[", "mmtpoints", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"PointSize", "[", "psize", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"PointSize", "[", "psize1", " ", "]"}], ",", " ", 
        RowBox[{"Point", "[", 
         RowBox[{"mmtpoints", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"PointSize", "[", "psize2", " ", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"mmtpoints", "[", 
          RowBox[{"[", "i2", "]"}], "]"}], "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<(black) original data   (green) m=\>\"", ",", 
      RowBox[{"MatrixForm", "[", "m", "]"}], ",", "\"\<    (blue) mtm =\>\"", 
      ",", 
      RowBox[{"MatrixForm", "[", "mtm", "]"}], ",", "\"\<    (red) mmt=\>\"", 
      ",", 
      RowBox[{"MatrixForm", "[", "mmt", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", 
     "\"\<Marking on action ellipses: Large circle is on +e1 axis and small \
circle is on +e2 axis\>\"", "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"ploto", ",", "plotm", ",", " ", "plotmtm", ",", "plotmmt"}], 
    "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5658236149065533`*^9, 3.5658236284161777`*^9}, {
   3.5658236708482523`*^9, 3.5658236712382526`*^9}, {3.565823725573148*^9, 
   3.565823805148888*^9}, {3.565823957748356*^9, 3.565823965189569*^9}, {
   3.565824012754052*^9, 3.5658240198676653`*^9}, {3.5658242148992076`*^9, 
   3.565824528272558*^9}, {3.565824562982619*^9, 3.565824564761022*^9}, {
   3.565824670092407*^9, 3.5658247229453*^9}, {3.5658247620233684`*^9, 
   3.565824767467778*^9}, 3.5658248363886995`*^9, {3.565824869585558*^9, 
   3.5658249502220993`*^9}, {3.565824992498173*^9, 3.56582501333981*^9}, {
   3.5658250528858795`*^9, 3.565825053665881*^9}, {3.5658251276568108`*^9, 
   3.565825158856866*^9}, {3.5658252062497487`*^9, 3.5658252216469755`*^9}, {
   3.5658252726278653`*^9, 3.5658252958251057`*^9}, 3.5658253810012555`*^9, {
   3.5658254387525573`*^9, 3.5658254444465675`*^9}, 3.565825474944621*^9, {
   3.584370426977019*^9, 3.584370444177043*^9}, {3.5843705267971582`*^9, 
   3.5843706611373463`*^9}, {3.5843707373174534`*^9, 3.58437082790758*^9}, {
   3.5843708673176355`*^9, 3.584370943807742*^9}, {3.584372566596018*^9, 
   3.5843725997660646`*^9}, {3.5843726680861597`*^9, 3.584372685806185*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"(black) original data   (green) m=\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2", "1"},
       {"0", "4"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], 
   "\[InvisibleSpace]", "\<\"    (blue) mtm =\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"4", "2"},
       {"2", "17"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"    (red) mmt=\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"5", "4"},
       {"4", "16"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["(black) original data   (green) m=", 
   MatrixForm[{{2, 1}, {0, 4}}], "    (blue) mtm =", 
   MatrixForm[{{4, 2}, {2, 17}}], "    (red) mmt=", 
   MatrixForm[{{5, 4}, {4, 16}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.565824519910943*^9, 3.5658245662898245`*^9, {3.565824672463611*^9, 
   3.56582469993526*^9}, 3.565824737718526*^9, 3.565824768996581*^9, 
   3.565824980517352*^9, 3.565825015149413*^9, 3.565825054929483*^9, {
   3.5658251473908453`*^9, 3.5658251603076677`*^9}, {3.565825213706562*^9, 
   3.565825222863778*^9}, {3.565825282658683*^9, 3.5658252967611074`*^9}, 
   3.5658253837468605`*^9, {3.5658254464121704`*^9, 3.565825476270623*^9}, 
   3.5843709477877483`*^9, 3.584372603256069*^9, 3.5843726891761894`*^9}],

Cell[BoxData["\<\"Marking on action ellipses: Large circle is on +e1 axis and \
small circle is on +e2 axis\"\>"], "Print",
 CellChangeTimes->{
  3.565824519910943*^9, 3.5658245662898245`*^9, {3.565824672463611*^9, 
   3.56582469993526*^9}, 3.565824737718526*^9, 3.565824768996581*^9, 
   3.565824980517352*^9, 3.565825015149413*^9, 3.565825054929483*^9, {
   3.5658251473908453`*^9, 3.5658251603076677`*^9}, {3.565825213706562*^9, 
   3.565825222863778*^9}, {3.565825282658683*^9, 3.5658252967611074`*^9}, 
   3.5658253837468605`*^9, {3.5658254464121704`*^9, 3.565825476270623*^9}, 
   3.5843709477877483`*^9, 3.584372603256069*^9, 3.5843726891761894`*^9}]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0], Thickness[0.0055], LineBox[CompressedData["
1:eJxdlntMlnUUx18umYLiFdGpaDP+KE23Ntc07bjFlnNOuTkVkTQjDVNmRcxo
ijntQpeVTmuoM8cSy5q1LFPqUN5SM8KGJje5y+Xlfc0oWiJk/j7H7YGNvex9
eJ7nd77f7+ecc99TWUkZoT6f7+zt3/8/3c91sb+2Ddkz5a+bQVm+uOuhYdH7
pOfxRi0PBmXD9toxEcMPS9r2hhOFlUG5HtO9KTfmqIRdyUtZpUGpXfrRsvaI
EklrnLrj/oKgZCcXrYrsd1J6B8Qdalp3+/6XwzLGdp+RfwrDzx2ZEZTM8Rcn
xvrPS23skHH7ewKy896x/w4tL5Xnp5Vd/PZYQKKiRmy5VVEmvSnxw6OyArKg
deojwdO/yeXeV7u/GBOQ6p2Lfq37rFyaUoN7jpV0yOiDRXNS370sHTH1Nx5L
75AfW1/prsm8IvnRVVWLOv2yZ3Pc2S6plLWTZ42bsMUvITXxk6ZEVcuSks3z
v4rwS9JBTRtUXiMzz/Wvfji/XRr3x04fOrdWtk15uvd4eLskTho1c2NcnQxI
nPb5+pw2afMdfmJnd50Ude4qyGlolfTU7PCJpfVy471xD/45p1UiD1XPDu5u
kNY1S1dGFrVIcciRntMZjVJ5alCgxdci/i9n5+U80CQjj14M+zr5moyYMHRh
6bUm+fnRTc/s3dcsF/gczvf2f3ZfFc85znPbeI+9186xjHPZOe3cVkcCdVmd
DdRtOixAl1R0CkW359BxN7q+hc4/oLv5EIMv5lMFvv2Ojwn4aj6b75aDHeTC
crKK3FiOssmV5SyL3FkOLZeW0w5yazl+kVxbzheQe+PgVll2s3/ygWLjJN1d
V7ue6+5Xu7/TPV/t+Y3u/RrK+3Pd+XQp58tz59cezg8XavV94OpXq3+w00dN
nySnn5p+V52+apzAhZr+J5w/av7AhRonvdV3/FXjJMX5r4vxHy7U8pHs8qNb
yU+7y5f2J1/kTy1/A10+9Q/yCRdq+Q24fGsF+YYLjSb/8KHGR4z7XofBCXyp
cdLunqvH4AQuNAJODrhz6ZNwEuHOra1wAhdq/M9ydWs9nNA/NAFO1jnd9KbT
0bjQD+EE3dX6E75oNJzgm1bCiW/hHV91Lpzgu0bCCbnQXXBCbnQFnMCF5sAJ
XOizcAIXWmH92+VWb8AJudbVcELudTGcwIU6Tr4ptuvZcGL358CJPd83ynFi
76+DE7jQPDiBC90IJ1bfajix+vfCielDHzEudCGcmL41cNKA/uPhxI8/p+AE
LpQ+p2vwt5/rg2r+J8PJDPJxDU7gQpPghL6r9GH9mPwthxO4UOOkhfx+Dydw
ocYJc0GNk/Pw8QufzI+7/9fGfTU8By7UOGF+qHECF2qcNHPugdQxn7pep064
UOMkEV1MpzB0Y37odnR9B52L0T2ADyO9/UurvP1N+/Q/Dcf3F8jBG+Sijpys
9PZXZS9R46RPf9YL5NJyesnb33Wtt//rCu980Ig3986bvuETmx96CG62cv19
7/zRbu980qve+aXrvPNN8+HaOHkJ7ruor8A7P3WQd77qPPqK9Zkm+s4l9I2l
LxknJ+lbxkmBd/7rQPaDTPxdQl9chP/N9E3jBC7EOOmzn+hK+nIh+RtM3w6S
T7gQ46SDvm9zoM/+pGXMjZ/gYzRzZQicwIUYJ3Bhe9bduWWcfMpcWwInkcw9
4+Q15qJxAhe2Z2mf/VOzmLt/M4ffZi7vgBO4kO/gxOY6e5b22Y81xPkq8XAC
F3IPnMCF5MOJ7R0ZcGJ7VS6cLGNvSYcT26tK4cT2nko4sb1oPZzY3pQJJ7ZX
uflxZuZ/39vDeA==
     "]], 
    {PointSize[0.015], PointBox[{0, 0}]}, 
    {PointSize[0.04], PointBox[{1., 0.}]}, 
    {PointSize[0.02], PointBox[{-1.6081226496766366`*^-16, 1.}]}}, 
   {RGBColor[0, 1, 0], Thickness[0.0055], LineBox[CompressedData["
1:eJw91glQFFcaB/BuLrkHRRZFBDeAokZFY1aDx3tZTbQMhQgSTo0XRomgaFhA
jHeybEzIRhGJghKFAK4xxFWLEPR70VURSRASBDkmwyG3DJeMXDOb8H3MVFFM
VVdPd7/3/f+//uuW3b5hBpIkPfzj78//9OFjXzLCTFTeyyW+KVAzZ4KdYOem
l3oci5V43CnVFHPbxyzycveyxKsS77IfPhRvX8n4UYdNW1QSV4V8vaHdXMXC
Yk5KvVYyj/bLft/CpJFlFWxJXbhI5nH7DcMch5vZvg/ZA8dQmYc7l7k4dbSz
1pKZcy8ekHnyOMfB8eVqFu/46KuCFJlbW088NlLVzXJmJHRty5X52tZ5i9T3
e9mDvV6LT9+VeW1ywOO6b1+w5DuWKavLZD45J3t18BcaNi9HCoqvkfmd1gPD
yvABNpB/snlWvczTjrg91LAhppk/7jf/BpnLypWz51qPsIDyyrKh32XumwOh
VuVaVmFVXDC1UuaNF53eGL9G4vav5CXeeiTzdbMnLT3oJnPINtmpzJd5m5S7
KnlY5h0+rYnHM2W+MTjayKXEgA+/9nbYjRMyt7hSy9Wphnxbf3BUTITMC+Qb
2vthRjxbYR9QtuaP867xwzEzjblNxpyKX1xkPnHaeP+SZmP+dNfvxf94KfGf
lxzafj7dhCuWfzS7vFDif8krM7zpN44/L7o09CJJ4jX3rDpbJFNeGTI/sClU
4m0fhGy1yDblRz37w69Pk3jPl1Nn9a4249+vf7NMKXQsu+/MuZgGMx6ZU+S0
drGOma17/WpUjDk/9feiJTVZWvbJ3G26H40suGx6KeuyQsuWFpnWLjhhwX+7
nl6u2j3CgsUR7+vmlnyR8ZuuWYXDbNery6ZOO2bJkx5Jv85wGGaf2dXUBPRZ
8orD32kStw2x5/b1Pcs3WnGt7LXPPHuQPQtWp+ULKx70TkTTw8YBVqk7Ovz9
FGvu7uyZqXUYYLr1K22td1tz8XXP5eo1L9ne10vLfsi35v7jFZ+f/lDDVE42
Uy9qrfm7Vf0RW1L62csMo6IbngqettVPHXfzBdOZuV15Fqng5uMMXO1K+lho
47wk13MKvv9u9pHI+l5m+PTw+vdBwa94dZf+1NXDQk813M2oVvDIhZEuXoPd
TLuiEcrVCl44Mif/HV0X+8Qmbe6LIQUf0f35UTNMhw3f76Zs8R14rj/u7Nyx
2La9XX/+e583Ntwrb9X/vs3s3MzuH5qZAV3/fH6IyinlGQuh+7vtdSmuYk8D
09L9rzg9Je+blXX653P/mxFf4K7UP/997/0XYuGpfn2CK9zzlvmU69evq/Td
wPTqx6yC1tfjgYP/kXuF+vX3iZr5X91Z0O+PavnOJfLb/2EnaP/4gn7x0+Yv
IYL2V7VKHVXoexMCaf89OkvX33b5H4zNx/F0jwZ58s/wMc1P6mb/O9GGv4Ip
zZfr4cyq1OgKGJs/78+WfPekrhq6aT4Tz1ifPeqigrH5NUjfN8HEtx6qaL5t
E9Z+0xLfCHY0/49Gc9EEY/lw9Em6lgotMIHyU1RZFRJc2QZj+XJ8IheubeuA
fMpfVcwGW01fJ5hTPmNXbZjcFN8F71F+k302fDo9rhtaKd/KSYF1w1E9MJb/
4tg4Pmt7L9RTPxg/WafZ498HPtQf6r4PTiaxFzBUi/0y/cbJtiDXfviK+udA
7Z3X/mmogbF+Sve4Z9FYowE76q9pDhEJb+S+hGrqt6vBsW/5fjQAa6j/1PMt
9w6uGAQL6sfnacW1OsMhOEP9abn5U+MFt4ZgM/Vr7tnjzlt2D0MM9a/6qeeM
rQ4jsJP6OeHb4haz2yNQRf1dW9pgMSdYCz3U74We050yO7Wwg/r/rv+cNK94
HQSSDzIGQ4yURjd1vFpRkIl+iGg8DuSHiMHzgfwQ0qTR3wfyQ9Th9WE7+iEO
4/0B+SEO4v3DXvRD7MDngzb0Q5zH5wfyQ5AfcBn9EP64fkB+CCWuL5xGP4Qz
rj+QH+Ie7g+QHyIV9w/60Q9hgn4A+SH8cP+B/BDNOB+C/BC+OD+C/BDkh2hH
P8QmnD9BfghLnE9BfojbOL+C/BCdON+C/BDkhyA/xC+YD0F+CPJDdKAfQon5
EuSHaMf8CfJDkB/iGvoBWZhfsQv9AEvMtziJfkAC5l9I6Acsw34Q5egHBGF/
iMXoB5Af4t/oByRi/4hy9AM6sZ8E+QHUXyIY/QDqN0F+APWfKEA/YB/2o/BD
P6AO+1P4ox9A/SrOox9AfghL9AOon0U0+gHkh8hBP4D6XUSgH0D9Lx6iH0A+
CHzH6gLyQ+xBP+BjOu6AfujP34B+6H9/Ivqhv34m+gHkm8hDP4D8EEvRD9DQ
87mhH0B+iCL0A8gPsQP9AMkf168e/YAntL4T0Q9ooPXn6Ad00P7YsFE/gPwX
fOGoHyyc9tdm9agfLID2fzX6wTxpPg6gH4z8EMnox9j7iViJfrAMmr+N6AdT
03wmoR+sheZXd2HUD1ZN822DfrCx+a9CP1gh5eMV9IPZUH7K0A/WRvmagn6w
Hyl/FegHo/c7cRD9YEGU3xT0gzVRvlXoB/Om/JMfrIH6wQj9YPT+CT3oB+tH
P8Ad/WBJ1D+H0A92i/rpAvrB7Km/yA9G78eQi36wldR/PegHM6Z+7EI/2Anq
Twv0g4VRv5IfLJ76txv9YBupn/+FfrAS6m8l+sGq0Q94gH6wKOp/8oOFkw/k
B0c/mpf+HzkmNmA=
     "]], 
    {PointSize[0.015], PointBox[{0, 0}]}, 
    {PointSize[0.04], PointBox[{2., 0.}]}, 
    {PointSize[0.02], PointBox[{0.9999999999999997, 4.}]}}, 
   {RGBColor[0, 0, 1], Thickness[0.0055], LineBox[CompressedData["
1:eJwt13lYjmkXAPD2aH1ejPRKpX3vfe2KnmM3NElkyTJjKWuLJUqWJL5sDS1U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     "]], 
    {PointSize[0.015], PointBox[{0, 0}]}, 
    {PointSize[0.04], PointBox[{4., 2.}]}, 
    {PointSize[0.02], PointBox[{1.9999999999999993`, 17.}]}}, 
   {RGBColor[1, 0, 0], Thickness[0.0055], LineBox[CompressedData["
1:eJwt1ws01VkXAPAbKSFdF/eB5JnXxdVbqf824aNSxpBnUlE0Sl8qJiozaXrw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     "]], 
    {PointSize[0.015], PointBox[{0, 0}]}, 
    {PointSize[0.04], PointBox[{5., 4.}]}, 
    {PointSize[0.02], PointBox[{3.999999999999999, 16.}]}}},
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 10}]], "Output",
 CellChangeTimes->{
  3.565824308624172*^9, 3.565824428323182*^9, 3.5658245198953433`*^9, 
   3.5658245662742248`*^9, {3.5658246724480114`*^9, 3.5658246999196596`*^9}, 
   3.565824737718526*^9, 3.5658247690277805`*^9, 3.5658249805329523`*^9, 
   3.5658250151806135`*^9, 3.565825054960683*^9, {3.5658251474220457`*^9, 
   3.565825160323268*^9}, {3.5658252137221622`*^9, 3.565825222894978*^9}, {
   3.565825282689883*^9, 3.565825296792308*^9}, 3.5658253837624607`*^9, {
   3.5658254464277706`*^9, 3.5658254762862234`*^9}, 3.584370947807748*^9, 
   3.584372603276069*^9, 3.58437268919619*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1123, 630},
WindowMargins->{{Automatic, 28}, {Automatic, 35}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 673, 13, 135, "Subtitle"],
Cell[1255, 37, 1529, 22, 428, "Subsubtitle"],
Cell[CellGroupData[{
Cell[2809, 63, 11180, 271, 1272, "Input"],
Cell[CellGroupData[{
Cell[14014, 338, 2808, 68, 36, "Print"],
Cell[16825, 408, 657, 9, 23, "Print"]
}, Open  ]],
Cell[17497, 420, 12359, 210, 447, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
