(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     67224,       1489]
NotebookOptionsPosition[     65800,       1439]
NotebookOutlinePosition[     66143,       1454]
CellTagsIndexPosition[     66100,       1451]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9},
 FontFamily->"Arial"],

Cell[TextData[{
 StyleBox["SVD Plot",
  FontWeight->"Bold"],
 "\nPlot the action of the singular value decomposition of a 2x2 matrix\n"
}], "Subsubtitle",
 CellChangeTimes->{{3.561922232641303*^9, 3.5619222329377036`*^9}, 
   3.5620061523504333`*^9, {3.5620726115589185`*^9, 3.5620726329153557`*^9}, 
   3.5846485717548866`*^9, {3.5846487850228615`*^9, 3.5846487985480847`*^9}, {
   3.5846491966607842`*^9, 3.584649197830786*^9}, {3.584649238734058*^9, 
   3.5846492395608597`*^9}}],

Cell[CellGroupData[{

Cell["\<\

Input matrix\
\>", "Section",
 CellChangeTimes->{{3.5846485813489037`*^9, 3.5846485911301203`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Pick", " ", "a", " ", "matrix", " ", "and", " ", "load", " ", "it", " ", 
    "into", " ", "m"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", "shear", " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"m1", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "scale", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m", " ", "=", " ", "m3"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.5620726520877895`*^9, 3.562072701992277*^9}, {
   3.562072735532336*^9, 3.562072758199176*^9}, {3.562078588534707*^9, 
   3.5620785991271253`*^9}, {3.5620795342207694`*^9, 
   3.5620796401449556`*^9}, {3.5636471916325455`*^9, 3.563647253861055*^9}, {
   3.563647362546446*^9, 3.5636473760716696`*^9}, {3.563647438705779*^9, 
   3.56364746177822*^9}, {3.563647517626318*^9, 3.563647658946966*^9}, {
   3.563647719053872*^9, 3.563647768256358*^9}, {3.5636481195533752`*^9, 
   3.563648259735222*^9}, {3.5636484546107635`*^9, 3.5636484619115763`*^9}, {
   3.5636484920976295`*^9, 3.5636484993048425`*^9}, {3.563648536120907*^9, 
   3.563648597647415*^9}, {3.5636486320298758`*^9, 3.5636486798751593`*^9}, {
   3.563648724943639*^9, 3.56364877124452*^9}, {3.5636488204314065`*^9, 
   3.563648841148243*^9}, {3.5636493060290594`*^9, 3.56364931237827*^9}, {
   3.563649358819552*^9, 3.563649434791685*^9}, {3.5636495009826016`*^9, 
   3.5636495016846027`*^9}, {3.56364953962387*^9, 3.563649655812874*^9}, {
   3.563651429078791*^9, 3.563651477641677*^9}, {3.563651591209876*^9, 
   3.5636516215831294`*^9}, {3.563651818393075*^9, 3.563651869342765*^9}, {
   3.563651933770878*^9, 3.5636521021887736`*^9}, {3.56365214568165*^9, 
   3.5636522239313874`*^9}, {3.563653406803465*^9, 3.563653492806416*^9}, {
   3.56365358032257*^9, 3.563653673439133*^9}, {3.5636537093191967`*^9, 
   3.5636537343416405`*^9}, {3.563672144490912*^9, 3.5636721844581823`*^9}, {
   3.5636722536599035`*^9, 3.563672322736825*^9}, {3.5636726868368416`*^9, 
   3.5636727927962027`*^9}, {3.5636728457030897`*^9, 3.563672866937525*^9}, {
   3.5636729383724394`*^9, 3.563673078842661*^9}, 3.5636731241007338`*^9, {
   3.563673243863326*^9, 3.563673291309003*^9}, {3.563673341718689*^9, 
   3.5636734618456764`*^9}, {3.5636734929745274`*^9, 3.563673550034218*^9}, {
   3.563673626051943*^9, 3.563673650716379*^9}, {3.5636737097756824`*^9, 
   3.5636738073838444`*^9}, {3.5636738404871025`*^9, 3.563673966588122*^9}, {
   3.563674011070199*^9, 3.5636742204333467`*^9}, {3.5636742709506326`*^9, 
   3.5636743527895737`*^9}, {3.5636744371481194`*^9, 
   3.5636744716949787`*^9}, {3.5636746455448503`*^9, 
   3.5636746712088947`*^9}, {3.5636747418514013`*^9, 
   3.5636747613836308`*^9}, {3.5636748430245533`*^9, 
   3.5636748952450314`*^9}, {3.563674963645134*^9, 3.5636752424635696`*^9}, {
   3.563675276270424*^9, 3.5636752767204247`*^9}, {3.563711034890959*^9, 
   3.5637110375273633`*^9}, {3.563711084031045*^9, 3.5637111226723127`*^9}, {
   3.563712346948063*^9, 3.5637123508168697`*^9}, 3.5637124873427105`*^9, {
   3.5637168301079397`*^9, 3.563716853585981*^9}, {3.5647671619635234`*^9, 
   3.5647671620103235`*^9}, {3.5647735514154854`*^9, 3.564773572983117*^9}, {
   3.584648596808531*^9, 3.5846486360582*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

SVD and construct action ellipse\
\>", "Section",
 CellChangeTimes->{{3.5846486382110033`*^9, 3.5846486628278465`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"SVD", " ", "of", " ", "m"}], " ", "=", " ", 
    RowBox[{"uu", ".", "sigma", ".", 
     RowBox[{"vv", "^", "T"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"uu", ",", "sigma", ",", "vv"}], "}"}], "=", 
     RowBox[{"SingularValueDecomposition", "[", "m", "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Form", " ", "transpose", " ", "for", " ", "easy", " ", "plotting", " ", 
     "of", " ", "columns"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"uut", " ", "=", " ", 
     RowBox[{"Transpose", "[", "uu", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<m =   \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "m", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<uu =  \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "uu", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<vv =  \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "vv", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<sigma=\>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "sigma", "]"}], "//", "N"}]}], "]"}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<evecs (as rows) \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "uut", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "divisible", " ", "by", " ", "4", " ", "please", " ", "so", " ", 
     "markers", " ", "appear", " ", "on", " ", "e1", " ", "and", " ", "e2", 
     " ", "axis"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"numcirclepts", " ", "=", " ", "200"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"numcirclepts", " ", "/", "4"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"del", " ", "=", " ", 
     RowBox[{
      RowBox[{"6", "*", 
       RowBox[{"Pi", "/", "180"}]}], "//", 
      RowBox[{
       RowBox[{"N", " ", "--"}], " ", "was", " ", "using", " ", "#16", " ", 
       "for", " ", 
       RowBox[{"pi", "/", "2"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"del", " ", "=", "  ", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "*", "Pi"}], ")"}], "/", "numcirclepts"}], "//", "N"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"i1", " ", "=", " ", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"i2", " ", "=", " ", 
     RowBox[{
      RowBox[{"IntegerPart", "[", 
       RowBox[{"numcirclepts", " ", "/", "4"}], "]"}], " ", "+", " ", "1"}]}],
     ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"construct", " ", "points", " ", "on", " ", "circle"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"points", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", "t", "]"}], ",", 
         RowBox[{"Sin", "[", "t", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", " ", 
         RowBox[{"2", "Pi"}], ",", "del"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"numpoints", "=", 
     RowBox[{"Length", "[", "points", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<generated numpoints =\>\"", ",", "numpoints"}], "]"}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Apply", " ", "SVD", " ", "in", " ", "stages", " ", "to", " ", "see", " ",
      "action", " ", "of", " ", "decomposition"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vpoints", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Transpose", "[", "vv", "]"}], ".", 
        RowBox[{"points", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numpoints"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"svpoints", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"sigma", ".", 
        RowBox[{"Transpose", "[", "vv", "]"}], ".", 
        RowBox[{"points", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numpoints"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"usvpoints", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"uu", ".", "sigma", ".", 
        RowBox[{"Transpose", "[", "vv", "]"}], ".", 
        RowBox[{"points", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numpoints"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mpoints", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"m", ".", 
        RowBox[{"points", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numpoints"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<Created all steps \>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pointsT", " ", "=", " ", 
     RowBox[{"Transpose", "[", "points", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"w0", " ", "=", " ", 
     RowBox[{
      RowBox[{"Max", "[", 
       RowBox[{"pointsT", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "-", " ", 
      RowBox[{"Min", "[", 
       RowBox[{"pointsT", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"h0", " ", "=", " ", 
     RowBox[{
      RowBox[{"Max", "[", 
       RowBox[{"pointsT", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "-", " ", 
      RowBox[{"Min", "[", 
       RowBox[{"pointsT", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"svpointsT", " ", "=", " ", 
     RowBox[{"Transpose", "[", "svpoints", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"w1", " ", "=", " ", 
     RowBox[{
      RowBox[{"Max", "[", 
       RowBox[{"svpointsT", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "-", " ", 
      RowBox[{"Min", "[", 
       RowBox[{"svpointsT", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"h1", "=", " ", 
     RowBox[{
      RowBox[{"Max", "[", 
       RowBox[{"svpointsT", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "-", " ", 
      RowBox[{"Min", "[", 
       RowBox[{"svpointsT", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"usvpointsT", " ", "=", " ", 
     RowBox[{"Transpose", "[", "usvpoints", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"w2", " ", "=", " ", 
     RowBox[{
      RowBox[{"Max", "[", 
       RowBox[{"usvpointsT", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", "-", " ", 
      RowBox[{"Min", "[", 
       RowBox[{"usvpointsT", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"h2", " ", "=", " ", 
     RowBox[{
      RowBox[{"Max", "[", 
       RowBox[{"usvpointsT", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], " ", "-", " ", 
      RowBox[{"Min", "[", 
       RowBox[{"usvpointsT", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"\"\<w0=\>\"", ",", "w0", ",", "\"\<  h0=\>\"", ",", "h0"}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<w1=\>\"", ",", "w1", ",", "\"\<  h1=\>\"", ",", "h1"}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{"\"\<w2=\>\"", ",", "w2", ",", "\"\<  h2=\>\"", ",", "h2"}], 
      "]"}], ";"}], "\[IndentingNewLine]", "*)"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5620726520877895`*^9, 3.562072701992277*^9}, {
   3.562072735532336*^9, 3.562072758199176*^9}, {3.562078588534707*^9, 
   3.5620785991271253`*^9}, {3.5620795342207694`*^9, 
   3.5620796401449556`*^9}, {3.5636471916325455`*^9, 3.563647253861055*^9}, {
   3.563647362546446*^9, 3.5636473760716696`*^9}, {3.563647438705779*^9, 
   3.56364746177822*^9}, {3.563647517626318*^9, 3.563647658946966*^9}, {
   3.563647719053872*^9, 3.563647768256358*^9}, {3.5636481195533752`*^9, 
   3.563648259735222*^9}, {3.5636484546107635`*^9, 3.5636484619115763`*^9}, {
   3.5636484920976295`*^9, 3.5636484993048425`*^9}, {3.563648536120907*^9, 
   3.563648597647415*^9}, {3.5636486320298758`*^9, 3.5636486798751593`*^9}, {
   3.563648724943639*^9, 3.56364877124452*^9}, {3.5636488204314065`*^9, 
   3.563648841148243*^9}, {3.5636493060290594`*^9, 3.56364931237827*^9}, {
   3.563649358819552*^9, 3.563649434791685*^9}, {3.5636495009826016`*^9, 
   3.5636495016846027`*^9}, {3.56364953962387*^9, 3.563649655812874*^9}, {
   3.563651429078791*^9, 3.563651477641677*^9}, {3.563651591209876*^9, 
   3.5636516215831294`*^9}, {3.563651818393075*^9, 3.563651869342765*^9}, {
   3.563651933770878*^9, 3.5636521021887736`*^9}, {3.56365214568165*^9, 
   3.5636522239313874`*^9}, {3.563653406803465*^9, 3.563653492806416*^9}, {
   3.56365358032257*^9, 3.563653673439133*^9}, {3.5636537093191967`*^9, 
   3.5636537343416405`*^9}, {3.563672144490912*^9, 3.5636721844581823`*^9}, {
   3.5636722536599035`*^9, 3.563672322736825*^9}, {3.5636726868368416`*^9, 
   3.5636727927962027`*^9}, {3.5636728457030897`*^9, 3.563672866937525*^9}, {
   3.5636729383724394`*^9, 3.563673078842661*^9}, 3.5636731241007338`*^9, {
   3.563673243863326*^9, 3.563673291309003*^9}, {3.563673341718689*^9, 
   3.5636734618456764`*^9}, {3.5636734929745274`*^9, 3.563673550034218*^9}, {
   3.563673626051943*^9, 3.563673650716379*^9}, {3.5636737097756824`*^9, 
   3.5636738073838444`*^9}, {3.5636738404871025`*^9, 3.563673966588122*^9}, {
   3.563674011070199*^9, 3.5636742204333467`*^9}, {3.5636742709506326`*^9, 
   3.5636743527895737`*^9}, {3.5636744371481194`*^9, 
   3.5636744716949787`*^9}, {3.5636746455448503`*^9, 
   3.5636746712088947`*^9}, {3.5636747418514013`*^9, 
   3.5636747613836308`*^9}, {3.5636748430245533`*^9, 
   3.5636748952450314`*^9}, {3.563674963645134*^9, 3.5636752424635696`*^9}, {
   3.563675276270424*^9, 3.5636752767204247`*^9}, {3.563711034890959*^9, 
   3.5637110375273633`*^9}, {3.563711084031045*^9, 3.5637111226723127`*^9}, {
   3.563712346948063*^9, 3.5637123508168697`*^9}, 3.5637124873427105`*^9, {
   3.5637168301079397`*^9, 3.563716853585981*^9}, {3.5647671619635234`*^9, 
   3.5647671620103235`*^9}, {3.5647735514154854`*^9, 3.564773572983117*^9}, {
   3.584648596808531*^9, 3.5846486360582*^9}, {3.5846486817194796`*^9, 
   3.5846487339171715`*^9}, {3.584648826191334*^9, 3.5846488307933416`*^9}, {
   3.58464908605659*^9, 3.584649089426196*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"m =   \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2.`", "1.`"},
       {"0.`", "1.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["m =   ", 
   MatrixForm[{{2., 1.}, {0., 1.}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.584649099082613*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"uu =  \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.9732489894677302`", 
        RowBox[{"-", "0.22975292054736127`"}]},
       {"0.22975292054736118`", "0.9732489894677301`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["uu =  ", 
   MatrixForm[{{0.9732489894677302, -0.22975292054736127`}, {
    0.22975292054736118`, 0.9732489894677301}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.584649099082613*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vv =  \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.85065080835204`", 
        RowBox[{"-", "0.5257311121191336`"}]},
       {"0.5257311121191336`", "0.8506508083520399`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["vv =  ", 
   MatrixForm[{{0.85065080835204, -0.5257311121191336}, {0.5257311121191336, 
    0.8506508083520399}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.584649099082613*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"sigma=\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2.288245611270737`", "0.`"},
       {"0.`", "0.8740320488976421`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["sigma=", 
   MatrixForm[{{2.288245611270737, 0.}, {0., 0.8740320488976421}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.584649099082613*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"evecs (as rows) \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.9732489894677302`", "0.22975292054736118`"},
       {
        RowBox[{"-", "0.22975292054736127`"}], "0.9732489894677301`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["evecs (as rows) ", 
   MatrixForm[{{0.9732489894677302, 
    0.22975292054736118`}, {-0.22975292054736127`, 0.9732489894677301}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.584649099082613*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"generated numpoints =\"\>", "\[InvisibleSpace]", "201"}],
  SequenceForm["generated numpoints =", 201],
  Editable->False]], "Print",
 CellChangeTimes->{3.584649099082613*^9}],

Cell[BoxData["\<\"Created all steps \"\>"], "Print",
 CellChangeTimes->{3.5846490994102135`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics", "Section",
 CellChangeTimes->{{3.584648834942949*^9, 3.5846488407305593`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"===", "===", "===", "==="}], "=", " ", 
    RowBox[{
     RowBox[{"Create", " ", "Plots"}], " ", "===", "===", "===", "===", "===",
      "===", "\[Equal]"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"sw0", " ", "=", " ", "100"}], ";", "  ", 
    RowBox[{"sh0", " ", "=", " ", "100"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sw1", " ", "=", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"w1", "/", "w0"}], ")"}], "*", "sw0"}]}], ";", "  ", 
    RowBox[{"sh1", " ", "=", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"h1", "/", "h0"}], ")"}], "*", "sh0"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sw2", " ", "=", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"w2", "/", "w0"}], ")"}], "*", "sw0"}]}], ";", "  ", 
    RowBox[{"sh2", " ", "=", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"h2", "/", "h0"}], ")"}], "*", "sh0"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<Screen width and height of orig data = \>\"", ",", "sw0", ",", 
       "\"\<  \>\"", ",", "sh0"}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<Screen width and height of sv data = \>\"", ",", "sw1", ",", 
       "\"\<  \>\"", ",", "sh1"}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<Screen width and height of usv data = \>\"", ",", "sw2", ",", 
       "\"\<  \>\"", ",", "sh2"}], "]"}], ";"}], "\[IndentingNewLine]", 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"these", " ", "work", " ", "for", " ", "bigger", " ", "items"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"psize", " ", "=", " ", "0.015"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"psize1", " ", "=", " ", "0.04"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"psize2", " ", "=", " ", "0.02"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"thick", " ", "=", " ", "0.0055"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"thick2", " ", "=", " ", "0.005"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"scale", " ", "for", " ", "smaller"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"psizeorig", " ", "=", " ", 
     RowBox[{"psize", " ", "*", 
      RowBox[{"(", 
       RowBox[{"w1", "/", "w0"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"psize1orig", " ", "=", " ", 
     RowBox[{"psize1", "*", 
      RowBox[{"(", 
       RowBox[{"w1", "/", "w0"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"psize2orig", " ", "=", " ", 
     RowBox[{"psize2", "*", 
      RowBox[{"(", 
       RowBox[{"w1", "/", "w0"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"thickorig", " ", "=", " ", 
     RowBox[{"thick", "*", 
      RowBox[{"(", 
       RowBox[{"w1", "/", "w0"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"--", " ", "change"}], " ", "from", " ", "points", " ", "to", 
       " ", "smooth", " ", "circle", "\[IndentingNewLine]", "plotorig"}], " ",
       "=", " ", 
      RowBox[{"Graphics", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PointSize", "[", "psize", "]"}], ",", 
         RowBox[{"Point", "[", "points", "]"}], ",", " ", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"PointSize", "[", "psize1", "]"}], ",", " ", 
         RowBox[{"Point", "[", 
          RowBox[{"points", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"PointSize", "[", "psize2", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"points", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], "]"}]}], "}"}], "]"}]}], ";"}], 
    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotorig", " ", "=", " ", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "thickorig", "]"}], ",", 
         RowBox[{"Line", "[", "points", "]"}], ",", " ", 
         "\[IndentingNewLine]", 
         RowBox[{"PointSize", "[", "psizeorig", " ", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"PointSize", "[", "psize1orig", " ", "]"}], ",", " ", 
         RowBox[{"Point", "[", 
          RowBox[{"points", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"PointSize", "[", "psize2orig", " ", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"points", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], "]"}]}], "}"}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"sw0", ",", "sh0"}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotv", " ", "=", " ", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "thickorig", "]"}], ",", " ", 
         RowBox[{"Line", "[", "vpoints", "]"}], ",", " ", 
         "\[IndentingNewLine]", 
         RowBox[{"PointSize", "[", "psizeorig", " ", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"PointSize", "[", "psize1orig", " ", "]"}], ",", " ", 
         RowBox[{"Point", "[", 
          RowBox[{"vpoints", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"PointSize", "[", "psize2orig", " ", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"vpoints", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], "]"}]}], "}"}], ",", " ", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"sw0", ",", "sh0"}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotsv", " ", "=", " ", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "thick", "]"}], ",", 
         RowBox[{"Line", "[", "svpoints", "]"}], ",", " ", 
         "\[IndentingNewLine]", 
         RowBox[{"PointSize", "[", "psize", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"PointSize", "[", "psize1", "]"}], ",", " ", 
         RowBox[{"Point", "[", 
          RowBox[{"svpoints", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"PointSize", "[", "psize2", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"svpoints", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"sw1", ",", "sh1"}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotusv", "=", " ", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Thickness", "[", "thick", "]"}], ",", " ", 
         RowBox[{"Line", "[", "usvpoints", "]"}], ",", " ", 
         "\[IndentingNewLine]", 
         RowBox[{"PointSize", "[", "psize", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"PointSize", "[", "psize1", "]"}], ",", " ", 
         RowBox[{"Point", "[", 
          RowBox[{"usvpoints", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"PointSize", "[", "psize2", "]"}], ",", 
         RowBox[{"Point", "[", 
          RowBox[{"usvpoints", "[", 
           RowBox[{"[", "i2", "]"}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"sw2", ",", "sh2"}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotm", "=", " ", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "thick", "]"}], ",", 
        RowBox[{"Line", "[", "mpoints", "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"PointSize", "[", "psize", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"PointSize", "[", "psize1", "]"}], ",", " ", 
        RowBox[{"Point", "[", 
         RowBox[{"mpoints", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"PointSize", "[", "psize2", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"mpoints", "[", 
          RowBox[{"[", "i2", "]"}], "]"}], "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotscaledaxes", " ", "=", " ", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "thick2", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{
            RowBox[{"sigma", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "1"}], "]"}], "]"}], "*", 
            RowBox[{"{", 
             RowBox[{"1", ",", "0"}], "}"}]}]}], "}"}], "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{
            RowBox[{"sigma", "[", 
             RowBox[{"[", 
              RowBox[{"2", ",", "2"}], "]"}], "]"}], "*", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]}]}], "}"}], "]"}]}], "}"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotscaledevecs", " ", "=", " ", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "thick2", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{
            RowBox[{"sigma", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "1"}], "]"}], "]"}], "*", 
            RowBox[{"uut", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], "]"}], ",", " ", 
        "\[IndentingNewLine]", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{
            RowBox[{"sigma", "[", 
             RowBox[{"[", 
              RowBox[{"2", ",", "2"}], "]"}], "]"}], "*", 
            RowBox[{"uut", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}]}], "}"}], "]"}]}], "}"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"===", "===", "===", "==="}], "=", " ", 
     RowBox[{
     "DISPLAY", " ", "===", "===", "===", "===", "===", "===", "\[Equal]"}]}],
     " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", 
     "\"\<Clockwise: original circle, v, sv, usv (final action)\>\"", "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"pic", " ", "=", " ", 
    RowBox[{"GraphicsGrid", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"plotorig", ",", "plotv"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"plotusv", ",", "plotsv"}], "}"}]}], "}"}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<Plot of original circle\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", "plotorig", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<Plot of v\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", "plotv", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<Plot of sv \>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"plotsv", ",", "plotscaledaxes"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<plot of usv -- final action \>\"", "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"plotusv", ",", " ", "plotscaledevecs"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   StyleBox[
    RowBox[{
     RowBox[{"Export", "[", 
      RowBox[{"\"\<SVD.eps\>\"", ",", " ", "pic"}], "]"}], ";"}],
    FontSize->12], "\[IndentingNewLine]", 
   StyleBox["  ",
    FontSize->12], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5620726520877895`*^9, 3.562072701992277*^9}, {
   3.562072735532336*^9, 3.562072758199176*^9}, {3.562078588534707*^9, 
   3.5620785991271253`*^9}, {3.5620795342207694`*^9, 
   3.5620796401449556`*^9}, {3.5636471916325455`*^9, 3.563647253861055*^9}, {
   3.563647362546446*^9, 3.5636473760716696`*^9}, {3.563647438705779*^9, 
   3.56364746177822*^9}, {3.563647517626318*^9, 3.563647658946966*^9}, {
   3.563647719053872*^9, 3.563647768256358*^9}, {3.5636481195533752`*^9, 
   3.563648259735222*^9}, {3.5636484546107635`*^9, 3.5636484619115763`*^9}, {
   3.5636484920976295`*^9, 3.5636484993048425`*^9}, {3.563648536120907*^9, 
   3.563648597647415*^9}, {3.5636486320298758`*^9, 3.5636486798751593`*^9}, {
   3.563648724943639*^9, 3.56364877124452*^9}, {3.5636488204314065`*^9, 
   3.563648841148243*^9}, {3.5636493060290594`*^9, 3.56364931237827*^9}, {
   3.563649358819552*^9, 3.563649434791685*^9}, {3.5636495009826016`*^9, 
   3.5636495016846027`*^9}, {3.56364953962387*^9, 3.563649655812874*^9}, {
   3.563651429078791*^9, 3.563651477641677*^9}, {3.563651591209876*^9, 
   3.5636516215831294`*^9}, {3.563651818393075*^9, 3.563651869342765*^9}, {
   3.563651933770878*^9, 3.5636521021887736`*^9}, {3.56365214568165*^9, 
   3.5636522239313874`*^9}, {3.563653406803465*^9, 3.563653492806416*^9}, {
   3.56365358032257*^9, 3.563653673439133*^9}, {3.5636537093191967`*^9, 
   3.5636537343416405`*^9}, {3.563672144490912*^9, 3.5636721844581823`*^9}, {
   3.5636722536599035`*^9, 3.563672322736825*^9}, {3.5636726868368416`*^9, 
   3.5636727927962027`*^9}, {3.5636728457030897`*^9, 3.563672866937525*^9}, {
   3.5636729383724394`*^9, 3.563673078842661*^9}, 3.5636731241007338`*^9, {
   3.563673243863326*^9, 3.563673291309003*^9}, {3.563673341718689*^9, 
   3.5636734618456764`*^9}, {3.5636734929745274`*^9, 3.563673550034218*^9}, {
   3.563673626051943*^9, 3.563673650716379*^9}, {3.5636737097756824`*^9, 
   3.5636738073838444`*^9}, {3.5636738404871025`*^9, 3.563673966588122*^9}, {
   3.563674011070199*^9, 3.5636742204333467`*^9}, {3.5636742709506326`*^9, 
   3.5636743527895737`*^9}, {3.5636744371481194`*^9, 
   3.5636744716949787`*^9}, {3.5636746455448503`*^9, 
   3.5636746712088947`*^9}, {3.5636747418514013`*^9, 
   3.5636747613836308`*^9}, {3.5636748430245533`*^9, 
   3.5636748952450314`*^9}, {3.563674963645134*^9, 3.5636752424635696`*^9}, {
   3.563675276270424*^9, 3.5636752767204247`*^9}, {3.563711034890959*^9, 
   3.5637110375273633`*^9}, {3.563711084031045*^9, 3.5637111226723127`*^9}, {
   3.563712346948063*^9, 3.5637123508168697`*^9}, 3.5637124873427105`*^9, {
   3.5637168301079397`*^9, 3.563716853585981*^9}, {3.5647671619635234`*^9, 
   3.5647671620103235`*^9}, {3.5647735514154854`*^9, 3.564773572983117*^9}, {
   3.584648596808531*^9, 3.5846486360582*^9}, {3.5846486817194796`*^9, 
   3.5846487339171715`*^9}, {3.584648826191334*^9, 3.5846488307933416`*^9}, {
   3.5846489944376287`*^9, 3.584649042922514*^9}, {3.5846490916413994`*^9, 
   3.584649095135806*^9}, {3.584649132232671*^9, 3.584649147692298*^9}}],

Cell[BoxData["\<\"Clockwise: original circle, v, sv, usv\"\>"], "Print",
 CellChangeTimes->{3.5647675753486495`*^9, 3.5647735762531214`*^9, 
  3.5658235792916913`*^9, 3.566148876176782*^9, 3.5846485524264526`*^9, 
  3.5846490994414134`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[
       {Thickness[0.012584457920899917`], LineBox[CompressedData["
1:eJxdlntMlnUUx18umYLiFdGpaDP+KE23Ntc07bjFlnNOuTkVkTQjDVNmRcxo
ijntQpeVTmuoM8cSy5q1LFPqUN5SM8KGJje5y+Xlfc0oWiJk/j7H7YGNvex9
eJ7nd77f7+ecc99TWUkZoT6f7+zt3/8/3c91sb+2Ddkz5a+bQVm+uOuhYdH7
pOfxRi0PBmXD9toxEcMPS9r2hhOFlUG5HtO9KTfmqIRdyUtZpUGpXfrRsvaI
EklrnLrj/oKgZCcXrYrsd1J6B8Qdalp3+/6XwzLGdp+RfwrDzx2ZEZTM8Rcn
xvrPS23skHH7ewKy896x/w4tL5Xnp5Vd/PZYQKKiRmy5VVEmvSnxw6OyArKg
deojwdO/yeXeV7u/GBOQ6p2Lfq37rFyaUoN7jpV0yOiDRXNS370sHTH1Nx5L
75AfW1/prsm8IvnRVVWLOv2yZ3Pc2S6plLWTZ42bsMUvITXxk6ZEVcuSks3z
v4rwS9JBTRtUXiMzz/Wvfji/XRr3x04fOrdWtk15uvd4eLskTho1c2NcnQxI
nPb5+pw2afMdfmJnd50Ude4qyGlolfTU7PCJpfVy471xD/45p1UiD1XPDu5u
kNY1S1dGFrVIcciRntMZjVJ5alCgxdci/i9n5+U80CQjj14M+zr5moyYMHRh
6bUm+fnRTc/s3dcsF/gczvf2f3ZfFc85znPbeI+9186xjHPZOe3cVkcCdVmd
DdRtOixAl1R0CkW359BxN7q+hc4/oLv5EIMv5lMFvv2Ojwn4aj6b75aDHeTC
crKK3FiOssmV5SyL3FkOLZeW0w5yazl+kVxbzheQe+PgVll2s3/ygWLjJN1d
V7ue6+5Xu7/TPV/t+Y3u/RrK+3Pd+XQp58tz59cezg8XavV94OpXq3+w00dN
nySnn5p+V52+apzAhZr+J5w/av7AhRonvdV3/FXjJMX5r4vxHy7U8pHs8qNb
yU+7y5f2J1/kTy1/A10+9Q/yCRdq+Q24fGsF+YYLjSb/8KHGR4z7XofBCXyp
cdLunqvH4AQuNAJODrhz6ZNwEuHOra1wAhdq/M9ydWs9nNA/NAFO1jnd9KbT
0bjQD+EE3dX6E75oNJzgm1bCiW/hHV91Lpzgu0bCCbnQXXBCbnQFnMCF5sAJ
XOizcAIXWmH92+VWb8AJudbVcELudTGcwIU6Tr4ptuvZcGL358CJPd83ynFi
76+DE7jQPDiBC90IJ1bfajix+vfCielDHzEudCGcmL41cNKA/uPhxI8/p+AE
LpQ+p2vwt5/rg2r+J8PJDPJxDU7gQpPghL6r9GH9mPwthxO4UOOkhfx+Dydw
ocYJc0GNk/Pw8QufzI+7/9fGfTU8By7UOGF+qHECF2qcNHPugdQxn7pep064
UOMkEV1MpzB0Y37odnR9B52L0T2ADyO9/UurvP1N+/Q/Dcf3F8jBG+Sijpys
9PZXZS9R46RPf9YL5NJyesnb33Wtt//rCu980Ig3986bvuETmx96CG62cv19
7/zRbu980qve+aXrvPNN8+HaOHkJ7ruor8A7P3WQd77qPPqK9Zkm+s4l9I2l
LxknJ+lbxkmBd/7rQPaDTPxdQl9chP/N9E3jBC7EOOmzn+hK+nIh+RtM3w6S
T7gQ46SDvm9zoM/+pGXMjZ/gYzRzZQicwIUYJ3Bhe9bduWWcfMpcWwInkcw9
4+Q15qJxAhe2Z2mf/VOzmLt/M4ffZi7vgBO4kO/gxOY6e5b22Y81xPkq8XAC
F3IPnMCF5MOJ7R0ZcGJ7VS6cLGNvSYcT26tK4cT2nko4sb1oPZzY3pQJJ7ZX
uflxZuZ/39vDeA==
         "]], 
        {PointSize[0.03432124887518159], PointBox[{0, 0}]}, 
        {PointSize[0.09152333033381758], PointBox[{1., 0.}]}, 
        {PointSize[0.04576166516690879], 
         PointBox[{-1.6081226496766366`*^-16, 1.}]}},
       BaseStyle->{FontFamily -> "Helvetica"},
       ImageSize->{100, 100}], {122.03110711175677`, -53.333333333333336`}, 
      ImageScaled[{0.5, 0.5}], {100, 100}], InsetBox[
      GraphicsBox[
       {Thickness[0.012584457920899917`], LineBox[CompressedData["
1:eJw91vtbz3cYx/HKYa4RhRw2JSuJTZqrnFZuqpGzi0klNJe2EDlFDsOmpU3N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         "]], 
        {PointSize[0.03432124887518159], PointBox[{0, 0}]}, 
        {PointSize[0.09152333033381758], 
         PointBox[{0.85065080835204, -0.5257311121191336}]}, 
        {PointSize[0.04576166516690879], 
         PointBox[{0.5257311121191335, 0.85065080835204}]}},
       BaseStyle->{FontFamily -> "Helvetica"},
       ImageSize->{100, 100}], {366.0933213352703, -53.333333333333336`}, 
      ImageScaled[{0.5, 0.5}], {100, 100}]}, {InsetBox[
      GraphicsBox[
       {Thickness[0.0055], LineBox[CompressedData["
1:eJw913tUVPUWB/A5gqiAD3yEoSAFImqQmpXhYx9vli5lISII8ugqit5UMEEu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         "]], 
        {PointSize[0.015], PointBox[{0, 0}]}, 
        {PointSize[0.04], PointBox[{2., -5.551115123125783*^-17}]}, 
        {PointSize[0.02], PointBox[{0.9999999999999994, 1.}]}},
       BaseStyle->{FontFamily -> "Helvetica"},
       ImageSize->{223.60035481162822`, 100.}], {122.03110711175677`, -160.}, 
      ImageScaled[{0.5, 0.5}], {223.60035481162822`, 100.}], InsetBox[
      GraphicsBox[
       {Thickness[0.0055], LineBox[CompressedData["
1:eJwt13lczfkaB/BzDpeo1LTZypIodFvV8DJ6fq3CpTK0qdFI6tpKjMkyJZIM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         "]], 
        {PointSize[0.015], PointBox[{0, 0}]}, 
        {PointSize[0.04], 
         PointBox[{1.9464979789354602`, -0.45950584109472237`}]}, 
        {PointSize[0.02], PointBox[{1.203001910015091, 0.743496068920369}]}},
       BaseStyle->{FontFamily -> "Helvetica"},
       ImageSize->{228.80832583454395`, 87.39700355983516}], {366.0933213352703, -160.},
       ImageScaled[{0.5, 0.5}], {228.80832583454395`, 87.39700355983516}]}}, \
{}},
  BaseStyle->{FontFamily -> "Helvetica"},
  ContentSelectable->True,
  ImageSize->{500.12442844702707`, 225.33333333333334`},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{3.56476757570745*^9, 3.564773576613122*^9, 
  3.5658235796972923`*^9, 3.566148876707183*^9, 3.5846485527852535`*^9, 
  3.5846490994570136`*^9}],

Cell[BoxData[
 GraphicsBox[
  {Thickness[0.012584457920899917`], LineBox[CompressedData["
1:eJxdlntMlnUUx18umYLiFdGpaDP+KE23Ntc07bjFlnNOuTkVkTQjDVNmRcxo
ijntQpeVTmuoM8cSy5q1LFPqUN5SM8KGJje5y+Xlfc0oWiJk/j7H7YGNvex9
eJ7nd77f7+ecc99TWUkZoT6f7+zt3/8/3c91sb+2Ddkz5a+bQVm+uOuhYdH7
pOfxRi0PBmXD9toxEcMPS9r2hhOFlUG5HtO9KTfmqIRdyUtZpUGpXfrRsvaI
EklrnLrj/oKgZCcXrYrsd1J6B8Qdalp3+/6XwzLGdp+RfwrDzx2ZEZTM8Rcn
xvrPS23skHH7ewKy896x/w4tL5Xnp5Vd/PZYQKKiRmy5VVEmvSnxw6OyArKg
deojwdO/yeXeV7u/GBOQ6p2Lfq37rFyaUoN7jpV0yOiDRXNS370sHTH1Nx5L
75AfW1/prsm8IvnRVVWLOv2yZ3Pc2S6plLWTZ42bsMUvITXxk6ZEVcuSks3z
v4rwS9JBTRtUXiMzz/Wvfji/XRr3x04fOrdWtk15uvd4eLskTho1c2NcnQxI
nPb5+pw2afMdfmJnd50Ude4qyGlolfTU7PCJpfVy471xD/45p1UiD1XPDu5u
kNY1S1dGFrVIcciRntMZjVJ5alCgxdci/i9n5+U80CQjj14M+zr5moyYMHRh
6bUm+fnRTc/s3dcsF/gczvf2f3ZfFc85znPbeI+9186xjHPZOe3cVkcCdVmd
DdRtOixAl1R0CkW359BxN7q+hc4/oLv5EIMv5lMFvv2Ojwn4aj6b75aDHeTC
crKK3FiOssmV5SyL3FkOLZeW0w5yazl+kVxbzheQe+PgVll2s3/ygWLjJN1d
V7ue6+5Xu7/TPV/t+Y3u/RrK+3Pd+XQp58tz59cezg8XavV94OpXq3+w00dN
nySnn5p+V52+apzAhZr+J5w/av7AhRonvdV3/FXjJMX5r4vxHy7U8pHs8qNb
yU+7y5f2J1/kTy1/A10+9Q/yCRdq+Q24fGsF+YYLjSb/8KHGR4z7XofBCXyp
cdLunqvH4AQuNAJODrhz6ZNwEuHOra1wAhdq/M9ydWs9nNA/NAFO1jnd9KbT
0bjQD+EE3dX6E75oNJzgm1bCiW/hHV91Lpzgu0bCCbnQXXBCbnQFnMCF5sAJ
XOizcAIXWmH92+VWb8AJudbVcELudTGcwIU6Tr4ptuvZcGL358CJPd83ynFi
76+DE7jQPDiBC90IJ1bfajix+vfCielDHzEudCGcmL41cNKA/uPhxI8/p+AE
LpQ+p2vwt5/rg2r+J8PJDPJxDU7gQpPghL6r9GH9mPwthxO4UOOkhfx+Dydw
ocYJc0GNk/Pw8QufzI+7/9fGfTU8By7UOGF+qHECF2qcNHPugdQxn7pep064
UOMkEV1MpzB0Y37odnR9B52L0T2ADyO9/UurvP1N+/Q/Dcf3F8jBG+Sijpys
9PZXZS9R46RPf9YL5NJyesnb33Wtt//rCu980Ig3986bvuETmx96CG62cv19
7/zRbu980qve+aXrvPNN8+HaOHkJ7ruor8A7P3WQd77qPPqK9Zkm+s4l9I2l
LxknJ+lbxkmBd/7rQPaDTPxdQl9chP/N9E3jBC7EOOmzn+hK+nIh+RtM3w6S
T7gQ46SDvm9zoM/+pGXMjZ/gYzRzZQicwIUYJ3Bhe9bduWWcfMpcWwInkcw9
4+Q15qJxAhe2Z2mf/VOzmLt/M4ffZi7vgBO4kO/gxOY6e5b22Y81xPkq8XAC
F3IPnMCF5MOJ7R0ZcGJ7VS6cLGNvSYcT26tK4cT2nko4sb1oPZzY3pQJJ7ZX
uflxZuZ/39vDeA==
    "]], 
   {PointSize[0.03432124887518159], PointBox[{0, 0}]}, 
   {PointSize[0.09152333033381758], PointBox[{1., 0.}]}, 
   {PointSize[0.04576166516690879], 
    PointBox[{-1.6081226496766366`*^-16, 1.}]}},
  BaseStyle->{FontFamily -> "Helvetica"},
  ImageSize->{100, 100}]], "Output",
 CellChangeTimes->{3.56476757570745*^9, 3.564773576613122*^9, 
  3.5658235796972923`*^9, 3.566148876707183*^9, 3.5846485527852535`*^9, 
  3.5846490994726133`*^9}],

Cell[BoxData["\<\"Plot of v\"\>"], "Print",
 CellChangeTimes->{3.5647675753486495`*^9, 3.5647735762531214`*^9, 
  3.5658235792916913`*^9, 3.566148876176782*^9, 3.5846485524264526`*^9, 
  3.5846490994726133`*^9}],

Cell[BoxData[
 GraphicsBox[
  {Thickness[0.012584457920899917`], LineBox[CompressedData["
1:eJw91vtbz3cYx/HKYa4RhRw2JSuJTZqrnFZuqpGzi0klNJe2EDlFDsOmpU3N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    "]], 
   {PointSize[0.03432124887518159], PointBox[{0, 0}]}, 
   {PointSize[0.09152333033381758], 
    PointBox[{0.85065080835204, -0.5257311121191336}]}, 
   {PointSize[0.04576166516690879], 
    PointBox[{0.5257311121191335, 0.85065080835204}]}},
  BaseStyle->{FontFamily -> "Helvetica"},
  ImageSize->{100, 100}]], "Output",
 CellChangeTimes->{3.56476757570745*^9, 3.564773576613122*^9, 
  3.5658235796972923`*^9, 3.566148876707183*^9, 3.5846485527852535`*^9, 
  3.5846490994726133`*^9}],

Cell[BoxData["\<\"Plot of sv \"\>"], "Print",
 CellChangeTimes->{3.5647675753486495`*^9, 3.5647735762531214`*^9, 
  3.5658235792916913`*^9, 3.566148876176782*^9, 3.5846485524264526`*^9, 
  3.5846490994726133`*^9}],

Cell[BoxData[
 GraphicsBox[{
   {Thickness[0.0055], LineBox[CompressedData["
1:eJwt13lczfkaB/BzDpeo1LTZypIodFvV8DJ6fq3CpTK0qdFI6tpKjMkyJZIM
0yWV7nVVZGku4qZGEc9PWVJpTwttp/0cnU47bca9z/eP5/W8nn8+/zx/vF+f
hTsCN/uJBALBm6/zv+25IFb1vd4XqEkdMD4XUI+xR4X30598AcPiM27m7e/R
7IHmkM1iAXc9ZJ1miVcdOj1090gIEHDeKvZFz4tqUHvv7tD82wLOM8QxOsiy
Gn0vRe3PEwu4pU7bRDb/qsLeIC3bo7OFnM2TkvWJnypQFueztHGDkHM42C+R
uZSjrXjOrrYjQu5OjP/dxFul6NF/2T08RcgNj25QMJe9xSmG2b+k5gu5ur8d
liWcKcCHl+ODXbqE3LuFhyfWz3mNiuP1Qwf/IuLKl/d+WHI7D9MiO2UKOiKu
+KliqqIxj6uPRfpNNxFxXuUaoQ/9sjHwwonfDlqJuJBeO/W2Xen4TUhxLuco
4hKC5401vbqFK9xPngvcKOKCXJfu2nfoItr3ByRMfL2bCrsMkjefhhNuP7zs
Xifi8s3ei4x2pICXwG22lbWIK1I7usw/8wEk++u86jUXcVui0++FZj6CHq0X
+kq6Iu6Qyrk3CfefwU3voryLiiIufk7P/M+ludDSLHSMkgu5ge6hlp32ryDT
VfHsUKmQq4nqA5OMN6CT8eBE610hF+reaPSL9lu45FO9YVuEkCucUn/7kVUp
/FC8wsDPTcg1y+JmaEnL4N8Lsw4oLxFyBkXbY7pjKmBn5J0kH7mAK92YP6/C
ogpOyn+z3vuHgLPpNmv0qngH8aq3Rq1CBNyslDgP3T01oOfldKrTQsAZKDdE
5YzVQpTxZMv+hi8Q4vlp6OWZ93Ag30hbYf0XyPn7gXd1ivXgzse6W9ybgMzk
e3P/GdUAxaKes9cVJmCLTlpc8ngj5PzX0u6I1zgc/WJ0al1mExycrjelLXUM
KstMdH71bwbOydRIXTYKcomJqp+mGFSP6/WYGY5C3an2wLRnYjh7R9fuJ98R
0N0f8fNq3xYoN3ZuVYr9DDWmZ2LFolZwCRNYGj37BNMKLA4cu9oK2mZHrFXE
w7DXvXyiwawNXAM2pHR8GYIVa0LCOnLbwFJpbah85hCUa9z8R9DGdrhxXHHf
zmWD0GO229itvB0K7VcdDPt2AGY62hUecemAtTcdZaHQD4uH4u2yCjrgRppC
5DWbPqg0Kvjcv6YTnowUaOtb98JVp6nFKnc64UMzoPNqOeyYEmsi/6YL5Kkz
DJ7vkIH5ojeLjgV3QXrfQJz52o+QH5tim1DUBetjd84K15PAQHt3ockCCbjK
E9+aj3ZAXIYg0XifBJrbVMKqC9tgLGGWQ/hDCWzrG/vlc3wL3F3LCTT6JSD7
vizMwLsZfj//Nqd6uRSifRcMdK5pgCG1IL1n3lKoLJSOfsiuhWFJ6ZXHUVKI
MU3RdzGuAvP25w65d6WQL+YM9ySVwvWR0elFb6Tw8V6x6Q2tfPg0uiemtFEK
qYluplmlT8FaS3ljgUwKJ7a8dobaWyC+6BycOSQFrjZ0amDXFVwSqSa6MCyF
BWX+9Ze2Z+Ph7+a+9OiVQpDvzMOmjS8xddFfN2q0SsHxsa+/2rQSzHBKGsgt
+Zqnr6sUrVmJiUkR9bszpHCrmf8Ydq0GHfjtcrUYKfwRM+/VSv16FPnsrMsL
kILi99eUC8qbsHWSg2LUSilkWeTffKTcgiFKcel7hFKIa5gtq7Rtw5DY/+Qc
z5OA8o/hTTGHOjBevqikIFQCxsY/lvsmdWH7Q5mdv7kEKs56JzzJk2Loyval
fs1dINR59btKczeOvZ5kWRvVBRbv4myrh3pQ44pufu3SLngx48RLe1Evpok8
mkJfdILatufVFZP70Nagc7bYvRP4qlWRlaJ+3Nqdd2NeRwdoBAhvTh3rx6Lz
GVYugR3g8F2FlZF8AGc9VjdM6G2HyqTBG9MbB3FMXd9EfX87uO4qCfXJH8Lg
2tmnW1q//v3DktqBO8OY3HG5YrlrG2w6NMUi+uwnHJyvtEw1txVOetvGD/h8
xvC9Ef2ZBq3gGXj9Yq/pCErur5HZ/toC6vxlT+exEdw6uW6huF0Mm45dLa3H
UdTPta3KthJDUey88wHHx3BaPUQMXmwGZc0+CW86jtar0iv5piawq/HVzm4c
R/H9+HOOy5vAJfO14eLICURN30k/tTSAF/mBleQHxJEfuJz8AOYHz/wAZ/KD
9yQ/gPnBMz+A+cHrkR/A/OA58gOYHzzzA5gffCr5AcwPnvkBzA++jPwA5gdf
SX4A84N/QX4A84PPJz+A+cH7kB+wn/zgfcgPYH7wF8gPMCc/eAH5AXbkB88V
/d8PZH7wzA/cRn7wTeQHMj94L/IDmR98BPmBzA8+kfxA5gfP/EDmB99AfiDz
g2d+IPODLyM/0Jv84FvJD2R+8MwP9CM/+CLyA8PJD34d+YHMD16b/EDmB7+M
/EDmBx4mPzCY/MAn5AduJT/wKfmBb8kPdCc/kPmBzA9kfmAF+YHW5Af2kB+o
SH5gPfmBkeQH6pEfWEZ+IPMDN5MfqEB+4HzyA3eTH+hCfuC35Aeakx9YSX4g
8wPl5AcWkR+oRX7gevIDF5EfmEh+YBX5gVnkByaRH/ie/EBf8gMHyA9kfmAW
+YHMD7QnP3CQ/MBN5AcyP7CJ/MBx8gO9yQ9kfmA/+YGp5AdGkB84TH5gLvmB
zA+8QH6gGfmBpeQHXiM/MJX8QOYHBpEfaEN+4ALyA5kfKCA/gPmBCuQH/Ex+
4APyA5gfGEB+APMDo8kPYH5gMvkBzA9MIz+A+YFzyQ8Qkx+YQ34A8wMTyQ9g
fqAS+QHMDzQkP4D5gWLyA46THziV/IAR8gNXkx+gRn5gHvkBD8gPVCU/wI78
wFzyA7aQH6hFfkAB+YGO5AcwP5D5AePkBzI/gPmBE+QHJJIf6EJ+wAD5gafJ
DwgjP9CD/AAp+YHMD3AlP9CF/IAl5AcWkx8wlfxAFfIDrMgPtCU/oIX8QGfy
A3jyA71Z/yhh/eNPnRGsgg==
     "]], 
    {PointSize[0.015], PointBox[{0, 0}]}, 
    {PointSize[0.04], PointBox[{1.9464979789354602`, -0.45950584109472237`}]}, 
    {PointSize[0.02], PointBox[{1.203001910015091, 0.743496068920369}]}}, 
   {Thickness[0.005], 
    LineBox[NCache[{{0, 0}, {(3 + 5^Rational[1, 2])^Rational[1, 2], 0}}, {{0, 
       0}, {2.288245611270737, 0}}]], 
    LineBox[NCache[{{0, 0}, {0, (3 - 5^Rational[1, 2])^Rational[1, 2]}}, {{0, 
       0}, {0, 0.8740320488976421}}]]}},
  BaseStyle->{FontFamily -> "Helvetica"},
  ImageSize->{228.80832583454395`, 87.39700355983516}]], "Output",
 CellChangeTimes->{3.56476757570745*^9, 3.564773576613122*^9, 
  3.5658235796972923`*^9, 3.566148876707183*^9, 3.5846485527852535`*^9, 
  3.5846490994726133`*^9}],

Cell[BoxData["\<\"plot of usv -- final action \"\>"], "Print",
 CellChangeTimes->{3.5647675753486495`*^9, 3.5647735762531214`*^9, 
  3.5658235792916913`*^9, 3.566148876176782*^9, 3.5846485524264526`*^9, 
  3.5846490994726133`*^9}],

Cell[BoxData[
 GraphicsBox[{
   {Thickness[0.0055], LineBox[CompressedData["
1:eJw913tUVPUWB/A5gqiAD3yEoSAFImqQmpXhYx9vli5lISII8ugqit5UMEEu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     "]], 
    {PointSize[0.015], PointBox[{0, 0}]}, 
    {PointSize[0.04], PointBox[{2., -5.551115123125783*^-17}]}, 
    {PointSize[0.02], PointBox[{0.9999999999999994, 1.}]}}, 
   {Thickness[0.005], 
    LineBox[NCache[{{0, 
       0}, {(2 + 5^Rational[1, 2]) ((3 + 5^Rational[1, 2])/(
          1 + (2 + 5^Rational[1, 2])^2))^
         Rational[1, 2], ((3 + 5^Rational[1, 2])/(
         1 + (2 + 5^Rational[1, 2])^2))^Rational[1, 2]}}, {{0, 0}, {
       2.2270327288232137`, 0.5257311121191336}}]], 
    LineBox[NCache[{{0, 
       0}, {(2 - 5^
         Rational[1, 2]) ((3 - 5^Rational[1, 2])/(
          1 + (2 - 5^Rational[1, 2])^2))^
         Rational[1, 2], ((3 - 5^Rational[1, 2])/(
         1 + (2 - 5^Rational[1, 2])^2))^Rational[1, 2]}}, {{0, 
       0}, {-0.20081141588622736`, 0.8506508083520399}}]]}},
  BaseStyle->{FontFamily -> "Helvetica"},
  ImageSize->{223.60035481162822`, 100.}]], "Output",
 CellChangeTimes->{3.56476757570745*^9, 3.564773576613122*^9, 
  3.5658235796972923`*^9, 3.566148876707183*^9, 3.5846485527852535`*^9, 
  3.5846490994726133`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1017, 716},
WindowMargins->{{Automatic, 32}, {5, Automatic}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 691, 12, 107, "Subtitle"],
Cell[1273, 36, 482, 9, 67, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1780, 49, 110, 4, 97, "Section"],
Cell[1893, 55, 4053, 76, 212, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5983, 136, 130, 4, 97, "Section"],
Cell[CellGroupData[{
Cell[6138, 144, 11667, 284, 1032, "Input"],
Cell[CellGroupData[{
Cell[17830, 432, 824, 23, 36, "Print"],
Cell[18657, 457, 988, 25, 36, "Print"],
Cell[19648, 484, 978, 25, 36, "Print"],
Cell[20629, 511, 886, 23, 36, "Print"],
Cell[21518, 536, 1008, 25, 36, "Print"],
Cell[22529, 563, 224, 5, 23, "Print"],
Cell[22756, 570, 96, 1, 23, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22913, 578, 95, 1, 71, "Section"],
Cell[CellGroupData[{
Cell[23033, 583, 16480, 378, 1612, "Input"],
Cell[39516, 963, 240, 3, 23, "Print"],
Cell[39759, 968, 12318, 213, 240, "Output"],
Cell[52080, 1183, 2390, 43, 115, "Output"],
Cell[54473, 1228, 211, 3, 23, "Print"],
Cell[54687, 1233, 2831, 50, 115, "Output"],
Cell[57521, 1285, 213, 3, 23, "Print"],
Cell[57737, 1290, 3895, 67, 102, "Output"],
Cell[61635, 1359, 230, 3, 23, "Print"],
Cell[61868, 1364, 3892, 70, 115, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
