(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     73745,       1473]
NotebookOptionsPosition[     71856,       1414]
NotebookOutlinePosition[     72299,       1431]
CellTagsIndexPosition[     72256,       1428]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9},
 FontFamily->"Arial"],

Cell[TextData[{
 "\n",
 StyleBox["SVD and Image Compression",
  FontWeight->"Bold"],
 "\nDemonstrate how SVD can be used for image compression.\nInput an image: \
an n x n table of colored pixels. This is the matrix.\nA matrix can be \
written in terms of k rank one matrices, where the matrix has k nonzero \
singular values:\nA = sigma_1u_1v_1^T + sigma_2u_2v_2^T + .....\nImages of \
varing quality can be created as follows.\nA_1 = sigma_1u_1v_1^T --> highes \
compression\nA_k involves all terms, thus is equal to the original image\nSee \
Section 16.7 for details."
}], "Subsubtitle",
 CellChangeTimes->{{3.5847165214193525`*^9, 3.5847165501993933`*^9}, {
  3.5847168067697525`*^9, 3.5847171260201993`*^9}}],

Cell[CellGroupData[{

Cell["\<\

Input image: table of gray scales\
\>", "Section",
 CellChangeTimes->{{3.584716582709439*^9, 3.5847166167494864`*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Select", " ", "one", " ", "data", " ", "set", " ", "and", " ", "load", 
    " ", "it", " ", "into", " ", "m"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"--", 
    RowBox[{"--", 
     RowBox[{"--", 
      RowBox[{"--", 
       RowBox[{"--", 
        RowBox[{"--", 
         RowBox[{"--", 
          RowBox[{"--", 
           RowBox[{"--", 
            RowBox[{"--", 
             RowBox[{"--", 
              RowBox[{"--", 
               RowBox[{"--", 
                RowBox[{"--", 
                 RowBox[{"--", 
                  RowBox[{"--", 
                   RowBox[{"--", 
                    RowBox[{"--", 
                    RowBox[{"--", "-"}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}]}], 
   " ", "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dim", " ", "=", " ", "6"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mrandom", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"RandomInteger", "[", "dim", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "dim"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "dim"}], "}"}]}], "]"}]}], " ", ";"}], 
   " ", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"m", " ", "=", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "2", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"example", " ", "in", " ", "svd"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mex", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "2", ",", "3", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "3", ",", "0", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2", ",", "1", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mcross", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
         "1"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
         "1"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
         "0"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
         "0"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
         "0"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
        "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
         "0"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
         "1"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
        "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", 
         "1"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"i", "\[GreaterEqual]", "4"}], " ", "&&", " ", 
          RowBox[{"i", "\[LessEqual]", " ", "5"}]}], " ", "||", " ", 
         RowBox[{
          RowBox[{"j", "\[GreaterEqual]", "4"}], " ", "&&", " ", 
          RowBox[{"j", " ", "\[LessEqual]", " ", "5"}]}]}], ",", " ", 
        RowBox[{
         RowBox[{"mcross", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", "1"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "1", ",", "8"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"load", " ", "data", " ", "set", " ", "to", " ", "use"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m", " ", "=", " ", "mcross"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"dim", ",", "dim2"}], "}"}], " ", "=", " ", 
     RowBox[{"Dimensions", "[", "m", "]"}]}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5661408497850227`*^9, 3.5661408645894485`*^9}, {
   3.5661484907173047`*^9, 3.566148495459713*^9}, {3.5661485960314903`*^9, 
   3.5661486832980433`*^9}, {3.5661487167133017`*^9, 
   3.5661488519499397`*^9}, {3.566149015251026*^9, 3.5661490608655066`*^9}, {
   3.566149146228856*^9, 3.566149170471299*^9}, {3.5661492721210775`*^9, 
   3.5661494058289127`*^9}, {3.566149451240592*^9, 3.5661495155595055`*^9}, {
   3.5661495533895717`*^9, 3.5661497123694506`*^9}, {3.5661497589043326`*^9, 
   3.566149958693884*^9}, {3.5661500266788025`*^9, 3.566150138374999*^9}, {
   3.5661502048155155`*^9, 3.566150221897546*^9}, {3.566150254564003*^9, 
   3.5661502899760656`*^9}, {3.566150444275936*^9, 3.566150497144429*^9}, {
   3.5661506670755277`*^9, 3.5661507108960047`*^9}, 3.5661510774030485`*^9, {
   3.5661511658084035`*^9, 3.5661511661984043`*^9}, {3.5661512502045517`*^9, 
   3.5661514048164234`*^9}, {3.566151489930173*^9, 3.5661514937833796`*^9}, {
   3.566151594637557*^9, 3.5661516069771786`*^9}, {3.566152191756606*^9, 
   3.566152242441095*^9}, {3.5701962718919015`*^9, 3.5701962938943396`*^9}, {
   3.570196365609264*^9, 3.570196406104533*^9}, {3.570196892886982*^9, 
   3.5701970639748783`*^9}, {3.5701971027105455`*^9, 
   3.5701971329745984`*^9}, {3.5701972200851517`*^9, 
   3.5701972774808507`*^9}, {3.5701973226125298`*^9, 3.570197391116248*^9}, {
   3.5701975063532495`*^9, 3.5701975343864985`*^9}, {3.5701975707153616`*^9, 
   3.570197616875843*^9}, {3.570197653003105*^9, 3.570197701094389*^9}, {
   3.5701977899741445`*^9, 3.5701977920645485`*^9}, {3.5701978325382166`*^9, 
   3.570197832881417*^9}, {3.570197870354682*^9, 3.5701979104819508`*^9}, {
   3.570197953148026*^9, 3.5701979665016494`*^9}, {3.5701980681294265`*^9, 
   3.570198068425827*^9}, {3.5701981312107344`*^9, 3.570198131694336*^9}, 
   3.5701981913620396`*^9, {3.5701987384569855`*^9, 3.570198764774232*^9}, {
   3.570198840177161*^9, 3.570198847926774*^9}, {3.570198881342033*^9, 
   3.5701988903432484`*^9}, {3.57019894929495*^9, 3.5701989639433756`*^9}, {
   3.5701989979982357`*^9, 3.5701991346780734`*^9}, {3.5701991940821753`*^9, 
   3.5701991965313797`*^9}, {3.5701992417090592`*^9, 
   3.5701992783199224`*^9}, {3.570199320611597*^9, 3.5701994403014064`*^9}, {
   3.5847166246794977`*^9, 3.5847167068396125`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

Image compression\
\>", "Section",
 CellChangeTimes->{{3.5847166918295918`*^9, 3.5847167283696423`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"if", " ", "want", " ", "last", " ", "image", " ", "displayed"}], 
    ",", " ", 
    RowBox[{"make", " ", "this", " ", "value", " ", "1"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "the", " ", "last", " ", "image", " ", "is", " ", "identical", " ", "to", 
    " ", "the", " ", "input"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"displaylast", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"displaylast", " ", "\[Equal]", " ", "0"}], ",", " ", 
      RowBox[{"numplots", "=", "dim"}], ",", " ", 
      RowBox[{"numplots", "=", 
       RowBox[{"dim", "+", "1"}]}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<m = \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "m", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<dimension = \>\"", ",", "dim"}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Create", " ", "data", " ", "structure"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plots", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numplots"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"plots", "[", 
      RowBox[{"[", "1", "]"}], "]"}], " ", "=", " ", 
     RowBox[{"ArrayPlot", "[", "m", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"SVD", " ", "of", " ", "m"}], " ", "=", " ", 
     RowBox[{"uu", ".", "sigma", ".", 
      RowBox[{"vv", "^", "T"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"uu", ",", "sigma", ",", "vv"}], "}"}], "=", 
     RowBox[{"SingularValueDecomposition", "[", "m", "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<uu =  \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "uu", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<vv =  \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "vv", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<sigma=\>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "sigma", "]"}], "//", "N"}]}], "]"}], ";"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"uut", " ", "=", " ", 
     RowBox[{"Transpose", "[", "uu", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vvt", " ", "=", " ", 
     RowBox[{"Transpose", "[", "vv", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mcompress", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "dim"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "dim"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m1", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "dim"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "1", ",", "dim"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<ready for making matrices\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"(", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{"\"\<k=\>\"", ",", "k", ",", "\"\<  sigma =\>\"", ",", 
          RowBox[{
           RowBox[{"sigma", "[", 
            RowBox[{"[", 
             RowBox[{"k", ",", "k"}], "]"}], "]"}], "//", "N"}]}], "]"}], ";",
         "\[IndentingNewLine]", 
        RowBox[{"u", " ", "=", " ", 
         RowBox[{"uut", "[", 
          RowBox[{"[", "k", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"v", " ", "=", " ", 
         RowBox[{"vvt", "[", 
          RowBox[{"[", "k", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Do", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"m1", "[", 
            RowBox[{"[", 
             RowBox[{"i", ",", "j"}], "]"}], "]"}], "=", " ", 
           RowBox[{
            RowBox[{"sigma", "[", 
             RowBox[{"[", 
              RowBox[{"k", ",", "k"}], "]"}], "]"}], "*", 
            RowBox[{"u", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "*", 
            RowBox[{"v", "[", 
             RowBox[{"[", "j", "]"}], "]"}]}]}], ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"i", ",", "1", ",", "dim"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "1", ",", "dim"}], "}"}]}], "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"mcompress", " ", "=", " ", 
         RowBox[{"mcompress", " ", "+", " ", "m1"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"k", "\[Equal]", "dim"}], ",", "\[IndentingNewLine]", 
            RowBox[{"Print", "[", 
             RowBox[{"\"\<m1 = \>\"", ",", 
              RowBox[{
               RowBox[{"MatrixForm", "[", "m1", "]"}], "//", "N"}], ",", 
              "\"\<   mcompress = \>\"", ",", 
              RowBox[{
               RowBox[{"MatrixForm", "[", "mcompress", "]"}], "//", "N"}]}], 
             "]"}]}], "]"}], ";"}], "\[IndentingNewLine]", "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"Print", "[", "\"\<make array plot\>\"", "]"}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"plots", "[", 
          RowBox[{"[", 
           RowBox[{"1", "+", "k"}], "]"}], "]"}], " ", "=", " ", 
         RowBox[{"ArrayPlot", "[", "mcompress", "]"}]}]}], ")"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"k", ",", "1", ",", 
        RowBox[{"numplots", "-", "1"}]}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Do", "[", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Show", "[", 
        RowBox[{"plots", "[", 
         RowBox[{"[", "k", "]"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"k", ",", "1", ",", 
         RowBox[{"dim", "+", "1"}]}], "}"}]}], "]"}], ";"}], 
    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<Left: original image\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", 
     "\"\<Second from left to right: adding successive terms\>\"", "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"pic", " ", "=", " ", 
    RowBox[{"GraphicsRow", "[", "plots", "]"}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<Left: original image\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", "\"\<Second from left to right: First three terms\>\"", 
     "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"pic2", " ", "=", " ", 
    RowBox[{"GraphicsRow", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"plots", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"plots", "[", 
        RowBox[{"[", "2", "]"}], "]"}], ",", 
       RowBox[{"plots", "[", 
        RowBox[{"[", "3", "]"}], "]"}], ",", 
       RowBox[{"plots", "[", 
        RowBox[{"[", "4", "]"}], "]"}]}], "}"}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"create", " ", "eps"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Export", "[", 
      RowBox[{"\"\<SVD_Compression.eps\>\"", ",", "pic2"}], "]"}], ";"}], " ",
     "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5661408497850227`*^9, 3.5661408645894485`*^9}, {
   3.5661484907173047`*^9, 3.566148495459713*^9}, {3.5661485960314903`*^9, 
   3.5661486832980433`*^9}, {3.5661487167133017`*^9, 
   3.5661488519499397`*^9}, {3.566149015251026*^9, 3.5661490608655066`*^9}, {
   3.566149146228856*^9, 3.566149170471299*^9}, {3.5661492721210775`*^9, 
   3.5661494058289127`*^9}, {3.566149451240592*^9, 3.5661495155595055`*^9}, {
   3.5661495533895717`*^9, 3.5661497123694506`*^9}, {3.5661497589043326`*^9, 
   3.566149958693884*^9}, {3.5661500266788025`*^9, 3.566150138374999*^9}, {
   3.5661502048155155`*^9, 3.566150221897546*^9}, {3.566150254564003*^9, 
   3.5661502899760656`*^9}, {3.566150444275936*^9, 3.566150497144429*^9}, {
   3.5661506670755277`*^9, 3.5661507108960047`*^9}, 3.5661510774030485`*^9, {
   3.5661511658084035`*^9, 3.5661511661984043`*^9}, {3.5661512502045517`*^9, 
   3.5661514048164234`*^9}, {3.566151489930173*^9, 3.5661514937833796`*^9}, {
   3.566151594637557*^9, 3.5661516069771786`*^9}, {3.566152191756606*^9, 
   3.566152242441095*^9}, {3.5701962718919015`*^9, 3.5701962938943396`*^9}, {
   3.570196365609264*^9, 3.570196406104533*^9}, {3.570196892886982*^9, 
   3.5701970639748783`*^9}, {3.5701971027105455`*^9, 
   3.5701971329745984`*^9}, {3.5701972200851517`*^9, 
   3.5701972774808507`*^9}, {3.5701973226125298`*^9, 3.570197391116248*^9}, {
   3.5701975063532495`*^9, 3.5701975343864985`*^9}, {3.5701975707153616`*^9, 
   3.570197616875843*^9}, {3.570197653003105*^9, 3.570197701094389*^9}, {
   3.5701977899741445`*^9, 3.5701977920645485`*^9}, {3.5701978325382166`*^9, 
   3.570197832881417*^9}, {3.570197870354682*^9, 3.5701979104819508`*^9}, {
   3.570197953148026*^9, 3.5701979665016494`*^9}, {3.5701980681294265`*^9, 
   3.570198068425827*^9}, {3.5701981312107344`*^9, 3.570198131694336*^9}, 
   3.5701981913620396`*^9, {3.5701987384569855`*^9, 3.570198764774232*^9}, {
   3.570198840177161*^9, 3.570198847926774*^9}, {3.570198881342033*^9, 
   3.5701988903432484`*^9}, {3.57019894929495*^9, 3.5701989639433756`*^9}, {
   3.5701989979982357`*^9, 3.5701991346780734`*^9}, {3.5701991940821753`*^9, 
   3.5701991965313797`*^9}, {3.5701992417090592`*^9, 
   3.5701992783199224`*^9}, {3.570199320611597*^9, 3.5701994403014064`*^9}, {
   3.5847166246794977`*^9, 3.5847166895795884`*^9}, {3.5847167459196672`*^9, 
   3.5847167528696766`*^9}, {3.584717137870216*^9, 3.5847171396602182`*^9}, {
   3.584717185480283*^9, 3.584717321500473*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"m = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.`", "1.`", "0.`", "1.`", "1.`", "0.`", "1.`", "1.`"},
       {"1.`", "1.`", "0.`", "1.`", "1.`", "0.`", "1.`", "1.`"},
       {"0.`", "0.`", "0.`", "1.`", "1.`", "0.`", "0.`", "0.`"},
       {"1.`", "1.`", "1.`", "1.`", "1.`", "1.`", "1.`", "1.`"},
       {"1.`", "1.`", "1.`", "1.`", "1.`", "1.`", "1.`", "1.`"},
       {"0.`", "0.`", "0.`", "1.`", "1.`", "0.`", "0.`", "0.`"},
       {"1.`", "1.`", "0.`", "1.`", "1.`", "0.`", "1.`", "1.`"},
       {"1.`", "1.`", "0.`", "1.`", "1.`", "0.`", "1.`", "1.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["m = ", 
   MatrixForm[CompressedData["
1:eJxTTMoPSmViYGDggGII+GCPSpMqTql+XIBcdfSmqe1+UsXJ1w8ANTU10A==

    "]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5661488455071287`*^9, 3.5661490647811136`*^9, {3.56614915406007*^9, 
   3.5661491723901024`*^9}, 3.5661493540212216`*^9, {3.566149390603286*^9, 
   3.5661494068273144`*^9}, 3.56614951846111*^9, 3.5661495737320075`*^9, {
   3.566149824050047*^9, 3.5661499149514065`*^9}, 3.5661499595518847`*^9, {
   3.5661501119017525`*^9, 3.5661501398570013`*^9}, 3.5661502228803473`*^9, 
   3.566150257699609*^9, 3.5661502913020678`*^9, 3.566150328586133*^9, {
   3.5661504602971644`*^9, 3.5661504985016317`*^9}, {3.5661506869343624`*^9, 
   3.5661507121908073`*^9}, 3.5661510798054523`*^9, 3.5661511674152064`*^9, {
   3.566151333914299*^9, 3.5661514057212253`*^9}, 3.5661514968409853`*^9, {
   3.5661515961039596`*^9, 3.56615160789758*^9}, 3.5701962484998627`*^9, 
   3.570196412890545*^9, 3.5701969001741943`*^9, 3.570196938363061*^9, 
   3.570197085159715*^9, 3.5701971342070007`*^9, {3.570197233909974*^9, 
   3.5701972785416527`*^9}, 3.570197324172532*^9, {3.570197376967024*^9, 
   3.570197391631049*^9}, 3.570197796246955*^9, 3.5701978366410236`*^9, 
   3.570198021354945*^9, 3.5701980741042366`*^9, {3.5701981757620125`*^9, 
   3.5701981930000424`*^9}, 3.570198772037444*^9, 3.570199140528084*^9, 
   3.5701992008213873`*^9, 3.570199291891947*^9, {3.5701993836733074`*^9, 
   3.570199411176155*^9}, 3.5701994442326136`*^9, 3.5847171604302473`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"dimension = \"\>", "\[InvisibleSpace]", "8"}],
  SequenceForm["dimension = ", 8],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5661488455071287`*^9, 3.5661490647811136`*^9, {3.56614915406007*^9, 
   3.5661491723901024`*^9}, 3.5661493540212216`*^9, {3.566149390603286*^9, 
   3.5661494068273144`*^9}, 3.56614951846111*^9, 3.5661495737320075`*^9, {
   3.566149824050047*^9, 3.5661499149514065`*^9}, 3.5661499595518847`*^9, {
   3.5661501119017525`*^9, 3.5661501398570013`*^9}, 3.5661502228803473`*^9, 
   3.566150257699609*^9, 3.5661502913020678`*^9, 3.566150328586133*^9, {
   3.5661504602971644`*^9, 3.5661504985016317`*^9}, {3.5661506869343624`*^9, 
   3.5661507121908073`*^9}, 3.5661510798054523`*^9, 3.5661511674152064`*^9, {
   3.566151333914299*^9, 3.5661514057212253`*^9}, 3.5661514968409853`*^9, {
   3.5661515961039596`*^9, 3.56615160789758*^9}, 3.5701962484998627`*^9, 
   3.570196412890545*^9, 3.5701969001741943`*^9, 3.570196938363061*^9, 
   3.570197085159715*^9, 3.5701971342070007`*^9, {3.570197233909974*^9, 
   3.5701972785416527`*^9}, 3.570197324172532*^9, {3.570197376967024*^9, 
   3.570197391631049*^9}, 3.570197796246955*^9, 3.5701978366410236`*^9, 
   3.570198021354945*^9, 3.5701980741042366`*^9, {3.5701981757620125`*^9, 
   3.5701981930000424`*^9}, 3.570198772037444*^9, 3.570199140528084*^9, 
   3.5701992008213873`*^9, 3.570199291891947*^9, {3.5701993836733074`*^9, 
   3.570199411176155*^9}, 3.5701994442326136`*^9, 3.5847171604402475`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"uu =  \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.38512103920770996`", 
        RowBox[{"-", "0.15346803088279062`"}], "0.2795162761925182`", 
        RowBox[{"-", "0.7071067811865475`"}], 
        RowBox[{"-", "0.4082482904638631`"}], "0.`", "0.`", 
        RowBox[{"-", "0.2886751345948129`"}]},
       {"0.38512103920770996`", 
        RowBox[{"-", "0.15346803088279062`"}], "0.2795162761925182`", "0.`", 
        "0.`", "0.`", "0.`", "0.8660254037844386`"},
       {"0.13784497461856535`", 
        RowBox[{"-", "0.5100363100784394`"}], 
        RowBox[{"-", "0.4699592805488335`"}], "0.`", "0.`", 
        RowBox[{"-", "0.7071067811865475`"}], "0.`", "0.`"},
       {"0.4293743509940412`", "0.4390422410150164`", 
        RowBox[{"-", "0.3505418338985499`"}], "0.`", "0.`", "0.`", 
        RowBox[{"-", "0.7071067811865475`"}], "0.`"},
       {"0.4293743509940412`", "0.4390422410150164`", 
        RowBox[{"-", "0.3505418338985499`"}], "0.`", "0.`", "0.`", 
        "0.7071067811865475`", "0.`"},
       {"0.13784497461856535`", 
        RowBox[{"-", "0.5100363100784394`"}], 
        RowBox[{"-", "0.4699592805488335`"}], "0.`", "0.`", 
        "0.7071067811865475`", "0.`", "0.`"},
       {"0.38512103920770996`", 
        RowBox[{"-", "0.15346803088279062`"}], "0.2795162761925182`", "0.`", 
        "0.816496580927726`", "0.`", "0.`", 
        RowBox[{"-", "0.2886751345948129`"}]},
       {"0.38512103920770996`", 
        RowBox[{"-", "0.15346803088279062`"}], "0.2795162761925182`", 
        "0.7071067811865475`", 
        RowBox[{"-", "0.4082482904638631`"}], "0.`", "0.`", 
        RowBox[{"-", "0.2886751345948129`"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["uu =  ", 
   MatrixForm[CompressedData["
1:eJxTTMoPSmViYGDggOLiZsntl5besL978Lza9SWH90+bYmMz4/FF+zPW9Wnz
Fjzbb6/DU7BX4dZ+BjQgazzBdXnlpf249KOrRwerfCJeVG17bX/5zOeS50sO
2m999nGVedCD/U+0pcQvCN/DsA/mHnRxo3UX+u5V3bb/a7pugYvkHXv7CDkW
9/xrGOpwmUOmfrj/SHQ/RrgQCj87cPi/wtBHKPxh9hGKPwABNaPI
    "]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5661488455071287`*^9, 3.5661490647811136`*^9, {3.56614915406007*^9, 
   3.5661491723901024`*^9}, 3.5661493540212216`*^9, {3.566149390603286*^9, 
   3.5661494068273144`*^9}, 3.56614951846111*^9, 3.5661495737320075`*^9, {
   3.566149824050047*^9, 3.5661499149514065`*^9}, 3.5661499595518847`*^9, {
   3.5661501119017525`*^9, 3.5661501398570013`*^9}, 3.5661502228803473`*^9, 
   3.566150257699609*^9, 3.5661502913020678`*^9, 3.566150328586133*^9, {
   3.5661504602971644`*^9, 3.5661504985016317`*^9}, {3.5661506869343624`*^9, 
   3.5661507121908073`*^9}, 3.5661510798054523`*^9, 3.5661511674152064`*^9, {
   3.566151333914299*^9, 3.5661514057212253`*^9}, 3.5661514968409853`*^9, {
   3.5661515961039596`*^9, 3.56615160789758*^9}, 3.5701962484998627`*^9, 
   3.570196412890545*^9, 3.5701969001741943`*^9, 3.570196938363061*^9, 
   3.570197085159715*^9, 3.5701971342070007`*^9, {3.570197233909974*^9, 
   3.5701972785416527`*^9}, 3.570197324172532*^9, {3.570197376967024*^9, 
   3.570197391631049*^9}, 3.570197796246955*^9, 3.5701978366410236`*^9, 
   3.570198021354945*^9, 3.5701980741042366`*^9, {3.5701981757620125`*^9, 
   3.5701981930000424`*^9}, 3.570198772037444*^9, 3.570199140528084*^9, 
   3.5701992008213873`*^9, 3.570199291891947*^9, {3.5701993836733074`*^9, 
   3.570199411176155*^9}, 3.5701994442326136`*^9, 3.584717161090248*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vv =  \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.38512103920770985`", "0.1534680308827919`", "0.2795162761925181`", 
        RowBox[{"-", "0.7071067811865475`"}], 
        RowBox[{"-", "0.4082482904638631`"}], "0.`", "0.`", 
        RowBox[{"-", "0.2886751345948129`"}]},
       {"0.38512103920771`", "0.153468030882791`", "0.27951627619251834`", 
        "0.`", "0.`", "0.`", "0.`", "0.8660254037844386`"},
       {"0.13784497461856537`", "0.510036310078439`", 
        RowBox[{"-", "0.4699592805488336`"}], "0.`", "0.`", 
        RowBox[{"-", "0.7071067811865475`"}], "0.`", "0.`"},
       {"0.42937435099404125`", 
        RowBox[{"-", "0.43904224101501627`"}], 
        RowBox[{"-", "0.35054183389854954`"}], "0.`", "0.`", "0.`", 
        RowBox[{"-", "0.7071067811865475`"}], "0.`"},
       {"0.42937435099404125`", 
        RowBox[{"-", "0.43904224101501627`"}], 
        RowBox[{"-", "0.35054183389854954`"}], "0.`", "0.`", "0.`", 
        "0.7071067811865475`", "0.`"},
       {"0.13784497461856537`", "0.510036310078439`", 
        RowBox[{"-", "0.4699592805488336`"}], "0.`", "0.`", 
        "0.7071067811865475`", "0.`", "0.`"},
       {"0.38512103920771`", "0.153468030882791`", "0.27951627619251834`", 
        "0.`", "0.816496580927726`", "0.`", "0.`", 
        RowBox[{"-", "0.2886751345948129`"}]},
       {"0.38512103920771`", "0.153468030882791`", "0.27951627619251834`", 
        "0.7071067811865475`", 
        RowBox[{"-", "0.4082482904638631`"}], "0.`", "0.`", 
        RowBox[{"-", "0.2886751345948129`"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["vv =  ", 
   MatrixForm[CompressedData["
1:eJxTTMoPSmViYGDggOLCZsntl5besOc+dF7t+pLD9lOn2NjMeHzR/ox1fdq8
Bc/22+vwFOxVuLWfAQ3IGk9wXV55aX8JVP/rgxD9M6H60dWjg1U+ES+qtr22
v3Lmc8nzJQftNz77uMo86IH9M20p8QvC9zDsg7kHXdx43YW+e1W37X+brlvg
Inlnv0WEHIt7/jUMdbjMIVM/3H8kuh8jXAiFnx04/F9h6CMU/jD7CMUfAFVw
oRg=
    "]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5661488455071287`*^9, 3.5661490647811136`*^9, {3.56614915406007*^9, 
   3.5661491723901024`*^9}, 3.5661493540212216`*^9, {3.566149390603286*^9, 
   3.5661494068273144`*^9}, 3.56614951846111*^9, 3.5661495737320075`*^9, {
   3.566149824050047*^9, 3.5661499149514065`*^9}, 3.5661499595518847`*^9, {
   3.5661501119017525`*^9, 3.5661501398570013`*^9}, 3.5661502228803473`*^9, 
   3.566150257699609*^9, 3.5661502913020678`*^9, 3.566150328586133*^9, {
   3.5661504602971644`*^9, 3.5661504985016317`*^9}, {3.5661506869343624`*^9, 
   3.5661507121908073`*^9}, 3.5661510798054523`*^9, 3.5661511674152064`*^9, {
   3.566151333914299*^9, 3.5661514057212253`*^9}, 3.5661514968409853`*^9, {
   3.5661515961039596`*^9, 3.56615160789758*^9}, 3.5701962484998627`*^9, 
   3.570196412890545*^9, 3.5701969001741943`*^9, 3.570196938363061*^9, 
   3.570197085159715*^9, 3.5701971342070007`*^9, {3.570197233909974*^9, 
   3.5701972785416527`*^9}, 3.570197324172532*^9, {3.570197376967024*^9, 
   3.570197391631049*^9}, 3.570197796246955*^9, 3.5701978366410236`*^9, 
   3.570198021354945*^9, 3.5701980741042366`*^9, {3.5701981757620125`*^9, 
   3.5701981930000424`*^9}, 3.570198772037444*^9, 3.570199140528084*^9, 
   3.5701992008213873`*^9, 3.570199291891947*^9, {3.5701993836733074`*^9, 
   3.570199411176155*^9}, 3.5701994442326136`*^9, 3.5847171611002483`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"sigma=\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"6.229815082953511`", "0.`", "0.`", "0.`", "0.`", "0.`", "0.`", "0.`"},
       {"0.`", "1.7216117062234069`", "0.`", "0.`", "0.`", "0.`", "0.`", 
        "0.`"},
       {"0.`", "0.`", "1.4917966232698952`", "0.`", "0.`", "0.`", "0.`", 
        "0.`"},
       {"0.`", "0.`", "0.`", "0.`", "0.`", "0.`", "0.`", "0.`"},
       {"0.`", "0.`", "0.`", "0.`", "0.`", "0.`", "0.`", "0.`"},
       {"0.`", "0.`", "0.`", "0.`", "0.`", "0.`", "0.`", "0.`"},
       {"0.`", "0.`", "0.`", "0.`", "0.`", "0.`", "0.`", "0.`"},
       {"0.`", "0.`", "0.`", "0.`", "0.`", "0.`", "0.`", "0.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["sigma=", 
   MatrixForm[CompressedData["
1:eJxTTMoPSmViYGDggOIjy1SXhryWcGCgECy2y9q+o/u3PaXmTFh8WSnt3neK
zRkFxAEAX/gOqA==
    "]]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5661488455071287`*^9, 3.5661490647811136`*^9, {3.56614915406007*^9, 
   3.5661491723901024`*^9}, 3.5661493540212216`*^9, {3.566149390603286*^9, 
   3.5661494068273144`*^9}, 3.56614951846111*^9, 3.5661495737320075`*^9, {
   3.566149824050047*^9, 3.5661499149514065`*^9}, 3.5661499595518847`*^9, {
   3.5661501119017525`*^9, 3.5661501398570013`*^9}, 3.5661502228803473`*^9, 
   3.566150257699609*^9, 3.5661502913020678`*^9, 3.566150328586133*^9, {
   3.5661504602971644`*^9, 3.5661504985016317`*^9}, {3.5661506869343624`*^9, 
   3.5661507121908073`*^9}, 3.5661510798054523`*^9, 3.5661511674152064`*^9, {
   3.566151333914299*^9, 3.5661514057212253`*^9}, 3.5661514968409853`*^9, {
   3.5661515961039596`*^9, 3.56615160789758*^9}, 3.5701962484998627`*^9, 
   3.570196412890545*^9, 3.5701969001741943`*^9, 3.570196938363061*^9, 
   3.570197085159715*^9, 3.5701971342070007`*^9, {3.570197233909974*^9, 
   3.5701972785416527`*^9}, 3.570197324172532*^9, {3.570197376967024*^9, 
   3.570197391631049*^9}, 3.570197796246955*^9, 3.5701978366410236`*^9, 
   3.570198021354945*^9, 3.5701980741042366`*^9, {3.5701981757620125`*^9, 
   3.5701981930000424`*^9}, 3.570198772037444*^9, 3.570199140528084*^9, 
   3.5701992008213873`*^9, 3.570199291891947*^9, {3.5701993836733074`*^9, 
   3.570199411176155*^9}, 3.5701994442326136`*^9, 3.5847171611002483`*^9}],

Cell[BoxData["\<\"ready for making matrices\"\>"], "Print",
 CellChangeTimes->{
  3.5661488455071287`*^9, 3.5661490647811136`*^9, {3.56614915406007*^9, 
   3.5661491723901024`*^9}, 3.5661493540212216`*^9, {3.566149390603286*^9, 
   3.5661494068273144`*^9}, 3.56614951846111*^9, 3.5661495737320075`*^9, {
   3.566149824050047*^9, 3.5661499149514065`*^9}, 3.5661499595518847`*^9, {
   3.5661501119017525`*^9, 3.5661501398570013`*^9}, 3.5661502228803473`*^9, 
   3.566150257699609*^9, 3.5661502913020678`*^9, 3.566150328586133*^9, {
   3.5661504602971644`*^9, 3.5661504985016317`*^9}, {3.5661506869343624`*^9, 
   3.5661507121908073`*^9}, 3.5661510798054523`*^9, 3.5661511674152064`*^9, {
   3.566151333914299*^9, 3.5661514057212253`*^9}, 3.5661514968409853`*^9, {
   3.5661515961039596`*^9, 3.56615160789758*^9}, 3.5701962484998627`*^9, 
   3.570196412890545*^9, 3.5701969001741943`*^9, 3.570196938363061*^9, 
   3.570197085159715*^9, 3.5701971342070007`*^9, {3.570197233909974*^9, 
   3.5701972785416527`*^9}, 3.570197324172532*^9, {3.570197376967024*^9, 
   3.570197391631049*^9}, 3.570197796246955*^9, 3.5701978366410236`*^9, 
   3.570198021354945*^9, 3.5701980741042366`*^9, {3.5701981757620125`*^9, 
   3.5701981930000424`*^9}, 3.570198772037444*^9, 3.570199140528084*^9, 
   3.5701992008213873`*^9, 3.570199291891947*^9, {3.5701993836733074`*^9, 
   3.570199411176155*^9}, 3.5701994442326136`*^9, 3.5847171611002483`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k=\"\>", "\[InvisibleSpace]", "1", 
   "\[InvisibleSpace]", "\<\"  sigma =\"\>", "\[InvisibleSpace]", 
   "6.229815082953511`"}],
  SequenceForm["k=", 1, "  sigma =", 6.229815082953511],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5661488455071287`*^9, 3.5661490647811136`*^9, {3.56614915406007*^9, 
   3.5661491723901024`*^9}, 3.5661493540212216`*^9, {3.566149390603286*^9, 
   3.5661494068273144`*^9}, 3.56614951846111*^9, 3.5661495737320075`*^9, {
   3.566149824050047*^9, 3.5661499149514065`*^9}, 3.5661499595518847`*^9, {
   3.5661501119017525`*^9, 3.5661501398570013`*^9}, 3.5661502228803473`*^9, 
   3.566150257699609*^9, 3.5661502913020678`*^9, 3.566150328586133*^9, {
   3.5661504602971644`*^9, 3.5661504985016317`*^9}, {3.5661506869343624`*^9, 
   3.5661507121908073`*^9}, 3.5661510798054523`*^9, 3.5661511674152064`*^9, {
   3.566151333914299*^9, 3.5661514057212253`*^9}, 3.5661514968409853`*^9, {
   3.5661515961039596`*^9, 3.56615160789758*^9}, 3.5701962484998627`*^9, 
   3.570196412890545*^9, 3.5701969001741943`*^9, 3.570196938363061*^9, 
   3.570197085159715*^9, 3.5701971342070007`*^9, {3.570197233909974*^9, 
   3.5701972785416527`*^9}, 3.570197324172532*^9, {3.570197376967024*^9, 
   3.570197391631049*^9}, 3.570197796246955*^9, 3.5701978366410236`*^9, 
   3.570198021354945*^9, 3.5701980741042366`*^9, {3.5701981757620125`*^9, 
   3.5701981930000424`*^9}, 3.570198772037444*^9, 3.570199140528084*^9, 
   3.5701992008213873`*^9, 3.570199291891947*^9, {3.5701993836733074`*^9, 
   3.570199411176155*^9}, 3.5701994442326136`*^9, 3.5847171611002483`*^9}],

Cell[BoxData["\<\"make array plot\"\>"], "Print",
 CellChangeTimes->{
  3.5661488455071287`*^9, 3.5661490647811136`*^9, {3.56614915406007*^9, 
   3.5661491723901024`*^9}, 3.5661493540212216`*^9, {3.566149390603286*^9, 
   3.5661494068273144`*^9}, 3.56614951846111*^9, 3.5661495737320075`*^9, {
   3.566149824050047*^9, 3.5661499149514065`*^9}, 3.5661499595518847`*^9, {
   3.5661501119017525`*^9, 3.5661501398570013`*^9}, 3.5661502228803473`*^9, 
   3.566150257699609*^9, 3.5661502913020678`*^9, 3.566150328586133*^9, {
   3.5661504602971644`*^9, 3.5661504985016317`*^9}, {3.5661506869343624`*^9, 
   3.5661507121908073`*^9}, 3.5661510798054523`*^9, 3.5661511674152064`*^9, {
   3.566151333914299*^9, 3.5661514057212253`*^9}, 3.5661514968409853`*^9, {
   3.5661515961039596`*^9, 3.56615160789758*^9}, 3.5701962484998627`*^9, 
   3.570196412890545*^9, 3.5701969001741943`*^9, 3.570196938363061*^9, 
   3.570197085159715*^9, 3.5701971342070007`*^9, {3.570197233909974*^9, 
   3.5701972785416527`*^9}, 3.570197324172532*^9, {3.570197376967024*^9, 
   3.570197391631049*^9}, 3.570197796246955*^9, 3.5701978366410236`*^9, 
   3.570198021354945*^9, 3.5701980741042366`*^9, {3.5701981757620125`*^9, 
   3.5701981930000424`*^9}, 3.570198772037444*^9, 3.570199140528084*^9, 
   3.5701992008213873`*^9, 3.570199291891947*^9, {3.5701993836733074`*^9, 
   3.570199411176155*^9}, 3.5701994442326136`*^9, 3.5847171611102486`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k=\"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\"  sigma =\"\>", "\[InvisibleSpace]", 
   "1.7216117062234069`"}],
  SequenceForm["k=", 2, "  sigma =", 1.7216117062234069`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5661488455071287`*^9, 3.5661490647811136`*^9, {3.56614915406007*^9, 
   3.5661491723901024`*^9}, 3.5661493540212216`*^9, {3.566149390603286*^9, 
   3.5661494068273144`*^9}, 3.56614951846111*^9, 3.5661495737320075`*^9, {
   3.566149824050047*^9, 3.5661499149514065`*^9}, 3.5661499595518847`*^9, {
   3.5661501119017525`*^9, 3.5661501398570013`*^9}, 3.5661502228803473`*^9, 
   3.566150257699609*^9, 3.5661502913020678`*^9, 3.566150328586133*^9, {
   3.5661504602971644`*^9, 3.5661504985016317`*^9}, {3.5661506869343624`*^9, 
   3.5661507121908073`*^9}, 3.5661510798054523`*^9, 3.5661511674152064`*^9, {
   3.566151333914299*^9, 3.5661514057212253`*^9}, 3.5661514968409853`*^9, {
   3.5661515961039596`*^9, 3.56615160789758*^9}, 3.5701962484998627`*^9, 
   3.570196412890545*^9, 3.5701969001741943`*^9, 3.570196938363061*^9, 
   3.570197085159715*^9, 3.5701971342070007`*^9, {3.570197233909974*^9, 
   3.5701972785416527`*^9}, 3.570197324172532*^9, {3.570197376967024*^9, 
   3.570197391631049*^9}, 3.570197796246955*^9, 3.5701978366410236`*^9, 
   3.570198021354945*^9, 3.5701980741042366`*^9, {3.5701981757620125`*^9, 
   3.5701981930000424`*^9}, 3.570198772037444*^9, 3.570199140528084*^9, 
   3.5701992008213873`*^9, 3.570199291891947*^9, {3.5701993836733074`*^9, 
   3.570199411176155*^9}, 3.5701994442326136`*^9, 3.584717161460249*^9}],

Cell[BoxData["\<\"make array plot\"\>"], "Print",
 CellChangeTimes->{
  3.5661488455071287`*^9, 3.5661490647811136`*^9, {3.56614915406007*^9, 
   3.5661491723901024`*^9}, 3.5661493540212216`*^9, {3.566149390603286*^9, 
   3.5661494068273144`*^9}, 3.56614951846111*^9, 3.5661495737320075`*^9, {
   3.566149824050047*^9, 3.5661499149514065`*^9}, 3.5661499595518847`*^9, {
   3.5661501119017525`*^9, 3.5661501398570013`*^9}, 3.5661502228803473`*^9, 
   3.566150257699609*^9, 3.5661502913020678`*^9, 3.566150328586133*^9, {
   3.5661504602971644`*^9, 3.5661504985016317`*^9}, {3.5661506869343624`*^9, 
   3.5661507121908073`*^9}, 3.5661510798054523`*^9, 3.5661511674152064`*^9, {
   3.566151333914299*^9, 3.5661514057212253`*^9}, 3.5661514968409853`*^9, {
   3.5661515961039596`*^9, 3.56615160789758*^9}, 3.5701962484998627`*^9, 
   3.570196412890545*^9, 3.5701969001741943`*^9, 3.570196938363061*^9, 
   3.570197085159715*^9, 3.5701971342070007`*^9, {3.570197233909974*^9, 
   3.5701972785416527`*^9}, 3.570197324172532*^9, {3.570197376967024*^9, 
   3.570197391631049*^9}, 3.570197796246955*^9, 3.5701978366410236`*^9, 
   3.570198021354945*^9, 3.5701980741042366`*^9, {3.5701981757620125`*^9, 
   3.5701981930000424`*^9}, 3.570198772037444*^9, 3.570199140528084*^9, 
   3.5701992008213873`*^9, 3.570199291891947*^9, {3.5701993836733074`*^9, 
   3.570199411176155*^9}, 3.5701994442326136`*^9, 3.584717161480249*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k=\"\>", "\[InvisibleSpace]", "3", 
   "\[InvisibleSpace]", "\<\"  sigma =\"\>", "\[InvisibleSpace]", 
   "1.4917966232698952`"}],
  SequenceForm["k=", 3, "  sigma =", 1.4917966232698952`],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5661488455071287`*^9, 3.5661490647811136`*^9, {3.56614915406007*^9, 
   3.5661491723901024`*^9}, 3.5661493540212216`*^9, {3.566149390603286*^9, 
   3.5661494068273144`*^9}, 3.56614951846111*^9, 3.5661495737320075`*^9, {
   3.566149824050047*^9, 3.5661499149514065`*^9}, 3.5661499595518847`*^9, {
   3.5661501119017525`*^9, 3.5661501398570013`*^9}, 3.5661502228803473`*^9, 
   3.566150257699609*^9, 3.5661502913020678`*^9, 3.566150328586133*^9, {
   3.5661504602971644`*^9, 3.5661504985016317`*^9}, {3.5661506869343624`*^9, 
   3.5661507121908073`*^9}, 3.5661510798054523`*^9, 3.5661511674152064`*^9, {
   3.566151333914299*^9, 3.5661514057212253`*^9}, 3.5661514968409853`*^9, {
   3.5661515961039596`*^9, 3.56615160789758*^9}, 3.5701962484998627`*^9, 
   3.570196412890545*^9, 3.5701969001741943`*^9, 3.570196938363061*^9, 
   3.570197085159715*^9, 3.5701971342070007`*^9, {3.570197233909974*^9, 
   3.5701972785416527`*^9}, 3.570197324172532*^9, {3.570197376967024*^9, 
   3.570197391631049*^9}, 3.570197796246955*^9, 3.5701978366410236`*^9, 
   3.570198021354945*^9, 3.5701980741042366`*^9, {3.5701981757620125`*^9, 
   3.5701981930000424`*^9}, 3.570198772037444*^9, 3.570199140528084*^9, 
   3.5701992008213873`*^9, 3.570199291891947*^9, {3.5701993836733074`*^9, 
   3.570199411176155*^9}, 3.5701994442326136`*^9, 3.584717161700249*^9}],

Cell[BoxData["\<\"make array plot\"\>"], "Print",
 CellChangeTimes->{
  3.5661488455071287`*^9, 3.5661490647811136`*^9, {3.56614915406007*^9, 
   3.5661491723901024`*^9}, 3.5661493540212216`*^9, {3.566149390603286*^9, 
   3.5661494068273144`*^9}, 3.56614951846111*^9, 3.5661495737320075`*^9, {
   3.566149824050047*^9, 3.5661499149514065`*^9}, 3.5661499595518847`*^9, {
   3.5661501119017525`*^9, 3.5661501398570013`*^9}, 3.5661502228803473`*^9, 
   3.566150257699609*^9, 3.5661502913020678`*^9, 3.566150328586133*^9, {
   3.5661504602971644`*^9, 3.5661504985016317`*^9}, {3.5661506869343624`*^9, 
   3.5661507121908073`*^9}, 3.5661510798054523`*^9, 3.5661511674152064`*^9, {
   3.566151333914299*^9, 3.5661514057212253`*^9}, 3.5661514968409853`*^9, {
   3.5661515961039596`*^9, 3.56615160789758*^9}, 3.5701962484998627`*^9, 
   3.570196412890545*^9, 3.5701969001741943`*^9, 3.570196938363061*^9, 
   3.570197085159715*^9, 3.5701971342070007`*^9, {3.570197233909974*^9, 
   3.5701972785416527`*^9}, 3.570197324172532*^9, {3.570197376967024*^9, 
   3.570197391631049*^9}, 3.570197796246955*^9, 3.5701978366410236`*^9, 
   3.570198021354945*^9, 3.5701980741042366`*^9, {3.5701981757620125`*^9, 
   3.5701981930000424`*^9}, 3.570198772037444*^9, 3.570199140528084*^9, 
   3.5701992008213873`*^9, 3.570199291891947*^9, {3.5701993836733074`*^9, 
   3.570199411176155*^9}, 3.5701994442326136`*^9, 3.584717161710249*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"N", "::", "meprec"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Internal precision limit $MaxExtraPrecision = \
\[NoBreak]\\!\\(50.`\\)\[NoBreak] reached while evaluating \
\[NoBreak]\\!\\(\\(\\(Root[\\(\\(\\(\\(\\(\\(\\(\\(-256\\)\\) + \\(\\(\
\[LeftSkeleton] 3 \[RightSkeleton]\\)\\) + \\(Slot[\\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)]\\)\\^3\\)\\) &\\)\\), 1, 0\\)\\)]\\)\\^\\(3/2\\)\\\\ \
\\(\\((2 + \\(\[LeftSkeleton] 1 \[RightSkeleton]\\)\\/\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\) - \\(128 - \\(\\(128\\\\ \\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)\\)\\) + \\(\\(32\\\\ \\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)\\)\\) - \\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\^3\\)\\/\\(2\\\\ \\(\\((\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\))\\)\\)\\\\ \\(\\((\\(\\(-8\\)\\) + \\(\\(3\\\\ \
\\(\\(Root[\\(\\(\[LeftSkeleton] 1 \[RightSkeleton]\\)\\)]\\)\\)\\)\\))\\)\\)\
\\))\\)\\)\\)\\/\\(\\(\\((\\(\\(-8\\)\\) + \\(\\(3\\\\ \
\\(\\(Root[\\(\\(\\(\\(\\(\\(Plus[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\
\\)]\\)\\) &\\)\\), 1, 0\\)\\)]\\)\\)\\)\\))\\)\\)\\\\ \\@\\(\\(\\((3 + \
\\(2\\\\ \\(\[LeftSkeleton] 1 \[RightSkeleton]\\)\\^2\\)\\/\\(\[LeftSkeleton] \
1 \[RightSkeleton]\\)\\^2 + \\(2\\\\ \\(\[LeftSkeleton] 1 \[RightSkeleton]\\)\
\\^2\\)\\/\\(\[LeftSkeleton] 1 \[RightSkeleton]\\)\\^2 + \\((\\(\\(-1\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\))\\)\\^2)\\)\
\\)\\\\ \\(\\((\\(8\\\\ \\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)\\)\\/\\(\[LeftSkeleton] 1 \[RightSkeleton]\\) + \\(\\(\
\[LeftSkeleton] 1 \[RightSkeleton]\\)\\) + \\(\\(2\\\\ \\(\\(\[LeftSkeleton] \
1 \[RightSkeleton]\\)\\)\\)\\))\\)\\)\\)\\) + \\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\/\\(\[LeftSkeleton] 1 \[RightSkeleton]\\) + \\(\\(\
\[LeftSkeleton] 1 \[RightSkeleton]\\)\\)\\)\[NoBreak]. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/N\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.5701991408088837`*^9, 3.5701992009773874`*^9, 3.570199292874748*^9, {
   3.5701993840945077`*^9, 3.570199411566156*^9}, 3.570199444622614*^9, 
   3.5847171618402495`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"N", "::", "meprec"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Internal precision limit $MaxExtraPrecision = \
\[NoBreak]\\!\\(50.`\\)\[NoBreak] reached while evaluating \
\[NoBreak]\\!\\(\\(\\(Root[\\(\\(\\(\\(\\(\\(\\(\\(-256\\)\\) + \\(\\(\
\[LeftSkeleton] 3 \[RightSkeleton]\\)\\) + \\(Slot[\\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)]\\)\\^3\\)\\) &\\)\\), 1, 0\\)\\)]\\)\\^\\(3/2\\)\\\\ \
\\(\\((2 + \\(\[LeftSkeleton] 1 \[RightSkeleton]\\)\\/\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\) - \\(128 - \\(\\(128\\\\ \\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)\\)\\) + \\(\\(32\\\\ \\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)\\)\\) - \\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\^3\\)\\/\\(2\\\\ \\(\\((\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\))\\)\\)\\\\ \\(\\((\\(\\(-8\\)\\) + \\(\\(3\\\\ \
\\(\\(Root[\\(\\(\[LeftSkeleton] 1 \[RightSkeleton]\\)\\)]\\)\\)\\)\\))\\)\\)\
\\))\\)\\)\\)\\/\\(\\(\\((\\(\\(-8\\)\\) + \\(\\(3\\\\ \
\\(\\(Root[\\(\\(\\(\\(\\(\\(Plus[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\
\\)]\\)\\) &\\)\\), 1, 0\\)\\)]\\)\\)\\)\\))\\)\\)\\\\ \\@\\(\\(\\((3 + \
\\(2\\\\ \\(\[LeftSkeleton] 1 \[RightSkeleton]\\)\\^2\\)\\/\\(\[LeftSkeleton] \
1 \[RightSkeleton]\\)\\^2 + \\(2\\\\ \\(\[LeftSkeleton] 1 \[RightSkeleton]\\)\
\\^2\\)\\/\\(\[LeftSkeleton] 1 \[RightSkeleton]\\)\\^2 + \\((\\(\\(-1\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\))\\)\\^2)\\)\
\\)\\\\ \\(\\((\\(8\\\\ \\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)\\)\\/\\(\[LeftSkeleton] 1 \[RightSkeleton]\\) + \\(\\(\
\[LeftSkeleton] 1 \[RightSkeleton]\\)\\) + \\(\\(2\\\\ \\(\\(\[LeftSkeleton] \
1 \[RightSkeleton]\\)\\)\\)\\))\\)\\)\\)\\) + \\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\/\\(\[LeftSkeleton] 1 \[RightSkeleton]\\) + \\(\\(\
\[LeftSkeleton] 1 \[RightSkeleton]\\)\\)\\)\[NoBreak]. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/N\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.5701991408088837`*^9, 3.5701992009773874`*^9, 3.570199292874748*^9, {
   3.5701993840945077`*^9, 3.570199411566156*^9}, 3.570199444622614*^9, 
   3.5847171618702497`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"N", "::", "meprec"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Internal precision limit $MaxExtraPrecision = \
\[NoBreak]\\!\\(50.`\\)\[NoBreak] reached while evaluating \
\[NoBreak]\\!\\(\\(\\(Root[\\(\\(\\(\\(\\(\\(\\(\\(-256\\)\\) + \\(\\(\
\[LeftSkeleton] 3 \[RightSkeleton]\\)\\) + \\(Slot[\\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)]\\)\\^3\\)\\) &\\)\\), 1, 0\\)\\)]\\)\\^\\(3/2\\)\\\\ \
\\(\\((2 + \\(\[LeftSkeleton] 1 \[RightSkeleton]\\)\\/\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\) - \\(128 - \\(\\(128\\\\ \\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)\\)\\) + \\(\\(32\\\\ \\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)\\)\\) - \\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\^3\\)\\/\\(2\\\\ \\(\\((\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\))\\)\\)\\\\ \\(\\((\\(\\(-8\\)\\) + \\(\\(3\\\\ \
\\(\\(Root[\\(\\(\[LeftSkeleton] 1 \[RightSkeleton]\\)\\)]\\)\\)\\)\\))\\)\\)\
\\))\\)\\)\\)\\/\\(\\(\\((\\(\\(-8\\)\\) + \\(\\(3\\\\ \
\\(\\(Root[\\(\\(\\(\\(\\(\\(Plus[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\
\\)]\\)\\) &\\)\\), 1, 0\\)\\)]\\)\\)\\)\\))\\)\\)\\\\ \\@\\(\\(\\((3 + \
\\(2\\\\ \\(\[LeftSkeleton] 1 \[RightSkeleton]\\)\\^2\\)\\/\\(\[LeftSkeleton] \
1 \[RightSkeleton]\\)\\^2 + \\(2\\\\ \\(\[LeftSkeleton] 1 \[RightSkeleton]\\)\
\\^2\\)\\/\\(\[LeftSkeleton] 1 \[RightSkeleton]\\)\\^2 + \\((\\(\\(-1\\)\\) + \
\\(\\(Times[\\(\\(\[LeftSkeleton] 4 \[RightSkeleton]\\)\\)]\\)\\))\\)\\^2)\\)\
\\)\\\\ \\(\\((\\(8\\\\ \\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\)\\)\\/\\(\[LeftSkeleton] 1 \[RightSkeleton]\\) + \\(\\(\
\[LeftSkeleton] 1 \[RightSkeleton]\\)\\) + \\(\\(2\\\\ \\(\\(\[LeftSkeleton] \
1 \[RightSkeleton]\\)\\)\\)\\))\\)\\)\\)\\) + \\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\/\\(\[LeftSkeleton] 1 \[RightSkeleton]\\) + \\(\\(\
\[LeftSkeleton] 1 \[RightSkeleton]\\)\\)\\)\[NoBreak]. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/N\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.5701991408088837`*^9, 3.5701992009773874`*^9, 3.570199292874748*^9, {
   3.5701993840945077`*^9, 3.570199411566156*^9}, 3.570199444622614*^9, 
   3.5847171618702497`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \[NoBreak]\\!\\(\\*StyleBox[\\(N :: \
meprec\\), \\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.5701991408088837`*^9, 3.5701992009773874`*^9, 3.570199292874748*^9, {
   3.5701993840945077`*^9, 3.570199411566156*^9}, 3.570199444622614*^9, 
   3.5847171618802495`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k=\"\>", "\[InvisibleSpace]", "4", 
   "\[InvisibleSpace]", "\<\"  sigma =\"\>", "\[InvisibleSpace]", "0.`"}],
  SequenceForm["k=", 4, "  sigma =", 0.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5661488455071287`*^9, 3.5661490647811136`*^9, {3.56614915406007*^9, 
   3.5661491723901024`*^9}, 3.5661493540212216`*^9, {3.566149390603286*^9, 
   3.5661494068273144`*^9}, 3.56614951846111*^9, 3.5661495737320075`*^9, {
   3.566149824050047*^9, 3.5661499149514065`*^9}, 3.5661499595518847`*^9, {
   3.5661501119017525`*^9, 3.5661501398570013`*^9}, 3.5661502228803473`*^9, 
   3.566150257699609*^9, 3.5661502913020678`*^9, 3.566150328586133*^9, {
   3.5661504602971644`*^9, 3.5661504985016317`*^9}, {3.5661506869343624`*^9, 
   3.5661507121908073`*^9}, 3.5661510798054523`*^9, 3.5661511674152064`*^9, {
   3.566151333914299*^9, 3.5661514057212253`*^9}, 3.5661514968409853`*^9, {
   3.5661515961039596`*^9, 3.56615160789758*^9}, 3.5701962484998627`*^9, 
   3.570196412890545*^9, 3.5701969001741943`*^9, 3.570196938363061*^9, 
   3.570197085159715*^9, 3.5701971342070007`*^9, {3.570197233909974*^9, 
   3.5701972785416527`*^9}, 3.570197324172532*^9, {3.570197376967024*^9, 
   3.570197391631049*^9}, 3.570197796246955*^9, 3.5701978366410236`*^9, 
   3.570198021354945*^9, 3.5701980741042366`*^9, {3.5701981757620125`*^9, 
   3.5701981930000424`*^9}, 3.570198772037444*^9, 3.570199140528084*^9, 
   3.5701992008213873`*^9, 3.570199291891947*^9, {3.5701993836733074`*^9, 
   3.570199411176155*^9}, 3.5701994442326136`*^9, 3.5847171621202497`*^9}],

Cell[BoxData["\<\"make array plot\"\>"], "Print",
 CellChangeTimes->{
  3.5661488455071287`*^9, 3.5661490647811136`*^9, {3.56614915406007*^9, 
   3.5661491723901024`*^9}, 3.5661493540212216`*^9, {3.566149390603286*^9, 
   3.5661494068273144`*^9}, 3.56614951846111*^9, 3.5661495737320075`*^9, {
   3.566149824050047*^9, 3.5661499149514065`*^9}, 3.5661499595518847`*^9, {
   3.5661501119017525`*^9, 3.5661501398570013`*^9}, 3.5661502228803473`*^9, 
   3.566150257699609*^9, 3.5661502913020678`*^9, 3.566150328586133*^9, {
   3.5661504602971644`*^9, 3.5661504985016317`*^9}, {3.5661506869343624`*^9, 
   3.5661507121908073`*^9}, 3.5661510798054523`*^9, 3.5661511674152064`*^9, {
   3.566151333914299*^9, 3.5661514057212253`*^9}, 3.5661514968409853`*^9, {
   3.5661515961039596`*^9, 3.56615160789758*^9}, 3.5701962484998627`*^9, 
   3.570196412890545*^9, 3.5701969001741943`*^9, 3.570196938363061*^9, 
   3.570197085159715*^9, 3.5701971342070007`*^9, {3.570197233909974*^9, 
   3.5701972785416527`*^9}, 3.570197324172532*^9, {3.570197376967024*^9, 
   3.570197391631049*^9}, 3.570197796246955*^9, 3.5701978366410236`*^9, 
   3.570198021354945*^9, 3.5701980741042366`*^9, {3.5701981757620125`*^9, 
   3.5701981930000424`*^9}, 3.570198772037444*^9, 3.570199140528084*^9, 
   3.5701992008213873`*^9, 3.570199291891947*^9, {3.5701993836733074`*^9, 
   3.570199411176155*^9}, 3.5701994442326136`*^9, 3.58471716213025*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k=\"\>", "\[InvisibleSpace]", "5", 
   "\[InvisibleSpace]", "\<\"  sigma =\"\>", "\[InvisibleSpace]", "0.`"}],
  SequenceForm["k=", 5, "  sigma =", 0.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5661488455071287`*^9, 3.5661490647811136`*^9, {3.56614915406007*^9, 
   3.5661491723901024`*^9}, 3.5661493540212216`*^9, {3.566149390603286*^9, 
   3.5661494068273144`*^9}, 3.56614951846111*^9, 3.5661495737320075`*^9, {
   3.566149824050047*^9, 3.5661499149514065`*^9}, 3.5661499595518847`*^9, {
   3.5661501119017525`*^9, 3.5661501398570013`*^9}, 3.5661502228803473`*^9, 
   3.566150257699609*^9, 3.5661502913020678`*^9, 3.566150328586133*^9, {
   3.5661504602971644`*^9, 3.5661504985016317`*^9}, {3.5661506869343624`*^9, 
   3.5661507121908073`*^9}, 3.5661510798054523`*^9, 3.5661511674152064`*^9, {
   3.566151333914299*^9, 3.5661514057212253`*^9}, 3.5661514968409853`*^9, {
   3.5661515961039596`*^9, 3.56615160789758*^9}, 3.5701962484998627`*^9, 
   3.570196412890545*^9, 3.5701969001741943`*^9, 3.570196938363061*^9, 
   3.570197085159715*^9, 3.5701971342070007`*^9, {3.570197233909974*^9, 
   3.5701972785416527`*^9}, 3.570197324172532*^9, {3.570197376967024*^9, 
   3.570197391631049*^9}, 3.570197796246955*^9, 3.5701978366410236`*^9, 
   3.570198021354945*^9, 3.5701980741042366`*^9, {3.5701981757620125`*^9, 
   3.5701981930000424`*^9}, 3.570198772037444*^9, 3.570199140528084*^9, 
   3.5701992008213873`*^9, 3.570199291891947*^9, {3.5701993836733074`*^9, 
   3.570199411176155*^9}, 3.5701994442326136`*^9, 3.58471716238025*^9}],

Cell[BoxData["\<\"make array plot\"\>"], "Print",
 CellChangeTimes->{
  3.5661488455071287`*^9, 3.5661490647811136`*^9, {3.56614915406007*^9, 
   3.5661491723901024`*^9}, 3.5661493540212216`*^9, {3.566149390603286*^9, 
   3.5661494068273144`*^9}, 3.56614951846111*^9, 3.5661495737320075`*^9, {
   3.566149824050047*^9, 3.5661499149514065`*^9}, 3.5661499595518847`*^9, {
   3.5661501119017525`*^9, 3.5661501398570013`*^9}, 3.5661502228803473`*^9, 
   3.566150257699609*^9, 3.5661502913020678`*^9, 3.566150328586133*^9, {
   3.5661504602971644`*^9, 3.5661504985016317`*^9}, {3.5661506869343624`*^9, 
   3.5661507121908073`*^9}, 3.5661510798054523`*^9, 3.5661511674152064`*^9, {
   3.566151333914299*^9, 3.5661514057212253`*^9}, 3.5661514968409853`*^9, {
   3.5661515961039596`*^9, 3.56615160789758*^9}, 3.5701962484998627`*^9, 
   3.570196412890545*^9, 3.5701969001741943`*^9, 3.570196938363061*^9, 
   3.570197085159715*^9, 3.5701971342070007`*^9, {3.570197233909974*^9, 
   3.5701972785416527`*^9}, 3.570197324172532*^9, {3.570197376967024*^9, 
   3.570197391631049*^9}, 3.570197796246955*^9, 3.5701978366410236`*^9, 
   3.570198021354945*^9, 3.5701980741042366`*^9, {3.5701981757620125`*^9, 
   3.5701981930000424`*^9}, 3.570198772037444*^9, 3.570199140528084*^9, 
   3.5701992008213873`*^9, 3.570199291891947*^9, {3.5701993836733074`*^9, 
   3.570199411176155*^9}, 3.5701994442326136`*^9, 3.5847171624002504`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k=\"\>", "\[InvisibleSpace]", "6", 
   "\[InvisibleSpace]", "\<\"  sigma =\"\>", "\[InvisibleSpace]", "0.`"}],
  SequenceForm["k=", 6, "  sigma =", 0.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5661488455071287`*^9, 3.5661490647811136`*^9, {3.56614915406007*^9, 
   3.5661491723901024`*^9}, 3.5661493540212216`*^9, {3.566149390603286*^9, 
   3.5661494068273144`*^9}, 3.56614951846111*^9, 3.5661495737320075`*^9, {
   3.566149824050047*^9, 3.5661499149514065`*^9}, 3.5661499595518847`*^9, {
   3.5661501119017525`*^9, 3.5661501398570013`*^9}, 3.5661502228803473`*^9, 
   3.566150257699609*^9, 3.5661502913020678`*^9, 3.566150328586133*^9, {
   3.5661504602971644`*^9, 3.5661504985016317`*^9}, {3.5661506869343624`*^9, 
   3.5661507121908073`*^9}, 3.5661510798054523`*^9, 3.5661511674152064`*^9, {
   3.566151333914299*^9, 3.5661514057212253`*^9}, 3.5661514968409853`*^9, {
   3.5661515961039596`*^9, 3.56615160789758*^9}, 3.5701962484998627`*^9, 
   3.570196412890545*^9, 3.5701969001741943`*^9, 3.570196938363061*^9, 
   3.570197085159715*^9, 3.5701971342070007`*^9, {3.570197233909974*^9, 
   3.5701972785416527`*^9}, 3.570197324172532*^9, {3.570197376967024*^9, 
   3.570197391631049*^9}, 3.570197796246955*^9, 3.5701978366410236`*^9, 
   3.570198021354945*^9, 3.5701980741042366`*^9, {3.5701981757620125`*^9, 
   3.5701981930000424`*^9}, 3.570198772037444*^9, 3.570199140528084*^9, 
   3.5701992008213873`*^9, 3.570199291891947*^9, {3.5701993836733074`*^9, 
   3.570199411176155*^9}, 3.5701994442326136`*^9, 3.5847171626202507`*^9}],

Cell[BoxData["\<\"make array plot\"\>"], "Print",
 CellChangeTimes->{
  3.5661488455071287`*^9, 3.5661490647811136`*^9, {3.56614915406007*^9, 
   3.5661491723901024`*^9}, 3.5661493540212216`*^9, {3.566149390603286*^9, 
   3.5661494068273144`*^9}, 3.56614951846111*^9, 3.5661495737320075`*^9, {
   3.566149824050047*^9, 3.5661499149514065`*^9}, 3.5661499595518847`*^9, {
   3.5661501119017525`*^9, 3.5661501398570013`*^9}, 3.5661502228803473`*^9, 
   3.566150257699609*^9, 3.5661502913020678`*^9, 3.566150328586133*^9, {
   3.5661504602971644`*^9, 3.5661504985016317`*^9}, {3.5661506869343624`*^9, 
   3.5661507121908073`*^9}, 3.5661510798054523`*^9, 3.5661511674152064`*^9, {
   3.566151333914299*^9, 3.5661514057212253`*^9}, 3.5661514968409853`*^9, {
   3.5661515961039596`*^9, 3.56615160789758*^9}, 3.5701962484998627`*^9, 
   3.570196412890545*^9, 3.5701969001741943`*^9, 3.570196938363061*^9, 
   3.570197085159715*^9, 3.5701971342070007`*^9, {3.570197233909974*^9, 
   3.5701972785416527`*^9}, 3.570197324172532*^9, {3.570197376967024*^9, 
   3.570197391631049*^9}, 3.570197796246955*^9, 3.5701978366410236`*^9, 
   3.570198021354945*^9, 3.5701980741042366`*^9, {3.5701981757620125`*^9, 
   3.5701981930000424`*^9}, 3.570198772037444*^9, 3.570199140528084*^9, 
   3.5701992008213873`*^9, 3.570199291891947*^9, {3.5701993836733074`*^9, 
   3.570199411176155*^9}, 3.5701994442326136`*^9, 3.584717162630251*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k=\"\>", "\[InvisibleSpace]", "7", 
   "\[InvisibleSpace]", "\<\"  sigma =\"\>", "\[InvisibleSpace]", "0.`"}],
  SequenceForm["k=", 7, "  sigma =", 0.],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5661488455071287`*^9, 3.5661490647811136`*^9, {3.56614915406007*^9, 
   3.5661491723901024`*^9}, 3.5661493540212216`*^9, {3.566149390603286*^9, 
   3.5661494068273144`*^9}, 3.56614951846111*^9, 3.5661495737320075`*^9, {
   3.566149824050047*^9, 3.5661499149514065`*^9}, 3.5661499595518847`*^9, {
   3.5661501119017525`*^9, 3.5661501398570013`*^9}, 3.5661502228803473`*^9, 
   3.566150257699609*^9, 3.5661502913020678`*^9, 3.566150328586133*^9, {
   3.5661504602971644`*^9, 3.5661504985016317`*^9}, {3.5661506869343624`*^9, 
   3.5661507121908073`*^9}, 3.5661510798054523`*^9, 3.5661511674152064`*^9, {
   3.566151333914299*^9, 3.5661514057212253`*^9}, 3.5661514968409853`*^9, {
   3.5661515961039596`*^9, 3.56615160789758*^9}, 3.5701962484998627`*^9, 
   3.570196412890545*^9, 3.5701969001741943`*^9, 3.570196938363061*^9, 
   3.570197085159715*^9, 3.5701971342070007`*^9, {3.570197233909974*^9, 
   3.5701972785416527`*^9}, 3.570197324172532*^9, {3.570197376967024*^9, 
   3.570197391631049*^9}, 3.570197796246955*^9, 3.5701978366410236`*^9, 
   3.570198021354945*^9, 3.5701980741042366`*^9, {3.5701981757620125`*^9, 
   3.5701981930000424`*^9}, 3.570198772037444*^9, 3.570199140528084*^9, 
   3.5701992008213873`*^9, 3.570199291891947*^9, {3.5701993836733074`*^9, 
   3.570199411176155*^9}, 3.5701994442326136`*^9, 3.5847171628702507`*^9}],

Cell[BoxData["\<\"make array plot\"\>"], "Print",
 CellChangeTimes->{
  3.5661488455071287`*^9, 3.5661490647811136`*^9, {3.56614915406007*^9, 
   3.5661491723901024`*^9}, 3.5661493540212216`*^9, {3.566149390603286*^9, 
   3.5661494068273144`*^9}, 3.56614951846111*^9, 3.5661495737320075`*^9, {
   3.566149824050047*^9, 3.5661499149514065`*^9}, 3.5661499595518847`*^9, {
   3.5661501119017525`*^9, 3.5661501398570013`*^9}, 3.5661502228803473`*^9, 
   3.566150257699609*^9, 3.5661502913020678`*^9, 3.566150328586133*^9, {
   3.5661504602971644`*^9, 3.5661504985016317`*^9}, {3.5661506869343624`*^9, 
   3.5661507121908073`*^9}, 3.5661510798054523`*^9, 3.5661511674152064`*^9, {
   3.566151333914299*^9, 3.5661514057212253`*^9}, 3.5661514968409853`*^9, {
   3.5661515961039596`*^9, 3.56615160789758*^9}, 3.5701962484998627`*^9, 
   3.570196412890545*^9, 3.5701969001741943`*^9, 3.570196938363061*^9, 
   3.570197085159715*^9, 3.5701971342070007`*^9, {3.570197233909974*^9, 
   3.5701972785416527`*^9}, 3.570197324172532*^9, {3.570197376967024*^9, 
   3.570197391631049*^9}, 3.570197796246955*^9, 3.5701978366410236`*^9, 
   3.570198021354945*^9, 3.5701980741042366`*^9, {3.5701981757620125`*^9, 
   3.5701981930000424`*^9}, 3.570198772037444*^9, 3.570199140528084*^9, 
   3.5701992008213873`*^9, 3.570199291891947*^9, {3.5701993836733074`*^9, 
   3.570199411176155*^9}, 3.5701994442326136`*^9, 3.584717162880251*^9}]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[
      RasterBox[{{0, 0, 1, 0, 0, 1, 0, 0}, {0, 0, 1, 0, 0, 1, 0, 0}, {1, 1, 1,
        0, 0, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0}, {
       1, 1, 1, 0, 0, 1, 1, 1}, {0, 0, 1, 0, 0, 1, 0, 0}, {0, 0, 1, 0, 0, 1, 
       0, 0}}, {{0, 0}, {8, 8}}, {0, 1}],
      BaseStyle->{},
      Frame->Automatic,
      FrameLabel->{None, None},
      FrameTicks->{{None, None}, {None, None}}], {196., -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmViYGDggOInwnpH/u09Y38FSrd0yPJN135lH+B5IP2o7z44DRO/
gqaeUv1tUPFWKM3roNQ9qfqD/VouM3G3Ly/gNEy8FU19AZo9a6DqGdAATBzd
XZTqp9T9Ax3+AHJv40I=
       "], {{0, 0}, {8, 8}}, {0, 1.148543244668226}],
      BaseStyle->{},
      Frame->Automatic,
      FrameLabel->{None, None},
      FrameTicks->{{None, None}, {None, None}}], {588., -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmViYGDggOIdvir6RRcu2K+B0oc/PJsjkvHOngENwMTXoKmnVP8F
qPgJKH0wq8UpQOmVfUB/88po0ZtwGiZ+Ak09xPQjeyD0jj0hUPV7Lrd1mold
hdMwcZg6VJp8/ZS6f6DDHwC73tBc
       "], {{0, 0}, {8, 8}}, {0, 1.1461694376181588`}],
      BaseStyle->{},
      Frame->Automatic,
      FrameLabel->{None, None},
      FrameTicks->{{None, None}, {None, None}}], {980., -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmViYGDggGJUcGbP1/8g8N4ewj+xB0ajip/Zg0qTr/8zVPwXlP6J
rK7hwh4Y/RNN3S8U865AzTu1B0Ufw2FUGi5+Co0mXz913D9w4Q8AdYbRXg==

       "], {{0, 0}, {8, 8}}, {0, 0.9999999999999993}],
      BaseStyle->{},
      Frame->Automatic,
      FrameLabel->{None, None},
      FrameTicks->{{None, None}, {None, None}}], {1372., -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmViYGDggGJUcGbP1/8g8N4ewj+xB0ajip/Zg0qTr/8zVPwXlP6J
rK7hwh4Y/RNN3S8U865AzTu1B0Ufw2FUGi5+Co0mXz913D9w4Q8AdYbRXg==

       "], {{0, 0}, {8, 8}}, {0, 0.9999999999999993}],
      BaseStyle->{},
      Frame->Automatic,
      FrameLabel->{None, None},
      FrameTicks->{{None, None}, {None, None}}], {1764., -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmViYGDggGJUcGbP1/8g8N4ewj+xB0ajip/Zg0qTr/8zVPwXlP6J
rK7hwh4Y/RNN3S8U865AzTu1B0Ufw2FUGi5+Co0mXz913D9w4Q8AdYbRXg==

       "], {{0, 0}, {8, 8}}, {0, 0.9999999999999993}],
      BaseStyle->{},
      Frame->Automatic,
      FrameLabel->{None, None},
      FrameTicks->{{None, None}, {None, None}}], {2156., -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmViYGDggGJUcGbP1/8g8N4ewj+xB0ajip/Zg0qTr/8zVPwXlP6J
rK7hwh4Y/RNN3S8U865AzTu1B0Ufw2FUGi5+Co0mXz913D9w4Q8AdYbRXg==

       "], {{0, 0}, {8, 8}}, {0, 0.9999999999999993}],
      BaseStyle->{},
      Frame->Automatic,
      FrameLabel->{None, None},
      FrameTicks->{{None, None}, {None, None}}], {2548., -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmViYGDggGJUcGbP1/8g8N4ewj+xB0ajip/Zg0qTr/8zVPwXlP6J
rK7hwh4Y/RNN3S8U865AzTu1B0Ufw2FUGi5+Co0mXz913D9w4Q8AdYbRXg==

       "], {{0, 0}, {8, 8}}, {0, 0.9999999999999993}],
      BaseStyle->{},
      Frame->Automatic,
      FrameLabel->{None, None},
      FrameTicks->{{None, None}, {None, None}}], {2940., -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}]}, {}},
  BaseStyle->{FontFamily -> "Helvetica"},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.570198788621872*^9, 3.5701991413936853`*^9, 3.5701992012581882`*^9, 
   3.5701992941383505`*^9, {3.57019938538931*^9, 3.5701994128453584`*^9}, 
   3.5701994459174166`*^9, 3.5847171632002516`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[
      RasterBox[{{0, 0, 1, 0, 0, 1, 0, 0}, {0, 0, 1, 0, 0, 1, 0, 0}, {1, 1, 1,
        0, 0, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0}, {
       1, 1, 1, 0, 0, 1, 1, 1}, {0, 0, 1, 0, 0, 1, 0, 0}, {0, 0, 1, 0, 0, 1, 
       0, 0}}, {{0, 0}, {8, 8}}, {0, 1}],
      BaseStyle->{},
      Frame->Automatic,
      FrameLabel->{None, None},
      FrameTicks->{{None, None}, {None, None}}], {194.4, -189.}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006`, 360.}], InsetBox[
     GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmViYGDggOInwnpH/u09Y38FSrd0yPJN135lH+B5IP2o7z44DRO/
gqaeUv1tUPFWKM3roNQ9qfqD/VouM3G3Ly/gNEy8FU19AZo9a6DqGdAATBzd
XZTqp9T9Ax3+AHJv40I=
       "], {{0, 0}, {8, 8}}, {0, 1.148543244668226}],
      BaseStyle->{},
      Frame->Automatic,
      FrameLabel->{None, None},
      FrameTicks->{{None, None}, {None, None}}], {583.2, -189.}, 
     ImageScaled[{0.5, 0.5}], {360.00000000000006`, 360.}], InsetBox[
     GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmViYGDggOIdvir6RRcu2K+B0oc/PJsjkvHOngENwMTXoKmnVP8F
qPgJKH0wq8UpQOmVfUB/88po0ZtwGiZ+Ak09xPQjeyD0jj0hUPV7Lrd1mold
hdMwcZg6VJp8/ZS6f6DDHwC73tBc
       "], {{0, 0}, {8, 8}}, {0, 1.1461694376181588`}],
      BaseStyle->{},
      Frame->Automatic,
      FrameLabel->{None, None},
      FrameTicks->{{None, None}, {None, None}}], {972., -189.}, 
     ImageScaled[{0.5, 0.5}], {360., 360.}], InsetBox[
     GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmViYGDggGJUcGbP1/8g8N4ewj+xB0ajip/Zg0qTr/8zVPwXlP6J
rK7hwh4Y/RNN3S8U865AzTu1B0Ufw2FUGi5+Co0mXz913D9w4Q8AdYbRXg==

       "], {{0, 0}, {8, 8}}, {0, 0.9999999999999993}],
      BaseStyle->{},
      Frame->Automatic,
      FrameLabel->{None, None},
      FrameTicks->{{None, None}, {None, None}}], {1360.8000000000002`, -189.},
      ImageScaled[{0.5, 0.5}], {359.9999999999998, 360.}]}, {}},
  BaseStyle->{FontFamily -> "Helvetica"},
  ContentSelectable->True,
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{
  3.570198788621872*^9, 3.5701991413936853`*^9, 3.5701992012581882`*^9, 
   3.5701992941383505`*^9, {3.57019938538931*^9, 3.5701994128453584`*^9}, 
   3.5701994459174166`*^9, 3.5847171632302513`*^9}]
}, Open  ]],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{{3.5661516813581095`*^9, 3.5661517006365433`*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1086, 630},
WindowMargins->{{Automatic, 14}, {Automatic, 49}},
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.5, 1.5 Inherited],
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 691, 12, 206, "Subtitle"],
Cell[1273, 36, 713, 13, 329, "Subsubtitle"],
Cell[CellGroupData[{
Cell[2011, 53, 129, 4, 143, "Section"],
Cell[2143, 59, 7319, 167, 692, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9499, 231, 115, 4, 143, "Section"],
Cell[CellGroupData[{
Cell[9639, 239, 10988, 256, 1691, "Input"],
Cell[CellGroupData[{
Cell[20652, 499, 2685, 50, 175, "Print"],
Cell[23340, 551, 1526, 23, 32, "Print"],
Cell[24869, 576, 3939, 75, 217, "Print"],
Cell[28811, 653, 3849, 72, 217, "Print"],
Cell[32663, 727, 2770, 52, 175, "Print"],
Cell[35436, 781, 1425, 19, 32, "Print"],
Cell[36864, 802, 1631, 25, 32, "Print"],
Cell[38498, 829, 1415, 19, 32, "Print"],
Cell[39916, 850, 1632, 25, 32, "Print"],
Cell[41551, 877, 1413, 19, 32, "Print"],
Cell[42967, 898, 1632, 25, 32, "Print"],
Cell[44602, 925, 1413, 19, 32, "Print"]
}, Open  ]],
Cell[46030, 947, 2263, 36, 205, "Message"],
Cell[48296, 985, 2263, 36, 205, "Message"],
Cell[50562, 1023, 2263, 36, 205, "Message"],
Cell[52828, 1061, 679, 14, 35, "Message"],
Cell[CellGroupData[{
Cell[53532, 1079, 1597, 24, 32, "Print"],
Cell[55132, 1105, 1412, 19, 32, "Print"],
Cell[56547, 1126, 1594, 24, 32, "Print"],
Cell[58144, 1152, 1415, 19, 32, "Print"],
Cell[59562, 1173, 1597, 24, 32, "Print"],
Cell[61162, 1199, 1413, 19, 32, "Print"],
Cell[62578, 1220, 1597, 24, 32, "Print"],
Cell[64178, 1246, 1413, 19, 32, "Print"]
}, Open  ]],
Cell[65606, 1268, 3859, 88, 109, "Output"],
Cell[69468, 1358, 2230, 48, 179, "Output"]
}, Open  ]],
Cell[71713, 1409, 115, 1, 71, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
