(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     43129,       1045]
NotebookOptionsPosition[     41961,       1004]
NotebookOutlinePosition[     42404,       1021]
CellTagsIndexPosition[     42361,       1018]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9},
 FontFamily->"Arial"],

Cell[TextData[{
 "\n",
 StyleBox["SVD Basics",
  FontWeight->"Bold"],
 "\nThis nb computes the SVD of a matrix m = uu.sigma.vv^T  two ways\n1) with \
Mathematica\[CloseCurlyQuote] s routine and \n2) by forming the symmteric \
matrices mm^T and m^Tm \nThen the results are printed to check that they are \
the same.\nThe input matrix is msize x nsize\n"
}], "Subsubtitle",
 CellChangeTimes->{{3.563739128898603*^9, 3.563739156183051*^9}, {
   3.5846493419906397`*^9, 3.5846494165899706`*^9}, {3.58464973506453*^9, 
   3.5846497855930185`*^9}, {3.5846500795599346`*^9, 3.584650087500349*^9}, {
   3.584650346180003*^9, 3.5846503794080615`*^9}, {3.58465045250979*^9, 
   3.5846504670490155`*^9}, 3.584715697390193*^9}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"to", " ", "enable", " ", "file", " ", 
    RowBox[{"export", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetDirectory", "[", 
     RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5619222362449093`*^9, 3.561922257523347*^9}, 
   3.561930070400257*^9, {3.5846501164539995`*^9, 3.5846501391520395`*^9}}],

Cell[CellGroupData[{

Cell["Input -- load matrix into m", "Section",
 CellChangeTimes->{{3.5846494515028315`*^9, 3.58464946749286*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Pick", " ", "an", " ", "input", " ", "matrix", " ", "and", " ", "load", 
    " ", "into", " ", "m", " ", "below"}], " ", "*)"}], "\[IndentingNewLine]",
   "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"m0", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";", "  ", 
    RowBox[{"(*", " ", 
     RowBox[{"shear", " ", "in", " ", "pla"}], " ", "*)"}], 
    "\[IndentingNewLine]", " ", 
    RowBox[{"m1", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"3", "x2", " ", "example", " ", "in", " ", "pla"}], " ", "*)"}], 
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
    RowBox[{"m2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.8"}], ",", " ", "0", ",", " ", "0.8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", " ", "1.5", ",", " ", 
         RowBox[{"-", "0.3"}]}], "}"}]}], "}"}]}], ";", "  ", 
    RowBox[{"(*", " ", 
     RowBox[{"2", "x3", " ", "example", " ", "in", " ", "pla"}], " ", "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{"this", " ", "is", " ", "the", " ", "vv", " ", "from", " ", "2", 
      RowBox[{"x3", " ", "--"}], " ", "to", " ", "see", " ", "that", " ", 
      "it", " ", "is", " ", "a", " ", "rotation"}], " ", "*)"}], 
    "\[IndentingNewLine]", 
    RowBox[{"m2v", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.6336240919231784`"}], ",", "0.38421179904749553`", 
         ",", "0.6714922215537678`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.7126647870884324`"}], ",", 
         RowBox[{"-", "0.6276244963818958`"}], ",", 
         RowBox[{"-", "0.31336303672509164`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.30104719128190993`", ",", 
         RowBox[{"-", "0.6771032306923801`"}], ",", "0.6714922215537679`"}], 
        "}"}]}], "}"}]}], ";"}], " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m2u", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.38491388955472267`", ",", 
         RowBox[{"-", "0.9229524893665191`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.9229524893665191`"}], ",", 
         RowBox[{"-", "0.38491388955472267`"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m3", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m4", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "4"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m5", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m6", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m7", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0.5"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m8", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m9", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m10", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m11", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m12", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Set", " ", "the", " ", "matrix", " ", "to", " ", "use"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"m", " ", "=", " ", "m1"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Matrix", " ", 
     RowBox[{"dimensions", ":", " ", 
      RowBox[{"msize", " ", "x", " ", "nsize"}]}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"msize", ",", " ", "nsize"}], "}"}], " ", "=", " ", 
     RowBox[{"Dimensions", "[", "m", "]"}]}], ";"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5619222682249656`*^9, 3.5619223194710555`*^9}, {
   3.561922363478733*^9, 3.5619225488070583`*^9}, {3.5619225949363394`*^9, 
   3.561922631159603*^9}, {3.5619227001897244`*^9, 3.5619230067926626`*^9}, 
   3.561923072718379*^9, 3.5619234930683174`*^9, {3.5619253840272255`*^9, 
   3.5619254078172674`*^9}, {3.561925452386546*^9, 3.561925464741768*^9}, {
   3.561926021413145*^9, 3.561926059352412*^9}, 3.5619260931420712`*^9, 
   3.5619261410809555`*^9, {3.561926310606453*^9, 3.561926323102075*^9}, {
   3.5619263595437393`*^9, 3.5619264771991463`*^9}, {3.561926620610198*^9, 
   3.5619266933375254`*^9}, {3.5619267282815866`*^9, 3.561927127923089*^9}, {
   3.5619272787597537`*^9, 3.5619273297250433`*^9}, {3.562006170415265*^9, 
   3.562006192302104*^9}, {3.5620062382753844`*^9, 3.5620062479006014`*^9}, {
   3.5620709328275676`*^9, 3.5620710139633102`*^9}, {3.5620710675806046`*^9, 
   3.56207123021089*^9}, {3.5620712726897645`*^9, 3.5620715644726768`*^9}, {
   3.562071595064331*^9, 3.562071705671325*^9}, {3.562071823430334*^9, 
   3.562071887936447*^9}, {3.5620722552234926`*^9, 3.562072275753128*^9}, {
   3.562072315891999*^9, 3.5620724936383114`*^9}, {3.562072989937583*^9, 
   3.5620730119492216`*^9}, {3.5620731232754173`*^9, 3.562073182196721*^9}, {
   3.562078950920145*^9, 3.562078972104982*^9}, {3.5620866763481646`*^9, 
   3.562086684011778*^9}, {3.562088432618802*^9, 3.562088446651625*^9}, {
   3.5620889547160945`*^9, 3.562089021074206*^9}, {3.5621579159546423`*^9, 
   3.562157992753577*^9}, {3.5621581563198643`*^9, 3.562158320884554*^9}, {
   3.5621903978558483`*^9, 3.562190424765895*^9}, {3.5623518153166966`*^9, 
   3.562351815406702*^9}, {3.562351935647579*^9, 3.562351995593008*^9}, {
   3.5623520268187943`*^9, 3.562352265946471*^9}, {3.5623523058907557`*^9, 
   3.562352382338128*^9}, {3.5623532326557636`*^9, 3.5623532468295746`*^9}, {
   3.5623533953340683`*^9, 3.562353426254837*^9}, {3.5624239544137077`*^9, 
   3.5624239545541077`*^9}, {3.5624242570854387`*^9, 
   3.5624242927939014`*^9}, {3.562424334508375*^9, 3.562424338377182*^9}, {
   3.5624277002454967`*^9, 3.5624277161107244`*^9}, {3.56363487736112*^9, 
   3.563634917827592*^9}, {3.5636351570072117`*^9, 3.5636351576624126`*^9}, {
   3.563723968811499*^9, 3.563723978062316*^9}, {3.5637246879883623`*^9, 
   3.563724724882427*^9}, {3.563724806735771*^9, 3.5637248343322196`*^9}, {
   3.563724873269888*^9, 3.563724930007188*^9}, {3.5637249900204926`*^9, 
   3.563725007320923*^9}, {3.5637250751654425`*^9, 3.5637251183463182`*^9}, {
   3.5637258586456184`*^9, 3.5637258962572846`*^9}, {3.5637391166837816`*^9, 
   3.563739116792982*^9}, {3.5637472883149333`*^9, 3.563747288907734*^9}, {
   3.5637474436750064`*^9, 3.563747446233411*^9}, {3.5637475381799726`*^9, 
   3.563747541721178*^9}, 3.5637478587293353`*^9, {3.563800986921939*^9, 
   3.563800999979162*^9}, {3.563801281076056*^9, 3.5638012922768755`*^9}, {
   3.5638013278761377`*^9, 3.5638013531949825`*^9}, {3.563801498602838*^9, 
   3.5638015062000513`*^9}, 3.5638016652891307`*^9, {3.563801697861988*^9, 
   3.5638017026355963`*^9}, {3.5638017746921225`*^9, 3.563801775628124*^9}, {
   3.563802456232935*^9, 3.5638024883845916`*^9}, {3.5638027118721266`*^9, 
   3.5638027583409986`*^9}, {3.5638028939652023`*^9, 3.563802896935207*^9}, {
   3.5638049670177393`*^9, 3.5638049769817553`*^9}, {3.563805010793007*^9, 
   3.5638050131930103`*^9}, {3.5638079625852056`*^9, 3.563807978545228*^9}, {
   3.5638348380028105`*^9, 3.5638348383460107`*^9}, {3.563834887133294*^9, 
   3.5638348913141017`*^9}, {3.5638350374683547`*^9, 3.563835053429182*^9}, {
   3.5638356013601303`*^9, 3.5638356093785443`*^9}, {3.563835644792606*^9, 
   3.563835653403821*^9}, {3.5638874188707085`*^9, 3.563887418917509*^9}, {
   3.5638896214916697`*^9, 3.5638896426693*^9}, 3.563889939407339*^9, {
   3.5639086762462196`*^9, 3.5639086768390207`*^9}, {3.564767068176159*^9, 
   3.564767068488159*^9}, {3.5695850074884005`*^9, 3.569585028376837*^9}, 
   3.569585192317525*^9, {3.584649488630897*^9, 3.584649492577704*^9}, {
   3.584649883576791*^9, 3.5846498836391907`*^9}, {3.58464991722605*^9, 
   3.5846499175380507`*^9}, {3.584650399703697*^9, 3.584650419765332*^9}, {
   3.5846508481888847`*^9, 3.5846508483760853`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
SVD
\
\>", "Section",
 CellChangeTimes->{{3.5846494983497143`*^9, 3.5846495038253236`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"SVD", " ", "of", " ", "m"}], " ", "=", " ", 
    RowBox[{"uu", ".", "sigma", ".", 
     RowBox[{"vv", "^", "T"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"uu", ",", "sigma", ",", "vv"}], "}"}], "=", 
     RowBox[{"SingularValueDecomposition", "[", "m", "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<m =   \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "m", "]"}], "//", "N"}], ",", 
      "\"\<  size mxn=\>\"", ",", "msize", ",", "\"\< x \>\"", ",", "nsize", 
      ",", "\"\<    rank=\>\"", ",", 
      RowBox[{"MatrixRank", "[", "m", "]"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<uu =  \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "uu", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<vv =  \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "vv", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<sigma=\>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "sigma", "]"}], "//", "N"}]}], "]"}], ";"}],
    "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Form", " ", "the", " ", "SVD", " ", "product", " ", "to", " ", "check", 
     " ", "against", " ", "the", " ", "matrix"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pm", " ", "=", " ", 
     RowBox[{"uu", ".", "sigma", ".", 
      RowBox[{"Transpose", "[", "vv", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<SVD product: uu.sigma.vv^T = \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "pm", "]"}], "//", "N"}], ",", 
      "\"\<  =? \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "m", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Form", " ", "the", " ", "two", " ", "symmetric", " ", "matrices", " ", 
     "from", " ", "m"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mmt", " ", "=", " ", 
     RowBox[{"m", ".", 
      RowBox[{"Transpose", "[", "m", "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mtm", " ", "=", " ", 
     RowBox[{
      RowBox[{"Transpose", "[", "m", "]"}], ".", "m"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Get", " ", "SVD", " ", "another", " ", "way"}], " ", "..."}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
      "Get", " ", "\"\<ethings\>\"", " ", "from", " ", "mmt", " ", "and", " ",
        "mtm"}], ";", " ", 
      RowBox[{"will", " ", "form", " ", "Sigma"}]}], ",", " ", "U", ",", " ", 
     "V"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Eigenvalues", " ", "of", " ", "both", " ", "should", " ", "be", " ", 
     RowBox[{"equal", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Evecs", " ", "of", " ", "mmt", " ", "give", " ", "U", " ", "and", " ", 
     "evecs", " ", "of", " ", "mtm", " ", "give", " ", 
     RowBox[{"V", " ", "--"}], " ", "once", " ", "normalized"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"evalsmmt", " ", "=", " ", 
     RowBox[{"Eigenvalues", "[", "mmt", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"evecsmmt", " ", "=", " ", 
     RowBox[{"Eigenvectors", "[", "mmt", "]"}]}], ";", " ", 
    RowBox[{"(*", " ", "mxm", " ", "*)"}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{"these", " ", "are", " ", "the", " ", "V", " ", "things"}], " ", 
     "*)"}], "\[IndentingNewLine]", 
    RowBox[{"evalsmtm", " ", "=", " ", 
     RowBox[{"Eigenvalues", "[", "mtm", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"evecsmtm", " ", "=", " ", 
     RowBox[{"Eigenvectors", "[", "mtm", "]"}]}], ";", " ", 
    RowBox[{"(*", " ", "nxn", " ", "*)"}], "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
     "normalize", " ", "the", " ", "eigenvectors", " ", "to", " ", "compare", 
      " ", "to", " ", "U", " ", "and", " ", "V", " ", "that", " ", 
      "Mathematica", " ", "computed"}], " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"evecsmmt", "[", 
          RowBox[{"[", "i", "]"}], "]"}], " ", "=", " ", 
         RowBox[{
          RowBox[{"evecsmmt", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "/", 
          RowBox[{"Norm", "[", 
           RowBox[{"evecsmmt", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "]"}]}]}], ";"}], ")"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "msize"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"evecsmtm", "[", 
         RowBox[{"[", "i", "]"}], "]"}], " ", "=", " ", 
        RowBox[{
         RowBox[{"evecsmtm", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "/", 
         RowBox[{"Norm", "[", 
          RowBox[{"evecsmtm", "[", 
           RowBox[{"[", "i", "]"}], "]"}], "]"}]}]}], ")"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "nsize"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Compute", " ", "U", " ", "as", " ", "normalized", " ", 
     RowBox[{"Av_i", " ", "--"}], " ", "check", " ", "same", " ", "as", " ", 
     "from", " ", 
     RowBox[{"AA", "^", "T"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"This", " ", "is", " ", "just", " ", "the", " ", "1"}], " ", 
       ".."}], " ", "n", " ", "If", " ", "m"}], ">", 
     RowBox[{
     "n", " ", "then", " ", "would", " ", "need", " ", "to", " ", "fill", " ",
       "in", " ", "rest", " ", "of", " ", 
      RowBox[{"R", "^", "m"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Initialize", " ", "u2", " ", "by", " ", "making", " ", "it", " ", 
      "same", " ", "as", " ", 
      RowBox[{"V", " ", "--"}], " ", "not", " ", "meaningful"}], ",", " ", 
     RowBox[{"just", " ", "for", " ", "size"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"u2", " ", "=", " ", "evecsmtm"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"(", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"w", " ", "=", " ", 
         RowBox[{"m", ".", 
          RowBox[{"evecsmtm", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"u2", "[", 
          RowBox[{"[", "i", "]"}], "]"}], " ", "=", " ", 
         RowBox[{"w", "/", 
          RowBox[{"Norm", "[", "w", "]"}]}]}], ";"}], ")"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "nsize"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<u_i = normalized Av_i  rows of\>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "u2", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<m.m^T =\>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "mmt", "]"}], "//", "N"}], ",", 
      "\"\<  evals=\>\"", ",", 
      RowBox[{"evalsmmt", "//", "N"}], ",", "\"\<  evecs (rows)=\>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "evecsmmt", "]"}], "//", "N"}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<m^T.m =\>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "mtm", "]"}], "//", "N"}], ",", 
      "\"\<   evals=\>\"", ",", 
      RowBox[{"evalsmtm", "//", "N"}], ",", "\"\<  evecs (rows)=\>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "evecsmtm", "]"}], "//", "N"}]}], "]"}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Check", " ", "that", " ", "the", " ", "evalues", " ", "from", " ", 
     "both", " ", "symmetric", " ", "matrics", " ", "correspond", " ", "to", 
     " ", "the", " ", "singular", " ", "values", " ", "that", " ", 
     "Mathematica", " ", 
     RowBox[{"computed", ".", " ", "Need"}], " ", "to", " ", "take", " ", 
     "square", " ", "root"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Equate", " ", "the", " ", "Sigma", " ", "vector", " ", "to", " ", "the", 
     " ", "eigenvalue", " ", "vectors", " ", "to", " ", "initialize"}], " ", 
    "*)"}], " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"smmt", " ", "=", " ", "evalsmmt"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"smtm", " ", "=", " ", "evalsmtm"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"smmt", "[", 
         RowBox[{"[", "i", "]"}], "]"}], " ", "=", " ", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"evalsmmt", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "]"}]}], ")"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "msize"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"smtm", "[", 
         RowBox[{"[", "i", "]"}], "]"}], " ", "=", " ", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"evalsmtm", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "]"}]}], ")"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "nsize"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<check sigma = sqrt(lambda):  \n       mm^T sigmas\>\"", ",", 
      RowBox[{"smmt", "//", "N"}], ",", "\"\<    m^Tm sigmas \>\"", ",", 
      RowBox[{"smtm", "//", "N"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<Det = Product of Sigma = \>\"", ",", 
      RowBox[{
       RowBox[{"Product", "[", 
        RowBox[{
         RowBox[{"sigma", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "i"}], "]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "nsize"}], "}"}]}], "]"}], "//", 
       "N"}]}], "]"}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5619222682249656`*^9, 3.5619223194710555`*^9}, {
   3.561922363478733*^9, 3.5619225488070583`*^9}, {3.5619225949363394`*^9, 
   3.561922631159603*^9}, {3.5619227001897244`*^9, 3.5619230067926626`*^9}, 
   3.561923072718379*^9, 3.5619234930683174`*^9, {3.5619253840272255`*^9, 
   3.5619254078172674`*^9}, {3.561925452386546*^9, 3.561925464741768*^9}, {
   3.561926021413145*^9, 3.561926059352412*^9}, 3.5619260931420712`*^9, 
   3.5619261410809555`*^9, {3.561926310606453*^9, 3.561926323102075*^9}, {
   3.5619263595437393`*^9, 3.5619264771991463`*^9}, {3.561926620610198*^9, 
   3.5619266933375254`*^9}, {3.5619267282815866`*^9, 3.561927127923089*^9}, {
   3.5619272787597537`*^9, 3.5619273297250433`*^9}, {3.562006170415265*^9, 
   3.562006192302104*^9}, {3.5620062382753844`*^9, 3.5620062479006014`*^9}, {
   3.5620709328275676`*^9, 3.5620710139633102`*^9}, {3.5620710675806046`*^9, 
   3.56207123021089*^9}, {3.5620712726897645`*^9, 3.5620715644726768`*^9}, {
   3.562071595064331*^9, 3.562071705671325*^9}, {3.562071823430334*^9, 
   3.562071887936447*^9}, {3.5620722552234926`*^9, 3.562072275753128*^9}, {
   3.562072315891999*^9, 3.5620724936383114`*^9}, {3.562072989937583*^9, 
   3.5620730119492216`*^9}, {3.5620731232754173`*^9, 3.562073182196721*^9}, {
   3.562078950920145*^9, 3.562078972104982*^9}, {3.5620866763481646`*^9, 
   3.562086684011778*^9}, {3.562088432618802*^9, 3.562088446651625*^9}, {
   3.5620889547160945`*^9, 3.562089021074206*^9}, {3.5621579159546423`*^9, 
   3.562157992753577*^9}, {3.5621581563198643`*^9, 3.562158320884554*^9}, {
   3.5621903978558483`*^9, 3.562190424765895*^9}, {3.5623518153166966`*^9, 
   3.562351815406702*^9}, {3.562351935647579*^9, 3.562351995593008*^9}, {
   3.5623520268187943`*^9, 3.562352265946471*^9}, {3.5623523058907557`*^9, 
   3.562352382338128*^9}, {3.5623532326557636`*^9, 3.5623532468295746`*^9}, {
   3.5623533953340683`*^9, 3.562353426254837*^9}, {3.5624239544137077`*^9, 
   3.5624239545541077`*^9}, {3.5624242570854387`*^9, 
   3.5624242927939014`*^9}, {3.562424334508375*^9, 3.562424338377182*^9}, {
   3.5624277002454967`*^9, 3.5624277161107244`*^9}, {3.56363487736112*^9, 
   3.563634917827592*^9}, {3.5636351570072117`*^9, 3.5636351576624126`*^9}, {
   3.563723968811499*^9, 3.563723978062316*^9}, {3.5637246879883623`*^9, 
   3.563724724882427*^9}, {3.563724806735771*^9, 3.5637248343322196`*^9}, {
   3.563724873269888*^9, 3.563724930007188*^9}, {3.5637249900204926`*^9, 
   3.563725007320923*^9}, {3.5637250751654425`*^9, 3.5637251183463182`*^9}, {
   3.5637258586456184`*^9, 3.5637258962572846`*^9}, {3.5637391166837816`*^9, 
   3.563739116792982*^9}, {3.5637472883149333`*^9, 3.563747288907734*^9}, {
   3.5637474436750064`*^9, 3.563747446233411*^9}, {3.5637475381799726`*^9, 
   3.563747541721178*^9}, 3.5637478587293353`*^9, {3.563800986921939*^9, 
   3.563800999979162*^9}, {3.563801281076056*^9, 3.5638012922768755`*^9}, {
   3.5638013278761377`*^9, 3.5638013531949825`*^9}, {3.563801498602838*^9, 
   3.5638015062000513`*^9}, 3.5638016652891307`*^9, {3.563801697861988*^9, 
   3.5638017026355963`*^9}, {3.5638017746921225`*^9, 3.563801775628124*^9}, {
   3.563802456232935*^9, 3.5638024883845916`*^9}, {3.5638027118721266`*^9, 
   3.5638027583409986`*^9}, {3.5638028939652023`*^9, 3.563802896935207*^9}, {
   3.5638049670177393`*^9, 3.5638049769817553`*^9}, {3.563805010793007*^9, 
   3.5638050131930103`*^9}, {3.5638079625852056`*^9, 3.563807978545228*^9}, {
   3.5638348380028105`*^9, 3.5638348383460107`*^9}, {3.563834887133294*^9, 
   3.5638348913141017`*^9}, {3.5638350374683547`*^9, 3.563835053429182*^9}, {
   3.5638356013601303`*^9, 3.5638356093785443`*^9}, {3.563835644792606*^9, 
   3.563835653403821*^9}, {3.5638874188707085`*^9, 3.563887418917509*^9}, {
   3.5638896214916697`*^9, 3.5638896426693*^9}, 3.563889939407339*^9, {
   3.5639086762462196`*^9, 3.5639086768390207`*^9}, {3.564767068176159*^9, 
   3.564767068488159*^9}, {3.5695850074884005`*^9, 3.569585028376837*^9}, 
   3.569585192317525*^9, {3.584649488630897*^9, 3.584649492577704*^9}, {
   3.584649642119567*^9, 3.584649642915168*^9}, {3.584650511353093*^9, 
   3.5846505183731055`*^9}, {3.584650578620412*^9, 3.5846505855312233`*^9}, 
   3.5846506156548767`*^9, {3.58465067445138*^9, 3.5846506923914113`*^9}, {
   3.584650941414649*^9, 3.58465094206985*^9}, {3.5846509902427344`*^9, 
   3.5846509902739344`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"m =   \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.`", "0.`"},
       {"0.`", "2.`"},
       {"0.`", "1.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"  size mxn=\"\>", 
   "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\" x \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\"    rank=\"\>", 
   "\[InvisibleSpace]", "2"}],
  SequenceForm["m =   ", 
   MatrixForm[{{1., 0.}, {0., 2.}, {0., 1.}}], "  size mxn=", 3, " x ", 2, 
   "    rank=", 2],
  Editable->False]], "Print",
 CellChangeTimes->{3.5846498870711966`*^9, 3.584649920704856*^9, 
  3.5846499650557337`*^9, 3.5846507302058773`*^9, 3.5846508519016914`*^9, 
  3.584650949620263*^9, 3.58465100459476*^9, 3.584715524569951*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"uu =  \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.`", "1.`", "0.`"},
       {"0.8944271909999159`", "0.`", 
        RowBox[{"-", "0.4472135954999579`"}]},
       {"0.4472135954999579`", "0.`", "0.8944271909999159`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["uu =  ", 
   MatrixForm[{{0., 1., 0.}, {0.8944271909999159, 0., -0.4472135954999579}, {
    0.4472135954999579, 0., 0.8944271909999159}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.5846498870711966`*^9, 3.584649920704856*^9, 
  3.5846499650557337`*^9, 3.5846507302058773`*^9, 3.5846508519016914`*^9, 
  3.584650949620263*^9, 3.58465100459476*^9, 3.5847155245799513`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"vv =  \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.`", "1.`"},
       {"1.`", "0.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["vv =  ", 
   MatrixForm[{{0., 1.}, {1., 0.}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.5846498870711966`*^9, 3.584649920704856*^9, 
  3.5846499650557337`*^9, 3.5846507302058773`*^9, 3.5846508519016914`*^9, 
  3.584650949620263*^9, 3.58465100459476*^9, 3.5847155245899515`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"sigma=\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2.23606797749979`", "0.`"},
       {"0.`", "1.`"},
       {"0.`", "0.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["sigma=", 
   MatrixForm[{{2.23606797749979, 0.}, {0., 1.}, {0., 0.}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.5846498870711966`*^9, 3.584649920704856*^9, 
  3.5846499650557337`*^9, 3.5846507302058773`*^9, 3.5846508519016914`*^9, 
  3.584650949620263*^9, 3.58465100459476*^9, 3.5847155245999513`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"SVD product: uu.sigma.vv^T = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.`", "0.`"},
       {"0.`", "2.`"},
       {"0.`", "1.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"  =? \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.`", "0.`"},
       {"0.`", "2.`"},
       {"0.`", "1.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["SVD product: uu.sigma.vv^T = ", 
   MatrixForm[{{1., 0.}, {0., 2.}, {0., 1.}}], "  =? ", 
   MatrixForm[{{1., 0.}, {0., 2.}, {0., 1.}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.5846498870711966`*^9, 3.584649920704856*^9, 
  3.5846499650557337`*^9, 3.5846507302058773`*^9, 3.5846508519016914`*^9, 
  3.584650949620263*^9, 3.58465100459476*^9, 3.584715524609951*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"u_i = normalized Av_i  rows of\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.`", "0.8944271909999159`", "0.4472135954999579`"},
       {"1.`", "0.`", "0.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["u_i = normalized Av_i  rows of", 
   MatrixForm[{{0., 0.8944271909999159, 0.4472135954999579}, {1., 0., 0.}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.5846498870711966`*^9, 3.584649920704856*^9, 
  3.5846499650557337`*^9, 3.5846507302058773`*^9, 3.5846508519016914`*^9, 
  3.584650949620263*^9, 3.58465100459476*^9, 3.584715524609951*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"m.m^T =\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.`", "0.`", "0.`"},
       {"0.`", "4.`", "2.`"},
       {"0.`", "2.`", "1.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"  evals=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"5.`", ",", "1.`", ",", "0.`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"  evecs (rows)=\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.`", "0.8944271909999159`", "0.4472135954999579`"},
       {"1.`", "0.`", "0.`"},
       {"0.`", 
        RowBox[{"-", "0.4472135954999579`"}], "0.8944271909999159`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["m.m^T =", 
   MatrixForm[{{1., 0., 0.}, {0., 4., 2.}, {0., 2., 1.}}], "  evals=", {5., 
   1., 0.}, "  evecs (rows)=", 
   MatrixForm[{{0., 0.8944271909999159, 0.4472135954999579}, {1., 0., 0.}, {
    0., -0.4472135954999579, 0.8944271909999159}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.5846498870711966`*^9, 3.584649920704856*^9, 
  3.5846499650557337`*^9, 3.5846507302058773`*^9, 3.5846508519016914`*^9, 
  3.584650949620263*^9, 3.58465100459476*^9, 3.584715524609951*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"m^T.m =\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.`", "0.`"},
       {"0.`", "5.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"   evals=\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"5.`", ",", "1.`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"  evecs (rows)=\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.`", "1.`"},
       {"1.`", "0.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["m^T.m =", 
   MatrixForm[{{1., 0.}, {0., 5.}}], "   evals=", {5., 1.}, "  evecs (rows)=", 
   MatrixForm[{{0., 1.}, {1., 0.}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.5846498870711966`*^9, 3.584649920704856*^9, 
  3.5846499650557337`*^9, 3.5846507302058773`*^9, 3.5846508519016914`*^9, 
  3.584650949620263*^9, 3.58465100459476*^9, 3.584715524609951*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"check sigma = sqrt(lambda):  \\n       mm^T sigmas\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2.23606797749979`", ",", "1.`", ",", "0.`"}], "}"}], 
   "\[InvisibleSpace]", "\<\"    m^Tm sigmas \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2.23606797749979`", ",", "1.`"}], "}"}]}],
  SequenceForm[
  "check sigma = sqrt(lambda):  \n       mm^T sigmas", {2.23606797749979, 1., 
   0.}, "    m^Tm sigmas ", {2.23606797749979, 1.}],
  Editable->False]], "Print",
 CellChangeTimes->{3.5846498870711966`*^9, 3.584649920704856*^9, 
  3.5846499650557337`*^9, 3.5846507302058773`*^9, 3.5846508519016914`*^9, 
  3.584650949620263*^9, 3.58465100459476*^9, 3.584715524609951*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Det = Product of Sigma = \"\>", "\[InvisibleSpace]", 
   "2.23606797749979`"}],
  SequenceForm["Det = Product of Sigma = ", 2.23606797749979],
  Editable->False]], "Print",
 CellChangeTimes->{3.5846498870711966`*^9, 3.584649920704856*^9, 
  3.5846499650557337`*^9, 3.5846507302058773`*^9, 3.5846508519016914`*^9, 
  3.584650949620263*^9, 3.58465100459476*^9, 3.584715524609951*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1199, 630},
WindowMargins->{{Automatic, 42}, {Automatic, 45}},
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.5, 1.5 Inherited],
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 691, 12, 161, "Subtitle"],
Cell[1273, 36, 715, 13, 244, "Subsubtitle"],
Cell[1991, 51, 489, 11, 125, "Input"],
Cell[CellGroupData[{
Cell[2505, 66, 113, 1, 105, "Section"],
Cell[2621, 69, 10938, 252, 908, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13596, 326, 101, 4, 143, "Section"],
Cell[CellGroupData[{
Cell[13722, 334, 15408, 340, 1718, "Input"],
Cell[CellGroupData[{
Cell[29155, 678, 1284, 30, 70, "Print"],
Cell[30442, 710, 1217, 28, 70, "Print"],
Cell[31662, 740, 993, 25, 49, "Print"],
Cell[32658, 767, 1054, 26, 70, "Print"],
Cell[33715, 795, 1817, 46, 70, "Print"],
Cell[35535, 843, 1125, 25, 49, "Print"],
Cell[36663, 870, 2183, 52, 70, "Print"],
Cell[38849, 924, 1875, 47, 49, "Print"],
Cell[40727, 973, 749, 15, 58, "Print"],
Cell[41479, 990, 430, 8, 32, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
