(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     25115,        649]
NotebookOptionsPosition[     24407,        621]
NotebookOutlinePosition[     24749,        636]
CellTagsIndexPosition[     24706,        633]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9},
 FontFamily->"Arial"],

Cell[TextData[{
 "\n",
 StyleBox["SVD Dimensions",
  FontWeight->"Bold"],
 "\nVisualize the dimensions of the elements of the SVD of an m x n matrix \n\
Three cases: m = n, m < n, m > n"
}], "Subsubtitle",
 CellChangeTimes->{{3.5847157674002914`*^9, 3.5847157739003005`*^9}, {
  3.5847158332503834`*^9, 3.5847159205305057`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SetOptions", "[", 
     RowBox[{"Graphics", ",", 
      RowBox[{"BaseStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}], "}"}]}]}], 
     "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], "\[IndentingNewLine]", "\n", 
   RowBox[{
    RowBox[{"aa", "=", " ", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"LightGray", ",", 
        RowBox[{"Rectangle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.5"}], ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "0.5"}], ",", "2"}], "}"}]}], "]"}]}], "}"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vv", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"LightGray", ",", 
        RowBox[{"Rectangle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0.5", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2.5", ",", "2"}], "}"}]}], "]"}]}], "}"}], "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ss", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"LightGray", ",", 
        RowBox[{"Rectangle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"3.0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4.0", ",", "2"}], "}"}]}], "]"}]}], "}"}], "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"uu", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"LightGray", ",", 
        RowBox[{"Rectangle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"4.5", ",", "0.5"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"5.5", ",", "1.5"}], "}"}]}], "]"}]}], "}"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"equal", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<=\>\"", ",", "Large"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"labela", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<A\>\"", ",", "Large"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], "}"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"labelv", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<U\>\"", ",", "Large"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.5", ",", "1"}], "}"}]}], "]"}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"labels", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<\[CapitalSigma]\>\"", ",", "Large"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"3.5", ",", "1"}], "}"}]}], "]"}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"labelu", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SuperscriptBox[\(V\), \(T\)]\)\>\"", ",", "Large"}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"5.0", ",", "1"}], "}"}]}], "]"}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"pic1", " ", "=", " ", 
    RowBox[{"Show", "[", 
     RowBox[{"{", 
      RowBox[{
      "aa", ",", "vv", ",", "ss", ",", "uu", ",", "equal", ",", "labela", ",",
        "labelv", ",", "labels", ",", "labelu"}], "}"}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<DimsMgN.eps\>\"", ",", "pic1"}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.5619281142307673`*^9, 3.561928114542775*^9}, {
   3.5619281835901456`*^9, 3.5619284202946763`*^9}, {3.561928600509342*^9, 
   3.561928636702038*^9}, {3.561928735484704*^9, 3.5619287495560846`*^9}, {
   3.561929085775668*^9, 3.5619291803602867`*^9}, {3.5619292957441072`*^9, 
   3.5619292973977394`*^9}, 3.561929331702799*^9, {3.5619334724264803`*^9, 
   3.561933490039445*^9}, {3.561933531614777*^9, 3.561933573923333*^9}, {
   3.5619336269962344`*^9, 3.561933628649887*^9}, 3.561933806541948*^9, {
   3.561933868100732*^9, 3.5619340034333344`*^9}, {3.561934047972191*^9, 
   3.5619341527744894`*^9}, {3.5619341971570582`*^9, 3.561934464622487*^9}, {
   3.561934495183279*^9, 3.5619345307125454`*^9}, 3.5619346020990605`*^9, 
   3.5619346884149675`*^9, {3.5619347297866974`*^9, 3.5619347456989017`*^9}, {
   3.561934925304004*^9, 3.561934934258519*^9}, {3.5619350337409945`*^9, 
   3.561935037750246*^9}, {3.561935179977269*^9, 3.5619352459978127`*^9}, 
   3.5619353533448534`*^9, 3.561945538197461*^9, {3.5619458104053507`*^9, 
   3.56194581191857*^9}, {3.5619458465354137`*^9, 3.561945849764655*^9}, {
   3.562012151074438*^9, 3.5620121558631773`*^9}, {3.5620156318164916`*^9, 
   3.5620156535011864`*^9}, {3.562015722439796*^9, 3.562015817197233*^9}, {
   3.5620158702543745`*^9, 3.562015873483657*^9}, {3.5620163044592876`*^9, 
   3.5620163824919887`*^9}, {3.56314196327319*^9, 3.5631419936932435`*^9}},
 FontFamily->"Courier New"],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0.85], RectangleBox[{-1.5, 0}, {-0.5, 2}]}, 
   {GrayLevel[0.85], RectangleBox[{0.5, 0}, {2.5, 2}]}, 
   {GrayLevel[0.85], RectangleBox[{3., 0}, {4., 2}]}, 
   {GrayLevel[0.85], RectangleBox[{4.5, 0.5}]}, InsetBox[
    StyleBox["\<\"=\"\>",
     StripOnInput->False,
     FontSize->Large], {0, 1}], InsetBox[
    StyleBox["\<\"A\"\>",
     StripOnInput->False,
     FontSize->Large], {-1, 1}], InsetBox[
    StyleBox["\<\"U\"\>",
     StripOnInput->False,
     FontSize->Large], {1.5, 1}], InsetBox[
    StyleBox["\<\"\[CapitalSigma]\"\>",
     StripOnInput->False,
     FontSize->Large], {3.5, 1}], InsetBox[
    StyleBox["\<\"\\!\\(\\*SuperscriptBox[\\(V\\), \\(T\\)]\\)\"\>",
     StripOnInput->False,
     FontSize->Large], {5., 1}]},
  BaseStyle->{FontFamily -> "Helvetica"}]], "Output",
 CellChangeTimes->{
  3.561934603378277*^9, 3.5619346945770464`*^9, {3.5619347334527445`*^9, 
   3.561934748460137*^9}, {3.561934926988826*^9, 3.56193493981219*^9}, 
   3.5619350426019077`*^9, 3.561935181693291*^9, {3.561935220194586*^9, 
   3.5619352472458525`*^9}, 3.561945545295552*^9, 3.5619456316270585`*^9, 
   3.5619458144458027`*^9, 3.5619458527598934`*^9, 3.5620121573450356`*^9, 
   3.5620156661999936`*^9, {3.562015766058794*^9, 3.5620158208945513`*^9}, 
   3.562015877009348*^9, 3.5620163868132715`*^9, 3.563141825467347*^9, {
   3.5631419695912013`*^9, 3.563141996251648*^9}, 3.5631420944694204`*^9, 
   3.584715934370525*^9, 3.5847160168506403`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"aa", "=", " ", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"LightGray", ",", 
        RowBox[{"Rectangle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "0.5"}], ",", "1.5"}], "}"}]}], "]"}]}], "}"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vv", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"LightGray", ",", 
        RowBox[{"Rectangle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0.5", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "1.5"}], "}"}]}], "]"}]}], "}"}], "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ss", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"LightGray", ",", 
        RowBox[{"Rectangle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2.5", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4.0", ",", "1.5"}], "}"}]}], "]"}]}], "}"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"uu", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"LightGray", ",", 
        RowBox[{"Rectangle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"4.5", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"6", ",", "1.5"}], "}"}]}], "]"}]}], "}"}], "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"equal", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<=\>\"", ",", "Large"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", ".75"}], "}"}]}], "]"}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"labela", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<A\>\"", ",", "Large"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.25"}], ",", ".75"}], "}"}]}], "]"}], "}"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"labelv", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<U\>\"", ",", "Large"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.25", ",", ".75"}], "}"}]}], "]"}], "}"}], "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"labels", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<\[CapitalSigma]\>\"", ",", "Large"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"3.25", ",", "0.75"}], "}"}]}], "]"}], "}"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"labelu", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SuperscriptBox[\(V\), \(T\)]\)\>\"", ",", "Large"}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"5.25", ",", "0.75"}], "}"}]}], "]"}], "}"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"pic2", " ", "=", " ", 
    RowBox[{"Show", "[", 
     RowBox[{"{", 
      RowBox[{
      "aa", ",", "vv", ",", "ss", ",", "uu", ",", "equal", ",", "labela", ",",
        "labelv", ",", "labels", ",", "labelu"}], "}"}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<DimsMeN.eps\>\"", ",", "pic2"}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.5619281142307673`*^9, 3.561928114542775*^9}, {
   3.5619281835901456`*^9, 3.5619284202946763`*^9}, {3.561928600509342*^9, 
   3.561928636702038*^9}, {3.561928735484704*^9, 3.5619287495560846`*^9}, {
   3.561929085775668*^9, 3.5619291803602867`*^9}, {3.5619292957441072`*^9, 
   3.5619292973977394`*^9}, 3.561929331702799*^9, {3.5619334724264803`*^9, 
   3.561933490039445*^9}, {3.561933531614777*^9, 3.561933573923333*^9}, {
   3.5619336269962344`*^9, 3.561933628649887*^9}, 3.561933806541948*^9, {
   3.561933868100732*^9, 3.5619340034333344`*^9}, {3.561934047972191*^9, 
   3.5619341527744894`*^9}, {3.5619341971570582`*^9, 3.561934464622487*^9}, {
   3.561934495183279*^9, 3.5619345307125454`*^9}, 3.5619346020990605`*^9, 
   3.5619346884149675`*^9, {3.5619347297866974`*^9, 3.5619347456989017`*^9}, {
   3.561934925304004*^9, 3.561934934258519*^9}, {3.5619350337409945`*^9, 
   3.561935037750246*^9}, {3.561935179977269*^9, 3.5619352459978127`*^9}, 
   3.5619353482746906`*^9, {3.5620122038909593`*^9, 3.5620122407346163`*^9}, 
   3.562012409139434*^9, {3.5620124781369066`*^9, 3.562012516684471*^9}, {
   3.5620125483214736`*^9, 3.5620125576503334`*^9}, {3.5620126217511444`*^9, 
   3.5620126680990415`*^9}, {3.562012709735708*^9, 3.562012787751808*^9}, {
   3.5620128388736544`*^9, 3.562012926718381*^9}, {3.562015841456011*^9, 
   3.5620158489598284`*^9}, {3.5631417697752485`*^9, 
   3.5631417842364745`*^9}, {3.563142017982486*^9, 3.5631420597593594`*^9}},
 FontFamily->"Courier New"],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0.85], RectangleBox[{-2, 0}, {-0.5, 1.5}]}, 
   {GrayLevel[0.85], RectangleBox[{0.5, 0}, {2, 1.5}]}, 
   {GrayLevel[0.85], RectangleBox[{2.5, 0}, {4., 1.5}]}, 
   {GrayLevel[0.85], RectangleBox[{4.5, 0}, {6, 1.5}]}, InsetBox[
    StyleBox["\<\"=\"\>",
     StripOnInput->False,
     FontSize->Large], {0, 0.75}], InsetBox[
    StyleBox["\<\"A\"\>",
     StripOnInput->False,
     FontSize->Large], {-1.25, 0.75}], InsetBox[
    StyleBox["\<\"U\"\>",
     StripOnInput->False,
     FontSize->Large], {1.25, 0.75}], InsetBox[
    StyleBox["\<\"\[CapitalSigma]\"\>",
     StripOnInput->False,
     FontSize->Large], {3.25, 0.75}], InsetBox[
    StyleBox["\<\"\\!\\(\\*SuperscriptBox[\\(V\\), \\(T\\)]\\)\"\>",
     StripOnInput->False,
     FontSize->Large], {5.25, 0.75}]},
  BaseStyle->{FontFamily -> "Helvetica"}]], "Output",
 CellChangeTimes->{
  3.5619456317050595`*^9, {3.5620122123921413`*^9, 3.562012243167982*^9}, 
   3.562012410091016*^9, 3.562012486560745*^9, {3.5620125520810976`*^9, 
   3.5620125590543423`*^9}, {3.5620126254951687`*^9, 
   3.5620126697058516`*^9}, {3.56201271315213*^9, 3.5620127888750153`*^9}, {
   3.5620128403244734`*^9, 3.562012927591992*^9}, 3.5620156662935963`*^9, 
   3.5620158209257526`*^9, 3.5620158770405483`*^9, 3.5620163873280816`*^9, 
   3.5631418258573475`*^9, 3.563142094578621*^9, 3.5847159346805253`*^9, 
   3.5847160170306406`*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJztmLty00AUho8j6+ImwwRIJFtJHAJJQaWWChqoGErVngyMXTAwIZWegl7v
QaE32eFhzN6vR4AjZyaFPBlHWe85+3/nsrvxx9Xd+vPX1d3mZrX8cLv6vt7c
/Fi+/3ZLh6IJwGQNAJ+WwJ639FG+benPdsPe2Mh+njP26+2WEPKaPb1jT8d6
zDxl4/Rx+jh9nP5w05+zJ5hCW4N81dAScr2bl2fcSwyEdNBUYF51C4GrE7kk
6RqozJIzX0nVQEdIrhcu+YTIkgr0L/let+xTPqPUsnJpQSyTmbaroOmEReGB
JBSkBW5TVVIjn33Vy2KBV02XBYhMISk0yxxRliDKFlpZgVhk/8eiRNCAtkpk
3QYsuRTdGRCWgNQfFukyLIVKvgUrJ0GkC0PG08TSYpvbmRWrQqJ4uVdhMffY
UiOKFpq9Bg02vOoD9LKSIDmk43yxQ24ewe+fb5AK+gK/xP0ADk0gggqOcf8h
vp5AYVI5xgCpRjS1mV6Jlhwf8VL30o9AYQdahk3jG9ks2HOd3xzRTyWlvp1Y
0+RoobFEXqhIk1VqFGI95X/P/JX4qJ/dXja0QYQ2s5wHplxz8jQoE17LBkxt
RHZpXngQgdeDIMzc62UvhsWrMGSa+zBcvSmuw2CcWiWm+nUZYrheD5BioLIC
jLnjXFTaFA/BYjDJGbJ/nIckbqFGuJoXOEkgKkJaqdx5yxhKrMLLessndj+N
Eb39rG4DHgRy+HC5pxKcOkcUTU1IolSzzo+DxbhX98AQ0LkPuJA7jLdRih3G
rQ8Yjlfi4TRNdhRMcFDCbdraF+hYD17mK/K79XRPZG57XyBYypx7TYLFrPPX
7d4Tn6yUB7514vkFAMOxFrgdQuYWbHBHsk9+FSUhsocsccrPuqad7QkqckIX
62qihdHwu7N1uzpCspsFy/DkaUfSO2vQfkRLYmX6YTii3rfcFtbimLu6j9KO
y8xPpBAwRa4yAaXYzGLLVtvDcMTiH/G37o7mZnnl7y8iLse4dLczKeP5YNW5
Lw/MYRjcZrjFtZMVEb1A79//G1Uu7La7pwvFy8r6vi6sDXtHF5dI9FIZPfvk
erKb20f1BcQ4fZz+eKc/xLf/MPkDE1Q+YA==\
\>"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"aa", "=", " ", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"LightGray", ",", 
        RowBox[{"Rectangle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "0.5"}], ",", "1.5"}], "}"}]}], "]"}]}], "}"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vv", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"LightGray", ",", 
        RowBox[{"Rectangle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0.5", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "1.5"}], "}"}]}], "]"}]}], "}"}], "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ss", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"LightGray", ",", 
        RowBox[{"Rectangle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2.5", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"5", ",", "1.5"}], "}"}]}], "]"}]}], "}"}], "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"uu", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"LightGray", ",", 
        RowBox[{"Rectangle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"5.5", ",", 
            RowBox[{"-", ".5"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"8", ",", "2"}], "}"}]}], "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"equal", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<=\>\"", ",", "Large"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", ".75"}], "}"}]}], "]"}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"labela", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<A\>\"", ",", "Large"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1.75"}], ",", ".75"}], "}"}]}], "]"}], "}"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"labelv", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<U\>\"", ",", "Large"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.25", ",", ".75"}], "}"}]}], "]"}], "}"}], "]"}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"labels", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{"\"\<\[CapitalSigma]\>\"", ",", "Large"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"3.75", ",", "0.75"}], "}"}]}], "]"}], "}"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"labelu", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"Text", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
          "\"\<\!\(\*SuperscriptBox[\(V\), \(T\)]\)\>\"", ",", "Large"}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"6.75", ",", "0.75"}], "}"}]}], "]"}], "}"}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"pic3", " ", "=", " ", 
    RowBox[{"Show", "[", 
     RowBox[{"{", 
      RowBox[{
      "aa", ",", "vv", ",", "ss", ",", "uu", ",", "equal", ",", "labela", ",",
        "labelv", ",", "labels", ",", "labelu"}], "}"}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<DimsMlN.eps\>\"", ",", "pic3"}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.5619281142307673`*^9, 3.561928114542775*^9}, {
   3.5619281835901456`*^9, 3.5619284202946763`*^9}, {3.561928600509342*^9, 
   3.561928636702038*^9}, {3.561928735484704*^9, 3.5619287495560846`*^9}, {
   3.561929085775668*^9, 3.5619291803602867`*^9}, {3.5619292957441072`*^9, 
   3.5619292973977394`*^9}, 3.561929331702799*^9, {3.5619334724264803`*^9, 
   3.561933490039445*^9}, {3.561933531614777*^9, 3.561933573923333*^9}, {
   3.5619336269962344`*^9, 3.561933628649887*^9}, 3.561933806541948*^9, {
   3.561933868100732*^9, 3.5619340034333344`*^9}, {3.561934047972191*^9, 
   3.5619341527744894`*^9}, {3.5619341971570582`*^9, 3.561934464622487*^9}, {
   3.561934495183279*^9, 3.5619345307125454`*^9}, 3.5619346020990605`*^9, 
   3.5619346884149675`*^9, {3.5619347297866974`*^9, 3.5619347456989017`*^9}, {
   3.561934925304004*^9, 3.561934934258519*^9}, {3.5619350337409945`*^9, 
   3.561935037750246*^9}, {3.561935179977269*^9, 3.5619352459978127`*^9}, 
   3.5619353482746906`*^9, {3.5620122038909593`*^9, 3.5620122407346163`*^9}, 
   3.562012409139434*^9, {3.5620124781369066`*^9, 3.562012516684471*^9}, {
   3.5620125483214736`*^9, 3.5620125576503334`*^9}, {3.5620126217511444`*^9, 
   3.5620126680990415`*^9}, {3.562012709735708*^9, 3.562012787751808*^9}, {
   3.5620128388736544`*^9, 3.562012926718381*^9}, {3.5620130239544277`*^9, 
   3.5620130551236267`*^9}, {3.562013098648246*^9, 3.562013195018901*^9}, {
   3.5620132673730927`*^9, 3.5620133177464614`*^9}, {3.5620133688686447`*^9, 
   3.5620134467765427`*^9}, {3.5620158553715925`*^9, 
   3.5620158589908857`*^9}, {3.5631417931908903`*^9, 
   3.5631418104913206`*^9}, {3.563142069212976*^9, 3.5631420886818104`*^9}},
 FontFamily->"Courier New"],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0.85], RectangleBox[{-3, 0}, {-0.5, 1.5}]}, 
   {GrayLevel[0.85], RectangleBox[{0.5, 0}, {2, 1.5}]}, 
   {GrayLevel[0.85], RectangleBox[{2.5, 0}, {5, 1.5}]}, 
   {GrayLevel[0.85], RectangleBox[{5.5, -0.5}, {8, 2}]}, InsetBox[
    StyleBox["\<\"=\"\>",
     StripOnInput->False,
     FontSize->Large], {0, 0.75}], InsetBox[
    StyleBox["\<\"A\"\>",
     StripOnInput->False,
     FontSize->Large], {-1.75, 0.75}], InsetBox[
    StyleBox["\<\"U\"\>",
     StripOnInput->False,
     FontSize->Large], {1.25, 0.75}], InsetBox[
    StyleBox["\<\"\[CapitalSigma]\"\>",
     StripOnInput->False,
     FontSize->Large], {3.75, 0.75}], InsetBox[
    StyleBox["\<\"\\!\\(\\*SuperscriptBox[\\(V\\), \\(T\\)]\\)\"\>",
     StripOnInput->False,
     FontSize->Large], {6.75, 0.75}]},
  BaseStyle->{FontFamily -> "Helvetica"}]], "Output",
 CellChangeTimes->{{3.562013027433272*^9, 3.5620130571828537`*^9}, {
   3.562013102267515*^9, 3.5620131415098724`*^9}, 3.5620131964385285`*^9, {
   3.562013289353915*^9, 3.5620133191036873`*^9}, {3.5620133712710905`*^9, 
   3.562013448586178*^9}, 3.562015666340398*^9, 3.5620158209569535`*^9, 
   3.56201587708735*^9, 3.5620163873592825`*^9, 3.5631418259509478`*^9, 
   3.5631420946722207`*^9, 3.5847159347905254`*^9, 3.584716017130641*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{935, 695},
WindowMargins->{{Automatic, 75}, {Automatic, 6}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 691, 12, 107, "Subtitle"],
Cell[1273, 36, 328, 8, 86, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1626, 48, 6060, 158, 335, "Input"],
Cell[7689, 208, 1499, 31, 128, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9225, 244, 5466, 141, 275, "Input"],
Cell[14694, 387, 2613, 51, 94, 868, 21, "CachedBoxData", "BoxData", "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17344, 443, 5723, 145, 295, "Input"],
Cell[23070, 590, 1309, 27, 108, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
