(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    161644,       2778]
NotebookOptionsPosition[    160158,       2729]
NotebookOutlinePosition[    160502,       2744]
CellTagsIndexPosition[    160459,       2741]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
    StripOnInput->False,
    FontWeight->"Bold",
    FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
   StyleBox[
   "\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis Group, An A \
K Peters Book, 2013",
    StripOnInput->False,
    FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
  }], "Subtitle",
   CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
     3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
     3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
     3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9},
   FontFamily->"Arial"],
  TextCell[
   Row[{
     Style[
     "Practical Linear Algebra: A Geometry Toolbox, Third edition", 
      FontWeight -> "Bold", FontColor -> 
      RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]], 
     Style[
     "\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis Group, An \
A K Peters Book, 2013", FontColor -> 
      RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]}], "Subtitle", 
   CellChangeTimes -> {{3.4991094606434994`*^9, 3.499109474090723*^9}, {
     3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
     3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
     3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9}, 
   FontFamily -> "Arial"]]], "Output",
 CellChangeTimes->{3.584716187208885*^9}],

Cell[CellGroupData[{

Cell[TextData[{
 "\n",
 StyleBox["Singular Value Decomposition (SVD) visualization",
  FontWeight->"Bold"],
 "\nHere, we uase a 2x3, 3x3 or 3x2 matrix ",
 StyleBox["mat",
  FontSlant->"Italic"],
 " to illustrate the geometry behind SVD ",
 StyleBox["mat=uu.ss.vv^T",
  FontSlant->"Italic"],
 ". \nWe map 3D unit vectors by using ",
 StyleBox["mat",
  FontSlant->"Italic"],
 " directly or by successively applying ",
 StyleBox["vvt, ss, uu",
  FontSlant->"Italic"],
 ". This generates both 2D and 3D vectors. \n\nIn order to display them using \
Graphics3D, we need convert some 2D vectors to 3D by adding zero \
z-components.\nOne special point is marked on all plots; these points are \
images of each other under the respective maps."
}], "Subsubtitle",
 CellChangeTimes->{{3.5190613970788293`*^9, 3.519061397749631*^9}, {
   3.519061432022891*^9, 3.5190614624429445`*^9}, {3.519061514905836*^9, 
   3.519061628240035*^9}, {3.519061759373866*^9, 3.5190617744122925`*^9}, {
   3.5190618332711954`*^9, 3.519061929601365*^9}, {3.51906205786479*^9, 
   3.5190620650876026`*^9}, 3.5190621108268833`*^9, {3.5190622884799953`*^9, 
   3.519062320350851*^9}, {3.519062521918805*^9, 3.5190626326165996`*^9}, {
   3.5190628193333273`*^9, 3.519062819380128*^9}, 3.519062858848197*^9, {
   3.5190637725290017`*^9, 3.519063787505028*^9}, 3.519064197458148*^9, {
   3.5190648424412813`*^9, 3.519064859632511*^9}, {3.519065093601722*^9, 
   3.5190651249109774`*^9}, {3.519143584891322*^9, 3.519143618134981*^9}, {
   3.5191436705822725`*^9, 3.519143684029496*^9}, {3.5191564974679966`*^9, 
   3.5191565115080214`*^9}, 3.5191687775763645`*^9, {3.5193183416584096`*^9, 
   3.51931846709823*^9}, 3.519318600363664*^9, {3.519318688550619*^9, 
   3.5193187098134565`*^9}, {3.519318801682018*^9, 3.5193188481232996`*^9}, {
   3.519318923799032*^9, 3.5193189293682423`*^9}, {3.5193190014403687`*^9, 
   3.519319022781206*^9}, {3.519319175864275*^9, 3.5193191785006795`*^9}, {
   3.519319310882512*^9, 3.5193193555765905`*^9}, {3.519319442172343*^9, 
   3.519319565287759*^9}, {3.5193198098493886`*^9, 3.519319841985445*^9}, 
   3.5193199527144394`*^9, 3.519320062320232*^9, 3.5193201753736305`*^9, 
   3.5193203564431486`*^9, {3.5193290189839635`*^9, 3.5193290317447863`*^9}, {
   3.519331648326182*^9, 3.519331738915541*^9}, {3.5193317714883986`*^9, 
   3.519331836524913*^9}, {3.519331911748245*^9, 3.5193319703887477`*^9}, {
   3.519332003850806*^9, 3.5193320128052225`*^9}, {3.5193320585133023`*^9, 
   3.519332077030535*^9}, {3.519332153501869*^9, 3.5193321795851154`*^9}, {
   3.519332252250043*^9, 3.5193322645272646`*^9}, {3.5193322952749186`*^9, 
   3.5193323228869667`*^9}, {3.5193324053487115`*^9, 
   3.5193324341619625`*^9}, {3.5193324710560274`*^9, 
   3.5193324897448597`*^9}, {3.5193325345949388`*^9, 3.519332573875808*^9}, {
   3.5193326105514717`*^9, 3.519332617306284*^9}, {3.5193326927480164`*^9, 
   3.519332779094168*^9}, {3.5193329731585093`*^9, 3.51933318466368*^9}, {
   3.5193333259219284`*^9, 3.5193333573559837`*^9}, 3.5193334441701365`*^9, 
   3.519333573806364*^9, {3.5193336196236444`*^9, 3.519333700915387*^9}, {
   3.5193338052015705`*^9, 3.519333805575971*^9}, {3.519336424716172*^9, 
   3.519336584819253*^9}, {3.51933662859293*^9, 3.5193366396221495`*^9}, {
   3.5193374015586877`*^9, 3.5193374062854958`*^9}, {3.5193377748885436`*^9, 
   3.51933777852335*^9}, {3.5193378293794394`*^9, 3.51933788112473*^9}, {
   3.5193379688748846`*^9, 3.5193379927897263`*^9}, {3.519393659487196*^9, 
   3.5193937240620933`*^9}, 3.5193995276423693`*^9, {3.519399560262027*^9, 
   3.5193995687172413`*^9}, 3.519399607062109*^9, {3.519743189247101*^9, 
   3.519743197296715*^9}, {3.519822556574108*^9, 3.5198225643117213`*^9}, {
   3.519822615635812*^9, 3.5198226456502647`*^9}, {3.519822681327527*^9, 
   3.5198226840575314`*^9}, {3.5198227249296036`*^9, 3.519822727909209*^9}, {
   3.5198230136237106`*^9, 3.5198230640585995`*^9}, {3.5199394713775268`*^9, 
   3.519939474435132*^9}, {3.5209457136282034`*^9, 3.5209457316306353`*^9}, {
   3.521233019052727*^9, 3.5212330195363283`*^9}, {3.521824157577416*^9, 
   3.5218241913514752`*^9}, {3.5218242354839525`*^9, 
   3.5218242371531553`*^9}, {3.521824777014904*^9, 3.521824780977311*^9}, {
   3.521824881659888*^9, 3.5218248945143104`*^9}, {3.522546096219933*^9, 
   3.522546118446204*^9}, {3.522546164829857*^9, 3.5225461846399903`*^9}, {
   3.5480827780275407`*^9, 3.548083073180059*^9}, {3.5480844465048714`*^9, 
   3.548084447799674*^9}, 3.548084490465749*^9, {3.548084523725007*^9, 
   3.5480845255190105`*^9}, {3.5480846736100707`*^9, 
   3.5480847132965403`*^9}, {3.5480850595079484`*^9, 3.548085176601754*^9}, {
   3.5480852081762094`*^9, 3.548085220968232*^9}, 3.5480852876959496`*^9, {
   3.5480853452912507`*^9, 3.548085345416051*^9}, {3.5480854601230526`*^9, 
   3.548085504957531*^9}, {3.54808669421002*^9, 3.5480867052080393`*^9}, 
   3.5480869024859858`*^9, {3.5480873606119905`*^9, 3.5480873616259923`*^9}, {
   3.5481089290239763`*^9, 3.5481089295387774`*^9}, {3.5481090731058297`*^9, 
   3.5481091125270987`*^9}, {3.54810921548728*^9, 3.5481092677161713`*^9}, {
   3.5481093308494825`*^9, 3.54810947777054*^9}, {3.5481095113105993`*^9, 
   3.5481095348666406`*^9}, {3.548255560709408*^9, 3.548255637461543*^9}, {
   3.548255675385209*^9, 3.54825568700723*^9}, {3.548255737161318*^9, 
   3.5482557378165193`*^9}, {3.548255813897853*^9, 3.548255849465915*^9}, {
   3.548265318518547*^9, 3.54826532014095*^9}, {3.5482654408071623`*^9, 
   3.5482654469691725`*^9}, {3.5482655240957084`*^9, 3.548265530054919*^9}, {
   3.548265648131526*^9, 3.548265660642748*^9}, {3.548265763743329*^9, 
   3.5482658059570036`*^9}, 3.5482660708142686`*^9, {3.548266109892337*^9, 
   3.5482661181291513`*^9}, {3.548266190653679*^9, 3.548266220886532*^9}, {
   3.5482665984383955`*^9, 3.548266647469281*^9}, {3.548266688247753*^9, 
   3.5482666925221605`*^9}, {3.548266762925084*^9, 3.5482667724099007`*^9}, {
   3.5482668726868773`*^9, 3.5482668940277147`*^9}, {3.5482669350245867`*^9, 
   3.54826695400982*^9}, {3.5482670699492235`*^9, 3.5482670787320385`*^9}, {
   3.548267132645734*^9, 3.5482671855142264`*^9}, {3.548267237665118*^9, 
   3.5482672647935658`*^9}, {3.548278236511236*^9, 3.5482782735925016`*^9}, {
   3.548278327256596*^9, 3.548278376802283*^9}, {3.5482785724890265`*^9, 
   3.548278578339037*^9}, {3.5482792414338017`*^9, 3.548279284864278*^9}, {
   3.5482793450959835`*^9, 3.548279353972399*^9}, {3.5482795652435703`*^9, 
   3.548279619921666*^9}, {3.548279773441536*^9, 3.5482797903051653`*^9}, {
   3.5482799098637753`*^9, 3.5482799507982473`*^9}, {3.5482800398588037`*^9, 
   3.548280046457616*^9}, {3.5482800767216682`*^9, 3.5482801276869583`*^9}, {
   3.5482803327805185`*^9, 3.548280371484186*^9}, {3.548280417441867*^9, 
   3.5482804279406853`*^9}, {3.548280494927203*^9, 3.54828054439489*^9}, {
   3.54828076624288*^9, 3.5482807778649*^9}, {3.54828122190408*^9, 
   3.5482813009182186`*^9}, 3.54828184769798*^9, {3.54828201277747*^9, 
   3.548282015523075*^9}, {3.5482820824627924`*^9, 3.5482820899040055`*^9}, 
   3.5482825476876197`*^9, {3.548282600821313*^9, 3.548282669102633*^9}, {
   3.5482827161211157`*^9, 3.548282763732399*^9}, {3.5482831379926567`*^9, 
   3.5482831926395526`*^9}, 3.548283229252817*^9, {3.5482832677224846`*^9, 
   3.5482832685804863`*^9}, {3.548337660164831*^9, 3.548337707885315*^9}, {
   3.5483378432467527`*^9, 3.5483378914976377`*^9}, {3.5483379306537066`*^9, 
   3.5483380219918666`*^9}, {3.5483383681252747`*^9, 
   3.5483384772006664`*^9}, {3.548338688097437*^9, 3.548338694181447*^9}, {
   3.5483387278775063`*^9, 3.54833873013951*^9}, 3.5483387632739687`*^9, {
   3.5483388024612374`*^9, 3.5483388390277014`*^9}, {3.548338931021063*^9, 
   3.5483389755279417`*^9}, {3.5483391622914696`*^9, 3.548339174412691*^9}, 
   3.548339235034397*^9, 3.5483395307173166`*^9, {3.5483403647727814`*^9, 
   3.5483403955048356`*^9}, {3.548364491181573*^9, 3.5483645678869076`*^9}, {
   3.548364623485405*^9, 3.5483646334070225`*^9}, {3.548364838016982*^9, 
   3.548364941538764*^9}, {3.548365010038484*^9, 3.54836506468538*^9}, {
   3.548365883702419*^9, 3.548365945525327*^9}, {3.5483659788781857`*^9, 
   3.5483659942130127`*^9}, {3.548366118607631*^9, 3.5483661200584335`*^9}, {
   3.548366160805705*^9, 3.548366169697721*^9}, {3.548366210023792*^9, 
   3.5483662558254724`*^9}, {3.548366303873557*^9, 3.5483663061043606`*^9}, {
   3.5483663402684207`*^9, 3.548366353544044*^9}, {3.5483663939637146`*^9, 
   3.548366438626593*^9}, {3.548426002981133*^9, 3.5484260441496053`*^9}, {
   3.548426218152311*^9, 3.548426330815709*^9}, {3.548426366836172*^9, 
   3.548426368957776*^9}, {3.5484265945809717`*^9, 3.548426731159212*^9}, 
   3.5484267672888756`*^9, {3.548426847566616*^9, 3.548426850062621*^9}, 
   3.548426916175537*^9, {3.548426966095625*^9, 3.5484269677492275`*^9}, {
   3.5484292280311985`*^9, 3.548429290446908*^9}, {3.548429320820162*^9, 
   3.5484295570201764`*^9}, {3.548429587112629*^9, 3.5484298194750376`*^9}, {
   3.5484344974260545`*^9, 3.548434522713699*^9}, {3.548434880188327*^9, 
   3.54843488232553*^9}, {3.5484349317776175`*^9, 3.548434953321255*^9}, {
   3.5484351235175543`*^9, 3.548435150833202*^9}, {3.5484351972588835`*^9, 
   3.54843521789772*^9}, 3.5484352564297876`*^9, {3.5484353248671074`*^9, 
   3.5484353811832066`*^9}, {3.5484354363605037`*^9, 
   3.5484354375461054`*^9}, {3.5484354942834053`*^9, 3.54843559367118*^9}, {
   3.548435695242958*^9, 3.5484358725996695`*^9}, {3.548435910258136*^9, 
   3.5484359121301394`*^9}, {3.548436201432647*^9, 3.5484362033982506`*^9}, {
   3.548436286452797*^9, 3.5484364403002667`*^9}, 3.548436500843973*^9, 
   3.54843653889244*^9, {3.548436585848522*^9, 3.548436642539022*^9}, {
   3.548436704954732*^9, 3.54843677804086*^9}, 3.5484369444931526`*^9, {
   3.5484370203872857`*^9, 3.54843702255569*^9}, {3.5484370660797663`*^9, 
   3.5484370777641864`*^9}, {3.548437110274644*^9, 3.5484372383352685`*^9}, {
   3.5484373881735315`*^9, 3.5484375229577684`*^9}, {3.5484376009267054`*^9, 
   3.548437604795512*^9}, {3.5484376442011814`*^9, 3.5484376638104157`*^9}, 
   3.5484376978184757`*^9, {3.548437819607889*^9, 3.548437887670809*^9}, 
   3.5484381060087924`*^9, {3.548438191746543*^9, 3.5484382289994087`*^9}, {
   3.5484383503832216`*^9, 3.5484385271315317`*^9}, 3.548438559517189*^9, {
   3.5484386721025867`*^9, 3.548438711539456*^9}, {3.548438834077671*^9, 
   3.5484388426888866`*^9}, 3.54843887293734*^9, {3.5484389443074646`*^9, 
   3.5484389527626796`*^9}, 3.54843906107367*^9, 3.5484390990909367`*^9, {
   3.5484391301817913`*^9, 3.5484391618810472`*^9}, {3.548439235965577*^9, 
   3.548439238243181*^9}, {3.548522484301733*^9, 3.5485226761820703`*^9}, 
   3.5485227731206408`*^9, {3.5487713741413865`*^9, 3.548771426481479*^9}, {
   3.584716113270776*^9, 3.584716113610776*^9}, {3.584716164478853*^9, 
   3.584716167318857*^9}},
 FontFamily->"Arial",
 FontColor->GrayLevel[0]],

Cell["\<\

\
\>", "Text",
 CellChangeTimes->{{3.5190613970788293`*^9, 3.519061397749631*^9}, {
   3.519061432022891*^9, 3.5190614624429445`*^9}, {3.519061514905836*^9, 
   3.519061628240035*^9}, {3.519061759373866*^9, 3.5190617744122925`*^9}, {
   3.5190618332711954`*^9, 3.519061929601365*^9}, {3.51906205786479*^9, 
   3.5190620650876026`*^9}, 3.5190621108268833`*^9, {3.5190622884799953`*^9, 
   3.519062320350851*^9}, {3.519062521918805*^9, 3.5190626326165996`*^9}, {
   3.5190628193333273`*^9, 3.519062819380128*^9}, 3.519062858848197*^9, {
   3.5190637725290017`*^9, 3.519063787505028*^9}, 3.519064197458148*^9, {
   3.5190648424412813`*^9, 3.519064859632511*^9}, {3.519065093601722*^9, 
   3.5190651249109774`*^9}, {3.519143584891322*^9, 3.519143618134981*^9}, {
   3.5191436705822725`*^9, 3.519143684029496*^9}, {3.5191564974679966`*^9, 
   3.5191565115080214`*^9}, 3.5191687775763645`*^9, {3.5193183416584096`*^9, 
   3.51931846709823*^9}, 3.519318600363664*^9, {3.519318688550619*^9, 
   3.5193187098134565`*^9}, {3.519318801682018*^9, 3.5193188481232996`*^9}, {
   3.519318923799032*^9, 3.5193189293682423`*^9}, {3.5193190014403687`*^9, 
   3.519319022781206*^9}, {3.519319175864275*^9, 3.5193191785006795`*^9}, {
   3.519319310882512*^9, 3.5193193555765905`*^9}, {3.519319442172343*^9, 
   3.519319565287759*^9}, {3.5193198098493886`*^9, 3.519319841985445*^9}, 
   3.5193199527144394`*^9, 3.519320062320232*^9, 3.5193201753736305`*^9, 
   3.5193203564431486`*^9, {3.5193290189839635`*^9, 3.5193290317447863`*^9}, {
   3.519331648326182*^9, 3.519331738915541*^9}, {3.5193317714883986`*^9, 
   3.519331836524913*^9}, {3.519331911748245*^9, 3.5193319703887477`*^9}, {
   3.519332003850806*^9, 3.5193320128052225`*^9}, {3.5193320585133023`*^9, 
   3.519332077030535*^9}, {3.519332153501869*^9, 3.5193321795851154`*^9}, {
   3.519332252250043*^9, 3.5193322645272646`*^9}, {3.5193322952749186`*^9, 
   3.5193323228869667`*^9}, {3.5193324053487115`*^9, 
   3.5193324341619625`*^9}, {3.5193324710560274`*^9, 
   3.5193324897448597`*^9}, {3.5193325345949388`*^9, 3.519332573875808*^9}, {
   3.5193326105514717`*^9, 3.519332617306284*^9}, {3.5193326927480164`*^9, 
   3.519332779094168*^9}, {3.5193329731585093`*^9, 3.51933318466368*^9}, {
   3.5193333259219284`*^9, 3.5193333573559837`*^9}, 3.5193334441701365`*^9, 
   3.519333573806364*^9, {3.5193336196236444`*^9, 3.519333700915387*^9}, {
   3.5193338052015705`*^9, 3.519333805575971*^9}, {3.519336424716172*^9, 
   3.519336584819253*^9}, {3.51933662859293*^9, 3.5193366396221495`*^9}, {
   3.5193374015586877`*^9, 3.5193374062854958`*^9}, {3.5193377748885436`*^9, 
   3.51933777852335*^9}, {3.5193378293794394`*^9, 3.51933788112473*^9}, {
   3.5193379688748846`*^9, 3.5193379927897263`*^9}, {3.519393659487196*^9, 
   3.5193937240620933`*^9}, 3.5193995276423693`*^9, {3.519399560262027*^9, 
   3.5193995687172413`*^9}, 3.519399607062109*^9, {3.519743189247101*^9, 
   3.519743197296715*^9}, {3.519822556574108*^9, 3.5198225643117213`*^9}, {
   3.519822615635812*^9, 3.5198226456502647`*^9}, {3.519822681327527*^9, 
   3.5198226840575314`*^9}, {3.5198227249296036`*^9, 3.519822727909209*^9}, {
   3.5198230136237106`*^9, 3.5198230640585995`*^9}, {3.5199394713775268`*^9, 
   3.519939474435132*^9}, {3.5209457136282034`*^9, 3.5209457316306353`*^9}, {
   3.521233019052727*^9, 3.5212330195363283`*^9}, {3.521824157577416*^9, 
   3.5218241913514752`*^9}, {3.5218242354839525`*^9, 
   3.5218242371531553`*^9}, {3.521824777014904*^9, 3.521824780977311*^9}, {
   3.521824881659888*^9, 3.5218248945143104`*^9}, {3.522546096219933*^9, 
   3.522546118446204*^9}, {3.522546164829857*^9, 3.5225461846399903`*^9}, {
   3.5480827780275407`*^9, 3.548083073180059*^9}, {3.5480844465048714`*^9, 
   3.548084447799674*^9}, 3.548084490465749*^9, {3.548084523725007*^9, 
   3.5480845255190105`*^9}, {3.5480846736100707`*^9, 
   3.5480847132965403`*^9}, {3.5480850595079484`*^9, 3.548085176601754*^9}, {
   3.5480852081762094`*^9, 3.548085220968232*^9}, 3.5480852876959496`*^9, {
   3.5480853452912507`*^9, 3.548085345416051*^9}, {3.5480854601230526`*^9, 
   3.548085504957531*^9}, {3.54808669421002*^9, 3.5480867052080393`*^9}, 
   3.5480869024859858`*^9, {3.5480873606119905`*^9, 3.5480873616259923`*^9}, {
   3.5481089290239763`*^9, 3.5481089295387774`*^9}, {3.5481090731058297`*^9, 
   3.5481091125270987`*^9}, {3.54810921548728*^9, 3.5481092677161713`*^9}, {
   3.5481093308494825`*^9, 3.54810947777054*^9}, {3.5481095113105993`*^9, 
   3.5481095348666406`*^9}, {3.548255560709408*^9, 3.548255637461543*^9}, {
   3.548255675385209*^9, 3.54825568700723*^9}, {3.548255737161318*^9, 
   3.5482557378165193`*^9}, {3.548255813897853*^9, 3.548255849465915*^9}, {
   3.548265318518547*^9, 3.54826532014095*^9}, {3.5482654408071623`*^9, 
   3.5482654469691725`*^9}, {3.5482655240957084`*^9, 3.548265530054919*^9}, {
   3.548265648131526*^9, 3.548265660642748*^9}, {3.548265763743329*^9, 
   3.5482658059570036`*^9}, 3.5482660708142686`*^9, {3.548266109892337*^9, 
   3.5482661181291513`*^9}, {3.548266190653679*^9, 3.548266220886532*^9}, {
   3.5482665984383955`*^9, 3.548266647469281*^9}, {3.548266688247753*^9, 
   3.5482666925221605`*^9}, {3.548266762925084*^9, 3.5482667724099007`*^9}, {
   3.5482668726868773`*^9, 3.5482668940277147`*^9}, {3.5482669350245867`*^9, 
   3.54826695400982*^9}, {3.5482670699492235`*^9, 3.5482670787320385`*^9}, {
   3.548267132645734*^9, 3.5482671855142264`*^9}, {3.548267237665118*^9, 
   3.5482672647935658`*^9}, {3.548278236511236*^9, 3.5482782735925016`*^9}, {
   3.548278327256596*^9, 3.548278376802283*^9}, {3.5482785724890265`*^9, 
   3.548278578339037*^9}, {3.5482792414338017`*^9, 3.548279284864278*^9}, {
   3.5482793450959835`*^9, 3.548279353972399*^9}, {3.5482795652435703`*^9, 
   3.548279619921666*^9}, {3.548279773441536*^9, 3.5482797903051653`*^9}, {
   3.5482799098637753`*^9, 3.5482799507982473`*^9}, {3.5482800398588037`*^9, 
   3.548280046457616*^9}, {3.5482800767216682`*^9, 3.5482801276869583`*^9}, {
   3.5482803327805185`*^9, 3.548280371484186*^9}, {3.548280417441867*^9, 
   3.5482804279406853`*^9}, {3.548280494927203*^9, 3.54828054439489*^9}, {
   3.54828076624288*^9, 3.5482807778649*^9}, {3.54828122190408*^9, 
   3.5482813009182186`*^9}, 3.54828184769798*^9, {3.54828201277747*^9, 
   3.548282015523075*^9}, {3.5482820824627924`*^9, 3.5482820899040055`*^9}, 
   3.5482825476876197`*^9, {3.548282600821313*^9, 3.548282669102633*^9}, {
   3.5482827161211157`*^9, 3.548282763732399*^9}, {3.5482831379926567`*^9, 
   3.5482831926395526`*^9}, 3.548283229252817*^9, {3.5482832677224846`*^9, 
   3.5482832685804863`*^9}, {3.548337660164831*^9, 3.548337707885315*^9}, {
   3.5483378432467527`*^9, 3.5483378914976377`*^9}, {3.5483379306537066`*^9, 
   3.5483380219918666`*^9}, {3.5483383681252747`*^9, 
   3.5483384772006664`*^9}, {3.548338688097437*^9, 3.548338694181447*^9}, {
   3.5483387278775063`*^9, 3.54833873013951*^9}, 3.5483387632739687`*^9, {
   3.5483388024612374`*^9, 3.5483388390277014`*^9}, {3.548338931021063*^9, 
   3.5483389755279417`*^9}, {3.5483391622914696`*^9, 3.548339174412691*^9}, 
   3.548339235034397*^9, 3.5483395307173166`*^9, {3.5483403647727814`*^9, 
   3.5483403955048356`*^9}, {3.548364491181573*^9, 3.5483645678869076`*^9}, {
   3.548364623485405*^9, 3.5483646334070225`*^9}, {3.548364838016982*^9, 
   3.548364941538764*^9}, {3.548365010038484*^9, 3.54836506468538*^9}, {
   3.548365883702419*^9, 3.548365945525327*^9}, {3.5483659788781857`*^9, 
   3.5483659942130127`*^9}, {3.548366118607631*^9, 3.5483661200584335`*^9}, {
   3.548366160805705*^9, 3.548366169697721*^9}, {3.548366210023792*^9, 
   3.5483662558254724`*^9}, {3.548366303873557*^9, 3.5483663061043606`*^9}, {
   3.5483663402684207`*^9, 3.548366353544044*^9}, {3.5483663939637146`*^9, 
   3.548366438626593*^9}, {3.548426002981133*^9, 3.5484260441496053`*^9}, {
   3.548426218152311*^9, 3.548426330815709*^9}, {3.548426366836172*^9, 
   3.548426368957776*^9}, {3.5484265945809717`*^9, 3.548426731159212*^9}, 
   3.5484267672888756`*^9, {3.548426847566616*^9, 3.548426850062621*^9}, 
   3.548426916175537*^9, {3.548426966095625*^9, 3.5484269677492275`*^9}, {
   3.5484292280311985`*^9, 3.548429290446908*^9}, {3.548429320820162*^9, 
   3.5484295570201764`*^9}, {3.548429587112629*^9, 3.5484298194750376`*^9}, {
   3.5484344974260545`*^9, 3.548434522713699*^9}, {3.548434880188327*^9, 
   3.54843488232553*^9}, {3.5484349317776175`*^9, 3.548434953321255*^9}, {
   3.5484351235175543`*^9, 3.548435150833202*^9}, {3.5484351972588835`*^9, 
   3.54843521789772*^9}, 3.5484352564297876`*^9, {3.5484353248671074`*^9, 
   3.5484353811832066`*^9}, {3.5484354363605037`*^9, 
   3.5484354375461054`*^9}, {3.5484354942834053`*^9, 3.54843559367118*^9}, {
   3.548435695242958*^9, 3.5484358725996695`*^9}, {3.548435910258136*^9, 
   3.5484359121301394`*^9}, {3.548436201432647*^9, 3.5484362033982506`*^9}, {
   3.548436286452797*^9, 3.5484364403002667`*^9}, 3.548436500843973*^9, 
   3.54843653889244*^9, {3.548436585848522*^9, 3.548436642539022*^9}, {
   3.548436704954732*^9, 3.54843677804086*^9}, 3.5484369444931526`*^9, {
   3.5484370203872857`*^9, 3.54843702255569*^9}, {3.5484370660797663`*^9, 
   3.5484370777641864`*^9}, {3.548437110274644*^9, 3.5484372383352685`*^9}, {
   3.5484373881735315`*^9, 3.5484375229577684`*^9}, {3.5484376009267054`*^9, 
   3.548437604795512*^9}, {3.5484376442011814`*^9, 3.5484376638104157`*^9}, 
   3.5484376978184757`*^9, {3.548437819607889*^9, 3.548437887670809*^9}, 
   3.5484381060087924`*^9, {3.548438191746543*^9, 3.5484382289994087`*^9}, {
   3.5484383503832216`*^9, 3.5484385271315317`*^9}, 3.548438559517189*^9, {
   3.5484386721025867`*^9, 3.548438711539456*^9}, {3.548438834077671*^9, 
   3.5484388426888866`*^9}, 3.54843887293734*^9, {3.5484389443074646`*^9, 
   3.5484389527626796`*^9}, 3.54843906107367*^9, 3.5484390990909367`*^9, {
   3.5484391301817913`*^9, 3.5484391618810472`*^9}, {3.548439235965577*^9, 
   3.548439238243181*^9}, {3.548522484301733*^9, 3.5485226761820703`*^9}, 
   3.5485227731206408`*^9, {3.5487713741413865`*^9, 3.5487714149842587`*^9}, {
   3.54877151806924*^9, 3.5487719190855446`*^9}, {3.5487720430745625`*^9, 
   3.54877209286985*^9}, {3.5494898424601593`*^9, 3.549489845611365*^9}, {
   3.549655692492215*^9, 3.5496557584023304`*^9}, {3.5620991400458937`*^9, 
   3.5620991634615355`*^9}, {3.562161244142488*^9, 3.5621612632525215`*^9}, 
   3.5847161109707723`*^9},
 FontFamily->"Arial",
 FontColor->GrayLevel[0]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"to", " ", "enable", " ", "file", " ", 
    RowBox[{"export", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"SetDirectory", "[", 
      RowBox[{"ToFileName", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"\"\<FileName\>\"", "/.", 
          RowBox[{"NotebookInformation", "[", 
           RowBox[{"EvaluationNotebook", "[", "]"}], "]"}]}], ",", 
         RowBox[{"{", "1", "}"}], ",", "FrontEnd`FileName"}], "]"}], "]"}], 
      "]"}], ";"}], ")"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5190613970788293`*^9, 3.519061397749631*^9}, {
   3.519061432022891*^9, 3.5190614624429445`*^9}, {3.519061514905836*^9, 
   3.519061628240035*^9}, {3.519061759373866*^9, 3.5190617744122925`*^9}, {
   3.5190618332711954`*^9, 3.519061929601365*^9}, {3.51906205786479*^9, 
   3.5190620650876026`*^9}, 3.5190621108268833`*^9, {3.5190622884799953`*^9, 
   3.519062320350851*^9}, {3.519062521918805*^9, 3.5190626326165996`*^9}, {
   3.5190628193333273`*^9, 3.519062819380128*^9}, 3.519062858848197*^9, {
   3.5190637725290017`*^9, 3.519063787505028*^9}, 3.519064197458148*^9, {
   3.5190648424412813`*^9, 3.519064859632511*^9}, {3.519065093601722*^9, 
   3.5190651249109774`*^9}, {3.519143584891322*^9, 3.519143618134981*^9}, {
   3.5191436705822725`*^9, 3.519143684029496*^9}, {3.5191564974679966`*^9, 
   3.5191565115080214`*^9}, 3.5191687775763645`*^9, {3.5193183416584096`*^9, 
   3.51931846709823*^9}, 3.519318600363664*^9, {3.519318688550619*^9, 
   3.5193187098134565`*^9}, {3.519318801682018*^9, 3.5193188481232996`*^9}, {
   3.519318923799032*^9, 3.5193189293682423`*^9}, {3.5193190014403687`*^9, 
   3.519319022781206*^9}, {3.519319175864275*^9, 3.5193191785006795`*^9}, {
   3.519319310882512*^9, 3.5193193555765905`*^9}, {3.519319442172343*^9, 
   3.519319565287759*^9}, {3.5193198098493886`*^9, 3.519319841985445*^9}, 
   3.5193199527144394`*^9, 3.519320062320232*^9, 3.5193201753736305`*^9, 
   3.5193203564431486`*^9, {3.5193290189839635`*^9, 3.5193290317447863`*^9}, {
   3.519331648326182*^9, 3.519331738915541*^9}, {3.5193317714883986`*^9, 
   3.519331836524913*^9}, {3.519331911748245*^9, 3.5193319703887477`*^9}, {
   3.519332003850806*^9, 3.5193320128052225`*^9}, {3.5193320585133023`*^9, 
   3.519332077030535*^9}, {3.519332153501869*^9, 3.5193321795851154`*^9}, {
   3.519332252250043*^9, 3.5193322645272646`*^9}, {3.5193322952749186`*^9, 
   3.5193323228869667`*^9}, {3.5193324053487115`*^9, 
   3.5193324341619625`*^9}, {3.5193324710560274`*^9, 
   3.5193324897448597`*^9}, {3.5193325345949388`*^9, 3.519332573875808*^9}, {
   3.5193326105514717`*^9, 3.519332617306284*^9}, {3.5193326927480164`*^9, 
   3.519332779094168*^9}, {3.5193329731585093`*^9, 3.51933318466368*^9}, {
   3.5193333259219284`*^9, 3.5193333573559837`*^9}, 3.5193334441701365`*^9, 
   3.519333573806364*^9, {3.5193336196236444`*^9, 3.519333700915387*^9}, {
   3.5193338052015705`*^9, 3.519333805575971*^9}, {3.519336424716172*^9, 
   3.519336584819253*^9}, {3.51933662859293*^9, 3.5193366396221495`*^9}, {
   3.5193374015586877`*^9, 3.5193374062854958`*^9}, {3.5193377748885436`*^9, 
   3.51933777852335*^9}, {3.5193378293794394`*^9, 3.51933788112473*^9}, {
   3.5193379688748846`*^9, 3.5193379927897263`*^9}, {3.519393659487196*^9, 
   3.5193937240620933`*^9}, 3.5193995276423693`*^9, {3.519399560262027*^9, 
   3.5193995687172413`*^9}, 3.519399607062109*^9, {3.519743189247101*^9, 
   3.519743197296715*^9}, {3.519822556574108*^9, 3.5198225643117213`*^9}, {
   3.519822615635812*^9, 3.5198226456502647`*^9}, {3.519822681327527*^9, 
   3.5198226840575314`*^9}, {3.5198227249296036`*^9, 3.519822727909209*^9}, {
   3.5198230136237106`*^9, 3.5198230640585995`*^9}, {3.5199394713775268`*^9, 
   3.519939474435132*^9}, {3.5209457136282034`*^9, 3.5209457316306353`*^9}, {
   3.521233019052727*^9, 3.5212330195363283`*^9}, {3.521824157577416*^9, 
   3.5218241913514752`*^9}, {3.5218242354839525`*^9, 
   3.5218242371531553`*^9}, {3.521824777014904*^9, 3.521824780977311*^9}, {
   3.521824881659888*^9, 3.5218248945143104`*^9}, {3.522546096219933*^9, 
   3.522546118446204*^9}, {3.522546164829857*^9, 3.5225461846399903`*^9}, {
   3.5480827780275407`*^9, 3.548083073180059*^9}, {3.5480844465048714`*^9, 
   3.548084447799674*^9}, 3.548084490465749*^9, {3.548084523725007*^9, 
   3.5480845255190105`*^9}, {3.5480846736100707`*^9, 
   3.5480847132965403`*^9}, {3.5480850595079484`*^9, 3.548085176601754*^9}, {
   3.5480852081762094`*^9, 3.548085220968232*^9}, 3.5480852876959496`*^9, {
   3.5480853452912507`*^9, 3.548085345416051*^9}, {3.5480854601230526`*^9, 
   3.548085504957531*^9}, {3.54808669421002*^9, 3.5480867052080393`*^9}, 
   3.5480869024859858`*^9, {3.5480873606119905`*^9, 3.5480873616259923`*^9}, {
   3.5481089290239763`*^9, 3.5481089295387774`*^9}, {3.5481090731058297`*^9, 
   3.5481091125270987`*^9}, {3.54810921548728*^9, 3.5481092677161713`*^9}, {
   3.5481093308494825`*^9, 3.54810947777054*^9}, {3.5481095113105993`*^9, 
   3.5481095348666406`*^9}, {3.548255560709408*^9, 3.548255637461543*^9}, {
   3.548255675385209*^9, 3.54825568700723*^9}, {3.548255737161318*^9, 
   3.5482557378165193`*^9}, {3.548255813897853*^9, 3.548255849465915*^9}, {
   3.548265318518547*^9, 3.54826532014095*^9}, {3.5482654408071623`*^9, 
   3.5482654469691725`*^9}, {3.5482655240957084`*^9, 3.548265530054919*^9}, {
   3.548265648131526*^9, 3.548265660642748*^9}, {3.548265763743329*^9, 
   3.5482658059570036`*^9}, 3.5482660708142686`*^9, {3.548266109892337*^9, 
   3.5482661181291513`*^9}, {3.548266190653679*^9, 3.548266220886532*^9}, {
   3.5482665984383955`*^9, 3.548266647469281*^9}, {3.548266688247753*^9, 
   3.5482666925221605`*^9}, {3.548266762925084*^9, 3.5482667724099007`*^9}, {
   3.5482668726868773`*^9, 3.5482668940277147`*^9}, {3.5482669350245867`*^9, 
   3.54826695400982*^9}, {3.5482670699492235`*^9, 3.5482670787320385`*^9}, {
   3.548267132645734*^9, 3.5482671855142264`*^9}, {3.548267237665118*^9, 
   3.5482672647935658`*^9}, {3.548278236511236*^9, 3.5482782735925016`*^9}, {
   3.548278327256596*^9, 3.548278376802283*^9}, {3.5482785724890265`*^9, 
   3.548278578339037*^9}, {3.5482792414338017`*^9, 3.548279284864278*^9}, {
   3.5482793450959835`*^9, 3.548279353972399*^9}, {3.5482795652435703`*^9, 
   3.548279619921666*^9}, {3.548279773441536*^9, 3.5482797903051653`*^9}, {
   3.5482799098637753`*^9, 3.5482799507982473`*^9}, {3.5482800398588037`*^9, 
   3.548280046457616*^9}, {3.5482800767216682`*^9, 3.5482801276869583`*^9}, {
   3.5482803327805185`*^9, 3.548280371484186*^9}, {3.548280417441867*^9, 
   3.5482804279406853`*^9}, {3.548280494927203*^9, 3.54828054439489*^9}, {
   3.54828076624288*^9, 3.5482807778649*^9}, {3.54828122190408*^9, 
   3.5482813009182186`*^9}, 3.54828184769798*^9, {3.54828201277747*^9, 
   3.548282015523075*^9}, {3.5482820824627924`*^9, 3.5482820899040055`*^9}, 
   3.5482825476876197`*^9, {3.548282600821313*^9, 3.548282669102633*^9}, {
   3.5482827161211157`*^9, 3.548282763732399*^9}, {3.5482831379926567`*^9, 
   3.5482831926395526`*^9}, 3.548283229252817*^9, {3.5482832677224846`*^9, 
   3.5482832685804863`*^9}, {3.548337660164831*^9, 3.548337707885315*^9}, {
   3.5483378432467527`*^9, 3.5483378914976377`*^9}, {3.5483379306537066`*^9, 
   3.5483380219918666`*^9}, {3.5483383681252747`*^9, 
   3.5483384772006664`*^9}, {3.548338688097437*^9, 3.548338694181447*^9}, {
   3.5483387278775063`*^9, 3.54833873013951*^9}, 3.5483387632739687`*^9, {
   3.5483388024612374`*^9, 3.5483388390277014`*^9}, {3.548338931021063*^9, 
   3.5483389755279417`*^9}, {3.5483391622914696`*^9, 3.548339174412691*^9}, 
   3.548339235034397*^9, 3.5483395307173166`*^9, {3.5483403647727814`*^9, 
   3.5483403955048356`*^9}, {3.548364491181573*^9, 3.5483645678869076`*^9}, {
   3.548364623485405*^9, 3.5483646334070225`*^9}, {3.548364838016982*^9, 
   3.548364941538764*^9}, {3.548365010038484*^9, 3.54836506468538*^9}, {
   3.548365883702419*^9, 3.548365945525327*^9}, {3.5483659788781857`*^9, 
   3.5483659942130127`*^9}, {3.548366118607631*^9, 3.5483661200584335`*^9}, {
   3.548366160805705*^9, 3.548366169697721*^9}, {3.548366210023792*^9, 
   3.5483662558254724`*^9}, {3.548366303873557*^9, 3.5483663061043606`*^9}, {
   3.5483663402684207`*^9, 3.548366353544044*^9}, {3.5483663939637146`*^9, 
   3.548366438626593*^9}, {3.548426002981133*^9, 3.5484260441496053`*^9}, {
   3.548426218152311*^9, 3.548426330815709*^9}, {3.548426366836172*^9, 
   3.548426368957776*^9}, {3.5484265945809717`*^9, 3.548426731159212*^9}, 
   3.5484267672888756`*^9, {3.548426847566616*^9, 3.548426850062621*^9}, 
   3.548426916175537*^9, {3.548426966095625*^9, 3.5484269677492275`*^9}, {
   3.5484292280311985`*^9, 3.548429290446908*^9}, {3.548429320820162*^9, 
   3.5484295570201764`*^9}, {3.548429587112629*^9, 3.5484298194750376`*^9}, {
   3.5484344974260545`*^9, 3.548434522713699*^9}, {3.548434880188327*^9, 
   3.54843488232553*^9}, {3.5484349317776175`*^9, 3.548434953321255*^9}, {
   3.5484351235175543`*^9, 3.548435150833202*^9}, {3.5484351972588835`*^9, 
   3.54843521789772*^9}, 3.5484352564297876`*^9, {3.5484353248671074`*^9, 
   3.5484353811832066`*^9}, {3.5484354363605037`*^9, 
   3.5484354375461054`*^9}, {3.5484354942834053`*^9, 3.54843559367118*^9}, {
   3.548435695242958*^9, 3.5484358725996695`*^9}, {3.548435910258136*^9, 
   3.5484359121301394`*^9}, {3.548436201432647*^9, 3.5484362033982506`*^9}, {
   3.548436286452797*^9, 3.5484364403002667`*^9}, 3.548436500843973*^9, 
   3.54843653889244*^9, {3.548436585848522*^9, 3.548436642539022*^9}, {
   3.548436704954732*^9, 3.54843677804086*^9}, 3.5484369444931526`*^9, {
   3.5484370203872857`*^9, 3.54843702255569*^9}, {3.5484370660797663`*^9, 
   3.5484370777641864`*^9}, {3.548437110274644*^9, 3.5484372383352685`*^9}, {
   3.5484373881735315`*^9, 3.5484375229577684`*^9}, {3.5484376009267054`*^9, 
   3.548437604795512*^9}, {3.5484376442011814`*^9, 3.5484376638104157`*^9}, 
   3.5484376978184757`*^9, {3.548437819607889*^9, 3.548437887670809*^9}, 
   3.5484381060087924`*^9, {3.548438191746543*^9, 3.5484382289994087`*^9}, {
   3.5484383503832216`*^9, 3.5484385271315317`*^9}, 3.548438559517189*^9, {
   3.5484386721025867`*^9, 3.548438711539456*^9}, {3.548438834077671*^9, 
   3.5484388426888866`*^9}, 3.54843887293734*^9, {3.5484389443074646`*^9, 
   3.5484389527626796`*^9}, 3.54843906107367*^9, 3.5484390990909367`*^9, {
   3.5484391301817913`*^9, 3.5484391618810472`*^9}, {3.548439235965577*^9, 
   3.548439238243181*^9}, {3.548522484301733*^9, 3.5485226761820703`*^9}, 
   3.5485227731206408`*^9, {3.5487713741413865`*^9, 3.5487714149842587`*^9}, {
   3.54877151806924*^9, 3.54877154086088*^9}, {3.5487719300523643`*^9, 
   3.548771981906855*^9}, {3.5490422461683207`*^9, 3.5490422720643663`*^9}, {
   3.549042356398114*^9, 3.549042358613318*^9}, {3.549042496132761*^9, 
   3.549042497583564*^9}, {3.5490425458188486`*^9, 3.549042591448929*^9}, {
   3.5490431102766404`*^9, 3.5490431324910793`*^9}, 3.5490432759489317`*^9, 
   3.5490433380370407`*^9, {3.5490435506966143`*^9, 3.5490435587774277`*^9}, {
   3.549043619055934*^9, 3.5490436199919357`*^9}, {3.54904369075366*^9, 
   3.5490436938580656`*^9}, 3.549489860665391*^9, {3.5494899950440273`*^9, 
   3.5494900364309*^9}, {3.5494920566188483`*^9, 3.5494920572740493`*^9}, {
   3.54949209199971*^9, 3.5494920925925117`*^9}, {3.5494922452855797`*^9, 
   3.5494922895584574`*^9}, {3.549492648078287*^9, 3.54949267823314*^9}, {
   3.549570556707936*^9, 3.5495705626359463`*^9}, {3.549570595021603*^9, 
   3.5495706010900135`*^9}, 3.5495706692309337`*^9, {3.5495711691650114`*^9, 
   3.5495711873390436`*^9}, 3.549571255932364*^9, {3.549571311718062*^9, 
   3.549571355398139*^9}, {3.5496348238725996`*^9, 3.5496348324370146`*^9}, {
   3.549635016813739*^9, 3.549635024473352*^9}, {3.5496350764682436`*^9, 
   3.549635082661454*^9}, {3.549635135077546*^9, 3.549635169475607*^9}, 
   3.5496352570073605`*^9, {3.5496354655329266`*^9, 3.5496355133470106`*^9}, {
   3.549635707192951*^9, 3.549635733307397*^9}, 3.549636997081217*^9, {
   3.549637058623325*^9, 3.5496370851433716`*^9}, {3.5496371589939013`*^9, 
   3.549637168494318*^9}, {3.5496374722112513`*^9, 3.5496374729600525`*^9}, {
   3.5496376869768286`*^9, 3.549637689270033*^9}, {3.549637751623342*^9, 
   3.549637770343375*^9}, {3.549638330587159*^9, 3.549638583647204*^9}, 
   3.549638641320505*^9, {3.5496480244817457`*^9, 3.549648046087784*^9}, {
   3.5496481182535105`*^9, 3.549648155553176*^9}, {3.5496481886096334`*^9, 
   3.5496481957232466`*^9}, {3.549648225753299*^9, 3.549648256017352*^9}, {
   3.5496482886370096`*^9, 3.549648300820631*^9}, {3.5496484007856064`*^9, 
   3.5496484595197096`*^9}, {3.54964849373057*^9, 3.549648498348178*^9}, {
   3.5496485926035433`*^9, 3.5496485968467507`*^9}, {3.549648963728195*^9, 
   3.5496489666142006`*^9}, {3.5496491073420477`*^9, 
   3.5496491153448615`*^9}, {3.549649213032233*^9, 3.5496492456206903`*^9}, {
   3.5496493848429356`*^9, 3.5496494053413715`*^9}, 3.5496495105479565`*^9, 
   3.549649583306484*^9, {3.5496496777178497`*^9, 3.549649680525855*^9}, {
   3.549649735718752*^9, 3.5496497579955907`*^9}, 3.5496498524693565`*^9, 
   3.5496498862902164`*^9, 3.5496553811468678`*^9, {3.549655412736923*^9, 
   3.549655429631753*^9}, {3.549655466182617*^9, 3.549655507179489*^9}, 
   3.5496555443075542`*^9, {3.549655595896845*^9, 3.549655601060454*^9}, {
   3.562091356752223*^9, 3.5620915759170074`*^9}, 3.562091709390842*^9, {
   3.5620918280602503`*^9, 3.5620918320850573`*^9}, {3.5620919174016075`*^9, 
   3.5620919603952827`*^9}, {3.562092199762103*^9, 3.5620922398385735`*^9}, {
   3.562092274533035*^9, 3.5620923285247297`*^9}, {3.5620924382553225`*^9, 
   3.562092511793852*^9}, {3.562092577407567*^9, 3.562092582009575*^9}, {
   3.562092623318447*^9, 3.562092627234054*^9}, {3.5620926805393476`*^9, 
   3.562092766448699*^9}, {3.562092869174879*^9, 3.562092962010642*^9}, {
   3.562093021540347*^9, 3.562093068168829*^9}, {3.5620931602401905`*^9, 
   3.562093341075708*^9}, {3.5620933743193665`*^9, 3.5620933812301784`*^9}, {
   3.5620934307602654`*^9, 3.5620934700411344`*^9}, {3.562093511818008*^9, 
   3.562093562471297*^9}, {3.562093601112565*^9, 3.5620936050281715`*^9}, {
   3.5620936625766726`*^9, 3.5620941391887097`*^9}, {3.5620941987184143`*^9, 
   3.562094238826085*^9}, {3.5620947570589952`*^9, 3.5620948176339016`*^9}, {
   3.5620948602375765`*^9, 3.5620948767736053`*^9}, {3.562094917240076*^9, 
   3.562094990263805*^9}, 3.5620980075899043`*^9, {3.5620980503495793`*^9, 
   3.562098094466457*^9}, {3.562098142670542*^9, 3.562098287516796*^9}, 
   3.5620983227728577`*^9, {3.5620983726617455`*^9, 3.562098372833346*^9}, {
   3.562098822990937*^9, 3.562098903892679*^9}, {3.5620989757776055`*^9, 
   3.5620989877584267`*^9}, {3.5620991083934383`*^9, 3.562099127565872*^9}, {
   3.562099173882354*^9, 3.56209943975362*^9}, {3.5621583498070045`*^9, 
   3.562158394984684*^9}, {3.5621585445265465`*^9, 3.5621586150230703`*^9}, {
   3.562158652338336*^9, 3.5621587503221083`*^9}, {3.562158807262208*^9, 
   3.562158875995929*^9}, {3.5621589394412403`*^9, 3.562159007145359*^9}, {
   3.5621591481696067`*^9, 3.5621591503848104`*^9}, {3.562159196311291*^9, 
   3.562159196607692*^9}, {3.562159251394988*^9, 3.5621592555289955`*^9}, {
   3.562159288320253*^9, 3.562159397161644*^9}, {3.5621594286892996`*^9, 
   3.5621595106986437`*^9}, {3.562159602473605*^9, 3.562159643470477*^9}, {
   3.562159702906581*^9, 3.562159751219866*^9}, {3.5621597829659214`*^9, 
   3.5621598318876076`*^9}, {3.56215995286582*^9, 3.562160113858103*^9}, {
   3.5621602978448257`*^9, 3.5621607866560845`*^9}, {3.562160927368332*^9, 
   3.5621609811884265`*^9}, {3.5621610683613796`*^9, 
   3.5621611490915213`*^9}, {3.5621612865745625`*^9, 3.562161311129006*^9}, {
   3.5621613577106876`*^9, 3.5621613650583005`*^9}, {3.5621614180671935`*^9, 
   3.5621614324348187`*^9}, {3.5621615463930187`*^9, 3.56216157525307*^9}, {
   3.5621616178723445`*^9, 3.5621616240811553`*^9}, {3.562161662488423*^9, 
   3.562161662597623*^9}, {3.564767746948951*^9, 3.5647677472921515`*^9}, 
   3.5847162105889177`*^9},
 FontFamily->"Courier New",
 FontColor->GrayLevel[0]],

Cell[CellGroupData[{

Cell["Input matrix", "Section",
 CellChangeTimes->{{3.5847162148789234`*^9, 3.584716224508937*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat0", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";", "  ", 
   RowBox[{"(*", " ", 
    RowBox[{"shear", " ", "in", " ", "pla"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"mat1", "=", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";", "  ", 
   RowBox[{"(*", " ", 
    RowBox[{"3", "x2", " ", "example", " ", "in", " ", "pla"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"mat2", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", ".8"}], ",", "0", ",", ".8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1.5", ",", 
        RowBox[{"-", ".3"}]}], "}"}]}], "}"}]}], ";", "   ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "2", "x3", " ", "Input", " ", "matrix", " ", "for", " ", "PLA", " ", 
     "example"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"mat3", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.5", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mat", " ", "=", " ", "mat0"}], ";"}]}], "Input",
 CellChangeTimes->{{3.5190613970788293`*^9, 3.519061397749631*^9}, {
   3.519061432022891*^9, 3.5190614624429445`*^9}, {3.519061514905836*^9, 
   3.519061628240035*^9}, {3.519061759373866*^9, 3.5190617744122925`*^9}, {
   3.5190618332711954`*^9, 3.519061929601365*^9}, {3.51906205786479*^9, 
   3.5190620650876026`*^9}, 3.5190621108268833`*^9, {3.5190622884799953`*^9, 
   3.519062320350851*^9}, {3.519062521918805*^9, 3.5190626326165996`*^9}, {
   3.5190628193333273`*^9, 3.519062819380128*^9}, 3.519062858848197*^9, {
   3.5190637725290017`*^9, 3.519063787505028*^9}, 3.519064197458148*^9, {
   3.5190648424412813`*^9, 3.519064859632511*^9}, {3.519065093601722*^9, 
   3.5190651249109774`*^9}, {3.519143584891322*^9, 3.519143618134981*^9}, {
   3.5191436705822725`*^9, 3.519143684029496*^9}, {3.5191564974679966`*^9, 
   3.5191565115080214`*^9}, 3.5191687775763645`*^9, {3.5193183416584096`*^9, 
   3.51931846709823*^9}, 3.519318600363664*^9, {3.519318688550619*^9, 
   3.5193187098134565`*^9}, {3.519318801682018*^9, 3.5193188481232996`*^9}, {
   3.519318923799032*^9, 3.5193189293682423`*^9}, {3.5193190014403687`*^9, 
   3.519319022781206*^9}, {3.519319175864275*^9, 3.5193191785006795`*^9}, {
   3.519319310882512*^9, 3.5193193555765905`*^9}, {3.519319442172343*^9, 
   3.519319565287759*^9}, {3.5193198098493886`*^9, 3.519319841985445*^9}, 
   3.5193199527144394`*^9, 3.519320062320232*^9, 3.5193201753736305`*^9, 
   3.5193203564431486`*^9, {3.5193290189839635`*^9, 3.5193290317447863`*^9}, {
   3.519331648326182*^9, 3.519331738915541*^9}, {3.5193317714883986`*^9, 
   3.519331836524913*^9}, {3.519331911748245*^9, 3.5193319703887477`*^9}, {
   3.519332003850806*^9, 3.5193320128052225`*^9}, {3.5193320585133023`*^9, 
   3.519332077030535*^9}, {3.519332153501869*^9, 3.5193321795851154`*^9}, {
   3.519332252250043*^9, 3.5193322645272646`*^9}, {3.5193322952749186`*^9, 
   3.5193323228869667`*^9}, {3.5193324053487115`*^9, 
   3.5193324341619625`*^9}, {3.5193324710560274`*^9, 
   3.5193324897448597`*^9}, {3.5193325345949388`*^9, 3.519332573875808*^9}, {
   3.5193326105514717`*^9, 3.519332617306284*^9}, {3.5193326927480164`*^9, 
   3.519332779094168*^9}, {3.5193329731585093`*^9, 3.51933318466368*^9}, {
   3.5193333259219284`*^9, 3.5193333573559837`*^9}, 3.5193334441701365`*^9, 
   3.519333573806364*^9, {3.5193336196236444`*^9, 3.519333700915387*^9}, {
   3.5193338052015705`*^9, 3.519333805575971*^9}, {3.519336424716172*^9, 
   3.519336584819253*^9}, {3.51933662859293*^9, 3.5193366396221495`*^9}, {
   3.5193374015586877`*^9, 3.5193374062854958`*^9}, {3.5193377748885436`*^9, 
   3.51933777852335*^9}, {3.5193378293794394`*^9, 3.51933788112473*^9}, {
   3.5193379688748846`*^9, 3.5193379927897263`*^9}, {3.519393659487196*^9, 
   3.5193937240620933`*^9}, 3.5193995276423693`*^9, {3.519399560262027*^9, 
   3.5193995687172413`*^9}, 3.519399607062109*^9, {3.519743189247101*^9, 
   3.519743197296715*^9}, {3.519822556574108*^9, 3.5198225643117213`*^9}, {
   3.519822615635812*^9, 3.5198226456502647`*^9}, {3.519822681327527*^9, 
   3.5198226840575314`*^9}, {3.5198227249296036`*^9, 3.519822727909209*^9}, {
   3.5198230136237106`*^9, 3.5198230640585995`*^9}, {3.5199394713775268`*^9, 
   3.519939474435132*^9}, {3.5209457136282034`*^9, 3.5209457316306353`*^9}, {
   3.521233019052727*^9, 3.5212330195363283`*^9}, {3.521824157577416*^9, 
   3.5218241913514752`*^9}, {3.5218242354839525`*^9, 
   3.5218242371531553`*^9}, {3.521824777014904*^9, 3.521824780977311*^9}, {
   3.521824881659888*^9, 3.5218248945143104`*^9}, {3.522546096219933*^9, 
   3.522546118446204*^9}, {3.522546164829857*^9, 3.5225461846399903`*^9}, {
   3.5480827780275407`*^9, 3.548083073180059*^9}, {3.5480844465048714`*^9, 
   3.548084447799674*^9}, 3.548084490465749*^9, {3.548084523725007*^9, 
   3.5480845255190105`*^9}, {3.5480846736100707`*^9, 
   3.5480847132965403`*^9}, {3.5480850595079484`*^9, 3.548085176601754*^9}, {
   3.5480852081762094`*^9, 3.548085220968232*^9}, 3.5480852876959496`*^9, {
   3.5480853452912507`*^9, 3.548085345416051*^9}, {3.5480854601230526`*^9, 
   3.548085504957531*^9}, {3.54808669421002*^9, 3.5480867052080393`*^9}, 
   3.5480869024859858`*^9, {3.5480873606119905`*^9, 3.5480873616259923`*^9}, {
   3.5481089290239763`*^9, 3.5481089295387774`*^9}, {3.5481090731058297`*^9, 
   3.5481091125270987`*^9}, {3.54810921548728*^9, 3.5481092677161713`*^9}, {
   3.5481093308494825`*^9, 3.54810947777054*^9}, {3.5481095113105993`*^9, 
   3.5481095348666406`*^9}, {3.548255560709408*^9, 3.548255637461543*^9}, {
   3.548255675385209*^9, 3.54825568700723*^9}, {3.548255737161318*^9, 
   3.5482557378165193`*^9}, {3.548255813897853*^9, 3.548255849465915*^9}, {
   3.548265318518547*^9, 3.54826532014095*^9}, {3.5482654408071623`*^9, 
   3.5482654469691725`*^9}, {3.5482655240957084`*^9, 3.548265530054919*^9}, {
   3.548265648131526*^9, 3.548265660642748*^9}, {3.548265763743329*^9, 
   3.5482658059570036`*^9}, 3.5482660708142686`*^9, {3.548266109892337*^9, 
   3.5482661181291513`*^9}, {3.548266190653679*^9, 3.548266220886532*^9}, {
   3.5482665984383955`*^9, 3.548266647469281*^9}, {3.548266688247753*^9, 
   3.5482666925221605`*^9}, {3.548266762925084*^9, 3.5482667724099007`*^9}, {
   3.5482668726868773`*^9, 3.5482668940277147`*^9}, {3.5482669350245867`*^9, 
   3.54826695400982*^9}, {3.5482670699492235`*^9, 3.5482670787320385`*^9}, {
   3.548267132645734*^9, 3.5482671855142264`*^9}, {3.548267237665118*^9, 
   3.5482672647935658`*^9}, {3.548278236511236*^9, 3.5482782735925016`*^9}, {
   3.548278327256596*^9, 3.548278376802283*^9}, {3.5482785724890265`*^9, 
   3.548278578339037*^9}, {3.5482792414338017`*^9, 3.548279284864278*^9}, {
   3.5482793450959835`*^9, 3.548279353972399*^9}, {3.5482795652435703`*^9, 
   3.548279619921666*^9}, {3.548279773441536*^9, 3.5482797903051653`*^9}, {
   3.5482799098637753`*^9, 3.5482799507982473`*^9}, {3.5482800398588037`*^9, 
   3.548280046457616*^9}, {3.5482800767216682`*^9, 3.5482801276869583`*^9}, {
   3.5482803327805185`*^9, 3.548280371484186*^9}, {3.548280417441867*^9, 
   3.5482804279406853`*^9}, {3.548280494927203*^9, 3.54828054439489*^9}, {
   3.54828076624288*^9, 3.5482807778649*^9}, {3.54828122190408*^9, 
   3.5482813009182186`*^9}, 3.54828184769798*^9, {3.54828201277747*^9, 
   3.548282015523075*^9}, {3.5482820824627924`*^9, 3.5482820899040055`*^9}, 
   3.5482825476876197`*^9, {3.548282600821313*^9, 3.548282669102633*^9}, {
   3.5482827161211157`*^9, 3.548282763732399*^9}, {3.5482831379926567`*^9, 
   3.5482831926395526`*^9}, 3.548283229252817*^9, {3.5482832677224846`*^9, 
   3.5482832685804863`*^9}, {3.548337660164831*^9, 3.548337707885315*^9}, {
   3.5483378432467527`*^9, 3.5483378914976377`*^9}, {3.5483379306537066`*^9, 
   3.5483380219918666`*^9}, {3.5483383681252747`*^9, 
   3.5483384772006664`*^9}, {3.548338688097437*^9, 3.548338694181447*^9}, {
   3.5483387278775063`*^9, 3.54833873013951*^9}, 3.5483387632739687`*^9, {
   3.5483388024612374`*^9, 3.5483388390277014`*^9}, {3.548338931021063*^9, 
   3.5483389755279417`*^9}, {3.5483391622914696`*^9, 3.548339174412691*^9}, 
   3.548339235034397*^9, 3.5483395307173166`*^9, {3.5483403647727814`*^9, 
   3.5483403955048356`*^9}, {3.548364491181573*^9, 3.5483645678869076`*^9}, {
   3.548364623485405*^9, 3.5483646334070225`*^9}, {3.548364838016982*^9, 
   3.548364941538764*^9}, {3.548365010038484*^9, 3.54836506468538*^9}, {
   3.548365883702419*^9, 3.548365945525327*^9}, {3.5483659788781857`*^9, 
   3.5483659942130127`*^9}, {3.548366118607631*^9, 3.5483661200584335`*^9}, {
   3.548366160805705*^9, 3.548366169697721*^9}, {3.548366210023792*^9, 
   3.5483662558254724`*^9}, {3.548366303873557*^9, 3.5483663061043606`*^9}, {
   3.5483663402684207`*^9, 3.548366353544044*^9}, {3.5483663939637146`*^9, 
   3.548366438626593*^9}, {3.548426002981133*^9, 3.5484260441496053`*^9}, {
   3.548426218152311*^9, 3.548426330815709*^9}, {3.548426366836172*^9, 
   3.548426368957776*^9}, {3.5484265945809717`*^9, 3.548426731159212*^9}, 
   3.5484267672888756`*^9, {3.548426847566616*^9, 3.548426850062621*^9}, 
   3.548426916175537*^9, {3.548426966095625*^9, 3.5484269677492275`*^9}, {
   3.5484292280311985`*^9, 3.548429290446908*^9}, {3.548429320820162*^9, 
   3.5484295570201764`*^9}, {3.548429587112629*^9, 3.5484298194750376`*^9}, {
   3.5484344974260545`*^9, 3.548434522713699*^9}, {3.548434880188327*^9, 
   3.54843488232553*^9}, {3.5484349317776175`*^9, 3.548434953321255*^9}, {
   3.5484351235175543`*^9, 3.548435150833202*^9}, {3.5484351972588835`*^9, 
   3.54843521789772*^9}, 3.5484352564297876`*^9, {3.5484353248671074`*^9, 
   3.5484353811832066`*^9}, {3.5484354363605037`*^9, 
   3.5484354375461054`*^9}, {3.5484354942834053`*^9, 3.54843559367118*^9}, {
   3.548435695242958*^9, 3.5484358725996695`*^9}, {3.548435910258136*^9, 
   3.5484359121301394`*^9}, {3.548436201432647*^9, 3.5484362033982506`*^9}, {
   3.548436286452797*^9, 3.5484364403002667`*^9}, 3.548436500843973*^9, 
   3.54843653889244*^9, {3.548436585848522*^9, 3.548436642539022*^9}, {
   3.548436704954732*^9, 3.54843677804086*^9}, 3.5484369444931526`*^9, {
   3.5484370203872857`*^9, 3.54843702255569*^9}, {3.5484370660797663`*^9, 
   3.5484370777641864`*^9}, {3.548437110274644*^9, 3.5484372383352685`*^9}, {
   3.5484373881735315`*^9, 3.5484375229577684`*^9}, {3.5484376009267054`*^9, 
   3.548437604795512*^9}, {3.5484376442011814`*^9, 3.5484376638104157`*^9}, 
   3.5484376978184757`*^9, {3.548437819607889*^9, 3.548437887670809*^9}, 
   3.5484381060087924`*^9, {3.548438191746543*^9, 3.5484382289994087`*^9}, {
   3.5484383503832216`*^9, 3.5484385271315317`*^9}, 3.548438559517189*^9, {
   3.5484386721025867`*^9, 3.548438711539456*^9}, {3.548438834077671*^9, 
   3.5484388426888866`*^9}, 3.54843887293734*^9, {3.5484389443074646`*^9, 
   3.5484389527626796`*^9}, 3.54843906107367*^9, 3.5484390990909367`*^9, {
   3.5484391301817913`*^9, 3.5484391618810472`*^9}, {3.548439235965577*^9, 
   3.548439238243181*^9}, {3.548522484301733*^9, 3.5485226761820703`*^9}, 
   3.5485227731206408`*^9, {3.5487713741413865`*^9, 3.5487714149842587`*^9}, {
   3.54877151806924*^9, 3.54877154086088*^9}, {3.5487719300523643`*^9, 
   3.548771981906855*^9}, {3.5490422461683207`*^9, 3.5490422720643663`*^9}, {
   3.549042356398114*^9, 3.549042358613318*^9}, {3.549042496132761*^9, 
   3.549042497583564*^9}, {3.5490425458188486`*^9, 3.549042591448929*^9}, {
   3.5490431102766404`*^9, 3.5490431324910793`*^9}, 3.5490432759489317`*^9, 
   3.5490433380370407`*^9, {3.5490435506966143`*^9, 3.5490435587774277`*^9}, {
   3.549043619055934*^9, 3.5490436199919357`*^9}, {3.54904369075366*^9, 
   3.5490436938580656`*^9}, 3.549489860665391*^9, {3.5494899950440273`*^9, 
   3.5494900364309*^9}, {3.5494920566188483`*^9, 3.5494920572740493`*^9}, {
   3.54949209199971*^9, 3.5494920925925117`*^9}, {3.5494922452855797`*^9, 
   3.5494922895584574`*^9}, {3.549492648078287*^9, 3.54949267823314*^9}, {
   3.549570556707936*^9, 3.5495705626359463`*^9}, {3.549570595021603*^9, 
   3.5495706010900135`*^9}, 3.5495706692309337`*^9, {3.5495711691650114`*^9, 
   3.5495711873390436`*^9}, 3.549571255932364*^9, {3.549571311718062*^9, 
   3.549571355398139*^9}, {3.5496348238725996`*^9, 3.5496348324370146`*^9}, {
   3.549635016813739*^9, 3.549635024473352*^9}, {3.5496350764682436`*^9, 
   3.549635082661454*^9}, {3.549635135077546*^9, 3.549635169475607*^9}, 
   3.5496352570073605`*^9, {3.5496354655329266`*^9, 3.5496355133470106`*^9}, {
   3.549635707192951*^9, 3.549635733307397*^9}, 3.549636997081217*^9, {
   3.549637058623325*^9, 3.5496370851433716`*^9}, {3.5496371589939013`*^9, 
   3.549637168494318*^9}, {3.5496374722112513`*^9, 3.5496374729600525`*^9}, {
   3.5496376869768286`*^9, 3.549637689270033*^9}, {3.549637751623342*^9, 
   3.549637770343375*^9}, {3.549638330587159*^9, 3.549638583647204*^9}, 
   3.549638641320505*^9, {3.5496480244817457`*^9, 3.549648046087784*^9}, {
   3.5496481182535105`*^9, 3.549648155553176*^9}, {3.5496481886096334`*^9, 
   3.5496481957232466`*^9}, {3.549648225753299*^9, 3.549648256017352*^9}, {
   3.5496482886370096`*^9, 3.549648300820631*^9}, {3.5496484007856064`*^9, 
   3.5496484595197096`*^9}, {3.54964849373057*^9, 3.549648498348178*^9}, {
   3.5496485926035433`*^9, 3.5496485968467507`*^9}, {3.549648963728195*^9, 
   3.5496489666142006`*^9}, {3.5496491073420477`*^9, 
   3.5496491153448615`*^9}, {3.549649213032233*^9, 3.5496492456206903`*^9}, {
   3.5496493848429356`*^9, 3.5496494053413715`*^9}, 3.5496495105479565`*^9, 
   3.549649583306484*^9, {3.5496496777178497`*^9, 3.549649680525855*^9}, {
   3.549649735718752*^9, 3.5496497579955907`*^9}, 3.5496498524693565`*^9, 
   3.5496498862902164`*^9, 3.5496553811468678`*^9, {3.549655412736923*^9, 
   3.549655429631753*^9}, {3.549655466182617*^9, 3.549655507179489*^9}, 
   3.5496555443075542`*^9, {3.549655595896845*^9, 3.549655601060454*^9}, {
   3.562091356752223*^9, 3.5620915759170074`*^9}, 3.562091709390842*^9, {
   3.5620918280602503`*^9, 3.5620918320850573`*^9}, {3.5620919174016075`*^9, 
   3.5620919603952827`*^9}, {3.562092199762103*^9, 3.5620922398385735`*^9}, {
   3.562092274533035*^9, 3.5620923285247297`*^9}, {3.5620924382553225`*^9, 
   3.562092511793852*^9}, {3.562092577407567*^9, 3.562092582009575*^9}, {
   3.562092623318447*^9, 3.562092627234054*^9}, {3.5620926805393476`*^9, 
   3.562092766448699*^9}, {3.562092869174879*^9, 3.562092962010642*^9}, {
   3.562093021540347*^9, 3.562093068168829*^9}, {3.5620931602401905`*^9, 
   3.562093341075708*^9}, {3.5620933743193665`*^9, 3.5620933812301784`*^9}, {
   3.5620934307602654`*^9, 3.5620934700411344`*^9}, {3.562093511818008*^9, 
   3.562093562471297*^9}, {3.562093601112565*^9, 3.5620936050281715`*^9}, {
   3.5620936625766726`*^9, 3.5620941391887097`*^9}, {3.5620941987184143`*^9, 
   3.562094238826085*^9}, {3.5620947570589952`*^9, 3.5620948176339016`*^9}, {
   3.5620948602375765`*^9, 3.5620948767736053`*^9}, {3.562094917240076*^9, 
   3.562094990263805*^9}, 3.5620980075899043`*^9, {3.5620980503495793`*^9, 
   3.562098094466457*^9}, {3.562098142670542*^9, 3.562098287516796*^9}, 
   3.5620983227728577`*^9, {3.5620983726617455`*^9, 3.562098372833346*^9}, {
   3.562098822990937*^9, 3.562098903892679*^9}, {3.5620989757776055`*^9, 
   3.5620989877584267`*^9}, {3.5620991083934383`*^9, 3.562099127565872*^9}, {
   3.562099173882354*^9, 3.56209943975362*^9}, {3.5621583498070045`*^9, 
   3.562158394984684*^9}, {3.5621585445265465`*^9, 3.5621586150230703`*^9}, {
   3.562158652338336*^9, 3.5621587503221083`*^9}, {3.562158807262208*^9, 
   3.562158875995929*^9}, {3.5621589394412403`*^9, 3.562159007145359*^9}, {
   3.5621591481696067`*^9, 3.5621591503848104`*^9}, {3.562159196311291*^9, 
   3.562159196607692*^9}, {3.562159251394988*^9, 3.5621592555289955`*^9}, {
   3.562159288320253*^9, 3.562159397161644*^9}, {3.5621594286892996`*^9, 
   3.5621595106986437`*^9}, {3.562159602473605*^9, 3.562159643470477*^9}, {
   3.562159702906581*^9, 3.562159751219866*^9}, {3.5621597829659214`*^9, 
   3.5621598318876076`*^9}, {3.56215995286582*^9, 3.562160113858103*^9}, {
   3.5621602978448257`*^9, 3.5621607866560845`*^9}, {3.562160927368332*^9, 
   3.5621609811884265`*^9}, {3.5621610683613796`*^9, 
   3.5621611490915213`*^9}, {3.5621612865745625`*^9, 3.562161311129006*^9}, {
   3.5621613577106876`*^9, 3.5621613650583005`*^9}, {3.5621614180671935`*^9, 
   3.5621614324348187`*^9}, {3.5621615463930187`*^9, 3.56216157525307*^9}, {
   3.5621616178723445`*^9, 3.5621616240811553`*^9}, {3.562161662488423*^9, 
   3.562161662597623*^9}, {3.564767746948951*^9, 3.5647677472921515`*^9}, {
   3.5847162105889177`*^9, 3.584716234588951*^9}},
 FontFamily->"Courier New",
 FontColor->GrayLevel[0]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compute SVD", "Section",
 CellChangeTimes->{{3.5847162393189583`*^9, 3.584716247288969*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Compute", " ", "SVD"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"uu", ",", "ss", ",", "vv"}], "}"}], "=", 
     RowBox[{"SingularValueDecomposition", "[", "mat", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vvt", "=", 
     RowBox[{"Transpose", "[", "vv", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimmat", " ", "=", " ", 
     RowBox[{"Dimensions", "[", "mat", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimvvt", " ", "=", " ", 
     RowBox[{"Dimensions", "[", "vvt", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimss", " ", "=", " ", 
     RowBox[{"Dimensions", "[", "ss", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dimuu", " ", "=", " ", 
     RowBox[{"Dimensions", "[", "uu", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{
     "\"\<Dimension mat =\>\"", ",", "dimmat", ",", "\"\<  Dim vvt = \>\"", 
      ",", "dimvvt", ",", "\"\<  Dim ss= \>\"", ",", "dimss", ",", 
      "\"\<  dimuu = \>\"", ",", "dimuu"}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Check", " ", "all", " ", "is", " ", "ok"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<uu,ss,vv: \>\"", ",", " ", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "uu", "]"}], "//", "N"}], ",", "\"\<, \>\"",
       ",", " ", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "ss", "]"}], "//", "N"}], ",", " ", 
      "\"\<, \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "vv", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"\"\<uu.ss.vv^T: \>\"", ",", " ", 
      RowBox[{
       RowBox[{"MatrixForm", "[", 
        RowBox[{"uu", ".", "ss", ".", "vvt"}], "]"}], "//", "N"}], ",", " ", 
      "\"\<   mat: \>\"", ",", 
      RowBox[{
       RowBox[{"MatrixForm", "[", "mat", "]"}], "//", "N"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Set", " ", "up", " ", "params", " ", "for", " ", "display"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"del", "=", "0.1"}], ";", " ", 
    RowBox[{"(*", " ", 
     RowBox[{"controls", " ", "number", " ", "of", " ", "points"}], " ", 
     "*)"}], "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{"vp", "=", 
       RowBox[{".7", 
        RowBox[{"{", 
         RowBox[{"1", ",", 
          RowBox[{"-", "2"}], ",", 
          RowBox[{"-", "0.8"}]}], "}"}]}]}], ";"}], " ", 
     RowBox[{"(*", "Viewpoint", " ", "*)"}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"vp", "=", 
     RowBox[{".8", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", "1"}], ",", "0.6"}], "}"}]}]}], ";", " ", 
    RowBox[{"(*", "Viewpoint", " ", "*)"}], "\[IndentingNewLine]", 
    RowBox[{"startsize", "=", "0.03"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Generate", " ", "successive", " ", "point", " ", "sets"}], " ", 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"points2d", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", "t", "]"}], ",", 
         RowBox[{"Sin", "[", "t", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", " ", 
         RowBox[{"2", "Pi"}], ",", "del"}], "}"}]}], "]"}]}], ";", 
    RowBox[{"points3d", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", "t", "]"}], ",", 
         RowBox[{"Sin", "[", "t", "]"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", " ", 
         RowBox[{"2", "Pi"}], ",", "del"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"numpoints", "=", 
     RowBox[{"Length", "[", "points3d", "]"}]}], ";"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Applying", " ", "vvt"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"dimvvt", "[", 
        RowBox[{"[", "2", "]"}], "]"}], " ", "\[Equal]", " ", "3"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"vvpoints", " ", "=", " ", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"vvt", ".", 
          RowBox[{"points3d", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "numpoints"}], "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"vvpoints", " ", "=", " ", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"vvt", ".", 
          RowBox[{"points2d", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "numpoints"}], "}"}]}], "]"}]}]}], 
     "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Applying", " ", 
     RowBox[{"ss", ".", "vvt"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ssvvpoints", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"ss", ".", 
        RowBox[{"vvpoints", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numpoints"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Apply", " ", "uu"}], ".."}], 
     RowBox[{"ss", ".", "vvt"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"uussvvpoints", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"uu", ".", 
        RowBox[{"ssvvpoints", "[", 
         RowBox[{"[", "i", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "numpoints"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Apply", " ", "mat", " ", "directly"}], "  ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"dimmat", "[", 
        RowBox[{"[", "2", "]"}], "]"}], " ", "\[Equal]", " ", "3"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"matpoints", " ", "=", " ", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"mat", ".", 
          RowBox[{"points3d", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "numpoints"}], "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"matpoints", " ", "=", " ", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"mat", ".", 
          RowBox[{"points2d", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "numpoints"}], "}"}]}], "]"}]}]}], 
     "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Make", " ", "the", " ", "3", "d", " ", "structures"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "For", " ", "the", " ", "list", " ", "of", " ", "points", " ", 
      "structures"}], ",", " ", 
     RowBox[{
     "look", " ", "at", " ", "the", " ", "second", " ", "dimension", " ", 
      "because", " ", "the", " ", "dimension", " ", "will", " ", "be", " ", 
      "#", "points"}], ",", " ", 
     RowBox[{"space", "-", "dimension"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d", " ", "=", " ", 
     RowBox[{"Dimensions", "[", "vvpoints", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"d", "[", 
        RowBox[{"[", "2", "]"}], "]"}], " ", "\[Equal]", " ", "2"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"vvpoints3d", " ", "=", " ", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"vvpoints", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{"vvpoints", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "numpoints"}], "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"vvpoints3d", " ", "=", " ", "vvpoints"}]}], 
     "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d", " ", "=", " ", 
     RowBox[{"Dimensions", "[", "ssvvpoints", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"d", "[", 
        RowBox[{"[", "2", "]"}], "]"}], " ", "\[Equal]", " ", "2"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ssvvpoints3d", " ", "=", " ", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"ssvvpoints", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{"ssvvpoints", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "numpoints"}], "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ssvvpoints3d", " ", "=", " ", "ssvvpoints"}]}], 
     "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d", " ", "=", " ", 
     RowBox[{"Dimensions", "[", "uussvvpoints", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"d", "[", 
        RowBox[{"[", "2", "]"}], "]"}], " ", "\[Equal]", " ", "2"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"uussvvpoints3d", " ", "=", " ", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"uussvvpoints", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{"uussvvpoints", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "numpoints"}], "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"uussvvpoints3d", " ", "=", " ", "uussvvpoints"}]}], 
     "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"dimmat", "[", 
        RowBox[{"[", "1", "]"}], "]"}], " ", "\[Equal]", " ", "2"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"matpoints3d", " ", "=", " ", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"matpoints", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{"matpoints", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "[", 
            RowBox[{"[", "2", "]"}], "]"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "1", ",", "numpoints"}], "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"matpoints3d", " ", "=", " ", "matpoints"}]}], 
     "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5190613970788293`*^9, 3.519061397749631*^9}, {
   3.519061432022891*^9, 3.5190614624429445`*^9}, {3.519061514905836*^9, 
   3.519061628240035*^9}, {3.519061759373866*^9, 3.5190617744122925`*^9}, {
   3.5190618332711954`*^9, 3.519061929601365*^9}, {3.51906205786479*^9, 
   3.5190620650876026`*^9}, 3.5190621108268833`*^9, {3.5190622884799953`*^9, 
   3.519062320350851*^9}, {3.519062521918805*^9, 3.5190626326165996`*^9}, {
   3.5190628193333273`*^9, 3.519062819380128*^9}, 3.519062858848197*^9, {
   3.5190637725290017`*^9, 3.519063787505028*^9}, 3.519064197458148*^9, {
   3.5190648424412813`*^9, 3.519064859632511*^9}, {3.519065093601722*^9, 
   3.5190651249109774`*^9}, {3.519143584891322*^9, 3.519143618134981*^9}, {
   3.5191436705822725`*^9, 3.519143684029496*^9}, {3.5191564974679966`*^9, 
   3.5191565115080214`*^9}, 3.5191687775763645`*^9, {3.5193183416584096`*^9, 
   3.51931846709823*^9}, 3.519318600363664*^9, {3.519318688550619*^9, 
   3.5193187098134565`*^9}, {3.519318801682018*^9, 3.5193188481232996`*^9}, {
   3.519318923799032*^9, 3.5193189293682423`*^9}, {3.5193190014403687`*^9, 
   3.519319022781206*^9}, {3.519319175864275*^9, 3.5193191785006795`*^9}, {
   3.519319310882512*^9, 3.5193193555765905`*^9}, {3.519319442172343*^9, 
   3.519319565287759*^9}, {3.5193198098493886`*^9, 3.519319841985445*^9}, 
   3.5193199527144394`*^9, 3.519320062320232*^9, 3.5193201753736305`*^9, 
   3.5193203564431486`*^9, {3.5193290189839635`*^9, 3.5193290317447863`*^9}, {
   3.519331648326182*^9, 3.519331738915541*^9}, {3.5193317714883986`*^9, 
   3.519331836524913*^9}, {3.519331911748245*^9, 3.5193319703887477`*^9}, {
   3.519332003850806*^9, 3.5193320128052225`*^9}, {3.5193320585133023`*^9, 
   3.519332077030535*^9}, {3.519332153501869*^9, 3.5193321795851154`*^9}, {
   3.519332252250043*^9, 3.5193322645272646`*^9}, {3.5193322952749186`*^9, 
   3.5193323228869667`*^9}, {3.5193324053487115`*^9, 
   3.5193324341619625`*^9}, {3.5193324710560274`*^9, 
   3.5193324897448597`*^9}, {3.5193325345949388`*^9, 3.519332573875808*^9}, {
   3.5193326105514717`*^9, 3.519332617306284*^9}, {3.5193326927480164`*^9, 
   3.519332779094168*^9}, {3.5193329731585093`*^9, 3.51933318466368*^9}, {
   3.5193333259219284`*^9, 3.5193333573559837`*^9}, 3.5193334441701365`*^9, 
   3.519333573806364*^9, {3.5193336196236444`*^9, 3.519333700915387*^9}, {
   3.5193338052015705`*^9, 3.519333805575971*^9}, {3.519336424716172*^9, 
   3.519336584819253*^9}, {3.51933662859293*^9, 3.5193366396221495`*^9}, {
   3.5193374015586877`*^9, 3.5193374062854958`*^9}, {3.5193377748885436`*^9, 
   3.51933777852335*^9}, {3.5193378293794394`*^9, 3.51933788112473*^9}, {
   3.5193379688748846`*^9, 3.5193379927897263`*^9}, {3.519393659487196*^9, 
   3.5193937240620933`*^9}, 3.5193995276423693`*^9, {3.519399560262027*^9, 
   3.5193995687172413`*^9}, 3.519399607062109*^9, {3.519743189247101*^9, 
   3.519743197296715*^9}, {3.519822556574108*^9, 3.5198225643117213`*^9}, {
   3.519822615635812*^9, 3.5198226456502647`*^9}, {3.519822681327527*^9, 
   3.5198226840575314`*^9}, {3.5198227249296036`*^9, 3.519822727909209*^9}, {
   3.5198230136237106`*^9, 3.5198230640585995`*^9}, {3.5199394713775268`*^9, 
   3.519939474435132*^9}, {3.5209457136282034`*^9, 3.5209457316306353`*^9}, {
   3.521233019052727*^9, 3.5212330195363283`*^9}, {3.521824157577416*^9, 
   3.5218241913514752`*^9}, {3.5218242354839525`*^9, 
   3.5218242371531553`*^9}, {3.521824777014904*^9, 3.521824780977311*^9}, {
   3.521824881659888*^9, 3.5218248945143104`*^9}, {3.522546096219933*^9, 
   3.522546118446204*^9}, {3.522546164829857*^9, 3.5225461846399903`*^9}, {
   3.5480827780275407`*^9, 3.548083073180059*^9}, {3.5480844465048714`*^9, 
   3.548084447799674*^9}, 3.548084490465749*^9, {3.548084523725007*^9, 
   3.5480845255190105`*^9}, {3.5480846736100707`*^9, 
   3.5480847132965403`*^9}, {3.5480850595079484`*^9, 3.548085176601754*^9}, {
   3.5480852081762094`*^9, 3.548085220968232*^9}, 3.5480852876959496`*^9, {
   3.5480853452912507`*^9, 3.548085345416051*^9}, {3.5480854601230526`*^9, 
   3.548085504957531*^9}, {3.54808669421002*^9, 3.5480867052080393`*^9}, 
   3.5480869024859858`*^9, {3.5480873606119905`*^9, 3.5480873616259923`*^9}, {
   3.5481089290239763`*^9, 3.5481089295387774`*^9}, {3.5481090731058297`*^9, 
   3.5481091125270987`*^9}, {3.54810921548728*^9, 3.5481092677161713`*^9}, {
   3.5481093308494825`*^9, 3.54810947777054*^9}, {3.5481095113105993`*^9, 
   3.5481095348666406`*^9}, {3.548255560709408*^9, 3.548255637461543*^9}, {
   3.548255675385209*^9, 3.54825568700723*^9}, {3.548255737161318*^9, 
   3.5482557378165193`*^9}, {3.548255813897853*^9, 3.548255849465915*^9}, {
   3.548265318518547*^9, 3.54826532014095*^9}, {3.5482654408071623`*^9, 
   3.5482654469691725`*^9}, {3.5482655240957084`*^9, 3.548265530054919*^9}, {
   3.548265648131526*^9, 3.548265660642748*^9}, {3.548265763743329*^9, 
   3.5482658059570036`*^9}, 3.5482660708142686`*^9, {3.548266109892337*^9, 
   3.5482661181291513`*^9}, {3.548266190653679*^9, 3.548266220886532*^9}, {
   3.5482665984383955`*^9, 3.548266647469281*^9}, {3.548266688247753*^9, 
   3.5482666925221605`*^9}, {3.548266762925084*^9, 3.5482667724099007`*^9}, {
   3.5482668726868773`*^9, 3.5482668940277147`*^9}, {3.5482669350245867`*^9, 
   3.54826695400982*^9}, {3.5482670699492235`*^9, 3.5482670787320385`*^9}, {
   3.548267132645734*^9, 3.5482671855142264`*^9}, {3.548267237665118*^9, 
   3.5482672647935658`*^9}, {3.548278236511236*^9, 3.5482782735925016`*^9}, {
   3.548278327256596*^9, 3.548278376802283*^9}, {3.5482785724890265`*^9, 
   3.548278578339037*^9}, {3.5482792414338017`*^9, 3.548279284864278*^9}, {
   3.5482793450959835`*^9, 3.548279353972399*^9}, {3.5482795652435703`*^9, 
   3.548279619921666*^9}, {3.548279773441536*^9, 3.5482797903051653`*^9}, {
   3.5482799098637753`*^9, 3.5482799507982473`*^9}, {3.5482800398588037`*^9, 
   3.548280046457616*^9}, {3.5482800767216682`*^9, 3.5482801276869583`*^9}, {
   3.5482803327805185`*^9, 3.548280371484186*^9}, {3.548280417441867*^9, 
   3.5482804279406853`*^9}, {3.548280494927203*^9, 3.54828054439489*^9}, {
   3.54828076624288*^9, 3.5482807778649*^9}, {3.54828122190408*^9, 
   3.5482813009182186`*^9}, 3.54828184769798*^9, {3.54828201277747*^9, 
   3.548282015523075*^9}, {3.5482820824627924`*^9, 3.5482820899040055`*^9}, 
   3.5482825476876197`*^9, {3.548282600821313*^9, 3.548282669102633*^9}, {
   3.5482827161211157`*^9, 3.548282763732399*^9}, {3.5482831379926567`*^9, 
   3.5482831926395526`*^9}, 3.548283229252817*^9, {3.5482832677224846`*^9, 
   3.5482832685804863`*^9}, {3.548337660164831*^9, 3.548337707885315*^9}, {
   3.5483378432467527`*^9, 3.5483378914976377`*^9}, {3.5483379306537066`*^9, 
   3.5483380219918666`*^9}, {3.5483383681252747`*^9, 
   3.5483384772006664`*^9}, {3.548338688097437*^9, 3.548338694181447*^9}, {
   3.5483387278775063`*^9, 3.54833873013951*^9}, 3.5483387632739687`*^9, {
   3.5483388024612374`*^9, 3.5483388390277014`*^9}, {3.548338931021063*^9, 
   3.5483389755279417`*^9}, {3.5483391622914696`*^9, 3.548339174412691*^9}, 
   3.548339235034397*^9, 3.5483395307173166`*^9, {3.5483403647727814`*^9, 
   3.5483403955048356`*^9}, {3.548364491181573*^9, 3.5483645678869076`*^9}, {
   3.548364623485405*^9, 3.5483646334070225`*^9}, {3.548364838016982*^9, 
   3.548364941538764*^9}, {3.548365010038484*^9, 3.54836506468538*^9}, {
   3.548365883702419*^9, 3.548365945525327*^9}, {3.5483659788781857`*^9, 
   3.5483659942130127`*^9}, {3.548366118607631*^9, 3.5483661200584335`*^9}, {
   3.548366160805705*^9, 3.548366169697721*^9}, {3.548366210023792*^9, 
   3.5483662558254724`*^9}, {3.548366303873557*^9, 3.5483663061043606`*^9}, {
   3.5483663402684207`*^9, 3.548366353544044*^9}, {3.5483663939637146`*^9, 
   3.548366438626593*^9}, {3.548426002981133*^9, 3.5484260441496053`*^9}, {
   3.548426218152311*^9, 3.548426330815709*^9}, {3.548426366836172*^9, 
   3.548426368957776*^9}, {3.5484265945809717`*^9, 3.548426731159212*^9}, 
   3.5484267672888756`*^9, {3.548426847566616*^9, 3.548426850062621*^9}, 
   3.548426916175537*^9, {3.548426966095625*^9, 3.5484269677492275`*^9}, {
   3.5484292280311985`*^9, 3.548429290446908*^9}, {3.548429320820162*^9, 
   3.5484295570201764`*^9}, {3.548429587112629*^9, 3.5484298194750376`*^9}, {
   3.5484344974260545`*^9, 3.548434522713699*^9}, {3.548434880188327*^9, 
   3.54843488232553*^9}, {3.5484349317776175`*^9, 3.548434953321255*^9}, {
   3.5484351235175543`*^9, 3.548435150833202*^9}, {3.5484351972588835`*^9, 
   3.54843521789772*^9}, 3.5484352564297876`*^9, {3.5484353248671074`*^9, 
   3.5484353811832066`*^9}, {3.5484354363605037`*^9, 
   3.5484354375461054`*^9}, {3.5484354942834053`*^9, 3.54843559367118*^9}, {
   3.548435695242958*^9, 3.5484358725996695`*^9}, {3.548435910258136*^9, 
   3.5484359121301394`*^9}, {3.548436201432647*^9, 3.5484362033982506`*^9}, {
   3.548436286452797*^9, 3.5484364403002667`*^9}, 3.548436500843973*^9, 
   3.54843653889244*^9, {3.548436585848522*^9, 3.548436642539022*^9}, {
   3.548436704954732*^9, 3.54843677804086*^9}, 3.5484369444931526`*^9, {
   3.5484370203872857`*^9, 3.54843702255569*^9}, {3.5484370660797663`*^9, 
   3.5484370777641864`*^9}, {3.548437110274644*^9, 3.5484372383352685`*^9}, {
   3.5484373881735315`*^9, 3.5484375229577684`*^9}, {3.5484376009267054`*^9, 
   3.548437604795512*^9}, {3.5484376442011814`*^9, 3.5484376638104157`*^9}, 
   3.5484376978184757`*^9, {3.548437819607889*^9, 3.548437887670809*^9}, 
   3.5484381060087924`*^9, {3.548438191746543*^9, 3.5484382289994087`*^9}, {
   3.5484383503832216`*^9, 3.5484385271315317`*^9}, 3.548438559517189*^9, {
   3.5484386721025867`*^9, 3.548438711539456*^9}, {3.548438834077671*^9, 
   3.5484388426888866`*^9}, 3.54843887293734*^9, {3.5484389443074646`*^9, 
   3.5484389527626796`*^9}, 3.54843906107367*^9, 3.5484390990909367`*^9, {
   3.5484391301817913`*^9, 3.5484391618810472`*^9}, {3.548439235965577*^9, 
   3.548439238243181*^9}, {3.548522484301733*^9, 3.5485226761820703`*^9}, 
   3.5485227731206408`*^9, {3.5487713741413865`*^9, 3.5487714149842587`*^9}, {
   3.54877151806924*^9, 3.54877154086088*^9}, {3.5487719300523643`*^9, 
   3.548771981906855*^9}, {3.5490422461683207`*^9, 3.5490422720643663`*^9}, {
   3.549042356398114*^9, 3.549042358613318*^9}, {3.549042496132761*^9, 
   3.549042497583564*^9}, {3.5490425458188486`*^9, 3.549042591448929*^9}, {
   3.5490431102766404`*^9, 3.5490431324910793`*^9}, 3.5490432759489317`*^9, 
   3.5490433380370407`*^9, {3.5490435506966143`*^9, 3.5490435587774277`*^9}, {
   3.549043619055934*^9, 3.5490436199919357`*^9}, {3.54904369075366*^9, 
   3.5490436938580656`*^9}, 3.549489860665391*^9, {3.5494899950440273`*^9, 
   3.5494900364309*^9}, {3.5494920566188483`*^9, 3.5494920572740493`*^9}, {
   3.54949209199971*^9, 3.5494920925925117`*^9}, {3.5494922452855797`*^9, 
   3.5494922895584574`*^9}, {3.549492648078287*^9, 3.54949267823314*^9}, {
   3.549570556707936*^9, 3.5495705626359463`*^9}, {3.549570595021603*^9, 
   3.5495706010900135`*^9}, 3.5495706692309337`*^9, {3.5495711691650114`*^9, 
   3.5495711873390436`*^9}, 3.549571255932364*^9, {3.549571311718062*^9, 
   3.549571355398139*^9}, {3.5496348238725996`*^9, 3.5496348324370146`*^9}, {
   3.549635016813739*^9, 3.549635024473352*^9}, {3.5496350764682436`*^9, 
   3.549635082661454*^9}, {3.549635135077546*^9, 3.549635169475607*^9}, 
   3.5496352570073605`*^9, {3.5496354655329266`*^9, 3.5496355133470106`*^9}, {
   3.549635707192951*^9, 3.549635733307397*^9}, 3.549636997081217*^9, {
   3.549637058623325*^9, 3.5496370851433716`*^9}, {3.5496371589939013`*^9, 
   3.549637168494318*^9}, {3.5496374722112513`*^9, 3.5496374729600525`*^9}, {
   3.5496376869768286`*^9, 3.549637689270033*^9}, {3.549637751623342*^9, 
   3.549637770343375*^9}, {3.549638330587159*^9, 3.549638583647204*^9}, 
   3.549638641320505*^9, {3.5496480244817457`*^9, 3.549648046087784*^9}, {
   3.5496481182535105`*^9, 3.549648155553176*^9}, {3.5496481886096334`*^9, 
   3.5496481957232466`*^9}, {3.549648225753299*^9, 3.549648256017352*^9}, {
   3.5496482886370096`*^9, 3.549648300820631*^9}, {3.5496484007856064`*^9, 
   3.5496484595197096`*^9}, {3.54964849373057*^9, 3.549648498348178*^9}, {
   3.5496485926035433`*^9, 3.5496485968467507`*^9}, {3.549648963728195*^9, 
   3.5496489666142006`*^9}, {3.5496491073420477`*^9, 
   3.5496491153448615`*^9}, {3.549649213032233*^9, 3.5496492456206903`*^9}, {
   3.5496493848429356`*^9, 3.5496494053413715`*^9}, 3.5496495105479565`*^9, 
   3.549649583306484*^9, {3.5496496777178497`*^9, 3.549649680525855*^9}, {
   3.549649735718752*^9, 3.5496497579955907`*^9}, 3.5496498524693565`*^9, 
   3.5496498862902164`*^9, 3.5496553811468678`*^9, {3.549655412736923*^9, 
   3.549655429631753*^9}, {3.549655466182617*^9, 3.549655507179489*^9}, 
   3.5496555443075542`*^9, {3.549655595896845*^9, 3.549655601060454*^9}, {
   3.562091356752223*^9, 3.5620915759170074`*^9}, 3.562091709390842*^9, {
   3.5620918280602503`*^9, 3.5620918320850573`*^9}, {3.5620919174016075`*^9, 
   3.5620919603952827`*^9}, {3.562092199762103*^9, 3.5620922398385735`*^9}, {
   3.562092274533035*^9, 3.5620923285247297`*^9}, {3.5620924382553225`*^9, 
   3.562092511793852*^9}, {3.562092577407567*^9, 3.562092582009575*^9}, {
   3.562092623318447*^9, 3.562092627234054*^9}, {3.5620926805393476`*^9, 
   3.562092766448699*^9}, {3.562092869174879*^9, 3.562092962010642*^9}, {
   3.562093021540347*^9, 3.562093068168829*^9}, {3.5620931602401905`*^9, 
   3.562093341075708*^9}, {3.5620933743193665`*^9, 3.5620933812301784`*^9}, {
   3.5620934307602654`*^9, 3.5620934700411344`*^9}, {3.562093511818008*^9, 
   3.562093562471297*^9}, {3.562093601112565*^9, 3.5620936050281715`*^9}, {
   3.5620936625766726`*^9, 3.5620941391887097`*^9}, {3.5620941987184143`*^9, 
   3.562094238826085*^9}, {3.5620947570589952`*^9, 3.5620948176339016`*^9}, {
   3.5620948602375765`*^9, 3.5620948767736053`*^9}, {3.562094917240076*^9, 
   3.562094990263805*^9}, 3.5620980075899043`*^9, {3.5620980503495793`*^9, 
   3.562098094466457*^9}, {3.562098142670542*^9, 3.562098287516796*^9}, 
   3.5620983227728577`*^9, {3.5620983726617455`*^9, 3.562098372833346*^9}, {
   3.562098822990937*^9, 3.562098903892679*^9}, {3.5620989757776055`*^9, 
   3.5620989877584267`*^9}, {3.5620991083934383`*^9, 3.562099127565872*^9}, {
   3.562099173882354*^9, 3.56209943975362*^9}, {3.5621583498070045`*^9, 
   3.562158394984684*^9}, {3.5621585445265465`*^9, 3.5621586150230703`*^9}, {
   3.562158652338336*^9, 3.5621587503221083`*^9}, {3.562158807262208*^9, 
   3.562158875995929*^9}, {3.5621589394412403`*^9, 3.562159007145359*^9}, {
   3.5621591481696067`*^9, 3.5621591503848104`*^9}, {3.562159196311291*^9, 
   3.562159196607692*^9}, {3.562159251394988*^9, 3.5621592555289955`*^9}, {
   3.562159288320253*^9, 3.562159397161644*^9}, {3.5621594286892996`*^9, 
   3.5621595106986437`*^9}, {3.562159602473605*^9, 3.562159643470477*^9}, {
   3.562159702906581*^9, 3.562159751219866*^9}, {3.5621597829659214`*^9, 
   3.5621598318876076`*^9}, {3.56215995286582*^9, 3.562160113858103*^9}, {
   3.5621602978448257`*^9, 3.5621607866560845`*^9}, {3.562160927368332*^9, 
   3.5621609811884265`*^9}, {3.5621610683613796`*^9, 
   3.5621611490915213`*^9}, {3.5621612865745625`*^9, 3.562161311129006*^9}, {
   3.5621613577106876`*^9, 3.5621613650583005`*^9}, {3.5621614180671935`*^9, 
   3.5621614324348187`*^9}, {3.5621615463930187`*^9, 3.56216157525307*^9}, {
   3.5621616178723445`*^9, 3.5621616240811553`*^9}, {3.562161662488423*^9, 
   3.562161662597623*^9}, {3.564767746948951*^9, 3.5647677472921515`*^9}, {
   3.5847162105889177`*^9, 3.584716234588951*^9}, 3.5847162678589983`*^9},
 FontFamily->"Courier New",
 FontColor->GrayLevel[0]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphics", "Section",
 CellChangeTimes->{{3.5847162704490013`*^9, 3.5847162758590093`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", "Graphics", " ", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"xyplane", " ", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.8", "]"}], ",", 
         RowBox[{"Opacity", "[", "0.8", "]"}], ",", 
         RowBox[{"Polygon", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1.5"}], ",", 
              RowBox[{"-", "1.5"}], ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1.5", ",", 
              RowBox[{"-", "1.5"}], ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1.5", ",", "1.5", ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1.5"}], ",", "1.5", ",", "0"}], "}"}]}], "}"}], 
          "]"}]}], "}"}], ",", 
       RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotzaxis", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0.0", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"Tube", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", "1.2"}], "}"}]}], "}"}], ",", 
            "0.02"}], "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<Initial point set \>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"start", "=", " ", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "startsize", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"points3d", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"origplot", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"xyplane", ",", " ", "plotzaxis", ",", "start", ",", 
      RowBox[{"Graphics3D", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PointSize", "[", "Large", "]"}], ",", 
         RowBox[{"Point", "[", "points3d", "]"}]}], "}"}], "]"}], ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
      RowBox[{"ViewPoint", "\[Rule]", "vp"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<Apply V^T \>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"startvv", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "startsize", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"vvpoints3d", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"plotvvpoints", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"xyplane", ",", " ", "plotzaxis", ",", "startvv", ",", 
      RowBox[{"Graphics3D", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PointSize", "[", "Large", "]"}], ",", 
         RowBox[{"Point", "[", "vvpoints3d", "]"}]}], "}"}], "]"}], ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
      RowBox[{"ViewPoint", "\[Rule]", "vp"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", "\"\<Apply SV^T \>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"startssvv", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "startsize", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"ssvvpoints3d", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"plotssvvpoints", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"xyplane", ",", " ", "plotzaxis", ",", "startssvv", ",", 
      RowBox[{"Graphics3D", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PointSize", "[", "Large", "]"}], ",", 
         RowBox[{"Point", "[", "ssvvpoints3d", "]"}]}], "}"}], "]"}], ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
      RowBox[{"ViewPoint", "\[Rule]", "vp"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", 
     "\"\<Apply USV^T -- illustrates action of input matrix \>\"", "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"startuussvv", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "startsize", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"uussvvpoints3d", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"plotuussvvpoints", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"xyplane", ",", " ", "plotzaxis", ",", "startuussvv", ",", 
      RowBox[{"Graphics3D", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PointSize", "[", "Large", "]"}], ",", 
         RowBox[{"Point", "[", "uussvvpoints3d", "]"}]}], "}"}], "]"}], ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
      RowBox[{"ViewPoint", "\[Rule]", "vp"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Just", " ", "checking", " ", "that", " ", "direct", " ", "mat", " ", 
     "multiply", " ", "give", " ", "same", " ", "geometry"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "Print", "[", 
     "\"\<Directly apply matrix to point set to check if result the same \
\>\"", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"startmat", "=", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"PointSize", "[", "startsize", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{"matpoints3d", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"plotfinalpoints", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"xyplane", ",", " ", "plotzaxis", ",", 
      RowBox[{"Graphics3D", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"PointSize", "[", "Large", "]"}], ",", 
         RowBox[{"Point", "[", "matpoints3d", "]"}]}], "}"}], "]"}], ",", 
      "startmat", ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
      RowBox[{"ViewPoint", "\[Rule]", "vp"}]}], "]"}]}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5190613970788293`*^9, 3.519061397749631*^9}, {
   3.519061432022891*^9, 3.5190614624429445`*^9}, {3.519061514905836*^9, 
   3.519061628240035*^9}, {3.519061759373866*^9, 3.5190617744122925`*^9}, {
   3.5190618332711954`*^9, 3.519061929601365*^9}, {3.51906205786479*^9, 
   3.5190620650876026`*^9}, 3.5190621108268833`*^9, {3.5190622884799953`*^9, 
   3.519062320350851*^9}, {3.519062521918805*^9, 3.5190626326165996`*^9}, {
   3.5190628193333273`*^9, 3.519062819380128*^9}, 3.519062858848197*^9, {
   3.5190637725290017`*^9, 3.519063787505028*^9}, 3.519064197458148*^9, {
   3.5190648424412813`*^9, 3.519064859632511*^9}, {3.519065093601722*^9, 
   3.5190651249109774`*^9}, {3.519143584891322*^9, 3.519143618134981*^9}, {
   3.5191436705822725`*^9, 3.519143684029496*^9}, {3.5191564974679966`*^9, 
   3.5191565115080214`*^9}, 3.5191687775763645`*^9, {3.5193183416584096`*^9, 
   3.51931846709823*^9}, 3.519318600363664*^9, {3.519318688550619*^9, 
   3.5193187098134565`*^9}, {3.519318801682018*^9, 3.5193188481232996`*^9}, {
   3.519318923799032*^9, 3.5193189293682423`*^9}, {3.5193190014403687`*^9, 
   3.519319022781206*^9}, {3.519319175864275*^9, 3.5193191785006795`*^9}, {
   3.519319310882512*^9, 3.5193193555765905`*^9}, {3.519319442172343*^9, 
   3.519319565287759*^9}, {3.5193198098493886`*^9, 3.519319841985445*^9}, 
   3.5193199527144394`*^9, 3.519320062320232*^9, 3.5193201753736305`*^9, 
   3.5193203564431486`*^9, {3.5193290189839635`*^9, 3.5193290317447863`*^9}, {
   3.519331648326182*^9, 3.519331738915541*^9}, {3.5193317714883986`*^9, 
   3.519331836524913*^9}, {3.519331911748245*^9, 3.5193319703887477`*^9}, {
   3.519332003850806*^9, 3.5193320128052225`*^9}, {3.5193320585133023`*^9, 
   3.519332077030535*^9}, {3.519332153501869*^9, 3.5193321795851154`*^9}, {
   3.519332252250043*^9, 3.5193322645272646`*^9}, {3.5193322952749186`*^9, 
   3.5193323228869667`*^9}, {3.5193324053487115`*^9, 
   3.5193324341619625`*^9}, {3.5193324710560274`*^9, 
   3.5193324897448597`*^9}, {3.5193325345949388`*^9, 3.519332573875808*^9}, {
   3.5193326105514717`*^9, 3.519332617306284*^9}, {3.5193326927480164`*^9, 
   3.519332779094168*^9}, {3.5193329731585093`*^9, 3.51933318466368*^9}, {
   3.5193333259219284`*^9, 3.5193333573559837`*^9}, 3.5193334441701365`*^9, 
   3.519333573806364*^9, {3.5193336196236444`*^9, 3.519333700915387*^9}, {
   3.5193338052015705`*^9, 3.519333805575971*^9}, {3.519336424716172*^9, 
   3.519336584819253*^9}, {3.51933662859293*^9, 3.5193366396221495`*^9}, {
   3.5193374015586877`*^9, 3.5193374062854958`*^9}, {3.5193377748885436`*^9, 
   3.51933777852335*^9}, {3.5193378293794394`*^9, 3.51933788112473*^9}, {
   3.5193379688748846`*^9, 3.5193379927897263`*^9}, {3.519393659487196*^9, 
   3.5193937240620933`*^9}, 3.5193995276423693`*^9, {3.519399560262027*^9, 
   3.5193995687172413`*^9}, 3.519399607062109*^9, {3.519743189247101*^9, 
   3.519743197296715*^9}, {3.519822556574108*^9, 3.5198225643117213`*^9}, {
   3.519822615635812*^9, 3.5198226456502647`*^9}, {3.519822681327527*^9, 
   3.5198226840575314`*^9}, {3.5198227249296036`*^9, 3.519822727909209*^9}, {
   3.5198230136237106`*^9, 3.5198230640585995`*^9}, {3.5199394713775268`*^9, 
   3.519939474435132*^9}, {3.5209457136282034`*^9, 3.5209457316306353`*^9}, {
   3.521233019052727*^9, 3.5212330195363283`*^9}, {3.521824157577416*^9, 
   3.5218241913514752`*^9}, {3.5218242354839525`*^9, 
   3.5218242371531553`*^9}, {3.521824777014904*^9, 3.521824780977311*^9}, {
   3.521824881659888*^9, 3.5218248945143104`*^9}, {3.522546096219933*^9, 
   3.522546118446204*^9}, {3.522546164829857*^9, 3.5225461846399903`*^9}, {
   3.5480827780275407`*^9, 3.548083073180059*^9}, {3.5480844465048714`*^9, 
   3.548084447799674*^9}, 3.548084490465749*^9, {3.548084523725007*^9, 
   3.5480845255190105`*^9}, {3.5480846736100707`*^9, 
   3.5480847132965403`*^9}, {3.5480850595079484`*^9, 3.548085176601754*^9}, {
   3.5480852081762094`*^9, 3.548085220968232*^9}, 3.5480852876959496`*^9, {
   3.5480853452912507`*^9, 3.548085345416051*^9}, {3.5480854601230526`*^9, 
   3.548085504957531*^9}, {3.54808669421002*^9, 3.5480867052080393`*^9}, 
   3.5480869024859858`*^9, {3.5480873606119905`*^9, 3.5480873616259923`*^9}, {
   3.5481089290239763`*^9, 3.5481089295387774`*^9}, {3.5481090731058297`*^9, 
   3.5481091125270987`*^9}, {3.54810921548728*^9, 3.5481092677161713`*^9}, {
   3.5481093308494825`*^9, 3.54810947777054*^9}, {3.5481095113105993`*^9, 
   3.5481095348666406`*^9}, {3.548255560709408*^9, 3.548255637461543*^9}, {
   3.548255675385209*^9, 3.54825568700723*^9}, {3.548255737161318*^9, 
   3.5482557378165193`*^9}, {3.548255813897853*^9, 3.548255849465915*^9}, {
   3.548265318518547*^9, 3.54826532014095*^9}, {3.5482654408071623`*^9, 
   3.5482654469691725`*^9}, {3.5482655240957084`*^9, 3.548265530054919*^9}, {
   3.548265648131526*^9, 3.548265660642748*^9}, {3.548265763743329*^9, 
   3.5482658059570036`*^9}, 3.5482660708142686`*^9, {3.548266109892337*^9, 
   3.5482661181291513`*^9}, {3.548266190653679*^9, 3.548266220886532*^9}, {
   3.5482665984383955`*^9, 3.548266647469281*^9}, {3.548266688247753*^9, 
   3.5482666925221605`*^9}, {3.548266762925084*^9, 3.5482667724099007`*^9}, {
   3.5482668726868773`*^9, 3.5482668940277147`*^9}, {3.5482669350245867`*^9, 
   3.54826695400982*^9}, {3.5482670699492235`*^9, 3.5482670787320385`*^9}, {
   3.548267132645734*^9, 3.5482671855142264`*^9}, {3.548267237665118*^9, 
   3.5482672647935658`*^9}, {3.548278236511236*^9, 3.5482782735925016`*^9}, {
   3.548278327256596*^9, 3.548278376802283*^9}, {3.5482785724890265`*^9, 
   3.548278578339037*^9}, {3.5482792414338017`*^9, 3.548279284864278*^9}, {
   3.5482793450959835`*^9, 3.548279353972399*^9}, {3.5482795652435703`*^9, 
   3.548279619921666*^9}, {3.548279773441536*^9, 3.5482797903051653`*^9}, {
   3.5482799098637753`*^9, 3.5482799507982473`*^9}, {3.5482800398588037`*^9, 
   3.548280046457616*^9}, {3.5482800767216682`*^9, 3.5482801276869583`*^9}, {
   3.5482803327805185`*^9, 3.548280371484186*^9}, {3.548280417441867*^9, 
   3.5482804279406853`*^9}, {3.548280494927203*^9, 3.54828054439489*^9}, {
   3.54828076624288*^9, 3.5482807778649*^9}, {3.54828122190408*^9, 
   3.5482813009182186`*^9}, 3.54828184769798*^9, {3.54828201277747*^9, 
   3.548282015523075*^9}, {3.5482820824627924`*^9, 3.5482820899040055`*^9}, 
   3.5482825476876197`*^9, {3.548282600821313*^9, 3.548282669102633*^9}, {
   3.5482827161211157`*^9, 3.548282763732399*^9}, {3.5482831379926567`*^9, 
   3.5482831926395526`*^9}, 3.548283229252817*^9, {3.5482832677224846`*^9, 
   3.5482832685804863`*^9}, {3.548337660164831*^9, 3.548337707885315*^9}, {
   3.5483378432467527`*^9, 3.5483378914976377`*^9}, {3.5483379306537066`*^9, 
   3.5483380219918666`*^9}, {3.5483383681252747`*^9, 
   3.5483384772006664`*^9}, {3.548338688097437*^9, 3.548338694181447*^9}, {
   3.5483387278775063`*^9, 3.54833873013951*^9}, 3.5483387632739687`*^9, {
   3.5483388024612374`*^9, 3.5483388390277014`*^9}, {3.548338931021063*^9, 
   3.5483389755279417`*^9}, {3.5483391622914696`*^9, 3.548339174412691*^9}, 
   3.548339235034397*^9, 3.5483395307173166`*^9, {3.5483403647727814`*^9, 
   3.5483403955048356`*^9}, {3.548364491181573*^9, 3.5483645678869076`*^9}, {
   3.548364623485405*^9, 3.5483646334070225`*^9}, {3.548364838016982*^9, 
   3.548364941538764*^9}, {3.548365010038484*^9, 3.54836506468538*^9}, {
   3.548365883702419*^9, 3.548365945525327*^9}, {3.5483659788781857`*^9, 
   3.5483659942130127`*^9}, {3.548366118607631*^9, 3.5483661200584335`*^9}, {
   3.548366160805705*^9, 3.548366169697721*^9}, {3.548366210023792*^9, 
   3.5483662558254724`*^9}, {3.548366303873557*^9, 3.5483663061043606`*^9}, {
   3.5483663402684207`*^9, 3.548366353544044*^9}, {3.5483663939637146`*^9, 
   3.548366438626593*^9}, {3.548426002981133*^9, 3.5484260441496053`*^9}, {
   3.548426218152311*^9, 3.548426330815709*^9}, {3.548426366836172*^9, 
   3.548426368957776*^9}, {3.5484265945809717`*^9, 3.548426731159212*^9}, 
   3.5484267672888756`*^9, {3.548426847566616*^9, 3.548426850062621*^9}, 
   3.548426916175537*^9, {3.548426966095625*^9, 3.5484269677492275`*^9}, {
   3.5484292280311985`*^9, 3.548429290446908*^9}, {3.548429320820162*^9, 
   3.5484295570201764`*^9}, {3.548429587112629*^9, 3.5484298194750376`*^9}, {
   3.5484344974260545`*^9, 3.548434522713699*^9}, {3.548434880188327*^9, 
   3.54843488232553*^9}, {3.5484349317776175`*^9, 3.548434953321255*^9}, {
   3.5484351235175543`*^9, 3.548435150833202*^9}, {3.5484351972588835`*^9, 
   3.54843521789772*^9}, 3.5484352564297876`*^9, {3.5484353248671074`*^9, 
   3.5484353811832066`*^9}, {3.5484354363605037`*^9, 
   3.5484354375461054`*^9}, {3.5484354942834053`*^9, 3.54843559367118*^9}, {
   3.548435695242958*^9, 3.5484358725996695`*^9}, {3.548435910258136*^9, 
   3.5484359121301394`*^9}, {3.548436201432647*^9, 3.5484362033982506`*^9}, {
   3.548436286452797*^9, 3.5484364403002667`*^9}, 3.548436500843973*^9, 
   3.54843653889244*^9, {3.548436585848522*^9, 3.548436642539022*^9}, {
   3.548436704954732*^9, 3.54843677804086*^9}, 3.5484369444931526`*^9, {
   3.5484370203872857`*^9, 3.54843702255569*^9}, {3.5484370660797663`*^9, 
   3.5484370777641864`*^9}, {3.548437110274644*^9, 3.5484372383352685`*^9}, {
   3.5484373881735315`*^9, 3.5484375229577684`*^9}, {3.5484376009267054`*^9, 
   3.548437604795512*^9}, {3.5484376442011814`*^9, 3.5484376638104157`*^9}, 
   3.5484376978184757`*^9, {3.548437819607889*^9, 3.548437887670809*^9}, 
   3.5484381060087924`*^9, {3.548438191746543*^9, 3.5484382289994087`*^9}, {
   3.5484383503832216`*^9, 3.5484385271315317`*^9}, 3.548438559517189*^9, {
   3.5484386721025867`*^9, 3.548438711539456*^9}, {3.548438834077671*^9, 
   3.5484388426888866`*^9}, 3.54843887293734*^9, {3.5484389443074646`*^9, 
   3.5484389527626796`*^9}, 3.54843906107367*^9, 3.5484390990909367`*^9, {
   3.5484391301817913`*^9, 3.5484391618810472`*^9}, {3.548439235965577*^9, 
   3.548439238243181*^9}, {3.548522484301733*^9, 3.5485226761820703`*^9}, 
   3.5485227731206408`*^9, {3.5487713741413865`*^9, 3.5487714149842587`*^9}, {
   3.54877151806924*^9, 3.54877154086088*^9}, {3.5487719300523643`*^9, 
   3.548771981906855*^9}, {3.5490422461683207`*^9, 3.5490422720643663`*^9}, {
   3.549042356398114*^9, 3.549042358613318*^9}, {3.549042496132761*^9, 
   3.549042497583564*^9}, {3.5490425458188486`*^9, 3.549042591448929*^9}, {
   3.5490431102766404`*^9, 3.5490431324910793`*^9}, 3.5490432759489317`*^9, 
   3.5490433380370407`*^9, {3.5490435506966143`*^9, 3.5490435587774277`*^9}, {
   3.549043619055934*^9, 3.5490436199919357`*^9}, {3.54904369075366*^9, 
   3.5490436938580656`*^9}, 3.549489860665391*^9, {3.5494899950440273`*^9, 
   3.5494900364309*^9}, {3.5494920566188483`*^9, 3.5494920572740493`*^9}, {
   3.54949209199971*^9, 3.5494920925925117`*^9}, {3.5494922452855797`*^9, 
   3.5494922895584574`*^9}, {3.549492648078287*^9, 3.54949267823314*^9}, {
   3.549570556707936*^9, 3.5495705626359463`*^9}, {3.549570595021603*^9, 
   3.5495706010900135`*^9}, 3.5495706692309337`*^9, {3.5495711691650114`*^9, 
   3.5495711873390436`*^9}, 3.549571255932364*^9, {3.549571311718062*^9, 
   3.549571355398139*^9}, {3.5496348238725996`*^9, 3.5496348324370146`*^9}, {
   3.549635016813739*^9, 3.549635024473352*^9}, {3.5496350764682436`*^9, 
   3.549635082661454*^9}, {3.549635135077546*^9, 3.549635169475607*^9}, 
   3.5496352570073605`*^9, {3.5496354655329266`*^9, 3.5496355133470106`*^9}, {
   3.549635707192951*^9, 3.549635733307397*^9}, 3.549636997081217*^9, {
   3.549637058623325*^9, 3.5496370851433716`*^9}, {3.5496371589939013`*^9, 
   3.549637168494318*^9}, {3.5496374722112513`*^9, 3.5496374729600525`*^9}, {
   3.5496376869768286`*^9, 3.549637689270033*^9}, {3.549637751623342*^9, 
   3.549637770343375*^9}, {3.549638330587159*^9, 3.549638583647204*^9}, 
   3.549638641320505*^9, {3.5496480244817457`*^9, 3.549648046087784*^9}, {
   3.5496481182535105`*^9, 3.549648155553176*^9}, {3.5496481886096334`*^9, 
   3.5496481957232466`*^9}, {3.549648225753299*^9, 3.549648256017352*^9}, {
   3.5496482886370096`*^9, 3.549648300820631*^9}, {3.5496484007856064`*^9, 
   3.5496484595197096`*^9}, {3.54964849373057*^9, 3.549648498348178*^9}, {
   3.5496485926035433`*^9, 3.5496485968467507`*^9}, {3.549648963728195*^9, 
   3.5496489666142006`*^9}, {3.5496491073420477`*^9, 
   3.5496491153448615`*^9}, {3.549649213032233*^9, 3.5496492456206903`*^9}, {
   3.5496493848429356`*^9, 3.5496494053413715`*^9}, 3.5496495105479565`*^9, 
   3.549649583306484*^9, {3.5496496777178497`*^9, 3.549649680525855*^9}, {
   3.549649735718752*^9, 3.5496497579955907`*^9}, 3.5496498524693565`*^9, 
   3.5496498862902164`*^9, 3.5496553811468678`*^9, {3.549655412736923*^9, 
   3.549655429631753*^9}, {3.549655466182617*^9, 3.549655507179489*^9}, 
   3.5496555443075542`*^9, {3.549655595896845*^9, 3.549655601060454*^9}, {
   3.562091356752223*^9, 3.5620915759170074`*^9}, 3.562091709390842*^9, {
   3.5620918280602503`*^9, 3.5620918320850573`*^9}, {3.5620919174016075`*^9, 
   3.5620919603952827`*^9}, {3.562092199762103*^9, 3.5620922398385735`*^9}, {
   3.562092274533035*^9, 3.5620923285247297`*^9}, {3.5620924382553225`*^9, 
   3.562092511793852*^9}, {3.562092577407567*^9, 3.562092582009575*^9}, {
   3.562092623318447*^9, 3.562092627234054*^9}, {3.5620926805393476`*^9, 
   3.562092766448699*^9}, {3.562092869174879*^9, 3.562092962010642*^9}, {
   3.562093021540347*^9, 3.562093068168829*^9}, {3.5620931602401905`*^9, 
   3.562093341075708*^9}, {3.5620933743193665`*^9, 3.5620933812301784`*^9}, {
   3.5620934307602654`*^9, 3.5620934700411344`*^9}, {3.562093511818008*^9, 
   3.562093562471297*^9}, {3.562093601112565*^9, 3.5620936050281715`*^9}, {
   3.5620936625766726`*^9, 3.5620941391887097`*^9}, {3.5620941987184143`*^9, 
   3.562094238826085*^9}, {3.5620947570589952`*^9, 3.5620948176339016`*^9}, {
   3.5620948602375765`*^9, 3.5620948767736053`*^9}, {3.562094917240076*^9, 
   3.562094990263805*^9}, 3.5620980075899043`*^9, {3.5620980503495793`*^9, 
   3.562098094466457*^9}, {3.562098142670542*^9, 3.562098287516796*^9}, 
   3.5620983227728577`*^9, {3.5620983726617455`*^9, 3.562098372833346*^9}, {
   3.562098822990937*^9, 3.562098903892679*^9}, {3.5620989757776055`*^9, 
   3.5620989877584267`*^9}, {3.5620991083934383`*^9, 3.562099127565872*^9}, {
   3.562099173882354*^9, 3.56209943975362*^9}, {3.5621583498070045`*^9, 
   3.562158394984684*^9}, {3.5621585445265465`*^9, 3.5621586150230703`*^9}, {
   3.562158652338336*^9, 3.5621587503221083`*^9}, {3.562158807262208*^9, 
   3.562158875995929*^9}, {3.5621589394412403`*^9, 3.562159007145359*^9}, {
   3.5621591481696067`*^9, 3.5621591503848104`*^9}, {3.562159196311291*^9, 
   3.562159196607692*^9}, {3.562159251394988*^9, 3.5621592555289955`*^9}, {
   3.562159288320253*^9, 3.562159397161644*^9}, {3.5621594286892996`*^9, 
   3.5621595106986437`*^9}, {3.562159602473605*^9, 3.562159643470477*^9}, {
   3.562159702906581*^9, 3.562159751219866*^9}, {3.5621597829659214`*^9, 
   3.5621598318876076`*^9}, {3.56215995286582*^9, 3.562160113858103*^9}, {
   3.5621602978448257`*^9, 3.5621607866560845`*^9}, {3.562160927368332*^9, 
   3.5621609811884265`*^9}, {3.5621610683613796`*^9, 
   3.5621611490915213`*^9}, {3.5621612865745625`*^9, 3.562161311129006*^9}, {
   3.5621613577106876`*^9, 3.5621613650583005`*^9}, {3.5621614180671935`*^9, 
   3.5621614324348187`*^9}, {3.5621615463930187`*^9, 3.56216157525307*^9}, {
   3.5621616178723445`*^9, 3.5621616240811553`*^9}, {3.562161662488423*^9, 
   3.562161662597623*^9}, {3.564767746948951*^9, 3.5647677472921515`*^9}, {
   3.5847162105889177`*^9, 3.584716234588951*^9}, 3.5847162678589983`*^9},
 FontFamily->"Courier New",
 FontColor->GrayLevel[0]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Dimension mat =\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], 
   "\[InvisibleSpace]", "\<\"  Dim vvt = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], "\[InvisibleSpace]", "\<\"  Dim ss= \"\>",
    "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], "\[InvisibleSpace]", "\<\"  dimuu = \"\>",
    "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}],
  SequenceForm[
  "Dimension mat =", {2, 2}, "  Dim vvt = ", {2, 2}, "  Dim ss= ", {2, 2}, 
   "  dimuu = ", {2, 2}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5620927459658628`*^9, 3.562092803561164*^9, 3.5620930509463987`*^9, 
   3.5620931895838423`*^9, 3.5620933970798063`*^9, 3.562093436797476*^9, {
   3.562093540990059*^9, 3.5620935635944986`*^9}, 3.562093606151374*^9, 
   3.5620939095875063`*^9, 3.562093948010374*^9, 3.5620940950718327`*^9, 
   3.562094245253296*^9, 3.5620980968376613`*^9, 3.5620981563829656`*^9, 
   3.5620982900440006`*^9, 3.562098325003662*^9, 3.5620983754385505`*^9, {
   3.5620988868730497`*^9, 3.562098904969081*^9}, {3.5620989769008074`*^9, 
   3.5620989890688286`*^9}, 3.562099088659404*^9, 3.5620992560632977`*^9, 
   3.562099305328184*^9, 3.562099336668639*^9, 3.562099441064023*^9, 
   3.562157276885518*^9, 3.5621586936160083`*^9, 3.5621598402492228`*^9, 
   3.562160794705699*^9, 3.5621609824676285`*^9, {3.562161130917489*^9, 
   3.5621611505423236`*^9}, 3.562161312923009*^9, 3.562161434400422*^9, 
   3.562161491574523*^9, 3.5621615769066725`*^9, 3.5621616250795574`*^9, 
   3.562161663674025*^9, 3.5647677507865577`*^9, 3.584716187368885*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"uu,ss,vv: \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.9238795325112867`", 
        RowBox[{"-", "0.38268343236508984`"}]},
       {"0.3826834323650898`", "0.9238795325112867`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"2.414213562373095`", "0.`"},
       {"0.`", "0.4142135623730948`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\", \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.38268343236508984`", 
        RowBox[{"-", "0.9238795325112867`"}]},
       {"0.9238795325112867`", "0.3826834323650898`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["uu,ss,vv: ", 
   MatrixForm[{{0.9238795325112867, -0.38268343236508984`}, {
    0.3826834323650898, 0.9238795325112867}}], ", ", 
   MatrixForm[{{2.414213562373095, 0.}, {0., 0.4142135623730948}}], ", ", 
   MatrixForm[{{0.38268343236508984`, -0.9238795325112867}, {
    0.9238795325112867, 0.3826834323650898}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5620927459658628`*^9, 3.562092803561164*^9, 3.5620930509463987`*^9, 
   3.5620931895838423`*^9, 3.5620933970798063`*^9, 3.562093436797476*^9, {
   3.562093540990059*^9, 3.5620935635944986`*^9}, 3.562093606151374*^9, 
   3.5620939095875063`*^9, 3.562093948010374*^9, 3.5620940950718327`*^9, 
   3.562094245253296*^9, 3.5620980968376613`*^9, 3.5620981563829656`*^9, 
   3.5620982900440006`*^9, 3.562098325003662*^9, 3.5620983754385505`*^9, {
   3.5620988868730497`*^9, 3.562098904969081*^9}, {3.5620989769008074`*^9, 
   3.5620989890688286`*^9}, 3.562099088659404*^9, 3.5620992560632977`*^9, 
   3.562099305328184*^9, 3.562099336668639*^9, 3.562099441064023*^9, 
   3.562157276885518*^9, 3.5621586936160083`*^9, 3.5621598402492228`*^9, 
   3.562160794705699*^9, 3.5621609824676285`*^9, {3.562161130917489*^9, 
   3.5621611505423236`*^9}, 3.562161312923009*^9, 3.562161434400422*^9, 
   3.562161491574523*^9, 3.5621615769066725`*^9, 3.5621616250795574`*^9, 
   3.562161663674025*^9, 3.5647677507865577`*^9, 3.584716187368885*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"uu.ss.vv^T: \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.0000000000000002`", "1.9999999999999998`"},
       {"2.7755575615628914`*^-16", "0.9999999999999999`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "\[InvisibleSpace]", "\<\"   mat: \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1.`", "2.`"},
       {"0.`", "1.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["uu.ss.vv^T: ", 
   MatrixForm[{{1.0000000000000002`, 1.9999999999999998`}, {
    2.7755575615628914`*^-16, 0.9999999999999999}}], "   mat: ", 
   MatrixForm[{{1., 2.}, {0., 1.}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5620927459658628`*^9, 3.562092803561164*^9, 3.5620930509463987`*^9, 
   3.5620931895838423`*^9, 3.5620933970798063`*^9, 3.562093436797476*^9, {
   3.562093540990059*^9, 3.5620935635944986`*^9}, 3.562093606151374*^9, 
   3.5620939095875063`*^9, 3.562093948010374*^9, 3.5620940950718327`*^9, 
   3.562094245253296*^9, 3.5620980968376613`*^9, 3.5620981563829656`*^9, 
   3.5620982900440006`*^9, 3.562098325003662*^9, 3.5620983754385505`*^9, {
   3.5620988868730497`*^9, 3.562098904969081*^9}, {3.5620989769008074`*^9, 
   3.5620989890688286`*^9}, 3.562099088659404*^9, 3.5620992560632977`*^9, 
   3.562099305328184*^9, 3.562099336668639*^9, 3.562099441064023*^9, 
   3.562157276885518*^9, 3.5621586936160083`*^9, 3.5621598402492228`*^9, 
   3.562160794705699*^9, 3.5621609824676285`*^9, {3.562161130917489*^9, 
   3.5621611505423236`*^9}, 3.562161312923009*^9, 3.562161434400422*^9, 
   3.562161491574523*^9, 3.5621615769066725`*^9, 3.5621616250795574`*^9, 
   3.562161663674025*^9, 3.5647677507865577`*^9, 3.5847161873788853`*^9}],

Cell[BoxData["\<\"Initial point set \"\>"], "Print",
 CellChangeTimes->{
  3.5620927459658628`*^9, 3.562092803561164*^9, 3.5620930509463987`*^9, 
   3.5620931895838423`*^9, 3.5620933970798063`*^9, 3.562093436797476*^9, {
   3.562093540990059*^9, 3.5620935635944986`*^9}, 3.562093606151374*^9, 
   3.5620939095875063`*^9, 3.562093948010374*^9, 3.5620940950718327`*^9, 
   3.562094245253296*^9, 3.5620980968376613`*^9, 3.5620981563829656`*^9, 
   3.5620982900440006`*^9, 3.562098325003662*^9, 3.5620983754385505`*^9, {
   3.5620988868730497`*^9, 3.562098904969081*^9}, {3.5620989769008074`*^9, 
   3.5620989890688286`*^9}, 3.562099088659404*^9, 3.5620992560632977`*^9, 
   3.562099305328184*^9, 3.562099336668639*^9, 3.562099441064023*^9, 
   3.562157276885518*^9, 3.5621586936160083`*^9, 3.5621598402492228`*^9, 
   3.562160794705699*^9, 3.5621609824676285`*^9, {3.562161130917489*^9, 
   3.5621611505423236`*^9}, 3.562161312923009*^9, 3.562161434400422*^9, 
   3.562161491574523*^9, 3.5621615769066725`*^9, 3.5621616250795574`*^9, 
   3.562161663674025*^9, 3.5647677507865577`*^9, 3.5847161873988853`*^9}]
}, Open  ]],

Cell[BoxData[
 Graphics3DBox[{
   {GrayLevel[0.8], Opacity[0.8], 
    Polygon3DBox[{{-1.5, -1.5, 0}, {1.5, -1.5, 0}, {
      1.5, 1.5, 0}, {-1.5, 1.5, 0}}]}, 
   {GrayLevel[0.], 
    StyleBox[Arrow3DBox[TubeBox[{{0, 0, 0}, {0, 0, 1.2}}, 0.02]],
     FontColor->GrayLevel[0.]]}, 
   {PointSize[0.03], Point3DBox[{1., 0., 0}]}, 
   {PointSize[Large], 
    Point3DBox[{{1., 0., 0}, {0.9950041652780258, 0.09983341664682815, 0}, {
      0.9800665778412416, 0.19866933079506122`, 0}, {
      0.955336489125606, 0.2955202066613396, 0}, {
      0.9210609940028851, 0.3894183423086505, 0}, {
      0.8775825618903728, 0.479425538604203, 0}, {
      0.8253356149096782, 0.5646424733950355, 0}, {
      0.7648421872844884, 0.6442176872376911, 0}, {
      0.6967067093471654, 0.7173560908995228, 0}, {
      0.6216099682706644, 0.7833269096274834, 0}, {
      0.5403023058681397, 0.8414709848078965, 0}, {
      0.4535961214255773, 0.8912073600614354, 0}, {
      0.3623577544766734, 0.9320390859672264, 0}, {
      0.26749882862458735`, 0.963558185417193, 0}, {
      0.16996714290024081`, 0.9854497299884603, 0}, {
      0.0707372016677029, 0.9974949866040544, 0}, {-0.029199522301288815`, 
       0.9995736030415051, 0}, {-0.12884449429552486`, 0.9916648104524686, 
       0}, {-0.2272020946930871, 0.9738476308781951, 0}, {-0.3232895668635036,
        0.9463000876874145, 0}, {-0.4161468365471424, 0.9092974268256817, 
       0}, {-0.5048461045998576, 0.8632093666488737, 0}, {-0.5885011172553458,
        0.8084964038195901, 0}, {-0.6662760212798244, 0.74570521217672, 
       0}, {-0.7373937155412458, 0.6754631805511506, 0}, {-0.8011436155469337,
        0.5984721441039565, 0}, {-0.8568887533689473, 0.5155013718214642, 
       0}, {-0.9040721420170612, 0.4273798802338298, 0}, {-0.9422223406686583,
        0.33498815015590466`, 0}, {-0.9709581651495907, 0.23924932921398198`, 
       0}, {-0.9899924966004454, 0.1411200080598672, 0}, {-0.9991351502732795,
        0.04158066243329049, 0}, {-0.9982947757947531, -0.058374143427580086`,
        0}, {-0.9874797699088649, -0.15774569414324865`, 
       0}, {-0.9667981925794609, -0.25554110202683167`, 
       0}, {-0.9364566872907963, -0.35078322768961984`, 
       0}, {-0.896758416334147, -0.44252044329485246`, 
       0}, {-0.848100031710408, -0.5298361409084934, 
       0}, {-0.7909677119144165, -0.6118578909427193, 
       0}, {-0.7259323042001399, -0.6877661591839741, 
       0}, {-0.6536436208636119, -0.7568024953079282, 
       0}, {-0.5748239465332685, -0.8182771110644108, 
       0}, {-0.4902608213406994, -0.8715757724135882, 
       0}, {-0.40079917207997545`, -0.9161659367494549, 
       0}, {-0.30733286997841935`, -0.9516020738895161, 
       0}, {-0.2107957994307797, -0.977530117665097, 
       0}, {-0.11215252693505398`, -0.9936910036334645, 
       0}, {-0.01238866346289056, -0.9999232575641008, 0}, {
      0.08749898343944727, -0.9961646088358406, 0}, {
      0.18651236942257576`, -0.9824526126243325, 0}, {
      0.28366218546322625`, -0.9589242746631385, 0}, {
      0.37797774271298107`, -0.9258146823277321, 0}, {
      0.4685166713003771, -0.8834546557201531, 0}, {
      0.5543743361791615, -0.8322674422239008, 0}, {
      0.6346928759426347, -0.7727644875559871, 0}, {
      0.70866977429126, -0.7055403255703919, 0}, {
      0.7755658785102502, -0.6312666378723208, 0}, {
      0.8347127848391598, -0.5506855425976376, 0}, {
      0.8855195169413194, -0.4646021794137566, 0}, {
      0.9274784307440359, -0.373876664830236, 0}, {
      0.960170286650366, -0.27941549819892586`, 0}, {
      0.9832684384425847, -0.18216250427209502`, 0}, {
      0.9965420970232175, -0.0830894028174964, 0}}]}},
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 14},
  Boxed->False,
  Lighting->"Neutral",
  ViewPoint->{-0.8, -0.8, 0.48}]], "Output",
 CellChangeTimes->{
  3.562093563610099*^9, 3.5620936061825733`*^9, 3.562093909634307*^9, 
   3.5620939480259743`*^9, 3.5620940950874324`*^9, 3.562094245268896*^9, 
   3.562098096853261*^9, 3.5620981564141655`*^9, 3.5620982900752*^9, 
   3.5620983250192623`*^9, 3.56209837545415*^9, {3.5620988868886495`*^9, 
   3.562098904984681*^9}, {3.5620989769164076`*^9, 3.562098989084429*^9}, 
   3.562099088737404*^9, 3.562099256078898*^9, 3.5620993053437843`*^9, 
   3.5620993366842394`*^9, 3.5620994410952225`*^9, 3.5621572769791183`*^9, 
   3.5621586936316085`*^9, 3.562159840280422*^9, 3.5621607947524986`*^9, 
   3.562160982498829*^9, {3.5621611309486895`*^9, 3.5621611505891237`*^9}, 
   3.562161313063409*^9, 3.5621614344316225`*^9, 3.562161491605723*^9, 
   3.5621615769846725`*^9, 3.562161625110757*^9, 3.562161663720825*^9, 
   3.5647677508801575`*^9, 3.584716187418885*^9}],

Cell[BoxData["\<\"Apply V^T \"\>"], "Print",
 CellChangeTimes->{
  3.5620927459658628`*^9, 3.562092803561164*^9, 3.5620930509463987`*^9, 
   3.5620931895838423`*^9, 3.5620933970798063`*^9, 3.562093436797476*^9, {
   3.562093540990059*^9, 3.5620935635944986`*^9}, 3.562093606151374*^9, 
   3.5620939095875063`*^9, 3.562093948010374*^9, 3.5620940950718327`*^9, 
   3.562094245253296*^9, 3.5620980968376613`*^9, 3.5620981563829656`*^9, 
   3.5620982900440006`*^9, 3.562098325003662*^9, 3.5620983754385505`*^9, {
   3.5620988868730497`*^9, 3.562098904969081*^9}, {3.5620989769008074`*^9, 
   3.5620989890688286`*^9}, 3.562099088659404*^9, 3.5620992560632977`*^9, 
   3.562099305328184*^9, 3.562099336668639*^9, 3.562099441064023*^9, 
   3.562157276885518*^9, 3.5621586936160083`*^9, 3.5621598402492228`*^9, 
   3.562160794705699*^9, 3.5621609824676285`*^9, {3.562161130917489*^9, 
   3.5621611505423236`*^9}, 3.562161312923009*^9, 3.562161434400422*^9, 
   3.562161491574523*^9, 3.5621615769066725`*^9, 3.5621616250795574`*^9, 
   3.562161663674025*^9, 3.5647677507865577`*^9, 3.584716187418885*^9}],

Cell[BoxData[
 Graphics3DBox[{
   {GrayLevel[0.8], Opacity[0.8], 
    Polygon3DBox[{{-1.5, -1.5, 0}, {1.5, -1.5, 0}, {
      1.5, 1.5, 0}, {-1.5, 1.5, 0}}]}, 
   {GrayLevel[0.], 
    StyleBox[Arrow3DBox[TubeBox[{{0, 0, 0}, {0, 0, 1.2}}, 0.02]],
     FontColor->GrayLevel[0.]]}, 
   {PointSize[0.03], 
    Point3DBox[{0.38268343236508984`, -0.9238795325112867, 0}]}, 
   {PointSize[Large], 
    Point3DBox[{{0.38268343236508984`, -0.9238795325112867, 0}, {
      0.47300565948683215`, -0.8810593885167033, 0}, {
      0.5586017704138652, -0.8294359903515734, 0}, {
      0.6386165171001186, -0.7695251419459367, 0}, {
      0.7122504186460618, -0.7019254526931687, 0}, {
      0.7787677494475796, -0.6273123563427967, 0}, {
      0.8375038903230096, -0.5464313622897429, 0}, {
      0.8878719691683112, -0.46009060669088364`, 0}, {
      0.9293687247891355, -0.3691527778357034, 0}, {
      0.9615795353203227, -0.2745264964500734, 0}, {
      0.9841825609905238, -0.177157237058309, 0}, {
      0.9969519598388089, -0.07801788111425467, 0}, {
      0.9997601442528881, 0.021901003708610534`, 0}, {
      0.992579055782358, 0.12160106094192846`, 0}, {
      0.9754804454894642, 0.22008612057028135`, 0}, {
      0.9486351570362042, 0.31637215243269484`, 0}, {
      0.91231141967093, 0.4094970983267305, 0}, {
      0.8668721681703647, 0.4985304845760295, 0}, {
      0.8127714165152824, 0.5825827190157131, 0}, {
      0.7505497215328893, 0.6608139795032353, 0}, {
      0.6808287818316923, 0.7324426051436207, 0}, {
      0.6043052259945068, 0.7967529063867468, 0}, {
      0.5217436520959334, 0.8531023159607513, 0}, {
      0.43396898809113915`, 0.9009278091918091, 0}, {
      0.3418582494084133, 0.9397515295605616, 0}, {
      0.24633177610091234`, 0.9691855632864999, 0}, {
      0.1483440371130696, 0.9889358152342327, 0}, {
      0.048874093542412456`, 0.9988049474148631, 0}, {-0.05108418381529323, 
       0.998694350721944, 0}, {-0.1505320448945025, 0.9886051302010725, 
       0}, {-0.24847583954040384`, 0.9686380940086402, 
       0}, {-0.34393694573281036`, 0.9389927461700573, 
       0}, {-0.43596154765389344`, 0.8999652932014779, 
       0}, {-0.5236301659005466, 0.8519456845122031, 0}, {-0.6060668446186415,
        0.7954137161590837, 0}, {-0.6824479037643698, 0.7309342368829206, 
       0}, {-0.7520101690429692, 0.6591515043265583, 0}, {-0.8140585972940035,
        0.5807827478254837, 0}, {-0.8679732211328717, 0.49661100208938863`, 
       0}, {-0.9132153434599812, 0.40747728337818845`, 
       0}, {-0.9493329199440965, 0.31427218634555587`, 
       0}, {-0.9759650756998721, 0.21792698551153045`, 
       0}, {-0.9928457110304164, 0.11940433027535857`, 
       0}, {-0.9998061602075028, 0.01968862644089936, 
       0}, {-0.9967768767237725, -0.08022379964076365, 
       0}, {-0.9837881281784467, -0.1793346560348777, 
       0}, {-0.9609696938534812, -0.27665365982604795`, 
       0}, {-0.9285495680018794, -0.37120843169777684`, 
       0}, {-0.8868516818044814, -0.4620542116251759, 
       0}, {-0.8362926667566837, -0.5482832986048312, 
       0}, {-0.777377691824255, -0.6290341201031893, 
       0}, {-0.7106954159620182, -0.7034998406045121, 
       0}, {-0.63691210642816, -0.7709364232446435, 
       0}, {-0.5567649816620222, -0.8306700639814151, 
       0}, {-0.47105484524115193`, -0.8821039240219003, 
       0}, {-0.38063808451666187`, -0.9247240932383489, 
       0}, {-0.2864181138739027, -0.9581047249883052, 
       0}, {-0.18933634811455735`, -0.981912291033493, 
       0}, {-0.09036279615112597, -0.9959089140437243, 0}, {
      0.009513631001477452, -0.9999547443885486, 0}, {
      0.10929500109790236`, -0.9940093574685348, 0}, {
      0.20798433167148198`, -0.9781321576245038, 0}, {
      0.30459555155347867`, -0.9524817845889927, 0}}]}},
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 14},
  Boxed->False,
  Lighting->"Neutral",
  ViewPoint->{-0.8, -0.8, 0.48}]], "Output",
 CellChangeTimes->{
  3.562093563610099*^9, 3.5620936061825733`*^9, 3.562093909634307*^9, 
   3.5620939480259743`*^9, 3.5620940950874324`*^9, 3.562094245268896*^9, 
   3.562098096853261*^9, 3.5620981564141655`*^9, 3.5620982900752*^9, 
   3.5620983250192623`*^9, 3.56209837545415*^9, {3.5620988868886495`*^9, 
   3.562098904984681*^9}, {3.5620989769164076`*^9, 3.562098989084429*^9}, 
   3.562099088737404*^9, 3.562099256078898*^9, 3.5620993053437843`*^9, 
   3.5620993366842394`*^9, 3.5620994410952225`*^9, 3.5621572769791183`*^9, 
   3.5621586936316085`*^9, 3.562159840280422*^9, 3.5621607947524986`*^9, 
   3.562160982498829*^9, {3.5621611309486895`*^9, 3.5621611505891237`*^9}, 
   3.562161313063409*^9, 3.5621614344316225`*^9, 3.562161491605723*^9, 
   3.5621615769846725`*^9, 3.562161625110757*^9, 3.562161663720825*^9, 
   3.5647677508801575`*^9, 3.5847161874788857`*^9}],

Cell[BoxData["\<\"Apply SV^T \"\>"], "Print",
 CellChangeTimes->{
  3.5620927459658628`*^9, 3.562092803561164*^9, 3.5620930509463987`*^9, 
   3.5620931895838423`*^9, 3.5620933970798063`*^9, 3.562093436797476*^9, {
   3.562093540990059*^9, 3.5620935635944986`*^9}, 3.562093606151374*^9, 
   3.5620939095875063`*^9, 3.562093948010374*^9, 3.5620940950718327`*^9, 
   3.562094245253296*^9, 3.5620980968376613`*^9, 3.5620981563829656`*^9, 
   3.5620982900440006`*^9, 3.562098325003662*^9, 3.5620983754385505`*^9, {
   3.5620988868730497`*^9, 3.562098904969081*^9}, {3.5620989769008074`*^9, 
   3.5620989890688286`*^9}, 3.562099088659404*^9, 3.5620992560632977`*^9, 
   3.562099305328184*^9, 3.562099336668639*^9, 3.562099441064023*^9, 
   3.562157276885518*^9, 3.5621586936160083`*^9, 3.5621598402492228`*^9, 
   3.562160794705699*^9, 3.5621609824676285`*^9, {3.562161130917489*^9, 
   3.5621611505423236`*^9}, 3.562161312923009*^9, 3.562161434400422*^9, 
   3.562161491574523*^9, 3.5621615769066725`*^9, 3.5621616250795574`*^9, 
   3.562161663674025*^9, 3.5647677507865577`*^9, 3.5847161874788857`*^9}],

Cell[BoxData[
 Graphics3DBox[{
   {GrayLevel[0.8], Opacity[0.8], 
    Polygon3DBox[{{-1.5, -1.5, 0}, {1.5, -1.5, 0}, {
      1.5, 1.5, 0}, {-1.5, 1.5, 0}}]}, 
   {GrayLevel[0.], 
    StyleBox[Arrow3DBox[TubeBox[{{0, 0, 0}, {0, 0, 1.2}}, 0.02]],
     FontColor->GrayLevel[0.]]}, 
   {PointSize[0.03], 
    Point3DBox[{0.9238795325112868, -0.38268343236508956`, 0}]}, 
   {PointSize[Large], 
    Point3DBox[{{0.9238795325112868, -0.38268343236508956`, 0}, {
      1.1419366782123401`, -0.36494674797976423`, 0}, {
      1.3485839700987752`, -0.3435636363239811, 0}, {
      1.5417566567385756`, -0.3187477503810879, 0}, {
      1.7195246205012369`, -0.29074704228038467`, 0}, {
      1.880111662655119, -0.2598412858414101, 0}, {
      2.021913250558039, -0.22633928116641758`, 0}, {
      2.1435125496170433`, -0.19057576921182937`, 0}, {
      2.243694579831319, -0.15290808716725032`, 0}, {
      2.3214583554707415`, -0.11371259806038966`, 0}, {
      2.376026886594408, -0.07338093026209702, 0}, {
      2.4068549424772896`, -0.032316064465136025`, 0}, {
      2.413634499375404, 0.00907169276568993, 0}, {
      2.3962978181972496`, 0.05036880864110399, 0}, {
      2.355018121330413, 0.0911626560302907, 0}, {
      2.290207861860735, 0.1310456362947903, 0}, {
      2.2025146024774114`, 0.16961925187936053`, 0}, {
      2.092814545240665, 0.20649808796782237`, 0}, {
      1.9622037768603864`, 0.24131366342050226`, 0}, {
      1.811987316960051, 0.27371811251597633`, 0}, {
      1.6436660787520245`, 0.3033876607103692, 0}, {
      1.4589218724088764`, 0.3300258596855713, 0}, {
      1.2596006009720722`, 0.3533665493628403, 0}, {
      1.0476938166989562`, 0.3731765172863271, 0}, {
      0.8253188221309155, 0.38925782880484494`, 0}, {
      0.5946975147062752, 0.4014498047694756, 0}, {
      0.3581341862955503, 0.4096306269865122, 0}, {
      0.11799249947878344`, 0.4137185553845821, 0}, {-0.12332812938964106`, 
       0.4136727447344214, 0}, {-0.36341650435606354`, 0.4094936527609035, 
       0}, {-0.5998737417404839, 0.4012230355696036, 0}, {-0.83033723898933, 
       0.38894353043359464`, 0}, {-1.0525042810191938`, 0.3727778301091309, 
       0}, {-1.2641550481847732`, 0.3528874569301844, 
       0}, {-1.4631747959829915`, 0.32947114893067575`, 
       0}, {-1.6475749848810304`, 0.30276287411973407`, 
       0}, {-1.8155131491460201`, 0.27302949275068816`, 
       0}, {-1.965311306153601, 0.24056809094162837`, 0}, {-2.09547272223564, 
       0.2057030122891181, 0}, {-2.2046968675482908`, 0.1687826171341905, 
       0}, {-2.2918924105362892`, 0.13017580186097377`, 
       0}, {-2.3561881221571155`, 0.09026831300596085, 0}, {-2.39694158091359,
        0.04945889300612985, 0}, {-2.4137455917171207`, 0.008155296096318031, 
       0}, {-2.406432254446426, -0.03322978583630611, 
       0}, {-2.375074641550047, -0.07428284673316031, 
       0}, {-2.319986067930595, -0.11459369798010166`, 
       0}, {-2.2417169604058156`, -0.1537595668764658, 
       0}, {-2.1410493580257675`, -0.19138912100675595`, 
       0}, {-2.018989098197149, -0.2271063783047784, 
       0}, {-1.8767557666884085`, -0.2605544637421672, 
       0}, {-1.7157705119318927`, -0.29139917510569935`, 
       0}, {-1.53764184537848, -0.31933232223533575`, 
       0}, {-1.3441495697828614`, -0.3440748063584285, 
       0}, {-1.1372269960027483`, -0.3653794087523971, 
       0}, {-0.9189416259958414, -0.3830332608724864, 
       0}, {-0.6914744950236974, -0.3968599712639002, 
       0}, {-0.4570983794683579, -0.40672138800691016`, 
       0}, {-0.21815508800200362`, -0.4125189790851713, 0}, {
      0.022967936991179994`, -0.41419481688505816`, 0}, {
      0.26386147395013815`, -0.4117321569892328, 0}, {
      0.5021185942823958, -0.40515560548132723`, 0}, {
      0.7353587115989214, -0.3945308730900894, 0}}]}},
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 14},
  Boxed->False,
  Lighting->"Neutral",
  ViewPoint->{-0.8, -0.8, 0.48}]], "Output",
 CellChangeTimes->{
  3.562093563610099*^9, 3.5620936061825733`*^9, 3.562093909634307*^9, 
   3.5620939480259743`*^9, 3.5620940950874324`*^9, 3.562094245268896*^9, 
   3.562098096853261*^9, 3.5620981564141655`*^9, 3.5620982900752*^9, 
   3.5620983250192623`*^9, 3.56209837545415*^9, {3.5620988868886495`*^9, 
   3.562098904984681*^9}, {3.5620989769164076`*^9, 3.562098989084429*^9}, 
   3.562099088737404*^9, 3.562099256078898*^9, 3.5620993053437843`*^9, 
   3.5620993366842394`*^9, 3.5620994410952225`*^9, 3.5621572769791183`*^9, 
   3.5621586936316085`*^9, 3.562159840280422*^9, 3.5621607947524986`*^9, 
   3.562160982498829*^9, {3.5621611309486895`*^9, 3.5621611505891237`*^9}, 
   3.562161313063409*^9, 3.5621614344316225`*^9, 3.562161491605723*^9, 
   3.5621615769846725`*^9, 3.562161625110757*^9, 3.562161663720825*^9, 
   3.5647677508801575`*^9, 3.5847161874888854`*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],

Cell[BoxData["\<\"Apply USV^T -- illustrates action of input matrix \"\>"], \
"Print",
 CellChangeTimes->{
  3.5620927459658628`*^9, 3.562092803561164*^9, 3.5620930509463987`*^9, 
   3.5620931895838423`*^9, 3.5620933970798063`*^9, 3.562093436797476*^9, {
   3.562093540990059*^9, 3.5620935635944986`*^9}, 3.562093606151374*^9, 
   3.5620939095875063`*^9, 3.562093948010374*^9, 3.5620940950718327`*^9, 
   3.562094245253296*^9, 3.5620980968376613`*^9, 3.5620981563829656`*^9, 
   3.5620982900440006`*^9, 3.562098325003662*^9, 3.5620983754385505`*^9, {
   3.5620988868730497`*^9, 3.562098904969081*^9}, {3.5620989769008074`*^9, 
   3.5620989890688286`*^9}, 3.562099088659404*^9, 3.5620992560632977`*^9, 
   3.562099305328184*^9, 3.562099336668639*^9, 3.562099441064023*^9, 
   3.562157276885518*^9, 3.5621586936160083`*^9, 3.5621598402492228`*^9, 
   3.562160794705699*^9, 3.5621609824676285`*^9, {3.562161130917489*^9, 
   3.5621611505423236`*^9}, 3.562161312923009*^9, 3.562161434400422*^9, 
   3.562161491574523*^9, 3.5621615769066725`*^9, 3.5621616250795574`*^9, 
   3.562161663674025*^9, 3.5647677507865577`*^9, 3.5847161874888854`*^9}],

Cell[BoxData[
 Graphics3DBox[{
   {GrayLevel[0.8], Opacity[0.8], 
    Polygon3DBox[{{-1.5, -1.5, 0}, {1.5, -1.5, 0}, {
      1.5, 1.5, 0}, {-1.5, 1.5, 0}}]}, 
   {GrayLevel[0.], 
    StyleBox[Arrow3DBox[TubeBox[{{0, 0, 0}, {0, 0, 1.2}}, 0.02]],
     FontColor->GrayLevel[0.]]}, 
   {PointSize[0.03], Point3DBox[{1., 2.220446049250313*^-16, 0}]}, 
   {PointSize[Large], 
    Point3DBox[{{1., 2.220446049250313*^-16, 0}, {
      1.1946709985716821`, 0.09983341664682843, 0}, {
      1.377405239431364, 0.19866933079506144`, 0}, {
      1.5463769024482852`, 0.2955202066613398, 0}, {
      1.699897678620186, 0.3894183423086507, 0}, {
      1.8364336390987788`, 0.4794255386042032, 0}, {
      1.954620561699749, 0.5646424733950355, 0}, {
      2.05327756175987, 0.6442176872376911, 0}, {
      2.1314188911462106`, 0.7173560908995228, 0}, {
      2.188263787525631, 0.7833269096274834, 0}, {
      2.2232442754839323`, 0.8414709848078965, 0}, {
      2.236010841548448, 0.8912073600614354, 0}, {
      2.226435926411126, 0.9320390859672265, 0}, {
      2.1946151994589735`, 0.963558185417193, 0}, {
      2.1408666028771615`, 0.9854497299884601, 0}, {
      2.065727174875812, 0.9974949866040544, 0}, {
      1.9699476837817207`, 0.9995736030415049, 0}, {
      1.854485126609412, 0.9916648104524683, 0}, {
      1.720493167063303, 0.9738476308781949, 0}, {
      1.569310608511325, 0.9463000876874142, 0}, {
      1.4024480171042208`, 0.9092974268256815, 0}, {
      1.2215726286978899`, 0.8632093666488736, 0}, {
      1.0284916903838341`, 0.8084964038195899, 0}, {
      0.8251344030736155, 0.7457052121767198, 0}, {
      0.6135326455610555, 0.6754631805511504, 0}, {
      0.3958006726609794, 0.5984721441039563, 0}, {
      0.1741139902739808, 0.5155013718214638, 0}, {-0.04931238154940169, 
       0.4273798802338295, 0}, {-0.2722460403568491, 0.33498815015590433`, 
       0}, {-0.49245950672162675`, 0.23924932921398168`, 
       0}, {-0.707752480480711, 0.14112000805986694`, 
       0}, {-0.9159738254066985, 0.04158066243329017, 
       0}, {-1.1150430626499133`, -0.058374143427580405`, 
       0}, {-1.302971158195362, -0.15774569414324885`, 
       0}, {-1.4778803966331244`, -0.25554110202683195`, 
       0}, {-1.6380231426700362`, -0.3507832276896201, 
       0}, {-1.781799302923852, -0.4425204432948527, 
       0}, {-1.9077723135273947`, -0.5298361409084935, 
       0}, {-2.0146834937998546`, -0.6118578909427193, 
       0}, {-2.101464622568088, -0.6877661591839742, 
       0}, {-2.1672486114794682`, -0.7568024953079283, 
       0}, {-2.21137816866209, -0.8182771110644108, 
       0}, {-2.2334123661678755`, -0.8715757724135882, 
       0}, {-2.2331310455788853`, -0.916165936749455, 
       0}, {-2.2105370177574515`, -0.951602073889516, 
       0}, {-2.1658560347609734`, -0.977530117665097, 
       0}, {-2.0995345342019824`, -0.9936910036334643, 
       0}, {-2.012235178591092, -0.9999232575641007, 
       0}, {-1.9048302342322336`, -0.9961646088358405, 
       0}, {-1.778392855826089, -0.9824526126243324, 
       0}, {-1.6341863638630505`, -0.9589242746631382, 
       0}, {-1.4736516219424833`, -0.925814682327732, 
       0}, {-1.298392640139929, -0.8834546557201529, 
       0}, {-1.1101605482686403`, -0.8322674422239007, 
       0}, {-0.9108360991693395, -0.7727644875559869, 
       0}, {-0.7024108768495237, -0.7055403255703916, 
       0}, {-0.4869673972343914, -0.6312666378723205, 
       0}, {-0.2666583003561154, -0.5506855425976374, 
       0}, {-0.043684841886193676`, -0.4646021794137563, 0}, {
      0.179725101083564, -0.3738766648302357, 0}, {
      0.40133929025251436`, -0.2794154981989256, 0}, {
      0.6189434298983948, -0.1821625042720948, 0}, {
      0.8303632913882246, -0.08308940281749616, 0}}]}},
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 14},
  Boxed->False,
  Lighting->"Neutral",
  ViewPoint->{-0.8, -0.8, 0.48}]], "Output",
 CellChangeTimes->{
  3.562093563610099*^9, 3.5620936061825733`*^9, 3.562093909634307*^9, 
   3.5620939480259743`*^9, 3.5620940950874324`*^9, 3.562094245268896*^9, 
   3.562098096853261*^9, 3.5620981564141655`*^9, 3.5620982900752*^9, 
   3.5620983250192623`*^9, 3.56209837545415*^9, {3.5620988868886495`*^9, 
   3.562098904984681*^9}, {3.5620989769164076`*^9, 3.562098989084429*^9}, 
   3.562099088737404*^9, 3.562099256078898*^9, 3.5620993053437843`*^9, 
   3.5620993366842394`*^9, 3.5620994410952225`*^9, 3.5621572769791183`*^9, 
   3.5621586936316085`*^9, 3.562159840280422*^9, 3.5621607947524986`*^9, 
   3.562160982498829*^9, {3.5621611309486895`*^9, 3.5621611505891237`*^9}, 
   3.562161313063409*^9, 3.5621614344316225`*^9, 3.562161491605723*^9, 
   3.5621615769846725`*^9, 3.562161625110757*^9, 3.562161663720825*^9, 
   3.5647677508801575`*^9, 3.584716187498885*^9}],

Cell[BoxData["\<\"Directly apply matrix to point set to check if result the \
same \"\>"], "Print",
 CellChangeTimes->{
  3.5620927459658628`*^9, 3.562092803561164*^9, 3.5620930509463987`*^9, 
   3.5620931895838423`*^9, 3.5620933970798063`*^9, 3.562093436797476*^9, {
   3.562093540990059*^9, 3.5620935635944986`*^9}, 3.562093606151374*^9, 
   3.5620939095875063`*^9, 3.562093948010374*^9, 3.5620940950718327`*^9, 
   3.562094245253296*^9, 3.5620980968376613`*^9, 3.5620981563829656`*^9, 
   3.5620982900440006`*^9, 3.562098325003662*^9, 3.5620983754385505`*^9, {
   3.5620988868730497`*^9, 3.562098904969081*^9}, {3.5620989769008074`*^9, 
   3.5620989890688286`*^9}, 3.562099088659404*^9, 3.5620992560632977`*^9, 
   3.562099305328184*^9, 3.562099336668639*^9, 3.562099441064023*^9, 
   3.562157276885518*^9, 3.5621586936160083`*^9, 3.5621598402492228`*^9, 
   3.562160794705699*^9, 3.5621609824676285`*^9, {3.562161130917489*^9, 
   3.5621611505423236`*^9}, 3.562161312923009*^9, 3.562161434400422*^9, 
   3.562161491574523*^9, 3.5621615769066725`*^9, 3.5621616250795574`*^9, 
   3.562161663674025*^9, 3.5647677507865577`*^9, 3.5847161875088854`*^9}],

Cell[BoxData[
 Graphics3DBox[{
   {GrayLevel[0.8], Opacity[0.8], 
    Polygon3DBox[{{-1.5, -1.5, 0}, {1.5, -1.5, 0}, {
      1.5, 1.5, 0}, {-1.5, 1.5, 0}}]}, 
   {GrayLevel[0.], 
    StyleBox[Arrow3DBox[TubeBox[{{0, 0, 0}, {0, 0, 1.2}}, 0.02]],
     FontColor->GrayLevel[0.]]}, 
   {PointSize[Large], 
    Point3DBox[{{1., 0., 0}, {1.1946709985716821`, 0.09983341664682815, 0}, {
      1.377405239431364, 0.19866933079506122`, 0}, {
      1.5463769024482852`, 0.2955202066613396, 0}, {
      1.6998976786201863`, 0.3894183423086505, 0}, {
      1.8364336390987788`, 0.479425538604203, 0}, {
      1.9546205616997492`, 0.5646424733950355, 0}, {
      2.0532775617598706`, 0.6442176872376911, 0}, {
      2.131418891146211, 0.7173560908995228, 0}, {
      2.1882637875256314`, 0.7833269096274834, 0}, {
      2.2232442754839328`, 0.8414709848078965, 0}, {
      2.236010841548448, 0.8912073600614354, 0}, {
      2.226435926411126, 0.9320390859672264, 0}, {
      2.194615199458973, 0.963558185417193, 0}, {
      2.1408666028771615`, 0.9854497299884603, 0}, {
      2.065727174875812, 0.9974949866040544, 0}, {
      1.9699476837817214`, 0.9995736030415051, 0}, {
      1.8544851266094122`, 0.9916648104524686, 0}, {
      1.7204931670633032`, 0.9738476308781951, 0}, {
      1.5693106085113253`, 0.9463000876874145, 0}, {
      1.402448017104221, 0.9092974268256817, 0}, {
      1.2215726286978899`, 0.8632093666488737, 0}, {
      1.0284916903838344`, 0.8084964038195901, 0}, {
      0.8251344030736156, 0.74570521217672, 0}, {
      0.6135326455610555, 0.6754631805511506, 0}, {
      0.3958006726609794, 0.5984721441039565, 0}, {
      0.174113990273981, 0.5155013718214642, 0}, {-0.04931238154940165, 
       0.4273798802338298, 0}, {-0.27224604035684896`, 0.33498815015590466`, 
       0}, {-0.4924595067216267, 0.23924932921398198`, 
       0}, {-0.7077524804807109, 0.1411200080598672, 0}, {-0.9159738254066985,
        0.04158066243329049, 
       0}, {-1.1150430626499133`, -0.058374143427580086`, 
       0}, {-1.3029711581953622`, -0.15774569414324865`, 
       0}, {-1.4778803966331242`, -0.25554110202683167`, 
       0}, {-1.638023142670036, -0.35078322768961984`, 
       0}, {-1.781799302923852, -0.44252044329485246`, 
       0}, {-1.9077723135273947`, -0.5298361409084934, 
       0}, {-2.014683493799855, -0.6118578909427193, 
       0}, {-2.101464622568088, -0.6877661591839741, 
       0}, {-2.1672486114794682`, -0.7568024953079282, 
       0}, {-2.2113781686620904`, -0.8182771110644108, 
       0}, {-2.233412366167876, -0.8715757724135882, 
       0}, {-2.2331310455788853`, -0.9161659367494549, 
       0}, {-2.2105370177574515`, -0.9516020738895161, 
       0}, {-2.165856034760974, -0.977530117665097, 
       0}, {-2.099534534201983, -0.9936910036334645, 
       0}, {-2.012235178591092, -0.9999232575641008, 
       0}, {-1.9048302342322339`, -0.9961646088358406, 
       0}, {-1.7783928558260893`, -0.9824526126243325, 
       0}, {-1.6341863638630507`, -0.9589242746631385, 
       0}, {-1.4736516219424831`, -0.9258146823277321, 
       0}, {-1.2983926401399293`, -0.8834546557201531, 
       0}, {-1.11016054826864, -0.8322674422239008, 
       0}, {-0.9108360991693396, -0.7727644875559871, 
       0}, {-0.7024108768495239, -0.7055403255703919, 
       0}, {-0.48696739723439153`, -0.6312666378723208, 
       0}, {-0.2666583003561154, -0.5506855425976376, 
       0}, {-0.043684841886193815`, -0.4646021794137566, 0}, {
      0.17972510108356388`, -0.373876664830236, 0}, {
      0.40133929025251425`, -0.27941549819892586`, 0}, {
      0.6189434298983947, -0.18216250427209502`, 0}, {
      0.8303632913882247, -0.0830894028174964, 0}}]}, 
   {PointSize[0.03], Point3DBox[{1., 0., 0}]}},
  BaseStyle->{FontFamily -> "Helvetica", FontSize -> 14},
  Boxed->False,
  Lighting->"Neutral",
  ViewPoint->{-0.8, -0.8, 0.48}]], "Output",
 CellChangeTimes->{
  3.562093563610099*^9, 3.5620936061825733`*^9, 3.562093909634307*^9, 
   3.5620939480259743`*^9, 3.5620940950874324`*^9, 3.562094245268896*^9, 
   3.562098096853261*^9, 3.5620981564141655`*^9, 3.5620982900752*^9, 
   3.5620983250192623`*^9, 3.56209837545415*^9, {3.5620988868886495`*^9, 
   3.562098904984681*^9}, {3.5620989769164076`*^9, 3.562098989084429*^9}, 
   3.562099088737404*^9, 3.562099256078898*^9, 3.5620993053437843`*^9, 
   3.5620993366842394`*^9, 3.5620994410952225`*^9, 3.5621572769791183`*^9, 
   3.5621586936316085`*^9, 3.562159840280422*^9, 3.5621607947524986`*^9, 
   3.562160982498829*^9, {3.5621611309486895`*^9, 3.5621611505891237`*^9}, 
   3.562161313063409*^9, 3.5621614344316225`*^9, 3.562161491605723*^9, 
   3.5621615769846725`*^9, 3.562161625110757*^9, 3.562161663720825*^9, 
   3.5647677508801575`*^9, 3.5847161875188856`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{" ", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "This", " ", "does", " ", "not", " ", "work", " ", "well", " ", "because", 
    " ", "of", " ", "the", " ", "opacity", " ", "in", " ", "the", " ", 
    "figure"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Export", "[", 
     RowBox[{"\"\<SVD2_orig.eps\>\"", ",", "origplot"}], "]"}], 
    "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<SVD2_vt.eps\>\"", ",", "plotvvpoints"}], "]"}], 
    "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<SVD2_svt.eps\>\"", ",", "plotssvvpoints"}], "]"}], 
    "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
     RowBox[{"\"\<SVD2_usvt.eps\>\"", ",", "plotuussvvpoints"}], "]"}]}], 
   "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5190613970788293`*^9, 3.519061397749631*^9}, {
   3.519061432022891*^9, 3.5190614624429445`*^9}, {3.519061514905836*^9, 
   3.519061628240035*^9}, {3.519061759373866*^9, 3.5190617744122925`*^9}, {
   3.5190618332711954`*^9, 3.519061929601365*^9}, {3.51906205786479*^9, 
   3.5190620650876026`*^9}, 3.5190621108268833`*^9, {3.5190622884799953`*^9, 
   3.519062320350851*^9}, {3.519062521918805*^9, 3.5190626326165996`*^9}, {
   3.5190628193333273`*^9, 3.519062819380128*^9}, 3.519062858848197*^9, {
   3.5190637725290017`*^9, 3.519063787505028*^9}, 3.519064197458148*^9, {
   3.5190648424412813`*^9, 3.519064859632511*^9}, {3.519065093601722*^9, 
   3.5190651249109774`*^9}, {3.519143584891322*^9, 3.519143618134981*^9}, {
   3.5191436705822725`*^9, 3.519143684029496*^9}, {3.5191564974679966`*^9, 
   3.5191565115080214`*^9}, 3.5191687775763645`*^9, {3.5193183416584096`*^9, 
   3.51931846709823*^9}, 3.519318600363664*^9, {3.519318688550619*^9, 
   3.5193187098134565`*^9}, {3.519318801682018*^9, 3.5193188481232996`*^9}, {
   3.519318923799032*^9, 3.5193189293682423`*^9}, {3.5193190014403687`*^9, 
   3.519319022781206*^9}, {3.519319175864275*^9, 3.5193191785006795`*^9}, {
   3.519319310882512*^9, 3.5193193555765905`*^9}, {3.519319442172343*^9, 
   3.519319565287759*^9}, {3.5193198098493886`*^9, 3.519319841985445*^9}, 
   3.5193199527144394`*^9, 3.519320062320232*^9, 3.5193201753736305`*^9, 
   3.5193203564431486`*^9, {3.5193290189839635`*^9, 3.5193290317447863`*^9}, {
   3.519331648326182*^9, 3.519331738915541*^9}, {3.5193317714883986`*^9, 
   3.519331836524913*^9}, {3.519331911748245*^9, 3.5193319703887477`*^9}, {
   3.519332003850806*^9, 3.5193320128052225`*^9}, {3.5193320585133023`*^9, 
   3.519332077030535*^9}, {3.519332153501869*^9, 3.5193321795851154`*^9}, {
   3.519332252250043*^9, 3.5193322645272646`*^9}, {3.5193322952749186`*^9, 
   3.5193323228869667`*^9}, {3.5193324053487115`*^9, 
   3.5193324341619625`*^9}, {3.5193324710560274`*^9, 
   3.5193324897448597`*^9}, {3.5193325345949388`*^9, 3.519332573875808*^9}, {
   3.5193326105514717`*^9, 3.519332617306284*^9}, {3.5193326927480164`*^9, 
   3.519332779094168*^9}, {3.5193329731585093`*^9, 3.51933318466368*^9}, {
   3.5193333259219284`*^9, 3.5193333573559837`*^9}, 3.5193334441701365`*^9, 
   3.519333573806364*^9, {3.5193336196236444`*^9, 3.519333700915387*^9}, {
   3.5193338052015705`*^9, 3.519333805575971*^9}, {3.519336424716172*^9, 
   3.519336584819253*^9}, {3.51933662859293*^9, 3.5193366396221495`*^9}, {
   3.5193374015586877`*^9, 3.5193374062854958`*^9}, {3.5193377748885436`*^9, 
   3.51933777852335*^9}, {3.5193378293794394`*^9, 3.51933788112473*^9}, {
   3.5193379688748846`*^9, 3.5193379927897263`*^9}, {3.519393659487196*^9, 
   3.5193937240620933`*^9}, 3.5193995276423693`*^9, {3.519399560262027*^9, 
   3.5193995687172413`*^9}, 3.519399607062109*^9, {3.519743189247101*^9, 
   3.519743197296715*^9}, {3.519822556574108*^9, 3.5198225643117213`*^9}, {
   3.519822615635812*^9, 3.5198226456502647`*^9}, {3.519822681327527*^9, 
   3.5198226840575314`*^9}, {3.5198227249296036`*^9, 3.519822727909209*^9}, {
   3.5198230136237106`*^9, 3.5198230640585995`*^9}, {3.5199394713775268`*^9, 
   3.519939474435132*^9}, {3.5209457136282034`*^9, 3.5209457316306353`*^9}, {
   3.521233019052727*^9, 3.5212330195363283`*^9}, {3.521824157577416*^9, 
   3.5218241913514752`*^9}, {3.5218242354839525`*^9, 
   3.5218242371531553`*^9}, {3.521824777014904*^9, 3.521824780977311*^9}, {
   3.521824881659888*^9, 3.5218248945143104`*^9}, {3.522546096219933*^9, 
   3.522546118446204*^9}, {3.522546164829857*^9, 3.5225461846399903`*^9}, {
   3.5480827780275407`*^9, 3.548083073180059*^9}, {3.5480844465048714`*^9, 
   3.548084447799674*^9}, 3.548084490465749*^9, {3.548084523725007*^9, 
   3.5480845255190105`*^9}, {3.5480846736100707`*^9, 
   3.5480847132965403`*^9}, {3.5480850595079484`*^9, 3.548085176601754*^9}, {
   3.5480852081762094`*^9, 3.548085220968232*^9}, 3.5480852876959496`*^9, {
   3.5480853452912507`*^9, 3.548085345416051*^9}, {3.5480854601230526`*^9, 
   3.548085504957531*^9}, {3.54808669421002*^9, 3.5480867052080393`*^9}, 
   3.5480869024859858`*^9, {3.5480873606119905`*^9, 3.5480873616259923`*^9}, {
   3.5481089290239763`*^9, 3.5481089295387774`*^9}, {3.5481090731058297`*^9, 
   3.5481091125270987`*^9}, {3.54810921548728*^9, 3.5481092677161713`*^9}, {
   3.5481093308494825`*^9, 3.54810947777054*^9}, {3.5481095113105993`*^9, 
   3.5481095348666406`*^9}, {3.548255560709408*^9, 3.548255637461543*^9}, {
   3.548255675385209*^9, 3.54825568700723*^9}, {3.548255737161318*^9, 
   3.5482557378165193`*^9}, {3.548255813897853*^9, 3.548255849465915*^9}, {
   3.548265318518547*^9, 3.54826532014095*^9}, {3.5482654408071623`*^9, 
   3.5482654469691725`*^9}, {3.5482655240957084`*^9, 3.548265530054919*^9}, {
   3.548265648131526*^9, 3.548265660642748*^9}, {3.548265763743329*^9, 
   3.5482658059570036`*^9}, 3.5482660708142686`*^9, {3.548266109892337*^9, 
   3.5482661181291513`*^9}, {3.548266190653679*^9, 3.548266220886532*^9}, {
   3.5482665984383955`*^9, 3.548266647469281*^9}, {3.548266688247753*^9, 
   3.5482666925221605`*^9}, {3.548266762925084*^9, 3.5482667724099007`*^9}, {
   3.5482668726868773`*^9, 3.5482668940277147`*^9}, {3.5482669350245867`*^9, 
   3.54826695400982*^9}, {3.5482670699492235`*^9, 3.5482670787320385`*^9}, {
   3.548267132645734*^9, 3.5482671855142264`*^9}, {3.548267237665118*^9, 
   3.5482672647935658`*^9}, {3.548278236511236*^9, 3.5482782735925016`*^9}, {
   3.548278327256596*^9, 3.548278376802283*^9}, {3.5482785724890265`*^9, 
   3.548278578339037*^9}, {3.5482792414338017`*^9, 3.548279284864278*^9}, {
   3.5482793450959835`*^9, 3.548279353972399*^9}, {3.5482795652435703`*^9, 
   3.548279619921666*^9}, {3.548279773441536*^9, 3.5482797903051653`*^9}, {
   3.5482799098637753`*^9, 3.5482799507982473`*^9}, {3.5482800398588037`*^9, 
   3.548280046457616*^9}, {3.5482800767216682`*^9, 3.5482801276869583`*^9}, {
   3.5482803327805185`*^9, 3.548280371484186*^9}, {3.548280417441867*^9, 
   3.5482804279406853`*^9}, {3.548280494927203*^9, 3.54828054439489*^9}, {
   3.54828076624288*^9, 3.5482807778649*^9}, {3.54828122190408*^9, 
   3.5482813009182186`*^9}, 3.54828184769798*^9, {3.54828201277747*^9, 
   3.548282015523075*^9}, {3.5482820824627924`*^9, 3.5482820899040055`*^9}, 
   3.5482825476876197`*^9, {3.548282600821313*^9, 3.548282669102633*^9}, {
   3.5482827161211157`*^9, 3.548282763732399*^9}, {3.5482831379926567`*^9, 
   3.5482831926395526`*^9}, 3.548283229252817*^9, {3.5482832677224846`*^9, 
   3.5482832685804863`*^9}, {3.548337660164831*^9, 3.548337707885315*^9}, {
   3.5483378432467527`*^9, 3.5483378914976377`*^9}, {3.5483379306537066`*^9, 
   3.5483380219918666`*^9}, {3.5483383681252747`*^9, 
   3.5483384772006664`*^9}, {3.548338688097437*^9, 3.548338694181447*^9}, {
   3.5483387278775063`*^9, 3.54833873013951*^9}, 3.5483387632739687`*^9, {
   3.5483388024612374`*^9, 3.5483388390277014`*^9}, {3.548338931021063*^9, 
   3.5483389755279417`*^9}, {3.5483391622914696`*^9, 3.548339174412691*^9}, 
   3.548339235034397*^9, 3.5483395307173166`*^9, {3.5483403647727814`*^9, 
   3.5483403955048356`*^9}, {3.548364491181573*^9, 3.5483645678869076`*^9}, {
   3.548364623485405*^9, 3.5483646334070225`*^9}, {3.548364838016982*^9, 
   3.548364941538764*^9}, {3.548365010038484*^9, 3.54836506468538*^9}, {
   3.548365883702419*^9, 3.548365945525327*^9}, {3.5483659788781857`*^9, 
   3.5483659942130127`*^9}, {3.548366118607631*^9, 3.5483661200584335`*^9}, {
   3.548366160805705*^9, 3.548366169697721*^9}, {3.548366210023792*^9, 
   3.5483662558254724`*^9}, {3.548366303873557*^9, 3.5483663061043606`*^9}, {
   3.5483663402684207`*^9, 3.548366353544044*^9}, {3.5483663939637146`*^9, 
   3.548366438626593*^9}, {3.548426002981133*^9, 3.5484260441496053`*^9}, {
   3.548426218152311*^9, 3.548426330815709*^9}, {3.548426366836172*^9, 
   3.548426368957776*^9}, {3.5484265945809717`*^9, 3.548426731159212*^9}, 
   3.5484267672888756`*^9, {3.548426847566616*^9, 3.548426850062621*^9}, 
   3.548426916175537*^9, {3.548426966095625*^9, 3.5484269677492275`*^9}, {
   3.5484292280311985`*^9, 3.548429290446908*^9}, {3.548429320820162*^9, 
   3.5484295570201764`*^9}, {3.548429587112629*^9, 3.5484298194750376`*^9}, {
   3.5484344974260545`*^9, 3.548434522713699*^9}, {3.548434880188327*^9, 
   3.54843488232553*^9}, {3.5484349317776175`*^9, 3.548434953321255*^9}, {
   3.5484351235175543`*^9, 3.548435150833202*^9}, {3.5484351972588835`*^9, 
   3.54843521789772*^9}, 3.5484352564297876`*^9, {3.5484353248671074`*^9, 
   3.5484353811832066`*^9}, {3.5484354363605037`*^9, 
   3.5484354375461054`*^9}, {3.5484354942834053`*^9, 3.54843559367118*^9}, {
   3.548435695242958*^9, 3.5484358725996695`*^9}, {3.548435910258136*^9, 
   3.5484359121301394`*^9}, {3.548436201432647*^9, 3.5484362033982506`*^9}, {
   3.548436286452797*^9, 3.5484364403002667`*^9}, 3.548436500843973*^9, 
   3.54843653889244*^9, {3.548436585848522*^9, 3.548436642539022*^9}, {
   3.548436704954732*^9, 3.54843677804086*^9}, 3.5484369444931526`*^9, {
   3.5484370203872857`*^9, 3.54843702255569*^9}, {3.5484370660797663`*^9, 
   3.5484370777641864`*^9}, {3.548437110274644*^9, 3.5484372383352685`*^9}, {
   3.5484373881735315`*^9, 3.5484375229577684`*^9}, {3.5484376009267054`*^9, 
   3.548437604795512*^9}, {3.5484376442011814`*^9, 3.5484376638104157`*^9}, 
   3.5484376978184757`*^9, {3.548437819607889*^9, 3.548437887670809*^9}, 
   3.5484381060087924`*^9, {3.548438191746543*^9, 3.5484382289994087`*^9}, {
   3.5484383503832216`*^9, 3.5484385271315317`*^9}, 3.548438559517189*^9, {
   3.5484386721025867`*^9, 3.548438711539456*^9}, {3.548438834077671*^9, 
   3.5484388426888866`*^9}, 3.54843887293734*^9, {3.5484389443074646`*^9, 
   3.5484389527626796`*^9}, 3.54843906107367*^9, 3.5484390990909367`*^9, {
   3.5484391301817913`*^9, 3.5484391618810472`*^9}, {3.548439235965577*^9, 
   3.548439238243181*^9}, {3.548522484301733*^9, 3.5485226761820703`*^9}, 
   3.5485227731206408`*^9, {3.5487713741413865`*^9, 3.5487714149842587`*^9}, {
   3.54877151806924*^9, 3.54877154086088*^9}, {3.5487719300523643`*^9, 
   3.548771981906855*^9}, {3.5490422461683207`*^9, 3.549042282656785*^9}, {
   3.549042313544839*^9, 3.549042323341656*^9}, {3.54904236553973*^9, 
   3.549042372138542*^9}, {3.5490425076611814`*^9, 3.549042508706383*^9}, {
   3.54904260358575*^9, 3.5490426453002234`*^9}, {3.5490427008207207`*^9, 
   3.549042714236744*^9}, {3.5490428660738115`*^9, 3.549042889629853*^9}, {
   3.549043942335302*^9, 3.5490439450653067`*^9}, {3.549044374816862*^9, 
   3.5490443774220667`*^9}, {3.5494919607410803`*^9, 3.549491968385093*^9}, {
   3.5496484754473376`*^9, 3.5496484765549393`*^9}, {3.562091872192728*^9, 
   3.5620918770443363`*^9}, {3.562098445373473*^9, 3.5620985005975704`*^9}, {
   3.5620985944037356`*^9, 3.5620986340278053`*^9}, {3.562098694041111*^9, 
   3.56209871647395*^9}, {3.5620989274955206`*^9, 3.56209895008436*^9}},
 FontFamily->"Courier New",
 FontColor->GrayLevel[0]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1175, 628},
WindowMargins->{{Automatic, 13}, {Automatic, 55}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 1604, 32, 114, "Output"],
Cell[CellGroupData[{
Cell[2186, 56, 10960, 159, 145, "Subsubtitle"],
Cell[13149, 217, 10464, 145, 47, "Text"],
Cell[23616, 364, 16241, 227, 72, "Input"],
Cell[CellGroupData[{
Cell[39882, 595, 99, 1, 71, "Section"],
Cell[39984, 598, 17274, 260, 132, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[57295, 863, 98, 1, 71, "Section"],
Cell[57396, 866, 27742, 535, 1312, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[85175, 1406, 97, 1, 71, "Section"],
Cell[CellGroupData[{
Cell[85297, 1411, 22502, 390, 572, "Input"],
Cell[CellGroupData[{
Cell[107824, 1805, 1714, 32, 23, "Print"],
Cell[109541, 1839, 3641, 79, 36, "Print"],
Cell[113185, 1920, 2713, 57, 38, "Print"],
Cell[115901, 1979, 1105, 15, 23, "Print"]
}, Open  ]],
Cell[117021, 1997, 4698, 82, 298, "Output"],
Cell[121722, 2081, 1095, 15, 23, "Print"],
Cell[122820, 2098, 4819, 87, 298, "Output"],
Cell[127642, 2187, 1098, 15, 23, "Print"],
Cell[128743, 2204, 7575, 132, 255, 3963, 73, "CachedBoxData", "BoxData", \
"Output"],
Cell[136321, 2338, 1139, 16, 23, "Print"],
Cell[137463, 2356, 4776, 88, 261, "Output"],
Cell[142242, 2446, 1152, 16, 23, "Print"],
Cell[143397, 2464, 4745, 87, 261, "Output"]
}, Open  ]],
Cell[148157, 2554, 11973, 171, 252, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
