(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     11804,        307]
NotebookOptionsPosition[     11366,        287]
NotebookOutlinePosition[     11709,        302]
CellTagsIndexPosition[     11666,        299]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9},
 FontFamily->"Arial"],

Cell[TextData[{
 StyleBox["Dimension and subspace",
  FontWeight->"Bold"],
 "\nA linear space, being a set, has many subsets. Some of these are \
themselves linear spaces. \nExample : in 3 D, fix any two vectors v and w. \
Let S[v, w] be the set of all 3 D vectors u which may be expressed as linear \
combinations of v and w : \n   \n   \tu = rv + sw.\n    \t\n    Then S[v, w] \
is a linear space. Since it is determined (spanned) by two vectors, it is \
called a two - dimensional (2 D) subspace of S. Similarly, a 1 D subspace is \
obtained by all multiples of one vector a.\n  \n  The following cell \
illustrates the subspace spanned by two vectors v and w (in blue). Note that \
the variable vector u (pictured tube style) never leaves the colored plane \
(rotate the image!)."
}], "Subsubtitle",
 CellChangeTimes->{{3.5848181870415745`*^9, 3.5848182110916085`*^9}, {
  3.5848185673621073`*^9, 3.58481856936211*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"e1", ",", "e2", ",", 
    RowBox[{"e3", " ", "axes"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"aa1", " ", "=", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], ";"}], " ", 
   RowBox[{"(*", "  ", "black", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"bb1", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], ";"}], 
   RowBox[{"(*", "  ", "black", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cc1", "=", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], ";"}], " ", 
   RowBox[{"(*", "  ", "black", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "subspace", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vv1", "=", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], ";"}], " ", 
   RowBox[{"(*", " ", "blue", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ww1", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "2"}], "}"}]}], ";"}], " ", 
   RowBox[{"(*", " ", "blue", " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"arrowaa1", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "aa1"}], "}"}], 
        "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"arrowbb1", " ", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "bb1"}], "}"}], 
        "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"arrowcc1", " ", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "cc1"}], "}"}], 
        "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"arrowvv1", " ", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "vv1"}], "}"}], 
        "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"arrowww1", " ", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "ww1"}], "}"}], 
        "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]",
    "\[IndentingNewLine]", 
   RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Graphics3D", "[", 
      RowBox[{
       RowBox[{"{", " ", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Arrowheads", "[", ".06", "]"}], ",", 
           RowBox[{"Arrow", "[", 
            RowBox[{"Tube", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
                RowBox[{
                 RowBox[{"r", "*", "vv1"}], "+", 
                 RowBox[{"s", "*", "ww1"}]}]}], "}"}], ",", ".005"}], "]"}], 
            "]"}]}], "}"}], ",", "Thick", ",", "arrowaa1", ",", " ", 
         "arrowbb1", ",", " ", "arrowcc1", ",", "Blue", ",", " ", "arrowvv1", 
         ",", " ", "arrowww1", ",", " ", "LightBlue", ",", 
         RowBox[{"Opacity", "[", "0.8", "]"}], ",", 
         RowBox[{"Polygon", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "vv1"}], "-", "ww1"}], ",", 
            RowBox[{
             RowBox[{"-", "ww1"}], "-", "ww1"}], ",", 
            RowBox[{"vv1", "+", "ww1"}], ",", 
            RowBox[{"ww1", "-", "vv1", "+", "ww1"}], ",", 
            RowBox[{"-", "vv1"}]}], "}"}], "]"}]}], "}"}], ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"aa1", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ",", 
            RowBox[{"aa1", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"bb1", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ",", 
            RowBox[{"bb1", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"cc1", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ",", 
            RowBox[{"cc1", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}], "}"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", "0.333"}], "}"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"s", ",", "0.333"}], "}"}], ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<tube vector is restricted to the subspace\>\"", ",", "\"\< \>\"", 
        ",", "\"\<Planar subspace defined by blue vectors v and w. Tube = r*v \
+ s*w\>\"", ",", "\"\< \>\""}], "}"}]}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5848182553116703`*^9, 3.584818334391781*^9}, {
  3.5848183863918543`*^9, 3.5848184074818835`*^9}, {3.584818442241932*^9, 
  3.5848185446720753`*^9}, {3.5848970803924828`*^9, 3.5848970898424964`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`r$$ = 0.333, $CellContext`s$$ = 0.333, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`r$$], 0.333}, -1, 1}, {{
       Hold[$CellContext`s$$], 0.333}, -1, 1}}, Typeset`size$$ = {
    360., {193., 198.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`r$85159$$ = 
    0, $CellContext`s$85160$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`r$$ = 0.333, $CellContext`s$$ = 0.333}, 
      "ControllerVariables" :> {
        Hold[$CellContext`r$$, $CellContext`r$85159$$, 0], 
        Hold[$CellContext`s$$, $CellContext`s$85160$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics3D[{{
          Arrowheads[0.06], 
          Arrow[
           
           Tube[{{0, 0, 
             0}, $CellContext`r$$ $CellContext`vv1 + $CellContext`s$$ \
$CellContext`ww1}, 0.005]]}, 
         Thick, $CellContext`arrowaa1, $CellContext`arrowbb1, \
$CellContext`arrowcc1, Blue, $CellContext`arrowvv1, $CellContext`arrowww1, 
         LightBlue, 
         Opacity[0.8], 
         Polygon[{-$CellContext`vv1 - $CellContext`ww1, -$CellContext`ww1 - \
$CellContext`ww1, $CellContext`vv1 + $CellContext`ww1, $CellContext`ww1 - \
$CellContext`vv1 + $CellContext`ww1, -$CellContext`vv1}]}, Boxed -> False, 
        PlotRange -> {{-Part[$CellContext`aa1, 1], 
           Part[$CellContext`aa1, 1]}, {-Part[$CellContext`bb1, 1], 
           Part[$CellContext`bb1, 1]}, {-Part[$CellContext`cc1, 1], 
           Part[$CellContext`cc1, 1]}}], 
      "Specifications" :> {{{$CellContext`r$$, 0.333}, -1, 
         1}, {{$CellContext`s$$, 0.333}, -1, 1}}, 
      "Options" :> {
       FrameLabel -> {
         "tube vector is restricted to the subspace", " ", 
          "Planar subspace defined by blue vectors v and w. Tube = r*v + s*w",
           " "}}, "DefaultOptions" :> {}],
     ImageSizeCache->{433., {278., 283.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.584818342151792*^9, 3.5848184593219557`*^9, {3.584818500032013*^9, 
   3.584818529392054*^9}, 3.584897017302395*^9, 3.5848970907324977`*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{885, 630},
WindowMargins->{{Automatic, 18}, {45, Automatic}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 691, 12, 107, "Subtitle"],
Cell[1273, 36, 923, 15, 238, "Subsubtitle"],
Cell[CellGroupData[{
Cell[2221, 55, 6234, 167, 552, "Input"],
Cell[8458, 224, 2880, 59, 578, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
