(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    130563,       2878]
NotebookOptionsPosition[    130123,       2858]
NotebookOutlinePosition[    130466,       2873]
CellTagsIndexPosition[    130423,       2870]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Practical Linear Algebra: A Geometry Toolbox, Third edition",
  FontWeight->"Bold",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]],
 StyleBox["\nGerald Farin & Dianne Hansford\nCRC Press, Taylor & Francis \
Group, An A K Peters Book, 2013",
  FontColor->RGBColor[0.7019607843137254, 0.34901960784313724`, 0.]]
}], "Subtitle",
 CellChangeTimes->{{3.4991094606434994`*^9, 3.499109474090723*^9}, {
   3.5373646957107067`*^9, 3.53736471444634*^9}, {3.5374511355396433`*^9, 
   3.5374511374740467`*^9}, {3.5376327574376*^9, 3.5376327584984016`*^9}, {
   3.5842134956497355`*^9, 3.5842135862546945`*^9}, 3.584477471526898*^9},
 FontFamily->"Arial"],

Cell[TextData[{
 "\n",
 StyleBox["Plot a triangulated surface",
  FontWeight->"Bold"],
 "\nCreate an n x n grid of (x,y) points, triangulate, and assign a z-value\n\
See Section 17.7 Breaking it Up: Triangles, 3D Triangulations"
}], "Subsubtitle",
 CellChangeTimes->{{3.5847210188956556`*^9, 3.5847210258156652`*^9}, {
  3.5847210797157407`*^9, 3.5847211180477953`*^9}, {3.5847215488283987`*^9, 
  3.5847215879784536`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Needs", "[", "\"\<ComputationalGeometry`\>\"", "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"create", " ", "memory", " ", "for", " ", 
     RowBox[{"(", 
      RowBox[{"x", ",", "y", ",", "z"}], ")"}], " ", 
     RowBox[{"data", " ", "--"}], " ", "there", " ", "are", "  ", "nrc", " ", 
     "x", " ", "nrc"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nrc", " ", "=", " ", "20"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"num", " ", "=", " ", 
     RowBox[{"nrc", "^", "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"points", " ", "=", " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "num"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"domain", " ", "of", " ", "x"}], ",", 
     RowBox[{"y", " ", 
      RowBox[{"is", " ", "[", 
       RowBox[{"1", ",", "nrc"}], "]"}]}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"z", "-", 
     RowBox[{
     "value", " ", "comes", " ", "from", " ", "evaluating", " ", "a", " ", 
      "function", " ", 
      RowBox[{"over", " ", "[", 
       RowBox[{
        RowBox[{"-", "d"}], ",", "d"}], "]"}]}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"d", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"fct", "[", 
      RowBox[{"du_", ",", "dv_"}], "]"}], " ", ":=", " ", 
     RowBox[{
      RowBox[{"4", 
       RowBox[{"du", "^", "2"}]}], "+", 
      RowBox[{"dv", "^", "2"}]}]}], ";"}], " ", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"fct", "[", 
       RowBox[{"du_", ",", "dv_"}], "]"}], " ", ":=", " ", 
      RowBox[{
       RowBox[{"Sin", "[", "du", "]"}], "+", 
       RowBox[{"dv", "^", "2"}]}]}], ";"}], " ", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"count", " ", "=", " ", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Do", "[", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"u", " ", 
       RowBox[{"in", " ", "[", 
        RowBox[{"0", ",", "1"}], "]"}]}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"u", " ", "=", " ", 
        RowBox[{"i", "/", "nrc"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"(*", " ", 
        RowBox[{"linear", " ", "interpolation", " ", "in", " ", "domain"}], 
        " ", "*)"}], "\[IndentingNewLine]", 
       RowBox[{"du", " ", "=", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "u"}], ")"}], "*", 
          RowBox[{"d", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], " ", "+", " ", 
         RowBox[{"u", "*", 
          RowBox[{"d", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Do", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"v", " ", "=", " ", 
            RowBox[{"j", "/", "nrc"}]}], ";", "\[IndentingNewLine]", 
           RowBox[{"dv", " ", "=", " ", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "v"}], ")"}], "*", 
              RowBox[{"d", "[", 
               RowBox[{"[", "1", "]"}], "]"}]}], " ", "+", " ", 
             RowBox[{"v", "*", 
              RowBox[{"d", "[", 
               RowBox[{"[", "2", "]"}], "]"}]}]}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"count", " ", "=", " ", 
            RowBox[{"count", " ", "+", " ", "1"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"points", "[", 
             RowBox[{"[", 
              RowBox[{"count", ",", "1"}], "]"}], "]"}], " ", "=", " ", "i"}],
            ";", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"points", "[", 
             RowBox[{"[", 
              RowBox[{"count", ",", "2"}], "]"}], "]"}], " ", "=", " ", "j"}],
            ";", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"points", "[", 
             RowBox[{"[", 
              RowBox[{"count", ",", "3"}], "]"}], "]"}], " ", "=", 
            RowBox[{"fct", "[", 
             RowBox[{"du", ",", "dv"}], "]"}]}]}], ")"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"j", ",", "1", ",", "nrc"}], "}"}]}], "]"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "nrc"}], "}"}]}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"TriangularSurfacePlot", "[", 
    RowBox[{"points", ",", " ", 
     RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}], ",", " ", 
     RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.564672039036339*^9, 3.5646722609461293`*^9}, {
   3.56467230695061*^9, 3.5646723517850885`*^9}, {3.5646723984915705`*^9, 
   3.564672493199337*^9}, {3.5646725267861967`*^9, 3.564672562525859*^9}, {
   3.5646725973763204`*^9, 3.564672665922841*^9}, {3.564672969530574*^9, 
   3.564673013397851*^9}, {3.5646730867179794`*^9, 3.5646732505962677`*^9}, {
   3.564673281531122*^9, 3.564673307754768*^9}, {3.564673337769221*^9, 
   3.5646733426364293`*^9}, {3.564673454830637*^9, 3.5646735391643853`*^9}, {
   3.564673569350438*^9, 3.5646735920328784`*^9}, {3.5646736623422017`*^9, 
   3.5646737367855325`*^9}, {3.5646738370001087`*^9, 
   3.5646739561063175`*^9}, {3.564673992157981*^9, 3.564673992672782*^9}, {
   3.5646783584997835`*^9, 3.56467849331522*^9}, {3.564678559864937*^9, 
   3.5646788084981737`*^9}, {3.5646788423190327`*^9, 3.5646788460786395`*^9}, 
   3.5646788865139103`*^9, {3.5646789384932017`*^9, 3.564678961394042*^9}, {
   3.5646789997077093`*^9, 3.56467900020691*^9}, 3.5847210424156885`*^9, {
   3.5847211252478056`*^9, 3.5847212180479355`*^9}, {3.584721290658037*^9, 
   3.5847215003983307`*^9}}],

Cell[BoxData[
 Graphics3DBox[{
   Polygon3DBox[
    NCache[{{1, 1, Rational[81, 5]}, {1, 2, Rational[388, 25]}, {
      2, 2, Rational[64, 5]}}, {{1, 1, 16.2}, {1, 2, 15.52}, {2, 2, 12.8}}]], 
   Polygon3DBox[
    NCache[{{1, 1, Rational[81, 5]}, {2, 1, Rational[337, 25]}, {
      2, 2, Rational[64, 5]}}, {{1, 1, 16.2}, {2, 1, 13.48}, {2, 2, 12.8}}]], 
   Polygon3DBox[
    NCache[{{1, 2, Rational[388, 25]}, {1, 3, Rational[373, 25]}, {
      2, 3, Rational[61, 5]}}, {{1, 2, 15.52}, {1, 3, 14.92}, {2, 3, 12.2}}]],
    Polygon3DBox[
    NCache[{{1, 2, Rational[388, 25]}, {2, 2, Rational[64, 5]}, {
      2, 3, Rational[61, 5]}}, {{1, 2, 15.52}, {2, 2, 12.8}, {2, 3, 12.2}}]], 
   Polygon3DBox[
    NCache[{{1, 3, Rational[373, 25]}, {1, 4, Rational[72, 5]}, {
      2, 4, Rational[292, 25]}}, {{1, 3, 14.92}, {1, 4, 14.4}, {
      2, 4, 11.68}}]], 
   Polygon3DBox[
    NCache[{{1, 3, Rational[373, 25]}, {2, 3, Rational[61, 5]}, {
      2, 4, Rational[292, 25]}}, {{1, 3, 14.92}, {2, 3, 12.2}, {
      2, 4, 11.68}}]], 
   Polygon3DBox[
    NCache[{{1, 4, Rational[72, 5]}, {1, 5, Rational[349, 25]}, {
      2, 5, Rational[281, 25]}}, {{1, 4, 14.4}, {1, 5, 13.96}, {
      2, 5, 11.24}}]], 
   Polygon3DBox[
    NCache[{{1, 4, Rational[72, 5]}, {2, 4, Rational[292, 25]}, {
      2, 5, Rational[281, 25]}}, {{1, 4, 14.4}, {2, 4, 11.68}, {
      2, 5, 11.24}}]], 
   Polygon3DBox[
    NCache[{{1, 5, Rational[349, 25]}, {1, 6, Rational[68, 5]}, {
      2, 6, Rational[272, 25]}}, {{1, 5, 13.96}, {1, 6, 13.6}, {
      2, 6, 10.88}}]], 
   Polygon3DBox[
    NCache[{{1, 5, Rational[349, 25]}, {2, 5, Rational[281, 25]}, {
      2, 6, Rational[272, 25]}}, {{1, 5, 13.96}, {2, 5, 11.24}, {
      2, 6, 10.88}}]], 
   Polygon3DBox[
    NCache[{{1, 6, Rational[68, 5]}, {1, 7, Rational[333, 25]}, {
      2, 7, Rational[53, 5]}}, {{1, 6, 13.6}, {1, 7, 13.32}, {2, 7, 10.6}}]], 
   Polygon3DBox[
    NCache[{{1, 6, Rational[68, 5]}, {2, 6, Rational[272, 25]}, {
      2, 7, Rational[53, 5]}}, {{1, 6, 13.6}, {2, 6, 10.88}, {2, 7, 10.6}}]], 
   Polygon3DBox[
    NCache[{{1, 7, Rational[333, 25]}, {1, 8, Rational[328, 25]}, {
      2, 8, Rational[52, 5]}}, {{1, 7, 13.32}, {1, 8, 13.12}, {2, 8, 10.4}}]],
    Polygon3DBox[
    NCache[{{1, 7, Rational[333, 25]}, {2, 7, Rational[53, 5]}, {
      2, 8, Rational[52, 5]}}, {{1, 7, 13.32}, {2, 7, 10.6}, {2, 8, 10.4}}]], 
   Polygon3DBox[
    NCache[{{1, 8, Rational[328, 25]}, {1, 9, 13}, {
      2, 9, Rational[257, 25]}}, {{1, 8, 13.12}, {1, 9, 13}, {2, 9, 10.28}}]],
    Polygon3DBox[
    NCache[{{1, 8, Rational[328, 25]}, {2, 8, Rational[52, 5]}, {
      2, 9, Rational[257, 25]}}, {{1, 8, 13.12}, {2, 8, 10.4}, {
      2, 9, 10.28}}]], 
   Polygon3DBox[
    NCache[{{1, 9, 13}, {1, 10, Rational[324, 25]}, {
      2, 10, Rational[256, 25]}}, {{1, 9, 13}, {1, 10, 12.96}, {
      2, 10, 10.24}}]], 
   Polygon3DBox[
    NCache[{{1, 9, 13}, {2, 9, Rational[257, 25]}, {
      2, 10, Rational[256, 25]}}, {{1, 9, 13}, {2, 9, 10.28}, {
      2, 10, 10.24}}]], 
   Polygon3DBox[
    NCache[{{1, 10, Rational[324, 25]}, {1, 11, 13}, {
      2, 11, Rational[257, 25]}}, {{1, 10, 12.96}, {1, 11, 13}, {
      2, 11, 10.28}}]], 
   Polygon3DBox[
    NCache[{{1, 10, Rational[324, 25]}, {2, 10, Rational[256, 25]}, {
      2, 11, Rational[257, 25]}}, {{1, 10, 12.96}, {2, 10, 10.24}, {
      2, 11, 10.28}}]], 
   Polygon3DBox[
    NCache[{{1, 11, 13}, {1, 12, Rational[328, 25]}, {
      2, 12, Rational[52, 5]}}, {{1, 11, 13}, {1, 12, 13.12}, {
      2, 12, 10.4}}]], 
   Polygon3DBox[
    NCache[{{1, 11, 13}, {2, 11, Rational[257, 25]}, {
      2, 12, Rational[52, 5]}}, {{1, 11, 13}, {2, 11, 10.28}, {
      2, 12, 10.4}}]], 
   Polygon3DBox[
    NCache[{{1, 12, Rational[328, 25]}, {1, 13, Rational[333, 25]}, {
      2, 13, Rational[53, 5]}}, {{1, 12, 13.12}, {1, 13, 13.32}, {
      2, 13, 10.6}}]], 
   Polygon3DBox[
    NCache[{{1, 12, Rational[328, 25]}, {2, 12, Rational[52, 5]}, {
      2, 13, Rational[53, 5]}}, {{1, 12, 13.12}, {2, 12, 10.4}, {
      2, 13, 10.6}}]], 
   Polygon3DBox[
    NCache[{{1, 13, Rational[333, 25]}, {1, 14, Rational[68, 5]}, {
      2, 14, Rational[272, 25]}}, {{1, 13, 13.32}, {1, 14, 13.6}, {
      2, 14, 10.88}}]], 
   Polygon3DBox[
    NCache[{{1, 13, Rational[333, 25]}, {2, 13, Rational[53, 5]}, {
      2, 14, Rational[272, 25]}}, {{1, 13, 13.32}, {2, 13, 10.6}, {
      2, 14, 10.88}}]], 
   Polygon3DBox[
    NCache[{{1, 14, Rational[68, 5]}, {1, 15, Rational[349, 25]}, {
      2, 15, Rational[281, 25]}}, {{1, 14, 13.6}, {1, 15, 13.96}, {
      2, 15, 11.24}}]], 
   Polygon3DBox[
    NCache[{{1, 14, Rational[68, 5]}, {2, 14, Rational[272, 25]}, {
      2, 15, Rational[281, 25]}}, {{1, 14, 13.6}, {2, 14, 10.88}, {
      2, 15, 11.24}}]], 
   Polygon3DBox[
    NCache[{{1, 15, Rational[349, 25]}, {1, 16, Rational[72, 5]}, {
      2, 16, Rational[292, 25]}}, {{1, 15, 13.96}, {1, 16, 14.4}, {
      2, 16, 11.68}}]], 
   Polygon3DBox[
    NCache[{{1, 15, Rational[349, 25]}, {2, 15, Rational[281, 25]}, {
      2, 16, Rational[292, 25]}}, {{1, 15, 13.96}, {2, 15, 11.24}, {
      2, 16, 11.68}}]], 
   Polygon3DBox[
    NCache[{{1, 16, Rational[72, 5]}, {1, 17, Rational[373, 25]}, {
      2, 17, Rational[61, 5]}}, {{1, 16, 14.4}, {1, 17, 14.92}, {
      2, 17, 12.2}}]], 
   Polygon3DBox[
    NCache[{{1, 16, Rational[72, 5]}, {2, 16, Rational[292, 25]}, {
      2, 17, Rational[61, 5]}}, {{1, 16, 14.4}, {2, 16, 11.68}, {
      2, 17, 12.2}}]], 
   Polygon3DBox[
    NCache[{{1, 17, Rational[373, 25]}, {1, 18, Rational[388, 25]}, {
      2, 18, Rational[64, 5]}}, {{1, 17, 14.92}, {1, 18, 15.52}, {
      2, 18, 12.8}}]], 
   Polygon3DBox[
    NCache[{{1, 17, Rational[373, 25]}, {2, 17, Rational[61, 5]}, {
      2, 18, Rational[64, 5]}}, {{1, 17, 14.92}, {2, 17, 12.2}, {
      2, 18, 12.8}}]], 
   Polygon3DBox[
    NCache[{{1, 18, Rational[388, 25]}, {1, 19, Rational[81, 5]}, {
      2, 19, Rational[337, 25]}}, {{1, 18, 15.52}, {1, 19, 16.2}, {
      2, 19, 13.48}}]], 
   Polygon3DBox[
    NCache[{{1, 18, Rational[388, 25]}, {2, 18, Rational[64, 5]}, {
      2, 19, Rational[337, 25]}}, {{1, 18, 15.52}, {2, 18, 12.8}, {
      2, 19, 13.48}}]], 
   Polygon3DBox[
    NCache[{{1, 19, Rational[81, 5]}, {1, 20, Rational[424, 25]}, {
      2, 20, Rational[356, 25]}}, {{1, 19, 16.2}, {1, 20, 16.96}, {
      2, 20, 14.24}}]], 
   Polygon3DBox[
    NCache[{{1, 19, Rational[81, 5]}, {2, 19, Rational[337, 25]}, {
      2, 20, Rational[356, 25]}}, {{1, 19, 16.2}, {2, 19, 13.48}, {
      2, 20, 14.24}}]], 
   Polygon3DBox[
    NCache[{{2, 1, Rational[337, 25]}, {2, 2, Rational[64, 5]}, {
      3, 2, Rational[52, 5]}}, {{2, 1, 13.48}, {2, 2, 12.8}, {3, 2, 10.4}}]], 
   Polygon3DBox[
    NCache[{{2, 1, Rational[337, 25]}, {3, 1, Rational[277, 25]}, {
      3, 2, Rational[52, 5]}}, {{2, 1, 13.48}, {3, 1, 11.08}, {3, 2, 10.4}}]],
    Polygon3DBox[
    NCache[{{2, 2, Rational[64, 5]}, {2, 3, Rational[61, 5]}, {
      3, 3, Rational[49, 5]}}, {{2, 2, 12.8}, {2, 3, 12.2}, {3, 3, 9.8}}]], 
   Polygon3DBox[
    NCache[{{2, 2, Rational[64, 5]}, {3, 2, Rational[52, 5]}, {
      3, 3, Rational[49, 5]}}, {{2, 2, 12.8}, {3, 2, 10.4}, {3, 3, 9.8}}]], 
   Polygon3DBox[
    NCache[{{2, 3, Rational[61, 5]}, {2, 4, Rational[292, 25]}, {
      3, 4, Rational[232, 25]}}, {{2, 3, 12.2}, {2, 4, 11.68}, {
      3, 4, 9.28}}]], 
   Polygon3DBox[
    NCache[{{2, 3, Rational[61, 5]}, {3, 3, Rational[49, 5]}, {
      3, 4, Rational[232, 25]}}, {{2, 3, 12.2}, {3, 3, 9.8}, {3, 4, 9.28}}]], 
   Polygon3DBox[
    NCache[{{2, 4, Rational[292, 25]}, {2, 5, Rational[281, 25]}, {
      3, 5, Rational[221, 25]}}, {{2, 4, 11.68}, {2, 5, 11.24}, {
      3, 5, 8.84}}]], 
   Polygon3DBox[
    NCache[{{2, 4, Rational[292, 25]}, {3, 4, Rational[232, 25]}, {
      3, 5, Rational[221, 25]}}, {{2, 4, 11.68}, {3, 4, 9.28}, {
      3, 5, 8.84}}]], 
   Polygon3DBox[
    NCache[{{2, 5, Rational[281, 25]}, {2, 6, Rational[272, 25]}, {
      3, 6, Rational[212, 25]}}, {{2, 5, 11.24}, {2, 6, 10.88}, {
      3, 6, 8.48}}]], 
   Polygon3DBox[
    NCache[{{2, 5, Rational[281, 25]}, {3, 5, Rational[221, 25]}, {
      3, 6, Rational[212, 25]}}, {{2, 5, 11.24}, {3, 5, 8.84}, {
      3, 6, 8.48}}]], 
   Polygon3DBox[
    NCache[{{2, 6, Rational[272, 25]}, {2, 7, Rational[53, 5]}, {
      3, 7, Rational[41, 5]}}, {{2, 6, 10.88}, {2, 7, 10.6}, {3, 7, 8.2}}]], 
   Polygon3DBox[
    NCache[{{2, 6, Rational[272, 25]}, {3, 6, Rational[212, 25]}, {
      3, 7, Rational[41, 5]}}, {{2, 6, 10.88}, {3, 6, 8.48}, {3, 7, 8.2}}]], 
   Polygon3DBox[
    NCache[{{2, 7, Rational[53, 5]}, {2, 8, Rational[52, 5]}, {3, 8, 8}}, {{
      2, 7, 10.6}, {2, 8, 10.4}, {3, 8, 8}}]], 
   Polygon3DBox[
    NCache[{{2, 7, Rational[53, 5]}, {3, 7, Rational[41, 5]}, {3, 8, 8}}, {{
      2, 7, 10.6}, {3, 7, 8.2}, {3, 8, 8}}]], 
   Polygon3DBox[
    NCache[{{2, 8, Rational[52, 5]}, {2, 9, Rational[257, 25]}, {
      3, 9, Rational[197, 25]}}, {{2, 8, 10.4}, {2, 9, 10.28}, {
      3, 9, 7.88}}]], 
   Polygon3DBox[
    NCache[{{2, 8, Rational[52, 5]}, {3, 8, 8}, {3, 9, Rational[197, 25]}}, {{
      2, 8, 10.4}, {3, 8, 8}, {3, 9, 7.88}}]], 
   Polygon3DBox[
    NCache[{{2, 9, Rational[257, 25]}, {2, 10, Rational[256, 25]}, {
      3, 10, Rational[196, 25]}}, {{2, 9, 10.28}, {2, 10, 10.24}, {
      3, 10, 7.84}}]], 
   Polygon3DBox[
    NCache[{{2, 9, Rational[257, 25]}, {3, 9, Rational[197, 25]}, {
      3, 10, Rational[196, 25]}}, {{2, 9, 10.28}, {3, 9, 7.88}, {
      3, 10, 7.84}}]], 
   Polygon3DBox[
    NCache[{{2, 10, Rational[256, 25]}, {2, 11, Rational[257, 25]}, {
      3, 11, Rational[197, 25]}}, {{2, 10, 10.24}, {2, 11, 10.28}, {
      3, 11, 7.88}}]], 
   Polygon3DBox[
    NCache[{{2, 10, Rational[256, 25]}, {3, 10, Rational[196, 25]}, {
      3, 11, Rational[197, 25]}}, {{2, 10, 10.24}, {3, 10, 7.84}, {
      3, 11, 7.88}}]], 
   Polygon3DBox[
    NCache[{{2, 11, Rational[257, 25]}, {2, 12, Rational[52, 5]}, {3, 12, 
      8}}, {{2, 11, 10.28}, {2, 12, 10.4}, {3, 12, 8}}]], 
   Polygon3DBox[
    NCache[{{2, 11, Rational[257, 25]}, {3, 11, Rational[197, 25]}, {3, 12, 
      8}}, {{2, 11, 10.28}, {3, 11, 7.88}, {3, 12, 8}}]], 
   Polygon3DBox[
    NCache[{{2, 12, Rational[52, 5]}, {2, 13, Rational[53, 5]}, {
      3, 13, Rational[41, 5]}}, {{2, 12, 10.4}, {2, 13, 10.6}, {
      3, 13, 8.2}}]], 
   Polygon3DBox[
    NCache[{{2, 12, Rational[52, 5]}, {3, 12, 8}, {
      3, 13, Rational[41, 5]}}, {{2, 12, 10.4}, {3, 12, 8}, {3, 13, 8.2}}]], 
   Polygon3DBox[
    NCache[{{2, 13, Rational[53, 5]}, {2, 14, Rational[272, 25]}, {
      3, 14, Rational[212, 25]}}, {{2, 13, 10.6}, {2, 14, 10.88}, {
      3, 14, 8.48}}]], 
   Polygon3DBox[
    NCache[{{2, 13, Rational[53, 5]}, {3, 13, Rational[41, 5]}, {
      3, 14, Rational[212, 25]}}, {{2, 13, 10.6}, {3, 13, 8.2}, {
      3, 14, 8.48}}]], 
   Polygon3DBox[
    NCache[{{2, 14, Rational[272, 25]}, {2, 15, Rational[281, 25]}, {
      3, 15, Rational[221, 25]}}, {{2, 14, 10.88}, {2, 15, 11.24}, {
      3, 15, 8.84}}]], 
   Polygon3DBox[
    NCache[{{2, 14, Rational[272, 25]}, {3, 14, Rational[212, 25]}, {
      3, 15, Rational[221, 25]}}, {{2, 14, 10.88}, {3, 14, 8.48}, {
      3, 15, 8.84}}]], 
   Polygon3DBox[
    NCache[{{2, 15, Rational[281, 25]}, {2, 16, Rational[292, 25]}, {
      3, 16, Rational[232, 25]}}, {{2, 15, 11.24}, {2, 16, 11.68}, {
      3, 16, 9.28}}]], 
   Polygon3DBox[
    NCache[{{2, 15, Rational[281, 25]}, {3, 15, Rational[221, 25]}, {
      3, 16, Rational[232, 25]}}, {{2, 15, 11.24}, {3, 15, 8.84}, {
      3, 16, 9.28}}]], 
   Polygon3DBox[
    NCache[{{2, 16, Rational[292, 25]}, {2, 17, Rational[61, 5]}, {
      3, 17, Rational[49, 5]}}, {{2, 16, 11.68}, {2, 17, 12.2}, {
      3, 17, 9.8}}]], 
   Polygon3DBox[
    NCache[{{2, 16, Rational[292, 25]}, {3, 16, Rational[232, 25]}, {
      3, 17, Rational[49, 5]}}, {{2, 16, 11.68}, {3, 16, 9.28}, {
      3, 17, 9.8}}]], 
   Polygon3DBox[
    NCache[{{2, 17, Rational[61, 5]}, {2, 18, Rational[64, 5]}, {
      3, 18, Rational[52, 5]}}, {{2, 17, 12.2}, {2, 18, 12.8}, {
      3, 18, 10.4}}]], 
   Polygon3DBox[
    NCache[{{2, 17, Rational[61, 5]}, {3, 17, Rational[49, 5]}, {
      3, 18, Rational[52, 5]}}, {{2, 17, 12.2}, {3, 17, 9.8}, {
      3, 18, 10.4}}]], 
   Polygon3DBox[
    NCache[{{2, 18, Rational[64, 5]}, {2, 19, Rational[337, 25]}, {
      3, 19, Rational[277, 25]}}, {{2, 18, 12.8}, {2, 19, 13.48}, {
      3, 19, 11.08}}]], 
   Polygon3DBox[
    NCache[{{2, 18, Rational[64, 5]}, {3, 18, Rational[52, 5]}, {
      3, 19, Rational[277, 25]}}, {{2, 18, 12.8}, {3, 18, 10.4}, {
      3, 19, 11.08}}]], 
   Polygon3DBox[
    NCache[{{2, 19, Rational[337, 25]}, {2, 20, Rational[356, 25]}, {
      3, 20, Rational[296, 25]}}, {{2, 19, 13.48}, {2, 20, 14.24}, {
      3, 20, 11.84}}]], 
   Polygon3DBox[
    NCache[{{2, 19, Rational[337, 25]}, {3, 19, Rational[277, 25]}, {
      3, 20, Rational[296, 25]}}, {{2, 19, 13.48}, {3, 19, 11.08}, {
      3, 20, 11.84}}]], 
   Polygon3DBox[
    NCache[{{3, 1, Rational[277, 25]}, {3, 2, Rational[52, 5]}, {
      4, 2, Rational[208, 25]}}, {{3, 1, 11.08}, {3, 2, 10.4}, {
      4, 2, 8.32}}]], 
   Polygon3DBox[
    NCache[{{3, 1, Rational[277, 25]}, {4, 1, 9}, {
      4, 2, Rational[208, 25]}}, {{3, 1, 11.08}, {4, 1, 9}, {4, 2, 8.32}}]], 
   Polygon3DBox[
    NCache[{{3, 2, Rational[52, 5]}, {3, 3, Rational[49, 5]}, {
      4, 3, Rational[193, 25]}}, {{3, 2, 10.4}, {3, 3, 9.8}, {4, 3, 7.72}}]], 
   Polygon3DBox[
    NCache[{{3, 2, Rational[52, 5]}, {4, 2, Rational[208, 25]}, {
      4, 3, Rational[193, 25]}}, {{3, 2, 10.4}, {4, 2, 8.32}, {4, 3, 7.72}}]],
    Polygon3DBox[
    NCache[{{3, 3, Rational[49, 5]}, {3, 4, Rational[232, 25]}, {
      4, 4, Rational[36, 5]}}, {{3, 3, 9.8}, {3, 4, 9.28}, {4, 4, 7.2}}]], 
   Polygon3DBox[
    NCache[{{3, 3, Rational[49, 5]}, {4, 3, Rational[193, 25]}, {
      4, 4, Rational[36, 5]}}, {{3, 3, 9.8}, {4, 3, 7.72}, {4, 4, 7.2}}]], 
   Polygon3DBox[
    NCache[{{3, 4, Rational[232, 25]}, {3, 5, Rational[221, 25]}, {
      4, 5, Rational[169, 25]}}, {{3, 4, 9.28}, {3, 5, 8.84}, {4, 5, 6.76}}]],
    Polygon3DBox[
    NCache[{{3, 4, Rational[232, 25]}, {4, 4, Rational[36, 5]}, {
      4, 5, Rational[169, 25]}}, {{3, 4, 9.28}, {4, 4, 7.2}, {4, 5, 6.76}}]], 
   Polygon3DBox[
    NCache[{{3, 5, Rational[221, 25]}, {3, 6, Rational[212, 25]}, {
      4, 6, Rational[32, 5]}}, {{3, 5, 8.84}, {3, 6, 8.48}, {4, 6, 6.4}}]], 
   Polygon3DBox[
    NCache[{{3, 5, Rational[221, 25]}, {4, 5, Rational[169, 25]}, {
      4, 6, Rational[32, 5]}}, {{3, 5, 8.84}, {4, 5, 6.76}, {4, 6, 6.4}}]], 
   Polygon3DBox[
    NCache[{{3, 6, Rational[212, 25]}, {3, 7, Rational[41, 5]}, {
      4, 7, Rational[153, 25]}}, {{3, 6, 8.48}, {3, 7, 8.2}, {4, 7, 6.12}}]], 
   Polygon3DBox[
    NCache[{{3, 6, Rational[212, 25]}, {4, 6, Rational[32, 5]}, {
      4, 7, Rational[153, 25]}}, {{3, 6, 8.48}, {4, 6, 6.4}, {4, 7, 6.12}}]], 
   Polygon3DBox[
    NCache[{{3, 7, Rational[41, 5]}, {3, 8, 8}, {4, 8, Rational[148, 25]}}, {{
      3, 7, 8.2}, {3, 8, 8}, {4, 8, 5.92}}]], 
   Polygon3DBox[
    NCache[{{3, 7, Rational[41, 5]}, {4, 7, Rational[153, 25]}, {
      4, 8, Rational[148, 25]}}, {{3, 7, 8.2}, {4, 7, 6.12}, {4, 8, 5.92}}]], 
   Polygon3DBox[
    NCache[{{3, 8, 8}, {3, 9, Rational[197, 25]}, {4, 9, Rational[29, 5]}}, {{
      3, 8, 8}, {3, 9, 7.88}, {4, 9, 5.8}}]], 
   Polygon3DBox[
    NCache[{{3, 8, 8}, {4, 8, Rational[148, 25]}, {4, 9, Rational[29, 5]}}, {{
      3, 8, 8}, {4, 8, 5.92}, {4, 9, 5.8}}]], 
   Polygon3DBox[
    NCache[{{3, 9, Rational[197, 25]}, {3, 10, Rational[196, 25]}, {
      4, 10, Rational[144, 25]}}, {{3, 9, 7.88}, {3, 10, 7.84}, {
      4, 10, 5.76}}]], 
   Polygon3DBox[
    NCache[{{3, 9, Rational[197, 25]}, {4, 9, Rational[29, 5]}, {
      4, 10, Rational[144, 25]}}, {{3, 9, 7.88}, {4, 9, 5.8}, {
      4, 10, 5.76}}]], 
   Polygon3DBox[
    NCache[{{3, 10, Rational[196, 25]}, {3, 11, Rational[197, 25]}, {
      4, 11, Rational[29, 5]}}, {{3, 10, 7.84}, {3, 11, 7.88}, {
      4, 11, 5.8}}]], 
   Polygon3DBox[
    NCache[{{3, 10, Rational[196, 25]}, {4, 10, Rational[144, 25]}, {
      4, 11, Rational[29, 5]}}, {{3, 10, 7.84}, {4, 10, 5.76}, {
      4, 11, 5.8}}]], 
   Polygon3DBox[
    NCache[{{3, 11, Rational[197, 25]}, {3, 12, 8}, {
      4, 12, Rational[148, 25]}}, {{3, 11, 7.88}, {3, 12, 8}, {
      4, 12, 5.92}}]], 
   Polygon3DBox[
    NCache[{{3, 11, Rational[197, 25]}, {4, 11, Rational[29, 5]}, {
      4, 12, Rational[148, 25]}}, {{3, 11, 7.88}, {4, 11, 5.8}, {
      4, 12, 5.92}}]], 
   Polygon3DBox[
    NCache[{{3, 12, 8}, {3, 13, Rational[41, 5]}, {
      4, 13, Rational[153, 25]}}, {{3, 12, 8}, {3, 13, 8.2}, {4, 13, 6.12}}]],
    Polygon3DBox[
    NCache[{{3, 12, 8}, {4, 12, Rational[148, 25]}, {
      4, 13, Rational[153, 25]}}, {{3, 12, 8}, {4, 12, 5.92}, {
      4, 13, 6.12}}]], 
   Polygon3DBox[
    NCache[{{3, 13, Rational[41, 5]}, {3, 14, Rational[212, 25]}, {
      4, 14, Rational[32, 5]}}, {{3, 13, 8.2}, {3, 14, 8.48}, {4, 14, 6.4}}]],
    Polygon3DBox[
    NCache[{{3, 13, Rational[41, 5]}, {4, 13, Rational[153, 25]}, {
      4, 14, Rational[32, 5]}}, {{3, 13, 8.2}, {4, 13, 6.12}, {4, 14, 6.4}}]],
    Polygon3DBox[
    NCache[{{3, 14, Rational[212, 25]}, {3, 15, Rational[221, 25]}, {
      4, 15, Rational[169, 25]}}, {{3, 14, 8.48}, {3, 15, 8.84}, {
      4, 15, 6.76}}]], 
   Polygon3DBox[
    NCache[{{3, 14, Rational[212, 25]}, {4, 14, Rational[32, 5]}, {
      4, 15, Rational[169, 25]}}, {{3, 14, 8.48}, {4, 14, 6.4}, {
      4, 15, 6.76}}]], 
   Polygon3DBox[
    NCache[{{3, 15, Rational[221, 25]}, {3, 16, Rational[232, 25]}, {
      4, 16, Rational[36, 5]}}, {{3, 15, 8.84}, {3, 16, 9.28}, {
      4, 16, 7.2}}]], 
   Polygon3DBox[
    NCache[{{3, 15, Rational[221, 25]}, {4, 15, Rational[169, 25]}, {
      4, 16, Rational[36, 5]}}, {{3, 15, 8.84}, {4, 15, 6.76}, {
      4, 16, 7.2}}]], 
   Polygon3DBox[
    NCache[{{3, 16, Rational[232, 25]}, {3, 17, Rational[49, 5]}, {
      4, 17, Rational[193, 25]}}, {{3, 16, 9.28}, {3, 17, 9.8}, {
      4, 17, 7.72}}]], 
   Polygon3DBox[
    NCache[{{3, 16, Rational[232, 25]}, {4, 16, Rational[36, 5]}, {
      4, 17, Rational[193, 25]}}, {{3, 16, 9.28}, {4, 16, 7.2}, {
      4, 17, 7.72}}]], 
   Polygon3DBox[
    NCache[{{3, 17, Rational[49, 5]}, {3, 18, Rational[52, 5]}, {
      4, 18, Rational[208, 25]}}, {{3, 17, 9.8}, {3, 18, 10.4}, {
      4, 18, 8.32}}]], 
   Polygon3DBox[
    NCache[{{3, 17, Rational[49, 5]}, {4, 17, Rational[193, 25]}, {
      4, 18, Rational[208, 25]}}, {{3, 17, 9.8}, {4, 17, 7.72}, {
      4, 18, 8.32}}]], 
   Polygon3DBox[
    NCache[{{3, 18, Rational[52, 5]}, {3, 19, Rational[277, 25]}, {4, 19, 
      9}}, {{3, 18, 10.4}, {3, 19, 11.08}, {4, 19, 9}}]], 
   Polygon3DBox[
    NCache[{{3, 18, Rational[52, 5]}, {4, 18, Rational[208, 25]}, {4, 19, 
      9}}, {{3, 18, 10.4}, {4, 18, 8.32}, {4, 19, 9}}]], 
   Polygon3DBox[
    NCache[{{3, 19, Rational[277, 25]}, {3, 20, Rational[296, 25]}, {
      4, 20, Rational[244, 25]}}, {{3, 19, 11.08}, {3, 20, 11.84}, {
      4, 20, 9.76}}]], 
   Polygon3DBox[
    NCache[{{3, 19, Rational[277, 25]}, {4, 19, 9}, {
      4, 20, Rational[244, 25]}}, {{3, 19, 11.08}, {4, 19, 9}, {
      4, 20, 9.76}}]], 
   Polygon3DBox[
    NCache[{{4, 1, 9}, {4, 2, Rational[208, 25]}, {
      5, 2, Rational[164, 25]}}, {{4, 1, 9}, {4, 2, 8.32}, {5, 2, 6.56}}]], 
   Polygon3DBox[
    NCache[{{4, 1, 9}, {5, 1, Rational[181, 25]}, {
      5, 2, Rational[164, 25]}}, {{4, 1, 9}, {5, 1, 7.24}, {5, 2, 6.56}}]], 
   Polygon3DBox[
    NCache[{{4, 2, Rational[208, 25]}, {4, 3, Rational[193, 25]}, {
      5, 3, Rational[149, 25]}}, {{4, 2, 8.32}, {4, 3, 7.72}, {5, 3, 5.96}}]],
    Polygon3DBox[
    NCache[{{4, 2, Rational[208, 25]}, {5, 2, Rational[164, 25]}, {
      5, 3, Rational[149, 25]}}, {{4, 2, 8.32}, {5, 2, 6.56}, {5, 3, 5.96}}]],
    Polygon3DBox[
    NCache[{{4, 3, Rational[193, 25]}, {4, 4, Rational[36, 5]}, {
      5, 4, Rational[136, 25]}}, {{4, 3, 7.72}, {4, 4, 7.2}, {5, 4, 5.44}}]], 
   Polygon3DBox[
    NCache[{{4, 3, Rational[193, 25]}, {5, 3, Rational[149, 25]}, {
      5, 4, Rational[136, 25]}}, {{4, 3, 7.72}, {5, 3, 5.96}, {5, 4, 5.44}}]],
    Polygon3DBox[
    NCache[{{4, 4, Rational[36, 5]}, {4, 5, Rational[169, 25]}, {5, 5, 5}}, {{
      4, 4, 7.2}, {4, 5, 6.76}, {5, 5, 5}}]], 
   Polygon3DBox[
    NCache[{{4, 4, Rational[36, 5]}, {5, 4, Rational[136, 25]}, {5, 5, 5}}, {{
      4, 4, 7.2}, {5, 4, 5.44}, {5, 5, 5}}]], 
   Polygon3DBox[
    NCache[{{4, 5, Rational[169, 25]}, {4, 6, Rational[32, 5]}, {
      5, 6, Rational[116, 25]}}, {{4, 5, 6.76}, {4, 6, 6.4}, {5, 6, 4.64}}]], 
   Polygon3DBox[
    NCache[{{4, 5, Rational[169, 25]}, {5, 5, 5}, {
      5, 6, Rational[116, 25]}}, {{4, 5, 6.76}, {5, 5, 5}, {5, 6, 4.64}}]], 
   Polygon3DBox[
    NCache[{{4, 6, Rational[32, 5]}, {4, 7, Rational[153, 25]}, {
      5, 7, Rational[109, 25]}}, {{4, 6, 6.4}, {4, 7, 6.12}, {5, 7, 4.36}}]], 
   Polygon3DBox[
    NCache[{{4, 6, Rational[32, 5]}, {5, 6, Rational[116, 25]}, {
      5, 7, Rational[109, 25]}}, {{4, 6, 6.4}, {5, 6, 4.64}, {5, 7, 4.36}}]], 
   Polygon3DBox[
    NCache[{{4, 7, Rational[153, 25]}, {4, 8, Rational[148, 25]}, {
      5, 8, Rational[104, 25]}}, {{4, 7, 6.12}, {4, 8, 5.92}, {5, 8, 4.16}}]],
    Polygon3DBox[
    NCache[{{4, 7, Rational[153, 25]}, {5, 7, Rational[109, 25]}, {
      5, 8, Rational[104, 25]}}, {{4, 7, 6.12}, {5, 7, 4.36}, {5, 8, 4.16}}]],
    Polygon3DBox[
    NCache[{{4, 8, Rational[148, 25]}, {4, 9, Rational[29, 5]}, {
      5, 9, Rational[101, 25]}}, {{4, 8, 5.92}, {4, 9, 5.8}, {5, 9, 4.04}}]], 
   Polygon3DBox[
    NCache[{{4, 8, Rational[148, 25]}, {5, 8, Rational[104, 25]}, {
      5, 9, Rational[101, 25]}}, {{4, 8, 5.92}, {5, 8, 4.16}, {5, 9, 4.04}}]],
    Polygon3DBox[
    NCache[{{4, 9, Rational[29, 5]}, {4, 10, Rational[144, 25]}, {5, 10, 
      4}}, {{4, 9, 5.8}, {4, 10, 5.76}, {5, 10, 4}}]], 
   Polygon3DBox[
    NCache[{{4, 9, Rational[29, 5]}, {5, 9, Rational[101, 25]}, {5, 10, 
      4}}, {{4, 9, 5.8}, {5, 9, 4.04}, {5, 10, 4}}]], 
   Polygon3DBox[
    NCache[{{4, 10, Rational[144, 25]}, {4, 11, Rational[29, 5]}, {
      5, 11, Rational[101, 25]}}, {{4, 10, 5.76}, {4, 11, 5.8}, {
      5, 11, 4.04}}]], 
   Polygon3DBox[
    NCache[{{4, 10, Rational[144, 25]}, {5, 10, 4}, {
      5, 11, Rational[101, 25]}}, {{4, 10, 5.76}, {5, 10, 4}, {
      5, 11, 4.04}}]], 
   Polygon3DBox[
    NCache[{{4, 11, Rational[29, 5]}, {4, 12, Rational[148, 25]}, {
      5, 12, Rational[104, 25]}}, {{4, 11, 5.8}, {4, 12, 5.92}, {
      5, 12, 4.16}}]], 
   Polygon3DBox[
    NCache[{{4, 11, Rational[29, 5]}, {5, 11, Rational[101, 25]}, {
      5, 12, Rational[104, 25]}}, {{4, 11, 5.8}, {5, 11, 4.04}, {
      5, 12, 4.16}}]], 
   Polygon3DBox[
    NCache[{{4, 12, Rational[148, 25]}, {4, 13, Rational[153, 25]}, {
      5, 13, Rational[109, 25]}}, {{4, 12, 5.92}, {4, 13, 6.12}, {
      5, 13, 4.36}}]], 
   Polygon3DBox[
    NCache[{{4, 12, Rational[148, 25]}, {5, 12, Rational[104, 25]}, {
      5, 13, Rational[109, 25]}}, {{4, 12, 5.92}, {5, 12, 4.16}, {
      5, 13, 4.36}}]], 
   Polygon3DBox[
    NCache[{{4, 13, Rational[153, 25]}, {4, 14, Rational[32, 5]}, {
      5, 14, Rational[116, 25]}}, {{4, 13, 6.12}, {4, 14, 6.4}, {
      5, 14, 4.64}}]], 
   Polygon3DBox[
    NCache[{{4, 13, Rational[153, 25]}, {5, 13, Rational[109, 25]}, {
      5, 14, Rational[116, 25]}}, {{4, 13, 6.12}, {5, 13, 4.36}, {
      5, 14, 4.64}}]], 
   Polygon3DBox[
    NCache[{{4, 14, Rational[32, 5]}, {4, 15, Rational[169, 25]}, {5, 15, 
      5}}, {{4, 14, 6.4}, {4, 15, 6.76}, {5, 15, 5}}]], 
   Polygon3DBox[
    NCache[{{4, 14, Rational[32, 5]}, {5, 14, Rational[116, 25]}, {5, 15, 
      5}}, {{4, 14, 6.4}, {5, 14, 4.64}, {5, 15, 5}}]], 
   Polygon3DBox[
    NCache[{{4, 15, Rational[169, 25]}, {4, 16, Rational[36, 5]}, {
      5, 16, Rational[136, 25]}}, {{4, 15, 6.76}, {4, 16, 7.2}, {
      5, 16, 5.44}}]], 
   Polygon3DBox[
    NCache[{{4, 15, Rational[169, 25]}, {5, 15, 5}, {
      5, 16, Rational[136, 25]}}, {{4, 15, 6.76}, {5, 15, 5}, {
      5, 16, 5.44}}]], 
   Polygon3DBox[
    NCache[{{4, 16, Rational[36, 5]}, {4, 17, Rational[193, 25]}, {
      5, 17, Rational[149, 25]}}, {{4, 16, 7.2}, {4, 17, 7.72}, {
      5, 17, 5.96}}]], 
   Polygon3DBox[
    NCache[{{4, 16, Rational[36, 5]}, {5, 16, Rational[136, 25]}, {
      5, 17, Rational[149, 25]}}, {{4, 16, 7.2}, {5, 16, 5.44}, {
      5, 17, 5.96}}]], 
   Polygon3DBox[
    NCache[{{4, 17, Rational[193, 25]}, {4, 18, Rational[208, 25]}, {
      5, 18, Rational[164, 25]}}, {{4, 17, 7.72}, {4, 18, 8.32}, {
      5, 18, 6.56}}]], 
   Polygon3DBox[
    NCache[{{4, 17, Rational[193, 25]}, {5, 17, Rational[149, 25]}, {
      5, 18, Rational[164, 25]}}, {{4, 17, 7.72}, {5, 17, 5.96}, {
      5, 18, 6.56}}]], 
   Polygon3DBox[
    NCache[{{4, 18, Rational[208, 25]}, {4, 19, 9}, {
      5, 19, Rational[181, 25]}}, {{4, 18, 8.32}, {4, 19, 9}, {
      5, 19, 7.24}}]], 
   Polygon3DBox[
    NCache[{{4, 18, Rational[208, 25]}, {5, 18, Rational[164, 25]}, {
      5, 19, Rational[181, 25]}}, {{4, 18, 8.32}, {5, 18, 6.56}, {
      5, 19, 7.24}}]], 
   Polygon3DBox[
    NCache[{{4, 19, 9}, {4, 20, Rational[244, 25]}, {5, 20, 8}}, {{4, 19, 
      9}, {4, 20, 9.76}, {5, 20, 8}}]], 
   Polygon3DBox[
    NCache[{{4, 19, 9}, {5, 19, Rational[181, 25]}, {5, 20, 8}}, {{4, 19, 
      9}, {5, 19, 7.24}, {5, 20, 8}}]], 
   Polygon3DBox[
    NCache[{{5, 1, Rational[181, 25]}, {5, 2, Rational[164, 25]}, {
      6, 2, Rational[128, 25]}}, {{5, 1, 7.24}, {5, 2, 6.56}, {6, 2, 5.12}}]],
    Polygon3DBox[
    NCache[{{5, 1, Rational[181, 25]}, {6, 1, Rational[29, 5]}, {
      6, 2, Rational[128, 25]}}, {{5, 1, 7.24}, {6, 1, 5.8}, {6, 2, 5.12}}]], 
   Polygon3DBox[
    NCache[{{5, 2, Rational[164, 25]}, {5, 3, Rational[149, 25]}, {
      6, 3, Rational[113, 25]}}, {{5, 2, 6.56}, {5, 3, 5.96}, {6, 3, 4.52}}]],
    Polygon3DBox[
    NCache[{{5, 2, Rational[164, 25]}, {6, 2, Rational[128, 25]}, {
      6, 3, Rational[113, 25]}}, {{5, 2, 6.56}, {6, 2, 5.12}, {6, 3, 4.52}}]],
    Polygon3DBox[
    NCache[{{5, 3, Rational[149, 25]}, {5, 4, Rational[136, 25]}, {6, 4, 
      4}}, {{5, 3, 5.96}, {5, 4, 5.44}, {6, 4, 4}}]], 
   Polygon3DBox[
    NCache[{{5, 3, Rational[149, 25]}, {6, 3, Rational[113, 25]}, {6, 4, 
      4}}, {{5, 3, 5.96}, {6, 3, 4.52}, {6, 4, 4}}]], 
   Polygon3DBox[
    NCache[{{5, 4, Rational[136, 25]}, {5, 5, 5}, {
      6, 5, Rational[89, 25]}}, {{5, 4, 5.44}, {5, 5, 5}, {6, 5, 3.56}}]], 
   Polygon3DBox[
    NCache[{{5, 4, Rational[136, 25]}, {6, 4, 4}, {
      6, 5, Rational[89, 25]}}, {{5, 4, 5.44}, {6, 4, 4}, {6, 5, 3.56}}]], 
   Polygon3DBox[
    NCache[{{5, 5, 5}, {5, 6, Rational[116, 25]}, {6, 6, Rational[16, 5]}}, {{
      5, 5, 5}, {5, 6, 4.64}, {6, 6, 3.2}}]], 
   Polygon3DBox[
    NCache[{{5, 5, 5}, {6, 5, Rational[89, 25]}, {6, 6, Rational[16, 5]}}, {{
      5, 5, 5}, {6, 5, 3.56}, {6, 6, 3.2}}]], 
   Polygon3DBox[
    NCache[{{5, 6, Rational[116, 25]}, {5, 7, Rational[109, 25]}, {
      6, 7, Rational[73, 25]}}, {{5, 6, 4.64}, {5, 7, 4.36}, {6, 7, 2.92}}]], 
   Polygon3DBox[
    NCache[{{5, 6, Rational[116, 25]}, {6, 6, Rational[16, 5]}, {
      6, 7, Rational[73, 25]}}, {{5, 6, 4.64}, {6, 6, 3.2}, {6, 7, 2.92}}]], 
   Polygon3DBox[
    NCache[{{5, 7, Rational[109, 25]}, {5, 8, Rational[104, 25]}, {
      6, 8, Rational[68, 25]}}, {{5, 7, 4.36}, {5, 8, 4.16}, {6, 8, 2.72}}]], 
   Polygon3DBox[
    NCache[{{5, 7, Rational[109, 25]}, {6, 7, Rational[73, 25]}, {
      6, 8, Rational[68, 25]}}, {{5, 7, 4.36}, {6, 7, 2.92}, {6, 8, 2.72}}]], 
   Polygon3DBox[
    NCache[{{5, 8, Rational[104, 25]}, {5, 9, Rational[101, 25]}, {
      6, 9, Rational[13, 5]}}, {{5, 8, 4.16}, {5, 9, 4.04}, {6, 9, 2.6}}]], 
   Polygon3DBox[
    NCache[{{5, 8, Rational[104, 25]}, {6, 8, Rational[68, 25]}, {
      6, 9, Rational[13, 5]}}, {{5, 8, 4.16}, {6, 8, 2.72}, {6, 9, 2.6}}]], 
   Polygon3DBox[
    NCache[{{5, 9, Rational[101, 25]}, {5, 10, 4}, {
      6, 10, Rational[64, 25]}}, {{5, 9, 4.04}, {5, 10, 4}, {6, 10, 2.56}}]], 
   Polygon3DBox[
    NCache[{{5, 9, Rational[101, 25]}, {6, 9, Rational[13, 5]}, {
      6, 10, Rational[64, 25]}}, {{5, 9, 4.04}, {6, 9, 2.6}, {6, 10, 2.56}}]],
    Polygon3DBox[
    NCache[{{5, 10, 4}, {5, 11, Rational[101, 25]}, {
      6, 11, Rational[13, 5]}}, {{5, 10, 4}, {5, 11, 4.04}, {6, 11, 2.6}}]], 
   Polygon3DBox[
    NCache[{{5, 10, 4}, {6, 10, Rational[64, 25]}, {
      6, 11, Rational[13, 5]}}, {{5, 10, 4}, {6, 10, 2.56}, {6, 11, 2.6}}]], 
   Polygon3DBox[
    NCache[{{5, 11, Rational[101, 25]}, {5, 12, Rational[104, 25]}, {
      6, 12, Rational[68, 25]}}, {{5, 11, 4.04}, {5, 12, 4.16}, {
      6, 12, 2.72}}]], 
   Polygon3DBox[
    NCache[{{5, 11, Rational[101, 25]}, {6, 11, Rational[13, 5]}, {
      6, 12, Rational[68, 25]}}, {{5, 11, 4.04}, {6, 11, 2.6}, {
      6, 12, 2.72}}]], 
   Polygon3DBox[
    NCache[{{5, 12, Rational[104, 25]}, {5, 13, Rational[109, 25]}, {
      6, 13, Rational[73, 25]}}, {{5, 12, 4.16}, {5, 13, 4.36}, {
      6, 13, 2.92}}]], 
   Polygon3DBox[
    NCache[{{5, 12, Rational[104, 25]}, {6, 12, Rational[68, 25]}, {
      6, 13, Rational[73, 25]}}, {{5, 12, 4.16}, {6, 12, 2.72}, {
      6, 13, 2.92}}]], 
   Polygon3DBox[
    NCache[{{5, 13, Rational[109, 25]}, {5, 14, Rational[116, 25]}, {
      6, 14, Rational[16, 5]}}, {{5, 13, 4.36}, {5, 14, 4.64}, {
      6, 14, 3.2}}]], 
   Polygon3DBox[
    NCache[{{5, 13, Rational[109, 25]}, {6, 13, Rational[73, 25]}, {
      6, 14, Rational[16, 5]}}, {{5, 13, 4.36}, {6, 13, 2.92}, {
      6, 14, 3.2}}]], 
   Polygon3DBox[
    NCache[{{5, 14, Rational[116, 25]}, {5, 15, 5}, {
      6, 15, Rational[89, 25]}}, {{5, 14, 4.64}, {5, 15, 5}, {6, 15, 3.56}}]],
    Polygon3DBox[
    NCache[{{5, 14, Rational[116, 25]}, {6, 14, Rational[16, 5]}, {
      6, 15, Rational[89, 25]}}, {{5, 14, 4.64}, {6, 14, 3.2}, {
      6, 15, 3.56}}]], 
   Polygon3DBox[
    NCache[{{5, 15, 5}, {5, 16, Rational[136, 25]}, {6, 16, 4}}, {{5, 15, 
      5}, {5, 16, 5.44}, {6, 16, 4}}]], 
   Polygon3DBox[
    NCache[{{5, 15, 5}, {6, 15, Rational[89, 25]}, {6, 16, 4}}, {{5, 15, 5}, {
      6, 15, 3.56}, {6, 16, 4}}]], 
   Polygon3DBox[
    NCache[{{5, 16, Rational[136, 25]}, {5, 17, Rational[149, 25]}, {
      6, 17, Rational[113, 25]}}, {{5, 16, 5.44}, {5, 17, 5.96}, {
      6, 17, 4.52}}]], 
   Polygon3DBox[
    NCache[{{5, 16, Rational[136, 25]}, {6, 16, 4}, {
      6, 17, Rational[113, 25]}}, {{5, 16, 5.44}, {6, 16, 4}, {
      6, 17, 4.52}}]], 
   Polygon3DBox[
    NCache[{{5, 17, Rational[149, 25]}, {5, 18, Rational[164, 25]}, {
      6, 18, Rational[128, 25]}}, {{5, 17, 5.96}, {5, 18, 6.56}, {
      6, 18, 5.12}}]], 
   Polygon3DBox[
    NCache[{{5, 17, Rational[149, 25]}, {6, 17, Rational[113, 25]}, {
      6, 18, Rational[128, 25]}}, {{5, 17, 5.96}, {6, 17, 4.52}, {
      6, 18, 5.12}}]], 
   Polygon3DBox[
    NCache[{{5, 18, Rational[164, 25]}, {5, 19, Rational[181, 25]}, {
      6, 19, Rational[29, 5]}}, {{5, 18, 6.56}, {5, 19, 7.24}, {
      6, 19, 5.8}}]], 
   Polygon3DBox[
    NCache[{{5, 18, Rational[164, 25]}, {6, 18, Rational[128, 25]}, {
      6, 19, Rational[29, 5]}}, {{5, 18, 6.56}, {6, 18, 5.12}, {
      6, 19, 5.8}}]], 
   Polygon3DBox[
    NCache[{{5, 19, Rational[181, 25]}, {5, 20, 8}, {
      6, 20, Rational[164, 25]}}, {{5, 19, 7.24}, {5, 20, 8}, {
      6, 20, 6.56}}]], 
   Polygon3DBox[
    NCache[{{5, 19, Rational[181, 25]}, {6, 19, Rational[29, 5]}, {
      6, 20, Rational[164, 25]}}, {{5, 19, 7.24}, {6, 19, 5.8}, {
      6, 20, 6.56}}]], 
   Polygon3DBox[
    NCache[{{6, 1, Rational[29, 5]}, {6, 2, Rational[128, 25]}, {7, 2, 4}}, {{
      6, 1, 5.8}, {6, 2, 5.12}, {7, 2, 4}}]], 
   Polygon3DBox[
    NCache[{{6, 1, Rational[29, 5]}, {7, 1, Rational[117, 25]}, {7, 2, 4}}, {{
      6, 1, 5.8}, {7, 1, 4.68}, {7, 2, 4}}]], 
   Polygon3DBox[
    NCache[{{6, 2, Rational[128, 25]}, {6, 3, Rational[113, 25]}, {
      7, 3, Rational[17, 5]}}, {{6, 2, 5.12}, {6, 3, 4.52}, {7, 3, 3.4}}]], 
   Polygon3DBox[
    NCache[{{6, 2, Rational[128, 25]}, {7, 2, 4}, {7, 3, Rational[17, 5]}}, {{
      6, 2, 5.12}, {7, 2, 4}, {7, 3, 3.4}}]], 
   Polygon3DBox[
    NCache[{{6, 3, Rational[113, 25]}, {6, 4, 4}, {
      7, 4, Rational[72, 25]}}, {{6, 3, 4.52}, {6, 4, 4}, {7, 4, 2.88}}]], 
   Polygon3DBox[
    NCache[{{6, 3, Rational[113, 25]}, {7, 3, Rational[17, 5]}, {
      7, 4, Rational[72, 25]}}, {{6, 3, 4.52}, {7, 3, 3.4}, {7, 4, 2.88}}]], 
   Polygon3DBox[
    NCache[{{6, 4, 4}, {6, 5, Rational[89, 25]}, {7, 5, Rational[61, 25]}}, {{
      6, 4, 4}, {6, 5, 3.56}, {7, 5, 2.44}}]], 
   Polygon3DBox[
    NCache[{{6, 4, 4}, {7, 4, Rational[72, 25]}, {7, 5, Rational[61, 25]}}, {{
      6, 4, 4}, {7, 4, 2.88}, {7, 5, 2.44}}]], 
   Polygon3DBox[
    NCache[{{6, 5, Rational[89, 25]}, {6, 6, Rational[16, 5]}, {
      7, 6, Rational[52, 25]}}, {{6, 5, 3.56}, {6, 6, 3.2}, {7, 6, 2.08}}]], 
   Polygon3DBox[
    NCache[{{6, 5, Rational[89, 25]}, {7, 5, Rational[61, 25]}, {
      7, 6, Rational[52, 25]}}, {{6, 5, 3.56}, {7, 5, 2.44}, {7, 6, 2.08}}]], 
   Polygon3DBox[
    NCache[{{6, 6, Rational[16, 5]}, {6, 7, Rational[73, 25]}, {
      7, 7, Rational[9, 5]}}, {{6, 6, 3.2}, {6, 7, 2.92}, {7, 7, 1.8}}]], 
   Polygon3DBox[
    NCache[{{6, 6, Rational[16, 5]}, {7, 6, Rational[52, 25]}, {
      7, 7, Rational[9, 5]}}, {{6, 6, 3.2}, {7, 6, 2.08}, {7, 7, 1.8}}]], 
   Polygon3DBox[
    NCache[{{6, 7, Rational[73, 25]}, {6, 8, Rational[68, 25]}, {
      7, 8, Rational[8, 5]}}, {{6, 7, 2.92}, {6, 8, 2.72}, {7, 8, 1.6}}]], 
   Polygon3DBox[
    NCache[{{6, 7, Rational[73, 25]}, {7, 7, Rational[9, 5]}, {
      7, 8, Rational[8, 5]}}, {{6, 7, 2.92}, {7, 7, 1.8}, {7, 8, 1.6}}]], 
   Polygon3DBox[
    NCache[{{6, 8, Rational[68, 25]}, {6, 9, Rational[13, 5]}, {
      7, 9, Rational[37, 25]}}, {{6, 8, 2.72}, {6, 9, 2.6}, {7, 9, 1.48}}]], 
   Polygon3DBox[
    NCache[{{6, 8, Rational[68, 25]}, {7, 8, Rational[8, 5]}, {
      7, 9, Rational[37, 25]}}, {{6, 8, 2.72}, {7, 8, 1.6}, {7, 9, 1.48}}]], 
   Polygon3DBox[
    NCache[{{6, 9, Rational[13, 5]}, {6, 10, Rational[64, 25]}, {
      7, 10, Rational[36, 25]}}, {{6, 9, 2.6}, {6, 10, 2.56}, {
      7, 10, 1.44}}]], 
   Polygon3DBox[
    NCache[{{6, 9, Rational[13, 5]}, {7, 9, Rational[37, 25]}, {
      7, 10, Rational[36, 25]}}, {{6, 9, 2.6}, {7, 9, 1.48}, {7, 10, 1.44}}]],
    Polygon3DBox[
    NCache[{{6, 10, Rational[64, 25]}, {6, 11, Rational[13, 5]}, {
      7, 11, Rational[37, 25]}}, {{6, 10, 2.56}, {6, 11, 2.6}, {
      7, 11, 1.48}}]], 
   Polygon3DBox[
    NCache[{{6, 10, Rational[64, 25]}, {7, 10, Rational[36, 25]}, {
      7, 11, Rational[37, 25]}}, {{6, 10, 2.56}, {7, 10, 1.44}, {
      7, 11, 1.48}}]], 
   Polygon3DBox[
    NCache[{{6, 11, Rational[13, 5]}, {6, 12, Rational[68, 25]}, {
      7, 12, Rational[8, 5]}}, {{6, 11, 2.6}, {6, 12, 2.72}, {7, 12, 1.6}}]], 
   Polygon3DBox[
    NCache[{{6, 11, Rational[13, 5]}, {7, 11, Rational[37, 25]}, {
      7, 12, Rational[8, 5]}}, {{6, 11, 2.6}, {7, 11, 1.48}, {7, 12, 1.6}}]], 
   Polygon3DBox[
    NCache[{{6, 12, Rational[68, 25]}, {6, 13, Rational[73, 25]}, {
      7, 13, Rational[9, 5]}}, {{6, 12, 2.72}, {6, 13, 2.92}, {7, 13, 1.8}}]],
    Polygon3DBox[
    NCache[{{6, 12, Rational[68, 25]}, {7, 12, Rational[8, 5]}, {
      7, 13, Rational[9, 5]}}, {{6, 12, 2.72}, {7, 12, 1.6}, {7, 13, 1.8}}]], 
   Polygon3DBox[
    NCache[{{6, 13, Rational[73, 25]}, {6, 14, Rational[16, 5]}, {
      7, 14, Rational[52, 25]}}, {{6, 13, 2.92}, {6, 14, 3.2}, {
      7, 14, 2.08}}]], 
   Polygon3DBox[
    NCache[{{6, 13, Rational[73, 25]}, {7, 13, Rational[9, 5]}, {
      7, 14, Rational[52, 25]}}, {{6, 13, 2.92}, {7, 13, 1.8}, {
      7, 14, 2.08}}]], 
   Polygon3DBox[
    NCache[{{6, 14, Rational[16, 5]}, {6, 15, Rational[89, 25]}, {
      7, 15, Rational[61, 25]}}, {{6, 14, 3.2}, {6, 15, 3.56}, {
      7, 15, 2.44}}]], 
   Polygon3DBox[
    NCache[{{6, 14, Rational[16, 5]}, {7, 14, Rational[52, 25]}, {
      7, 15, Rational[61, 25]}}, {{6, 14, 3.2}, {7, 14, 2.08}, {
      7, 15, 2.44}}]], 
   Polygon3DBox[
    NCache[{{6, 15, Rational[89, 25]}, {6, 16, 4}, {
      7, 16, Rational[72, 25]}}, {{6, 15, 3.56}, {6, 16, 4}, {7, 16, 2.88}}]],
    Polygon3DBox[
    NCache[{{6, 15, Rational[89, 25]}, {7, 15, Rational[61, 25]}, {
      7, 16, Rational[72, 25]}}, {{6, 15, 3.56}, {7, 15, 2.44}, {
      7, 16, 2.88}}]], 
   Polygon3DBox[
    NCache[{{6, 16, 4}, {6, 17, Rational[113, 25]}, {
      7, 17, Rational[17, 5]}}, {{6, 16, 4}, {6, 17, 4.52}, {7, 17, 3.4}}]], 
   Polygon3DBox[
    NCache[{{6, 16, 4}, {7, 16, Rational[72, 25]}, {
      7, 17, Rational[17, 5]}}, {{6, 16, 4}, {7, 16, 2.88}, {7, 17, 3.4}}]], 
   Polygon3DBox[
    NCache[{{6, 17, Rational[113, 25]}, {6, 18, Rational[128, 25]}, {7, 18, 
      4}}, {{6, 17, 4.52}, {6, 18, 5.12}, {7, 18, 4}}]], 
   Polygon3DBox[
    NCache[{{6, 17, Rational[113, 25]}, {7, 17, Rational[17, 5]}, {7, 18, 
      4}}, {{6, 17, 4.52}, {7, 17, 3.4}, {7, 18, 4}}]], 
   Polygon3DBox[
    NCache[{{6, 18, Rational[128, 25]}, {6, 19, Rational[29, 5]}, {
      7, 19, Rational[117, 25]}}, {{6, 18, 5.12}, {6, 19, 5.8}, {
      7, 19, 4.68}}]], 
   Polygon3DBox[
    NCache[{{6, 18, Rational[128, 25]}, {7, 18, 4}, {
      7, 19, Rational[117, 25]}}, {{6, 18, 5.12}, {7, 18, 4}, {
      7, 19, 4.68}}]], 
   Polygon3DBox[
    NCache[{{6, 19, Rational[29, 5]}, {6, 20, Rational[164, 25]}, {
      7, 20, Rational[136, 25]}}, {{6, 19, 5.8}, {6, 20, 6.56}, {
      7, 20, 5.44}}]], 
   Polygon3DBox[
    NCache[{{6, 19, Rational[29, 5]}, {7, 19, Rational[117, 25]}, {
      7, 20, Rational[136, 25]}}, {{6, 19, 5.8}, {7, 19, 4.68}, {
      7, 20, 5.44}}]], 
   Polygon3DBox[
    NCache[{{7, 1, Rational[117, 25]}, {7, 2, 4}, {8, 2, Rational[16, 5]}}, {{
      7, 1, 4.68}, {7, 2, 4}, {8, 2, 3.2}}]], 
   Polygon3DBox[
    NCache[{{7, 1, Rational[117, 25]}, {8, 1, Rational[97, 25]}, {
      8, 2, Rational[16, 5]}}, {{7, 1, 4.68}, {8, 1, 3.88}, {8, 2, 3.2}}]], 
   Polygon3DBox[
    NCache[{{7, 2, 4}, {7, 3, Rational[17, 5]}, {8, 3, Rational[13, 5]}}, {{7,
       2, 4}, {7, 3, 3.4}, {8, 3, 2.6}}]], 
   Polygon3DBox[
    NCache[{{7, 2, 4}, {8, 2, Rational[16, 5]}, {8, 3, Rational[13, 5]}}, {{7,
       2, 4}, {8, 2, 3.2}, {8, 3, 2.6}}]], 
   Polygon3DBox[
    NCache[{{7, 3, Rational[17, 5]}, {7, 4, Rational[72, 25]}, {
      8, 4, Rational[52, 25]}}, {{7, 3, 3.4}, {7, 4, 2.88}, {8, 4, 2.08}}]], 
   Polygon3DBox[
    NCache[{{7, 3, Rational[17, 5]}, {8, 3, Rational[13, 5]}, {
      8, 4, Rational[52, 25]}}, {{7, 3, 3.4}, {8, 3, 2.6}, {8, 4, 2.08}}]], 
   Polygon3DBox[
    NCache[{{7, 4, Rational[72, 25]}, {7, 5, Rational[61, 25]}, {
      8, 5, Rational[41, 25]}}, {{7, 4, 2.88}, {7, 5, 2.44}, {8, 5, 1.64}}]], 
   Polygon3DBox[
    NCache[{{7, 4, Rational[72, 25]}, {8, 4, Rational[52, 25]}, {
      8, 5, Rational[41, 25]}}, {{7, 4, 2.88}, {8, 4, 2.08}, {8, 5, 1.64}}]], 
   Polygon3DBox[
    NCache[{{7, 5, Rational[61, 25]}, {7, 6, Rational[52, 25]}, {
      8, 6, Rational[32, 25]}}, {{7, 5, 2.44}, {7, 6, 2.08}, {8, 6, 1.28}}]], 
   Polygon3DBox[
    NCache[{{7, 5, Rational[61, 25]}, {8, 5, Rational[41, 25]}, {
      8, 6, Rational[32, 25]}}, {{7, 5, 2.44}, {8, 5, 1.64}, {8, 6, 1.28}}]], 
   Polygon3DBox[
    NCache[{{7, 6, Rational[52, 25]}, {7, 7, Rational[9, 5]}, {8, 7, 1}}, {{
      7, 6, 2.08}, {7, 7, 1.8}, {8, 7, 1}}]], 
   Polygon3DBox[
    NCache[{{7, 6, Rational[52, 25]}, {8, 6, Rational[32, 25]}, {8, 7, 1}}, {{
      7, 6, 2.08}, {8, 6, 1.28}, {8, 7, 1}}]], 
   Polygon3DBox[
    NCache[{{7, 7, Rational[9, 5]}, {7, 8, Rational[8, 5]}, {
      8, 8, Rational[4, 5]}}, {{7, 7, 1.8}, {7, 8, 1.6}, {8, 8, 0.8}}]], 
   Polygon3DBox[
    NCache[{{7, 7, Rational[9, 5]}, {8, 7, 1}, {8, 8, Rational[4, 5]}}, {{
      7, 7, 1.8}, {8, 7, 1}, {8, 8, 0.8}}]], 
   Polygon3DBox[
    NCache[{{7, 8, Rational[8, 5]}, {7, 9, Rational[37, 25]}, {
      8, 9, Rational[17, 25]}}, {{7, 8, 1.6}, {7, 9, 1.48}, {8, 9, 0.68}}]], 
   Polygon3DBox[
    NCache[{{7, 8, Rational[8, 5]}, {8, 8, Rational[4, 5]}, {
      8, 9, Rational[17, 25]}}, {{7, 8, 1.6}, {8, 8, 0.8}, {8, 9, 0.68}}]], 
   Polygon3DBox[
    NCache[{{7, 9, Rational[37, 25]}, {7, 10, Rational[36, 25]}, {
      8, 10, Rational[16, 25]}}, {{7, 9, 1.48}, {7, 10, 1.44}, {
      8, 10, 0.64}}]], 
   Polygon3DBox[
    NCache[{{7, 9, Rational[37, 25]}, {8, 9, Rational[17, 25]}, {
      8, 10, Rational[16, 25]}}, {{7, 9, 1.48}, {8, 9, 0.68}, {
      8, 10, 0.64}}]], 
   Polygon3DBox[
    NCache[{{7, 10, Rational[36, 25]}, {7, 11, Rational[37, 25]}, {
      8, 11, Rational[17, 25]}}, {{7, 10, 1.44}, {7, 11, 1.48}, {
      8, 11, 0.68}}]], 
   Polygon3DBox[
    NCache[{{7, 10, Rational[36, 25]}, {8, 10, Rational[16, 25]}, {
      8, 11, Rational[17, 25]}}, {{7, 10, 1.44}, {8, 10, 0.64}, {
      8, 11, 0.68}}]], 
   Polygon3DBox[
    NCache[{{7, 11, Rational[37, 25]}, {7, 12, Rational[8, 5]}, {
      8, 12, Rational[4, 5]}}, {{7, 11, 1.48}, {7, 12, 1.6}, {8, 12, 0.8}}]], 
   Polygon3DBox[
    NCache[{{7, 11, Rational[37, 25]}, {8, 11, Rational[17, 25]}, {
      8, 12, Rational[4, 5]}}, {{7, 11, 1.48}, {8, 11, 0.68}, {8, 12, 0.8}}]],
    Polygon3DBox[
    NCache[{{7, 12, Rational[8, 5]}, {7, 13, Rational[9, 5]}, {8, 13, 1}}, {{
      7, 12, 1.6}, {7, 13, 1.8}, {8, 13, 1}}]], 
   Polygon3DBox[
    NCache[{{7, 12, Rational[8, 5]}, {8, 12, Rational[4, 5]}, {8, 13, 1}}, {{
      7, 12, 1.6}, {8, 12, 0.8}, {8, 13, 1}}]], 
   Polygon3DBox[
    NCache[{{7, 13, Rational[9, 5]}, {7, 14, Rational[52, 25]}, {
      8, 14, Rational[32, 25]}}, {{7, 13, 1.8}, {7, 14, 2.08}, {
      8, 14, 1.28}}]], 
   Polygon3DBox[
    NCache[{{7, 13, Rational[9, 5]}, {8, 13, 1}, {
      8, 14, Rational[32, 25]}}, {{7, 13, 1.8}, {8, 13, 1}, {8, 14, 1.28}}]], 
   Polygon3DBox[
    NCache[{{7, 14, Rational[52, 25]}, {7, 15, Rational[61, 25]}, {
      8, 15, Rational[41, 25]}}, {{7, 14, 2.08}, {7, 15, 2.44}, {
      8, 15, 1.64}}]], 
   Polygon3DBox[
    NCache[{{7, 14, Rational[52, 25]}, {8, 14, Rational[32, 25]}, {
      8, 15, Rational[41, 25]}}, {{7, 14, 2.08}, {8, 14, 1.28}, {
      8, 15, 1.64}}]], 
   Polygon3DBox[
    NCache[{{7, 15, Rational[61, 25]}, {7, 16, Rational[72, 25]}, {
      8, 16, Rational[52, 25]}}, {{7, 15, 2.44}, {7, 16, 2.88}, {
      8, 16, 2.08}}]], 
   Polygon3DBox[
    NCache[{{7, 15, Rational[61, 25]}, {8, 15, Rational[41, 25]}, {
      8, 16, Rational[52, 25]}}, {{7, 15, 2.44}, {8, 15, 1.64}, {
      8, 16, 2.08}}]], 
   Polygon3DBox[
    NCache[{{7, 16, Rational[72, 25]}, {7, 17, Rational[17, 5]}, {
      8, 17, Rational[13, 5]}}, {{7, 16, 2.88}, {7, 17, 3.4}, {8, 17, 2.6}}]],
    Polygon3DBox[
    NCache[{{7, 16, Rational[72, 25]}, {8, 16, Rational[52, 25]}, {
      8, 17, Rational[13, 5]}}, {{7, 16, 2.88}, {8, 16, 2.08}, {
      8, 17, 2.6}}]], 
   Polygon3DBox[
    NCache[{{7, 17, Rational[17, 5]}, {7, 18, 4}, {
      8, 18, Rational[16, 5]}}, {{7, 17, 3.4}, {7, 18, 4}, {8, 18, 3.2}}]], 
   Polygon3DBox[
    NCache[{{7, 17, Rational[17, 5]}, {8, 17, Rational[13, 5]}, {
      8, 18, Rational[16, 5]}}, {{7, 17, 3.4}, {8, 17, 2.6}, {8, 18, 3.2}}]], 
   Polygon3DBox[
    NCache[{{7, 18, 4}, {7, 19, Rational[117, 25]}, {
      8, 19, Rational[97, 25]}}, {{7, 18, 4}, {7, 19, 4.68}, {8, 19, 3.88}}]],
    Polygon3DBox[
    NCache[{{7, 18, 4}, {8, 18, Rational[16, 5]}, {
      8, 19, Rational[97, 25]}}, {{7, 18, 4}, {8, 18, 3.2}, {8, 19, 3.88}}]], 
   Polygon3DBox[
    NCache[{{7, 19, Rational[117, 25]}, {7, 20, Rational[136, 25]}, {
      8, 20, Rational[116, 25]}}, {{7, 19, 4.68}, {7, 20, 5.44}, {
      8, 20, 4.64}}]], 
   Polygon3DBox[
    NCache[{{7, 19, Rational[117, 25]}, {8, 19, Rational[97, 25]}, {
      8, 20, Rational[116, 25]}}, {{7, 19, 4.68}, {8, 19, 3.88}, {
      8, 20, 4.64}}]], 
   Polygon3DBox[
    NCache[{{8, 1, Rational[97, 25]}, {8, 2, Rational[16, 5]}, {
      9, 2, Rational[68, 25]}}, {{8, 1, 3.88}, {8, 2, 3.2}, {9, 2, 2.72}}]], 
   Polygon3DBox[
    NCache[{{8, 1, Rational[97, 25]}, {9, 1, Rational[17, 5]}, {
      9, 2, Rational[68, 25]}}, {{8, 1, 3.88}, {9, 1, 3.4}, {9, 2, 2.72}}]], 
   Polygon3DBox[
    NCache[{{8, 2, Rational[16, 5]}, {8, 3, Rational[13, 5]}, {
      9, 3, Rational[53, 25]}}, {{8, 2, 3.2}, {8, 3, 2.6}, {9, 3, 2.12}}]], 
   Polygon3DBox[
    NCache[{{8, 2, Rational[16, 5]}, {9, 2, Rational[68, 25]}, {
      9, 3, Rational[53, 25]}}, {{8, 2, 3.2}, {9, 2, 2.72}, {9, 3, 2.12}}]], 
   Polygon3DBox[
    NCache[{{8, 3, Rational[13, 5]}, {8, 4, Rational[52, 25]}, {
      9, 4, Rational[8, 5]}}, {{8, 3, 2.6}, {8, 4, 2.08}, {9, 4, 1.6}}]], 
   Polygon3DBox[
    NCache[{{8, 3, Rational[13, 5]}, {9, 3, Rational[53, 25]}, {
      9, 4, Rational[8, 5]}}, {{8, 3, 2.6}, {9, 3, 2.12}, {9, 4, 1.6}}]], 
   Polygon3DBox[
    NCache[{{8, 4, Rational[52, 25]}, {8, 5, Rational[41, 25]}, {
      9, 5, Rational[29, 25]}}, {{8, 4, 2.08}, {8, 5, 1.64}, {9, 5, 1.16}}]], 
   Polygon3DBox[
    NCache[{{8, 4, Rational[52, 25]}, {9, 4, Rational[8, 5]}, {
      9, 5, Rational[29, 25]}}, {{8, 4, 2.08}, {9, 4, 1.6}, {9, 5, 1.16}}]], 
   Polygon3DBox[
    NCache[{{8, 5, Rational[41, 25]}, {8, 6, Rational[32, 25]}, {
      9, 6, Rational[4, 5]}}, {{8, 5, 1.64}, {8, 6, 1.28}, {9, 6, 0.8}}]], 
   Polygon3DBox[
    NCache[{{8, 5, Rational[41, 25]}, {9, 5, Rational[29, 25]}, {
      9, 6, Rational[4, 5]}}, {{8, 5, 1.64}, {9, 5, 1.16}, {9, 6, 0.8}}]], 
   Polygon3DBox[
    NCache[{{8, 6, Rational[32, 25]}, {8, 7, 1}, {9, 7, Rational[13, 25]}}, {{
      8, 6, 1.28}, {8, 7, 1}, {9, 7, 0.52}}]], 
   Polygon3DBox[
    NCache[{{8, 6, Rational[32, 25]}, {9, 6, Rational[4, 5]}, {
      9, 7, Rational[13, 25]}}, {{8, 6, 1.28}, {9, 6, 0.8}, {9, 7, 0.52}}]], 
   Polygon3DBox[
    NCache[{{8, 7, 1}, {8, 8, Rational[4, 5]}, {9, 8, Rational[8, 25]}}, {{8, 
      7, 1}, {8, 8, 0.8}, {9, 8, 0.32}}]], 
   Polygon3DBox[
    NCache[{{8, 7, 1}, {9, 7, Rational[13, 25]}, {9, 8, Rational[8, 25]}}, {{
      8, 7, 1}, {9, 7, 0.52}, {9, 8, 0.32}}]], 
   Polygon3DBox[
    NCache[{{8, 8, Rational[4, 5]}, {8, 9, Rational[17, 25]}, {
      9, 9, Rational[1, 5]}}, {{8, 8, 0.8}, {8, 9, 0.68}, {9, 9, 0.2}}]], 
   Polygon3DBox[
    NCache[{{8, 8, Rational[4, 5]}, {9, 8, Rational[8, 25]}, {
      9, 9, Rational[1, 5]}}, {{8, 8, 0.8}, {9, 8, 0.32}, {9, 9, 0.2}}]], 
   Polygon3DBox[
    NCache[{{8, 9, Rational[17, 25]}, {8, 10, Rational[16, 25]}, {
      9, 10, Rational[4, 25]}}, {{8, 9, 0.68}, {8, 10, 0.64}, {
      9, 10, 0.16}}]], 
   Polygon3DBox[
    NCache[{{8, 9, Rational[17, 25]}, {9, 9, Rational[1, 5]}, {
      9, 10, Rational[4, 25]}}, {{8, 9, 0.68}, {9, 9, 0.2}, {9, 10, 0.16}}]], 
   Polygon3DBox[
    NCache[{{8, 10, Rational[16, 25]}, {8, 11, Rational[17, 25]}, {
      9, 11, Rational[1, 5]}}, {{8, 10, 0.64}, {8, 11, 0.68}, {9, 11, 0.2}}]],
    Polygon3DBox[
    NCache[{{8, 10, Rational[16, 25]}, {9, 10, Rational[4, 25]}, {
      9, 11, Rational[1, 5]}}, {{8, 10, 0.64}, {9, 10, 0.16}, {9, 11, 0.2}}]],
    Polygon3DBox[
    NCache[{{8, 11, Rational[17, 25]}, {8, 12, Rational[4, 5]}, {
      9, 12, Rational[8, 25]}}, {{8, 11, 0.68}, {8, 12, 0.8}, {
      9, 12, 0.32}}]], 
   Polygon3DBox[
    NCache[{{8, 11, Rational[17, 25]}, {9, 11, Rational[1, 5]}, {
      9, 12, Rational[8, 25]}}, {{8, 11, 0.68}, {9, 11, 0.2}, {
      9, 12, 0.32}}]], 
   Polygon3DBox[
    NCache[{{8, 12, Rational[4, 5]}, {8, 13, 1}, {
      9, 13, Rational[13, 25]}}, {{8, 12, 0.8}, {8, 13, 1}, {9, 13, 0.52}}]], 
   Polygon3DBox[
    NCache[{{8, 12, Rational[4, 5]}, {9, 12, Rational[8, 25]}, {
      9, 13, Rational[13, 25]}}, {{8, 12, 0.8}, {9, 12, 0.32}, {
      9, 13, 0.52}}]], 
   Polygon3DBox[
    NCache[{{8, 13, 1}, {8, 14, Rational[32, 25]}, {
      9, 14, Rational[4, 5]}}, {{8, 13, 1}, {8, 14, 1.28}, {9, 14, 0.8}}]], 
   Polygon3DBox[
    NCache[{{8, 13, 1}, {9, 13, Rational[13, 25]}, {
      9, 14, Rational[4, 5]}}, {{8, 13, 1}, {9, 13, 0.52}, {9, 14, 0.8}}]], 
   Polygon3DBox[
    NCache[{{8, 14, Rational[32, 25]}, {8, 15, Rational[41, 25]}, {
      9, 15, Rational[29, 25]}}, {{8, 14, 1.28}, {8, 15, 1.64}, {
      9, 15, 1.16}}]], 
   Polygon3DBox[
    NCache[{{8, 14, Rational[32, 25]}, {9, 14, Rational[4, 5]}, {
      9, 15, Rational[29, 25]}}, {{8, 14, 1.28}, {9, 14, 0.8}, {
      9, 15, 1.16}}]], 
   Polygon3DBox[
    NCache[{{8, 15, Rational[41, 25]}, {8, 16, Rational[52, 25]}, {
      9, 16, Rational[8, 5]}}, {{8, 15, 1.64}, {8, 16, 2.08}, {9, 16, 1.6}}]],
    Polygon3DBox[
    NCache[{{8, 15, Rational[41, 25]}, {9, 15, Rational[29, 25]}, {
      9, 16, Rational[8, 5]}}, {{8, 15, 1.64}, {9, 15, 1.16}, {9, 16, 1.6}}]],
    Polygon3DBox[
    NCache[{{8, 16, Rational[52, 25]}, {8, 17, Rational[13, 5]}, {
      9, 17, Rational[53, 25]}}, {{8, 16, 2.08}, {8, 17, 2.6}, {
      9, 17, 2.12}}]], 
   Polygon3DBox[
    NCache[{{8, 16, Rational[52, 25]}, {9, 16, Rational[8, 5]}, {
      9, 17, Rational[53, 25]}}, {{8, 16, 2.08}, {9, 16, 1.6}, {
      9, 17, 2.12}}]], 
   Polygon3DBox[
    NCache[{{8, 17, Rational[13, 5]}, {8, 18, Rational[16, 5]}, {
      9, 18, Rational[68, 25]}}, {{8, 17, 2.6}, {8, 18, 3.2}, {
      9, 18, 2.72}}]], 
   Polygon3DBox[
    NCache[{{8, 17, Rational[13, 5]}, {9, 17, Rational[53, 25]}, {
      9, 18, Rational[68, 25]}}, {{8, 17, 2.6}, {9, 17, 2.12}, {
      9, 18, 2.72}}]], 
   Polygon3DBox[
    NCache[{{8, 18, Rational[16, 5]}, {8, 19, Rational[97, 25]}, {
      9, 19, Rational[17, 5]}}, {{8, 18, 3.2}, {8, 19, 3.88}, {9, 19, 3.4}}]],
    Polygon3DBox[
    NCache[{{8, 18, Rational[16, 5]}, {9, 18, Rational[68, 25]}, {
      9, 19, Rational[17, 5]}}, {{8, 18, 3.2}, {9, 18, 2.72}, {9, 19, 3.4}}]],
    Polygon3DBox[
    NCache[{{8, 19, Rational[97, 25]}, {8, 20, Rational[116, 25]}, {
      9, 20, Rational[104, 25]}}, {{8, 19, 3.88}, {8, 20, 4.64}, {
      9, 20, 4.16}}]], 
   Polygon3DBox[
    NCache[{{8, 19, Rational[97, 25]}, {9, 19, Rational[17, 5]}, {
      9, 20, Rational[104, 25]}}, {{8, 19, 3.88}, {9, 19, 3.4}, {
      9, 20, 4.16}}]], 
   Polygon3DBox[
    NCache[{{9, 1, Rational[17, 5]}, {9, 2, Rational[68, 25]}, {
      10, 2, Rational[64, 25]}}, {{9, 1, 3.4}, {9, 2, 2.72}, {10, 2, 2.56}}]],
    Polygon3DBox[
    NCache[{{9, 1, Rational[17, 5]}, {10, 1, Rational[81, 25]}, {
      10, 2, Rational[64, 25]}}, {{9, 1, 3.4}, {10, 1, 3.24}, {
      10, 2, 2.56}}]], 
   Polygon3DBox[
    NCache[{{9, 2, Rational[68, 25]}, {9, 3, Rational[53, 25]}, {
      10, 3, Rational[49, 25]}}, {{9, 2, 2.72}, {9, 3, 2.12}, {
      10, 3, 1.96}}]], 
   Polygon3DBox[
    NCache[{{9, 2, Rational[68, 25]}, {10, 2, Rational[64, 25]}, {
      10, 3, Rational[49, 25]}}, {{9, 2, 2.72}, {10, 2, 2.56}, {
      10, 3, 1.96}}]], 
   Polygon3DBox[
    NCache[{{9, 3, Rational[53, 25]}, {9, 4, Rational[8, 5]}, {
      10, 4, Rational[36, 25]}}, {{9, 3, 2.12}, {9, 4, 1.6}, {10, 4, 1.44}}]],
    Polygon3DBox[
    NCache[{{9, 3, Rational[53, 25]}, {10, 3, Rational[49, 25]}, {
      10, 4, Rational[36, 25]}}, {{9, 3, 2.12}, {10, 3, 1.96}, {
      10, 4, 1.44}}]], 
   Polygon3DBox[
    NCache[{{9, 4, Rational[8, 5]}, {9, 5, Rational[29, 25]}, {10, 5, 1}}, {{
      9, 4, 1.6}, {9, 5, 1.16}, {10, 5, 1}}]], 
   Polygon3DBox[
    NCache[{{9, 4, Rational[8, 5]}, {10, 4, Rational[36, 25]}, {10, 5, 1}}, {{
      9, 4, 1.6}, {10, 4, 1.44}, {10, 5, 1}}]], 
   Polygon3DBox[
    NCache[{{9, 5, Rational[29, 25]}, {9, 6, Rational[4, 5]}, {
      10, 6, Rational[16, 25]}}, {{9, 5, 1.16}, {9, 6, 0.8}, {10, 6, 0.64}}]],
    Polygon3DBox[
    NCache[{{9, 5, Rational[29, 25]}, {10, 5, 1}, {
      10, 6, Rational[16, 25]}}, {{9, 5, 1.16}, {10, 5, 1}, {10, 6, 0.64}}]], 
   Polygon3DBox[
    NCache[{{9, 6, Rational[4, 5]}, {9, 7, Rational[13, 25]}, {
      10, 7, Rational[9, 25]}}, {{9, 6, 0.8}, {9, 7, 0.52}, {10, 7, 0.36}}]], 
   Polygon3DBox[
    NCache[{{9, 6, Rational[4, 5]}, {10, 6, Rational[16, 25]}, {
      10, 7, Rational[9, 25]}}, {{9, 6, 0.8}, {10, 6, 0.64}, {10, 7, 0.36}}]],
    Polygon3DBox[
    NCache[{{9, 7, Rational[13, 25]}, {9, 8, Rational[8, 25]}, {
      10, 8, Rational[4, 25]}}, {{9, 7, 0.52}, {9, 8, 0.32}, {10, 8, 0.16}}]],
    Polygon3DBox[
    NCache[{{9, 7, Rational[13, 25]}, {10, 7, Rational[9, 25]}, {
      10, 8, Rational[4, 25]}}, {{9, 7, 0.52}, {10, 7, 0.36}, {
      10, 8, 0.16}}]], 
   Polygon3DBox[
    NCache[{{9, 8, Rational[8, 25]}, {9, 9, Rational[1, 5]}, {
      10, 9, Rational[1, 25]}}, {{9, 8, 0.32}, {9, 9, 0.2}, {10, 9, 0.04}}]], 
   Polygon3DBox[
    NCache[{{9, 8, Rational[8, 25]}, {10, 8, Rational[4, 25]}, {
      10, 9, Rational[1, 25]}}, {{9, 8, 0.32}, {10, 8, 0.16}, {
      10, 9, 0.04}}]], 
   Polygon3DBox[
    NCache[{{9, 9, Rational[1, 5]}, {9, 10, Rational[4, 25]}, {10, 10, 0}}, {{
      9, 9, 0.2}, {9, 10, 0.16}, {10, 10, 0}}]], 
   Polygon3DBox[
    NCache[{{9, 9, Rational[1, 5]}, {10, 9, Rational[1, 25]}, {10, 10, 0}}, {{
      9, 9, 0.2}, {10, 9, 0.04}, {10, 10, 0}}]], 
   Polygon3DBox[
    NCache[{{9, 10, Rational[4, 25]}, {9, 11, Rational[1, 5]}, {
      10, 11, Rational[1, 25]}}, {{9, 10, 0.16}, {9, 11, 0.2}, {
      10, 11, 0.04}}]], 
   Polygon3DBox[
    NCache[{{9, 10, Rational[4, 25]}, {10, 10, 0}, {
      10, 11, Rational[1, 25]}}, {{9, 10, 0.16}, {10, 10, 0}, {
      10, 11, 0.04}}]], 
   Polygon3DBox[
    NCache[{{9, 11, Rational[1, 5]}, {9, 12, Rational[8, 25]}, {
      10, 12, Rational[4, 25]}}, {{9, 11, 0.2}, {9, 12, 0.32}, {
      10, 12, 0.16}}]], 
   Polygon3DBox[
    NCache[{{9, 11, Rational[1, 5]}, {10, 11, Rational[1, 25]}, {
      10, 12, Rational[4, 25]}}, {{9, 11, 0.2}, {10, 11, 0.04}, {10, 12, 0.16}
      }]], 
   Polygon3DBox[
    NCache[{{9, 12, Rational[8, 25]}, {9, 13, Rational[13, 25]}, {
      10, 13, Rational[9, 25]}}, {{9, 12, 0.32}, {9, 13, 0.52}, {
      10, 13, 0.36}}]], 
   Polygon3DBox[
    NCache[{{9, 12, Rational[8, 25]}, {10, 12, Rational[4, 25]}, {
      10, 13, Rational[9, 25]}}, {{9, 12, 0.32}, {10, 12, 0.16}, {
      10, 13, 0.36}}]], 
   Polygon3DBox[
    NCache[{{9, 13, Rational[13, 25]}, {9, 14, Rational[4, 5]}, {
      10, 14, Rational[16, 25]}}, {{9, 13, 0.52}, {9, 14, 0.8}, {
      10, 14, 0.64}}]], 
   Polygon3DBox[
    NCache[{{9, 13, Rational[13, 25]}, {10, 13, Rational[9, 25]}, {
      10, 14, Rational[16, 25]}}, {{9, 13, 0.52}, {10, 13, 0.36}, {
      10, 14, 0.64}}]], 
   Polygon3DBox[
    NCache[{{9, 14, Rational[4, 5]}, {9, 15, Rational[29, 25]}, {10, 15, 
      1}}, {{9, 14, 0.8}, {9, 15, 1.16}, {10, 15, 1}}]], 
   Polygon3DBox[
    NCache[{{9, 14, Rational[4, 5]}, {10, 14, Rational[16, 25]}, {10, 15, 
      1}}, {{9, 14, 0.8}, {10, 14, 0.64}, {10, 15, 1}}]], 
   Polygon3DBox[
    NCache[{{9, 15, Rational[29, 25]}, {9, 16, Rational[8, 5]}, {
      10, 16, Rational[36, 25]}}, {{9, 15, 1.16}, {9, 16, 1.6}, {
      10, 16, 1.44}}]], 
   Polygon3DBox[
    NCache[{{9, 15, Rational[29, 25]}, {10, 15, 1}, {
      10, 16, Rational[36, 25]}}, {{9, 15, 1.16}, {10, 15, 1}, {
      10, 16, 1.44}}]], 
   Polygon3DBox[
    NCache[{{9, 16, Rational[8, 5]}, {9, 17, Rational[53, 25]}, {
      10, 17, Rational[49, 25]}}, {{9, 16, 1.6}, {9, 17, 2.12}, {
      10, 17, 1.96}}]], 
   Polygon3DBox[
    NCache[{{9, 16, Rational[8, 5]}, {10, 16, Rational[36, 25]}, {
      10, 17, Rational[49, 25]}}, {{9, 16, 1.6}, {10, 16, 1.44}, {
      10, 17, 1.96}}]], 
   Polygon3DBox[
    NCache[{{9, 17, Rational[53, 25]}, {9, 18, Rational[68, 25]}, {
      10, 18, Rational[64, 25]}}, {{9, 17, 2.12}, {9, 18, 2.72}, {
      10, 18, 2.56}}]], 
   Polygon3DBox[
    NCache[{{9, 17, Rational[53, 25]}, {10, 17, Rational[49, 25]}, {
      10, 18, Rational[64, 25]}}, {{9, 17, 2.12}, {10, 17, 1.96}, {
      10, 18, 2.56}}]], 
   Polygon3DBox[
    NCache[{{9, 18, Rational[68, 25]}, {9, 19, Rational[17, 5]}, {
      10, 19, Rational[81, 25]}}, {{9, 18, 2.72}, {9, 19, 3.4}, {
      10, 19, 3.24}}]], 
   Polygon3DBox[
    NCache[{{9, 18, Rational[68, 25]}, {10, 18, Rational[64, 25]}, {
      10, 19, Rational[81, 25]}}, {{9, 18, 2.72}, {10, 18, 2.56}, {
      10, 19, 3.24}}]], 
   Polygon3DBox[
    NCache[{{9, 19, Rational[17, 5]}, {9, 20, Rational[104, 25]}, {10, 20, 
      4}}, {{9, 19, 3.4}, {9, 20, 4.16}, {10, 20, 4}}]], 
   Polygon3DBox[
    NCache[{{9, 19, Rational[17, 5]}, {10, 19, Rational[81, 25]}, {10, 20, 
      4}}, {{9, 19, 3.4}, {10, 19, 3.24}, {10, 20, 4}}]], 
   Polygon3DBox[
    NCache[{{10, 1, Rational[81, 25]}, {10, 2, Rational[64, 25]}, {
      11, 2, Rational[68, 25]}}, {{10, 1, 3.24}, {10, 2, 2.56}, {
      11, 2, 2.72}}]], 
   Polygon3DBox[
    NCache[{{10, 1, Rational[81, 25]}, {11, 1, Rational[17, 5]}, {
      11, 2, Rational[68, 25]}}, {{10, 1, 3.24}, {11, 1, 3.4}, {
      11, 2, 2.72}}]], 
   Polygon3DBox[
    NCache[{{10, 2, Rational[64, 25]}, {10, 3, Rational[49, 25]}, {
      11, 3, Rational[53, 25]}}, {{10, 2, 2.56}, {10, 3, 1.96}, {
      11, 3, 2.12}}]], 
   Polygon3DBox[
    NCache[{{10, 2, Rational[64, 25]}, {11, 2, Rational[68, 25]}, {
      11, 3, Rational[53, 25]}}, {{10, 2, 2.56}, {11, 2, 2.72}, {
      11, 3, 2.12}}]], 
   Polygon3DBox[
    NCache[{{10, 3, Rational[49, 25]}, {10, 4, Rational[36, 25]}, {
      11, 4, Rational[8, 5]}}, {{10, 3, 1.96}, {10, 4, 1.44}, {11, 4, 1.6}}]],
    Polygon3DBox[
    NCache[{{10, 3, Rational[49, 25]}, {11, 3, Rational[53, 25]}, {
      11, 4, Rational[8, 5]}}, {{10, 3, 1.96}, {11, 3, 2.12}, {11, 4, 1.6}}]],
    Polygon3DBox[
    NCache[{{10, 4, Rational[36, 25]}, {10, 5, 1}, {
      11, 5, Rational[29, 25]}}, {{10, 4, 1.44}, {10, 5, 1}, {11, 5, 1.16}}]],
    Polygon3DBox[
    NCache[{{10, 4, Rational[36, 25]}, {11, 4, Rational[8, 5]}, {
      11, 5, Rational[29, 25]}}, {{10, 4, 1.44}, {11, 4, 1.6}, {
      11, 5, 1.16}}]], 
   Polygon3DBox[
    NCache[{{10, 5, 1}, {10, 6, Rational[16, 25]}, {
      11, 6, Rational[4, 5]}}, {{10, 5, 1}, {10, 6, 0.64}, {11, 6, 0.8}}]], 
   Polygon3DBox[
    NCache[{{10, 5, 1}, {11, 5, Rational[29, 25]}, {
      11, 6, Rational[4, 5]}}, {{10, 5, 1}, {11, 5, 1.16}, {11, 6, 0.8}}]], 
   Polygon3DBox[
    NCache[{{10, 6, Rational[16, 25]}, {10, 7, Rational[9, 25]}, {
      11, 7, Rational[13, 25]}}, {{10, 6, 0.64}, {10, 7, 0.36}, {
      11, 7, 0.52}}]], 
   Polygon3DBox[
    NCache[{{10, 6, Rational[16, 25]}, {11, 6, Rational[4, 5]}, {
      11, 7, Rational[13, 25]}}, {{10, 6, 0.64}, {11, 6, 0.8}, {
      11, 7, 0.52}}]], 
   Polygon3DBox[
    NCache[{{10, 7, Rational[9, 25]}, {10, 8, Rational[4, 25]}, {
      11, 8, Rational[8, 25]}}, {{10, 7, 0.36}, {10, 8, 0.16}, {
      11, 8, 0.32}}]], 
   Polygon3DBox[
    NCache[{{10, 7, Rational[9, 25]}, {11, 7, Rational[13, 25]}, {
      11, 8, Rational[8, 25]}}, {{10, 7, 0.36}, {11, 7, 0.52}, {
      11, 8, 0.32}}]], 
   Polygon3DBox[
    NCache[{{10, 8, Rational[4, 25]}, {10, 9, Rational[1, 25]}, {
      11, 9, Rational[1, 5]}}, {{10, 8, 0.16}, {10, 9, 0.04}, {11, 9, 0.2}}]],
    Polygon3DBox[
    NCache[{{10, 8, Rational[4, 25]}, {11, 8, Rational[8, 25]}, {
      11, 9, Rational[1, 5]}}, {{10, 8, 0.16}, {11, 8, 0.32}, {11, 9, 0.2}}]],
    Polygon3DBox[
    NCache[{{10, 9, Rational[1, 25]}, {10, 10, 0}, {
      11, 10, Rational[4, 25]}}, {{10, 9, 0.04}, {10, 10, 0}, {
      11, 10, 0.16}}]], 
   Polygon3DBox[
    NCache[{{10, 9, Rational[1, 25]}, {11, 9, Rational[1, 5]}, {
      11, 10, Rational[4, 25]}}, {{10, 9, 0.04}, {11, 9, 0.2}, {
      11, 10, 0.16}}]], 
   Polygon3DBox[
    NCache[{{10, 10, 0}, {10, 11, Rational[1, 25]}, {
      11, 11, Rational[1, 5]}}, {{10, 10, 0}, {10, 11, 0.04}, {
      11, 11, 0.2}}]], 
   Polygon3DBox[
    NCache[{{10, 10, 0}, {11, 10, Rational[4, 25]}, {
      11, 11, Rational[1, 5]}}, {{10, 10, 0}, {11, 10, 0.16}, {
      11, 11, 0.2}}]], 
   Polygon3DBox[
    NCache[{{10, 11, Rational[1, 25]}, {10, 12, Rational[4, 25]}, {
      11, 12, Rational[8, 25]}}, {{10, 11, 0.04}, {10, 12, 0.16}, {
      11, 12, 0.32}}]], 
   Polygon3DBox[
    NCache[{{10, 11, Rational[1, 25]}, {11, 11, Rational[1, 5]}, {
      11, 12, Rational[8, 25]}}, {{10, 11, 0.04}, {11, 11, 0.2}, {
      11, 12, 0.32}}]], 
   Polygon3DBox[
    NCache[{{10, 12, Rational[4, 25]}, {10, 13, Rational[9, 25]}, {
      11, 13, Rational[13, 25]}}, {{10, 12, 0.16}, {10, 13, 0.36}, {
      11, 13, 0.52}}]], 
   Polygon3DBox[
    NCache[{{10, 12, Rational[4, 25]}, {11, 12, Rational[8, 25]}, {
      11, 13, Rational[13, 25]}}, {{10, 12, 0.16}, {11, 12, 0.32}, {
      11, 13, 0.52}}]], 
   Polygon3DBox[
    NCache[{{10, 13, Rational[9, 25]}, {10, 14, Rational[16, 25]}, {
      11, 14, Rational[4, 5]}}, {{10, 13, 0.36}, {10, 14, 0.64}, {
      11, 14, 0.8}}]], 
   Polygon3DBox[
    NCache[{{10, 13, Rational[9, 25]}, {11, 13, Rational[13, 25]}, {
      11, 14, Rational[4, 5]}}, {{10, 13, 0.36}, {11, 13, 0.52}, {
      11, 14, 0.8}}]], 
   Polygon3DBox[
    NCache[{{10, 14, Rational[16, 25]}, {10, 15, 1}, {
      11, 15, Rational[29, 25]}}, {{10, 14, 0.64}, {10, 15, 1}, {
      11, 15, 1.16}}]], 
   Polygon3DBox[
    NCache[{{10, 14, Rational[16, 25]}, {11, 14, Rational[4, 5]}, {
      11, 15, Rational[29, 25]}}, {{10, 14, 0.64}, {11, 14, 0.8}, {
      11, 15, 1.16}}]], 
   Polygon3DBox[
    NCache[{{10, 15, 1}, {10, 16, Rational[36, 25]}, {
      11, 16, Rational[8, 5]}}, {{10, 15, 1}, {10, 16, 1.44}, {
      11, 16, 1.6}}]], 
   Polygon3DBox[
    NCache[{{10, 15, 1}, {11, 15, Rational[29, 25]}, {
      11, 16, Rational[8, 5]}}, {{10, 15, 1}, {11, 15, 1.16}, {
      11, 16, 1.6}}]], 
   Polygon3DBox[
    NCache[{{10, 16, Rational[36, 25]}, {10, 17, Rational[49, 25]}, {
      11, 17, Rational[53, 25]}}, {{10, 16, 1.44}, {10, 17, 1.96}, {
      11, 17, 2.12}}]], 
   Polygon3DBox[
    NCache[{{10, 16, Rational[36, 25]}, {11, 16, Rational[8, 5]}, {
      11, 17, Rational[53, 25]}}, {{10, 16, 1.44}, {11, 16, 1.6}, {
      11, 17, 2.12}}]], 
   Polygon3DBox[
    NCache[{{10, 17, Rational[49, 25]}, {10, 18, Rational[64, 25]}, {
      11, 18, Rational[68, 25]}}, {{10, 17, 1.96}, {10, 18, 2.56}, {
      11, 18, 2.72}}]], 
   Polygon3DBox[
    NCache[{{10, 17, Rational[49, 25]}, {11, 17, Rational[53, 25]}, {
      11, 18, Rational[68, 25]}}, {{10, 17, 1.96}, {11, 17, 2.12}, {
      11, 18, 2.72}}]], 
   Polygon3DBox[
    NCache[{{10, 18, Rational[64, 25]}, {10, 19, Rational[81, 25]}, {
      11, 19, Rational[17, 5]}}, {{10, 18, 2.56}, {10, 19, 3.24}, {
      11, 19, 3.4}}]], 
   Polygon3DBox[
    NCache[{{10, 18, Rational[64, 25]}, {11, 18, Rational[68, 25]}, {
      11, 19, Rational[17, 5]}}, {{10, 18, 2.56}, {11, 18, 2.72}, {
      11, 19, 3.4}}]], 
   Polygon3DBox[
    NCache[{{10, 19, Rational[81, 25]}, {10, 20, 4}, {
      11, 20, Rational[104, 25]}}, {{10, 19, 3.24}, {10, 20, 4}, {
      11, 20, 4.16}}]], 
   Polygon3DBox[
    NCache[{{10, 19, Rational[81, 25]}, {11, 19, Rational[17, 5]}, {
      11, 20, Rational[104, 25]}}, {{10, 19, 3.24}, {11, 19, 3.4}, {
      11, 20, 4.16}}]], 
   Polygon3DBox[
    NCache[{{11, 1, Rational[17, 5]}, {11, 2, Rational[68, 25]}, {
      12, 2, Rational[16, 5]}}, {{11, 1, 3.4}, {11, 2, 2.72}, {12, 2, 3.2}}]],
    Polygon3DBox[
    NCache[{{11, 1, Rational[17, 5]}, {12, 1, Rational[97, 25]}, {
      12, 2, Rational[16, 5]}}, {{11, 1, 3.4}, {12, 1, 3.88}, {12, 2, 3.2}}]],
    Polygon3DBox[
    NCache[{{11, 2, Rational[68, 25]}, {11, 3, Rational[53, 25]}, {
      12, 3, Rational[13, 5]}}, {{11, 2, 2.72}, {11, 3, 2.12}, {
      12, 3, 2.6}}]], 
   Polygon3DBox[
    NCache[{{11, 2, Rational[68, 25]}, {12, 2, Rational[16, 5]}, {
      12, 3, Rational[13, 5]}}, {{11, 2, 2.72}, {12, 2, 3.2}, {12, 3, 2.6}}]],
    Polygon3DBox[
    NCache[{{11, 3, Rational[53, 25]}, {11, 4, Rational[8, 5]}, {
      12, 4, Rational[52, 25]}}, {{11, 3, 2.12}, {11, 4, 1.6}, {
      12, 4, 2.08}}]], 
   Polygon3DBox[
    NCache[{{11, 3, Rational[53, 25]}, {12, 3, Rational[13, 5]}, {
      12, 4, Rational[52, 25]}}, {{11, 3, 2.12}, {12, 3, 2.6}, {
      12, 4, 2.08}}]], 
   Polygon3DBox[
    NCache[{{11, 4, Rational[8, 5]}, {11, 5, Rational[29, 25]}, {
      12, 5, Rational[41, 25]}}, {{11, 4, 1.6}, {11, 5, 1.16}, {
      12, 5, 1.64}}]], 
   Polygon3DBox[
    NCache[{{11, 4, Rational[8, 5]}, {12, 4, Rational[52, 25]}, {
      12, 5, Rational[41, 25]}}, {{11, 4, 1.6}, {12, 4, 2.08}, {
      12, 5, 1.64}}]], 
   Polygon3DBox[
    NCache[{{11, 5, Rational[29, 25]}, {11, 6, Rational[4, 5]}, {
      12, 6, Rational[32, 25]}}, {{11, 5, 1.16}, {11, 6, 0.8}, {
      12, 6, 1.28}}]], 
   Polygon3DBox[
    NCache[{{11, 5, Rational[29, 25]}, {12, 5, Rational[41, 25]}, {
      12, 6, Rational[32, 25]}}, {{11, 5, 1.16}, {12, 5, 1.64}, {
      12, 6, 1.28}}]], 
   Polygon3DBox[
    NCache[{{11, 6, Rational[4, 5]}, {11, 7, Rational[13, 25]}, {12, 7, 
      1}}, {{11, 6, 0.8}, {11, 7, 0.52}, {12, 7, 1}}]], 
   Polygon3DBox[
    NCache[{{11, 6, Rational[4, 5]}, {12, 6, Rational[32, 25]}, {12, 7, 
      1}}, {{11, 6, 0.8}, {12, 6, 1.28}, {12, 7, 1}}]], 
   Polygon3DBox[
    NCache[{{11, 7, Rational[13, 25]}, {11, 8, Rational[8, 25]}, {
      12, 8, Rational[4, 5]}}, {{11, 7, 0.52}, {11, 8, 0.32}, {12, 8, 0.8}}]],
    Polygon3DBox[
    NCache[{{11, 7, Rational[13, 25]}, {12, 7, 1}, {
      12, 8, Rational[4, 5]}}, {{11, 7, 0.52}, {12, 7, 1}, {12, 8, 0.8}}]], 
   Polygon3DBox[
    NCache[{{11, 8, Rational[8, 25]}, {11, 9, Rational[1, 5]}, {
      12, 9, Rational[17, 25]}}, {{11, 8, 0.32}, {11, 9, 0.2}, {
      12, 9, 0.68}}]], 
   Polygon3DBox[
    NCache[{{11, 8, Rational[8, 25]}, {12, 8, Rational[4, 5]}, {
      12, 9, Rational[17, 25]}}, {{11, 8, 0.32}, {12, 8, 0.8}, {
      12, 9, 0.68}}]], 
   Polygon3DBox[
    NCache[{{11, 9, Rational[1, 5]}, {11, 10, Rational[4, 25]}, {
      12, 10, Rational[16, 25]}}, {{11, 9, 0.2}, {11, 10, 0.16}, {
      12, 10, 0.64}}]], 
   Polygon3DBox[
    NCache[{{11, 9, Rational[1, 5]}, {12, 9, Rational[17, 25]}, {
      12, 10, Rational[16, 25]}}, {{11, 9, 0.2}, {12, 9, 0.68}, {
      12, 10, 0.64}}]], 
   Polygon3DBox[
    NCache[{{11, 10, Rational[4, 25]}, {11, 11, Rational[1, 5]}, {
      12, 11, Rational[17, 25]}}, {{11, 10, 0.16}, {11, 11, 0.2}, {
      12, 11, 0.68}}]], 
   Polygon3DBox[
    NCache[{{11, 10, Rational[4, 25]}, {12, 10, Rational[16, 25]}, {
      12, 11, Rational[17, 25]}}, {{11, 10, 0.16}, {12, 10, 0.64}, {
      12, 11, 0.68}}]], 
   Polygon3DBox[
    NCache[{{11, 11, Rational[1, 5]}, {11, 12, Rational[8, 25]}, {
      12, 12, Rational[4, 5]}}, {{11, 11, 0.2}, {11, 12, 0.32}, {
      12, 12, 0.8}}]], 
   Polygon3DBox[
    NCache[{{11, 11, Rational[1, 5]}, {12, 11, Rational[17, 25]}, {
      12, 12, Rational[4, 5]}}, {{11, 11, 0.2}, {12, 11, 0.68}, {
      12, 12, 0.8}}]], 
   Polygon3DBox[
    NCache[{{11, 12, Rational[8, 25]}, {11, 13, Rational[13, 25]}, {12, 13, 
      1}}, {{11, 12, 0.32}, {11, 13, 0.52}, {12, 13, 1}}]], 
   Polygon3DBox[
    NCache[{{11, 12, Rational[8, 25]}, {12, 12, Rational[4, 5]}, {12, 13, 
      1}}, {{11, 12, 0.32}, {12, 12, 0.8}, {12, 13, 1}}]], 
   Polygon3DBox[
    NCache[{{11, 13, Rational[13, 25]}, {11, 14, Rational[4, 5]}, {
      12, 14, Rational[32, 25]}}, {{11, 13, 0.52}, {11, 14, 0.8}, {
      12, 14, 1.28}}]], 
   Polygon3DBox[
    NCache[{{11, 13, Rational[13, 25]}, {12, 13, 1}, {
      12, 14, Rational[32, 25]}}, {{11, 13, 0.52}, {12, 13, 1}, {
      12, 14, 1.28}}]], 
   Polygon3DBox[
    NCache[{{11, 14, Rational[4, 5]}, {11, 15, Rational[29, 25]}, {
      12, 15, Rational[41, 25]}}, {{11, 14, 0.8}, {11, 15, 1.16}, {
      12, 15, 1.64}}]], 
   Polygon3DBox[
    NCache[{{11, 14, Rational[4, 5]}, {12, 14, Rational[32, 25]}, {
      12, 15, Rational[41, 25]}}, {{11, 14, 0.8}, {12, 14, 1.28}, {
      12, 15, 1.64}}]], 
   Polygon3DBox[
    NCache[{{11, 15, Rational[29, 25]}, {11, 16, Rational[8, 5]}, {
      12, 16, Rational[52, 25]}}, {{11, 15, 1.16}, {11, 16, 1.6}, {
      12, 16, 2.08}}]], 
   Polygon3DBox[
    NCache[{{11, 15, Rational[29, 25]}, {12, 15, Rational[41, 25]}, {
      12, 16, Rational[52, 25]}}, {{11, 15, 1.16}, {12, 15, 1.64}, {
      12, 16, 2.08}}]], 
   Polygon3DBox[
    NCache[{{11, 16, Rational[8, 5]}, {11, 17, Rational[53, 25]}, {
      12, 17, Rational[13, 5]}}, {{11, 16, 1.6}, {11, 17, 2.12}, {
      12, 17, 2.6}}]], 
   Polygon3DBox[
    NCache[{{11, 16, Rational[8, 5]}, {12, 16, Rational[52, 25]}, {
      12, 17, Rational[13, 5]}}, {{11, 16, 1.6}, {12, 16, 2.08}, {
      12, 17, 2.6}}]], 
   Polygon3DBox[
    NCache[{{11, 17, Rational[53, 25]}, {11, 18, Rational[68, 25]}, {
      12, 18, Rational[16, 5]}}, {{11, 17, 2.12}, {11, 18, 2.72}, {
      12, 18, 3.2}}]], 
   Polygon3DBox[
    NCache[{{11, 17, Rational[53, 25]}, {12, 17, Rational[13, 5]}, {
      12, 18, Rational[16, 5]}}, {{11, 17, 2.12}, {12, 17, 2.6}, {
      12, 18, 3.2}}]], 
   Polygon3DBox[
    NCache[{{11, 18, Rational[68, 25]}, {11, 19, Rational[17, 5]}, {
      12, 19, Rational[97, 25]}}, {{11, 18, 2.72}, {11, 19, 3.4}, {
      12, 19, 3.88}}]], 
   Polygon3DBox[
    NCache[{{11, 18, Rational[68, 25]}, {12, 18, Rational[16, 5]}, {
      12, 19, Rational[97, 25]}}, {{11, 18, 2.72}, {12, 18, 3.2}, {
      12, 19, 3.88}}]], 
   Polygon3DBox[
    NCache[{{11, 19, Rational[17, 5]}, {11, 20, Rational[104, 25]}, {
      12, 20, Rational[116, 25]}}, {{11, 19, 3.4}, {11, 20, 4.16}, {
      12, 20, 4.64}}]], 
   Polygon3DBox[
    NCache[{{11, 19, Rational[17, 5]}, {12, 19, Rational[97, 25]}, {
      12, 20, Rational[116, 25]}}, {{11, 19, 3.4}, {12, 19, 3.88}, {
      12, 20, 4.64}}]], 
   Polygon3DBox[
    NCache[{{12, 1, Rational[97, 25]}, {12, 2, Rational[16, 5]}, {13, 2, 
      4}}, {{12, 1, 3.88}, {12, 2, 3.2}, {13, 2, 4}}]], 
   Polygon3DBox[
    NCache[{{12, 1, Rational[97, 25]}, {13, 1, Rational[117, 25]}, {13, 2, 
      4}}, {{12, 1, 3.88}, {13, 1, 4.68}, {13, 2, 4}}]], 
   Polygon3DBox[
    NCache[{{12, 2, Rational[16, 5]}, {12, 3, Rational[13, 5]}, {
      13, 3, Rational[17, 5]}}, {{12, 2, 3.2}, {12, 3, 2.6}, {13, 3, 3.4}}]], 
   Polygon3DBox[
    NCache[{{12, 2, Rational[16, 5]}, {13, 2, 4}, {
      13, 3, Rational[17, 5]}}, {{12, 2, 3.2}, {13, 2, 4}, {13, 3, 3.4}}]], 
   Polygon3DBox[
    NCache[{{12, 3, Rational[13, 5]}, {12, 4, Rational[52, 25]}, {
      13, 4, Rational[72, 25]}}, {{12, 3, 2.6}, {12, 4, 2.08}, {
      13, 4, 2.88}}]], 
   Polygon3DBox[
    NCache[{{12, 3, Rational[13, 5]}, {13, 3, Rational[17, 5]}, {
      13, 4, Rational[72, 25]}}, {{12, 3, 2.6}, {13, 3, 3.4}, {
      13, 4, 2.88}}]], 
   Polygon3DBox[
    NCache[{{12, 4, Rational[52, 25]}, {12, 5, Rational[41, 25]}, {
      13, 5, Rational[61, 25]}}, {{12, 4, 2.08}, {12, 5, 1.64}, {
      13, 5, 2.44}}]], 
   Polygon3DBox[
    NCache[{{12, 4, Rational[52, 25]}, {13, 4, Rational[72, 25]}, {
      13, 5, Rational[61, 25]}}, {{12, 4, 2.08}, {13, 4, 2.88}, {
      13, 5, 2.44}}]], 
   Polygon3DBox[
    NCache[{{12, 5, Rational[41, 25]}, {12, 6, Rational[32, 25]}, {
      13, 6, Rational[52, 25]}}, {{12, 5, 1.64}, {12, 6, 1.28}, {
      13, 6, 2.08}}]], 
   Polygon3DBox[
    NCache[{{12, 5, Rational[41, 25]}, {13, 5, Rational[61, 25]}, {
      13, 6, Rational[52, 25]}}, {{12, 5, 1.64}, {13, 5, 2.44}, {
      13, 6, 2.08}}]], 
   Polygon3DBox[
    NCache[{{12, 6, Rational[32, 25]}, {12, 7, 1}, {
      13, 7, Rational[9, 5]}}, {{12, 6, 1.28}, {12, 7, 1}, {13, 7, 1.8}}]], 
   Polygon3DBox[
    NCache[{{12, 6, Rational[32, 25]}, {13, 6, Rational[52, 25]}, {
      13, 7, Rational[9, 5]}}, {{12, 6, 1.28}, {13, 6, 2.08}, {13, 7, 1.8}}]],
    Polygon3DBox[
    NCache[{{12, 7, 1}, {12, 8, Rational[4, 5]}, {13, 8, Rational[8, 5]}}, {{
      12, 7, 1}, {12, 8, 0.8}, {13, 8, 1.6}}]], 
   Polygon3DBox[
    NCache[{{12, 7, 1}, {13, 7, Rational[9, 5]}, {13, 8, Rational[8, 5]}}, {{
      12, 7, 1}, {13, 7, 1.8}, {13, 8, 1.6}}]], 
   Polygon3DBox[
    NCache[{{12, 8, Rational[4, 5]}, {12, 9, Rational[17, 25]}, {
      13, 9, Rational[37, 25]}}, {{12, 8, 0.8}, {12, 9, 0.68}, {
      13, 9, 1.48}}]], 
   Polygon3DBox[
    NCache[{{12, 8, Rational[4, 5]}, {13, 8, Rational[8, 5]}, {
      13, 9, Rational[37, 25]}}, {{12, 8, 0.8}, {13, 8, 1.6}, {
      13, 9, 1.48}}]], 
   Polygon3DBox[
    NCache[{{12, 9, Rational[17, 25]}, {12, 10, Rational[16, 25]}, {
      13, 10, Rational[36, 25]}}, {{12, 9, 0.68}, {12, 10, 0.64}, {
      13, 10, 1.44}}]], 
   Polygon3DBox[
    NCache[{{12, 9, Rational[17, 25]}, {13, 9, Rational[37, 25]}, {
      13, 10, Rational[36, 25]}}, {{12, 9, 0.68}, {13, 9, 1.48}, {
      13, 10, 1.44}}]], 
   Polygon3DBox[
    NCache[{{12, 10, Rational[16, 25]}, {12, 11, Rational[17, 25]}, {
      13, 11, Rational[37, 25]}}, {{12, 10, 0.64}, {12, 11, 0.68}, {
      13, 11, 1.48}}]], 
   Polygon3DBox[
    NCache[{{12, 10, Rational[16, 25]}, {13, 10, Rational[36, 25]}, {
      13, 11, Rational[37, 25]}}, {{12, 10, 0.64}, {13, 10, 1.44}, {
      13, 11, 1.48}}]], 
   Polygon3DBox[
    NCache[{{12, 11, Rational[17, 25]}, {12, 12, Rational[4, 5]}, {
      13, 12, Rational[8, 5]}}, {{12, 11, 0.68}, {12, 12, 0.8}, {
      13, 12, 1.6}}]], 
   Polygon3DBox[
    NCache[{{12, 11, Rational[17, 25]}, {13, 11, Rational[37, 25]}, {
      13, 12, Rational[8, 5]}}, {{12, 11, 0.68}, {13, 11, 1.48}, {
      13, 12, 1.6}}]], 
   Polygon3DBox[
    NCache[{{12, 12, Rational[4, 5]}, {12, 13, 1}, {
      13, 13, Rational[9, 5]}}, {{12, 12, 0.8}, {12, 13, 1}, {13, 13, 1.8}}]],
    Polygon3DBox[
    NCache[{{12, 12, Rational[4, 5]}, {13, 12, Rational[8, 5]}, {
      13, 13, Rational[9, 5]}}, {{12, 12, 0.8}, {13, 12, 1.6}, {
      13, 13, 1.8}}]], 
   Polygon3DBox[
    NCache[{{12, 13, 1}, {12, 14, Rational[32, 25]}, {
      13, 14, Rational[52, 25]}}, {{12, 13, 1}, {12, 14, 1.28}, {
      13, 14, 2.08}}]], 
   Polygon3DBox[
    NCache[{{12, 13, 1}, {13, 13, Rational[9, 5]}, {
      13, 14, Rational[52, 25]}}, {{12, 13, 1}, {13, 13, 1.8}, {
      13, 14, 2.08}}]], 
   Polygon3DBox[
    NCache[{{12, 14, Rational[32, 25]}, {12, 15, Rational[41, 25]}, {
      13, 15, Rational[61, 25]}}, {{12, 14, 1.28}, {12, 15, 1.64}, {
      13, 15, 2.44}}]], 
   Polygon3DBox[
    NCache[{{12, 14, Rational[32, 25]}, {13, 14, Rational[52, 25]}, {
      13, 15, Rational[61, 25]}}, {{12, 14, 1.28}, {13, 14, 2.08}, {
      13, 15, 2.44}}]], 
   Polygon3DBox[
    NCache[{{12, 15, Rational[41, 25]}, {12, 16, Rational[52, 25]}, {
      13, 16, Rational[72, 25]}}, {{12, 15, 1.64}, {12, 16, 2.08}, {
      13, 16, 2.88}}]], 
   Polygon3DBox[
    NCache[{{12, 15, Rational[41, 25]}, {13, 15, Rational[61, 25]}, {
      13, 16, Rational[72, 25]}}, {{12, 15, 1.64}, {13, 15, 2.44}, {
      13, 16, 2.88}}]], 
   Polygon3DBox[
    NCache[{{12, 16, Rational[52, 25]}, {12, 17, Rational[13, 5]}, {
      13, 17, Rational[17, 5]}}, {{12, 16, 2.08}, {12, 17, 2.6}, {
      13, 17, 3.4}}]], 
   Polygon3DBox[
    NCache[{{12, 16, Rational[52, 25]}, {13, 16, Rational[72, 25]}, {
      13, 17, Rational[17, 5]}}, {{12, 16, 2.08}, {13, 16, 2.88}, {
      13, 17, 3.4}}]], 
   Polygon3DBox[
    NCache[{{12, 17, Rational[13, 5]}, {12, 18, Rational[16, 5]}, {13, 18, 
      4}}, {{12, 17, 2.6}, {12, 18, 3.2}, {13, 18, 4}}]], 
   Polygon3DBox[
    NCache[{{12, 17, Rational[13, 5]}, {13, 17, Rational[17, 5]}, {13, 18, 
      4}}, {{12, 17, 2.6}, {13, 17, 3.4}, {13, 18, 4}}]], 
   Polygon3DBox[
    NCache[{{12, 18, Rational[16, 5]}, {12, 19, Rational[97, 25]}, {
      13, 19, Rational[117, 25]}}, {{12, 18, 3.2}, {12, 19, 3.88}, {
      13, 19, 4.68}}]], 
   Polygon3DBox[
    NCache[{{12, 18, Rational[16, 5]}, {13, 18, 4}, {
      13, 19, Rational[117, 25]}}, {{12, 18, 3.2}, {13, 18, 4}, {
      13, 19, 4.68}}]], 
   Polygon3DBox[
    NCache[{{12, 19, Rational[97, 25]}, {12, 20, Rational[116, 25]}, {
      13, 20, Rational[136, 25]}}, {{12, 19, 3.88}, {12, 20, 4.64}, {
      13, 20, 5.44}}]], 
   Polygon3DBox[
    NCache[{{12, 19, Rational[97, 25]}, {13, 19, Rational[117, 25]}, {
      13, 20, Rational[136, 25]}}, {{12, 19, 3.88}, {13, 19, 4.68}, {
      13, 20, 5.44}}]], 
   Polygon3DBox[
    NCache[{{13, 1, Rational[117, 25]}, {13, 2, 4}, {
      14, 2, Rational[128, 25]}}, {{13, 1, 4.68}, {13, 2, 4}, {
      14, 2, 5.12}}]], 
   Polygon3DBox[
    NCache[{{13, 1, Rational[117, 25]}, {14, 1, Rational[29, 5]}, {
      14, 2, Rational[128, 25]}}, {{13, 1, 4.68}, {14, 1, 5.8}, {
      14, 2, 5.12}}]], 
   Polygon3DBox[
    NCache[{{13, 2, 4}, {13, 3, Rational[17, 5]}, {
      14, 3, Rational[113, 25]}}, {{13, 2, 4}, {13, 3, 3.4}, {14, 3, 4.52}}]],
    Polygon3DBox[
    NCache[{{13, 2, 4}, {14, 2, Rational[128, 25]}, {
      14, 3, Rational[113, 25]}}, {{13, 2, 4}, {14, 2, 5.12}, {
      14, 3, 4.52}}]], 
   Polygon3DBox[
    NCache[{{13, 3, Rational[17, 5]}, {13, 4, Rational[72, 25]}, {14, 4, 
      4}}, {{13, 3, 3.4}, {13, 4, 2.88}, {14, 4, 4}}]], 
   Polygon3DBox[
    NCache[{{13, 3, Rational[17, 5]}, {14, 3, Rational[113, 25]}, {14, 4, 
      4}}, {{13, 3, 3.4}, {14, 3, 4.52}, {14, 4, 4}}]], 
   Polygon3DBox[
    NCache[{{13, 4, Rational[72, 25]}, {13, 5, Rational[61, 25]}, {
      14, 5, Rational[89, 25]}}, {{13, 4, 2.88}, {13, 5, 2.44}, {
      14, 5, 3.56}}]], 
   Polygon3DBox[
    NCache[{{13, 4, Rational[72, 25]}, {14, 4, 4}, {
      14, 5, Rational[89, 25]}}, {{13, 4, 2.88}, {14, 4, 4}, {14, 5, 3.56}}]],
    Polygon3DBox[
    NCache[{{13, 5, Rational[61, 25]}, {13, 6, Rational[52, 25]}, {
      14, 6, Rational[16, 5]}}, {{13, 5, 2.44}, {13, 6, 2.08}, {
      14, 6, 3.2}}]], 
   Polygon3DBox[
    NCache[{{13, 5, Rational[61, 25]}, {14, 5, Rational[89, 25]}, {
      14, 6, Rational[16, 5]}}, {{13, 5, 2.44}, {14, 5, 3.56}, {
      14, 6, 3.2}}]], 
   Polygon3DBox[
    NCache[{{13, 6, Rational[52, 25]}, {13, 7, Rational[9, 5]}, {
      14, 7, Rational[73, 25]}}, {{13, 6, 2.08}, {13, 7, 1.8}, {
      14, 7, 2.92}}]], 
   Polygon3DBox[
    NCache[{{13, 6, Rational[52, 25]}, {14, 6, Rational[16, 5]}, {
      14, 7, Rational[73, 25]}}, {{13, 6, 2.08}, {14, 6, 3.2}, {
      14, 7, 2.92}}]], 
   Polygon3DBox[
    NCache[{{13, 7, Rational[9, 5]}, {13, 8, Rational[8, 5]}, {
      14, 8, Rational[68, 25]}}, {{13, 7, 1.8}, {13, 8, 1.6}, {
      14, 8, 2.72}}]], 
   Polygon3DBox[
    NCache[{{13, 7, Rational[9, 5]}, {14, 7, Rational[73, 25]}, {
      14, 8, Rational[68, 25]}}, {{13, 7, 1.8}, {14, 7, 2.92}, {
      14, 8, 2.72}}]], 
   Polygon3DBox[
    NCache[{{13, 8, Rational[8, 5]}, {13, 9, Rational[37, 25]}, {
      14, 9, Rational[13, 5]}}, {{13, 8, 1.6}, {13, 9, 1.48}, {14, 9, 2.6}}]],
    Polygon3DBox[
    NCache[{{13, 8, Rational[8, 5]}, {14, 8, Rational[68, 25]}, {
      14, 9, Rational[13, 5]}}, {{13, 8, 1.6}, {14, 8, 2.72}, {14, 9, 2.6}}]],
    Polygon3DBox[
    NCache[{{13, 9, Rational[37, 25]}, {13, 10, Rational[36, 25]}, {
      14, 10, Rational[64, 25]}}, {{13, 9, 1.48}, {13, 10, 1.44}, {
      14, 10, 2.56}}]], 
   Polygon3DBox[
    NCache[{{13, 9, Rational[37, 25]}, {14, 9, Rational[13, 5]}, {
      14, 10, Rational[64, 25]}}, {{13, 9, 1.48}, {14, 9, 2.6}, {
      14, 10, 2.56}}]], 
   Polygon3DBox[
    NCache[{{13, 10, Rational[36, 25]}, {13, 11, Rational[37, 25]}, {
      14, 11, Rational[13, 5]}}, {{13, 10, 1.44}, {13, 11, 1.48}, {
      14, 11, 2.6}}]], 
   Polygon3DBox[
    NCache[{{13, 10, Rational[36, 25]}, {14, 10, Rational[64, 25]}, {
      14, 11, Rational[13, 5]}}, {{13, 10, 1.44}, {14, 10, 2.56}, {
      14, 11, 2.6}}]], 
   Polygon3DBox[
    NCache[{{13, 11, Rational[37, 25]}, {13, 12, Rational[8, 5]}, {
      14, 12, Rational[68, 25]}}, {{13, 11, 1.48}, {13, 12, 1.6}, {
      14, 12, 2.72}}]], 
   Polygon3DBox[
    NCache[{{13, 11, Rational[37, 25]}, {14, 11, Rational[13, 5]}, {
      14, 12, Rational[68, 25]}}, {{13, 11, 1.48}, {14, 11, 2.6}, {
      14, 12, 2.72}}]], 
   Polygon3DBox[
    NCache[{{13, 12, Rational[8, 5]}, {13, 13, Rational[9, 5]}, {
      14, 13, Rational[73, 25]}}, {{13, 12, 1.6}, {13, 13, 1.8}, {
      14, 13, 2.92}}]], 
   Polygon3DBox[
    NCache[{{13, 12, Rational[8, 5]}, {14, 12, Rational[68, 25]}, {
      14, 13, Rational[73, 25]}}, {{13, 12, 1.6}, {14, 12, 2.72}, {
      14, 13, 2.92}}]], 
   Polygon3DBox[
    NCache[{{13, 13, Rational[9, 5]}, {13, 14, Rational[52, 25]}, {
      14, 14, Rational[16, 5]}}, {{13, 13, 1.8}, {13, 14, 2.08}, {
      14, 14, 3.2}}]], 
   Polygon3DBox[
    NCache[{{13, 13, Rational[9, 5]}, {14, 13, Rational[73, 25]}, {
      14, 14, Rational[16, 5]}}, {{13, 13, 1.8}, {14, 13, 2.92}, {
      14, 14, 3.2}}]], 
   Polygon3DBox[
    NCache[{{13, 14, Rational[52, 25]}, {13, 15, Rational[61, 25]}, {
      14, 15, Rational[89, 25]}}, {{13, 14, 2.08}, {13, 15, 2.44}, {
      14, 15, 3.56}}]], 
   Polygon3DBox[
    NCache[{{13, 14, Rational[52, 25]}, {14, 14, Rational[16, 5]}, {
      14, 15, Rational[89, 25]}}, {{13, 14, 2.08}, {14, 14, 3.2}, {
      14, 15, 3.56}}]], 
   Polygon3DBox[
    NCache[{{13, 15, Rational[61, 25]}, {13, 16, Rational[72, 25]}, {14, 16, 
      4}}, {{13, 15, 2.44}, {13, 16, 2.88}, {14, 16, 4}}]], 
   Polygon3DBox[
    NCache[{{13, 15, Rational[61, 25]}, {14, 15, Rational[89, 25]}, {14, 16, 
      4}}, {{13, 15, 2.44}, {14, 15, 3.56}, {14, 16, 4}}]], 
   Polygon3DBox[
    NCache[{{13, 16, Rational[72, 25]}, {13, 17, Rational[17, 5]}, {
      14, 17, Rational[113, 25]}}, {{13, 16, 2.88}, {13, 17, 3.4}, {
      14, 17, 4.52}}]], 
   Polygon3DBox[
    NCache[{{13, 16, Rational[72, 25]}, {14, 16, 4}, {
      14, 17, Rational[113, 25]}}, {{13, 16, 2.88}, {14, 16, 4}, {
      14, 17, 4.52}}]], 
   Polygon3DBox[
    NCache[{{13, 17, Rational[17, 5]}, {13, 18, 4}, {
      14, 18, Rational[128, 25]}}, {{13, 17, 3.4}, {13, 18, 4}, {
      14, 18, 5.12}}]], 
   Polygon3DBox[
    NCache[{{13, 17, Rational[17, 5]}, {14, 17, Rational[113, 25]}, {
      14, 18, Rational[128, 25]}}, {{13, 17, 3.4}, {14, 17, 4.52}, {
      14, 18, 5.12}}]], 
   Polygon3DBox[
    NCache[{{13, 18, 4}, {13, 19, Rational[117, 25]}, {
      14, 19, Rational[29, 5]}}, {{13, 18, 4}, {13, 19, 4.68}, {
      14, 19, 5.8}}]], 
   Polygon3DBox[
    NCache[{{13, 18, 4}, {14, 18, Rational[128, 25]}, {
      14, 19, Rational[29, 5]}}, {{13, 18, 4}, {14, 18, 5.12}, {
      14, 19, 5.8}}]], 
   Polygon3DBox[
    NCache[{{13, 19, Rational[117, 25]}, {13, 20, Rational[136, 25]}, {
      14, 20, Rational[164, 25]}}, {{13, 19, 4.68}, {13, 20, 5.44}, {
      14, 20, 6.56}}]], 
   Polygon3DBox[
    NCache[{{13, 19, Rational[117, 25]}, {14, 19, Rational[29, 5]}, {
      14, 20, Rational[164, 25]}}, {{13, 19, 4.68}, {14, 19, 5.8}, {
      14, 20, 6.56}}]], 
   Polygon3DBox[
    NCache[{{14, 1, Rational[29, 5]}, {14, 2, Rational[128, 25]}, {
      15, 2, Rational[164, 25]}}, {{14, 1, 5.8}, {14, 2, 5.12}, {
      15, 2, 6.56}}]], 
   Polygon3DBox[
    NCache[{{14, 1, Rational[29, 5]}, {15, 1, Rational[181, 25]}, {
      15, 2, Rational[164, 25]}}, {{14, 1, 5.8}, {15, 1, 7.24}, {
      15, 2, 6.56}}]], 
   Polygon3DBox[
    NCache[{{14, 2, Rational[128, 25]}, {14, 3, Rational[113, 25]}, {
      15, 3, Rational[149, 25]}}, {{14, 2, 5.12}, {14, 3, 4.52}, {
      15, 3, 5.96}}]], 
   Polygon3DBox[
    NCache[{{14, 2, Rational[128, 25]}, {15, 2, Rational[164, 25]}, {
      15, 3, Rational[149, 25]}}, {{14, 2, 5.12}, {15, 2, 6.56}, {
      15, 3, 5.96}}]], 
   Polygon3DBox[
    NCache[{{14, 3, Rational[113, 25]}, {14, 4, 4}, {
      15, 4, Rational[136, 25]}}, {{14, 3, 4.52}, {14, 4, 4}, {
      15, 4, 5.44}}]], 
   Polygon3DBox[
    NCache[{{14, 3, Rational[113, 25]}, {15, 3, Rational[149, 25]}, {
      15, 4, Rational[136, 25]}}, {{14, 3, 4.52}, {15, 3, 5.96}, {
      15, 4, 5.44}}]], 
   Polygon3DBox[
    NCache[{{14, 4, 4}, {14, 5, Rational[89, 25]}, {15, 5, 5}}, {{14, 4, 4}, {
      14, 5, 3.56}, {15, 5, 5}}]], 
   Polygon3DBox[
    NCache[{{14, 4, 4}, {15, 4, Rational[136, 25]}, {15, 5, 5}}, {{14, 4, 
      4}, {15, 4, 5.44}, {15, 5, 5}}]], 
   Polygon3DBox[
    NCache[{{14, 5, Rational[89, 25]}, {14, 6, Rational[16, 5]}, {
      15, 6, Rational[116, 25]}}, {{14, 5, 3.56}, {14, 6, 3.2}, {
      15, 6, 4.64}}]], 
   Polygon3DBox[
    NCache[{{14, 5, Rational[89, 25]}, {15, 5, 5}, {
      15, 6, Rational[116, 25]}}, {{14, 5, 3.56}, {15, 5, 5}, {
      15, 6, 4.64}}]], 
   Polygon3DBox[
    NCache[{{14, 6, Rational[16, 5]}, {14, 7, Rational[73, 25]}, {
      15, 7, Rational[109, 25]}}, {{14, 6, 3.2}, {14, 7, 2.92}, {
      15, 7, 4.36}}]], 
   Polygon3DBox[
    NCache[{{14, 6, Rational[16, 5]}, {15, 6, Rational[116, 25]}, {
      15, 7, Rational[109, 25]}}, {{14, 6, 3.2}, {15, 6, 4.64}, {
      15, 7, 4.36}}]], 
   Polygon3DBox[
    NCache[{{14, 7, Rational[73, 25]}, {14, 8, Rational[68, 25]}, {
      15, 8, Rational[104, 25]}}, {{14, 7, 2.92}, {14, 8, 2.72}, {
      15, 8, 4.16}}]], 
   Polygon3DBox[
    NCache[{{14, 7, Rational[73, 25]}, {15, 7, Rational[109, 25]}, {
      15, 8, Rational[104, 25]}}, {{14, 7, 2.92}, {15, 7, 4.36}, {
      15, 8, 4.16}}]], 
   Polygon3DBox[
    NCache[{{14, 8, Rational[68, 25]}, {14, 9, Rational[13, 5]}, {
      15, 9, Rational[101, 25]}}, {{14, 8, 2.72}, {14, 9, 2.6}, {
      15, 9, 4.04}}]], 
   Polygon3DBox[
    NCache[{{14, 8, Rational[68, 25]}, {15, 8, Rational[104, 25]}, {
      15, 9, Rational[101, 25]}}, {{14, 8, 2.72}, {15, 8, 4.16}, {
      15, 9, 4.04}}]], 
   Polygon3DBox[
    NCache[{{14, 9, Rational[13, 5]}, {14, 10, Rational[64, 25]}, {15, 10, 
      4}}, {{14, 9, 2.6}, {14, 10, 2.56}, {15, 10, 4}}]], 
   Polygon3DBox[
    NCache[{{14, 9, Rational[13, 5]}, {15, 9, Rational[101, 25]}, {15, 10, 
      4}}, {{14, 9, 2.6}, {15, 9, 4.04}, {15, 10, 4}}]], 
   Polygon3DBox[
    NCache[{{14, 10, Rational[64, 25]}, {14, 11, Rational[13, 5]}, {
      15, 11, Rational[101, 25]}}, {{14, 10, 2.56}, {14, 11, 2.6}, {
      15, 11, 4.04}}]], 
   Polygon3DBox[
    NCache[{{14, 10, Rational[64, 25]}, {15, 10, 4}, {
      15, 11, Rational[101, 25]}}, {{14, 10, 2.56}, {15, 10, 4}, {
      15, 11, 4.04}}]], 
   Polygon3DBox[
    NCache[{{14, 11, Rational[13, 5]}, {14, 12, Rational[68, 25]}, {
      15, 12, Rational[104, 25]}}, {{14, 11, 2.6}, {14, 12, 2.72}, {
      15, 12, 4.16}}]], 
   Polygon3DBox[
    NCache[{{14, 11, Rational[13, 5]}, {15, 11, Rational[101, 25]}, {
      15, 12, Rational[104, 25]}}, {{14, 11, 2.6}, {15, 11, 4.04}, {
      15, 12, 4.16}}]], 
   Polygon3DBox[
    NCache[{{14, 12, Rational[68, 25]}, {14, 13, Rational[73, 25]}, {
      15, 13, Rational[109, 25]}}, {{14, 12, 2.72}, {14, 13, 2.92}, {
      15, 13, 4.36}}]], 
   Polygon3DBox[
    NCache[{{14, 12, Rational[68, 25]}, {15, 12, Rational[104, 25]}, {
      15, 13, Rational[109, 25]}}, {{14, 12, 2.72}, {15, 12, 4.16}, {
      15, 13, 4.36}}]], 
   Polygon3DBox[
    NCache[{{14, 13, Rational[73, 25]}, {14, 14, Rational[16, 5]}, {
      15, 14, Rational[116, 25]}}, {{14, 13, 2.92}, {14, 14, 3.2}, {
      15, 14, 4.64}}]], 
   Polygon3DBox[
    NCache[{{14, 13, Rational[73, 25]}, {15, 13, Rational[109, 25]}, {
      15, 14, Rational[116, 25]}}, {{14, 13, 2.92}, {15, 13, 4.36}, {
      15, 14, 4.64}}]], 
   Polygon3DBox[
    NCache[{{14, 14, Rational[16, 5]}, {14, 15, Rational[89, 25]}, {15, 15, 
      5}}, {{14, 14, 3.2}, {14, 15, 3.56}, {15, 15, 5}}]], 
   Polygon3DBox[
    NCache[{{14, 14, Rational[16, 5]}, {15, 14, Rational[116, 25]}, {15, 15, 
      5}}, {{14, 14, 3.2}, {15, 14, 4.64}, {15, 15, 5}}]], 
   Polygon3DBox[
    NCache[{{14, 15, Rational[89, 25]}, {14, 16, 4}, {
      15, 16, Rational[136, 25]}}, {{14, 15, 3.56}, {14, 16, 4}, {
      15, 16, 5.44}}]], 
   Polygon3DBox[
    NCache[{{14, 15, Rational[89, 25]}, {15, 15, 5}, {
      15, 16, Rational[136, 25]}}, {{14, 15, 3.56}, {15, 15, 5}, {
      15, 16, 5.44}}]], 
   Polygon3DBox[
    NCache[{{14, 16, 4}, {14, 17, Rational[113, 25]}, {
      15, 17, Rational[149, 25]}}, {{14, 16, 4}, {14, 17, 4.52}, {
      15, 17, 5.96}}]], 
   Polygon3DBox[
    NCache[{{14, 16, 4}, {15, 16, Rational[136, 25]}, {
      15, 17, Rational[149, 25]}}, {{14, 16, 4}, {15, 16, 5.44}, {
      15, 17, 5.96}}]], 
   Polygon3DBox[
    NCache[{{14, 17, Rational[113, 25]}, {14, 18, Rational[128, 25]}, {
      15, 18, Rational[164, 25]}}, {{14, 17, 4.52}, {14, 18, 5.12}, {
      15, 18, 6.56}}]], 
   Polygon3DBox[
    NCache[{{14, 17, Rational[113, 25]}, {15, 17, Rational[149, 25]}, {
      15, 18, Rational[164, 25]}}, {{14, 17, 4.52}, {15, 17, 5.96}, {
      15, 18, 6.56}}]], 
   Polygon3DBox[
    NCache[{{14, 18, Rational[128, 25]}, {14, 19, Rational[29, 5]}, {
      15, 19, Rational[181, 25]}}, {{14, 18, 5.12}, {14, 19, 5.8}, {
      15, 19, 7.24}}]], 
   Polygon3DBox[
    NCache[{{14, 18, Rational[128, 25]}, {15, 18, Rational[164, 25]}, {
      15, 19, Rational[181, 25]}}, {{14, 18, 5.12}, {15, 18, 6.56}, {
      15, 19, 7.24}}]], 
   Polygon3DBox[
    NCache[{{14, 19, Rational[29, 5]}, {14, 20, Rational[164, 25]}, {15, 20, 
      8}}, {{14, 19, 5.8}, {14, 20, 6.56}, {15, 20, 8}}]], 
   Polygon3DBox[
    NCache[{{14, 19, Rational[29, 5]}, {15, 19, Rational[181, 25]}, {15, 20, 
      8}}, {{14, 19, 5.8}, {15, 19, 7.24}, {15, 20, 8}}]], 
   Polygon3DBox[
    NCache[{{15, 1, Rational[181, 25]}, {15, 2, Rational[164, 25]}, {
      16, 2, Rational[208, 25]}}, {{15, 1, 7.24}, {15, 2, 6.56}, {
      16, 2, 8.32}}]], 
   Polygon3DBox[
    NCache[{{15, 1, Rational[181, 25]}, {16, 1, 9}, {
      16, 2, Rational[208, 25]}}, {{15, 1, 7.24}, {16, 1, 9}, {
      16, 2, 8.32}}]], 
   Polygon3DBox[
    NCache[{{15, 2, Rational[164, 25]}, {15, 3, Rational[149, 25]}, {
      16, 3, Rational[193, 25]}}, {{15, 2, 6.56}, {15, 3, 5.96}, {
      16, 3, 7.72}}]], 
   Polygon3DBox[
    NCache[{{15, 2, Rational[164, 25]}, {16, 2, Rational[208, 25]}, {
      16, 3, Rational[193, 25]}}, {{15, 2, 6.56}, {16, 2, 8.32}, {
      16, 3, 7.72}}]], 
   Polygon3DBox[
    NCache[{{15, 3, Rational[149, 25]}, {15, 4, Rational[136, 25]}, {
      16, 4, Rational[36, 5]}}, {{15, 3, 5.96}, {15, 4, 5.44}, {
      16, 4, 7.2}}]], 
   Polygon3DBox[
    NCache[{{15, 3, Rational[149, 25]}, {16, 3, Rational[193, 25]}, {
      16, 4, Rational[36, 5]}}, {{15, 3, 5.96}, {16, 3, 7.72}, {
      16, 4, 7.2}}]], 
   Polygon3DBox[
    NCache[{{15, 4, Rational[136, 25]}, {15, 5, 5}, {
      16, 5, Rational[169, 25]}}, {{15, 4, 5.44}, {15, 5, 5}, {
      16, 5, 6.76}}]], 
   Polygon3DBox[
    NCache[{{15, 4, Rational[136, 25]}, {16, 4, Rational[36, 5]}, {
      16, 5, Rational[169, 25]}}, {{15, 4, 5.44}, {16, 4, 7.2}, {
      16, 5, 6.76}}]], 
   Polygon3DBox[
    NCache[{{15, 5, 5}, {15, 6, Rational[116, 25]}, {
      16, 6, Rational[32, 5]}}, {{15, 5, 5}, {15, 6, 4.64}, {16, 6, 6.4}}]], 
   Polygon3DBox[
    NCache[{{15, 5, 5}, {16, 5, Rational[169, 25]}, {
      16, 6, Rational[32, 5]}}, {{15, 5, 5}, {16, 5, 6.76}, {16, 6, 6.4}}]], 
   Polygon3DBox[
    NCache[{{15, 6, Rational[116, 25]}, {15, 7, Rational[109, 25]}, {
      16, 7, Rational[153, 25]}}, {{15, 6, 4.64}, {15, 7, 4.36}, {
      16, 7, 6.12}}]], 
   Polygon3DBox[
    NCache[{{15, 6, Rational[116, 25]}, {16, 6, Rational[32, 5]}, {
      16, 7, Rational[153, 25]}}, {{15, 6, 4.64}, {16, 6, 6.4}, {
      16, 7, 6.12}}]], 
   Polygon3DBox[
    NCache[{{15, 7, Rational[109, 25]}, {15, 8, Rational[104, 25]}, {
      16, 8, Rational[148, 25]}}, {{15, 7, 4.36}, {15, 8, 4.16}, {
      16, 8, 5.92}}]], 
   Polygon3DBox[
    NCache[{{15, 7, Rational[109, 25]}, {16, 7, Rational[153, 25]}, {
      16, 8, Rational[148, 25]}}, {{15, 7, 4.36}, {16, 7, 6.12}, {
      16, 8, 5.92}}]], 
   Polygon3DBox[
    NCache[{{15, 8, Rational[104, 25]}, {15, 9, Rational[101, 25]}, {
      16, 9, Rational[29, 5]}}, {{15, 8, 4.16}, {15, 9, 4.04}, {
      16, 9, 5.8}}]], 
   Polygon3DBox[
    NCache[{{15, 8, Rational[104, 25]}, {16, 8, Rational[148, 25]}, {
      16, 9, Rational[29, 5]}}, {{15, 8, 4.16}, {16, 8, 5.92}, {
      16, 9, 5.8}}]], 
   Polygon3DBox[
    NCache[{{15, 9, Rational[101, 25]}, {15, 10, 4}, {
      16, 10, Rational[144, 25]}}, {{15, 9, 4.04}, {15, 10, 4}, {
      16, 10, 5.76}}]], 
   Polygon3DBox[
    NCache[{{15, 9, Rational[101, 25]}, {16, 9, Rational[29, 5]}, {
      16, 10, Rational[144, 25]}}, {{15, 9, 4.04}, {16, 9, 5.8}, {
      16, 10, 5.76}}]], 
   Polygon3DBox[
    NCache[{{15, 10, 4}, {15, 11, Rational[101, 25]}, {
      16, 11, Rational[29, 5]}}, {{15, 10, 4}, {15, 11, 4.04}, {
      16, 11, 5.8}}]], 
   Polygon3DBox[
    NCache[{{15, 10, 4}, {16, 10, Rational[144, 25]}, {
      16, 11, Rational[29, 5]}}, {{15, 10, 4}, {16, 10, 5.76}, {
      16, 11, 5.8}}]], 
   Polygon3DBox[
    NCache[{{15, 11, Rational[101, 25]}, {15, 12, Rational[104, 25]}, {
      16, 12, Rational[148, 25]}}, {{15, 11, 4.04}, {15, 12, 4.16}, {
      16, 12, 5.92}}]], 
   Polygon3DBox[
    NCache[{{15, 11, Rational[101, 25]}, {16, 11, Rational[29, 5]}, {
      16, 12, Rational[148, 25]}}, {{15, 11, 4.04}, {16, 11, 5.8}, {
      16, 12, 5.92}}]], 
   Polygon3DBox[
    NCache[{{15, 12, Rational[104, 25]}, {15, 13, Rational[109, 25]}, {
      16, 13, Rational[153, 25]}}, {{15, 12, 4.16}, {15, 13, 4.36}, {
      16, 13, 6.12}}]], 
   Polygon3DBox[
    NCache[{{15, 12, Rational[104, 25]}, {16, 12, Rational[148, 25]}, {
      16, 13, Rational[153, 25]}}, {{15, 12, 4.16}, {16, 12, 5.92}, {
      16, 13, 6.12}}]], 
   Polygon3DBox[
    NCache[{{15, 13, Rational[109, 25]}, {15, 14, Rational[116, 25]}, {
      16, 14, Rational[32, 5]}}, {{15, 13, 4.36}, {15, 14, 4.64}, {
      16, 14, 6.4}}]], 
   Polygon3DBox[
    NCache[{{15, 13, Rational[109, 25]}, {16, 13, Rational[153, 25]}, {
      16, 14, Rational[32, 5]}}, {{15, 13, 4.36}, {16, 13, 6.12}, {
      16, 14, 6.4}}]], 
   Polygon3DBox[
    NCache[{{15, 14, Rational[116, 25]}, {15, 15, 5}, {
      16, 15, Rational[169, 25]}}, {{15, 14, 4.64}, {15, 15, 5}, {
      16, 15, 6.76}}]], 
   Polygon3DBox[
    NCache[{{15, 14, Rational[116, 25]}, {16, 14, Rational[32, 5]}, {
      16, 15, Rational[169, 25]}}, {{15, 14, 4.64}, {16, 14, 6.4}, {
      16, 15, 6.76}}]], 
   Polygon3DBox[
    NCache[{{15, 15, 5}, {15, 16, Rational[136, 25]}, {
      16, 16, Rational[36, 5]}}, {{15, 15, 5}, {15, 16, 5.44}, {
      16, 16, 7.2}}]], 
   Polygon3DBox[
    NCache[{{15, 15, 5}, {16, 15, Rational[169, 25]}, {
      16, 16, Rational[36, 5]}}, {{15, 15, 5}, {16, 15, 6.76}, {
      16, 16, 7.2}}]], 
   Polygon3DBox[
    NCache[{{15, 16, Rational[136, 25]}, {15, 17, Rational[149, 25]}, {
      16, 17, Rational[193, 25]}}, {{15, 16, 5.44}, {15, 17, 5.96}, {
      16, 17, 7.72}}]], 
   Polygon3DBox[
    NCache[{{15, 16, Rational[136, 25]}, {16, 16, Rational[36, 5]}, {
      16, 17, Rational[193, 25]}}, {{15, 16, 5.44}, {16, 16, 7.2}, {
      16, 17, 7.72}}]], 
   Polygon3DBox[
    NCache[{{15, 17, Rational[149, 25]}, {15, 18, Rational[164, 25]}, {
      16, 18, Rational[208, 25]}}, {{15, 17, 5.96}, {15, 18, 6.56}, {
      16, 18, 8.32}}]], 
   Polygon3DBox[
    NCache[{{15, 17, Rational[149, 25]}, {16, 17, Rational[193, 25]}, {
      16, 18, Rational[208, 25]}}, {{15, 17, 5.96}, {16, 17, 7.72}, {
      16, 18, 8.32}}]], 
   Polygon3DBox[
    NCache[{{15, 18, Rational[164, 25]}, {15, 19, Rational[181, 25]}, {16, 19,
       9}}, {{15, 18, 6.56}, {15, 19, 7.24}, {16, 19, 9}}]], 
   Polygon3DBox[
    NCache[{{15, 18, Rational[164, 25]}, {16, 18, Rational[208, 25]}, {16, 19,
       9}}, {{15, 18, 6.56}, {16, 18, 8.32}, {16, 19, 9}}]], 
   Polygon3DBox[
    NCache[{{15, 19, Rational[181, 25]}, {15, 20, 8}, {
      16, 20, Rational[244, 25]}}, {{15, 19, 7.24}, {15, 20, 8}, {
      16, 20, 9.76}}]], 
   Polygon3DBox[
    NCache[{{15, 19, Rational[181, 25]}, {16, 19, 9}, {
      16, 20, Rational[244, 25]}}, {{15, 19, 7.24}, {16, 19, 9}, {
      16, 20, 9.76}}]], 
   Polygon3DBox[
    NCache[{{16, 1, 9}, {16, 2, Rational[208, 25]}, {
      17, 2, Rational[52, 5]}}, {{16, 1, 9}, {16, 2, 8.32}, {17, 2, 10.4}}]], 
   Polygon3DBox[
    NCache[{{16, 1, 9}, {17, 1, Rational[277, 25]}, {
      17, 2, Rational[52, 5]}}, {{16, 1, 9}, {17, 1, 11.08}, {17, 2, 10.4}}]],
    Polygon3DBox[
    NCache[{{16, 2, Rational[208, 25]}, {16, 3, Rational[193, 25]}, {
      17, 3, Rational[49, 5]}}, {{16, 2, 8.32}, {16, 3, 7.72}, {
      17, 3, 9.8}}]], 
   Polygon3DBox[
    NCache[{{16, 2, Rational[208, 25]}, {17, 2, Rational[52, 5]}, {
      17, 3, Rational[49, 5]}}, {{16, 2, 8.32}, {17, 2, 10.4}, {
      17, 3, 9.8}}]], 
   Polygon3DBox[
    NCache[{{16, 3, Rational[193, 25]}, {16, 4, Rational[36, 5]}, {
      17, 4, Rational[232, 25]}}, {{16, 3, 7.72}, {16, 4, 7.2}, {
      17, 4, 9.28}}]], 
   Polygon3DBox[
    NCache[{{16, 3, Rational[193, 25]}, {17, 3, Rational[49, 5]}, {
      17, 4, Rational[232, 25]}}, {{16, 3, 7.72}, {17, 3, 9.8}, {
      17, 4, 9.28}}]], 
   Polygon3DBox[
    NCache[{{16, 4, Rational[36, 5]}, {16, 5, Rational[169, 25]}, {
      17, 5, Rational[221, 25]}}, {{16, 4, 7.2}, {16, 5, 6.76}, {
      17, 5, 8.84}}]], 
   Polygon3DBox[
    NCache[{{16, 4, Rational[36, 5]}, {17, 4, Rational[232, 25]}, {
      17, 5, Rational[221, 25]}}, {{16, 4, 7.2}, {17, 4, 9.28}, {
      17, 5, 8.84}}]], 
   Polygon3DBox[
    NCache[{{16, 5, Rational[169, 25]}, {16, 6, Rational[32, 5]}, {
      17, 6, Rational[212, 25]}}, {{16, 5, 6.76}, {16, 6, 6.4}, {
      17, 6, 8.48}}]], 
   Polygon3DBox[
    NCache[{{16, 5, Rational[169, 25]}, {17, 5, Rational[221, 25]}, {
      17, 6, Rational[212, 25]}}, {{16, 5, 6.76}, {17, 5, 8.84}, {
      17, 6, 8.48}}]], 
   Polygon3DBox[
    NCache[{{16, 6, Rational[32, 5]}, {16, 7, Rational[153, 25]}, {
      17, 7, Rational[41, 5]}}, {{16, 6, 6.4}, {16, 7, 6.12}, {17, 7, 8.2}}]],
    Polygon3DBox[
    NCache[{{16, 6, Rational[32, 5]}, {17, 6, Rational[212, 25]}, {
      17, 7, Rational[41, 5]}}, {{16, 6, 6.4}, {17, 6, 8.48}, {17, 7, 8.2}}]],
    Polygon3DBox[
    NCache[{{16, 7, Rational[153, 25]}, {16, 8, Rational[148, 25]}, {17, 8, 
      8}}, {{16, 7, 6.12}, {16, 8, 5.92}, {17, 8, 8}}]], 
   Polygon3DBox[
    NCache[{{16, 7, Rational[153, 25]}, {17, 7, Rational[41, 5]}, {17, 8, 
      8}}, {{16, 7, 6.12}, {17, 7, 8.2}, {17, 8, 8}}]], 
   Polygon3DBox[
    NCache[{{16, 8, Rational[148, 25]}, {16, 9, Rational[29, 5]}, {
      17, 9, Rational[197, 25]}}, {{16, 8, 5.92}, {16, 9, 5.8}, {
      17, 9, 7.88}}]], 
   Polygon3DBox[
    NCache[{{16, 8, Rational[148, 25]}, {17, 8, 8}, {
      17, 9, Rational[197, 25]}}, {{16, 8, 5.92}, {17, 8, 8}, {
      17, 9, 7.88}}]], 
   Polygon3DBox[
    NCache[{{16, 9, Rational[29, 5]}, {16, 10, Rational[144, 25]}, {
      17, 10, Rational[196, 25]}}, {{16, 9, 5.8}, {16, 10, 5.76}, {
      17, 10, 7.84}}]], 
   Polygon3DBox[
    NCache[{{16, 9, Rational[29, 5]}, {17, 9, Rational[197, 25]}, {
      17, 10, Rational[196, 25]}}, {{16, 9, 5.8}, {17, 9, 7.88}, {
      17, 10, 7.84}}]], 
   Polygon3DBox[
    NCache[{{16, 10, Rational[144, 25]}, {16, 11, Rational[29, 5]}, {
      17, 11, Rational[197, 25]}}, {{16, 10, 5.76}, {16, 11, 5.8}, {
      17, 11, 7.88}}]], 
   Polygon3DBox[
    NCache[{{16, 10, Rational[144, 25]}, {17, 10, Rational[196, 25]}, {
      17, 11, Rational[197, 25]}}, {{16, 10, 5.76}, {17, 10, 7.84}, {
      17, 11, 7.88}}]], 
   Polygon3DBox[
    NCache[{{16, 11, Rational[29, 5]}, {16, 12, Rational[148, 25]}, {17, 12, 
      8}}, {{16, 11, 5.8}, {16, 12, 5.92}, {17, 12, 8}}]], 
   Polygon3DBox[
    NCache[{{16, 11, Rational[29, 5]}, {17, 11, Rational[197, 25]}, {17, 12, 
      8}}, {{16, 11, 5.8}, {17, 11, 7.88}, {17, 12, 8}}]], 
   Polygon3DBox[
    NCache[{{16, 12, Rational[148, 25]}, {16, 13, Rational[153, 25]}, {
      17, 13, Rational[41, 5]}}, {{16, 12, 5.92}, {16, 13, 6.12}, {
      17, 13, 8.2}}]], 
   Polygon3DBox[
    NCache[{{16, 12, Rational[148, 25]}, {17, 12, 8}, {
      17, 13, Rational[41, 5]}}, {{16, 12, 5.92}, {17, 12, 8}, {
      17, 13, 8.2}}]], 
   Polygon3DBox[
    NCache[{{16, 13, Rational[153, 25]}, {16, 14, Rational[32, 5]}, {
      17, 14, Rational[212, 25]}}, {{16, 13, 6.12}, {16, 14, 6.4}, {
      17, 14, 8.48}}]], 
   Polygon3DBox[
    NCache[{{16, 13, Rational[153, 25]}, {17, 13, Rational[41, 5]}, {
      17, 14, Rational[212, 25]}}, {{16, 13, 6.12}, {17, 13, 8.2}, {
      17, 14, 8.48}}]], 
   Polygon3DBox[
    NCache[{{16, 14, Rational[32, 5]}, {16, 15, Rational[169, 25]}, {
      17, 15, Rational[221, 25]}}, {{16, 14, 6.4}, {16, 15, 6.76}, {
      17, 15, 8.84}}]], 
   Polygon3DBox[
    NCache[{{16, 14, Rational[32, 5]}, {17, 14, Rational[212, 25]}, {
      17, 15, Rational[221, 25]}}, {{16, 14, 6.4}, {17, 14, 8.48}, {
      17, 15, 8.84}}]], 
   Polygon3DBox[
    NCache[{{16, 15, Rational[169, 25]}, {16, 16, Rational[36, 5]}, {
      17, 16, Rational[232, 25]}}, {{16, 15, 6.76}, {16, 16, 7.2}, {
      17, 16, 9.28}}]], 
   Polygon3DBox[
    NCache[{{16, 15, Rational[169, 25]}, {17, 15, Rational[221, 25]}, {
      17, 16, Rational[232, 25]}}, {{16, 15, 6.76}, {17, 15, 8.84}, {
      17, 16, 9.28}}]], 
   Polygon3DBox[
    NCache[{{16, 16, Rational[36, 5]}, {16, 17, Rational[193, 25]}, {
      17, 17, Rational[49, 5]}}, {{16, 16, 7.2}, {16, 17, 7.72}, {
      17, 17, 9.8}}]], 
   Polygon3DBox[
    NCache[{{16, 16, Rational[36, 5]}, {17, 16, Rational[232, 25]}, {
      17, 17, Rational[49, 5]}}, {{16, 16, 7.2}, {17, 16, 9.28}, {
      17, 17, 9.8}}]], 
   Polygon3DBox[
    NCache[{{16, 17, Rational[193, 25]}, {16, 18, Rational[208, 25]}, {
      17, 18, Rational[52, 5]}}, {{16, 17, 7.72}, {16, 18, 8.32}, {
      17, 18, 10.4}}]], 
   Polygon3DBox[
    NCache[{{16, 17, Rational[193, 25]}, {17, 17, Rational[49, 5]}, {
      17, 18, Rational[52, 5]}}, {{16, 17, 7.72}, {17, 17, 9.8}, {
      17, 18, 10.4}}]], 
   Polygon3DBox[
    NCache[{{16, 18, Rational[208, 25]}, {16, 19, 9}, {
      17, 19, Rational[277, 25]}}, {{16, 18, 8.32}, {16, 19, 9}, {
      17, 19, 11.08}}]], 
   Polygon3DBox[
    NCache[{{16, 18, Rational[208, 25]}, {17, 18, Rational[52, 5]}, {
      17, 19, Rational[277, 25]}}, {{16, 18, 8.32}, {17, 18, 10.4}, {
      17, 19, 11.08}}]], 
   Polygon3DBox[
    NCache[{{16, 19, 9}, {16, 20, Rational[244, 25]}, {
      17, 20, Rational[296, 25]}}, {{16, 19, 9}, {16, 20, 9.76}, {
      17, 20, 11.84}}]], 
   Polygon3DBox[
    NCache[{{16, 19, 9}, {17, 19, Rational[277, 25]}, {
      17, 20, Rational[296, 25]}}, {{16, 19, 9}, {17, 19, 11.08}, {
      17, 20, 11.84}}]], 
   Polygon3DBox[
    NCache[{{17, 1, Rational[277, 25]}, {17, 2, Rational[52, 5]}, {
      18, 2, Rational[64, 5]}}, {{17, 1, 11.08}, {17, 2, 10.4}, {
      18, 2, 12.8}}]], 
   Polygon3DBox[
    NCache[{{17, 1, Rational[277, 25]}, {18, 1, Rational[337, 25]}, {
      18, 2, Rational[64, 5]}}, {{17, 1, 11.08}, {18, 1, 13.48}, {
      18, 2, 12.8}}]], 
   Polygon3DBox[
    NCache[{{17, 2, Rational[52, 5]}, {17, 3, Rational[49, 5]}, {
      18, 3, Rational[61, 5]}}, {{17, 2, 10.4}, {17, 3, 9.8}, {
      18, 3, 12.2}}]], 
   Polygon3DBox[
    NCache[{{17, 2, Rational[52, 5]}, {18, 2, Rational[64, 5]}, {
      18, 3, Rational[61, 5]}}, {{17, 2, 10.4}, {18, 2, 12.8}, {
      18, 3, 12.2}}]], 
   Polygon3DBox[
    NCache[{{17, 3, Rational[49, 5]}, {17, 4, Rational[232, 25]}, {
      18, 4, Rational[292, 25]}}, {{17, 3, 9.8}, {17, 4, 9.28}, {
      18, 4, 11.68}}]], 
   Polygon3DBox[
    NCache[{{17, 3, Rational[49, 5]}, {18, 3, Rational[61, 5]}, {
      18, 4, Rational[292, 25]}}, {{17, 3, 9.8}, {18, 3, 12.2}, {
      18, 4, 11.68}}]], 
   Polygon3DBox[
    NCache[{{17, 4, Rational[232, 25]}, {17, 5, Rational[221, 25]}, {
      18, 5, Rational[281, 25]}}, {{17, 4, 9.28}, {17, 5, 8.84}, {
      18, 5, 11.24}}]], 
   Polygon3DBox[
    NCache[{{17, 4, Rational[232, 25]}, {18, 4, Rational[292, 25]}, {
      18, 5, Rational[281, 25]}}, {{17, 4, 9.28}, {18, 4, 11.68}, {
      18, 5, 11.24}}]], 
   Polygon3DBox[
    NCache[{{17, 5, Rational[221, 25]}, {17, 6, Rational[212, 25]}, {
      18, 6, Rational[272, 25]}}, {{17, 5, 8.84}, {17, 6, 8.48}, {
      18, 6, 10.88}}]], 
   Polygon3DBox[
    NCache[{{17, 5, Rational[221, 25]}, {18, 5, Rational[281, 25]}, {
      18, 6, Rational[272, 25]}}, {{17, 5, 8.84}, {18, 5, 11.24}, {
      18, 6, 10.88}}]], 
   Polygon3DBox[
    NCache[{{17, 6, Rational[212, 25]}, {17, 7, Rational[41, 5]}, {
      18, 7, Rational[53, 5]}}, {{17, 6, 8.48}, {17, 7, 8.2}, {
      18, 7, 10.6}}]], 
   Polygon3DBox[
    NCache[{{17, 6, Rational[212, 25]}, {18, 6, Rational[272, 25]}, {
      18, 7, Rational[53, 5]}}, {{17, 6, 8.48}, {18, 6, 10.88}, {
      18, 7, 10.6}}]], 
   Polygon3DBox[
    NCache[{{17, 7, Rational[41, 5]}, {17, 8, 8}, {
      18, 8, Rational[52, 5]}}, {{17, 7, 8.2}, {17, 8, 8}, {18, 8, 10.4}}]], 
   Polygon3DBox[
    NCache[{{17, 7, Rational[41, 5]}, {18, 7, Rational[53, 5]}, {
      18, 8, Rational[52, 5]}}, {{17, 7, 8.2}, {18, 7, 10.6}, {
      18, 8, 10.4}}]], 
   Polygon3DBox[
    NCache[{{17, 8, 8}, {17, 9, Rational[197, 25]}, {
      18, 9, Rational[257, 25]}}, {{17, 8, 8}, {17, 9, 7.88}, {
      18, 9, 10.28}}]], 
   Polygon3DBox[
    NCache[{{17, 8, 8}, {18, 8, Rational[52, 5]}, {
      18, 9, Rational[257, 25]}}, {{17, 8, 8}, {18, 8, 10.4}, {
      18, 9, 10.28}}]], 
   Polygon3DBox[
    NCache[{{17, 9, Rational[197, 25]}, {17, 10, Rational[196, 25]}, {
      18, 10, Rational[256, 25]}}, {{17, 9, 7.88}, {17, 10, 7.84}, {
      18, 10, 10.24}}]], 
   Polygon3DBox[
    NCache[{{17, 9, Rational[197, 25]}, {18, 9, Rational[257, 25]}, {
      18, 10, Rational[256, 25]}}, {{17, 9, 7.88}, {18, 9, 10.28}, {
      18, 10, 10.24}}]], 
   Polygon3DBox[
    NCache[{{17, 10, Rational[196, 25]}, {17, 11, Rational[197, 25]}, {
      18, 11, Rational[257, 25]}}, {{17, 10, 7.84}, {17, 11, 7.88}, {
      18, 11, 10.28}}]], 
   Polygon3DBox[
    NCache[{{17, 10, Rational[196, 25]}, {18, 10, Rational[256, 25]}, {
      18, 11, Rational[257, 25]}}, {{17, 10, 7.84}, {18, 10, 10.24}, {
      18, 11, 10.28}}]], 
   Polygon3DBox[
    NCache[{{17, 11, Rational[197, 25]}, {17, 12, 8}, {
      18, 12, Rational[52, 5]}}, {{17, 11, 7.88}, {17, 12, 8}, {
      18, 12, 10.4}}]], 
   Polygon3DBox[
    NCache[{{17, 11, Rational[197, 25]}, {18, 11, Rational[257, 25]}, {
      18, 12, Rational[52, 5]}}, {{17, 11, 7.88}, {18, 11, 10.28}, {
      18, 12, 10.4}}]], 
   Polygon3DBox[
    NCache[{{17, 12, 8}, {17, 13, Rational[41, 5]}, {
      18, 13, Rational[53, 5]}}, {{17, 12, 8}, {17, 13, 8.2}, {
      18, 13, 10.6}}]], 
   Polygon3DBox[
    NCache[{{17, 12, 8}, {18, 12, Rational[52, 5]}, {
      18, 13, Rational[53, 5]}}, {{17, 12, 8}, {18, 12, 10.4}, {
      18, 13, 10.6}}]], 
   Polygon3DBox[
    NCache[{{17, 13, Rational[41, 5]}, {17, 14, Rational[212, 25]}, {
      18, 14, Rational[272, 25]}}, {{17, 13, 8.2}, {17, 14, 8.48}, {
      18, 14, 10.88}}]], 
   Polygon3DBox[
    NCache[{{17, 13, Rational[41, 5]}, {18, 13, Rational[53, 5]}, {
      18, 14, Rational[272, 25]}}, {{17, 13, 8.2}, {18, 13, 10.6}, {
      18, 14, 10.88}}]], 
   Polygon3DBox[
    NCache[{{17, 14, Rational[212, 25]}, {17, 15, Rational[221, 25]}, {
      18, 15, Rational[281, 25]}}, {{17, 14, 8.48}, {17, 15, 8.84}, {
      18, 15, 11.24}}]], 
   Polygon3DBox[
    NCache[{{17, 14, Rational[212, 25]}, {18, 14, Rational[272, 25]}, {
      18, 15, Rational[281, 25]}}, {{17, 14, 8.48}, {18, 14, 10.88}, {
      18, 15, 11.24}}]], 
   Polygon3DBox[
    NCache[{{17, 15, Rational[221, 25]}, {17, 16, Rational[232, 25]}, {
      18, 16, Rational[292, 25]}}, {{17, 15, 8.84}, {17, 16, 9.28}, {
      18, 16, 11.68}}]], 
   Polygon3DBox[
    NCache[{{17, 15, Rational[221, 25]}, {18, 15, Rational[281, 25]}, {
      18, 16, Rational[292, 25]}}, {{17, 15, 8.84}, {18, 15, 11.24}, {
      18, 16, 11.68}}]], 
   Polygon3DBox[
    NCache[{{17, 16, Rational[232, 25]}, {17, 17, Rational[49, 5]}, {
      18, 17, Rational[61, 5]}}, {{17, 16, 9.28}, {17, 17, 9.8}, {
      18, 17, 12.2}}]], 
   Polygon3DBox[
    NCache[{{17, 16, Rational[232, 25]}, {18, 16, Rational[292, 25]}, {
      18, 17, Rational[61, 5]}}, {{17, 16, 9.28}, {18, 16, 11.68}, {
      18, 17, 12.2}}]], 
   Polygon3DBox[
    NCache[{{17, 17, Rational[49, 5]}, {17, 18, Rational[52, 5]}, {
      18, 18, Rational[64, 5]}}, {{17, 17, 9.8}, {17, 18, 10.4}, {
      18, 18, 12.8}}]], 
   Polygon3DBox[
    NCache[{{17, 17, Rational[49, 5]}, {18, 17, Rational[61, 5]}, {
      18, 18, Rational[64, 5]}}, {{17, 17, 9.8}, {18, 17, 12.2}, {
      18, 18, 12.8}}]], 
   Polygon3DBox[
    NCache[{{17, 18, Rational[52, 5]}, {17, 19, Rational[277, 25]}, {
      18, 19, Rational[337, 25]}}, {{17, 18, 10.4}, {17, 19, 11.08}, {
      18, 19, 13.48}}]], 
   Polygon3DBox[
    NCache[{{17, 18, Rational[52, 5]}, {18, 18, Rational[64, 5]}, {
      18, 19, Rational[337, 25]}}, {{17, 18, 10.4}, {18, 18, 12.8}, {
      18, 19, 13.48}}]], 
   Polygon3DBox[
    NCache[{{17, 19, Rational[277, 25]}, {17, 20, Rational[296, 25]}, {
      18, 20, Rational[356, 25]}}, {{17, 19, 11.08}, {17, 20, 11.84}, {
      18, 20, 14.24}}]], 
   Polygon3DBox[
    NCache[{{17, 19, Rational[277, 25]}, {18, 19, Rational[337, 25]}, {
      18, 20, Rational[356, 25]}}, {{17, 19, 11.08}, {18, 19, 13.48}, {
      18, 20, 14.24}}]], 
   Polygon3DBox[
    NCache[{{18, 1, Rational[337, 25]}, {18, 2, Rational[64, 5]}, {
      19, 2, Rational[388, 25]}}, {{18, 1, 13.48}, {18, 2, 12.8}, {
      19, 2, 15.52}}]], 
   Polygon3DBox[
    NCache[{{18, 1, Rational[337, 25]}, {19, 1, Rational[81, 5]}, {
      19, 2, Rational[388, 25]}}, {{18, 1, 13.48}, {19, 1, 16.2}, {
      19, 2, 15.52}}]], 
   Polygon3DBox[
    NCache[{{18, 2, Rational[64, 5]}, {18, 3, Rational[61, 5]}, {
      19, 3, Rational[373, 25]}}, {{18, 2, 12.8}, {18, 3, 12.2}, {
      19, 3, 14.92}}]], 
   Polygon3DBox[
    NCache[{{18, 2, Rational[64, 5]}, {19, 2, Rational[388, 25]}, {
      19, 3, Rational[373, 25]}}, {{18, 2, 12.8}, {19, 2, 15.52}, {
      19, 3, 14.92}}]], 
   Polygon3DBox[
    NCache[{{18, 3, Rational[61, 5]}, {18, 4, Rational[292, 25]}, {
      19, 4, Rational[72, 5]}}, {{18, 3, 12.2}, {18, 4, 11.68}, {
      19, 4, 14.4}}]], 
   Polygon3DBox[
    NCache[{{18, 3, Rational[61, 5]}, {19, 3, Rational[373, 25]}, {
      19, 4, Rational[72, 5]}}, {{18, 3, 12.2}, {19, 3, 14.92}, {
      19, 4, 14.4}}]], 
   Polygon3DBox[
    NCache[{{18, 4, Rational[292, 25]}, {18, 5, Rational[281, 25]}, {
      19, 5, Rational[349, 25]}}, {{18, 4, 11.68}, {18, 5, 11.24}, {
      19, 5, 13.96}}]], 
   Polygon3DBox[
    NCache[{{18, 4, Rational[292, 25]}, {19, 4, Rational[72, 5]}, {
      19, 5, Rational[349, 25]}}, {{18, 4, 11.68}, {19, 4, 14.4}, {
      19, 5, 13.96}}]], 
   Polygon3DBox[
    NCache[{{18, 5, Rational[281, 25]}, {18, 6, Rational[272, 25]}, {
      19, 6, Rational[68, 5]}}, {{18, 5, 11.24}, {18, 6, 10.88}, {
      19, 6, 13.6}}]], 
   Polygon3DBox[
    NCache[{{18, 5, Rational[281, 25]}, {19, 5, Rational[349, 25]}, {
      19, 6, Rational[68, 5]}}, {{18, 5, 11.24}, {19, 5, 13.96}, {
      19, 6, 13.6}}]], 
   Polygon3DBox[
    NCache[{{18, 6, Rational[272, 25]}, {18, 7, Rational[53, 5]}, {
      19, 7, Rational[333, 25]}}, {{18, 6, 10.88}, {18, 7, 10.6}, {
      19, 7, 13.32}}]], 
   Polygon3DBox[
    NCache[{{18, 6, Rational[272, 25]}, {19, 6, Rational[68, 5]}, {
      19, 7, Rational[333, 25]}}, {{18, 6, 10.88}, {19, 6, 13.6}, {
      19, 7, 13.32}}]], 
   Polygon3DBox[
    NCache[{{18, 7, Rational[53, 5]}, {18, 8, Rational[52, 5]}, {
      19, 8, Rational[328, 25]}}, {{18, 7, 10.6}, {18, 8, 10.4}, {
      19, 8, 13.12}}]], 
   Polygon3DBox[
    NCache[{{18, 7, Rational[53, 5]}, {19, 7, Rational[333, 25]}, {
      19, 8, Rational[328, 25]}}, {{18, 7, 10.6}, {19, 7, 13.32}, {
      19, 8, 13.12}}]], 
   Polygon3DBox[
    NCache[{{18, 8, Rational[52, 5]}, {18, 9, Rational[257, 25]}, {19, 9, 
      13}}, {{18, 8, 10.4}, {18, 9, 10.28}, {19, 9, 13}}]], 
   Polygon3DBox[
    NCache[{{18, 8, Rational[52, 5]}, {19, 8, Rational[328, 25]}, {19, 9, 
      13}}, {{18, 8, 10.4}, {19, 8, 13.12}, {19, 9, 13}}]], 
   Polygon3DBox[
    NCache[{{18, 9, Rational[257, 25]}, {18, 10, Rational[256, 25]}, {
      19, 10, Rational[324, 25]}}, {{18, 9, 10.28}, {18, 10, 10.24}, {
      19, 10, 12.96}}]], 
   Polygon3DBox[
    NCache[{{18, 9, Rational[257, 25]}, {19, 9, 13}, {
      19, 10, Rational[324, 25]}}, {{18, 9, 10.28}, {19, 9, 13}, {
      19, 10, 12.96}}]], 
   Polygon3DBox[
    NCache[{{18, 10, Rational[256, 25]}, {18, 11, Rational[257, 25]}, {19, 11,
       13}}, {{18, 10, 10.24}, {18, 11, 10.28}, {19, 11, 13}}]], 
   Polygon3DBox[
    NCache[{{18, 10, Rational[256, 25]}, {19, 10, Rational[324, 25]}, {19, 11,
       13}}, {{18, 10, 10.24}, {19, 10, 12.96}, {19, 11, 13}}]], 
   Polygon3DBox[
    NCache[{{18, 11, Rational[257, 25]}, {18, 12, Rational[52, 5]}, {
      19, 12, Rational[328, 25]}}, {{18, 11, 10.28}, {18, 12, 10.4}, {
      19, 12, 13.12}}]], 
   Polygon3DBox[
    NCache[{{18, 11, Rational[257, 25]}, {19, 11, 13}, {
      19, 12, Rational[328, 25]}}, {{18, 11, 10.28}, {19, 11, 13}, {
      19, 12, 13.12}}]], 
   Polygon3DBox[
    NCache[{{18, 12, Rational[52, 5]}, {18, 13, Rational[53, 5]}, {
      19, 13, Rational[333, 25]}}, {{18, 12, 10.4}, {18, 13, 10.6}, {
      19, 13, 13.32}}]], 
   Polygon3DBox[
    NCache[{{18, 12, Rational[52, 5]}, {19, 12, Rational[328, 25]}, {
      19, 13, Rational[333, 25]}}, {{18, 12, 10.4}, {19, 12, 13.12}, {
      19, 13, 13.32}}]], 
   Polygon3DBox[
    NCache[{{18, 13, Rational[53, 5]}, {18, 14, Rational[272, 25]}, {
      19, 14, Rational[68, 5]}}, {{18, 13, 10.6}, {18, 14, 10.88}, {
      19, 14, 13.6}}]], 
   Polygon3DBox[
    NCache[{{18, 13, Rational[53, 5]}, {19, 13, Rational[333, 25]}, {
      19, 14, Rational[68, 5]}}, {{18, 13, 10.6}, {19, 13, 13.32}, {
      19, 14, 13.6}}]], 
   Polygon3DBox[
    NCache[{{18, 14, Rational[272, 25]}, {18, 15, Rational[281, 25]}, {
      19, 15, Rational[349, 25]}}, {{18, 14, 10.88}, {18, 15, 11.24}, {
      19, 15, 13.96}}]], 
   Polygon3DBox[
    NCache[{{18, 14, Rational[272, 25]}, {19, 14, Rational[68, 5]}, {
      19, 15, Rational[349, 25]}}, {{18, 14, 10.88}, {19, 14, 13.6}, {
      19, 15, 13.96}}]], 
   Polygon3DBox[
    NCache[{{18, 15, Rational[281, 25]}, {18, 16, Rational[292, 25]}, {
      19, 16, Rational[72, 5]}}, {{18, 15, 11.24}, {18, 16, 11.68}, {
      19, 16, 14.4}}]], 
   Polygon3DBox[
    NCache[{{18, 15, Rational[281, 25]}, {19, 15, Rational[349, 25]}, {
      19, 16, Rational[72, 5]}}, {{18, 15, 11.24}, {19, 15, 13.96}, {
      19, 16, 14.4}}]], 
   Polygon3DBox[
    NCache[{{18, 16, Rational[292, 25]}, {18, 17, Rational[61, 5]}, {
      19, 17, Rational[373, 25]}}, {{18, 16, 11.68}, {18, 17, 12.2}, {
      19, 17, 14.92}}]], 
   Polygon3DBox[
    NCache[{{18, 16, Rational[292, 25]}, {19, 16, Rational[72, 5]}, {
      19, 17, Rational[373, 25]}}, {{18, 16, 11.68}, {19, 16, 14.4}, {
      19, 17, 14.92}}]], 
   Polygon3DBox[
    NCache[{{18, 17, Rational[61, 5]}, {18, 18, Rational[64, 5]}, {
      19, 18, Rational[388, 25]}}, {{18, 17, 12.2}, {18, 18, 12.8}, {
      19, 18, 15.52}}]], 
   Polygon3DBox[
    NCache[{{18, 17, Rational[61, 5]}, {19, 17, Rational[373, 25]}, {
      19, 18, Rational[388, 25]}}, {{18, 17, 12.2}, {19, 17, 14.92}, {
      19, 18, 15.52}}]], 
   Polygon3DBox[
    NCache[{{18, 18, Rational[64, 5]}, {18, 19, Rational[337, 25]}, {
      19, 19, Rational[81, 5]}}, {{18, 18, 12.8}, {18, 19, 13.48}, {
      19, 19, 16.2}}]], 
   Polygon3DBox[
    NCache[{{18, 18, Rational[64, 5]}, {19, 18, Rational[388, 25]}, {
      19, 19, Rational[81, 5]}}, {{18, 18, 12.8}, {19, 18, 15.52}, {
      19, 19, 16.2}}]], 
   Polygon3DBox[
    NCache[{{18, 19, Rational[337, 25]}, {18, 20, Rational[356, 25]}, {
      19, 20, Rational[424, 25]}}, {{18, 19, 13.48}, {18, 20, 14.24}, {
      19, 20, 16.96}}]], 
   Polygon3DBox[
    NCache[{{18, 19, Rational[337, 25]}, {19, 19, Rational[81, 5]}, {
      19, 20, Rational[424, 25]}}, {{18, 19, 13.48}, {19, 19, 16.2}, {
      19, 20, 16.96}}]], 
   Polygon3DBox[
    NCache[{{19, 1, Rational[81, 5]}, {19, 2, Rational[388, 25]}, {
      20, 2, Rational[464, 25]}}, {{19, 1, 16.2}, {19, 2, 15.52}, {
      20, 2, 18.56}}]], 
   Polygon3DBox[
    NCache[{{19, 1, Rational[81, 5]}, {20, 1, Rational[481, 25]}, {
      20, 2, Rational[464, 25]}}, {{19, 1, 16.2}, {20, 1, 19.24}, {
      20, 2, 18.56}}]], 
   Polygon3DBox[
    NCache[{{19, 2, Rational[388, 25]}, {19, 3, Rational[373, 25]}, {
      20, 3, Rational[449, 25]}}, {{19, 2, 15.52}, {19, 3, 14.92}, {
      20, 3, 17.96}}]], 
   Polygon3DBox[
    NCache[{{19, 2, Rational[388, 25]}, {20, 2, Rational[464, 25]}, {
      20, 3, Rational[449, 25]}}, {{19, 2, 15.52}, {20, 2, 18.56}, {
      20, 3, 17.96}}]], 
   Polygon3DBox[
    NCache[{{19, 3, Rational[373, 25]}, {19, 4, Rational[72, 5]}, {
      20, 4, Rational[436, 25]}}, {{19, 3, 14.92}, {19, 4, 14.4}, {
      20, 4, 17.44}}]], 
   Polygon3DBox[
    NCache[{{19, 3, Rational[373, 25]}, {20, 3, Rational[449, 25]}, {
      20, 4, Rational[436, 25]}}, {{19, 3, 14.92}, {20, 3, 17.96}, {
      20, 4, 17.44}}]], 
   Polygon3DBox[
    NCache[{{19, 4, Rational[72, 5]}, {19, 5, Rational[349, 25]}, {20, 5, 
      17}}, {{19, 4, 14.4}, {19, 5, 13.96}, {20, 5, 17}}]], 
   Polygon3DBox[
    NCache[{{19, 4, Rational[72, 5]}, {20, 4, Rational[436, 25]}, {20, 5, 
      17}}, {{19, 4, 14.4}, {20, 4, 17.44}, {20, 5, 17}}]], 
   Polygon3DBox[
    NCache[{{19, 5, Rational[349, 25]}, {19, 6, Rational[68, 5]}, {
      20, 6, Rational[416, 25]}}, {{19, 5, 13.96}, {19, 6, 13.6}, {
      20, 6, 16.64}}]], 
   Polygon3DBox[
    NCache[{{19, 5, Rational[349, 25]}, {20, 5, 17}, {
      20, 6, Rational[416, 25]}}, {{19, 5, 13.96}, {20, 5, 17}, {
      20, 6, 16.64}}]], 
   Polygon3DBox[
    NCache[{{19, 6, Rational[68, 5]}, {19, 7, Rational[333, 25]}, {
      20, 7, Rational[409, 25]}}, {{19, 6, 13.6}, {19, 7, 13.32}, {
      20, 7, 16.36}}]], 
   Polygon3DBox[
    NCache[{{19, 6, Rational[68, 5]}, {20, 6, Rational[416, 25]}, {
      20, 7, Rational[409, 25]}}, {{19, 6, 13.6}, {20, 6, 16.64}, {
      20, 7, 16.36}}]], 
   Polygon3DBox[
    NCache[{{19, 7, Rational[333, 25]}, {19, 8, Rational[328, 25]}, {
      20, 8, Rational[404, 25]}}, {{19, 7, 13.32}, {19, 8, 13.12}, {
      20, 8, 16.16}}]], 
   Polygon3DBox[
    NCache[{{19, 7, Rational[333, 25]}, {20, 7, Rational[409, 25]}, {
      20, 8, Rational[404, 25]}}, {{19, 7, 13.32}, {20, 7, 16.36}, {
      20, 8, 16.16}}]], 
   Polygon3DBox[
    NCache[{{19, 8, Rational[328, 25]}, {19, 9, 13}, {
      20, 9, Rational[401, 25]}}, {{19, 8, 13.12}, {19, 9, 13}, {
      20, 9, 16.04}}]], 
   Polygon3DBox[
    NCache[{{19, 8, Rational[328, 25]}, {20, 8, Rational[404, 25]}, {
      20, 9, Rational[401, 25]}}, {{19, 8, 13.12}, {20, 8, 16.16}, {
      20, 9, 16.04}}]], 
   Polygon3DBox[
    NCache[{{19, 9, 13}, {19, 10, Rational[324, 25]}, {20, 10, 16}}, {{19, 9, 
      13}, {19, 10, 12.96}, {20, 10, 16}}]], 
   Polygon3DBox[
    NCache[{{19, 9, 13}, {20, 9, Rational[401, 25]}, {20, 10, 16}}, {{19, 9, 
      13}, {20, 9, 16.04}, {20, 10, 16}}]], 
   Polygon3DBox[
    NCache[{{19, 10, Rational[324, 25]}, {19, 11, 13}, {
      20, 11, Rational[401, 25]}}, {{19, 10, 12.96}, {19, 11, 13}, {
      20, 11, 16.04}}]], 
   Polygon3DBox[
    NCache[{{19, 10, Rational[324, 25]}, {20, 10, 16}, {
      20, 11, Rational[401, 25]}}, {{19, 10, 12.96}, {20, 10, 16}, {
      20, 11, 16.04}}]], 
   Polygon3DBox[
    NCache[{{19, 11, 13}, {19, 12, Rational[328, 25]}, {
      20, 12, Rational[404, 25]}}, {{19, 11, 13}, {19, 12, 13.12}, {
      20, 12, 16.16}}]], 
   Polygon3DBox[
    NCache[{{19, 11, 13}, {20, 11, Rational[401, 25]}, {
      20, 12, Rational[404, 25]}}, {{19, 11, 13}, {20, 11, 16.04}, {
      20, 12, 16.16}}]], 
   Polygon3DBox[
    NCache[{{19, 12, Rational[328, 25]}, {19, 13, Rational[333, 25]}, {
      20, 13, Rational[409, 25]}}, {{19, 12, 13.12}, {19, 13, 13.32}, {
      20, 13, 16.36}}]], 
   Polygon3DBox[
    NCache[{{19, 12, Rational[328, 25]}, {20, 12, Rational[404, 25]}, {
      20, 13, Rational[409, 25]}}, {{19, 12, 13.12}, {20, 12, 16.16}, {
      20, 13, 16.36}}]], 
   Polygon3DBox[
    NCache[{{19, 13, Rational[333, 25]}, {19, 14, Rational[68, 5]}, {
      20, 14, Rational[416, 25]}}, {{19, 13, 13.32}, {19, 14, 13.6}, {
      20, 14, 16.64}}]], 
   Polygon3DBox[
    NCache[{{19, 13, Rational[333, 25]}, {20, 13, Rational[409, 25]}, {
      20, 14, Rational[416, 25]}}, {{19, 13, 13.32}, {20, 13, 16.36}, {
      20, 14, 16.64}}]], 
   Polygon3DBox[
    NCache[{{19, 14, Rational[68, 5]}, {19, 15, Rational[349, 25]}, {20, 15, 
      17}}, {{19, 14, 13.6}, {19, 15, 13.96}, {20, 15, 17}}]], 
   Polygon3DBox[
    NCache[{{19, 14, Rational[68, 5]}, {20, 14, Rational[416, 25]}, {20, 15, 
      17}}, {{19, 14, 13.6}, {20, 14, 16.64}, {20, 15, 17}}]], 
   Polygon3DBox[
    NCache[{{19, 15, Rational[349, 25]}, {19, 16, Rational[72, 5]}, {
      20, 16, Rational[436, 25]}}, {{19, 15, 13.96}, {19, 16, 14.4}, {
      20, 16, 17.44}}]], 
   Polygon3DBox[
    NCache[{{19, 15, Rational[349, 25]}, {20, 15, 17}, {
      20, 16, Rational[436, 25]}}, {{19, 15, 13.96}, {20, 15, 17}, {
      20, 16, 17.44}}]], 
   Polygon3DBox[
    NCache[{{19, 16, Rational[72, 5]}, {19, 17, Rational[373, 25]}, {
      20, 17, Rational[449, 25]}}, {{19, 16, 14.4}, {19, 17, 14.92}, {
      20, 17, 17.96}}]], 
   Polygon3DBox[
    NCache[{{19, 16, Rational[72, 5]}, {20, 16, Rational[436, 25]}, {
      20, 17, Rational[449, 25]}}, {{19, 16, 14.4}, {20, 16, 17.44}, {
      20, 17, 17.96}}]], 
   Polygon3DBox[
    NCache[{{19, 17, Rational[373, 25]}, {19, 18, Rational[388, 25]}, {
      20, 18, Rational[464, 25]}}, {{19, 17, 14.92}, {19, 18, 15.52}, {
      20, 18, 18.56}}]], 
   Polygon3DBox[
    NCache[{{19, 17, Rational[373, 25]}, {20, 17, Rational[449, 25]}, {
      20, 18, Rational[464, 25]}}, {{19, 17, 14.92}, {20, 17, 17.96}, {
      20, 18, 18.56}}]], 
   Polygon3DBox[
    NCache[{{19, 18, Rational[388, 25]}, {19, 19, Rational[81, 5]}, {
      20, 19, Rational[481, 25]}}, {{19, 18, 15.52}, {19, 19, 16.2}, {
      20, 19, 19.24}}]], 
   Polygon3DBox[
    NCache[{{19, 18, Rational[388, 25]}, {20, 18, Rational[464, 25]}, {
      20, 19, Rational[481, 25]}}, {{19, 18, 15.52}, {20, 18, 18.56}, {
      20, 19, 19.24}}]], 
   Polygon3DBox[
    NCache[{{19, 19, Rational[81, 5]}, {19, 20, Rational[424, 25]}, {20, 20, 
      20}}, {{19, 19, 16.2}, {19, 20, 16.96}, {20, 20, 20}}]], 
   Polygon3DBox[
    NCache[{{19, 19, Rational[81, 5]}, {20, 19, Rational[481, 25]}, {20, 20, 
      20}}, {{19, 19, 16.2}, {20, 19, 19.24}, {20, 20, 20}}]]},
  Boxed->False,
  ImageSize->{446.6666666666667, 411.90752104898445`},
  Lighting->"Neutral",
  ViewCenter->{{0.5, 0.5, 0.5}, {0.5, 0.42164890409776556`}},
  ViewPoint->{-1.2119450889530468`, 2.6867465074110495`, -1.6621017737422474`},
  ViewVertical->{-0.18955013192639394`, 
   0.3161344599672193, -2.944106804315363}]], "Output",
 CellChangeTimes->{{3.5646787673921013`*^9, 3.5646788107445774`*^9}, 
   3.5646788478726425`*^9, 3.564678888916315*^9, {3.5646789402716045`*^9, 
   3.5646789631880455`*^9}, 3.5646790022037134`*^9, 3.5847209625155764`*^9, 
   3.584721412248207*^9, 3.5847214711082897`*^9, 3.584968952319186*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{953, 630},
WindowMargins->{{Automatic, 23}, {52, Automatic}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (October 6, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 691, 12, 107, "Subtitle"],
Cell[1273, 36, 423, 9, 86, "Subsubtitle"],
Cell[CellGroupData[{
Cell[1721, 49, 6395, 152, 732, "Input"],
Cell[8119, 203, 121976, 2651, 427, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
